<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'uk', version '4.3'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Додавання зустрічі';
$string['addingappointments'] = 'Додавання зустрічей';
$string['addremoveattendees'] = 'Додати/видалити учасників';
$string['addsession'] = 'Додати сеанс';
$string['addtimeframe'] = 'Додайте часові рамки';
$string['advanced'] = 'Розширений';
$string['allowcancellations'] = 'Дозволити скасування';
$string['allowcancellations_help'] = 'Якщо поставлено прапорець, учасники сесії зможуть скасувати свої реєстрації';
$string['allowcancellationsdefault'] = 'Дозволити скасування за умовчанням';
$string['allowcancellationsdefault_help'] = 'Якщо поставлено прапорець, налаштування за замовчуванням під час створення нових сеансів для цієї активності дозволятиме скасування реєстрації';
$string['allowwaitlist'] = 'Дозволити список очікування';
$string['allowwaitlist_help'] = 'Коли позначено прапорець «Дозволити список очікування», учні зможуть зареєструватися на сеанс зустрічі, навіть якщо він уже заповнений.<br />

Коли учень зареєструється на сеанс, який уже заповнений, він отримає електронний лист із повідомленням про те, що його внесено до списку очікування на сеанс, і буде сповіщено, коли бронювання стане доступним.';
$string['alreadysignedup'] = 'Ви вже зареєструвалися на цю зустріч.';
$string['appointment'] = 'Призначення';
$string['appointment:addattendees'] = 'Додайте учасників до сеансу зустрічі';
$string['appointment:addinstance'] = 'Додати екземпляр';
$string['appointment:configurecancellation'] = 'Дозволити конфігурацію скасування реєстрації після додавання/редагування дії щодо зустрічі.';
$string['appointment:editsessions'] = 'Додавати, редагувати, копіювати та видаляти сеанси зустрічі';
$string['appointment:managecustomfields'] = 'Керуйте користувацькими полями для сеансу зустрічі.';
$string['appointment:overbook'] = 'Зареєструйтеся на повні сеанси, для яких не ввімкнено список очікування.';
$string['appointment:removeattendees'] = 'Видалити учасників із сеансу зустрічі';
$string['appointment:signup'] = 'Записатися на сеанс';
$string['appointment:takeattendance'] = 'Прийміть участь';
$string['appointment:view'] = 'Перегляд заходів та сеансів зустрічі';
$string['appointment:viewattendees'] = 'Переглянути список присутніх та учасників';
$string['appointment:viewcancellations'] = 'Переглянути скасування';
$string['appointmentactivity'] = 'Діяльність по призначенню';
$string['appointmentcustomfields'] = 'Спеціальні поля призначення';
$string['appointmentname'] = 'Назва зустрічі';
$string['appointments'] = 'Призначення';
$string['appointmentsession'] = 'Сеанс призначення';
$string['appointmentsessions'] = 'Сеанси призначення';
$string['appointmentsettings'] = 'Налаштування зустрічі';
$string['approvalreqd'] = 'Потрібне схвалення';
$string['approvalreqd_help'] = 'Якщо поставлено прапорець «Потрібне схвалення», учню знадобиться схвалення від свого керівника, щоб отримати дозвіл на відвідування сеансу зустрічі.';
$string['approve'] = 'Затвердити';
$string['attendance'] = 'Відвідуваність';
$string['attendanceinstructions'] = 'Виберіть користувачів, які відвідали сеанс:';
$string['attendedsession'] = 'Присутня на сесії';
$string['attendees'] = 'Учасники';
$string['attendeestablesummary'] = 'Люди, які планують або були присутні на цьому занятті.';
$string['availableseats'] = 'Доступних місць: {$a}';
$string['book'] = 'Книга';
$string['bookedvscapacity'] = 'Заброньовано / Ємність';
$string['bookingcancelled'] = 'Ваше бронювання скасовано.';
$string['bookingcompleted'] = 'Ваше бронювання завершено.';
$string['bookingfull'] = 'Повний';
$string['bookingopen'] = 'Відчиено';
$string['break'] = 'Перерва';
$string['break_help'] = 'Цей параметр визначає час перерви між сеансами. Встановлення значення 0 означає, що перерва не потрібна.';
$string['calendareventdescriptionbooking'] = 'Ви заброньовані на цей<a href="{$a}">сеанс зустрічі</a>.';
$string['calendareventdescriptionsession'] = 'Ви створили цей <a href="{$a}">сеанс зустрічі</a>.';
$string['calendaroptions'] = 'Параметри календаря';
$string['cancel'] = 'Скасувати';
$string['cancelbooking'] = 'Скасувати бронювання';
$string['cancellationinstrmngr'] = '# Повідомлення для менеджера';
$string['cancellationinstrmngr_help'] = 'Коли встановлено прапорець **Надіслати повідомлення менеджеру**, текст у полі **Повідомлення для менеджера** надсилається менеджеру учня з повідомленням про те, що він скасував бронювання зустрічі.';
$string['cancellationmessage'] = 'Повідомлення про скасування';
$string['cancellationmessage_help'] = 'Це повідомлення надсилається щоразу, коли користувачі скасовують своє бронювання на сеанс.';
$string['cancellations'] = 'Скасування';
$string['cancellationstablesummary'] = 'Список людей, які скасували реєстрацію на сеанс.';
$string['cancelreason'] = 'Причина скасування';
$string['cannotapproveatcapacity'] = 'Ви не можете схвалити більше учасників, оскільки цей сеанс заповнений.';
$string['cannotsignupsessioninprogress'] = 'Ви не можете зареєструватися, цей сеанс триває';
$string['cannotsignupsessionover'] = 'Ви не можете зареєструватися, цей сеанс закінчено.';
$string['capacity'] = 'Місткість';
$string['capacity_help'] = '**Місткість** — це кількість місць, доступних за сеанс.

Коли сеанс зустрічі досягає максимальної кількості, деталі сеансу не відображаються на сторінці курсу. Деталі відображатимуться сірим кольором на сторінці "Переглянути всі заняття", і учень не може зареєструватися на сеанс.
&nbsp;';
$string['closed'] = 'Зачинено';
$string['completionbooked'] = 'Учень повинен записатися на зустріч, щоб виконати цю роботу';
$string['completionbooked_help'] = 'Якщо ввімкнено, діяльність вважатиметься завершеною, якщо статус учня "Заброньовано", "Повністю відвідував" або "Частично відвідував". Якщо учень скасував участь, занесений до списку очікування або його відвідування позначено як «Не приходить», заняття не вважатиметься завершеним.';
$string['completiondetail:booked'] = 'Замовте зустріч';
$string['confirmationinstrmngr'] = '# Повідомлення для менеджера';
$string['confirmationinstrmngr_help'] = 'Якщо поставлено прапорець «Надіслати повідомлення менеджеру», текст у полі «Повідомлення для керівника» надсилається менеджеру з повідомленням про те, що співробітник зареєструвався на зустріч.';
$string['confirmationmessage'] = 'Повідомлення про підтвердження';
$string['confirmationmessage_help'] = 'Це повідомлення надсилається щоразу, коли користувачі реєструються на сеанс.';
$string['confirmcancelbooking'] = 'Підтвердити скасування';
$string['courseresetsessions'] = 'Видалити всі сеанси';
$string['courseresetsignups'] = 'Видалити всі реєстрації на сеанс';
$string['crontask'] = 'Роботи з обслуговування призначення';
$string['currentstatus'] = 'Поточний стан';
$string['customisednotifications'] = 'Індивідуальні сповіщення';
$string['date'] = 'Дата';
$string['decidelater'] = 'Вирішіть пізніше';
$string['decline'] = 'Відхилити';
$string['delete'] = 'Видалити';
$string['deleteappointmentconfirm'] = 'Ви повністю впевнені, що хочете видалити цю зустріч і всі її бронювання?';
$string['deletesession'] = 'Видалити сеанс';
$string['deletetimeframe'] = 'Видалити часові рамки';
$string['details'] = 'Деталі';
$string['duplicate'] = 'Дублікат';
$string['duplicateappointment'] = 'Дубльована зустріч';
$string['editingappointment'] = 'Редагування зустрічі';
$string['email:message'] = 'Повідомлення';
$string['email:subject'] = 'Тема';
$string['emailmanager'] = 'Надіслати повідомлення менеджеру';
$string['emailmanagercancellation'] = '# Надіслати повідомлення менеджеру';
$string['emailmanagercancellation_help'] = 'Коли встановлено прапорець «Надіслати повідомлення менеджеру», менеджеру учня буде надіслано електронний лист із повідомленням про те, що бронювання зустрічі скасовано.';
$string['emailmanagerconfirmation'] = '# Надіслати повідомлення менеджеру';
$string['emailmanagerconfirmation_help'] = 'Якщо поставлено прапорець «Надіслати повідомлення менеджеру», менеджеру учня буде надіслано електронний лист із підтвердженням, коли учень зареєструється на сеанс зустрічі.';
$string['emailmanagerreminder'] = '# Надіслати повідомлення менеджеру';
$string['emailmanagerreminder_help'] = 'Коли встановлено прапорець «Надіслати повідомлення менеджеру», менеджеру учня буде надіслано повідомлення-нагадування за кілька днів до дати початку сеансу зустрічі.';
$string['empty'] = 'Порожній';
$string['endtime'] = 'Час закінчення';
$string['entitiysession'] = 'Сесія';
$string['error:cancellationsnotallowed'] = 'Ви не можете скасувати цю реєстрацію.';
$string['error:canttakeattendanceforunstartedsession'] = 'Не можна взяти участь у сесії, яка ще не розпочалася.';
$string['error:eventoccurred'] = 'Ви не можете скасувати подію, яка вже відбулася.';
$string['error:invaliduserid'] = 'Недійсний ідентифікатор користувача';
$string['error:manageremailaddressmissing'] = 'Наразі ви не призначені для менеджера в системі. Зверніться до адміністратора сайту.';
$string['error:sessionsplitexceeds'] = 'Час розділу сеансу перевищує тривалість сеансу.';
$string['error:sessionstartafterend'] = 'Час початку сеансу пізніше, ніж час закінчення сеансу.';
$string['errorcannoteditsessions'] = 'У вас немає дозволу редагувати сеанси';
$string['errorcannotviewappointment'] = 'У вас немає дозволу на перегляд цієї зустрічі';
$string['errorcannotviewattendees'] = 'У вас немає дозволу на перегляд учасників';
$string['eventaddsession'] = 'Сесію додано';
$string['eventapproverequests'] = 'Запити на схвалення сесії';
$string['eventattendancetaken'] = 'Відвідування сесії зараховано';
$string['eventattendeesviewed'] = 'Переглянуто учасники сесії';
$string['eventcancelbooking'] = 'Бронювання сеансу скасування';
$string['eventcourseappointmentviewed'] = 'Переглянуто екземпляри призначення курсу';
$string['eventcoursemoduleviewed'] = 'Переглянуто екземпляр модуля призначення';
$string['eventdeletesession'] = 'Сеанс видалено';
$string['eventsignup'] = 'Реєстрація на сесію';
$string['eventupdatesession'] = 'Сесію оновлено';
$string['full'] = 'Дата повністю зайнята';
$string['fullfilter'] = 'Повний';
$string['goback'] = 'Повертайся';
$string['icalendarheading'] = 'Вкладення iCalendar';
$string['joinwaitlist'] = 'Приєднатися до списку очікування';
$string['location'] = 'Місцезнаходження';
$string['managecustomfields'] = 'Керуйте користувацькими полями';
$string['modulename'] = 'Запис на прийом';
$string['modulename_help'] = 'Призначення – це модуль активності для вчителів, щоб відстежувати особисту діяльність.

Це дає змогу вчителю налаштувати систему бронювання для однієї або кількох очних або класних сесій, на які студенти можуть записатися.

Цей модуль активності підходить як для сесій 1-на-1, так і для кількох сесій, таких як семінари.

Сеанси можуть мати кілька дат і часу в рамках однієї дії щодо зустрічі, і їх можна створювати масово, використовуючи часові проміжки, зазначені в конфігурації.

Діяльність дозволяє відстежувати відвідуваність.';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Призначення';
$string['multipleappointments'] = 'Кілька зустрічей';
$string['noactionableunapprovedrequests'] = 'Немає неприйнятних запитів';
$string['noremindersneedtobesent'] = 'Не потрібно надсилати нагадування.';
$string['nosignedupusers'] = 'Жоден користувач не зареєструвався для цього сеансу.';
$string['notset'] = 'Не встановлено';
$string['notsignedup'] = 'Ви не зареєстровані на цей сеанс.';
$string['partiallyfull'] = 'Частково повний';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:appointmentname'] = '[appointmentname]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:details'] = '[details]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'Адміністрація призначення';
$string['pluginname'] = 'Призначення';
$string['potentialattendees'] = 'Потенційні учасники';
$string['privacy:metadata:appointment_signups'] = 'Реєстрація користувачів у сеансах зустрічі';
$string['privacy:metadata:appointment_signups:id'] = 'Ідентифікатор реєстрації';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Час надсилання останнього нагадування';
$string['privacy:metadata:appointment_signups:sessionid'] = 'Ідентифікатор сеансу';
$string['privacy:metadata:appointment_signups_status'] = 'Статус реєстрації користувача в сеансі';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Оцінка, виставлена за відвідування сесії';
$string['privacy:metadata:appointment_signups_status:note'] = 'Зберігає причину скасованого сеансу';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'Ідентифікатор реєстрації';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Статус реєстрації, наприклад, скасовано,відхилено,повністю_присутня';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Час створення реєстрації.';
$string['privacy:metadata:userid'] = 'Ідентифікатор користувача, який отримав доступ до активності зустрічі';
$string['remindermessage'] = 'Повідомлення-нагадування';
$string['remindermessage_help'] = 'Це повідомлення надсилається за кілька днів до дати початку сеансу.';
$string['reminderperiod'] = 'За кілька днів до відправлення повідомлення';
$string['reminderperiod_help'] = 'Повідомлення з нагадуванням буде надіслано за стільки днів до початку сеансу.';
$string['requestmessage'] = 'Повідомлення із запитом';
$string['requestmessage_help'] = 'Якщо **Потрібне схвалення** увімкнено, доступний розділ **Повідомлення запиту**.

У розділі **Повідомлення запиту** відображаються повідомлення, надіслані учню та його менеджеру щодо процесу затвердження учня для відвідування сеансу призначення.

**Тема:** — це рядок теми, який відображається в електронних листах із запитом про схвалення, надісланих менеджеру та учню.

**Повідомлення:** – це текст електронної пошти, надісланий учню з повідомленням про те, що їхній запит на участь у сесії зустрічі надіслано їхньому менеджеру для затвердження.

**Примітка для менеджера:** – це текст електронної пошти, надісланий менеджеру учня з проханням отримати дозвіл на участь у сесії зустрічі.';
$string['requeststablesummary'] = 'Люди, які просили взяти участь у цьому засіданні.';
$string['room'] = 'Кімната';
$string['saveattendance'] = 'Збережіть відвідуваність';
$string['search:activity'] = 'Діяльність по призначенню';
$string['seatsavailable'] = 'Доступні місця';
$string['seatsbooked'] = 'Заброньовані місця';
$string['sessionavailability'] = 'Доступність сесії';
$string['sessiondatetime'] = 'Дата/час сеансу';
$string['sessiondescription'] = 'Опис';
$string['sessionfinished'] = 'Готово';
$string['sessionfinishtime'] = 'Час закінчення сесії';
$string['sessioninprogress'] = 'сесія триває';
$string['sessionisfull'] = 'Зараз ця сесія заповнена. Вам потрібно буде вибрати інший час або поговорити з інструктором.';
$string['sessionrequiresmanagerapproval'] = 'Щоб забронювати цей сеанс, потрібен дозвіл менеджера.';
$string['sessions'] = 'Повний опис поточної сесії.';
$string['sessionsdetailstablesummary'] = 'Повний опис поточної сесії.';
$string['sessionstartdate'] = 'Дата початку сесії';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (часовий пояс: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (часовий пояс: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Час початку сесії';
$string['setting:defaultcancellationmessagedefault'] = 'Повідомляємо, що ваше бронювання на наступну зустріч скасовано:<br><br>
***БРОНЮВАННЯ СКАСУВАНО***<br><br>
Учасник:  [firstname] [lastname]<br>
Призначення:  [appointmentname]<br><br>
Дата(и):<br>
[alldates]<br><br>
Місцезнаходження: [session:location]<br>
Місце проведення: [session:venue]<br>
Кімната: [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Скасування запису на прийом';
$string['setting:defaultconfirmationmessagedefault'] = 'Це підтверджує, що ви зараз заброньовані на таку зустріч:<br><br>
Учасник:  [firstname] [lastname]<br>
Призначення: [ім’я зустрічі]<br><br>
Дата(и):<br>
[alldates]<br><br>
Місцезнаходження:  [session:location]<br>
Місце проведення: [session:venue]<br>
Кімната: [session:room]<br><br>
***Будь ласка, приходьте за десять хвилин до початку зустрічі***<br><br>
Щоб перепланувати або скасувати бронювання<br>
Щоб повторно запланувати бронювання, вам потрібно скасувати це бронювання, а потім повторно забронювати новий сеанс.<br>
Щоб скасувати бронювання, поверніться на сторінку зустрічі, а потім виберіть «Скасувати».<br><br>
[details][reminderperiod]<br><br>
Ви отримаєте нагадування [період нагадування] робочих днів до цієї зустрічі.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Підтвердження бронювання зустрічі: [ім’я зустрічі], [час початку]-[час завершення], [дата сесії]';
$string['setting:defaultremindermessagedefault'] = 'Це нагадування, що ви заброньовані на таку зустріч:<br><br>
Учасник: [firstname] [lastname]<br>
Призначення: [appointmentname]<br><br>
Дата(и):<br>
[alldates]<br><br>
Місцезнаходження: [session:location]<br>
Місце проведення: [session:venue]<br>
Кімната: [session:room]<br><br>
***Будь ласка, приходьте за десять хвилин до початку зустрічі***<br><br>
Щоб перепланувати або скасувати бронювання<br>
Щоб повторно запланувати бронювання, вам потрібно скасувати це бронювання, а потім повторно забронювати новий сеанс.<br>
Щоб скасувати бронювання, поверніться на сторінку зустрічі, а потім виберіть «Скасувати».<br><br>
[details]';
$string['setting:defaultremindersubjectdefault'] = 'Нагадування про бронювання зустрічі: [ім’я зустрічі], [час початку]-[час завершення], [дата сесії]';
$string['setting:defaultrequestmessagedefault'] = 'Ваш запит на запис на наступну зустріч надіслано вашому менеджеру:

Учасник: [firstname] [lastname]
Призначення: [appointmentname]

Дата(и):
[alldates]

Місцезнаходження: [session:location]
Місце проведення: [session:venue]
Кімната: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Запит на бронювання зустрічі: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Повідомляємо, що зустріч, яку ви забронювали або приєдналися до списку очікування, змінилася:<br><br>
Учасник: [firstname] [lastname]<br>
Призначення: [appointmentname]<br><br>
Дата(и):<br>
[alldates]<br><br>
Місцезнаходження: [session:location]<br>
Місце проведення: [session:room][details]<br>
Кімната: [session:room]<br><br>
***Зверніть увагу, що це не підтвердження бронювання зустрічі***<br><br>
Щоб скасувати бронювання або помістити в список очікування, поверніться на сторінку зустрічі, а потім виберіть «Скасувати».<br><br>
[details]<br><br>';
$string['setting:defaultupdatesubjectdefault'] = 'Оновлення зустрічі: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'Це повідомляє, що вас додали до списку очікування для:<br><br>
Зустріч: [appointmentname]<br>
Місцезнаходження: [session:location]<br>
Учасник: [firstname] [lastname]<br><br>
***Зверніть увагу, що це не підтвердження бронювання зустрічі***<br><br>
Додавши до списку очікування, ви зареєстрували свою зацікавленість у цій зустрічі, і з вами зв’яжуться безпосередньо, коли сеанси стануть доступними.<br><br>
Щоб виключити себе зі списку очікування, поверніться до цієї зустрічі та натисніть Скасувати. Зауважте, що немає електронної пошти з підтвердженням видалення зі списку очікування.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Поради щодо списку очікування для [appointmentname]';
$string['setting:oneemailperday'] = 'Надсилайте окремий електронний лист на кожен день у подіях, які охоплюють кілька днів';
$string['setting:oneemailperday_caption'] = 'Окрема електронна адреса для кожного дня';
$string['settings'] = 'Налаштування';
$string['shortname'] = '# Коротке ім\'я';
$string['shortname_help'] = '**Коротка назва** — це опис сеансу, який відображається в календарі тренінгів, коли ввімкнено **Показувати в календарі**.';
$string['showoncalendar'] = 'Налаштування відображення календаря';
$string['showoncalendar_help'] = 'Коли вибрано **Сайт**, сеанси зустрічі відображатимуться в календарі сайту як глобальна подія. Усі користувачі сайту зможуть переглядати ці сеанси.

Коли вибрано **Курс**, усі сеанси, пов’язані із записом, відображатимуться в календарі курсу та як подія курсу в календарі на рівні сайту та будуть видимі всім користувачам, зареєстрованим на курсі.

Якщо вибрано **Немає**, сеанси активності на зустрічі відображатимуться лише як події користувача в календарі підтвердженого учасника, якщо вибрано параметр **Показувати в календарі користувача**.';
$string['sign-ups'] = 'Реєстрації';
$string['signupforthissession'] = 'Зареєструйтеся на цю зустріч';
$string['split'] = 'Автоматичне розділення';
$string['split_help'] = 'Цей параметр визначає тривалість кожного сеансу, створеного протягом періоду часу. Встановлення значення 0 виключає цю опцію.';
$string['status'] = 'Статус';
$string['status_approved'] = 'Затверджено';
$string['status_booked'] = 'Заброньовано';
$string['status_declined'] = 'Відхилено';
$string['status_fully_attended'] = 'Повністю присутні';
$string['status_no_show'] = 'Нічого показати';
$string['status_partially_attended'] = 'Частково відвідував';
$string['status_requested'] = 'Запит';
$string['status_user_cancelled'] = 'Користувач скасований';
$string['status_waitlisted'] = 'У списку очікування';
$string['suppressemail'] = 'Вимкнути сповіщення електронною поштою';
$string['suppressemail_help'] = 'Використовуйте цю опцію, якщо ви хочете без звуку додавати або видаляти користувачів із сеансу зустрічі. Якщо цей параметр увімкнено, звичайне підтвердження електронною поштою не надсилається вибраним користувачам.';
$string['takeattendance'] = 'Прийміть участь';
$string['thirdpartyemailaddress'] = 'Сторонні адреси електронної пошти';
$string['thirdpartyemailaddress_help'] = '**Адреса(и) електронної пошти третьої сторони** — це необов’язкове поле, яке використовується для вказування адреси електронної пошти третьої сторони (наприклад, зовнішнього викладача), яка потім отримуватиме повідомлення з підтвердженням щоразу, коли користувач реєструється на сеанс. Вводячи **кілька адрес електронної пошти**, розділяйте кожну адресу комою. Наприклад: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Повідомляйте третіх сторін про сеанси в списку очікування';
$string['thirdpartywaitlist_help'] = 'Якщо вибрано опцію **Повідомляти третю сторону про сеанси в списку очікування**, третя сторона(и) отримають сповіщення, коли учень зареєструється на сеанс у списку очікування. Коли

**Сповіщати третіх сторін про сеанси в списку очікування** не ввімкнено. Треті сторони отримають сповіщення лише тоді, коли користувач зареєструється (або скасовує) для запланованого сеансу.';
$string['timecancelled'] = 'Час скасовано';
$string['timeframes'] = 'Терміни';
$string['timerequested'] = 'Запитаний час';
$string['timesignedup'] = 'Час зареєструвався';
$string['timestart'] = 'Час початку';
$string['unapprovedrequests'] = 'Незатверджені запити';
$string['unknowndate'] = '(невідома дата)';
$string['unknowntime'] = '(невідомий час)';
$string['updatemessage'] = 'Оновити повідомлення';
$string['updatemessage_help'] = 'Це повідомлення надсилається щоразу, коли змінюється сеанс.';
$string['usercalentry'] = 'Показати запис у календарі користувача';
$string['usercalentry_help'] = 'Якщо цей параметр активний, він додає запис про подію користувача до календаря учасника сеансу зустрічі. Якщо це вимкнено, це запобігає відображенню повторюваної події в календарі відвідувача сеансу, де для параметрів відображення календаря встановлено значення Курс або Сайт.';
$string['usercancelledon'] = 'Користувач скасовано {$a}';
$string['usernotsignedup'] = 'Статус: не зареєстрований';
$string['usersignedup'] = 'Статус: зареєстрований';
$string['usersignedupon'] = 'Користувач зареєструвався на {$a}';
$string['userwillbewaitlisted'] = 'Наразі ця сесія заповнена. Натиснувши кнопку «Зареєструватися», ви потрапите в список очікування сеансів.';
$string['venue'] = 'Місце проведення';
$string['waitlistedmessage'] = 'Повідомлення в списку очікування';
$string['waitlistedmessage_help'] = 'Це повідомлення надсилається щоразу, коли користувачі реєструються на сеанс у списку очікування.';
