<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'uk', version '4.3'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Доступ відхилено';
$string['accounts'] = 'Облікові записи';
$string['addcategory'] = 'Додати категорію';
$string['additionalhtml'] = 'Додатковий HTML';
$string['additionalhtml_desc'] = 'Ці налаштування дозволяють вказати HTML, який потрібно додати до кожної сторінки. Ви можете встановити HTML, який буде додано в тег HEAD для сторінки, відразу після відкриття тегу BODY або безпосередньо перед закриттям тегу body. Це дозволить вам додавати спеціальні колонтитули на кожну сторінку або додати Підтримка таких служб, як Google Analytics, дуже проста, незалежно від обраної вами теми.';
$string['additionalhtml_heading'] = 'Додатковий HTML код буде додаватися до кожної сторінки.';
$string['additionalhtmlfooter'] = 'Перед закриваючим тегом BODY';
$string['additionalhtmlfooter_desc'] = 'Цей вміст буде доданий на кожну сторінку безпосередньо перед закриваючим тегом BODY.';
$string['additionalhtmlhead'] = 'Всередині HEAD';
$string['additionalhtmlhead_desc'] = 'Цей вміст буде доданий в кінець тега HEAD для кожної сторінки.';
$string['additionalhtmltopofbody'] = 'Після відкриття BODY';
$string['additionalhtmltopofbody_desc'] = 'Цей вміст буде доданий на кожну сторінку відразу після відкриваючого тега BODY.';
$string['admincategory'] = 'Категорія: {$a}';
$string['adminseesall'] = 'Адміністратори бачать все';
$string['adminseesallevents'] = 'Адміністратори бачать всі події';
$string['adminseesownevents'] = 'Адміністратори подібні іншим користувачам';
$string['advancedfeatures'] = 'Розширені функції';
$string['agedigitalconsentverification'] = 'Перевірка віку згоди';
$string['agedigitalconsentverification_desc'] = 'Вмикає перевірку цифрового віку згоди перед відображенням сторінки реєстрації для користувачів, які самостійно реєструються. Це захищає ваш сайт від реєстрації неповнолітніми без згоди батьків/опікунів. Для отримання додаткової допомоги надано <a target="_blank" href="{$a}">контактну інформацію служби підтримки</a>.';
$string['ageofdigitalconsentmap'] = 'Вік згоди';
$string['ageofdigitalconsentmap_desc'] = 'Тут можна вказати вік згоди за умовчанням і вік у будь-якій країні, де він відрізняється від стандартного. Введіть кожний вік на новий рядок у форматі: код країни, вік (розділений комою). Вік за умовчанням позначається * замість коду країни. Коди країн вказані в ISO 3166-2.';
$string['allcountrycodes'] = 'Всі коди країн';
$string['allowattachments'] = 'Дозволити вкладення';
$string['allowbeforeblock'] = 'Дозволений список буде оброблятися в першу чергу';
$string['allowbeforeblockdesc'] = 'Типово записи в списку заблокованих ІР звіряються першими. Якщо ця опція включена, то записи в списку дозволених ІР будуть оброблятися  перед списком заблокованих.';
$string['allowcategorythemes'] = 'Дозволити теми категорій';
$string['allowcohortthemes'] = 'Дозволити когортні теми';
$string['allowcoursethemes'] = 'Дозволити теми курсу';
$string['allowedemaildomains'] = 'Дозволені домени електронної пошти';
$string['allowediplist'] = 'Список дозволених ІР';
$string['allowemailaddresses'] = 'Дозволені поштові домени';
$string['allowemojipicker'] = 'Вибрати емоджі';
$string['allowframembedding'] = 'Дозволити включення фреймів';
$string['allowframembedding_help'] = 'Якщо ввімкнено, цей сайт може бути вбудований у фрейм у віддаленій системі, як рекомендовано під час використання плагіна реєстрації «Опублікувати як інструмент LTI». В іншому випадку з міркувань безпеки рекомендується залишити вбудовування фрейма вимкненим. Зауважте, що для мобільного додатка це налаштування ігнорується, а вбудовування кадрів завжди дозволено.';
$string['allowguestmymoodle'] = 'Дозволити Гостю доступ до Інформаційної панелі';
$string['allowindexing'] = 'Дозволити індексацію пошуковими системами';
$string['allowindexing_desc'] = 'Це визначає, чи дозволити пошуковим системам індексувати ваш сайт. "Скрізь" дозволить пошуковим системам здійснювати пошук всюди, включаючи сторінки входу та реєстрації, що означає, що сайти з увімкненим Force Login все ще проіндексовані. Щоб уникнути ризику спаму, пов\'язаного з можливістю пошуку на сторінці реєстрації, використовуйте "Скрізь, окрім сторінок реєстрації". "Ніде" не дасть пошуковим системам індексувати будь-яку сторінку. Зверніть увагу, що це лише тег у заголовку сайту. Пошукова система повинна зважати на тег.';
$string['allowindexingeverywhere'] = 'Скрізь';
$string['allowindexingexceptlogin'] = 'Скрізь, окрім сторінок реєстрації';
$string['allowindexingnowhere'] = 'Ніде';
$string['allowobjectembed'] = 'Дозволити теги EMBED і OBJECT';
$string['allowthemechangeonurl'] = 'Дозволити темі зміни в URL';
$string['allowuserblockhiding'] = 'Дозволити користувачам ховати блоки';
$string['allowusermailcharset'] = 'Дозволити користувачу вибирати кодування';
$string['allowuserswitchrolestheycantassign'] = 'Дозволити користувачам без права призначення ролей перемикати ролі';
$string['allowuserthemes'] = 'Дозволити теми  користувачів';
$string['alternativefullnameformat'] = 'Альтернативний формат повного імені';
$string['alternativefullnameformat_desc'] = 'Це визначає, як імена будуть показуватися для користувачів правом перегляду viewfullnames (стандартно це користувачі з роллю менеджера, викладача та асистента). Можна використовувати заповнювачі як в параметрі "Формат повного імені".';
$string['always'] = 'Завжди';
$string['appearance'] = 'Сторінки сайту';
$string['aspellpath'] = 'Шлях до aspell';
$string['authentication'] = 'Аутентифікація';
$string['authpreventaccountcreation'] = 'Запобігти створенню облікового запису при аутентифікації';
$string['authpreventaccountcreation_help'] = 'При аутентифікації зовнішнього користувача на сайті автоматично створюється його обліковий запис, якщо такого ще не існувало. Якщо ви використовуєте зовнішні бази даних, такі як LDAP, для аутентифікації користувачів, але хочете обмежити доступ до сайту тільки користувачам з існуючим обліковим  записом, то включіть цей параметр. Нові облікові записи потрібно буде створювати вручну або завантажувати через файл. Це не стосується аутентифікації через Мережу Moodle.';
$string['authsettings'] = 'Управління аутентифікацією';
$string['autolang'] = 'Автовизначення мови';
$string['autolangusercreation'] = 'Під час створення облікового запису встановити мову що використовується браузером';
$string['autologinguests'] = 'Автоматичний вхід як гість';
$string['availableto'] = 'Доступно до';
$string['availabletoanyone'] = 'Доступно кожному, хто відвідує сайт';
$string['availabletoauthenticated'] = 'Обмежено для автентифікованих користувачів';
$string['backgroundcolour'] = 'Прозорий';
$string['backup_shortname'] = 'Використовувати назву курсу в імені файлу резервної копії';
$string['backup_shortnamehelp'] = 'Назва курсу використовується як частина імені файлу резервної копії замість номера ідентифікатора.';
$string['backups'] = 'Резервні копії';
$string['badwordsconfig'] = 'Введіть через кому список неприпустимих слів.';
$string['badwordsdefault'] = 'Якщо цей список порожній, то буде використаний стандартний список з мовного пакету.';
$string['badwordslist'] = 'Список неприпустимих слів';
$string['blockediplist'] = 'Список заблокованих ІР';
$string['blockinstances'] = 'Застосувань';
$string['blockmultiple'] = 'Багаторядковий';
$string['blockprotect'] = 'Захистити від видалення';
$string['blockprotect_help'] = 'Якщо заблокувати конкретний тип блоку, то ніхто не зможе додавати або видаляти екземпляри блоків такого типу. (Можна, звичайно, відкрити знову, якщо вам потрібно відредагувати якісь примірники блоків).

В першу чергу це використовується для захисту блоків навігації і налаштувань, які дуже важко повернути назад при випадковому видаленні.';
$string['blockprotectblock'] = 'Захистити екземпляри {$a}';
$string['blockprotected'] = '{$a} екземплярів блоку захищено.';
$string['blocksettings'] = 'Управління блоками';
$string['blockunprotect'] = 'Зняти захист';
$string['blockunprotectblock'] = 'Зняти захист екземплярів {$a}';
$string['blockunprotected'] = '{$a} екземпляри блоку незахищені.';
$string['bloglevel'] = 'Видимість Блога';
$string['bookmarkadded'] = 'Закладку додано.';
$string['bookmarkalreadyexists'] = 'Ви вже маєте закладку для цієї сторінки';
$string['bookmarkdeleted'] = 'Закладку видалено';
$string['bookmarkthispage'] = 'Закласти цю сторінку';
$string['cacheapplication'] = 'Кеш програми';
$string['cacheapplicationhelp'] = 'Кешовані елементи доступні для всіх користувачів і термін їх дії визначається налаштуваннями зовнішніх діяльностей (ttl).';
$string['cachejs'] = 'Кешувати Javascript';
$string['cachejs_help'] = 'Кешування та стиснення Javascript значно підвищує продуктивності завантаження сторінок. Настійно рекомендується для робочих сайтів. Розробники, ймовірно, захочуть відключити цю функцію.';
$string['cacherequest'] = 'Кешувати запит';
$string['cacherequesthelp'] = 'Специфічний кеш користувача, який припиняється після закінчення виконання запиту. Призначений для заміни частин, де ми використовуємо статичні запам\'ятовувальні пристрої.';
$string['cachesession'] = 'Кешувати сесію';
$string['cachesessionhelp'] = 'Специфічний кеш користувача, який припиняється після закінчення сесії користувача. Застосовується для запобіганню надмірного розростання сесійних даних.';
$string['cachesettings'] = 'Налаштування кешування';
$string['cachetemplates'] = 'Кешування шаблону';
$string['cachetemplates_help'] = 'Кешування шаблону прискорить завантаження сторінки та дуже рекомендовано для використання на сайтах з реальними проектами. Для розробників може бути долучним вимкнути цю опцію.';
$string['caching'] = 'Кешування';
$string['calendar_weekend'] = 'Вихідні';
$string['calendarexportsalt'] = 'Код експорту Календаря';
$string['calendarsettings'] = 'Календар';
$string['calendartype'] = 'Тип календаря';
$string['calendartype_desc'] = 'Виберіть стандартний тип календаря для всього сайту. Це налаштування може змінити установки курсу або користувачів у їх персональних профілях.';
$string['cannotdeletemodfilter'] = 'Ви не можете вилучити \'{$a->filter}\' оскільки це частина модуля \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} не може бути вилученим.';
$string['categoryemail'] = 'Електронна пошта';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot визначено неправильно у файлі config.php. Він містить символ \'/\' в кінці, який необхідно видалити.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot визначено неправильно у файлі config.php. Вона має відповідати URL-адресі, яку ви використовуєте для доступу до цієї сторінки.';
$string['change'] = 'змінити';
$string['checkboxno'] = 'Ні';
$string['checkboxyes'] = 'Так';
$string['checkupgradepending'] = 'Удосконалити';
$string['choosefiletoedit'] = 'Виберіть файл для редагування';
$string['cleanup'] = 'Очищення';
$string['clianswerno'] = 'ні';
$string['cliansweryes'] = 'так';
$string['cliexitgraceful'] = 'Здійснюється поступовий вихід, зачекайте...';
$string['cliexitnow'] = 'Здійснюється МИТЄВИЙ вихід';
$string['cliincorrectvalueerror'] = 'Помилка, некоректне значення "{$a->value}" для "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Некоректне значення, повторіть правильно';
$string['clistatusdisabled'] = 'Статус: відключено';
$string['clistatusenabled'] = 'Статус: включено';
$string['clistatusenabledlater'] = 'Статус: режим обслуговування через інтерфейс командного рядка буде включено в {$a}';
$string['clitypevalue'] = 'тип значення';
$string['clitypevaluedefault'] = 'тип значення, натисніть Enter для використання типового значення ({$a})';
$string['cliunknowoption'] = 'Невизначені опції: {$a}. Будь ласка, використайте опцію --help.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Щоб очистити решту кешу після перемикання трафіку користувача на новий код:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

 Ви повинні виконувати ці очищення ізольовано, з перервою між командами, щоб зменшити стрибки навантаження на веб-сервер.';
$string['cliupgradedefault'] = 'Нове налаштування: {$a}';
$string['cliupgradedefaultheading'] = 'Застосовують нові налаштунки за замовчуванням';
$string['cliupgradedefaultverbose'] = 'Нове налаштування: {$a->name}, Значення за замовчуванням: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Оновлення командного рядка з {$a->oldversion} до {$a->newversion} успішно завершено.';
$string['cliupgrademaintenancenotrequired'] = 'Це оновлення НЕ призведе до режиму обслуговування для користувачів.';
$string['cliupgrademaintenancerequired'] = 'Це оновлення призведе до режиму обслуговування для користувачів.';
$string['cliupgradenoneed'] = 'Немає необхідності поновлення для встановленої версії {$}. Дякуємо, за використання!';
$string['cliupgradepending'] = 'Чекає оновлення';
$string['cliupgradesetlock'] = 'Оновлення заблоковано лише для виконання CLI.';
$string['cliupgradeunsetlock'] = 'Існуюче блокування виконання оновлення CLI видалено.';
$string['cliyesnoprompt'] = 'натисніть y (означає так) або n (означає ні)';
$string['close'] = 'Закрити';
$string['cohort_customfield'] = 'Спеціальні поля когорти';
$string['commentsperpage'] = 'Показувати коментарі посторінково';
$string['commonactivitysettings'] = 'Загальні налаштування';
$string['commonfiltersettings'] = 'Налаштування загального фільтру';
$string['commonsettings'] = 'Загальні налаштування';
$string['componentinstalled'] = 'Компонент встановлений';
$string['computedfromlogs'] = 'Вирахувано з логів від {$a}.';
$string['condifmodeditdefaults'] = 'Значення встановлені тут визначають типові установки, які будуть використовуватися при створенні вами нової діяльності. Ви також можете встановити, які параметри налаштування діяльності будуть вважатися розширеними.';
$string['confeditorhidebuttons'] = 'Виберіть кнопки, які повинні бути сховані HTML редакторі.';
$string['configallcountrycodes'] = 'Це список країн, які можуть бути вибрані, наприклад, в профілі користувача. Якщо список в countries.php порожній (типово), то буде використовуватися список з англійського мовного пакету. Це список згідно ISO 3166-1. Інакше ви можете вказати список розділених комами кодів, наприклад, \'GB, FR, ES. Якщо ви хочете додати новий нестандартний код, то вам потрібно додати також відповідну йому країну в файлі countries.php в англійському та вашому мовному пакетах.';
$string['configallowassign'] = 'Для кожної ролі в лівому стовпці виберіть, які ролі вони можуть призначити іншим.';
$string['configallowattachments'] = 'Якщо включено, то листи з сайту можуть містити файлові долучення, наприклад, відзнаки.';
$string['configallowcategorythemes'] = 'Якщо це включити, то теми оформлення сторінок (дизайни) можна застосовувати до категорій курсів. Установка буде мати ефект для всіх дочірніх категорій та курсів в цій категорії, якщо вони не мають власної теми. УВАГА: включення тем категорій може вплинути на продуктивність роботи.';
$string['configallowcohortthemes'] = 'Якщо ви ввімкнете цю функцію, то теми можуть бути встановлені на рівні когорти. Це вплине на всіх користувачів, які мають лише одну когорту або більше однієї, але з тією ж темою.';
$string['configallowcoursethemes'] = 'Якщо ввімкнено, курсам буде дозволено встановлювати власні теми. Теми курсу замінюють усі інші варіанти (теми сайту, користувача, категорії, когорти або URL-адреси).';
$string['configallowedemaildomains'] = 'Перелік доменів електронної пошти, які можуть бути розкриті в розділі "Від" вихідної пошти. За замовчуванням "Empty" буде використовуватися адреса без відповіді для всіх вихідних повідомлень електронної пошти. Використання символів підстановки дозволено, наприклад, * .example.com дозволить електронні листи, надіслані з будь-якого субдомену example.com, а не сам example.com. Для цього буде потрібно окремий запис.';
$string['configallowemailaddresses'] = 'Щоб обмежити нові адреси електронної пошти певними доменами, укажіть їх тут, розділивши пробіли. Усі інші домени буде відхилено. Щоб дозволити субдомени, додайте домен із попереднім «.». Щоб дозволити кореневий домен разом із його субдоменами, додайте домен двічі – один раз із попереднім \'.\' і один раз без напр. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Засіб вибору емодзі дає змогу користувачам вибирати емодзі, такі як смайли, для додавання до повідомлень та інших текстових областей за допомогою кнопки вибору емодзі на панелі інструментів Atto.';
$string['configallowemojipickerincompatible'] = 'Ваша поточна конфігурація бази даних не підтримує належним чином смайли. Щоб увімкнути вибір смайлів, вам знадобиться <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> оновити свою базу даних до повної підтримки Unicode </a>.';
$string['configallowguestmymoodle'] = 'Якщо ввімкнено, гості зможуть отримати доступ до інформаційної панелі. В іншому випадку гості перенаправляються на дім сайту.';
$string['configallowobjectembed'] = 'В якості стандартного заходу безпеки, звичайним користувачам не дозволяється вбудовувати у свої HTML- сторінки мультимедіа (наприклад Flash), використовуючи теги EMBED і OBJECT(хоча це може безпечно зроблено при використанні фільтру mediaplugins). Якщо Ви хочете дозволити використати ці теги, то включить цю опцію.';
$string['configallowoverride'] = 'Дозволити ролі, вказаній зліва, виключати користувачів з ролі вказаній у колонках';
$string['configallowoverride2'] = 'Для кожної ролі в лівій колонці виберіть, для яких ролей вони можуть встановити заміни. Користувачі також повинні мати можливість moodle/role:override або moodle/role:safeoverride.';
$string['configallowswitch'] = 'Для кожної ролі в лівому стовпчику виберіть, на які ролі вони можуть переходити. <br>Користувачі також повинні мати можливість moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Якщо дозволено, то тема дизайну може бути вибрана додаванням theme={themename} до URL.';
$string['configallowuserblockhiding'] = 'Чи бажаєте дозволити користувачам ховати/показувати блоки сайту? Ця можливість використовує Javascript і cookies для збереження місця кожного блоку і результат буде доступним тільки для того, хто його встановив.';
$string['configallowusermailcharset'] = 'Включаючи це, ви надаєте можливість всім користувачам вибирати кодування, яким вони будуть отримувати електронні листи.';
$string['configallowuserswitchrolestheycantassign'] = 'Типово право moodle/role:assign потрібне користувачеві для перемикання ролей. Включення цього права забезпечує цю вимогу, і результат у випадаючому меню "Перемикнути на роль..." для кожної ролі буде залежати від налаштувань в таблиці "Дозволи, які роль надає". Це важливо для того, щоб установки в таблиці "Дозволи, які роль надає" не давали можливості перемикнути на роль з правами більшими ніж власні.';
$string['configallowuserthemes'] = 'Якщо включити це, то користувачам буде дозволено застосовувати власні теми сайту. Теми користувачів відміняють теми сайту (крім тем курсів)';
$string['configallowview'] = 'Для кожної ролі в лівому стовпці виберіть ролі, які вони можуть переглядати, шукати та фільтрувати.';
$string['configallusersaresitestudents'] = 'Чи слід УСІХ користувачів вважати студентами для діяльності на головній сторінці сайту? Якщо так, то будь-хто, хто має обліковий запис, зможе брати участь у цих заходах як студент. Якщо ні, то брати участь у цих заходах зможуть лише користувачі, які вже є учасниками хоча б одного курсу. Лише адміністратори та спеціально призначені викладачі можуть виступати в якості викладачів для домашньої діяльності сайту.';
$string['configauthenticationplugins'] = 'Будь ласка, виберіть режими аутентифікації, які ви бажаєте використовувати, та встановіть їх у відповідному порядку.';
$string['configautolang'] = 'Визначити мову інтерфейсу з налаштувань браузера. Якщо відключено, то береться типова мова сайту.';
$string['configautolangusercreation'] = 'Якщо ввімкнено, коли обліковий запис користувача створюється автоматично під час першого входу (наприклад, за допомогою автентифікації LDAP або OAuth 2), мова браузера користувача встановлюється як бажана мова.';
$string['configautologinguests'] = 'Чи слід, щоб відвідувачі були автоматично зареєстровані як гості при вході до курсів з гостьовим доступом?';
$string['configbloglevel'] = 'Ця установка дозволяє вам встановити рівень, за яким будуть переглядатися записи (блоги) користувачів. Відмітьте, що це означає максимальну ширину перегляду, не емблему або тип. Записи також можуть бути взагалі відключеними.';
$string['configcalendarcustomexport'] = 'Включити специфічні діапазони дат для експорту календаря';
$string['configcalendarexportsalt'] = 'Це випадковий текст використовується для підвищення надійності аутентифікаційних символів, які використовуються для експорту календаря. Зверніть увагу, що всі нинішні символи стають недійсними, якщо ви зміните цей код.';
$string['configcookiesecure'] = 'Якщо сервер приймає лише з’єднання https, рекомендується увімкнути надсилання безпечних файлів cookie. Якщо ввімкнено, переконайтеся, що веб-сервер не приймає http://, або налаштуйте постійне переспрямування на адресу https:// і в ідеалі надсилайте заголовки HSTS. Якщо адреса <em>wwwroot</em> не починається з https://, цей параметр ігнорується.';
$string['configcountry'] = 'Якщо Ви вкажете тут країну, то вона буде підставлятися як типова для кожного нового користувача. Для вибору користувачем країни, залишіть поле не визначеним.';
$string['configcoursegraceperiodafter'] = 'Класифікуйте минулі курси як поточні протягом багатьох днів після дати закінчення курсу.';
$string['configcoursegraceperiodbefore'] = 'Класифікуйте майбутні курси як поточні за ці багато днів до дати початку курсу.';
$string['configcourseoverviewfilesext'] = 'Розділений комами список дозволених розширень файлів зображення курсу.';
$string['configcourseoverviewfileslimit'] = 'Максимальна кількість файлів для долучення в описах курсів. Перше додане зображення використовується як зображення всього курсу в основному вигляді на інформаційних панелях користувачів; будь-які додаткові файли відображаються лише на сторінці списку курсів.';
$string['configcourserequestnotify'] = 'При запиті нового курсу, вказати псевдо користувача.';
$string['configcourserequestnotify2'] = 'Користувачі, які будуть повідомлені про запит курсу. Тут наведені тільки користувачі, які можуть ухвалювати створення курсів.';
$string['configcoursesperpage'] = 'Введіть число курсів, що показуватиметься на одній сторінці в списку курсів.';
$string['configcourseswithsummarieslimit'] = 'Максимальна кількість курсів, які будуть показуватися в списку з використанням короткого опису. Після перевищення цього обмеження список буде перетворюватися в простий (без описів).';
$string['configcronclionly'] = 'Запуск cron через веб-оглядач може надати специфічну інформацію вашого сервера анонімним користувачам. Тому рекомендується запускати cron лише з командного рядка або встановити пароль на на віддалений доступ.';
$string['configcronremotepassword'] = 'Це означає, що сценарій cron.php не можна запустити з веб-браузера без введення пароля за допомогою такої форми URL-адреси: <pre>https://site.example.com/admin/cron.php?password=opensesame</pre>. Якщо це поле залишено порожнім , пароль не потрібен.';
$string['configcurlcache'] = 'Час життя для кешу cURL, в секундах.';
$string['configcustommenuitems'] = 'Тут можна налаштувати спеціальне меню. Введіть кожен пункт меню в новому рядку у форматі: текст меню, URL-адреса посилання (необов’язково, не для верхнього пункту меню з підпунктами), заголовок спливаючої підказки (необов’язково) і код мови або список кодів, розділених комами ( необов’язковий, для відображення рядка лише користувачам зазначеної мови), розділених вертикальною рискою. Рядки, які починаються з дефіса, відображатимуться як пункти меню в попередньому меню верхнього рівня, а ### робить роздільником. Наприклад:
<pre>
Курси
-Всі курси|/курс/
-Пошук курсу|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Мобільний додаток|https://example.org/app|Завантажте наш додаток
</pre>';
$string['configcustomusermenuitems'] = 'Ви можете налаштувати вміст меню користувача (за винятком посилання для виходу, яке додається автоматично). Кожен рядок розділений символами вертикальної лінії і складається з 1) рядка у формі "langstringname, componentname" або у вигляді простого тексту та 2) URL-адреси. Роздільники можна використовувати, додавши рядок із одного або більше # символів, де потрібно.';
$string['configdbsessions'] = 'Якщо дозволено, то система буде використовувати базу даних для зберігання інформації про поточні сеанси. Це особливо корисно для великих за обсягом сайтів або сайтів, які працюють за кластерною технологією. Для більшості сайтів, ймовірно, дозволяти нема потреби, бо це дуже завантажує дискову систему.

Зверніть увагу, що після зміни цього налаштування буде зроблено примусовий вихід для всіх користувачів, які зараз у системі (включаючи Вас).

Якщо Ви використовуєте MySQL, переконайтеся, що \'max_allowed_packet\' у my.cnf (або my.ini) має значення як мінімум 4M. Інші системи можуть бути налаштовані прямо в config.php (див. config-dist.php для детальнішої інформації). Ця опція відключається, якщо задати рушій сеансу у файлі config.php.';
$string['configdebug'] = 'При виборі, звітування про помилки PHP буде в повному обсязі. Ця функція корисна розробникам.';
$string['configdebugdisplay'] = 'Встановлення включеним призведе до виведення звіту про помилку на сторінку HTML. Це практично, але порушує XHTML, JS, cookies and HTTP правила. При виключенні, всі помилки будуть складатися в лог-файлах на сервері. Змінна error_log в налаштуванні РНР вказує, де буде цей файл.';
$string['configdebugpageinfo'] = 'Включіть, якщо ви хочете інформацію про роботу внизу кожної сторінки.';
$string['configdebugvalidators'] = 'Включіть, якщо ви бажаєте мати посилання на зовнішні дійсні сервери внизу сторінки. Можливо, вам доведеться створити нового користувача з ім\'ям <em> w3cvalidator </em>, і дозволить гостьовий доступ. Ці зміни можуть створити можливість несанкційованого доступу до сервера, не дозволяйте на робочих сайтах!';
$string['configdefaulthomepage'] = 'На яку сторінку слід перенаправляти користувачів після входу на сайт? Налаштування також визначає перше посилання в навігації для користувачів класичних тем.';
$string['configdefaultrequestcategory'] = 'Курси, запитані користувачами, які мають можливість запитувати нові курси в системному контексті, будуть поміщені в цю категорію, якщо користувачі не зможуть вибрати іншу категорію.';
$string['configdefaultrequestedcategory'] = 'Типова категорія, до якої поміщати курси, які отримали схвалення.';
$string['configdefaultuserroleid'] = 'Всім завантаженим користувачам будуть давати можливості тієї ролі, яку ви визначите тут, для рівня сайту, в доповнення до інших ролей, які ви можливо їм дали. Типово це роль Аутентифікований користувач (або Гість в старих версіях). Відмітимо, що це не буде конфліктувати з іншими ролями, які користувачі вже мають, це тільки надасть можливість робити щось на даному рівні сайту (наприклад, залишати записи блогу, редагувати свій календар, тощо).';
$string['configdeleteincompleteusers'] = 'Після закінчення цього періоду будь-який обліковий запис без заповненого поля імені, прізвища або електронної пошти буде видалено.';
$string['configdeleteunconfirmed'] = 'Для певних методів аутентифікації, таких як самореєстрація на основі електронної пошти, користувачі повинні підтвердити свій обліковий запис протягом певного часу. Після закінчення цього періоду всі старі непідтверджені облікові записи видаляються.';
$string['configdenyemailaddresses'] = 'Заборонити електронні адреси з перерахованих тут доменів. Всі решта доменів будуть дозволеними. Наприклад, <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Відключити можливість користувачів змінювати свої фото.';
$string['configdisplayloginfailures'] = 'Це покаже вибраним користувачам інформацію про попередні невдалі спроби входження в систему.';
$string['configdndallowtextandlinks'] = 'Включення або відключення режиму перетягування тексту та посилань на сторінці курсу поряд з перетягуванням файлів. Зверніть увагу, що перетягування тексту у Firefox або між різними браузерами ненадійне і може призвести до втрати завантажуваних даних, або їх пошкодження.';
$string['configdoclang'] = 'Ця мова буде використана в посиланнях на сторінки документації.';
$string['configdocroot'] = 'Визначає шлях до Moodle Docs для надання контекстної документації через посилання «Довідка та документація» у нижньому колонтитулі кожної сторінки. Якщо поле залишити порожнім, посилання не відображатимуться.';
$string['configdoctonewwindow'] = 'Якщо ввімкнено, посилання на Moodle Docs відображатимуться в новому вікні.';
$string['configduration_high'] = 'Це значення занадто високе. Максимальне значення – {$a}.';
$string['configduration_low'] = 'Це значення занадто низьке. Мінімальне значення – {$a}.';
$string['configeditordictionary'] = 'Ця змінна буде використана, якщо aspell не має словника для власної мови користувача.';
$string['configeditorfontlist'] = 'Оберіть шрифти, які будуть показані у списку шрифтів редактора.';
$string['configemailchangeconfirmation'] = 'Чи потрібне підтвердження по ел.пошті операції зміни користувачем адреси своєї ел.скриньки.';
$string['configemaildkimselector'] = 'Селектор DKIM є довільним, і ваші записи DNS повинні відповідати цьому.';
$string['configemailfromvia'] = 'Додати через інформацію в розділі "Від" вихідної пошти. Це повідомляє одержувача, звідки надходить ця електронна пошта, а також допомагає одержувачам боротьби випадково відповідати на електронні адреси без відповіді.';
$string['configemailheaders'] = 'Необроблені заголовки електронних листів будуть дослівно додаватися до всіх вихідних електронних листів.';
$string['configemailsubjectprefix'] = 'Текст, який має бути додано до рядка теми всієї вихідної пошти.';
$string['configenableanalytics'] = 'Аналітичні моделі, такі як \'Студенти які ризикують бути відсіяні\' або \'Майбутні обов\'язкові події\', що можуть генерувати прогнози, надсилати аналітичні повідомлення та пропонувати додаткові дії, такі як обмін повідомленнями з користувачами.';
$string['configenableblogs'] = 'Даний перемикач включає для всіх користувачів сайту можливість ведення власного блогу.';
$string['configenablecalendarexport'] = 'Дозволити експорт або розсилку календаря.';
$string['configenablecomments'] = 'Дозволити коментарі';
$string['configenablecourserequests'] = 'Якщо ввімкнено, користувачі з можливістю запитувати нові курси (moodle/course:request) матимуть можливість подати запит на курс. Ця можливість не дозволена для жодної з ролей за замовчуванням. Він може застосовуватися в контексті системи або категорії.';
$string['configenabledevicedetection'] = 'Забезпечує виявлення мобільних телефонів, смартфонів, планшетів або типових пристроїв (настільні ПК, ноутбуки і т.д.) для застосування найкращої для них функціональності.';
$string['configenablemobilewebservice'] = 'Включити мобільний сервіс для офіційних програм  Moodle або інших програм, які це потребують. Для детальної інформації читайте {$a}';
$string['configenablerssfeeds'] = 'Даний перемикач включає RSS для всього сайту. Щоб реально бачити будь-які зміни, вам необхідно включити RSS також в індивідуальних налаштуваннях - перейдіть до Модуля налаштування в конфігурації адміністратора.';
$string['configenablerssfeedsdisabled'] = 'Недоступно, тому що RSS відключено на рівні сайту. Щоб його включити, перейдіть до налаштування Змінних в конфігурації адміністратора.';
$string['configenablerssfeedsdisabled2'] = 'RSS-канали наразі вимкнено на рівні сайту. Їх можна ввімкнути в Розширених функціях в Адміністрації сайту.';
$string['configenablestats'] = 'Якщо ви тут виберете "Так", то cronjob системи опрацює логи та збере трохи статистики. В залежності від величини трафіку на вашому сайті, це може зайняти деякий час. Якщо ви дозволите це, то отримаєте деякі цікаві графіки та статистику про кожен ваш курс.';
$string['configenabletrusttext'] = 'Типово Moodle буде приймати чистий текст, який приходить від користувачів і видаляти всі можливі проблемні скрипти, медіа та інше, що складає певний ризик для системи. Довірча система - це можливість довіряти всім користувачам у введенні тексту. Щоб включити цю можливість, вам потрібно спочатку включити дану установку, а потім включити Довірчу систему у властивостях відповідної ролі. Текст, введений чи завантажений такими користувачами, буде помічатися як довірчий і не буде очищуватися перед виводом на екран.';
$string['configenablewebservices'] = 'Веб-сервіси дозволяють іншим системам, таким як додаток Moodle, входити на сайт і виконувати операції. Для додаткової безпеки це налаштування слід вимкнути, якщо ви не користуєтеся програмою або зовнішнім інструментом/сервісом, який потребує інтеграції через веб-служби.';
$string['configenablewsdocumentation'] = 'Дозволити автогенерацію документації веб-служб. Користувач веб-служби може мати доступ до власної {$a} без входження в Moodle. Це покаже документацію тільки для включених протоколів.';
$string['configerrorlevel'] = 'Виберіть рівень попереджень РНР. Нормальний звичайно є найкращим.';
$string['configexportlookahead'] = 'Кількість днів вперед для експорту';
$string['configexportlookback'] = 'Кількість днів назад для експорту';
$string['configextendedusernamechars'] = 'Якщо ввімкнено, імена користувачів можуть містити будь-які символи, крім великих літер. В іншому випадку дозволені лише буквено-цифрові символи з малими літерами, символом підкреслення (_), дефісом (-), крапкою (.) та символом (@).';
$string['configextramemorylimit'] = 'Деякі скрипти, як Пошук, Резервування або Відновлення, а також Періодичні задачі (cron), вимагають більше пам\'яті. Встановіть найбільше значення для великих сайтів.';
$string['configfilterall'] = 'Фільтрує всі рядки включно з заголовками, назвами, навігаційним блоком і т.д. Це має ефект при багатомовності, інакше просто завантажить сайт без великої користі.';
$string['configfiltermatchoneperpage'] = 'Автоматичні зв\'язуючі фільтри генеруватиме тільки єдиний зв\'язок для першого відповідного текстового зразка, який знайдено на повній сторінці. Все інше ігнорується.';
$string['configfiltermatchonepertext'] = 'Фільтри автоматичного зв’язування створять лише одне посилання для першого екземпляра відповідного тексту, знайденого в кожному елементі тексту на сторінці. Всі інші ігноруються. Це налаштування не діє, якщо ввімкнено «Фільтрувати збіг один раз на сторінку».';
$string['configfilternavigationwithsystemcontext'] = 'Звичайне використання фільтрів пов’язане з контекстом, у якому вони використовуються (наприклад, контекст курсу), але для навігації по сайту фільтрування всього за контекстом може підвищити продуктивність при використанні фільтру «вміст і заголовки».';
$string['configfilteruploadedfiles'] = 'Якщо вибрано дане встановлення, то в процесі завантаження html та текстових файлів буде проводитися попередня їх фільтрація перед виводом на екран.';
$string['configforcelogin'] = 'Зазвичай, головну сторінку сайту та списки курсів (але не курси) можуть прочитати люди, не входячи на сайт. Якщо ви хочете змусити людей увійти в систему, перш ніж вони БУДУТЬ робити на сайті, вам слід увімкнути це налаштування.';
$string['configforceloginforprofiles'] = 'Це налаштування змушує людей входити в систему як реальний (не гість) обліковий запис, перш ніж переглядати профіль будь-якого користувача. Якщо ви вимкнули це налаштування, ви можете виявити, що деякі користувачі публікують рекламу (спам) або інший невідповідний вміст у своїх профілях, який потім буде видно всьому світу.';
$string['configfrontpage'] = 'Вибрані вище елементи відображатимуться на головній сторінці сайту.';
$string['configfrontpagecourselimit'] = 'Максимальна кількість курсів';
$string['configfrontpagecourselimithelp'] = 'Максимальна кількість курсів для відображення на головній сторінці сайту в списках курсів.';
$string['configfrontpageloggedin'] = 'Вибрані вище елементи відображатимуться на головній сторінці сайту, коли користувач увійде в систему.';
$string['configfullnamedisplay'] = 'Це визначає спосіб відображення імен, коли вони відображаються повністю. Значення за замовчуванням «мова» залишає на вибір рядок «повне ім’ядисплей» у поточному мовному пакеті. Деякі мови мають різні правила відображення імен.

Для більшості одномовних сайтів найефективнішим параметром є «ім’я прізвище», але ви можете взагалі приховати прізвища. Можна використовувати такі заповнювачі: ім’я, прізвище, фонетичне ім’я, фонетичне прізвище, ім’я по батькові та альтернативне ім’я.';
$string['configgeoipfile'] = 'Розташування файлу бінарних даних GeoLite2 City. Цей файл не є частиною дистрибутива Moodle і має бути отриманий окремо від <a href="https://www.maxmind.com/">MaxMind</a>. Ви можете придбати комерційну версію або скористатися безкоштовною версією. Вам потрібно зареєструватися, щоб завантажити файл бази даних міста, що ви можете зробити за адресою <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Після реєстрації та завантаження файлу розпакуйте його в каталог "{$a}" на вашому сервері.';
$string['configgetremoteaddrconf'] = 'Якщо ваш сервер знаходиться за реверсним проксі, можете використати це налаштування для вказівок серверу, яким HTTP-заголовкам з вкладеними віддаленими IP-адресами можна довіряти. Заголовки читатимуться поки не отримається перший доступний.';
$string['configgradebookroles'] = 'Ця установка дозволяє вам контролювати, хто буде показуватися в Журналі оцінок. Користувачам потрібно мати хоча б одну з наведених ролей на курсі, щоб бути в списку Журналу оцінок цього курсу.';
$string['configgradeexport'] = 'Виберіть, які формати експорту журналу оцінок є для вас пріоритетними. Вибрані розширення будуть тоді встановлювати та використовувати "останнє експортоване" поле для кожного оцінювання. Наприклад, це може призвести до експортування записів відмічених як "нові" або "оновлені". Якщо ви не впевнені в тому, що робите, залиште все як є.';
$string['confighiddenuserfields'] = 'Вкажіть, які поля профілю користувачів будуть сховані від інших користувачів. Це буде приватною інформацією студентів. Утримування кнопки CTRL дозволить вибрати кілька варіантів.';
$string['configidnumber'] = 'Дана опція визначає: (a) Не вимагати ID-код користувача, (b) Користувача просять ввести ID-код, але він може це проігнорувати, (c) Користувача просять ввести ID-код і він зобов`язаний це зробити. Якщо вказаний ID-код, то він показується в обліковому записі користувача.';
$string['configintro'] = 'На цій сторінці Ви можете визначити велику кількість параметрів, які дозволять більш ефективно налаштувати роботу системи на Вашому сервері. Не хвилюйтеся, усі параметри мають типові значення, які гарантують нормальну роботу системи, до того ж Ви завжди можете повернутися до цієї сторінки і змінити  ці параметри.';
$string['configintroadmin'] = 'На цій сторінці вам необхідно заповнити профіль головного адміністратора, який матиме повний контроль над сайтом. Впевніться, що вказали безпечний пароль, логін та відповідний e-mail. Пізніше ви зможете додавати нових адміністраторів.';
$string['configintrosite'] = 'Ця сторінка дозволяє налаштувати домашню сторінку сайту та назву цього нового сайту. Ви можете повернутися сюди пізніше, щоб змінити ці налаштування в будь-який час за допомогою меню адміністрування.';
$string['configiplookup'] = 'Коли ви натискаєте на IP-адресу, наприклад, у журналі дій, вам буде показана карта з можливим її розташуванням на Земній кулі. Існують різні розширення цієї програми, за допомогою яких можна отримати багато цікавої інформації.';
$string['configkeeptagnamecase'] = 'Дозволити чи ні збереження регістру символів в назвах міток такими, якими їх створив автор мітки.';
$string['configlang'] = 'Виберіть типову мову для системи. В подальшому користувачі зможуть змінити її для себе.';
$string['configlanglist'] = 'Якщо залишити порожнім, усі мови, встановлені на сайті, відображатимуться в мовному меню. Як альтернатива, меню мови можна скоротити, ввівши список кодів мов, розділених комами, наприклад. en,de,fr. За бажанням можна вказати іншу назву для мови, ніж назва мовного пакета, використовуючи формат: код мови|назва мови, наприклад. en_kids|англійська,de_kids|німецька.';
$string['configlangmenu'] = 'Виберіть відображати або ні меню для вибору мови, серед тих які використовуються на сайті. Це не вплине на можливість користувача вибирати мову у своєму профілі.';
$string['configlangstringcache'] = 'Кешуються всі мовні змінні в скомпільований файл в каталозі даних. Якщо ви перекладаєте Moodle або змінюєте рядки в коді, ви можливо захочете відключити це. В іншому випадку залишіть його, щоб побачити переваги продуктивності.';
$string['configlatinexcelexport'] = 'Оберіть кодову таблицю для експорту у файл Excel.';
$string['configlocale'] = 'Оберіть мовну локаль сайту - це визначить формат і мову дат на сайті. Необхідно, щоб ця локаль була встановлена у Вашій операційній системі. (для linux uk_UA.UTF-8 ). Якщо Ви не впевнені то залиште рядок порожнім.';
$string['configlockrequestcategory'] = 'Якщо ввімкнено, користувачі, які мають можливість запитувати нові курси в системному контексті, не зможуть вибрати категорію у формі запиту на новий курс. Альтернативний спосіб обмежити користувачів запитом на новий курс лише в одній категорії — застосувати можливість запиту нових курсів у контексті категорії.';
$string['configloglifetime'] = 'Поле визначає проміжок часу, протягом якого ви бажаєте зберігати статистику про діяльність користувачів. Записи старше цього терміну, автоматично видаляються. Зазвичай логи зберігають максимально довго, але, якщо ваш сервер обмежений у дисковому просторі та матиме проблеми з роботою, бажано понизити цей параметр. Значення нижче за 30 не рекомендується, оскільки статистика може працювати не коректно.';
$string['configlookahead'] = 'Днів для наступних подій';
$string['configmailnewline'] = 'Символи нового рядку, які використовуватимуться в повідомленнях електронної пошти. CRLF вимагається відповідно до RFC 822bis, деякі поштові сервери автоматично переконвертовують з LF до CRLF, інші роблять некоректне перетворення з LF до CRLF, а деякі відкидають листи з голими LF (Qmail, наприклад). Спробуйте змінити це налаштування, якщо у вас виникли проблеми з недоставленням повідомлень або подвійним переводом рядків.';
$string['configmaxbytes'] = 'Це визначає максимальний розмір файлів, завантажених на сайт. Цей параметр обмежений параметрами PHP post_max_size і upload_max_filesize, а також параметром Apache LimitRequestBody. У свою чергу, maxbytes обмежує діапазон розмірів, які можна вибрати на рівні курсу або активності. Якщо вибрано «Обмеження завантаження сайту», використовуватиметься максимальний розмір, дозволений сервером.';
$string['configmaxconsecutiveidentchars'] = 'Пароль не повинен мати більше ніж це число послідовних однакових символів. Вкажіть 0, щоб відключити перевірку.';
$string['configmaxeditingtime'] = 'Час, протягом якого користувач може змінити повідомлення на форумі, коментарі до глосарію... Зазвичай використовується значення 30 хв.';
$string['configmaxevents'] = 'Наступних подій';
$string['configmaxusersperpage'] = 'Максимальна кількість користувачів, які будуть показуватися в списках вибору в курсах, групах, гуртах, веб-сервісах, тощо.';
$string['configmessaging'] = 'Якщо ввімкнено, користувачі можуть надсилати повідомлення іншим користувачам сайту.';
$string['configmessagingallowemailoverride'] = 'Дозволити користувачам отримувати повідомлення електронної пошти на іншу адресу, крім тієї що вказана в їх профілі.';
$string['configmessagingallusers'] = 'Якщо ввімкнено, користувачі можуть переглядати список усіх користувачів на сайті, вибираючи комусь надіслати повідомлення, а їхні налаштування повідомлень включають можливість приймати повідомлення від будь-кого на сайті. Якщо вимкнено, користувачі можуть переглядати лише список користувачів на своїх курсах, і у них є лише два варіанти в налаштуваннях повідомлень: приймати повідомлення лише від своїх контактів або їхніх контактів та будь-кого на своїх курсах.';
$string['configmessagingdefaultpressenter'] = 'Чи ввімкнено "Використовувати ввод для надсилання" за замовчуванням у налаштуваннях повідомлень користувачів.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Прочитані та непрочитані сповіщення можна видалити, щоб заощадити місце. Через який час після створення сповіщення його можна видалити?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Прочитані повідомлення можуть бути видалені для економії простору. Після якого часу потрібно видаляти прочитані повідомлення?';
$string['configminpassworddigits'] = 'Паролі повинні мати як мінімум таку кількість цифрових символів.';
$string['configminpasswordlength'] = 'Паролі повинні мати як мінімум таку кількість літерних символів.';
$string['configminpasswordlower'] = 'Паролі повинні мати як мінімум таку кількість символів нижнього регістру.';
$string['configminpasswordnonalphanum'] = 'Паролі повинні мати як мінімум таку кількість не алфавітних символів.';
$string['configminpasswordupper'] = 'Паролі повинні мати як мінімум таку кількість символів верхнього регістру.';
$string['configmycoursesperpage'] = 'Максимальна кількість курсів для показу в списку власних курсів';
$string['configmymoodleredirect'] = 'Цей параметр встановлює перенаправлення в /my користувачів, які входять як не адміністратори, і замінює верхній рівень сайту на /mу';
$string['configmypagelocked'] = 'Цей параметр дозволяє редагувати типову сторінку не адміністраторам';
$string['confignavcourselimit'] = 'Обмежує кількість курсів, які відображаються користувачеві в навігації.';
$string['confignavshowallcourses'] = 'Цей параметр визначає, чи зможуть користувачі, які зареєстровані на курсах, бачити курси (з переліком усіх курсів) на навігації, крім Мої курси (перелік курсів, на які вони зараховані).';
$string['confignavshowcategories'] = 'Показувати категорії курсів на панелі навігації та навігаційних блоках. Це не відбувається з курсами, на які користувач зараз зареєстрований; вони все одно будуть перераховані в розділі Мої курси без категорій.';
$string['confignoreplyaddress'] = 'Іноді листи можуть надсилатися від імені користувача (наприклад повідомлення з форумів). Електронна адреса вказана вами тут, буде використовуватися в полі "Від" в електронних листах, щоб користувачі могли направити персональну відповідь тому, хто опублікував повідомлення на форумі (якщо користувачі вказали, що вони хочуть отримувати приватні повідомлення).';
$string['confignotifyloginfailures'] = 'Якщо зберігаються дані про невдалі входження в систему, вони будуть відправлятися поштою. Хто повинен отримувати ці повідомлення?';
$string['confignotifyloginthreshold'] = 'Якщо зберігаються дані про невдалі входження в систему, то скільки невдалих спроб з одного логіна чи ІР-адреси повинно бути записано?';
$string['confignotloggedinroleid'] = 'Користувачі, які не зайшли на сайт під своїм ім\'ям, будуть розглядатися, як користувачі з даної групи (ролі) для всього сайту. Гість - це майже завжди найкращий варіант, але ви можете створити власну роль та надати їй необхідні права. Але такі дії, як створення повідомлень, все ще будуть вимагати нормального входження.';
$string['configopentowebcrawlers'] = 'Якщо ви включаєте цей параметр, то пошукова машина Google буде зареєстрована на вашому сайті як Гість. Крім того, люди, які прийдуть до вас через пошук Google, автоматично реєструються на вашому сайті як Гості. Це лише забезпечить простий доступ до ваших курсів, які дозволяють гостьовий доступ';
$string['configoverride'] = 'Визначено в config.php';
$string['configpasswordpolicy'] = 'Якщо ввімкнено, паролі користувачів перевірятимуться на відповідність політиці паролів, як зазначено в налаштуваннях нижче. Увімкнення політики паролів не вплине на існуючих користувачів, доки вони не вирішать або не вимагатимуть змінити свій пароль або не буде ввімкнено налаштування «Перевіряти пароль під час входу».';
$string['configpasswordpolicycheckonlogin'] = 'Якщо ввімкнено, паролі користувачів перевірятимуться на відповідність політиці паролів щоразу, коли користувачі входять у систему. Якщо перевірка не вдається, користувачу потрібно буде змінити свій пароль, перш ніж продовжити. Корисно ввімкнути цей параметр після оновлення політики паролів.';
$string['configpasswordresettime'] = 'Це визначає час, протягом якого людина, яка замовила зміну пароля, повинна це підтвердити. Інакше відбувається застарівання цього запиту. Зазвичай 30 хвилин достатньо.';
$string['configpathtodu'] = 'Шлях до du. Звичайно це /usr/bin/du. якщо ви це вкажете, то сторінки, які показують вміст каталогів, будуть запускатись значно швидше, особливо для каталогів з багатьма файлами.';
$string['configpathtophp'] = 'Шлях до PHP CLI. Ймовірно, щось на кшталт /usr/bin/php. Якщо ви введете це, сценарії cron можна буде виконувати з веб-інтерфейсу адміністратора.';
$string['configperfdebug'] = 'Якщо ви увімкнете це, інформація про продуктивність буде надрукована у нижньому колонтитулі стандартної теми';
$string['configprofileroles'] = 'Ролі, які вказані в профілях користувачів і на сторінці учасників.';
$string['configprofilesforenrolledusersonly'] = 'Для запобігання зловживань з боку спамерів, профіль опису користувачів, які ще не зараховані до будь-який курс, є прихованим. Нові користувачі повинні бути зареєстровані, принаймні на один курс, перш ніж вони зможуть додати опис профілю.';
$string['configprotectusernames'] = 'Якщо ввімкнено, форма забутого пароля не відображатиме жодних підказок, які дозволяють вгадувати імена користувачів облікового запису або адреси електронної пошти.';
$string['configproxybypass'] = 'Розділений комами список (частин) хостів або IP-адрес, які не повинні використовувати проксі (наприклад, 192,168 .. mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Це намагається виправити внутрішні виклики, які не проходять через проксі, шляхом додавання агента користувача MoodleBot та використання проксі.';
$string['configproxyhost'] = 'Якщо <b>серверу</b> потрібен проксі (firewall) для доступу в Інтернет, то тут вкажіть ім`я та порт машини, інакше залиште поле порожнім.';
$string['configproxylogunsafe_help'] = 'Це намагається реєструвати внутрішні виклики, які не проходять через проксі-сервер і повинні.';
$string['configproxypassword'] = 'Якщо потрібен пароль для доступу через проксі, то вкажіть його, якщо ні, то залишіть пустим (потрібне розширення PHP cURL).';
$string['configproxyport'] = 'Якщо серверу потрібен проксі (firewall) для доступу в Інтернет, то тут вкажіть його порт.';
$string['configproxytype'] = 'Тип web-проксі (розширення PHP5 та cURL необхідні для підтримки SOCKS5).';
$string['configproxyuser'] = 'Якщо потрібне ім\'я користувача проксі, то вкажіть його, якщо ні, то залиште пустим (потрібне розширення PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Рядок символів (секретний ключ), який використовується для зв\'язку між вашим сервером Moodle і сервером recaptcha. Ключі ReCAPTCHA можна отримати в <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = ' Рядок символів (ключ сайту), який використовується для відображення елемента reCAPTCHA у формі реєстрації та формі підтримки сайту. Ключі ReCAPTCHA можна отримати з <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>';
$string['configrequestedstudentname'] = 'Звертання до студента, яке буде використовуватися у запрошеному курсі';
$string['configrequestedstudentsname'] = 'Звертання до студентів, яке буде використовуватися у запрошеному курсі';
$string['configrequestedteachername'] = 'Звертання до викладача, яке буде використовуватися у запрошеному курсі';
$string['configrequestedteachersname'] = 'Звертання до викладачів, яке буде використовуватися у запрошеному курсі';
$string['configreverseproxyignore'] = 'Якщо ваш сервер знаходиться за кількома зворотними проксі, які додаються до заголовка X-Forwarded-For, то вкажіть розділений комами список IP-адрес або підмереж зворотних проксі, які слід ігнорувати, щоб знайти правильну IP-адресу користувача.';
$string['configsectioninterface'] = 'Інтерфейс';
$string['configsectionmail'] = 'Пошта';
$string['configsectionmaintenance'] = 'Обслуговування';
$string['configsectionmisc'] = 'Різне';
$string['configsectionoperatingsystem'] = 'Операційна система';
$string['configsectionpermissions'] = 'Права';
$string['configsectionrequestedcourse'] = 'Замовлення курсу';
$string['configsectionsecurity'] = 'Безпека';
$string['configsectionstats'] = 'Статистика';
$string['configsectionuser'] = 'Користувач';
$string['configsecureforms'] = 'Система може використовувати додатковий рівень безпеки при отриманні даних через web-форми. Якщо дана опція включена, то змінна браузера HTTP_REFERER звіряється з поточною адресою форми. Дуже мала ймовірність, що це викличе проблеми, наприклад, якщо користувач використовує систему мережевого захисту (наприклад, Zonealarm) налаштовану відокремлювати HTTP_REFERER від загального трафіку. Симптом - `прилипання` до форми. Якщо ваші користувачі мають проблеми при вході в систему, можливо, потрібно виключити це встановлення, хоча це може залишити ваш сайт вразливим для підбору пароля методом перебору. Якщо ви не впевнені, залиште опцію включеною.';
$string['configservicespage'] = 'Введіть URL-адресу сторінки послуг і підтримки або залиште пустим, щоб посилатися на служби Moodle на moodle.com. Посилання відображається лише для адміністраторів сайту.';
$string['configsessioncookie'] = 'Установка визначає формат імені для cookie, які використовуються у підтримки сесій Moodle. Вона не обов\'язкова, але дуже корисна у випадку, коли на сервері встановлено не одну, а кілька копій Moodle.';
$string['configsessioncookiedomain'] = 'Дозволяє змінити домен, з якого отримуються moodle-куки. Це корисно для moodle реєстрації (наприклад, аутентифікації або реєстраційних програмних доповнень), при потребі доступу до відкритих ресурсів на інших субдоменах. <strong>УВАГА: рекомендуємо залишити типову установку (пусто) - некоректне значення може заблокувати будь-які входження на сайт.</strong>';
$string['configsessioncookiepath'] = 'Якщо вам необхідно змінити шлях, по якому браузери посилатимуть Cookies для Moodle, вкажіть тут відповідний каталог вашого сайту. У багатьох випадках непоганим вибором може бути типовий шлях  \'/\'';
$string['configsessiontimeout'] = 'Якщо користувач зайшов на сайт і нічого не робить протягом деякого часу (не завантажує сторінки), він автоматично виходить (сесія закінчується). Ця змінна задає час.';
$string['configsessiontimeoutwarning'] = 'Якщо люди, які ввійшли на цей сайт, тривалий час неактивні (без завантаження сторінок), вони попереджуються про те, що їх сеанс ось-ось закінчиться. Ця змінна визначає тривалість цього часу.';
$string['configsessiontimeoutwarningcheck'] = 'Попередження про час очікування сеансу має бути менше часу очікування сеансу';
$string['configshowcommentscount'] = 'Показати кількість коментарів, це буде коштувати ще одного запиту при показу посилання до коментарів';
$string['configshowicalsource'] = 'Показати інформацію джерела для  iCal подій';
$string['configshowsiteparticipantslist'] = 'Всі ці студенти і викладачі сайту будуть внесені до списку учасників сайту. Кому буде дозволено бачити цей список?';
$string['configsitedefaultlicense'] = 'Типова ліцензія сайту';
$string['configsitedefaultlicensehelp'] = 'Типова ліцензія для публічного контенту на цьому сайті';
$string['configsitemailcharset'] = 'Всі повідомлення, створені на сайті будуть надсилатися в кодуванні, зазначеному тут. У будь-якому випадку, кожен користувач зможе вказати власне кодування, якщо наступний параметр увімкнено.';
$string['configsitemaxcategorydepth'] = 'Максимальна глибина категорії';
$string['configsitemaxcategorydepthhelp'] = 'Цей параметр визначає максимальну глибину дочірніх категорій розкритих при відображенні списку категорій або комбо списку. Глибші категорії будуть показуватися у вигляді посилань і користувач може розкрити їх запитом AJAX.';
$string['configslasharguments'] = 'Для коректного відображення пакетів SCORM і багатофайлових ресурсів потрібні «Аргументи косої риски» (з використанням <em>PATH_INFO</em>). Якщо ваш веб-сервер не підтримує «аргументи косої риски» і ви не можете його налаштувати, цей параметр можна вимкнути, хоча це призведе до того, що все не працюватиме. Примітка. У наступних версіях буде потрібно використовувати «аргументи косої риски». Moodle.';
$string['configsmartpix'] = 'При включенні, зображення, які викликаються через РНР-скрипти, спершу шукаються в поточній темі, потім у всіх батьківських темах, потім у каталозі /pix. Це зменшує потребу дублювати файли зображень в межах тем.';
$string['configsmtpauthtype'] = 'Це встановлює тип автентифікації для використання на сервері SMTP.';
$string['configsmtphosts'] = 'Дайте повну назву одного або кількох локальних серверів SMTP, які Moodle повинен використовувати для відправки пошти (наприклад, "mail.a.com" або "mail.a.com; mail.b.com"). Щоб задати нестандартний порт (тобто відмінний від порту 25), ви можете використовувати синтаксис [сервер]: [порт] (наприклад, "mail.a.com: 587"), . Якщо ви залишите це поле порожнім, Moodle буде використовувати PHP як типовий метод відправки пошти.';
$string['configsmtpmaxbulk'] = 'Максимальна кількість повідомлень протягом однієї SMTP сесії. Групування повідомлень може прискорити відправку пошти. Значення менше 2 буде примусово створювати нову сесію для кожного повідомлення.';
$string['configsmtpoauthservice'] = 'Виберіть службу OAuth 2, налаштовану для спілкування з сервером SMTP. Якщо служби ще не існує, її потрібно створити. Зауважте, що вам потрібно встановити тип автентифікації SMTP на XOAUTH2.';
$string['configsmtpsecure'] = 'Якщо smtp вимагає безпечного з’єднання, вкажіть правильний тип протоколу.';
$string['configsmtpuser'] = 'Якщо ви вище вказали SMTP сервера, і ці сервера вимагають аутентифікації,  вкажіть ім\'я користувача та пароль.';
$string['configstartwday'] = 'Початок тижня';
$string['configstatsfirstrun'] = 'Це визначає, скільки записів системного журналу (logs) потрібно обробити, коли <b>перший раз</b> служба cron запускається для отримання статистики. Якщо ви маєте великий трафік і використовуєте розділений хостинг, можливо, не дуже хороша ідея встановлювати це значення великим, оскільки робота cron може бути тривалою і використовувати багато ресурсів. (Відмітьте, що для цього параметра 1 місяць = 28 днів. У графіках і звітах, які генеруються, 1 місяць = 1 календарний місяць.)';
$string['configstatsmaxruntime'] = 'Обробка статистики може бути вельми інтенсивною. Використовуйте комбінацію цього та наступного полів, щоб визначити, коли це запускати і для якого проміжку часу.';
$string['configstatsmaxruntime2'] = 'Статистичний обробіток може бути доволі інтенсивним, що надасть можливість детального обробітку максимального часу. Максимальна кількість днів за один cron-процес - 31.';
$string['configstatsmaxruntime3'] = 'Вказує максимальний час, відведений для розрахунку статистичних даних за один день, враховуючи, що обробка статистики може дати велике навантаження на сервер. Максимальне число днів, які будуть обробляються за один раз може бути вказаний нижче.';
$string['configstatsruntimedays'] = 'Вказує максимальну кількість днів, які будуть опрацьовані за один раз обробітку статистики. Якщо статистика щоденна, то буде опрацьовано тільки один день. Змініть значення в залежності від навантаження на ваш сервер.';
$string['configstatsruntimestart'] = 'У який час повинна запускатись служба cron для обробки статистики? Визначте різний час для різних сайтів Moodle на одному фізичному сервері.';
$string['configstatsuserthreshold'] = 'Якщо ви введете ненульове, не числове значення для розміщених курсів, курси з меншою кількістю зареєстрованих користувачів (студенти + викладачі) будуть проігноровані';
$string['configstrictformsrequired'] = 'Якщо цей параметр включений, то користувачі не зможуть вводити пробіл або розрив рядка в полях форми, необхідних для заповнення.';
$string['configstripalltitletags'] = 'Знята відмітка дозволить HTML теги в назвах діяльностей та ресурсів.';
$string['configsupportavailability'] = 'Визначає, хто має доступ до служби підтримки сайту з нижнього колонтитула.';
$string['configsupportemail'] = 'Якщо на цьому сайті налаштовано SMTP, а сторінку підтримки не встановлено, на цю адресу електронної пошти надходитимуть повідомлення, надіслані через форму підтримки. Якщо відправка не вдається, адреса електронної пошти буде відображатися користувачам, які ввійшли в систему.';
$string['configsupportname'] = 'Ім’я особи чи іншої організації, яка надає підтримку через форму підтримки або сторінку підтримки.';
$string['configsupportpage'] = 'Введіть URL-адресу сторінки підтримки або залиште поле пустим, щоб перейти до контактної форми. Посилання відображається в нижньому колонтитулі сайту.';
$string['configtempdatafoldercleanup'] = 'Видалити тимчасові файли даних з каталогу даних, які старіші за вказаний час';
$string['configthemedesignermode'] = 'Звичайно, для підвищення продуктивності, всі картинки та листи стилів теми дизайну кешуються у браузері та на сервері на довгий час. Якщо ви створюєте теми або програмний код, то можливо краще відключити цей режим. Попередження: це уповільнить роботу сайту для всіх користувачів! Як альтернатива, ви можете також змінити тип кешування теми вручну на сторінці вибору теми.';
$string['configthemelist'] = 'Залишіть це поле порожнім, щоб дозволити використовувати будь-яку дійсну тему. Якщо ви хочете скоротити меню тем, ви можете визначити тут їх список, відокремлюючи назви тем комами (Не використовуйте пропуски!). Наприклад: standard,orangewhite.';
$string['configtimezone'] = 'Тут ви можете встановити “часовий пояс”. Він буде типовим для виводу системних дат та часу, при цьому кожен користувач зможе змінити для себе часовий пояс у власному профайлі. Установка “Час на сервері” ставить це значення у відповідність до налаштувань операційної системи серверу. Задачі cron та інші серверні налаштування визначаються цією опцією. Ви повинні змінити це налаштування, якщо бачите напис "Неправильний часовий пояс".';
$string['configuseblogassociations'] = 'Чи користувачі зможуть організувувати свій блог, зв\'язавши записи з курсів та навчальних модулів?';
$string['configusesitenameforsitepages'] = 'Якщо ввімкнено, коротка назва сайту використовуватиметься для вузла сторінок сайту в навігації, а не рядка «Сторінки сайту».';
$string['configusetags'] = 'Чи повинна бути включена функціональність міток на всьому сайті?';
$string['configvariables'] = 'Змінні';
$string['configverifychangedemail'] = 'Включає перевірку дозволених та заборонених доменів при зміні ел.пошти. Якщо ця установка відключена то перевірка на дозволеність домену буде проводитися тільки при реєстрації нових користувачів.';
$string['configvisiblecourses'] = 'Показувати курси в схованих категоріях';
$string['configwarning'] = 'Будьте уважні при зміні цих налаштувань, некоректні установки можуть призвести до проблем.';
$string['configyuicomboloading'] = 'Ця опція дозволяє завантаження об\'єднаного файл у оптимізації для бібліотеки YUI. Цей параметр повинен бути включений на робочих сайтах для збільшення продуктивності.';
$string['confirmation'] = 'Підтвердження';
$string['confirmcontextlock'] = '{$a->contextname} наразі запущено. Якщо його зупинити, він стане доступним лише для читання та не дозволить користувачам вносити зміни. Ви впевнені, що хочете продовжити?';
$string['confirmcontextunlock'] = '{$a->contextname} наразі зупинено. Запуск дозволить користувачам вносити зміни. Ви впевнені, що хочете продовжити?';
$string['confirmdeletecomments'] = 'Ви впевнені, що бажаєте видалити вибрані коментарі?';
$string['confirmed'] = 'Підтверджено';
$string['contactsitesupport'] = 'Зверніться до служби підтримки сайту';
$string['contenttypeuninstalling'] = '{$a->type} підтримує вміст {$a->count}. Він буде видалений. Ви впевнені, що хочете продовжити?';
$string['contextlockappliestoadmin'] = 'Блокування контексту стосується адміністраторів';
$string['contextlockappliestoadmin_desc'] = 'Якщо вимкнено, адміністратори залишаються з доступом на запис до будь-яких заморожених контекстів.';
$string['contextlocking'] = 'Заморожування контексту';
$string['contextlocking_desc'] = 'Цей параметр дозволяє встановити доступ лише для читання для вибраних категорій, курсів, заходів або блоків.';
$string['cookiesecure'] = 'Тільки безпечні куки';
$string['country'] = 'Типова країна';
$string['course_customfield'] = 'Спеціальні поля курсу';
$string['coursecolor'] = 'Колір {$a}';
$string['coursecolorheading_desc'] = 'Будь-які курси без зображення курсу, встановленого в налаштуваннях курсу, відображаються на інформаційній панелі за допомогою візерункової картки курсу. Кольори, використані у візерунку, можуть бути вказані нижче.';
$string['coursecolorsettings'] = 'Колір карток курсу';
$string['coursecontact'] = 'Контакти курсу';
$string['coursecontact_desc'] = 'Цей параметр дозволяє вам контролювати, хто з\'являється в загальному описі курсу. Користувачі повинні мати принаймні одну з цих ролей в курсі, щоб показуватися в описі курсу.';
$string['coursecontactduplicates'] = 'Відобразити всі контактні ролі курсу';
$string['coursecontactduplicates_desc'] = 'Якщо ввімкнено, користувачі з більш ніж однією з вибраних контактних ролей курсу відображатимуться в описі курсу з кожною з їхніх ролей. В іншому випадку вони відображатимуться лише з однією роллю (яка з них є найвищою в списку «Визначення ролей» в Адміністрації сайту).';
$string['coursecreationguide'] = 'URL-адреса посібника зі створення курсу Moodle';
$string['coursecreationguide_help'] = 'Визначає шлях до швидкого посібника з короткими відео та загальними порадами щодо створення курсів. Посилання на посібник відображається на сторінці Мої курси, якщо немає курсів для показу. Лише користувачі, які мають можливість створювати курси, бачитимуть посилання.';
$string['coursegraceperiodafter'] = 'Пільговий період для минулих курсів';
$string['coursegraceperiodbefore'] = 'Пільговий період для майбутніх курсів';
$string['courselistshortnames'] = 'Показати короткі назви';
$string['courselistshortnames_desc'] = 'Показати коротку та повну назви при відображенні списку курсів.';
$string['coursemgmt'] = 'Робота з курсами';
$string['courseoverview'] = 'Статистика курсів';
$string['coursepage'] = 'Сторінка курсу';
$string['courserequestnotify'] = 'Повідомлення замовлення курсу';
$string['courserequestnotifyemail'] = 'Користувач {$a->user} запросив новий курс <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Замовлення курсу';
$string['courserequestspending'] = 'Очікують реєстрації';
$string['courses'] = 'Курси';
$string['coursesperpage'] = 'Курсів на сторінку';
$string['courseswithsummarieslimit'] = 'Курсів з коротким описом';
$string['creatornewroleid'] = 'Роль творця курсу в нових курсах';
$string['creatornewroleid_help'] = 'Якщо користувач ще не має дозволу на керування новим курсом, користувач автоматично зараховується з використанням цієї ролі.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Увімкнути cron';
$string['cron_enabled_desc'] = 'Зазвичай Cron має бути увімкнено, однак цей параметр дозволяє його тимчасово вимкнути, наприклад, перед перезапуском сервера. Якщо вимкнено, системі заборонено запускати нові фонові завдання. Зверніть увагу, що cron не слід відключати на тривалий час, оскільки це завадить роботі важливих функцій.';
$string['cron_help'] = 'Сценарій cron.php запускає ряд завдань з різними запланованими інтервалами, наприклад надсилає електронні листи з повідомленнями про повідомлення на форумі. Сценарій слід запускати регулярно – в ідеалі кожну хвилину.';
$string['cron_keepalive'] = 'Залишатися живим';
$string['cron_keepalive_desc'] = 'Тривалість опитування для додаткових завдань. Цей параметр призначений для забезпечення постійного запуску cron. Якщо ви використовуєте спеціалізовані програми для виконання завдань, встановіть для нього значення 0. В іншому випадку встановіть для нього значення, подібне до обмеження одночасного виконання завдань adhoc. Уникайте тривалого часу. Максимальний час – 15 хвилин.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Виконання Cron тільки через командний рядок';
$string['cronerrorclionly'] = 'Вибачте, інтернет доступ до цієї сторінки заблоковано адміністратором.';
$string['cronerrorpassword'] = 'Вибачте, ви не вказали правильний пароль для доступу до даної сторінки';
$string['croninfrequent'] = 'Між останніми двома запусками сценарію обслуговування cron було {$a->actual}, і він повинен виконуватися кожні {$a->expected}. Ми рекомендуємо налаштувати його так, щоб він працював частіше.';
$string['cronremotepassword'] = 'Cron-пароль для віддаленого доступу';
$string['cronwarning'] = 'Сценарій <a href="{$a->url}">admin/cron.php script</a> не був запущений для {$a->actual} і має виконуватися кожного {$a->expected}.';
$string['cronwarningcli'] = 'Сценарій <code>admin/cli/cron.php</code> не було запущено для {$a->actual} і має виконуватися кожні {$a->expected}.';
$string['cronwarningnever'] = 'Скрипт <code>admin/cli/cron.php</code> ніколи не запускався, але він має виконуватися кожний {$a->expected}.';
$string['cronwarningneverweb'] = 'Скрипт <a href="{$a->url}">admin/cron.php script</a> ніколи не запускався, але він має виконуватися кожний {$a->expected}.';
$string['ctyperequired'] = 'Розширення ctype PHP тепер потрібне для Moodle, що додає функціонування багатомовності.';
$string['curlcache'] = 'Час зберігання кешу cURL';
$string['curlrequired'] = 'Розширення PHP cURL потрібне для зв’язку з Moodle репозиторіями.';
$string['curlsecurityallowedport'] = 'список дозволених портів cURL';
$string['curlsecurityallowedportsyntax'] = 'Список номерів портів, до яких може підключатися cURL. Допустимі записи - це цілі числа. Покладіть кожен запис на новий рядок. Якщо залишити порожнім, то всі порти дозволені. Якщо встановлено, практично у всіх випадках, 443 і 80 повинні бути вказані для cURL для підключення до стандартних HTTPS і HTTP портів.';
$string['curlsecurityblockedhosts'] = 'список заблокованих хостів cURL';
$string['curlsecurityblockedhostssyntax'] = 'Помістіть кожен запис у новому рядку. Допустимі записи - це повні адреси IPv4 або IPv6 (наприклад, 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), які відповідають одному хосту; або позначення CIDR (наприклад, 231.54.211.0/20 або fe80::/64); або діапазон IP-адрес (наприклад, 231.3.56.10-20 або fe80::1111-bbbb), де діапазон застосовується до останньої групи адреси; або доменні імена (наприклад, localhost або example.com); або доменні імена (наприклад, * .example.com або * .sub.example.com). Порожні рядки не допускаються.';
$string['curlsecurityurlblocked'] = 'URL заблоковано.';
$string['curltimeoutkbitrate'] = 'Бітрейд для розрахунку cURL затримки (кбіт/с)';
$string['curltimeoutkbitrate_help'] = 'Цей параметр використовується для розрахунку відповідної затримки під час великих cURL запитів. У рамках цього розрахунку HTTP HEAD потрібно розрахувати розмір контенту. Значення 0 відключає цю вимогу.';
$string['currenttheme'] = 'Поточна тема';
$string['customcheck'] = 'Інші перевірки';
$string['custommenu'] = 'Персональне меню';
$string['custommenuitems'] = 'Елементи персонального меню';
$string['customusermenuitems'] = 'Елементи меню користувача';
$string['datarootsecurityerror'] = '<p><strong>ПОПЕРЕДЖЕННЯ БЕЗПЕКИ!</strong></p><p>Ваш каталог з даними сайту (dataroot) знаходиться в небезпечному місці та доступний з мережі. Це означає, що ваші приватні файли доступні кожному в Інтернеті і можуть бути використані хакерами для взлому вашого сайту!</p><p>Вам <em>потрібно</em> перемістити цей каталог ({$a}) в нове більш безпечне місце та оновити змінну <code>$CFG->dataroot</code> в config.php.</p>';
$string['datarootsecuritywarning'] = 'Конфігурація вашого сайту може мати проблеми із захищеністю. Переконайтеся, будь ласка, що ваш кореневий каталог даних ({$a}) не має безпосереднього доступу з Web.';
$string['dbsessions'] = 'Використовувати базу даних для інформації сесій';
$string['debug'] = 'Повідомлення налагодження';
$string['debugall'] = 'ВСЕ: Показати всі розумні повідомлення РНР налагодження';
$string['debugdeveloper'] = 'РОЗРОБКА: Тільки повідомлення налагодження для розробників.';
$string['debugdisplay'] = 'Показувати повідомлення налагодження';
$string['debugging'] = 'Налагодження';
$string['debugminimal'] = 'МІНІМАЛЬНО: Показати тільки фатальні помилки';
$string['debugnone'] = 'НІЧОГО: Не показувати будь-яких помилок та попереджень';
$string['debugnormal'] = 'НОРМАЛЬНО: Показувати помилки та попередження';
$string['debugpageinfo'] = 'Показати інформацію сторінки';
$string['debugsqltrace'] = 'Показати походження викликів SQL';
$string['debugsqltrace1'] = 'Показати лише одну лінію виклику';
$string['debugsqltrace100'] = 'Показати повне трасування стека';
$string['debugsqltrace2'] = 'Показати 2 рядки трасування стека';
$string['debugsqltrace_desc'] = 'Якщо ввімкнено, часткова або повна трасування стека PHP додається до SQL як коментар.';
$string['debugstringids'] = 'Показати джерело мовних рядків';
$string['debugstringids_desc'] = 'Якщо ввімкнено, компоненти мовного рядка та ідентифікатори відображаються, коли до URL-адреси сторінки додається ?strings=1 або &strings=1.';
$string['debugtemplateinfo'] = 'Показати інформацію про шаблон';
$string['debugtemplateinfo_desc'] = 'Якщо ввімкнено, шаблони, які використовуються для відтворення, відображаються як коментарі в HTML-коді сторінки. Використовуйте лише для тимчасового налагодження, оскільки це створює помилки перевірки HTML і може порушити роботу деяких сценаріїв сторінок.';
$string['debugvalidators'] = 'Показати перевірку посилань';
$string['defaultcity'] = 'Типове місто';
$string['defaultcity_help'] = 'Місто, яке буде підставлятися як типове при створенні нового користувача.';
$string['defaultformatnotset'] = 'Помилка при визначенні типового форматукурсу, звичайно. Будь ласка, перевірте налаштування сайту.';
$string['defaulthomepage'] = 'Стартова сторінка для користувачів';
$string['defaultrequestcategory'] = 'Типова категорія для замовлених курсів';
$string['defaultsettinginfo'] = 'Типово: {$a}';
$string['defaultuserroleid'] = 'Типова роль для усіх користувачів';
$string['deleteincompleteusers'] = 'Видаляти непідтверджених користувачів після';
$string['deleteunconfirmed'] = 'Видаляти непідтверджених користувачів після';
$string['deleteuser'] = 'Видалити користувача';
$string['density'] = 'Щільність';
$string['denyemailaddresses'] = 'Заборонені поштові домени';
$string['development'] = 'Розробка';
$string['devicedetectregex'] = 'Регулярний вираз для виявлення пристроїв';
$string['devicedetectregex_desc'] = '<p>Типово Moodle вміє визначати стандартні пристрої (настільні ПК, ноутбуки, тощо), мобільні (телефони та невеликі портативні пристрої), планшети (iPads, Android планшети) та застарілі (Internet Explorer 6). Перемикач тем може бути використаним для забезпечення їх всіх. Цей параметр дозволяє регулярні вирази, які допоможуть виявленню додаткових типів пристроїв (вони мають пріоритет над стандартними типами).</p> <p>Наприклад, введений регулярний вираз \'/(MIDP-1.0|Maemo|Windows CE)/\' виявить деякі з найбільш використовуваних телефонів feasture і поверне значення \'featurephone\'. Це додасть \'featurephone\' до перемикача теми, що дасть вам можливість визначити тему дизайну, яку будуть використовувати ці пристрої. Інші телефони будуть як і раніше використовувати тему, обрану для мобільного типу пристроїв.</p>';
$string['devicedetectregexexpression'] = 'Регулярний вираз';
$string['devicedetectregexvalue'] = 'Повернути значення';
$string['devicetype'] = 'Тип пристрою';
$string['devlibdirpresent'] = 'Довідники з бібліотеками розробки, особливо <em>/vendor</em> і <em>/node_modules</em>, не повинні бути присутніми на загальнодоступних сайтах. Для отримання докладніших відомостей див. <a href="{$a->moreinfourl}"> звіт про перевірку безпеки.';
$string['disabled'] = 'Вимкнено';
$string['disableplugin'] = 'Вимкнути {$a}';
$string['disableuserimages'] = 'Відключити фото користувачів';
$string['displayerrorswarning'] = 'Включення РНР опції <em>display_errors</em> не рекомендується на на діючих сайтах, оскільки інформація про помилки може видати небажану інформацію про ваш сервер.';
$string['displayloginfailures'] = 'Показати невдалі спроби входження';
$string['divertallemails'] = 'Переадресація електронної пошти';
$string['divertallemailsdetail'] = 'Використовується як запобіжний засіб у середовищі розробки під час тестування електронних листів і не повинен використовуватися у виробництві.';
$string['divertallemailsexcept'] = 'Винятки щодо переадресації електронної пошти';
$string['divertallemailsexcept_desc'] = 'Список винятків електронної пошти, розділених комами або новими рядками. Кожне правило інтерпретується як регулярний вираз, наприклад
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Переадресовувати всі електронні листи';
$string['divertallemailsto_desc'] = 'Якщо встановлено, усі електронні листи будуть перенаправлені на цю єдину адресу електронної пошти.';
$string['dndallowtextandlinks'] = 'Завантаження тексту/посилань перетягуванням';
$string['doclang'] = 'Мова документації';
$string['docroot'] = 'Місце Moodle Документації';
$string['doctonewwindow'] = 'Відкрити у новому вікні';
$string['doesnotfit'] = 'Налаштування відображення електронної пошти';
$string['doesnotfitdetail'] = 'Відображення налаштувань для електронної пошти з Moodle.';
$string['download'] = 'Завантажити';
$string['downloadcoursecontentallowed'] = 'Доступна функція завантаження змісту курсу';
$string['downloadcoursecontentallowed_desc'] = 'Чи доступна функція завантаження вмісту курсу для курсів. Якщо доступно, завантаження вмісту курсу можна ввімкнути/вимкнути за допомогою параметра «Увімкнути завантаження вмісту курсу» в меню редагування курсу (за умовчанням це можна встановити в налаштуваннях <a href={$a} target="_blank">курсу за замовчуванням</a>).';
$string['durationunits'] = 'одиниці часу';
$string['edithelpdocs'] = 'Редагувати файли допомоги';
$string['editlang'] = '<b>Редагувати</b>';
$string['editorbackgroundcolor'] = 'Колір тла';
$string['editordictionary'] = 'Редактор словника';
$string['editorfontfamily'] = 'Сімейство шрифтів';
$string['editorfontlist'] = 'Список шрифтів';
$string['editorfontsize'] = 'Розмір шрифтів';
$string['editorhidebuttons'] = 'Сховані кнопки';
$string['editorkillword'] = 'Фільтрація формату Word';
$string['editorspelling'] = 'Редактор правопису';
$string['editorspellinghelp'] = 'Включити або виключити перевірку правопису. Якщо включено, то <strong>aspell</strong> повинен бути встановленим на сервері.';
$string['editstrings'] = 'Редагування змінних';
$string['emailchangeconfirmation'] = 'Підтвердження зміни ел.пошти';
$string['emaildkim'] = 'Підпис електронної пошти DomainKeys Identified Mail (DKIM).';
$string['emaildkiminfo'] = 'Якщо одночасно встановлено селектор DKIM і знайдено приватний файл сертифіката, який відповідає домену адреси електронної пошти "Від" у $CFG->dataroot/dkim/[domain]/[selector].private, тоді електронний лист буде підписано. У більшості випадків (наприклад, якщо параметр enableemaildomains порожній) потрібен лише один сертифікат у <pre>{$a->path}</pre>. Додаткові відомості про налаштування див. у документації <a href="{$a->docs}">Конфігурація пошти</a>.';
$string['emaildkimselector'] = 'Селектор DKIM';
$string['emailfromvia'] = 'Електронна пошта через інформацію';
$string['emailheaders'] = 'Заголовки електронних листів';
$string['emailsubjectprefix'] = 'Текст префікса теми електронного листа';
$string['emoticonalt'] = 'Альтернативний текст';
$string['emoticoncomponent'] = 'Компонент зображення';
$string['emoticonimagename'] = 'Назва зображення';
$string['emoticons'] = 'Емоційки';
$string['emoticons_desc'] = 'Ця форма визначає емоційки (або смайлики), що використовуються на вашому сайті. Щоб видалити рядок з таблиці, збережіть форму з порожнім значенням в непотрібних рядках. Для реєстрації нових емоційок, заповніть поля в кінці таблиці. Для скидання всіх полів в типові значення, перейдіть за посиланням вище.

* Текст (обов\'язково) - Цей текст буде замінений на зображення емоційки. Він повинен бути не менше двох символів.
* Назва зображення (обов\'язково) - ім’я файлу зображення емоційки без розширення, по відношенню до каталогу pix.
* Компонент зображення (обов\'язково) - компонент, який забезпечує значок.
* Альтернативний текст (опціонально) - ідентифікатор рядка і компонент альтернативного тексту емоційки.';
$string['emoticonsreset'] = 'Скинути налаштування емоційок до типових значень';
$string['emoticontext'] = 'Текст';
$string['emptysettingvalue'] = 'Порожнє';
$string['enableanalytics'] = 'Аналітика';
$string['enableblogs'] = 'Дозволити блоги';
$string['enablecalendarexport'] = 'Дозволити експорт календаря';
$string['enablecomments'] = 'Дозволити коментарі';
$string['enablecommunicationsubsystem'] = 'Увімкнути комунікаційну підсистему';
$string['enablecommunicationsubsystem_desc'] = 'Цей параметр увімкне нову підсистему зв’язку. Ця нова підсистема дозволяє вчителям і учням легше спілкуватися під час використання Moodle для викладання та навчання';
$string['enablecourserelativedates'] = 'Увімкнути відносні дати курсів';
$string['enablecourserelativedates_desc'] = 'Дозволити налаштування курсів для відображення дат відносно дати початку користувача в курсі.';
$string['enablecourserequests'] = 'Дозволити замовлення нових курсів';
$string['enabled'] = 'Включено';
$string['enabledashboard'] = 'Увімкнути інформаційну панель';
$string['enabledashboard_help'] = 'На інформаційній панелі за замовчуванням відображаються часова шкала, календар і елементи, до яких ви нещодавно зверталися. Ви можете встановити іншу інформаційну панель за замовчуванням для всіх і дозволити користувачам налаштовувати власну інформаційну панель. Якщо вимкнено, потрібно встановити для параметра "Початкова сторінка для користувачів" значення, відмінне від інформаційної панелі.';
$string['enabledevicedetection'] = 'Включити визначення пристроїв';
$string['enableglobalsearch'] = 'Увімкнути глобальний пошук';
$string['enableglobalsearch_desc'] = 'Якщо ввімкнено, дані будуть індексуватися та синхронізуватися запланованим завданням.';
$string['enablegravatar'] = 'Включити Граватар';
$string['enablegravatar_help'] = 'Якщо включено, то Moodle, при відсутності картинки користувача, буде намагатися отримати картинку для облікового запису з сайту Граватару.';
$string['enablemobilewebservice'] = 'Включити мобільний веб-сервіс';
$string['enablepdfexportfont'] = 'Увімкнути шрифти PDF';
$string['enablepdfexportfont_desc'] = 'Якщо на вашому сайті є курси різними мовами, які потребують інших шрифтів у створених PDF-файлах, ви можете надати можливість установити шрифт у налаштуваннях курсу. Вам потрібно вказати доступні шрифти в $CFG->pdfexportfont у config.php.';
$string['enableplugin'] = 'Увімкнути {$a}';
$string['enablerecordcache'] = 'Дозволити Кеш Записів';
$string['enablerssfeeds'] = 'Дозволити RSS';
$string['enablesearchareas'] = 'Дозволити поле пошуку';
$string['enablesharingtomoodlenet'] = 'Увімкнути спільний доступ до MoodleNet (вихідний)';
$string['enablesharingtomoodlenet_desc'] = 'Дозвольте користувачам ділитися вмістом курсу з налаштованим екземпляром MoodleNet, якщо вони мають відповідні можливості.';
$string['enablestats'] = 'Дозволити статистику';
$string['enabletrusttext'] = 'Дозволити Довірчий Контент';
$string['enableuserfeedback'] = 'Увімкнути відгук про це програмне забезпечення';
$string['enableuserfeedback_desc'] = 'Якщо ввімкнено, у нижньому колонтитулі відображається посилання «Надати відгук про це програмне забезпечення», щоб користувачі могли надіслати відгук про програмне забезпечення Moodle до штаб-квартири Moodle. Якщо встановлено опцію «Наступне нагадування про зворотній зв’язок», користувачеві також відображатиметься нагадування на інформаційній панелі через вказаний інтервал. Якщо для параметра «Наступне нагадування про це програмне забезпечення» встановлено значення «Ніколи», нагадування на інформаційній панелі вимкнеться, у нижньому колонтитулі залишиться посилання «Надати відгук про це програмне забезпечення».';
$string['enablewebservices'] = 'Дозволити Веб-сервіси';
$string['enablewsdocumentation'] = 'Документація Веб-сервісів';
$string['encryptedpassword_edit'] = 'Введіть нове значення';
$string['encryptedpassword_set'] = '(Встановлено та зашифровано)';
$string['enroladminnewcourse'] = 'Автоматична реєстрація адміністратора на нові курси';
$string['enroladminnewcourse_help'] = 'Коли адміністратор додає новий курс, чи слід він автоматично реєструватися й призначати роль творців у нових курсах?';
$string['enrolinstancedefaults'] = 'Варіант типового зарахування';
$string['enrolinstancedefaults_desc'] = 'Установка типового зарахування на нових курсах.';
$string['enrolmultipleusers'] = 'Зарахувати користувачів';
$string['entitytasklog'] = 'Журнал завдань';
$string['environment'] = 'Середовище';
$string['environmenterrortodo'] = 'Ви повинні вирішити всі проблеми залежностей, знайдені вище, перш ніж почати установку даної версії Moodle!';
$string['environmenterrorupgrade'] = 'Попередження: вам необхідно вирішити всі проблеми залежностей перед продовженням модернізації даної версії Мудл! Модернізація без задоволення вимог залежності може мати проблеми у вигляді втрати даних. Ви впевнені, що бажаєте продовжити модернізацію?';
$string['environmentmariadbwrongdbtype'] = 'Неправильний $CFG->dbtype. Вам потрібно змінити його у файлі config.php з «mysqli» на «mariadb».';
$string['environmentmustfixsetting'] = 'Налаштування РНР повинні бути змінені.';
$string['environmentok'] = 'Всі серверні залежності відповідають мінімальним вимогам.';
$string['environmentrecommendcustomcheck'] = 'якщо цей тест не пройшов, то це вказує на потенційну проблему';
$string['environmentrecommendinstall'] = 'рекомендується встановити та включити';
$string['environmentrecommendversion'] = 'рекомендовано версію {$a->needed}, ви запускаєте {$a->current}';
$string['environmentrequirecustomcheck'] = 'цей тест потрібно пройти';
$string['environmentrequireinstall'] = 'вимагається для встановлення та включення';
$string['environmentrequireversion'] = 'потрібна версія {$a->needed}, ви запускаєте {$a->current}';
$string['environmentsettingok'] = 'рекомендоване значення виявлено';
$string['environmentshouldfixsetting'] = 'Налаштування РНР повинні бути змінені.';
$string['environmentxmlerror'] = 'Помилка зчитування даних оточення ({$a->error_code})';
$string['errordeletingconfig'] = 'Сталася помилка при видаленні записів конфігурації для плагіна \'{$a}\'.';
$string['errorsetting'] = 'Неможливо зберегти налаштування:';
$string['errorwithsettings'] = 'Деякі налаштування не було змінено через помилку:';
$string['eventshandlersinuse'] = 'Наступні модулі у вашій системі використовують застарілий інтерфейс подій (API 1):  \'{$a}\'. Будь ласка, оновіть їх для використаннянового інтерфейсу (API "). Див. https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Кожен, хто може \'{$a}';
$string['exceptions'] = 'Винятки';
$string['execpathnotallowed'] = 'Встановлення шляхів виконання відключено в config.php';
$string['experimental'] = 'Експериментально';
$string['experimentalsettings'] = 'Експериментальні налаштування';
$string['extendedusernamechars'] = 'Дозволити розширений набір символів в псевдоім’ях користувачів';
$string['extramemorylimit'] = 'Максимальне обмеження пам\'яті для РНР';
$string['fatalsessionautostart'] = '<p>Виявлено серйозні конфігураційні помилки, повідомте адміністратора сервера.</p><p> Для нормальної роботи Moodle вимагає, щоб адміністратор змінив налаштування PHP.</p><p><code>session.auto_start</code> повино бути встановлено в <code>off</code>.</p><p>Це налаштування знаходиться у файлі <code>php.ini</code>, Apache/IIS <br />конфігурації або <code>.htaccess</code> файлі на сервері.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Фавікон відображається поруч із заголовком сторінки на вкладці браузера. Фавіконка Moodle відображається, якщо власна піктограма веб-сторінки не надано.';
$string['feedbacksettings'] = 'Перегляд параметрів збору відгуків';
$string['fileconversioncleanuptask'] = 'Очищення тимчасових записів для перетворення файлів';
$string['filecreated'] = 'Новий файл створено';
$string['filescleanupperiod'] = 'Очистіть файли сміттєвого басейну';
$string['filescleanupperiod_help'] = 'Як часто видаляються файли пулу сміття. Це файли, які пов’язані з контекстом, який більше не існує, наприклад, коли курс видалено. Зверніть увагу: це налаштування може призвести до відсутності файлів у курсі, який створюється резервне копіювання, видаляється, а потім відновлюється, якщо параметр «Включати файли» (backup_auto_files) у «Налаштування автоматичного резервного копіювання» вимкнено.';
$string['filesizeunits'] = 'одиниці розміру файлу';
$string['filestoredin'] = 'Зберегти файл до каталогу:';
$string['filestoredinhelp'] = 'Де буде збережено файл';
$string['filterall'] = 'Фільтрація всіх рядків';
$string['filtermatchoneperpage'] = 'Фільтрувати один раз на сторінку';
$string['filtermatchonepertext'] = 'Фільтрувати один раз на текст';
$string['filternavigationwithsystemcontext'] = 'Фільтр навігації з системним контекстом';
$string['filters'] = 'Фільтри';
$string['filtersettings'] = 'Управління фільтрами';
$string['filtersettingsgeneral'] = 'Загальні параметри фільтру';
$string['filteruploadedfiles'] = 'Фільтрація завантажених файлів';
$string['forceclean'] = 'Очищення вмісту всюди';
$string['forceclean_desc'] = 'Вміст, доданий до сайту, зазвичай очищається перед відображенням, щоб видалити все, що може бути загрозою для безпеки. Однак вміст не очищається в певних місцях, таких як опис діяльності, ресурси сторінки або блоки HTML, щоб додати сценарії, медіа, вбудовані кадри тощо. Якщо це налаштування ввімкнено, ВСЕ вміст буде очищено. Це може призвести до неправильного відображення існуючого вмісту.';
$string['forcelogin'] = 'Примусити користувачів до входження';
$string['forceloginforprofileimage'] = 'Примусити користувачів до входу в систему для перегляду зображень інших користувачів';
$string['forceloginforprofileimage_help'] = 'Якщо ввімкнено, користувачі повинні ввійти, щоб переглянути зображення профілю користувача, а зображення користувача за замовчуванням використовуватиметься у всіх повідомленнях електронної пошти.';
$string['forceloginforprofiles'] = 'Примусити до входження для огляду профіля';
$string['forcetimezone'] = 'Примусити типовий часовий пояс';
$string['formatuninstallwithcourses'] = 'Є {$a->count} курс(ів), які використовують  {$a->format}. Іхній формат буде замінено на {$a->defaultformat} (типовий формат для курсів). Деяка специфічна інформація формату може бути втрачена. Ви впевнені, що хочете продовжити процес?';
$string['frontpage'] = 'Головна сайту';
$string['frontpagebackup'] = 'Резервна копія головної сторінки';
$string['frontpagedefaultrole'] = 'Типова роль для головної сторінки';
$string['frontpagefilters'] = 'Деякі фільтри головної сторінки';
$string['frontpageloggedin'] = 'Елементи головної сторінки сайту під час входу';
$string['frontpageoverrides'] = 'Дозвіл головної сайту перевизначає';
$string['frontpagequestions'] = 'Питання на головній сайту';
$string['frontpagerestore'] = 'Відновлення головної сайту';
$string['frontpageroles'] = 'Ролі головної сайту';
$string['frontpagesettings'] = 'Налаштування головної сайту';
$string['fullnamedisplay'] = 'Формат повного імені';
$string['fullnamedisplayprivate'] = 'Формат повного імені - приватний';
$string['gdrequired'] = 'Розширення GD тепер потрібне Moodle для перетворення зображень.';
$string['generalsettings'] = 'Загальні налаштування';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Зареєстроване джерело ІР-адеси';
$string['globalsearch'] = 'Глобальний пошук';
$string['globalsearchmanage'] = 'Керування глобальним пошуком';
$string['googlemapkey3'] = 'Ключ для Google Maps API V3';
$string['googlemapkey3_help'] = 'Вам потрібно вказати спеціальний ключ для використання сервісу Google Maps для візуалізації розташування ІР-адрес. Ви можете вільно отримати цей ключ відвідавши <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Перейти до першої не заповненої змінної';
$string['gradebook'] = 'Журнал оцінок';
$string['gradebookroles'] = 'Ролі для журналу оцінок';
$string['gradeexport'] = 'Основні методи експорту оцінок';
$string['gravatardefaulturl'] = 'URL типової картинки з Граватару';
$string['gravatardefaulturl_help'] = 'Граватару потрібно вказати типову картинку для показу, якщо не вдалося знайти картинку вказану користувачем. Вказуйте повний URL до картинки. Якщо залишити цей параметр порожнім, Moodle буде намагатися використовувати найбільш підходящі зображення для сторінки, яку ви переглядаєте. Відзначимо також, що Граватар має ряд кодів, які можуть бути використані для <a href="https://en.gravatar.com/site/implement/images/#default-image">генерування типового зображення</a>.';
$string['groupenrolmentkeypolicy'] = 'Політика ключа запису в групу';
$string['groupenrolmentkeypolicy_desc'] = 'Якщо ввімкнено, ключі реєстрації груп перевірятимуться на відповідність політиці паролів, як зазначено в налаштуваннях вище.';
$string['guestroleid'] = 'Роль для гостя';
$string['guestroleid_help'] = 'Ця роль автоматично надається гостю. Він також тимчасово записується до незареєстрованих користувачів, які ввійшли на курс через модуль реєстрації гостей.';
$string['h5pgetcontenttypestask'] = 'Завантажте доступні типи вмісту H5P з h5p.org';
$string['helpadminseesall'] = 'У календарі сайту адміністратори бачать і фільтрують події з усіх календарів курсів чи лише з курсів, на які вони зареєстровані? Незалежно від вибраного параметра, адміністратори завжди зможуть керувати подіями для кожного календаря курсу, спочатку перейшовши до курсу, а потім безпосередньо перейшовши до календаря курсу.';
$string['helpcalendarcustomexport'] = 'Включає можливість вибору специфічних діапазонів дат при експорті календаря. При цьому повинна бути включена власне можливість експортувати календар.';
$string['helpexportlookahead'] = 'Скільки днів вперед від поточної дати потрібно взяти при експорті календаря в ручному режимі?';
$string['helpexportlookback'] = 'Скільки днів назад від поточної дати потрібно взяти при експорті календаря в ручному режимі?';
$string['helpforcetimezone'] = 'Ви можете дозволити користувачам вибирати власний часовий пояс або встановити його один для всіх.';
$string['helpshowicalsource'] = 'Якщо включено, то назва підписки та посилання будуть показуватися для подій iCal-імпорту.';
$string['helpsitemaintenance'] = 'Для модернізації та ін.роботи';
$string['helpstartofweek'] = 'Який день починає тиждень в календарі';
$string['helpupcominglookahead'] = 'Скільки днів наперед показувати для подій, які надходять?';
$string['helpupcomingmaxevents'] = 'Скільки (максимально) нових подій буде показуватися користувачу в типовому варіанті.';
$string['helpweekenddays'] = 'Які дні тижня виділяються під вихідні (будуть виділятися іншим кольором).';
$string['hiddenuserfields'] = 'Сховані дані користувача';
$string['hidefromall'] = 'Сховати від всіх';
$string['hidefromnone'] = 'Не ховати';
$string['hidefromstudents'] = 'Сховати від студентів';
$string['hookcallbacknotcallable'] = 'Цей зворотній виклик неможливий. Це може бути тому, що клас або метод не існує, або тому, що метод не є публічним.';
$string['hookcallbacks'] = 'Callbacks (Зворотній виклик)';
$string['hookcallbacks_help'] = 'Список зворотних викликів, які будуть викликані, коли буде відправлено хук.
Показаний порядок — це порядок виклику зворотних викликів.
Зворотний виклик із вищим пріоритетом буде викликано перед викликом із нижчим пріоритетом.';
$string['hookclassmissing'] = 'Клас підключення не знайдено';
$string['hookclassmissing_desc'] = 'Агент виявлення хуків повернув клас, який не існує.';
$string['hookconfigoverride'] = 'Перевизначено';
$string['hookconfigoverride_help'] = 'Визначення цього зворотного виклику було замінено у файлі конфігурації сайту config.php';
$string['hookdeprecates'] = 'Застарілі зворотні виклики lib.php';
$string['hookdescription'] = 'Опис';
$string['hookdescriptionmissing'] = 'Хук не має методу опису';
$string['hookname'] = 'Хук';
$string['hooksoverview'] = 'Огляд хуків';
$string['hookunknown'] = 'Хук не знайдено';
$string['hookunknown_desc'] = 'Об’єкт, який прослуховує цей зворотній виклик, недоступний. Можливо, його було видалено чи перейменовано, або він може бути недоступним у цій версії Moodle.';
$string['hostname'] = 'Ім\'я хоста';
$string['htmleditor'] = 'HTML редактор';
$string['htmleditorsettings'] = 'Налаштування HTML редактора';
$string['htmlsettings'] = 'HTML налаштування';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP безпека';
$string['iconvrequired'] = 'Потрібне встановлене розширення ICONV.';
$string['igbinary322buggyversion'] = 'Встановлене на сайті розширення php-igbinary може призвести до проблем під час роботи з PHP 7.2. Рекомендується або оновити до php-igbinary 3.2.5 або пізнішої версії, або оновити до PHP 7.3 або новішої.';
$string['ignore'] = 'Ігнорувати';
$string['includemoduleuserdata'] = 'Включити модуль даних користувача';
$string['incompatibleblocks'] = 'Несумісні блоки';
$string['incompleteunicodesupport'] = 'Поточна установка MySQL або MariaDB використовує utf8. Цей набір символів не підтримує чотири байтових символи, які містять деякі смайли. Спроба використовувати ці символи призведе до помилки при оновленні запису, і будь-яка інформація, що надсилається до бази даних, буде втрачена. Будь ласка, подумайте про те, щоб змінити налаштування на utf8mb4. Докладнішу інформацію див. У документації.';
$string['indexdata'] = 'Дані індекса';
$string['indexinginfo'] = 'Рекомендований спосіб індексування вмісту вашого сайту здійснюється за допомогою планового завдання індексування глобального пошуку.';
$string['installhijacked'] = 'Інсталяція повинна бути завершена з тієї ІР-адреси, з якої розпочиналася.';
$string['installsessionerror'] = 'Не вдається ініціалізувати сеанс PHP. Будь ласка, переконайтеся, що ваш браузер приймає файли cookie.';
$string['intlrecommended'] = 'Розширення Intl використовується для підтримки інтернаціоналізації, наприклад, правильного сортування в інших мовах.';
$string['intlrequired'] = 'Intl розширення є необхідним для поліпшення підтримки інтернаціоналізації, наприклад, для сортування та локалізації доменів.';
$string['invalidagedigitalconsent'] = 'Цифровий вік згоди недійсний: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL забутого пароля не є дійсним URL.';
$string['invalidsection'] = 'Неправильна секція';
$string['invalidthemepreset'] = 'Вибраний файл попереднього налаштування несумісний з цією темою. Помилка компіляції SCSS: "{$a}"';
$string['invaliduserchangeme'] = 'Користувач "changeme" є зарезервованим - ви не повинні створювати користувача з подібним псевдоім’ям.';
$string['ipblocked'] = 'Цей сайт не доступний в даний час.';
$string['ipblocker'] = 'IP-блокатор';
$string['ipblockersyntax'] = 'Розмістіть кожен запис в одному рядку. Дійсними записами є повна IP-адреса (наприклад, 192.168.10.1), яка відповідає одному хосту; або часткову адресу (наприклад, <b>192.168</b>), яка відповідає будь-якій адресі, що починається з цих чисел; або позначення CIDR (наприклад, <b>231.54.211.0/20</b>); або діапазон IP-адрес (наприклад, <b>231.3.56.10-20</b>), де діапазон застосовується до останньої частини адреси. Текстові доменні імена (наприклад, \'example.com\') не підтримуються. Порожні рядки та текст після символу "#" ігноруються.';
$string['iplookup'] = 'Пошук ІР-адреси';
$string['iplookupgeoplugin'] = 'Служба <a href="http://www.geoplugin.com">geoPlugin</a> наразі використовується для пошуку географічної інформації. Для більш точних результатів ми рекомендуємо встановити локальну копію бази даних MaxMind GeoLite.';
$string['iplookupinfo'] = 'Безкоштовний онлайн-сервер NetGeo використовується для пошуку IP-адрес. Однак база даних більше не підтримується і може повертати неправильні дані. Рекомендується встановити локальну копію безкоштовної бази даних GeoLite2 City від MaxMind. Якщо надано ключ Google Maps API V3, розташування IP-адреси відображається за допомогою Google Maps. Вам потрібен обліковий запис Google і заявка на отримання ключа Google Maps API. Якщо ключ Google Maps API V3 не надано, розташування IP-адреси відображається за допомогою OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Цей продукт містить дані GeoLite2, створені MaxMind, доступні з
 <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Виявлено, що на вашому сайті використовується спеціальний каталог адміністратора. Ця функція більше не підтримується і буде вилучена після Moodle 4.2.';
$string['ishttpswarning'] = 'Виявлено, що ваш сайт не захищений за допомогою HTTPS. Настійно рекомендується перенести свій сайт на HTTPS для підвищення безпеки та поліпшення інтеграції з іншими системами.';
$string['keeptagnamecase'] = 'Зберігати регстр назви мітки';
$string['lang'] = 'Типова мова';
$string['langcache'] = 'Кеш мовного меню';
$string['langcache_desc'] = 'Кеш мовного меню. Якщо включено, то список доступних перекладів кешується. Кеш автоматично оновлюється, коли ви встановлюєте або видаляєте мовний пакет через вбудований інструментарій керування пакунками. Якщо ви встановлюєте новий мовний пакет вручну, вам потрібно використовувати функцію очищення всіх кешей для оновлення мовного списку.';
$string['langlist'] = 'Мови у мовному меню';
$string['langmenu'] = 'Показати мовне меню';
$string['langmenuinsecurelayout'] = 'Відображення меню мови у захищеному макеті';
$string['langmenuinsecurelayout_desc'] = 'Якщо ввімкнено, користувач зможе змінити мову під час проходження опитування чи іншої діяльності використовуючи захищений макет.';
$string['langpackwillbeupdated'] = 'Для перекладачів: В процесі оновлення Moodle спробує оновити ваш мовний пакет. Зміни у каталозі вашого не локального мовного пакету будуть перезаписані.';
$string['langstringcache'] = 'Кешувати всі мовні змінні';
$string['languagesettings'] = 'Установки';
$string['latinexcelexport'] = 'Excel кодування';
$string['legacyfilesaddallowed'] = 'Дозволити додавання до файлів курсу (застарілого сховища)';
$string['legacyfilesaddallowed_help'] = 'Якщо в курсі присутнє сховище Файли курсу (застаріле і не рекомендується до використання), дозволяє записувати в нього нові файли та теки.';
$string['legacyfilesinnewcourses'] = 'Застаріле сховище файлів в нових курсах';
$string['legacyfilesinnewcourses_help'] = 'Типово область спадкових файлів курсу доступна тільки в оновлених курсах. Будь ласка, зверніть увагу на деякі особливості, як то єдина активація резервування та відновлення не підтримується цим налаштуванням.';
$string['libcurlwarning'] = 'Виявлено, що libcurl не має підтримки CURLOPT_PROTOCOL. З міркувань безпеки рекомендується встановити сучасний libcurl.';
$string['licensesettings'] = 'Налаштування ліцензії';
$string['linkadmincategories'] = 'Посилання на керування категоріями';
$string['linkadmincategories_help'] = 'При включеному параметрі налаштування категорій буде показуватися у навігації як посилання на сторінку керування категоріями.';
$string['linkcoursesections'] = 'Завжди пов’язувати секції курсу';
$string['linkcoursesections_help'] = 'Завжди намагатися забезпечити зв’язок секцій курсу. Секції курсу зазвичай показуються як посилання, якщо в курсі задіяно формат однієї секції на сторінку. Якщо цей параметр включено, то завжди буде створюватися посилання.';
$string['loading'] = 'Завантаження';
$string['localetext'] = 'Глобальна мова сайту';
$string['localstringcustomization'] = 'Локальний мовний пакет';
$string['location'] = 'Локалізація';
$string['locationsettings'] = 'Установки локалізації';
$string['locked'] = 'закрито';
$string['lockoutduration'] = 'Тривалість блокування облікового запису';
$string['lockoutduration_desc'] = 'Обліковий запис буде розблоковано автоматично після вказаного періоду.';
$string['lockoutemailbody'] = 'Ваш обліковий запис з псевдоім’ям {$a->username} на сервері \'{$a->sitename}\' було заблоковано після декількох невдалих спроб входу в систему.

Для швидкого розблокування цього облікового запису вам потрібно перейти за наступною адресою

{$a->link}.

У більшості поштових програм, це має виглядати гіперпосилання, на яке ви можете просто натиснути для переходу. Якщо це не спрацьовує, то скопіюйте посилання та вставте його в адресний рядок вашого веб-переглядача (Firefox, Opera, Chrome).

Якщо вам потрібна допомога, будь ласка, зв’яжіться з адміністратором,  {$a->admin}.';
$string['lockoutemailsubject'] = 'Ваш обліковий запис на  {$a}  було заблоковано';
$string['lockouterrorunlock'] = 'Надано неправильну інформацію для розблокування облікового запису.';
$string['lockoutthreshold'] = 'Кількість невдалих спроб входу перед блокуванням';
$string['lockoutthreshold_desc'] = 'Вкажіть кількість некоректних спроб входу на сайт до блокування облікового запису. Ця функція може бути застосована для зловживання атаками на відмову в обслуговуванні.';
$string['lockoutwindow'] = 'Термін нагляду за кількість невдалих спроб перед блокуванням';
$string['lockoutwindow_desc'] = 'Термін нагляду за межею для блокування. Якщо немає невдалих спроб, що перевищують межу, лічильник скидається після вказаного часу.';
$string['lockrequestcategory'] = 'Запобігти вибору категорії';
$string['log'] = 'Журнал подій';
$string['logguests'] = 'Журнал доступу гостей';
$string['logguests_help'] = 'Цей параметр дозволяє протоколювання дій гостьового облікового запису. Сайтам з великим навантаженням може знадобитися відключити цю реєстрації з причин продуктивності. Рекомендується, щоб ця установка включена на діючих сайтах.';
$string['logininfoinsecurelayout'] = 'Відображення зареєстрованого користувача у захищеному макеті';
$string['logininfoinsecurelayout_desc'] = 'Якщо ввімкнено, повне ім’я користувача, який увійшов у систему, буде відображатися на панелі навігації під час спроби тесту чи іншої діяльності з використанням безпечного макета.';
$string['loginpageautofocus'] = 'Автофокус на псевдоімені';
$string['loginpageautofocus_help'] = 'Включення цієї опції покращує зручність роботи зі сторінкою входу, але повинно бути розглянуто з питання доступності.';
$string['loglifetime'] = 'Зберігати записи журналу до';
$string['logo'] = 'Логотип';
$string['logo_desc'] = 'Повний логотип, який використовуватиметься як прикраса для деяких тем (наприклад, основних тем). Це зображення може мати досить високу роздільну здатність, оскільки воно буде зменшено для використання (і кешовано для продуктивності). Логотипи, ширші за висоту, зазвичай дають кращі результати.';
$string['logocompact'] = 'Компактний логотип';
$string['logocompact_desc'] = 'Компактна версія того самого логотипу, що й вище, наприклад емблема, щит або значок. Зображення повинно бути чітким навіть при невеликих розмірах.';
$string['logossettings'] = 'Логотипи';
$string['logstorenotrequired'] = 'Журнал не вимагається';
$string['logstoressupported'] = 'Журнали, з яких створюється цей звіт';
$string['longtimewarning'] = '<b>Зверніть увагу, що цей процес може зайняти деякий час.</b>';
$string['mailnewline'] = 'Символи нового рядка в листах';
$string['maintenancemode'] = 'В режимі обслуговування';
$string['maintenancemodeisscheduled'] = 'Сайт перейде в режим обслуговування через {$a} хв.';
$string['maintenancemodeisscheduledlong'] = 'Цей сайт буде переведений на режим обслуговування через {$a->hour} год. {$a->min} хв {$a->sec} сек';
$string['maintfileopenerror'] = 'Помилка при відкритті файлів, які обслуговуються!';
$string['maintinprogress'] = 'Обслуговування триває...';
$string['managecontextlock'] = 'Заморозити цей контекст';
$string['managecontextlocklocked'] = '{$a->contextname} та будь-які нижчі контексти тепер заморожені.';
$string['managecontextlockunlocked'] = '{$a->contextname} і будь-які нижчі контексти тепер розморожені.';
$string['managecontextunlock'] = 'Розморозити цей контекст';
$string['managecustomfields'] = 'Керуйте користувацькими типами полів';
$string['manageformats'] = 'Управління форматами';
$string['manageformatsgotosettings'] = 'Типовий формат можна змінити на  {$a}';
$string['managelang'] = 'Керування';
$string['manageqbanks'] = 'Керуйте плагінами банку запитань';
$string['manageqbehaviours'] = 'Управління поведінкою питань';
$string['manageqtypes'] = 'Управління типами питань';
$string['maturity100'] = 'Бета';
$string['maturity150'] = 'Кандидат в реліз';
$string['maturity200'] = 'Стабільна версія';
$string['maturity50'] = 'Альфа';
$string['maturityallowunstable'] = 'Підказка: ви можете запустити цей скрипт в тестовому режимі з параметром --allow-unstable';
$string['maturitycoreinfo'] = 'Наразі ваш сайт запущено на нестабільному "{$a}" коді.';
$string['maturitycorewarning'] = 'Ви намагаєтеся встановити чи оновити Moodle, версія якого має позначку "{$a}", що не рекомендується для повноцінно функціонуючих сайтів. Будь ласка, впевніться, що ви робите це осмислено та маєте правильні програмні коди Moodle.';
$string['maxbytes'] = 'Максимальний обсяг завантажуваних файлів';
$string['maxconsecutiveidentchars'] = 'Послідовність однакових символів';
$string['maxeditingtime'] = 'Максимальний час для редагування повідомлення';
$string['maxsizeperdownloadcoursefile'] = 'Максимальний розмір файлу';
$string['maxsizeperdownloadcoursefile_desc'] = 'Максимальний розмір кожного файлу під час завантаження вмісту курсу. Файли, що перевищують цей розмір, будуть вилучені з завантаження.';
$string['maxtimelimit'] = 'Максимальний час виконання';
$string['maxtimelimit_desc'] = 'Щоб обмежити максимальний час виконання скриптів PHP, що дозволить Moodle не відображати будь-які повідомлення, введіть значення в секундах тут. 0 означає, що Moodle використовуватиме типові обмеження. Якщо у вас є зовнішній сервер з власним терміном, встановіть це значення нижче, щоб отримувати повідомлення про помилки PHP в журналах. Не застосовується до консольних скриптів (CLI).';
$string['maxusersperpage'] = 'Максимум користувачів на сторінку';
$string['mbstringrecommended'] = 'Установка необов\'язкової бібліотеки MBSTRING наполегливо рекомендується для поліпшення продуктивності сайту, особливо якщо ваш сайт підтримує нелатинські мови.';
$string['mbstringrequired'] = 'Щоб підвищити продуктивність сайту, потрібно встановити бібліотеку MBSTRING, особливо якщо ваш сайт підтримує нелатинські мови.';
$string['mediapluginavi'] = 'Включити .avi фільтр';
$string['mediapluginflv'] = 'Включити .flv фільтр';
$string['mediapluginimg'] = 'Включити авто-вкладення зв’язаних картинок';
$string['mediapluginmov'] = 'Включити .mov фільтр';
$string['mediapluginmp3'] = 'Включити .mp3 фільтр';
$string['mediapluginmpg'] = 'Включити .mpg фільтр';
$string['mediapluginogg'] = 'Включити .ogg фільтр';
$string['mediapluginogv'] = 'Включити .ogv фільтр';
$string['mediapluginram'] = 'Включити .ram фільтр';
$string['mediapluginrm'] = 'Включити .rm фільтр';
$string['mediapluginrpm'] = 'Включити .rpm фільтр';
$string['mediapluginswf'] = 'Включити .swf фільтр';
$string['mediapluginswfnote'] = 'Типові заходи безпеки не дозволяють звичайним користувачам вбудовувати флеш-файли формату swf.';
$string['mediapluginwmv'] = 'Включити .wmv фільтр';
$string['mediapluginyoutube'] = 'Включити YouTube фільтр';
$string['messaging'] = 'Включити систему повідомлень';
$string['messagingallowemailoverride'] = 'Нехтувати повідомленнями ел.пошти';
$string['messagingallusers'] = 'Дозволити обмін повідомленнями на всьому сайті';
$string['messagingcategory'] = 'Обмін повідомленнями';
$string['messagingdefaultpressenter'] = 'Використовуйте Enter, щоб відправка ввімкнена за замовчуванням';
$string['messagingdeleteallnotificationsdelay'] = 'Видалити всі сповіщення';
$string['messagingdeletereadnotificationsdelay'] = 'Видаляти прочитані повідомлення';
$string['messagingssettings'] = 'Налаштування обміну повідомленнями';
$string['minpassworddigits'] = 'Цифр';
$string['minpasswordlength'] = 'Довжина паролю';
$string['minpasswordlower'] = 'Нижнього регістра';
$string['minpasswordnonalphanum'] = 'Не алфавітних символів';
$string['minpasswordupper'] = 'Верхнього регістра';
$string['misc'] = 'Різне';
$string['mlbackendsettings'] = 'Налаштування серверної частини машинного навчання';
$string['mnetrestore_extusers'] = '<strong>Зверніть увагу:</strong> Даний файл резервної копії містить дані про віддалених користувачів мережі Moodle, які будуть поновлені як частина процесу.';
$string['mnetrestore_extusers_admin'] = '<strong>Примітка:</strong> Здається ця резервна копія складається з різних інсталяцій та вміщує дані про віддалених користувачів Мережі Moodle. При відновленні система спробує відновити зв\'язок зі всіма віддаленими користувачами. Автоматичного переключення на локальні ресурси не відбувається. При відновленні про це також буде повідомлено.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Зверніть увагу:</strong> Даний файл резервної копії очевидно належить до іншої інсталяції Мудл та містить дані про віддалених користувачів мережі Мудл, які не можуть бути відновлені. Ця операція не підтримується. Якщо ви впевнені, що ця резервна копія створена в даній інсталяції та має всі потрібно установки, то можете спробувати провести відновлення.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Примітка:</strong> Здається ця резервна копія складається з різних інсталяцій та вміщує дані про віддалених користувачів Мережі Moodle. У вас не має прав для відновлення резервних копій такого виду. Зверніться до адміністратора за допомогою, або відновіть курс без інформації про користувачів (оцінки, файли, повідомлення...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Користувач Мережі Moodle {$a->username} (прийшов з {$a->mnethosturl}) переключений на локального {$a->auth} аутентифікованого користувача.';
$string['mobilenotconfiguredwarning'] = 'Moodle Mobile не ввімкнено.';
$string['modassignmentinuse'] = 'На вашому сайті досі використовується плагін Assignment 2.2. Перед оновленням ви повинні 1) створити резервну копію будь-яких дій Призначення 2.2, які ви хочете зберегти, і відновити їх як дії Призначення, і 2) видалити всі дані Призначення 2.2 із бази даних.';
$string['modassignmentsubpluginsexist'] = 'Завдання 2.2. можуть бути присутні підплагіни. Перед оновленням потрібно видалити папку mod/assignment і всі її вкладені модулі.';
$string['modeditdefaults'] = 'Типові значення для налаштування діяльностей';
$string['modsettings'] = 'Управління діяльностями';
$string['modulesecurity'] = 'Безпека модулів';
$string['moodleapp'] = 'Додаток Moodle';
$string['moodleapp_help'] = '<p>Безкоштовний додаток Moodle надає користувачам доступ до своїх курсів на мобільних пристроях. Додаткові функції програми доступні в плані програми Pro або Premium. </p>
<a href="https://moodle.com/mobile-app">Завантажте додаток Moodle </a><br />
<a href="https://apps.moodle.com">Портал додатків Moodle</a>';
$string['moodlebrandedapp'] = 'Фірмова програма Moodle';
$string['moodlebrandedapp_help'] = 'Додаток Branded Moodle має всі функції нашого безкоштовного мобільного додатка для Moodle у поєднанні з вашим власним брендом. <a href="https://moodle.com/branded-app/">Про додаток Branded Moodle</a>';
$string['moodlebrandedappreference'] = 'Крім того, придбайте  <a href="https://moodle.com/branded-app/">фірмовий додаток Moodle</a> зі своїм власним брендом.';
$string['moodlepartners'] = 'Партнери Moodle';
$string['moodlepartners_help'] = '<p>Партнери Moodle - це постачальники сервісів, які сертифіковано Moodle HQ (штаб-картирою), що надають високоякісні сервіси онлайн начального середовища Moodle для Вашого організації.</p> <a href="https://moodle.com/about-partners/">Про наших партнерів</a><br /> <a href="https://moodle.com/partners">Знайти партнера</a>';
$string['moodleservices'] = 'Moodle сервіси';
$string['moodleservices_help'] = 'Переконайтеся, що отримуєте максимальну користь із середовища навчання Moodle використовуючи сервіси Moodle:';
$string['multilangforceold'] = 'Викликати старий синтаксис багатомовності: &lt;span&gt; без class="multilang" та &lt;lang&gt;';
$string['mustenablestats'] = 'Статистика поки-що не дозволена на цьому сайті.';
$string['mycourses'] = 'Мої курси';
$string['mycoursesperpage'] = 'Максимальна кількість курсів';
$string['mydashboard'] = 'Типова системна інформаційна панель';
$string['mymoodle'] = 'Особистий кабінет';
$string['mymoodleredirect'] = 'Зобов\'язати користувачів користуватися сервісом Мій Moodle';
$string['mypage'] = 'Типовий особистий кабінет';
$string['mypagelocked'] = 'Закрити типову сторінку';
$string['myprofile'] = 'Типова сторінка профайлу';
$string['navadduserpostslinks'] = 'Додати посилання для перегляду користувачем повідомлень';
$string['navadduserpostslinks_help'] = 'Якщо включено, то буде додано по два посилання для кожного користувача в навігації, щоб мати можливість переглянути дискусії, які користувач почав, та повідомлення, які користувач робив у форумах на сайті або у вказаних курсах.';
$string['navcourselimit'] = 'Обмеження курсу';
$string['navigationupgrade'] = 'Це оновлення вводить два нових блоки навігації, які будуть заміняти такі блоки: Керування, Курси, Діяльності та Люди. Якщо у вас безліч спеціальних дозволів на ці блоки, ви повинні перевірити та переконатися, що всі вони ведуть себе так, як ви цього хочете.';
$string['navshowallcourses'] = 'Показати всі курси';
$string['navshowcategories'] = 'Показати категорії курсів';
$string['navshowfrontpagemods'] = 'Показати домашню діяльність сайту в навігації';
$string['navshowfrontpagemods_help'] = 'Якщо ввімкнено, домашні дії на сайті відображатимуться на навігації під сторінками сайту. Цей параметр застосовується лише до тем на основі класичної версії.';
$string['navshowfullcoursenames'] = 'Показати повну назву курсу';
$string['navshowfullcoursenames_help'] = 'Якщо включено, то курси в навігаційному рядку будуть показані з використанням їх повної назви замість короткої.';
$string['navshowmycoursecategories'] = 'Показувати категоріїв Моїх курсах';
$string['navshowmycoursecategories_help'] = 'Якщо ввімкнено, курси у гілці Мої курси користувача відображатимуться в категоріях у блоці навігації (тільки класичні теми).';
$string['navsortmycourseshiddenlast'] = 'Відсортуйте мої приховані курси останнім';
$string['navsortmycourseshiddenlast_help'] = 'Якщо ввімкнено, усі приховані курси відображатимуться після видимих курсів (для користувачів, які можуть переглядати приховані курси). В іншому випадку всі курси, незалежно від їх видимості, відображатимуться відповідно до параметра «Сортувати мої курси».';
$string['navsortmycoursessort'] = 'Сортувати мої курси';
$string['navsortmycoursessort_help'] = 'Визначає, як на сторінці Моя домашня будуть відображатися (сортуватися) курси. Типово використовується - ручне сортування.';
$string['never'] = 'Ніколи';
$string['neverdeleteruns'] = 'Ніколи не видаляти робочі';
$string['newestdocindexed'] = 'Новий документ індексується';
$string['nobookmarksforuser'] = 'У вас немає ніяких закладок.';
$string['nodatabase'] = 'Немає бази даних';
$string['nohttpsformobilewarning'] = 'Рекомендується включити HTTPS з чинним сертифікатом. Moodle в першу чергу завжди намагатиметься використовувати захищене з\'єднання.';
$string['nomissingstrings'] = 'Всі рядки заповнені';
$string['none'] = 'Нічого';
$string['nonewsettings'] = 'Ніяких нових установок не було додано в процесі цієї модернізації.';
$string['nonexistentbookmark'] = 'Такої закладки не існує.';
$string['noreplyaddress'] = 'Адреса, на яку "не відповідати"';
$string['noreplydomain'] = 'Домен без відповіді';
$string['noreplydomaindetail'] = 'Налаштування доменів без відповіді та налаштованих доменів';
$string['noresults'] = 'Пошук не дав результату.';
$string['noroles'] = 'Немає ролей';
$string['nosupportedlogstore'] = 'Знайдено непідтримуваний журнал';
$string['noteunneededblocks'] = 'Примітка: блоки, налаштовані на показ, не будуть перераховані в меню «Додати блок» курсу, якщо вони вказані в налаштуваннях теми «Непотрібні блоки».';
$string['notifications'] = 'Повідомлення';
$string['notifyloginfailures'] = 'Повідомити про невдале входження';
$string['notifyloginthreshold'] = 'Обмеження в електронних повідомленнях';
$string['notloggedinroleid'] = 'Роль для відвідувачів';
$string['numberofmissingstrings'] = 'Число відсутніх рядків: {$a}';
$string['numberofstrings'] = 'Загальне число рядків: {$a->strings}<br />відсутніх: {$a->missing} ({$a->missingpercent}  %)';
$string['oauthrefreshtokenexpired'] = 'Маркер оновлення для одного з служб OAuth {$a->issuer} на вашому сайті {$a->siteurl} закінчився. Це обмежить функціональність будь-яких плагінів, які використовують цю службу. Щоб усунути цю проблему, перейдіть на сторінку налаштування служб OAuth 2 і натисніть значок "Підключити системний обліковий запис" у рядку таблиці для цієї служби. Обов\'язково щоразу ввійдіть, використовуючи той самий обліковий запис служби для системи OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'Маркер оновлення OAuth закінчився для {$a->issuer} на вашому сайті {$a->siteurl}.';
$string['onlynoreply'] = 'Тільки тоді, коли з адреси без відповіді';
$string['opcacherecommended'] = 'Кешування PHP з opcode caching підвищує продуктивність і знижує вимоги до пам\'яті, розширення OPcache рекомендується і повністю підтримується.';
$string['opensslrecommended'] = 'Рекомендується встановити основні бібліотеки OpenSSL - це дозволить функціонування мережевої розподіленості Мудл.';
$string['opensslrequired'] = 'Розширення OpenSSL PHP тепер вимагає Moodle для надання більш потужних криптографічних послуг.';
$string['opentowebcrawlers'] = 'Відкрити для Google';
$string['optionalmaintenancemessage'] = 'Необов’язкове повідомлення при обслуговуванні';
$string['order1'] = 'Перший';
$string['order2'] = 'Другий';
$string['order3'] = 'Третій';
$string['order4'] = 'Четвертий';
$string['outgoingmailconfig'] = 'Конфігурація вихідної пошти';
$string['overridetossl'] = 'HTTPS для входу вже застаріли. Цей примірник тепер примушений до SSL. Щоб виправити це попередження, змініть ваш wwwroot в config.php на https://';
$string['pageinfodebugsummary'] = 'Ця сторінка: {$a}';
$string['passwordchangelogout'] = 'Вийти після зміни пароля';
$string['passwordchangelogout_desc'] = 'Якщо включено, то при зміні пароля, всі сеанси браузера припиняються, крім того, де було вказано новий пароль. (Цей параметр не впливає на зміну пароля через гуртові завантаження користувачів.)';
$string['passwordchangetokendeletion'] = 'Видалення маркерів доступу до веб-служб після зміни пароля';
$string['passwordchangetokendeletion_desc'] = 'Якщо ввімкнено, коли пароль змінюється, всі маркери доступу до веб-служб користувача видаляються.';
$string['passwordpolicy'] = 'Політика паролів';
$string['passwordpolicycheckonlogin'] = 'Перевірте пароль під час входу';
$string['passwordresettime'] = 'Максимальний час для підтвердження відновлення пароля';
$string['passwordreuselimit'] = 'Обмеження зміни пароля';
$string['passwordreuselimit_desc'] = 'Визначає скільки разів, користувач повинен змінити свій пароль, перш ніж він може повторно використовувати старий пароль. Хеши раніше використаних паролів зберігаються в локальній таблиці бази даних. Ця функція може бути несумісна з деякими зовнішніми модулями аутентифікації.';
$string['pathtodot'] = 'Шлях до dot';
$string['pathtodot_help'] = 'Шлях до точки. У Linux це щось на кшталт /usr/bin/dot. У Windows це щось на кшталт C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. На Mac це щось на кшталт /opt/local/bin/dot. Щоб мати можливість генерувати графіку з файлів DOT, ви повинні встановити виконуваний файл dot і вказати на нього тут.';
$string['pathtodu'] = 'Шлях до du';
$string['pathtogs'] = 'Шлях до ghostscript';
$string['pathtogs_help'] = 'У більшості інсталяцій Linux це можна залишити як «/usr/bin/gs». У Windows це буде щось на кшталт "c:\\gs\\bin\\gswin32c.exe" (переконайтеся, що в шляху немає пробілів - за потреби скопіюйте файли "gswin32c.exe" і "gsdll32.dll" в нову папку без пробілу на шляху)';
$string['pathtopdftoppm'] = 'Шлях до pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> — це бібліотека візуалізації PDF, яка включає інструмент pdftoppm для перетворення файлів PDF у PNG. Продуктивність, як правило, краща, ніж при використанні Ghostscript, особливо для великих файлів. Якщо доступний, pdftoppm буде використовуватися замість Ghostscript. У більшості інсталяцій Linux шлях можна залишити як /usr/bin/pdftoppm. В іншому випадку вам потрібно встановити poppler-utils або poppler пакет, залежно від вашого дистрибутива Linux. У Windows це забезпечується установками Cygwin.';
$string['pathtopgdump'] = 'Шлях до pg_dump';
$string['pathtopgdumpdesc'] = 'Це важливо ввести, якщо Ви маєте більше одного pg_dump у вашій системі (Наприклад, якщо встановлено більше однієї версії postgresql)';
$string['pathtopgdumpinvalid'] = 'Помилка в pg_dump - неправильний шлях або не має прав на запуск';
$string['pathtophp'] = 'Шлях до PHP CLI';
$string['pathtopsql'] = 'Шлях до psql';
$string['pathtopsqldesc'] = 'Це важливо ввести, якщо Ви маєте більше одного psql у вашій системі (Наприклад, якщо встановлено більше однієї версії postgresql)';
$string['pathtopsqlinvalid'] = 'Помилка в psql - неправильний шлях або не має прав на запуск';
$string['pathtopython'] = 'Шлях до Python';
$string['pathtopythondesc'] = 'Шлях до вашого файлу запуску Python (як Python2, так і Python3).';
$string['pathtosassc'] = 'Шлях до SassC';
$string['pathtosassc_help'] = 'Визначення місця розташування двійкової копії SassC перетворить компілятор SASS з реалізації PHP Moodle на SassC. Докладнішу інформацію див. У https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Дуже рекомендується використовувати розширення PHP PCRE, сумісне з символами Unicode.';
$string['perfdebug'] = 'Характеристика швидкодії';
$string['performance'] = 'Швидкодія';
$string['pgcluster'] = 'PostgreSQL Кластер';
$string['pgclusterdescription'] = 'Параметр версії/кластера PostgreSQL для операцій в командному рядку. Якщо у вас тільки один PostgreSQL у вашій системі, або ви не упевнені, що це так, залиште це поле порожнім';
$string['phpfloatproblem'] = 'Знайдено несподівану проблему обробки PHP за номера - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Ваш сайт було зареєстровано. Ви можете у будь-який час оновити ваші реєстраційні дані. Типово завдання "Реєстрація сайту" буде періодично оновлювати ваші дані.';
$string['pleaserefreshregistrationnewdata'] = 'Інформація про реєстрацію була змінена. Будь ласка, підтвердіть її, використовуючи кнопку "Оновити реєстрацію".';
$string['pleaserefreshregistrationunknown'] = 'Ваш сайт було зареєстровано, але дата реєстрації невідома. Будь ласка, оновіть ваші реєстраційні дані використовуючи кнопку "Оновити реєстрацію" або переконайтеся, що завдання "Реєстрація сайту" активоване, щоб ваші дані автоматично оновлювалися.';
$string['plugin'] = 'Модуль';
$string['plugin_disabled'] = '{$a} вимкнено.';
$string['plugin_enabled'] = '{$a} увімкнено.';
$string['plugins'] = 'Модулі';
$string['pluginscheck'] = 'Модуль перевірки залежностей';
$string['pluginscheckfailed'] = 'Не вдалося перевірити залежності для {$a->pluginslist}';
$string['pluginschecktodo'] = 'Ви повинні задовольнити всі вимоги модулів перед тим як продовжити процес встановлення цієї версії Moodle!';
$string['pluginsoverview'] = 'Огляд модулів';
$string['pluginsoverviewsee'] = 'Перегляньте <a href="{$a->url}">сторінку модулів</a> для детальнішої інформації.';
$string['policysettings'] = 'Параметри політики';
$string['privacy:metadata'] = 'Плагін адміністрування не зберігає жодних персональних даних.';
$string['privacyandpolicies'] = 'Конфіденційність і правила';
$string['privacysettings'] = 'Налаштування конфіденційності';
$string['profilecategory'] = 'Категорія';
$string['profilecategoryname'] = 'Назва категорії (має бути унікальна)';
$string['profilecategorynamenotunique'] = 'Така назва категорії вже використовується';
$string['profilecommonsettings'] = 'Загальні налаштування';
$string['profileconfirmcategorydeletion'] = '{$a} пол(е/ів) з даної категорії будуть переміщені в категорію вище (або нижче, якщо воно у головній).<br />Ви все ще бажаєте видалити цю категорію?';
$string['profileconfirmfielddeletion'] = 'В полі, яке ви видаляєте, є {$a} запис(ів).<br />Ви все ще бажаєте видалити це поле?';
$string['profilecreatecategory'] = 'Створити нову категорію профіля';
$string['profilecreatefield'] = 'Створіть нове поле профілю';
$string['profilecreatenewcategory'] = 'Створення нової категорії';
$string['profilecreatenewfield'] = 'Створення нового профільного поля \'{$a}';
$string['profiledefaultcategory'] = 'Інші поля';
$string['profiledefaultchecked'] = 'Типово Відмічено';
$string['profiledefaultdata'] = 'Типове значення';
$string['profiledeletecategory'] = 'Видалення категорії';
$string['profiledeletefield'] = 'Видалення поля';
$string['profiledescription'] = 'Опис поля';
$string['profiledscript'] = 'Цей скрипт було профільовано';
$string['profiledscriptview'] = 'Перегляд даних профілювання для цього скрипта';
$string['profileeditcategory'] = 'Редагування категорії: {$a}';
$string['profileeditfield'] = 'Редагування профільного поля: $a';
$string['profilefield'] = 'Поле';
$string['profilefieldcolumns'] = 'Символів';
$string['profilefieldispassword'] = 'Це поле з паролем?';
$string['profilefieldlink'] = 'Посилання';
$string['profilefieldlink_help'] = 'Щоб перетворити текст на посилання, введіть URL-адресу, яка містить $$, де $$ буде замінено текстом. Наприклад, щоб перетворити ідентифікатор Twitter на посилання, введіть https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Об’єкт посилання';
$string['profilefieldmaxlength'] = 'Обмеження символів';
$string['profilefieldmaxlength_help'] = 'Щоб використовувати це поле в налаштуваннях "Показати ідентифікатор користувача", обмеження має становити 255 символів або менше.';
$string['profilefieldrows'] = 'Рядків';
$string['profilefields'] = 'Поля профілю користувача';
$string['profilefieldsize'] = 'Показати розмір';
$string['profileforceunique'] = 'Дані повинні бути унікальні?';
$string['profileinvaliddata'] = 'Неправильне значення';
$string['profilelocked'] = 'Це поле закрите?';
$string['profilemenudefaultnotinoptions'] = 'Типове значення не відповідає жодному з можливого списку.';
$string['profilemenunooptions'] = 'Елементи списку не визначені';
$string['profilemenuoptions'] = 'Меню опцій (одна на лінію)';
$string['profilemenutoofewoptions'] = 'Ви повинні вказати хоча б два варіанти';
$string['profilename'] = 'Назва';
$string['profilenofieldsdefined'] = 'Поля не визначені';
$string['profilerequired'] = 'Це поле обов\'язкове?';
$string['profileroles'] = 'Видимі в профайлі ролі';
$string['profilesforenrolledusersonly'] = 'Профайли тільки для зареєстрованих користувачів';
$string['profileshortname'] = 'Коротка назва (має бути унікальна)';
$string['profileshortnameinvalid'] = 'This short name can only contain alphanumeric characters (letters and numbers) or underscore (_).';
$string['profileshortnamenotunique'] = 'Така коротка назва вже використовується';
$string['profilesignup'] = 'Показати установки сторінки?';
$string['profilespecificsettings'] = 'Спеціальне налаштування';
$string['profilevisible'] = 'Хто може бачити це поле?';
$string['profilevisible_help'] = '* Не видно – для приватних даних, які можуть переглядати лише адміністратори та менеджери
* Видно для користувача - для приватних даних, які можуть переглядати лише користувач і адміністратори
* Відображається для користувачів, викладачів та адміністраторів - приватні дані доступні лише користувачеві, адміністраторам та викладачам (у профілі курсу)
* Видно для всіх';
$string['profilevisibleall'] = 'Видиме всім';
$string['profilevisiblenone'] = 'Невидиме';
$string['profilevisibleprivate'] = 'Видиме для користувача';
$string['profilevisibleteachers'] = 'Відображається для користувачів, викладачів та адміністраторів';
$string['profiling'] = 'Профілювання';
$string['profilingallowall'] = 'Безперервне профілювання';
$string['profilingallowall_help'] = 'Якщо цей параметр включений, то в будь-який момент, ви можете використовувати PROFILEALL параметр у будь-якому місці (PGC), щоб включити профілювання для всіх виконуваних скриптів за життя сесії Moodle. Аналогічно, ви можете використовувати параметр PROFILEALLSTOP, щоб зупинити його.';
$string['profilingallowme'] = 'Селективне профілювання';
$string['profilingallowme_help'] = 'Якщо цей параметр включений, то вибірково, ви можете використовувати параметр PROFILEME в будь-якому місці (PGC) і профілювання для цього сценарію не відбудеться. Аналогічно, ви можете використовувати параметр DONTPROFILEME для запобігання профілювання відбудеться';
$string['profilingautofrec'] = 'Автоматичне профілювання';
$string['profilingautofrec_help'] = 'Зі зміною цього налаштування, деякі запити (випадкові, на основі зазначених частот - 1 з XXX) буде обрано і автоматично профільовано, та збережено результати для подальшого аналізу. Зверніть увагу, що цей спосіб профілювання має налаштування включити / виключити . Встановіть його в 0 для відключення автоматичного профілювання.';
$string['profilingenabled'] = 'Включити профілювання';
$string['profilingenabled_help'] = 'Якщо цей параметр включений, то профілювання буде доступне на цьому сайті і ви зможете визначити його поведінку з налаштування наступних варіантів.';
$string['profilingexcluded'] = 'Виключити з профілювання';
$string['profilingexcluded_help'] = 'Список URL-адрес (відокремлених комами або новим рядком, абсолютний пропуск wwwroot, викликані) URL-адрес, які будуть виключені з профілю, визначених параметром "Профілюйте ці".';
$string['profilingimportprefix'] = 'Префікс імпорту профілювання';
$string['profilingimportprefix_desc'] = 'Для полегшення виявлення, всі імпортовані профілювання запускатимуться з префіксом визначеним тут.';
$string['profilingincluded'] = 'Включити в профілювання';
$string['profilingincluded_help'] = 'Список URL-адрес (відокремлених комами або новим рядком, абсолютний пропуск wwwroot, викликані) URL-адрес, які будуть автоматично профільовані. Приклади: /index.php, /course/view.php. Також приймає * wildchar у будь-якій позиції. Приклади: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Зберігати працюючі профілювання';
$string['profilinglifetime_help'] = 'Вкажіть час, коли ви хочете зберегти інформацію про старі працюючі профілювання. Старі будуть видалятися періодично. Зауважимо, що це виключає будь-які профілювання позначені як "працююче посилання".';
$string['profilingslow'] = 'Повільні сторінки профілю';
$string['profilingslow_help'] = 'Якщо встановити мінімальний час у секундах, усі повільніші сторінки будуть профільовані. Будуть збережені лише профілі, які є повільнішими, ніж існуючий профіль для того самого сценарію. Встановіть 0, щоб вимкнути. Зауважте, що це стосується налаштувань виключення.';
$string['protectusernames'] = 'Захист імен користувачів';
$string['proxybypass'] = 'Хости без проксі';
$string['proxyfixunsafe'] = 'Виправити дзвінки без проксі';
$string['proxyhost'] = 'Адреса проксі';
$string['proxylogunsafe'] = 'Реєструйте непроксі-дзвінки';
$string['proxypassword'] = 'Пароль проксі';
$string['proxyport'] = 'Порт проксі';
$string['proxytype'] = 'Тип проксі';
$string['proxyuser'] = 'Користувач проксі';
$string['purgecaches'] = 'Повністю очистити кеш';
$string['purgecachesconfirm'] = 'Moodle може кешувати тему дизайну, javascript, мовні змінні, фільтрований текст, rss та багато інших програмних даних. Очищення кешу буде видаляти ці дані з сервера та тимчасових файлів браузера, так що ви можете бути впевнені, що бачите найновіші дані. Не існує ніякої небезпеки в очищенні кеша, але ваш сайт може здаватися повільнішим на деякий час, поки сервер і клієнт покладуть до кешу нову інформацію.';
$string['purgecachesfinished'] = 'Кеш повністю очищено.';
$string['purgecachesnoneselected'] = 'Виберіть один або кілька кешів для очищення';
$string['purgecachespage'] = 'Очистити кеші';
$string['purgefiltercache'] = 'Текстові фільтри';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Мовні рядки';
$string['purgemuc'] = 'Усі кеші MUC';
$string['purgeothercaches'] = 'Усі файли та інші кеш-пам’яті';
$string['purgeselectedcaches'] = 'Очистити вибрані кеші';
$string['purgeselectedcachesfinished'] = 'Вибрані кеші було очищено.';
$string['purgetemplates'] = 'Шаблони';
$string['purgethemecache'] = 'Теми';
$string['query'] = 'Запит';
$string['question'] = 'Питання';
$string['questionbehaviours'] = 'Поведінка питань';
$string['questioncwqpfscheck'] = 'Одне або кілька випадкових питань у тесті налаштовуються для вибору питань із суміші спільних і нерозділених категорій запитань. Перегляньте<a href="{$a->reporturl}"> звіт про випадкові запитання</a>  та <a href="{$a->docsurl}">документацію</a>.';
$string['questioncwqpfsok'] = 'Добре. Немає випадкових питань у ваших тестах, створених з відібраних вами питань з загальних і локальних категорій питань.';
$string['questiontype'] = 'Тип питання';
$string['questiontypes'] = 'Типи питань';
$string['quizattemptsupgradedmessage'] = 'У Moodle 2.1 було здійснено серйозну модернізацію запитань. Вдалося зберегти частину бази даних проведення пізніших оновлень. Перед початком оновленням до Moodle 2.7, це оновлення повинно бути завершено.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA секретний ключ';
$string['recaptchapublickey'] = 'ReCAPTCHA ключ сайту';
$string['referrernone'] = 'Браузер за замовчуванням';
$string['referrerpolicy'] = 'Політика щодо реферерів';
$string['referrerpolicydesc'] = 'Налаштуйте заголовок політики переходу, щоб він включався у відповіді з вашого сайту.';
$string['register'] = 'Зареєструйте свій сайт';
$string['registration'] = 'Реєстрація';
$string['registration_help'] = 'Зареєструвавшись:

* Ви отримуватимете сповіщення системи безпеки
* Ви можете активувати push-сповіщення для мобільних додатків зі свого сайту
* Ви робите свій внесок у нашу статистику Moodle про всесвітню спільноту';
$string['registrationwarning'] = 'Ваш сайт ще не зареєстровано';
$string['registrationwarningcontactadmin'] = 'Ваш сайт ще не зареєстрований. Повідомте свого адміністратора.';
$string['releasenoteslink'] = 'Для отримання інформації про дану версію Moodle дивіться онлайновий ресурс <a href="{$a}" target="_new">Відомості про випуск</a>';
$string['rememberuserlicensepref'] = 'Запам’ятайте налаштування ліцензії користувача';
$string['rememberuserlicensepref_help'] = 'Якщо ввімкнено, під час завантаження файлу в засобі вибору файлів попередньо вибирається остання ліцензія, вибрана користувачем. В іншому випадку попередньо вибрано ліцензію сайту за замовчуванням.';
$string['rememberusername'] = 'Запам’ятати мене';
$string['rememberusername_desc'] = 'Включіть, якщо ви бажаєте на постійно зберегти куки з псевдо доки користувач явно не вийде з системи. Постійна кука може бути небезпечною з погляду забезпечення приватності, якщо вона задіюється без відповідної згоди.';
$string['replacefrontsearch'] = 'Використовується для пошуку домашнього курсу на сайті';
$string['reportsmanage'] = 'Управління звітами';
$string['required'] = 'Вимагається';
$string['requiredentrieschanged'] = 'Примітка. Після оновлення налаштування "Потрібні записи перед переглядом" тепер застосовується до таких дій бази даних:{$a->text}';
$string['requiremodintro'] = 'Потрібен опис діяльності';
$string['requiremodintro_desc'] = 'Якщо включено, користувачі будуть змушені вводити опис для кожного виду діяльності.';
$string['requires'] = 'Залежності';
$string['resetindentation'] = 'Скинути відступи для всього сайту';
$string['resetindentation_help'] = 'Це видалить будь-які відступи, встановлені раніше для всіх курсів на сайті в {$a->format}.';
$string['resetindentation_title'] = 'Скинути відступи для всього сайту?';
$string['resetindentationsuccess'] = 'Скидання відступів.';
$string['restorecourse'] = 'Відновити курс';
$string['restorernewroleid'] = 'Роль для користувача, що відновив курс';
$string['restorernewroleid_help'] = 'Якщо користувач ще не має дозволу на управління нововідновленим курсом, то йому автоматично буде надано таку роль та при потребі зараховано на курс. Вкажіть "Порожньо", якщо ви не бажаєте відновлювати користувачів на ролі в курсі.';
$string['resultfilter'] = 'Відфільтрувати за результатом';
$string['reverseproxy'] = 'Реверсивний проксі';
$string['reverseproxyignore'] = 'Ігноруйте зворотні проксі';
$string['riskconfig'] = 'Користувачі можуть змінювати налаштування та поведінку сайту';
$string['riskconfigshort'] = 'Конфігураційний ризик';
$string['riskdataloss'] = 'Користувачі можуть знищити велику кількість контенту або інформації';
$string['riskdatalossshort'] = 'Ризик втрати даних';
$string['riskmanagetrust'] = 'Користувачі можуть змінювати довірчі установки для інших користувачів';
$string['riskmanagetrustshort'] = 'Управління довірчими відносинами';
$string['riskpersonal'] = 'Користувачі можуть отримувати доступ до приватної інформації інших';
$string['riskpersonalshort'] = 'Ризик приватності';
$string['riskspam'] = 'Користувачі можуть надсилати спам до користувачів сайту або в інші місця';
$string['riskspamshort'] = 'Ризик спаму';
$string['riskxss'] = 'Користувачі можуть додавати файли та текст, що вміщують cross-site scripting (XSS)';
$string['riskxssshort'] = 'Ризик XSS';
$string['roleswithexceptions'] = '{$a->roles}, з {$a->exceptions}';
$string['rssglobaldisabled'] = 'Вимкнено на рівні сайту';
$string['save'] = 'Зберегти';
$string['savechanges'] = 'Зберегти зміни';
$string['scssinvalid'] = 'Код SCSS недійсний, збій з: {$a}';
$string['search'] = 'Пошук';
$string['searchablecourses'] = 'Курси з можливістю пошуку';
$string['searchallavailablecourses'] = 'Пошукові курси';
$string['searchallavailablecourses_desc'] = 'У деяких ситуаціях пошукова система може не працювати при пошуку по великій кількості курсів. Встановіть пошук лише зареєстрованих курсів, якщо вам потрібно обмежити кількість пошукових курсів.';
$string['searchallavailablecourses_off'] = 'Шукати тільки в зареєстрованих курсах';
$string['searchallavailablecourses_on'] = 'Пошук у всіх курсах, до яких користувач може отримати доступ';
$string['searchallavailablecoursesdesc'] = 'Якщо налаштовано пошук лише в межах зареєстрованих курсів, інформація про курс (назва та підсумок) та вміст курсу будуть шукатися лише в курсах, на яких зарахований користувач. В іншому випадку інформація про курс та вміст курсу буде шукатися у всіх курсах, до яких користувач може отримати доступ , наприклад курси з увімкненим гостьовим доступом.';
$string['searchalldeleted'] = 'Всі індексовані вміст видалено';
$string['searchalternatesettings'] = 'Альтернативні налаштування лише для запитів';
$string['searchalternatesettings_desc'] = 'Якщо ви виконали ці налаштування, ви можете вибрати «альтернативні налаштування» для цієї пошукової системи в опції пошукової системи лише для запитів на сторінці «Керувати глобальним пошуком». Це корисно лише при переміщенні між двома пошуковими системами одного типу.';
$string['searchareadisabled'] = 'Вимкнена область пошуку';
$string['searchareaenabled'] = 'Область пошуку включена';
$string['searchareas'] = 'Пошук областей';
$string['searchbanner'] = 'Пошук інформації';
$string['searchbannerenable'] = 'Відобразити пошукову інформацію';
$string['searchbannerenable_desc'] = 'Якщо ввімкнено, наведений нижче текст відображатиметься у верхній частині екрана пошуку для всіх користувачів. Це можна використовувати для інформування користувачів, коли виконується технічне обслуговування пошукової системи.';
$string['searchdefaultcategory'] = 'Категорія пошуку за замовчуванням';
$string['searchdefaultcategory_desc'] = 'Результати з вибраної категорії області пошуку відображатимуться за замовчуванням.';
$string['searchdeleteindex'] = 'Видалити весь індексований вміст';
$string['searchdisplay'] = 'Параметри відображення результатів пошуку';
$string['searchenablecategories'] = 'Відображати результати в окремих категоріях';
$string['searchenablecategories_desc'] = 'Якщо ввімкнено, результати пошуку відображатимуться в окремих категоріях.';
$string['searchengine'] = 'Пошукова система';
$string['searchenginealternatesettings'] = '{$a} (альтернативні налаштування)';
$string['searchenginequeryonly'] = 'Пошукова система лише за запитами';
$string['searchenginequeryonly_desc'] = 'Ця пошукова система буде використовуватися лише для створення запитів, а не для індексації. Використовуючи цю функцію, ви можете переіндексувати в іншій пошуковій системі, тоді як запити користувачів продовжують працювати з цієї.';
$string['searchenginequeryonly_none'] = 'Немає (використовуйте основну пошукову систему для запитів)';
$string['searchenginequeryonlysame'] = 'Не можна встановити одне значення для пошукової системи лише для запитів і для основної пошукової системи.';
$string['searchhideallcategory'] = 'Приховати категорію всіх результатів';
$string['searchhideallcategory_desc'] = 'Якщо позначено, категорія з усіма результатами буде прихована на екрані результатів пошуку.';
$string['searchincludeallcourses'] = 'Включіть усі видимі курси';
$string['searchincludeallcourses_desc'] = 'Якщо ввімкнено, результати пошуку включатимуть інформацію про курс (назва та підсумок) курсів, які бачать користувачі, навіть якщо вони не мають доступу до вмісту курсу.';
$string['searchindexactions'] = 'Індексні дії';
$string['searchindexdeleted'] = 'Індекс видалено';
$string['searchindextime'] = 'Ліміт часу індексування';
$string['searchindextime_desc'] = 'При індексуванні великої кількості нового вмісту заплановане завдання припиняється після досягнення цього обмеження часу. Він буде продовжуватися наступного разу, коли завдання буде запущено.';
$string['searchindexupdated'] = 'Вміст пошукової системи було оновлено';
$string['searchindexwhendisabled'] = 'Індекс, якщо його вимкнено';
$string['searchindexwhendisabled_desc'] = 'Дозволяє запланованому завданню будувати індекс пошуку, навіть якщо пошук вимкнено. Це корисно, якщо ви хочете побудувати індекс, перш ніж пошукова система з\'явиться студентам.';
$string['searchinsettings'] = 'Пошук в налаштуваннях';
$string['searchlastrun'] = 'Останній запуск (час, # docs, # records, # ignores)';
$string['searchmanagement'] = 'Управління пошуком';
$string['searchmanagement_desc'] = 'Ці параметри корисні під час внесення змін на сайтах із дуже великими пошуковими індексами, перебудова яких потребує багато часу.';
$string['searchmaxtopresults'] = 'Максимальний результат';
$string['searchmaxtopresults_desc'] = 'Максимальна кількість результатів з найвищим рейтингом, які відображаються над результатами пошуку для вмісту курсу, курсів і користувачів.';
$string['searchnotavailable'] = 'Пошук недоступний';
$string['searchoptions'] = 'Параметри пошуку';
$string['searchpartial'] = '(ще не повністю індексований)';
$string['searchreindexed'] = 'Всі зміст сайту було переіндексовано.';
$string['searchreindexindex'] = 'Відновити весь вміст сайту';
$string['searchresults'] = 'Результати пошуку';
$string['searchsetupinfo'] = 'Налагодження пошуку';
$string['searchteacherroles'] = 'Ролі вчителя';
$string['searchteacherroles_desc'] = 'Виберіть усі ролі, завдяки яким користувачі з рейтингом ролей вищі в результатах пошуку.';
$string['searchtopresults'] = 'Найкращі результати';
$string['searchupdateindex'] = 'Оновити індексований вміст';
$string['sectionerror'] = 'Помилка секції!';
$string['secureforms'] = 'Використання додаткових форм безпеки';
$string['security'] = 'Безпека';
$string['selectdevice'] = 'Виберіть пристрій';
$string['selectsearchengine'] = 'Обрати пошукову систему';
$string['selecttheme'] = 'Виберіть тему для пристрою - {$a}';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Перевірка серверу';
$string['serverlimit'] = 'Обмеження серверу';
$string['servicespage'] = 'Посилання на послуги та підтримку';
$string['sessionautostartwarning'] = '<p>Виявлено серйозну помилку в конфігурації, повідомте адміністратора серверу.</p><p> Для нормальної роботи Moodle вимагає зміни в конфігураційних файлах PHP.</p><p><code>session.auto_start</code> повинне бути встановлено в  <code>off</code>.</p></p><p>Це налаштування можна зробити у файлі <code>php.ini</code>,або конфігураційному файлі Apache/IIS <br />або в  <code>.htaccess</code> файлі на сервері.</p>';
$string['sessioncookie'] = 'Cookie-префікс';
$string['sessioncookiedomain'] = 'Cookie-домен';
$string['sessioncookiepath'] = 'Cookie-шлях';
$string['sessionhandling'] = 'Обробка сесії';
$string['sessiontimeout'] = 'Перерва';
$string['sessiontimeoutwarning'] = 'Попередження про час очікування';
$string['settingdependenton'] = 'Це налаштування може бути приховано на основі значення <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Завантаження файлів потрібно для нормальної роботи, будь ласка, увімкніть його в налаштуваннях PHP.';
$string['settingmaxinputvars'] = 'Налаштування PHP max_input_vars рекомендується мати принаймні 5000.';
$string['settingmaxinputvarsrequired'] = 'Налаштування PHP max_input_vars має бути не менше 5000.';
$string['settingmemorylimit'] = 'Виявлено недостатньо пам\'яті, будь ласка, встановити більш високі обмеження пам\'яті в налаштуваннях PHP.';
$string['settingsafemode'] = 'Moodle не повністю сумісні з безпечним режимом, попросіть адміністратора сервера  відключити його. Запуск Moodle в безпечному режимі не підтримується, ви можете отримати різні проблеми, якщо ви це зробите.';
$string['setupsearchengine'] = 'Налаштувати пошукову систему';
$string['showcommentscount'] = 'Показати кількість коментарів';
$string['showdetails'] = 'Показати деталі';
$string['showuseridentity'] = 'Показувати ідентифікатор користувача';
$string['showuseridentity_desc'] = 'Під час вибору або пошуку користувачів, а також під час відображення списків користувачів ці поля можуть відображатися на додаток до їх повного імені. Поля відображаються лише користувачам, які мають можливість moodle/site:viewuseridentity; за замовчуванням вчителі та менеджери. (Цей варіант має найбільший розум, якщо ви виберете одне або два поля, обов’язкові для заповнення у вашій установі.)

Поля, позначені *, є користувацькими полями профілю користувача. Ви можете вибрати ці поля, але наразі є деякі екрани, на яких вони не відображатимуться.';
$string['simplexmlrequired'] = 'Розширення РНР SimpleXML вимагається для роботи Moodle.';
$string['sitemailcharset'] = 'Кодування';
$string['sitemaintenance'] = 'Сайт зараз на технічному обслуговуванні і не доступний';
$string['sitemaintenancemode'] = 'Режим обслуговування';
$string['sitemaintenanceoff'] = 'Режим обслуговування був розблокований і сайт знову працює в нормальному режимі';
$string['sitemaintenanceon'] = 'Зараз ваш сайт знаходиться в режимі технічного обслуговування (тільки адміністратори можуть увійти і використовувати сайт).';
$string['sitemaintenanceoncli'] = 'Ваш сайт наразі знаходиться в режимі обслуговування з інтерфейсу командного рядка, веб доступ не дозволено.';
$string['sitemaintenancetitle'] = '{$a} на технічному обслуговуванні';
$string['sitemaintenancewarning'] = 'Зараз ваш сайт знаходиться в режимі технічного обслуговування (увійти можуть тільки адміністратори). Для того, щоб повернути сайт у нормальний режим, <a href="maintenance.php">відключіть режим обслуговування</a>.';
$string['sitemaintenancewarning2'] = 'Зараз ваш сайт знаходиться в режимі технічного обслуговування (увійти можуть тільки адміністратори). Для того, щоб повернути сайт у нормальний режим, <a href="{$a}">відключіть режим обслуговування</a>.';
$string['sitemenubar'] = 'Навігація по сайту';
$string['sitepolicies'] = 'Налаштування безпеки сайту';
$string['sitepolicy'] = 'URL політики сайту';
$string['sitepolicy_help'] = 'URL-адреса політики сайту, яку всі зареєстровані користувачі повинні побачити та погодитися, перш ніж отримати доступ до сайту. Зауважте, що це налаштування матиме ефект, лише якщо для обробника політики сайту встановлено значення за замовчуванням (основне).';
$string['sitepolicyguest'] = 'URL політики сайту для гостя';
$string['sitepolicyguest_help'] = 'URL-адреса політики сайту, яку всі гості повинні побачити та погодитися, перш ніж отримати доступ до сайту. Зауважте, що це налаштування матиме ефект, лише якщо для обробника політики сайту встановлено значення за замовчуванням (основне).';
$string['sitepolicyhandler'] = 'Обробник політики сайту';
$string['sitepolicyhandler_desc'] = 'Це визначає, яким чином керуються політикою та згодою користувачів. Обробник за умовчанням (ядро) дає змогу вказати URL-адресу політики сайту та URL-адресу політики сайту. Обробник політик дозволяє встановлювати правила щодо сайтів, конфіденційності та інших політик. Вона також дає змогу користувачам погоджуватися на перегляд і, якщо необхідно, давати згоду від імені неповнолітніх.';
$string['sitepolicyhandlercore'] = 'За замовчуванням (ядро)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Якщо вибрано, розділ теми буде відображатися на головній сторінці сайту.';
$string['sixtyfourbitsrequired'] = 'Було виявлено, що ваш сайт не використовує 64-розрядну версію PHP. Ви повинні оновити свою систему (операційну систему, PHP...) перед встановленням цієї версії Moodle.';
$string['sixtyfourbitswarning'] = 'Було виявлено, що ваш сайт не використовує 64-розрядну версію PHP. Рекомендується оновити свій сайт, щоб забезпечити сумісність у майбутньому.';
$string['slasharguments'] = 'Використання слеш аргументів';
$string['slashargumentswarning'] = 'Рекомендується використовувати для передачі аргументів слеш ("/"). У майбутньому це буде необхідно. Для більш детальної інформації, зверніться до документації <a href="https://docs.moodle.org/en/admin/environment/slasharguments"> Використання слешу для аргументів</a>.';
$string['smartpix'] = 'Пошук піктограм';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Тип SMTP аутентифікації';
$string['smtpdetail'] = 'Параметри протоколу SMTP для відправки електронної пошти.';
$string['smtphosts'] = 'SMTP хости';
$string['smtpmaxbulk'] = 'обмеження сесії SMTP';
$string['smtppass'] = 'Пароль SMTP';
$string['smtpsecure'] = 'SMTP безпека';
$string['smtpuser'] = 'SMTP користувач';
$string['soaprecommended'] = 'Встановлення додаткових soap-розширень корисне для веб-серверів та деяких вкладених модулів.';
$string['sort_fullname'] = 'за Повною назвою';
$string['sort_idnumber'] = 'за Кодом';
$string['sort_shortname'] = 'за Короткою назвою';
$string['sort_sortorder'] = 'ручне сортування';
$string['spellengine'] = 'Правопис';
$string['spelllanguagelist'] = 'Список мов для перевірки орфографії';
$string['splrequired'] = 'Розширення РНР SPL потрібне для Moodle.';
$string['stats'] = 'Статистика';
$string['statsfirstrun'] = 'Максимальний інтервал обробітку';
$string['statsmaxruntime'] = 'Максимальний час виконання';
$string['statsmoodleorg'] = 'статистика';
$string['statsruntimedays'] = 'Обробіток днів';
$string['statsruntimestart'] = 'Запустити в';
$string['statsuserthreshold'] = 'Межа для користувача';
$string['stickyblocks'] = 'Прикріплені блоки';
$string['stickyblockscourseview'] = 'Сторінка курсу';
$string['stickyblocksduplicatenotice'] = 'Якщо ви додаєте будь-який блок і він вже існує на окремій сторінці, він буде продубльований.<br />Тільки згорнутий блок буде недоступний для редагування, дублікат все ще можна буде редагувати.';
$string['stickyblocksmymoodle'] = 'Мій Moodle';
$string['stickyblockspagetype'] = 'Тип сторінки для формування';
$string['strictformsrequired'] = 'Сувора перевірка обов\'язкових полів';
$string['stripalltitletags'] = 'Видалити HTML теги з усіх назв діяльностей';
$string['supportavailability'] = 'Доступність підтримки';
$string['supportcontact'] = 'Зв’язатися зі службою підтримки';
$string['supportemail'] = 'Підтримка ел.пошти';
$string['supportemailsubject'] = 'Запит на підтримку сайту – {$a}';
$string['supportname'] = 'Підтримка імені';
$string['supportpage'] = 'Посилання зв\'язатися зі службою підтримки сайту';
$string['suspenduser'] = 'Призупинити діяльність користувача';
$string['switchlang'] = 'Перемикнути мовний каталог';
$string['systempaths'] = 'Системні шляхи';
$string['tablenosave'] = 'Зміни в таблиці вище, збережено автоматично.';
$string['tablesnosave'] = 'Зміни в таблицях вище, збережено автоматично.';
$string['tabselectedtofront'] = 'У таблицях із закладками рядок з поточним вибраним тегом (ознакою) повинен бути винесений на передній план';
$string['tabselectedtofronttext'] = 'Переносити відібраний рядок на перед';
$string['task_adhoc_concurrency_limit'] = 'Обмеження паралельності спеціальних завдань';
$string['task_adhoc_concurrency_limit_desc'] = 'Кількість спеціальних програм, які можуть виконуватися одночасно. Якщо ліміт високий, то заплановані завдання можуть не виконуватися регулярно, коли є багато спеціальних завдань. Установка 0 повністю вимкне обробку спеціальних завдань.';
$string['task_adhoc_max_runtime'] = 'Тривалість використання спеціального засобу керування завданнями';
$string['task_adhoc_max_runtime_desc'] = 'Вік користувача, що виконує спеціальні завдання, до його звільнення. Рекомендується мала тривалість, оскільки немає обмежень на кількість спеціальних завдань, що стоять у черзі. Якщо це число занадто велике, а у вас велика черга спеціальних завдань, то заплановані завдання можуть не виконуватися регулярно.';
$string['task_dbreads'] = 'Читання бази даних';
$string['task_dbstats'] = 'База даних';
$string['task_dbwrites'] = 'База даних записує';
$string['task_duration'] = 'Тривалість';
$string['task_endtime'] = 'Час закінчення';
$string['task_logmode'] = 'Коли входити';
$string['task_logmode_all'] = 'Зберігайте вихідні дані журналу всіх завдань';
$string['task_logmode_desc'] = 'Ви можете вибрати, коли ви бажаєте, щоб відбулося ведення журналу завдань. За замовчуванням журнали записуються завжди. Ви можете повністю вимкнути ведення журналу або змінити лише реєстрацію завдань, які не вдалися.';
$string['task_logmode_failonly'] = 'Зберігайте журнали лише для завдань, які не вдалися';
$string['task_logmode_none'] = 'Нічого не реєструйте';
$string['task_logoutput'] = 'Висновок завдання';
$string['task_logretainruns'] = 'Зберігати пробіги';
$string['task_logretainruns_desc'] = 'Кількість виконання кожного завдання, яке потрібно зберегти. Це налаштування взаємодіє з налаштуванням "Період зберігання": застосовуватиметься те, що буде досягнуто першим.';
$string['task_logretention'] = 'Термін зберігання';
$string['task_logretention_desc'] = 'Максимальний період, протягом якого слід зберігати журнали. Це налаштування взаємодіє з налаштуванням «Зберігати прогони»: застосовуватиметься те, що буде досягнуто першим';
$string['task_logtostdout'] = 'Відобразити вихідний журнал';
$string['task_logtostdout_desc'] = 'Коли виконуються завдання та фіксується вихідний результат, чи слід також відображати отриманий результат під час виконання завдання.';
$string['task_result'] = 'Результат';
$string['task_result:failed'] = 'Помилка';
$string['task_scheduled_concurrency_limit'] = 'Обмеження паралельності запланованих завдань';
$string['task_scheduled_concurrency_limit_desc'] = 'Кількість запланованих завдань, які можуть виконуватися одночасно. Якщо ліміт високий, то сервер може відчувати високе навантаження, що впливає на продуктивність. Установка 0 повністю вимкне обробку запланованих завдань.';
$string['task_scheduled_max_runtime'] = 'Тривалість життя запланованих завдань';
$string['task_scheduled_max_runtime_desc'] = 'Вік програми для запланованих завдань до її звільнення.';
$string['task_starttime'] = 'Час початку';
$string['task_stats:dbreads'] = '{$a} читає';
$string['task_stats:dbwrites'] = '{$a} пише';
$string['task_status'] = 'Статус завдання';
$string['task_status_desc'] = 'Завдання "{$a->name}" - {$a->status}. Щоб отримати докладнішу інформацію, див. {$a->class}{$a->extradescription} у запланованих завданнях.';
$string['task_type:adhoc'] = 'До цього';
$string['task_type:scheduled'] = 'За розкладом';
$string['taskadmintitle'] = 'Задачі';
$string['taskanalyticscleanup'] = 'Очищення Analytics';
$string['taskautomatedbackup'] = 'Автоматичне створення резервних копій';
$string['taskbackupcleanup'] = 'Очистіть резервні таблиці, журнали та файли';
$string['taskbadgescron'] = 'Роздача відзнак';
$string['taskbadgesmessagecron'] = 'Фонова обробка для надсилання сповіщень про значки';
$string['taskblogcron'] = 'Синхронізація зовнішніх блогів';
$string['taskcachecleanup'] = 'Видалення прострочених записів кешу';
$string['taskcachecron'] = 'Обробка у фоновому режимі для кешей';
$string['taskcalendarcron'] = 'Надсилання повідомлень календаря';
$string['taskcheckforupdates'] = 'Перевірка оновлень';
$string['taskcompletiondaily'] = 'Відмітити виконаною після початку';
$string['taskcompletionregular'] = 'Розрахувати дані нормального виконання';
$string['taskcontextcleanup'] = 'Очищення контекстів';
$string['taskcreatecontexts'] = 'Створення відсутніх контекстів';
$string['taskdeletecachetext'] = 'Видалення старих записів тексту кеша';
$string['taskdeleteincompleteusers'] = 'Видалення неповних користувачів';
$string['taskdeleteunconfirmedusers'] = 'Видалення непідтверджених користувачів';
$string['taskeventscron'] = 'Обробка у фоновому режимі для подій';
$string['taskfiletrashcleanup'] = 'Очищення файлів у смітнику';
$string['taskglobalsearchindex'] = 'Побудова глобального пошукового індексу';
$string['taskglobalsearchoptimize'] = 'Оптимізація глобального пошукового індексу';
$string['taskgradecron'] = 'Обробка у фоновому режимі для журналу оцінок';
$string['taskgradehistorycleanup'] = 'Фонова обробка для очищення таблиць історії оцінок';
$string['taskh5pcleanup'] = 'Очищення невикористаних файлів H5P';
$string['tasklegacycron'] = 'Обробку застарілого cron процесу для модулів';
$string['tasklockcleanuptask'] = 'Очистіть метадані спеціального завдання';
$string['tasklogcleanup'] = 'Очищення журналів завдань';
$string['tasklogging'] = 'Конфігурація журналу завдань';
$string['tasklogs'] = 'Журнали завдань';
$string['taskmessagingcleanup'] = 'Обробка у фоновому режимі для повідомлень';
$string['taskpasswordresetcleanup'] = 'Очищення спроб скидання пароля';
$string['taskplagiarismcron'] = 'Обробка у фоновому режимі застарілого cron для модулів перевірки на плагіат';
$string['taskportfoliocron'] = 'Обробка у фоновому режимі для модулів портфоліо';
$string['taskprocessing'] = 'Обробка завдання';
$string['taskquestioncron'] = 'Фонова обробка для очищення попереднього перегляду запитань';
$string['taskquestionstatscleanupcron'] = 'Фонова обробка для очищення кешу статистики запитань';
$string['taskrefreshsystemtokens'] = 'Оновити маркери OAuth для облікових записів служб';
$string['taskregistrationcron'] = 'Реєстрація сайту';
$string['tasksendfailedloginnotifications'] = 'Надсилання повідомлення про невдалі спроби входу';
$string['tasksendnewuserpasswords'] = 'Надсилання паролей новим користувачам';
$string['tasksessioncleanup'] = 'Очищення застарілих сесій';
$string['taskstatscron'] = 'Обробка у фоновому режимі для статистики';
$string['tasktagcron'] = 'Обробка у фоновому режимі для міток';
$string['tasktempfilecleanup'] = 'Вилучення застарілих тимчасових файлів';
$string['tasktype'] = 'Тип';
$string['tempdatafoldercleanup'] = 'Очистіть тимчасові файли даних старше';
$string['templates'] = 'Шаблони';
$string['testoutgoingmailconf'] = 'Перевірте конфігурацію вихідної пошти';
$string['testoutgoingmailconf_errorcommunications'] = 'Ваш сайт не може зв’язатися з вашим поштовим сервером. Перевірте конфігурацію вихідної пошти.';
$string['testoutgoingmailconf_fromemail'] = 'З імені користувача або електронної адреси';
$string['testoutgoingmailconf_fromemail_help'] = 'Це поле імітує надсилання повідомлення від цього користувача, але заголовок From, який використовується в справжньому надісланому електронному листі, буде залежати від інших налаштувань, наприклад дозволених доменів електронної пошти.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Недійсний Від імені користувача або електронної пошти. Має бути дійсний формат електронної пошти або наявне ім’я користувача в Moodle.';
$string['testoutgoingmailconf_message'] = 'Це тестове повідомлення, щоб підтвердити, що ви успішно налаштували вихідну пошту свого сайту. Надіслано: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Надішліть тестове повідомлення';
$string['testoutgoingmailconf_sentmail'] = 'Цей сайт успішно надіслав тестове повідомлення на поштовий сервер.
<br />Від: {$a->fromemail}
<br />Кому: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: тестове повідомлення. {$a->additional} Надіслано: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Додаткова тема';
$string['testoutgoingmailconf_toemail'] = 'На адресу електронної пошти';
$string['testoutgoingmaildetail'] = 'Примітка. Перед тестуванням збережіть конфігурацію.{$a}';
$string['testsiteupgradewarning'] = 'Наразі ви використовуєте тестовий сайт {$a}, для правильного його оновлення використовуйте інструмент з інтерфейсом командного рядка.';
$string['themedesignermode'] = 'Режим дизайнера тем';
$string['themedesignermodewarning'] = 'Режим розробки теми включений. Це не слід увімкнути на виробничих площадках, оскільки це може значно зменшити продуктивність.';
$string['themelist'] = 'Список тем';
$string['themenoselected'] = 'Тему не вибрано';
$string['themeresetcaches'] = 'Очистити кеш теми';
$string['themeselect'] = 'Вибрати тему';
$string['themeselector'] = 'Вибір теми';
$string['themesettings'] = 'Установки теми';
$string['therewereerrors'] = 'Ваші дані містять помилки';
$string['thirdpartylibrary'] = 'Бібліотека';
$string['thirdpartylibrarylocation'] = 'Розміщення';
$string['thirdpartylibs'] = 'Сторонні бібліотеки';
$string['timezone'] = 'Типовий часовий пояс';
$string['timezoneforced'] = 'Це встановлено адміністратором сайту';
$string['timezoneinvalid'] = 'Неправильний часовий пояс "{$a}"';
$string['timezoneisforcedto'] = 'Примусово встановити усім користувачам';
$string['timezonenotforced'] = 'Користувачі можуть змінювати власний часовий пояс';
$string['timezonephpdefault'] = 'Типовий часовий пояс PHP ({$a})';
$string['timezoneserver'] = 'Часовий пояс сервера ({$a})';
$string['tlswarning'] = 'Розширення PHP/cURL з підтримкою TLSv1.2 не виявлено. Деякі послуги можуть не працювати. Настійно рекомендується оновити бібліотеки TLS.';
$string['tokenduration'] = 'Користувач створив тривалість токена';
$string['tokenduration_desc'] = 'Тривалість часу, протягом якого маркер веб-служб, створений користувачем (наприклад, через мобільну програму), є дійсним.';
$string['tokenizerrecommended'] = 'Рекомендується встановити розширення PHP Tokenizer - це дозволить функціональність розподіленої мережі Мудл.';
$string['tools'] = 'Інструментарій Адміна';
$string['toolsmanage'] = 'Управління інструментарієм адміна';
$string['unattendedoperation'] = 'Автоматична робота';
$string['unbookmarkthispage'] = 'Видалити закладку для цієї сторінки';
$string['unicoderequired'] = 'Вимагається, щоб ви зберігали ваші дані у форматі Unicode (UTF-8). Нові інсталяції повинні записувати дані до бази, яка вже під Unicode.Якщо ви поновлюєте систему, вам потрібно пройти процес міграції до UTF-8 (див.в меню Адміністрування)';
$string['uninstallplugin'] = 'Деінсталювати';
$string['unlockaccount'] = 'Розблокувати обліковий запис';
$string['unoconvwarning'] = 'Версія встановленого у вас unoconv не підтримується. Для можливості оцінювання діяльності Завдання потрібна версія 0.7 або вище.';
$string['unsettheme'] = 'Відключити тему';
$string['unsupported'] = 'Не підтримується';
$string['unsupporteddbfileformat'] = 'База даних використовує антилопу як формат файлу. Повна підтримка UTF-8 в MySQL і MariaDB вимагає формату файлу Barracuda. Перейдіть у формат файлу Barracuda. Докладнішу інформацію див. У документації <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support"> повну підтримку Unicode MySQL</a>';
$string['unsupporteddbfilepertable'] = 'Для повної підтримки UTF-8 як MySQL, так і MariaDB вимагають змінити налаштування MySQL innodb_file_per_table на ON. Додаткову інформацію див. У документації.';
$string['unsupporteddblargeprefix'] = 'Для повної підтримки UTF-8 MySQL і MariaDB вимагають змінити налаштування MySQL innodb_large_prefix на ON. Додаткову інформацію див. У документації.';
$string['unsupporteddbstorageengine'] = 'Рушій сховища бази даних, що наразі використовується, більше не підтримується.';
$string['unsupporteddbtablerowformat'] = 'Ваша база даних має таблиці, що використовують тип Antelope в якості формату файлу. Рекомендується конвертувати ці таблиці до формату файлу Barracuda. За детальною інформацією про конвертацію таблиць InnoDB до типу Barracuda зверніться до документації <a href="https://docs.moodle.org/en/cli">Керування через командний рядок</a>.';
$string['unsupportedphpversion7'] = 'PHP версії 7 і вище не підтримуються.';
$string['unsupportedphpversion71'] = 'PHP версії 7.1 і вище не підтримуються.';
$string['unsupportedphpversion72'] = 'PHP версії 7.2 і вище не підтримуються.';
$string['unsupportedphpversion73'] = 'PHP версії 7.3 і вище не підтримуються.';
$string['unsupportedphpversion74'] = 'PHP версії 7.4 і вище не підтримуються.';
$string['unsupportedphpversion80'] = 'PHP версії 8.0 і вище не підтримуються.';
$string['unsupportedphpversion81'] = 'PHP версії 8.1 і вище не підтримуються.';
$string['unsupportedphpversion82'] = 'PHP версії 8.2 і вище не підтримуються.';
$string['unsuspenduser'] = 'Активувати діяльність користувача';
$string['updateaccounts'] = 'Оновіть існуючі облікові записи';
$string['updateautocheck'] = 'Автоматично перевіряти наявність оновлень';
$string['updateautocheck_desc'] = 'Якщо включено, то сайт буде автоматично перевіряти наявність оновлень системи Moodle та всіх інших додаткових модулів. За наявності оновлень адміністраторам сайту буде розіслано відповідне повідомлення.';
$string['updateavailable'] = 'Наявна новіша версія Moodle!';
$string['updateavailable_moreinfo'] = 'Детальніше...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Версія {$a}';
$string['updateavailabledetailslink'] = 'Деталі можете переглянути на {$a->url}';
$string['updateavailableforplugin'] = 'Наявні новіші версії деяких з ваших модулів!';
$string['updateavailableinstall'] = 'Встановіть це оновлення';
$string['updateavailableinstallall'] = 'Встановити усі оновлення ({$a})';
$string['updateavailableinstallallhead'] = 'Відбувається оновлення';
$string['updateavailablenot'] = 'Ви маєте найновішу версію Moodle!';
$string['updateavailablerecommendation'] = 'Наполегливо рекомендуємо вам оновити ваш сайт до останньої версії, щоб отримувати всі латки безпеки та виправлення помилок.';
$string['updatecomponent'] = 'Оновити компонент';
$string['updateminmaturity'] = 'Потрібна стадія розробки';
$string['updateminmaturity_desc'] = 'Повідомляти тільки про такі оновлення. стадія розробки яких не нижче вказаної. Цей параметр не впливає на повідомлення про наявність нових версій додаткових модулів, оскільки для них не вказується стадія розробки.';
$string['updatenotificationfooter'] = 'Ваш сайт Moodle {$a->siteurl} налаштовано на автоматичну перевірку доступних оновлень. Ви отримуєте це повідомлення як адміністратор сайту. Ви можете вимкнути автоматичну перевірку доступних оновлень у розділі Адміністрування сайту / Сервер / Сповіщення про оновлення або налаштувати доставку цього повідомлення на сторінці налаштувань.';
$string['updatenotifications'] = 'Повідомлення оновлень';
$string['updatenotificationsubject'] = 'Наявні оновлення для вашого сайту Moodle';
$string['updatenotifybuilds'] = 'Повідомляти про нові збірки';
$string['updatenotifybuilds_desc'] = 'Якщо включено, то повідомлення будуть розсилатися при виході кожної нової збірки (build) Moodle. Збірки мають постійні поліпшення поточної версії Moodle та зазвичай виходять кожного тижня. Якщо відключити цей параметр, то ви будете проінформовані тільки при виході наступної версії Moodle. Цей параметр не вплине на перевірку версій додаткових модулів.';
$string['upgradeerror'] = 'Невідома помилка під час оновлення {$a->plugin} до версії {$a->version}. Неможливо продовжити.';
$string['upgradeforumread'] = 'Нова особливість була додана у Moodle 1.5, щоб відстежувати прочитану/непрочитану пошту форуму.<br />Для того, щоб використовувати цю функціональність, вам потрібно <a href="{$a}">оновити ваші таблиці</a>.';
$string['upgradeforumreadinfo'] = 'Нова особливість була додана у Moodle 1.5, щоб відстежувати прочитану/непрочитану пошту форуму. Щоб використовувати цю функціональність, вам потрібно оновити ваші таблиці зі всією відстежуючою інформацією для існуючої пошти. Залежно від розміру вашого сайту це може тривати довгій час (години) і може бути вельми накладним для вашої бази даних, так що це краще робити протягом періоду с невеликою активністю користувачів. Проте, ваш сайт продовжуватиме функціонування протягом цього оновлення і користувачів не буде зачеплено. Якщо ви запускаєте цей процес, ви повинні дозволити йому завершитися (утримуйте вікно свого браузера відкритим). Проте, якщо ви зупиняєте процес, закриваючи вікно, не турбуйтеся - ви можете перестартувати.<br /><br />Ви хочете запустити процес оновлення зараз?';
$string['upgradekeyreq'] = 'Потрібно оновлення ключа';
$string['upgradekeyset'] = 'Оновлення ключа (залишіть порожнім, якщо не встановлено)';
$string['upgradelogs'] = 'Для повного виконання функцій Вашу стару статистику потрібно оновити. <a href="{$a}">Більше інформації</a>.';
$string['upgradelogsinfo'] = 'Деякі зміни, які були зроблені недавно, збережені в записах системного журналу (logs). Щоб мати доступ до усіх старих логів в неактивній базі, Ваші старі логи потрібно удосконалити/модернізувати. Залежно від Вашого сайту це може зайняти багато часу (кілька годин) та буде оподатковано за базою даних великих сайтів. Якщо процес розпочався, завершіть його (вікно браузера повинно бути відкритим). Не хвилюйтеся - Ваш сайт буде доступним для інших людей під час удосконалення / модернізації логів. Ви хочете удосконалити/модернізувати Ваші логи зараз?';
$string['upgradepluginsfirst'] = 'Вам потрібно скачати та встановити доступні оновлення вручну';
$string['upgradepluginsinfo'] = 'Оновлення модулів';
$string['upgradepluginsinfo_help'] = 'Наявні оновлення для деяких модулів. Moodle ще не вміє оновлювати їх автоматично. Вам необхідно скачати оновлення та вручну встановити їх на свій сервер.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Нові установки';
$string['upgradesettingsintro'] = 'Показані нижче налаштування були додані під час останнього оновлення Moodle. Внесіть необхідні зміни до значень за замовчуванням, а потім натисніть кнопку «Зберегти зміни» внизу цієї сторінки.';
$string['upgradestalefiles'] = 'Виявлено змішування версій Moodle, продовження оновлення не можливе.';
$string['upgradestalefilesinfo'] = 'Процес оновлення Moodle було призупинено, тому що в каталозі Moodle  виявлено скрипти, що найменше, двух основних версій Moodle. В подальшому це може призвести до великих проблем, тому для продовження необхідно переконатися, що каталог Moodle має файли тільки однієї версії.

Очищати каталог Moodle рекомендується в такій послідовності:

* перейменувати поточний каталог Moodle в "moodel_old"
*створити новий каталог Moodle, який матиме тільки файли з (будь-якого) стандартного пакету Moodle або Moodle CVS, або репозиторію GIT
* перемістити вихідний файл config.php та будь-які нестандартні модулі з каталогу "moodel_old" до нового каталогу Moodle.

Після очистки каталогу Moodle оновіть сторінку, щоб поновити процес оновлення Moodle.

Часто причиною цього попередження є розпаковка стандартного пакету Moodle в попередню версію Moodle. Хоча це нормально для невеликих модернізацій, але не рекомендується для великих оновлень.

Ви можете знайти детальнішу інформацію про оновленна в документації <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Оновити';
$string['upgradesure'] = '<p>Програмні файли на сервері були змінені, і готова модернізацію вашого сервера до цієї версії:</p>
<p> <strong>{$a}</strong> </p>
<p> Повернутися до попереднього стану буде не можливо. Зверніть увагу, що цей процес може зайняти трохи часу.</p>
<p>Ви бажаєте модернізувати ваш сервер до цієї версії?</p>';
$string['upgradetimedout'] = 'Оновлення перевищило час очікування, перезапустіть оновлення.';
$string['upgradingdata'] = 'Оновлення даних';
$string['upgradinglogs'] = 'Оновлення статистики';
$string['upgradingversion'] = 'Оновлення до нової версії';
$string['upwards'] = 'і більше';
$string['useblogassociations'] = 'Включити асоціації';
$string['user'] = 'Користувач';
$string['userbulk'] = 'Гуртові дії з користувачами';
$string['userbulkdownload'] = 'Експортувати користувача як';
$string['userdefaultpreferences'] = 'Типові уподобання користувача';
$string['userfeedbackafterupgrade'] = 'Після кожного серйозного оновлення';
$string['userfeedbackencouragement'] = '<p>У Moodle 3.9 і пізнішої версії включена нова функція, яка дає користувачам можливість надсилати відгуки про програмне забезпечення Moodle до штаб-квартири Moodle через зовнішній сайт опитування, розміщений у штаб-квартирі Moodle. </p>
<p>На сайт опитування не пересилається інформація, що ідентифікує користувача. Головний офіс Moodle прагне бути відкритим і прозорим щодо своїх методів збору даних. Таким чином, ми хочемо переконатися, що ви знаєте і контролюєте цю функцію. </p>
<p>Відгуки користувачів значно допоможуть Moodle HQ у покращенні програмного забезпечення Moodle. Щоб увімкнути цю функцію, перейдіть до  <a href="{$a}">налаштувань зворотного зв’язку</a>.</p>';
$string['userfeedbacknextreminder'] = 'Наступне нагадування про відгук';
$string['userfeedbacknextreminder_desc'] = 'Коли ми повинні знову попросити користувача надати відгук?';
$string['userfeedbackperiodically'] = 'Періодично';
$string['userfeedbackremindafter'] = 'Показати нагадування після';
$string['userfeedbackremindafter_desc'] = 'Знову нагадати користувачам про надання відгуку через зазначену кількість днів.';
$string['userfiltersdefault'] = 'Фільтри користувача за замовчуванням';
$string['userfiltersdefault_desc'] = 'Виберіть фільтри, які мають відображатися на сторінці "Перегляд списку користувачів" і на сторінці "Групові дії користувача". Утримуйте клавішу Ctrl, щоб вибрати кілька елементів. Усі невибрані фільтри будуть доступні, натиснувши посилання «Показати більше».';
$string['userimagesdisabled'] = 'Зображення користувача профілю вимкнено';
$string['userlist'] = 'Список користувачів';
$string['usermanagement'] = 'Керування користувачами';
$string['userpolicies'] = 'Політика користувачів';
$string['userpreference'] = 'Налаштування користувача';
$string['userquota'] = 'Приватний простір для файлів';
$string['userquota_desc'] = 'Максимальна кількість даних, яку кожен користувач може зберігати в області приватних файлів.';
$string['users'] = 'Користувачі';
$string['usesitenameforsitepages'] = 'Використовувати назву сайту для сторінок сайту';
$string['usetags'] = 'Включити функціональність міток';
$string['validateemptylineerror'] = 'Порожні рядки недійсні';
$string['validateerror'] = 'Це значення не дійсне';
$string['validateerrorlist'] = 'Ці записи є недійсними: {$a}';
$string['validateiperror'] = 'Ці IP-адреси недійсні: {$a}';
$string['verifychangedemail'] = 'Обмежити домени при зміні ел.пошти';
$string['warningcurrentsetting'] = 'Неправильне поточне значення: {$a}';
$string['warningiconvbuggy'] = 'Ваша версія бібліотеки iconv не підтримує модифікатор  //IGNORE. Вам потрібно встановити розширення mbstring, яке може бути використане для очищення рядків, які містять символи не UTF-8.';
$string['webproxy'] = 'Веб-проксі';
$string['webproxyinfo'] = 'Заповніть наступні параметри, якщо ваш сервер Moodle не може отримати прямий доступ до Інтернету. Для завантаження даних середовища, мовних пакетів, RSS-каналів, часових поясів потрібен доступ до Інтернету. <em>Настійно рекомендується розширення PHP cURL.</em>';
$string['xmlrpcwebserviceenabled'] = 'Було виявлено, що на вашому сайті ввімкнено протокол веб-служби XML-RPC. Ця функція спирається на розширення PHP XML-RPC, яке більше не підтримується PHP.';
$string['yuicomboloading'] = 'Завантаження YUI Combo';
$string['ziprequired'] = 'Розширення Zip PHP тепер вимагається для Moodle, бінарні info-ZIP або бібліотека PclZip ніде не використовується.';
