<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'mn', version '4.3'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Үйлдэл';
$string['addanotherhint'] = 'Өөр дохио нэмэх';
$string['addcategory'] = 'Ангилал нэмэх';
$string['addmorechoiceblanks'] = 'Илүү {no} сонголт хийх хоосон зай';
$string['adminreport'] = 'Асуултын өгөгдлийн санд гарч болзошгүй асуудлын талаар мэдээлэх';
$string['advancedsearchoptions'] = 'Хайлтын сонголтууд';
$string['alltries'] = 'Бүх оролдлого';
$string['answer'] = 'Хариулт';
$string['answers'] = 'Хариултууд';
$string['answersaved'] = 'Хариултыг хадгалсан';
$string['answerx'] = 'Хариулт {$a}';
$string['attemptfinished'] = 'Оролдлого дууслаа';
$string['attemptfinishedsubmitting'] = 'Оролдлогыг илгээж дууссан: {$a}';
$string['attemptoptions'] = 'Оролдлогын сонголтууд';
$string['availableq'] = 'Боломжтой эсэх?';
$string['badbase'] = '** өмнөх суурь муу: {$a}**';
$string['behaviour'] = 'Шинж';
$string['behaviourbeingused'] = 'Ашиглаж буй шинж: {$a}';
$string['broken'] = 'Энэ бол "эвдэрсэн холбоос" бөгөөд энэ нь байхгүй файлыг заадаг.';
$string['byandon'] = '<em>{$a->time}</em> дээрх <em>{$a->user}</em> нь';
$string['cannotcopybackup'] = 'Нөөц файлыг хуулж чадсангүй';
$string['cannotcreate'] = 'question_attempts хүснэгтэд шинэ бичилт үүсгэж чадсангүй';
$string['cannotcreatepath'] = 'Зам үүсгэх боломжгүй: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Та \'{$a}\' шинжийг устгах боломжгүй. Үүнийг асуултын оролдлогод ашигладаг.';
$string['cannotdeletecate'] = 'Та уг ангиллыг устгах боломжгүй, энэ нь уг сэдвийн өгөгдмөл ангилал болно.';
$string['cannotdeleteneededbehaviour'] = '\'{$a}\' асуултын шинжийг устгах боломжгүй. Түүнд тулгуурласан бусад шинжийг суулгасан байна.';
$string['cannotdeleteqtypeinuse'] = 'Та \'{$a}\' асуултын төрлийг устгах боломжгүй. Асуултын санд ийм төрлийн асуултууд бий.';
$string['cannotdeleteqtypeneeded'] = '\'{$a}\' асуултын төрлийг устгах боломжгүй. Түүнд тулгуурласан бусад төрлийг суулгасан байна.';
$string['cannotdeletetopcat'] = 'Дээд ангиллыг устгах боломжгүй.';
$string['cannotedittopcat'] = 'Дээд ангиллыг засварлах боломжгүй.';
$string['cannotenable'] = '{$a} асуултын төрлийг шууд үүсгэх боломжгүй.';
$string['cannotenablebehaviour'] = '{$a} асуултын шинжийг шууд ашиглах боломжгүй. Үүнийг зөвхөн дотоод хэрэглээнд зориулсан.';
$string['cannotfindcate'] = 'Ангиллын бичлэгийг олж чадсангүй';
$string['cannotfindquestionfile'] = 'Zip файлаас асуултын өгөгдлийн файлыг олж чадсангүй';
$string['cannotgetdsfordependent'] = 'Өгөгдлийн багцаас хамааралтай асуултын хувьд заасан өгөгдлийн багцыг авч чадахгүй байна! (question: {$a->id}, datasetitem: {$a->item})';
$string['cannotgetdsforquestion'] = 'Тооцоолсон асуултын өгөгдлийн багцыг авч чадахгүй байна! (question: {$a})';
$string['cannothidequestion'] = 'Асуултыг нуух боломжгүй';
$string['cannotimportformat'] = 'Уучлаарай, энэ форматын импортыг хэрэгжүүлээгүй байна!';
$string['cannotinsertquestion'] = 'Шинэ асуултыг оруулж чадсангүй!';
$string['cannotinsertquestioncatecontext'] = '{$a->cat} хориглосон contextid {$a->ctx} шинэ асуултын ангиллыг оруулж чадсангүй.';
$string['cannotloadquestion'] = 'Асуултыг ачаалж чадсангүй';
$string['cannotmovequestion'] = 'Та төрөл бүрийн хэсгээс холбоотой файлтай асуултыг зөөхөд энэ скриптийг ашиглах боломжгүй.';
$string['cannotopenforwriting'] = 'Бичилт хийхээр нээх боломжгүй: {$a}';
$string['cannotpreview'] = 'Та эдгээр асуултыг урьдчилан харах боломжгүй!';
$string['cannotread'] = 'Импортын файлыг унших боломжгүй (эсвэл файл хоосон байна)';
$string['cannotregradedifferentqtype'] = 'Өөр төрлийн асуултаар дахин үнэлэх боломжгүй.';
$string['cannotretrieveqcat'] = 'Асуултын ангиллыг сэргээж чадсангүй';
$string['cannotunhidequestion'] = 'Асуултыг харуулахад алдаа гарлаа.';
$string['cannotunzip'] = 'Файлыг задалж чадсангүй.';
$string['cannotwriteto'] = '{$a} руу экспортолсон асуултыг бичих боломжгүй';
$string['categories'] = 'Ангиллууд';
$string['category'] = 'Ангилал';
$string['categorycurrent'] = 'Идэвхтэй ангилал';
$string['categorycurrentuse'] = 'Энэ ангиллыг ашиглах';
$string['categorydoesnotexist'] = 'Энэ ангилал байхгүй';
$string['categoryinfo'] = 'Ангиллын мэдээлэл';
$string['categorymove'] = '\'{$a->name}\' ангилал нь {$a->count} асуултуудыг (зарим нь нуусан асуулт эсвэл шалгалтад ашиглах санамсаргүй асуулт байж болно) агуулдаг. Тэдгээрийг зөөхийн тулд өөр ангиллыг сонгоно уу.';
$string['categorymoveto'] = 'Ангилалд хадгалах';
$string['categorynamecantbeblank'] = 'Ангиллын нэр хоосон байж болохгүй.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Өөрчлөлтийн сонголтууд';
$string['changepublishstatuscat'] = '"{$a->coursename}" хичээлийн <a href="{$a->caturl}">"{$a->name}"</a> ангилал нь {$a->changefrom}-аас {$a->changeto} хүртэлх өөрчлөгдсөн төлөвийг хуваалцаж байна.';
$string['check'] = 'Шалгах';
$string['chooseqtypetoadd'] = 'Нэмэх асуултын төрлийг сонгох';
$string['clearwrongparts'] = 'Буруу хариултыг арилгах';
$string['clickflag'] = 'Асуултыг тэмдэглэх';
$string['clicktoflag'] = 'Цаашид лавлах зорилгоор энэ асуултыг тэмдэглэх';
$string['clicktounflag'] = 'Тэмдэглэгээг арилгах';
$string['clickunflag'] = 'Тэмдэглэгээг арилгах';
$string['closepreview'] = 'Урьдчилан харахыг хаах';
$string['combinedfeedback'] = 'Нэгтгэсэн санал хүсэлт';
$string['comment'] = 'Сэтгэгдэл';
$string['commented'] = 'Сэтгэгдэл бичсэн: {$a}';
$string['commentormark'] = 'Сэтгэгдэл бичих эсвэл тэмдэглэгээг дарах';
$string['comments'] = 'Сэтгэгдлүүд';
$string['commentx'] = 'Сэтгэгдэл: {$a}';
$string['complete'] = 'Бүрэн';
$string['contexterror'] = 'Ангиллыг өөр сэдэвт шилжүүлэхгүй бол энд байхгүй байсан.';
$string['copy'] = '{$a}-аас хуулж, холбоосыг өөрчилнө.';
$string['correct'] = 'Зөв';
$string['correctfeedback'] = 'Дурын зөв хариултын хувьд';
$string['correctfeedbackdefault'] = 'Таны хариулт зөв байна.';
$string['created'] = 'Үүсгэсэн';
$string['createdby'] = 'Үүсгэсэн:';
$string['createdmodifiedheader'] = 'Үүсгэсэн / хамгийн сүүлд хадгалсан';
$string['createnewquestion'] = 'Шинэ асуулт үүсгэх ...';
$string['cwrqpfs'] = 'Дэд ангиллаас асуулт сонгох санамсаргүй асуултууд.';
$string['cwrqpfsinfo'] = '<p>Moodle 1.9 хувилбарыг шинэчлэх явцад бид асуултын ангиллыг төрөл бүрийн сэдэвт хуваах болно. Таны сайт дээрх зарим асуултын ангилал, асуултууд, тэдгээрийн хуваалцах төлөвийг өөрчлөх шаардлагатай. Энэ нь нэг буюу хэд хэдэн \'санамсаргүй\' асуултыг хуваалцсан болон хуваалцаагүй ангиллын багцаас сонгохын тулд тохируулсан онцгой тохиолдолд зайлшгүй шаардлагатай (энэ сайт дээрх тохиолдол). Энэ нь \'санамсаргүй\' асуултыг дэд ангиллаас сонгохоор тохируулсан ба нэг буюу хэд хэдэн дэд ангилал нь санамсаргүй асуулт үүсгэсэн үндсэн ангиллаас өөр хуваалцах төлөвтэй үед тохиолддог.</p>
<p>Үндсэн ангиллын \'санамсаргүй\' асуултуудаас асуулт сонгох дараах асуултын ангилал Moodle 1.9 хувилбарт шилжихэд \'санамсаргүй\' асуулттай ангиллын хуваалцах төлөвтэй ижил хуваалцах төлөвтэй болно. Дараах ангиллын хуваалцах төлөв өөрчлөгдөнө. Хамаарах асуултыг эдгээр сорилтоос хасах хүртэл одоо байгаа бүх сорил дээр байх болно.</p>';
$string['cwrqpfsnoprob'] = '\'Дэд ангиллаас асуулт сонгох санамсаргүй асуулт\' нь танай сайтын асуултын ангилалд хамаарахгүй.';
$string['decimalplacesingrades'] = 'Үнэлгээ дэх аравтын орон';
$string['defaultfor'] = '{$a}-н өгөгдмөл утга';
$string['defaultinfofor'] = '\'{$a}\' сэдвийн хуваалцсан асуултын өгөгдмөл ангилал.';
$string['defaultmark'] = 'Өгөгдмөл дүн';
$string['defaultmarkmustbepositive'] = 'Өгөгдмөл дүн нь эерэг байх ёстой.';
$string['deletecoursecategorywithquestions'] = 'Энэ хичээлийн ангилалтай холбоотой асуултын санд асуултууд байна. Хэрэв та үргэлжлүүлбэл тэдгээр нь устах болно. Та асуултын сангийн интерфэйсийг ашиглан тэдгээрийг эхлээд зөөж болно.';
$string['deletequestioncheck'] = 'Та \'{$a}\'-г устгахдаа итгэлтэй байна уу?';
$string['deletequestionscheck'] = 'Та дараах асуултыг устгахдаа итгэлтэй байна уу?<br /><br />{$a}';
$string['deletingbehaviour'] = '\'{$a}\' асуултын шинжийг устгаж байна';
$string['deletingqtype'] = '\'{$a}\' асуултын төрлийг устгаж байна';
$string['didnotmatchanyanswer'] = '[Ямар ч хариулт тохирохгүй байна]';
$string['disabled'] = 'Идэвхгүй болгосон';
$string['displayoptions'] = 'Харуулах сонголтууд';
$string['disterror'] = '{$a} хуваарилалт нь асуудал үүсгэсэн';
$string['donothing'] = 'Файл хуулах, зөөх, холбоосыг өөрчлөх шаардлагагүй.';
$string['editcategories'] = 'Ангиллыг засварлах';
$string['editcategories_help'] = 'Бүх зүйлийг нэг том жагсаалтад оруулахын оронд асуултыг ангилал, дэд ангилалд хувааж болно.

Ангилал бүр нь тухайн ангиллын асуултыг хаана ашиглаж болохыг тодорхойлдог хамрах хүрээтэй. Үүнд:

* Үйл ажиллагааны хамрах хүррээ - Зөвхөн үйл ажиллагааны модульд байгаа асуултууд
* Хичээлийн хамрах хүрээ - Сургалтын бүх үйл ажиллагааны модульд байгаа асуултууд
* Хичээлийн ангиллын хамрах хүрээ - Хичээлийн ангиллын бүх үйл ажиллагааны модуль, хичээлд байгаа асуултууд
* Системийн хамрах хүрээ - Сайт дээрх бүх хичээл, үйл ажиллагаанд байгаа асуултууд

Асуултыг тодорхой ангиллаас сонгон авдаг тул санамсаргүй асуултад ангиллыг бас ашигладаг.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Ангиллыг засварлах';
$string['editingcategory'] = 'Ангиллыг засварлаж байна';
$string['editingquestion'] = 'Асуултыг засварлаж байна';
$string['editquestion'] = 'Ангиллыг засварлах';
$string['editquestions'] = 'Асуултыг засварлах';
$string['editthiscategory'] = 'Энэ ангиллыг засварлах';
$string['emptyxml'] = 'Үл мэдэгдэх алдаа - хоосон imsmanifest.xml';
$string['enabled'] = 'Идэвхжүүлсэн';
$string['erroraccessingcontext'] = 'Хамрах хүрээнд хандах боломжгүй';
$string['errordeletingquestionsfromcategory'] = '{$a} ангиллын асуултыг устгахад алдаа гарлаа.';
$string['errorduringpost'] = 'Дараах боловсруулалтын явцад алдаа гарлаа!';
$string['errorduringpre'] = 'Өмнөх боловсруулалтын явцад алдаа гарлаа!';
$string['errorduringproc'] = 'Боловсруулалтын явцад алдаа гарлаа!';
$string['errorduringregrade'] = '{$a->stateid} төлөвт шилжих {$a->qid} асуултыг дахин оноож чадсангүй.';
$string['errorfilecannotbecopied'] = 'Алдаа: {$a} файлыг хуулж чадсангүй.';
$string['errorfilecannotbemoved'] = 'Алдаа: {$a} файлыг зөөж чадсангүй.';
$string['errorfileschanged'] = 'Алдаа: маягтыг харуулснаас хойш асуултын холбогдсон файлууд өөрчлөгдсөн.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Асуулт ({$a}) нь сорилд өөр өөр байрлалд өөр өөр жинтэй нэгээс олон удаа гарч ирнэ. Одоогоор үүнийг статистикийн тайлан дэмжихгүй байгаа ба энэ нь асуултын статистикийг бодитой бус болгож болзошгүй.';
$string['errormanualgradeoutofrange'] = '{$a->name} асуултын {$a->grade} үнэлгээ нь 0 ба {$a->maxgrade} хооронд биш байна. Оноо, сэтгэгдэл хадгалагдаагүй байна.';
$string['errormovingquestions'] = '{$a} ID дугаартай асуултыг зөөх явцад алдаа гарлаа.';
$string['errorpostprocess'] = 'Дараах боловсруулалтын явцад алдаа гарлаа!';
$string['errorpreprocess'] = 'Өмнөх боловсруулалтын явцад алдаа гарлаа!';
$string['errorprocess'] = 'Боловсруулалтын явцад алдаа гарлаа!';
$string['errorprocessingresponses'] = 'Таны хариултыг боловсруулах явцад алдаа гарлаа ({$a}). Үргэлжлүүлэх товчийг дараад өмнөх хуудсанд буцаж очоод дахин оролдоно уу.';
$string['errorsavingcomment'] = '{$a->name} асуултын тайлбарыг өгөгдлийн санд хадгалахад алдаа гарлаа.';
$string['errorsavingflags'] = 'Флагийн төлөвийг хадгалахад алдаа гарлаа.';
$string['errorupdatingattempt'] = 'Өгөгдлийн сан дахь {$a->id} оролдлогыг шинэчлэхэд алдаа гарлаа.';
$string['eventquestioncategorycreated'] = 'Асуултын ангиллыг үүсгэсэн';
$string['eventquestioncategorydeleted'] = 'Асуултын ангиллыг устгасан';
$string['eventquestioncategorymoved'] = 'Асуултын ангиллыг зөөсөн';
$string['eventquestioncategoryupdated'] = 'Асуултын ангиллыг шинэчилсэн';
$string['eventquestioncategoryviewed'] = 'Асуултын ангиллыг харсан';
$string['eventquestioncreated'] = 'Асуултыг үүсгэсэн';
$string['eventquestiondeleted'] = 'Асуултыг устгасан';
$string['eventquestionmoved'] = 'Асуултыг зөөсөн';
$string['eventquestionsexported'] = 'Асуултыг экспортолсон';
$string['eventquestionsimported'] = 'Асуултыг импортолсон';
$string['eventquestionupdated'] = 'Асуултыг шинэчилсэн';
$string['eventquestionviewed'] = 'Асуултыг харсан';
$string['export'] = 'Экспорт';
$string['exportasxml'] = 'Moodle XML байдлаар экспортлох';
$string['exportcategory'] = 'Экспортын ангилал';
$string['exportcategory_help'] = 'Энэ тохиргоо нь экспортолсон асуултын ангиллыг тодорхойлно.

GIFT болон Moodle XML зэрэг импортын тодорхой формат нь ангилал, хамрах хүрээний өгөгдлийг экспортын файлд оруулахыг зөвшөөрч, импортлох үед (сонголтоор) дахин үүсгэх боломжийг олгодог. Шаардлагатай бол харгалзах сонголтыг хийнэ.';
$string['exporterror'] = 'Экспортлох явцад алдаа гарлаа!';
$string['exportfilename'] = 'асуултууд';
$string['exportnameformat'] = '%y%m%d-%H%M';
$string['exportonequestion'] = 'Энэ асуултыг Moodle XML форматаар татаж авах';
$string['exportquestions'] = 'Асуултыг файл руу экспортлох';
$string['exportquestions_help'] = 'Энэ функц нь асуултын бүрэн ангиллыг (болон дурын дэд ангиллыг) файлд экспортлох боломжийг олгодог. Сонгосон файлын форматаас хамааран зарим асуултын өгөгдөл, асуултын төрлийг экспортлохгүй байж болохыг анхаарна уу.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Санал хүсэлт';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Танд асуултыг зөөх гэж байгаа газраас файлыг устгах зөвшөөрөл байхгүй тул асуултын файлыг зөөх боломжгүй.';
$string['filecantmoveto'] = 'Танд асуултыг зөөх гэж буй газарт файл нэмэх зөвшөөрөл байхгүй тул асуултын файлыг зөөх эсвэл хуулах боломжгүй.';
$string['fileformat'] = 'Файлын формат';
$string['filesareacourse'] = 'хичээлийн файлын хэсэг';
$string['filesareasite'] = 'сайтын файлын хэсэг';
$string['filestomove'] = 'Файлыг {$a} руу зөөх/хуулах эсэх?';
$string['fillincorrect'] = 'Зөв хариултыг бөглөнө үү';
$string['filterbytags'] = 'Тагаар шүүх...';
$string['firsttry'] = 'Эхний оролдлого';
$string['flagged'] = 'Тэмдэглэсэн';
$string['flagthisquestion'] = 'Энэ асуултыг тэмдэглэх';
$string['formquestionnotinids'] = 'Маягт нь questionids дотор байхгүй асуултыг агуулсан';
$string['fractionsnomax'] = 'Хариултын аль нэг нь 100% оноотой байх ёстой тул энэ асуултад бүрэн оноо авах боломжтой.';
$string['generalfeedback'] = 'Ерөнхий санал хүсэлт';
$string['generalfeedback_help'] = 'Асуултыг бөглөсний дараа суралцагчид ерөнхий санал хүсэлтийг харуулна. Асуултын төрөл, суралцагчийн өгсөн хариулт зэргээс хамаарах тодорхой санал хүсэлтээс ялгаатай нь бүх суралцагчид ижил ерөнхий санал хүсэлтийн бичвэрийг харуулдаг.

Та ерөнхий санал хүсэлтийг ашиглан суралцагчид бүрэн хариултыг өгч, асуултыг ойлгоогүй тохиолдолд ашиглаж болох нэмэлт мэдээллийн холбоосыг өгч болно.';
$string['getcategoryfromfile'] = 'Файлаас ангилал авах';
$string['getcontextfromfile'] = 'Файлаас сэдэв авах';
$string['hintn'] = 'Дохио {no}';
$string['hintnoptions'] = 'Дохионы {no} сонголтууд';
$string['hinttext'] = 'Дохио бичвэр';
$string['howquestionsbehave'] = 'Асуулт хэрхэн ажилладаг вэ';
$string['howquestionsbehave_help'] = 'Суралцагч шалгалтын асуулттай төрөл бүрийн аргаар харилцах боломжтой. Жишээлбэл, та суралцагчийг үнэлэх эсвэл санал хүсэлт авахаас өмнө асуулт бүрийн хариултыг оруулаад дараа нь шалгалтаа бүхэлд нь авч болно. Энэ нь \'Хойшлогдсон санал хүсэлт\' горим байх болно.

Эсвэл та суралцагчид асуулт бүрийг илгээж, шууд санал хүсэлтээ авч болох ба суралцагч тухайн үед зөв хийж чадаагүй тохиолдолд цөөн оноо авахын тулд дахин оролдох боломжийг олгож болно. Энэ нь \'Олон оролдлого бүхий интерактив\' горим байх болно.

Эдгээр нь хамгийн түгээмэл хэрэглэгддэг хоёр хэлбэр болно.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID дугаар';
$string['idnumber_help'] = 'Хэрэв ашигласан бол ID дугаар нь асуултын ангилал бүрд давтагдашгүй байх ёстой. Энэ нь заримдаа хэрэгцээтэй боловч ихэвчлэн хоосон орхиж болох асуултыг тодорхойлох өөр аргыг өгдөг.';
$string['ignorebroken'] = 'Эвдэрсэн холбоосыг алгасах';
$string['import'] = 'Импорт';
$string['importcategory'] = 'Импортын ангилал';
$string['importcategory_help'] = 'Энэ тохиргоо нь импортолсон асуултыг оруулах ангиллыг тодорхойлдог.

GIFT, Moodle XML зэрэг зарим импортын формат нь импортын файлд ангилал, хамрах хүрээний өгөгдлийг агуулж болно. Сонгосон ангиллаас илүү энэ өгөгдлийг ашиглахын тулд тохирох сонголтыг хийнэ. Импортын файлд заасан ангилал байхгүй бол тэдгээрийг үүсгэнэ.';
$string['importerror'] = 'Импортыг боловсруулах явцад алдаа гарлаа';
$string['importerrorquestion'] = 'Асуултыг импортлоход алдаа гарлаа';
$string['importfromcoursefiles'] = '... эсвэл импортлох хичээлийн файлыг сонгоно уу.';
$string['importfromupload'] = 'Байршуулах файлаа сонгох ...';
$string['importingquestions'] = 'Файлаас {$a} асуулт импортолж байна';
$string['importparseerror'] = 'Импортын файлыг задлан шинжлэхэд алдаа гарлаа. Ямар ч асуултыг импортлоогүй байна. Дурын сайн асуултыг импортлохын тулд \'Алдаа гарвал зогсох\' гэдгийг \'Үгүй\' болгоод дахин оролдоно уу.';
$string['importquestions'] = 'Файлаас асуулт импортлох';
$string['importquestions_help'] = 'Энэ функц нь төрөл бүрийн форматтай асуултыг текст файлаар импортлох боломжийг олгодог. Файл нь UTF-8 кодчилол ашиглах ёстойг анхаарна уу.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Таны сонгосон файл UTF-8 тэмдэгтийн кодчилол ашиглаагүй байна. {$a} файл нь UTF-8 ашиглах ёстой.';
$string['importwrongfiletype'] = 'Таны сонгосон файлын төрөл ({$a->actualtype}) нь энэ импортын форматын ({$a->expectedtype}) хүлээгдэж буй төрөлтэй таарахгүй байна.';
$string['impossiblechar'] = 'Хаалтын тэмдэг байх боломжгүй {$a} тэмдэгт илэрсэн';
$string['includesubcategories'] = 'Дэд ангиллын асуултыг харуулах';
$string['incorrect'] = 'Буруу';
$string['incorrectfeedback'] = 'Дурын буруу хариултын хувьд';
$string['incorrectfeedbackdefault'] = 'Таны хариулт буруу байна.';
$string['information'] = 'Мэдээлэл';
$string['invalidanswer'] = 'Бүрэн бус хариулт';
$string['invalidarg'] = 'Хүчинтэй аргумент байхгүй эсвэл серверийн тохиргоо буруу байна';
$string['invalidcategoryidforparent'] = 'Үндсэн ангиллын ID дугаар буруу байна!';
$string['invalidcategoryidtomove'] = 'Зөөх ангиллын ID буруу байна!';
$string['invalidconfirm'] = 'Баталгаажуулах тэмдэгт мөр буруу байна';
$string['invalidcontextinhasanyquestions'] = 'question_context_has_any_questions руу буруу сэдэв дамжуулсан';
$string['invalidgrade'] = 'Үнэлгээ нь ({$a}) үнэлгээний сонголттой таарахгүй байна - асуултыг алгассан.';
$string['invalidpenalty'] = 'Хүчингүй торгууль';
$string['invalidwizardpage'] = 'Буруу эсвэл алхам алхмаарх хуудсыг заагаагүй байна!';
$string['lastmodifiedby'] = 'Хамгийн сүүлд өөрчилсөн';
$string['lasttry'] = 'Сүүлийн оролдлого';
$string['linkedfiledoesntexist'] = 'Холбогдсон файл {$a} байхгүй байна';
$string['makechildof'] = '\'{$a}\'-н салбар болгох';
$string['makecopy'] = 'Хуулбар хийх';
$string['maketoplevelitem'] = 'Дээд түвшинд зөөх';
$string['manualgradeinvalidformat'] = 'Энэ нь хүчинтэй тоо биш байна.';
$string['manualgradeoutofrange'] = 'Энэ үнэлгээ нь хүчинтэй хязгаараас гадуур байна.';
$string['manuallygraded'] = 'Дараах тайлбартайгаар гараар үнэлэгдсэн {$a->mark}: {$a->comment}';
$string['mark'] = 'Оноо';
$string['markedoutof'] = 'Авсан оноо';
$string['markedoutofmax'] = '{$a} оноотой';
$string['markoutofmax'] = '{$a->max}-с {$a->mark} оноо авлаа';
$string['marks'] = 'Оноо';
$string['matchgrades'] = 'Тохирох үнэлгээ';
$string['matchgrades_help'] = 'Импортолсон үнэлгээ нь хүчинтэй үнэлгээний тогтсон жагсаалтын аль нэгтэй тохирч байх ёстой - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2811, 14.2811,. , 0 (мөн сөрөг утгууд). Үгүй бол дараах хоёр сонголт байна. Үүнд:

* Үнэлгээ нь жагсаалтад ороогүй тохиолдолд гарах алдаа - Асуулт нь жагсаалтад олдоогүй дурын үнэлгээг агуулж байвал алдаа гарч, уг асуултыг импортлохгүй.
* Жагсаалтад ороогүй хамгийн ойрын үнэлгээ - Жагсаалт дахь утгатай тохирохгүй үнэлгээ олдвол тухайн үнэлгээг жагсаалтын хамгийн ойрын утга болгон өөрчилнө.';
$string['matchgradeserror'] = 'Үнэлгээ нь жагсаалтад ороогүй тохиолдолд гарах алдаа';
$string['matchgradesnearest'] = 'Жагсаалтад ороогүй хамгийн ойрын үнэлгээ';
$string['missingcourseorcmid'] = 'Асуултыг хэвлэхийн тулд courseid эсвэл cmid өгөх шаардлагатай.';
$string['missingcourseorcmidtolink'] = 'Асуултыг засварлах холбоосыг авахын тулд courseid эсвэл cmid өгөх шаардлагатай.';
$string['missingimportantcode'] = 'Энэ асуултын төрөлд чухал код дутуу байна: {$a}.';
$string['missingoption'] = '{$a} хаах асуултад түүний сонголтууд дутуу байна';
$string['modified'] = 'Хамгийн сүүлд хадгалсан';
$string['move'] = '{$a}-аас зөөж, холбоосыг өөрчилнө үү.';
$string['movecategory'] = 'Ангиллыг зөөх';
$string['movedquestionsandcategories'] = 'Асуулт, асуултын ангиллыг {$a->oldplace}-аас {$a->newplace} руу зөөсөн.';
$string['movelinksonly'] = 'Холбоосын чиглэлийг өөрчил, файл зөөж, хуулж болохгүй.';
$string['moveq'] = 'Асуултыг зөөх';
$string['moveqtoanothercontext'] = 'Асуултыг өөр сэдэвт шилжүүлнэ үү.';
$string['moveto'] = 'Зөөх';
$string['movingcategory'] = 'Ангиллыг зөөж байна';
$string['movingcategoryandfiles'] = 'Та {$a->name} ангилал, бүх дэд ангиллыг "{$a->contextto}" сэдэвт зөөхөд итгэлтэй байна уу?<br /> Бид {$a->fromareaname} доторх асуултаас холбосон {$a->urlcount} файлыг илрүүллээ. Та тэдгээрийг {$a->toareaname} руу хуулах эсвэл зөөхийг хүсэж байна уу?';
$string['movingcategorynofiles'] = 'Та {$a->name} ангилал, бүх дэд ангиллыг "{$a->contextto}" сэдэвт зөөхөд итгэлтэй байна уу?';
$string['movingquestions'] = 'Асуулт болон дурын файлыг зөөж байна';
$string['movingquestionsandfiles'] = 'Та {$a->questions} асуултыг <strong>"{$a->tocontext}"</strong> сэдэвт шилжүүлэхэд итгэлтэй байна уу?<br /> Бид {$a->fromareaname} доторх асуултаас холбосон <strong>{$a->urlcount} файл</strong> илрүүллээ. Та эдгээрийг {$a->toareaname} руу хуулах эсвэл зөөхийг хүсэж байна уу?';
$string['movingquestionsnofiles'] = 'Та {$a->questions} асуултыг <strong>"{$a->tocontext}"</strong> сэдэвт шилжүүлэхэд итгэлтэй байна уу?<br /> Энд {$a->fromareaname} доторх асуултаас холбосон <strong>файл байхгүй байна</strong>.';
$string['needtochoosecat'] = 'Та энэ асуултыг зөөх ангиллыг сонгох эсвэл \'цуцлах\' товчийг дарах хэрэгтэй.';
$string['nocate'] = 'Ийм {$a} ангилал байхгүй!';
$string['nopermissionadd'] = 'Танд энд асуулт нэмэх зөвшөөрөл байхгүй.';
$string['nopermissionedit'] = 'Танд энд асуулт засварлах зөвшөөрөл байхгүй.';
$string['nopermissionmove'] = 'Танд эндээс асуулт шилжүүлэх зөвшөөрөл байхгүй. Та асуултаа энэ ангилалд хадгалах эсвэл шинэ асуулт болгон хадгалах шаардлагатай.';
$string['noprobs'] = 'Таны асуултын өгөгдлийн санд ямар ч асуудал олдсонгүй.';
$string['noquestionbanks'] = 'Асуултын сангийн нэмэлт хэрэгсэл олдсонгүй.';
$string['noquestions'] = 'Экспортлох боломжтой асуулт олдсонгүй. Асуулт бүхий экспорт хийх ангиллыг сонгосон эсэхээ шалгаарай.';
$string['noquestionsinfile'] = 'Импортын файлд асуулт байхгүй байна';
$string['noresponse'] = '[Хариу байхгүй]';
$string['notagfiltersapplied'] = 'Таг шүүлтүүр ашиглаагүй';
$string['notanswered'] = 'Хариулаагүй';
$string['notchanged'] = 'Сүүлийн оролдлогоос хойш өөрчлөгдөөгүй';
$string['notenoughanswers'] = 'Энэ төрлийн асуултад хамгийн багадаа {$a} хариулт шаардлагатай';
$string['notenoughdatatoeditaquestion'] = 'Асуултын id, ангиллын id болон асуултын төрлийг заагаагүй.';
$string['notenoughdatatomovequestions'] = 'Та зөөхийг хүсэж байгаа асуултынхаа асуултын ID дугаарыг оруулах шаардлагатай.';
$string['notflagged'] = 'Тэмдэглээгүй';
$string['notgraded'] = 'Үнэлээгүй';
$string['notshown'] = 'Харуулаагүй';
$string['notyetanswered'] = 'Одоогоор хариу өгөөгүй байна';
$string['notyourpreview'] = 'Энэ урьдчилан үзэх нь танд хамаарахгүй';
$string['novirtualquestiontype'] = '{$a} асуултын төрөлд бодит асуулт байхгүй';
$string['numqas'] = 'Асуултын оролдлого байхгүй';
$string['numquestions'] = 'Асуулт байхгүй';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} нуусан +{$a->numdraft} ноорог)';
$string['options'] = 'Сонголтууд';
$string['page-question-category'] = 'Асуултын ангиллын хуудас';
$string['page-question-edit'] = 'Асуултыг засварлах хуудас';
$string['page-question-export'] = 'Асуулт экспортлох хуудас';
$string['page-question-import'] = 'Асуулт импортлох хуудас';
$string['page-question-x'] = 'Дурын асуултын хуудас';
$string['parent'] = 'Үндсэн';
$string['parentcategory'] = 'Үндсэн ангилал';
$string['parentcategory_help'] = 'Үндсэн ангилал нь шинэ ангиллыг байршуулах ангилал болно. "Дээд" гэдэг нь тухайн ангилал өөр ямар ч ангилалд ороогүй гэсэн үг юм. Ангиллын сэдвийг тод үсгээр харуулав. Сэдэв бүрд хамгийн багадаа нэг ангилал байх ёстой.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = '**-ийн өмнөх хаалт {$a}** дотор зөв хаагдаагүй байна';
$string['parenthesisinproperstart'] = '**-ийн өмнөх хаалт {$a}**-д зөв эхлээгүй байна';
$string['parsingquestions'] = 'Импортын файлаас асуултыг задлан шинжилж байна.';
$string['partiallycorrect'] = 'БҮрэн бус зөв байна';
$string['partiallycorrectfeedback'] = 'Дурын бүрэн бус зөв хариултын хувьд';
$string['partiallycorrectfeedbackdefault'] = 'Таны хариулт бүрэн бус зөв байна.';
$string['penaltyfactor'] = 'Торгуулийн хүчин зүйл';
$string['penaltyfactor_help'] = 'Энэ тохиргоо нь буруу хариулт бүрд хүрсэн онооны хэдэн хувийг хасахыг тодорхойлдог. Энэ нь шалгалтыг дасан зохицох горимд явуулсан тохиолдолд хэрэглэнэ.

Торгуулийн хүчин зүйл нь 0 ба 1 хоорондох тоо байх ёстой. 1-ийн торгуулийн хүчин зүйл нь тухайн суралцагч дурын кредит авахын тулд эхний хариултад зөв хариу зөв авах ёстой гэсэн үг. Торгуулийн хүчин зүйл 0 гэдэг нь тухайн суралцагч хүссэн үедээ оролдож бүрэн оноо авах боломжтой гэсэн үг.';
$string['penaltyforeachincorrecttry'] = 'Буруу оролдлого бүрийн торгууль';
$string['penaltyforeachincorrecttry_help'] = 'Асуултыг  \'Олон оролдлого бүхий интерактив\' эсвэл  \'Зохицох горим\' ашиглан ажиллуулах үед суралцагч асуултаа зөв хариулахын тулд хэд хэдэн оролдлого хийж болох ба энэ сонголт нь буруу оролдлого бүрд ямар торгууль ногдуулахыг хянадаг.

Торгууль нь нийт асуултын дүнгийн эзлэх хувь тул асуулт нь гурван оноотой, торгууль нь 0.3333333 бол эхний удаа зөв авсан тохиолдолд 3 оноо, хоёр дахь удаа зөв авсан бол 2 оноо авна. Тэдний 1 нь гурав дахь оролдлого дээрээ зөв байна.

Зарим олон хэсэгтэй асуултын хувьд энэ онооны логикийг асуултын хэсэг бүрд тусад нь хэрэглэнэ. Дэлгэрэнгүй мэдээлэл нь асуултын төрлөөс шалтгаалах ба төвөгтэй байж болох ч суралцагчийн мэдлэгийг аль болох шударга үнэлэх зарчим болно.';
$string['permissionedit'] = 'Энэ асуултыг засварлах';
$string['permissionmove'] = 'Энэ асуултыг зөөх';
$string['permissionsaveasnew'] = 'Асуултыг шинэ асуулт болгон хадгалах';
$string['permissionto'] = 'Танд дараах зөвшөөрөл байна :';
$string['previewquestion'] = 'Асуултыг урьдчилан харах: {$a}';
$string['privacy:metadata:database:question'] = 'Тодорхой асуултын талаарх дэлгэрэнгүй мэдээлэл.';
$string['privacy:metadata:database:question:createdby'] = 'Асуултыг үүсгэсэн хүн.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Энэ асуултын талаарх ерөнхий санал хүсэлт.';
$string['privacy:metadata:database:question:modifiedby'] = 'Асуултыг хамгийн сүүлд шинэчилсэн хүн.';
$string['privacy:metadata:database:question:name'] = 'Асуултын нэр.';
$string['privacy:metadata:database:question:questiontext'] = 'Асуултын бичвэр.';
$string['privacy:metadata:database:question:timecreated'] = 'Энэ асуултыг үүсгэсэн огноо, цаг.';
$string['privacy:metadata:database:question:timemodified'] = 'Энэ асуултыг шинэчилсэн огноо, цаг.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Асуултыг оролдох алхам нь тухайн алхамд хамаарах нэмэлт өгөгдөлтэй байж болно. Өгөгдөл нь step_data хүснэгтэд хадгалагдана.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Өгөгдлийн нэгжийн нэр.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Өгөгдлийн нэгжийн утга.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Асуултын оролдлого бүр нь гүйцэтгэж эхлэхээс дуустал тэмдэглэх өөр өөр үе шатыг заах хэд хэдэн алхамтай байна. Энэ хүснэгт нь эдгээр алхам бүрийн мэдээллийг хадгалдаг.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Энэ асуултын оролдлогын үнэлгээг 1-ээс дээш үнэлэв.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Алхам шилжих төгсгөл дэх энэ асуултын оролдлогын алхмын төлөв.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Энэ алхам шилжиж эхэлсэн огноо, цаг.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Алхам шилжилтийг хийсэн хэрэглэгч.';
$string['privacy:metadata:database:question_attempts'] = 'Тодорхой асуултад оролдлого хийсэн талаарх мэдээлэл.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Хэрэглэгч оролдлогын хүрээнд энэ асуултыг тэмдэглэсэн болохыг харуулж байна.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Асуултын хариултын хураангуй.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Асуултын оролдлогыг шинэчилсэн цаг.';
$string['privacy:metadata:database:question_bank_entries'] = 'Тодорхой асуултын сангийн бичлэгийн талаарх дэлгэрэнгүй мэдээлэл.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Асуултын сангийн бичлэгийг эзэмшигч.';
$string['privacy:metadata:link:qbehaviour'] = 'Асуулт дэд систем нь Question Behavior нэмэлт хэрэгслийн төрлийг ашигладаг.';
$string['privacy:metadata:link:qformat'] = 'Асуулт дэд систем нь асуултыг төрөл бүрийн форматаар импортлох, экспортлох зорилгоор Question Format нэмэлт хэрэгслийн төрлийг ашигладаг.';
$string['privacy:metadata:link:qtype'] = 'Асуулт дэд систем нь төрөл бүрийн төрлийн асуултыг агуулсан Question Type нэмэлт хэрэгсэлтэй харилцдаг.';
$string['published'] = 'хуваалцсан';
$string['qbanknotfound'] = '\'{$a}\' асуултын сангийн нэмэлт хэрэгсэл байхгүй эсвэл танигдаагүй байна.';
$string['qtypeveryshort'] = 'Т';
$string['question_version'] = 'Асуултын хувилбар';
$string['questionaffected'] = '<a href="{$a->qurl}">Асуулт "{$a->name}" ({$a->qtype})</a> нь тухайн асуултын ангилалд байгаа хэдий ч "{$a->coursename}" өөр хичээлийн <a href="{$a->qurl}">сорилд "{$a->quizname}"</a> бас ашиглагдаж байна.';
$string['questionbank'] = 'Асуултын сан';
$string['questionbanknavigation'] = 'Асуултын сангийн гуравдагч удирдлага';
$string['questionbehaviouradminsetting'] = 'Асуултын шинжийн тохиргоо';
$string['questionbehavioursdisabled'] = 'Идэвхгүй болгох асуултын шинж';
$string['questionbehavioursdisabledexplained'] = 'Нээгдэх цэсэд харуулахгүй шинжийн таслалаар тусгаарласан жагсаалтыг оруулна уу.';
$string['questionbehavioursorder'] = 'Асуултын шинжийн дараалал';
$string['questionbehavioursorderexplained'] = 'Нээгдэх цэсэд харуулах шинжийн таслалаар тусгаарласан жагсаалтыг оруулна уу.';
$string['questioncategories'] = 'Асуултын ангилал';
$string['questioncategory'] = 'Асуултын ангилал';
$string['questioncatsfor'] = '\'{$a}\' асуултын ангилал';
$string['questiondoesnotexist'] = 'Энэ асуулт байхгүй байна';
$string['questionformtagheader'] = '{$a} таг';
$string['questionidmismatch'] = 'Асуултын id таарахгүй байна';
$string['questionloaderror'] = 'Асуултын сонголтуудыг ачаалж чадсангүй.';
$string['questionname'] = 'Асуултын нэр';
$string['questionnamecopy'] = '{$a} (хуулах)';
$string['questionno'] = '{$a} асуулт';
$string['questionpreviewdefaults'] = 'Асуултыг урьдчилан харах өгөгдмөл тохиргоо';
$string['questionpreviewdefaults_desc'] = 'Өгөгдмөл тохиргоог хэрэглэгч асуултын сан дахь асуултыг анх харуулахад ашигладаг. Хэрэглэгч асуултыг урьдчилан харсны дараа тэдний хувийн тохиргоог хэрэглэгчийн сонголт болгон хадгална.';
$string['questions'] = 'Асуултууд';
$string['questionsaveerror'] = 'Асуултыг хадгалах явцад алдаа гарлаа - ({$a})';
$string['questionsinuse'] = '(* одоор тэмдэглэсэн асуултыг дурын газарт, жишээ нь сорилд ашигладаг. Иймээс та үргэлжлүүлбэл эдгээр асуулт бодитоор устахгүй, зүгээр л харагдахгүй болно.)';
$string['questionsmovedto'] = 'Ашиглаж буй асуултыг хичээлийн үндсэн ангилал "{$a}" руу шилжүүлсэн.';
$string['questionsrescuedfrom'] = '{$a} сэдвээс хадгалсан асуултууд.';
$string['questionsrescuedfrominfo'] = 'Эдгээр асуултыг (зарим нь нуусан байж болно) зарим сорил эсвэл бусад үйл ажиллагаанд ашигласан хэвээр байгаа тул {$a} сэдвийг устгах үед хадгалсан байна.';
$string['questiontags'] = 'Асуултыг таг';
$string['questiontext'] = 'Асуултын бичвэр';
$string['questiontype'] = 'Асуултын төрөл';
$string['questionuse'] = 'Энэ үйл ажиллагаанд асуулт ашиглах';
$string['questionvariant'] = 'Асуултын хувилбар';
$string['questionx'] = '{$a} асуулт';
$string['requiresgrading'] = 'Үнэлгээ шаарддаг';
$string['responsehistory'] = 'Хариу үйлдлийн түүх';
$string['restart'] = 'Дахин эхлэх';
$string['restartwiththeseoptions'] = 'Урьдчилан үзэх сонголтыг хадгалаад дахин эхлүүлэх';
$string['restoremultipletopcats'] = 'Нөөц файл нь {$a} сэдвийн нэгээс олон дээд түвшний асуултын ангиллыг агуулж байна.';
$string['reviewresponse'] = 'Хариултыг хянах';
$string['rightanswer'] = 'Зөв хариулт';
$string['rightanswer_help'] = 'Зөв хариултын автоматаар үүсгэсэн хураангуй. Энэ нь хязгаарлагдмал байж болох тул та асуултын ерөнхий санал хүсэлтэд зөв шийдлийг тайлбарлаж, уг сонголтыг идэвхгүй болгож болно.';
$string['save'] = 'Хадгалах';
$string['savechangesandcontinueediting'] = 'Өөрчлөлтийг хадгалж, үргэлжлүүлэн засварлах';
$string['saved'] = 'Хадгалсан: {$a}';
$string['saveflags'] = 'Флагийн төлөвийг хадгалах';
$string['selectacategory'] = 'Ангилал сонгох:';
$string['selectaqtypefordescription'] = 'Асуултын тайлбарыг нь харахын тулд түүний төрлийг сонгоно уу.';
$string['selectcategoryabove'] = 'Дээрээс ангилал сонгох';
$string['selectquestionsforbulk'] = 'Багц үйлдлийн асуултыг сонгох';
$string['settingsformultipletries'] = 'Олон оролдлого';
$string['shareincontext'] = '{$a}-н хүрээнд хуваалцах';
$string['showhidden'] = 'Хуучин асуултыг харуулах';
$string['showmarkandmax'] = 'Дүн болон хамгийн өндөр оноог харуулах';
$string['showmaxmarkonly'] = 'Зөвхөн хамгийн өндөр оноог харуулах';
$string['shown'] = 'Харуулсан';
$string['shownumpartscorrect'] = 'Зөв хариултын тоог харуулах';
$string['shownumpartscorrectwhenfinished'] = 'Асуулт дууссаны дараа зөв хариултын тоог харуулах';
$string['showquestiontext'] = 'Асуултын жагсаалтад асуултын бичвэрийг харуулах эсэх?';
$string['showquestiontext_full'] = 'Тийм, зураг, медиа гэх мэт.';
$string['showquestiontext_off'] = 'Үгүй';
$string['showquestiontext_plain'] = 'Тийм, зөвхөн бичвэр';
$string['specificfeedback'] = 'Тодорхой санал хүсэлт';
$string['specificfeedback_help'] = 'Суралцагчийн өгсөн хариултаас хамаарах санал хүсэлт.';
$string['started'] = 'Эхэлсэн';
$string['state'] = 'Төлөв';
$string['step'] = 'Алхам';
$string['steps'] = 'Алхмууд';
$string['stoponerror'] = 'Алдаа гарахад зогсох';
$string['stoponerror_help'] = 'Энэ тохиргоо нь алдаа илэрсэн үед импортлох процессыг зогсоож, ямар ч асуултыг импортлохгүй, эсвэл алдаатай асуултыг орхиж, хүчинтэй асуултыг импортлох эсэхийг тодорхойлно.';
$string['submissionoutofsequence'] = 'Дараалалгүй хандалт. Асуулт дээр ажиллахдаа буцах товчийг дарж болохгүй.';
$string['submissionoutofsequencefriendlymessage'] = 'Та ердийн дарааллаас өөр өгөгдөл оруулсан байна. Энэ нь хөтчийнхөө Буцах эсвэл Урагшаа товчийг ашигласан тохиолдолд гардаг; Сорилын үед эдгээрийг бүү ашигла. Түүнчлэн энэ нь хуудсыг ачаалж байх үед ямар нэгэн зүйл дээр дарвал тохиолдож болно. Үргэлжлүүлэхийн тулд <strong>Үргэлжлүүлэх</strong> дээр дарна уу.';
$string['submit'] = 'Илгээх';
$string['submitandfinish'] = 'Илгээгээд дуусгах';
$string['submitted'] = 'Илгээх: {$a}';
$string['tagarea_question'] = 'Асуултууд';
$string['technicalinfo'] = 'Техникийн мэдээлэл';
$string['technicalinfo_help'] = 'Энэхүү техникийн мэдээлэл нь зөвхөн шинэ асуултын төрөл дээр ажиллаж буй хөгжүүлэгчдэд хэрэгтэй байж магадгүй. Үүнийг асуудлыг асуултаар оношлоход хэрэглэж болно.';
$string['technicalinfomaxfraction'] = 'Хамгийн их бутархай: {$a}';
$string['technicalinfominfraction'] = 'Хамгийн бага бутархай: {$a}';
$string['technicalinfoquestionsummary'] = 'Асуултын хураангуй: {$a}';
$string['technicalinforesponsesummary'] = 'Хариултын хураангуй: {$a}';
$string['technicalinforightsummary'] = 'Зөв хариултын хураангуй: {$a}';
$string['technicalinfostate'] = 'Хариултын төлөв: {$a}';
$string['technicalinfovariant'] = 'Хариултын хувилбар: {$a}';
$string['tofilecategory'] = 'Файлд ангиллыг бичих';
$string['tofilecontext'] = 'Файлд сэдвийг бичих';
$string['topfor'] = '{$a}-н дээд';
$string['uninstallbehaviour'] = 'Энэ асуултын шинжийг устгана.';
$string['uninstallqtype'] = 'Энэ асуултын төрлийг устгана.';
$string['unknown'] = 'Тодорхойгүй';
$string['unknownbehaviour'] = 'Тодорхойгүй шинж: {$a}.';
$string['unknownorunhandledtype'] = 'Тодорхойгүй эсвэл шийдэгдээгүй асуултын төрөл: {$a}';
$string['unknownquestion'] = 'Тодорхойгүй асуулт: {$a}.';
$string['unknownquestioncatregory'] = 'Тодорхойгүй асуултын ангилал: {$a}.';
$string['unknownquestiontype'] = 'Тодорхойгүй асуултын төрөл: {$a}.';
$string['unknowntolerance'] = 'Тодорхойгүй зөвшөөрөгдөх төрөл {$a}';
$string['unpublished'] = 'хуваалцаагүй';
$string['unusedcategorydeleted'] = 'Хичээлийг устгасны дараа асуултыг ашиглахаа больсон тул энэ ангиллыг устгасан болно.';
$string['updatedisplayoptions'] = 'Харуулах сонголтыг шинэчлэх';
$string['upgradeproblemcategoryloop'] = 'Асуултын ангиллыг шинэчлэх үед асуудал илэрлээ. Ангиллын модонд гогцоо байна. Нөлөөлөлд өртсөн ангиллын id нь {$a} болно.';
$string['upgradeproblemcouldnotupdatecategory'] = '{$a->name} ({$a->id}) асуултын ангиллыг шинэчилж чадсангүй.';
$string['upgradeproblemunknowncategory'] = 'Асуултын ангиллыг шинэчлэх үед асуудал илэрлээ. {$a->id} ангилал нь байхгүй үндсэн {$a->parent} ангилалд хандсан байна. Асуудлыг засахын тулд үндсэн ангиллыг өөрчилсөн.';
$string['version_selection'] = 'Хувилбар {$a->version}';
$string['whethercorrect'] = 'Зөв эсэх';
$string['whethercorrect_help'] = 'Энэ нь \'Зөв\', \'Хэсэгчилсэн зөв\' эсвэл \'Буруу\' гэсэн бичвэр тайлбар болон ижил мэдээлэл бүхий дурын өнгөт тодруулгыг хамарна.';
$string['whichtries'] = 'Оролдож буй';
$string['withselected'] = 'Сонгосон';
$string['wrongprefix'] = 'Буруу форматтай нэрийн угтвар {$a}';
$string['xoutofmax'] = '{$a->max}-аас {$a->mark}';
$string['yougotnright'] = 'Таны зөв хариултын тоо {$a->num}.';
$string['youmustselectaqtype'] = 'Та асуултын төрлийг сонгох ёстой.';
$string['yourfileshoulddownload'] = 'Таны экспорт файлыг удахгүй татаж эхэлнэ. Хэрэв үгүй бол <a href="{$a}">энд дарна уу</a>.';
