<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'mn', version '4.3'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Заасан админ лавлах буруу байна';
$string['admindirname'] = 'Админ лавлах';
$string['admindirsetting'] = 'Маш цөөн веб хост /админыг хяналтын самбар эсвэл бусад зүйлд хандахын тулд тусгай URL хаяг болгон ашигладаг. Харамсалтай нь энэ нь Moodle админ хуудасны стандарт байршилтай зөрчилддөг. Та үүнийг суурилуулалтын админ лавлахын нэрийг өөрчилж, энд шинэ нэрийг оруулснаар засах боломжтой. Жишээ нь: <br /> <br /><b>moodleadmin</b><br /> <br />
     Энэ нь Moodle дээрх админ холбоосыг засах болно.';
$string['admindirsettinghead'] = 'Админ лавлахын тохиргоо ...';
$string['admindirsettingsub'] = 'Маш цөөн веб хост /админыг хяналтын самбар эсвэл бусад зүйлд хандахын тулд тусгай URL хаяг болгон ашигладаг. Харамсалтай нь энэ нь Moodle админ хуудасны стандарт байршилтай зөрчилддөг. Та үүнийг суурилуулалтын админ лавлахын нэрийг өөрчилж, энд шинэ нэрийг оруулснаар засах боломжтой. Жишээ нь: <br /> <br /><b>moodleadmin</b><br /> <br />
     Энэ нь Moodle дээрх админ холбоосыг засах болно.';
$string['availablelangs'] = 'Боломжит хэлний багц';
$string['caution'] = 'Анхааруулга';
$string['chooselanguage'] = 'Хэл сонгох';
$string['chooselanguagehead'] = 'Хэл сонгох';
$string['chooselanguagesub'] = 'Суулгах хэлээ сонгоно уу. Энэ хэлийг сайтын өгөгдмөл хэл болгон ашиглах боловч дараа нь өөрчилж болно.';
$string['cliadminemail'] = 'Шинэ админ хэрэглэгчийн цахим шуудангийн хаяг';
$string['cliadminpassword'] = 'Шинэ админ хэрэглэгчийн нууц үг';
$string['cliadminusername'] = 'Админ бүртгэлийн хэрэглэгчийн нэр';
$string['clialreadyconfigured'] = 'config.php тохиргооны файл байна. Энэ сайтад Moodle системийг суулгахын тулд admin/cli/install_database.php ашиглана уу.';
$string['clialreadyinstalled'] = 'config.php тохиргооны файл байна. Энэ сайтад Moodle системийг шинэчлэхийн тулд admin/cli/install_database.php ашиглана уу.';
$string['cliinstallfinished'] = 'Суурилуулалт амжилттай дууссан.';
$string['cliinstallheader'] = 'Moodle {$a} командын мөр суулгах програм';
$string['climustagreelicense'] = 'Интерактив бус горимд та --agree-license сонголтыг зааж өгөх замаар лицензийг зөвшөөрөх ёстой';
$string['cliskipdatabase'] = 'Өгөгдлийн сангийн суурилуулалтыг алгасаж байна.';
$string['clisupportemail'] = 'Дэмжлэгийн цахим шуудангийн хаяг';
$string['clitablesexist'] = 'Өгөгдлийн сангийн хүснэгтүүд байна; CLI суурилуултыг үргэлжлүүлэх боломжгүй.';
$string['compatibilitysettings'] = 'Таны РНР тохиргоог шалгаж байна ...';
$string['compatibilitysettingshead'] = 'Таны РНР тохиргоог шалгаж байна ...';
$string['compatibilitysettingssub'] = 'Moodle системийг зөв ажиллуулахын тулд таны сервер эдгээр бүх шалгалтыг давах ёстой';
$string['configfilenotwritten'] = 'Суулгах скрипт нь таны сонгосон тохиргоог агуулсан config.php файлыг автоматаар үүсгэх боломжгүй нь Moodle лавлах бичилт хийх боломжгүйтэй холбоотой байж магадгүй. Та Moodle системийн үндсэн лавлах доторх config.php нэртэй файлд дараах кодыг гараар хуулж болно.';
$string['configfilewritten'] = 'config.php файлыг амжилттай үүсгэлээ';
$string['configurationcomplete'] = 'Тохируулга дууслаа';
$string['configurationcompletehead'] = 'Тохируулга дууслаа';
$string['configurationcompletesub'] = 'Moodle таны тохиргоог Moodle суурилуулалтын үндсэн файлд хадгалахыг оролдсон.';
$string['database'] = 'Өгөгдлийн сан';
$string['databasehead'] = 'Өгөгдлийн сангийн тохиргоо';
$string['databasehost'] = 'Өгөгдлийн сангийн хост';
$string['databasename'] = 'Өгөгдлийн сангийн нэр';
$string['databasepass'] = 'Өгөгдлийн сангийн нууц үг';
$string['databaseport'] = 'Өгөгдлийн сангийн порт';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Өгөгдлийн сангийн драйвер сонгох';
$string['databasetypesub'] = 'Moodle нь хэд хэдэн төрлийн өгөгдлийн сангийн серверийг дэмждэг. Та ямар төрлийг ашиглахаа мэдэхгүй байгаа бол серверийн админтай холбогдоно уу.';
$string['databaseuser'] = 'Өгөгдлийн сангийн хэрэглэгч';
$string['dataroot'] = 'Өгөгдлийн лавлах';
$string['datarooterror'] = 'Таны заасан \'өгөгдлийн лавлах\' олдоkгүй эсвэл үүсгэгдээгүй байна. Замаа засах буюу тухайн лавлахыг гараар үүсгэнэ үү.';
$string['datarootpermission'] = 'Өгөгдлийн лавлахын зөвшөөрөл';
$string['datarootpublicerror'] = 'Таны заасан \'өгөгдлийн лавлах\' нь вебээр шууд хандах боломжтой тул та өөр лавлах ашиглах шаардлагатай.';
$string['dbconnectionerror'] = 'Бид таны заасан өгөгдлийн сантай холбогдож чадсангүй. Өгөгдлийн сангийн тохиргоогоо шалгана уу.';
$string['dbcreationerror'] = 'Өгөгдлийн сан үүсгэхэд алдаа гарлаа. Өгөгдсөн мэдээллийн сангийн нэрийг өгсөн тохиргоогоор үүсгэж чадсангүй';
$string['dbhost'] = 'Хост сервер';
$string['dbpass'] = 'Hууц үг';
$string['dbport'] = 'Порт';
$string['dbprefix'] = 'Хүснэгтийн угтвар';
$string['dbtype'] = 'Tөрөл';
$string['directorysettings'] = '<p>Moodle системийг суурилуулах байршлыг баталгаажуулна уу.</p>

<p><b>Веб хаяг:</b>
Moodle системд хандах бүтэн веб хаягийг зааж өгнө үү. Таны веб сайтад олон URL хаягаар хандах боломжтой бол суралцагч ашиглахад хамгийн энгийн хаягийг сонгоно. Хаягийн төгсгөлд ташуу зураас бичихгүй.</p>

<p><b>Moodle лавлах:</b>
Энэ суурилуулалтын бүрэн лавлахын замыг зааж өгнө үү
Том/жижиг үсэг зөв эсэхийг шалгана уу.</p>

<p><b>Өгөгдлийн лавлах:</b>
Танд Moodle системд байршуулсан файлыг хадгалах газар хэрэгтэй. Энэ нь веб серверийн хэрэглэгч (ихэвчлэн \'хэн ч\' эсвэл \'apache\') унших, бичих боломжтой лавлах байх ёстой ч вебээр дамжуулан шууд хандах боломжгүй байх ёстой. Хэрэв байхгүй бол суурилуулагч үүнийг үүсгэхийг оролдоно.</p>';
$string['directorysettingshead'] = 'Энэ Moodle системийг суурилуулах байршлыг баталгаажуулна уу.';
$string['directorysettingssub'] = '<p><b>Вэб хаяг:</b>
Moodle системд хандах бүтэн веб хаягийг зааж өгнө үү. Таны веб сайтад олон URL хаягаар хандах боломжтой бол суралцагч ашиглахад хамгийн энгийн хаягийг сонгоно. Хаягийн төгсгөлд ташуу зураас бичихгүй.
<br />
<br />
<p><b>Moodle лавлах:</b>
Энэ суурилуулалтын бүрэн лавлахын замыг зааж өгнө үү
Том/жижиг үсэг зөв эсэхийг шалгана уу.
<br />
<br />
<p><b>Өгөгдлийн лавлах:</b>
Танд Moodle системд байршуулсан файлыг хадгалах газар хэрэгтэй. Энэ нь веб серверийн хэрэглэгч (ихэвчлэн \'хэн ч\' эсвэл \'apache\') унших, бичих боломжтой лавлах байх ёстой ч вебээр дамжуулан шууд хандах боломжгүй байх ёстой. Хэрэв байхгүй бол суурилуулагч үүнийг үүсгэхийг оролдоно.</p>';
$string['dirroot'] = 'Moodle лавлах';
$string['dirrooterror'] = '\'Moodle лавлах\' тохиргоо буруу байна - бид тэндээс Moodle суурилуулалтыг олж чадахгүй байна. Доорх утгыг шинэчилсэн.';
$string['download'] = 'Татан авах';
$string['downloadlanguagebutton'] = '&quot;{$a}&quot татаж авах; хэлний багц';
$string['downloadlanguagehead'] = 'Xэлний багцыг татаж авах';
$string['downloadlanguagenotneeded'] = 'Та "{$a}" хэлний өгөгдмөл багцыг ашиглан суурилуулалтын процессыг үргэлжлүүлж болно.';
$string['downloadlanguagesub'] = 'Танд хэлний багцыг татаж аваад энэ хэл дээр суурилуулах процессыг үргэлжлүүлэх сонголт байна.<br /><br />Хэлний багцыг татаж авах боломжгүй тохиолдолд суурилуулах процесс англи хэл дээр үргэлжилнэ. (Суурилуулах процесс дууссаны дараа та нэмэлт хэлний багцыг татаж авах, суулгах боломжтой.)';
$string['doyouagree'] = 'Та зөвшөөрч байна уу ? (тийм/үгүй):';
$string['environmenthead'] = 'Таны орчныг шалгаж байна ...';
$string['environmentsub'] = 'Бид таны системийн төрөл бүрийн бүрэлдэхүүн хэсгийг системийн шаардлагыг хангаж байгаа эсэхийг шалгаж байна';
$string['environmentsub2'] = 'Moodle системийн хувилбар бүр нь PHP хувилбарын хамгийн наад захын шаардлагыг хангаж, PHP гол гол өргөтгөлтэй байдаг.
Суурилуулах, шинэчлэхээс өмнө орчны бүрэн шалгалтыг хийдэг. Шинэ хувилбар суулгах эсвэл PHP өргөтгөлийг хэрхэн идэвхжүүлэхийг мэдэхгүй байгаа бол серверийн админтай холбогдоно уу.';
$string['errorsinenvironment'] = 'Орчны шалгалт амжилтгүй боллоо!';
$string['fail'] = 'Амжилтгүй';
$string['fileuploads'] = 'Файл байршуулалт';
$string['fileuploadserror'] = 'Энэ идэвхтэй байх ёстой';
$string['fileuploadshelp'] = '<p>Таны сервер дээр файл байршуулахыг идэвхгүй болгосон байна.</p>

<p>Moodle системийг суурилуулсан хэвээр байгаа ч энэ боломжгүйгээр та хичээлийн файл эсвэл шинэ хэрэглэгчийн профайлын зургийг байршуулах боломжгүй.</p>

<p>Файл байршуулахыг идэвхжүүлэхийн тулд та (эсвэл таны системийн администратор) систем дээрх үндсэн php.ini файлыг засварлаж, <b>file_uploads</b> тохиргоог \'1\' болгох шаардлагатай.</p>';
$string['inputdatadirectory'] = 'Өгөгдлийн лавлах:';
$string['inputwebadress'] = 'Веб хаяг:';
$string['inputwebdirectory'] = 'Moodle лавлах:';
$string['installation'] = 'Суурилуулалт';
$string['invaliddbprefix'] = 'Буруу угтвар. Угтвар нь зөвхөн жижиг үсэг, доогуур зураасаас бүрдэнэ.';
$string['langdownloaderror'] = 'Харамсалтай нь "{$a}" хэлийг татаж авч чадсангүй. Суулгах үйл явц англи хэл дээр үргэлжилнэ.';
$string['langdownloadok'] = '"{$a}" хэлийг амжилттай суулгасан. Суурилуулах процесс энэ хэл дээр үргэлжилнэ.';
$string['memorylimit'] = 'Санах ойн хязгаарлалт';
$string['memorylimiterror'] = 'PHP санах ойн хязгаарлалтыг маш багаар тохируулсан ... дараа нь танд асуудал гарч магадгүй.';
$string['memorylimithelp'] = '<p>Таны серверийн PHP санах ойн хязгаарлалтыг {$a} гэж тохируулсан байна.</p>

<p>Энэ нь Moodle системд хожим санах ойн асуудал, ялангуяа олон модулийг идэвхжүүлсэн ба/буюу олон хэрэглэгчтэй үед үүсгэж болзошгүй.</p>

<p>Бид танд PHP-г боломжтой бол 40M гэх мэт өндөр хязгаартайгаар тохируулахыг зөвлөж байна.
    Үүнд хэд хэдэн арга байдаг ба тэдгээрийг ашиглаж болно:</p>
<ol>
<li>Хэрэв боломжтой бол PHP-г <i>--enable-memory-limit</i> ашиглан дахин хөрвүүлээрэй.
     Энэ нь Moodle системд санах ойн хязгаарыг өөрөө тохируулах боломжийг олгоно.</li>
<li>Хэрэв та өөрийн php.ini файлд хандах эрхтэй бол <b>memory_limit</b> тохиргоог 40M гэх зэргээр өөрчлөх боломжтой. Хандах эрхгүй бол администратортоо хандаж болно.</li>
<li>Зарим PHP серверт дараах мөрийг агуулсан Moodle санд .htaccess файлыг үүсгэж болно: <blockquote><div>php_value memory_limit 40M</div></blockquote>
   <p>Гэвч зарим серверт энэ нь <b>бүх</b> PHP хуудас ажиллахаас сэргийлдэг (хуудсыг харахад алдаа гарах болно) тул та .htaccess файлыг устгах шаардлагатай.</p> </li>
</ol>';
$string['mysqliextensionisnotpresentinphp'] = 'PHP нь MySQL-тэй холбогдохын тулд MySQLi өргөтгөлөөр зөв тохируулагдаагүй байна. php.ini файлаа шалгах буюу PHP-г дахин хөрвүүлнэ үү.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>Өгөгдлийн сан нь Moodle системийн ихэнх тохиргоо, өгөгдлийг хадгалдаг бөгөөд энд тохируулсан байх ёстой.</p>
<p>Өгөгдлийн сангийн нэр, хэрэглэгчийн нэр, нууц үг нь шаардлагатай талбар; хүснэгтийн угтвар нь сонголттой байна.</p>
<p>Өгөгдлийн сангийн нэр нь зөвхөн үсэг, тоон тэмдэгт, доллар ($) болон доогуур зураас (_) агуулж болно.</p>
<p>Хэрэв одоогоор өгөгдлийн сан байхгүй, таны заасан хэрэглэгч зөвшөөрөлтэй бол Moodle систем зөв зөвшөөрөл, тохиргоотой шинэ өгөгдлийн санг үүсгэх болно.</p>
<p>Энэ драйвер нь хуучин MyISAM системтэй тохирохгүй байна.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Өгөгдлийн сан нь Moodle системийн ихэнх тохиргоо, өгөгдлийг хадгалдаг бөгөөд энд тохируулсан байх ёстой.</p>
<p>Өгөгдлийн сангийн нэр, хэрэглэгчийн нэр, нууц үг нь шаардлагатай талбар; хүснэгтийн угтвар нь сонголттой байна.</p>
<p>Өгөгдлийн сангийн нэр нь зөвхөн үсэг, тоон тэмдэгт, доллар ($) болон доогуур зураас (_) агуулж болно.</p>
<p>Хэрэв одоогоор өгөгдлийн сан байхгүй, таны заасан хэрэглэгч зөвшөөрөлтэй бол Moodle систем зөв зөвшөөрөл, тохиргоотой шинэ өгөгдлийн санг үүсгэх болно.</p>
<p>Энэ драйвер нь хуучин MyISAM системтэй тохирохгүй байна.</p>';
$string['nativemysqli'] = 'Сайжруулсан MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>Өгөгдлийн сан нь Moodle системийн ихэнх тохиргоо, өгөгдлийг хадгалдаг бөгөөд энд тохируулсан байх ёстой.</p>
<p>Өгөгдлийн сангийн нэр, хэрэглэгчийн нэр, нууц үг нь шаардлагатай талбар; хүснэгтийн угтвар нь сонголттой байна.</p>
<p>Өгөгдлийн сангийн нэр нь зөвхөн үсэг, тоон тэмдэгт, доллар ($) болон доогуур зураас (_) агуулж болно.</p>
<p>Хэрэв одоогоор өгөгдлийн сан байхгүй, таны заасан хэрэглэгч зөвшөөрөлтэй бол Moodle систем зөв зөвшөөрөл, тохиргоотой шинэ өгөгдлийн санг үүсгэх болно.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Одоо та ихэнх Moodle өгөгдлийг хадгалдаг өгөгдлийн санг тохируулах хэрэгтэй.
Энэ өгөгдлийн санг үүсгэсэн байх ёстой ба нэвтрэхийн тулд хэрэглэгчийн нэр, нууц үгийг үүсгэсэн байна. Хүснэгтийн угтвар заавал байх ёстой.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Өгөгдлийн санд Moodle системийн ихэнх тохиргоо, өгөгдлийг хадгалдаг ба энд тохируулагдсан байх ёстой.</p>
<p>Өгөгдлийн сангийн нэр, хэрэглэгчийн нэр, нууц үг болон хүснэгтийн угтвар нь шаардлагатай талбарууд болно.</p>
<p>Өгөгдлийн санг хэдийнэ үүсгэсэн байх ёстой ба хэрэглэгч түүнд унших ба бичих эрхтэй байх ёстой.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Одоо та ихэнх Moodle өгөгдлийг хадгалдаг өгөгдлийн санг тохируулах хэрэгтэй.
Энэ өгөгдлийн санг үүсгэсэн байх ёстой ба нэвтрэхийн тулд хэрэглэгчийн нэр, нууц үгийг үүсгэсэн байна. Хүснэгтийн угтвар заавал байх ёстой.';
$string['nativesqlsrvnodriver'] = 'PHP-д зориулсан SQL серверт зориулсан Microsoft драйверыг суулгаагүй эсвэл зөв тохируулаагүй байна.';
$string['ociextensionisnotpresentinphp'] = 'PHP нь OCI8 өргөтгөлтэй зөв тохируулагдаагүй тул  Oracle-тай холбогдох боломжтой. php.ini файлаа шалгах буюу PHP-г дахин хөрвүүлнэ үү.';
$string['pass'] = 'Дамжуулах';
$string['paths'] = 'Замууд';
$string['pathserrcreatedataroot'] = 'Суурилуулагч нь өгөгдлийн лавлахыг ({$a->dataroot}) үүсгэх боломжгүй';
$string['pathshead'] = 'Замыг баталгаажуулах';
$string['pathsrodataroot'] = 'Dataroot лавлах нь бичилт хийх боломжгүй.';
$string['pathsroparentdataroot'] = 'Үндсэн лавлах ({$a->parent}) нь бичилт хийх боломжгүй. Суурилуулагч нь өгөгдлийн санг ({$a->dataroot}) үүсгэх боломжгүй.';
$string['pathssubadmindir'] = 'Маш цөөн веб хост /админыг хянах самбар эсвэл өөр зүйлд нэвтрэхийн тулд тусгай URL болгон ашигладаг. Харамсалтай нь энэ нь Moodle админ хуудасны стандарт байршилтай зөрчилддөг. Та үүнийг засах боломжтой
Суурилуулалтад админ лавлахын нэрийг өөрчилж, энд шинэ нэрийг оруулах замаар засаж болно. Жишээ нь: <em>moodleadmin</em>. Энэ нь Moodle дээрх админ холбоосыг засах болно.';
$string['pathssubdataroot'] = '<p>Moodle нь хэрэглэгчийн байршуулсан бүх файлын агуулгыг хадгалах лавлах.</p>
<p>Энэ лавлах нь веб серверийн хэрэглэгч (ихэвчлэн \'www-data\', \'nobody\' эсвэл \'apache\') унших, бичих боломжтой байх ёстой.</p>
<p>Энэ нь вебээр шууд хандах боломжгүй байх ёстой.</p>
<p>Одоогоор лавлах байхгүй бол үүнийг суурилуулах процесс үүсгэх болно.</p>';
$string['pathssubdirroot'] = '<p>Moodle код агуулсан лавлахад хандах бүрэн зам.</p>';
$string['pathssubwwwroot'] = '<p>Moodle системд хандах бүрэн хаяг, өөрөөр хэлбэл хэрэглэгч Moodle системд хандахын тулд хөтчийн хаягийн мөрөнд оруулах хаяг.</p>
<p>Олон хаяг ашиглан Moodle системд хандах боломжгүй. Таны сайтад олон хаягаар хандах боломжтой бол хамгийн хялбарыг сонгож, бусад хаяг руугаа байнгын дахин чиглүүлэлт хийхээр тохируулна уу.</p>
<p>Таны сайтад интернэт, дотоод сүлжээнээс (заримдаа интранэт гэж нэрлэдэг) нэвтрэх боломжтой бол энд нийтийн хаягийг ашиглана уу.</p>
<p>Одоогийн хаяг буруу байвал хөтчийн хаягийн мөрөнд байгаа URL хаягийг өөрчлөөд суурилуулалтыг дахин эхлүүлнэ үү.</p>';
$string['pathsunsecuredataroot'] = 'Dataroot байршил аюулгүй биш байна';
$string['pathswrongadmindir'] = 'Админ лавлах байхгүй байна';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP нь PostgreSQL-тэй холбогдохын тулд PGSQL өргөтгөлтэй зөв тохируулагдаагүй байна. php.ini файлаа шалгах буюу PHP-г дахин хөрвүүлнэ үү.';
$string['phpextension'] = '{$a} PHP өргөтгөл';
$string['phpversion'] = 'РНР хувилбар';
$string['phpversionhelp'] = '<p>Moodle системд хамгийн багадаа 5.6.5 эсвэл 7.1 PHP хувилбар шаардлагатай (7.0.x нь системийн зарим хязгаарлалттай).</p>
<p>Та одоогоор {$a} хувилбарыг ажиллуулж байна.</p>
<p>Та PHP-г шинэчлэх эсвэл шинэ PHP хувилбартай хостод шилжих шаардлагатай.</p>';
$string['releasenoteslink'] = 'Moodle системийн энэ хувилбарын талаарх мэдээллийг {$a} дээрх хувилбарын тэмдэглэлээс үзнэ үү.';
$string['safemode'] = 'Аюулгүйн горим';
$string['safemodeerror'] = 'Moodle систем нь аюулгүйн горимд асуудалтай байж магадгүй';
$string['safemodehelp'] = '<p>Moodle систем нь аюулгүйн горимд төрөл бүрийн асуудалтай байж болох ба энэ нь шинэ файл үүсгэхийг зөвшөөрөхгүй байх магадлалтай.</p>

<p>Аюулгүйн горимыг ихэвчлэн нийтийн веб хостууд идэвхжүүлдэг тул та Moodle сайтдаа веб байршуулах компанийг олох шаардлага гарч болзошгүй.</p>

<p>Хэрэв та хүсвэл суурилуулалтыг үргэлжлүүлж болох ч хожим зарим нэг асуудал гарах болно.</p>';
$string['sessionautostart'] = 'Сейшнг автоматаар эхлэх';
$string['sessionautostarterror'] = 'Үүнийг унтраасан байх ёстой';
$string['sessionautostarthelp'] = '<p>Moodle нь сейшны дэмжлэгийг шаардах түүнгүйгээр ажиллахгүй.</p>

<p>Сейшнг php.ini файлд идэвхжүүлж болно ... session.auto_start параметрийг хайна уу.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP нь SQLite өргөтгөлтэй зөв тохируулагдаагүй байна. php.ini файлаа шалгах буюу PHP-г дахин хөрвүүлнэ үү.';
$string['upgradingqtypeplugin'] = 'question/type нэмэлт хэрэгслийг шинэчилж байна';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Та <strong>{$a->packname} {$a->packversion}</strong> багцыг компьютертоо амжилттай суулгаж, эхлүүлсэн тул та энэ хуудсыг харж байна. Баяр хүргэе!';
$string['welcomep30'] = '<strong>{$a->installername}</strong> энэхүү хувилбарт <strong>Moodle</strong> ажиллах орчныг бүрдүүлэх аппликейшнүүд багтсан болно, тухайлбал:';
$string['welcomep40'] = 'Түүнчлэн энэ багц нь <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>-г агуулдаг.';
$string['welcomep50'] = 'Энэ багцад буй бүх аппликейшны хэрэглээг тэдгээрийн лицензээр зохицуулдаг. Бүрэн <strong>{$a->installername}</strong> багц нь <a href="https://www.opensource.org/docs/definition_plain.html">нээлттэй эх сурвалж</a> бөгөөд <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a> лиценз дор түгээгддэг.';
$string['welcomep60'] = 'Дараах хуудсууд нь таны компьютерт <strong>Moodle</strong> системийг тохируулах, тохируулахад хялбар алхмыг хийх болно. Та өгөгдмөл тохиргоог хүлээн зөвшөөрөх эсвэл өөрийн хэрэгцээнд тохируулан өөрчилж болно.';
$string['welcomep70'] = 'Доорх "Дараах" товчийг дарж <strong>Moodle</strong> системийн тохиргоог үргэлжлүүлнэ үү.';
$string['wwwroot'] = 'Веб хаяг';
$string['wwwrooterror'] = '\'Вэб хаяг\' хүчинтэй биш байна - энэ Moodle суурилуулалт байхгүй бололтой. Доорх утгыг шинэчилсэн болно.';
