<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_compilatio', language 'nl', version '4.3'.
 *
 * @package     plagiarism_compilatio
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_report'] = 'Toegangsrapport';
$string['activate_compilatio'] = 'Compilatio inschakelen';
$string['activate_submissiondraft'] = 'Om leerlingen hun concepten te laten analyseren, moet je de <b>{$a}</b>-optie inschakelen in de sectie';
$string['activated'] = 'Plagiaatsdetectie met Compilatio toestaan';
$string['activities_statistics'] = 'Statistieken per activiteit';
$string['activity'] = 'Activiteit';
$string['admin_disabled_reports'] = 'De beheerder staat niet toe dat leraren vergelijkingsrapporten tonen aan leerlingen.';
$string['admin_goto_helpcenter'] = 'Toegang tot het Compilatio help center om artikels te lezen over het beheer van de Moodle-plugin.';
$string['ai_included_in_subscription'] = 'detectie van tekst geschreven met AI</li></ul>';
$string['ai_not_included_in_subscription'] = 'Jouw abonnement bevat geen AI-detectie.';
$string['ai_score_not_included'] = 'niet inbegrepen in jouw abonnement';
$string['aiscore'] = 'AI-gegenereerde tekst';
$string['aiscore_percentage'] = 'Percentage tekst mogelijks gescheven door AI';
$string['analysed_docs'] = '{$a} geanalyseerde document(en)';
$string['analysing_docs'] = '{$a} documenten worden geanalyseerd';
$string['analysis_date'] = 'Analysedatum (enkel geplande analyses)';
$string['analysis_started'] = '{$a} analyses gevraagd.';
$string['analysistype'] = 'Analyse start';
$string['analysistype_auto'] = 'Onmiddellijk';
$string['analysistype_auto_help'] = '<p>Je hebt drie opties:
<ul>
<li><strong>Manueel:</strong> Analyse van documenten moet manueel gestart worden met de "Analyseer"-knop van elk document of met de "Analyseer alle documenten"-knop.</li>
<li><strong>Gepland:</strong> Alle documenten worden geanalyseerd op het gekozen tijdstip.</li>
<li><strong>Onmiddellijk:</strong Elk document wordt geanalyseerd wanneer de leerling het instuurt. De documenten in de activiteit zullen niet met elkaar vergeleken worden.</li>
</ul>

Om alle documenten met elkaar te vergelijken kun je best wachten tot iedereen afgegeven heeft en pas dan de analyse starten.</p>';
$string['analysistype_help'] = '<p>Je hebt twee opties:
<ul>
<li><strong>Manueel:</strong> Analyse van documenten moet manueel gestart worden met de "Analyseer"-knop van elk document of met de "Analyseer alle documenten"-knop.</li>
<li><strong>Gepland:</strong> Alle documenten worden geanalyseerd op het gekozen tijdstip.</li>
</ul>

Om alle documenten met elkaar te vergelijken kun je best wachten tot iedereen afgegeven heeft en pas dan de analyse starten.</p>';
$string['analysistype_manual'] = 'Manueel';
$string['analysistype_prog'] = 'Gepland';
$string['api_key_not_tested'] = 'Je API-sleutel is niet geverifieerd omdat de verbinding met Compilatio mislukt is.';
$string['api_key_not_valid'] = 'Je API-sleutel is niet geldig. Die is specifiek voor het gebruikte platform. Je kunt een sleutel bekomen door contact op te nemen met ent@compilatio.net.';
$string['api_key_valid'] = 'Je API-sleutel is geldig';
$string['apikey'] = 'API-sleutel';
$string['apikey_help'] = 'Persoonlijke code die door Compilatio uitgereikt wordt op toegang tot de API te krijgen';
$string['auto_diagnosis_title'] = 'Auto-diagnose';
$string['average'] = 'Gemiddelde';
$string['btn_analysing'] = 'Analyse bezig';
$string['btn_error_analysis_failed'] = 'Analyse mislukt';
$string['btn_error_not_found'] = 'Document niet gevonden';
$string['btn_error_sending_failed'] = 'Versturen mislukt';
$string['btn_error_too_large'] = 'Bestand te groot';
$string['btn_error_too_long'] = 'Bestand te lang';
$string['btn_error_too_short'] = 'Bestand te kort';
$string['btn_error_unsupported'] = 'Bestandsformaat niet ondersteund';
$string['btn_planned'] = 'Analyse gepland';
$string['btn_queue'] = 'In de wachtrij';
$string['btn_sent'] = 'Analyse';
$string['btn_unsent'] = 'Verstuur';
$string['certificate'] = 'Analyse-certificaat';
$string['compilatio'] = 'Compilatio plagiaatscanner';
$string['compilatio:enable'] = 'Leraren toestaan om Compilatio in te schakelen / uit te schakelen in een activiteit';
$string['compilatio:triggeranalysis'] = 'Toestaan dat leraren manueel een analyse starten';
$string['compilatio:viewreport'] = 'Toestaan dat leraren het volledig rapport van Compilatio zien';
$string['compilatio_depositor'] = 'Het document in activiteit <b>{$a->modulename}</b> is ingestuurd door Moodle-gebruiker <b>{$a->lastname} {$a->firstname}</b>.';
$string['compilatio_help_assign'] = 'Toon hulp over de Compilatio-plugin';
$string['compilatio_iddocument'] = 'Document-identificatie';
$string['compilatio_search'] = 'Zoek';
$string['compilatio_search_help'] = 'Je kunt de auteur van een document vinden via de document-identificatie van de bronnen in het analyserapport.';
$string['compilatio_search_notfound'] = 'Er is geen document gevonden met deze docunent-identificatie op jouw Moodle-platform.';
$string['compilatio_search_tab'] = 'Zoek de verzender van een document.';
$string['compilatiodefaults'] = 'Compilatio standaardinstellingen';
$string['compilatioexplain'] = 'Kijk voor meer informatie over deze plugin op: <a href="http://www.compilatio.net/en/" target="_blank">compilatio.net</a>';
$string['cron_check'] = 'De geplande taak send_files van de plugin is op  {$a} de laatste keer uitgevoerd.';
$string['cron_check_never_called'] = 'De geplande taak send_files van de plugin is  nooit uitgevoerd sinds de activatie van de plugin. Dit is waarschijnlijk fout geconfigureerd op je server.';
$string['cron_check_not_ok'] = 'De geplande taak send_files van de plugin is niet meer uitgevoerd in het laatste uur.';
$string['cron_frequency'] = 'Loopt blijkbaar elke {$a} minuten';
$string['cron_recommandation'] = 'Voor de geplande taken van de Compilatio-plugin raden we aan dat die minstens om de 15 minuten uitgevoerd wordt.';
$string['defaultindexing'] = 'Voeg documenten toe aan de documentendatabank';
$string['defaultindexing_help'] = 'Ja: voeg documenten toe aan de documentendatabank. Deze documenten zullen gebruikt worden als vergelijkingsmateriaal voor toekomstige analyse.
Nee: documenten worden niet toegevoegd aan de documentendatabank en zullen niet gebruikt worden om mee te vergelijken.';
$string['defaults_desc'] = 'Volgende instellingen zijn de standaardinstellingen wanneer Compilatio ingeschakeld wordt in een activiteit.';
$string['defaultupdated'] = 'Standaardinstellingen aangepast';
$string['detailed'] = 'Gedetailleerd rapport';
$string['detailed_error_analysis_failed'] = 'De analyse van deze documenten werkte niet correct. Je kunt deze documenten resetten.';
$string['detailed_error_not_found'] = 'Deze documenten werden niet gevonden.';
$string['detailed_error_sending_failed'] = 'Deze documenten konden niet naar Compilatio gestuurd worden. Je kunt deze documenten opnieuw versturen.';
$string['detailed_error_too_large'] = 'Deze documenten konden niet door Compilatio geanalyseerd worden omdat ze te groot zijn (Maximale grootte: {$a} MB).';
$string['detailed_error_too_long'] = 'Deze documenten konden niet door Compilatio geanalyseerd worden omdat ze te veel woorden bevatten (Maximaal aantal woorden: {$a} woorden).';
$string['detailed_error_too_short'] = 'Deze documenten konden niet door Compilatio geanalyseerd worden omdat ze te weinig woorden bevatten (Minimaal aantal woorden: {$a} woorden).';
$string['detailed_error_unsupported'] = 'Deze documenten konden niet door Compilatio geanalyseerd worden omdat het bestandsformaat niet ondersteund wordt.';
$string['disable_ssl_verification'] = 'Negeer SSL-certificaatsverificatie.';
$string['disable_ssl_verification_help'] = 'Schakel deze optie in wanneer je problemen hebt met het verifiëren van SSL-certificaten of wanneer je fouten ondervindt bij het versturen van bestanden naar Compilatio.';
$string['disclaimer_data'] = 'Bij het inschakelen van Compilatio aanvaard je dat gegevens over je Moodle-confiiguratie zullen verzameld worden om de ondersteuning van deze service te verbeteren.';
$string['display_notifications'] = 'Toon meldingen';
$string['display_settings_frame'] = 'Toon instellingen voor scores';
$string['display_stats'] = 'Toont statistieken over deze activiteit';
$string['display_stats_per_student'] = 'Toon statistieken per leerling over deze activiteit';
$string['document_deleting'] = 'Verwijder documenten';
$string['document_sent'] = '{$a} documenten verstuurd.';
$string['documents_number'] = 'Geanalyseerde documenten';
$string['download_report_failed'] = 'Er is een fout opgetreden tijdens het downloaden van het analyserapport.';
$string['element_included_in_subscription'] = 'Inbegrepen in jouw abonnement: <ul><li>plagiaatsdetectie</li><li>detectie van gewijzigde tekst';
$string['enable_activities_title'] = 'Schakel Compilatio in voor activiteiten';
$string['enable_analyses_auto'] = 'Mogelijkheid om de analyse onmiddellijk te starten';
$string['enable_analyses_auto_help'] = 'Met deze optie kunnen leraren automatisch de documentenanalyse in een activiteit starten (onmiddellijk na insturen).<br>
Merk op dat in dit geval:
<ul>
    <li>Het aantal uitgevoerde scans voor jouw instituut kan behoorlijk hoger liggen.</li>
    <li>De documenten van wie eerst instuurt worden niet vergeleken met wie later instuurt.</li>
</ul>

Om alle documenten van een opdracht met elkaar te vergelijken, moet je de "geplande" analyse gebruiken, waarbij je een tijdstip na de instuurdeadline kiest.';
$string['enable_mod_assign'] = 'Opdrachten';
$string['enable_mod_forum'] = 'Forums';
$string['enable_mod_quiz'] = 'Testen';
$string['enable_mod_workshop'] = 'Workshop';
$string['enable_search_tab'] = 'Tool om de auteur van een document te zoeken';
$string['enable_search_tab_help'] = 'Met de zoekfunctie kun je zoeken naar voornaam of achternaam van een leerling, gebaseerd op de document-ID die je kunt vinden in de analyserapporten samen met alle documenten die op je platform staan.';
$string['enable_show_reports'] = 'Mogelijkheid om analyse aan leerlingen te tonen';
$string['enable_student_analyses'] = 'Mogelijkheid om leerlingen plagiaatsrapporten te laten maken van kladwerken';
$string['enable_student_analyses_help'] = 'Met deze optie kunnen leraren de mogelijkheid inschakelen dat leerlingen hun documenten in kladwerkmodus door Compilatio laten controleren, voor ze de opdracht insturen.';
$string['enabledandworking'] = 'De Compilatio-plugin is ingeschakeld en werkt.';
$string['errors'] = 'Fouten';
$string['excluded_from_score'] = 'Niet mee opgenomen in de score:';
$string['export_csv'] = 'Exporteer gegevens over deze activiteit in een CSV-bestand';
$string['export_csv_per_student'] = 'Exporteer de resultaten van deze leerling naar een CSV-bestand';
$string['export_global_csv'] = 'Klik hier om deze gegevens in CSV-formaat te exporteren';
$string['export_raw_csv'] = 'Klik hier om ruwe gegevens in CSV-formaat te exporteren';
$string['extraction_in_progress'] = 'Document wordt uitgepakt - probeer later opnieuw.';
$string['failedanalysis'] = 'Compilatio kon jouw document niet analyseren:';
$string['file'] = 'Bestand';
$string['filename'] = 'Bestandsnaam';
$string['firstname'] = 'Voornaam';
$string['get_scores'] = 'Haal de plagiaatscores op van Compilatio';
$string['global_statistics'] = 'Globale statistieken';
$string['global_statistics_description'] = 'Alle documentsgegevens die naar Compilatio zijn gestuurd.';
$string['globalscore'] = 'Totaal';
$string['goto_compilatio_service_status'] = 'Compilatio service status';
$string['green_threshold'] = 'Groen tot';
$string['help_compilatio_format_content'] = 'Compilatio kan de meeste formaten gebruikt in tekstverwerkers en op het internet verwerken.
Volgende formaten worden ondersteund:';
$string['helpcenter'] = 'Toegang tot het Compilatio helpcentrum voor het gebruik van de Compilatioplugin in Moodle';
$string['helpcenter_error'] = 'We kunnen geen verbinding maken met het helpcentrum. Probeer later opnieuw of ga er rechtstreeks naartoe met volgende link:';
$string['immediately'] = 'Onmiddellijk';
$string['include_percentage_in_suspect_text'] = 'Inbegrepen in het percentage van de getoonde verdachte tekst:';
$string['indexed_document'] = 'Document toegevoegd aan de databank met documenten van je instituut. De inhoud kan gebruikt worden om te vergelijken met andere documenten.';
$string['info_cm_activated'] = 'Documenten in deze activiteit worden ingestuurd naar de Compilatio-account {$a}.<br>Alle leraren die aangemeld zijn in deze cursus kunnen Compilatio voor deze activiteit gebruiken.';
$string['info_cm_activation'] = 'Door Compilatio voor deze activiteit in te schakelen, kunnen ingestuurde documenten naar jouw Compilatio-account {$a} geüpload worden.<br>Alle leraren in deze cursus zullen Compilatio voor deze activiteit kunnen gebruiken.';
$string['keep_docs_indexed'] = 'Bewaar documenten in de referentiebibliotheek';
$string['keep_docs_indexed_help'] = 'Bij het verwijderen van een cursus, het terug op standaardinstellingen zetten of het verwijderen van een activiteit, kun je er voor kiezen om de documenten die naar Compilatio verstuurd zijn, permanent te verwijderen of ze te behouden in de referentiebibliotheek. Enkel de tekst zal behouden blijven en worden gebruikt als vergelijkingsmateriaal in volgende analyses.';
$string['lastname'] = 'Achternaam';
$string['manual_analysis'] = 'De analyse van dit document moet manueel gestart worden.';
$string['max_file_size'] = 'Bestanden mogen niet groter zijn dan {$a} MB';
$string['maximum'] = 'Maximum';
$string['minimum'] = 'Minimum';
$string['next_student'] = 'Volgende leerling';
$string['no_document_analysed'] = 'Geen documenten geanalyseerd';
$string['no_document_available_for_analysis'] = 'Er zijn geen documenten voor analyse beschikbaar';
$string['no_document_to_display'] = 'Geen documenten te tonen';
$string['no_notification'] = 'Geen melding';
$string['no_statistics_yet'] = 'Er zijn nog geen documenten geanalyseerd.';
$string['no_students_finished_quiz'] = 'Niemand beëindigde de test';
$string['not_analysed'] = 'niet geanalyseerd';
$string['not_analyzed'] = 'Onderstaande documenten kunnen niet geanalyseerd worden:';
$string['not_analyzed_extracting'] = 'Onderstaande documenten kunnen nog niet geanalyseerd worden omdat ze uitgepakt worden. Probeer later opnieuw.';
$string['not_indexed_document'] = 'Dit document is niet toegevoegd aan de documentendatabank van je instituut. De inhoud ervan zal niet gebruikt worden om te vergelijken met andere documenten.';
$string['not_sent'] = 'Volgende documenten konden niet verstuurd worden:';
$string['notifications'] = 'Meldingen';
$string['numeric_threshold'] = 'Drempel moet een getal zijn.';
$string['open'] = 'Open';
$string['orange_threshold'] = 'Oranje tot';
$string['other_analysis_options'] = 'Andere analyse-opties';
$string['owner_file'] = 'AIV en eigenaarschap van documenten';
$string['owner_file_school'] = 'De school is eigenaar van de documenten';
$string['owner_file_school_details'] = 'Wanneer een leerling vraagt om al zijn gegevens te verwijderen, dan zullen zijn documenten en rapporten bewaard worden en beschikbaar blijven voor toekomstige vergelijking met andere documenten. Aan het eind van het contract met Compilatio, zullen alle persoonlijke gegevens van jouw school, inclusief alle geanalyseerde documenten, verwijderd worden binnen de contractuele deadlines.';
$string['owner_file_student'] = 'De leerling is de enige eigenaar van dit document';
$string['owner_file_student_details'] = 'Wanneer een leerling vraagt om al zijn gegevens te verwijderen, dan zullen zijn documeten en rapporten verwijderd worden van Moodle en de Compilatio documentendatabase. Documenten zullen niet langer beschikbaar zijn voor vergelijking met andere documenten.';
$string['plugin_disabled'] = 'De plugin is niet ingeschakeld in Moodle.';
$string['plugin_disabled_assign'] = 'De plugin is niet ingeschakeld voor opdrachten.';
$string['plugin_disabled_forum'] = 'De plugin is niet ingeschakeld voor forums.';
$string['plugin_disabled_quiz'] = 'De plugin is niet ingeschakeld voor testen.';
$string['plugin_disabled_workshop'] = 'De plugin is niet ingeschakeld voor workshops.';
$string['plugin_enabled'] = 'De plugin is ingeschakeld in Moodle.';
$string['plugin_enabled_assign'] = 'De plugin is ingeschakeld voor opdrachten.';
$string['plugin_enabled_forum'] = 'De plugin is ingeschakeld voor forums.';
$string['plugin_enabled_quiz'] = 'De plugin is ingeschakeld voor testen.';
$string['plugin_enabled_workshop'] = 'De plugin is ingeschakeld voor workshops.';
$string['pluginname'] = 'Compilatio plagiaatsplugin';
$string['previous_student'] = 'Vorige leerling';
$string['privacy:metadata:core_files'] = 'Bestanden als bijlage bij inzendingen of gemaakt als online tekst.';
$string['privacy:metadata:core_plagiarism'] = 'Deze plugin wordt door het Moodle plagiaat subsysteem gebruikt';
$string['privacy:metadata:external_compilatio_document'] = 'Informatie en inhoud over documenten in de Compilatio databank';
$string['privacy:metadata:external_compilatio_document:authors'] = 'Voornaam, achternaam en e-mail van de Moodlegebruiker (of leden van de groep) die het bestand ingestuurd hebben';
$string['privacy:metadata:external_compilatio_document:depositor'] = 'Voornaam, achternaam en e-mail van de Moodlegebruiker die het bestand instuurde';
$string['privacy:metadata:external_compilatio_document:filename'] = 'Bestandsnaam ingestuurd of gegenereerde naam voor online tekst';
$string['privacy:metadata:external_compilatio_user'] = 'Informatie over de leraar die de cursusmodule met Compilatio gemaakt heeft';
$string['privacy:metadata:external_compilatio_user:email'] = 'E-mailadres leraar';
$string['privacy:metadata:external_compilatio_user:firstname'] = 'Voornaam leraar';
$string['privacy:metadata:external_compilatio_user:lastname'] = 'Achternaam leraar';
$string['privacy:metadata:external_compilatio_user:username'] = 'E-mailadres leraar';
$string['privacy:metadata:plagiarism_compilatio_files'] = 'Informatie over bestanden ingestuurd naar Compilatio';
$string['privacy:metadata:plagiarism_compilatio_files:filename'] = 'Bestandsnaam ingestuurd of gegenereerde naam voor online tekst';
$string['privacy:metadata:plagiarism_compilatio_files:userid'] = 'De MoodleID van de gebruiker die de inzending maakte';
$string['privacy:metadata:plagiarism_compilatio_user'] = 'Informatie over de leraar die de cursusmodule met Compilatio gemaakt heeft';
$string['privacy:metadata:plagiarism_compilatio_user:compilatioid'] = 'De Compilatio-ID van de leraar';
$string['privacy:metadata:plagiarism_compilatio_user:userid'] = 'De Moodle-ID van de leraar';
$string['programmed_analysis_future'] = 'Documenten zullen door Compilatio geanalyseerd worden op {$a}.';
$string['programmed_analysis_past'] = 'Documenten zijn voor analyse naar Compilatio gestuurd op {$a}.';
$string['progress'] = 'Vooruitgang:';
$string['queuing_docs'] = '{$a} documenten wachten op analyse';
$string['quiz_help'] = 'Enkel open vragen waarvan het antwoord minstens {$a} woorden bevat zullen geanalyseerd worden.';
$string['read_only_apikey'] = 'Jouw enkel lezen API-sleutel staat niet toe dat je documenten upload of documenten analyseert.';
$string['red_threshold'] = 'anders rood';
$string['redirect_report_failed'] = 'Er is een fout opgetreden bij het ophalen van het analyserapport. Probeer later opnieuw of neem contact op met de ondersteuning (support@compilatio.net) als dit probleem zich blijft voordoen.';
$string['reporttype'] = 'Rapport beschikbaar voor leerlingen';
$string['reporttype_help'] = '<p>Er zijn twee mogelijke opties :</p>
<ul>
    <li><strong> Analysecertificaat :</strong> De leerling zal toegang hebben tot de analysecertificaten van zijn documenten.</li>
    <li><strong> Gedetailleerd rapportt :</strong> De leerling zal toegang hebben tot de PDF-versie van het rapport.</li>
</ul>';
$string['reset_docs_in_error'] = 'Documenten met fout resetten';
$string['reset_docs_in_error_in_progress'] = 'Documenten met fout die verwerkt worden resetten';
$string['response_type'] = 'Antwoordtype';
$string['results'] = 'Resultaten';
$string['results_by_student'] = 'Resultaat per leerling';
$string['saved_config_failed'] = '<strong>De ingegeven combinatie  API-sleutel - adres is niet geldig. Compilatio is uitgeschakeld. Probeer opnieuw.<br/>
De <a href="autodiagnosis.php">automatische diagnosepagina</a> kan je helpen bij de configuratie van deze plugin.</strong><br/>
Fout:';
$string['score'] = 'Score';
$string['score_settings_info'] = 'Het aanpassen van de score zal alle geanalyseerde documenten in de opdracht beïnvloeden,<br>ook de individueel aangepaste documenten.';
$string['see_all_notifications'] = 'Bekijk alle meldingen';
$string['select_a_student'] = 'Selecteer een leerling';
$string['send_all_documents'] = 'Stuur alle documenten';
$string['send_documents_in_progress'] = 'Versturen van documenten bezig';
$string['short_error_analysis_failed'] = 'mislukte analyses.';
$string['short_error_not_found'] = 'documenten niet gevonden.';
$string['short_error_sending_failed'] = 'versturen mislukt.';
$string['short_error_too_large'] = 'documenten te groot.';
$string['short_error_too_long'] = 'documenten te lang.';
$string['short_error_too_short'] = 'documenten te kort.';
$string['short_error_unsupported'] = 'documenten niet ondersteund.';
$string['showstudentreport'] = 'Toon analyse aan leerling';
$string['showstudentreport_help'] = 'Het analyserapport geeft een overzicht van welke delen van een inzending geplagieerd zijn en geeft de locatie van de gevonden bronnen.';
$string['showstudentscore'] = 'Toon de score voor verdachte tekst aan leerling';
$string['showstudentscore_help'] = 'De verdachte tekstscore is het percentage van de inzending die mogelijks niet authentiek is.';
$string['showwhenclosed'] = 'Wanneer activiteit sluit';
$string['similarities'] = 'Verdachte tekst';
$string['similarities_disclaimer'] = 'Je kunt verdacht teksten in deze activiteit analyseren met <a href=\'http://www.compilatio.net/en/\' target=\'_blank\'>Compilatio</a>.<br/> Opgelet: sommige verdachte teksten zijn niet noodzakelijk plagiaat. Het analyserapport helpt je met het identificeren van overeenkomsten en de beoordeling of iets in aanmerking komt voor quoteren of plagiaat is.';
$string['similarity_percent'] = '% verdachte tekst';
$string['simscore'] = 'Overeenkomsten';
$string['simscore_percentage'] = 'Percentage overeenkomsten';
$string['start_all_analysis'] = 'Analyseer alle documenten';
$string['start_analysis_in_progress'] = 'De analyse is gestart';
$string['start_selected_files_analysis'] = 'Analyseer geselecteerde documenten';
$string['start_selected_questions_analysis'] = 'Analyse geselecteerde vragen';
$string['stats_avg'] = 'Gemiddelde';
$string['stats_error_unknown'] = 'onbekende fouten';
$string['stats_errors'] = 'Fouten';
$string['stats_max'] = 'Maximum';
$string['stats_min'] = 'Minimum';
$string['stats_score'] = 'Percentage verdachte tekst';
$string['stats_threshold'] = 'Aantal documenten per drempel';
$string['student'] = 'Leerling';
$string['student_analyse'] = 'De analyse kan door de leerling gestart worden.';
$string['student_help'] = 'Je kunt je concept analyseren met Compilatio Magister, zodat je overeenkomsten in je teksten kunt meten.<br />
De inhoud van je concept zal niet gebruikt worden door Compilatio als vergelijkingsmateriaal voor toekomstige analyses.<br />
Je leraar zal toegang hebben tot dit analyserapport.';
$string['studentanalyses'] = 'Sta toe dat leerlingen hun documenten analyseren';
$string['studentanalyses_help'] = 'Hiermee kunnen leerlingen hun concepten analyseren met Compilatio Magister, voor ze die insturen naar de leraar.';
$string['studentdisclosuredefault'] = 'Alle hier geüploade bestanden zullen op verdachte tekst gecontroleerd worden door Compilatio';
$string['students_disclosure'] = 'Zichtbaar voor leerlingen';
$string['students_disclosure_help'] = 'Deze tekst zal aan alle leerlingen op de uploadpagina voor bestanden getoond worden.';
$string['subscription'] = '<b>Informatie over je abonnement:</b>';
$string['subscription_analysis_count'] = 'Aantal geanalyseerde documenten: {$a->usage} van {$a->value}';
$string['subscription_analysis_page_count'] = 'Aantal geanalyseerde pagina\'s: {$a->usage} van {$a->value}';
$string['subscription_end'] = 'Einddatum inbegrepen:';
$string['subscription_start'] = 'Startdatum:';
$string['suspect_words/total_words'] = 'verdachte woorden / totaal aantal woorden';
$string['suspect_words_quiz_on_total'] = 'verdachte woorden / <br>totaal aantal woorden';
$string['tabs_title_help'] = 'Help';
$string['tabs_title_stats'] = 'Statistieken';
$string['teacher'] = 'Leraar';
$string['teacher_features_title'] = 'Functies, ingeschakeld voor leraren';
$string['terms_of_service_info'] = '<a href=\'{$a}\'>Gebruiksvoorwaarden</a> van Compilatio';
$string['text'] = 'Tekst';
$string['thresholds_description'] = 'Geef de drempel aan die je wil gebruiken om overeenkomsten te vinden met het analyserapport (% verdachte tekst):';
$string['thresholds_settings'] = 'Limieten:';
$string['timesubmitted'] = 'Ingestuurd naar Compilatio op';
$string['title_analysing'] = 'Compilatio analyseert dit bestand.';
$string['title_error_analysis_failed'] = 'De analyse van dit document verliep niet correct.';
$string['title_error_not_found'] = 'Dit document werd niet gevonden. Neem contact op met je Moodlebeheerder. Fout: document niet gevonden voor deze API-sleutel.';
$string['title_error_sending_failed'] = 'Er is een fout opgetreden bij het versturen van dit document naar Compilatio';
$string['title_error_too_large'] = 'Dit bestand is te groot om door Compilatio te laten verwerken. Maximale grootte: {$a} MB.';
$string['title_error_too_long'] = 'Dit bestand bevat teveel woorden om door Compilatio te laten analyseren. Maximale aantal: {$a} woorden.';
$string['title_error_too_short'] = 'Dit bestand bevat te weinig woorden om door Compilatio te laten analyseren. Minimaal aantal: {$a} woorden.';
$string['title_error_unsupported'] = 'Dit bestandstype wordt niet ondersteund door Compilatio';
$string['title_planned'] = 'Dit bestand zal verwerkt worden op {$a}';
$string['title_queue'] = 'Dit document is nu in de wachtrij en zal binnenkort door Compilatio geanalyseerd worden';
$string['title_score'] = 'Analyse voltooid: {$a}% verdachte tekst.';
$string['title_score_teacher'] = 'Klik hier om de score bij te werken als je bepaalde bronnen in het rapport genegeerd hebt.';
$string['title_sent'] = 'Start analyse';
$string['title_unsent'] = 'Stuur document naar Compilatio';
$string['tooltip_detailed_scores'] = '% verdachte tekst, inclusief';
$string['total'] = 'Totaal';
$string['trigger_analyses'] = 'Start Compilatio-analyse';
$string['unmeasured'] = 'niet gemeten';
$string['unsent_docs'] = 'Deze activiteit bevat documenten die nog niet naar Compilatio verstuurd zijn.';
$string['update_meta'] = 'Voer de geplande taken voor Compilatio uit';
$string['utlscore'] = 'Taal niet herkend';
$string['utlscore_percentage'] = 'Percentage  niet-herkende taaltypes';
$string['webservice_not_ok'] = 'De server kon niet verbinden met de webservice. Je firewall blokkeert misschien de verbinding.';
$string['webservice_ok'] = 'De server kan verbinden met de webservice.';
$string['webservice_unreachable'] = 'Compilatio is nu niet beschikbaar. Excuses voor het ongemak.';
$string['word'] = 'woorden';
$string['word_limits'] = 'Een tekst moet tussen {$a->min} en {$a->max} woorden bevatten om geanalyseerd te kunnen worden';
$string['wrong_apikey_type'] = 'De API-sleutel is niet geldig. Als je recent je Compilatio-plugin hebt geüpdatet, neem dan contact op met support (support@compilatio.net)  voor een nieuwe sleutel.';
