<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'diary', language 'nl', version '4.3'.
 *
 * @package     diary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Geen toegang';
$string['additionallinks'] = 'Bijkomende links voor deze activiteit en cursus';
$string['addtofeedback'] = 'Toevoegen aan feedback';
$string['alias'] = 'Sleutelwoord';
$string['aliases'] = 'Sleutelwoorden';
$string['aliases_help'] = 'Elk dagboekitem kan geassocieerd worden met een lijst sleutelwoorden.

Zet elk sleutelwoord op een nieuwe regel (niet scheiden met komma\'s).';
$string['alwaysopen'] = 'Altijd open';
$string['alwaysshowdescription'] = 'Altijd beschrijving toestaan';
$string['alwaysshowdescription_help'] = 'Indien uitgeschakeld zal de beschrijving van het dagboek hierboven enkel zichtbaar zijn op de "opent op" tijd.';
$string['and'] = 'en';
$string['attachment'] = 'Bijlage';
$string['attachment_help'] = 'Je kunt optioneel één of meer bestanden toevoegen aan een dagboekpagina.';
$string['autorating'] = 'Automatisch beoordelen';
$string['autorating_descr'] = 'Indien ingeschakeld zal de beoordeling van een item enkel automatisch berekend worden, gebaseerd op de min/max instellingen.';
$string['autorating_help'] = 'Deze instellingen bepalen samen met de min/max-instellingen de standaarden voor automatisch beoordelen in alle nieuwe dagboeken.';
$string['autorating_title'] = 'Automatisch beoordelen inschakelen';
$string['autoratingbelowmaxitemdetails'] = 'Automatisch beoordelen vereist {$a->one} of meer {$a->two} met mogelijk {$a->three}% strafpunten voor elk tekort.<br>Je hebt er  {$a->four}. Je hebt er {$a->five} nodig. Mogelijk strafpunt is {$a->six} punten.';
$string['autoratingitempenaltymath'] = 'De automatische berekening van het aantal strafpunten is (max({$a->one} - {$a->two}, 0)) * {$a->three} =  {$a->four}.<br> Merk op:  max verhindert negatieve getallen veroorzaakt door meer dan vereist te hebben.';
$string['autoratingitempercentset'] = 'Automatisch beoordelen percentage-instellingen: {$a}%';
$string['autoratingovermaxitemdetails'] = 'Automatisch beoordelenlimiet is een maximum van {$a->one} {$a->two} met mogelijk {$a->three}% strafpunten voor elke extra.<br>Je hebt er  {$a->four}, wat {$a->five} teveel is. Mogelijk strafpunt is {$a->six} punten.';
$string['availabilityhdr'] = 'Beschikbaarheid';
$string['avgsylperword'] = 'Gemiddeld aantal lettergrepen per woord: {$a}';
$string['avgwordlenchar'] = 'Gemiddelde woordlengte: {$a} tekens';
$string['avgwordpara'] = 'Gemiddeld aantal woorden per alinea: {$a}';
$string['blankentry'] = 'Lege pagina';
$string['calendarend'] = '{$a} sluit';
$string['calendarstart'] = '{$a} opent';
$string['cancel'] = 'Transfer annuleren';
$string['chars'] = 'Tekens:';
$string['charspersentence'] = 'Tekens per zin';
$string['clearfeedback'] = 'Feedback wissen';
$string['commonerrorpercentset'] = 'Instelling algemene foutenpercentage {$a}%';
$string['commonerrors'] = 'Algemene fouten';
$string['commonerrors_help'] = 'De algemene fouten worden gedefinieerd in de "Woordenlijst met fouten" die geassocieerd is met deze vraag.';
$string['configdateformat'] = 'Dit bepaalt hoe data getoond worden in dagboekrapporten. De standaardwaarde "M d ,Y G:i" is maand, dag jaar en 24-uur opmaak voor de tijd. Kijk naar "Date" in de PHP-handleiding voor meer voorbeelden en voorgedefinieerde datumconstanten.';
$string['created'] = '{$a->one} dagen en {$a->two} uur geleden gemaakt.';
$string['createnewprompt'] = 'Maak nieuwe prompt';
$string['crontask'] = 'Achtergrondverwerking voor Dagboekmodule';
$string['csvexport'] = 'Exporteer naar .csv';
$string['currententry'] = 'Huidige dagboekpagina\'s:';
$string['currpotrating'] = 'Je huidig mogelijk cijfer is: {$->one} punten of {$a->two}%.';
$string['datechanged'] = 'Datum gewijzigd';
$string['dateformat'] = 'Standaard datum-opmaak';
$string['datestart'] = 'Datum om te starten instellen met prompt ID {$a}:';
$string['datestop'] = 'Datum om te stoppen instellen met prompt ID {$a}:';
$string['daysavailable'] = 'Beschikbare dagen';
$string['daysavailable_help'] = 'Als je de week-format gebruikt voor de cursus, dan kun je instellen hoeveel dagen het dagboek open staat voor gebruik.';
$string['deadline'] = 'Dagen open';
$string['delete'] = 'Verwijder';
$string['deleteallratings'] = 'Verwijder alle beoordelingen';
$string['deleteexconfirm'] = 'Bevestig dat je het prompt ID voor schrijven gaat verwijderen';
$string['deletenotenrolled'] = 'Verwijder items van niet aangemelde gebruikers';
$string['details'] = 'Details:';
$string['detectcommonerror'] = 'Minstens {$a->one}, {$a->two} gedetecteerd. Deze zijn: {$a->three}
<br>Indien toegestaan zou je die moeten verbeteren en opnieuw insturen.';
$string['diary:addentries'] = 'Voeg dagboekpagina toe';
$string['diary:addinstance'] = 'Voeg dagboek toe';
$string['diary:manageentries'] = 'Beheer dagboekpagina\'s';
$string['diary:rate'] = 'Beoordeel dagboekpagina\'s';
$string['diaryclosetime'] = 'Dagboek open tot';
$string['diaryclosetime_help'] = 'Indien ingeschakeld kun je een datum instellen wanneer het dagboek sluit en niet meer gebruikt kan worden.';
$string['diarydescription'] = 'Beschrijving dagboek';
$string['diaryentrydate'] = 'Zet een datum bij deze pagina';
$string['diaryid'] = 'DagboekID om de transfer naar te doen';
$string['diarymail'] = 'Beste {$a->user},
{$a->teacher} heeft feedback gegeven bij je dagboekpagina voor \'{$a->diary}\'.

Je kunt die onderaan je dagboekpagina lezen:

{$a->url}';
$string['diarymailhtml'] = 'Beste {$a->user},<br>
{$a->teacher} heeft feedback gegeven bij je dagboekpagina voor \'<i>{$a->diary}</i>\'.<br /><br />
Je kunt die onderaan je dagboekpagina lezen: <a href="{$a->url}">diary entry</a>.';
$string['diarymailhtmluser'] = 'heeft een dagboekitem geschreven voor \'<i>{$a->diary}</i>\'<br /><br />
Je kunt het  <a href="{$a->url}">dagboekitem hier bekijken</a>.<br /><br />Merk op: je moet misschien feedback geven of de status van het item updaten, zodat de activiteit als voltooid gemarkeerd kan worden.';
$string['diarymailuser'] = 'heeft een dagboekitem geschreven voor \'{$a->diary}\'

Je kunt het dagboekitem hier bekijken:

    {$a->url}

Merk op: je moet misschien feedback geven of de status van het item updaten, zodat de activiteit als voltooid gemarkeerd kan worden.';
$string['diaryname'] = 'Naam dagboek';
$string['diaryopentime'] = 'Dagboek open van';
$string['diaryopentime_help'] = 'Indien ingeschakeld kun je instellen wanneer het dagboek kan gebruikt worden.';
$string['diarytitle'] = 'Titel';
$string['diarytitle_help'] = 'Je kan een optionele titel of omschrijving opgeven';
$string['editall'] = 'Bewerk alle pagina\'s';
$string['editall_help'] = 'Indien ingeschakeld kunnen gebruikers alle pagina\'s bewerken.';
$string['editdates'] = 'Bewerk data van de pagina\'s';
$string['editdates_help'] = 'Indien ingeschakeld kunnen gebruikers de datum van hun pagina\'s wijzigen.';
$string['editingended'] = 'Bewerkperiode is beëindigd';
$string['editingends'] = 'Bewerkperiode eindigt';
$string['editthisentry'] = 'Bewerk deze pagina';
$string['edittopoflist'] = 'Bewerk bovenaan de lijst';
$string['eeditlabel'] = 'Bewerk';
$string['emaillater'] = 'E-mail naar leraar sturen';
$string['emailnow'] = 'Nu e-mailen';
$string['emailpreference'] = 'Schakel e-mails';
$string['enableautorating'] = 'Automatisch beoordelen inschakelen';
$string['enableautorating_help'] = 'Automatische beoordeling inschakelen of uitschakelen';
$string['enablestats'] = 'Statistieken inschakelen';
$string['enablestats_descr'] = 'Indien ingeschakeld zullen de statistieken voor elk item getoond worden.';
$string['enablestats_help'] = 'Inschakelen, uitschakelen, bekijken van statistieken voor elk item.';
$string['enablestats_title'] = 'Statistieken inschakelen';
$string['enabletitles'] = 'Titels inschakelen';
$string['enabletitles_descr'] = 'Indien ingeschakeld, zullen de titels voor elke bijdrage verplicht zijn en getoond worden.';
$string['enabletitles_help'] = 'Schakel titels in of uit voor elke bijdrage.';
$string['enabletitles_title'] = 'Schakel titels in';
$string['entries'] = 'Pagina\'s';
$string['entry'] = 'Pagina';
$string['entrybgc'] = 'Achtergrondkleur voor dagboekitem / feedback';
$string['entrybgc_colour'] = '#93FC84';
$string['entrybgc_descr'] = 'Dit stelt de achtergrondkleur in van een dagboekpagina / feedback';
$string['entrybgc_help'] = 'Dit stelt de algemene achtergrondkleur in voor elk dagboek-item en feedback.';
$string['entrybgc_title'] = 'Achtergrondkleur dagboekpagina / feedback';
$string['entrycomment'] = 'Opmerking bij pagina';
$string['entrysuccess'] = 'Jouw schrijven is bewaard! Misschien moet het nagekeken of beoordeeld worden voor deze activiteit als voltooid wordt aangeduid.';
$string['entrytextbgc'] = 'Dagboektekst achtergrondkleur';
$string['entrytextbgc_colour'] = '#EEFC84';
$string['entrytextbgc_descr'] = 'Dit stelt de achtergrondkleur in van de tekst op een dagboekpagina';
$string['entrytextbgc_help'] = 'Dit stelt de achtergrondkleur in voor de tekst in een dagboekitem';
$string['entrytextbgc_title'] = 'Dagboek tekst achtergrondkleur';
$string['errorbehavior'] = 'Gedrag foutenovereenkomst';
$string['errorbehavior_help'] = 'Deze instellingen verfijnen het gedrag voor het vinden van fouten in de woordenlijst met fouten.';
$string['errorcmid'] = 'Woordenlijst met fouten';
$string['errorcmid_help'] = 'Kies de woordenlijst die een lijst met algemene fouten bevat. Telkens wanneer één van de fouten gevonden wordt in het antwoord, zal de het opgegeven strafpunt afgetrokken worden van de beoordeling van de leerling voor dit dagboek-item.';
$string['errorfullmatch'] = 'Fout bij koppeling';
$string['errorfullmatch_help'] = 'Deze instelling verfijnt het koppelgedrag voor items in de lijst met algemene fouten';
$string['errorpercent'] = 'Strafpunten per fout';
$string['errorpercent_help'] = 'Selecteer het percentage van het totaal dat afgetrokken moet worden voor elke fout die in het antwoord gevonden wordt.';
$string['errp'] = 'Fout %:';
$string['eventdiarycreated'] = 'Dagboek gemaakt';
$string['eventdiarydeleted'] = 'Dagboek verwijderd';
$string['eventdiaryviewed'] = 'Dagboek bekeken';
$string['eventdownloadentriess'] = 'Download pagina\'s';
$string['evententriesviewed'] = 'Bekeken dagboekpagina\'s';
$string['evententrycreated'] = 'Dagboekpagina gemaakt';
$string['evententryupdated'] = 'Dagboekpagina aangepast';
$string['eventfeedbackupdated'] = 'Dagboek feedback aangepast';
$string['eventinvalidentryattempt'] = 'Dagboek ongeldig item';
$string['eventpromptcreated'] = 'Schrijfsuggestie gemaakt';
$string['eventpromptedited'] = 'Schrijfsuggestie bewerkt';
$string['eventpromptinuse'] = 'Verwijderen van suggestie voorkomen';
$string['eventpromptremoved'] = 'Suggestie verwijderd';
$string['eventpromptsviewed'] = 'Suggestie bekeken';
$string['eventxfrentries'] = 'Journal naar Dagboekitem transfer';
$string['exportfilename'] = 'paginas.csv';
$string['exportfilenamep1'] = 'alle_site';
$string['exportfilenamep2'] = '_dagboek_pagina_export_op_';
$string['feedbackupdated'] = 'Feedback aangepast voor {$a} pagina\'s';
$string['files'] = 'Bestanden';
$string['firstentry'] = 'Eerste dagboekpagina\'s:';
$string['fkgrade'] = 'FK-niveau';
$string['fkgrade_help'] = 'Flesh Kincaid niveau geeft het aantal jaar scholing die over het algemeen nodig is om deze tekst te begrijpen. Probeer een niveau lager dan 10 te zoeken.';
$string['fogindex'] = 'Fog-index';
$string['fogindex_help'] = 'De Gunning fog-index is een maat voor de leesbaarheid. Dit wordt met volgende formule berekend.

((aantal woorden per zin) + (lange moorden per zin)) x 0,4

Probeer voor een niveau onder de 10 te gaan. Meer informatie op: <https://en.wikipedia.org/wiki/Gunning_fog_index>';
$string['for'] = 'voor site:';
$string['format'] = 'Opmaak';
$string['freadingease'] = 'Flesh gemakkelijk leesniveau';
$string['freadingease_help'] = 'Flesh gemakkelijk leesniveau: hoge scores geven aan dat je tekst makkelijker te lezen is terwijl een lage score aangeeft dat je tekst moeilijk te lezen is. Ga voor een Flesh gemakkelijk leesniveau boven de 60.';
$string['generalerror'] = 'Er is een fout opgetreden.';
$string['generalerrorinsert'] = 'Kon geen nieuw dagboek-item invoegen.';
$string['generalerrorupdate'] = 'Kon je dagboek niet aanpassen.';
$string['gradeingradebook'] = 'Huidig cijfer in cijferboek';
$string['highestgradeentry'] = 'Hoogst beoordeelde pagina\'s';
$string['idlable'] = '(ID: {$a})';
$string['incorrectcourseid'] = 'Cursus-ID is fout';
$string['incorrectmodule'] = 'Cursus module-ID is fout';
$string['invalidaccess'] = 'Ongeldige toegang';
$string['invalidaccessexp'] = 'Je hebt het recht niet om deze pagina te bekijken. De poging werd gelogd.';
$string['invalidtimechange'] = 'Een ongeldige poging om dit item te wijzigen. Het tijdstip van aanmaken werd gedetecteerd.';
$string['invalidtimechangenewtime'] = 'Het tijdstip van wijzigen was: {$a->one}.';
$string['invalidtimechangeoriginal'] = 'Het oorspronkelijke tijdstip was: {$a->one}.';
$string['invalidtimeresettime'] = 'Het tijdstip is teruggezet naar het oorspronkelijke tijdstip: {$a->one}.';
$string['journalid'] = 'JournalID om een transfer van te doen';
$string['journalmissing'] = 'Er zijn geen actieve Journals in deze cursus.';
$string['journaltodiaryxfrdid'] = '<br>Dit is een lijst met dagboekactiviteiten in deze cursus. <br></b>| Cursus | Dagboeknaam<br>';
$string['journaltodiaryxfrjid'] = 'Dit is een lijst met elke logboekactiviteit in deze cursus<br><b>    ID</b> | Cursus | Logboeknaam<br>';
$string['journaltodiaryxfrp1'] = 'Deze functie is enkel voor beheerders om Logboek-items te verplaatsten naar Dagboekitems. Items van meerdere logboeken kunnen naar een enkel of naar aparte dagboeken verplaats worden. Dit is een nieuwe functie en nog onder ontwikkeling.<br><br>';
$string['journaltodiaryxfrp2'] = 'Als je <b>Overzetten en stuur e-mail</b> selectievakje gebruikt, dan zal elk overgezet logboek-item het nieuwe dagboek-item markeren zodat er een e-mail verstuurd wordt naar de gebruiker om hen te melden dat het item naar een dagboekactiviteit is overgezet.<br><br>';
$string['journaltodiaryxfrp3'] = 'Als je <b>Overzetten zonder e-mail</b> gebruikt, dan zal er GEE? e-mail verstuurd worden wanneer er een logboek-item het nieuwe dagboek-item  overgezet wordt, zelfs wanneer dit proces automatisch feedback toevoegt die niet in het originele logboek te vinden was.<br><br>';
$string['journaltodiaryxfrp4'] = 'De naam van de cursus waarin je werkt is: <b> {$a->one}</b>, met cursus-ID: <b> {$a->two}</b><br><br>';
$string['journaltodiaryxfrp5'] = 'Als je er voor kiest om automatisch feedback toe te voegen ongeacht of het logboekitem al feedback heeft, dan zul je automatisch als leraar toegevoegd worden voor dat item om een fout te voorkomen. <br><br>';
$string['journaltodiaryxfrtitle'] = 'Journal naar dagboek xfr';
$string['lastnameasc'] = 'Achternaam oplopend:';
$string['lastnamedesc'] = 'Achternaam aflopend:';
$string['latestmodifiedentry'] = 'Laatst aangepaste pagina:';
$string['lexicaldensity'] = 'Lexicale densiteit';
$string['lexicaldensity_help'] = 'De lexicale densiteit is een percentage dat berekend wordt met volgende formule.

100 x (aantal unieke woorden) / (totaal aantal woorden)

Daarom heeft een essay waarin woorden vaak herhaald worden een lage lexicale densiteit, terwijl een essay met veel unieke woorden een hoge lexicale densiteit heeft.';
$string['longwords'] = 'Unieke woorden';
$string['longwords_help'] = 'Lange woorden zijn woorden die drie of meer lettergrepen tellen. Merk op dat het algoritme het aantal lettergrepen slechts bij benadering kan bepalen.';
$string['longwordspersentence'] = 'Lange woorden per zin';
$string['lowestgradeentry'] = 'Laagst beoordeelde pagina:';
$string['mailed'] = 'E-mail verzonden';
$string['mailsubject'] = 'Dagboek feedback';
$string['max'] = 'max';
$string['maxc'] = 'Max:';
$string['maxchar'] = 'Maximaal aantal tekens';
$string['maxchar_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker minder tekens invoeren dat het dit maximum. Anders krijgt die strafpunten voor elk teveel ingevoerd teken.';
$string['maxcharacterlimit'] = 'Maximaal aantal tekens';
$string['maxcharacterlimit_desc'] = 'Opmerking: dit item mag <strong>maximaal {$a} tekens</strong> tellen.';
$string['maxcharacterlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker minder dan dat aantal tekens gebruiken.';
$string['maxparagraph'] = 'Maximaal aantal alinea\'s';
$string['maxparagraph_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker minder alinea\'s invoeren dat het dit maximum. Anders krijgt die strafpunten voor elke teveel ingevoerd alinea.';
$string['maxparagraphlimit'] = 'Maximaal aantal alinea\'s';
$string['maxparagraphlimit_desc'] = 'Opmerking: dit item mag <strong>maximaal {$a} alinea\'s</strong> tellen.';
$string['maxparagraphlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker minder dan dat aantal aiinea\'s schrijven.';
$string['maxpossrating'] = 'Het maximaal aantal punten voor dit item is {$a} punten';
$string['maxsentence'] = 'Maximaal aantal zinnen';
$string['maxsentence_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker minder zinnen invoeren dat het dit maximum. Anders krijgt die strafpunten voor elke teveel ingevoerd zin.';
$string['maxsentencelimit'] = 'Maximaal aantal zinnen';
$string['maxsentencelimit_desc'] = 'Opmerking: dit item mag <strong>maximaal {$a} zinnen</strong> tellen.';
$string['maxsentencelimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker minder dan dat aantal zinnen gebruiken.';
$string['maxword'] = 'Maximaal aantal woorden';
$string['maxword_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker minder woorden invoeren dat het dit maximum. Anders krijgt die strafpunten voor elk teveel ingevoerd woord.';
$string['maxwordlimit'] = 'Maximaal aantal woorden';
$string['maxwordlimit_desc'] = 'Opmerking: dit item mag <strong>maximaal {$a} woorden</strong> tellen.';
$string['maxwordlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker minder dan dat aantal woorden gebruiken.';
$string['mediumwords'] = 'Unieke medium woorden';
$string['mediumwords_help'] = 'Medium woorden zijn woorden met twee lettergrepen. Merk op dat het algoritme  het aantal lettergrepen slechts kan benaderen.';
$string['min'] = 'min';
$string['minc'] = 'Min:';
$string['minchar'] = 'Minimaal aantal tekens';
$string['minchar_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker meer tekens invoeren dat het dit minimum. Anders krijgt die strafpunten voor elk te weinig ingevoerd teken.';
$string['mincharacterlimit'] = 'Minimaal aantal tekens';
$string['mincharacterlimit_desc'] = 'Opmerking: dit item mag <strong>minimaal {$a} tekens</strong> tellen.';
$string['mincharacterlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker meer dan dat aantal tekens gebruiken.';
$string['minmaxcharpercent'] = 'Teken strafpunten per min/max fout aantal';
$string['minmaxcharpercent_help'] = 'Selecteer het percentage van de totale beoordeling die zou moeten afgetrokken worden voor elke min/max fout voor het aantal tekens.';
$string['minmaxhdr'] = 'Min/Max aantallen';
$string['minmaxhdr_help'] = 'Deze instelling bepaalt de standaarden voor minimaal en maximaal aantal woorden en zinnen in alle nieuwe dagboeken.';
$string['minmaxparagraphpercent'] = 'Alinea strafpunt per min/max-fout';
$string['minmaxparagraphpercent_help'] = 'Selecteer het percentage van het totaalcijfer dat moet afgetrokken worden voor elke min/max-fout voor het aantal alinea\'s.';
$string['minmaxparapercent'] = 'Alinea strafpunten per min/max fout aantal';
$string['minmaxparapercent_help'] = 'Selecteer het percentage van de totale beoordeling die zou moeten afgetrokken worden voor elke min/max fout voor het aantal alinea\'s.';
$string['minmaxpercent'] = 'Strafpunten per min/max fout aantal';
$string['minmaxpercent_help'] = 'Selecteer het percentage van de totale beoordeling die zou moeten afgetrokken worden voor elke min/max fout.';
$string['minmaxsentencepercent'] = 'Zin strafpunt per min/max-fout';
$string['minmaxsentencepercent_help'] = 'Selecteer het percentage van het totaalcijfer dat moet afgetrokken worden voor elke min/max fout voor het aantal zinnen.';
$string['minmaxsentpercent'] = 'Zinnen strafpunten per min/max fout aantal';
$string['minmaxsentpercent_help'] = 'Selecteer het percentage van de totale beoordeling die zou moeten afgetrokken worden voor elke min/max fout voor het aantal zinnen.';
$string['minmaxwordpercent'] = 'Woorden strafpunten per min/max fout aantal';
$string['minmaxwordpercent_help'] = 'Selecteer het percentage van de totale beoordeling die zou moeten afgetrokken worden voor elke min/max fout voor het aantal woorden.';
$string['minparagraph'] = 'Minimaal aantal alinea\'s';
$string['minparagraph_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker meer alinea\'s invoeren dat het dit minimum. Anders krijgt die strafpunten voor elke te weinig ingevoerde alinea.';
$string['minparagraphlimit'] = 'Minimaal aantal alinea\'s';
$string['minparagraphlimit_desc'] = 'Opmerking: dit item moet <strong>minimaal {$a} alinea\'s</strong> tellen.';
$string['minparagraphlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker meer dan dat aantal aiinea\'s gebruiken.';
$string['minsentence'] = 'Minimaal aantal zinnen';
$string['minsentence_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker meer zinnen invoeren dat het dit minimum. Anders krijgt die strafpunten voor elke te weinig ingevoerd zin.';
$string['minsentencelimit'] = 'Minimaal aantal zinnen';
$string['minsentencelimit_desc'] = 'Opmerking: dit item moet <strong>minimaal {$a} zinnen</strong> tellen.';
$string['minsentencelimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker meer dan dat aantal zinnen gebruiken.';
$string['minword'] = 'Minimaal aantal woorden';
$string['minword_help'] = 'Als hier een getal groter dan 0 ingegeven wordt, dan moet de gebruiker meer woorden invoeren dat het dit minimum. Anders krijgt die strafpunten voor elk te weinig ingevoerde woorden.';
$string['minwordlimit'] = 'Minimaal aantal woorden';
$string['minwordlimit_desc'] = 'Opmerking: dit item moet <strong>minimaal {$a} woorden</strong> tellen.';
$string['minwordlimit_help'] = 'Als hier een getal wordt ingegeven, dan moet de gebruiker meer dan dat aantal woorden gebruiken.';
$string['missing'] = 'Ontbrekend';
$string['modulename'] = 'Dagboek';
$string['modulename_help'] = 'Met de dagboek-activiteit kunnen leraars feedback van leerlingen krijgen over een bepaalde tijdsperiode.';
$string['modulenameplural'] = 'Dagboeken';
$string['needsgrading'] = 'Deze pagina heeft nog geen feedback gekregen of is nog niet beoordeeld.';
$string['needsregrade'] = 'Deze pagina is gewijzigd sinds er feedback gegeven is of sinds ze was beoordeeld.';
$string['newdiaryentries'] = 'Nieuwe dagboekpagina\'s';
$string['nextentry'] = 'Volgende pagina';
$string['nodeadline'] = 'Altijd open';
$string['noentriesmanagers'] = 'Er zijn geen leraren';
$string['noentry'] = 'Geen pagina';
$string['noratinggiven'] = 'Geen beoordeling';
$string['notextdetected'] = '<b>Geen tekst gevonden!</b>';
$string['notopenuntil'] = 'Dit dagboek gaat niet open voor';
$string['notstarted'] = 'Je bent nog niet begonnen aan dit dagboek.';
$string['numwordscln'] = '{$a->one} woorden en {$a->two} tekens gebruikt, {$a->three} spaties NIET meegerekend.';
$string['numwordsnew'] = 'Nieuwe berekening: {$a->one} woorden en {$a->two} tekens gebruikt in {$a->three} zinnen en {$a->four} alinea\'s.';
$string['numwordsraw'] = '{$a->one} woorden en {$a->two} tekens gebruikt, {$a->three} spaties inbegrepen.';
$string['numwordsstd'] = '{$a->one} standaard woorden en {$a->two} tekens gebruikt, {$a->three} spaties inbegrepen.';
$string['outof'] = 'van {$a} pagina\'s';
$string['overallrating'] = 'Algemene beoordeling';
$string['pagesize'] = 'Dagboekpagina\'s per pagina';
$string['paragraphs'] = 'Alinea\'s:';
$string['percentofentryrating'] = '{$a}% van de beoordeling van het item.';
$string['phrasecasesensitiveno'] = 'Hoofdlettergevoelig';
$string['phrasecasesensitiveyes'] = 'Niet hoofdlettergevoelig';
$string['phrasefullmatchno'] = 'Hele woorden of delen van een woord.';
$string['phrasefullmatchyes'] = 'Enkel hele woorden.';
$string['phraseignorebreaksno'] = 'Herken regeleinden.';
$string['phraseignorebreaksyes'] = 'Negeer regeleinden.';
$string['pluginadministration'] = 'Beheer dagboekmodule';
$string['pluginname'] = 'Dagboek';
$string['popoverhelp'] = 'klik voor info';
$string['potautoratingerrpen'] = 'Mogelijk aantal strafpunten bij automatisch beoordelen: {$a->one}% of {$a->two}  punten minder.';
$string['potcommerrpen'] = 'Mogelijk aantal strafpunten voor algemene fouten: {$a->one} * {$a->two} = {$a->three}% of {$a->four} punten minder.';
$string['present'] = 'Aanwezig';
$string['previousentry'] = 'Vorige pagina';
$string['privacy:metadata:diary_entries'] = 'Een record van een dagboekitem.';
$string['privacy:metadata:diary_entries:diary'] = 'De ID van de dagboekactiviteit waarin het item was geschreven.';
$string['privacy:metadata:diary_entries:entrycomment'] = 'Feedback van leraar en indien mogelijk, feedback automatische beoordeling.';
$string['privacy:metadata:diary_entries:mailed'] = 'Is er een e-mail naar de gebruiker gestuurd?';
$string['privacy:metadata:diary_entries:promptdatestart'] = 'De datum van wanneer de automatische schrijfsuggestie gebruikt wordt.';
$string['privacy:metadata:diary_entries:promptdatestop'] = 'De datum van wanneer de automatische schrijfsuggestie niet meer gebruikt wordt.';
$string['privacy:metadata:diary_entries:promptid'] = 'De ID van de automatische schrijfsuggestie die gebruikt werd voor automatische beoordeling en feedback.';
$string['privacy:metadata:diary_entries:prompttext'] = 'De tekst van de schrijfsuggestie die gebruikt werd voor automatische beoordeling en feedback.';
$string['privacy:metadata:diary_entries:rating'] = 'Het cijfer voor dit dagboekitem. Dit dan bepaald worden door schalen, geavanceerde beoordelingsformulieren en dergelijke, maar zal altijd terug geconverteerd worden naar een kommagetal.';
$string['privacy:metadata:diary_entries:teacher'] = 'De gebruikersID van de persoon die het item beoordeelt.';
$string['privacy:metadata:diary_entries:text'] = 'De inhoud van dit item.';
$string['privacy:metadata:diary_entries:timecreated'] = 'Tijdstip waarop het item is gemaakt.';
$string['privacy:metadata:diary_entries:timemarked'] = 'Tijdstip waarop het item is beoordeeld.';
$string['privacy:metadata:diary_entries:timemodified'] = 'Tijdstip waarop het item laatst is bewerkt.';
$string['privacy:metadata:diary_entries:userid'] = 'ID van de gebruiker.';
$string['prompt'] = 'Maak je schrijfsuggestie';
$string['promptbgc'] = 'Achtergrondkleur voor deze prompt';
$string['promptbgc_help'] = 'Dit stelt de algemene achtergrondkleur in voor deze prompt';
$string['promptid'] = 'Schrijfsuggestie ID';
$string['promptinfo'] = 'Er zijn {$a->past} schrijfsuggesties voorbij, {$a->current} huidige schrijfsuggestie en {$a->future} schrijfsuggesties die nog volgen voor deze dagboekactiviteit.<br>';
$string['promptmaxc'] = 'Max tekens';
$string['promptmaxp'] = 'Max alinea\'s';
$string['promptmaxs'] = 'Max zinnen';
$string['promptmaxw'] = 'Max woorden';
$string['promptminc'] = 'Min tekens';
$string['promptminmaxcp'] = 'Tekens %';
$string['promptminmaxpp'] = 'Alinea %';
$string['promptminmaxsp'] = 'Zin %';
$string['promptminmaxwp'] = 'Woord %';
$string['promptminp'] = 'Min alinea\'s';
$string['promptmins'] = 'Min zinnen';
$string['promptminw'] = 'Min woorden';
$string['promptremovefailure'] = 'Deze schrijfsuggestie, ID {$a} , is in gebruik en kan niet verwijderd worden';
$string['promptremovesuccess'] = 'Je hebt schrijfsuggestie ID {$a} verwijderd.';
$string['promptstart'] = 'Schrijfsuggestie start';
$string['promptstitle'] = 'Dagboek schrijfsuggesties';
$string['promptstop'] = 'Schrijfsuggestie stop';
$string['promptsviewtitle'] = 'Bekijk schrijfsuggesties';
$string['prompttext'] = 'Schrijfsuggestietekst';
$string['promptzerocount'] = '<td>Er zijn nu {$a} schrijfsuggesties voor deze dagboekactiviteit. </td>';
$string['rate'] = 'Beoordeel';
$string['rating'] = 'Beoordelingen voor deze pagina';
$string['reload'] = 'Herlaad en toon van huidige tot oudste dagboekpagina';
$string['removealldiarytags'] = 'Verwijder alle dagboek-tags';
$string['removeentries'] = 'Verwijder alle pagina\'s';
$string['removemessages'] = 'Verwijder alle dagboekpagina\'s';
$string['reportsingle'] = 'Haal alle dagboekpagina\'s voor deze gebruiker op.';
$string['reportsingleallentries'] = 'Alle dagboekpagina\'s voor deze gebruiker.';
$string['returnto'] = 'Keer terug naar {$a}';
$string['returntoreport'] = 'Keer terug naar de rapportpagina voor - {$a}';
$string['saveallfeedback'] = 'Bewaar al mijn feedback';
$string['savesettings'] = 'Bewaar instellingen';
$string['search'] = 'Zoek';
$string['search:activity'] = 'Dagboek - informatie activiteit';
$string['search:entry'] = 'Dagboek - pagina\'s';
$string['search:entrycomment'] = 'Dagboek - opmerking bij pagina';
$string['selectentry'] = 'Selecteer pagina om te beoordelen';
$string['sentences'] = 'Zinnen:';
$string['sentencesperparagraph'] = 'Zinnen per alinea';
$string['shortwords'] = 'Unieke korte woorden';
$string['shortwords_help'] = 'Korte woorden zijn woorden die maar één lettergreep hebben. Merk op dat het algoritme om het aantal lettergrepen te bepalen dit slechts bij benadering kan.';
$string['showlistno'] = 'Verberg geen bijdrages';
$string['showlistpreference'] = 'Toon gebruikers zonder bijdrages';
$string['showlistyes'] = 'Toon geen bijdrages';
$string['shownone'] = 'Niets tonen';
$string['showoverview'] = 'Toon dagboekoverzicht op mijn startpagina';
$string['showrecentactivity'] = 'Toon recente activiteit';
$string['showstudentsonly'] = 'Toon enkel leerlingen';
$string['showteacherandstudents'] = 'Toon leerlingen en leraren';
$string['showteachersonly'] = 'Toon enkel leraren';
$string['showtextstats'] = 'Toon tekststatistieken?';
$string['showtextstats_help'] = 'Als deze optie ingeschakeld is, dan worden er statistieken over de tekst getoond.';
$string['showtostudentsonly'] = 'Ja, toon enkel leerlingen';
$string['showtoteachersandstudents'] = 'Ja, toon leerlingen en leraren';
$string['showtoteachersonly'] = 'Ja, toon enkel leraren';
$string['sortcurrententry'] = 'Van huidige dagboekpagina tot de eerste pagina.';
$string['sortfirstentry'] = 'Van eerste dagboekpagina tot de laatste pagina.';
$string['sorthighestentry'] = 'Van hoogste beoordeelde dagboekpagina tot de laagst beoordeelde pagina.';
$string['sortlastentry'] = 'Van laatst gewijzigde pagina tot de oudste gewijzigde pagina.';
$string['sortlowestentry'] = 'Van de laagst beoordeelde dagboekpagina tot de hoogst beoordeelde pagina.';
$string['sortoptions'] = 'Sorteer-opties:';
$string['sortorder'] = 'Sorteervolgorde is:';
$string['startnewentry'] = 'Start nieuw item';
$string['startoredit'] = 'Start nieuwe pagina of bewerk de pagina van vandaag';
$string['statshdr'] = 'Tekststatistieken';
$string['statshdr_help'] = 'Deze instellingen definiëren de standaardinstellingen in alle nieuwe dagboeken.';
$string['statshide'] = 'Verberg statistieken';
$string['statsshow'] = 'Toon statistieken';
$string['studentemail'] = 'Stuur meldingen via e-mail naar leerlingen';
$string['studentemail_help'] = 'Schakel de mogelijkheid om onmiddellijk e-mailmeldingen naar leerlingen te sturen in of uit.';
$string['tablecolumncharacters'] = 'Tekens';
$string['tablecolumnedit'] = 'Bewerk&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tablecolumnparagraphs'] = 'Alinea\'s';
$string['tablecolumnprompts'] = 'Schrijfsuggesties';
$string['tablecolumnpromptsbgc'] = 'Achtergrondkleur van prompts';
$string['tablecolumnsentences'] = 'Zinnen';
$string['tablecolumnstart'] = 'Start';
$string['tablecolumnstatus'] = 'Status';
$string['tablecolumnstop'] = 'Stop';
$string['tablecolumnwords'] = 'Woorden&nbsp;&nbsp;&nbsp;&nbsp;';
$string['tagarea_diary_entries'] = 'Dagboekitems';
$string['tcount'] = 'Op dit moment horen er {$a} schrijfsuggesties bij deze dagboekactiviteit.<br>';
$string['teacher'] = 'Leraar';
$string['teacheremail'] = 'Stuur meldingen via e-mail naar leraren';
$string['teacheremail_help'] = 'Schakel de mogelijkheid om onmiddellijk e-mails naar leraren te sturen in of uit';
$string['text'] = 'Geef je schrijfsuggestie';
$string['text_editor'] = 'Schrijfsuggestietekst';
$string['textstatitems'] = 'Statistische items';
$string['textstatitems_help'] = 'Selecteer hier de items die je wil laten verschijnen in de tekststatistieken op de bekijk-pagina, de rapportpagina en de rapport enkel-pagina.';
$string['timecreated'] = 'Tijdstip gemaakt';
$string['timemarked'] = 'Tijdstip beoordeeld';
$string['timemodified'] = 'Tijdstip bewerkt';
$string['toolbar'] = 'Gereedschapsbalk:';
$string['totalsyllables'] = 'Totaal aantal lettergrepen {$a}';
$string['transfer'] = 'Items transfereren';
$string['transferwemail'] = 'Transfereer en stuur e-mail. <b>Standaard: stuur geen e-mail</b>';
$string['transferwfb'] = 'Transfereer en geef feedback over de transfer.<b>Standaard: geen feedback geven</b>';
$string['transferwfbmsg'] = '<br>Dit item was getransfereerd van de journal met naam: {$a}';
$string['transferwoe'] = 'Transfer zonder e-mail';
$string['uniquewords'] = 'Unieke woorden';
$string['userid'] = 'GebruikersID';
$string['usertoolbar'] = 'Gereedschapsbalk gebruiker:';
$string['viewalldiaries'] = 'Bekijk alle cursusdagboeken';
$string['viewallentries'] = 'Bekijk {$a} dagboekpagina\'s';
$string['viewentries'] = 'Bekijk pagina\'s';
$string['warning'] = '<b>WAARSCHUWING - ke jebt {$a} schrijfsuggesties en dat is een fout. Je kunt geen overlappende datums hebben. Dit moet hersteld worden!</b>';
$string['words'] = 'Woorden:';
$string['wordspersentence'] = 'Woorden per zin';
$string['writingpromptlable'] = 'Huidige schrijfsuggestie: {$a->counter} (ID: {$a->entryid}) gestart op {$a->starton} en zal eindigen op {$a->endon}.<br>{$a->datatext}';
$string['writingpromptlable2'] = 'Schrijfsuggestie:';
$string['writingpromptlable3'] = 'Bewerk schrijfsuggestie';
$string['writingpromptnotused'] = 'De normale dagboekinstellingen zijn gebruikt voor de instellingen van de automatische beoordeling van dit item.';
$string['writingpromptused'] = 'SchrijfsuggestieID: {$a} is gebruikt voor de instellingen van de automatische beoordeling van dit item.';
$string['xfrresults'] = 'Er zijn {$a->one} items verwerkt en {$a->two} ervan getransfereerd.';
