<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'board', language 'nl', version '4.3'.
 *
 * @package     board
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Cancel'] = 'Annuleer';
$string['Ok'] = 'OK';
$string['acceptedfiletypeforbackground'] = 'Toegestane bestandstypes voor achtergrondafbeeldingen.';
$string['acceptedfiletypeforbackground_desc'] = 'Kies de bestandstypes die ondersteund worden voor achtergrondafbeeldingen .';
$string['acceptedfiletypeforcontent'] = 'Toegestane bestandstypes voor inhoudsafbeeldingen.';
$string['acceptedfiletypeforcontent_desc'] = 'Kies de bestandstypes die ondersteund worden voor inhoudsafbeeldingen.';
$string['addcomment'] = 'Opmerking toevoegen';
$string['addrating'] = 'Berichten beoordelen';
$string['addrating_all'] = 'door iedereen';
$string['addrating_none'] = 'Uitgeschakeld';
$string['addrating_students'] = 'door leerlingen';
$string['addrating_teachers'] = 'door leraren';
$string['allowed_singleuser_modes'] = 'Modussen voor individuele gebruikers inschakelen.';
$string['allowed_singleuser_modes_desc'] = 'Wel/niet toestaan van bepaalde modussen voor individuele gebruikers. Heeft geen invloed op al aangemaakte prikborden.';
$string['allowyoutube'] = 'YouTube toestaan';
$string['allowyoutube_desc'] = 'Indien ingeschakeld wordt de knop om een YouTube video in te bedden ondersteund.';
$string['aria_addmedia'] = '{type} toevoegen voor bericht {post} in kolom {column}';
$string['aria_addmedianew'] = '{type} toevoegen voor nieuw bericht in kolom {column}';
$string['aria_canceledit'] = 'Bericht bewerken annuleren voor bericht {post} in kolom {column}';
$string['aria_cancelnew'] = 'Nieuw bericht annuleren voor kolom {column}';
$string['aria_choosefileedit'] = 'Bestand selecteren voor bericht {post} in kolom {column}';
$string['aria_choosefilenew'] = 'Bestand selecteren voor nieuw bericht';
$string['aria_column_locked'] = 'Kolom {$a} vergrendeld';
$string['aria_column_unlocked'] = 'Kolom {$a} ontgrendeld';
$string['aria_deleteattachment'] = 'Bijlage bij bericht {post} verwijderen uit kolom {column}';
$string['aria_deletecolumn'] = 'Kolom {column} verwijderen';
$string['aria_deletepost'] = 'Bericht {post} verwijderen uit kolom {column}';
$string['aria_editpost'] = 'Bericht {post} bewerken';
$string['aria_movecolumn'] = 'Kolom {column} verplaatsen';
$string['aria_movepost'] = 'Bericht {post} verplaatsen';
$string['aria_newcolumn'] = 'Nieuwe kolom toevoegen';
$string['aria_newpost'] = 'Nieuw bericht toevoegen aan kolom {column}';
$string['aria_postedit'] = 'Bewerking van bericht {post} in kolom {column} bewaren';
$string['aria_postnew'] = 'Nieuw bericht bewaren voor kolom {column}';
$string['aria_ratepost'] = 'Bericht {post} beoordelen voor kolom {column}';
$string['background_color'] = 'Achtergrondkleur';
$string['background_color_help'] = 'Moet een geldige hex kleur zijn, zoals #00cc99';
$string['background_image'] = 'Achtergrondafbeelding';
$string['blanktargetenabled'] = 'Dit Prikbord is zo ingesteld dat alle URLs / weblinks in een nieuw venster of tabblad worden geopend.';
$string['board:addinstance'] = 'Nieuwe activiteit Prikbord toevoegen';
$string['board:deleteallcomments'] = 'Alle opmerkingen bij berichten bekijken en verwijderen';
$string['board:manageboard'] = 'Kolommen en alle berichten beheren.';
$string['board:postcomment'] = 'Opmerkingen bij berichten maken en bekijken';
$string['board:view'] = 'Inhoud van Prikbord bekijken en eigen berichten beheren.';
$string['board_column_locked'] = 'Deze kolom is vergrendeld en kan niet bewerkt worden.';
$string['boardhasnotes'] = 'Er staan al berichten op dit prikbord, het is niet toegestaan de gebruikersmodus te veranderen';
$string['boardsettings'] = 'Prikbordinstellingen';
$string['brickfieldlogo'] = 'Powered by Brickfield logo';
$string['cancel_button_text'] = 'Annuleer';
$string['choose_file'] = 'Kies afbeeldingsbestand';
$string['column_colours'] = 'Kolomkleuren';
$string['column_colours_desc'] = 'De kleuren die gebruikt worden bovenaan iedere kolom. Dit zijn hex kleuren die je een per regel met 3 of 6 tekens toevoegt. Als een waarde hier niet overeenkomt met een kleur, worden de standaardwaardes gebruikt.';
$string['comment'] = 'Opmerking';
$string['comments'] = '{$a} opmerkingen';
$string['completiondetail:notes'] = 'Notities toevoegen: {$a}';
$string['completionnotes'] = 'Vereis van leerlingen dat zij dit aantal notities toevoegen om de activiteit te voltooien';
$string['completionnotesgroup'] = 'Notities vereisen';
$string['default_column_heading'] = 'Kop';
$string['delete'] = 'Verwijderen';
$string['deletecomment'] = 'Opmerking verwijderen';
$string['embed_height'] = 'Hoogte voor inbedden';
$string['embed_height_desc'] = 'Hoogte om te gebruiken voor het iframe wanneer je het prikbord op de cursuspagina inbedt. Dit moet een geldige CSS waarde zijn, bijv. px, rem, %, etc...';
$string['embed_width'] = 'Breedte voor inbedden';
$string['embed_width_desc'] = 'Breedte om te gebruiken voor het iframe wanneer je het prikbord op de cursuspagina inbedt. Dit moet een geldige CSS waarde zijn, bijv. px, rem, %, etc...';
$string['embedboard'] = 'Prikbord inbedden op de cursuspagina';
$string['enableblanktarget'] = 'Lege/Nieuwe pagina inschakelen';
$string['enableblanktarget_help'] = 'Indien ingeschakeld worden alle links in een nieuw tabblad of venster geopend.';
$string['event_add_column'] = 'Kolom toegevoegd';
$string['event_add_column_desc'] = 'De gebruiker met id \'{$a->userid}\' maakte prikbordkolom met id \'{$a->objectid}\' en naam \'{$a->name}\'.';
$string['event_add_comment'] = 'Opmerking toegevoegd';
$string['event_add_comment_desc'] = 'De gebruiker met id \'{$a->userid}\' heeft een opmerking met id \'{$a->objectid}\' inhoud \'{$a->content}\' toegevoegd aan bericht met id \'{$a->noteid}\'.';
$string['event_add_note'] = 'Bericht toegevoegd';
$string['event_add_note_desc'] = 'De gebruiker met \'{$a->userid}\' maakte prikbordbericht met id \'{$a->objectid}\', kop \'{$a->heading}\', inhoud \'{$a->content}\', media \'{$a->media}\' in kolom id \'{$a->columnid}\', groep id \'{$a->groupid}\'.';
$string['event_delete_column'] = 'Kolom verwijderd';
$string['event_delete_column_desc'] = 'De gebruiker met id \'{$a->userid}\' verwijderde kolom met id \'{$a->objectid}\'.';
$string['event_delete_comment'] = 'Opmerking verwijderd';
$string['event_delete_comment_desc'] = 'De gebruiker met id \'{$a->userid}\' heeft de opmerking met id \'{$a->objectid}\' verwijderd van bericht met id \'{$a->noteid}\'.';
$string['event_delete_note'] = 'Bericht verwijderd';
$string['event_delete_note_desc'] = 'De gebruiker met id \'{$a->userid}\' verwijderde prikbordbericht met id \'{$a->objectid}\' uit kolom id \'{$a->columnid}\'.';
$string['event_move_note'] = 'Bericht verplaatst';
$string['event_move_note_desc'] = 'De gebruiker met id \'{$a->userid}\' verplaatste prikbordbericht met id \'{$a->objectid}\' naar kolom id \'{$a->columnid}\'.';
$string['event_rate_note'] = 'Bericht beoordeeld';
$string['event_rate_note_desc'] = 'De gebruiker met id \'{$a->userid}\' beoordeelde prikbordbericht met id \'{$a->objectid}\' met beoordeling \'{$a->rating}\'.';
$string['event_update_column'] = 'Kolom bijgewerkt';
$string['event_update_column_desc'] = 'De gebruiker met id \'{$a->userid}\' werkte prikbordkolom bij met id \'{$a->objectid}\' naar \'{$a->name}\'.';
$string['event_update_note'] = 'Bericht bijgewerkt';
$string['event_update_note_desc'] = 'De gebruiker met id \'{$a->userid}\' werkte prikbordbericht bij met id \'{$a->objectid}\' naar kop \'{$a->heading}\', inhoud \'{$a->content}\', media \'{$a->media}\' voor kolom id \'{$a->columnid}\'.';
$string['export'] = 'Exporteren';
$string['export_backtoboard'] = 'Terug naar Prikbord';
$string['export_board'] = 'Prikbord exporteren';
$string['export_comment'] = 'Opmerking';
$string['export_comments'] = 'Opmerkingen exporteren';
$string['export_comments_description'] = 'Kies welke opmerkingen je wilt exporteren.';
$string['export_comments_include_deleted'] = 'Je kunt ervoor kiezen alle opmerkingen te exporteren inclusief eerder verwijderde opmerkingen.';
$string['export_comments_include_deleted_button'] = 'Opmerkingen exporteren (verwijderde mee opnemen)';
$string['export_content'] = 'Tekst';
$string['export_deleted'] = 'Verwijderd';
$string['export_email'] = 'E-mail';
$string['export_firstname'] = 'Voornaam';
$string['export_heading'] = 'Kop van bericht';
$string['export_info'] = 'Titel van media';
$string['export_lastname'] = 'Achternaam';
$string['export_submissions'] = 'Exporteer inzendingen';
$string['export_timecreated'] = 'Datum aangemaakt';
$string['export_url'] = 'URL van media';
$string['form_body'] = 'Inhoud';
$string['form_image_file'] = 'Afbeeldingsbestand';
$string['form_mediatype'] = 'Media';
$string['form_title'] = 'Titel van bericht';
$string['hideheaders'] = 'Verberg kolomkoppen voor leerlingen';
$string['history'] = 'Prikbord-geschiedenis';
$string['history_refresh'] = 'Timer Prikbord verversen';
$string['history_refresh_desc'] = 'Tijd in seconden voor automatisch verversen van het prikbord. Indien ingesteld op 0 wordt het prikbord alleen ververst bij prikbord-acties (toevoegen/bijwerken/etc.)';
$string['historyinfo'] = 'De geschiedenistabel van Prikbord wordt enkel gebruikt om tijdelijke gegevens te bewaren, die worden gebruikt door Javascript-processen om weergaves van het prikbord te verversen, en die daarna onmiddellijk worden verwijderd.';
$string['include_deleted'] = 'Verwijderde items mee opnemen';
$string['invalid_file_extension'] = 'Bestandsextensie niet geaccepteerd voor uploaden.';
$string['invalid_file_size_max'] = 'Bestand te groot om geaccepteerd te worden.';
$string['invalid_file_size_min'] = 'Bestand te klein om geaccepteerd te worden.';
$string['invalid_youtube_url'] = 'Ongeldige YouTube URL';
$string['media_selection'] = 'Media kiezen';
$string['media_selection_buttons'] = 'Knoppen';
$string['media_selection_desc'] = 'Configureer hoe media kiezen voor berichten wordt weergegeven.';
$string['media_selection_dropdown'] = 'Keuzemenu';
$string['modal_title_edit'] = 'Bericht bewerken voor kolom {column}';
$string['modal_title_new'] = 'Nieuw bericht voor kolom {column}';
$string['modulename'] = 'Prikbord';
$string['modulename_help'] = 'Met deze activiteit voeg je als leraar een prikbord toe aan je cursus.';
$string['modulenameplural'] = 'Prikborden';
$string['move_column_to_aftercolumn'] = 'Kolom verplaatsen na kolom {$a}';
$string['move_column_to_firstplace'] = 'Kolom verplaatsen naar eerste plaats';
$string['move_to_afterpost'] = 'Verplaatsen na bericht {$a}';
$string['move_to_firstitemcolumn'] = 'Verplaatsen naar kolom {$a}';
$string['new_column_icon'] = 'Icoon nieuwe kolom';
$string['new_column_icon_desc'] = 'Icoon weergegeven in knop voor nieuwe kolommen.';
$string['new_note_icon'] = 'Icoon nieuw bericht';
$string['new_note_icon_desc'] = 'Icoon weergegeven in knop voor nieuwe berichten.';
$string['nopermission'] = 'Je hebt geen permissie dit prikbord te bekijken.';
$string['note_changed_text'] = 'Het bericht dat je bewerkte, is gewijzigd.';
$string['note_changed_title'] = 'Bevestigen';
$string['note_deleted_text'] = 'Het bericht dat je bewerkte, is verwijderd.';
$string['nousers'] = 'Er zijn geen aangemelde deelnemers in deze activiteit Prikbord';
$string['opensinnewwindow'] = 'Opent in een nieuw venster';
$string['option_empty'] = 'Geen';
$string['option_image'] = 'Afbeelding';
$string['option_image_info'] = 'Titel van afbeelding';
$string['option_image_url'] = 'URL van afbeelding';
$string['option_link'] = 'Link';
$string['option_link_info'] = 'Titel van link';
$string['option_link_url'] = 'URL van link';
$string['option_youtube'] = 'Video (YouTube)';
$string['option_youtube_info'] = 'Titel van video';
$string['option_youtube_url'] = 'YouTube URL';
$string['pluginadministration'] = 'Prikbord-beheer';
$string['pluginname'] = 'Prikbord';
$string['post_button_text'] = 'Bericht';
$string['post_max_length'] = 'Maximale lengte bericht';
$string['post_max_length_desc'] = 'De maximaal toegestane lengte van inhoud. Alles voorbij deze waarde wordt ingekort.';
$string['postbydate'] = 'Plaatsen tot datum';
$string['postbyenabled'] = 'Beperk berichten van leerlingen tot datum';
$string['posts'] = 'Berichten';
$string['privacy:metadata:board_comments'] = 'Opmerkingen bij ieder bericht op het prikbord.';
$string['privacy:metadata:board_comments:content'] = 'De inhoud van de opmerking bij het bericht';
$string['privacy:metadata:board_comments:noteid'] = 'Het ID van het betreffende bericht';
$string['privacy:metadata:board_comments:timecreated'] = 'Het tijdstip waarop de opmerking bij het bericht werd gemaakt';
$string['privacy:metadata:board_comments:userid'] = 'Het ID van de gebruiker die de opmerking bij het bericht plaatste';
$string['privacy:metadata:board_history'] = 'Tijdelijke prikbord-geschiedenis legt informatie vast gebruikt door Javascript processen om weergaves van het prikbord te verversen en wordt daarna onmiddellijk verwijderd.';
$string['privacy:metadata:board_history:action'] = 'De uitgevoerde actie';
$string['privacy:metadata:board_history:boardid'] = 'Het ID van het prikbord';
$string['privacy:metadata:board_history:content'] = 'De JSON data van de uitgevoerde actie';
$string['privacy:metadata:board_history:timecreated'] = 'Het tijdstip dat de actie werd uitgevoerd';
$string['privacy:metadata:board_history:userid'] = 'Het ID van de gebruiker die de actie uitvoerde';
$string['privacy:metadata:board_note_ratings'] = 'Informatie over de individuele beoordelingen voor ieder prikbordbericht.';
$string['privacy:metadata:board_note_ratings:noteid'] = 'Het ID van het gerelateerde bericht';
$string['privacy:metadata:board_note_ratings:timecreated'] = 'Het tijdstip waarop de beoordeling van het bericht werd aangemaakt';
$string['privacy:metadata:board_note_ratings:userid'] = 'Het ID van de gebruiker die de beoordeling van het bericht aanmaakte';
$string['privacy:metadata:board_notes'] = 'Informatie over de individuele berichten voor ieder prikbord.';
$string['privacy:metadata:board_notes:columnid'] = 'De kolomlocatie van het bericht';
$string['privacy:metadata:board_notes:content'] = 'De inhoud van het bericht';
$string['privacy:metadata:board_notes:heading'] = 'De kop van het bericht';
$string['privacy:metadata:board_notes:info'] = 'De media-informatie van het bericht';
$string['privacy:metadata:board_notes:timecreated'] = 'Het tijdstip waarop het bericht werd aangemaakt';
$string['privacy:metadata:board_notes:url'] = 'De media-URL van het bericht';
$string['privacy:metadata:board_notes:userid'] = 'Het ID van de gebruiker die het bericht aanmaakte';
$string['rate_note_text'] = 'Weet je zeker dat je dit bericht wilt beoordelen?';
$string['rate_note_title'] = 'Bevestigen';
$string['rate_remove_note_text'] = 'Weet je zeker dat je de waardering voor dit bericht wilt verwijderen?';
$string['ratings'] = 'Beoordelingen';
$string['remove_column_text'] = 'Weet je zeker dat je deze kolom "{$a}" en alle berichten daarin wilt verwijderen?';
$string['remove_column_title'] = 'Bevestigen';
$string['remove_note_text'] = 'Weet je zeker dat je dit bericht met alle gegevens erin wilt verwijderen? Dit beïnvloedt eveneens alle andere gebruikers.';
$string['remove_note_title'] = 'Bevestigen';
$string['selectuser'] = 'Selecteer gebruiker';
$string['selectuserplease'] = 'Selecteer een gebruiker';
$string['singleusermode'] = 'Modus individuele gebruiker';
$string['singleusermode_desc'] = 'In de modus voor individuele gebruikers kunnen gebruikers berichten plaatsen op hun eigen prikbord. Bij privaat kunnen gebruikers de prikborden van anderen niet zien, bij publiek zijn prikborden beschikbaar via een keuzemenu.';
$string['singleusermodenone'] = 'Uitgeschakeld';
$string['singleusermodenotembed'] = 'Het is niet toegestaan een Prikbord voor individuele gebruikers in te bedden. Wijzig daarom je instellingen.';
$string['singleusermodeprivate'] = 'Modus individuele gebruiker (privaat)';
$string['singleusermodepublic'] = 'Modus individuele gebruiker (publiek)';
$string['sortby'] = 'Sorteren op';
$string['sortbydate'] = 'Aanmaakdatum';
$string['sortbynone'] = 'Geen';
$string['sortbyrating'] = 'Beoordeling';
$string['userscanedit'] = 'Toestaan dat alle gebruikers de plaatsing van eigen berichten kunnen bewerken.';
$string['viewboard'] = 'Activiteit Prikbord bekijken';
$string['warning'] = 'Melding';
