<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'geogebra', language 'de', version '4.3'.
 *
 * @package     geogebra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityclosed'] = 'Die Aktivität wurde geschlossen';
$string['activitynotopened'] = 'Diese Aktivität ist aktuell nicht verfügbar.';
$string['attempt'] = 'Versuch';
$string['attempts'] = 'Versuche';
$string['attemptsremaining'] = 'Verbleibende Versuche für diese Aktivität';
$string['autograde'] = 'Automatische Bewertung durch GeoGebra-Aktivität';
$string['availabledate'] = 'Verfügbar vom';
$string['average'] = 'Durchschnitt';
$string['choosescripttype'] = 'Wählen Sie den Skripttyp';
$string['codebase'] = 'Speicherort der GeoGebra-Codebase';
$string['codebase_desc'] = 'Speicherort der GeoGebra-Codebase. Nützlich für den Offline-Modus.';
$string['comment'] = 'Kommentar';
$string['configintro'] = 'Die hier eingestellten Werte definieren die Standard-URLs, von denen GeoGebra geladen werden soll.';
$string['contentheader'] = 'Inhalt';
$string['coursewithoutstudents'] = 'Der Kurs enthält keine Teilnehmer/innen.';
$string['datestudent'] = 'Zuletzt geändert (Abgabe)';
$string['dateteacher'] = 'Zuletzt geändert (Bewertung)';
$string['deleteallattempts'] = 'Alle Versuche löschen';
$string['deployggb'] = 'URL zur GeoGebra Bibliothek';
$string['deployggb_desc'] = 'URL für die Distributionsdatei deployggb.js. Die URL sollte normalerweise auf www.geogebratube.org verweisen, kann aber auch eine lokale Datei sein.';
$string['description'] = 'Beschreibung';
$string['discardchanges'] = 'Änderungen verwerfen und zurückkehren';
$string['duedate'] = 'Fälligkeit';
$string['duration'] = 'Dauer';
$string['enableLabelDrags'] = 'Aktivieren Sie das Ziehen von Textfeldern';
$string['enableRightClick'] = 'Rechtsklick aktivieren';
$string['errorattempt'] = 'Fehler: Versuch konnte nicht gespeichert werden.';
$string['event_course_module_viewed'] = 'Kursmodule angezeigt';
$string['event_instances_list_viewed'] = 'Instanzenliste angezeigt';
$string['expired'] = 'Die Aktivität wurde am {$a} geschlossen und steht leider nicht mehr zur Verfügung';
$string['extractedfromggb'] = 'Aus ggb extrahierte Dateien';
$string['fflate'] = 'URL zur fflate Bibliothek';
$string['fflate_desc'] = 'URL für das Fast-Flate-Skript, das zum Dekomprimieren der GeoGebra-Javascript-Dateien verwendet wird.';
$string['filename'] = 'Dateiname';
$string['filenotfound'] = 'Die angegebene Datei existiert nicht.';
$string['filetype'] = 'Dateityp';
$string['filetype_help'] = 'Diese Einstellung legt fest, wie die GeoGebra-Aktivität in den Kurs eingebunden wird. Es gibt bis zu zwei Optionen:

* Hochgeladenes GeoGebra - Ermöglicht die Auswahl eines gültigen ".ggb"-Pakets durch den Datei-Picker.
* Externe URL - Ermöglicht die Angabe einer URL. Hinweis: Die URL muss mit http(s) oder www beginnen und eine gültige ".ggb"-Datei enthalten.';
$string['filetypeexternal'] = 'Externe URL';
$string['filetypelocal'] = 'Hochgeladene Datei';
$string['firstattempt'] = 'Erster Versuch';
$string['for'] = 'für';
$string['functionalityoptionsgrp'] = 'Funktionsweise';
$string['geogebra:addinstance'] = 'Geogebra hinzufügen';
$string['geogebra:grade'] = 'GeoGebra Bewertung';
$string['geogebra:submit'] = 'Geogebra abgeben';
$string['geogebra:view'] = 'Geogebra anzeigen';
$string['geogebrafile'] = 'Geogebra-Datei';
$string['geogebrafile_help'] = 'Die .ggb-Datei';
$string['geogebraurl'] = 'URL';
$string['geogebraurl_help'] = 'Finden Sie die Konstruktion unter <a href="https://www.geogebra.org/" target="_blank">geogebra.org</a>, und gehen Sie zu <strong>Details</strong>, klicken Sie mit der rechten Maustaste auf <strong>Download</strong> and wählen Sie <strong>Linkadresse kopieren</strong>. Gehen Sie schließlich zum URL-Feld und fügen Sie den Link mit <strong>Ctrl+V</strong> ein. <br/> Ein schrittweises Beispiel finden Sie unter: <a href="https://youtu.be/qbp-RuM4NpU" target="_blank">https://youtu.be/qbp-RuM4NpU</a>.';
$string['grade'] = 'Bewertung';
$string['gradeit'] = 'Bewertung';
$string['grademethod'] = 'Bewertungsmethode';
$string['header_geogebra'] = 'GeoGebra Parameter';
$string['height'] = 'Höhe';
$string['height_help'] = 'Wert in Pixel';
$string['highestattempt'] = 'Beste Bewertung';
$string['httpnotallowed'] = 'Externe Dateien dürfen im Moment nicht benutzt werden.';
$string['interfaceoptionsgrp'] = 'Nutzeroberfläche';
$string['invalidgeogebrafile'] = 'Ungültige GeoGebra Datei. Sie muss die Erweiterung ".ggb" haben.';
$string['invalidurl'] = 'Ungültige URL. Sie muss mit http(s) beginnen und eine gültige ".ggb"-Datei sein.';
$string['language'] = 'Sprache';
$string['lastattempt'] = 'Letzter Versuch';
$string['lastattemptremaining'] = 'Dies ist der letzte Versuch für diese Aktivität.';
$string['lastmodifiedgrade'] = 'Zuletzt geändert (Bewertung)';
$string['lastmodifiedsubmission'] = 'Zuletzt geändert (Abgabe)';
$string['lowestattempt'] = 'Schlechteste Bewertung';
$string['manualgrade'] = 'Eigene Bewertung?';
$string['maxattempts'] = 'Maximale Anzahl von Versuchen';
$string['modulename'] = 'GeoGebra';
$string['modulename_help'] = '<p><a href="https://www.geogebra.org" target="_blank">GeoGebra</a> ist eine kostenlose und plattformübergreifende dynamische Mathematiksoftware für alle Bildungsstufen, die Geometrie, Algebra, Tabellen, Diagramme, Statistik und Kalkulation in einem einfach zu bedienenden Paket vereint.</p>
<p>Deshalb hat das <a href="http://www.gencat.cat/ensenyament/" target="_blank">Departament of Education of Cataloni</a> in Zusammenarbeit mit der <a href="https://acgeogebra.cat/" target="_blank">Catalan Association of GeoGebra</a> (ACG) und dem GeoGeobra-Entwicklungsteam dieses Modul implementiert, das die Einbindung von GeoGebra-Aktivitäten in Moodle ermöglicht. Seine Hauptmerkmale sind:
<ul>
    <li>Ermöglicht die einfache Einbettung von GeoGebra-Aktivitäten in einige Moodle-Kurse.</li>
    <li>Erleichtert die Verfolgung von Lernerfolgen, da die Punktezahl, das Datum, die Dauer und die Konstruktion jedes einzelnen Versuchs für eine/n Nutzer/innen gespeichert werden.</li>
    <li>Teilnehmer/in  können den Stand der Aktivitäten speichern, um sie später fortzusetzen.</li>
</ul>
</p>';
$string['modulenameplural'] = 'GeoGebra';
$string['msg_noattempts'] = 'Sie haben diese Aktivität so oft wie möglich durchgeführt';
$string['msg_nosessions'] = 'Diese Geogebra-Aktivität hat noch keine Sitzung';
$string['name'] = 'Name';
$string['noattempts'] = '-';
$string['nograding'] = 'Keine Bewertung';
$string['nomoreattempts'] = 'Keine weiteren Versuche für diese Aktivität verfügbar';
$string['notopenyet'] = 'Diese Aktivität ist nicht verfügbar bis {$a}';
$string['pluginadministration'] = 'GeoGebra Administration';
$string['pluginname'] = 'GeoGebra';
$string['preview_geogebra'] = 'Vorschau der Aktivität Geogebra';
$string['previewtab'] = 'Vorschau';
$string['privacy'] = 'Privatsphäreneinstellungen der Ergebnisse';
$string['privacy:metadata:geogebra_attempts'] = 'Informationen über Versuche von Nutzer/innen für eine bestimmte Geogebra-Aktivität';
$string['privacy:metadata:geogebra_attempts:datestudent'] = 'Der Zeitstempel, der angibt, wann der Versuch von Teilnehmer/innen beendet wurde';
$string['privacy:metadata:geogebra_attempts:dateteacher'] = 'Der Zeitstempel, der angibt, wann der Versuch von Trainer/innen beendet wurde';
$string['privacy:metadata:geogebra_attempts:finished'] = 'Der Zeitstempel, der angibt, wann der Versuch von Nutzer/innen beendet wurde';
$string['privacy:metadata:geogebra_attempts:geogebra'] = 'Die ID der gewählten Aktivität';
$string['privacy:metadata:geogebra_attempts:gradecomment'] = 'Der Kommentar zur Bewertung der Geogebra Aktivität';
$string['privacy:metadata:geogebra_attempts:userid'] = 'Die ID der Person, die diese Geogebra-Aktivität beantwortet';
$string['privacy:metadata:geogebra_attempts:vars'] = 'Die ID der Option, die die Person ausgewählt hat.';
$string['redirecttocourse'] = 'Die Aktivität wurde gespeichert. Zurück zur Startseite des Kurses';
$string['report'] = 'Bericht von';
$string['results'] = 'Ergebnisse';
$string['resultstab'] = 'Ergebnisse';
$string['resumeattempt'] = 'Wiederaufnahme eines unvollendeten Versuchs';
$string['review'] = 'Bewertung von';
$string['reviewtab'] = 'Bewertung';
$string['savechanges'] = 'Änderungen speichern';
$string['savewithoutsubmitting'] = 'Speichern ohne zu senden';
$string['seed'] = 'Seed';
$string['seed_help'] = 'Seed kann eine positive Zahl zwischen 0 und 99 sein. Ist der Wert Null, wird eine mit Hilfe des Zufalls generierte Geogebra-Aktivität bei jedem Neuladen anders sein. Wenn der Wert nicht Null ist, wird beim erneuten Laden dieselbe zufällige Version angezeigt. Die Verwendung von zwei verschiedenen Seeds führt zu zwei verschiedenen Zufallsversionen. Verwenden Sie einen Null-Seed, um jedem Schüler einen anderen Test zu geben. Verwenden Sie einen anderen Seed als Null, um sicherzustellen, dass alle Schüler denselben Test erhalten.';
$string['settings'] = 'Einstellungen';
$string['showAlgebraInput'] = 'Eingabeleiste anzeigen';
$string['showMenuBar'] = 'Menüleiste anzeigen';
$string['showResetIcon'] = 'Symbol zum Zurücksetzen der Konstruktion anzeigen';
$string['showToolBar'] = 'Toolbar anzeigen';
$string['showToolBarHelp'] = 'Toolbar-Hilfe anzeigen';
$string['showsubmit'] = 'Schaltfläche "Speichern" anzeigen';
$string['status'] = 'Status';
$string['submitandfinish'] = 'Senden und abschließen';
$string['timing'] = 'Zeit';
$string['total'] = 'total';
$string['unfinished'] = 'Nicht abgeschlossen';
$string['ungraded'] = 'Unbewertet';
$string['unlimitedattempts'] = 'Unbegrenzte Anzahl von Versuchen für diese Aktivität';
$string['urledit'] = 'Geogebra Datei';
$string['urledit_help'] = 'Die ".ggb"-Datei, in der Sie die GeoGebra-Aktivität finden.';
$string['urlggb'] = 'Benutzerdefinierte URL';
$string['urlggb_help'] = 'Alternative URL für die Datei deployggb.js, d. h. den Ort, an dem sich die GeoGebra-Distribution befindet. Wenn es gesetzt ist, wird diese URL anstelle des in der Modulkonfiguration festgelegten Standardwerts verwendet. Normalerweise kann dieses Feld leer gelassen werden.';
$string['useBrowserForJS'] = 'Verwende Javascript von folgender Ressource:';
$string['useBrowserForJS_geogebra'] = 'Geogebra Datei (falsch)';
$string['useBrowserForJS_html'] = 'HTML (wahr)';
$string['view'] = 'Ansicht';
$string['viewattempt'] = 'Versuch anzeigen';
$string['viewattempts'] = 'Versuche anzeigen';
$string['viewattempttab'] = 'Versuch anzeigen';
$string['viewtab'] = 'Ansicht';
$string['weight'] = 'Gewichtung';
$string['width'] = 'Breite';
$string['width_help'] = 'Wert in Pixel. Ist der Wert leer oder Null, beträgt die Breite der GeoGebra-Aktivität 100 % des GeoGebra-Containers.';
