<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'ar', version '4.3'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'إجابتك ينبغي أن تكون معادلة، ولكنها ليست كذلك.';
$string['ATAlgEquiv_SA_not_expression'] = 'إجابتك ينبغي أن تكون تعبيراً وليس معادلة، متراجحة، قائمة، مجموعة أو مصفوفة.';
$string['ATAlgEquiv_SA_not_function'] = 'إجابتك ينبغي أن تكون دالة، معرفة باستعمال العامل <tt>:=</tt>، ولكنها ليست كذلك.';
$string['ATAlgEquiv_SA_not_inequality'] = 'إجابتك ينبغي أن تكون متراجحة، ولكنها ليست كذلك.';
$string['ATAlgEquiv_SA_not_list'] = 'إجابتك ينبغي أن تكون قائمة، ولكنها ليست كذلك. لاحظ أن صيغة إدخال القائمة تكون عبر إحاطة القيم المفصولة بفوارز بأقواس مربعة.';
$string['ATAlgEquiv_SA_not_logic'] = 'إجابتك ينبغي أن تكون معادلة، متراجحة، أو متراكبة منطقية من أي مما سبق، ولكنها ليست كذلك.';
$string['ATAlgEquiv_SA_not_matrix'] = 'إجابتك ينبغي أن تكون مصفوفة، ولكنها ليست كذلك.';
$string['ATAlgEquiv_SA_not_realset'] = 'إجابتك ينبغي أن تكون مجموعة جزئية من الأرقام الحقيقية. هذه ستكون مجموعة من الأرقام، أو مجموعة من الفترات.';
$string['ATAlgEquiv_SA_not_set'] = 'إجابتك ينبغي أن تكون مجموعة، ولكنها ليست كذلك. لاحظ أن صيغة إدخال المجموعة هي إحاطة القيم المفصولة بفوارز بأقواس متموجة.';
$string['ATAlgEquiv_SA_not_string'] = 'إجابتك ينبغي أن تكون سلسلة محارف، ولكنها ليست كذلك.';
$string['ATAlgEquiv_TA_not_equation'] = 'لقد قمتَ بإدخال معادلة، ولن لا يُتوقع وضع معادلة هنا. ربما أدخلت شيئاً مشابهاً لـ "y=2*x+1" بينما كان عليك إدخال "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'إجابتك ينبغي أن تعتمد على المتغير {$a->m0}، ولكنها ليست كذلك!';
$string['ATCompSquare_false_no_summands'] = 'المربع الكامل هو بالشكل \\( a(\\cdots\\cdots)^2 + b\\) حيث أن \\(a\\) و \\(b\\) لا يعتمدان على متغيرك. أكثر من واحد من نتائج الجمع عندك يبدو معتمداً على المتغير في جوابك.';
$string['ATCompSquare_not_AlgEquiv'] = 'إجابتك تبدو بالشكل الصحيح، ولكنها غير مساوية للإجابة الصحيحة.';
$string['ATDiff_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATDiff_int'] = 'يبدو أنك قمتَ بالتكامل بدلاً من ذلك!';
$string['ATEquivFirst_SA_not_list'] = 'المعامل الأول في فحص الإجابة لـ Equiv ينبغي أن يكون قائمة، ولكن الفحص فشل. لطفاً، تواصل مع معلمك.';
$string['ATEquivFirst_SA_wrong_end'] = 'إجابتك النهائية ليست بالتنسيق الصحيح.';
$string['ATEquivFirst_SA_wrong_start'] = 'السطر الأول في معامل ينبغي أن يكون "{$a->m0}".';
$string['ATEquivFirst_SB_not_list'] = 'المعامل الثاني في فحص الإجابة لـ Equiv ينبغي أن يكون قائمة، ولكن الفحص فشل. لطفاً، تواصل مع معلمك.';
$string['ATEquiv_SA_not_list'] = 'المعامل الأول في فحص الإجابة لـ Equiv ينبغي أن يكون قائمة، ولكن الفحص فشل. لطفاً، تواصل مع معلمك.';
$string['ATEquiv_SB_not_list'] = 'المعامل الثاني في فحص الإجابة لـ Equiv ينبغي أن يكون قائمة، ولكن الفحص فشل. لطفاً، تواصل مع معلمك.';
$string['ATFacForm_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATFacForm_isfactored'] = 'إجابتك محللة، أحسنت صنعاً.';
$string['ATFacForm_notalgequiv'] = 'لاحظ أن إجابتك ليست مكافئة جبرياً للإجابة الصحيحة. قد تكون أخطأت في مكان ما.';
$string['ATFacForm_notfactored'] = 'إجابتك ليست محللة.';
$string['ATInequality_backwards'] = 'متراجحتك يبدو أنها باتجاه عكسي.';
$string['ATInequality_nonstrict'] = 'ينبغي لمتراجحتك أن تكون صارمة، ولكنها ليست كذلك!';
$string['ATInequality_strict'] = 'متراجحتك ينبغي أن لا تكون صارمة!';
$string['ATInt_EqFormalDiff'] = 'المشتقة القياسية لإجابتك تساوي التعبير الذي تمت مطالبتك بإجراء تكامله. مع ذلك، إجابتك تختلف عن الإجابة الصحيحة بشكل كبير، حيث يمكن القول أن الفرق لا يقتصر (مثلاً) على ثابت التكامل فقط. لطفاً، إسأل معلمك عن ذلك.';
$string['ATInt_STACKERROR_OptList'] = 'فشل تنفيذ فحص الإجابة بشكل صحيح: لطفاً، أبلغ معلمك. عندما يكون خيار ATInt هو قائمة، ينبغي أن يتكون من عنصرين بالضبط، ولكنه ليس كذلك.';
$string['ATInt_const'] = 'عليك أن تضيف ثابت التكامل، بخلاف ذلك يبدو جوابك صحيحاً. أحسنت صنعاً.';
$string['ATInt_const_int'] = 'عليك أن تضيف ثابت التكامل. هذا ينبغي أن يكون ثابتاً عشوائياً وليس رقماً.';
$string['ATInt_diff'] = 'يبدو أنك قمتَ بالتفاضل بدلاً من ذلك!';
$string['ATInt_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATInt_generic'] = 'مشتقة إجابتك ينبغي أن تساوي التعبير الذي طُلب منك إجراء التكامل له، والذي كان: {$a->m0} في الواقع، مشتقة إجابتك بالنسبة إلى {$a->m1} هي: {$a->m2} ما يعني أنك ربما أخطأت في مكان ما!';
$string['ATInt_logabs'] = 'المشتقة القياسية لإجابتك تساوي التعبير الذي طُلب منك إجراء التكامل له. مع ذلك، إجابتك تختلف عن الإجابة الصحيحة بشكل كبير، ويمكن القول أن الفرق بينهما لا يقتصر (مثلاً) على ثابت التكامل. قد يتوقع منك معلمك استعمال النتيجة \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\)، بدلاً من \\(\\int\\frac{1}{x} dx = \\log(x)+c\\). لطفاً، إسأل معلمك عن ذلك.';
$string['ATInt_logabs_inconsistent'] = 'يبدو أن هناك تناقضات غريبة بين استعمالاتك لـ \\(\\log(...)\\) and \\(\\log(|...|)\\). لطفاً، إسأل معلمك عن ذلك.';
$string['ATInt_weirdconst'] = 'المشتقة القياسية لإجابتك تساوي التعبير الذي طُلب منك إجراء التكامل له. مع ذلك، لديك ثابت تكامل غريب. لطفاً، إسأل معلمك عن ذلك.';
$string['ATList_wrongentries'] = 'المدخلات التي تحتها خطوط حمراء أدناه هي الخاطئة. {$a->m0}';
$string['ATList_wronglen'] = 'قائمتك ينبغي أن تضم {$a->m0} من العناصر، ولكنها فعلياً تضم {$a->m1}.';
$string['ATLowestTerms_entries'] = 'الحدود الآتية في إجابتك ليست ضمن الحدود الدنيا. {$a->m0}. لطفاً، حاول مجدداً.';
$string['ATLowestTerms_not_rat'] = 'ينبغي عليك إخلاء ما يأتي من مقام الكسر عندك: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'عليك إلغاء الكسور من إجابتك.';
$string['ATMatrix_wrongentries'] = 'المدخلات التي تحتها خطوط حمراء أدناه هي الخاطئة. {$a->m0}';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'في حالة ATNumDecPlacesWrong، خيار الفحص ينبغي أن يكون رقماً صحيحاً موجباً، في الواقع، تم تلقي "{$a->opt}".';
$string['ATNumDecPlaces_Float'] = 'إجابتك ينبغي أن تكون رقماً ذا فارزة عشرية، ولكنه ليس كذلك.';
$string['ATNumDecPlaces_NoDP'] = 'إجابتك ينبغي أن تكون رقماً عشرياً، متضمناً للفاصلة العشرية.';
$string['ATNumDecPlaces_OptNotInt'] = 'في حالة ATNumDecPlaces، خيار الفحص ينبغي أن يكون رقماً صحيحاً موجباً، في الواقع، تم تلقي "{$a->opt}".';
$string['ATNumDecPlaces_Wrong_DPs'] = 'إجابتك تحتوي على العدد الخاطئ من المنازل العشرية.';
$string['ATNumSigFigs_Inaccurate'] = 'دقة إجابتك ليست صحيحة. إما أنك لم تقم بالتقريب بشكل صحيح، أو قمت بتقريب أحد النتائج الوسطية مما أدى إلى مضاعفة هامش الخطأ.';
$string['ATNumSigFigs_NotDecimal'] = 'إجابتك ينبغي أن تكون رقماً عشرياً، ولكنها ليست كذلك!';
$string['ATNumSigFigs_WrongDigits'] = 'إجابتك لا تحتوي على العدد الصحيح من المراتب المؤثرة.';
$string['ATNumSigFigs_WrongSign'] = 'إجابتك فيها علامة جبرية خاطئة.';
$string['ATNumSigFigs_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATNum_OutofRange'] = 'التعبير الرقمي هو خارج المدى المدعوم. لطفاً، تواصل مع معلمك.';
$string['ATNumerical_FAILED'] = 'إجابتك ينبغي أن تكون رقماً ذا فارزة عشرية، أو قائمة أو مجموعة من الأرقام. لكنها ليست كذلك.';
$string['ATNumerical_SA_not_list'] = 'إجابتك ينبغي أن تكون قائمة، ولكنها ليست كذلك. لاحظ أن صيغة إدخال المجموعة هي إحاطة القيم المفصولة بفوارز بأقواس مربعة.';
$string['ATNumerical_SA_not_number'] = 'إجابتك ينبغي أن تكون رقماً ذا فارزة عشرية، ولكنه ليس كذلك.';
$string['ATNumerical_SA_not_set'] = 'إجابتك ينبغي أن تكون مجموعة، ولكنها ليست كذلك. لاحظ أن صيغة إدخال المجموعة هي إحاطة القيم المفصولة بفوارز بأقواس متموجة.';
$string['ATNumerical_STACKERROR_tol'] = 'مجال التسامح الرقمي لـ ATNumerical ينبغي أن يكون رقماً ذا فارزة عشرية، ولكنه ليس كذلك. هذا خطأ داخلي في الفحص. لطفاً، إسأل معلمك عن ذلك.';
$string['ATPartFrac_denom_ret'] = 'إذا تمت كتابة إجابتك بشكل كسر منفرد، عندها سيكون المقام بالشكل {$a->m0}. في الواقع، هو ينبغي أن يكون {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'المتغيرات في إجابتك تختلف عن تلك التي في السؤال. لطفاً، تحقق منها.';
$string['ATPartFrac_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATPartFrac_ret_expression'] = 'إجابتك بشكل كسر واحد هي {$a->m0}';
$string['ATPartFrac_single_fraction'] = 'إجابتك يبدو أنها بشكل كسر منفرد، المفترض أن تكون بشكل كسر جزئي.';
$string['ATSRegExp_SA_not_string'] = 'المعامل الأول لفحص إجابة SRegExp ينبغي أن يكون نصاً. لقد فشل الفحص. لطفاً، تواصل مع معلمك.';
$string['ATSRegExp_SB_not_string'] = 'المعامل الثاني لفحص إجابة SRegExp ينبغي أن يكون نصاً. لقد فشل الفحص. لطفاً، تواصل مع معلمك.';
$string['ATSet_wrongentries'] = 'المدخلات الآتية غير صحيحة، رغم أنها قد تبدو بشكل أبسط من تلك التي أدخلتها بالفعل. {$a->m0}';
$string['ATSet_wrongsz'] = 'مجموعتك ينبغي أن تضم {$a->m0} من العناصر المختلفة، ولكنها في الواقع تضم {$a->m1}.';
$string['ATSets_SA_not_set'] = 'إجابتك ينبغي أن تكون مجموعة، ولكنها ليست كذلك. لاحظ أن صيغة إدخال المجموعة هي إحاطة القيم المفصولة بفوارز بأقواس متموجة.';
$string['ATSets_SB_not_set'] = 'إن فحص إجابة "المجموعات" يتوقع أن يكون معامله الثاني مجموعة. هذا خطأ. لطفاً، تواصل مع معلمك.';
$string['ATSets_duplicates'] = 'يبدو أن مجموعتك تضم مدخلات مكررة!';
$string['ATSets_missingentries'] = 'مجموعتك ينقصها ما يأتي. {$a->m0}';
$string['ATSets_wrongentries'] = 'هذه المدخلات ينبغي أن لا تكون عناصر ضمن مجموعتك. {$a->m0}';
$string['ATSingleFrac_div'] = 'إجابتك تحتوي كسوراً ضمن كسور. عليك بتصفيتها وكتابة الإجابة بشكل كسر منفرد';
$string['ATSingleFrac_error_list'] = 'فحص الإجابة فشل. لطفاً، تواصل مع المشرف على النظام.';
$string['ATSingleFrac_part'] = 'إجابتك عليها أن تكون كسراً منفرداً بالشكل \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'إجابتك ليست مكافئة جبرياً للإجابة الصحيحة. قد تكون أخطأت في مكان ما.';
$string['ATSingleFrac_var'] = 'المتغيرات في إجابتك تختلف عن تلك التي في السؤال. لطفاً، تحقق منها.';
$string['ATSysEquiv_SA_extra_variables'] = 'إجابتك تضم عدداً كبيراً من المتغيرات!';
$string['ATSysEquiv_SA_missing_variables'] = 'إجابتك ينقصها واحد أو أكثر من المتغيرات!';
$string['ATSysEquiv_SA_not_eq_list'] = 'إجابتك ينبغي أن تكون قائمة من المعادلات، ولكنها ليست كذلك!';
$string['ATSysEquiv_SA_not_list'] = 'إجابتك ينبغي أن تكون قائمة، ولكنها ليست كذلك!';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'واحدة أو أكثر من معادلاتك ليست متعددة الحدود!';
$string['ATSysEquiv_SA_system_overdetermined'] = 'المدخلات التي تحتها خطوط حمراء أدناه هي الخاطئة. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'المعادلات في نظامك تبدو صحيحة، ولكنك بحاجة إلى المزيد منها معها.';
$string['ATSysEquiv_SA_wrong_variables'] = 'إجابتك تستعمل المتغيرات الخطأ!';
$string['ATSysEquiv_SB_not_eq_list'] = 'إجابة المعلم ليست قائمة من المعادلات، ولكنها ينبغي أن تكون كذلك.';
$string['ATSysEquiv_SB_not_list'] = 'إجابة المعلم ليست قائمة. لطفاً، تواصل مع معلمك.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'إجابة المعلم ينبغي أن تكون قائمة من المعادلات المتعددة الحدود، ولكنها ليست كذلك. لطفاً، تواصل مع معلمك.';
$string['ATUnits_SA_bad_units'] = 'إجابتك ينبغي أن تكون لها وحدات قياس، وينبغي عليك استعمال الضرب لإرفاق وحدات القياس بالقيم، مثلاً <code>3.2*m/s</code>.';
$string['ATUnits_SA_excess_units'] = 'إجابتك تستعمل وحدات القياس (أو المتغيرات)، ولكنها لا ينبغي أن تكون كذلك.';
$string['ATUnits_SA_no_units'] = 'إجابتك ينبغي أن تكون لها وحدات قياس.';
$string['ATUnits_SA_not_expression'] = 'على إجابتك أن تضم رقماً مع وحدة القياس. لا تستعمل المجموعات، القوائم، المعادلات أو المصفوفات.';
$string['ATUnits_SA_only_units'] = 'على إجابتك أن تضم رقماً مع وحدة القياس. إجابتك تحتوي على وحدة القياس فقط.';
$string['ATUnits_SO_wrong_units'] = 'وحدات القياس المعينة لسماحية الرقم ينبغي أن تطابق وحدات القياس المستعملة في إجابة المعلم. هذا خطأ داخلي في الفحص. لطفاً، إسأل معلمك عن ذلك.';
$string['ATUnits_compatible_units'] = 'وحدات القياس التي استعملتها تختلف عن تلك المستعملة من قبل المعلم، ولكنها متوافقة معها. تم تحويل القيم الرقمية إلى وحدات القياس الأساسية لغرض المقارنة.';
$string['ATUnits_correct_numerical'] = 'لطفاً، تحقق من وحدات القياس عندك بعناية.';
$string['ATUnits_incompatible_units'] = 'وحدات القياس التي استعملتها غير متوافقة مع الوحدات المستعملة من قبل المعلم.';
$string['AT_EmptySA'] = 'تمت محاولة تنفيذ فحص الإجابة مع إجابة فارغة للطالب، ربما هذه مشكلة التحقق لنظام المصادقة المركزي عند تفويض السؤال.';
$string['AT_EmptyTA'] = 'تمت محاولة تنفيذ فحص الإجابة مع إجابة فارغة للطالب، ربما هذه مشكلة التحقق لنظام المصادقة المركزي عند تفويض السؤال.';
$string['AT_InvalidOptions'] = 'حقل الخيار غير صحيح. {$a->errors}';
$string['AT_MissingOptions'] = 'هناك خيار مفقود عند تنفيذ الفحص.';
$string['AT_NOTIMPLEMENTED'] = 'فحص الإجابة هذا لم يتم تطبيقه بعد.';
$string['Bad_assignment'] = 'عند إدراج قيم المتغير، ينبغي أن تقوم بذلك بالطريقة الآتية: {$a->m0}. لطفاً، قم بتعديل ما أدخلته.';
$string['CommaError'] = 'إجابتك تحتوي فوارز ليس جزءاً من قائمة، مجموعة، أو مصفوفة. <ul><li>إذا كنت تقصد إدخال قائمة، لطفاً استعمل <tt>{...}</tt>،</li><li>إذا كنت تقصد إدخال مجموعة، لطفاً استعمل <tt>{...}</tt>.</li></ul>';
$string['Equiv_Illegal_list'] = 'لا يُسمح بالقوائم عند الاستدلال بالتكافؤ.';
$string['Equiv_Illegal_matrix'] = 'لا يُسمح بالمصفوفات عند الاستدلال بالتكافؤ.';
$string['Equiv_Illegal_set'] = 'لا يُسمح بالمجموعات عند الاستدلال بالتكافؤ.';
$string['FacForm_UnPick_intfac'] = 'عليك التخلص من العامل المشترك.';
$string['FacForm_UnPick_morework'] = 'لا زال بإمكانك القيام بالمزيد على الحد {$a->m0}.';
$string['Illegal_groups'] = 'إجابتك تحتوي على مجموعات تقييم "(a,b,c)" وتلك غير مسموح بها هنا.';
$string['Illegal_identifiers_in_units'] = 'الإدخال يحتوي على اسم متغير بينما المتوقع هو أسماء وحدات القياس فقط.';
$string['Illegal_illegal_operation_in_units'] = 'العامل <code>{$a}</code> غير مسموح به في هذا الإدخال.';
$string['Illegal_lists'] = 'إجابتك تحتوي على قوائم "[a,b,c]" وتلك غير مسموح بها هنا.';
$string['Illegal_sets'] = 'إجابتك تحتوي على مجموعات "{a,b,c}" وتلك غير مسموح بها هنا.';
$string['Illegal_singleton_floats'] = 'هذا الإدخال لا يقبل الأرقام العشرية بالشكل المعطى. هذا الإدخال يتطلب قيمة رقمية ممثلة بإحدى الأشكال الآتية: <code>{$a->forms}</code>';
$string['Illegal_singleton_integer'] = 'هذا الإدخال لا يقبل القيم الصحيحة بالشكل المعطى. هذا الإدخال يتطلب قيمة رقمية ممثلة بإحدى الأشكال الآتية: <code>{$a->forms}</code>';
$string['Illegal_singleton_power'] = 'هذا الإدخال يتطلب قيمة رقمية ممثلة بإحدى الأشكال الآتية: <code>{$a->forms}</code>';
$string['Illegal_strings'] = 'إجابتك تحتوي على جُمل "strings" وتلك غير مسموح بها هنا.';
$string['addanothernode'] = 'إضافة عقدة جديدة';
$string['addanothertestcase'] = 'إضافة حالة فحص أخرى...';
$string['addatestcase'] = 'إضافة حالة فحص...';
$string['addingatestcase'] = 'إضافة حالة فحص إلى السؤال {$a}';
$string['alg_indices_fact'] = 'القوانين الآتية تحكم معالجة المؤشرات:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'قوانين المؤشرات';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ means } a \\hbox{ is greater than } b.\\]
\\[ a < b \\hbox{ means } a \\hbox{ is less than } b.\\]
\\[a\\geq b \\hbox{ means } a \\hbox{ is greater than or equal to } b.\\]
\\[a\\leq b \\hbox{ means } a \\hbox{ is less than or equal to } b.\\]';
$string['alg_inequalities_name'] = 'المتراجحات';
$string['alg_logarithms_fact'] = 'لأي أساس \\(c>0\\) فيه \\(c \\neq 1\\):
\\[\\log_c(a) = b \\mbox{, means } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\left(a^n\\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
معادلة التغيير للأساس هي:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
اللوغاريتمات للأساس \\(e\\), denoted \\(\\log_e\\) أو كبديل عنها \\(\\ln\\) تسمى اللوغاريتمات الطبيعية. الحرف \\(e\\) يمثل الثابت الأسي والذي قيمته التقريبية \\(2.718\\).';
$string['alg_logarithms_name'] = 'قوانين اللوغاريتمات';
$string['alg_partial_fractions_fact'] = 'الكسور الصالحة تحدث مع \\[{\\frac{P(x)}{Q(x)}}\\]
عندما \\(P\\) و \\(Q\\) تكونان متعددات حدود من الدرجة \\(P\\) وأقل من درجة \\(Q\\). في تلك الحالة، نتابع كما يأتي: أكتب \\(Q(x)\\) بصيغة التحليل إلى العوامل،
<ul>
<li>
a <em>العامل الخطي</em> \\(ax+b\\) في المقام يولد كسراً جزئياً بالشكل \\[{\\frac{A}{ax+b}}.\\]
</li>
<li>
a <em>العوامل الخطية المكررة</em> \\((ax+b)^2\\) في المقام تولد كسوراً جزئياً بالشكل \\[{A\\over ax+b}+{B\\over (ax+b)^2}.\\]
</li>
<li>
a <em>العامل التربيعي</em> \\(ax^2+bx+c\\)
في المقام يولد كسراً جزئياً بالشكل \\[{Ax+B\\over ax^2+bx+c}\\]
</li>
<li>
<em>Improper fractions}</em> تتطلب حداً إضافياً والذي هو متعددة حدود من الدرجة
\\(n-d\\) حيث أن \\(n\\) يمثل درجة البسط (أي \\(P(x)\\)) أما \\(d\\) فيمثل درجة المقام (أي \\(Q(x)\\)).
</li></ul>';
$string['alg_partial_fractions_name'] = 'الكسور الجزئية';
$string['alg_quadratic_formula_fact'] = 'إذا كانت لدينا معادلة تربية بالشكل:
\\[ax^2 + bx + c = 0,\\]
فإذن حلول تلك المعادلة التي تعطيها لنا المعادلة التربيعية هي:
\\[x = \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a}.\\]';
$string['alg_quadratic_formula_name'] = 'المعادلة التربيعية';
$string['all'] = 'الكل';
$string['allnodefeedbackmustusethesameformat'] = 'كل التغذية الراجعة من كل العقد في PRT ينبغي أن تستعمل نفس تنسيق النص.';
$string['allowwords'] = 'الكلمات المسموح بها';
$string['allowwords_help'] = 'إفتراضياً، لا يُسمح بأسماء المتغيرات أو الدوال العشوائية أن تزيد على حرفين. هذه قائمة مفصولة بفوارز تتضمن أسماء الدوال أو المتغيرات المسموح بها في إجابة الطالب.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'سبق وأن تم نشر متغير مطابق لهذه الملاحظة من السؤال';
$string['ansnotemismatch'] = '[الإجابة غير متطابقة]';
$string['answernote'] = 'الإجابة';
$string['answernote_err'] = 'لا ينبغي أن تتضمن الإجابات الرمز |. هذا الرمز يتم إدراجه من قبل STACK ويُستعمل لاحقاً للفصل ما بين الإجابات تلقائياً.';
$string['answernote_err2'] = 'لا ينبغي أن تتضمن الإجابات رمزَي ; أو : . هذان الرمزان يُستعملان للفصل ما بين جُمل ملخصات المحاولات في أدواة التقارير غير المتصلة بالإنترنت.';
$string['answernote_help'] = 'هذا وسم ذو دور أساسي في التقارير. إنه مصمم لتسجيل المسار الفريد خلال الشجرة، والمخرجات لكل فحص من الإجابات. يتم توليده تلقائياً، ولكن يمكن تحويله إلى صيغة مفهومة.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answernoterequired'] = 'الإجابة ينبغي أن لا تكون فارغة.';
$string['answernoteunique'] = 'تم الكشف عن إجابة مكررة ضمن شجرة الاستجابة المحتملة هذه.';
$string['answertest'] = 'فحص الإجابة';
$string['answertest_help'] = 'فحص الإجابة يُستعمل للمقارنة ما بين تعبيرين لتقرير ما إذا كانا يلبيان بعض المعايير الرياضية.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'إفترضه موجباً';
$string['assumepositive_help'] = 'هذا الخيار يضع قيمة للمتغير assume_pos العائد إلى Maxima.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'إفترضه حقيقياً';
$string['assumereal_help'] = 'هذا الخيار يضع قيمة للمتغير assume_real.';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify_help'] = 'يضبط المتغير "simp" ضمن Maxima لهذا السؤال. على سبيل المثال، متغيرات السؤال، نص السؤال، إلخ. القيمة الموضوعة في أي شجرة استجابة محتملة ستتجاوز هذه القيمة لأي تعابير يتم تعريفها لاحقاً ضمن الشجرة.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt_help'] = 'يضبط المتغير "simp" ضمن Maxima لمتغيرات الإفادة المُعرَّفة في شجرة الاستجابة المحتملة هذه. لاحظ أن احتمالية تبسيط التعابير في ملاحظات PRT قبل الاستعمال يعتمد على فحص الإجابة. على سبيل المثال، العوامل الموجهة إلى AlgEquiv تكون مبسطة، بينما تلك الموجهة إلى EqualComAss ليست كذلك.';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['basicquestionreport'] = 'تقرير استعمال الأسئلة الأساسي';
$string['basicquestionreport_help'] = 'يقوم بتوليد تقرير أساسي للمحاولات في هذا السؤال في المخدم. مفيد لاتخاذ القرار بشأن أي من فحوص PRT يمكن إضافتها لتحسين الإفادة على ضوء ما قام به الطالب فعلياً. (معظم الأسئلة تستعمل فقط في موضع واحد).';
$string['basicreportinputsummary'] = 'إدخالات خام، بغض النظر عن التباين المستعمل.';
$string['basicreportnotes'] = 'تردد ملاحظات الإجابة لكل PRT، بغض النظر عن التباين المستعمل.';
$string['basicreportnotessplit'] = 'تردد ملاحظات الإجابة لكل PRT، مفصولاً بـ |، بغض النظر عن التباين المستعمل.';
$string['basicreportraw'] = 'بيانات خام';
$string['basicreportvariants'] = 'المدخلات الخام وملاحظات إجابة PRT حسب التباين.';
$string['booleangotunrecognisedvalue'] = 'إدخال خاطئ.';
$string['boxsize'] = 'حجم مربع الإدخال';
$string['boxsize_help'] = 'عرض حقل نموذج html.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['branchfeedback'] = 'التغذية الراجعة لفرع العقدة';
$string['branchfeedback_help'] = 'هذا هو نص نظام المصادقة المركزي والذي قد يعتمد على أي من متغيرات السؤال، عناصر الإدخال، أو متغيرات الإفادة. يتم تقييمه وعرضه للطالب إذا اجتاز هذا الفرع بنجاح.';
$string['bulktestcontinuefromhere'] = 'قم بالتشغيل مرة أخرى أو الاستئناف، بادئاً من هنا';
$string['bulktestindexintro'] = 'النقر على الرابط سيؤدي إلى تشغيل كل فحوص السؤال لكل أسئلة STACK في ذلك السياق';
$string['bulktestindexintro_desc'] = 'إن <a href="{$a->link}">تشغيل فحوص السؤال بالجملة</a> يسمح لك بسهولة أن تشغل كل أسئلة STACK ضمن سياق معين. هذا ليس وسيلة لفحص الأسئلة فحسب، بل هو أيضاً طريقة جيدة لإعادة تعبئة خبء نظام المصادقة المركزي بعد إخلائه.';
$string['bulktestindextitle'] = 'تشغيل فحوص السؤال بالجملة';
$string['bulktestnodeployedseeds'] = 'هذا السؤال يمتلك متغيرات عشوائية، ولكنه لا يمتلك أصول منشورة.';
$string['bulktestnogeneralfeedback'] = 'لا يمتلك هذا السؤال أي إفادة عامة.';
$string['bulktestnotests'] = 'لا يمتلك هذا السؤال أي فحوص.';
$string['bulktestrun'] = 'تشغيل كل فحوص الأسئلة لكل ما موجود منها في النظام (بطيء، المشرف فقط)';
$string['bulktesttitle'] = 'تشغيل كل فحوص السؤال في {$a}';
$string['cachedef_parsercache'] = 'قام STACK بتحليل تعابير Maxima';
$string['calc_chain_rule_fact'] = 'القاعدة الآتية تسمح بإيجاد المشتقة لتعبير مركب من دالتين.
إفترض أن لدينا الدالة \\(f(g(x))\\)، ثم هناك التعريف \\(u=g(x)\\)، المشتقة بالنسبة إلى \\(x\\) ستكون بالشكل:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
كبديل عن ذلك، يمكننا كتابتها:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_chain_rule_name'] = 'قاعدة السلسلة';
$string['calc_diff_linearity_rule_fact'] = '\\[{{\\rm d}\\,\\over {\\rm d}x}\\big(af(x)+bg(x)\\big)=a{{\\rm d}f(x)\\over {\\rm d}x}+b{{\\rm d}g(x)\\over {\\rm d}x}\\quad a,b {\\rm\\  constant.}\\]';
$string['calc_diff_linearity_rule_name'] = 'القاعدة الخطية للتفاضل';
$string['calc_diff_standard_derivatives_fact'] = 'الجدول الآتي يعرض مشتقات بعض الدوال القياسية. من المفيد معرفة تلك المشتقات القياسية نظراً لاستعمالها المتكرر في الحساب.
<center>
<table>
<tr><th>\\(f(x)\\)               </th><th> \\(f\'(x)\\)</th></tr>
<tr>
<td>\\(k\\)، ثابت           </td> <td> \\(0\\) </td> </tr> <tr> <td>
\\(x^n\\)، أي ثابت \\(n\\) </td> <td> \\(nx^{n-1}\\)</td> </tr> <tr> <td>
\\(e^x\\)                   </td> <td> \\(e^x\\)</td> </tr> <tr> <td>
\\(\\ln(x)=\\log_{\\rm e}(x)\\)              </td> <td> \\(\\frac{1}{x}\\)                </td> </tr> <tr> <td>
\\(\\sin(x)\\)                             </td> <td> \\(\\cos(x)\\)                    </td> </tr> <tr> <td>
\\(\\cos(x)\\)                             </td> <td> \\(-\\sin(x)\\)                   </td> </tr> <tr> <td>
\\(\\tan(x) = \\frac{\\sin(x)}{\\cos(x)}\\)   </td> <td>   \\(\\sec^2(x)\\)                </td> </tr> <tr> <td>
\\(cosec(x)=\\frac{1}{\\sin(x)}\\)         </td> <td>   \\(-cosec(x)\\cot(x)\\)        </td> </tr> <tr> <td>
\\(\\sec(x)=\\frac{1}{\\cos(x)}\\)           </td> <td>   \\(\\sec(x)\\tan(x)\\)           </td> </tr> <tr> <td>
\\(\\cot(x)=\\frac{\\cos(x)}{\\sin(x)}\\)     </td> <td>   \\(-cosec^2(x)\\)             </td> </tr> <tr> <td>
\\(\\cosh(x)\\)                            </td> <td>   \\(\\sinh(x)\\)                 </td> </tr> <tr> <td>
\\(\\sinh(x)\\)                            </td> <td>   \\(\\cosh(x)\\)                 </td> </tr> <tr> <td>
\\(\\tanh(x)\\)                            </td> <td>   \\(sech^2(x)\\)               </td> </tr> <tr> <td>
\\(sech(x)\\)                            </td> <td>   \\(-sech(x)\\tanh(x)\\)        </td> </tr> <tr> <td>
\\(cosech(x)\\)                          </td> <td>   \\(-cosech(x)\\coth(x)\\)      </td> </tr> <tr> <td>
\\(coth(x)\\)                            </td> <td>   \\(-cosech^2(x)\\)            </td> </tr>
</table>
</center>

 \\[ \\frac{d}{dx}\\left(\\sin^{-1}(x)\\right) =  \\frac{1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\cos^{-1}(x)\\right) =  \\frac{-1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\tan^{-1}(x)\\right) =  \\frac{1}{1+x^2}\\]
 \\[ \\frac{d}{dx}\\left(\\cosh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2-1}}\\]
 \\[ \\frac{d}{dx}\\left(\\sinh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2+1}}\\]
 \\[ \\frac{d}{dx}\\left(\\tanh^{-1}(x)\\right) =  \\frac{1}{1-x^2}\\]';
$string['calc_diff_standard_derivatives_name'] = 'المشتقات القياسية';
$string['calc_int_linearity_rule_fact'] = '\\[\\int \\left(af(x)+bg(x)\\right){\\rm d}x = a\\int\\!\\!f(x)\\,{\\rm d}x
\\,+\\,b\\int \\!\\!g(x)\\,{\\rm d}x, \\quad (a,b \\, \\, {\\rm constant.})
\\]';
$string['calc_int_linearity_rule_name'] = 'قاعدة الخطية للتكامل';
$string['calc_int_methods_parts_fact'] = '\\[
\\int_a^b u{{\\rm d}v\\over {\\rm d}x}{\\rm d}x=\\left[uv\\right]_a^b-
\\int_a^b{{\\rm d}u\\over {\\rm d}x}v\\,{\\rm d}x\\]
or alternatively: \\[\\int_a^bf(x)g(x)\\,{\\rm d}x=\\left[f(x)\\,\\int
g(x){\\rm d}x\\right]_a^b -\\int_a^b{{\\rm d}f\\over {\\rm
d}x}\\left\\{\\int g(x){\\rm d}x\\right\\}{\\rm d}x.\\]';
$string['calc_int_methods_parts_name'] = 'التكامل حسب الأجزاء';
$string['calc_int_methods_substitution_fact'] = '\\[
\\int f(u){{\\rm d}u\\over {\\rm d}x}{\\rm d}x=\\int f(u){\\rm d}u
\\quad\\hbox{and}\\quad \\int_a^bf(u){{\\rm d}u\\over {\\rm d}x}\\,{\\rm
d}x = \\int_{u(a)}^{u(b)}f(u){\\rm d}u.
\\]';
$string['calc_int_methods_substitution_name'] = 'التكامل بالتعويض';
$string['calc_int_standard_integrals_fact'] = '\\[\\int k\\ dx = kx +c, \\mbox{ where k is constant.}\\]
\\[\\int x^n\\ dx  = \\frac{x^{n+1}}{n+1}+c, \\quad (n\\ne -1)\\]
\\[\\int x^{-1}\\ dx = \\int {\\frac{1}{x}}\\ dx = \\ln(|x|)+c = \\ln(k*|x|) = \\left\\{\\matrix{\\ln(x)+c & x>0\\cr
\\ln(-x)+c & x<0\\cr}\\right.\\]

<center>
<table>
<tr><th>\\(f(x)\\)</th><th> \\(\\int f(x)\\ dx\\)</th></tr>
<tr><td>\\(e^x\\) </td> <td>  \\(e^x+c\\)</td> <td> </td> </tr>
<tr><td>\\(\\cos(x)\\) </td> <td>  \\(\\sin(x)+c\\)   </td> <td> </td> </tr>
<tr><td>\\(\\sin(x)\\) </td> <td>  \\(-\\cos(x)+c\\)  </td> <td> </td> </tr>
<tr><td>\\(\\tan(x)\\) </td> <td>  \\(\\ln(\\sec(x))+c\\) </td> <td>\\(-\\frac{\\pi}{2} < x < \\frac{\\pi}{2}\\)</td> </tr>
<tr><td>\\(\\sec x\\)  </td> <td>  \\(\\ln (\\sec(x)+\\tan(x))+c\\) </td> <td> \\( -{\\pi\\over 2}< x < {\\pi\\over 2}\\)</td> </tr>
<tr><td>cosec\\(\\, x\\) </td> <td>  \\(\\ln ($cosec$(x)-\\cot(x))+c\\) </td> <td>\\(0 < x < \\pi\\)</td> </tr>
<tr><td>cot\\(\\,x\\) </td> <td>  \\(\\ln(\\sin(x))+c\\) </td> <td>  \\(0< x< \\pi\\) </td> </tr>
<tr><td>\\(\\cosh(x)\\) </td> <td>  \\(\\sinh(x)+c\\)</td> <td></td> </tr>
<tr><td>\\(\\sinh(x)\\) </td> <td>  \\(\\cosh(x) + c\\) </td> <td> </td> </tr>
<tr><td>\\(\\tanh(x)\\) </td> <td>  \\(\\ln(\\cosh(x))+c\\)</td> <td> </td> </tr>
<tr><td>coth\\((x)\\) </td> <td>  \\(\\ln(\\sinh(x))+c \\)</td> <td>   \\(x>0\\)</td> </tr>
<tr><td>\\({1\\over x^2+a^2}\\) </td> <td>  \\({1\\over a}\\tan^{-1}{x\\over a}+c\\)</td> <td> \\(a>0\\)</td> </tr>
<tr><td>\\({1\\over x^2-a^2}\\) </td> <td>  \\({1\\over 2a}\\ln{x-a\\over x+a}+c\\) </td> <td>  \\(|x|>a>0\\)</td> </tr>
<tr><td>\\({1\\over a^2-x^2}\\) </td> <td>  \\({1\\over 2a}\\ln{a+x\\over a-x}+c\\) </td> <td>   \\(|x|<a\\)</td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+a^2}}\\) </td> <td>  \\(\\sinh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td> \\(a>0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2-a^2}}\\) </td> <td>  \\(\\cosh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td>  \\(x\\geq a > 0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+k}}\\) </td> <td>  \\(\\ln (x+\\sqrt{x^2+k})+c\\)</td> <td> </td> </tr>
<tr><td>\\({1\\over \\sqrt{a^2-x^2}}\\) </td> <td>  \\(\\sin^{-1}\\left(\\frac{x}{a}\\right)+c\\)</td> <td>  \\(-a\\leq x\\leq a\\)  </td> </tr>
</table></center>';
$string['calc_int_standard_integrals_name'] = 'التكاملات القياسية';
$string['calc_product_rule_fact'] = 'القاعدة الآتية تسمح بمفاضلة الدوال المضروبة مع بعضها البعض.
إفترض أننا نريد مفاضلة \\(f(x)g(x)\\) بالنسبة إلى \\(x\\).
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] أو، باستعمال الترميز البديل، \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]';
$string['calc_product_rule_name'] = 'قاعدة ناتج الضرب';
$string['calc_quotient_rule_fact'] = 'قاعة حاصل القسمة للمفاضل تنص على أنه لأي دالتين قابلتين للمفاضلة \\(f(x)\\) و \\(g(x)\\),
 \\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]';
$string['calc_quotient_rule_name'] = 'قاعدة حاصل القسمة';
$string['calc_rules_fact'] = '<b>قاعدة ناتج الضرب</b><br />القاعدة الآتية تسمح بإيجاد بمفاضلة الدوال المضروبة بعضها مع بعض.
إفترض أننا نريد مفاضلة \\(f(x)g(x)\\) بالنسبة إلى \\(x\\).
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] or, using alternative notation, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]
<b>قاعدة حاصل القسمة</b><br />قاعدة حاصل القسمة للمفاضلة تنص على أنه لأي دالتين قابلتين للمفاضلة \\(f(x)\\) و \\(g(x)\\),
\\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]
<b>قاعدة السلسلة</b><br />القاعدة الآتية تسمح بإيجاد المشتقة لتعبير مركب من دالتين.
إفترض أن لدينا الدالة \\(f(g(x))\\)، ثم هناك التعريف \\(u=g(x)\\)، المشتقة بالنسبة إلى \\(x\\) ستكون بالشكل:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
كبديل عن ذلك، يمكننا كتابتها:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_rules_name'] = 'قواعد الحساب';
$string['casdisplay'] = 'عرض نظام المصادقة المركزي';
$string['casvalid'] = 'V2';
$string['chat'] = 'أرسل إلى نظام المصادقة المركزي';
$string['chat_desc'] = 'إن <a href="{$a->link}">نص الاتصال البرمجي لنظام المصادقة المركزي</a> يسمح لك بفحص الاتصال مع النظام ومحاولة صيغة Maxima.';
$string['chatintro'] = 'هذه الصفحة تسمح بتقييم نص نظام المصادقة المركزي بشكل مباشر. إنه نص برمجي بسيط يمثل نموذجاً بأصغر شكل ممكن، وطريقة عملية لفحص ما إذا كان نظام المصادقة المركزي يؤدي عمله، وكذلك لفحص إدخالات متنوعة. يسمح مربع النص الأول بتعريف المتغيرات، الثاني هو لوضع نص نظام المصادقة المركزي بحد ذاته.';
$string['chattitle'] = 'فحص الاتصال مع نظام المصادقة المركزي';
$string['checkanswertype'] = 'تحقق من نوع الاستجابة';
$string['checkanswertype_help'] = 'إن كان نعم، سيتم رفض الإجابات التي من "نوع" (مثل التعابير، المعادلات، المصفوفات، القوائم، المجموعات) مختلف واعتبارها غير صحيحة.';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearedthecache'] = 'تم إخلاء مخبوء نظام المصادقة المركزي.';
$string['clearingcachefiles'] = 'يتم إخلاء ملفات رسومات STACK المخبأة {$a->done}/{$a->total}';
$string['clearingthecache'] = 'إخلاء الخبء';
$string['clearthecache'] = 'إخلاء الخبء';
$string['completetestcase'] = 'إملأ ما تبقى من النموذج للخروج بحالة فحص ناجحة';
$string['complexno'] = 'معنى وطريقة عرض الدالة sqrt(-1)';
$string['complexno_help'] = 'يتحكم بمعنى وطريقة عرض الرمز i والدالة sqrt(-1)';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'إنشاء حالة الفحص';
$string['currentlyselectedvariant'] = 'هذا هو التباين المعروض أدناه';
$string['ddl_badanswer'] = 'إن حقل إجابة النموذج لهذا الإدخال بتنسيق خاطئ: <code>{$a}</code>.';
$string['ddl_duplicates'] = 'تم العثور على قيم مكررة عند توليد خيارات الإدخال.';
$string['ddl_empty'] = 'لم يتم تقديم خيارات لهذه القائمة المنسدلة.';
$string['ddl_nocorrectanswersupplied'] = 'لم يحدد المعلم إجابة واحدة صحيحة على الأقل.';
$string['ddl_runtime'] = 'أدى الإدخال إلى توليد خطأ التشغيل الآتي والذي يمنعك من الإجابة. لطفاً تواصل مع معلمك.';
$string['ddl_unknown'] = 'لقد تلقى STACK <code>{$a}</code> ولكن لم يتم إدراج ذلك من قبل المعلم بمثابة خيار.';
$string['debuginfo'] = 'معلومات تصحيح الأخطاء';
$string['defaultmarkzeroifnoprts'] = 'الدرجة الافتراضية ينبغي أن تكون 0 إذا لم يكن لهذا السؤال أي من PRT.';
$string['defaultprtcorrectfeedback'] = 'إجابة صحيحة، أداؤك حسن.';
$string['defaultprtincorrectfeedback'] = 'إجابة غير صحيحة';
$string['defaultprtpartiallycorrectfeedback'] = 'إجابتك صحيحة جزئياً.';
$string['deletetestcase'] = 'حذف حالة الفحص {$a->no} للسؤال {$a->question}';
$string['deletetestcaseareyousure'] = 'هل أنت متأكد من رغبتك في حذف حالة الفحص {$a->no} للسؤال {$a->question}؟';
$string['deletethistestcase'] = 'حذف حالة الفحص هذه...';
$string['deploy'] = 'نشر';
$string['deployedprogress'] = 'نشر المتغيرات';
$string['deployedvariants'] = 'المتغيرات المنشورة';
$string['deployedvariantsn'] = 'المتغيرات المنشورة ({$a})';
$string['deploymanyerror'] = 'خطأ في إدخال المستخدم: لا يمكن نشر متغيرات "{$a->err}".';
$string['deploymanynonew'] = 'تم توليد العديد من ملاحظات السؤال المكررة والموجودة سابقاً.';
$string['deploymanysuccess'] = 'تم إنشاء عدد من المتغيرات الجديدة وفحصها ونشرها بنجاح: {$a->no}.';
$string['deploytestall'] = 'تشغيل كل الفحصول على كل المتغيرات المنشورة (بطيء):';
$string['deploytoomanyerror'] = 'سيحاول STACK نشر ما يصل إلى 100 متغير جديد لأي طلب واحد. لا يتم نشر المزيد من المتغيرات.';
$string['displaymismatch'] = '[عدم تطابق LaTeX]';
$string['dropdowngotunrecognisedvalue'] = 'إدخال خاطئ.';
$string['editingtestcase'] = 'تحرير حالة الفحص {$a->no} للسؤال {$a->question}';
$string['editthistestcase'] = 'تحرير حالة الفحص هذه...';
$string['equiv_AND'] = 'و';
$string['equiv_ANDOR'] = 'إلتباس ما بين و/أو !';
$string['equiv_MISSINGVAR'] = 'ينقصه علامة المساواة';
$string['equiv_SAMEROOTS'] = '(نفس الجذور)';
$string['equivfirstline'] = 'لقد استعملتَ السطر الأول الخطأ في معاملك!';
$string['equivnocomments'] = 'ليس مسموح لك باستعمال التعليقات في هذا النوع من الإدخالات. رجاءً، أقتصر على العمل مع كل سطر على حدة.';
$string['errors'] = 'الأخطاء';
$string['exceptionmessage'] = '{$a}';
$string['expectedpenalty'] = 'الغرامة المتوقعة';
$string['expectedscore'] = 'الدرجة المتوقعة';
$string['exportthisquestion'] = 'تصدير هذا السؤال';
$string['exportthisquestion_help'] = 'هذا سينشئ ملف تصدير بصيغة مودل XML يحتوي على هذا السؤال فقط. مثال على الفائدة المتوخاة من ذلك، هو عند اعتقادك بأن هذا السؤال يمثل خطأ برمجياً في STACK وتريد التبليغ عنه إلى المطورين.';
$string['false'] = 'خطأ';
$string['falsebranch'] = 'فرع خاطئ';
$string['feedbackfromprtx'] = '[ الإفادة من {$a}. ]';
$string['feedbackstyle'] = 'نمط إفادة PRT';
$string['feedbackstyle0'] = 'مركب';
$string['feedbackstyle1'] = 'قياسي';
$string['feedbackstyle2'] = 'موجز';
$string['feedbackstyle3'] = 'رمزي فقط';
$string['feedbackstyle_help'] = 'يتحكم بكيفية عرض إفادة PRT.';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'متغيرات الإفادة';
$string['feedbackvariables_help'] = 'تسمح لك متغيرات الإفادة بالتحكم بأي من الإدخالات، فضلاً عن متغيرات السؤال، قبل عبور الشجرة. المتغيرات المُعرَّفة هنا يمكن استعمالها في أي موضع آخر من هذه الشجرة.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} لا ينبغي أن يضم أي من العناصر النائبة [[{$a->type}:...]]';
$string['firstnodemusthavelowestnumber'] = 'العقدة الأولى ينبغي أن تمتلك الرقم الأصغر.';
$string['forbidfloat'] = 'منع الفاصلة العائمة';
$string['forbidfloat_help'] = 'عند ضبطه على نعم، ستكون أي إجابة يقدمها الطالب محتوية على الفاصلة العشرية العائمة مرفوضة باعتبارها غير صحيحة.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'الكلمات الممنوعة';
$string['forbidwords_help'] = 'هذه قائمة مفصولة بفوارز من الجُمل النصية التي يُمنع استعمالها في إجابة الطالب.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'الإفادة العامة';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_fact'] = '<center>
<table>
<tr><td>
 Upper case, \\(\\quad\\) </td><td>  lower case, \\(\\quad\\) </td><td>  name </td> </tr>   <tr> <td>
 \\(A\\)  </td><td>  \\(\\alpha\\)  </td><td>  alpha  </td> </tr>   <tr> <td>
 \\(B\\)  </td><td>  \\(\\beta\\)  </td><td>  beta </td> </tr>   <tr> <td>
 \\(\\Gamma\\)  </td><td>  \\(\\gamma\\)  </td><td>  gamma </td> </tr>   <tr> <td>
 \\(\\Delta\\)  </td><td>  \\(\\delta\\)  </td><td>  delta </td> </tr>   <tr> <td>
 \\(E\\)  </td><td>  \\(\\epsilon\\)  </td><td>  epsilon </td> </tr>   <tr> <td>
 \\(Z\\)  </td><td>  \\(\\zeta\\)  </td><td>  zeta </td> </tr>   <tr> <td>
 \\(H\\)  </td><td>  \\(\\eta\\)  </td><td>  eta </td> </tr>   <tr> <td>
 \\(\\Theta\\)  </td><td>  \\(\\theta\\)  </td><td>  theta </td> </tr>   <tr> <td>
 \\(K\\)  </td><td>  \\(\\kappa\\)  </td><td>  kappa </td> </tr>   <tr> <td>
 \\(M\\)  </td><td>  \\(\\mu\\)  </td><td>  mu </td> </tr>   <tr> <td>
 \\(N\\)  </td><td>  \\( u\\)  </td><td>  nu </td> </tr>   <tr> <td>
 \\(\\Xi\\)  </td><td>  \\(\\xi\\)  </td><td>  xi </td> </tr>   <tr> <td>
 \\(O\\)  </td><td>  \\(o\\)  </td><td>  omicron </td> </tr>   <tr> <td>
 \\(\\Pi\\)  </td><td>  \\(\\pi\\)  </td><td>  pi </td> </tr>   <tr> <td>
 \\(I\\)  </td><td>  \\(\\iota\\)  </td><td>  iota </td> </tr>   <tr> <td>
 \\(P\\)  </td><td>  \\(\\rho\\) </td><td>  rho </td> </tr>   <tr> <td>
 \\(\\Sigma\\)  </td><td>  \\(\\sigma\\)  </td><td>  sigma </td> </tr>   <tr> <td>
 \\(\\Lambda\\)  </td><td>  \\(\\lambda\\)  </td><td>  lambda </td> </tr>   <tr> <td>
 \\(T\\)  </td><td>  \\(\\tau\\)  </td><td>  tau </td> </tr>   <tr> <td>
 \\(\\Upsilon\\)  </td><td>  \\(\\upsilon\\)  </td><td>  upsilon </td> </tr>   <tr> <td>
 \\(\\Phi\\)  </td><td>  \\(\\phi\\)  </td><td>  phi </td> </tr>   <tr> <td>
 \\(X\\)  </td><td>  \\(\\chi\\)  </td><td>  chi </td> </tr>   <tr> <td>
 \\(\\Psi\\)  </td><td>  \\(\\psi\\)  </td><td> psi </td> </tr>   <tr> <td>
 \\(\\Omega\\)  </td><td>  \\(\\omega\\)  </td><td>  omega </td></tr>
</table></center>';
$string['greek_alphabet_name'] = 'الأبجدية اليونانية';
$string['healthautomaxopt'] = 'إنشاء صورة Maxima محسنة تلقائياً';
$string['healthautomaxopt_failed'] = 'فشل إنشاء صورة Maxima المحسنة: [{$a->errmsg}]';
$string['healthautomaxopt_nolisp'] = 'تعذر تحديد إصدار LISP، لذلك لم يتم إنشاء صورة Maxima تلقائياً.';
$string['healthautomaxopt_nolisprun'] = 'تعذر تحديد موضع الملف lisp.run تلقائياً. حاول إدخال "sudo updatedb" من سطر الأوامر مع الإشارة إلى مستندات التحسين.';
$string['healthautomaxopt_notok'] = 'لم يتم إنشاء صورة Maxima تلقائياً.';
$string['healthautomaxopt_ok'] = 'تم إنشاء صورة Maxima عند: <tt>{$a->command}</tt>';
$string['healthautomaxopt_succeeded'] = 'نجح إنشاء صورة Maxima المحسنة';
$string['healthautomaxoptintro'] = 'لأفضل أداء، علينا تحسين Maxima في نظام لينكس. أنظر <a href="doc/doc.php/CAS/Optimising_Maxima.md">التوثيقات</a> لهذه المشكلة.';
$string['healthcheck'] = 'فحص الصحة لـ STACK';
$string['healthcheck_desc'] = 'إن <a href="{$a->link}">نص فحص الصحة</a> يسمح لك بالتأكد من أن كل مفاصل STACK تعمل بشكل صحيح.';
$string['healthcheckcachestatus'] = 'يحتوي الخبء حالياً على {$a} من المدخلات.';
$string['healthcheckconfigintro1'] = 'تم العثور عليه، وهو يستعمل Maxima في المجلد الآتي:';
$string['healthcheckconnect'] = 'محاولة الاتصال مع نظام المصادقة المركزي';
$string['healthcheckconnectintro'] = 'نحن نحاول تقييم نص نظام المصادقة المركزي الآتي:';
$string['healthcheckcreateimage'] = 'إنشاء صورة Maxima';
$string['healthchecksstackmaximaversion'] = 'إصدار Maxima';
$string['illegalcaschars'] = 'لا يُسمح بالرموز @، $ و \\ في إدخال نظام المصادقة المركزي.';
$string['inputentered'] = 'القيمة المدخلة';
$string['inputexpression'] = 'فحص الإدخال';
$string['inputextraoptions_help'] = 'بعض أنواع الإدخال تتطلب خيارات إضافية ليتسنى لها العمل. يمكنك إدخالها هنا. هذه القيمة هي تعبير نظام المصادقة المركزي.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'الإدخال: {$a}';
$string['inputlanguageproblems'] = 'هناك تناقضات بين الإدخال ووسوم التحقق ما بين اللغات.';
$string['inputname'] = 'اسم الإدخال';
$string['inputnameform'] = 'أسماء الإدخال ينبغي أن تكون من حروف فقط متبوعة (إختيارياً) بأرقام. \'{$a}\' غير مقبول.';
$string['inputnamelength'] = 'أسماء الإدخال لا يمكن أن تزيد على 18 حرف. \'{$a}\' طويل جداً.';
$string['inputoptionunknown'] = 'هذا الإدخال لا يدعم الخيار \'{$a}\'.';
$string['inputremovedconfirm'] = 'أنا أؤكد رغبتي في حذف هذا الإدخال من هذا السؤال.';
$string['inputremovedconfirmbelow'] = 'تمت إزالة الإدخال \'{$a}\'. يرجى تأكيد ذلك أدناه.';
$string['inputs'] = 'الإدخالات';
$string['inputstatusname'] = 'فارغ';
$string['inputstatusnamescore'] = 'الدرجة';
$string['inputtest'] = 'فحص الإدخال';
$string['inputtype'] = 'نوع الإدخال';
$string['inputtype_help'] = 'هذا يحدد نوعية عنصر الإدخال، مثل: حقل نموذج، صح/خطأ، منطقة نص.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'إدخال جبري';
$string['inputtypeboolean'] = 'صح/خطأ';
$string['insertspaces'] = 'إدراج نجوم للفراغات فقط';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsspaces'] = 'إدراج نجوم للضرب الضمني وللفراغات';
$string['insertstarsspacessinglechar'] = 'إدراج نجوم مفترضاً المتغيرات بحرف منفرد، ضمني وللفراغات';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'على الطالب التحقق';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['nodexfalsefeedback'] = 'إفادة الخطأ في العقدة {$a}';
$string['nodextruefeedback'] = 'إفادة الصواب في العقدة {$a}';
$string['noprtsifnoinputs'] = 'السؤال الذي بلا إدخالات لا يمكن أن يكون له أي PRT.';
$string['numericalinputminsfmaxdperr'] = 'لا تحدد متطلبات كل من المنازل العشرية والأرقام المؤثرة ضمن نفس الإدخال.';
$string['numericalinputmustfloat'] = 'هذا الإدخال يتوقع رقماً ذي فارزة عائمة.';
$string['numericalinputmustint'] = 'هذا الإدخال يتوقع رقماً رقماً صحيحاً فقط.';
$string['numericalinputmustnumber'] = 'هذا الإدخال يتوقع رقماً رقماً.';
$string['numericalinputmustrational'] = 'هذا الإدخال يتوقع رقماً رقماً كسرياً أو نسبياً.';
$string['numericalinputvarsforbidden'] = 'هذا الإدخال يتوقع رقماً رقماً، ولذلك لا يمكن أن يضم متغيرات.';
$string['optionsnotrequired'] = 'هذا الإدخال لا يتطلب أي خيارات.';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'الغرامة ينبغي أن تكون قيمة رقمية ما بين 0 و 1.';
$string['penaltyerror2'] = 'الغرامة ينبغي أن تكون خالية، أو قيمة رقمية ما بين 0 و 1.';
$string['privacy:metadata'] = 'إن ملحق نوع السؤال، STACK لا يخزن أي بيانات شخصية.';
$string['prtcorrectfeedback'] = 'الإفادة القياسية لما هو صائب';
$string['prtheading'] = 'شجرة الاستجابة المحتملة: {$a}';
$string['prtincorrectfeedback'] = 'الإفادة القياسية لما هو خاطئ';
$string['prtmustbesetup'] = 'لا بد من ضبط PRT قبل أن يكون بالإمكان حفظ السؤال.';
$string['prtname'] = 'اسم PRT';
$string['prtnamelength'] = 'اسم PRT لا يمكن أن يكون أطول من 18 حرفاً. \'{$a}\' طويل جداً.';
$string['prtnodesheading'] = 'عُقد شجرة الاستجابة المحتملة ({$a})';
$string['prtpartiallycorrectfeedback'] = 'الإفادة القياسية لما هو صحيح جزئياً';
$string['prtremovedconfirm'] = 'أنا أؤكد رغبتي في إزالة شجرة الاستجابة المحتملة هذه من هذا السؤال.';
$string['prtremovedconfirmbelow'] = 'لقد تمت إزالة شجرة الاستجابة المحتملة \'{$a}\'. لطفاً، قم بتأكيد ذلك أدناه.';
$string['prtruntimeerror'] = 'العقدة {$a->node} ولَّدت خطأ التشغيل الآتي: {$a->error}';
$string['prts'] = 'أشجار الاستجابة المحتملة';
$string['prtwillbecomeactivewhen'] = 'شجرة الاستجابة المحتملة هذه ستصير فعالة عند تقديم الطالب للإجابة: {$a}';
$string['prtwillberemoved'] = 'شجرة الاستجابة المحتملة هذه لم تعد مشاراً إليها في نص السؤال أو الإفادة الخاصة. إذا قمت بحفظ السؤال الآن، سيتم فقدان البيانات المتعلقة بشجرة الاستجابة المحتملة هذه. لطفاً، قم بتأكيد رغبتك في القيام بهذا. أو بدلاً من ذلك، قم بتحرير نص السؤال أو الإفادة الخاصة لتضع في أي منهما العنصر النائب \'[[feedback:{$a}]]\'.';
$string['qm_error'] = 'إن إجابتك تحتوي على رموز علامة السؤال ?، وتلك الرموز ليس مسموحاً بها في الإجابة. ينبغي عليك استبدالها بقيمة محددة.';
$string['questiondoesnotuserandomisation'] = 'هذا السؤال لا يستعمل العشوائية.';
$string['questionnotdeployedyet'] = 'لم يتم نشر أي تباينات لهذا السؤال بعد.';
$string['questionnote'] = 'ملاحظة السؤال';
$string['questionnote_help'] = 'إن ملاحظة السؤال هي نص نظام المصادقة المركزي. الغرض من ملاحظة السؤال هو التمييز ما بين المتغيرات العشوائية المختلفة للسؤال. يتساوى اثنان من متغيرات السؤال إذا وفقط إذا تساوت ملاحظة السؤال. في التحليلات اللاحقة، من المفيد جداً ترك ملاحظة سؤال ذات مغزى.';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'لا يمكن لملاحظة السؤال أن تكون فارغة عندما تظهر الدالة rand() بين متغيرات السؤال. ملاحظة السؤال تستعمل للتمييز بين المتغيرات العشوائية المختلفة للسؤال.';
$string['questionpreview'] = 'استعراض السؤال';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'فحوص السؤال';
$string['questiontestsdefault'] = '(الافتراضي)';
$string['questiontestsfor'] = 'فحصوص السؤال للجذر {$a}';
$string['questiontestspass'] = 'تم اجتياز كل فحوص السؤال بنجاح.';
$string['questiontext'] = 'نص السؤال';
$string['questiontext_help'] = 'إن نص السؤال هو نص نظام المصادقة المركزي. هذا هو "السؤال" الذي سيراه الطالب فعلياً. ينبغي عليك وضع عناصر الإدخال وجُمل التحقق من الصحة في هذا الحقل حصراً. على سبيل المثال، مستعملاً `[[input:ans1]] [[validation:ans1]]`.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'هناك تناقضات بين وسوم الإفادة ما بين اللغات.';
$string['questiontextfeedbackonlycontain'] = 'نص السؤال مجتمعاً مع الإفادة الخاصة ينبغي أن يحتوي فقط على الترميز \'{$a}\' لمرة واحدة.';
$string['questiontextmustcontain'] = 'نص السؤال ينبغي أن يحتوي على الترميز \'{$a}\'.';
$string['questiontextnonempty'] = 'نص السؤال ينبغي أن لا يكون فارغاً.';
$string['questiontextonlycontain'] = 'نص السؤال ينبغي أن يحتوي على الترميز \'{$a}\' لمرة واحدة فقط.';
$string['questiontextplaceholderswhitespace'] = 'العناصر النائبة ينبغي أن لا تكون فيها فراغات. العنصر النائب هذا يبدو أنه يحتوي على فراغ: \'{$a}\'.';
$string['questionvalue'] = 'قيمة السؤال';
$string['questionvaluepostive'] = 'قيمة السؤال ينبغي أن لا تكون سالبة.';
$string['questionvariables'] = 'متغيرات السؤال';
$string['questionvariables_help'] = 'هذا الحقل يسمح لك بتعريف متغيرات نظام المصادقة المركزي والتحكم بها، مثلاُ، إنشاء متغيرات عشوائية. ستكون هذه متاحة لكل الأجزاء الأخرى من السؤال';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'قيم متغيرات السؤال';
$string['quiet'] = 'صامت';
$string['quiet_help'] = 'عند ضبطه على نعم، سيتم حجب أي إفادات تلقائية تولدها فحوص الإجابة ولن تعرض للطالب. حقول الإفادات في الفروع لا تتأثر بهذا الخيار.';
$string['renamequestionparts'] = 'إعادة تسمية أجزاء من السؤال';
$string['replacedollarscount'] = 'الصنف يحتوي على {$a} من أسئلة STACK.';
$string['replacedollarserrors'] = 'الأسئلة الآتية أدت إلى توليد أخطاء.';
$string['replacedollarsindextitle'] = 'استبدال $s في نصوص السؤال';
$string['replacedollarsnoproblems'] = 'لم يتم العثور على مشاكل في المحددات.';
$string['replacedollarstitle'] = 'استبدال $s في نصوص السؤال عند {$a}';
$string['requiredfield'] = 'هذا الحقل مطلوب!';
$string['requirelowestterms'] = 'يتطلب أدنى الحدود';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'فحوص السؤال والمتغيرات المنشورة';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['score'] = 'الدرجة';
$string['scoreerror'] = 'الدرجة ينبغي أن تكون قيمة رقمية ما بين 0 و 1.';
$string['seethisquestioninthequestionbank'] = 'مشاهدة هذا السؤال في بنك الأسئلة';
$string['settingajaxvalidation_desc'] = 'عند تفعيل هذا الخيار، سيتم التحقق من الإدخال الحالي للطالب كلما توقف عن الكتابة. هذا سيعطي تجربة أفضل للمستخدم، ولكنه من المحتمل أن يزيد الحمل على المخدم.';
$string['settingcasmaximaversion'] = 'إصدار Maxima';
$string['settingcasresultscache'] = 'تخبئة نتائج نظام المصادقة المركزي';
$string['settingcasresultscache_db'] = 'التخبئة في قاعدة البيانات';
$string['settingcasresultscache_none'] = 'لا تستعمل التخبئة';
$string['settingcastimeout'] = 'انتهت مهلة الاتصال بنظام المصادقة المركزي';
$string['settingcastimeout_desc'] = 'المهلة الزمنية المستعملة عند محاولة الاتصال مع Maxima.';
$string['settingdefaultinputoptions'] = 'خيارات الإدخال الافتراضية';
$string['settingdefaultinputoptions_desc'] = 'يُستعمل عند إنشاء سؤال جديد، أو إضافة إدخال جديد إلى سؤال موجود.';
$string['settingdefaultquestionoptions'] = 'خيارات الإدخال الافتراضية';
$string['settingmathsdisplay'] = 'منقح الرياضيات';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingmathsdisplay_maths'] = 'منقح الرياضيات OU القديم';
$string['settingmathsdisplay_oumaths'] = 'منقح الرياضيات OU الجديد';
$string['settingmathsdisplay_tex'] = 'منقح TeX لمودل';
$string['settingplatformmaximacommand_desc'] = 'لنوع المنصة: المخدم، ينبغي ضبطه على رابط Maxima Pool servlet. لأنواع المنصات الأخرى، إذا كان هذا فارغاً، سيقوم STACK بالخروج بتخمين ناجع بشأن الموضع الذي يُتوقع فيه العثور على Maxima. إذا فشل ذلك، ينبغي ضبطه على المسار الكامل لـ maxima أو الملف التنفيذي لـ maxima-optimised. خذ بعين الاعتبار استعمال أمر مهلة التنفيذ في الأنظمة المبنية على يونكس. مثلاً: timeout --kill-after=10s 10s maxima';
$string['settingplatformplotcommand'] = 'أمر الرسم';
$string['settingplatformtype'] = 'نوع المنصة';
$string['settingplatformtype_desc'] = 'يحتاج STACK إلى معرفة نوعية نظام التشغيل الذي يعمل عليه. إن خيار "المخدم" يعطي أداءً أفضل مقابل تكلفة الحاجة إلى إعداد مخدم إضافي. الخيار "لينكس (مُحسَّن)" مشروح في صفحة تحسين Maxima في التوثيقات.';
$string['settingplatformtypeserver'] = 'المخدم';
$string['settingplatformtypewin'] = 'وندوز';
$string['settingreplacedollars'] = 'استبدال <code>$</code> و <code>$$</code>';
$string['settingserveruserpass'] = 'username:password للمخدم';
$string['settingserveruserpass_desc'] = 'إذا كنت تستعمل نوع المنصة: المخدم، وإذا قمت بإعداد مخدم Maxima pool لاستعمال مصادقة HTTP، فيمكنك وضع اسم الدخول وكلمة المرور هنا. هذا نسبياً أكثر أماناً من وضعهما في عنوان الرابط. الصيغة هي username:password.';
$string['settingsmathsdisplayheading'] = 'خيارات عرض الرياضيات';
$string['settingsmaximasettings'] = 'يجري الاتصال مع Maxima';
$string['showvalidation_help'] = 'يعرض أي إفادة تَحقُّق من هذا الإدخال، بما في ذلك أصداء انطباعاتهم بشأن الترميز التقليدي ثنائي الأبعاد. يتم دائمًا الإبلاغ عن الأخطاء في الصياغة.';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationno'] = 'لا';
$string['showvalidationyes'] = 'نعم، مع قائمة المتغيرات';
$string['showvalidationyesnovars'] = 'نعم، بدون قائمة المتغيرات';
$string['singlechargotmorethanone'] = 'يمكنك إدخال حرف واحد هنا.';
$string['specificfeedback'] = 'الإفادة الخاصة';
$string['specificfeedback_help'] = 'إفتراضياً، سيتم إظهار الإفادة الخاصة بكل شجرة استجابة محتملة في هذه الكتلة. يمكن نقلها إلى نص السؤال، وفي تلك الحالة، ستكون لمودل سيطرة أقل على توقيت عرضها حسب أنواع السلوك المختلفة. لاحظ أن هذه الكتلة ليست نص نظام المصادقة المركزي.';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stackBlock_missmatch'] = 'ليس له ما يطابقه.';
$string['stackBlock_unknownBlock'] = 'الكتلة الآتية مجهولة:';
$string['stackCas_MissingAt'] = 'أنت تفتقد إلى علامة <code>@</code>.';
$string['stackCas_MissingCloseDisplay'] = 'تفتقد <code>\\]</code>.';
$string['stackCas_MissingCloseInline'] = 'تفتقد <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'تفتقد <code>#}</code>.';
$string['stackCas_MissingClosingTeXCAS'] = 'تفتقد <code>@}</code>.';
$string['stackCas_MissingOpenDisplay'] = 'تفتقد <code>\\[</code>.';
$string['stackCas_MissingOpenInline'] = 'تفتقد <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'تفتقد <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'تفتقد <code>{@</code>.';
$string['stackCas_forbiddenFunction'] = 'دالة ممنوعة: {$a->forbid}.';
$string['stackCas_forbiddenOperator'] = 'عامل ممنوع: {$a->forbid}.';
$string['stackCas_forbiddenVariable'] = 'متغير أو ثابت ممنوع: {$a->forbid}.';
$string['stackCas_forbiddenWord'] = 'إن التعبير {$a->forbid} ممنوع.';
$string['stackCas_inputsdefined'] = 'لا يمكنك استعمال أسماء الإدخال بمثابة متغيرات. لقد حاولت تعريف <code>{$a}</code>';
$string['stackCas_invalidCommand'] = 'أوامر نظام المصادقة المركزي غير صحيحة.';
$string['stackCas_missingRightBracket'] = 'لديك قوس أيمن مفقود <span class="stacksyntaxexample">{$a->bracket}</span> في التعبير: {$a->cmd}.';
$string['stackCas_underscores'] = 'الاستعمال الآتي للشرطة التحتانية غير مسموح به: {$a}.';
$string['stackCas_unknownFunctionCase'] = 'الإدخال يتحسس حالة الأحرف: {$a->forbid} هي دالة مجهولة. هل كنت تقصد {$a->lower}؟';
$string['stackCas_unknownUnitsCase'] = 'إدخال الوحدات يتحسس حالة الأحرف: {$a->forbid} هي وحدة قياس مجهولة. هل كنت تقصد
 واحدة من القائمة الآتية {$a->unit}؟';
$string['stackCas_unknownVariableCase'] = 'الإدخال يتحسس حالة الأحرف: {$a->forbid} هو متغير مجهول. هل كنت تقصد {$a->lower}؟';
$string['stackDoc_home'] = 'الصفحة الرئيسية للتوثيقات';
$string['stackDoc_siteMap'] = 'خريطة الموقع';
$string['stackDoc_siteMap_en'] = 'خريطة الموقع بالإنجليزية';
$string['stackInstall_input_title'] = 'تركيبة فحص للتحقق من إدخال الطالب';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'الأسئلة التي بدون الإفادة العامة: الطلبة يقدرون حقًا الأسئلة المحلولة!';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['studentValidation_listofunits'] = 'وحدات القياس التي عُثر عليها في إجابتك هي: {$a}';
$string['studentValidation_listofvariables'] = 'المتغيرات التي عُثر عليها في إجابتك هي: {$a}';
$string['studentValidation_notes'] = '(هذا الإدخال ليس مقيماً بشكل تلقائي من قبل STACK.)';
$string['studentanswer'] = 'استجابة الطالب';
$string['symbolicprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span>';
$string['symbolicprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i>';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributevalue'] = 'القيمة';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['teacheranswerempty'] = 'يمكن ترك هذا الإدخال فارغاً.';
$string['teacheranswershow'] = 'الإجابة الصحيحة هي \\( {$a->display} \\)، والتي يمكن طباعتها بالشكل: {$a->value}';
$string['teacheranswershow_disp'] = 'الإجابة الصحيحة هي {$a->display}.';
$string['teacheranswershow_mcq'] = 'الإجابة الصحيحة هي {$a->display}.';
$string['teacheranswershownotes'] = 'لم يتم تقديم الإجابة الصحيحة لهذا الإدخال';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testinputs'] = 'إدخالات الفحص';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testsuitefeedback'] = 'الإفادة';
$string['trig_standard_values_name'] = 'القيم المثلثية القياسية';
$string['true'] = 'صح';
