<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_formulas', language 'cs', version '4.3'.
 *
 * @package     qtype_formulas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abserror'] = 'Absolutní chyba';
$string['addmorepartsblanks'] = 'Prázdné místo pro {počet} dalších částí';
$string['algebraic_formula'] = 'Algebraická formule';
$string['answer'] = 'Odpověď*';
$string['answer_help'] = '**Požadováno**
v závislosti na typu vybrané odpovědi se musí jednat o seznam seznam čísel nebo řetězců. Pokud je povolená pouze 1 odpověď, tak musí být číslo nebo řetězec napsáno přesně. Mějte na paměti, že počet prvků v seznamu definuje pro danou část počet polí pro odpovědi.

<pre class="prettyprint">123<br>[1, 0, 0, 1]<br>a<br>[1, a, b]<br>"exp(-a t)"<br>["vx t","vy t - 0.5 a t^2"]</pre>';
$string['answercombinedunitmulti'] = 'Odpověď a jednotka pro část {$a->part}';
$string['answercombinedunitsingle'] = 'Odpověď a jednotka';
$string['answercoordinatemulti'] = 'Odpovědi pro část {$a->part} a souřadnice {$a->numanswer}';
$string['answercoordinatesingle'] = 'Odpověď na souřadnici {$a->numanswer}';
$string['answermark'] = 'Známka za část*';
$string['answermark_help'] = '**Požadováno**
Známka za tuto část by měla být vyšší než 0.
Výchozí nastavení známky pro celou otázku je součet všech známek z jednotlivých částí.

Poznámka: Pokud zůstane pole pro známku nevyplněné, tak bude část po uložení otázky odstraněna.';
$string['answermulti'] = 'Odpověď pro část {$a->part}';
$string['answerno'] = 'Část {$a}';
$string['answersingle'] = 'Odpověď';
$string['answertype'] = 'Typ odpovědi';
$string['answertype_help'] = 'Jsou zde čtyři typy odpovědí.

Na číselné a numerické úlohy je jako odpověď vyžadováno číslo nebo seznam čísel.

Algebraické úlohy vyžadují jako odpověď řetězec nebo seznam řetězců.

Různé typy odpovědí budou při zadávání odpovědí požadovat různá omezení, takže je potřeba aby studenti byli seznámeni, které hodnoty kam patří. Pokud ovšem zadají něco špatně, tak jim to kontrola formátu u otázky oznámí.

Pro více detailů si prosím přečtěte dokumentaci.';
$string['answertype_link'] = 'https://moodleformulas.org/';
$string['answerunitmulti'] = 'Jednotka pro část {$a->part}';
$string['answerunitsingle'] = 'Jednotka';
$string['checkvarshdr'] = 'Zkontrolujte instanci proměnných';
$string['choiceno'] = 'Ne';
$string['choiceyes'] = 'Ano';
$string['commonsiunit'] = 'Běžné SI jednotky';
$string['correctansweris'] = 'Jediná správná odpověď na otázku je: {$a}';
$string['correctfeedback'] = 'Za každou správnou odpověď';
$string['correctfeedback_help'] = 'Tato zpětná vazba bude zobrazena studentům, kteří získají za část nejvyšší známku. Zpětná vazba může obsahovat globální a lokální proměnné nahrazené jejich hodnotami.';
$string['correctness'] = 'Kritéria hodnocení*';
$string['correctness_help'] = '**Požadováno**
Pro problém s rozsahem můžete zvolit relativní nebo absolutní chybu. Relativní chyba nemůže být pužita pro algebraický typ odpovědi.

Pro přesnou definici relativní chyby a absolutní chyby, v případě existence více odpovědních polí najdete v dokumentaci.';
$string['correctness_link'] = 'https://moodleformulas.org/';
$string['correctnessexpert'] = 'Expert';
$string['correctnesssimple'] = 'Jednoduché';
$string['defaultanswermark'] = 'Výchozí známka části';
$string['defaultanswermark_desc'] = 'Výchozí známka části pro novou část otázky';
$string['defaultanswertype'] = 'Výchozí typ odpovědi';
$string['defaultanswertype_desc'] = 'Výchozí odpověď pro novou část otázky';
$string['defaultcorrectness'] = 'Výchozí kritéria hodnocení';
$string['defaultcorrectness_desc'] = 'Výchozí kritéria hodnocení pro novou část otázky';
$string['defaultunitpenalty'] = 'Výchozí penalizace za špatnou jednotku';
$string['defaultunitpenalty_desc'] = 'Výchozí penalizace za špatnou jednotku (0-1)';
$string['error_algebraic_var'] = 'Syntaktická chyba definování algebraické proměnné.';
$string['error_answer_missing'] = 'Nebyla definována žádná odpověď.';
$string['error_answerbox_duplicate'] = 'Každé zástupné odpovědní pole musí být požitu v části jednou.';
$string['error_answertype_mistmatch'] = 'Nesoulad s typem odpovědi: Číselná odpověď vyžaduje číslo a algebraická odpověď vyžaduje řetězec.';
$string['error_criterion'] = 'Kritérium hodnocení musí být vyhodnoceno jako jedno číslo.';
$string['error_eval_numerical'] = 'Některá výrazy nelze vyhodnotit číselně.';
$string['error_fixed_range'] = 'Chyba syntaxe pevného rozsahu.';
$string['error_forbid_char'] = 'Vzorec nebo výraz obsahuje zakázané znaky nebo operátory.';
$string['error_forloop'] = 'Syntaktická chyba for cyklu.';
$string['error_forloop_expression'] = 'Výraz ve for cyklu musí být řetězec.';
$string['error_forloop_var'] = 'Proměnná for cyklu obsahuje chyby.';
$string['error_func_param'] = 'Špatný počet nebo typ parametrů pro funkci {$a}()';
$string['error_grading_error'] = 'Chyba hodnocení! Pravděpodobně důsledkem nesprávného importovaného souboru nebo poškození databáze.';
$string['error_mark'] = 'Známka za odpověď musí být hodnota vyšší než 0.';
$string['error_no_answer'] = 'Je požadována nejméně jedna odpověď.';
$string['error_placeholder_format'] = 'Špatný formát zástupného znaku nebo zakázané znaky.';
$string['error_placeholder_main_duplicate'] = 'Duplikovaný Tento zástupný znak v hlavním textu otázky.';
$string['error_placeholder_missing'] = 'Tento zástupný znak chybí v hlavním textu.';
$string['error_placeholder_sub_duplicate'] = 'Tento zástupný znak již byl definován v jiné části.';
$string['error_placeholder_too_long'] = 'Délka zástupného pole je omezena na 40 znaků.';
$string['error_question_damaged'] = 'Chyba: Otázka je poškozená, počet fragmentů textu a počet částí otázky nejsou stejné.';
$string['error_randvars_set_size'] = 'Počet generovatelných prvků v sadě musí být vyšší než 1.';
$string['error_randvars_type'] = 'Všechny prvnky množiny musí být stejného typu a mít stejnou velikost.';
$string['error_rule'] = 'Chyba převodního pravidla!';
$string['error_ruleid'] = 'Žádné takové pravidlo s id/name v souboru neexistuje.';
$string['error_subexpression_empty'] = 'Podvýraz je prázdný.';
$string['error_syntax'] = 'Syntaktická chyba.';
$string['error_unit'] = 'Chyba převodu jednotky!';
$string['error_unitpenalty'] = 'Penalizace musí být číslo mezi 0 a 1.';
$string['error_validation_eval'] = 'Chyba pokusu o vyhodnocení!';
$string['error_vars_array_index_nonnumeric'] = 'Nečíslná hodnota nemůže být použit jako seznamový index.';
$string['error_vars_array_index_out_of_range'] = 'Seznamový index ukazuje mimo rozsah !!!';
$string['error_vars_array_size'] = 'Velikost seznamu musí být od 1 do 1000.';
$string['error_vars_array_type'] = 'Prvek ve stejném seznamu musí být stejného typu (číslo nebo řetězec).';
$string['error_vars_array_unsubscriptable'] = 'Proměnná je nezapsatelná.';
$string['error_vars_bracket_mismatch'] = 'Neodpovídá počet závorek.';
$string['error_vars_end_separator'] = 'Chybějící přeřazovací operátor na konci.';
$string['error_vars_name'] = 'Syntaxe názvu proměnné je špatně.';
$string['error_vars_reserved'] = 'Funkce {$a}() je obsazená a nemůže být použita jako proměnná.';
$string['error_vars_string'] = 'Chyba! Buď použití řetězce bez dvojitých uvozovek nebo použití neakceptovatelného znaku jako \'.';
$string['error_vars_undefined'] = 'Proměnná \'{$a}\' nebyla definována.';
$string['feedback'] = 'Část obecná zpětná vazba';
$string['feedback_help'] = 'Tato část zpětné vazby bude zobrazena všem studentům. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['functiontakesatleasttwo'] = 'Funkce {$a} musí mít nejméně dva argumenty.';
$string['functiontakesnoargs'] = 'Funkce {$a} nepřijímá žádné argumenty';
$string['functiontakesonearg'] = 'Funkce {$a} musí mít přesně jeden argument';
$string['functiontakesoneortwoargs'] = 'Funkce {$a} musí mít buď jeden nebo dva argumenty.';
$string['functiontakesthreeargs'] = 'Funkce {$a} musí mít přesně tři argumenty';
$string['functiontakestwoargs'] = 'Funkce {$a} musí mít přesně dva argumenty.';
$string['globalvarshdr'] = 'Proměnné';
$string['illegalformulasyntax'] = 'Ilegální syntaxe vzorce začínající \'{$a}\'';
$string['incorrectfeedback'] = 'Za jakoukoli nesprávnou odpověď';
$string['incorrectfeedback_help'] = 'Tato zpětná vazba bude zobrazena studentům, kteří z této části nezískali žádnou známku. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['instantiate'] = 'Okamžitě';
$string['mainq'] = 'Hlavní otázka';
$string['modelanswer'] = 'Modelová otázka';
$string['none'] = 'žádný';
$string['number'] = 'Číslo';
$string['number_unit'] = 'Číslo a jednotka';
$string['numdataset'] = 'Počet datových sad';
$string['numeric'] = 'Číselná hodnota';
$string['numeric_unit'] = 'Číselná hodnota a jednotka';
$string['numerical_formula'] = 'Číselný vzorec';
$string['numerical_formula_unit'] = 'Číselný vzorec a jednotka';
$string['otherrule'] = 'Ostatní pravidla';
$string['otherrule_help'] = 'Zde může autor otázky zavézt pravidla převodu pro jiné jednotky veličiny. Více informací najdete v dokumentaci.';
$string['partiallycorrectfeedback'] = 'Za jakoukoli částečně správnou odpověď';
$string['partiallycorrectfeedback_help'] = 'Tento feedback bude zobrazen studentům, kteří v této části nezískali nejvyšší známku. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['placeholder'] = 'Zástupný název';
$string['placeholder_help'] = 'Zástupný symbol se používá k identifikaci místa v textu hlavní otázky, které bude nahrazeno obsahem části. Jedná se o řetězec alfanumerických znaků s prefixem \'**#**\', jako #1, #2a, #2b a #A.

Pokud necháte pole prázdné, tak bude část připojena na konec hlavní otázky.';
$string['pleaseputananswer'] = 'Prosím vyplňte odpověď do všech vstupních polí.';
$string['pluginname'] = 'Vzorce';
$string['pluginname_help'] = 'K využití této otázky jděte na <a href="https://moodleformulas.org/">moodleformulas.org</a>.

Pro možné odpovědi jděte na <a href="https://moodleformulas.org/">moodleformulas.org</a>.

Pro možnosti v upravování formuláře níže jděte na <a href="https://moodleformulas.org/">moodleformulas.org</a>

Pro kompletní dokumentaci jděte na <a href="https://moodleformulas.org/">moodleformulas.org</a>';
$string['pluginname_link'] = 'question/type/formulas';
$string['pluginnameadding'] = 'Přidání otázky';
$string['pluginnameediting'] = 'Úpravy otázky';
$string['pluginnamesummary'] = 'Typ otázky s náhodnými hodnotami a více odpověďmi.
Odpovědní pole mohou být umístěná kamkoli, takže můžeme vytvořit různé otázky zahrnující různorodé struktury jako jsou vektory, polynomy a matice.
Dále jsou ke snadnému použití dostupné funkce jako kontrola jednotky a vícedílné otázky.';
$string['postunit'] = 'Jednotka';
$string['postunit_help'] = 'Zde můžete specifikovat jednotku. Tento typ otázky je navržen pro SI jednotky, takže prázdný prostor reprezentuje \'produkt\' různých \'základních jednotek\'. Označení <tt> a ^ </tt> je použito pro exponent. Označení <tt>> / <tt> může být použito pro označení inverzního exponentu. S jakoukoli permutací základní jednotky se zachází stejně.

Po studentech je požadováno používat stejní vstupní formát.

Například:
<pre class="prettyprint">1 m<br>0.1 m^2<br>20 m s^(-1)<br>400 kg m/s<br>100 kW</pre>';
$string['previewerror'] = 'Náhled není k dispozici. Zkontrolujte svou definici náhodných proměnných, globálních proměnných, lokálních proměnných částí a odpovědí. Původní chybová zpráva:';
$string['privacy:metadata'] = 'Tento plugin neskladuje žádná osobní data.';
$string['qtextpreview'] = 'Náhled';
$string['questiontext'] = 'Text otázky';
$string['questiontext_help'] = 'Kromě normálního typu otázky, zde můžete využít i globální proměnné a zástupná pole.

Globální proměnné budou nahrazeny jejich hodnotami a zástupná pole budou nahrazeny částmi.

Příklad:
<tt> A, B, C </tt> a zástupné symboly <tt> #1, #2, #3 </tt> jsou:

<pre class="prettyprint">Jaký je výsledek {A} + {B}?<br>{#1}<br>Jaký je výsledek {A} - {B}?<br>{#2}<br>Jaký je výsledek {C} / {B}?<br>{#3}</pre>';
$string['relerror'] = 'Relativní chyba';
$string['renew'] = 'Změna';
$string['ruleid'] = 'Základní převodní pravidla';
$string['ruleid_help'] = 'Tento typ otázky má vestavěný systém pro konverzi jednotek a obsahuje základní převodní pravidla.

Základním z pravidel je "Běžné SI jednotky", které převedou základní jednotky jako jsou délka (km, m, cm a mm). Toto nastavení nemá žádný vliv, pokud jednotky nejsou použity.';
$string['settingusepopup'] = 'Použijte popisky';
$string['settingusepopup_desc'] = 'Zobrazte správnou odpověď a zpětnou vazbu v popisku.';
$string['subqoptions'] = 'Nastavení jednotky';
$string['subqtext'] = 'Text část';
$string['subqtext_help'] = 'Zde mohou být specifikovány části textu a odpovědní pole. Zástupná pole mohou být využita ke specifikování odpovědních míst vypadají takto:

<pre class="prettyprint">{_0}<br>{_1}<br>{_2}<br>...<br>{_u}</pre>

<tt> {_0}, {_1}, {_2} </tt> ajsou vstupní pole pro souřadnice a  <tt> {_u} </tt> je vstupní pole pro jednotku.

Všechny chybějící pole jsou automaticky spojeny na konci části textu. Speciální případ je pokud <tt> {_0}, {_u} </tt> jsou zadány postupně a je zde pouze jedna souřadnice a jednotka tj. <tt> {_0}{_u} </tt>, ty budou spojeny do jednoho dlouhého vstupního pole pro obojí (hodnotu i veličinu).';
$string['unit'] = 'Jednotka';
$string['unitpenalty'] = 'Srážka za špatnou jednotku (0-1)*';
$string['unitpenalty_help'] = 'Toto nastavení určuje známku, kterou chcete udělit studentovi jako penalizaci za uvedení špatné jednotky.

Přijímány jsou hodnoty mezi 0 a 1. Pokud je hodnota 1, tak pro získání známky je potřeba mít správně jednotku i odpověď. Odpověď a jednotka jsou při odpovědi považovány za jednu entitu. Na druhou stranu, pokud je nastavena hodnota 0, studenti mohou dostat plný počet bodů pouze za správnou odpověď. Všechny náhodné řetězce na konci otázky nebudou mít vliv.

Je doporučeno nastavit hodnotu 1 všude, kde není požadovaná žádná přidružená jednotka.';
$string['unsupportedformulafunction'] = 'Funkce {$a} není podporována';
$string['vars1'] = 'Lokální proměnné';
$string['vars1_help'] = 'Zde můžete definovat proměnné stejným způsobem jako je tomu u globálních proměnných v úrovni otázek. Proměnné definované zde mohou být použity v části odpovědi nebo zpětné vazbě. Jejich viditelnost je omezená pro danou část.';
$string['vars2'] = 'Klasifikační proměnné';
$string['vars2_help'] = 'Zde je možné využít všechny lokální proměnné a studentské ospovědi. Pro pokročilé využití najdete více informací v dokumentaci.';
$string['vars2_link'] = 'https://moodleformulas.org/';
$string['varsdata'] = 'Instantní datové sady';
$string['varsglobal'] = 'Globální proměnné';
$string['varsglobal_help'] = 'Zde lze specifikovat vzorce pro manipulaci s instanciovanými náhodnými proměnnými (všechny náhodné proměnné jsou dostupné zde). Úplný seznam matematických funkcí a operátorů je dostupný v dokumentaci.

příklad:
<pre class="prettyprint">a = 1.11111;<br>b = exp(3);<br>c = A + a + b;<br>d = sin(1.5*pi()) + c;<br>e = round(a, 0);<br>f = [0,1,2,3][A];<br>g = ["zero","one","two","three"][A];<br>distance = sqrt(a*a + b*b);</pre>';
$string['varsglobal_link'] = 'https://moodleformulas.org/';
$string['varsrandom'] = 'Náhodné proměnné';
$string['varsrandom_help'] = 'Nové náhodné hodnoty jsou pro tyto proměnné vygenerovány na začátku každého pokusu. Toto lze provézt definováním sady prvků, ze kterých si můžete vybrat.

<pre class="prettyprint">A = {1,2,3};<br>C = {[1,-1], [2,-2], [3,-3]};<br>E = {10:100:10, 100, 1000};</pre>

Prvky mohou být čísla, řetězce nebo jejich seznamy. Na začátku nového pokusu bude jeden z prvků vylosován a přiřazen. Také je zde možnost pro čísla využít notaci pro definování rozsahu jako 10:100:100 (ukázáno výše u E).';
$string['varsrandom_link'] = 'https://moodleformulas.org/';
$string['varsstatistics'] = 'Statistika';
$string['yougotnright'] = 'U části otázky {$a->num} jste odpověděli správně.';
