<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'lt', version '4.3'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Veiksmas';
$string['addanotherhint'] = 'Pridėti dar vieną užuominą';
$string['addcategory'] = 'Pridėti kategoriją';
$string['addmorechoiceblanks'] = 'Dar {no} tuščių pasirinkimų';
$string['adminreport'] = 'Apie galimas problemas praneškite klausimų duomenų bazėje.';
$string['advancedsearchoptions'] = 'Paieškos parinktys';
$string['alltries'] = 'Visi bandymai';
$string['answer'] = 'Atsakymas';
$string['answers'] = 'Atsakymai';
$string['answersaved'] = 'Atsakymas išsaugotas';
$string['answerx'] = 'Atsakymas {$a}';
$string['attemptfinished'] = 'Bandymas baigtas';
$string['attemptfinishedsubmitting'] = 'Bandymas baigtas pateikiant: {$a}';
$string['attemptoptions'] = 'Bandymų pasirinkimai';
$string['availableq'] = 'Ar prieinama?';
$string['badbase'] = 'Bloga bazė prieš **: {$a}**';
$string['behaviour'] = 'Elgsena';
$string['behaviourbeingused'] = 'Naudojama elgsene: {$a}';
$string['broken'] = 'Tai neveikiantis saitas, jis nurodo nesamą failą.';
$string['byandon'] = 'Naudotojas <em>{$a->user}</em>, laikas <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nepavyko nukopijuoti atsarginės kopijos failo';
$string['cannotcreate'] = 'Lentelėje question_attempts nepavyko sukurti naujo įrašo';
$string['cannotcreatepath'] = 'Nepavyksta sukurti kelio: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Negalite ištrinti šios elgsenos \'{$a}\'. Ji yra naudojama klausimams.';
$string['cannotdeletecate'] = 'Negalite naikinti šios kategorijos. Tai numatytoji šio konteksto kategorija.';
$string['cannotdeleteneededbehaviour'] = 'Negalite ištrinti klausimo elgsenos \'{$a}\'. Yra kitų elgsenų, kuriuos nuo to yra priklausomos.';
$string['cannotdeleteqtypeinuse'] = 'Negalite ištrinti klausimo tipo \'{$a}\'. Yra tokio tipo klausimų klausimų sąraše.';
$string['cannotdeleteqtypeneeded'] = 'Negalite ištrinti klausimų tipo \'{$a}\'. Yra kitų klausimų tipų, kurie nuo to priklausomi.';
$string['cannotdeletetopcat'] = 'Aukščiausių kategorijų negalima ištrinti.';
$string['cannotedittopcat'] = 'Aukščiausių kategorijų redaguoti negalima.';
$string['cannotenable'] = 'Klausimo tipo {$a} tiesiogiai sukurti negalima.';
$string['cannotenablebehaviour'] = 'Klausimo elgsena {$a} negali būti naudojama tiesiogiai. Ji tik vidiniam naudojimui.';
$string['cannotfindcate'] = 'Nepavyko rasti kategorijos įrašo';
$string['cannotfindquestionfile'] = 'Suglaudintame faile nepavyko rasti klausimų duomenų failo';
$string['cannotgetdsfordependent'] = 'Nepavyksta gauti nuo duomenų rinkinio priklausomo klausimo nurodyto duomenų rinkinio! (klausimas: {$a->id}, duomenų rinkinio elementas: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nepavyksta gauti apskaičiuoto klausimo nurodyto duomenų rinkinio! (klausimas: {$a})';
$string['cannothidequestion'] = 'Nepavyko paslėpti klausimo';
$string['cannotimportformat'] = 'Atsiprašome, šio formato importavimo galimybė dar neįdiegta!';
$string['cannotinsertquestion'] = 'Nepavyko įterpti naujo klausimo!';
$string['cannotinsertquestioncatecontext'] = 'Nepavyko įterpti naujos klausimo kategorijos {$a->cat}, neleistinas konteksto ID {$a->ctx}';
$string['cannotloadquestion'] = 'Nepavyko įkelti klausimo';
$string['cannotmovequestion'] = 'Norėdami perkelti klausimus, turinčius su jais susietų skirtingų sričių failų, negalite naudoti šio scenarijaus.';
$string['cannotopenforwriting'] = 'Negalima atidaryti norint rašyti: {$a}';
$string['cannotpreview'] = 'Šių klausimų peržiūrėti negalite!';
$string['cannotread'] = 'Negalima skaityti failo (arba failas yra tuščias)';
$string['cannotregradedifferentqtype'] = 'Neįmanoma iš naujo įvertinti kitokio tipo klausimo.';
$string['cannotretrieveqcat'] = 'Nepavyko nuskaityti klausimo kategorijos';
$string['cannotunhidequestion'] = 'Nepavyko panaikinti failo slėpimo.';
$string['cannotunzip'] = 'Nepavyko išskleisti failo.';
$string['cannotwriteto'] = 'Eksportuotų klausimų nepavyksta įrašyti į {$a}';
$string['categories'] = 'Kategorijos';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Dabartinė kategorija';
$string['categorycurrentuse'] = 'Naudoti šią kategoriją';
$string['categorydoesnotexist'] = 'Tokios kategorijos nėra';
$string['categoryinfo'] = 'Kategorijos informacija';
$string['categorymove'] = 'Kategorija \'{$a->name}\' turi {$a->count} klausimų (kai kurie iš jų gali būti paslėpti ar atsitiktiniai klausimai, kurie vis dar naudojami testuose). Prašome pasirinkti kitą kategoriją, į kurią perkelsite juos.';
$string['categorymoveto'] = 'Įrašyti į kategoriją';
$string['categorynamecantbeblank'] = 'Kategorijos pavadinimas negali būti paliktas tuščias.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Pakeisti nustatymus';
$string['changepublishstatuscat'] = 'Kurso „{$a->coursename}“ <a href="{$a->caturl}">kategorijos „{$a->name}“</a> bendrinimo būsena bus pakeista iš {$a- >changefrom} į {$a->changeto}.';
$string['check'] = 'Tikrinti';
$string['chooseqtypetoadd'] = 'Pasirinkite klausimo tipą';
$string['clearwrongparts'] = 'Išvalyti neteisingus atsiliepimus';
$string['clickflag'] = 'Pažymėti klausimą';
$string['clicktoflag'] = 'Spustelėkite, kad pažymėtumėte šį klausimą vėliavėle';
$string['clicktounflag'] = 'Spustelėkite, kad panaikintumėte šio klausimo žymėjimą vėliavėle';
$string['clickunflag'] = 'Nuimti pažymėjimą';
$string['closepreview'] = 'Uždaryti peržiūrą';
$string['combinedfeedback'] = 'Bendri atsiliepimai';
$string['comment'] = 'Komentaras';
$string['commented'] = 'Komentuota: {$a}';
$string['commentormark'] = 'Palikti komentarą arba pakeisti pažymį';
$string['comments'] = 'Komentarai';
$string['commentx'] = 'Komentaras: {$a}';
$string['complete'] = 'Baigta';
$string['contexterror'] = 'Jei neperkeliate kategorijos į kitą kontekstą, čia patekti neturėjote.';
$string['copy'] = 'Kopijuoti iš {$a} ir keisti saitus.';
$string['correct'] = 'Teisinga';
$string['correctfeedback'] = 'Kiekvienam teisingam atsakymui';
$string['correctfeedbackdefault'] = 'Jūsų atsakymas yra teisingas.';
$string['created'] = 'Sukurta';
$string['createdby'] = 'Sukūrė';
$string['createdmodifiedheader'] = 'Sukurta / paskutinį kartą įrašyta';
$string['createnewquestion'] = 'Kurti naują klausimą...';
$string['cwrqpfs'] = 'Pasirinktiniai klausimai, pasirenkant klausimus iš subkategorijų.';
$string['cwrqpfsinfo'] = '<p>Naujinant versiją į „Moodle 1.9“ atskiriame klausimų kategorijas į skirtingus kontekstus. Turės būti pakeistos kai kurių klausimų kategorijų ir klausimų, esančių jūsų svetainėje, bendro naudojimo būsenos. Tai būna retais atvejais, kai vienas ar keli atsitiktiniai testo klausimai nustatyti taip, kad būtų pasirinkti iš bendrai naudojamų ir bendrai nenaudojamų kategorijų derinio (kaip tai yra šioje svetainėje). Taip nutinka, kai atsitiktinis klausimas nustatytas taip, kad būtų pasirinktas iš subkategorijų, o viena ar kelios subkategorijos turi kitokią pirminės kategorijos, kuriame sukurtas atsitiktinis klausimas, bendro naudojimo būseną.</p> <p>Atnaujinant į „Moodle 1.9“ šių klausimų kategorijų, iš kurių atsitiktiniai klausimai pirminėse kategorijose parenka klausimus, bendro naudojimo būsenos bus pakeistos į tą pačią bendro naudojimo būseną kaip kategorija, kurioje yra atsitiktinis klausimas. Bus pakeista šių kategorijų bendro naudojimo būsena. Paveikti klausimai toliau veiks visuose esamuose testuose, kol jų nepašalinsite iš tų testų.</p>';
$string['cwrqpfsnoprob'] = 'Nė vienos svetainės klausimų kategorijos nepaveikė pasirinktinių klausimų, pasirenkant klausimus iš subkategorijų, problema.';
$string['decimalplacesingrades'] = 'Skaičių po kablelio pažymiuose';
$string['defaultfor'] = '{$a} numatytoji reikšmė';
$string['defaultinfofor'] = 'Numatytoji klausimų, bendrinamų kontekste „{$a}“, kategorija.';
$string['defaultmark'] = 'Numatytasis balas';
$string['defaultmarkmustbepositive'] = '';
$string['deletecoursecategorywithquestions'] = 'Klausimų banke yra klausimų, susijusių su šia kursų kategorija. Jei tęsite, jie bus panaikinti. Galbūt pirmiausia norite juos perkelti, naudodami klausimų banko sąsają.';
$string['deletequestioncheck'] = 'Bus ištrintas šis klausimas ir visos jo versijos: <br /><br />{$a}';
$string['deletequestionscheck'] = 'Bus ištrinti šie klausimai ir visos jų versijos:<br /><br />{$a}';
$string['deletequestiontitle'] = 'Ištrinti klausimą?';
$string['deletequestiontitle_plural'] = 'Ištrinti klausimus?';
$string['deleteselectedquestioncheck'] = 'Bus ištrintos pasirinktos šio klausimo versijos:<br /><br />{$a}';
$string['deleteversiontitle'] = 'Ištrinti pasirinktą versiją?';
$string['deleteversiontitle_plural'] = 'Ištrinti pasirinktas versijas?';
$string['deletingbehaviour'] = 'Trinama klausimo elgsena \'{$a}';
$string['deletingqtype'] = 'Trinamas klausimo tipas \'{$a}';
$string['didnotmatchanyanswer'] = '[Neatitiko nei vienas atsakymas]';
$string['disabled'] = 'Išjungta';
$string['displayoptions'] = 'Vaizdavimo nustatymai';
$string['disterror'] = 'Paskirstymas {$a} sukėlė problemų';
$string['donothing'] = 'Nekopijuokite ir neperkelkite failų, nekeiskite saitų.';
$string['editcategories'] = 'Redaguoti kategorijas';
$string['editcategories_help'] = 'Užuot viską laikę viename dideliame sąraše, klausimus galite suskirstyti į kategorijas ir subkategorijas. Yra kiekvienos kategorijos kontekstas, nustatantis, kur gali  būti naudojama subkategorijoje esantis klausimas: * Veiklos kontekstas – tik veiklos modulyje prieinami klausimai * Kursų kontekstas –  kursų visuose veiklos moduliuose prieinami klausimai * Kursų kategorijos kontekstas – kursų kategorijos visuose veiklos moduliuose ir kursuose prieinami klausimai * Sistemos kontekstas – klausimai, prieinami visuose svetainės Kategorijos kursuose ir veiklose, taip pat naudojami atsitiktiniams klausimams kaip iš konkrečios kategorijos parinkti klausimai.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Redaguoti kategoriją';
$string['editingcategory'] = 'Redaguojama kategorija';
$string['editingquestion'] = 'Redaguojamas klausimas';
$string['editquestion'] = 'Redaguoti klausimą';
$string['editquestions'] = 'Redaguoti klausimus';
$string['editthiscategory'] = 'Redaguoti šią kategoriją';
$string['emptyxml'] = 'Nežinoma klaida  –  tuščias imsmanifest.xml';
$string['enabled'] = 'Įjungta';
$string['erroraccessingcontext'] = 'Nepavyksta pasiekti konteksto';
$string['errordeletingquestionsfromcategory'] = 'Įvyko klaida naikinant klausimus iš kategorijos {$a}.';
$string['errorduringpost'] = 'Įvyko klaida atliekant baigiamąjį apdorojimą!';
$string['errorduringpre'] = 'Įvyko klaida atliekant išankstinį apdorojimą!';
$string['errorduringproc'] = 'Apdorojant įvyko klaida!';
$string['errorduringregrade'] = 'Klausimo įvertinti iš naujo {$a->qid} nepavyko, pereinamam į būseną {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Klaida: nepavyksta nukopijuoti failo {$a}.';
$string['errorfilecannotbemoved'] = 'Klaida: nepavyksta perkelti failo {$a}.';
$string['errorfileschanged'] = 'Klaida: nuo tada, kai buvo parodyta forma, iš klausimų susieti failai pasikeitė';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Klausimas ({$a}) rodomas daugiau nei vieną kartą su skirtingu svoriu skirtingose testo pozicijose. Šiuo metu statistikos ataskaita to nepalaiko, todėl šio klausimo statistika gali tapti nepatikima.';
$string['errormanualgradeoutofrange'] = 'Klausimo {$a->name} įvertinimas {$a->grade} nėra nuo 0 iki {$a->maxgrade}. Balai ir komentarai neįrašyti.';
$string['errormovingquestions'] = 'Įvyko klaida perkeliant klausimus, kurių ID {$a}.';
$string['errorpostprocess'] = 'Įvyko klaida atliekant baigiamąjį apdorojimą!';
$string['errorpreprocess'] = 'Įvyko klaida atliekant išankstinį apdorojimą!';
$string['errorprocess'] = 'Apdorojant įvyko klaida!';
$string['errorprocessingresponses'] = 'Įvyko klaida apdorojant Jūsų atsakymus ({$a}). Spauskite tęsti norėdami grįžti į puslapį, kuriame buvote ir pamėginti dar kartą.';
$string['errorsavingcomment'] = 'Įvyko klaida įrašant klausimo {$a->name} komentarą į duomenų bazę.';
$string['errorsavingflags'] = 'Saugant vėliavos būseną įvyko klaida.';
$string['errorupdatingattempt'] = 'Įvyko klaida bandant atnaujinti {$a->id} duomenų bazėje.';
$string['eventqbankdisabled'] = 'Klausimų banko papildinys išjungtas';
$string['eventqbankenabled'] = 'Klausimų banko papildinys įjungtas';
$string['eventquestioncategorycreated'] = 'Klausimo kategorija sukurta';
$string['eventquestioncategorydeleted'] = 'Klausimo kategorija panaikinta';
$string['eventquestioncategorymoved'] = 'Klausimo kategorija perkelta';
$string['eventquestioncategoryupdated'] = 'Klausimo kategorija atnaujinta';
$string['eventquestioncategoryviewed'] = 'Klausimo kategorija peržiūrėta';
$string['eventquestioncreated'] = 'Klausimas sukurtas';
$string['eventquestiondeleted'] = 'Klausimas panaikintas';
$string['eventquestionmoved'] = 'Klausimas perkeltas';
$string['eventquestionsexported'] = 'Klausimai eksportuoti';
$string['eventquestionsimported'] = 'Klausimai importuoti';
$string['eventquestionupdated'] = 'Klausimas atnaujintas';
$string['eventquestionviewed'] = 'Klausimas peržiūrėtas';
$string['export'] = 'Eksportuoti';
$string['exportasxml'] = 'Eksportuoti į Moodle XML';
$string['exportcategory'] = 'Eksportuoti kategoriją';
$string['exportcategory_help'] = 'Šis parametras nustato kategoriją, iš kurios bus imami eksportuojami klausimai. Tam tikri importavimo formatai, pvz., GIFT ir „Moodle“ XML, leidžia į eksportavimo failą įtraukti kategorijos ir konteksto duomenis, kurie gali (pasirinktinai) būti atkurti importuojant. Jei to reikia, turi būti pažymėti atitinkami žymės langeliai.';
$string['exporterror'] = 'Eksportuojant įvyko klaidų!';
$string['exportfilename'] = 'klausimai';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Atsisiųsti šį klausimą „Moodle XML“ formatu';
$string['exportquestions'] = 'Eksportuoti klausimus į failą';
$string['exportquestions_help'] = 'Ši funkcija įjungia visos klausimų kategorijos (ir subkategorijų) eksportavimą į failą. Atkreipkite dėmesį, kad atsižvelgiant į pasirinktą failo formatą kai kurių klausimų duomenų ir tam tikrų klausimų tipų eksportuoti negalima.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Grįžtamasis ryšys';
$string['fieldinquestion'] = '{$a->fieldname} {$a->questionindentifier}';
$string['fieldinquestionpre'] = '{$a->questionindentifier} {$a->fieldname}';
$string['filecantmovefrom'] = 'Klausimų failo perkelti negalima, nes neturite tesės perkelti failų iš vietos, iš kurios bandote perkelti klausimus.';
$string['filecantmoveto'] = 'Klausimų failo perkelti ar nukopijuoti negalima, nes neturite tesės įtraukti failų į vietą, į kurią bandote perkelti klausimus.';
$string['fileformat'] = 'Failo formatas';
$string['filesareacourse'] = 'kursų failų sritis';
$string['filesareasite'] = 'svetainės failų sritis';
$string['filestomove'] = 'Ar perkelti / kopijuoti failus į {$a}?';
$string['fillincorrect'] = 'Užpildykite teisingais atsakymais';
$string['filterbytags'] = 'Filtruoti pagal žymes...';
$string['firsttry'] = 'Pirmas bandymas';
$string['flagged'] = 'Pažymėta vėliavėlė';
$string['flagthisquestion'] = 'Pažymėti vėliavėlė šį klausimą';
$string['formquestionnotinids'] = 'Formoje buvo klausimas, kurio nėra tarp klausimų ID';
$string['fractionsnomax'] = 'Vieno iš atsakymų balas turi būti 100 %, kad būtų galima gauti visus šio klausimo balus.';
$string['generalfeedback'] = 'Bendras grįžtamasis ryšys';
$string['generalfeedback_help'] = 'Bendras atsakas yra rodomas visiems besimokantiesiems po to kai jie atsakė klausimą. Skirtingai nuo atsako, kuris priklauso nuo klausimo tipo ir ką atsakė besimokantysis, tas pats bendras atsakas yra rodomas visiems besimokantiesiems. Galite naudoti bendrą atsaką į klausimą, leisdami besimokantiesiems suprasti kokias žinias klausimas testavo, arba duoti nuorodą į platesnę informaciją kurią jie gali panaudoti, jei nesuprato klausimo.';
$string['getcategoryfromfile'] = 'Gauti kategoriją iš failo';
$string['getcontextfromfile'] = 'Gauti kontekstą iš failo';
$string['hintn'] = 'Užuomina {no}';
$string['hintnoptions'] = 'Užuominos {no} nuostatos';
$string['hinttext'] = 'Užuominos tekstas';
$string['howquestionsbehave'] = 'Kaip klausimai elgiasi';
$string['howquestionsbehave_help'] = 'Besimokantiejis gali sąveikauti su testų klausimais įvariais būdais. Pavyzdžiui, gal jūs norite, kad besimokantieji įvestų atsakymą kiekvienam klausimui ir tik tada užbaigtų testą, prieš parodant kokį grįžtamajį ryšį. Tai būtų "Atidėtas grįžtamasis ryšys". Kaip alternatyvą gal jūs norite, kad besimokantieji tik pateikę klausimo atsakymą gautų atgalinį ryšį. Tai būtų "Sąveikaujantis su keliais bandymais"';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID numeris';
$string['idnumber_help'] = 'Jei naudojamas, ID numeris turi būti unikalus kiekvienoje klausimų kategorijoje. Tai dar vienas kartais naudingas būdas atpažinti klausimą, bet paprastai gali būti paliktas tuščias.';
$string['ignorebroken'] = 'Nepaisyti neveikiančių saitų';
$string['import'] = 'Importuoti';
$string['importcategory'] = 'Importuoti į kategoriją';
$string['importcategory_help'] = 'Šis parametras nustato kategoriją, į kurią pateks importuoti klausimai. Tam tikri importavimo formatai, pvz., GIFT ir „Moodle“ XML, į importavimo failą gali įtraukti kategorijos ir konteksto duomenis. Norint naudoti šiuos duomenis, o ne pasirinktą kategoriją, turi būti pažymėti  atitinkami žymės langeliai. Jei importavimo faile nurodytų kategorijų nėra, jos bus sukurtos.';
$string['importerror'] = 'Importuojant įvyko klaida';
$string['importerrorquestion'] = 'Klaida importuojant klausimą';
$string['importfromcoursefiles'] = '... arba pasirinkite kurso failą importavimui.';
$string['importfromupload'] = 'Pasirinkite failą įkėlimui ...';
$string['importingquestions'] = 'Importuojami {$a} klausimai iš failo';
$string['importparseerror'] = 'Klaidos rastos nagrinėjant importuotą failą. Nei vienas klausimas nebuvo importuotas. Norėdami importuoti gerus klausimus pabandykite dar kartą, nustatydami \'Sustoti ties klaida\' į \'ne';
$string['importquestions'] = 'Importuoti klausimus iš failo';
$string['importquestions_help'] = 'Ši funkcija leidžia importuoti įvairių formatų klausimus naudojant tekstinį failą. Atkreipkite dėmesį, kad failo kodavimas turi būti UTF-8.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Pasirinktame faile nenaudojama UTF-8 simbolių koduotė. {$a} failai turi naudoti UTF-8.';
$string['importwrongfiletype'] = 'Jūsų pasirinktas failo tipas ({$a->actualtype}) neatitinka importuojamo formato tipo ({$a->expectedtype}).';
$string['impossiblechar'] = 'Negalimas simbolis {$a} aptiktas kaip skliaustas';
$string['includesubcategories'] = 'Taip pat rodyti klausimus iš subkategorijų';
$string['incorrect'] = 'Neteisinga';
$string['incorrectfeedback'] = 'Kiekvienam neteisingam atsakymui';
$string['incorrectfeedbackdefault'] = 'Jūsų atsakymas yra neteisingas.';
$string['information'] = 'Informacija';
$string['invalidanswer'] = 'Nepilnas atsakymas';
$string['invalidarg'] = 'Nepateikta galiojančių argumentų arba neteisingai sukonfigūruotas serveris';
$string['invalidcategoryidforparent'] = 'Neteisingas pirminio elemento kategorijos ID!';
$string['invalidcategoryidtomove'] = 'Neteisingas kategorijos ID norint perkelti!';
$string['invalidconfirm'] = 'Neteisinga patvirtinimo eilutė';
$string['invalidcontextinhasanyquestions'] = 'Į question_context_has_any_questions perduotas netinkamas kontekstas.';
$string['invalidgrade'] = 'Įvertinimai neatitinka vertinimo parinkčių - klausimas praleistas';
$string['invalidpenalty'] = 'Negaliojanti nuobauda';
$string['invalidwizardpage'] = 'Nurodytas netinkamas puslapio vedlys arba jo nėra!';
$string['lastmodifiedby'] = 'Paskutinį kartą modifikavo';
$string['lasttry'] = 'Paskutinis bandymas';
$string['linkedfiledoesntexist'] = 'Susieto failo {$a} nėra';
$string['makechildof'] = 'Kurti {$a} antrinį elementą';
$string['makecopy'] = 'Padaryti kopiją';
$string['maketoplevelitem'] = 'Perkelti į aukščiausią lygį';
$string['manualgradeinvalidformat'] = 'Tai yra neleistinas numeris.';
$string['manualgradeoutofrange'] = 'Šis įvertinimas yra neleistinose ribose.';
$string['manuallygraded'] = 'Rankinio būdo vertinimas {$a->mark} su komentaru: {$a->comment}';
$string['mark'] = 'Balas';
$string['markedoutof'] = 'Įvertinti iš';
$string['markedoutofmax'] = 'Įvertinti iš {$a}';
$string['markoutofmax'] = 'Balas {$a->mark} iš {$a->max}';
$string['marks'] = 'Balai';
$string['matchgrades'] = 'Atitinkantys įvertinimai';
$string['matchgrades_help'] = 'Importuoti įverčiai turi atitikti vieną iš fiksuotų sąrašų, sudarytų iš leistinų įverčių – 100, 90, 80, 75, 70, 66,666, 60, 50, 40, 33,333, 30, 25, 20, 16,666, 14,2857, 12,5, 11,111, 10, 5, 0 (taip pat neigiamos reikšmės). Jei ne, yra dvi parinktys: * Klaida, jei įverčio nėra sąraše, – jei klausime yra įverčių, kurių nėra sąraše, rodoma klaida ir tas klausimas neimportuojamas * Artimiausias įvertis, jei įverčio nėra sąraše, – jei randamas įvertis, kuris neatitinka sąrašo reikšmės, įvertis pakeičiamas artimiausia tinkama sąrašo reikšme.';
$string['matchgradeserror'] = 'Klaida jeigu pažymio nėra';
$string['matchgradesnearest'] = 'Artimiausias įvertinimas jeigu nėra išvardintas';
$string['missingcourseorcmid'] = 'Į print_question reikia pateikti kursų ID arba cmid.';
$string['missingcourseorcmidtolink'] = 'Į get_question_edit_link reikia pateikti kursų ID arba cmid.';
$string['missingimportantcode'] = 'Trūksta šio klausimo tipo svarbaus kodo: {$a}.';
$string['missingoption'] = 'Cloze klausime {$a} trūksta parinkčių';
$string['modified'] = 'Paskutinį kartą įrašyta';
$string['move'] = 'Perkelti iš {$a} ir keisti saitus.';
$string['movecategory'] = 'Perkelti kategoriją';
$string['movedquestionsandcategories'] = 'Klausimai ir klausimų kategorijos, perkeltos iš {$a->oldplace} į {$a->newplace}.';
$string['movelinksonly'] = 'Pakeisti tik vietas, kurias nurodo saitai, failų neperkelti ir nekopijuoti.';
$string['moveq'] = 'Perkelti klausimą (-us)';
$string['moveqtoanothercontext'] = 'Klausimą perkelti į kitą kontekstą';
$string['moveto'] = 'Perkelti į';
$string['movingcategory'] = 'Perkeliama kategorija';
$string['movingcategoryandfiles'] = 'Ar tikrai norite perkelti kategoriją {$a->name} ir antrines kategorijas į {$a->contextto} kontekstą?<br /> Aptikome su {$a->fromareaname} klausimais susietų failų: {$a->urlcount}. Ar šiuos failus norite kopijuoti į {$a->toareaname}, ar perkelti?';
$string['movingcategorynofiles'] = 'Ar tikrai norite perkelti kategoriją {$a->name} ir antrines kategorijas į {$a->contextto} kontekstą?';
$string['movingquestions'] = 'Perkeliami klausimai ir visi failai';
$string['movingquestionsandfiles'] = 'Ar  tikrai norite perkelti klausimą (-us) {$a->questions} į <strong>{$a->tocontext}</strong> kontekstą?<br /> {$a->fromareaname} aptikome su šiuo (-iais) klausimu (-ais) susietų <strong>failų: {$a->urlcount}</strong>. Ar šiuos failus norite perkelti į {$a->toareaname} ar kopijuoti?';
$string['movingquestionsnofiles'] = 'Ar tikrai norite perkelti klausimą (-us) {$a->questions} į <strong>{$a->tocontext}</strong> kontekstą?<br /> {$a->fromareaname} <strong>nėra</strong> su šiuo (-iais) klausimu (-ais) susijusių failų.';
$string['needtochoosecat'] = 'Turite pasirinkti kategoriją, į kurią perkelsite šį klausimą, arba paspausti Atšaukti.';
$string['nocate'] = 'Tokios kategorijos {$a} nėra!';
$string['noconditionspecified'] = 'Nurodykite sąlygą';
$string['nopermissionadd'] = 'Neturite teisės čia įtraukti klausimų.';
$string['nopermissionedit'] = 'Neturite leidimo redaguoti klausimų iš čia.';
$string['nopermissionmove'] = 'Neturite teisės iš čia perkelti klausimų. Turite klausimą įrašyti į šią kategoriją arba įrašyti kaip naują klausimą.';
$string['noprobs'] = 'Klausimų duomenų bazėje problemų nerasta.';
$string['noquestionbanks'] = 'Klausimų banko papildinys nerastas.';
$string['noquestions'] = 'Nerasta klausimų, kuriuos galima eksportuoti. Įsitikinkite, kad eksportavimui pasirinkote kategoriją turinčią klausimų.';
$string['noquestionsinfile'] = 'Faile, iš kurio importuojama, nėra klausimų';
$string['noresponse'] = '[Nėra atsako]';
$string['notagfiltersapplied'] = 'Netaikomi jokie žymių filtrai';
$string['notanswered'] = 'Neatsakyta';
$string['notchanged'] = 'Nebuvo pakeista nuo paskutinio bandymo';
$string['notenoughanswers'] = 'Šis klausimo tipas reikalauja bent {$a} atsakymų';
$string['notenoughdatatoeditaquestion'] = 'Nenurodytas nei klausimo ID, nei kategorijos ID, nei klausimo tipas.';
$string['notenoughdatatomovequestions'] = 'Turite pateikti norimų perkelti klausimų ID.';
$string['notflagged'] = 'Nepažymėta vėliavėle';
$string['notgraded'] = 'Neįvertinta';
$string['notshown'] = 'Neparodyta';
$string['notyetanswered'] = 'Neatsakyta';
$string['notyourpreview'] = 'Ši peržiūra Jums nepriklauso';
$string['novirtualquestiontype'] = 'Nėra klausimo tipo {$a} virtualaus klausim tipo';
$string['numqas'] = 'Klausimų bandymų skaičius';
$string['numquestions'] = 'Klausimų skaičius';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} paslėptas +{$a->numdraft} juodraštis)';
$string['options'] = 'Nustatymai';
$string['page-question-category'] = 'Klausimų kategorijų puslapis';
$string['page-question-edit'] = 'Klausimų redagavimo puslapis';
$string['page-question-export'] = 'Klausimų eksportavimo puslapis';
$string['page-question-import'] = 'Klausimų importavimo puslapis';
$string['page-question-x'] = 'Bet kurio klausimo puslapis';
$string['parent'] = 'Pirminis';
$string['parentcategory'] = 'Pirminė kategorija';
$string['parentcategory_help'] = 'Ši pirminė kategorija – tai kategorija, į kurią bus įtraukiama nauja kategorija. Viršutinė reiškia tai, kad ši kategorija nėra jokioje kitoje kategorijoje. Kategorijos kontekstas rodomas paryškintai. Kiekviename kontekste turi būti bent viena kategorija.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = '{$a}** prieš ** esantis skliaustas uždarytas netinkamai';
$string['parenthesisinproperstart'] = '{$a}** prieš ** esantis skliaustas atidarytas netinkamai';
$string['parsingquestions'] = 'Nagrinėjiami klausimai iš importuoto failo.';
$string['partiallycorrect'] = 'Iš dalies teisingas';
$string['partiallycorrectfeedback'] = 'Kiekvienam dalinai teisingam atsakymui';
$string['partiallycorrectfeedbackdefault'] = 'Jūsų atsakymas dalinai teisingas.';
$string['penaltyfactor'] = 'Baudos koeficientas';
$string['penaltyfactor_help'] = 'Šis parametras nustato, kokia surinktų balų dalis atimama už kiekvieną neteisingą atsakymą. Tai taikoma tik tada, jei testas atliekamas adaptyviuoju režimu. Baudos koeficientas turi būti nuo 0 iki 1. Baudos koeficientas 1 reiškia, kad besimokantysis, norėdamas gauti už atsakymą kreditų, turi pateikti teisingą atsakymą pirmu bandymu. Baudos koeficientas 0 reiškia, kad besimokantysis gali bandyti tiek kartų, kiek nori, ir vis tiek gaus visus balus.';
$string['penaltyforeachincorrecttry'] = 'Nuobauda už kiekvieną neteisingą bandymą';
$string['penaltyforeachincorrecttry_help'] = 'Kai klausimai vykdomi naudojant elgseną „Interaktyvus su keliais bandymais“ arba „Adaptuotas režimas“ elgseną, kad besikomantysis kelis kartus bandytų teisingai atsakyti, ši parinktis valdo, kiek jis bus baudžiamas už kiekvieną neteisingą bandymą.

Nuobauda yra viso klausimo įvertinimo dalis, taigi, jei klausimas yra vertas trijų balų, o nuobauda yra 0,3333333, tada studentas surinks 3 balus, jei teisingai atsakys pirmą kartą, 2, jei teisingai atsakys antrą kartą, ir 1 jei tai pavyksta trečiu bandymu.

Kai kuriems klausimams iš kelių dalių ši taškų skaičiavimo logika taikoma atskirai kiekvienai klausimo daliai. Išsami informacija priklauso nuo klausimo tipo ir gali būti sudėtinga, tačiau principas yra suteikti besimokantiesiems nuopelnus už jų parodytas žinias kuo sąžiningiau.';
$string['permissionedit'] = 'Redaguoti šį klausimą';
$string['permissionmove'] = 'Perkelti šį klausimą';
$string['permissionsaveasnew'] = 'Įrašyti kaip naują kausimą';
$string['permissionto'] = 'Turite teisę:';
$string['previewquestion'] = 'Peržiūrėti klausimą : {$a}';
$string['privacy:metadata:database:question'] = 'Išsami informacija apie konkretų klausimą.';
$string['privacy:metadata:database:question:createdby'] = 'Asmuo, kuris sukūrė klausimą.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Bendras šio klausimo atsiliepimas.';
$string['privacy:metadata:database:question:modifiedby'] = 'Asmuo, kuris paskutinį kartą atnaujino klausimą.';
$string['privacy:metadata:database:question:name'] = 'Klausimo pavadinimas';
$string['privacy:metadata:database:question:questiontext'] = 'Klausimo tekstas';
$string['privacy:metadata:database:question:timecreated'] = 'Šio klausimo sukūrimo data ir laikas.';
$string['privacy:metadata:database:question:timemodified'] = 'Šio atnaujinimo sukūrimo data ir laikas.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Klausimo bandymo žingsniai gali turėti papildomų duomenų, būdingų tam veiksmui. Duomenys saugomi lentelėje step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Duomenų elemento pavadinimas.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Duomenų elemento vertė.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Kiekvienas klausimo bandymas turi keletą žingsnių, nurodančių skirtingus etapus nuo pradžios iki užbaigimo iki vertinimo. Šioje lentelėje saugoma kiekvieno iš šių veiksmų informacija.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Įvertinimas, kuris buvo suteiktas už šį klausimą, buvo padidintas iki 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Šio klausimo bandymo žingsnio būsena pereinant žingsnį.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Data ir laikas, kada prasidėjo šis žingsnis.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Naudotojas, atlikęs žingsninį perėjimą.';
$string['privacy:metadata:database:question_attempts'] = 'Informacija apie bandymą atsakyti į konkretų klausimą.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Požymis, kad naudotojas šį klausimą pažymėjo bandydamas.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Atsakymo į klausimą santrauka.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Laikas, kai buvo atnaujintas bandymas pateikti klausimą.';
$string['privacy:metadata:database:question_bank_entries'] = 'Išsami informacija apie konkretų klausimų banko įrašą.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'Asmuo, kuriam priklauso klausimų banko įrašas.';
$string['privacy:metadata:link:qbehaviour'] = 'Klausimų posistemis naudoja įskiepio tipą Question Behavior.';
$string['privacy:metadata:link:qformat'] = 'Klausimų posistemė naudoja klausimų formato įskiepio tipą klausimams importuoti ir eksportuoti įvairiais formatais.';
$string['privacy:metadata:link:qtype'] = 'Klausimų posistemė sąveikauja su Klausimo tipo įskiepio tipu, kuriame pateikiami įvairūs klausimų tipai.';
$string['published'] = 'bendrai naudojama';
$string['qbanknotfound'] = 'Klausimų banko papildinio „{$a}“ nėra arba jis neatpažįstamas.';
$string['qtypeveryshort'] = 'T';
$string['question_version'] = 'Klausimo versija';
$string['questionaffected'] = '<a href="{$a->qurl}">Klausimas {$a->name} ({$a->qtype})</a> yra klausimų kategorijoje, bet taip pat naudojamas kitų kursų {$a->coursename} <a href="{$a->qurl}">teste {$a->quizname}</a>.';
$string['questionbank'] = 'Klausimų bankas';
$string['questionbanknavigation'] = 'Tretinė klausimų banko navigacija';
$string['questionbehaviouradminsetting'] = 'Klausimų elgsenos nustatymai';
$string['questionbehavioursdisabled'] = 'Klausimų elgsenos, kurias išjungti';
$string['questionbehavioursdisabledexplained'] = 'Išskleidžiamajame meniu įveskite kableliais atskirtą veiksmų, kurių nenorite, sąrašą.';
$string['questionbehavioursorder'] = 'Klausimų elgsenos tvarka';
$string['questionbehavioursorderexplained'] = 'Įveskite kableliais atskirtą veiksmų sąrašą tokia tvarka, kokia norite, kad jos būtų rodomos išskleidžiamajame meniu.';
$string['questioncategories'] = 'Klausimų kategorijos';
$string['questioncategory'] = 'Klausimų kategorija';
$string['questioncatsfor'] = '{$a} klausimų kategorijos';
$string['questiondoesnotexist'] = 'Tokio klausimo nėra';
$string['questionformtagheader'] = '{$a} žymės';
$string['questionidmismatch'] = 'Klausimų id nesutampa';
$string['questionloaderror'] = 'Nepavyko įkelti klausimo parinkčių.';
$string['questionname'] = 'Klausimo pavadinimas';
$string['questionnameandquestionversion'] = '{$a->name} v{$a->version}';
$string['questionnamecopy'] = '{$a} (kopija)';
$string['questionno'] = 'Klausimas {$a}';
$string['questionpreviewdefaults'] = 'Numatytieji klausimo peržiūros nustatymai';
$string['questionpreviewdefaults_desc'] = 'Šie numatytieji nustatymai naudojami, kai naudotojas pirmą kartą peržiūri klausimą klausimų banke. Kai naudotojas peržiūri klausimą, jo asmeninės nuostatos išsaugomos kaip naudotojo nuostatos.';
$string['questions'] = 'Klausimai';
$string['questionsaveerror'] = 'Įvyko klaidų įrašant klausimą – ({$a})';
$string['questionsinuse'] = '* Žymi klausimus, kurių negalima ištrinti, nes jie naudojami. Vietoj to, jie bus paslėpti klausimų banke, nebent pasirinksite „Rodyti senus klausimus“.';
$string['questionsmovedto'] = 'Vis dar naudojami klausimai perkelti į {$a}, į pirminę kursų kategoriją.';
$string['questionsrescuedfrom'] = 'Įrašyti klausimai iš konteksto {$a}.';
$string['questionsrescuedfrominfo'] = 'Panaikinus kontekstą {$a}, šie klausimai (kai kurie gali būti paslėpti) buvo įrašyti, nes jie vis dar naudojami kai kuriuose testuose ar kitose veiklose.';
$string['questiontags'] = 'Klausimo žymės';
$string['questiontext'] = 'Klausimo tekstas';
$string['questiontype'] = 'Klausimo tipas';
$string['questionuse'] = 'Naudoti klausimą šioje veikloje';
$string['questionvariant'] = 'Klausimo variantas';
$string['questionx'] = 'Klausimas {$a}';
$string['requiresgrading'] = 'Reikia vertinimo';
$string['responsehistory'] = 'Atsakymų istorija';
$string['restart'] = 'Pradėti iš naujo';
$string['restartwiththeseoptions'] = 'Išsaugoti peržiūros parinktis ir pradėti iš naujo';
$string['restoremultipletopcats'] = 'Atsarginiame faile yra daugiau nei viena aukščiausio lygio klausimų kategorija, skirta kontekstui {$a}.';
$string['reviewresponse'] = 'Peržiūrėti atsakymus';
$string['rightanswer'] = 'Teisingas atsakymas';
$string['rightanswer_help'] = 'Automatiškai sugeneruota teisingo atsakymo santrauka. Tai gali būti apribota, todėl galbūt norėsite paaiškinti teisingą sprendimą bendrajame klausimo atsiliepime ir išjungti šią parinktį.';
$string['save'] = 'Išsaugoti';
$string['savechangesandcontinueediting'] = 'Išsaugoti pakeitimus ir tęsti redagavimą';
$string['saved'] = 'Išsaugota: {$a}';
$string['saveflags'] = 'Įrašyti vėliavėlių būseną';
$string['selectacategory'] = 'Pasirinkite kategoriją:';
$string['selectaqtypefordescription'] = 'Norėdami peržiūrėti aprašą, pasirinkite klausimo tipą.';
$string['selectcategoryabove'] = 'Pasirinkti aukštesnę kategoriją';
$string['selectquestionsforbulk'] = 'Pasirinkti klausimus masiniams veiksmams atlikti';
$string['settingsformultipletries'] = 'Daugelis bandymų';
$string['shareincontext'] = 'Bendrai naudoti {$a} kontekste';
$string['shortversioninfo'] = 'v{$a->version} (iš {$a->latestversion})';
$string['shortversioninfolatest'] = 'v{$a->version} (naujausia)';
$string['showhidden'] = 'Rodyti paslėptus klausimus';
$string['showmarkandmax'] = 'Rodyti pažymį ir maksimumą';
$string['showmaxmarkonly'] = 'Rodyti tiktai maksimalų pažymį';
$string['shown'] = 'Rodoma';
$string['shownumpartscorrect'] = 'Rodyti teisingų atsakymų skaičių';
$string['shownumpartscorrectwhenfinished'] = 'Parodyti teisingų atsakymų kiekį kai klausimas bus baigtas';
$string['showquestiontext'] = 'Rodyti klausimo tekstą klausimų sąraše?';
$string['showquestiontext_full'] = 'Taip, su paveiksliukais, medija ir pan.';
$string['showquestiontext_off'] = 'Ne';
$string['showquestiontext_plain'] = 'Taip, tik tekstas';
$string['specificfeedback'] = 'Specifinis grįžtamasis ryšys';
$string['specificfeedback_help'] = 'Atsakas, kuris priklauso nuo besimokančiojo pateikto atsakymo';
$string['started'] = 'Pradėta';
$string['state'] = 'Būsena';
$string['step'] = 'Žingsnis';
$string['steps'] = 'Žingsniai';
$string['stoponerror'] = 'Stabdyti įvykus klaidai';
$string['stoponerror_help'] = 'Šis parametras nustato, ar importavimo procesas bus stabdomas aptikus klaidą ir nebus importuotas nė vienas klausimas, ar bus nepaisoma klausimų su klaidomis, o visi tinkami klausimai bus importuoti.';
$string['submissionoutofsequence'] = 'Informacijos išrinkimas ne iš sekos. Prašau nespausti mygtuko "atgal" kai dirbate su klausimynu.';
$string['submissionoutofsequencefriendlymessage'] = 'Įvesti duomenys neatitinka normalios sekos. Tai galėjo atsitikti dėl to kad panaudojote naršyklės Atgal arba Pirmyn mygtukus; prašome nenaudoti jų per testą. Taip pat tai galėjo atsitikti jei jūs kažką paspaudėte kol puslapis krovėsi. Spauskite <strong> Tęsti</strong> testo atnaujinimui.';
$string['submit'] = 'Pateikti';
$string['submitandfinish'] = 'Pateikti ir baigti';
$string['submitted'] = 'Pateikti: {$a}';
$string['tagarea_question'] = 'Klausimai';
$string['technicalinfo'] = 'Techninė informacija';
$string['technicalinfo_help'] = 'Ši techninė informacija ko gero yra naudinga tik kūrėjams dirbantiems su naujais klausimų tipais. Ji taip pat gali būti naudinga kuomet bandoma surasti problemas susijusias su klausimais.';
$string['technicalinfomaxfraction'] = 'Didžiausia trupmena: {$a}';
$string['technicalinfominfraction'] = 'Mažiausia trupmena: {$a}';
$string['technicalinfoquestionsummary'] = 'Klausimo santrauka: {$a}';
$string['technicalinforesponsesummary'] = 'Atsakymų santrauka: {$a}';
$string['technicalinforightsummary'] = 'Teisingo klausimo santrauka: {$a}';
$string['technicalinfostate'] = 'Klausimo būsena: {$a}';
$string['technicalinfovariant'] = 'Klausimo variantas: {$a}';
$string['tofilecategory'] = 'Įrašyti kategoriją į failą';
$string['tofilecontext'] = 'Įrašyti kontekstą į failą';
$string['topfor'] = 'Aukščiausia {$a}';
$string['uninstallbehaviour'] = 'Ištrinti šią klausimo elgseną.';
$string['uninstallqtype'] = 'Ištrinti šį klausimo tipą.';
$string['unknown'] = 'Nežinoma';
$string['unknownbehaviour'] = 'Nežinoma elgsena: {$a}.';
$string['unknownorunhandledtype'] = 'Nežinomas arba nenagrinėtas klausimo tipas: {$a}';
$string['unknownquestion'] = 'Nežinomas klausimas: {$a}.';
$string['unknownquestioncatregory'] = 'Nežinoma klausimo kategorija: {$a}.';
$string['unknownquestiontype'] = 'Nežinomas klausimo tipas: {$a}.';
$string['unknowntolerance'] = 'Nežinomas nuokrypio tipas {$a}';
$string['unpublished'] = 'bendrai nenaudojama';
$string['unusedcategorydeleted'] = 'Ši kategorija buvo ištrinta, nes ištrynus paskaitą, jos klausimai daugiau nebenaudojami.';
$string['updatedisplayoptions'] = 'Atnaujinti vaizdavimo nustatymus';
$string['upgradeproblemcategoryloop'] = 'Atnaujinant klausimų kategorijas aptikta problema. Kategorijų medyje yra ciklas. Paveiktų  kategorijų ID yra {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nepavyko atnaujinti klausimų kategorijos {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Atnaujinant klausimų kategorijas aptikta problema. Kategorija {$a->id} nurodo pirminę kategoriją {$a->parent}, kurios nėra. Norint išspręsti problemą, pirminė kategorija pakeista.';
$string['version_selection'] = 'Versija {$a->version}';
$string['versioninfo'] = 'Versija {$a->version} (iš {$a->latestversion})';
$string['versioninfolatest'] = 'Versija {$a->version} (naujausia)';
$string['whethercorrect'] = 'Ar teisingas';
$string['whethercorrect_help'] = 'Tai apima tekstinį aprašymą "Teisingas", "Iš dalies teisingas" arba "Neteisingas", ir bet kokios spalvos paryškinimą kuris perteikia tą pačią informaciją.';
$string['whichtries'] = 'Kuris bando';
$string['withselected'] = 'Su pasirinktais';
$string['wrongprefix'] = 'Netinkamai suformatuotas pavadinimo priešvardis {$a}';
$string['xoutofmax'] = '{$a->mark} iš {$a->max}';
$string['yougotnright'] = 'Jūs teisingai pasirinkę {$a->num}.';
$string['youmustselectaqtype'] = 'Turite pasirinkti klausimo tipą.';
$string['yourfileshoulddownload'] = 'Eksportavimo failas turi būti netrukus pradėtas atsisiųsti. Jei ne, <a href="{$a}">spustelėkite čia</a>.';
