<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_foundation', language 'af', version '4.3'.
 *
 * @package     theme_foundation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alertdanger'] = 'Gevaar';
$string['alertdark'] = 'Donker';
$string['alertinfo'] = 'Inligting';
$string['alertlight'] = 'Lig';
$string['alertpage'] = 'Waarskuwing {$a->number} bladsy';
$string['alertpagedesc'] = 'Vertoon waarskuwing {$a->number} op die gegewe bladsy of \'Alle\'.';
$string['alertprimary'] = 'Primêr';
$string['alertsecondary'] = 'Sekondêr';
$string['alertsettingheading'] = 'Waarskuwing {$a->number} verstellings';
$string['alertsheading'] = 'Waarskuwingverstellings';
$string['alertsheadingdesc'] = 'Stel die waarskuwingverstellings.';
$string['alertsuccess'] = 'Sukses';
$string['alerttext'] = 'Waarskuwing {$a->number} teks';
$string['alerttextdesc'] = 'Teks vir waarskuwing {$a->number}.';
$string['alerttitle'] = 'Waarskuwing {$a->number} titel';
$string['alerttitledesc'] = 'Titel van waarskuwing {$a->number}. As die titel leeg is, sal dit nie vertoon word nie, maar enige teks sal wel vertoon word.';
$string['alerttype'] = 'Waarskuwing {$a->number} tipe';
$string['alerttypedesc'] = 'Stel die geskikte waarksuwingstitel om jou gebruikers die beste in te lig.';
$string['alertwarning'] = 'Waarskuwing';
$string['asconfigintlower'] = '{$a->value} is minder as die onderste meetgrens van {$a->lower}';
$string['asconfigintnan'] = '{$a->value} is nie \'n getal nie';
$string['asconfigintupper'] = '{$a->value} is groter as die boonste meetgrens van {$a->upper}';
$string['backtotop'] = 'Terug na bo';
$string['brandiconname'] = 'Handelsmerkikoon {$a->number} naam';
$string['brandiconnamedesc'] = 'Ikoonnaam vir handelsmerk {$a->number}.';
$string['brandiconurl'] = 'Handelsmerkikoon {$a->number} URL';
$string['brandiconurldesc'] = 'URL vir handelsmerkikoon {$a->number}.';
$string['brandsettingheading'] = 'Handelsmerk {$a->number} verstellings';
$string['brandsheading'] = 'Handelsmerkikone-verstellings';
$string['brandsheadingdesc'] = 'Stel die handelsmerkikoon-verstellings. Die handelsmerkikoon se \'naam\' is - dit is die FontAwesome-naam sonder die prefiks \'fa-\', dus word \'fa-train\' net \'train\'. Afhangende van die \'fav\'-verstelling om gebruik van FontAwesome 5 te ontsper, kyk asseblief na \'<a href="//fontawesome.com/icons?d=gallery&s=brands&m=free" target="_blank">fontawesome.com/icons?d=gallery&s=brands&m=free</a>\' indien gestel, en \'<a href="//fontawesome.com/v4.7.0/icons/#brand" target="_blank">fontawesome.com/v4.7.0/icons/#brand</a>\' indien nie, vir die naam van die ikoon. Die tema sal die res met die klasname doen.';
$string['choosereadme'] = '<div class="clearfix">
<h2>Foundation</h2>
<h3>Inligting oor</h3>
<p>Foundation is \'n basiese tema.</p>
<h3>Temakrediete</h3>
<p>Outeur: G J Barnard<br>
Kontak: <a href="http://moodle.org/user/profile.php?id=442195">Moodle profile</a><br>
Webwerf: <a href="http://about.me/gjbarnard">about.me/gjbarnard</a>
</p>
<h3>Meer Inligting</h3>
<p><a href="foundation/Readme.md">How to use this theme.</a></p>
</div></div>';
$string['closedrawer'] = 'Maak laai toe';
$string['configtabtitle'] = 'Verstellings';
$string['configtitle'] = 'Foundation';
$string['coursesmenuheadingdesc'] = 'Konfigureer die verstellings van die kursuskieslys van Foundation hier.';
$string['coursesmenuheadingsub'] = 'Kursuskieslys-verstellings';
$string['customscss'] = 'Doelgemaakte SCSS';
$string['customscssdesc'] = 'Voeg doelgemaakte SCSS by die tema.';
$string['displayhiddenmycourses'] = 'Vertoon versteekte kursusse';
$string['displayhiddenmycoursesdesc'] = 'Vertoon versteekte kursusse vir gebruikers in die \'Kursuskieslys\' as hulle oor toestemming beskik om versteekte kursusse te besigtig.';
$string['displaymycourses'] = 'Vertoon kursusse';
$string['displaymycoursesdesc'] = 'Vertoon ingeskrewe kursusse vir gebruikers op die \'Navstafie\'.';
$string['enablealert'] = 'Waarskuwing {$a->number} ontsper';
$string['enablealertdesc'] = 'Ontsper of versper waarskuwing {$a->number}.';
$string['enablebrand'] = 'Handelsnaam {$a->number} ontsper';
$string['enablebranddesc'] = 'Ontsper of versper handelsnaam {$a->number}.';
$string['faiv'] = 'FontAwesome 5 Free w4 shims';
$string['faivdesc'] = 'Wanneer FontAwesome 5 Free vir die ikone gebruik word, voeg ondersteuning vir weergawe 4 ikoonklasname by.';
$string['fav'] = 'FontAwesome 5 Free';
$string['favdesc'] = 'Gebruik FontAwesome 5 Free vir ikone. Let wel: Sien asseblief die lisensie in die fontlêer van die tema.';
$string['favicon'] = 'Doelgemaakte favicon';
$string['favicondesc'] = 'Laai jou eie favicon op. Dit behoort \'n .ico-dokument te wees.';
$string['featuresheading'] = 'Funksies';
$string['featuresheadingdesc'] = 'Konfigureer die verstellings vir die funksies van Foundation hier.';
$string['featuresheadingsub'] = 'Funksieverstellings';
$string['footerantigravityhorizontaloffset'] = 'Anti-swaartekrag horisontale voorspanning op die skerm';
$string['footerantigravityhorizontaloffsetdesc'] = 'Stel die horisontale voorspanning van die anti-swaartekrag knoppies op die skerm (nie die navstafie nie) uit die verstek. Dit kan \'n positiewe (skuif regs) of negatiewe (skuif links) getal wees. Die eenhede is beeldelemente. Let wel: Keer hierdie logika om vir RTL-tale.';
$string['footerantigravityverticaloffset'] = 'Anti-swaartekrag vertikale voorspanning op die skerm';
$string['footerantigravityverticaloffsetdesc'] = 'Stel die vertikale voorspanning van die anti-swaartekrag knoppies op die skerm (nie die navstafie nie) uit die verstek. Dit kan \'n positiewe (skuif af) of negatiewe (skuif op) getal wees. Die eenhede is beeldelemente.';
$string['frontpagecarouselheading'] = 'Voorbladkarousel';
$string['frontpagecarouselheadingdesc'] = 'Konfigureer die verstellings van die voorbladkarousel van Foundation hier.';
$string['frontpagecarouselheadingsub'] = 'Voorbladkarousel-verstellings';
$string['frontpagecarouselslides'] = 'Voorbladskyfies';
$string['frontpagecarouselslidesdesc'] = 'Aantal voorbladskyfies tussen {$a->lower} en {$a->upper}. Ná verandering en \'Berg veranderinge\', verfris die bladsy.';
$string['frontpageenableslide'] = 'Voorbladskyfie {$a->number} ontsper';
$string['frontpageenableslidedesc'] = 'Ontsper of versper voorbladskyfie {$a->number}.';
$string['frontpageslidecaption'] = 'Voorbladskyfie {$a->number} onderskrif';
$string['frontpageslidecaptiondesc'] = 'Onderskrif vir voorbladskyfie {$a->number}.';
$string['frontpageslideimage'] = 'Voorbladskyfie {$a->number} prent';
$string['frontpageslideimagedesc'] = 'Prent vir voorbladskyfie {$a->number}.';
$string['frontpageslideno'] = 'Voorbladskyfie {$a->number}';
$string['frontpageslidenodesc'] = 'Voer die verstellings van voorbladskyfie {$a->number} in.';
$string['frontpageslidetitle'] = 'Voorbladskyfie {$a->number} titel';
$string['frontpageslidetitledesc'] = 'Titel van voorbladskyfie {$a->number}.';
$string['frontpageslideurl'] = 'Voorbladskyfieskakel {$a->number}';
$string['frontpageslideurldesc'] = 'Voer die teikenbestemming van voorbladskyfie {$a->number} prentskakel in';
$string['generalheading'] = 'Algemeen';
$string['generalheadingdesc'] = 'Konfigureer die algemene verstellings van Foundation hier.';
$string['generalheadingsub'] = 'Algemene verstellings';
$string['gotobottom'] = 'Gaan na onderkant van die bladsy';
$string['header'] = 'Hofie';
$string['headerbackground'] = 'Hofieagtergrond';
$string['headerbackgroundbottomcolour'] = 'Hofieagtergrond onderste kleur';
$string['headerbackgroundbottomcolourdesc'] = 'Stel die kleur van die teks van die onderkant van die hofie wanneer daar \'n agtergrond is. Voer \'-\' in om hierdie verstelling te ignoreer.';
$string['headerbackgroundbottomopacity'] = 'Hofieagtergrond onderste deursigtigheid.';
$string['headerbackgroundbottomopacitydesc'] = 'Hofieagtergrond onderste deursigtigheid wanneer daar \'n agtergrondprent is. Die kleur word gestel by die \'liggaam-bg\' SCSS-veranderlike.';
$string['headerbackgrounddesc'] = 'Hofieagtergrondprent.';
$string['headerbackgroundposition'] = 'Hofieagtergrondposisie';
$string['headerbackgroundpositiondesc'] = 'Kies die posisie van die opgelaaide prent.';
$string['headerbackgroundstyle'] = 'Hofieagtergrondstyl';
$string['headerbackgroundstyledesc'] = 'Kies die styl van die opgelaaide prent.';
$string['headerbackgroundtopcolour'] = 'Hofieagtergrond boonste kleur';
$string['headerbackgroundtopcolourdesc'] = 'Stel die kleur van die teks van die bokant van die hofie wanneer daar \'n agtergrond is. Voer \'-\' in om hierdie verstelling te ignoreer.';
$string['headerbackgroundtopopacity'] = 'Hofieagtergrond boonste deursigtigheid.';
$string['headerbackgroundtopopacitydesc'] = 'Hofieagtergrond boonste deursigtigheid wanneer daar \'n agtergrondprent is. Die kleur word gestel by die \'body-bg\' SCSS-veranderlike.';
$string['headerdesc'] = 'Hofiebeskrywing';
$string['headerheading'] = 'Hofie';
$string['headerheadingdesc'] = 'Konfigureer die hofieverstellings van Foundation hier.';
$string['headerheadingsub'] = 'Hofieverstellings';
$string['hvpcustomcss'] = 'H5P Doelgemaakte CSS';
$string['hvpcustomcssdesc'] = 'Doelgemaakte CSS vir die H5P-module.';
$string['hvpfontcss'] = 'H5P Font CSS';
$string['hvpfontcssdesc'] = 'Font CSS vir die H5P-module. Plaas die \'font-voorkant\'-verklarings hier met Moodle \'font:theme\'-sintaksis vir die URL en verseker dat die fontdokument in die tema-fontlêer is. Pas dan toe met CSS \'font-familie\'-verklarings in die H5P doelgemaakte CSS-verstelling.';
$string['hvpheading'] = 'H5P';
$string['hvpheadingdesc'] = 'Konfigureer die H5P-verstellings van Foundation hier. Dit tree slegs in werking as die H5P-module (moodle.org/plugins/mod_hvp) geïnstalleer is.';
$string['hvpheadingsub'] = 'H5P-verstellings';
$string['informationheading'] = 'Inligting';
$string['loginbackground'] = 'Intekenagtergrondprent';
$string['loginbackgrounddesc'] = 'Laai jou eie intekenagtergrondprent op. Kies die styl van die prent hieronder.';
$string['loginbackgroundheading'] = 'Intekenagtergrondprent-verstellings';
$string['loginbackgroundheadingdesc'] = 'Stel die intekenagtergrondprent-verstellings.';
$string['loginbackgroundopacity'] = 'Intekenboksagtergrond-deursigtigheid';
$string['loginbackgroundopacitydesc'] = 'Intekenagtergrond-deursigtigheid van die intekenboks wanneer daar \'n agtergrondprent is.';
$string['loginbackgroundstyle'] = 'Intekenagtergrond-styl';
$string['loginbackgroundstyledesc'] = 'Kies die styl van die opgelaaide prent.';
$string['moduleheading'] = 'Module';
$string['moduleheadingdesc'] = 'Konfigureer die moduleverstellings vir Foundation hier.';
$string['moduleheadingsub'] = 'Moduleverstellings';
$string['myclasses'] = 'My klasse';
$string['mycourses'] = 'My kursusse';
$string['mycoursesmax'] = 'Maks. kursusse';
$string['mycoursesmaxdesc'] = 'Stel hoeveel kursusse gelys moet word tussen {$a->lower} en {$a->upper}, waar \'{$a->lower}\' alle voorstel.';
$string['mycoursesorder'] = 'Kursusse volgorde';
$string['mycoursesorderdesc'] = 'Stel hoeveel kursusse gesorteer moet word. Die kursus sorteringsvolgorde kan  gestel word deur die kernnavigasieverstelling \'navsorteermykursusvolgorde\'.';
$string['mycoursesorderenrolbackcolour'] = 'Ingeskrewe en nie binnegegaande kursus-agtergrondkleur';
$string['mycoursesorderenrolbackcolourdesc'] = 'Die agtergrondkleur van ingeskrewe, maar nie binnegegaande kursusse. Vir wanneer \'mykursussevolgorde\' gestel is op \'Laaste binnegegaan ...\'.';
$string['mycoursesorderid'] = 'Kursus-ID';
$string['mycoursesorderidasc'] = 'Stygend';
$string['mycoursesorderiddes'] = 'Dalend';
$string['mycoursesorderidorder'] = 'Kursus-ID-volgorde';
$string['mycoursesorderidorderdesc'] = 'Kursus-ID-volgorde vir wanneer \'Kursus-ID\' gestel is as die \'Kursus-sorteringsvolgorde\'.';
$string['mycoursesorderlast'] = 'Laaste binnegegaande tyd of aanvangstyd van inskrywing indien nooit binnegegaan nie';
$string['mycoursesordersort'] = 'Kursus-sorteringsvolgorde';
$string['mycoursetitle'] = 'Terminologie';
$string['mycoursetitledesc'] = 'Verander die terminologie van die "My kursusse"-kieslystitel. Wanneer \'mykursussevolgorde\' gestel is op \'Laaste toegang verkry ...\' sal die woord \'nuutste\' bygevoeg word.';
$string['mylatestclasses'] = 'My nuutste klasse';
$string['mylatestcourses'] = 'My nuutste kursusse';
$string['mylatestmodules'] = 'My nuutste modules';
$string['mylatestunits'] = 'My nuutste eenhede';
$string['mymodules'] = 'My modules';
$string['myunits'] = 'My eenhede';
$string['navbarmenus'] = 'Navstafie-kieslyste';
$string['navbarposition'] = 'Navstafie-posisie';
$string['navbarpositiondesc'] = 'Stel die posisie van die navstafie.';
$string['noenrolments'] = 'Jy is tans nie ingeskryf nie';
$string['numberofalerts'] = 'Waarskuwings';
$string['numberofalertsdesc'] = 'Aantal waarskuwings tussen {$a->lower} en {$a->upper}. Nadat jy dit verander het, kliek op \'Berg veranderinge\' om jou gestelde hoeveelheid te kry.';
$string['numberofbrands'] = 'Handelsmerke';
$string['numberofbrandsdesc'] = 'Aantal handelsmerke tussen {$a->lower} en {$a->upper}. Nadat jy dit verander het, kliek op \'Berg veranderinge\' om jou gestelde hoeveelheid te kry.';
$string['opendrawer'] = 'Maak laai oop';
$string['pluginname'] = 'Foundation';
$string['prescss'] = 'Pre SCSS';
$string['prescssdesc'] = 'Stel die SCSS wat gebruik moet word voordat enige ander SCSS by die tema gevoeg word.';
$string['privacy:metadata:preference:collapseblock'] = 'Die toestand van die blokke op \'n bladsy.';
$string['privacy:metadata:preference:drawerclosed'] = 'Die toestand van die laai.';
$string['privacy:request:preference:collapseblock'] = 'Die gebruikersvoorkeur "{$a->name}" vir blok-id "{$a->blockid}" het die waarde "{$a->value}", wat "{$a->decoded}" vir die toestand van die blok voorstel.';
$string['privacy:request:preference:drawerclosed'] = 'Die gebruikersvoorkeur "{$a->name}" het die waarde "{$a->value}", wat "{$a->decoded}" vir die toestand van die laai voorstel.';
$string['privacynote'] = 'Let wel: Die Foundation-temageheue het verstellings wat betrekking het op die konfigurasie daarvan. Spesifieke gebruikersverstellings word in die \'Invoegtoepassing-privaatheidsbewaararea\' beskryf. Vir die ander verstellings is dit jou verantwoordelikheid om te verseker dat geen gebruikerdata in enige van die vryeteksvelde ingevoer is nie. Die stel van \'n verstelling sal tot gevolg hê dat daardie aksie binne die Moodle-logstelsel teen die gebruiker wat dit verander het gelog word; dit is buite die tema se beheer - sien asseblief die kernlogstelsel vir privaatheidvoldoening hiervan. Wanneer prente opgelaai word, moet jy vermy om prente op te laai met vasgelegde liggingdata (EXIF GPS) daar ingesluit, asook ander sulke persoonlike data. Dit sal moontlik wees om enige ligging-/persoonlike data uit die prente te haal. Ondersoek asseblief die kode noukeurig om te verseker dat dit voldoen aan jou interpretasie van jou privaatheidswetgewing. Ek is nie \'n prokureur nie en my analise is op my interpretasie gebaseer. As jy enige twyfel ervaar, verwyder onmiddellik die tema.';
$string['properties'] = 'Invoer-/uitvoerverstellings';
$string['propertiesdesc'] = 'In hierdie afdeling kan jy huidige Foundation-temaverstellings (eienskappe) in JSON-formaat invoer/uitvoer. Jy kan ook alle huidige verstellings op hierdie Moodle-installasie besigtig.';
$string['propertiesexport'] = 'Voer eienskappe as JSON-string uit.';
$string['propertiesproperty'] = 'Eienskap';
$string['propertiesreturn'] = 'Keer terug';
$string['propertiessub'] = 'Huidige temaverstellings';
$string['propertiesvalue'] = 'Waarde';
$string['putpropertiesadded'] = 'Bygevoeg:';
$string['putpropertieschanged'] = 'Verander:';
$string['putpropertiesdesc'] = 'Plak die JSON-string en \'Berg veranderinge\'. Waarskuwing! Valideer nie verstellingswaardes nie en voer \'n \'Skrap alle kasgeheue\' uit.';
$string['putpropertiesfrom'] = 'vanaf';
$string['putpropertiesheading'] = 'Voer temaverstellings in';
$string['putpropertiesignorecti'] = 'Alle kursustitelprent-verstellings word geïgnoreer.';
$string['putpropertiesignored'] = 'Geïgnoreer:';
$string['putpropertiesname'] = 'Voer eienskappe in';
$string['putpropertiesreportfiles'] = 'Onthou om die volgende dokumente na hul verstellings op te laai:';
$string['putpropertiessettingsreport'] = 'Verstellingsverslag:';
$string['putpropertiesunchanged'] = 'Onveranderd:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Ons';
$string['putpropertyproperties'] = 'Eienskappe';
$string['putpropertyreport'] = 'Verslag:';
$string['putpropertyversion'] = 'weergawe:';
$string['region-content'] = 'Inhoud';
$string['region-drawer'] = 'Laai';
$string['region-marketing'] = 'Bemarking';
$string['region-poster'] = 'Plakkaat';
$string['region-side-post'] = 'Links';
$string['region-side-pre'] = 'Regs';
$string['stylebottom'] = 'Onder';
$string['stylecenter'] = 'Middel';
$string['stylecontain'] = 'Bevat';
$string['stylecover'] = 'Bedek';
$string['styleleft'] = 'Links';
$string['styleright'] = 'Regs';
$string['stylestretch'] = 'Rek';
$string['styletop'] = 'Bo';
$string['swatch'] = 'Swatch';
$string['swatchcustomcolour'] = '{$a} kleur';
$string['swatchcustomcolourdesc'] = 'Stel die {$a} kleur. Voer \'-\' in om hierdie verstelling te ignoreer.';
$string['swatchcustomcolours'] = 'Swatch doelgemaakte kleure';
$string['swatchcustomcoloursdesc'] = 'Aktiveer doelgemaakte swatch-kleurverstellings.';
$string['swatchcustomcoloursheading'] = 'Swatch doelgemaakte kleure';
$string['swatchcustomcoloursheadingdesc'] = 'Konfigureer die doelgemaakte swatch-kleurverstellings vir Foundation hier.';
$string['swatchcustomcoloursheadingsub'] = 'Doelgemaakte swatch-kleurverstellings';
$string['swatchcustomfontsizebase'] = 'Fontgrootte-basis';
$string['swatchcustomfontsizebasedesc'] = 'Stel die basis-fontgrootte as \'n getal. Intern is eenhede \'rem\'.';
$string['swatchcustomlineheightbase'] = 'Lynhoogte-basis';
$string['swatchcustomlineheightbasedesc'] = 'Stel die basis-lynhoogte as \'n getal.';
$string['swatchcustomtypography'] = 'Swatch doelgemaakte tipografie';
$string['swatchcustomtypographydesc'] = 'Aktiveer doelgemaakte swatch-tipografieverstellings.';
$string['swatchcustomtypographyheading'] = 'Swatch doelgemaakte tipografie';
$string['swatchcustomtypographyheadingdesc'] = 'Konfigureer die doelgemaakte swatch-tipografieverstellings vir Foundation hier.';
$string['swatchcustomtypographyheadingsub'] = 'Doelgemaakte swatch-tipografieverstellings';
$string['swatchdesc'] = 'Kies die swatch vir die tema. \'n \'Swatch\' is \'n manier om die voorkoms van die tema te verander deur \'n voorafingestelde lys definisies te gebruik waaraan jy \'n naam toeken. Alle swatches (behalwe \'Seventies\' wat ek geskep het) is uit \'Bootswatch.com\' en onder die \'MIT-lisensie\' gelisensieer. Let wel: Die Google-font CDN\'e is verwyder weens beperkings met die PHP SCSS-samesteller en ek wil nie die komplikasies hê om die privaatheid ook by te werk nie.';
$string['swatchheading'] = 'Swatch';
$string['swatchheadingdesc'] = 'Konfigureer die swatch-verstellings vir Foundation hier.';
$string['swatchheadingsub'] = 'Swatch-verstellings';
$string['syntaxhighlightheading'] = 'Sintaksisbeligting-verstellings';
$string['syntaxhighlightheadingdesc'] = 'Stel die sintaksisbeligting-verstellings.';
$string['syntaxhighlightremoved'] = 'Sintaksisbeligting is verwyder';
$string['syntaxhighlightremoveddesc'] = 'Sintaksisbeligting-funksionaliteit in Foundation is verwyder. Gebruik asseblief eerder die \'<a href="https://moodle.org/plugins/filter_synhi" target="_blank">SynHi</a>\' filter.';
$string['themechanges'] = 'Veranderinge';
$string['themereadme'] = 'Leesmy';
$string['trio'] = 'Drie kolomme';
$string['triodesc'] = 'Gebruik drie in plaas van twee kolomme op twee-kolom bladsye. Die laaiblokarea tel nie as \'n \'kolom\' in hierdie terminologie nie. Let wel: Wanneer hierdie verstelling verander word, kan die blokarea(s) vreemd voorkom totdat die bladsy verfris word.';
$string['urltarget'] = 'Skakelteiken';
$string['urltargetdesc'] = 'Kies hoe die skakel oopgemaak moet word';
$string['urltargetnew'] = 'Nuwe bladsy';
$string['urltargetparent'] = 'Moederraam';
$string['urltargetself'] = 'Huidige bladsy';
