<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'af', version '4.3'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = '\'n Nuwe rol word bygevoeg';
$string['addrole'] = 'Voeg \'n nuwe rol by';
$string['advancedoverride'] = 'Gevorderde roloorheersing';
$string['allow'] = 'Laat toe';
$string['allowassign'] = 'Laat roltoekennings toe';
$string['allowed'] = 'Toegelaat';
$string['allowoverride'] = 'Laat roloorheersings toe';
$string['allowroletoassign'] = 'Laat gebruikers met rol {$a->fromrole} toe om die rol {$a->targetrole} toe te ken';
$string['allowroletooverride'] = 'Laat gebruikers met rol {$a->fromrole} toe om die rol {$a->targetrole} oorheen te skryf';
$string['allowroletoswitch'] = 'Laat gebruikers met rol {$a->fromrole} toe om rolle om te skakel na die rol {$a->targetrole}';
$string['allowroletoview'] = 'Laat gebruikers met rol {$a->fromrole} toe om die rol {$a->targetrole} te besigtig';
$string['allowswitch'] = 'Laat rolomskakelings toe';
$string['allowview'] = 'Laat rol om te beskou toe';
$string['allsiteusers'] = 'Alle werfgebruikers';
$string['analytics:listinsights'] = 'Lys insigte';
$string['analytics:listowninsights'] = 'Lys eie insigte';
$string['analytics:managemodels'] = 'Bestuur modelle';
$string['archetype'] = 'Rolargetipe';
$string['archetype_help'] = 'Die rolargetipe bepaal die toestemmings wanneer \'n rol na verstek teruggestel word. Dit bepaal ook enige nuwe toestemmings vir die rol wanneer die werf bygewerk word.';
$string['archetypecoursecreator'] = 'ARGETIPE: Kursusskepper';
$string['archetypeeditingteacher'] = 'ARGETIPE: Onderwyser (kan wysig)';
$string['archetypefrontpage'] = 'ARGETIPE: Gevalideerde gebruiker op voorblad';
$string['archetypeguest'] = 'ARGETIPE: Besoeker';
$string['archetypemanager'] = 'ARGETIPE: Bestuurder';
$string['archetypestudent'] = 'ARGETIPE: Student';
$string['archetypeteacher'] = 'ARGETIPE: Onderwyser (kan nie wysig nie)';
$string['archetypeuser'] = 'ARGETIPE: Gevalideerde gebruiker';
$string['assignanotherrole'] = 'Ken \'n ander rol toe';
$string['assignedroles'] = 'Toegewese rolle';
$string['assignerror'] = 'Fout met toekenning van die rol {$a->role} aan gebruiker {$a->user}.';
$string['assignglobalroles'] = 'Ken stelsel rolle toe';
$string['assignmentcontext'] = 'Toekenningskonteks';
$string['assignmentoptions'] = 'Toekenningsopsies';
$string['assignrole'] = 'Ken rol toe';
$string['assignrolenameincontext'] = 'Ken rol \'{$a->role}\' in {$a->context} toe';
$string['assignroles'] = 'Ken rolle toe';
$string['assignroles_help'] = 'Deur \'n rol aan \'n gebruiker in \'n konteks toe te ken, verleen jy aan hulle die toestemmings wat in daardie rol vervat word, vir die huidige konteks en alle laer kontekste. Byvoorbeeld: As \'n gebruiker die rol van \'n student in \'n kursus toegeken word, sal hulle ook die rol van student hê vir alle aktiwiteite en blokke binne die kursus.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Ken rolle toe in {$a}';
$string['assignrolesrelativetothisuser'] = 'Ken rolle relatief tot hierdie gebruiker toe';
$string['backtoallroles'] = 'Terug na die lys van alle rolle';
$string['backup:anonymise'] = 'Maak gebruikerdata met rugsteun anoniem';
$string['backup:backupactivity'] = 'Rugsteun aktiwiteite';
$string['backup:backupcourse'] = 'Rugsteun kursusse';
$string['backup:backupsection'] = 'Rugsteun afdelings';
$string['backup:backuptargetimport'] = 'Rugsteun vir invoer';
$string['backup:configure'] = 'Konfigureer rugsteunopsies';
$string['backup:downloadfile'] = 'Laai dokumente van rugsteunareas af';
$string['backup:userinfo'] = 'Rugsteun gebruikerdata';
$string['badges:awardbadge'] = 'Ken kenteken aan \'n gebruiker toe';
$string['badges:configurecriteria'] = 'Stel op/wysig kriteria om \'n kenteken te verdien';
$string['badges:configuredetails'] = 'Stel op/wysig kentekenbesonderhede';
$string['badges:configuremessages'] = 'Konfigureer kentekenbesonderhede';
$string['badges:createbadge'] = 'Skep/dupliseer kentekens';
$string['badges:deletebadge'] = 'Wis kentekens uit';
$string['badges:earnbadge'] = 'Verdien kenteken';
$string['badges:manageglobalsettings'] = 'Bestuur kentekens globale verstellings';
$string['badges:manageownbadges'] = 'Besigtig en bestuur eie verdiende kentekens';
$string['badges:revokebadge'] = 'Herroep kenteken van \'n gebruiker';
$string['badges:viewawarded'] = 'Besigtig gebruikers wat \'n spesifieke kenteken verdien het sonder om \'n kenteken te kan toeken';
$string['badges:viewbadges'] = 'Besigtig beskikbare kentekens sonder om daarvan te verdien';
$string['badges:viewotherbadges'] = 'Besigtig publieke kentekens in ander gebruikers se profiele';
$string['block:edit'] = 'Wysig \'n blok se verstellings';
$string['block:view'] = 'Besigtig blok';
$string['blog:create'] = 'Skep nuwe bloginskrywings';
$string['blog:manageentries'] = 'Wysig en bestuur inskrywings';
$string['blog:manageexternal'] = 'Wysig en bestuur eksterne blogs';
$string['blog:search'] = 'Deursoek bloginskrywings';
$string['blog:view'] = 'Besigtig bloginskrywings';
$string['blog:viewdrafts'] = 'Besigtig proef-bloginskrywings';
$string['calendar:manageentries'] = 'Bestuur enige kalenderinskrywings';
$string['calendar:managegroupentries'] = 'Bestuur groep-kalenderinskrywings';
$string['calendar:manageownentries'] = 'Bestuur eie kalenderinskrywings';
$string['capabilities'] = 'Vaardighede';
$string['capability'] = 'Vaardigheid';
$string['category:create'] = 'Skep kategorieë';
$string['category:delete'] = 'Wis kategorieë uit';
$string['category:manage'] = 'Bestuur kategorieë';
$string['category:update'] = 'Werk kategorieë by';
$string['category:viewcourselist'] = 'Besigtig kursuskategorie en kursusse daarbinne';
$string['category:viewhiddencategories'] = 'Sien versteekte kategorieë';
$string['category:visibility'] = 'Sien versteekte kategorieë';
$string['checkglobalpermissions'] = 'Kontroleer stelsel regte';
$string['checkpermissions'] = 'Kontroleer toestemmings';
$string['checkpermissionsin'] = 'Kontroleer toestemmings in {$a}';
$string['checksystempermissionsfor'] = 'Kontroleer stelsel regte vir {$a->fullname}';
$string['checkuserspermissionshere'] = 'Kontroleer toestemmings wat {$a->fullname} in hierdie {$a->contextlevel} het';
$string['chooseroletoassign'] = 'Kies asseblief \'n rol om toe te ken';
$string['cohort:assign'] = 'Voeg by en verwyder kohortlede';
$string['cohort:manage'] = 'Skep, wis uit en skuif kohorte';
$string['cohort:view'] = 'Besigtig werfwye kohorte';
$string['comment:delete'] = 'Wis kommentaar uit';
$string['comment:post'] = 'Plaas kommentaar';
$string['comment:view'] = 'Besigtig kommentaar';
$string['competency:competencygrade'] = 'Stel vaardigheidsgradering';
$string['competency:competencymanage'] = 'Bestuur vaardigheidsraamwerke';
$string['competency:competencyview'] = 'Besigtig vaardigheidsraamwerke';
$string['competency:coursecompetencyconfigure'] = 'Konfigureer kursusvaardigheidsverstellings';
$string['competency:coursecompetencygradable'] = 'Ontvang vaardigheidspunte';
$string['competency:coursecompetencymanage'] = 'Bestuur kursusvaardighede';
$string['competency:coursecompetencyview'] = 'Besigtig kursusvaardighede';
$string['competency:evidencedelete'] = 'Wis bewyse uit';
$string['competency:plancomment'] = 'Lewer kommentaar op \'n leerplan';
$string['competency:plancommentown'] = 'Lewer kommentaar op eie leerplan';
$string['competency:planmanage'] = 'Bestuur leerplanne';
$string['competency:planmanagedraft'] = 'Bestuur proef-leerplanne';
$string['competency:planmanageown'] = 'Bestuur eie leerplanne';
$string['competency:planmanageowndraft'] = 'Bestuur eie proef-leerplanne';
$string['competency:planrequestreview'] = 'Versoek hersiening van \'n leerplan';
$string['competency:planrequestreviewown'] = 'Versoek hersiening van eie leerplan';
$string['competency:planreview'] = 'Hersien \'n leerplan';
$string['competency:planview'] = 'Besigtig alle leerplanne';
$string['competency:planviewdraft'] = 'Besigtig proef-leerplanne';
$string['competency:planviewown'] = 'Besigtig eie leerplanne';
$string['competency:planviewowndraft'] = 'Besigtig eie proef-leerplanne';
$string['competency:templatemanage'] = 'Bestuur leerplantemplate';
$string['competency:templateview'] = 'Besigtig leerplantemplate';
$string['competency:usercompetencycomment'] = 'Lewer kommentaar op \'n gebruikersvaardigheid';
$string['competency:usercompetencycommentown'] = 'Lewer kommentaar op eie gebruikersvaardigheid';
$string['competency:usercompetencyrequestreview'] = 'Versoek hersiening van \'n gebruikersvaardigheid';
$string['competency:usercompetencyrequestreviewown'] = 'Versoek hersiening van eie gebruikersvaardigheid';
$string['competency:usercompetencyreview'] = 'Hersien \'n gebruikersvaardigheid';
$string['competency:usercompetencyview'] = 'Besigtig \'n gebruikersvaardigheid';
$string['competency:userevidencemanage'] = 'Bestuur bewys van vorige leer';
$string['competency:userevidencemanageown'] = 'Bestuur eie bewyse van vorige leer';
$string['competency:userevidenceview'] = 'Besigtig bewys van vorige leer van \'n gebruiker';
$string['confirmaddadmin'] = 'Wil jy regtig gebruiker <strong>{$a}</strong> as nuwe werfadministrateur byvoeg?';
$string['confirmdeladmin'] = 'Wil jy regtig gebruiker <strong>{$a}</strong> van die lys van werfadministrateurs verwyder?';
$string['confirmroleprevent'] = 'Wil jy regtig <strong>"{$a->role}"</strong> van die lys toegelate rolle vir vaardigheid "{$a->cap}" in konteks "{$a->context}" verwyder?';
$string['confirmroleunprohibit'] = 'Wil jy regtig <strong>"{$a->role}"</strong> van die lys verbode rolle vir vaardigheid "{$a->cap}" in konteks "{$a->context}" verwyder?';
$string['confirmunassign'] = 'Is jy seker jy wil hierdie rol van hierdie gebruiker verwyder?';
$string['confirmunassignno'] = 'Kanselleer';
$string['confirmunassigntitle'] = 'Bevestig rolverandering';
$string['confirmunassignyes'] = 'Verwyder';
$string['contentbank:access'] = 'Toegang tot die inhoudbank';
$string['contentbank:deleteanycontent'] = 'Wis enige inhoud uit die inhoudbank';
$string['contentbank:deleteowncontent'] = 'Wis inhoud uit eie inhoudbank';
$string['contentbank:downloadcontent'] = 'Laai inhoud van die inhoudbank af';
$string['contentbank:manageanycontent'] = 'Bestuur enige inhoud van die inhoudbank';
$string['contentbank:manageowncontent'] = 'Bestuur inhoud van eie inhoudbank';
$string['contentbank:upload'] = 'Laai nuwe inhoud op die inhoudbank';
$string['contentbank:useeditor'] = 'Skep of wysig inhoud met \'n inhoudtipe-wysiger';
$string['contentbank:viewunlistedcontent'] = 'Beskou ongelyste inhoud uit die inhoudbank';
$string['context'] = 'Konteks';
$string['course:activityvisibility'] = 'Versteek/vertoon aktiwiteite';
$string['course:bulkmessaging'] = 'Stuur \'n boodskap aan baie mense';
$string['course:changecategory'] = 'Verander kursuskategorie';
$string['course:changefullname'] = 'Verander kursusvolnaam';
$string['course:changeidnumber'] = 'Verander kursus-ID-nommer';
$string['course:changelockedcustomfields'] = 'Verander geslote doelgemaakte velde';
$string['course:changeshortname'] = 'Verander kursuskortnaam';
$string['course:changesummary'] = 'Verander kursusopsomming';
$string['course:configurecustomfields'] = 'Konfigureer doelgemaakte velde';
$string['course:configuredownloadcontent'] = 'Konfigureer aflaai van kursusinhoud';
$string['course:create'] = 'Skep kursusse';
$string['course:creategroupconversations'] = 'Skep groepgesprekke';
$string['course:delete'] = 'Wis kursusse uit';
$string['course:downloadcoursecontent'] = 'Laai kursusinhoud af';
$string['course:enrolconfig'] = 'Konfigureer inskryf-eksemplare in kursusse';
$string['course:enrolreview'] = 'Hersien kursusinskrywings';
$string['course:ignoreavailabilityrestrictions'] = 'Ignoreer beskikbare beperkings';
$string['course:ignorefilesizelimits'] = 'Gebruik dokumente groter as enige dokumentgroottebeperkings';
$string['course:isincompletionreports'] = 'Word op voltooiingsverslae vertoon';
$string['course:manageactivities'] = 'Bestuur aktiwiteite';
$string['course:managefiles'] = 'Bestuur dokumente';
$string['course:managegrades'] = 'Bestuur punte';
$string['course:managegroups'] = 'Bestuur groepe';
$string['course:managescales'] = 'Bestuur skale';
$string['course:markcomplete'] = 'Merk gebruikers as voltooid in kursusvoltooiing';
$string['course:movesections'] = 'Skuif afdelings';
$string['course:overridecompletion'] = 'Oorheers aktiwiteitvoltooiingstatus';
$string['course:recommendactivity'] = 'Beveel aktiwiteite in die aktiwiteitkieser aan';
$string['course:renameroles'] = 'Herbenoem rolle';
$string['course:request'] = 'Versoek nuwe kursusse';
$string['course:reset'] = 'Stel kursus terug';
$string['course:reviewotherusers'] = 'Hersien ander gebruikers';
$string['course:sectionvisibility'] = 'Beheer afdelingsigbaarheid';
$string['course:setcurrentsection'] = 'Stel huidige afdeling';
$string['course:setforcedlanguage'] = 'Dwing kursustaal';
$string['course:tag'] = 'Verander kursusmerkers';
$string['course:togglecompletion'] = 'Merk aktiwiteite per hand as voltooid';
$string['course:update'] = 'Werk kursusverstellings by';
$string['course:useremail'] = 'Aktiveer/Deaktiveer e-pos adres';
$string['course:view'] = 'Besigtig kursusse sonder deelname';
$string['course:viewcoursegrades'] = 'Beskou kursuspunte';
$string['course:viewhiddenactivities'] = 'Besigtig versteekte aktiwiteite';
$string['course:viewhiddencourses'] = 'Vertoon versteekte kursusse';
$string['course:viewhiddensections'] = 'Besigtig versteekte afdelings';
$string['course:viewhiddenuserfields'] = 'Besigtig versteekte gebruikervelde';
$string['course:viewparticipants'] = 'Beskou deelnemers';
$string['course:viewscales'] = 'Beskou skale';
$string['course:viewsuspendedusers'] = 'Besigtig opgeskorte gebruikers';
$string['course:visibility'] = 'Versteek/wys kursusse';
$string['createrolebycopying'] = 'Skep \'n nuwe rol deur {$a} te kopieer';
$string['createthisrole'] = 'Skep hierdie rol';
$string['currentcontext'] = 'Huidige konteks';
$string['currentrole'] = 'Huidige rol';
$string['customroledescription'] = 'Doelgemaakte beskrywing';
$string['customroledescription_help'] = 'Beskrywings van standaard rolle word outomaties gelokaliseer as die doelgemaakte beskrywing leeg is.';
$string['customrolename'] = 'Doelgemaakte volnaam';
$string['customrolename_help'] = 'Name van standaard rolle word outomaties gelokaliseer as die doelgemaakte naam leeg is. Jy moet \'n volnaam vir alle doelgemaakte rolle verskaf.';
$string['defaultrole'] = 'Verstek rol';
$string['defaultx'] = 'Verstek: {$a}';
$string['defineroles'] = 'Definieer rolle';
$string['deletecourseoverrides'] = 'Wis alle oorheersings in kursus uit';
$string['deletelocalroles'] = 'Wis alle plaaslike roltoekennings uit';
$string['deleterolesure'] = '<p>Is jy seker dat jy rol "{$a->name} ({$a->shortname})" wil uitwis?</p><p>Tans is hierdie rol toegeken aan {$a->count} gebruikers.</p>';
$string['deletexrole'] = 'Wis {$a} rol uit';
$string['duplicaterole'] = 'Dupliseer rol';
$string['duplicaterolesure'] = '<p>Is jy seker dat jy rol "{$a->name} ({$a->shortname})" wil dupliseer?</p>';
$string['editingrolex'] = 'Rol \'{$a}\' word gewysig';
$string['editrole'] = 'Wysig rol';
$string['editxrole'] = 'Wysig {$a} rol';
$string['errorbadrolename'] = 'Verkeerde rolnaam';
$string['errorbadroleshortname'] = 'Verkeerde rolkortnaam';
$string['errorexistsrolename'] = 'Rolnaam bestaan reeds';
$string['errorexistsroleshortname'] = 'Rolnaam bestaan reeds';
$string['errorroleshortnametoolong'] = 'Die kortnaam moet nie 100 karakters oorskry nie';
$string['eventcapabilityassigned'] = 'Vaardigheid is toegewys';
$string['eventcapabilityunassigned'] = 'Vaardigheid is nie toegewys nie';
$string['eventroleallowassignupdated'] = 'Laat roltoekennings toe';
$string['eventroleallowoverrideupdated'] = 'Laat roloorheersing toe';
$string['eventroleallowswitchupdated'] = 'Laat rolverandering toe';
$string['eventroleallowviewupdated'] = 'Laat rolbeskouing toe';
$string['eventroleassigned'] = 'Rol is toegewys';
$string['eventrolecapabilitiesupdated'] = 'Rolvaardighede is bygewerk';
$string['eventroledeleted'] = 'Rol is uitgewis';
$string['eventroleunassigned'] = 'Rol is nie toegewys nie';
$string['eventroleupdated'] = 'Rol is bygewerk';
$string['existingadmins'] = 'Huidige webwerf administrateurs';
$string['existingusers'] = '{$a} bestaande gebruikers';
$string['explanation'] = 'Verduideliking';
$string['export'] = 'Voer uit';
$string['extusers'] = 'Bestaande gebruikers';
$string['extusersmatching'] = 'Bestaande gebruikers wat pas by \'{$a}\'';
$string['filter:manage'] = 'Bestuur plaaslike filterverstellings';
$string['frontpageuser'] = 'Gevalideerde gebruiker op voorblad';
$string['frontpageuserdescription'] = 'Alle ingetekende gebruikers in die voorbladkursus.';
$string['globalrole'] = 'Stelselrol';
$string['globalroleswarning'] = 'WAARSKUWING! Enige rolle wat jy van hierdie bladsy af toeken, sal op die toegewese gebruikers regdeur die hele stelsel toepaslik wees, ook die voorblad en al die kursusse.';
$string['gotoassignroles'] = 'Gaan na Ken rolle vir hierdie {$a->contextlevel} toe';
$string['gotoassignsystemroles'] = 'Gaan na ken stelsel rolle toe';
$string['grade:edit'] = 'Wysig punte';
$string['grade:export'] = 'Voer punte uit';
$string['grade:hide'] = 'Versteek/onthul punte of items';
$string['grade:import'] = 'Voer punte in';
$string['grade:lock'] = 'Sluit punte of items';
$string['grade:manage'] = 'Bestuur puntitems';
$string['grade:managegradingforms'] = 'Bestuur gevorderde graderingsmetodes';
$string['grade:manageletters'] = 'Bestuur letterpunte';
$string['grade:manageoutcomes'] = 'Bestuur puntuitkomste';
$string['grade:managesharedforms'] = 'Bestuur gevorderde nasienvormtemplate';
$string['grade:override'] = 'Oorheers punte';
$string['grade:sharegradingforms'] = 'Deel gevorderde nasienvorm as \'n templaat';
$string['grade:unlock'] = 'Ontsluit punte of items';
$string['grade:view'] = 'Besigtig eie punte';
$string['grade:viewall'] = 'Besigtig punte van ander gebruikers';
$string['grade:viewhidden'] = 'Besigtig versteekte punte vir eienaar';
$string['h5p:deploy'] = 'Ontplooi H5P-inhoud';
$string['h5p:setdisplayoptions'] = 'Stel H5P-vertoonopsies';
$string['h5p:updatelibraries'] = 'Bestuur H5P-inhoudtipes';
$string['highlightedcellsshowdefault'] = 'Die toestemmings wat in die tabel hieronder belig word, is die verstek vir die rolargetipe wat tans hierbo geselekteer is.';
$string['highlightedcellsshowinherit'] = 'Die beligte selle in die tabel hieronder toon die toestemming (indien enige) wat oorgeërf sal word. Behalwe die vermoëns waarvan jy die toestemming wil verander, behoort jy alles op Geërf gestel te laat.';
$string['inactiveformorethan'] = 'onaktief vir langer as {$a->timeperiod}';
$string['ingroup'] = 'in die groep "{$a->group}"';
$string['inherit'] = 'Erf';
$string['invalidpresetfile'] = 'Ongeldige roldefinisiedokument';
$string['legacy:admin'] = 'ARGAïESE ROL: Administrateur';
$string['legacy:coursecreator'] = 'ARGAïESE ROL: Kursusskepper';
$string['legacy:editingteacher'] = 'ARGAïESE ROL: Onderwyser (kan wysig)';
$string['legacy:guest'] = 'ARGAïESE ROL: Besoeker';
$string['legacy:student'] = 'ARGAïESE ROL: Student';
$string['legacy:teacher'] = 'ARGAïESE ROL: Onderwyser (kan nie wysig nie)';
$string['legacy:user'] = 'ARGAïESE ROL: Gevalideerde gebruiker';
$string['legacytype'] = 'Argaïese roltipe';
$string['listallroles'] = 'Lys alle rolle';
$string['localroles'] = 'Plaaslik toegekende rolle';
$string['mainadmin'] = 'Hoofadministrateur';
$string['mainadminset'] = 'Stel hoofadmin';
$string['manageadmins'] = 'Bestuur webwerf administrateurs';
$string['manager'] = 'Bestuurder';
$string['managerdescription'] = 'Bestuurders kan kursusse binnegaan en wysig, maar gewoonlik nie daaraan deelneem nie.';
$string['manageroles'] = 'Bestuur rolle';
$string['maybeassignedin'] = 'Kontekstipes waar hierdie rol toegeken kan word';
$string['morethan'] = 'Meer as {$a}';
$string['multipleroles'] = 'Veelvuldige rolle';
$string['my:configsyspages'] = 'Konfigureer stelseltemplate vir Paneelbordbladsye';
$string['my:manageblocks'] = 'Bestuur paneelbordbladsyblokke';
$string['neededroles'] = 'Rolle met toestemming';
$string['nocapabilitiesincontext'] = 'Geen vermoëns in hierdie konteks beskikbaar nie';
$string['noneinthisx'] = 'Niks in hierdie {$a}';
$string['noneinthisxmatching'] = 'Geen gebruikers wat met \'{$a->search}\' in hierdie {$a->contexttype} ooreenstem nie';
$string['norole'] = 'Geen rol';
$string['noroleassignments'] = 'Hierdie gebruiker beskik oor geen roltoekennings op enige plek op hierdie werf nie.';
$string['noroles'] = 'Geen rolle';
$string['notabletoassignroleshere'] = 'Toekenning van rolle in hierdie konteks is nie deur \'n administrateur ontsper nie.';
$string['notabletooverrideroleshere'] = 'Jy kan nie die toestemming van enige rolle hier oorheers nie';
$string['notes:manage'] = 'Bestuur notas';
$string['notes:view'] = 'Besigtig notas';
$string['notset'] = 'Nie gestel nie';
$string['novisibleroles'] = 'Geen rolle nie';
$string['overrideanotherrole'] = 'Oorheers \'n ander rol';
$string['overridecontext'] = 'Oorheers konteks';
$string['overridepermissions'] = 'Oorheers toestemmings';
$string['overridepermissions_help'] = 'Oorheersing van toestemmings laat toe dat sekere vermoëns in \'n spesifieke konteks toegelaat of verhoed word.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Oorheers toestemmings vir rol \'{$a->role}\' in {$a->context}';
$string['overridepermissionsin'] = 'Ooheers toestemmings in {$a}';
$string['overrideroles'] = 'Oorheers rolle';
$string['overriderolesin'] = 'Oorheers rolle in {$a}';
$string['overrides'] = 'Oorheersings';
$string['overridesbycontext'] = 'Oorheersings (volgens konteks)';
$string['payment:manageaccounts'] = 'Bestuur rekeninge';
$string['payment:viewpayments'] = 'Besigtig betalings';
$string['permission'] = 'Toestemming';
$string['permission_help'] = 'Toestemmings is vermoëverstellings.Daar is 4 opsies:

* Nie gestel nie
* Laat toe - Toestemming vir die vermoë word gegee
* Verhoed - Toestemming vir die vermoë word verwyder, selfs al word dit in \'n hoër konteks toegelaat
* Verbied - Toestemming word heeltemal geweier en kan nie op enige laer (meer spesifieke) konteks oorheers word nie';
$string['permissions'] = 'Toestemmings';
$string['permissionsforuser'] = 'Toestemmings vir gebruiker';
$string['permissionsincontext'] = 'Toestemmings in {$a}';
$string['portfolio:export'] = 'Voer uit na portefeuljes';
$string['potentialusers'] = '{$a} potensiële gebruikers';
$string['potusers'] = 'Potensiële gebruikers';
$string['potusersmatching'] = 'Potensiële gebruikers wat met \'{$a}\' ooreenstem';
$string['prevent'] = 'Verhoed';
$string['privacy:metadata:preference:showadvanced'] = 'Hanteer die tokkel gevorderde modus-knoppie';
$string['privacy:metadata:role_assignments'] = 'Roltoekennings';
$string['privacy:metadata:role_assignments:component'] = 'Invoegtoepassing verantwoordelik vir roltoekenning, leeg wanneer handmatig toegewys.';
$string['privacy:metadata:role_assignments:itemid'] = 'Die ID van inskrywing/magtigingeksemplaar verantwoordelik vir hierdie roltoekenning';
$string['privacy:metadata:role_assignments:modifierid'] = 'Die ID van die gebruiker wat die roltoekenning geskep of gewysig het';
$string['privacy:metadata:role_assignments:roleid'] = 'Die ID van die rol';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Hierdie tabel berg die toegekende rolle in elke konteks.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Die datum waarop die roltoekenning geskep of gewysig is.';
$string['privacy:metadata:role_assignments:userid'] = 'Die ID van die gebruiker';
$string['privacy:metadata:role_capabilities'] = 'Rolvermoëns';
$string['privacy:metadata:role_capabilities:capability'] = 'Die naam van die vermoë';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Die ID van die gebruiker wat die vermoë geskep of gewysig het';
$string['privacy:metadata:role_capabilities:permission'] = 'Die toestemming vir \'n vermoë: erf, laat toe, verhoed of verbied.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Die ID van die rol';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Die vermoëns en oorheersvermoëns vir \'n spesifieke rol in \'n spesifieke konteks';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Die datum waarop die vermoë geskep of gewysig is.';
$string['privacy:metadata:role_cohortroles'] = 'Rolle om te groepeer';
$string['prohibit'] = 'Verbied';
$string['prohibitedroles'] = 'Verbied';
$string['question:add'] = 'Voeg nuwe vrae by';
$string['question:config'] = 'Konfigureer vraagtipes';
$string['question:editall'] = 'Wysig alle vrae';
$string['question:editmine'] = 'Wysig jou eie vrae';
$string['question:flag'] = 'Vlag vrae terwyl jy dit probeer';
$string['question:managecategory'] = 'Wysig vraagkategorieë';
$string['question:moveall'] = 'Skuif alle vrae';
$string['question:movemine'] = 'Skuif jou eie vrae';
$string['question:tagall'] = 'Merk alle vrae';
$string['question:tagmine'] = 'Merk jou eie vrae';
$string['question:useall'] = 'Gebruik alle vrae';
$string['question:usemine'] = 'Gebruik jou eie vrae';
$string['question:viewall'] = 'Besigtig alle vrae';
$string['question:viewmine'] = 'Besigtig jou eie vrae';
$string['rating:rate'] = 'Voeg graderings by items';
$string['rating:view'] = 'Besigtig die totale gradering wat jy ontvang het';
$string['rating:viewall'] = 'Besigtig alle rou graderings deur individue gegee';
$string['rating:viewany'] = 'Besigtig totale graderings wat enigiemand ontvang het';
$string['resetrole'] = 'Stel terug';
$string['resettingrole'] = 'Rol \'{$a}\' word teruggestel';
$string['restore:configure'] = 'Konfigureer terugstelopsies';
$string['restore:createuser'] = 'Skep gebruikers met herstel';
$string['restore:restoreactivity'] = 'Herstel aktiwiteite';
$string['restore:restorecourse'] = 'Herstel kursus';
$string['restore:restoresection'] = 'Herstel afdelings';
$string['restore:restoretargetimport'] = 'Herstel vanaf dokumente wat as invoer geteiken is';
$string['restore:rolldates'] = 'Toegelate rolaktiwiteit-konfigurasiedatums met herstel';
$string['restore:uploadfile'] = 'Laai dokumente op na rugsteunareas';
$string['restore:userinfo'] = 'Herstel gebruikerdata';
$string['restore:viewautomatedfilearea'] = 'Herstel kursusse vanaf outomatiese rugsteune';
$string['risks'] = 'Risiko\'s';
$string['role:assign'] = 'Ken rolle aan gebruikers toe';
$string['role:manage'] = 'Skep en bestuur rolle';
$string['role:override'] = 'Oorheers toestemmings vir ander';
$string['role:review'] = 'Hersien toestemmings vir ander';
$string['role:safeoverride'] = 'Oorheers veilige toestemmings vir ander';
$string['role:switchroles'] = 'Verander na ander rolle';
$string['roleallowheader'] = 'Laat rol toe:';
$string['roleallowinfo'] = 'Kies \'n rol om by die lys toegelate rolle in konteks "{$a->context}", vermoë "{$a->cap}" te voeg:';
$string['roleassignments'] = 'Roltoekennings';
$string['roledefinitions'] = 'Roldefinisies';
$string['rolefullname'] = 'Rolnaam';
$string['roleincontext'] = '{$a->role} in {$a->context}';
$string['roleprohibitheader'] = 'Verbied rol';
$string['roleprohibitinfo'] = 'Kies \'n rol om by die lys verbode rolle in konteks "{$a->context}", vermoë "{$a->cap}" te voeg:';
$string['rolerepreset'] = 'Gebruik rol-voorafinstelling';
$string['roleresetdefaults'] = 'Verstek';
$string['roleresetrole'] = 'Gebruik rol of argetipe';
$string['rolerisks'] = 'Rolrisiko\'s';
$string['roles'] = 'Rolle';
$string['roles_help'] = '\'n Rol is \'n versameling toestemmings wat vir die hele stelsel gedefinieer is, wat jy aan spesifieke gebruikers in spesifieke kontekste kan toewys.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Kies rol';
$string['rolesforuser'] = 'Rolle vir gebruiker {$a}';
$string['roleshortname'] = 'Kortnaam';
$string['roleshortname_help'] = 'Rolkortnaam is \'n laevlak-rolidentifiseerder waarin slegs ASCII-alfanumeriese karakters toegelaat word. Moet nie kortname van standaard rolle verander nie.';
$string['roletoassign'] = 'Rol om toe te ken';
$string['roletooverride'] = 'Rol om te oorheers';
$string['safeoverridenotice'] = 'Let wel: Vermoëns met hoër risiko\'s is gesluit, omdat jy slegs toegelaat word om veilige vermoëns te oorheers.';
$string['search:query'] = 'Voer werfwye soektogte uit';
$string['selectanotheruser'] = 'Kies \'n ander gebruiker';
$string['selectauser'] = 'Kies \'n gebruiker';
$string['selectrole'] = 'Kies \'n rol';
$string['showallroles'] = 'Vertoon alle rolle';
$string['showthisuserspermissions'] = 'Vertoon hierdie gebruiker se toestemmings';
$string['site:accessallgroups'] = 'Verkry toegang tot alle groepe';
$string['site:approvecourse'] = 'Keur kursusskepping goed';
$string['site:backup'] = 'Rugsteun kursusse';
$string['site:config'] = 'Verander werfkonfigurasie';
$string['site:configview'] = 'Besigtig die werfadministrasieboom (maar nie alle bladsye daarin nie)';
$string['site:deleteanymessage'] = 'Wis enige boodskappe op die werf uit';
$string['site:deleteownmessage'] = 'Wis boodskappe deur en aan die gebruiker gestuur, uit';
$string['site:doanything'] = 'Toegelaat om alles te doen';
$string['site:doclinks'] = 'Vertoon skakels na vanwerf-dokumente';
$string['site:forcelanguage'] = 'Oorheers kursustaal';
$string['site:import'] = 'Voer ander kursusse in \'n kursus in';
$string['site:maintenanceaccess'] = 'Gaan werf binne terwyl in onderhoudsmodus';
$string['site:manageallmessaging'] = 'Voeg by, verwyder, blok en ontblok kontakte vir enige gebruiker';
$string['site:manageblocks'] = 'Bestuur blokke op \'n bladsy';
$string['site:managecontextlocks'] = 'Bestuur die vries van kontekste';
$string['site:messageanyuser'] = 'Omseil gebruikerprivaatheidsvoorkeure vir die stuur van boodskappe aan enige gebruiker';
$string['site:mnetloginfromremote'] = 'Teken in vanaf \'n afstandstoepassing via MNet';
$string['site:mnetlogintoremote'] = 'Beweeg na \'n afstandstoepassing vir MNet';
$string['site:readallmessages'] = 'Lees alle boodskappe op werf';
$string['site:restore'] = 'Herstel kursus';
$string['site:senderrormessage'] = 'Stuur \'n boodskap aan die ondersteuningsgebruiker vanaf die foutblad';
$string['site:sendmessage'] = 'Stuur boodskappe aan enige gebruiker';
$string['site:trustcontent'] = 'Vertrou ingediende inhoud';
$string['site:uploadusers'] = 'Laai nuwe gebruikers vanaf dokument op';
$string['site:viewanonymousevents'] = 'Beskou anonieme gebeure in verslae';
$string['site:viewfullnames'] = 'Sien altyd volle name van gebruikers';
$string['site:viewparticipants'] = 'Besigtig deelnemers';
$string['site:viewreports'] = 'Besigtig verslae';
$string['site:viewuseridentity'] = 'Sien volledige gebruikeridentiteit in lyste';
$string['siteadministrators'] = 'Webwerf administrateurs';
$string['tag:edit'] = 'Wysig bestaande merkers';
$string['tag:editblocks'] = 'Wysig blokke in merkers bladsye';
$string['tag:flag'] = 'Vlag merkers as onvanpas';
$string['tag:manage'] = 'Bestuur alle merkers';
$string['thisnewrole'] = 'Hierdie nuwe rol';
$string['thisusersroles'] = 'Hierdie gebruiker se roltoekennings';
$string['unassignarole'] = 'Kanselleer toewysing van rol {$a}';
$string['unassignconfirm'] = 'Wil jy regtig toewysing van rol "{$a->role}" aan gebruiker "{$a->user}" kanselleer?';
$string['unassignerror'] = 'Fout met kansellasie van roltoewysing {$a->role} van gebruiker {$a->user}.';
$string['user:changeownpassword'] = 'Verander eie wagwoord';
$string['user:create'] = 'Skep gebruikers';
$string['user:delete'] = 'Wis gebruikers uit';
$string['user:editmessageprofile'] = 'Wysig gebruikerboodskapprofiel';
$string['user:editownmessageprofile'] = 'Wysig eie gebruikerboodskapprofiel';
$string['user:editownprofile'] = 'Wysig eie gebruikerprofiel';
$string['user:editprofile'] = 'Wysig gebruikerprofiel';
$string['user:ignoreuserquota'] = 'Ignoreer gebruikerkwotabeperking';
$string['user:loginas'] = 'Teken in as ander gebruikers';
$string['user:manageblocks'] = 'Bestuur blokke op gebruikersprofiel van ander gebruikers';
$string['user:manageownblocks'] = 'Bestuur blokke op eie publieke gebruikersprofiel';
$string['user:manageownfiles'] = 'Bestuur dokumente op eie private dokumentareas';
$string['user:managesyspages'] = 'Konfigureer verstek bladsyuitleg vir publieke gebruikersprofiele';
$string['user:readuserblogs'] = 'Besigtig alle gebruikerblogs';
$string['user:readuserposts'] = 'Besigtig alle gebruikerforumplasings';
$string['user:update'] = 'Werk gebruikerprofiele by';
$string['user:viewalldetails'] = 'Besigtig gebruiker se volledige inligting';
$string['user:viewdetails'] = 'Besigtig gebruikerprofiele';
$string['user:viewhiddendetails'] = 'Besigtig versteekte besonderhede van gebruikers';
$string['user:viewlastip'] = 'Besigtig gebruiker se laaste IP-adres';
$string['user:viewuseractivitiesreport'] = 'Sien gebruiker se aktiwiteitverslae';
$string['user:viewusergrades'] = 'Besigtig gebruikerpunte';
$string['usersfrom'] = 'Gebruikers vanaf {$a}';
$string['usersfrommatching'] = 'Gebruikers vanaf {$a->contextname} wat pas by \'{$a->search}\'';
$string['usersinthisx'] = 'Gebruikers in hierdie {$a}';
$string['usersinthisxmatching'] = 'Gebruikers in hierdie {$a->contexttype} wat pas by \'{$a->search}\'';
$string['userswithrole'] = 'Alle gebruikers met \'n rol';
$string['userswiththisrole'] = 'Gebruikers met rol';
$string['useshowadvancedtochange'] = 'Gebruik \'Vertoon gevorderd\' om te verander';
$string['viewingdefinitionofrolex'] = 'Die definisie van rol \'{$a}\' word besigtig';
$string['viewrole'] = 'Besigtig rolbesonderhede';
$string['webservice:createmobiletoken'] = 'Skep \'n webdiensteken vir mobiele toegang';
$string['webservice:createtoken'] = 'Skep \'n webdiensteken';
$string['webservice:managealltokens'] = 'Bestuur alle gebruikers se webdienstekens';
$string['whydoesuserhavecap'] = 'Waarom beskik {$a->fullname} oor vermoë {$a->capability} in konteks {$a->context}?';
$string['whydoesusernothavecap'] = 'Waarom beskik {$a->fullname} nie oor vermoë {$a->capability} in konteks {$a->context} nie?';
$string['xroleassignments'] = '{$a} se roltoekennings';
$string['xuserswiththerole'] = 'Gebruikers met die rol "{$a->role}"';
