<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'es_mx', version '4.3'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acessar'] = 'Access Course';
$string['background_color'] = 'Color del fondo';
$string['background_color_black'] = 'Tema Negro {$a}';
$string['background_color_blue'] = 'Tema Azul {$a}';
$string['background_color_default'] = 'Tema por defecto {$a}';
$string['background_color_desc'] = '¡Color de sprite!';
$string['background_color_green'] = 'Tema Verde {$a}';
$string['background_color_random'] = 'Tema Aleatorio {$a}';
$string['background_color_red'] = 'Tema Rojo {$a}';
$string['choosereadme'] = '';
$string['contact_address'] = 'Address';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Phone Number';
$string['content_pagefonts'] = 'Fuentes Extra de Google';
$string['content_pagefonts_desc'] = 'Agrega aquí el enlace @import de Google para fuentes adicionales.<br>Puedes poner múltiples importaciones.<br><a href="https://fonts.google.com/selection/embed" target="google">Código de inserción</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle default';
$string['content_type_empty'] = '(No content)';
$string['content_type_footer'] = 'Content type for footer';
$string['content_type_footer_desc'] = 'Select the type of content you want to display in the footer.';
$string['content_type_home'] = 'Content type for homepage';
$string['content_type_home_desc'] = 'Select the type of content you want to display on the homepage.';
$string['content_type_html'] = 'Page to be created with editor';
$string['continuar'] = 'Continue studying';
$string['countlesson'] = '{$a} lesson';
$string['countlessons'] = '{$a} lessons';
$string['customcss'] = 'CSS personalizado';
$string['customcss_desc'] = 'Todas las reglas CSS que añada a esta área_de_texto se reflejarán en todas las páginas, haciendo más facil el personalizar este tema.';
$string['custommenuitems'] = 'Elementos de menú personalizados';
$string['custommenuitems_desc'] = 'Puedes crear un menú personalizado junto a los menús superiores. El menú raíz debe comenzar al ras con el borde, y los submenús deben ir precedidos por un guión (-). El número de guiones determina la profundidad del elemento. Así, los elementos con un solo guión aparecen en un submenú debajo del elemento de nivel superior anterior, y los elementos con dos guiones aparecen en un submenú debajo del submenú anterior.
El contenido de cada elemento de menú debe consistir en hasta tres elementos (<strong>etiqueta</strong> | <strong>URL</strong> | <strong>tooltip</strong> | <strong>idioma</strong>), cada uno separado por el carácter "|".
<ul>
<li><strong>etiqueta</strong>: Este es el texto que se mostrará dentro del elemento de menú. Debes especificar una etiqueta para cada elemento de menú.</li>
<li><strong>URL</strong>: Esta es la URL a la que el usuario será llevado al hacer clic en el elemento de menú. Esto es opcional; si no se proporciona, el elemento no estará enlazado a ningún lugar.<br>
Se pueden agregar otros atributos como "target" al final de la URL.</li>
<li><strong>tooltip</strong>: Si proporcionas una URL, también puedes elegir proporcionar un tooltip para el enlace creado con la URL. Esto es opcional, y si no se define, se usará la etiqueta como tooltip para el elemento de menú.</li>
<li><strong>idioma</strong>: Puedes agregar un código de idioma (o una lista separada por comas de códigos) como el cuarto elemento de la línea. La línea se mostrará solo si el usuario ha seleccionado el/los idioma(s) listado(s).</li>
</ul>
A continuación, se muestra un ejemplo de cómo crear un menú personalizado:
<blockquote><pre>
Cursos
-Todos los cursos | /curso/
-Mis cursos
--Curso de ejemplo
---Curso de ejemplo 7 | /curso/ver.php?id=7
---Curso de ejemplo 9 | /curso/ver.php?id=9
--Curso de prueba
---Curso de prueba 2 | /curso/ver.php?id=2
---Curso de prueba 5 | /curso/ver.php?id=5
Google
-Google en cualquier idioma | https://google.com/" target="_blank
-Google en México | https://www.google.com.mx/" target="_blank|Etiqueta de Google|en
-Google en portugués | https://google.com.br/" target="_blank|Etiqueta de Google|pt,pt_br,pt_br_kids
Página de soporte | https://support.com/" target="_blank
</pre></blockquote>
Para Moodle con soporte para múltiples idiomas, el valor de <strong>etiqueta</strong> debe formatearse como <strong>"nombredelacadenaidioma,nombre del componente"</strong>.
<blockquote><pre>
perfil,moodle | /usuario/perfil.php
mensajes,mensaje | /mensaje/índice.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Configuración_avanzada_de_temas" target="_blank">Más información del menú</a>';
$string['editor_link_footer'] = 'Edit the footer block for {$a} language';
$string['editor_link_footer_all'] = 'Edit the footer block for all languages';
$string['editor_link_home'] = 'Edit the homepage for {$a} language';
$string['editor_link_home_all'] = 'Edit the homepage for all languages';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Cambiar el favicon del tema. Una imagen .png con fondo transparente y altura de 32 pixeles funcionará mejor.';
$string['fontfamily'] = 'Site Font';
$string['fontfamily_desc'] = 'Choose which font you want to use on your Moodle';
$string['fontfamily_menus'] = 'Fuentes del menú';
$string['fontfamily_menus_desc'] = 'Elige la fuente que deseas utilizar para los menús en tu sitio Moodle.';
$string['fontfamily_sitename'] = 'Fuente para el nombre del sitio';
$string['fontfamily_sitename_desc'] = 'La fuente que se aplicará al nombre del sitio si no se proporciona un logotipo.';
$string['fontfamily_title'] = 'Fuentes del texto del título';
$string['fontfamily_title_desc'] = 'Elige la fuente que deseas utilizar para los títulos en tu sitio Moodle.';
$string['fontpreview'] = 'Vista previa de lista de fuentes';
$string['footer_contact_title'] = 'Contact Block Title';
$string['footer_contact_title_default'] = 'Contact us';
$string['footer_contact_title_desc'] = 'Enter the title of the block that will appear in the footer with the contact details.';
$string['footer_description'] = 'Description';
$string['footer_description_desc'] = 'Describe your Moodle, what you do, and this information will be shown below the logo in the Moodle footer';
$string['footer_frontpage_blockcourses_instructor'] = 'Show Professor\'s name';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'If checked, shows the names of professors in the course list!';
$string['footer_frontpage_blockcourses_text'] = 'Short text explaining the "{$a}" block';
$string['footer_frontpage_blockcourses_text_desc'] = 'Add a text talking about "{$a}"!';
$string['footer_links_title'] = 'Links Block Title';
$string['footer_links_title_default'] = 'Important Links';
$string['footer_show_copywriter'] = 'Show Made with ❤️';
$string['footer_show_copywriter_desc'] = 'Uncheck if you want to hide the "Made with ❤️"';
$string['footer_social_title'] = 'Social Links Block Title';
$string['footer_social_title_default'] = 'Follow us on social media';
$string['footer_social_title_desc'] = 'Enter the title of the block that will appear in the footer with the data from your social networks.';
$string['footerblink'] = 'Footer Block Links';
$string['footerblink_desc'] = 'You can configure a Footer Block Links here to be shown by themes.<br>Each line consists of some menu text or language key or text, a link URL (optional), separated by vertical bars. For example:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Contact block';
$string['footerblock_copywriter'] = 'Made with ❤️';
$string['footerblock_description'] = 'Description block';
$string['footerblock_links'] = 'Links block';
$string['footerblock_social'] = 'Social block';
$string['free_name'] = 'Free';
$string['frontpage_about_description'] = 'Describe what you do';
$string['frontpage_about_description_desc'] = 'Describe in a maximum of 5 lines the purpose of your Moodle';
$string['frontpage_about_enable'] = 'Enable About block';
$string['frontpage_about_enable_desc'] = 'If checked, the About Block will appear below the Banner!';
$string['frontpage_about_info'] = 'Data box {$a}';
$string['frontpage_about_logo'] = 'Different logo to be shown here';
$string['frontpage_about_logo_desc'] = 'If set, this logo will be used here instead of the Top logo.<br>
Blank uses the Top Logo!';
$string['frontpage_about_number'] = 'Amount of data';
$string['frontpage_about_number_desc'] = 'Enter the amount of information mentioned above';
$string['frontpage_about_text'] = 'Data name';
$string['frontpage_about_text_1_defalt'] = 'Courses';
$string['frontpage_about_text_2_defalt'] = 'Teachers';
$string['frontpage_about_text_3_defalt'] = 'Students';
$string['frontpage_about_text_4_defalt'] = 'Lessons';
$string['frontpage_about_text_desc'] = 'Enter the name of the data to be shown on the home';
$string['frontpage_about_title'] = 'About block title';
$string['frontpage_about_title_default'] = 'Our Global Community';
$string['grapsjs-assetmanager-addbutton'] = 'Add image';
$string['grapsjs-assetmanager-modaltitle'] = 'Select image';
$string['grapsjs-assetmanager-uploadtitle'] = 'Drop files here or click to upload';
$string['grapsjs-attachment'] = 'Attachment';
$string['grapsjs-clear'] = 'Clear Canvas';
$string['grapsjs-confirm_clear'] = 'Are you sure you want to clear the canvas?';
$string['grapsjs-decoration'] = 'Decorations';
$string['grapsjs-devicemanager-device'] = 'Device';
$string['grapsjs-devicemanager-devices-desktop'] = 'Desktop';
$string['grapsjs-devicemanager-devices-mobilelandscape'] = 'Mobile, Landscape mode';
$string['grapsjs-devicemanager-devices-mobileportrait'] = 'Mobile, Portrait mode';
$string['grapsjs-devicemanager-devices-tablet'] = 'Tablet';
$string['grapsjs-dimensions'] = 'Dimensions';
$string['grapsjs-domcomponents-names-'] = 'Box';
$string['grapsjs-domcomponents-names-body'] = 'Body';
$string['grapsjs-domcomponents-names-cell'] = 'Table Cell';
$string['grapsjs-domcomponents-names-comment'] = 'Comment';
$string['grapsjs-domcomponents-names-image'] = 'Image';
$string['grapsjs-domcomponents-names-label'] = 'Label';
$string['grapsjs-domcomponents-names-link'] = 'Link';
$string['grapsjs-domcomponents-names-map'] = 'Map';
$string['grapsjs-domcomponents-names-row'] = 'Table Row';
$string['grapsjs-domcomponents-names-section'] = 'Section';
$string['grapsjs-domcomponents-names-table'] = 'Table';
$string['grapsjs-domcomponents-names-tbody'] = 'Table Body';
$string['grapsjs-domcomponents-names-text'] = 'Text';
$string['grapsjs-domcomponents-names-tfoot'] = 'Table Footer';
$string['grapsjs-domcomponents-names-thead'] = 'Table Header';
$string['grapsjs-domcomponents-names-video'] = 'Video';
$string['grapsjs-domcomponents-names-wrapper'] = 'Body';
$string['grapsjs-edit_code'] = 'Edit code';
$string['grapsjs-edit_code_paste_here_html'] = 'Paste your HTML/CSS here and click Import';
$string['grapsjs-fullscreen'] = 'Fullscreen';
$string['grapsjs-general'] = 'General';
$string['grapsjs-open_block'] = 'Blocks';
$string['grapsjs-open_layers'] = 'Layers';
$string['grapsjs-open_sm'] = 'Style Manager';
$string['grapsjs-page_preview'] = 'Preview';
$string['grapsjs-page_save'] = 'Save';
$string['grapsjs-panels-buttons-titles-export-template'] = 'View code';
$string['grapsjs-panels-buttons-titles-fullscreen'] = 'Fullscreen';
$string['grapsjs-panels-buttons-titles-open-blocks'] = 'Open blocks';
$string['grapsjs-panels-buttons-titles-open-layers'] = 'Open layer manager';
$string['grapsjs-panels-buttons-titles-open-sm'] = 'Open style manager';
$string['grapsjs-panels-buttons-titles-open-tm'] = 'Settings';
$string['grapsjs-panels-buttons-titles-preview'] = 'Preview';
$string['grapsjs-panels-buttons-titles-sw-visibility'] = 'View components';
$string['grapsjs-position'] = 'Position';
$string['grapsjs-preview'] = 'Preview';
$string['grapsjs-redo'] = 'Redo';
$string['grapsjs-repeat'] = 'Repeat';
$string['grapsjs-selectormanager-emptystate'] = '- State -';
$string['grapsjs-selectormanager-label'] = 'Classes';
$string['grapsjs-selectormanager-selected'] = 'Selected';
$string['grapsjs-selectormanager-states-active'] = 'Click';
$string['grapsjs-selectormanager-states-hover'] = 'Hover';
$string['grapsjs-selectormanager-states-nth-of-type-2n'] = 'Even/Odd';
$string['grapsjs-settings'] = 'Settings';
$string['grapsjs-show_border'] = 'Show Borders';
$string['grapsjs-size'] = 'Size';
$string['grapsjs-stylemanager-empty'] = 'Select an element to use the style manager';
$string['grapsjs-stylemanager-filebutton'] = 'Images';
$string['grapsjs-stylemanager-layer'] = 'Layer';
$string['grapsjs-stylemanager-properties-align-content'] = 'Align Content';
$string['grapsjs-stylemanager-properties-align-items'] = 'Align Items';
$string['grapsjs-stylemanager-properties-align-self'] = 'Align Self';
$string['grapsjs-stylemanager-properties-background'] = 'Background';
$string['grapsjs-stylemanager-properties-background-attachment'] = 'Background Attachment';
$string['grapsjs-stylemanager-properties-background-color'] = 'Background Color';
$string['grapsjs-stylemanager-properties-background-image'] = 'Background Image';
$string['grapsjs-stylemanager-properties-background-position'] = 'Background Position';
$string['grapsjs-stylemanager-properties-background-repeat'] = 'Background Repeat';
$string['grapsjs-stylemanager-properties-background-size'] = 'Background Size';
$string['grapsjs-stylemanager-properties-border'] = 'Border';
$string['grapsjs-stylemanager-properties-border-bottom-left'] = 'Border Bottom Left';
$string['grapsjs-stylemanager-properties-border-bottom-right'] = 'Border Bottom Right';
$string['grapsjs-stylemanager-properties-border-color'] = 'Border Color';
$string['grapsjs-stylemanager-properties-border-radius'] = 'Border Radius';
$string['grapsjs-stylemanager-properties-border-radius-bottom-left'] = 'Border Radius Bottom Left';
$string['grapsjs-stylemanager-properties-border-radius-bottom-right'] = 'Border Radius Bottom Right';
$string['grapsjs-stylemanager-properties-border-radius-top-left'] = 'Border Radius Top Left';
$string['grapsjs-stylemanager-properties-border-radius-top-right'] = 'Border Radius Top Right';
$string['grapsjs-stylemanager-properties-border-style'] = 'Border Style';
$string['grapsjs-stylemanager-properties-border-top-left'] = 'Border Top Left';
$string['grapsjs-stylemanager-properties-border-top-right'] = 'Border Top Right';
$string['grapsjs-stylemanager-properties-border-width'] = 'Border Width';
$string['grapsjs-stylemanager-properties-bottom'] = 'Bottom';
$string['grapsjs-stylemanager-properties-box-shadow'] = 'Box Shadow';
$string['grapsjs-stylemanager-properties-box-shadow-blur'] = 'Box Shadow Blur';
$string['grapsjs-stylemanager-properties-box-shadow-color'] = 'Box Shadow Color';
$string['grapsjs-stylemanager-properties-box-shadow-h'] = 'Box Shadow: Horizontal';
$string['grapsjs-stylemanager-properties-box-shadow-spread'] = 'Box Shadow Spread';
$string['grapsjs-stylemanager-properties-box-shadow-type'] = 'Box Shadow Type';
$string['grapsjs-stylemanager-properties-box-shadow-v'] = 'Box Shadow: Vertical';
$string['grapsjs-stylemanager-properties-center'] = 'Center';
$string['grapsjs-stylemanager-properties-color'] = 'Color';
$string['grapsjs-stylemanager-properties-display'] = 'Display';
$string['grapsjs-stylemanager-properties-flex-basis'] = 'Flex Basis';
$string['grapsjs-stylemanager-properties-flex-direction'] = 'Flex Direction';
$string['grapsjs-stylemanager-properties-flex-grow'] = 'Flex Grow';
$string['grapsjs-stylemanager-properties-flex-shrink'] = 'Flex Shrink';
$string['grapsjs-stylemanager-properties-flex-wrap'] = 'Flex Wrap';
$string['grapsjs-stylemanager-properties-float'] = 'Float';
$string['grapsjs-stylemanager-properties-font-family'] = 'Font Family';
$string['grapsjs-stylemanager-properties-font-size'] = 'Font Size';
$string['grapsjs-stylemanager-properties-font-weight'] = 'Font Weight';
$string['grapsjs-stylemanager-properties-height'] = 'Height';
$string['grapsjs-stylemanager-properties-justify'] = 'Justify';
$string['grapsjs-stylemanager-properties-justify-content'] = 'Justify Content';
$string['grapsjs-stylemanager-properties-left'] = 'Left';
$string['grapsjs-stylemanager-properties-letter-spacing'] = 'Letter Spacing';
$string['grapsjs-stylemanager-properties-line-height'] = 'Line Height';
$string['grapsjs-stylemanager-properties-line-through'] = 'Line through';
$string['grapsjs-stylemanager-properties-margin'] = 'Margin';
$string['grapsjs-stylemanager-properties-margin-bottom'] = 'Margin Bottom';
$string['grapsjs-stylemanager-properties-margin-left'] = 'Margin Left';
$string['grapsjs-stylemanager-properties-margin-right'] = 'Margin Right';
$string['grapsjs-stylemanager-properties-margin-top'] = 'Margin Top';
$string['grapsjs-stylemanager-properties-max-height'] = 'Max Height';
$string['grapsjs-stylemanager-properties-max-width'] = 'Max Width';
$string['grapsjs-stylemanager-properties-none'] = 'None';
$string['grapsjs-stylemanager-properties-order'] = 'Order';
$string['grapsjs-stylemanager-properties-padding'] = 'Padding';
$string['grapsjs-stylemanager-properties-padding-bottom'] = 'Padding Bottom';
$string['grapsjs-stylemanager-properties-padding-left'] = 'Padding Left';
$string['grapsjs-stylemanager-properties-padding-right'] = 'Padding Right';
$string['grapsjs-stylemanager-properties-padding-top'] = 'Padding Top';
$string['grapsjs-stylemanager-properties-perspective'] = 'Perspective';
$string['grapsjs-stylemanager-properties-position'] = 'Position';
$string['grapsjs-stylemanager-properties-right'] = 'Right';
$string['grapsjs-stylemanager-properties-text-align'] = 'Text Align';
$string['grapsjs-stylemanager-properties-text-shadow'] = 'Text Shadow';
$string['grapsjs-stylemanager-properties-text-shadow-blur'] = 'Text Shadow Blur';
$string['grapsjs-stylemanager-properties-text-shadow-color'] = 'Text Shadow Color';
$string['grapsjs-stylemanager-properties-text-shadow-h'] = 'Text Shadow: Horizontal';
$string['grapsjs-stylemanager-properties-text-shadow-v'] = 'Text Shadow: Vertical';
$string['grapsjs-stylemanager-properties-top'] = 'Top';
$string['grapsjs-stylemanager-properties-transform'] = 'Transform';
$string['grapsjs-stylemanager-properties-transform-rotate-x'] = 'Rotate X';
$string['grapsjs-stylemanager-properties-transform-rotate-y'] = 'Rotate Y';
$string['grapsjs-stylemanager-properties-transform-rotate-z'] = 'Rotate Z';
$string['grapsjs-stylemanager-properties-transform-scale-x'] = 'Scale X';
$string['grapsjs-stylemanager-properties-transform-scale-y'] = 'Scale Y';
$string['grapsjs-stylemanager-properties-transform-scale-z'] = 'Scale Z';
$string['grapsjs-stylemanager-properties-transition'] = 'Transition';
$string['grapsjs-stylemanager-properties-transition-duration'] = 'Transition Duration';
$string['grapsjs-stylemanager-properties-transition-property'] = 'Transition Property';
$string['grapsjs-stylemanager-properties-transition-timing-function'] = 'Transition Timing Function';
$string['grapsjs-stylemanager-properties-underline'] = 'Underline';
$string['grapsjs-stylemanager-properties-width'] = 'Width';
$string['grapsjs-stylemanager-sectors-decorations'] = 'Decorations';
$string['grapsjs-stylemanager-sectors-dimension'] = 'Dimension';
$string['grapsjs-stylemanager-sectors-extra'] = 'Extra';
$string['grapsjs-stylemanager-sectors-flex'] = 'Flex';
$string['grapsjs-stylemanager-sectors-general'] = 'General';
$string['grapsjs-stylemanager-sectors-layout'] = 'Layout';
$string['grapsjs-stylemanager-sectors-typography'] = 'Typography';
$string['grapsjs-tipografia'] = 'Typography';
$string['grapsjs-traitmanager-empty'] = 'Select an element to use the trait manager';
$string['grapsjs-traitmanager-label'] = 'Component Settings';
$string['grapsjs-traitmanager-traits-options-target-_blank'] = 'New window';
$string['grapsjs-traitmanager-traits-options-target-false'] = 'This window';
$string['grapsjs-undo'] = 'Undo';
$string['grapsjs-width'] = 'Width';
$string['heart'] = 'If you like this theme, don\'t forget to click ❤️ on the themes page <a href="{$a}" target="_blank">by clicking here</a>';
$string['instructor'] = 'Instructor';
$string['login_backgroundcolor'] = 'Background Color';
$string['login_backgroundcolor_desc'] = 'Select the background color of the password recovery page';
$string['login_backgroundfoto'] = 'Background Image';
$string['login_backgroundfoto_desc'] = 'Select the Login/Password Recovery/Create Account background image. Default image is: {$a}';
$string['login_forgot_description'] = 'Text on the side of the Forgot Password Screen';
$string['login_forgot_description_desc'] = 'Text that will appear only on the Forgot Password screen';
$string['login_login_description'] = 'Text on the side of the Login Screen';
$string['login_login_description_desc'] = 'Text that will appear only on the Login screen';
$string['login_signup_description'] = 'Text on the side of the Create an Account Screen';
$string['login_signup_description_desc'] = 'Text that will appear only on the Create an Account screen';
$string['login_theme'] = 'Login theme';
$string['login_theme_block'] = 'Central white block with optional background';
$string['login_theme_desc'] = 'Choose which theme you want in the Login area';
$string['login_theme_image_login'] = 'Background image and login on the side';
$string['login_theme_imagetext_login'] = 'Background image, text over the image, and login on the side';
$string['login_theme_login'] = 'Login screen only, no side image';
$string['logo_color'] = 'Colored Logo';
$string['logo_color_desc'] = 'Please upload your colored LOGO if you want to include it at the top. This logo will be displayed as the page is scrolled, and the menu will be displayed on a white background.';
$string['logo_write'] = 'White Logo';
$string['logo_write_desc'] = 'Please upload your white LOGO if you want to include it at the top. This logo will be displayed when scrolling remains at the top, and the menu will be displayed on a colored background.';
$string['matricular'] = 'Enroll';
$string['pluginname'] = 'Degrade Theme (Tema Degradado)';
$string['privacy:metadata'] = 'The Degrade theme does not store any personal data about any user.';
$string['settings_about_heading'] = 'About your Moodle';
$string['settings_css_heading'] = 'Fuentes y CSS';
$string['settings_footer_heading'] = 'Footer Block';
$string['settings_icons_block'] = 'Icon {$a}';
$string['settings_icons_change_icons'] = 'Change the default icon in the course list';
$string['settings_icons_default_audio_file'] = 'Audio';
$string['settings_icons_default_book'] = 'Book';
$string['settings_icons_default_download'] = 'Download';
$string['settings_icons_default_game'] = 'Game';
$string['settings_icons_default_money'] = 'Financial';
$string['settings_icons_default_slide'] = 'Slides';
$string['settings_icons_default_support'] = 'Support';
$string['settings_icons_default_video_file'] = 'Video';
$string['settings_icons_heading'] = 'Icons';
$string['settings_icons_image'] = 'Icon Image';
$string['settings_icons_image_desc'] = 'Upload the SVG or PNG image of the desired icon to replace in the course.<br>Recommended size: 24px. If PNG, remember transparency.';
$string['settings_icons_module_disable'] = 'Custom icon selection is disabled. Activate in {$a}';
$string['settings_icons_name'] = 'Icon Name';
$string['settings_icons_name_desc'] = 'Add the icon name for easy selection in the module';
$string['settings_icons_none'] = 'No custom icons';
$string['settings_icons_num'] = 'Number of Icons';
$string['settings_icons_num_desc'] = 'Quantity of custom icons you want to add';
$string['settings_icons_select_icon'] = 'Select the custom icon. Edit in {$a}';
$string['settings_login_heading'] = 'Login Screen';
$string['settings_slideshow_heading'] = 'SlideShow';
$string['settings_theme_heading'] = 'Theme and CSS';
$string['settings_top_heading'] = 'Top';
$string['sitefonts'] = 'Fuentes adicionales de Google';
$string['sitefonts_desc'] = 'Inserta el código @import de Google Fonts como se indica en la imagen a continuación. Después de guardar, el campo "Fuente del sitio" se actualizará, mostrando estas fuentes. Puedes agregar múltiples @import según sea necesario.';
$string['slidecaption_desc'] = 'Enter the caption text to be used on the slide';
$string['slideshow_image'] = 'Slide Image';
$string['slideshow_image_desc'] = 'The image should be 1250px X 400px.';
$string['slideshow_info'] = 'Slide {$a}';
$string['slideshow_numslides'] = 'How many images in the SlideShow';
$string['slideshow_numslides_desc'] = 'How many images do you want in the SlideShow?';
$string['slideshow_numslides_nenhum'] = 'No slides on the Home';
$string['slideshow_text'] = 'Short descriptive text for the Slide';
$string['slideshow_text_desc'] = 'Insert a short text about the slide.';
$string['slideshow_url'] = 'Slides button link';
$string['slideshow_url_desc'] = 'Insert the destination link for the slide image button';
$string['social_facebook'] = 'Your Facebook';
$string['social_facebook_desc'] = 'Your organization\'s Facebook URL.';
$string['social_instagram'] = 'Your Instagram';
$string['social_instagram_desc'] = 'Your organization\'s Instagram URL.';
$string['social_linkedin'] = 'Your Linkedin';
$string['social_linkedin_desc'] = 'Your organization\'s Linkedin URL.';
$string['social_twitter'] = 'Your Twitter';
$string['social_twitter_desc'] = 'Your organization\'s Twitter URL.';
$string['social_youtube'] = 'Your Youtube';
$string['social_youtube_desc'] = 'Your organization\'s Youtube URL.';
$string['theme_color'] = 'Color Selection';
$string['theme_color-color_buttons'] = 'Buttons Color';
$string['theme_color-color_buttons_desc'] = 'The color used for buttons, adding visual cohesion and emphasizing interactive actions.';
$string['theme_color-color_names'] = 'Names Color';
$string['theme_color-color_names_desc'] = 'Color used to highlight names or identifiers, providing clarity and emphasis on specific text information.';
$string['theme_color-color_primary'] = 'Primary Color';
$string['theme_color-color_primary_desc'] = 'The main primary color of the theme, usually used for highlight and emphasis elements.';
$string['theme_color-color_secondary'] = 'Secondary Color';
$string['theme_color-color_secondary_desc'] = 'A secondary color that complements the primary color, used to highlight secondary elements or to contrast with the primary color.';
$string['theme_color-color_titles'] = 'Titles Color';
$string['theme_color-color_titles_desc'] = 'The color used for titles, providing highlight and visual structure to the page content.';
$string['theme_color_blue'] = 'Blue';
$string['theme_color_desc'] = 'Select the colors of Moodle texts and buttons or click the line below:';
$string['theme_color_green'] = 'Green';
$string['theme_color_green_d'] = 'Dark Green';
$string['theme_color_heading'] = 'Environment Color Selection';
$string['theme_color_red_d'] = 'Red';
$string['theme_color_violet'] = 'Purple';
$string['theme_degrade_about_editbooton'] = 'Edit About block';
$string['theme_degrade_frontpage_bloco'] = 'Block "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Home blocks';
$string['theme_degrade_slideshow_editbooton'] = 'Edit SlideShow';
$string['theme_login_branco'] = 'Login screen only, no side image, with the form on a white background';
$string['top_color_heading'] = 'Scroll Top Color';
$string['top_scroll_background_color'] = 'Background Color of Top Menu on Scroll';
$string['top_scroll_background_color_desc'] = 'Set the background color when scrolling the page.';
$string['top_scroll_text_color'] = 'Text Color of Menu on Scroll';
$string['top_scroll_text_color_desc'] = 'Set the text color of the menu when scrolling the page.';
