<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'es_mx', version '4.3'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acessar'] = 'Acceder al curso';
$string['background_color'] = 'Color de fondo';
$string['background_color_black'] = 'Tema negro {$a}';
$string['background_color_blue'] = 'Tema azul {$a}';
$string['background_color_default'] = 'Tema predeterminado {$a}';
$string['background_color_desc'] = 'Color de fondo de la parte superior e inferior.';
$string['background_color_green'] = 'Tema verde {$a}';
$string['background_color_random'] = 'Tema aleatorio {$a}';
$string['background_color_red'] = 'Tema rojo {$a}';
$string['choosereadme'] = 'Boost Magnific es un tema moderno altamente configurable. Este tema está planeado para ser usado directamente, o como un tema paterno cuando se crean temas nuevos utilizando Bootstrap 4.';
$string['contact_address'] = 'Dirección';
$string['contact_email'] = 'Correo electrónico';
$string['contact_phone'] = 'Número de teléfono';
$string['content_pagefonts'] = 'Fuentes Extra de Google';
$string['content_pagefonts_desc'] = 'Agrega aquí el enlace @import de Google para fuentes adicionales.<br>Puedes poner múltiples importaciones.<br><a href="https://fonts.google.com/selection/embed" target="google">Código de inserción</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Predeterminado de Moodle';
$string['content_type_empty'] = '(Sin contenido)';
$string['content_type_footer'] = 'Tipo de contenido para el pie de página';
$string['content_type_footer_desc'] = 'Seleccione el tipo de contenido que desea mostrar en el pie de página.';
$string['content_type_home'] = 'Tipo de contenido para la página de inicio';
$string['content_type_home_desc'] = 'Seleccione el tipo de contenido que desea mostrar en la página de inicio.';
$string['content_type_html'] = 'Página a ser creada con editor';
$string['continuar'] = 'Continuar estudiando';
$string['countlesson'] = '{$a} lección';
$string['countlessons'] = '{$a} lecciones';
$string['customcss'] = 'CSS personalizado';
$string['customcss_desc'] = 'Cualquier regla CSS que añadas a esta área de texto se reflejará en todas las páginas, facilitando la personalización de este tema.';
$string['custommenuitems'] = 'Elementos de menú personalizados';
$string['custommenuitems_desc'] = 'Puedes crear un menú personalizado junto a los menús superiores. El menú raíz debe comenzar al ras con el borde, y los submenús deben ir precedidos por un guión (-). El número de guiones determina la profundidad del elemento. Así, los elementos con un solo guión aparecen en un submenú debajo del elemento de nivel superior anterior, y los elementos con dos guiones aparecen en un submenú debajo del submenú anterior.
El contenido de cada elemento de menú debe consistir en hasta tres elementos (<strong>etiqueta</strong> | <strong>URL</strong> | <strong>tooltip</strong> | <strong>idioma</strong>), cada uno separado por el carácter "|".
<ul>
<li><strong>etiqueta</strong>: Este es el texto que se mostrará dentro del elemento de menú. Debes especificar una etiqueta para cada elemento de menú.</li>
<li><strong>URL</strong>: Esta es la URL a la que el usuario será llevado al hacer clic en el elemento de menú. Esto es opcional; si no se proporciona, el elemento no estará enlazado a ningún lugar.<br>
Se pueden agregar otros atributos como "target" al final de la URL.</li>
<li><strong>tooltip</strong>: Si proporcionas una URL, también puedes elegir proporcionar un tooltip para el enlace creado con la URL. Esto es opcional, y si no se define, se usará la etiqueta como tooltip para el elemento de menú.</li>
<li><strong>idioma</strong>: Puedes agregar un código de idioma (o una lista separada por comas de códigos) como el cuarto elemento de la línea. La línea se mostrará solo si el usuario ha seleccionado el/los idioma(s) listado(s).</li>
</ul>
A continuación, se muestra un ejemplo de cómo crear un menú personalizado:
<blockquote><pre>
Cursos
-Todos los cursos | /curso/
-Mis cursos
--Curso de ejemplo
---Curso de ejemplo 7 | /curso/ver.php?id=7
---Curso de ejemplo 9 | /curso/ver.php?id=9
--Curso de prueba
---Curso de prueba 2 | /curso/ver.php?id=2
---Curso de prueba 5 | /curso/ver.php?id=5
Google
-Google en cualquier idioma | https://google.com/" target="_blank
-Google en México | https://www.google.com.mx/" target="_blank|Etiqueta de Google|en
-Google en portugués | https://google.com.br/" target="_blank|Etiqueta de Google|pt,pt_br,pt_br_kids
Página de soporte | https://support.com/" target="_blank
</pre></blockquote>
Para Moodle con soporte para múltiples idiomas, el valor de <strong>etiqueta</strong> debe formatearse como <strong>"nombredelacadenaidioma,nombre del componente"</strong>.
<blockquote><pre>
perfil,moodle | /usuario/perfil.php
mensajes,mensaje | /mensaje/índice.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Configuración_avanzada_de_temas" target="_blank">Más información del menú</a>';
$string['editor_link_footer'] = 'Editar el bloque del pie de página para el idioma {$a}';
$string['editor_link_footer_all'] = 'Editar el bloque del pie de página para todos los idiomas';
$string['editor_link_home'] = 'Editar la página de inicio para el idioma {$a}';
$string['editor_link_home_all'] = 'Editar la página de inicio para todos los idiomas';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'El favicon se muestra junto al título de la página en la pestaña del navegador. Se muestra un favicon de Moodle si no se proporciona un favicon personalizado.';
$string['fontfamily'] = 'Fuente del sitio';
$string['fontfamily_desc'] = 'Elige la fuente que deseas utilizar en tu Moodle';
$string['fontfamily_menus'] = 'Fuentes del menú';
$string['fontfamily_menus_desc'] = 'Elige la fuente que deseas utilizar para los menús en tu sitio Moodle.';
$string['fontfamily_sitename'] = 'Fuente para el nombre del sitio';
$string['fontfamily_sitename_desc'] = 'La fuente que se aplicará al nombre del sitio si no se proporciona un logotipo.';
$string['fontfamily_title'] = 'Fuentes del texto del título';
$string['fontfamily_title_desc'] = 'Elige la fuente que deseas utilizar para los títulos en tu sitio Moodle.';
$string['fontpreview'] = 'Vista previa de lista de fuentes';
$string['footer_contact_title'] = 'Título del bloque de contacto';
$string['footer_contact_title_default'] = 'Contacto';
$string['footer_contact_title_desc'] = 'Ingresa el título del bloque que aparecerá en el pie de página con los

 datos de contacto.';
$string['footer_description'] = 'Descripción';
$string['footer_description_desc'] = 'Describe tu Moodle, lo que haces, y esta información se mostrará debajo del logo en el pie de página de Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Mostrar nombre del profesor';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Si está marcado, muestra los nombres de los profesores en la lista de cursos.';
$string['footer_frontpage_blockcourses_text'] = 'Texto breve explicando el bloque "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = '¡Añade un texto hablando de "{$a}"!';
$string['footer_links_title'] = 'Título del bloque de enlaces';
$string['footer_links_title_default'] = 'Enlaces importantes';
$string['footer_show_copywriter'] = 'Mostrar "Hecho con ❤️"';
$string['footer_show_copywriter_desc'] = 'Desmarca si quieres ocultar "Hecho con ❤️"';
$string['footer_social_title'] = 'Título del bloque de redes sociales';
$string['footer_social_title_default'] = 'Síguenos en redes sociales';
$string['footer_social_title_desc'] = 'Ingresa el título del bloque que aparecerá en el pie de página con los datos de tus redes sociales.';
$string['footerblink'] = 'Enlaces del bloque de pie de página';
$string['footerblink_desc'] = 'Puedes configurar un bloque de enlaces de pie de página aquí para que se muestren en los temas.<br>Cada línea consta de algún texto de menú o clave de idioma o texto, una URL de enlace (opcional), separado por barras verticales. Por ejemplo:<br><pre>Soporte de Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Bloque de contacto';
$string['footerblock_copywriter'] = 'Hecho con ❤️';
$string['footerblock_description'] = 'Bloque de descripción';
$string['footerblock_links'] = 'Bloque de enlaces';
$string['footerblock_social'] = 'Bloque social';
$string['free_name'] = 'Gratis';
$string['frontpage_about_description'] = 'Describe lo que haces';
$string['frontpage_about_description_desc'] = 'Describe en un máximo de 5 líneas el propósito de tu Moodle';
$string['frontpage_about_enable'] = 'Habilitar bloque Acerca de';
$string['frontpage_about_enable_desc'] = 'Si está marcado, ¡el bloque Acerca de aparecerá debajo del banner!';
$string['frontpage_about_info'] = 'Cuadro de datos {$a}';
$string['frontpage_about_logo'] = 'Logo diferente a mostrar aquí';
$string['frontpage_about_logo_desc'] = 'Si se establece, se utilizará este logo aquí en lugar del logo superior.<br> En blanco usa el logo superior.';
$string['frontpage_about_number'] = 'Cantidad de datos';
$string['frontpage_about_number_desc'] = 'Ingresa aquí la cantidad de información mencionada anteriormente';
$string['frontpage_about_text'] = 'Nombre del dato';
$string['frontpage_about_text_1_defalt'] = 'Cursos';
$string['frontpage_about_text_2_defalt'] = 'Profesores';
$string['frontpage_about_text_3_defalt'] = 'Estudiantes';
$string['frontpage_about_text_4_defalt'] = 'Lecciones';
$string['frontpage_about_text_desc'] = 'Ingresa aquí el nombre del dato que se mostrará en la página principal';
$string['frontpage_about_title'] = 'Título del bloque Acerca de';
$string['frontpage_about_title_default'] = 'Nuestra Comunidad Global';
$string['grapsjs-assetmanager-addbutton'] = 'Agregar imagen';
$string['grapsjs-assetmanager-modaltitle'] = 'Seleccionar imagen';
$string['grapsjs-assetmanager-uploadtitle'] = 'Suelte los archivos aquí o haga clic para subir';
$string['grapsjs-attachment'] = 'Adjunto';
$string['grapsjs-clear'] = 'Limpiar el lienzo';
$string['grapsjs-confirm_clear'] = '¿Estás seguro de limpiar el lienzo?';
$string['grapsjs-decoration'] = 'Decoraciones';
$string['grapsjs-devicemanager-device'] = 'Dispositivo';
$string['grapsjs-devicemanager-devices-desktop'] = 'Escritorio';
$string['grapsjs-devicemanager-devices-mobilelandscape'] = 'Celular, modo paisaje';
$string['grapsjs-devicemanager-devices-mobileportrait'] = 'Celular, modo retrato';
$string['grapsjs-devicemanager-devices-tablet'] = 'Tableta';
$string['grapsjs-dimensions'] = 'Dimensiones';
$string['grapsjs-domcomponents-names-'] = 'Caja';
$string['grapsjs-domcomponents-names-body'] = 'Cuerpo';
$string['grapsjs-domcomponents-names-cell'] = 'Célula de la tabla';
$string['grapsjs-domcomponents-names-comment'] = 'Comentario';
$string['grapsjs-domcomponents-names-image'] = 'Imagen';
$string['grapsjs-domcomponents-names-label'] = 'Etiqueta';
$string['grapsjs-domcomponents-names-link'] = 'Enlace';
$string['grapsjs-domcomponents-names-map'] = 'Mapa';
$string['grapsjs-domcomponents-names-row'] = 'Fila de la tabla';
$string['grapsjs-domcomponents-names-section'] = 'Sección';
$string['grapsjs-domcomponents-names-table'] = 'Tabla';
$string['grapsjs-domcomponents-names-tbody'] = 'Cuerpo de la tabla';
$string['grapsjs-domcomponents-names-text'] = 'Texto';
$string['grapsjs-domcomponents-names-tfoot'] = 'Pie de página de la tabla';
$string['grapsjs-domcomponents-names-thead'] = 'Encabezado de la tabla';
$string['grapsjs-domcomponents-names-video'] = 'Vídeo';
$string['grapsjs-domcomponents-names-wrapper'] = 'Cuerpo';
$string['grapsjs-edit_code'] = 'Editar código';
$string['grapsjs-edit_code_paste_here_html'] = 'Pegue aquí su HTML/CSS y haga clic en Importar';
$string['grapsjs-fullscreen'] = 'Pantalla Completa';
$string['grapsjs-general'] = 'Generales';
$string['grapsjs-open_block'] = 'Bloques';
$string['grapsjs-open_layers'] = 'Capas';
$string['grapsjs-open_sm'] = 'Gestor de Estilos';
$string['grapsjs-page_preview'] = 'Previsualizar';
$string['grapsjs-page_save'] = 'Guardar';
$string['grapsjs-panels-buttons-titles-export-template'] = 'Ver código';
$string['grapsjs-panels-buttons-titles-fullscreen'] = 'Pantalla completa';
$string['grapsjs-panels-buttons-titles-open-blocks'] = 'Abrir bloques';
$string['grapsjs-panels-buttons-titles-open-layers'] = 'Abrir gestor de capas';
$string['grapsjs-panels-buttons-titles-open-sm'] = 'Abrir gestor de estilos';
$string['grapsjs-panels-buttons-titles-open-tm'] = 'Configuraciones';
$string['grapsjs-panels-buttons-titles-preview'] = 'Previsualización';
$string['grapsjs-panels-buttons-titles-sw-visibility'] = 'Ver componentes';
$string['grapsjs-position'] = 'Posición';
$string['grapsjs-preview'] = 'Previa';
$string['grapsjs-redo'] = 'Rehacer';
$string['grapsjs-repeat'] = 'Repetir';
$string['grapsjs-selectormanager-emptystate'] = '- Estado -';
$string['grapsjs-selectormanager-label'] = 'Clases';
$string['grapsjs-selectormanager-selected'] = 'Seleccionado';
$string['grapsjs-selectormanager-states-active'] = 'Click';
$string['grapsjs-selectormanager-states-hover'] = 'Hover';
$string['grapsjs-selectormanager-states-nth-of-type-2n'] = 'Par/Impar';
$string['grapsjs-settings'] = 'Configuraciones';
$string['grapsjs-show_border'] = 'Mostrar Bordes';
$string['grapsjs-size'] = 'Tamaño';
$string['grapsjs-stylemanager-empty'] = 'Seleccione un elemento para usar el gestor de estilos';
$string['grapsjs-stylemanager-filebutton'] = 'Imágenes';
$string['grapsjs-stylemanager-layer'] = 'Capa';
$string['grapsjs-stylemanager-properties-align-content'] = 'Alinear contenido';
$string['grapsjs-stylemanager-properties-align-items'] = 'Alinear elementos';
$string['grapsjs-stylemanager-properties-align-self'] = 'Autoalinearse';
$string['grapsjs-stylemanager-properties-background'] = 'Fondo';
$string['grapsjs-stylemanager-properties-background-attachment'] = 'Ajuste de fondo';
$string['grapsjs-stylemanager-properties-background-color'] = 'Color de fondo';
$string['grapsjs-stylemanager-properties-background-image'] = 'Imagen de fondo';
$string['grapsjs-stylemanager-properties-background-position'] = 'Posición del fondo';
$string['grapsjs-stylemanager-properties-background-repeat'] = 'Repetir fondo';
$string['grapsjs-stylemanager-properties-background-size'] = 'Tamaño del fondo';
$string['grapsjs-stylemanager-properties-border'] = 'Borde';
$string['grapsjs-stylemanager-properties-border-bottom-left'] = 'Borde inferior izquierdo';
$string['grapsjs-stylemanager-properties-border-bottom-right'] = 'Borde inferior derecho';
$string['grapsjs-stylemanager-properties-border-color'] = 'Color del borde';
$string['grapsjs-stylemanager-properties-border-radius'] = 'Radio del borde';
$string['grapsjs-stylemanager-properties-border-radius-bottom-left'] = 'Radio del borde inferior izquierdo';
$string['grapsjs-stylemanager-properties-border-radius-bottom-right'] = 'Radio del borde inferior derecho';
$string['grapsjs-stylemanager-properties-border-radius-top-left'] = 'Radio del borde superior izquierdo';
$string['grapsjs-stylemanager-properties-border-radius-top-right'] = 'Radio del borde superior derecho';
$string['grapsjs-stylemanager-properties-border-style'] = 'Estilo del borde';
$string['grapsjs-stylemanager-properties-border-top-left'] = 'Borde superior izquierdo';
$string['grapsjs-stylemanager-properties-border-top-right'] = 'Borde superior derecho';
$string['grapsjs-stylemanager-properties-border-width'] = 'Ancho del borde';
$string['grapsjs-stylemanager-properties-bottom'] = 'Inferior';
$string['grapsjs-stylemanager-properties-box-shadow'] = 'Sombra de caja';
$string['grapsjs-stylemanager-properties-box-shadow-blur'] = 'Desenfoque de la sombra de caja';
$string['grapsjs-stylemanager-properties-box-shadow-color'] = 'Color de la sombra de caja';
$string['grapsjs-stylemanager-properties-box-shadow-h'] = 'Sombra de caja: horizontal';
$string['grapsjs-stylemanager-properties-box-shadow-spread'] = 'Extensión de la sombra de caja';
$string['grapsjs-stylemanager-properties-box-shadow-type'] = 'Tipo de sombra de caja';
$string['grapsjs-stylemanager-properties-box-shadow-v'] = 'Sombra de caja: vertical';
$string['grapsjs-stylemanager-properties-center'] = 'Centro';
$string['grapsjs-stylemanager-properties-color'] = 'Color';
$string['grapsjs-stylemanager-properties-display'] = 'Exhibición';
$string['grapsjs-stylemanager-properties-flex-basis'] = 'Base Flex';
$string['grapsjs-stylemanager-properties-flex-direction'] = 'Dirección Flex';
$string['grapsjs-stylemanager-properties-flex-grow'] = 'Crecimiento Flex';
$string['grapsjs-stylemanager-properties-flex-shrink'] = 'Contracción Flex';
$string['grapsjs-stylemanager-properties-flex-wrap'] = 'Envoltura Flex';
$string['grapsjs-stylemanager-properties-float'] = 'Float';
$string['grapsjs-stylemanager-properties-font-family'] = 'Familia de Fuente';
$string['grapsjs-stylemanager-properties-font-size'] = 'Tamaño de la fuente';
$string['grapsjs-stylemanager-properties-font-weight'] = 'Grosor de la fuente';
$string['grapsjs-stylemanager-properties-height'] = 'Altura';
$string['grapsjs-stylemanager-properties-justify'] = 'Justificar';
$string['grapsjs-stylemanager-properties-justify-content'] = 'Justificar contenido';
$string['grapsjs-stylemanager-properties-left'] = 'Izquierda';
$string['grapsjs-stylemanager-properties-letter-spacing'] = 'Espacio entre letras';
$string['grapsjs-stylemanager-properties-line-height'] = 'Altura de línea';
$string['grapsjs-stylemanager-properties-line-through'] = 'Tachado';
$string['grapsjs-stylemanager-properties-margin'] = 'Margen';
$string['grapsjs-stylemanager-properties-margin-bottom'] = 'Margen Inferior';
$string['grapsjs-stylemanager-properties-margin-left'] = 'Margen Izquierdo';
$string['grapsjs-stylemanager-properties-margin-right'] = 'Margen Derecho';
$string['grapsjs-stylemanager-properties-margin-top'] = 'Margen Superior';
$string['grapsjs-stylemanager-properties-max-height'] = 'Altura Máx.';
$string['grapsjs-stylemanager-properties-max-width'] = 'Ancho Máx.';
$string['grapsjs-stylemanager-properties-none'] = 'Ninguno';
$string['grapsjs-stylemanager-properties-order'] = 'Orden';
$string['grapsjs-stylemanager-properties-padding'] = 'Padding';
$string['grapsjs-stylemanager-properties-padding-bottom'] = 'Padding Inferior';
$string['grapsjs-stylemanager-properties-padding-left'] = 'Padding Izquierdo';
$string['grapsjs-stylemanager-properties-padding-right'] = 'Padding Derecho';
$string['grapsjs-stylemanager-properties-padding-top'] = 'Padding Superior';
$string['grapsjs-stylemanager-properties-perspective'] = 'Perspectiva';
$string['grapsjs-stylemanager-properties-position'] = 'Posición';
$string['grapsjs-stylemanager-properties-right'] = 'Derecha';
$string['grapsjs-stylemanager-properties-text-align'] = 'Alineación del texto';
$string['grapsjs-stylemanager-properties-text-shadow'] = 'Sombra del texto';
$string['grapsjs-stylemanager-properties-text-shadow-blur'] = 'Desenfoque de la sombra del texto';
$string['grapsjs-stylemanager-properties-text-shadow-color'] = 'Color de la sombra del texto';
$string['grapsjs-stylemanager-properties-text-shadow-h'] = 'Sombra del texto: horizontal';
$string['grapsjs-stylemanager-properties-text-shadow-v'] = 'Sombra del texto: vertical';
$string['grapsjs-stylemanager-properties-top'] = 'Arriba';
$string['grapsjs-stylemanager-properties-transform'] = 'Transformación';
$string['grapsjs-stylemanager-properties-transform-rotate-x'] = 'Rotar horizontalmente';
$string['grapsjs-stylemanager-properties-transform-rotate-y'] = 'Rotar verticalmente';
$string['grapsjs-stylemanager-properties-transform-rotate-z'] = 'Rotar en profundidad';
$string['grapsjs-stylemanager-properties-transform-scale-x'] = 'Escalar horizontalmente';
$string['grapsjs-stylemanager-properties-transform-scale-y'] = 'Escalar verticalmente';
$string['grapsjs-stylemanager-properties-transform-scale-z'] = 'Escalar en profundidad';
$string['grapsjs-stylemanager-properties-transition'] = 'Transición';
$string['grapsjs-stylemanager-properties-transition-duration'] = 'Duración de la transición';
$string['grapsjs-stylemanager-properties-transition-property'] = 'Tipo de transición';
$string['grapsjs-stylemanager-properties-transition-timing-function'] = 'Función del tiempo de la transición';
$string['grapsjs-stylemanager-properties-underline'] = 'Subrayado';
$string['grapsjs-stylemanager-properties-width'] = 'Ancho';
$string['grapsjs-stylemanager-sectors-decorations'] = 'Decoraciones';
$string['grapsjs-stylemanager-sectors-dimension'] = 'Dimensión';
$string['grapsjs-stylemanager-sectors-flex'] = 'Flex';
$string['grapsjs-stylemanager-sectors-general'] = 'General';
$string['grapsjs-stylemanager-sectors-layout'] = 'Disposición';
$string['grapsjs-stylemanager-sectors-typography'] = 'Tipografía';
$string['grapsjs-tipografia'] = 'Tipografía';
$string['grapsjs-traitmanager-empty'] = 'Seleccione un elemento para usar el gestor de características';
$string['grapsjs-traitmanager-label'] = 'Configuraciones del componente';
$string['grapsjs-traitmanager-traits-options-target-_blank'] = 'Nueva ventana';
$string['grapsjs-traitmanager-traits-options-target-false'] = 'Esta ventana';
$string['grapsjs-undo'] = 'Deshacer';
$string['grapsjs-width'] = 'Ancho';
$string['heart'] = 'Si te gusta este tema, no olvides hacer clic en ❤️ en la página de temas <a href="{$a}" target="_blank">haciendo clic aquí</a>';
$string['instructor'] = 'Profesor';
$string['login_backgroundcolor'] = 'Color de fondo';
$string['login_backgroundcolor_desc'] = 'Selecciona el color de fondo de la página de recuperación de contraseña';
$string['login_backgroundfoto'] = 'Imagen de fondo';
$string['login_backgroundfoto_desc'] = 'Selecciona la imagen de fondo para Iniciar sesión/Recuperar contraseña/Crear cuenta. La imagen predeterminada es: {$a}';
$string['login_forgot_description'] = 'Texto en el lateral de la pantalla de recuperación de contraseña';
$string['login_forgot_description_desc'] = 'Texto que aparecerá solo en la pantalla de recuperación de contraseña';
$string['login_login_description'] = 'Texto en el lateral de la pantalla de inicio de sesión';
$string['login_login_description_desc'] = 'Texto que aparecerá solo en la pantalla de inicio de sesión';
$string['login_signup_description'] = 'Texto en el lateral de la pantalla de crear una cuenta';
$string['login_signup_description_desc'] = 'Texto que aparecerá solo en la pantalla de crear una cuenta';
$string['login_theme'] = 'Tema de inicio de sesión';
$string['login_theme_block'] = 'Bloque blanco central con fondo opcional';
$string['login_theme_desc'] = 'Elige qué tema deseas en el área de inicio de sesión';
$string['login_theme_image_login'] = 'Imagen de fondo e inicio de sesión en el lateral';
$string['login_theme_imagetext_login'] = 'Imagen de fondo, texto sobre la imagen e inicio de sesión en el lateral';
$string['login_theme_login'] = 'Solo pantalla de inicio de sesión, sin imagen lateral';
$string['logo_color'] = 'Logo a color';
$string['logo_color_desc'] = 'Sube tu LOGO a color si quieres incluirla en la parte superior. Este logo se mostrará a medida que la página se desplaza y el menú se mostrará en fondo blanco.';
$string['logo_write'] = 'Logo blanca';
$string['logo_write_desc'] = 'Sube tu LOGO blanca si quieres incluirla en la parte superior. Esta logo se mostrará cuando el desplazamiento permanezca en la parte superior y el menú se mostrará en fondo de color.';
$string['matricular'] = 'Matricularse';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'El tema Boost Magnific no almacena ningún dato personal sobre ningún usuario.';
$string['settings_about_heading'] = 'Acerca de tu Moodle';
$string['settings_css_heading'] = 'Fuentes y CSS';
$string['settings_footer_heading'] = 'Bloque del pie de página';
$string['settings_icons_block'] = 'Icono {$a}';
$string['settings_icons_change_icons'] = 'Cambiar el icono predeterminado en la lista de cursos';
$string['settings_icons_default_audio_file'] = 'Audio';
$string['settings_icons_default_book'] = 'Libro';
$string['settings_icons_default_download'] = 'Descargar';
$string['settings_icons_default_game'] = 'Juego';
$string['settings_icons_default_money'] = 'Financiero';
$string['settings_icons_default_slide'] = 'Diapositivas';
$string['settings_icons_default_support'] = 'Soporte';
$string['settings_icons_default_video_file'] = 'Video';
$string['settings_icons_heading'] = 'Iconos';
$string['settings_icons_image'] = 'Imagen del icono';
$string['settings_icons_image_desc'] = 'Sube la imagen SVG o PNG del icono deseado para reemplazar en el curso.<br>Tamaño recomendado: 24px. Si es PNG, recuerda la transparencia.';
$string['settings_icons_module_disable'] = 'La selección de icono personalizado está desactivada. Actívala en {$a}';
$string['settings_icons_name'] = 'Nombre del icono';
$string['settings_icons_name_desc'] = 'Agrega el nombre del icono para facilitar la selección en el módulo';
$string['settings_icons_none'] = 'Ningún icono personalizado';
$string['settings_icons_num'] = 'Número de iconos';
$string['settings_icons_num_desc'] = 'Cantidad de iconos personalizados que desea agregar';
$string['settings_icons_select_icon'] = 'Selecciona el icono personalizado. Edítalo en {$a}';
$string['settings_login_heading'] = 'Pantalla de inicio de sesión';
$string['settings_slideshow_heading'] = 'Presentación de diapositivas';
$string['settings_theme_heading'] = 'Tema y CSS';
$string['settings_top_heading'] = 'Superior';
$string['sitefonts'] = 'Fuentes adicionales de Google';
$string['sitefonts_desc'] = 'Inserta el código @import de Google Fonts como se indica en la imagen a continuación. Después de guardar, el campo "Fuente del sitio" se actualizará, mostrando estas fuentes. Puedes agregar múltiples @import según sea necesario.';
$string['slidecaption_desc'] = 'Ingresa el texto de la leyenda a utilizar en la diapositiva';
$string['slideshow_image'] = 'Imagen de la diapositiva';
$string['slideshow_image_desc'] = 'La imagen debe tener 1250px x 400px.';
$string['slideshow_info'] = 'Diapositiva {$a}';
$string['slideshow_numslides'] = 'Cantidad de imágenes en la presentación de diapositivas';
$string['slideshow_numslides_desc'] = '¿Cuántas imágenes quieres en la presentación de diapositivas?';
$string['slideshow_numslides_nenhum'] = 'Sin diapositivas en la página principal';
$string['slideshow_text'] = 'Texto breve descriptivo de la diapositiva';
$string['slideshow_text_desc'] = 'Inserta un breve texto sobre la diapositiva.';
$string['slideshow_url'] = 'Enlace del botón de las diapositivas';
$string['slideshow_url_desc'] = 'Inserta el destino del enlace del botón de la imagen de la diapositiva';
$string['social_facebook'] = 'Tu Facebook';
$string['social_facebook_desc'] = 'La URL de Facebook de tu organización.';
$string['social_instagram'] = 'Tu Instagram';
$string['social_instagram_desc'] = 'La URL de Instagram de tu organización.';
$string['social_linkedin'] = 'Tu Linkedin';
$string['social_linkedin_desc'] = 'La URL de LinkedIn de tu organización.';
$string['social_twitter'] = 'Tu Twitter';
$string['social_twitter_desc'] = 'La URL de Twitter de tu organización.';
$string['social_youtube'] = 'Tu Youtube';
$string['social_youtube_desc'] = 'La URL de YouTube de tu organización.';
$string['theme_boost_magnific_about_editbooton'] = 'Editar bloque Acerca de';
$string['theme_boost_magnific_frontpage_bloco'] = 'Bloque "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Bloques de la página principal';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Editar presentación de diapositivas';
$string['theme_color'] = 'Selección de colores';
$string['theme_color-color_buttons'] = 'Color de los botones';
$string['theme_color-color_buttons_desc'] = 'El color utilizado para los botones, añadiendo cohesión visual y enfatizando acciones interactivas.';
$string['theme_color-color_names'] = 'Color de los nombres';
$string['theme_color-color_names_desc'] = 'Color utilizado para resaltar nombres o identificadores, proporcionando claridad y énfasis en información de texto específica.';
$string['theme_color-color_primary'] = 'Color primario';
$string['theme_color-color_primary_desc'] = 'El color primario principal del tema, generalmente utilizado para elementos destacados y de énfasis.';
$string['theme_color-color_secondary'] = 'Color secundario';
$string['theme_color-color_secondary_desc'] = 'Un color secundario que complementa el color primario, utilizado para resaltar elementos secundarios o contrastar con el color primario.';
$string['theme_color-color_titles'] = 'Color de los títulos';
$string['theme_color-color_titles_desc'] = 'Color utilizado para los títulos, proporcionando destacado y estructura visual al contenido de la página.';
$string['theme_color_blue'] = 'Azul';
$string['theme_color_desc'] = 'Selecciona los colores de textos y botones de Moodle o haz clic en la línea de abajo:';
$string['theme_color_green'] = 'Verde';
$string['theme_color_green_d'] = 'Verde oscuro';
$string['theme_color_heading'] = 'Selección de colores del entorno';
$string['theme_color_red_d'] = 'Rojo';
$string['theme_color_violet'] = 'Morado';
$string['theme_login_branco'] = 'Solo pantalla de inicio de sesión, sin imagen lateral, con el formulario en fondo blanco';
$string['top_color_heading'] = 'Color del encabezado al desplazar';
$string['top_scroll_background_color'] = 'Color de fondo del menú superior al desplazar';
$string['top_scroll_background_color_desc'] = 'Establece el color de fondo al desplazar la página.';
$string['top_scroll_text_color'] = 'Color del texto del menú al desplazar';
$string['top_scroll_text_color_desc'] = 'Establece el color del texto del menú al desplazar la página.';
