<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'datalynx', language 'es_mx', version '4.3'.
 *
 * @package     datalynx
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['activate'] = 'activar';
$string['addline'] = 'Añadir {$a}';
$string['addoptions'] = 'Añadir opciones';
$string['admin'] = 'Administrador';
$string['admissibleroles'] = 'Roles admisibles';
$string['admissibleroles_error'] = '¡Por favor seleccione al menos un rol!';
$string['after'] = 'después de';
$string['alignment'] = 'Alineación';
$string['allof'] = 'todos de';
$string['allowaddoption'] = 'Permitir añadir opciones';
$string['allowsubscription'] = 'Permitir suscripción manual';
$string['allowunsubscription'] = 'Permitir des-suscripción manual';
$string['alltime'] = 'Todo el tiempo';
$string['andor'] = 'y/o';
$string['anyof'] = 'cualquiera de';
$string['approval_none'] = 'No requerido';
$string['approval_required_new'] = 'Requerido solamente para nuevas entradas';
$string['approval_required_update'] = 'Requerido para entradas nuevas y entradas editadas';
$string['approved'] = 'aprobado';
$string['approvednot'] = 'no aprobado';
$string['ascending'] = 'Ascendente';
$string['asdisplay'] = 'Usar plantilla de visualización';
$string['author'] = 'Autor';
$string['authorinfo'] = 'Información del autor';
$string['autocompletion'] = 'Autollenado';
$string['autocompletion_help'] = 'Elegir si el auto-llenado debería estar activo en modo de edición.';
$string['before'] = 'antes de';
$string['behavior'] = 'Comportamiento';
$string['behavioradd'] = 'Añadir comportamiento';
$string['behaviors'] = 'Comportamientos';
$string['between'] = 'entre';
$string['blankfilter'] = 'Filtro vacío';
$string['browse'] = 'Ojear';
$string['check_enable'] = 'Usted debe activar la casilla \'habilitar\' para confirmar la validez del valor seleccionado.';
$string['columns'] = 'columnas';
$string['comment'] = 'Comentario';
$string['commentadd'] = 'Añadir comentario';
$string['commentbynameondate'] = 'por {$a->name} - {$a->date}';
$string['commentdelete'] = '¿Está seguro de querer eliminar este comentario?';
$string['commentdeleted'] = 'Comentario eliminado';
$string['commentedit'] = 'Editar comentario';
$string['commentempty'] = 'Comentario estaba vacío';
$string['commentinputtype'] = 'Tipo de entrada del comentario';
$string['comments'] = 'Comentarios';
$string['commentsallow'] = '¿Permitir comentarios?';
$string['commentsaved'] = 'Comentario guardado';
$string['commentsn'] = '{$a} comentarios';
$string['commentsnone'] = 'Sin comentarios';
$string['completionentries'] = 'Número de entradas (aprobadas)';
$string['completionentriesgroup'] = 'Entradas (aprobadas) requeridas';
$string['configmaxentries'] = 'Este valor determina el número máximo de entradas que pueden ser añadidas a una actividad Datalynx.';
$string['configmaxfields'] = 'Este valor determina el número máximo de campos que pueden ser añadidas a una actividad Datalynx.';
$string['configmaxfilters'] = 'Este valor determina el número máximo de filtros que pueden ser añadidas a una actividad Datalynx.';
$string['configmaxviews'] = 'Este valor determina el número máximo de vistas que pueden ser añadidas a una actividad Datalynx.';
$string['confirmbehaviordelete'] = '¡Usted está a punto de eliminar este comportamiento de campo!';
$string['confirmbehaviorduplicate'] = '¡Usted está a punto de duplicar este comportamiento de campo!';
$string['contains'] = 'contiene';
$string['convert'] = 'Convertir';
$string['converttoeditor'] = 'Convertir a campo de editor';
$string['copyof'] = 'Copia de {$a}';
$string['correct'] = 'Correcto';
$string['csscode'] = 'Código CSS';
$string['cssinclude'] = 'CSS';
$string['cssincludes'] = 'Incluir CSS externo';
$string['csssaved'] = 'CSS guardado';
$string['cssupload'] = 'Subir archivos CSSS';
$string['csvdelimiter'] = 'delimitador';
$string['csvfailed'] = 'No se pueden leer los datos crudos desde el archivo CSV';
$string['csvoutput'] = 'salida CSV';
$string['csvsettings'] = 'configuraciones CSV';
$string['csvwithselecteddelimiter'] = '<acronym title=\\"Valores Separados por Comas\\">CSV</acronym> texto con delimitador seleccionado:';
$string['custom'] = 'Plantilla personalizada';
$string['customfilter'] = 'Filtro personalizado';
$string['customfilteradd'] = 'Añadir un filtro personalizado';
$string['customfilternew'] = 'Nuevo filtro personalizado';
$string['customfilters'] = 'Filtros personalizados';
$string['customfiltersnoneindatalynx'] = 'No hay filtros personalizados definidos para este Datalynx.';
$string['datalynx:addinstance'] = 'Añadir un nuevo datalynx';
$string['datalynx:approve'] = 'Aprobar entradas so aprobadas';
$string['datalynx:comment'] = 'Escribir comentarios';
$string['datalynx:editprivilegeadmin'] = 'Privilegio de acceso editor admin';
$string['datalynx:editprivilegeguest'] = 'Privilegio de acceso editor invitado';
$string['datalynx:editprivilegemanager'] = 'Privilegio de acceso editor Mánager';
$string['datalynx:editprivilegestudent'] = 'Privilegio de acceso editor estudiante';
$string['datalynx:editprivilegeteacher'] = 'Privilegio de acceso editor profesor';
$string['datalynx:editrestrictedfields'] = 'Editar campos restringidos';
$string['datalynx:exportallentries'] = 'Exportar todas las entradas';
$string['datalynx:exportentry'] = 'Exportar entrada';
$string['datalynx:exportownentry'] = 'Exportar entradas propias';
$string['datalynx:managecomments'] = 'Gestionar comentarios';
$string['datalynx:manageentries'] = 'Gestionar entradas';
$string['datalynx:managepresets'] = 'gestionar preconfiguraciones';
$string['datalynx:manageratings'] = 'gestionar valoraciones';
$string['datalynx:managetemplates'] = 'gestionar plantillas';
$string['datalynx:notifycommentadded'] = 'Notificado sobre comentarios añadidos';
$string['datalynx:notifyentryadded'] = 'Notificado sobre entrada añadida';
$string['datalynx:notifyentryapproved'] = 'Notificado sobre entrada aprobada';
$string['datalynx:notifyentrydeleted'] = 'Notificado sobre entrada eliminada';
$string['datalynx:notifyentrydisapproved'] = 'Notificado sobre entrada des-aprobada';
$string['datalynx:notifyentryupdated'] = 'Notificado sobre entrada actualizada';
$string['datalynx:notifymemberadded'] = 'Informar usuarios acerca de ser añadidos como miembros de un equipo';
$string['datalynx:notifymemberremoved'] = 'Informar usuarios acerca de ser eliminados como miembros de un equipo';
$string['datalynx:notifyratingadded'] = 'Notificado sobre valoración añadida';
$string['datalynx:notifyratingupdated'] = 'Notificado sobre valoración actualizada';
$string['datalynx:notifyteamupdated'] = 'Notificado sobre equipo actualizado';
$string['datalynx:presetsviewall'] = 'Ver preconfiguraciones de todos los usuarios';
$string['datalynx:rate'] = 'Valorar entradas';
$string['datalynx:ratingsview'] = 'Ver valoraciones';
$string['datalynx:ratingsviewall'] = 'Ver todas las valoraciones';
$string['datalynx:ratingsviewany'] = 'Ver cualquier valoración';
$string['datalynx:teamsubscribe'] = 'Suscribirse a / unirse a equipos';
$string['datalynx:viewanonymousentry'] = 'Ver entradas anónimas';
$string['datalynx:viewdrafts'] = 'Ver borradores';
$string['datalynx:viewentry'] = 'Ver entradas';
$string['datalynx:viewindex'] = 'Ver índice';
$string['datalynx:viewprivilegeadmin'] = 'Privilegio de acceso de vista de administrador';
$string['datalynx:viewprivilegeguest'] = 'Privilegio de acceso de vista de invitado';
$string['datalynx:viewprivilegemanager'] = 'Privilegio de acceso de vista de mánager';
$string['datalynx:viewprivilegestudent'] = 'Privilegio de acceso de vista de estudiante';
$string['datalynx:viewprivilegeteacher'] = 'Privilegio de acceso de vista de profesor';
$string['datalynx:viewstatistics'] = 'Ver estadísticas';
$string['datalynx:writeentry'] = 'Escribir entradas';
$string['datalynx_commentadded'] = 'Comentario añadido';
$string['datalynx_csssaved'] = 'CSS personalizado guardado';
$string['datalynx_entryadded'] = 'Entrada añadida';
$string['datalynx_entryapproved'] = 'Entrada aprobada';
$string['datalynx_entrydeleted'] = 'Entrada eliminada';
$string['datalynx_entrydisapproved'] = 'Entrada des-aprobada';
$string['datalynx_entryupdated'] = 'Entrada actualizada';
$string['datalynx_jssaved'] = 'JavaScript personalizado guardado';
$string['datalynx_memberadded'] = 'Miembro de equipo añadido';
$string['datalynx_memberremoved'] = 'Miembro de equipo eliminado';
$string['datalynx_ratingadded'] = 'Valoración añadida';
$string['datalynx_ratingdeleted'] = 'Valoración eliminada';
$string['datalynx_ratingupdated'] = 'Valoración actualizada';
$string['datalynx_team_updated'] = 'Equipo actualizado';
$string['defaultbehavior'] = 'Comportamiento predeterminado';
$string['defaultfilterlabel'] = 'Filtro predeterminado ({$a})';
$string['deletenotenrolled'] = 'Eliminar entradas de usuarios no inscritos';
$string['deleteoption'] = '¿Eliminar?';
$string['deletetag'] = 'Eliminar marca';
$string['deletingbehavior'] = 'Eliminando comportamiento de campo "{$a}"';
$string['descending'] = 'Descendiente';
$string['dfintervalcount'] = 'Número de intervalos';
$string['dfintervalcount_help'] = 'Seleccionar cualtos intervalos deberían ser desbloqueados';
$string['dflateallow'] = 'Publicaciones tardías';
$string['dflateuse'] = 'Permitir publicaciones tardías';
$string['dfratingactivity'] = 'Calificación de actividad';
$string['dftimeavailable'] = 'Disponible a partir de';
$string['dftimedue'] = 'Fecha esperada';
$string['dftimeinterval'] = 'Pausar hasta que la entrada siguiente sea desbloqueada';
$string['dftimeinterval_help'] = 'Seleccionar un intervalo de tiempo hasta que la siguiente entrada sea desbloqueada para el usuario';
$string['dfupdatefailed'] = '¡No se pudo actualizar datalynx!';
$string['disabled'] = 'Mostrar elementos deshabilitados';
$string['disapproved'] = 'No aprobado';
$string['displaytemplate'] = 'Mostrar plantilla';
$string['documenttype'] = 'Tipo de documento';
$string['dots'] = '...';
$string['download'] = 'Descargar';
$string['duplicatename'] = 'El nombre ya existe. Por favor elija otro.';
$string['duplicatingbehavior'] = 'Duplicando comportamiento de campo "{$a}"';
$string['editable'] = 'Editable';
$string['editableby'] = 'Editable por';
$string['editing'] = 'Editando';
$string['editingbehavior'] = 'Editando comportamiento de campo "{$a}"';
$string['editmode'] = 'Modo de edición';
$string['editordisable'] = 'Deshabilitar editor';
$string['editorenable'] = 'Habilitar editor';
$string['edittemplate'] = 'Editar plantilla';
$string['email'] = 'Email';
$string['embed'] = 'Incrustar';
$string['empty'] = 'vacío';
$string['enabled'] = 'Habilitado';
$string['entries'] = 'Entradas';
$string['entriesadded'] = '{$a} entrada(s) añadida(s)';
$string['entriesanonymous'] = 'Permitir entradas anónimas';
$string['entriesappended'] = '{$a} entrada(s) anexada(s)';
$string['entriesapproved'] = '{$a} entrada(s) aprobada(s)';
$string['entriesconfirmadd'] = 'Usted está a punto de duplicar {$a} entrada(s) ¿Desea continuar?';
$string['entriesconfirmapprove'] = 'Usted está a punto de aprobar {$a} entrada(s) ¿Desea continuar?';
$string['entriesconfirmdelete'] = 'Usted está a punto de eliminar {$a} entrada(s) ¿Desea continuar?';
$string['entriesconfirmduplicate'] = 'Usted está a punto de duplicar {$a} entrada(s) ¿Desea continuar?';
$string['entriesconfirmupdate'] = 'Usted está a punto de actualizar {$a} entrada(s) ¿Desea continuar?';
$string['entriescount'] = '{$a} entrada(s)';
$string['entriesdeleteall'] = 'Eliminar todas las entradas';
$string['entriesdeleted'] = '{$a} entrada(s) eliminada(s)';
$string['entriesdisapproved'] = '{$a} entrada(s) des-aprobada(s)';
$string['entriesduplicated'] = '{$a} entrada(s) duplicada(s)';
$string['entriesfound'] = '{$a} entrada(s) encontrada(s)';
$string['entriesimport'] = 'Importar entradas';
$string['entrieslefttoadd'] = 'Usted debe añadir {$a} entrada(s) más para completar esta actividad';
$string['entrieslefttoaddtoview'] = 'Usted debe añadir {$a} entrada(s) más antes de que pueda ver las entradas de otros participantes.';
$string['entriesmax'] = 'Máximo de entradas';
$string['entriesmax_help'] = 'Número de entradas permitidas. -1 permite entradas ilimitadas';
$string['entriesnotsaved'] = 'No se guardó ninguna entrada. Por favor revise el formato del archivo subido.';
$string['entriespending'] = 'Pendiente';
$string['entriesrequired'] = 'Entradas requeridas';
$string['entriessaved'] = '{$a} entrada(s) guardada(s)';
$string['entriestoview'] = 'Entradas requeridas antes de ver';
$string['entriesupdated'] = '{$a} entrada(s) actualizada(s)';
$string['entry'] = 'Entrada';
$string['entryaddmultinew'] = 'Añadir nuevas entradas';
$string['entryaddnew'] = 'Añadir una nueva entrada';
$string['entryauthor'] = 'Autor de la entrada';
$string['entryinfo'] = 'Info de la entrada';
$string['entrylockonapproval'] = 'bloquear cuando sea aprobada';
$string['entrylockoncomments'] = 'bloquear cuando sea comentada';
$string['entrylockonratings'] = 'bloquear cuando sea valorada';
$string['entrylocks'] = 'Bloqueos de entrada';
$string['entrynew'] = 'Nueva entrada';
$string['entrynoneforaction'] = 'No se encontraron entradas para la acción solicitada';
$string['entrynoneindatalynx'] = 'Sin entradas en datalynx';
$string['entryrating'] = 'Valoración de entrada';
$string['entrysaved'] = 'Su entrada ha sido guardada';
$string['entrysettings'] = 'Configuraciones de entrada';
$string['entrysettingsupdated'] = 'Configuraciones de entrada actualizadas';
$string['entrytemplate'] = 'Plantilla de entrada';
$string['entrytemplate_help'] = 'Plantilla de entrada';
$string['entrytimelimit'] = 'Límite de tiempo de edición (minutos)';
$string['entrytimelimit_help'] = 'Minutos para que la edición sea deshabilitada, -1 es sin límite';
$string['equal'] = 'igual a';
$string['err_numeric'] = 'Usted debe ingresar un número aquí. Ejemplo: 0.00 o 0.3 o 387';
$string['event_comment_created'] = 'Comentario creado';
$string['event_entry_approved'] = 'Comentario aprobado';
$string['event_entry_created'] = 'Entrada creada';
$string['event_entry_deleted'] = 'Entrada eliminada';
$string['event_entry_disapproved'] = 'Entrada des-aprobada';
$string['event_entry_updated'] = 'Entrada actualizada';
$string['event_rating_added'] = 'Valoración añadida';
$string['event_rating_deleted'] = 'Valoración eliminada';
$string['event_rating_updated'] = 'Valoración actualizada';
$string['event_team_updated'] = 'Equipo actualizado';
$string['eventsettings'] = 'Configuraciones de evento';
$string['exactly'] = 'exactamente';
$string['existingoptions'] = 'Editar opciones existentes';
$string['export'] = 'Exportar';
$string['exportadd'] = 'Añadir una nueva vista de exportación';
$string['exportall'] = 'Exportar todo';
$string['exportcontent'] = 'Exportar contenido';
$string['exportnoneindatalynx'] = 'No hay exportaciones definidas para este datalynx.';
$string['exportpage'] = 'Exportar página';
$string['field'] = 'Campo';
$string['field_has_duplicate_entries'] = '¡Existen entradas duplicadas, por lo que no es posible configurar este campo a Único:,"Sí" actualmente!';
$string['fieldadd'] = 'Añadir un campo';
$string['fieldallowautolink'] = 'Permitir auto-enlace';
$string['fieldattributes'] = 'Atributos del campo';
$string['fieldcreate'] = 'Crear un nuevo campo';
$string['fielddescription'] = 'Descripción del campo';
$string['fieldedit'] = 'Editando \'{$a}\'';
$string['fieldeditable'] = 'Editable';
$string['fieldedits'] = 'Número de ediciones';
$string['fieldids'] = 'IDs del campo';
$string['fieldlabel'] = 'Etiqueta del campo';
$string['fieldlist'] = 'Campos buscables';
$string['fieldmappings'] = 'Mapeos de Campo';
$string['fieldname'] = 'Nombre del campo';
$string['fieldnew'] = 'Nuevo campo {$a}';
$string['fieldnoneforaction'] = 'No se encontraron campos para la acción solicitada';
$string['fieldnoneindatalynx'] = 'No hay campos definidos para este datalynx.';
$string['fieldnonematching'] = 'No se encontraron campos coincidentes';
$string['fieldnotmatched'] = 'Los siguientes campos en su archivo no son conocidos en este datalynx: {$a}';
$string['fieldoptions'] = 'Opciones (una por línea)';
$string['fieldoptionsdefault'] = 'Valores predeterminados (uno por línea)';
$string['fieldoptionsseparator'] = 'Separador de opciones';
$string['fieldrequired'] = 'Usted debe proporcionar un valor aquí.';
$string['fieldrules'] = 'Reglas para edición de campo';
$string['fields'] = 'Campos';
$string['fieldsadded'] = 'Campos añadidos';
$string['fieldsconfirmdelete'] = 'Usted está a punto de eliminar {$a} campo(s). ¿Desea proceder?';
$string['fieldsconfirmduplicate'] = 'Usted está a punto de duplicar {$a} campo(s). ¿Desea proceder?';
$string['fieldsdeleted'] = 'Campos eliminados. Usted podría necesitar actualizar las configuraciones de ordenamiento predeterminado.';
$string['fieldsmax'] = 'Máximo de campos';
$string['fieldsnonedefined'] = 'Sin campos definidos';
$string['fieldsupdated'] = 'Campos actualizados';
$string['fieldtype'] = 'Tipo de campo';
$string['fieldvisibility'] = 'Visble para';
$string['fieldvisibleall'] = 'Todos';
$string['fieldvisiblenone'] = 'Sólamente mánagers';
$string['fieldvisibleowner'] = 'Propietario y mánagers';
$string['fieldwidth'] = 'Ancho';
$string['fileexist'] = 'existe';
$string['filemaxsize'] = 'Tamaño total de archivos subidos';
$string['filemissing'] = 'faltante';
$string['filesmax'] = 'Número máximo de archivos subidos';
$string['filetypeany'] = 'Cualquier tipo de archivo';
$string['filetypeaudio'] = 'Archivos de audio';
$string['filetypegif'] = 'Archivos GIF';
$string['filetypehtml'] = 'Archivos HTML';
$string['filetypeimage'] = 'Archivos de imágenes';
$string['filetypejpg'] = 'Archivos JPG';
$string['filetypepng'] = 'Archivos PNG';
$string['filetypes'] = 'Tipos de archivos aceptados';
$string['filter'] = 'Filtrar';
$string['filteradd'] = 'Añadir un filtro';
$string['filteradvanced'] = 'Filtro personalizado';
$string['filterbypage'] = 'Por página';
$string['filtercancel'] = 'Cancelar filtro';
$string['filtercreate'] = 'Crear un nuevo filtro';
$string['filtercurrent'] = 'Filtro actual';
$string['filtercustomsearch'] = 'Opciones de búsqueda';
$string['filtercustomsort'] = 'Opciones de ordenamiento';
$string['filterdescription'] = 'Descripción del filtro';
$string['filteredit'] = 'Editando \'{$a}\'';
$string['filterformadd'] = 'Añadir nuevo formato de filtro';
$string['filterforms'] = 'Formatos de filtro';
$string['filtergroupby'] = 'Agrupar por';
$string['filterincomplete'] = 'Las condiciones de búsqueda deben ser completadas.';
$string['filtermy'] = 'Mi filtro';
$string['filtername'] = 'Auto-enlace Datalynx';
$string['filternew'] = 'Nuevo filtro';
$string['filternoneforaction'] = 'No se encontraron filtros para la acción solicitada';
$string['filterperpage'] = 'Por página';
$string['filters'] = 'Filtros';
$string['filtersadded'] = '{$a} filtro(s) añadido(s)';
$string['filtersave'] = 'Guardar filtro';
$string['filtersconfirmdelete'] = 'Usted está a punto de eliminar {$a} filtro(s). ¿Desea proceder?';
$string['filtersconfirmduplicate'] = 'Usted está a punto de duplicar {$a} filtro(s). ¿Desea proceder?';
$string['filtersdeleted'] = '{$a} filtro(s) eliminado(s)';
$string['filtersduplicated'] = '{$a} filtro(s) duplicado(s)';
$string['filtersearchfieldlabel'] = 'Buscar campo';
$string['filterselection'] = 'Selección';
$string['filtersimplesearch'] = 'Búsqueda simple';
$string['filtersmax'] = 'Máximo de filtros';
$string['filtersnonedefined'] = 'Sin filtros definidos';
$string['filtersnoneindatalynx'] = 'No hay filtros definidos para este Datalynx.';
$string['filtersortfieldlabel'] = 'Ordenar campo';
$string['filtersupdated'] = '{$a} filtro(s) actualizado(s)';
$string['filterupdate'] = 'Actualizar un filtro existente';
$string['filterurlquery'] = 'consulta de URL';
$string['filteruserreset'] = '** Reiniciar mi filtro';
$string['first'] = 'Primero';
$string['firstdayofweek'] = 'Lunes';
$string['formemptyadd'] = '¡Usted no llenó ningún campo!';
$string['fromaftertoday_error'] = '¡La fecha para \'Desde\' no puede configurarse a después de la fecha de hoy!';
$string['fromdate'] = 'Desde fecha';
$string['fromfile'] = 'Importar de archivo ZIP';
$string['fromto_error'] = '¡La fecha para \'Desde\' no puede configurarse a después para \'Hasta\'!';
$string['generalactions'] = 'Acciones generales';
$string['grade'] = 'Calificación';
$string['gradeinputtype'] = 'Tipo de ingreso de calificación';
$string['gradeitem'] = 'Ítem de calificación';
$string['grading'] = 'Calificación';
$string['gradingmethod'] = 'Método de calificación';
$string['gradingsettings'] = 'Configuraciones de calificación de actividad';
$string['greater_equal'] = 'mayor o igual a';
$string['greater_than'] = 'mayor de';
$string['groupentries'] = 'Entradas del grupo';
$string['groupinfo'] = 'Información del grupo';
$string['guest'] = 'Invitado';
$string['headercss'] = 'Estilos CSS personalizados para todas las vistas';
$string['headerjs'] = 'JavaScript personalizado para todas las vistas';
$string['hidden'] = 'Oculto';
$string['hideline'] = 'Ocultar la última línea';
$string['horizontal'] = 'Horizontal';
$string['iamteammember'] = 'Yo soy un miembrodelequipo';
$string['id'] = 'ID';
$string['import'] = 'Importar';
$string['importadd'] = 'Añadir una nueva vista de importación';
$string['importnoneindatalynx'] = 'No hay importaciones definidas  para este Datalynx.';
$string['in'] = 'en';
$string['incorrect'] = 'Incorrecto';
$string['index'] = 'Índice';
$string['insufficiententries'] = 'se necesitan más entradas para ver este Datalynx';
$string['internal'] = 'Interno';
$string['intro'] = 'Introducción';
$string['invalidname'] = 'Por favor elija otro nombre para este {$a}';
$string['invalidrate'] = 'Tasa de datalynx inválida ({$a})';
$string['invalidurl'] = 'La URL que recién ingresó no es válida';
$string['isdefault'] = 'Vista p´redeterminada';
$string['isedit'] = 'Editar vista';
$string['ismore'] = 'Vista detallada';
$string['jscode'] = 'código JavaScript';
$string['jsincludes'] = 'Incluir JavaScript externo';
$string['jssaved'] = 'JavaScript guardado';
$string['jsupload'] = 'Subir archivos JavaScript';
$string['label'] = 'Etiqueta';
$string['less_equal'] = 'menor o igual a';
$string['less_than'] = 'menor que';
$string['limitchoice'] = 'Limitar opciones para usuarios';
$string['limitchoice_error'] = '¡Usted ya ha seleccionado a la opción \'{$a}\' el número máximo permitido de veces!';
$string['limitchoice_help'] = 'Habilite esto para impedir que un usuario elija la misma opción más del número de veces elegida en entradas separadas.';
$string['line'] = 'Línea';
$string['linksettings'] = 'Configuraciones de enlace de mensaje';
$string['linktoentry'] = 'Enlazar a entrada';
$string['listformat'] = 'Forlato de lista';
$string['listformat_comma'] = 'Separado por comas';
$string['listformat_commaspace'] = 'Separado por comas con espacio';
$string['listformat_newline'] = 'Separado por línea nueva';
$string['listformat_space'] = 'Separado por espacio';
$string['listformat_ul'] = 'Lista desordenada';
$string['lock'] = 'Bloquear';
$string['manage'] = 'Gestionar';
$string['managemode'] = 'Modo de gestionar';
$string['manager'] = 'Mánager';
$string['mappingwarning'] = 'Todos los campos antiguos que no estén mapeados a un nuevo campo serán perdido y todos los datos en ese campo serán eliminados.';
$string['max'] = 'Máximo';
$string['maxsize'] = 'Tamaño máximo';
$string['maxteamsize_error_form'] = '¡Usted puede seleccionar solamente un máximo de  {$a} miembros del equipo!';
$string['me'] = 'Yo, a mí';
$string['mediafile'] = 'Archivo de medio';
$string['message_comment_created'] = 'Hola {$a->fullname},

el comentario siguiente fue añadido por {$a->senderprofilelink} a esta entrada: {$a->viewlink}:


{$a->commenttext}';
$string['message_entry_approved'] = 'Hola {$a->fullname},

el contenido en {$a->datalynxlink} ha sido aprobado por  {$a->senderprofilelink}.

La entrada siguiente ha sido aprobada: {$a->viewlink}.';
$string['message_entry_created'] = 'Hola {$a->fullname},

el contenido en {$a->datalynxlink} ha sido modificado por {$a->senderprofilelink}.

La entrada siguiente ha sido creada: {$a->viewlink}.';
$string['message_rating_added'] = 'Valoración Datalynx añadida';
$string['message_rating_updated'] = 'Valoración Datalynx actualizada';
$string['messageprovider:event_comment_created'] = 'Comentario Datalynx creado';
$string['messageprovider:event_entry_approved'] = 'Entrada Datalynx aprobada';
$string['messageprovider:event_entry_created'] = 'Entrada Datalynx creada';
$string['messageprovider:event_entry_deleted'] = 'Entrada Datalynx eliminada';
$string['messageprovider:event_entry_disapproved'] = 'Entrada Datalynx des-aprobada';
$string['messageprovider:event_entry_updated'] = 'Entrada Datalynx actualizada';
$string['messageprovider:event_rating_added'] = 'Valoración Datalynx añadida';
$string['messageprovider:event_rating_updated'] = 'Valoración Datalynx actualizada';
$string['messageprovider:event_team_updated'] = 'Equipo de entrada Datalynx actualizado';
$string['min'] = 'Mínimo';
$string['minteamsize'] = 'Tamaño mínimo del equipo';
$string['minteamsize_error_form'] = '¡Usted debe seleccionar a por lo menos {$a} miembros del equipo!';
$string['modearray'] = 'Modo de visualización';
$string['modulename'] = 'Datalynx';
$string['modulenameplural'] = 'Datalynxs';
$string['more'] = 'Más';
$string['moreresults'] = '({$a} resultados más...)';
$string['movezipfailed'] = 'No se puede mover ZIP';
$string['multiapprove'] = 'Aprobar';
$string['multidelete'] = 'Eliminar';
$string['multidownload'] = 'Descargar';
$string['multiduplicate'] = 'Duplicar';
$string['multiedit'] = 'Editar';
$string['multiexport'] = 'Exportar';
$string['multipletags'] = '¡Marcas múltiples encontradas! Vista no guardada';
$string['multiselect'] = 'Multi-selección';
$string['multishare'] = 'Compartir';
$string['newbehavior'] = 'Nuevo comportamiento de campo';
$string['newfilterform'] = 'Nuevo formato de filtro';
$string['newvalue'] = 'Nuevo valor';
$string['newvalueallow'] = 'Añadir nuevos valores';
$string['noaccess'] = 'Usted no tiene acceso a esta página';
$string['noautocompletion'] = 'Sin auto-llenado';
$string['nodatalynxs'] = 'No se encontraron módulos Datalynx';
$string['noedit'] = 'No editable';
$string['noentries'] = 'No hay entradas para mostrar';
$string['nomatch'] = '¡No se encontraron entradas coincidentes!';
$string['nomaximum'] = 'Sin máximo';
$string['nooptions'] = '¡Usted debe especificar al menos una opción!';
$string['nopermission'] = 'Usted no tiene permiso para ver entradas específicas.';
$string['nosuchentries'] = 'Sin entradas disponibles.';
$string['not'] = 'NO';
$string['notallowedtoeditentry'] = 'No tiene permitido editar esta entrada.';
$string['notapproved'] = 'La entrada aun no está aprobada.';
$string['noteditable'] = 'Cuando no sea editable';
$string['notemplate'] = 'Sin plantilla';
$string['notificationenable'] = 'Habilitar notificaciones para';
$string['notifyteam'] = 'Regla de notificación';
$string['notifyteam_help'] = 'Seleccionar regla de notificación a ser aplicada a todos los miembros del equipo seleccionados en este campo.';
$string['notifyteammembers'] = 'Notificar a miembros del equipo';
$string['notifyteammembers_help'] = 'Seleccionar esta opción para informar a miembros del equipo sobre el cambio del estado de su membresía.';
$string['notinjectivemap'] = 'No es un mapa inyectivo';
$string['notopenyet'] = 'Lo sentimos; esta actividad no estará disponible sino hasta después de {$a}';
$string['notrequired'] = 'No requerido';
$string['notvisible'] = 'Cuando no sea visible';
$string['novalue'] = 'Cuando esté vacío';
$string['noviewsavailable'] = 'Sin vistas disponibles';
$string['numapprovedentries'] = 'Número de entradas aprobadas';
$string['numberrssarticles'] = 'Artículos RSS';
$string['numcharsallowed'] = 'Número de caracteres';
$string['numdeletedentries'] = 'Número de entradas eliminadas';
$string['numtotalentries'] = 'Número de entradas creadas';
$string['numvisits'] = 'Número de visitas';
$string['ondate'] = 'En la fecha';
$string['option'] = 'Opción';
$string['optionaldescription'] = 'Descripción breve (opcional)';
$string['optionalfilename'] = 'Nombredearchivo (opcional)';
$string['or'] = 'O';
$string['other'] = 'Otro';
$string['otheruser'] = 'Otro usuario';
$string['overwrite'] = 'Sobrescribir';
$string['overwritesettings'] = 'Sobrescribir configuraciones actuales';
$string['page-mod-datalynx-x'] = 'Cualquier página de módulo de actividad Datalynx';
$string['pagesize'] = 'Entradas por página';
$string['pagingnextslide'] = 'Siguiente deslizador';
$string['pagingpreviousslide'] = 'Anterior deslizador';
$string['participants'] = 'Participantes';
$string['period'] = 'Período';
$string['pleaseaddsome'] = 'Por favor cree algunos debajo o  {$a} para comenzar.';
$string['pluginadministration'] = 'Administración de actividad Datalynx';
$string['pluginname'] = 'Datalynx';
$string['porttypeblank'] = 'Entradas vacías';
$string['porttypecsv'] = 'CSV';
$string['presetadd'] = 'Añadir preconfiguraciones';
$string['presetapply'] = 'Aplicar';
$string['presetavailableincourse'] = 'Preconfiguraciones del curso';
$string['presetavailableinsite'] = 'Preconfiguraciones del sitio';
$string['presetdata'] = 'con datos del usuario';
$string['presetdataanon'] = 'con datos anonimizados del usuario';
$string['presetfaileddelete'] = '¡Error al eliminar una preconfiguración!';
$string['presetfromdatalynx'] = 'Hacer una preconfiguración de este Datalynx';
$string['presetfromfile'] = 'Subir preconfiguración desde archivo';
$string['presetimportsuccess'] = 'La preconfiguración ha sido aplicada exitosamente.';
$string['presetinfo'] = 'Al guerdar como una preconfiguración, se publicará esta vista. Otros usuarios podrán usarla en sus Datalynxes.';
$string['presetmap'] = 'campos del mapa';
$string['presetnodata'] = 'sin datos del usuario';
$string['presetnodefinedfields'] = '¡La nueva preconfiguración no tiene campos definidos!';
$string['presetnodefinedviews'] = '¡La nueva preconfiguración no tiene vistas definidas!';
$string['presetnoneavailable'] = 'Sin preconfiguraciones disponibles para mostrar';
$string['presetplugin'] = 'Enchufar';
$string['presetrefreshlist'] = 'Refrescar lista';
$string['presets'] = 'Preconfiguraciones';
$string['presetshare'] = 'Compartir';
$string['presetsharesuccess'] = 'Guardada exitosamente. Su preconfiguración estará disponible para todo el sitio.';
$string['presetsource'] = 'Origen de preconfiguración';
$string['presetusestandard'] = 'Usar una preconfiguración';
$string['privacy:metadata:datalynx_contents'] = 'Representa contenido de un campo que fue escrito en una instancia Datalynx.';
$string['privacy:metadata:datalynx_contents:content'] = 'Contenido';
$string['privacy:metadata:datalynx_contents:content1'] = 'Contenido adicional 1';
$string['privacy:metadata:datalynx_contents:content2'] = 'Contenido adicional 2';
$string['privacy:metadata:datalynx_contents:content3'] = 'Contenido adicional 3';
$string['privacy:metadata:datalynx_contents:content4'] = 'Contenido adicional 4';
$string['privacy:metadata:datalynx_contents:fieldid'] = 'ID de definición del campo';
$string['privacy:metadata:datalynx_entries'] = 'Representa entradas en una instancia Datalynx.';
$string['privacy:metadata:datalynx_entries:approved'] = 'Estado de aprobación';
$string['privacy:metadata:datalynx_entries:assessed'] = 'Mostrar si es que la instancia fue valorada';
$string['privacy:metadata:datalynx_entries:groupid'] = 'Grupo';
$string['privacy:metadata:datalynx_entries:status'] = 'Estado de esta entrada';
$string['privacy:metadata:datalynx_entries:timecreated'] = 'Hora de cuando fue creado el registro';
$string['privacy:metadata:datalynx_entries:timemodified'] = 'Hora de cuando fue modificado por última vez el registro';
$string['privacy:metadata:datalynx_entries:userid'] = 'Usuario que creó el registro';
$string['privacy:metadata:filepurpose'] = 'Archivo o imagen anexa a una instancia Datalynx.';
$string['random'] = 'Aleatorio';
$string['randomone'] = 'Un aleatorio';
$string['range'] = 'Rango';
$string['rate'] = 'Tasa';
$string['rating'] = 'Valoración';
$string['ratingmanual'] = 'Manual';
$string['ratingmethod'] = 'Método de valoración';
$string['ratingno'] = 'Sin valoraciones';
$string['ratingpublic'] = '{$a} puede ver valoraciones de todos';
$string['ratingpublicnot'] = '{$a} solamente puede ver sus propias valoraciones';
$string['ratings'] = 'Valoraciones';
$string['ratingsaggregate'] = '{$a->value} ({$a->method} de {$a->count ratings})';
$string['ratingsavg'] = 'Promedio de valoraciones';
$string['ratingscount'] = 'Número de valoraciones';
$string['ratingsmax'] = 'Valoración más alta';
$string['ratingsmin'] = 'Valoración más baja';
$string['ratingsnone'] = '---';
$string['ratingssaved'] = 'Valoraciones guardadas';
$string['ratingssum'] = 'Suma de valoraciones';
$string['ratingsview'] = 'Ver valoraciones';
$string['ratingsviewrate'] = 'Ver y valorar';
$string['ratingvalue'] = 'Valor de valoración';
$string['redirectsettings'] = 'Redireccionar en opciones de envío';
$string['redirectto'] = 'Vista de destino';
$string['reference'] = 'Referencia';
$string['referencefield'] = 'Campo de referencia';
$string['renameoption'] = 'Renombrar a:';
$string['requireapproval'] = '¿Requerir aprobación?';
$string['required'] = 'Requerido';
$string['requiredall'] = 'todo requerido';
$string['requirednotall'] = 'no todo requerido';
$string['resetsettings'] = 'Reiniciar filtros';
$string['returntoimport'] = 'Regresar a Importar';
$string['rsstemplate'] = 'Plantilla RSSS';
$string['rsstitletemplate'] = 'plantilla de título RSSS';
$string['rule'] = 'regla';
$string['ruleaction'] = 'Acción de regla';
$string['ruleadd'] = 'Añadir una regla';
$string['rulecancel'] = 'Cancelar regla';
$string['rulecondition'] = 'Condición';
$string['rulecreate'] = 'Crear una nueva regla';
$string['ruledenydelete'] = 'Impedir eliminación de entrada';
$string['ruledenyedit'] = 'Impedir edición de entrada';
$string['ruledenyview'] = 'Ocultar entrada a todos';
$string['ruledenyviewbyother'] = 'Ocultar entrada a todos excepto al propietario';
$string['ruledescription'] = 'Descripción de regla';
$string['ruleedit'] = 'Editando \'{$a}\'';
$string['ruleenabled'] = 'Habilitado';
$string['rulename'] = 'Auto-enlace Datalynx';
$string['rulenew'] = 'Nueva regla {$a}';
$string['rulenoneforaction'] = 'No se encontraron reglas para la acción solicitada';
$string['rules'] = 'Reglas';
$string['rulesadded'] = '{$a} regla(s) añadida(s)';
$string['rulesave'] = 'Guardar regla';
$string['rulesconfirmdelete'] = 'Usted está a punto de eliminar {$a} regla(s). ¿Desea proceder?';
$string['rulesconfirmduplicate'] = 'Usted está a punto de duplicar {$a} regla(s). ¿Desea proceder?';
$string['rulesdeleted'] = '{$a} regla(s) eliminada(s)';
$string['rulesduplicated'] = '{$a} regla(s) duplicada(s)';
$string['rulesmax'] = 'Máximo de reglas';
$string['rulesnonedefined'] = 'Sin reglas definidas';
$string['rulesnoneindatalynx'] = 'No hay reglas definidas para este Datalynx.';
$string['rulesupdated'] = '{$a} regla(s)actualizada(s)';
$string['ruleupdate'] = 'Actualizar una regla  existente';
$string['saveasstandardtags'] = '¿Guardar marcas como marcas estándar para sugerirlas cuando se añada o actualice alguna entrada?';
$string['savecontinue'] = 'Guardar y continuar';
$string['search'] = 'Buscar';
$string['search:activity'] = 'Datalynx - instancias';
$string['selectuser'] = 'Seleccionar usuario...';
$string['sendinratings'] = 'Enviar mis últimas valoraciones';
$string['separateentries'] = 'Cada entrada en un archivo separado';
$string['separateparticipants'] = 'Separar participantes';
$string['setdefault'] = 'Configurar como vista predeterminada';
$string['setedit'] = 'Configurar como vista para editar';
$string['setmore'] = 'Configurar como vista detallada';
$string['settings'] = 'Configuraciones';
$string['showall'] = 'Mostrar todas las entradas';
$string['shownothing'] = 'No mostrar nada';
$string['singleedit'] = 'E';
$string['singlemore'] = 'M';
$string['sortable'] = 'ordenable';
$string['spreadsheettype'] = 'Tipo de Hoja de Cálculo';
$string['statistics'] = 'Estadísticas';
$string['statisticsfor'] = 'Estadísticas para \'{$a}\'';
$string['status'] = 'Estado';
$string['status_draft'] = 'Borrador';
$string['status_finalsubmission'] = 'Envío final';
$string['status_notcreated'] = 'No configurado';
$string['status_submission'] = 'Envío';
$string['statusrequired'] = '¡Debe configurarse el Estado!';
$string['student'] = 'Estudiante';
$string['submission'] = 'Envío';
$string['submissionsinpopup'] = 'Envíos en ventana emergente';
$string['submissionsview'] = 'VVista de envíos';
$string['subplugintype_datalynxfield'] = 'Tipo de campo Datalynx';
$string['subplugintype_datalynxfield_plural'] = 'Tipos de campo Datalynx';
$string['subplugintype_datalynxrule'] = 'Tipo de regla Datalynx';
$string['subplugintype_datalynxrule_plural'] = 'Tipos de regla Datalynx';
$string['subplugintype_datalynxtool'] = 'Tipo de herramienta Datalynx';
$string['subplugintype_datalynxtool_plural'] = 'Tipos de herramienta Datalynx';
$string['subplugintype_datalynxview'] = 'Tipo de vista Datalynx';
$string['subplugintype_datalynxview_plural'] = 'Tipos de vista Datalynx';
$string['subscribe'] = 'Suscribir';
$string['tagarea_datalynx_contents'] = 'ENTRADAS dATALYNX';
$string['tagcollection_datalynx'] = 'mARCAS dATALYNX';
$string['tagproperties'] = '{$a->tagtype} propiedades de marca: {$a->tagname}';
$string['targetview_default'] = '(Predeterminado)';
$string['targetview_edit'] = '(Editar)';
$string['targetview_more'] = '(Más)';
$string['targetview_this'] = '(Esta vista)';
$string['targetview_this_new'] = 'Esta vista (nueva)';
$string['targetviewforroles'] = 'Enlazar vistas de destino para roles';
$string['teacher'] = 'Profesor';
$string['teachersandstudents'] = '{$a->teachers} y {$a->students}';
$string['teamfield'] = 'Campo del equipo';
$string['teammembers'] = 'Miembros del equipo';
$string['teammemberselectmultiple'] = '¡Una persona solamente puede ser seleccionada una sola vez como un miembro del equipo!';
$string['teams'] = 'Equipos';
$string['teamsize'] = 'Tamaño máximo del equipo';
$string['teamsize_error_required'] = '¡Este campo es obligatorio!';
$string['teamsize_error_value'] = '¡El valor debe ser un número entero positivo!';
$string['teamsize_help'] = 'Especificar el tamaño máximo del equipo. debe ser un número entero positivo.';
$string['textbox'] = 'Caja de texto';
$string['thisfield'] = 'Este campo';
$string['time_field_required'] = '!El campo {$a} es obligatorio!';
$string['timecreated'] = 'Hora de creación';
$string['timemodified'] = 'Hora de modificación';
$string['timestring0'] = 'desde {$a->from} hasta {$a->to}';
$string['timestring1'] = 'en {$a->from}';
$string['timestring2'] = 'hasta antes de {$a->to}';
$string['timestring3'] = 'desde {$a->from} hasta ahora mismo ({$a->now})';
$string['timestring4'] = 'hasta ahora mismo ({$a->now})';
$string['todatalynx'] = 'a este Datalynx.';
$string['todate'] = 'A la fecha';
$string['toolnoneindatalynx'] = 'No hay herramientas definidas para este Datalynx';
$string['toolrun'] = 'Ejecutar';
$string['tools'] = 'Herramientas';
$string['triggeringevent'] = 'Evento disparador';
$string['type'] = 'Tipo';
$string['unique'] = 'Único';
$string['unique_required'] = '¡Texto único requerido! ¡Este texto ya fue utilizado!';
$string['unlock'] = 'Desbloquear';
$string['unsubscribe'] = 'Des-suscribir';
$string['updateexisting'] = 'Sobrescribir existentes';
$string['updatefield'] = 'Actualizar un campo existente';
$string['updateview'] = 'Actualizar una vista existente';
$string['uploadfile'] = 'Archivo a importar';
$string['uploadtext'] = 'Texto a importar';
$string['urlclass'] = 'Clases CSSS';
$string['user_can_add_self'] = 'Usuario puede añadirse él mismo  / ella misma';
$string['user_can_add_self_help'] = 'Activar esta opción para permitirle al usuario poseedor de la entrada que se añada a sí mismo al equipo en este  campo.';
$string['userfields'] = 'Campos definidos por el usuario';
$string['userinfo'] = 'Información del usuario';
$string['useristeammember'] = 'Un usuario es miembrodelequipo';
$string['userpref'] = 'Preferencias del usuario';
$string['usersubmissions'] = 'Envíos del usuario';
$string['usersubmissionsinpopup'] = 'Envío del usuario en ventana emergente';
$string['usersubmissionsview'] = 'Vista de envíos de usuario';
$string['vertical'] = 'Vertical';
$string['view'] = 'vista';
$string['viewadd'] = 'Añadir una vista';
$string['viewcharactertags'] = 'Marcas de caracter';
$string['viewcreate'] = 'Crear una nueva vista';
$string['viewcurrent'] = 'Vista actual';
$string['viewcustomdays'] = 'Días de intervalo de refresco personalizado';
$string['viewcustomhours'] = 'Horas de intervalo de refresco personalizado';
$string['viewcustomminutes'] = 'Minutos de intervalo de refresco personalizado';
$string['viewdescription'] = 'Descripción de vista';
$string['viewedit'] = 'Editando \'{$a}\'';
$string['vieweditthis'] = 'Editar esta vista';
$string['viewfieldtags'] = 'Marcas del campo';
$string['viewfilter'] = 'Filtro';
$string['viewforedit'] = 'Vista para \'editar\'';
$string['viewformore'] = 'Vista para \'más\'';
$string['viewfoverride'] = 'Cualquier usuario puede anular este filtro.';
$string['viewfoverride_help'] = 'El uso inapropiado de esta característica puede mostrar información que no se quería  mostrar, téngalo en cuenta si la usa.';
$string['viewfromdate'] = 'Visible desde';
$string['viewgeneral'] = 'Configuraciones de vista general';
$string['viewgeneral_help'] = 'Configuraciones de vista general';
$string['viewgeneraltags'] = 'Marcas generales';
$string['viewgroupby'] = 'Agrupar por';
$string['viewinterval'] = 'Cuando refrescar ver contenidos';
$string['viewintervalsettings'] = 'Configuraciones del intervalo';
$string['viewlistfooter'] = 'pie de página de lista';
$string['viewlistheader'] = 'encabezado de lista';
$string['viewname'] = 'Nombre de vista';
$string['viewnew'] = 'Nueva vista {$a}';
$string['viewnoneforaction'] = 'No se encontraron vistas para la acción solicitada';
$string['viewnoneindatalynx'] = 'No hay vistas definidas para este datalynx.';
$string['viewoptions'] = 'Opciones de vista';
$string['viewperpage'] = 'Por página';
$string['viewrepeatedfields'] = 'Usted no puede usar el campo {$a} más de una vez.';
$string['viewresettodefault'] = 'Reiniciar a predeterminado';
$string['viewreturntolist'] = 'Regresar a lista';
$string['views'] = 'Vistas';
$string['viewsadded'] = 'Vista añadidad';
$string['viewsconfirmdelete'] = 'Usted está a punto de eliminar {$a} vista(s). ¿Desea proceder?';
$string['viewsconfirmduplicate'] = 'Usted está a punto de duplicar {$a} vista(s). ¿Desea proceder?';
$string['viewsdeleted'] = 'Vista eliminada';
$string['viewsectionpos'] = 'Posición de sección';
$string['viewsmax'] = 'Máximo de vistas';
$string['viewsupdated'] = 'Vista actualizada';
$string['viewtemplate'] = 'Ver plantilla';
$string['viewtemplate_help'] = 'Ver plantilla';
$string['viewtodate'] = 'Visible para';
$string['viewvisibility'] = 'Visibilidad';
$string['visibility'] = 'Visibilidad';
$string['visible_1'] = 'Mánager';
$string['visible_2'] = 'Profesor';
$string['visible_4'] = 'Estudiante';
$string['visible_8'] = 'Invitado';
$string['visibleto'] = 'Visible para';
$string['wrongdataid'] = 'ID satalix equivocada proporcionada';
