<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'fr', version '4.3'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acessar'] = 'Accéder au cours';
$string['background_color'] = 'Couleur d’arrière-plan';
$string['background_color_black'] = 'Thème noir {$a}';
$string['background_color_blue'] = 'Thème bleu {$a}';
$string['background_color_default'] = 'Thème par défaut {$a}';
$string['background_color_desc'] = 'Couleur de sprite !';
$string['background_color_green'] = 'Thème vert {a}';
$string['background_color_random'] = 'Thème aléatoire {a}';
$string['background_color_red'] = 'Thème rouge {a}';
$string['choosereadme'] = 'Degrade est un thème créé avec soin pour apporter des couleurs vives à Moodle.';
$string['contact_address'] = 'Adresse';
$string['contact_email'] = 'E-mail';
$string['contact_phone'] = 'Numéro de téléphone';
$string['content_type_default'] = 'Par défaut Moodle';
$string['content_type_empty'] = '(Aucun contenu)';
$string['content_type_footer'] = 'Type de contenu pour le pied de page';
$string['content_type_footer_desc'] = 'Sélectionnez le type de contenu à afficher dans le pied de page.';
$string['content_type_home'] = 'Type de contenu pour la page d\'accueil';
$string['content_type_home_desc'] = 'Sélectionnez le type de contenu à afficher sur la page d\'accueil.';
$string['content_type_html'] = 'Page à créer avec l\'éditeur';
$string['continuar'] = 'Continuer à étudier';
$string['countlesson'] = '{$a} leçon';
$string['countlessons'] = '{$a} leçons';
$string['customcss'] = 'CSS personnalisé';
$string['customcss_desc'] = 'Quelles que soient les règles CSS ajoutées à cette zone de texte, elles seront répercutées dans chaque page, ce qui facilitera la personnalisation de ce thème.';
$string['editor_link_footer'] = 'Modifier le bloc du pied de page pour la langue {$a}';
$string['editor_link_footer_all'] = 'Modifier le bloc du pied de page pour toutes les langues';
$string['editor_link_home'] = 'Modifier la page d\'accueil pour la langue {$a}';
$string['editor_link_home_all'] = 'Modifier la page d\'accueil pour toutes les langues';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Modifier le favicon du thème. Une image .png avec un fond transparent et une hauteur de 32px fonctionnera mieux.';
$string['fontfamily'] = 'Police du site';
$string['fontfamily_desc'] = 'Choisissez la police que vous souhaitez utiliser dans votre Moodle';
$string['footer_contact_title'] = 'Titre du bloc de contact';
$string['footer_contact_title_default'] = 'Contactez-nous';
$string['footer_contact_title_desc'] = 'Ajoutez le titre du bloc qui apparaîtra dans le pied de page avec les coordonnées de contact.';
$string['footer_description'] = 'Description';
$string['footer_description_desc'] = 'Décrivez votre Moodle, ce que vous faites, et cette information sera affichée sous le logo dans le pied de page de Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Afficher le nom de l\'enseignant';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Si coché, affiche les noms des enseignants dans la liste des cours !';
$string['footer_frontpage_blockcourses_text'] = 'Texte court expliquant le bloc "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Ajoutez un texte décrivant les "{$a}" !';
$string['footer_links_title'] = 'Titre du bloc des liens';
$string['footer_links_title_default'] = 'Liens importants';
$string['footer_show_copywriter'] = 'Afficher le "Fait avec ❤️"';
$string['footer_show_copywriter_desc'] = 'Décochez si vous souhaitez masquer le "Fait avec ❤️"';
$string['footer_social_title'] = 'Titre du bloc des réseaux sociaux';
$string['footer_social_title_default'] = 'Suivez-nous sur les réseaux sociaux';
$string['footer_social_title_desc'] = 'Ajoutez le titre du bloc qui apparaîtra dans le pied de page avec les données de vos réseaux sociaux.';
$string['footerblink'] = 'Liens du bloc du pied de page';
$string['footerblink_desc'] = 'Vous pouvez configurer ici un bloc de liens du pied de page à afficher par thème. <br>Chaque ligne se compose d\'un texte de menu ou d\'une clé de langue ou d\'un texte, d\'une URL de lien (facultatif), séparés par des barres verticales. Par exemple :<br><pre>Support Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Bloc de contact';
$string['footerblock_copywriter'] = 'Fait avec ❤️';
$string['footerblock_description'] = 'Bloc de description';
$string['footerblock_links'] = 'Bloc des liens';
$string['footerblock_social'] = 'Bloc social';
$string['free_name'] = 'Gratuit';
$string['frontpage_about_description'] = 'Décrivez ce que vous faites';
$string['frontpage_about_description_desc'] = 'Décrivez en maximum 5 lignes la finalité de votre Moodle';
$string['frontpage_about_enable'] = 'Activer le bloc À propos';
$string['frontpage_about_enable_desc'] = 'Si coché, le bloc À propos apparaîtra sous la bannière !';
$string['frontpage_about_info'] = 'Boîte de données {$a}';
$string['frontpage_about_logo'] = 'Logo différent à afficher ici';
$string['frontpage_about_logo_desc'] = 'Si défini, ce logo sera utilisé ici au lieu du logo en haut.<br>
                                         Laissez vide pour utiliser le logo en haut !';
$string['frontpage_about_number'] = 'Quantité de données';
$string['frontpage_about_number_desc'] = 'Indiquez ici la quantité d\'informations mentionnée ci-dessus';
$string['frontpage_about_text'] = 'Nom de la donnée';
$string['frontpage_about_text_1_defalt'] = 'Cours';
$string['frontpage_about_text_2_defalt'] = 'Enseignants';
$string['frontpage_about_text_3_defalt'] = 'Étudiants';
$string['frontpage_about_text_4_defalt'] = 'Leçons';
$string['frontpage_about_text_desc'] = 'Ajoutez ici le nom de la donnée qui sera affichée sur la page d\'accueil';
$string['frontpage_about_title'] = 'Titre du bloc À propos';
$string['frontpage_about_title_default'] = 'Notre communauté mondiale';
$string['grapsjs-assetmanager-addbutton'] = 'Ajouter une image';
$string['grapsjs-assetmanager-modaltitle'] = 'Sélectionner une image';
$string['grapsjs-assetmanager-uploadtitle'] = 'Déposez les fichiers ici ou cliquez pour envoyer';
$string['grapsjs-attachment'] = 'Pièce jointe';
$string['grapsjs-clear'] = 'Effacer le canvas';
$string['grapsjs-confirm_clear'] = 'Êtes-vous sûr de vouloir effacer le canvas ?';
$string['grapsjs-decoration'] = 'Décorations';
$string['grapsjs-devicemanager-device'] = 'Dispositif';
$string['grapsjs-devicemanager-devices-desktop'] = 'Bureau';
$string['grapsjs-devicemanager-devices-mobilelandscape'] = 'Mobile, mode paysage';
$string['grapsjs-devicemanager-devices-mobileportrait'] = 'Mobile, mode portrait';
$string['grapsjs-devicemanager-devices-tablet'] = 'Tablette';
$string['grapsjs-dimensions'] = 'Dimensions';
$string['grapsjs-domcomponents-names-'] = 'Boîte';
$string['grapsjs-domcomponents-names-body'] = 'Corps';
$string['grapsjs-domcomponents-names-cell'] = 'Cellule de table';
$string['grapsjs-domcomponents-names-comment'] = 'Commentaire';
$string['grapsjs-domcomponents-names-image'] = 'Image';
$string['grapsjs-domcomponents-names-label'] = 'Label';
$string['grapsjs-domcomponents-names-link'] = 'Lien';
$string['grapsjs-domcomponents-names-map'] = 'Carte';
$string['grapsjs-domcomponents-names-row'] = 'Ligne de table';
$string['grapsjs-domcomponents-names-section'] = 'Section';
$string['grapsjs-domcomponents-names-table'] = 'Table';
$string['grapsjs-domcomponents-names-tbody'] = 'Corps de table';
$string['grapsjs-domcomponents-names-text'] = 'Texte';
$string['grapsjs-domcomponents-names-tfoot'] = 'Pied de table';
$string['grapsjs-domcomponents-names-thead'] = 'Tête de table';
$string['grapsjs-domcomponents-names-video'] = 'Vidéo';
$string['grapsjs-domcomponents-names-wrapper'] = 'Corps';
$string['grapsjs-edit_code'] = 'Modifier le code';
$string['grapsjs-edit_code_paste_here_html'] = 'Collez ici votre HTML/CSS et cliquez sur Importer';
$string['grapsjs-fullscreen'] = 'Plein écran';
$string['grapsjs-general'] = 'Généraux';
$string['grapsjs-open_block'] = 'Blocs';
$string['grapsjs-open_layers'] = 'Couches';
$string['grapsjs-open_sm'] = 'Gestionnaire de Styles';
$string['grapsjs-page_preview'] = 'Prévisualiser';
$string['grapsjs-page_save'] = 'Sauver';
$string['grapsjs-panels-buttons-titles-export-template'] = 'Voir code';
$string['grapsjs-panels-buttons-titles-fullscreen'] = 'Plein écran';
$string['grapsjs-panels-buttons-titles-open-blocks'] = 'Ouvrir les blocs';
$string['grapsjs-panels-buttons-titles-open-layers'] = 'Ouvrir le gestionnaire de couches';
$string['grapsjs-panels-buttons-titles-open-sm'] = 'Ouvrir le gestionnaire de styles';
$string['grapsjs-panels-buttons-titles-open-tm'] = 'Paramètres';
$string['grapsjs-panels-buttons-titles-preview'] = 'Prévisualisation';
$string['grapsjs-panels-buttons-titles-sw-visibility'] = 'Voir composants';
$string['grapsjs-position'] = 'Position';
$string['grapsjs-preview'] = 'Aperçu';
$string['grapsjs-redo'] = 'Rétablir';
$string['grapsjs-repeat'] = 'Répéter';
$string['grapsjs-selectormanager-emptystate'] = '- État -';
$string['grapsjs-selectormanager-label'] = 'Classes';
$string['grapsjs-selectormanager-selected'] = 'Sélectionné';
$string['grapsjs-selectormanager-states-active'] = 'Click';
$string['grapsjs-selectormanager-states-hover'] = 'Hover';
$string['grapsjs-selectormanager-states-nth-of-type-2n'] = 'Pair/Impair';
$string['grapsjs-settings'] = 'Paramètres';
$string['grapsjs-show_border'] = 'Afficher les bordures';
$string['grapsjs-size'] = 'Taille';
$string['grapsjs-stylemanager-empty'] = 'Sélectionnez un élément pour utiliser le gestionnaire de styles';
$string['grapsjs-stylemanager-filebutton'] = 'Images';
$string['grapsjs-stylemanager-layer'] = 'Couche';
$string['grapsjs-stylemanager-properties-align-content'] = 'Aligner le contenu';
$string['grapsjs-stylemanager-properties-align-items'] = 'Aligner les éléments';
$string['grapsjs-stylemanager-properties-align-self'] = 'S\'aligner';
$string['grapsjs-stylemanager-properties-background'] = 'Fond';
$string['grapsjs-stylemanager-properties-background-attachment'] = 'Attachement de fond';
$string['grapsjs-stylemanager-properties-background-color'] = 'Couleur de fond';
$string['grapsjs-stylemanager-properties-background-image'] = 'Image de fond';
$string['grapsjs-stylemanager-properties-background-position'] = 'Position du fond';
$string['grapsjs-stylemanager-properties-background-repeat'] = 'Répéter le fond';
$string['grapsjs-stylemanager-properties-background-size'] = 'Taille du fond';
$string['grapsjs-stylemanager-properties-border'] = 'Bordure';
$string['grapsjs-stylemanager-properties-border-bottom-left'] = 'Bordure inférieure gauche';
$string['grapsjs-stylemanager-properties-border-bottom-right'] = 'Bordure inférieure droite';
$string['grapsjs-stylemanager-properties-border-color'] = 'Couleur de bordure';
$string['grapsjs-stylemanager-properties-border-radius'] = 'Rayon de bordure';
$string['grapsjs-stylemanager-properties-border-radius-bottom-left'] = 'Rayon bordure inférieure gauche';
$string['grapsjs-stylemanager-properties-border-radius-bottom-right'] = 'Rayon bordure inférieure droite';
$string['grapsjs-stylemanager-properties-border-radius-top-left'] = 'Rayon bordure supérieure gauche';
$string['grapsjs-stylemanager-properties-border-radius-top-right'] = 'Rayon bordure supérieure droite';
$string['grapsjs-stylemanager-properties-border-style'] = 'Style de bordure';
$string['grapsjs-stylemanager-properties-border-top-left'] = 'Bordure supérieure gauche';
$string['grapsjs-stylemanager-properties-border-top-right'] = 'Bordure supérieure droite';
$string['grapsjs-stylemanager-properties-border-width'] = 'Largeur de bordure';
$string['grapsjs-stylemanager-properties-bottom'] = 'Bas';
$string['grapsjs-stylemanager-properties-box-shadow'] = 'Ombre de la boîte';
$string['grapsjs-stylemanager-properties-box-shadow-blur'] = 'Flou de l\'ombre de la boîte';
$string['grapsjs-stylemanager-properties-box-shadow-color'] = 'Couleur de l\'ombre de la boîte';
$string['grapsjs-stylemanager-properties-box-shadow-h'] = 'Ombre de la boîte: horizontal';
$string['grapsjs-stylemanager-properties-box-shadow-spread'] = 'Étendue de l\'ombre de la boîte';
$string['grapsjs-stylemanager-properties-box-shadow-type'] = 'Type d\'ombre de la boîte';
$string['grapsjs-stylemanager-properties-box-shadow-v'] = 'Ombre de la boîte: vertical';
$string['grapsjs-stylemanager-properties-center'] = 'Centre';
$string['grapsjs-stylemanager-properties-color'] = 'Couleur';
$string['grapsjs-stylemanager-properties-display'] = 'Affichage';
$string['grapsjs-stylemanager-properties-flex-basis'] = 'Base Flex';
$string['grapsjs-stylemanager-properties-flex-direction'] = 'Direction Flex';
$string['grapsjs-stylemanager-properties-flex-grow'] = 'Croissance Flex';
$string['grapsjs-stylemanager-properties-flex-shrink'] = 'Rétrécissement Flex';
$string['grapsjs-stylemanager-properties-flex-wrap'] = 'Flex Envelopper';
$string['grapsjs-stylemanager-properties-float'] = 'Flottant';
$string['grapsjs-stylemanager-properties-font-family'] = 'Famille de polices';
$string['grapsjs-stylemanager-properties-font-size'] = 'Taille de police';
$string['grapsjs-stylemanager-properties-font-weight'] = 'Poids de police';
$string['grapsjs-stylemanager-properties-height'] = 'Hauteur';
$string['grapsjs-stylemanager-properties-justify'] = 'Justifier';
$string['grapsjs-stylemanager-properties-justify-content'] = 'Justifier le contenu';
$string['grapsjs-stylemanager-properties-left'] = 'Gauche';
$string['grapsjs-stylemanager-properties-letter-spacing'] = 'Espacement des lettres';
$string['grapsjs-stylemanager-properties-line-height'] = 'Hauteur de ligne';
$string['grapsjs-stylemanager-properties-line-through'] = 'Barré';
$string['grapsjs-stylemanager-properties-margin'] = 'Marge';
$string['grapsjs-stylemanager-properties-margin-bottom'] = 'Marge Inférieure';
$string['grapsjs-stylemanager-properties-margin-left'] = 'Marge Gauche';
$string['grapsjs-stylemanager-properties-margin-right'] = 'Marge Droite';
$string['grapsjs-stylemanager-properties-margin-top'] = 'Marge Supérieure';
$string['grapsjs-stylemanager-properties-max-height'] = 'Hauteur Max.';
$string['grapsjs-stylemanager-properties-max-width'] = 'Largeur Max.';
$string['grapsjs-stylemanager-properties-none'] = 'Aucun';
$string['grapsjs-stylemanager-properties-order'] = 'Ordre';
$string['grapsjs-stylemanager-properties-padding'] = 'Padding';
$string['grapsjs-stylemanager-properties-padding-bottom'] = 'Padding Inférieur';
$string['grapsjs-stylemanager-properties-padding-left'] = 'Padding Gauche';
$string['grapsjs-stylemanager-properties-padding-right'] = 'Padding Droite';
$string['grapsjs-stylemanager-properties-padding-top'] = 'Padding Supérieur';
$string['grapsjs-stylemanager-properties-perspective'] = 'Perspective';
$string['grapsjs-stylemanager-properties-position'] = 'Position';
$string['grapsjs-stylemanager-properties-right'] = 'Droit';
$string['grapsjs-stylemanager-properties-text-align'] = 'Alignement du texte';
$string['grapsjs-stylemanager-properties-text-shadow'] = 'Ombre du texte';
$string['grapsjs-stylemanager-properties-text-shadow-blur'] = 'Flou de l\'ombre du texte';
$string['grapsjs-stylemanager-properties-text-shadow-color'] = 'Couleur de l\'ombre du texte';
$string['grapsjs-stylemanager-properties-text-shadow-h'] = 'Ombre du texte: horizontal';
$string['grapsjs-stylemanager-properties-text-shadow-v'] = 'Ombre du texte: vertical';
$string['grapsjs-stylemanager-properties-top'] = 'Haut';
$string['grapsjs-stylemanager-properties-transform'] = 'Transformation';
$string['grapsjs-stylemanager-properties-transform-rotate-x'] = 'Rotation horizontale';
$string['grapsjs-stylemanager-properties-transform-rotate-y'] = 'Rotation verticale';
$string['grapsjs-stylemanager-properties-transform-rotate-z'] = 'Rotation en profondeur';
$string['grapsjs-stylemanager-properties-transform-scale-x'] = 'Mise à l\'échelle horizontale';
$string['grapsjs-stylemanager-properties-transform-scale-y'] = 'Mise à l\'échelle verticale';
$string['grapsjs-stylemanager-properties-transform-scale-z'] = 'Mise à l\'échelle en profondeur';
$string['grapsjs-stylemanager-properties-transition'] = 'Transition';
$string['grapsjs-stylemanager-properties-transition-duration'] = 'Durée de la transition';
$string['grapsjs-stylemanager-properties-transition-property'] = 'Propriété de transition';
$string['grapsjs-stylemanager-properties-transition-timing-function'] = 'Fonction de timing de la transition';
$string['grapsjs-stylemanager-properties-underline'] = 'Souligné';
$string['grapsjs-stylemanager-properties-width'] = 'Largeur';
$string['grapsjs-stylemanager-sectors-decorations'] = 'Décorations';
$string['grapsjs-stylemanager-sectors-dimension'] = 'Dimension';
$string['grapsjs-stylemanager-sectors-extra'] = 'Extra';
$string['grapsjs-stylemanager-sectors-flex'] = 'Flex';
$string['grapsjs-stylemanager-sectors-general'] = 'Général';
$string['grapsjs-stylemanager-sectors-layout'] = 'Disposition';
$string['grapsjs-stylemanager-sectors-typography'] = 'Typographie';
$string['grapsjs-tipografia'] = 'Typographie';
$string['grapsjs-traitmanager-empty'] = 'Sélectionnez un élément pour utiliser le gestionnaire de caractéristiques';
$string['grapsjs-traitmanager-label'] = 'Réglages du composant';
$string['grapsjs-traitmanager-traits-options-target-_blank'] = 'Nouvelle fenêtre';
$string['grapsjs-traitmanager-traits-options-target-false'] = 'Cette fenêtre';
$string['grapsjs-undo'] = 'Annuler';
$string['grapsjs-width'] = 'Largeur';
$string['heart'] = 'Si vous appréciez ce thème, n\'oubliez pas de cliquer sur ❤️ sur la page des thèmes <a href="{$a}" target="_blank">en cliquant ici</a>';
$string['instructor'] = 'Enseignant';
$string['login_backgroundcolor'] = 'Couleur de fond';
$string['login_backgroundcolor_desc'] = 'Sélectionnez la couleur de fond de la page de récupération de mot de passe';
$string['login_backgroundfoto'] = 'Image de fond';
$string['login_backgroundfoto_desc'] = 'Sélectionnez l\'image de fond de la connexion/Récupération du mot de passe/Création de compte. L\'image par défaut est : {$a}';
$string['login_forgot_description'] = 'Texte sur le côté de l\'écran de récupération de mot de passe';
$string['login_forgot_description_desc'] = 'Texte qui apparaîtra uniquement sur l\'écran de récupération de mot de passe';
$string['login_login_description'] = 'Texte sur le côté de l\'écran de connexion';
$string['login_login_description_desc'] = 'Texte qui apparaîtra uniquement sur l\'écran de connexion';
$string['login_signup_description'] = 'Texte sur le côté de l\'écran de création de compte';
$string['login_signup_description_desc'] = 'Texte qui apparaîtra uniquement sur l\'écran de création de compte';
$string['login_theme'] = 'Thème de connexion';
$string['login_theme_block'] = 'Bloc blanc central avec fond optionnel';
$string['login_theme_desc'] = 'Choisissez le thème que vous souhaitez pour la zone de connexion';
$string['login_theme_image_login'] = 'Image de fond et connexion sur le côté';
$string['login_theme_imagetext_login'] = 'Image de fond, texte sur l\'image et connexion sur le côté';
$string['login_theme_login'] = 'Seulement l\'écran de connexion, sans image latérale';
$string['logo_color'] = 'Logo en couleur';
$string['logo_color_desc'] = 'Veuillez télécharger votre LOGO en couleur si vous souhaitez l\'inclure en haut. Ce logo sera affiché lorsque la page est défilée, et le menu sera affiché sur un fond blanc.';
$string['logo_write'] = 'Logo du menu supérieur lors du défilement';
$string['logo_write_desc'] = 'Veuillez télécharger votre logo si vous souhaitez l\'inclure en haut. Ce logo sera affiché lorsque le défilement reste en haut, et le menu sera affiché sur un fond coloré.';
$string['matricular'] = 'S\'inscrire';
$string['pluginname'] = 'Thème Dégradé';
$string['settings_about_heading'] = 'À propos de votre Moodle';
$string['settings_footer_heading'] = 'Bloc du pied de page';
$string['settings_icons_block'] = 'Icône {$a}';
$string['settings_icons_change_icons'] = 'Changer l\'icône par défaut dans la liste des cours';
$string['settings_icons_default_audio_file'] = 'Audio';
$string['settings_icons_default_book'] = 'Livre';
$string['settings_icons_default_download'] = 'Téléchargement';
$string['settings_icons_default_game'] = 'Jeu';
$string['settings_icons_default_money'] = 'Financier';
$string['settings_icons_default_slide'] = 'Diapositives';
$string['settings_icons_default_support'] = 'Support';
$string['settings_icons_default_video_file'] = 'Vidéo';
$string['settings_icons_heading'] = 'Icônes';
$string['settings_icons_image'] = 'Image de l\'icône';
$string['settings_icons_image_desc'] = 'Téléchargez l\'image SVG ou PNG de l\'icône souhaitée à remplacer dans le cours.<br>Taille recommandée : 24px. Si c\'est du PNG, pensez à la transparence.';
$string['settings_icons_module_disable'] = 'La sélection d\'icône personnalisée est désactivée. Activez dans {$a}';
$string['settings_icons_name'] = 'Nom de l\'icône';
$string['settings_icons_name_desc'] = 'Ajoutez le nom de l\'icône pour faciliter la sélection dans le module';
$string['settings_icons_none'] = 'Aucune icône personnalisée';
$string['settings_icons_num'] = 'Nombre d\'icônes';
$string['settings_icons_num_desc'] = 'Quantité d\'icônes personnalisées que vous souhaitez ajouter';
$string['settings_icons_select_icon'] = 'Sélectionnez l\'icône personnalisée. Modifiez dans {$a}';
$string['settings_login_heading'] = 'Écran de connexion';
$string['settings_slideshow_heading'] = 'Diaporama';
$string['settings_theme_heading'] = 'Thème';
$string['settings_top_heading'] = 'Haut';
$string['slidecaption_desc'] = 'Entrez le texte de la légende à utiliser sur la diapositive';
$string['slideshow_image'] = 'Image de la diapositive';
$string['slideshow_image_desc'] = 'L\'image doit avoir une taille de 1250px X 400px.';
$string['slideshow_info'] = 'Diapositive {$a}';
$string['slideshow_numslides'] = 'Combien d\'images dans le diaporama';
$string['slideshow_numslides_desc'] = 'Combien d\'images souhaitez-vous dans le diaporama ?';
$string['slideshow_numslides_nenhum'] = 'Aucune diapositive sur la page d\'accueil';
$string['slideshow_text'] = 'Texte court descriptif de la diapositive';
$string['slideshow_text_desc'] = 'Insérez un petit texte sur la diapositive.';
$string['slideshow_url'] = 'Lien du bouton des diapositives';
$string['slideshow_url_desc'] = 'Insérez la destination du lien du bouton de l\'image de la diapositive';
$string['social_facebook'] = 'Votre Facebook';
$string['social_facebook_desc'] = 'L\'URL Facebook de votre organisation.';
$string['social_instagram'] = 'Votre Instagram';
$string['social_instagram_desc'] = 'L\'URL Instagram de votre organisation.';
$string['social_linkedin'] = 'Votre Linkedin';
$string['social_linkedin_desc'] = 'L\'URL Linkedin de votre organisation.';
$string['social_twitter'] = 'Votre Twitter';
$string['social_twitter_desc'] = 'L\'URL Twitter de votre organisation.';
$string['social_youtube'] = 'Votre Youtube';
$string['social_youtube_desc'] = 'L\'URL Youtube de votre organisation.';
$string['theme_color'] = 'Sélection des couleurs';
$string['theme_color-color_buttons'] = 'Couleur des boutons';
$string['theme_color-color_buttons_desc'] = 'La couleur utilisée pour les boutons, ajoutant une cohésion visuelle et mettant en évidence les actions interactives.';
$string['theme_color-color_names'] = 'Couleur des noms';
$string['theme_color-color_names_desc'] = 'Couleur utilisée pour mettre en évidence des noms ou des identifiants, offrant clarté et accentuation des informations de texte spécifiques.';
$string['theme_color-color_primary'] = 'Couleur primaire';
$string['theme_color-color_primary_desc'] = 'La couleur primaire principale du thème, généralement utilisée pour les éléments en surbrillance et l\'accentuation.';
$string['theme_color-color_secondary'] = 'Couleur secondaire';
$string['theme_color-color_secondary_desc'] = 'Une couleur secondaire qui complète la couleur primaire, utilisée pour mettre en valeur des éléments secondaires ou pour contraster avec la couleur primaire.';
$string['theme_color-color_titles'] = 'Couleur des titres';
$string['theme_color-color_titles_desc'] = 'La couleur utilisée pour les titres, offrant une mise en évidence et une structure visuelle au contenu de la page.';
$string['theme_color_blue'] = 'Bleu';
$string['theme_color_desc'] = 'Sélectionnez les couleurs des textes et des boutons de Moodle ou cliquez sur la ligne ci-dessous :';
$string['theme_color_green'] = 'Vert';
$string['theme_color_green_d'] = 'Vert foncé';
$string['theme_color_heading'] = 'Sélection des couleurs du thème';
$string['theme_color_red_d'] = 'Rouge';
$string['theme_color_violet'] = 'Violet';
$string['theme_degrade_about_editbooton'] = 'Modifier le bloc À propos';
$string['theme_degrade_frontpage_bloco'] = 'Bloc "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Blocs de la page d\'accueil';
$string['theme_degrade_slideshow_editbooton'] = 'Modifier le diaporama';
$string['theme_login_branco'] = 'Seulement l\'écran de connexion, sans image latérale, avec le formulaire sur fond blanc';
$string['top_color_heading'] = 'Couleur du haut en défilement';
$string['top_scroll_background_color'] = 'Couleur de fond du menu en haut en défilement';
$string['top_scroll_background_color_desc'] = 'Définissez la couleur de fond lors du défilement de la page.';
$string['top_scroll_text_color'] = 'Couleur du texte du menu en haut en défilement';
$string['top_scroll_text_color_desc'] = 'Définissez la couleur du texte du menu lors du défilement de la page.';
