<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'game', language 'fr', version '4.3'.
 *
 * @package     game
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allattempts'] = 'Toutes les tentatives';
$string['allstudents'] = 'Tous les étudiants $a';
$string['and'] = 'et';
$string['attempt'] = 'Tentative';
$string['attemptduration'] = 'Durée de la tentative';
$string['attemptfirst'] = 'Première tentative';
$string['attemptgamenow'] = 'Jouer maintenant';
$string['attemptlast'] = 'Dernière tentative';
$string['attempts'] = 'Tentatives';
$string['attemptsonly'] = 'Ne montrer que les étudiants qui ont tenté';
$string['bookquiz_cant_update_lastchaperid'] = 'Impossible de mettre à jour la table game_bookquiz avec lastchapterid à %d';
$string['bookquiz_categories'] = 'Catégories';
$string['bookquiz_chapters'] = 'Chapitres';
$string['bookquiz_empty'] = 'Le livre est vide';
$string['bookquiz_error'] = 'livre avec questions : %s';
$string['bookquiz_error_insert'] = 'game_bookquiz_continue : erreur d’insertion dans game_bookquiz';
$string['bookquiz_layout'] = 'Mise en page';
$string['bookquiz_layout0'] = 'Question en haut du livre';
$string['bookquiz_layout1'] = 'Question en bas du livre';
$string['bookquiz_not_select_book'] = 'Vous n’avez pas choisi de livre';
$string['bookquiz_numquestions'] = 'Questions';
$string['bookquiz_options'] = 'Options du test Livre';
$string['bookquiz_questions'] = 'Associez une catégorie de questions à un sous-chapitre';
$string['bottomtext'] = 'Texte au bas';
$string['clearrepetitions'] = 'Effacer les statistiques';
$string['col_highscores'] = 'Meilleurs scores';
$string['comment'] = 'Commentaire';
$string['common_problems'] = 'Problèmes communs';
$string['common_problems_allowspaces'] = 'Il y a des mots avec des espaces, mais dans ce jeu, les espaces ne sont pas autorisés';
$string['common_problems_crossword_param1'] = 'Le nombre maximum de colonnes/lignes est trop petit';
$string['common_problems_shortanswer_hangman'] = 'Tous les caractères ne sont pas dans la langue du jeu';
$string['completedon'] = 'Terminé le';
$string['computerepetitions'] = 'Recalculer les statistiques';
$string['confighangmanimagesets'] = 'Définit combien d’ensembles d’images sont utilisés pour le pendu';
$string['confighidebookquiz'] = 'Définit si le jeu « Livre avec des questions » est montré aux enseignants ou non';
$string['confighidecross'] = 'Définit si le jeu mots croisés est montré aux enseignants ou non';
$string['confighidecryptex'] = 'Définit si le jeu Cryptex est montré aux enseignants ou non';
$string['confighidehangman'] = 'Définit si le jeu du pendu est montré aux enseignants ou non';
$string['confighidehiddenpicture'] = 'Définit si le jeu « Image cachée » est montré aux enseignants ou non';
$string['confighidemillionaire'] = 'Définit si le jeu Qui veut gagner des millions est montré aux enseignants ou non';
$string['confighidesnakes'] = 'Définit si le jeu « Serpents et échelles » est montré aux enseignants ou non';
$string['confighidesudoku'] = 'Définit si le jeu du Sudoku est montré aux enseignants ou non';
$string['continueattemptgame'] = 'Continuer une tentative précédente du jeu';
$string['convertfrom'] = '-';
$string['convertto'] = '-';
$string['cross_across'] = 'Horizontalement';
$string['cross_checkbutton'] = 'Vérifier le mots croisés';
$string['cross_correct'] = 'caractère correct';
$string['cross_corrects'] = 'caractères corrects';
$string['cross_disabletransformuppercase'] = 'Désactive la transformation de texte en majuscules dans le CSS';
$string['cross_down'] = 'Verticalement';
$string['cross_endofgamebutton'] = 'Fin du mots croisés';
$string['cross_error'] = 'mauvais caractère';
$string['cross_error_containsbadchars'] = 'Le mot contient des caractères incorrects';
$string['cross_error_wordlength1'] = 'Le mot correct contient&nbsp;';
$string['cross_error_wordlength2'] = 'lettres.';
$string['cross_errors'] = 'mauvais caractère';
$string['cross_found_many'] = 'Trouvés';
$string['cross_found_one'] = 'Trouvé';
$string['cross_layout'] = 'Mise en page';
$string['cross_layout0'] = 'Définitions sous la grille';
$string['cross_layout1'] = 'Définitions à droite de la grille';
$string['cross_max_attempts'] = 'Maximum de tentatives';
$string['cross_maxcols'] = 'Nombre maximum de colonnes de la grille';
$string['cross_maxcomputetime'] = 'Temps maximal de génération de la grille en secondes';
$string['cross_maxwords'] = 'Nombre de mots maximum de la grille';
$string['cross_minwords'] = 'Minimum de mots dans la grille';
$string['cross_options'] = 'Options de la grille';
$string['cross_pleasewait'] = 'Attendez le chargement du mots croisés';
$string['cross_welcome'] = '<h3>Bienvenue !</h3><p>Cliquez sur un mot pour commencer.</p>';
$string['cryptex_error'] = 'Erreur du jeu des mots mêlés : %s';
$string['cryptex_maxtries'] = 'Maximum d’essais';
$string['cryptex_options'] = 'Options de la grille de mots mêlés';
$string['deleteattemptcheck'] = 'Voulez-vous vraiment effacer complètement ces tentatives ?';
$string['different_glossary_category'] = 'La catégorie sélectionnée ne correspond pas au glossaire sélectionné';
$string['disablesummarize'] = 'Désactiver résumer';
$string['displayoptions'] = 'Montrer les options';
$string['downloadods'] = 'Télécharger au format ODS';
$string['eventgamecreated'] = 'Partie créée';
$string['eventgamedeleted'] = 'Partie supprimée';
$string['eventgameplayed'] = 'Partie jouée';
$string['eventgamesupdated'] = 'Partie actualisée';
$string['eventgameviewed'] = 'Partie visualisée';
$string['export'] = 'Exporter';
$string['export_to_html'] = 'Exporter au format HTML';
$string['export_to_javame'] = 'Exporter au format Javame';
$string['feedback'] = 'Rapports';
$string['feedbacks'] = 'Messages pour réponses correctes';
$string['finish'] = 'Fin du jeu';
$string['game:addinstance'] = 'Ajouter un nouveau jeu';
$string['game:attempt'] = 'Jouer';
$string['game:deleteattempts'] = 'Effacer les tentatives';
$string['game:grade'] = 'Évaluer manuellement le jeu';
$string['game:manage'] = 'Gérer';
$string['game:manageoverrides'] = 'Gérer les dépassements du jeu';
$string['game:preview'] = 'Prévisualiser le jeu';
$string['game:reviewmyattempts'] = 'Revoir mes tentatives';
$string['game:view'] = 'Voir';
$string['game:viewreports'] = 'visualisation des rapports';
$string['game_bookquiz'] = 'Livre de questions';
$string['game_cross'] = 'Mots croisés';
$string['game_cryptex'] = 'Mots mêlés';
$string['game_error'] = 'Erreur de jeu : %s';
$string['game_hangman'] = 'Pendu';
$string['game_hiddenpicture'] = 'Image cachée';
$string['game_millionaire'] = 'Qui veut gagner des millions';
$string['game_snakes'] = 'Serpents et échelles';
$string['game_sudoku'] = 'Sudoku';
$string['gameclose'] = 'Fermer le jeu';
$string['gameclosed'] = 'Ce jeu a été fermé le {$a}';
$string['gamecloseson'] = 'Ce jeu sera fermé le {$a}';
$string['gamenotavailable'] = 'Ce jeu ne sera pas disponible avant le {$a}';
$string['gamenotfound'] = 'Jeu %s non trouvé';
$string['gameopen'] = 'Mettre à disposition le jeu';
$string['gameopenclose'] = 'Dates d’ouverture et fermeture';
$string['gameopenclose_help'] = 'Les étudiants ne peuvent débuter leurs tentatives qu’après cette date et doivent les avoir terminées avant la date de fermeture.';
$string['gameopenedon'] = 'Ce jeu a débuté le {$a}';
$string['glossary_only_approved'] = 'N’utiliser que les articles de glossaire approuvés ou ceux de l’enseignant';
$string['grade'] = 'Note';
$string['gradeaverage'] = 'Note moyenne';
$string['gradehighest'] = 'Note maximale';
$string['grademethod'] = 'Méthode de notation';
$string['hangman_allowspaces'] = 'Autoriser les espaces dans les mots';
$string['hangman_allowsub'] = 'Autoriser le symbole - dans les mots';
$string['hangman_correct_phrase'] = 'La phrase correcte était :';
$string['hangman_correct_word'] = 'Le mot correct était :';
$string['hangman_error'] = 'Erreur du jeu du pendu : %s';
$string['hangman_gradeinstance'] = 'Note pour tout l’ensemble';
$string['hangman_imageset'] = 'Choisissez les images du pendu';
$string['hangman_language'] = 'Langue des mots';
$string['hangman_letters'] = 'Lettres :';
$string['hangman_loose'] = '<BIG><B>Jeu terminé</B></BIG>';
$string['hangman_maximum_number_of_errors'] = 'Nombre maximum d’erreurs';
$string['hangman_maxtries'] = 'Nombre de mots par jeu';
$string['hangman_options'] = 'Options du Pendu';
$string['hangman_restletters_many'] = 'Il vous reste <b>{$a}</b> tentatives';
$string['hangman_restletters_one'] = 'Vous n’avez <b>QU’UNE SEULE</b> tentative';
$string['hangman_showcorrectanswer'] = 'Montrer la réponse correcte après la fin du jeu';
$string['hangman_showfirst'] = 'Montrer la première lettre du pendu';
$string['hangman_showlast'] = 'Montrer la dernière lettre du pendu';
$string['hangman_showquestion'] = 'Montrer les questions ?';
$string['hangman_wrongnum'] = 'Non : %%d en dehors de %%d';
$string['hangmanimagesets'] = 'Nombre d’ensembles d’images utilisé par le pendu';
$string['header_footer_options'] = 'Options en-tête/pied de page';
$string['helpbookquiz'] = 'Quand l’étudiant répond correctement, il peut aller au chapitre suivant.';
$string['helpcross'] = 'Ce jeu récupère des mots d’un Glossaire ou de questions de type réponse courte et génère des mots croisés aléatoires. L’enseignant peut définir le nombre maximal de colonnes/lignes ou choisir les mots. L’étudiant peut cliquer sur le bouton « Vérifier la grille » pour vérifier si les réponses sont correctes. Tous les mots croisés sont dynamiques donc sont différents pour chaque étudiant.';
$string['helpcryptex'] = 'Ce jeu ressemble à des mots croisés mais les réponses sont cachées dans une grille de mots mêlés aléatoire.';
$string['helphangman'] = 'Ce jeu récupère des mots d’un Glossaire ou de questions de type réponse courte et génère une grille de pendu. L’enseignant peut définir le nombre maximal de mots de chaque partie, si la première ou la dernière lettre est affichée ou si la question ou la réponse est affichée à la fin.';
$string['helphiddenpicture'] = 'Le jeu de l’image cachée découvre un morceau d’une image (une case numérotée) à chaque bonne réponse de l’étudiant. A chaque case correspond une question posée à l’étudiant. Lorsque l’étudiant répond correctement à la question, la case correspondante est découverte pour révéler un morceau de l’image.';
$string['helpmillionaire'] = 'Une question est affichée à l’étudiant qui, s’il répond correctement, avance à la case suivante dans le jeu jusqu’à ce que l’utilisateur ait répondu à toutes les questions. Si l’étudiant répond mal à une question, le jeu est fini.';
$string['helpsnakes'] = 'Une question est affichée à l’étudiant. S’il répond correctement, un dé virtuel est lancé. Le pion avance alors du nombre de points affiché par le dé.';
$string['helpsudoku'] = 'Ce jeu affiche une grille de sudoku aux étudiants dans laquelle il manque des chiffres pour la résoudre? Pour chaque bonne réponse, un chiffre supplémentaire est révélé afin de rendre la résolution du sudoku plus aisée.';
$string['hiddenpicture_across'] = 'Cases horizontales';
$string['hiddenpicture_down'] = 'Cases verticales';
$string['hiddenpicture_error'] = 'Erreur du jeu d’image cachée : %s';
$string['hiddenpicture_height'] = 'Définir la hauteur de l’image à (en pixels)';
$string['hiddenpicture_mainsubmit'] = 'Catégorie de la réponse principale';
$string['hiddenpicture_nocols'] = 'Il faut spécifier le nombre de cellules horizontales';
$string['hiddenpicture_nomainquestion'] = 'Il n’y a pas d’entrée de glossaire dans le glossaire {$a->name} avec une image liée';
$string['hiddenpicture_norows'] = 'Il faut spécifier le nombre de cellules verticales';
$string['hiddenpicture_options'] = 'options de l\'« Image cachée »';
$string['hiddenpicture_pictureglossary'] = 'Le glossaire pour la question principale et l’image';
$string['hiddenpicture_width'] = 'Définir la largeur de l’image à (en pixels)';
$string['hidebookquiz'] = 'Cacher le jeu « Livre avec questions »';
$string['hidecross'] = 'Cacher le jeu mots croisés';
$string['hidecryptex'] = 'Cacher le jeu mots mêlés';
$string['hidehangman'] = 'Cacher le jeu du pendu';
$string['hidehiddenpicture'] = 'Cacher le jeu « Image cachée »';
$string['hidemillionaire'] = 'Cacher le jeu Qui veut gagner des millions';
$string['hidesnakes'] = 'Cacher le jeu « Serpents et échelles »';
$string['hidesudoku'] = 'Cacher le jeu Sudoku';
$string['highscore'] = 'Afficher le plus haut score (nombre d’étudiants)';
$string['html_hangman_new'] = 'Nouveau';
$string['html_hascheckbutton'] = 'A le bouton Vérifier:';
$string['html_hasprintbutton'] = 'A le bouton Imprimer:';
$string['html_snakes_check'] = 'Vérifier';
$string['html_snakes_correct'] = 'Correct !';
$string['html_snakes_no_selection'] = 'Aucune sélection !';
$string['html_snakes_wrong'] = 'Votre réponse est incorrecte. Vous restez à la même place.';
$string['html_title'] = 'Titre de HTML :';
$string['info'] = 'Info';
$string['introduction'] = 'Description';
$string['javame_createdby'] = 'Créé par :';
$string['javame_description'] = 'Description :';
$string['javame_filename'] = 'Nom du fichier :';
$string['javame_icon'] = 'Icône :';
$string['javame_maxpictureheight'] = 'Hauteur maximale de l’image :';
$string['javame_maxpicturewidth'] = 'Largeur maximale de l’image :';
$string['javame_name'] = 'Nom :';
$string['javame_type'] = 'Type :';
$string['javame_vendor'] = 'Vendeur :';
$string['javame_version'] = 'Version :';
$string['language_user_defined'] = 'Langue définie par l’utilisateur';
$string['letter'] = 'lettre';
$string['letters'] = 'lettres';
$string['lettersall'] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
$string['millionaire_also_multichoice'] = 'Question à choix multiple sans réponse correcte unique';
$string['millionaire_background'] = 'Couleur d’arrière plan';
$string['millionaire_error'] = 'Erreur du jeu du millionnaire : %s';
$string['millionaire_helppeople'] = 'Avis du public';
$string['millionaire_info_people'] = 'Les gens disent';
$string['millionaire_info_telephone'] = 'Je pense que la bonne réponse est&nbsp;';
$string['millionaire_info_wrong_answer'] = 'Vous avez donné une mauvaise réponse <br>La réponse correcte est :';
$string['millionaire_lettersall'] = '-';
$string['millionaire_must_select_questioncategory'] = 'Vous devez choisir une catégorie de questions';
$string['millionaire_must_select_quiz'] = 'Vous devez choisir un test';
$string['millionaire_no_multichoice_questions'] = 'Il n’y a pas de question à choix multiple';
$string['millionaire_options'] = 'options du jeu Qui veut gagner des millions';
$string['millionaire_quit'] = 'Quitter';
$string['millionaire_shuffle'] = 'Questions aléatoires';
$string['millionaire_sourcemodule_must_quiz_question'] = 'Pour le jeu Qui veut gagner des millions, la source doit être {$a} ou questions et non';
$string['millionaire_telephone'] = 'Appel à un ami';
$string['missingbook'] = 'Livre manquant';
$string['modulename'] = 'Jeu';
$string['modulename_help'] = 'Ce module contient 8 jeux : le Pendu, Mots croisés, Mots mêlés, Qui veut gagner des millions, le Sudoku, l’Image cachée, Serpents et échelles et Livre avec questions.';
$string['modulenameplural'] = 'Jeux';
$string['must_select_glossary'] = 'Vous devez choisir un glossaire';
$string['must_select_questioncategory'] = 'Vous devez choisir une catégorie de questions';
$string['must_select_quiz'] = 'Vous devez choisir un test';
$string['name'] = 'Nom';
$string['nextgame'] = 'Nouveau jeu';
$string['nextword'] = 'Mot suivant';
$string['no_questions'] = 'Pas de question';
$string['no_words'] = 'Pas de mots';
$string['noattempts'] = 'Aucune tentative sur ce test';
$string['noattemptsonly'] = 'Montrer $a sans tentatives';
$string['noglossaryentriesfound'] = 'Aucune entrée de glossaire n’a été trouvée';
$string['numattempts'] = '$a->studentnum $a->studentstring ont effectué $a->attemptnum tentative(s)';
$string['only_teachers'] = 'Seuls les enseignants peuvent voir cette page';
$string['outof'] = '{$a->grade} hors de la plage maximum de {$a->maxgrade}';
$string['pagesize'] = 'Questions par page :';
$string['percent'] = 'Pourcentage';
$string['pluginadministration'] = 'Administration du jeu';
$string['pluginname'] = 'Jeu';
$string['preview'] = 'Prévisualisation';
$string['print'] = 'Imprimer';
$string['privacy:metadata:game'] = 'L’activité de jeu utilise des rapports de jeu.';
$string['privacy:metadata:game_attempts'] = 'Détails sur chaque tentative pour un jeu.';
$string['privacy:metadata:game_attempts:attempt'] = 'Le numéro de la tentative.';
$string['privacy:metadata:game_attempts:bookquiz_lastchapter'] = 'Le dernier chapitre du livre.';
$string['privacy:metadata:game_attempts:cross_createconnectors'] = 'Le nombre de connecteurs dans les mots croisés';
$string['privacy:metadata:game_attempts:cross_createfilleds'] = 'Le nombre de cases pleines dans les mots croisés';
$string['privacy:metadata:game_attempts:cross_createlimit'] = 'Le temps maximum autorisé pour essayer de trouver les meilleurs mots croisés';
$string['privacy:metadata:game_attempts:cross_createscore'] = 'Le note du mots croisés (à quel point le mots croisés est bon)';
$string['privacy:metadata:game_attempts:cross_createspaces'] = 'Le nombre d’espaces dans les mots croisés';
$string['privacy:metadata:game_attempts:cross_createtries'] = 'Le nombre d’essais réalisés pour arriver au meilleur mots croisés';
$string['privacy:metadata:game_attempts:cross_triesplay'] = 'Le nombre de fois où l’utilisateur a fait les mots croisés';
$string['privacy:metadata:game_attempts:cross_usedcols'] = 'Nombre de colonnes qui comprennent';
$string['privacy:metadata:game_attempts:cross_usedrows'] = 'Nombre de lignes qui comprennent';
$string['privacy:metadata:game_attempts:cross_words'] = 'Nombre de mots qui comprennent';
$string['privacy:metadata:game_attempts:cross_wordsall'] = 'Nombre de mots qui ont essayé d’inclure';
$string['privacy:metadata:game_attempts:cryptex_letters'] = 'Les lettres qui ont le mot mêlé (horizontalement et verticalement)';
$string['privacy:metadata:game_attempts:hangman_allletters'] = 'Toutes les lettres';
$string['privacy:metadata:game_attempts:hangman_corrects'] = 'Le nombre de lettres correctes';
$string['privacy:metadata:game_attempts:hangman_finishedword'] = '1 si l’utilisateur a terminé le jeu du pendu';
$string['privacy:metadata:game_attempts:hangman_iscorrect'] = '1 si c’est correct';
$string['privacy:metadata:game_attempts:hangman_letters'] = 'Lettres utilisées';
$string['privacy:metadata:game_attempts:hangman_maxtries'] = 'Nombre maximal d’essais autorisés pour un utilisateur';
$string['privacy:metadata:game_attempts:hangman_queryid'] = 'Lien vers game_queries';
$string['privacy:metadata:game_attempts:hangman_try'] = 'Le nombre d’essais réalisés par cet utilisateur au jeu du pendu';
$string['privacy:metadata:game_attempts:hiddenpicture_corect'] = 'Nombre de correctes';
$string['privacy:metadata:game_attempts:hiddenpicture_found'] = '1 si l’utilisateur a trouvé la bonne réponse';
$string['privacy:metadata:game_attempts:hiddenpicture_wrong'] = 'Nombre d’erreurs';
$string['privacy:metadata:game_attempts:language'] = 'La langue utilisée.';
$string['privacy:metadata:game_attempts:millionaire_level'] = 'Le niveau';
$string['privacy:metadata:game_attempts:millionaire_queryid'] = 'Lien vers game_queries';
$string['privacy:metadata:game_attempts:millionaire_state'] = 'L’état';
$string['privacy:metadata:game_attempts:preview'] = 'S’il s’agit d’un aperçu du jeu.';
$string['privacy:metadata:game_attempts:score'] = 'Le score (%) de la tentative.';
$string['privacy:metadata:game_attempts:snakes_dice'] = 'dé';
$string['privacy:metadata:game_attempts:snakes_position'] = 'La position au sein du tableau';
$string['privacy:metadata:game_attempts:snakes_queryid'] = 'id de requête';
$string['privacy:metadata:game_attempts:snakes_snakesdatabaseid'] = 'Quel tableau est utilisé';
$string['privacy:metadata:game_attempts:sudoku_data'] = 'donnée';
$string['privacy:metadata:game_attempts:sudoku_guess'] = 'invité';
$string['privacy:metadata:game_attempts:sudoku_level'] = 'niveau';
$string['privacy:metadata:game_attempts:sudoku_opened'] = 'ouvert';
$string['privacy:metadata:game_attempts:timefinish'] = 'L’heure à laquelle la tentative a été terminée.';
$string['privacy:metadata:game_attempts:timemodified'] = 'L’heure à laquelle la tentative a été mise à jour.';
$string['privacy:metadata:game_attempts:timestart'] = 'L’heure à laquelle la tentative a été démarrée.';
$string['privacy:metadata:game_grades'] = 'Détails sur la note globale de ce jeu.';
$string['privacy:metadata:game_grades:game'] = 'Le jeu a été noté.';
$string['privacy:metadata:game_grades:score'] = 'Le score total (%) pour ce jeu.';
$string['privacy:metadata:game_grades:timemodified'] = 'L’heure à laquelle la note a été modifiée.';
$string['privacy:metadata:game_grades:userid'] = 'L’utilisateur qui a été noté.';
$string['privacy:metadata:game_queries'] = 'game_queries';
$string['privacy:metadata:game_queries:answerid'] = 'Id de la réponse';
$string['privacy:metadata:game_queries:answertext'] = 'Texte de la réponse';
$string['privacy:metadata:game_queries:attachment'] = 'annexe';
$string['privacy:metadata:game_queries:attemptid'] = 'ID de la tentative';
$string['privacy:metadata:game_queries:correct'] = 'correct';
$string['privacy:metadata:game_queries:glossaryentryid'] = 'id de l’entrée du glossaire';
$string['privacy:metadata:game_queries:horizontal'] = 'horizontal';
$string['privacy:metadata:game_queries:id'] = 'id';
$string['privacy:metadata:game_queries:questionid'] = 'id de la question';
$string['privacy:metadata:game_queries:questiontext'] = 'Texte de la question';
$string['privacy:metadata:game_queries:score'] = 'score';
$string['privacy:metadata:game_queries:studentanswer'] = 'réponse de l’étudiant';
$string['privacy:metadata:game_queries:timelastattempt'] = 'Heure de la dernière tentative';
$string['privacy:metadata:game_queries:tries'] = 'essais';
$string['privacy:metadata:game_repetitions:gameid'] = 'id du jeu';
$string['privacy:metadata:game_repetitions:glossaryentryid'] = 'id de l’entrée du glossaire';
$string['privacy:metadata:game_repetitions:id'] = 'id';
$string['privacy:metadata:game_repetitions:questionid'] = 'id de la question';
$string['privacy:metadata:game_repetitions:repetitions'] = 'répétitions';
$string['privacy:metadata:game_repetitions:userid'] = 'id de l’utilisateur';
$string['reattemptgame'] = 'Tenter à nouveau';
$string['repetitions'] = 'Répétitions';
$string['reportoverview'] = 'Vue d’ensemble';
$string['reset_game_all'] = 'Supprimer les tentatives de tous les jeux';
$string['reset_game_deleted_course'] = 'Supprimer les tentatives des cours supprimés';
$string['results'] = 'Résultats';
$string['review'] = 'Relecture';
$string['reviewofattempt'] = 'Relecture de la tentative {$a}';
$string['score'] = 'Score';
$string['selectall'] = 'Choisir tout';
$string['selectnone'] = 'Déselectionner tout';
$string['showall'] = 'Tout montrer';
$string['showanswers'] = 'Montrer les réponses';
$string['showattempts'] = 'Montrer les tentatives';
$string['showdetailedmarks'] = 'Montrer les marques de détail';
$string['showsolution'] = 'solution';
$string['snakes_background'] = 'Arrière-plan';
$string['snakes_cols'] = 'Colonnes';
$string['snakes_data'] = 'Positions de Serpents et échelles';
$string['snakes_dice'] = 'Dé, $a points.';
$string['snakes_error'] = 'Erreur du jeu serpents et échelles : %s';
$string['snakes_file'] = 'Fichier pour l’arrière-plan';
$string['snakes_footerx'] = 'Espace en bas à gauche (en pixels)';
$string['snakes_footery'] = 'Espace en bas à droite (en pixels)';
$string['snakes_headerx'] = 'Espace en haut à gauche (en pixels)';
$string['snakes_headery'] = 'Espace en haut à droite (en pixels)';
$string['snakes_layout0'] = 'Question en haut de l’image';
$string['snakes_layout1'] = 'Question en bas de l’image';
$string['snakes_options'] = 'options « Serpents et échelles »';
$string['snakes_player'] = 'Joueur, position : $a.';
$string['snakes_rows'] = 'Lignes';
$string['sourcemodule'] = 'Source des questions';
$string['sourcemodule_book'] = 'Choisissez un livre';
$string['sourcemodule_glossary'] = 'Choisissez un glossaire';
$string['sourcemodule_glossarycategory'] = 'Choisissez une catégorie de glossaire';
$string['sourcemodule_include_subcategories'] = 'Inclure les sous-catégories';
$string['sourcemodule_question'] = 'Questions';
$string['sourcemodule_questioncategory'] = 'Choisissez une catégorie de questions';
$string['sourcemodule_quiz'] = 'Choisissez un test';
$string['startagain'] = 'Démarrer à nouveau';
$string['startedon'] = 'Démarré le';
$string['sudoku_create_count'] = 'Nombre de sudokus a créer';
$string['sudoku_create_start'] = 'Création des sudokus…';
$string['sudoku_creating'] = 'Création de <b>{$a}</b> sudoku(s)';
$string['sudoku_error'] = 'Erreur du jeu sudoku : %s';
$string['sudoku_finishattemptbutton'] = 'Fin du jeu';
$string['sudoku_guessnumber'] = 'Devinez le nombre correct';
$string['sudoku_maxquestions'] = 'Nombre maximum de questions';
$string['sudoku_noentriesfound'] = 'Aucun mot dans le glossaire';
$string['sudoku_options'] = 'Options du Sudoku';
$string['sudoku_submit'] = 'Enregistrer la réponse';
$string['timecompleted'] = 'Terminé';
$string['timefinish'] = 'Fin du jeu';
$string['timelastattempt'] = 'Dernière tentative';
$string['timestart'] = 'Démarrer';
$string['timetaken'] = 'Temps consommé';
$string['toptext'] = 'Texte en haut de la page';
$string['unfinished'] = 'ouvert';
$string['userdefined'] = 'Utilisateur défini';
$string['viewbook'] = 'Voir le livre <b>{$a}</b>';
$string['viewglossary'] = 'Voir le glossaire <b>{$a}</b>';
$string['viewquestions'] = 'Voir les questions';
$string['viewquiz'] = 'Voir les tests <b>{$a}</b>';
$string['win'] = 'Bravo !!!';
$string['withselected'] = 'Avec les éléments sélectionnés';
$string['yourfinalgradeis'] = 'Votre note finale pour ce jeu est {$a}.';
