<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sr_cr', version '4.3'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Додавање нове улоге';
$string['addrole'] = 'Додај нову улогу';
$string['advancedoverride'] = 'Напредно мењање улога';
$string['allow'] = 'Дозволи';
$string['allowassign'] = 'Дозволи додељивање улога';
$string['allowed'] = 'Дозвољено';
$string['allowoverride'] = 'Дозволи мењање улога';
$string['allowroletoassign'] = 'Дозволи кориснику са улогом {$a->fromrole} да додели улогу {$a->targetrole}';
$string['allowroletooverride'] = 'Дозволи кориснику са улогом {$a->fromrole} да мења улогу {$a->targetrole}';
$string['allowroletoswitch'] = 'Дозволи кориснику са улогом {$a->fromrole} да мења улоге у улогу {$a->targetrole}';
$string['allowroletoview'] = 'Дозволи корисницима са улогом {$a->fromrole} да виде улогу {$a->targetrole}';
$string['allowswitch'] = 'Дозволи преласке између улога';
$string['allowview'] = 'Дозволи улози да види';
$string['allsiteusers'] = 'Сви корисници на сајту';
$string['analytics:listinsights'] = 'Преглед увидa';
$string['analytics:listowninsights'] = 'Преглед сопствених увидa';
$string['analytics:managemodels'] = 'Управљање моделима';
$string['archetype'] = 'Архетипска улога';
$string['archetype_help'] = 'Архетипска улога одређује овлашћења која улога има када се ресетује на подразумеване вредности. Она, такође, одређује евентуална нова овлашћења за улогу приликом надоградње сајта.';
$string['archetypecoursecreator'] = 'АРХЕТИП: Креатор курса';
$string['archetypeeditingteacher'] = 'АРХЕТИП: Предавач (са уређивачким правима)';
$string['archetypefrontpage'] = 'АРХЕТИП: Ауторизовани корисник на насловној страници';
$string['archetypeguest'] = 'АРХЕТИП: Гост';
$string['archetypemanager'] = 'АРХЕТИП: Менаџер';
$string['archetypestudent'] = 'АРХЕТИП: Полазник';
$string['archetypeteacher'] = 'АРХЕТИП: Наставник (без уређивачких права)';
$string['archetypeuser'] = 'АРХЕТИП: Ауторизовани корисник';
$string['assignanotherrole'] = 'Додели још једну улогу';
$string['assignedroles'] = 'Додељене улоге';
$string['assignerror'] = 'Грешка приликом додељивања улоге {$a->role} кориснику {$a->user}.';
$string['assignglobalroles'] = 'Додели глобалне улоге';
$string['assignmentcontext'] = 'Контекст додељивања улога';
$string['assignmentoptions'] = 'Опције додељивања улога';
$string['assignrole'] = 'Додели улогу';
$string['assignrolenameincontext'] = 'Додели улогу \'{$a->role}\' у {$a->context}';
$string['assignroles'] = 'Додели улоге';
$string['assignroles_help'] = 'Додељивањем неке улоге кориснику у конкретном контексту одобравате му овлашћења која та улога подразумева, и то за текући контекст и све њему подређене. На пример, ако доделите улогу полазника кориснику у оквиру неког курса, он ће ту улогу имати не само на нивоу курса, већ и на нивоу свих блокова и активности у оквиру тог курса.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Додели улоге у {$a}';
$string['assignrolesrelativetothisuser'] = 'Додели улоге у односу на овог корисника';
$string['backtoallroles'] = 'Повратак на листу свих улога';
$string['backup:anonymise'] = 'Сакриј корисничке податке приликом креирања резервне копије података';
$string['backup:backupactivity'] = 'Резервна копија активности';
$string['backup:backupcourse'] = 'Резервна копија курсева';
$string['backup:backupsection'] = 'Резервна копија секција';
$string['backup:backuptargetimport'] = 'Резервна копија за увоз';
$string['backup:configure'] = 'Конфигурисање опција за креирање резервне копије';
$string['backup:downloadfile'] = 'Преузимање датотека из подручја резервних копија';
$string['backup:userinfo'] = 'Креирај резервну копију корисничких података';
$string['badges:awardbadge'] = 'Додели беџ кориснику';
$string['badges:configurecriteria'] = 'Подешавање/уређивање критеријуме за добијање беџа';
$string['badges:configuredetails'] = 'Подешавање/уређивање информација о беџу';
$string['badges:configuremessages'] = 'Конфигурисање порука о беџевима';
$string['badges:createbadge'] = 'Креирај/копирај беџеве';
$string['badges:deletebadge'] = 'Обриши беџеве';
$string['badges:earnbadge'] = 'Зарадите беџ';
$string['badges:manageglobalsettings'] = 'Управљање глобалним подешавањима за беџеве';
$string['badges:manageownbadges'] = 'Преглед и управљање својим добијеним беџевима';
$string['badges:revokebadge'] = 'Одузми беџ кориснику';
$string['badges:viewawarded'] = 'Преглед корисника који су зарадили одређену беџ без могућности  доделе беџа';
$string['badges:viewbadges'] = 'Преглед доступних беџева без могућности да се зараде';
$string['badges:viewotherbadges'] = 'Преглед  јавних беџева у профилима других корисника';
$string['block:edit'] = 'Уреди подешавања блока';
$string['block:view'] = 'Преглед блока';
$string['blog:create'] = 'Креирање нових блог уноса';
$string['blog:manageentries'] = 'Уређивање и управљање уносима';
$string['blog:manageexternal'] = 'Уређивање и управљање спољним блоговима';
$string['blog:search'] = 'Претражи уносе у блог';
$string['blog:view'] = 'Преглед чланака блога';
$string['blog:viewdrafts'] = 'Преглед радне верзије блог чланака';
$string['calendar:manageentries'] = 'Управљање произвољним уносима у календар';
$string['calendar:managegroupentries'] = 'Управљање ставкама везаним за групе';
$string['calendar:manageownentries'] = 'Управљање сопственим уносима у календар';
$string['capabilities'] = 'Способности';
$string['capability'] = 'Способност';
$string['category:create'] = 'Креирање категорија';
$string['category:delete'] = 'Обриши категорије';
$string['category:manage'] = 'Управљање категоријама';
$string['category:update'] = 'Ажурирај категорије';
$string['category:viewcourselist'] = 'Приказ категорија и курсева унутар ње';
$string['category:viewhiddencategories'] = 'Види скривене категорије';
$string['category:visibility'] = 'Види скривене категорије';
$string['checkglobalpermissions'] = 'Провери глобална овлашћења';
$string['checkpermissions'] = 'Провери овлашћења';
$string['checkpermissionsin'] = 'Провери овлашћења у {$a}';
$string['checksystempermissionsfor'] = 'Провери глобална овлашћења за {$a->fullname}';
$string['checkuserspermissionshere'] = 'Провери глобална овлашћења за {$a->fullname} које има у овом {$a->contextlevel}';
$string['chooseroletoassign'] = 'Молимо да изаберете улогу за додељивање';
$string['cohort:assign'] = 'Додај и уклони чланове кохорте';
$string['cohort:configurecustomfields'] = 'Конфигурисање прилагођених поља кохорте';
$string['cohort:manage'] = 'Креирај, обриши и премести кохорте';
$string['cohort:view'] = 'Преглед кохорти на нивоу сајта';
$string['comment:delete'] = 'Обриши коментаре';
$string['comment:post'] = 'Објави коментаре';
$string['comment:view'] = 'Преглед коментара';
$string['competency:competencygrade'] = 'Подеси рангирање компетенције';
$string['competency:competencymanage'] = 'Управљање оквирима компетенција';
$string['competency:competencyview'] = 'Прикажи оквире компетенција';
$string['competency:coursecompetencyconfigure'] = 'Конфигурисање подешавања компетенција курса';
$string['competency:coursecompetencygradable'] = 'Примање оцена компетенција';
$string['competency:coursecompetencymanage'] = 'Управљање компетенција курса';
$string['competency:coursecompetencyview'] = 'Преглед компетенција курса';
$string['competency:evidencedelete'] = 'Обриши доказ';
$string['competency:plancomment'] = 'Коментар на план учења';
$string['competency:plancommentown'] = 'Коментар на сопствени план учења';
$string['competency:planmanage'] = 'Управљање плановима учења';
$string['competency:planmanagedraft'] = 'Управљање радним верзијама планова учења';
$string['competency:planmanageown'] = 'Управљање сопственим плановима учења';
$string['competency:planmanageowndraft'] = 'Управљање сопственим радним верзијама планова учења';
$string['competency:planrequestreview'] = 'Захтевај рецензију плана учења';
$string['competency:planrequestreviewown'] = 'Захтевај рецензију сопственог плана учења';
$string['competency:planreview'] = 'Рецензирај план учења';
$string['competency:planview'] = 'Прикажи све планове учења';
$string['competency:planviewdraft'] = 'Прикажи радне верзије планова учења';
$string['competency:planviewown'] = 'Прикажи сопствене планове учења';
$string['competency:planviewowndraft'] = 'Прикажи сопствене нацрте планове учења';
$string['competency:templatemanage'] = 'Управљање шаблонима планова учења';
$string['competency:templateview'] = 'Прикажи шаблоне планова учења';
$string['competency:usercompetencycomment'] = 'Коментар на корисничку компетенцију';
$string['competency:usercompetencycommentown'] = 'Коментар на сопствену корисничку компетенцију';
$string['competency:usercompetencyrequestreview'] = 'Захтевај рецензију корисничке компетенције';
$string['competency:usercompetencyrequestreviewown'] = 'Захтевај рецензију сопствене корисничке компетенције';
$string['competency:usercompetencyreview'] = 'Рецензирај корисничку компетенцију';
$string['competency:usercompetencyview'] = 'Прикажи корисничку компетенцију';
$string['competency:userevidencemanage'] = 'Управљање доказима о претходном учењу';
$string['competency:userevidencemanageown'] = 'Управљање сопственим доказима о претходном учењу';
$string['competency:userevidenceview'] = 'Прикажи доказ о претходном учењу корисника';
$string['confirmaddadmin'] = 'Да ли стварно желите да додате корисника <strong>{$a}</strong> као новог администратора сајта?';
$string['confirmaddadmins'] = 'Да ли сте сигурни да желите да додате следеће кориснике на списак администратора сајта?';
$string['confirmdeladmin'] = 'Да ли стварно желите да уклоните корисника <strong>{$a}</strong> са списка администратора сајта?';
$string['confirmremoveadmins'] = 'Да ли сте сигурни да желите да уклоните следеће кориснике са списка администратора сајта?';
$string['confirmroleprevent'] = 'Да ли стварно желите да уклоните <strong>"{$a->role}"</strong> са списка дозвољених улога за способност "{$a->cap}" у контексту "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Да ли стварно желите да уклоните <strong>"{$a->role}"</strong> са списка забрањених улога за способност "{$a->cap}" у контексту "{$a->context}"?';
$string['confirmunassign'] = 'Да ли сте сигурни да желите да уклоните ову улогу овом кориснику?';
$string['confirmunassignno'] = 'Откажи';
$string['confirmunassigntitle'] = 'Потврди промену улоге';
$string['confirmunassignyes'] = 'Уклони';
$string['contentbank:access'] = 'Приступи банци садржаја';
$string['contentbank:copyanycontent'] = 'Копирајте било који садржај у банци садржаја';
$string['contentbank:copycontent'] = 'Копирајте садржај у банци садржаја';
$string['contentbank:deleteanycontent'] = 'Обриши сав садржај из банке садржаја';
$string['contentbank:deleteowncontent'] = 'Избриши садржај из сопствене банке садржаја';
$string['contentbank:downloadcontent'] = 'Преузми садржај из банке садржаја';
$string['contentbank:manageanycontent'] = 'Управљање било којим садржајем из банке садржаја';
$string['contentbank:manageowncontent'] = 'Управљање садржајем из сопствене банке садржаја';
$string['contentbank:upload'] = 'Постави нови садржај у банку садржаја';
$string['contentbank:useeditor'] = 'Креирање или уређивање садржаја помоћу едитора типа садржаја';
$string['contentbank:viewunlistedcontent'] = 'Погледај садржај из банке садржаја који није наведен';
$string['context'] = 'Контекст';
$string['contextrolenotallowed'] = 'Улога {$a} није дозвољена у овом контексту.';
$string['course:activityvisibility'] = 'Сакриј/прикажи активности';
$string['course:bulkmessaging'] = 'Пошаљи поруку већем броју људи';
$string['course:changecategory'] = 'Промени категорију курса';
$string['course:changefullname'] = 'Промени пун назив курса';
$string['course:changeidnumber'] = 'Промени идентификациони број курса';
$string['course:changelockedcustomfields'] = 'Измена закључаних прилагођених поља';
$string['course:changeshortname'] = 'Промени скраћени назив курса';
$string['course:changesummary'] = 'Промена резимеа курса';
$string['course:configurecoursecommunication'] = 'Конфигурисање комуникационих подешавања курса';
$string['course:configurecustomfields'] = 'Конфигурисање прилагођена поља курса';
$string['course:configuredownloadcontent'] = 'Конфигурисање преузимање садржаја курса';
$string['course:create'] = 'Креирај курсеве';
$string['course:creategroupconversations'] = 'Креира групну преписку';
$string['course:delete'] = 'Обриши курсеве';
$string['course:downloadcoursecontent'] = 'Преузимање садржаја курса';
$string['course:enrolconfig'] = 'Конфигуши инстанце уписа на курсеве';
$string['course:enrolreview'] = 'Преглед уписа на курсеве';
$string['course:ignoreavailabilityrestrictions'] = 'Игнориши ограничења доступности';
$string['course:ignorefilesizelimits'] = 'Користи датотеке веће од било ког ограничења за величину датотеке';
$string['course:isincompletionreports'] = 'Биће приказано у извештајима о завршетку';
$string['course:manageactivities'] = 'Управљање активностима';
$string['course:managefiles'] = 'Управљање датотекама';
$string['course:managegrades'] = 'Управљање оценама';
$string['course:managegroups'] = 'Управљање групама';
$string['course:managescales'] = 'Управљање скалама за оцењивање';
$string['course:markcomplete'] = 'Означи да су корисници завршили курс';
$string['course:movesections'] = 'Премести секције';
$string['course:overridecompletion'] = 'Измени статус завршетка активности';
$string['course:recommendactivity'] = 'Препоручује активности у бирачу активности';
$string['course:renameroles'] = 'Преименуј улоге';
$string['course:request'] = 'Захтев за отварање новог курса';
$string['course:reset'] = 'Поновно постављање курса';
$string['course:reviewotherusers'] = 'Прегледа друге корснике';
$string['course:sectionvisibility'] = 'Контрола видљивости секције';
$string['course:setcurrentsection'] = 'Постављање тренутно активне секције';
$string['course:setforcedlanguage'] = 'Обавезан језик на курсу односно активности';
$string['course:tag'] = 'Промени ознаке курса';
$string['course:togglecompletion'] = 'Ручно означите активности као завршене';
$string['course:update'] = 'Ажурирање подешавања курса';
$string['course:useremail'] = 'Омогући/онемогући адресу е-поште';
$string['course:view'] = 'Преглед курсева без учесника';
$string['course:viewcoursegrades'] = 'Преглед оцена на курсевима';
$string['course:viewhiddenactivities'] = 'Преглед скривених активности';
$string['course:viewhiddencourses'] = 'Преглед скривених курсева';
$string['course:viewhiddengroups'] = 'Приказ сакривених група';
$string['course:viewhiddensections'] = 'Преглед скривених секција';
$string['course:viewhiddenuserfields'] = 'Преглед скривених корисничких поља';
$string['course:viewparticipants'] = 'Преглед учесника';
$string['course:viewscales'] = 'Преглед скала за оцењивање';
$string['course:viewsuspendedusers'] = 'Преглед суспендованих корисника';
$string['course:visibility'] = 'Скривање/приказивање курсева';
$string['createrolebycopying'] = 'Креирање нових улога преузимање од  {$a}';
$string['createthisrole'] = 'Креирање ових улога';
$string['currentcontext'] = 'Тренутни контекст';
$string['currentrole'] = 'Тренутна улога';
$string['customroledescription'] = 'Прилагођени опис улоге';
$string['customroledescription_help'] = 'Ако је поље за прилагођени опис улоге празно, описи стандардних улога се аутоматски локализују.';
$string['customrolename'] = 'Прилагођени пуни назив улоге';
$string['customrolename_help'] = 'Ако је поље за прилагођени назив улоге празно, називи стандардних улога се аутоматски локализују. Морате навести пун назив за све прилагођене улоге.';
$string['defaultrole'] = 'Подразумевана улога';
$string['defaultx'] = 'Подразумевано {$a}';
$string['defineroles'] = 'Дефиниши улогe';
$string['definitionofrolex'] = 'Дефиниција улоге \'{$a}\'';
$string['deletecourseoverrides'] = 'Обриши све измене улога на курсу';
$string['deletelocalroles'] = 'Обриши све локално додељене улоге';
$string['deleterolesure'] = '<p>Да ли сте сигурни да желите да обришете улогу "{$a->name} ({$a->shortname})"?</p><p>Број корисника којима је ова улога тренутно додељена је: {$a->count}.</p>';
$string['deletexrole'] = 'Обриши {$a} улогу';
$string['duplicaterole'] = 'Копирај улогу';
$string['duplicaterolesure'] = '<p>Да ли сте сигурни да желите да дуплирате улогу  "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Уређивање улоге \'{$a}\'';
$string['editrole'] = 'Уреди улогу';
$string['editxrole'] = 'Уреди {$a} улогу';
$string['errorbadrolename'] = 'Погрешан назив улоге';
$string['errorbadroleshortname'] = 'Неисправан скраћени назив улоге';
$string['errorexistsrolename'] = 'Назив улоге већ постоји';
$string['errorexistsroleshortname'] = 'Назив улоге већ постоји';
$string['errorroleshortnametoolong'] = 'Скраћени назив не сме бити дужи од 100 знакова';
$string['eventcapabilityassigned'] = 'Додељена могућност';
$string['eventcapabilityunassigned'] = 'Укинута могућност';
$string['eventroleallowassignupdated'] = 'Дозволи додељивање улоге';
$string['eventroleallowoverrideupdated'] = 'Дозволи преписивање улоге';
$string['eventroleallowswitchupdated'] = 'Дозволи мењање улоге';
$string['eventroleallowviewupdated'] = 'Дозволи улози да види';
$string['eventroleassigned'] = 'Улога додељена';
$string['eventrolecapabilitiesupdated'] = 'Способности улоге ажуриране';
$string['eventrolecreated'] = 'Улога креирана';
$string['eventroledeleted'] = 'Улога обрисана';
$string['eventroleunassigned'] = 'Улога повучена';
$string['eventroleupdated'] = 'Ажурирана улога';
$string['existingadmins'] = 'Тренутни адимистратори сајта';
$string['existingusers'] = '{$a} постојећих корисника';
$string['explanation'] = 'Објашњење';
$string['export'] = 'Извези';
$string['extusers'] = 'Постојећи корисници';
$string['extusersmatching'] = 'Постојећи корисници који одговарају \'{$a}\'';
$string['filter:manage'] = 'Управљање подешавањима локалних филтера';
$string['frontpageuser'] = 'Ауторизовани корисник на насловној страници';
$string['frontpageuserdescription'] = 'Сви пријављени корисници на курсу насловне странице.';
$string['globalrole'] = 'Системска улога';
$string['globalroleswarning'] = 'УПОЗОРЕЊЕ! Свака улога коју доделите на овој страници примењиваће се на кориснике којима је додељена на читавом сајту, укључујући и насловну страницу и све курсеве.';
$string['gotoassignroles'] = 'Иди на Додели улоге за овај контекст {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Иди на Додели глобалне улоге';
$string['grade:edit'] = 'Едитуј оцене';
$string['grade:export'] = 'Извоз оцена';
$string['grade:hide'] = 'Сакриј/откриј оцене или ставке';
$string['grade:import'] = 'Увоз оцена';
$string['grade:lock'] = 'Закључај оцене или ставке';
$string['grade:manage'] = 'Управљање ставкама за оцењивање';
$string['grade:managegradingforms'] = 'Управљање напредним методама оцењивања';
$string['grade:manageletters'] = 'Управљање словним оценама';
$string['grade:manageoutcomes'] = 'Управљање исходима оцена';
$string['grade:managesharedforms'] = 'Управљање шаблонима образаца за напредно оцењивање';
$string['grade:override'] = 'Измени оцене';
$string['grade:sharegradingforms'] = 'Дељење обрасца за напредно оцењивање као шаблона';
$string['grade:unlock'] = 'Откључавање оцена или ставки';
$string['grade:view'] = 'Преглед сопствених оцена';
$string['grade:viewall'] = 'Преглед оцена других корисника';
$string['grade:viewhidden'] = 'Преглед сопствених сакривених оцена';
$string['group:configurecustomfields'] = 'Конфигурисање прилагођених поља за групе/груписања';
$string['h5p:deploy'] = 'Примени H5P садржај';
$string['h5p:setdisplayoptions'] = 'Подесите опције за приказ H5P-а';
$string['h5p:updatelibraries'] = 'Управљање типовима H5P садржаја';
$string['highlightedcellsshowdefault'] = 'Овлашћења истакнута у доњој табели су подразумевана овлашћења за архетип улоге изабрану горе.';
$string['highlightedcellsshowinherit'] = 'Засенчене ћелије у доњој табели показују дозволе које ће бити наслеђене. Осим способности, чија овлашћења заправо желите да промените, требало би све оставити подешенo на \'Наслеђено\'.';
$string['inactiveformorethan'] = 'неактиван више од {$a->timeperiod}';
$string['ingroup'] = 'у групи "{$a->group}"';
$string['inherit'] = 'Наслеђивање';
$string['invalidpresetfile'] = 'Невалидна датотека са дефиницијом улоге';
$string['legacy:admin'] = 'НАСЛЕЂЕНА УЛОГА: Администратор';
$string['legacy:coursecreator'] = 'НАСЛЕЂЕНА УЛОГА: Креатор курса';
$string['legacy:editingteacher'] = 'НАСЛЕЂЕНА УЛОГА: Предавач (са уређивачким правима)';
$string['legacy:guest'] = 'НАСЛЕЂЕНА УЛОГА: Гост';
$string['legacy:student'] = 'НАСЛЕЂЕНА УЛОГА: Полазник';
$string['legacy:teacher'] = 'НАСЛЕЂЕНА УЛОГА: Предавач (без уређивачких права)';
$string['legacy:user'] = 'НАСЛЕЂЕНА УЛОГА: Ауторизовани корисник';
$string['legacytype'] = 'Тип наслеђене улоге';
$string['listallroles'] = 'Списак свих улога';
$string['localroles'] = 'Локално додељене улоге';
$string['mainadmin'] = 'Главни администратор';
$string['mainadminset'] = 'Постави главног администратора';
$string['manageadmins'] = 'Управљање администраторима сајта';
$string['manager'] = 'Менаџер';
$string['managerdescription'] = 'Менаџери могу да приступе курсевима и да их мењају, али обично не учествују на њима.';
$string['manageroles'] = 'Управљање улогама';
$string['maybeassignedin'] = 'Врста контекста у којем ова улога може бити додељена';
$string['moodlenet:shareactivity'] = 'Делите активности на MoodleNet платформи';
$string['moodlenet:sharecourse'] = 'Дељење курса на MoodleNet платформи';
$string['morethan'] = 'Више од {$a}';
$string['multipleroles'] = 'Вишеструке улоге';
$string['my:configsyspages'] = 'Конфигуриши глобалне шаблоне за странице \'Контролни панел\'';
$string['my:manageblocks'] = 'Управљање блоковима на страници \'Контролни панел\'';
$string['neededroles'] = 'Улоге са овлашћењем';
$string['nocapabilitiesincontext'] = 'Нема способности расположивих у овом контексту';
$string['noneinthisx'] = 'Нико за овај {$a}';
$string['noneinthisxmatching'] = 'Ниједан корисник не одговара \'{$a->search}\' у овом контексту {$a->contexttype}';
$string['norole'] = 'Без улоге';
$string['noroleassignments'] = 'Овај корисник нема додељену ниједну улогу било где на овом сајту';
$string['noroles'] = 'Нема улога';
$string['notabletoassignroleshere'] = 'Администратор није омогућио додељивање улога у овом контексту.';
$string['notabletooverrideroleshere'] = 'Нисте у могућности да овде мењате овлашћења било које улоге';
$string['notes:manage'] = 'Управљање белешкама';
$string['notes:view'] = 'Преглед белешки';
$string['notset'] = 'Није постављено';
$string['novisibleroles'] = 'Нема улога';
$string['overrideanotherrole'] = 'Измени другу улогу';
$string['overridecontext'] = 'Измени контекст';
$string['overridepermissions'] = 'Измени овлашћења';
$string['overridepermissions_help'] = 'Измена овлашћења омогућава да дозволу односно забрану озабраних способности у одређеном контексту';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Измени овлашћења улоге \'{$a->role}\' у {$a->context}';
$string['overridepermissionsin'] = 'Измени овлашћења у {$a}';
$string['overrideroles'] = 'Измени улоге';
$string['overriderolesin'] = 'Измени улоге у {$a}';
$string['overrides'] = 'Измене';
$string['overridesbycontext'] = 'Измене (према контексту)';
$string['payment:manageaccounts'] = 'Управљање налозима';
$string['payment:viewpayments'] = 'Прегледа уплата';
$string['permission'] = 'Овлашћење';
$string['permission_help'] = 'Овлашћења представљају подешавања одговарајућих способности. Постоје 4 опције:

* Није постављено
* Дозволи - даје се дозвола за извршавање одређене способности
* Спречи - Овлашћење се уклања, чак и ако је допуштено у ширем контексту
* Забрани - овлашћење се у потпуности укида и не може се променити на било ком ужем (специфичнијем) контексту';
$string['permissions'] = 'Овлашћења';
$string['permissionsforuser'] = 'Овлашћења за корисника {$a}';
$string['permissionsincontext'] = 'Овлашћења у {$a}';
$string['portfolio:export'] = 'Извези у портфолио';
$string['potentialusers'] = '{$a} потенцијалних корисника';
$string['potusers'] = 'Потенцијални корисници';
$string['potusersmatching'] = 'Потенцијални кориснцици који одговарају \'{$a}\'';
$string['prevent'] = 'Спречи';
$string['privacy:metadata:preference:showadvanced'] = 'Управља прекидачем дугмета за напредни режим.';
$string['privacy:metadata:role_assignments'] = 'Додела улога';
$string['privacy:metadata:role_assignments:component'] = 'Додатак одговоран за доделу улога, празан када су улоге ручно додељене.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID ознака инстанце уписа/провере идентитета одговорне за ову доделу улога';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID ознака корисника који је креирао или изменио доделу улоге';
$string['privacy:metadata:role_assignments:roleid'] = 'ID ознака улоге';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Ова табела чува додељене улоге у сваком контексту.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Датум када је додела улога креирана или измењена.';
$string['privacy:metadata:role_assignments:userid'] = 'ID ознака корисника';
$string['privacy:metadata:role_capabilities'] = 'Способности улога';
$string['privacy:metadata:role_capabilities:capability'] = 'Назив способности.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID ознака корисника који креирао или изменио способност';
$string['privacy:metadata:role_capabilities:permission'] = 'Овлашћења за способност: наследити, дозволити, спречити или забранити.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID ознака улоге';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Способности и измене способности за одређену улогу у одређеном контексту';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Датум када је привилегија креирана или измењена.';
$string['privacy:metadata:role_cohortroles'] = 'Улоге на кохорту';
$string['prohibit'] = 'Забрани';
$string['prohibitedroles'] = 'Забрањено';
$string['question:add'] = 'Додавање нових питања';
$string['question:commentall'] = 'Коментарисање свих питања';
$string['question:commentmine'] = 'Коментарисање сопствених питања';
$string['question:config'] = 'Кофигурисање типова питања';
$string['question:editall'] = 'Уреди сва питања';
$string['question:editmine'] = 'Уреди своја питања';
$string['question:flag'] = 'Обележи (заставицом) питања у току давања одговора на њих';
$string['question:managecategory'] = 'Уреди категорије питања';
$string['question:moveall'] = 'Премести сва питања';
$string['question:movemine'] = 'Премести своја питања';
$string['question:tagall'] = 'Означите сва питања';
$string['question:tagmine'] = 'Означите своја питања';
$string['question:useall'] = 'Користи сва питања';
$string['question:usemine'] = 'Користи своја питања';
$string['question:viewall'] = 'Преглед свих питања';
$string['question:viewmine'] = 'Преглед сопствених питања';
$string['rating:rate'] = 'Додај оцене ставкама';
$string['rating:view'] = 'Погледај укупну оцену коју си добио/ла';
$string['rating:viewall'] = 'Преглед свих необрађених оцена које су дали појединци';
$string['rating:viewany'] = 'Преглед укупних оцена које је било ко добио';
$string['reportbuilder:edit'] = 'Уређивање сопствених прилагођених извештаја';
$string['reportbuilder:editall'] = 'Уређивање свих прилагођених извештаја';
$string['reportbuilder:scheduleviewas'] = 'Преглед планираних извештаја из угла других корисника';
$string['reportbuilder:view'] = 'Преглед прилагођених извештаја';
$string['resetrole'] = 'Ресетуј';
$string['resettingrole'] = 'Враћање улоге \'{$a}\' на подразумеване вредности';
$string['restore:configure'] = 'Конфигурисање опција за рестаурацију';
$string['restore:createuser'] = 'Креирај кориснике приликом рестаурације';
$string['restore:restoreactivity'] = 'Рестаурирај активности';
$string['restore:restorecourse'] = 'Рестаурирај курсеве';
$string['restore:restoresection'] = 'Рестаурирај секције';
$string['restore:restoretargetimport'] = 'Рестаурирај из датотека намењених увозу';
$string['restore:rolldates'] = 'Дозвољено је променити конфигурацију датума активности приликом рестаурације';
$string['restore:uploadfile'] = 'Постави датотеке у подручје за резервне копије';
$string['restore:userinfo'] = 'Рестаурирај корисничке податке';
$string['restore:viewautomatedfilearea'] = 'Рестаурирај курсеве из аутоматски креираних резервних копија';
$string['risks'] = 'Ризици';
$string['role:assign'] = 'Додељивање улога корисницима';
$string['role:manage'] = 'Креирање и управљање улогама';
$string['role:override'] = 'Измени овлашћења за друге';
$string['role:review'] = 'Прегледај овлашћења других корисника';
$string['role:safeoverride'] = 'Преправи безбедне дозволе за остале';
$string['role:switchroles'] = 'Пребацивање на друге улоге';
$string['roleallowheader'] = 'Дозволи улогу:';
$string['roleallowinfo'] = 'Изаберите улогу која ће бити додата списку дозвољених улога у контексту "{$a->context}", capability "{$a->cap}":';
$string['roleassignments'] = 'Додељивање улога';
$string['roledefinitions'] = 'Дефиниција улога';
$string['rolefullname'] = 'Назив улоге';
$string['roleincontext'] = '{$a->role} у {$a->context}';
$string['roleprohibitheader'] = 'Забрањена улога';
$string['roleprohibitinfo'] = 'Изаберите улогу која ће бити додата списку забрањених улога у контексту "{$a->context}", capability "{$a->cap}":';
$string['rolerepreset'] = 'Користи предефинисану улогу';
$string['roleresetdefaults'] = 'Подразумеване вредности';
$string['roleresetrole'] = 'Користи улогу или архетип';
$string['rolerisks'] = 'Ризици улоге';
$string['roles'] = 'Улоге';
$string['roles_help'] = 'Улога представља скуп овлашћења дефинисаних на нивоу читавог система које можете да доделите одређеним корисницима у одређеном контексту.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Одабери улогу';
$string['rolesforuser'] = 'Улоге за корисника {$a}';
$string['roleshortname'] = 'Скраћени назив';
$string['roleshortname_help'] = 'Скраћени назив улоге је базични идентификатор улога за који је дозвољено користити само ASCII алфанумеричке знакове.';
$string['roletoassign'] = 'Улога која се додељује';
$string['roletooverride'] = 'Улога која се мења';
$string['safeoverridenotice'] = 'Напомена: Могућности са више ризика су закључане јер Вам је допуштено да преправљате једино безбедне могућности овлашћења.';
$string['search:query'] = 'Изврши претрагу на нивоу сајта';
$string['selectanotheruser'] = 'Изaбери другог корисника';
$string['selectauser'] = 'Изабери корисника';
$string['selectrole'] = 'Изаберите улогу';
$string['showallroles'] = 'Приказ свих улога';
$string['showthisuserspermissions'] = 'Прикажи овлашћења овог корисника';
$string['site:accessallgroups'] = 'Приступ свим групама';
$string['site:approvecourse'] = 'Одобравање креирања курса';
$string['site:backup'] = 'Креирање резервних копија курсева';
$string['site:config'] = 'Промени конфигурацију сајта';
$string['site:configview'] = 'Приказ хијерархијске структуре администрације сајта (али и не свих страница унутар ње)';
$string['site:deleteanymessage'] = 'Обриши постојеће поруке на сајту';
$string['site:deleteownmessage'] = 'Обриши поруке које је корисник послао/примио';
$string['site:doanything'] = 'Дозвољено да ради било шта';
$string['site:doclinks'] = 'Приказ линкова ка документима ван сајта';
$string['site:forcelanguage'] = 'Измена језика курса';
$string['site:import'] = 'Увоз других курсева у текући курс';
$string['site:maintenanceaccess'] = 'Приступ сајту док је у режиму одржавања';
$string['site:manageallmessaging'] = 'Додаје, уклања, блокира и деблокира контакте за све кориснике';
$string['site:manageblocks'] = 'Управљање блоковима на страници';
$string['site:managecontextlocks'] = 'Управљање замрзавањем контекста';
$string['site:messageanyuser'] = 'Заобилази параметре корисника за приватност за слање порука било ком кориснику';
$string['site:mnetloginfromremote'] = 'Пријавите се из удаљене апликације путем MNeta';
$string['site:mnetlogintoremote'] = 'Идите до удаљене апликације путем MNeta';
$string['site:readallmessages'] = 'Прочитај све поруке на сајту';
$string['site:restore'] = 'Рестаурирање курсева';
$string['site:senderrormessage'] = 'Слање поруку кориснику подршке са странице о грешци';
$string['site:sendmessage'] = 'Пошаљи поруку било ком кориснику';
$string['site:trustcontent'] = 'Поверење у безбедност предатог садржаја';
$string['site:uploadusers'] = 'Постави нове кориснике из датотеке';
$string['site:viewanonymousevents'] = 'Преглед анонимних догађаја у извештајима';
$string['site:viewfullnames'] = 'Увек види пуна имена корисника';
$string['site:viewparticipants'] = 'Преглед учесника';
$string['site:viewreports'] = 'Преглед извештаја';
$string['site:viewuseridentity'] = 'Види потпун идентитет корисника на списковима';
$string['siteadministrators'] = 'Администратори сајта';
$string['siteadministratorsconfigphp'] = 'Списак администратора сајта се не може променити јер је дефинисан у датотеци config.php.';
$string['tag:edit'] = 'Уређивање постојећих ознака';
$string['tag:editblocks'] = 'Уређивање блокова на страницама ознака';
$string['tag:flag'] = 'Обележи ознаке као непримерене';
$string['tag:manage'] = 'Управљање свим ознакама';
$string['thisnewrole'] = 'Ова нова улога';
$string['thisusersroles'] = 'Улоге додељене овом кориснику';
$string['unassignarole'] = 'Недодељена улога {$a}';
$string['unassignconfirm'] = 'Да ли стварно желите да уклоните улогу "{$a->role}" кориснику "{$a->user}"?';
$string['unassignerror'] = 'Грешка приликом одзимања улоге {$a->role} кориснику {$a->user}.';
$string['user:changeownpassword'] = 'Промени сопствену лозинку';
$string['user:create'] = 'Креирај кориснике';
$string['user:delete'] = 'Обриши кориснике';
$string['user:editmessageprofile'] = 'Уреди кориснички профил за слање порука';
$string['user:editownmessageprofile'] = 'Уреди сопствени профил за слање порука';
$string['user:editownprofile'] = 'Уреди свој кориснички профил';
$string['user:editprofile'] = 'Уређивање корисничког профила';
$string['user:ignoreuserquota'] = 'Игнориши ограничење корисничке квоте';
$string['user:loginas'] = 'Пријавите се као други корисник';
$string['user:manageblocks'] = 'Управљање блоковима на корисничким профилима других корисника';
$string['user:manageownblocks'] = 'Управљање блоковима на сопственом јавном корисничком профилу';
$string['user:manageownfiles'] = 'Управљање датотекама у сопственом простору за приватне датотеке';
$string['user:managesyspages'] = 'Конфигуриши подразумевани изглед странице за јавне корисничке профиле';
$string['user:readuserblogs'] = 'Погледај све корисничке блогове';
$string['user:readuserposts'] = 'Види све поруке корисника на фоумима';
$string['user:update'] = 'Ажурирај корисничке профиле';
$string['user:viewalldetails'] = 'Преглед свих података о кориснику';
$string['user:viewdetails'] = 'Преглед корисничких профила';
$string['user:viewhiddendetails'] = 'Преглед скривених детаља о корисницима';
$string['user:viewlastip'] = 'Види последњу IP адресу корисника';
$string['user:viewuseractivitiesreport'] = 'Види извештаје о активностима корисника';
$string['user:viewusergrades'] = 'Преглед корисничких оцена';
$string['usersfrom'] = 'Корисник из {$a}';
$string['usersfrommatching'] = 'Корисници из {$a->contextname} који одговарају \'{$a->search}\'';
$string['usersinthisx'] = 'Корисници у овом {$a}';
$string['usersinthisxmatching'] = 'Корисници у овом {$a->contexttype} који одговарају \'{$a->search}\'';
$string['userswithrole'] = 'Сви корисници са улогом';
$string['userswiththisrole'] = 'Корисници са улогом';
$string['useshowadvancedtochange'] = 'Употреби \'Прикажи напредно\' за промену';
$string['viewingdefinitionofrolex'] = 'Преглед дефиниције улоге \'{$a}\'';
$string['viewrole'] = 'Преглед детаља о улогама';
$string['webservice:createmobiletoken'] = 'Креирај токен за приступ веб сервису путем мобилних уређаја';
$string['webservice:createtoken'] = 'Креирај токен за веб сервис';
$string['webservice:managealltokens'] = 'Управљање свим токенима корисничких веб сервиса';
$string['whydoesuserhavecap'] = 'Зашто {$a->fullname} има способност {$a->capability} у контексту {$a->context}?';
$string['whydoesusernothavecap'] = 'Зашто {$a->fullname} нема способност {$a->capability} у контексту {$a->context}?';
$string['xroleassignments'] = 'Додељене улоге за {$a}';
$string['xuserswiththerole'] = 'Корисници са улогом "{$a->role}"';
