<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'sr_cr', version '4.3'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Прихватам <a href=":url" target="_blank">услове коришћења</a>';
$string['accountdetailslinktext'] = 'овде';
$string['action'] = 'Акција';
$string['add'] = 'Додај';
$string['addedandupdatedpp'] = 'Додато нових H5P библиотека: {$a->%new}, и ажурирано старих: {$a->%old}.';
$string['addedandupdatedps'] = 'Додато нових H5P библиотека: {$a->%new}, и ажурирана {$a->%old} стара.';
$string['addedandupdatedsp'] = 'Додата {$a->%new} нова H5P библиотека, и ажурирано старих: {$a->%old}.';
$string['addedandupdatedss'] = 'Додата {$a->%new} нова H5P библиотека, и ажурирана {$a->%old} стара.';
$string['addednewlibraries'] = 'Додато нових H5P библиотека: {$a->%new}';
$string['addednewlibrary'] = 'Додата {$a->%new} нова H5P библиотека.';
$string['additionalinfo'] = 'Додатне информације';
$string['additionallicenseinfo'] = 'Све додатне информације о лиценци';
$string['addlibraries'] = 'Додај библиотеке';
$string['address'] = 'Адреса';
$string['age'] = 'Типичан узраст';
$string['agedescription'] = 'Циљна публика за овај садржај. Могући формати уноса одвојени зарезима су: „1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Покушај учитавања података није успео';
$string['alttext'] = 'Alt текст';
$string['anunexpectedsave'] = 'Догодило се нешто неочекивано. Нисмо успели да сачувамо овај интерактивни садржај.';
$string['assistivetechnologieslabel'] = 'Ознака за асистивне технологије';
$string['attribution'] = 'Ауторство 4.0';
$string['attributionnc'] = 'Ауторство - Некомерцијална лиценца 4.0';
$string['attributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада 4.0';
$string['attributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима 4.0';
$string['attributionnd'] = 'Ауторство - Лиценца - Без прерада 4.0';
$string['attributionsa'] = 'Ауторство - Лиценца - Делити под истим условима 4.0';
$string['author'] = 'Аутор';
$string['authorcomments'] = 'Коментари аутора';
$string['authorcommentsdescription'] = 'Коментари за уредника интерактивног садржаја (овај текст неће бити објављен као део информације о ауторским правима)';
$string['authorname'] = 'Име аутора';
$string['authorrole'] = 'Улога аутора';
$string['back'] = 'Назад';
$string['by'] = 'од стране';
$string['cancel'] = 'Откажи';
$string['cancellabel'] = 'Откажи';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Не';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Да';
$string['cancelpublishconfirmationdialogdescription'] = 'Да ли сте сигурни да желите да откажете дељење?';
$string['cancelpublishconfirmationdialogtitle'] = 'Откажи дељење';
$string['ccattribution'] = 'Ауторство (CC BY)';
$string['ccattributionnc'] = 'Ауторство - Некомерцијална лиценца (CC BY-NC)';
$string['ccattributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Ауторство - Лиценца - Без прерада (CC BY-ND)';
$string['ccattributionsa'] = 'Ауторство - Лиценца - Делити под истим условима (CC BY-SA)';
$string['ccpdd'] = 'Посвећеност јавном власништву (CC0)';
$string['ccpdm'] = 'Ознака јавног власништва (PDM)';
$string['changedby'] = 'Променио/ла';
$string['changedescription'] = 'Опис промене';
$string['changehasbeensubmitted'] = 'Промена је предата за';
$string['changelog'] = 'Измене записа';
$string['changeplaceholder'] = 'Фотографија изрезана, текст промењен, итд.';
$string['city'] = 'Град';
$string['close'] = 'Затвори';
$string['completionpass'] = 'Захтевај прелазну оцену';
$string['completionpass_help'] = 'Ако је ова опција омогућена, ова активност се сматра завршеном када ученик добије прелазну оцену (као што је наведено у одељку Оцена у подешавањима H5P активности) или вишу.';
$string['completionpassdesc'] = 'Полазник мора постићи прелазну оцену како би завршио ову активност';
$string['confirmdialogbody'] = 'Потврдите да желите да наставите. Ова акција је неповратна.';
$string['confirmdialogheader'] = 'Потврди акцију';
$string['confirmlabel'] = 'Потврди';
$string['connectionlost'] = 'Веза се прекинула. Резултати ће бити сачувани и послати када поново успоставите везу.';
$string['connectionreestablished'] = 'Веза је поново успостављена.';
$string['contactperson'] = 'Контакт особа';
$string['contactpersondescription'] = 'H5P ће контактирати особу одговорну за контакт у случају да постоје проблеми са садржајем који је издавач поделио. Име контакт особе или друге информације неће бити објављене нити дељене са трећим лицима';
$string['contentavailable'] = 'Ваш садржај ће обично бити доступан на H5P OER HUB- у року од једног радног дана.';
$string['contentchanged'] = 'Овај интерактивни садржај је промењен од када сте га последњи пут користили.';
$string['contentcopied'] = 'Садржај је копиран у клипборд';
$string['contenthub:changesettings'] = 'Промените подешавања налога <a href="{$a}">овде</a>';
$string['contenthub:licenseagreementdescription'] = 'Молимо вас, прочитајте следећи уговор пре него што наставите';
$string['contenthub:licenseagreementmaintext'] = 'TODO';
$string['contenthub:licenseagreementtitle'] = 'End User License Agreement (EULA)';
$string['contenthub:nopermissions'] = 'Немате овлашћење да региструјете сајт на чворишту са садржајем.';
$string['contenthub:register'] = 'Региструјте налог на H5P OER HUB-у <a href="{$a}">овде</a>';
$string['contenthub:settings:box'] = 'H5P OER HUB Налог';
$string['contenthub:settings:heading'] = 'H5P OER HUB - Подешавања налога';
$string['contenthubeditsharing'] = 'Уредите информације о дељењу';
$string['contenthuboptions'] = 'H5P OER HUB - Опције';
$string['contenthubshare'] = 'Поделите на H5P OER HUB-у';
$string['contenthubsharinginprogress'] = 'Дељење...';
$string['contenthubsyncchanges'] = 'Синхронизујте промене';
$string['contenthubunshare'] = 'Опозови дељење';
$string['contentissyncing'] = 'Садржај се синхронизује.';
$string['contentlicensetitle'] = 'Информације о лиценци садржаја';
$string['contentnotshared'] = 'Садржај се не дели на H5P OER HUB-у.';
$string['contentstatefrequency'] = 'Учесталост снимања статуса интерактивног садржаја';
$string['contentstatefrequency_help'] = 'Временски период, у секундама, колико често желите да корисници аутоматски чувају свој напредак. Повећајте овај број ако имате проблема са великим бројем AJAX захтева.';
$string['contenttype'] = 'Тип интерактивног садржаја';
$string['contenttypecacheheader'] = 'Кеш интерактивног садржаја';
$string['contentupdatesoon'] = 'Ваш садржај ће се ускоро ажурирати';
$string['copyright'] = 'Права коришћења';
$string['copyrightinfo'] = 'Информације о ауторским правима';
$string['copyrightstring'] = 'Ауторска права';
$string['copyrighttitle'] = 'Погледајте информације о ауторским правима за овај интерактивни садржај.';
$string['copyrightwarning'] = 'Материјал заштићен ауторским правима се не може делити на H5P OER HUB-у. Ако је садржај под лиценцом која је прилагођена OER-у, као што је Creative Commons, изаберите одговарајућу лиценцу. Ако није, овај садржај се не може делити.';
$string['couldnotcopy'] = 'Није могуће копирати датотеку';
$string['couldnotparsejsonfromzip'] = 'Није могуће парсирати JSON из пакета: %fileName';
$string['couldnotparsepostdata'] = 'Није могуће парсирати податке поста.';
$string['couldnotreadfilefromzip'] = 'Није могуће прочитати датотеку из пакета: %fileName';
$string['couldnotsave'] = 'Није могуће сачувати датотеку';
$string['country'] = 'Земља';
$string['create'] = 'Креирај';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Ажурирајте кеш интерактивног садржаја';
$string['ctcacheconnectionfailed'] = 'Није могуће успоставити везу са H5P OER HUB-ом. Молимо, покушајте поново касније.';
$string['ctcachedescription'] = 'Ако водите рачуна да кеш интерактивних садржаја буде ажуран онда ћете моћи да прегледате, преузмете и користите најновије библиотеке. Ово се разликује од ажурирања самих библиотека.';
$string['ctcachelastupdatelabel'] = 'Последња промена';
$string['ctcacheneverupdated'] = 'Никад';
$string['ctcachenolibraries'] = 'Ниједан тип интерактивног садржаја није преузет са H5P OER HUB-а. Молимо, покушајте поново касније.';
$string['ctcachesuccess'] = 'Кеш библиотеке је успешно ажуриран!';
$string['ctcachetaskname'] = 'Ажурирајте кеш интерактивног садржаја';
$string['currentpage'] = 'Страница $current од $total';
$string['currentstep'] = 'Корак :step од :total';
$string['dataviewreportlabel'] = 'Прикажи одговоре';
$string['date'] = 'Датум';
$string['description'] = 'Опис';
$string['disablefileextensioncheck'] = 'Онемогући проверу екстензије датотеке';
$string['disablefileextensioncheckwarning'] = 'Упозорење! Онемогућавање провере екстензије датотеке може да има последице по безбедност система, јер омогућава постављање PHP датотека. То би омогућило нападачима да покрену злонамерни кôд на вашем сајту. Проверите да ли знате тачно коју датотеку постављате.';
$string['disablefullscreen'] = 'Онемогући приказ преко целог екрана';
$string['disablehubconfirmationmsg'] = 'Да ли и даље желите да омогућите чвориште?';
$string['disablehubdescription'] = 'Препоручује се да ова опција буде омогућена. H5P OER HUB обезбеђује једноставан интерфејс за преузимање нових типова интерактивног садржаја и ажурирање постојећих. Убудуће, ова опција ће, такође, олакшати дељење и поновно коришћење интерактивних садржаја. Ако је ова опција онемогућена, интерактивне садржаје ћете морати да инсталирати и ажурирати путем образаца за постављање датотека.';
$string['disciplinedescription'] = 'Можете изабрати више дисциплина';
$string['disciplinelabel'] = 'Дисциплине';
$string['disciplinelimitreachedmessage'] = 'Максималан број дисциплина које можете изабрати: :numDisciplines';
$string['disciplines'] = 'Дисциплине';
$string['displayoptionalwaysshow'] = 'Увек прикажи';
$string['displayoptionauthoroff'] = 'Контролисано од стране аутора, стандардно искључено';
$string['displayoptionauthoron'] = 'Контролисано од стране аутора, стандардно укључено';
$string['displayoptiondownloadalways'] = 'Увек';
$string['displayoptiondownloadnever'] = 'Никад';
$string['displayoptiondownloadpermission'] = 'Само ако корисник има овлашћења да извезе H5P';
$string['displayoptionnevershow'] = 'Никад не приказуј';
$string['displayoptionpermissions'] = 'Прикажи само ако корисник има овлашћења да извезе H5P';
$string['displayoptionpermissionsembed'] = 'Прикажи само ако корисник има овлашћења да угради H5P';
$string['displayoptions'] = 'Опције приказа';
$string['download'] = 'Преузми';
$string['downloadfailed'] = 'Преузимање затражене библиотеке није успело.';
$string['downloadtitle'] = 'Преузмите овај интерактивни садржај као H5P датотеку.';
$string['dropdownbutton'] = 'Дугме за падајући мени';
$string['editinfotitle'] = 'Уредите информације за <strong>:title</strong>';
$string['editingfailed'] = 'Уређивање није успело.';
$string['editor'] = 'Едитор';
$string['emailaddress'] = 'Адреса е-поште';
$string['emailaddressdescription'] = 'H5P ће користити адресу е-поште да ступи у контакт са издавачем у случају било каквих проблема са садржајем или у случају да издавач треба да поврати свој налог. Адресе е-поште неће бити објављен нити дељен са трећим лицима';
$string['emailconfirmbody'] = 'Поштовани/а {$a->username},

Хвала вам што сте послали своје одговоре у оквиру \'{$a->hvpname}\' на курсу \'{$a->coursename}\'.

Ова порука потврђује да су ваши одговори сачувани.

Овој H5P активности можете приступити на {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Хвала вам што сте послали своје одговоре на \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Потврда о слању за {$a->hvpname}';
$string['emailnotifybody'] = 'Поштовани/а {$a->username},

{$a->studentname} је завршио/ла \'{$a->hvpname}\' ({$a->hvpurl}) на курсу \'{$a->coursename}\'.

Можете прегледати овај покушај на {$a->hvpreporturl}.';
$string['emailnotifysmall'] = 'Полазник {$a->studentname} је завршио/ла активност {$a->hvpname}. Погледајте {$a->hvpreporturl}';
$string['emailnotifysubject'] = 'Полазник {$a->studentname} је завршио/ла активност {$a->hvpname}';
$string['embed'] = 'Угради';
$string['embedloginfailed'] = 'Немате приступ овом интерактивном садржају. Покушајте да се пријавите.';
$string['embedtitle'] = 'Прикажи уграђени кôд за овај интерактивни садржај.';
$string['empty'] = 'Нема доступних резултата';
$string['enableabout'] = 'Дугме ”О H5P”';
$string['enablecopyright'] = 'Дугме за ауторска права';
$string['enabledlrscontenttypes'] = 'Омогућите LRS зависан интераткиван садржај';
$string['enabledlrscontenttypes_help'] = 'Омогућава коришћење интерактивних садржаја који се ослањају  на LRS (Learning Record Store) како би функционисали исправно, као што је интерактивни садржај Упитник (Questionnaire).';
$string['enabledownload'] = 'Дозволи преузимање';
$string['enableembed'] = 'Угради дугме';
$string['enableframe'] = 'Прикажи траку акције и оквир';
$string['enablehublabel'] = 'Користи H5P OER HUB';
$string['enablejavascript'] = 'Омогући JavaScript.';
$string['enablesavecontentstate'] = 'Сними статус интерактивног садржаја';
$string['enablesavecontentstate_help'] = 'Аутоматски се снима тренутно стање интерактивних садржаја за сваког корисника. То значи да корисник може да настави тамо где је стао.';
$string['failedtodownloadh5p'] = 'Није могуће преузети тражени H5P.';
$string['fileexceedsmaxsize'] = 'Једна од датотека унутар пакета премашује максималну дозвољену величину датотеке. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Датотека није пронађена на серверу. Проверите подешавања за постављање датотека.';
$string['filenotimage'] = 'Датотека није слика';
$string['filetypenotallowed'] = 'Тип датотеке није дозвољен.';
$string['finished'] = 'Завршено';
$string['fullscreen'] = 'Приказ преко целог екрана';
$string['gpl'] = 'General Public License v3';
$string['gradeheading'] = 'Резултати за {$a}';
$string['gradetopassmustbeset'] = 'Оцена за пролаз не може бити нула јер ова H5P активност има као услов за завршетак прелазну оцену. Подесите вредност различиту од нуле.';
$string['gradetopassnotset'] = 'Ова H5P активност још увек нема подешену оцену за пролаз. Она се може подесити у одељку Оцена на страници за подешавања активности H5P.';
$string['h5pfile'] = 'H5P датотека';
$string['h5ptitle'] = 'Посетите H5P.org како бисте пронашли више интересантних садржаја.';
$string['helpchoosinglicense'] = 'Помозите ми да изаберем лиценцу';
$string['hide'] = 'Сакриј';
$string['hideadvanced'] = 'Сакриј напредна подешавања';
$string['hubcommunicationdisabled'] = 'Комуникација са H5P чвориштем је онемогућена јер је један или више H5P услова није испуњен.';
$string['hubisdisabled'] = 'Чвориште је онемогућено. Можете га поново омогућити у H5P подешавањима.';
$string['hubisdisableduploadlibraries'] = 'H5P OER HUB чвориште је онемогућено док се овај проблем не реши. И даље можете поставити библиотеке преко странице "H5P Библиотеке".';
$string['hubsettingsheader'] = 'Типови интерактивних садржаја';
$string['hvp:addinstance'] = 'Креирање нових H5P активности';
$string['hvp:contenthubregistration'] = 'Регистрација сајта на H5P OER HUB-у';
$string['hvp:emailconfirmsubmission'] = 'Добијање е-поруке са потврдом да је предат покушај решавања H5P активности';
$string['hvp:emailnotifysubmission'] = 'Добијање е-поруке са обавештењем да је предат покушај решавања H5P активности';
$string['hvp:getcachedassets'] = 'Потребно за преглед активности H5P активности';
$string['hvp:getembedcode'] = 'Приказ H5P кôда за уграђивање када је подешена опција \'контролисано путем овлашћења\'';
$string['hvp:getexport'] = 'Преузимање h5p датотеке када је подешена опција \'контролисано путем овлашћења\'';
$string['hvp:installrecommendedh5plibraries'] = 'Инсталирање нових безбедних типова H5P интерактивног садржаја које препоручује H5P.org';
$string['hvp:manage'] = 'Уређивање постојећих H5P активности';
$string['hvp:restrictlibraries'] = 'Ограничавање приступа одређеним типовима H5P интерактивног садржаја';
$string['hvp:savecontentuserdata'] = 'Чување података о напредовању корисника за H5P активности';
$string['hvp:saveresults'] = 'Чување резултата из завршених H5P активности';
$string['hvp:share'] = 'Дељење садржаја на H5P OER HUB-у';
$string['hvp:updatelibraries'] = 'Инсталирање нових H5P типова интерактивног садржаја или ажурирање постојећих';
$string['hvp:userestrictedlibraries'] = 'Коришћење ограничених типова H5P интерактивног садржаја';
$string['hvp:view'] = 'Преглед и интеракција са H5P активностима';
$string['hvp:viewallresults'] = 'Приказ свих резултата за завршених H5P активности';
$string['hvp:viewresults'] = 'Приказ сопствених резултата за завршене H5P активности';
$string['icon'] = 'Иконица';
$string['icondescription'] = '640x480 пиксела. Ако није изабранo, садржај ће користити иконицу категорије';
$string['in'] = 'у';
$string['installdenied'] = 'Немате дозволу да инсталирате типове интерактивног садржаја. Обратите се администратору свог сајта.';
$string['installedlibraries'] = 'Инсталиране библиотеке';
$string['intro'] = 'Увод';
$string['invalidage'] = 'Неисправан формат уноса за типичан узраст. Могући формати уноса одвојени зарезима: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Неисправан формат аудио датотеке. Користите mp3 или wav.';
$string['invalidcontentfolder'] = 'Неисправан директоријум интерактивног садржаја';
$string['invalidcontenttype'] = 'Изабрани тип интерактивног садржаја није исправан.';
$string['invalidfieldtype'] = 'Неисправан тип датотеке';
$string['invalidfile'] = 'Датотеке "{$a->%filename}" није дозвољена. Дозвољене су само датотеке са следећим екстензијама: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Није могуће послати H5P.';
$string['invalidhvp'] = 'Неисправна H5P активност';
$string['invalidimageformat'] = 'Неисправан формат графичке датотеке. Користите jpg, png или gif.';
$string['invalidlanguagefile'] = 'Неисправна језичка датотека {$a->%file} у библиотеци {$a->%library}';
$string['invalidlanguagefile2'] = 'Неисправна језичка датотека {$a->%languageFile} је укључена у библиотеку {$a->%name}';
$string['invalidlibrary'] = 'Неисправна библиотека';
$string['invalidlibrarydata'] = 'Добијени неисправни подаци за {$a->%property} у {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Добијени неисправни подаци за {$a->%property} у {$a->%library}. Очекивани су Булови логички оператори.';
$string['invalidlibraryname'] = 'Неисправан назив библиотеке: {$a->%name}';
$string['invalidlibrarynamed'] = 'Библиотека H5P {$a->%library} која се користи у интерактивном садржају није исправна';
$string['invalidlibraryoption'] = 'Недопуштена опција {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Није могуће очитати својство {$a->%property} у {$a->%library}';
$string['invalidmainjson'] = 'Недостаје исправна главна h5p.json датотека';
$string['invalidmultiselectoption'] = 'Неисправно изабрана опција при избору више опција';
$string['invalidparameters'] = 'Неисправни параметри';
$string['invalidselectoption'] = 'Неисправно изабрана опција при избору опције';
$string['invalidsemanticsjson'] = 'Неисправна датотека semantics.json је укључена у датотеку {$a->%name}';
$string['invalidsemanticstype'] = 'H5P интерна грешка: непознати тип интерактивног садржаја "{$a->@type}" у семантици. Садржај се уклања!';
$string['invalidstring'] = 'Добијени стринг није исправан према правилима коришћења регуларних израза (regexp) у семантици (value: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'H5P је добио неисправан токен. Освежите страницу и покушајте поново';
$string['invalidvideoformat'] = 'Неисправан формат видео датотеке. Користите mp4 или webm.';
$string['invalidxapiresult'] = 'Нису пронађени xAPI резултати за дату комбинацију интерактивног садржаја и ID ознаке корисника';
$string['isnowsubmitted'] = 'Сада се доставља H5P OER HUB-у';
$string['javascriptloading'] = 'Сачекајте да се покрене JavaScript...';
$string['keywordexists'] = 'Кључна реч већ постоји!';
$string['keywords'] = 'Кључне речи';
$string['keywordsdescription'] = 'Можете додати већи број кључних речи одвојених зарезима. Притисните тастер "Enter" или дугме "Додај" како бисте потврдили кључне речи';
$string['keywordsexists'] = 'Кључне речи већ постоје!';
$string['keywordsplaceholder'] = 'Додај кључне речи';
$string['language'] = 'Језик';
$string['level'] = 'Ниво';
$string['libraries'] = 'H5P библиотеке';
$string['librarydirectoryerror'] = 'Назив директоријума библиотеке мора да се поклапа са machineName или machineName-majorVersion.minorVersion (из датотеке library.json). (Директоријум: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Акције';
$string['librarylistinstancedependencies'] = 'Зависности инстанце';
$string['librarylistinstances'] = 'Инстанце';
$string['librarylistlibrarydependencies'] = 'Зависности библиотеке';
$string['librarylistrestricted'] = 'Ограничено';
$string['librarylisttitle'] = 'Наслов';
$string['librarynotselected'] = 'Морате да изаберете тип интерактивног садржаја.';
$string['license'] = 'Лиценца';
$string['licenseCC010'] = 'CC0 1.0 Универзална лиценца (CC0 1.0) Посвећеност јавном власништву';
$string['licenseCC010U'] = 'CC0 1.0 Универзална лиценца';
$string['licenseCC10'] = '1.0 Нелокализована лиценца';
$string['licenseCC20'] = '2.0 Нелокализована лиценца';
$string['licenseCC25'] = '2.5 Нелокализована лиценца';
$string['licenseCC30'] = '3.0 Нелокализована лиценца';
$string['licenseCC40'] = '4.0 Међународна лиценца';
$string['licenseGPL'] = 'Општа јавна лиценца';
$string['licenseV1'] = 'Верзија 1';
$string['licenseV2'] = 'Верзија 2';
$string['licenseV3'] = 'Верзија 3';
$string['licensedescription'] = 'Изаберите лиценцу за свој садржај';
$string['licensedetails'] = 'Детаљне информације о лиценци';
$string['licensedialogdescription'] = 'Кликните на одређену лиценцу како бисте добили информације о правилном коришћењу';
$string['licensee'] = 'Носилац лиценце';
$string['licenseextras'] = 'Додаци лиценце';
$string['licenseversion'] = 'Верзија лиценце';
$string['licenseversiondescription'] = 'Изаберите верзију лиценце';
$string['loadingdata'] = 'Учитавање података';
$string['logouploadtext'] = 'Лого или аватар организације';
$string['longdescription'] = 'Дужи опис';
$string['longdescriptionplaceholder'] = 'Дужи опис вашег садржаја';
$string['lookforupdates'] = 'Потражите нове верзије H5P-а';
$string['maintitle'] = 'Дељење <strong>:title</strong>';
$string['maximumgrade'] = 'Максимална оцена';
$string['maximumgradeerror'] = 'Унесите исправан позитивни цео број као максималан број поена који се може освојити за ову активност';
$string['maxlength'] = ':length представља максималан број знакова';
$string['maxpostsizetoosmall'] = 'Вредност вашег PHP подешавање за максималну величину поста (post_max_size) је премала. Са тренутним подешавањима, нећете моћи да поставите датотке које су веће од {$a->%number} MB. То може бити проблем када покушавате да поставите H5P активности, слике и видео записе. Повећајте ово подешавање на вредност већу од 5 MB.';
$string['maxscore'] = 'Максималан резултат';
$string['maxuploadsizetoosmall'] = 'Вредност вашег PHP подешавање за максималну величину датотеке за постављање (upload_max_filesize) је премала. Са тренутним подешавањима, нећете моћи да поставите датотке које су веће од {$a->%number} MB. То може бити проблем када покушавате да поставите H5P активности, слике и видео записе. Повећајте ово подешавање на вредност већу од 5 MB.';
$string['messageprovider:confirmation'] = 'Потврда о вашим предатим покушајима за H5P активност';
$string['messageprovider:submission'] = 'Обавештење о предатим покушајима за H5P активност';
$string['missingcontentfolder'] = 'Недостаје исправан директоријум интерактивног садржаја';
$string['missingcontentuserdata'] = 'Грешка: није могуће пронаћи корисничке податке за интерактивни садржај';
$string['missingcoreversion'] = 'Систем није могао да инсталира <em>{$a->%component}</em> компоненту из пакета; систем захтева новију верзију H5P додатка. Овај сајт тренутно користи верзију {$a->%current}, док је верзија која се захтева {$a->%required} или новија. Инсталирајте нову верзију додатка, а затим покушајте поново.';
$string['missingdependency'] = 'Недостаје зависност {$a->@dep} коју захтева {$a->@lib}.';
$string['missinglibrary'] = 'Недостаје неопходна библиотека {$a->@library}';
$string['missinglibraryfile'] = 'Датотека "{$a->%file}" недостаје у библиотеци: "{$a->%name}"';
$string['missinglibraryjson'] = 'Није могуће пронаћи library.json датотеку са исправном библиотеком {$a->%name}';
$string['missinglibraryproperty'] = 'Неопходно својство {$a->%property} недостаје у {$a->%library}';
$string['missingmbstring'] = 'PHP екстензија mbstring није учитана. H5P захтева ову екстензију како би исправно функционисано';
$string['missingparameters'] = 'Недостају параметри';
$string['missinguploadpermissions'] = 'Имајте на уму да у датотеци која је постављена  могу да постоје библиотеке, али вама није дозвољено да поставите нове библиотеке. Контактирајте администратора у вези са овим.';
$string['modulename'] = 'Интерактивни садржај';
$string['modulename_help'] = 'Модул активност H5P омогућава да креирате интерактивне садржаје, као што су интерактивни видео клипови, скупови питања, питања ”превуци и спусти”, питања вишеструког избора, презентације и још много тога.

Поред тога што представља ауторски алат за креирање богатог мултимедијалног садржаја, H5P вам пружа могућност да увезете и извезете H5P датотеке, како бисте их ефикасно поново користили и делили садржаје са другима.

Интеракције и њихови резултати се прате помоћу xAPI спецификације и доступни су у књизи оцена вашег Moodlea. Имајте на уму, да корисници са прогамерским вештинама могу да варају у H5P интеракцијама и да остваре максималан резултат а да притом не знају тачне одговоре. Због тога H5P не треба користити за проверу знања, поготово не сумативну.

Интерактивни H5P садржај додајете тако што креирате нови садржај користећи уграђени алат за креирање или тако што на сервер постављате H5P датотеке које сте пронашли на другим H5P сајтовима.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Интерактивни садржај';
$string['next'] = 'Следеће';
$string['nextpage'] = 'Следећа страница';
$string['noanswersubmitted'] = 'Овај корисник још није послао одговор на H5P';
$string['nocontent'] = 'Није могуће пронаћи или парсирати content.json датотеку';
$string['nocontenttype'] = 'Није наведен тип интерактивног садржаја.';
$string['nocopyright'] = 'Нема информација о ауторским правима за овај интерактивни садржај';
$string['nodata'] = 'Не постоје доступни подаци који одговарају вашим критеријумима.';
$string['noexport'] = 'Недостаје датотека за извоз.';
$string['noextension'] = 'Датотека коју сте поставили није исправан HTML5 пакет (нема екстензију датотеке .h5p).';
$string['noh5ps'] = 'Не постоји интерактивни садржај доступан за овај курс.';
$string['nohubregistration'] = 'Није регистровано на H5P OER HUB-у';
$string['nojson'] = 'Главна h5p.json датотека није исправна';
$string['nombstringexteension'] = 'PHP екстензија mbstring није учитана. H5P-у је ова екстензија потребно како би исправно функционисао';
$string['noparameters'] = 'Нема параметара';
$string['noparse'] = 'Није могуће парсирати главна h5p.json датотеку';
$string['nopermissiontogettranslations'] = 'Немате овлашћења за преузимање превода';
$string['nopermissiontorestrict'] = 'Немате овлашћења да ограничите библиотеке.';
$string['nopermissiontosavecontentuserdata'] = 'Немате овлашћења да сачувате корисничке податке за интерактивни садржај.';
$string['nopermissiontosaveresult'] = 'Немате овлашћења да сачувате резултате за овај интерактивни садржај.';
$string['nopermissiontoupgrade'] = 'Немате овлашћења да надоградите библиотеке.';
$string['nopermissiontouploadcontent'] = 'Немате овлашћења да поставите интерактивни садржај овде.';
$string['nopermissiontouploadfiles'] = 'Немате овлашћења да поставите датотеке овде.';
$string['nopermissiontoviewcontenthubcache'] = 'Немате овлашћења да видите метаподатке за чвориште садржаја.';
$string['nopermissiontoviewcontenttypes'] = 'Немате овлашћења да видите типове интерактивних садржаја.';
$string['nopermissiontoviewresult'] = 'Немате овлашћења да видите резултате за овај интерактивни садржај.';
$string['nosuchlibrary'] = 'Не постоји таква библиотека';
$string['notapplicable'] = 'N/A - није примењиво';
$string['nounzip'] = 'Датотека коју сте поставили није исправан HTML5 пакет (није могуће распаковати га).';
$string['noversionattribution'] = 'Ауторство';
$string['noversionattributionnc'] = 'Ауторство - Некомерцијална лиценца';
$string['noversionattributionncnd'] = 'Ауторство - Некомерцијална лиценца - Без прерада';
$string['noversionattributionncsa'] = 'Ауторство - Некомерцијална лиценца - Делити под истим условима';
$string['noversionattributionnd'] = 'Ауторство - Лиценца - Без прерада';
$string['noversionattributionsa'] = 'Ауторство - Лиценца - Делити под истим условима';
$string['nowriteaccess'] = 'Откривен је проблем са приступом за уписивање на серверу. Проверите да ли ваш сервер може да уписује у ваш директоријум са подацима.';
$string['noziparchive'] = 'Ваша PHP верзија не подржава ZipArchive.';
$string['offlinedialogbody'] = 'Нисмо били у могућности да пошаљемо информације о вашем завршетку овог задатка. Проверите своју интернет везу.';
$string['offlinedialogheader'] = 'Ваша веза са сервером је изгубљена';
$string['offlinedialogretrybuttonlabel'] = 'Покушајте поново';
$string['offlinedialogretrymessage'] = 'Поновни покушај за  :num....';
$string['offlinesuccessfulsubmit'] = 'Резултати су успешно послати.';
$string['oldphpversion'] = 'Ваша PHP верзија је застарела. H5P захтева верзију 5.2. како би исправно функционисано. Препоручује се верзија 5.6 или новија.';
$string['olduploadoldcontent'] = 'Покушавате да поставите старију верзију H5P садржаја. Надоградите интерактивни садржај на серверу на којем се налази и покушајте поново да га поставите или укључите H5P OER HUB како би сервер аутоматски надоградио интерактивни садржај.';
$string['onlyupdate'] = 'Ажурирај само постојеће библиотеке';
$string['optionalinfo'] = 'Опционе информације';
$string['options'] = 'Опције';
$string['originator'] = 'Креатор';
$string['pd'] = 'Јавно власништво';
$string['pddl'] = 'Посвећеност јавном власништву и лиценца';
$string['pdm'] = 'Ознака јавног власништва';
$string['phone'] = 'Телефон';
$string['pleasewait'] = 'Молимо, сачекајте...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'За приступ датој крајњој тачки потребна је порука';
$string['previouspage'] = 'Претходна страница';
$string['privacy:metadata:core_files'] = 'H5P активност чува датотеке које су постављене као део H5P садржаја.';
$string['privacy:metadata:core_grades'] = 'H5P активност чува оцене корисника који су одговорили на H5P садржај.';
$string['privacy:metadata:hvp_content_user_data'] = 'Описује тренутно стање у којем се налази интерактивни садржај за корисника. Користи се за враћање интерактивног садржаја у претходно стање.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Кориснички подаци који се чувају.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Идентификатор типа података.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Ознака (заставица) која обележава да ли податке треба обрисати када се интерактивни садржај промени.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID ознака H5P садржаја којем подаци припадају.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID ознака везе између интерактивног садржаја и корисничких података.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Ознака (заставица) која обележава да ли податке треба унапред учитати у интерактивни садржај.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Подсадржај H5P, 0 ако ово није подсадржај.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID ознака корисника којем подаци припадају.';
$string['privacy:metadata:hvp_events'] = 'Праћење записа';
$string['privacy:metadata:hvp_events:content_id'] = 'ID ознака интерактивног садржаја на којем је извршена акција. 0 ако је реч о новом интерактивном садржају или ако нема садржаја.';
$string['privacy:metadata:hvp_events:content_title'] = 'Наслов интерактивног садржаја';
$string['privacy:metadata:hvp_events:created_at'] = 'Време када је догађај креиран.';
$string['privacy:metadata:hvp_events:id'] = 'Јединствени ID ознака догађаја.';
$string['privacy:metadata:hvp_events:library_name'] = 'Библиотека на коју догађај утиче.';
$string['privacy:metadata:hvp_events:library_version'] = 'Верзија библиотека на коју догађај утиче.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Подврста догађаја, акције или догађаја.';
$string['privacy:metadata:hvp_events:type'] = 'Врста догађаја';
$string['privacy:metadata:hvp_events:user_id'] = 'ID ознака корисника који је извео акцију.';
$string['privacy:metadata:hvp_xapi_results'] = 'Чува xAPI догађаје у H5P садржају.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Додатне информације које H5P може да пошаље.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID ознака интерактивног садржаја на којем је догађај изведен.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Шаблон тачног одговора';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Опис, задатак или питање интерактивног садржаја на којем је изведена акција.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Јединствена ID ознака xAPI догађаја.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Тип интеракције.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Максимална резултат који се може постићи за овај догађај.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID ознака матичног садржаја којем припада интерактивни садржај на којем је овај догађај изведен. Нула ако матични садржај не постоји.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Постигнут резултат за догађај.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Одговор који је корисник послао.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID ознака корисника који је извео акцију.';
$string['publisherdescription'] = 'Опис издавача';
$string['publisherdescriptiontext'] = 'Ово ће бити приказано у одељку "Информације о издавачу" на дељеном садржају';
$string['publisherfielddescription'] = 'Ово ће бити приказано као "Назив издавача" на дељеном садржају';
$string['publisherfieldtitle'] = 'Издавач';
$string['question'] = 'Питање';
$string['registeronhub'] = 'Региструјте се на H5P OER HUB-у';
$string['registrationfailed'] = 'Дошло је до грешке';
$string['registrationfaileddescription'] = 'Нисмо били у могућности да отворимо налог у овом тренутку. Нешто није у реду. Покушајте поново касније.';
$string['registrationtitle'] = 'H5P OER HUB Регистрација';
$string['remove'] = 'Уклони';
$string['removechip'] = 'Уклоните :chip са списка';
$string['removeimage'] = 'Уклони слику';
$string['removeoldlogentries'] = 'Уклоњање старих H5P записа';
$string['removeoldmobileauthentries'] = 'Укланање старих H5P уноса за потврду идентиета путем мобилниих уређаја';
$string['removetmpfiles'] = 'Уклањање старих H5P привремених датотека';
$string['reportingquestionsremaininglabel'] = 'питања која остају да буду оцењена';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Резултат у дневнику оцена:';
$string['reportingscoredelimiter'] = 'од';
$string['reportingscorelabel'] = 'Резултат:';
$string['reportnotsupported'] = 'Није подржан';
$string['reportsubmitgradelabel'] = 'Пошаљи оцену';
$string['requiredinfo'] = 'Потребне информације';
$string['resizescript'] = 'Укључите овај скрипт на свом сајту ако желите динамичку промену величине уграђеног интерактивног садржаја:';
$string['resubmitscores'] = 'Покушај слања сачуваних резултата.';
$string['reuse'] = 'Поновно коришћење';
$string['reusecontent'] = 'Поновна употреба садржаја';
$string['reusedescription'] = 'Поново употребите овај садржај.';
$string['reveal'] = 'Откриј';
$string['reviewandsave'] = 'Прегледајте и сачувајте';
$string['reviewandshare'] = 'Прегледајте и делите';
$string['reviewinfo'] = 'Прегледајте информације';
$string['reviewmessage'] = 'Прегледајте информације у наставку пре него што поделите садржај';
$string['reviseserversetupandretry'] = 'Када ревидирате подешавања вашег сервера, можете поново омогућити комуникацију са H5P чвориштем у H5P подешавањима.';
$string['savechanges'] = 'Сачувај измене';
$string['score'] = 'Резултат';
$string['screenshots'] = 'Снимци екрана';
$string['screenshotsdescription'] = 'Додајте до пет снимака екрана свог садржаја';
$string['search'] = 'Претражи';
$string['searchplaceholder'] = 'Унесите текст за претрагу дисциплина';
$string['sendusagestatistics'] = 'Дајте свој допринос статистици коришћења';
$string['sendusagestatistics_help'] = 'Статистички подаци о коришћењу аутоматски ће бити прослеђени како би помогли програмерима да боље разумеју како се H5P користи и како би се одредиле потенцијалне области побољшања. Прочитајте више о томе који се <a {$a}>подаци прикупљају на h5p.org</a>.';
$string['settings'] = 'H5P подешавања';
$string['share'] = 'Подели';
$string['shared'] = 'Подељено';
$string['sharefailed'] = 'Дељење није успело.';
$string['sharetryagain'] = 'Нешто није у реду, покушајте поново да поделите.';
$string['sharingnote'] = 'Сви детаљи садржаја могу се уређивати након дељења';
$string['shortdescription'] = 'Кратак опис';
$string['shortdescriptionplaceholder'] = 'Кратак опис вашег садржаја';
$string['showadvanced'] = 'Прикажи напредна подешавања';
$string['showless'] = 'Прикажи мање';
$string['showmore'] = 'Прикажи више';
$string['sitecouldnotberegistered'] = 'Сајт није могао бити регистрован на H5P чворишту. Обратите се администратору сајта.';
$string['sitekey'] = 'Кључ сајта';
$string['sitekeydescription'] = 'Кључ сајта је јединствени тајни кључ који служи за идентификацију овог сајта на H5P OER HUB-у.';
$string['sitekeyregistered'] = 'Добили сте јединствени кључ који вас идентификује на H5P OER HUB-у приликом преузимања нових верзија и исправки. Кључ је доступан на страници "H5P OER HUB - Подешавања налога".';
$string['size'] = 'Величина';
$string['somekeywordsexists'] = 'Неке од ових кључних речи већ постоје';
$string['source'] = 'Извор';
$string['sslnotenabled'] = 'Ваш сервер нема укључен SSL. SSL треба да укључити како би се обезбедила безбедна веза са H5P чвориштем.';
$string['startingover'] = 'Започећете из почетка';
$string['subcontentwarning'] = 'Делови садржаја (као што су слике, питања итд.) ће се делити под лиценцом :license осим ако није другачије назначено у алату за креирање садржаја';
$string['sublevel'] = 'Подниво';
$string['submitted'] = 'Предато!';
$string['successfullyregisteredwithhub'] = 'Ваш сајт је успешно регистрован на H5P OER HUB-у.';
$string['successfullyregistred'] = 'Успешно сте регистровали налог на H5P OER HUB-у';
$string['successfullyregistreddescription'] = 'Детаљи вашег налога могу се променити';
$string['successfullyupdated'] = 'Подешавања вашег H5P OER HUB налога успешно су промењена';
$string['thumbnail'] = 'Умањена верзија слика';
$string['title'] = 'Наслов';
$string['unabletocreatedir'] = 'Није могуће креирати директоријум.';
$string['unabletogetfieldtype'] = 'Није могуће преузети тип поља.';
$string['undisclosed'] = 'Неоткривено';
$string['unpackedfilesexceedsmaxsize'] = 'Укупна величина распакованих датотека премашује максималну дозвољену величину. (%used > %max)';
$string['updatedlibraries'] = 'Ажурирано старих H5P библиотека {$a->%old}.';
$string['updatedlibrary'] = 'Ажурирана {$a->%old} H5P библиотека.';
$string['updatelibraries'] = 'Ажурирај све библиотеке';
$string['updateregistrationonhub'] = 'Сачувајте подешавања налога';
$string['upgrade'] = 'Надогради H5P';
$string['upgradebuttonlabel'] = 'Надогради';
$string['upgradedone'] = 'Успешно сте надоградили {$a} инстанцу/е/и садржаја';
$string['upgradeerror'] = 'Дошло је до грешке приликом обраде параметара:';
$string['upgradeerrorcontent'] = 'Није могуће надоградити интерактивни садржај %id:';
$string['upgradeerrordata'] = 'Није могуће учитати податке за библиотеку %lib.';
$string['upgradeerrormissinglibrary'] = 'Недостаје обавезна библиотека %lib.';
$string['upgradeerrornotsupported'] = 'Параметри садрже %used који није подржан.';
$string['upgradeerrorparamsbroken'] = 'Параметри су неисправни.';
$string['upgradeerrorscript'] = 'Није могуће учитати скрипт за надоградњу за %lib.';
$string['upgradeerrortoohighversion'] = 'Параметри садрже %used док су подржани само %supported или новије верзије.';
$string['upgradeheading'] = 'Надогради интерактивни садржај {$a}';
$string['upgradeinprogress'] = 'Надоградња на %ver...';
$string['upgradeinvalidtoken'] = 'Грешка: неисправан безбедносни токен!';
$string['upgradelibrarycontent'] = 'Надогради садржај библиотеке';
$string['upgradelibrarymissing'] = 'Грешка: ваша библиотека недостаје!';
$string['upgrademessage'] = 'Намеравате да надоградите {$a} инстанцу/е/и садржаја. Молимо, изаберите верзију за надоградњу.';
$string['upgradenoavailableupgrades'] = 'Не постоје доступна надоградње за ову библиотеку.';
$string['upgradenothingtodo'] = 'Не постоје инстанце интерактивног садржаја за надоградњу.';
$string['upgradereturn'] = 'Повратак';
$string['upload'] = 'Постави';
$string['uploadlibraries'] = 'Постави библиотеке';
$string['uploadsizelargerthanpostsize'] = 'Вредност вашег PHP подешавање за максималну величину датотеке за постављање  (upload_max_filesize) је мања од вредности подешавање за максималну величину поста (post_max_size). Познато је да ово узрокује проблеме у неким инсталацијама.';
$string['user'] = 'Корисник';
$string['validatingh5pfailed'] = 'Провера исправности h5p пакета није успела.';
$string['validationfailed'] = 'Тражени H5P није био исправан';
$string['viewreportlabel'] = 'Извештај';
$string['welcomecommunity'] = 'Надамо се да ћете уживати у H5P-у и да ћете се придружити  нашој растућој заједници путем наших  <a {$a->forums}>форума</a>.';
$string['welcomecontactus'] = 'Уколико имате било какве повратне информације, не устручавајте се да <a {$a}>нас контактирате</a>. Ми све повратне информације узимамо веома озбиљно и посвећени смо томе да H5P буде бољи сваки дан!';
$string['welcomegettingstarted'] = 'Да бисте започели коришћењем H5P-а и Moodlea погледајте наш <a {$a->moodle_tutorial}>водич</a>. Такође, погледајте, инспирације ради, <a {$a->example_content}>пример интерактивног садржаја</a> на H5P.org.<br>Како бисте лакше користили H5P инсталирани су најпопуларнији типови садржаја!';
$string['welcomeheader'] = 'Добро дошли у H5P свет!';
$string['wrongversion'] = 'Верзија H5P библиотеке {$a->%machineName} коришћена у овом садржају није исправна. Интерактивни садржај садржи {$a->%contentLibrary}, али би требало да буде {$a->%semanticsLibrary}.';
$string['year'] = 'Година';
$string['years'] = 'Година/e';
$string['yearsfrom'] = 'Године (од)';
$string['yearsto'] = 'Године (до)';
$string['zip'] = 'Zip';
