<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'wiki', language 'de', version '4.3'.
 *
 * @package     wiki
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Kommentar hinzufügen';
$string['addedbegins'] = 'Start hinzugefügt';
$string['addedends'] = 'Ende hinzugefügt';
$string['admin'] = 'Administration';
$string['adminmenu'] = 'Admin-Menü';
$string['attachmentattach'] = 'Als Anhang hinzufügen';
$string['attachmentimage'] = 'Als Bild hinzufügen';
$string['attachmentlink'] = 'Als Link hinzufügen';
$string['attachments'] = 'Seitenanhänge';
$string['backcomments'] = 'Zurück zu Kommentaren';
$string['backhistory'] = 'Zurück zum Verlauf';
$string['backoldversion'] = 'Zurück zur vorherigen Version';
$string['backpage'] = 'Zurück zur Seite';
$string['backtomapmenu'] = 'Zurück zur Übersicht';
$string['cannotcomparenewerversion'] = 'Eine Seitenversion kann nur mit einer älteren Seitenversion verglichen werden.';
$string['cannoteditpage'] = 'Sie können diese Seite nicht bearbeiten.';
$string['cannotmanagefiles'] = 'Sie dürfen keine Dateien im Wiki verwalten.';
$string['cannotviewfiles'] = 'Sie dürfen keine Dateien im Wiki sehen.';
$string['cannotviewpage'] = 'Sie können diese Seite nicht anzeigen.';
$string['changerate'] = 'Wollen Sie Änderungen vornehmen?';
$string['comments'] = 'Kommentare';
$string['commentscount'] = 'Kommentare ({$a})';
$string['comparesel'] = 'Ausgewählte Versionen vergleichen';
$string['comparewith'] = 'Version {$a->old} mit Version {$a->new} vergleichen';
$string['contributions'] = 'Mitwirkung';
$string['contributions_help'] = 'Liste der von Ihnen bearbeiteten Seiten';
$string['createcomment'] = 'Kommentar erstellen';
$string['createddate'] = 'Erstellt: {$a->date} von {$a->username}';
$string['createpage'] = 'Seite erstellen';
$string['creating'] = 'Wikiseite wird erstellt';
$string['creole'] = 'Creole';
$string['defaultformat'] = 'Standardformat';
$string['defaultformat_help'] = 'Diese Option legt das Bearbeitungsformat von Wikiseiten fest.

* HTML - Der Texteditor ist verfügbar
* Creole - Markup-Editor für Wikis mit Werkzeugleiste
* NWiki - MediaWiki-ähnlicher Markup-Editor';
$string['deleteallpages'] = 'Alle Wiki-Seiten löschen';
$string['deletecomment'] = 'Kommentar wird gelöscht';
$string['deletecommentcheck'] = 'Kommentar löschen';
$string['deletecommentcheckfull'] = 'Möchten Sie den Kommentar wirklich löschen?';
$string['deletedbegins'] = 'Start gelöscht';
$string['deletedends'] = 'Ende gelöscht';
$string['deleteupload'] = 'Löschen';
$string['deleteversions'] = 'Versionen löschen';
$string['diff'] = 'Unterschiede';
$string['diff_help'] = 'Ausgewählte Versionen der Seite können verglichen werden, um die Unterschiede zu finden.';
$string['edit'] = 'Bearbeiten';
$string['editblocks'] = 'Blockbearbeitung einschalten';
$string['editcomment'] = 'Kommentar bearbeiten';
$string['editfiles'] = 'Wikidateien bearbeiten';
$string['editing'] = 'Wikiseite wird bearbeitet';
$string['editingcomment'] = 'Kommentar wird bearbeitet';
$string['editingpage'] = 'Die Seite \'{$a}\' wird bearbeitet';
$string['editsection'] = 'Bearbeiten';
$string['eventdiffviewed'] = 'Wikiänderungen angezeigt';
$string['eventhistoryviewed'] = 'Wikiverlauf angezeigt';
$string['eventmapviewed'] = 'Wikistruktur angezeigt';
$string['eventpagecreated'] = 'Wikiseite angelegt';
$string['eventpagedeleted'] = 'Wikiseite gelöscht';
$string['eventpagelocksdeleted'] = 'Wikiseitensperre aufgehoben';
$string['eventpageupdated'] = 'Wikiseite geändert';
$string['eventpageversiondeleted'] = 'Wikiseitenversion gelöscht';
$string['eventpageviewed'] = 'Wikiseite angezeigt';
$string['eventversionrestored'] = 'Wikiseitenversion wiederhergestellt';
$string['eventversionviewed'] = 'Wikiseitenversion angezeigt';
$string['filenotuploadederror'] = 'Datei \'{$a}\' konnte nicht hochgeladen werden';
$string['files'] = 'Dateien';
$string['filtername'] = 'Autoverlinkung im Wiki';
$string['firstpagetitle'] = 'Name der Startseite';
$string['firstpagetitle_help'] = 'Der Name der Startseite im Wiki kann nicht geändert werden, sobald das Wiki angelegt wurde.';
$string['forceformat'] = 'Format vorgeben';
$string['forceformat_help'] = 'Wenn das Format vorgegeben ist, kann bei der Erstellung einer neuen Wikiseite kein anderes Format eingestellt werden.';
$string['format'] = 'Format';
$string['format_help'] = '* HTML - Der Texteditor ist verfügbar
* Creole - Markup-Editor für Wikis mit Werkzeugleiste
* NWiki - MediaWiki-ähnlicher Markup-Editor';
$string['formatcreole'] = 'Creole-Format';
$string['formatcreole_help'] = 'Creole ist eine Markup-Sprache für Wikis mit einer Werkzeugleiste zum Einfügen der entsprechenden Formatierungszeichen.

Um eine neue Seite zu erstellen, geben Sie den neuen Seitennamen in doppelte Eckige Klammern ein, z.B. [[Neue Seite]].';
$string['formatcreole_link'] = 'mod/wiki/creole';
$string['formathtml'] = 'HTML-Format';
$string['formathtml_help'] = 'Der HTML-Editor kann benutzt werden, um Texte im Wiki zu formatieren.

Um eine neue Seite zu anzulegen, geben Sie den Namen der neuen Seite in doppelte eckige Klammern ein, z.B. [[Neue Seite]].';
$string['formatnwiki'] = 'NWiki-Format';
$string['formatnwiki_help'] = 'NWiki ist eine dem MediaWiki ähnliche Markup-Sprache, um Texte im Wiki zu formatieren.

Um eine neue Seite zu anzulegen, geben Sie den Namen der neuen Seite in doppelte eckige Klammern ein, z.B. [[Neue Seite]].';
$string['formatnwiki_link'] = 'mod/wiki/nwiki';
$string['history'] = 'Verlauf';
$string['history_help'] = 'Der Link \'Verlauf\' führt zu älteren Versionen der Seite';
$string['html'] = 'HTML';
$string['incorrectdeleteversions'] = 'Zu löschende Versionen sind falsch.';
$string['incorrectpageid'] = 'Die Seiten-ID ist falsch.';
$string['incorrectsubwikiid'] = 'Die Subwiki-ID ist falsch.';
$string['incorrectwikiid'] = 'Die Wiki-ID ist falsch.';
$string['indicator:cognitivedepth'] = 'Wiki kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Wiki-Aktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Wiki kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Wiki-Aktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Wiki sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Wiki-Aktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Wiki sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Wiki-Aktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein, Teilnahme mit anderen).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['individualpagedoesnotexist'] = 'Wikiseite existiert nicht';
$string['insertcomment'] = 'Kommentar einfügen';
$string['insertimage'] = 'Bild einfügen...';
$string['insertimage_help'] = 'Diese Dropdown-Liste fügt ein Bild in den Wikieditor ein. Falls Sie weitere Bilder im Wiki hinzufügen möchten, nutzen Sie bitte "Dateien"';
$string['invalidlock'] = 'Diese Seite ist bereits von jemand anderem gesperrt.';
$string['invalidparameters'] = 'Ungültige Parameter';
$string['invalidsection'] = 'Ungültiger Abschnitt';
$string['invalidsesskey'] = 'Offenbar ist Ihre Session abgelaufen. Bitte notieren Sie Ihren Bearbeitungsstand und loggen Sie sich erneut ein.';
$string['javascriptdisabledlocks'] = 'JavaScript ist in Ihrem Browser deaktiviert, so dass die Datensperre nicht funktioniert. Ihre  Änderungen könnten eventuell verloren gehen.';
$string['links'] = 'Links';
$string['listall'] = 'Alle Seiten auflisten';
$string['listorphan'] = 'Verwaiste Seiten auflisten';
$string['lockingajaxtimeout'] = 'Timeout für Sperre bearbeiten';
$string['lockingtimeout'] = 'Timeout für Sperre';
$string['map'] = 'Spezialseiten';
$string['mapmenu'] = 'Spezialmenü';
$string['migrationfinished'] = 'Die Migration wurde erfolgreich abgeschlossen';
$string['migrationfinishednowikis'] = 'Migration abgeschlossen - es wurden keine Wikis migriert';
$string['missingpages'] = 'Seiten ohne Inhalt';
$string['modified'] = 'Geändert';
$string['modulename'] = 'Wiki';
$string['modulename_help'] = 'Ein Wiki ist eine Sammlung von untereinander verlinkten Seiten. In einem gemeinsamen Wiki darf jeder alle Seiten ansehen und bearbeiten. Bei einem persönlichen Wiki hat jeder seine eigenen Seiten, die nur er sehen und bearbeiten kann.

Im Verlauf werden alle Versionen eines Wikis gespeichert. Es ist nachvollziehbar, wer wann was im Wiki geändert hat. Frühere Versionen einer Seite können wiederhergestellt werden.

Eine Wiki-Aktivität kann verwendet werden

* Für Gruppenvorlesungsnotizen oder Studienführer
* Für Mitglieder einer Fakultät, um gemeinsam einen Arbeitsplan oder eine Tagesordnung für ein Treffen zu planen
* Um Teilnehmer/innen gemeinsam ein Online-Buch verfassen und Inhalte zu einem von ihrem Tutor festgelegten Thema erstellen lassen
* Für das gemeinsame Erzählen von Geschichten oder das Verfassen von Gedichten, wobei jede/r Teilnehmer/in eine Zeile oder einen Vers schreibt
* Als persönliches Tagebuch für Prüfungsnotizen oder für das Überarbeiten (unter Verwendung eines individuellen Wikis)';
$string['modulename_link'] = 'mod/wiki/view';
$string['modulenameplural'] = 'Wikis';
$string['navigation'] = 'Navigation';
$string['navigationfrom'] = 'Diese Seite kommt von';
$string['navigationfrom_help'] = 'Zu dieser Seite verlinkte Wikiseiten';
$string['navigationto'] = 'Diese Seite führt zu';
$string['navigationto_help'] = 'Links zu anderen Websites';
$string['newpage'] = 'Neu';
$string['newpagehdr'] = 'Neue Seite';
$string['newpagetitle'] = 'Titel für neue Seite
';
$string['noattachments'] = '<strong>Keine verbundenen Dateien</strong>';
$string['nocomments'] = 'Keine Kommentare';
$string['nocontent'] = 'Kein Inhalt auf dieser Seite';
$string['nocontribs'] = 'Sie haben keine Beiträge in diesem Wiki
';
$string['nocreatepermission'] = 'Keine Recht zum Anlegen neuer Seiten';
$string['noeditcommentpermission'] = 'Keine Recht zum Bearbeiten von Kommentaren';
$string['noeditpermission'] = 'Keine Recht zum Bearbeiten von Seiten';
$string['nofrompages'] = 'Zu dieser Seite existieren keine Links';
$string['nohistory'] = 'Für diese Seite existiert kein Verlauf';
$string['nomanagecommentpermission'] = 'Keine Recht zum Verwalten von Kommentaren';
$string['nomanagewikipermission'] = 'Keine Recht zum Verwalten des Wikis';
$string['noorphanedpages'] = 'Keine verwaiste Seiten';
$string['nooverridelockpermission'] = 'Keine Recht zum Ändern der Sperre';
$string['norated'] = 'Diese Seite wurde noch nicht bewertet. Geben Sie die erste Bewertung ab!';
$string['norating'] = 'Keine Bewertung';
$string['nosearchresults'] = 'Keine Ergebnisse';
$string['noteditblocks'] = 'Blockbearbeitung ausschalten';
$string['notingroup'] = 'Nicht in Gruppen';
$string['notmigrated'] = 'Dieses Wiki wurde bisher nicht migriert. Bitte melden Sie sich bei dem/der Administrator/in.';
$string['notopages'] = 'Keine verlinkten Wikiseiten';
$string['noupdatedpages'] = 'Keine aktualisierten WIkiseiten';
$string['noviewcommentpermission'] = 'Keine Recht zum Anzeigen von Kommentaren';
$string['noviewpagepermission'] = 'Keine Recht zum Anzeigen von Seiten';
$string['nwiki'] = 'NWiki';
$string['oldversion'] = 'Alte Version';
$string['orphaned'] = 'Verwaiste Seiten';
$string['orphaned_help'] = 'Liste von Seiten ohne Verlinkung von anderen Seiten';
$string['overridelocks'] = 'Datensperren ändern';
$string['overridinglocks'] = 'Datensperren werden geändert...';
$string['page-mod-wiki-comments'] = 'Wiki-Kommentarseite';
$string['page-mod-wiki-history'] = 'Wiki-Versionsseite';
$string['page-mod-wiki-map'] = 'Wiki-Spezialseiten';
$string['page-mod-wiki-view'] = 'Wiki-Hauptseite';
$string['page-mod-wiki-x'] = 'Jede Wiki-Seite';
$string['pageexists'] = 'Diese Seite existiert bereits.';
$string['pageindex'] = 'Seitenindex';
$string['pageindex_help'] = 'Struktur dieses Wikis';
$string['pageislocked'] = 'Jemand anderes bearbeitet gerade diese Seite. Versuchen Sie es in ein paar Minuten nochmal.';
$string['pagelist'] = 'Seitenliste';
$string['pagelist_help'] = 'Seitenübersicht in alphabetischer Reihenfolge';
$string['pagename'] = 'Seitenname';
$string['peerreview'] = 'Einstufung durch Peers';
$string['pluginadministration'] = 'Wiki-Administration';
$string['pluginname'] = 'Wiki';
$string['prettyprint'] = 'Druckversion';
$string['previewwarning'] = 'Dies ist eine Seitenvorschau - Ihre Änderungen wurden bisher noch nicht gespeichert';
$string['print'] = 'Drucken';
$string['privacy:metadata:core_comment'] = 'Kommentare auf Wiki-Seiten';
$string['privacy:metadata:core_files'] = 'Angehängte Dateien in Unter-Wikis';
$string['privacy:metadata:core_tag'] = 'Tags in Wiki-Seiten';
$string['privacy:metadata:wiki_locks'] = 'Temporäre Sperrung von Wiki-Seiten';
$string['privacy:metadata:wiki_locks:lockedat'] = 'Daten der Sperrung';
$string['privacy:metadata:wiki_locks:sectionname'] = 'Name des gesperrten Seitenabschnitts';
$string['privacy:metadata:wiki_locks:userid'] = 'Nutzer, der Seite gesperrt hat';
$string['privacy:metadata:wiki_pages'] = 'Information über Wikiseite';
$string['privacy:metadata:wiki_pages:cachedcontent'] = 'Gecachter Inhalt im HTML-Format';
$string['privacy:metadata:wiki_pages:pageviews'] = 'Wie oft die Seite betrachtet wurde';
$string['privacy:metadata:wiki_pages:readonly'] = 'Ob die Seite nur gelesen werden darf';
$string['privacy:metadata:wiki_pages:timecreated'] = 'Zeitpunkt der Erstellung der Seite';
$string['privacy:metadata:wiki_pages:timemodified'] = 'Zeitpunkt der letzten Änderung der Seite';
$string['privacy:metadata:wiki_pages:timerendered'] = 'Zeitpunkt an dem die Seite zuletzt gerendert wurde';
$string['privacy:metadata:wiki_pages:title'] = 'Name der Seite';
$string['privacy:metadata:wiki_pages:userid'] = 'Letzter Nutzer der die Seite bearbeitet hat';
$string['privacy:metadata:wiki_subwikis'] = 'Information über Unterwikis (im Falle des Gruppen- oder Einzelmodus)';
$string['privacy:metadata:wiki_subwikis:groupid'] = 'Gruppe, die Subwiki besitzt';
$string['privacy:metadata:wiki_subwikis:userid'] = 'Nutzer, der eigenes Wiki besitzt';
$string['privacy:metadata:wiki_versions'] = 'Informationen zur Geschichte der Wikiseiten';
$string['privacy:metadata:wiki_versions:content'] = 'Inhaltsüberarbeitung';
$string['privacy:metadata:wiki_versions:contentformat'] = 'Überarbeitug des Inhaltsformats';
$string['privacy:metadata:wiki_versions:timecreated'] = 'Zeitpunkt der Überarbeitung';
$string['privacy:metadata:wiki_versions:userid'] = 'Nutzer der Überarbeitung vornahm';
$string['privacy:metadata:wiki_versions:version'] = 'Versionsnummer';
$string['rated'] = 'Ihre Bewertung der Seite: {$a}';
$string['rating'] = 'Bewertung';
$string['ratingmode'] = 'Bewertungsmodus';
$string['removeallwikitags'] = 'Alle Wiki-Tags löschen';
$string['removepages'] = 'Seiten löschen';
$string['reparsetimeout'] = 'Standard-Timeout setzen';
$string['repeatedsection'] = 'Wikifehler: Name \'{$a}\' kann nicht doppelt verwendet werden';
$string['restore'] = 'Wiederherstellen';
$string['restoreconfirm'] = 'Möchten Sie Version #{$a} wirklich wiederherstellen?';
$string['restoreerror'] = 'Die Version #{$a} konnte nicht wiederhergestellt werden';
$string['restorethis'] = 'Diese Version wiederherstellen';
$string['restoreversion'] = 'Alte Version wiederherstellen';
$string['restoring'] = 'Version #{$a} wiederherstellen';
$string['return'] = 'Zurück';
$string['save'] = 'Speichern';
$string['saving'] = 'Wikiseite wird gespeichert';
$string['savingerror'] = 'Fehler beim Speichern';
$string['search:activity'] = 'Wiki - Aktivitätsinfo';
$string['search:collaborative_page'] = 'Wikiseiten - Gemeinsame Seiten';
$string['searchcontent'] = 'Im Seiteninhalt suchen';
$string['searchresult'] = 'Suchergebnisse:';
$string['searchterms'] = 'Suchbegriffe';
$string['searchwikis'] = 'Wiki durchsuchen';
$string['special'] = 'Spezial';
$string['tableofcontents'] = 'Inhaltsübersicht';
$string['tagarea_wiki_pages'] = 'Wikiseiten';
$string['tagsdeleted'] = 'Wiki-Tags wurden gelöscht';
$string['teacherrating'] = 'Trainer/innenbewertung';
$string['timesrating'] = 'Diese Seite wurde {$a->c}-mal bewertet, u.z. mit einem Mittelwert {$a->s}';
$string['updatedpages'] = 'Aktualisierte Seiten';
$string['updatedpages_help'] = 'Kürzlich aktualisierte Wikiseiten';
$string['updatedwikipages'] = 'Aktualisierte Wikiseiten';
$string['upload'] = 'Hochladen & Löschen';
$string['uploadactions'] = 'Aktionen';
$string['uploadfiletitle'] = 'Anhänge';
$string['uploadname'] = 'Dateiname';
$string['uploadtitle'] = 'Dateien anhängen';
$string['version'] = 'Version';
$string['versionerror'] = 'Versions ID existiert nicht';
$string['versionnum'] = 'Version #{$a}';
$string['view'] = 'Anzeigen';
$string['viewallhistory'] = 'Gesamten Verlauf anzeigen';
$string['viewcurrent'] = 'Aktuelle Version';
$string['viewperpage'] = '{$a} Versionen pro Seite anzeigen';
$string['viewversion'] = 'Seitenversion #{$a} anzeigen';
$string['wiki'] = 'Wiki';
$string['wiki:addinstance'] = 'Neues Wiki hinzufügen';
$string['wiki:createpage'] = 'Neue Wikiseiten erstellen';
$string['wiki:editcomment'] = 'Kommentar zu Seiten hinzufügen';
$string['wiki:editpage'] = 'Wikiseiten bearbeiten';
$string['wiki:managecomment'] = 'Kommentare im Wiki verwalten';
$string['wiki:managefiles'] = 'Dateien im Wiki verwalten';
$string['wiki:managewiki'] = 'Einstellungen des Wikis verwalten';
$string['wiki:overridelock'] = 'Seitensperrung übergehen';
$string['wiki:viewcomment'] = 'Seitenkommentare anzeigen';
$string['wiki:viewpage'] = 'Wikiseiten anzeigen';
$string['wikiattachments'] = 'Anhänge im Wiki';
$string['wikiboldtext'] = 'Fett';
$string['wikiexternalurl'] = 'Externe URL';
$string['wikifiles'] = 'Wikidateien';
$string['wikifiletable'] = 'Dateiliste hochladen';
$string['wikiheader'] = 'Überschrift {$a}';
$string['wikihr'] = 'Waagerechte Linie';
$string['wikiimage'] = 'Bild';
$string['wikiinternalurl'] = 'Interner Link';
$string['wikiintro'] = 'Beschreibung';
$string['wikiitalictext'] = 'Kursiv';
$string['wikilockingsettings'] = 'Datensperre aktiviert';
$string['wikimode'] = 'Wikimodus';
$string['wikimode_help'] = 'Der Wikimodus legt fest, wie damit gearbeitet werden kann. <ul>
<li>gemeinsames Wiki - alle benutzen und bearbeiten das Wiki gemeinsam</li>
<li>persönliches Wiki - jede Person hat ihr eigenes Wiki, das sie alleine bearbeitet</li></ul>';
$string['wikimodecollaborative'] = 'Gemeinsames Wiki';
$string['wikimodeindividual'] = 'Persönliches Wiki';
$string['wikiname'] = 'Name des Wikis';
$string['wikinowikitext'] = 'Kein Wikitext';
$string['wikiorderedlist'] = 'Geordnete Liste';
$string['wikipages'] = 'Wikiseiten';
$string['wikisettings'] = 'Einstellungen des Wikis';
$string['wikiunorderedlist'] = 'Ungeordnete Liste';
$string['wrongversionlock'] = 'Eine andere Person hat die Seite aktualisiert, während Sie daran gearbeitet haben. Deswegen ist der von Ihnen verwendete Inhalt veraltet.';
$string['wrongversionsave'] = 'Jemand hat eine neue Version der Seite gespeichert, während Sie daran gearbeitet haben. Sie haben diese neuen Inhalte überschrieben. Bitte prüfen Sie den Seitenverlauf.';
