<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_compilatio', language 'de', version '4.3'.
 *
 * @package     plagiarism_compilatio
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activate_compilatio'] = 'Das Compilatio Plugin aktivieren';
$string['activate_submissiondraft'] = 'Um Teilnehmer/innen die Möglichkeit zu geben, ihre Entwürfe zu analysieren, müssen Sie die Option <b>{$a}</b> im Abschnitt';
$string['admin_disabled_reports'] = 'Der Administrator hat die Anzeige der Ähnlichkeitsberichte für die Teilnehmer/innen deaktiviert.';
$string['admin_goto_helpcenter'] = 'Gehen Sie zum Compilatio Hilfecenter, um die Artikel zur Verwaltung des Moodle-Plugins zu lesen.';
$string['analysis_date'] = 'Analysedatum (nur bei geplanter Analyse)';
$string['analysis_started'] = '{$a} gewünschte Analyse(n).';
$string['analysistype_auto'] = 'Direkt';
$string['analysistype_manual'] = 'Manuell';
$string['analysistype_prog'] = 'Geplante';
$string['api_key_not_tested'] = 'Der API-Key konnte nicht überprüft werden, da die Verbindung zur Dienstleistung von Compilatio.net nicht hergestellt werden konnte.';
$string['api_key_not_valid'] = 'Der gespeicherte API-Key ist gültig. Er ist auf die verwendete Plattform zugeschnitten. Er kann bei <a href=\'mailto:ent@compilatio.net\'>ent@compilatio.net</a> angefordert werden.';
$string['api_key_valid'] = 'Der gespeicherte API-Key ist gültig.';
$string['auto_diagnosis_title'] = 'Selbstdiagnose';
$string['average'] = 'Durchschnitt';
$string['compilatio'] = 'Plugin zur Plagiatserkennung Compilatio';
$string['compilatio:enable'] = 'Den Trainer/innen erlauben, Compilatio innerhalb einer Aufgabe zu aktivieren/deaktivieren';
$string['compilatio:triggeranalysis'] = 'Den Trainer/innen erlauben, die Analyse manuell auszulösen.';
$string['compilatio:viewreport'] = 'Den Trainer/innen erlauben, den vollständigen Bericht auf Compilatio einzusehen.';
$string['compilatio_help_assign'] = 'Hilfe zum Compilatio Plugin anfordern.';
$string['compilatio_iddocument'] = 'Kennung des Dokuments';
$string['compilatio_search'] = 'Suche';
$string['compilatio_search_help'] = 'Sie können Autor/innen eines Dokuments ermitteln, indem Sie die Dokumentenkennung aus den Quellen des Analyseberichts abrufen. Beispiel: 1. Ihr Dokument: <b>1st5xfj2</b> - Zuweisen_Name(30)Name_Kopiertes_Dokument.odt.';
$string['compilatio_search_notfound'] = 'Unter den Dokumenten, die auf Ihrer Moodle-Plattform geladen sind, wurde kein Dokument mit dieser Kennung gefunden.';
$string['compilatio_search_tab'] = 'Autor/in eines Dokuments finden';
$string['compilatiodefaults'] = 'Standartwerte für Compilatio.';
$string['compilatioexplain'] = 'Weitere Informationen zu diesem Plugin finden Sie unter: <a href="http://compilatio.net" target="_blank">compilatio.net</a>';
$string['cron_check'] = 'Der CRON Job wurde zum letzten Mal am {$a} durchgeführt.';
$string['cron_check_never_called'] = 'Es wurde seit der Aktivierung des Plugins kein CRON Job ausgeführt. Er ist möglicherweise falsch konfiguriert.';
$string['cron_check_not_ok'] = 'Er wurde seit über einer Stunde nicht mehr durchgeführt.';
$string['cron_frequency'] = 'Es scheint, dass er jede {$a} Minute durchgeführt wird.';
$string['cron_recommandation'] = 'Wir empfehlen einen kürzeren Abstand als 15 Minuten zwischen jedem CRON Job.';
$string['defaults_desc'] = 'Folgende Parameter werden als Standartwerte für die Aktivitäten von Compilatio innerhalb von Moodle verwendet.';
$string['defaultupdated'] = 'Die Standartwerte wurden aktualisiert';
$string['disable_ssl_verification'] = 'Ignorieren Sie die Überprüfung des SSL-Zertifikats.';
$string['disable_ssl_verification_help'] = 'Aktivieren Sie diese Option, wenn Sie Probleme mit der Überprüfung von SSL-Zertifikaten haben oder wenn beim Senden von Dateien an Compilatio Fehler auftreten.';
$string['disclaimer_data'] = 'Indem Sie Compilatio aktivieren, akzeptieren Sie, dass die Informationen zur Konfiguration Ihrer Moodle Plattform gesammelt werden, um die Unterstützung und Wartung der Dienstleistung zu erleichtern.';
$string['display_notifications'] = 'Benachrichtigungen anzeigen';
$string['display_stats'] = 'Statistiken über diese Aktivität anzeigen';
$string['document_deleting'] = 'Löschen von Dokumenten';
$string['documents_number'] = 'Analysierte Dokumente';
$string['enable_activities_title'] = 'Aktivieren Sie Compilatio für Aktivitäten';
$string['enable_mod_assign'] = 'Aktivieren Sie Compilatio für Zuweisungen';
$string['enable_mod_forum'] = 'Aktivieren Sie Compilatio für Foren';
$string['enable_mod_quiz'] = 'Aktivieren Sie Compilatio für Quiz';
$string['enable_mod_workshop'] = 'Aktivieren Sie Compilatio für Workshops';
$string['enabledandworking'] = 'Das Compilatio Plugin ist aktiv und funktionsfähig.';
$string['errors'] = 'Fehler :';
$string['export_csv'] = 'Daten über diese Aktivität in eine CSV-Datei exportieren';
$string['export_global_csv'] = 'Klicken Sie hier um diese Daten im CSV-Format zu exportieren';
$string['export_raw_csv'] = 'Klicken Sie hier um die Ausgangsdaten im CSV-Format zu exportieren';
$string['extraction_in_progress'] = 'Dokumentenextraktion läuft, bitte versuchen Sie es später noch einmal';
$string['failedanalysis'] = 'Compilatio konnte Ihr Dokument nicht analysieren:';
$string['filename'] = 'Dateiname';
$string['firstname'] = 'Vorname';
$string['get_scores'] = 'Ruft die Ähnlichkeitsquoten auf Compilatio.net ab';
$string['global_statistics'] = 'Gesamtstatistiken';
$string['global_statistics_description'] = 'Alle Daten der Dokumente werden an Compilatio gesendet.';
$string['goto_compilatio_service_status'] = 'Siehe Status der Compilatio-Dienste.';
$string['green_threshold'] = 'Grün bis';
$string['help_compilatio_format_content'] = 'Compilatio.net unterstützt die meisten in der Büroelektronik und im Internet verwendeten Formate. Folgende Formate werden akzeptiert:';
$string['helpcenter'] = 'Rufen Sie das Compilatio Help Center für die Verwendung des Compilatio-Plugins in Moodle auf.';
$string['helpcenter_error'] = 'Wir können Sie nicht automatisch mit dem Hilfecenter verbinden. Bitte versuchen Sie es später noch einmal oder gehen Sie direkt über den folgenden Link dorthin:';
$string['immediately'] = 'Unmittelbar';
$string['indexed_document'] = 'Dokument, das der Dokumentendatenbank Ihrer Institution hinzugefügt wurde. Sein Inhalt kann verwendet werden, um Ähnlichkeiten mit anderen Dokumenten zu erkennen.';
$string['keep_docs_indexed'] = 'Dokumente in der Handbibliothek aufbewahren';
$string['keep_docs_indexed_help'] = 'Wenn Sie einen Kurs löschen, einen Kurs zurücksetzen oder eine Aktivität löschen, können Sie wählen, ob Sie die an Compilatio gesendeten Dokumente endgültig löschen oder in der Referenzbibliothek aufbewahren möchten (nur der Text wird aufbewahrt und dient als Vergleichsmaterial für Ihre nächsten Analysen).';
$string['lastname'] = 'Nachname';
$string['manual_analysis'] = 'Die Analyse dieses Dokuments muss manuell ausgelöst werden';
$string['maximum'] = 'Maximum';
$string['minimum'] = 'Minimum';
$string['no_document_available_for_analysis'] = 'Es steht kein Dokument zur Analyse bereit.';
$string['no_statistics_yet'] = 'Derzeit sind keine Statistiken verfügbar.';
$string['not_analyzed'] = 'Folgende Dokumente konnten nicht analysiert werden:';
$string['not_analyzed_extracting'] = 'Die folgenden Dokumente können nicht analysiert werden, da sie gerade extrahiert werden. Bitte versuchen Sie es später erneut';
$string['not_indexed_document'] = 'Das Dokument wurde nicht in die Dokumentendatenbank Ihrer Institution aufgenommen. Sein Inhalt wird nicht verwendet, um Ähnlichkeiten mit anderen Dokumenten zu erkennen.';
$string['numeric_threshold'] = 'Der Schwellenwert muss eine Zahl sein.';
$string['orange_threshold'] = 'Orange bis';
$string['owner_file'] = 'DSGVO und Eigentum der Arbeit';
$string['owner_file_school'] = 'Die Bildungsinstitution ist Eigentümerin der Arbeiten.';
$string['owner_file_school_details'] = 'Im Falle einer Anfrage zur Löschung von personenbezogenen Daten seitens eines Schülers wird der Inhalt der Arbeit aufbewahrt und steht für zukünftige Vergleiche mit neuen Arbeiten zur Verfügung. Nach Vertragsende mit Compilatio werden innerhalb der vertraglich festgelegten Fristen alle personenbezogenen Daten, die aus Ihrer Bildungsinstitution stammen, gelöscht, darunter auch die Arbeiten.';
$string['owner_file_student'] = 'Der Studierende ist Eigentümer seiner Arbeit';
$string['owner_file_student_details'] = 'Im Falle einer Anfrage zur Löschung von personenbezogenen Daten seitens eines Schülers werden die Arbeiten aus der Moodle Plattform und der Compilatio Referenzbibliothek gelöscht. Die Arbeiten stehen nicht mehr zum Vergleich mit neuen Dokumenten zur Verfügung.';
$string['plugin_disabled'] = 'Das Plugin wurde nicht für die Moodle Plattform aktiviert.';
$string['plugin_disabled_assign'] = 'Das Plugin wurde nicht für die Aufgaben aktiviert.';
$string['plugin_disabled_forum'] = 'Das Plugin wurde nicht für die Foren aktiviert.';
$string['plugin_disabled_quiz'] = 'Das Plugin ist nicht für Quiz aktiviert.';
$string['plugin_disabled_workshop'] = 'Das Plugin wurde nicht für die Workshops aktiviert.';
$string['plugin_enabled'] = 'Das Plugin wurde für die Moodle Plattform aktiviert.';
$string['plugin_enabled_assign'] = 'Das Plugin wurde für die Aufgaben aktiviert.';
$string['plugin_enabled_forum'] = 'Das Plugin wurde für die Foren aktiviert.';
$string['plugin_enabled_quiz'] = 'Das Plugin ist für Quiz aktiviert.';
$string['plugin_enabled_workshop'] = 'Das Plugin wurde für die Workshops aktiviert.';
$string['pluginname'] = 'Compilatio – Plugin zur Plagiatserkennung';
$string['privacy:metadata:core_files'] = 'Eingereichte oder in einem Eingabefeld erstellte Dateien';
$string['privacy:metadata:core_plagiarism'] = 'Dieses Plugin wird vom Plagiatserkennung-Untersystem von Moodle aufgerufen';
$string['privacy:metadata:external_compilatio_document'] = 'Informationen zu den Dokumenten in der Compilatio Datenbank';
$string['privacy:metadata:external_compilatio_document:filename'] = 'Name der Einreichung';
$string['privacy:metadata:plagiarism_compilatio_files'] = 'Informationen zu den bei Compilatio eingereichten Dateien in der Datenbank des Plugins';
$string['privacy:metadata:plagiarism_compilatio_files:filename'] = 'Der Name (eventuell auto-generiert) der Einreichung';
$string['privacy:metadata:plagiarism_compilatio_files:userid'] = 'Nutzer-ID der Person, die die Einreichung vorgenommen hat';
$string['programmed_analysis_future'] = 'Die Dokumente werden am {$a} von Compilatio analysiert.';
$string['programmed_analysis_past'] = 'Die Dokumente wurden Compilatio am {$a} zur Analyse unterbreitet.';
$string['progress'] = 'Progression :';
$string['quiz_help'] = 'Es werden nur Aufsatzfragen ausgewertet, deren Antwort mindestens {$a} Wörter enthält.';
$string['red_threshold'] = 'Rot ab';
$string['redirect_report_failed'] = 'Beim Abrufen des Analyseberichts ist ein Fehler aufgetreten. Bitte versuchen Sie es später noch einmal oder kontaktieren Sie den Support (support@compilatio.net), wenn das Problem weiterhin besteht.';
$string['results'] = 'Resultate :';
$string['saved_config_failed'] = '<strong>Die Kombination von Adresse und API-Key ist nicht korrekt. Das Plugin wurde deaktiviert, bitte versuchen Sie es erneut.<br/>
    Die Seite der<a href="autodiagnosis.php">auto-diagnostic</a> kann Ihnen dabei helfen, dieses Plugin zu konfigurieren.</strong><br/>
    Fehler :';
$string['showwhenclosed'] = 'Datum, an dem die Aktivität abgeschlossen wurde';
$string['similarities'] = 'Ähnlichkeiten';
$string['similarities_disclaimer'] = 'Sie können die Ähnlichkeiten in den Dokumenten dieser Aktivität mit <a href=\'http://www.compilatio.net/en/\' target=\'_blank\'>Compilatio</a> analysieren.<br/> Seien Sie vorsichtig: Ähnlichkeiten, die während der Analyse gemessen werden, bedeuten nicht unbedingt ein Plagiat. Der Analysebericht hilft Ihnen zu erkennen, ob die Ähnlichkeiten auf ein passendes Zitat oder ein Plagiat zurückzuführen sind.';
$string['similarity_percent'] = '% Ähnlichkeiten';
$string['start_analysis_in_progress'] = 'Lancierung der Analysen in Arbeit';
$string['stats_errors'] = 'Fehler';
$string['student_help'] = 'Sie können Ihren Entwurf mit Compilatio Magister analysieren, um Ähnlichkeiten im Text Ihrer Dateien zu messen.<br/>
Der Inhalt Ihres Entwurfs wird von Compilatio nicht als Vergleichsmaterial für zukünftige Analysen verwendet.<br/>
Ihre Trainer/innen werden jedoch Zugang zu diesem Analysebericht haben.';
$string['studentdisclosuredefault'] = 'Alle hier hochgeladenen Dateien werden an den Ähnlichkeitserkennungsdienst Compilatio weitergeleitet.';
$string['students_disclosure'] = 'Präventive Botschaft an die Teilnehmer/innen';
$string['students_disclosure_help'] = 'Dieser Text wird für alle Teilnehmer/innen auf der Download-Seite angezeigt.';
$string['tabs_title_help'] = 'Hilfe';
$string['tabs_title_stats'] = 'Statistiken';
$string['teacher'] = 'Trainer/in';
$string['teacher_features_title'] = 'Aktivierte Funktionen für Lehrer';
$string['thresholds_description'] = 'Geben Sie die Grenzwerte ein, die Sie verwenden möchten, um den Analysebericht (Ähnlichkeitsquote) einfacher zu kennzeichnen:';
$string['thresholds_settings'] = 'Einstellung der Grenzwerte für die Anzeige der Ähnlichkeitsquote:';
$string['timesubmitted'] = 'Compilatio vorgelegt am';
$string['trigger_analyses'] = 'Analysen auslösen';
$string['update_meta'] = 'Führt die von Compilatio.net geplanten Aufgaben aus';
$string['webservice_not_ok'] = 'Der Webservice konnte nicht kontaktiert werden. Ihre Firewall blockiert möglicherweise die Verbindung.';
$string['webservice_ok'] = 'Der Server kann den Webservice kontaktieren.';
