<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'de', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Aktivitäten';
$string['activate'] = 'Zugriff aktivieren';
$string['activatesuccess'] = 'Zugriff auf die Badges wurde erfolgreich aktiviert.';
$string['addalignment'] = 'Externen Skill oder Standard hinzufügen';
$string['addbadge'] = 'Badges hinzufügen';
$string['addbadge_help'] = 'Wählen Sie alle Badges aus, die als Voraussetzung für dieses Badge hinzugefügt werden sollen. (Mehrfachauswahl möglich)';
$string['addbadgecriteria'] = 'Kriterium hinzufügen';
$string['addcohort'] = 'Globale Gruppe hinzufügen';
$string['addcohort_help'] = 'Wählen Sie alle globalen Gruppen aus, die als Voraussetzung für dieses Badge hinzugefügt werden sollen. (Mehrfachauswahl möglich)';
$string['addcompetency'] = 'Kompetenz hinzufügen';
$string['addcompetency_help'] = 'Wählen Sie alle Kompetenzen aus, die als Badge-Anforderungen hinzugefügt werden sollen (Mehrfachauswahl möglich).';
$string['addcourse'] = 'Kurse hinzufügen';
$string['addcourse_help'] = 'Wählen Sie alle Kurse, die als Voraussetzung für dieses Badge hinzugefügt werden sollen. (Mehrfachauswahl möglich)';
$string['addcriteria'] = 'Kriterium hinzufügen';
$string['addcriteriatext'] = 'Um mit einem Kriterium für ein Badge zu beginnen, wählen Sie zuerst eine Option aus dem Auswahlmenü.';
$string['addedtobackpack'] = 'Badge zum Backpack hinzugefügt';
$string['addrelated'] = 'Badges zuweisen';
$string['addtobackpack'] = 'Zum Backpack hinzufügen';
$string['adminonly'] = 'Diese Seite ist nur für Administrator/innen erlaubt!';
$string['after'] = 'nach der Verleihung';
$string['aggregationmethod'] = 'Methode der Zusammenfassung';
$string['alignment'] = 'Ausrichtung';
$string['all'] = 'Alle';
$string['allmethod'] = 'Alle gewählten Bedingungen sind erfüllt';
$string['allmethodactivity'] = 'Alle gewählten Aktivitäten sind abgeschlossen';
$string['allmethodbadges'] = 'Alle gewählten Badges wurden erworben';
$string['allmethodcohort'] = 'Mitglied in allen gewählten globalen Gruppen';
$string['allmethodcompetencies'] = 'Alle ausgewählten Kompetenzen sind abgeschlossen.';
$string['allmethodcourseset'] = 'Alle gewählten Kurse sind abgeschlossen';
$string['allmethodmanual'] = 'Alle ausgewählten Rollen verleihen den Badge';
$string['allmethodprofile'] = 'Alle gewählten Nutzerprofilfelder sind vollständig';
$string['allowcoursebadges'] = 'Kursbezogene Badges erlauben';
$string['allowcoursebadges_desc'] = 'Diese Option erlaubt, kursbezogene Badges zu erstellen und zu verleihen.';
$string['allowexternalbackpack'] = 'Externe Backpack-Verbindung';
$string['allowexternalbackpack_desc'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen eine Verbindung zu einem externen Backpack herstellen und ihre Badges von dieser Website freigeben. Nutzer/innen können außerdem festlegen, dass alle öffentlichen Badge Collections von ihrem externen Backpack auf ihrer Profilseite angezeigt werden.

Es wird empfohlen, diese Option deaktiviert zu lassen, wenn Ihre Website nicht über das Internet erreichbar ist (z.B. ein lokales Moodle).';
$string['any'] = 'Einer von diesen';
$string['anymethod'] = 'Eine der gewählten Bedingungen ist erfüllt';
$string['anymethodactivity'] = 'Eine der gewählten Aktivitäten ist abgeschlossen';
$string['anymethodbadges'] = 'Einer der gewählten Badges wurde erworben';
$string['anymethodcohort'] = 'Mitglied in mindestens einer der gewählten globalen Gruppen';
$string['anymethodcompetencies'] = 'Mindestens eine der ausgewählten Kompetenzen ist abgeschlossen.';
$string['anymethodcourseset'] = 'Einer der gewählten Kurse ist abgeschlossen';
$string['anymethodmanual'] = 'Eine der gewählten Rollen verleiht den Badge';
$string['anymethodprofile'] = 'Eines der gewählten Nutzerprofilfelder ist vollständig';
$string['apiversion'] = 'Unterstützte API-Version';
$string['archivebadge'] = 'Möchten Sie den Badge \'{$a}\' löschen, aber verliehene Badges erhalten?';
$string['archiveconfirm'] = 'Löschen und verliehene Badges erhalten';
$string['archivehelp'] = '<p>Mit dieser Option wird der Badge \'zurückgezogen\' und erscheint nicht mehr in der Liste der Badges. Der Badge kann nicht mehr neu erworben werden. Alle diejenigen, die den Badge bereits erworben haben, können ihn weiterhin auf ihrer Profilseite anzeigen und in ihren externen Backpack exportieren.</p><p>Wenn Sie möchten, dass Nutzer/innen ihre erworbenen Badges behalten sollen, müssen Sie diese Option wählen, anstatt den Badge vollständig zu löschen.</p>';
$string['attachment'] = 'Badge an die Mitteilung anhängen';
$string['attachment_help'] = 'Wenn diese Option aktiviert ist, wird ein verliehener Badge zum Download an die E-Mail angehängt. Für die Verwendung dieser Option müssen E-Mail-Anhänge in der \'Website-Administration > Server > E-Mails > Ausgehende E-Mails\' aktiviert sein.';
$string['award'] = 'Badge verleihen';
$string['awardedto'] = 'Verliehen an {$a}';
$string['awardedtoyou'] = 'An mich verliehen';
$string['awardoncron'] = 'Der Zugriff auf die Badges wurde erfolgreich aktiviert. Zu viele Nutzer/innen können dieses Badge jetzt sofort erwerben. Um die Leistung der Website sicherzustellen, wird der Vorgang einige Zeit dauern.';
$string['awards'] = 'Empfänger/innen';
$string['backpackapiurl'] = 'URL der Backpack-API';
$string['backpackavailability'] = 'Externe Verifizierung der Badges';
$string['backpackavailability_help'] = 'Für die Verifizierung von Badges muss ein externer Backpack-Service auf die Website zugreifen. Im Moment scheint diese Verbindung nicht möglich zu sein, so dass verliehene Badges der Website nicht von extern verifiziert werden können.

**Warum sehe ich diese Mitteilung?**

Eventuell verhindert eine Firewall, dass jemand von außerhalb zugreifen kann. Möglicherweise ist die Website kennwortgeschützt oder ist nicht über das Internet erreichbar (z.B. ein lokales Moodle).

**Ist das ein Problem?**

Auf einer produktiven Website sollten Sie das Problem lösen. Andernfalls können Nutzer/innen nicht nachweisen, dass ein Badge auf der Website verliehen wurde.

**Was muss ich tun, wenn nicht die gesamte Website öffentlich erreichbar sein soll?**

Die einzige URL, die für die Verifizierung benötigt wird, ist [website]/badges/assertion.php. Wenn die Firewall so konfiguriert ist, dass sie den Zugriff auf dieses Skript erlaubt, funktioniert die Verifizierung von Badges.';
$string['backpackbadgessettings'] = 'Backpack-Einstellungen ändern';
$string['backpackbadgessummary'] = 'Sie haben {$a->totalbadges} Badge(s) aus {$a->totalcollections} Collection(s) angezeigt.';
$string['backpackcannotsendverification'] = 'Eine Bestätigungsmitteilung konnte nicht gesendet werden.';
$string['backpackconnected'] = 'Backpack ist verbunden';
$string['backpackconnection'] = 'Zum Backpack verbinden';
$string['backpackconnection_connected'] = 'Mein Backpack';
$string['backpackconnection_help'] = 'Speichern und teilen Sie Ihre Badges von dieser Website. Zeigen Sie öffentliche Badges anderer Websites in Ihrem Nutzerprofil.';
$string['backpackconnectioncancelattempt'] = 'Verwenden Sie zum Verbinden eine andere E-Mail-Adresse.';
$string['backpackconnectionconnect'] = 'Zum Backpack verbinden';
$string['backpackconnectionnottested'] = 'Die Verbindung kann für dieses Backpack nicht getestet werden, weil nur Backpacks für Open-Badges 2.0 unterstützt wird.';
$string['backpackconnectionok'] = 'Backpack-Verbindung erfolgreich hergestellt';
$string['backpackconnectionresendemail'] = 'Bestätigungsmitteilung erneut senden';
$string['backpackconnectionunexpectedmessage'] = 'Der Backpack liefert den Fehler: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Beim Verbinden mit Ihrem Backpack ist ein Problem aufgetreten. Ihr Backpack-Provider sendet die folgende Mitteilung: \'{$a}\'.';
$string['backpackdetails'] = 'Backpack konfigurieren';
$string['backpackdisconnected'] = 'Backpack ist getrennt';
$string['backpackemail'] = 'E-Mail-Adresse';
$string['backpackemail_help'] = 'E-Mail-Adresse, die mit Ihrem Backpack-Dienst verknüpft ist.

Wenn eine Verbindung zum Backpack-Dienst besteht, werden alle Badges dieser Website an diese E-Mail-Adresse zugeordnet.';
$string['backpackemail_required'] = 'Die E-Mail-Adresse darf nicht leer sein.';
$string['backpackemailverificationpending'] = 'Bestätigung ausstehend';
$string['backpackemailverifyemailbody'] = 'Hallo {$a->userfirstname},

Sie sind fast fertig, Ihr Badges-Backpack auf "{$a->sitename}" zu verbinden.

Um die Verbindung zu Ihrem Backpack abzuschließen, bestätigen Sie Ihre E-Mail-Adresse durch Drücken folgender Taste:

{$a->buttonlink}

Falls die Taste nicht funktioniert, können Sie auch die folgende URL kopieren und in Ihren Browser einfügen:
{$a->link}

Wenn Sie selber nicht versucht haben, eine Verbindung zu Ihrem Badges-Backpack herzustellen, können Sie diese E-Mail einfach ignorieren.

Für weitere Hilfe wenden Sie sich bitte an den Support Ihrer Website.

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: E-Mail-Bestätigung für Badges-Backpack';
$string['backpackemailverifypending'] = 'Eine E-Mail an <strong>{$a}</strong> wurde gesendet. Klicken Sie auf den Bestätigungslink in der E-Mail, um die Backpack-Verbindung zu aktivieren.';
$string['backpackemailverifysuccess'] = 'Sie sind jetzt mit Ihrem Backpack verbunden.';
$string['backpackemailverifytokenmismatch'] = 'Das Token im angeklickten Link stimmt nicht mit dem gespeicherten Token überein. Prüfen Sie, ob Sie wirklich den Link in der aktuellsten E-Mail angeklickt haben.';
$string['backpackexporterror'] = 'Badge kann nicht in Backpack exportiert werden';
$string['backpackexporterrorwithinfo'] = 'Das Badge "{$a->badgename}" kann nicht zum Backpack exportiert werden. Fehler: {$a->Fehler}';
$string['backpackimport'] = 'Importeinstellungen';
$string['backpackimport_help'] = 'Wenn die Verbindung zum Backpack erfolgreich hergestellt ist, können Badges aus Ihrem Backpack auf der Seite \'Meine Badges\' und in Ihrem Nutzerprofil angezeigt werden.

An dieser Stelle können Sie die Badge Collections auswählen, die Sie in Ihrem Profil anzeigen möchten.';
$string['backpackprovider'] = 'Backpack-Provider';
$string['backpacksettings'] = 'Backpack-Einstellungen';
$string['backpackweburl'] = 'Backpack-URL';
$string['badgedetails'] = 'Grundeinstellungen';
$string['badgeimage'] = 'Bild';
$string['badgeimage_help'] = 'Das Bild sollte mindestens 300 x 300 Pixel groß sein. Es wird als 300 x 300 Pixel auf der Badge-Seite und 100 x 100 Pixel auf der Profilseite von Nutzer/innen angezeigt.';
$string['badgeissued'] = 'Badge ausgestellt';
$string['badgeprivacysetting'] = 'Privatsphäre für Badges';
$string['badgeprivacysetting_help'] = 'Sie können erworbene Badges in Ihren Nutzerprofil anzeigen lassen. Diese Einstellung legt fest, ob neue Badges automatisch sichtbar werden.

Sie können die Sichtbarkeit eines Badge jederzeit auf der Seite \'Meine Badges\' ändern.';
$string['badgeprivacysetting_str'] = 'Meine Badges automatisch im Nutzerprofil anzeigen';
$string['badges'] = 'Badges';
$string['badgesalt'] = 'Hash-Salt für Empfänger-E-Mail-Adresse';
$string['badgesalt_desc'] = 'Mit Verwendung des Hash können Backpack-Dienste die Empfänger/innen eines Badge bestätigen, ohne deren E-Mail-Adresse zu kennen. Der Hash Salt ist eine zusätzliche Sicherung, die dem Hash hinzugefügt wird. Verwenden Sie für den Salt ausschließlich Ziffern und Buchstaben.

Hinweis: Vermeiden Sie bei der Absicherung der Badge-Verifikation unbedingt, nachträglich den Salt zu ändern, wenn bereits Badges verliehen wurden.';
$string['badgesdisabled'] = 'Badges sind auf dieser Moodle-Site nicht aktiviert.';
$string['badgesearned'] = 'Anzahl der erworbenen Badges: {$a}';
$string['badgesettings'] = 'Einstellungen';
$string['badgestatus_0'] = 'Nicht verfügbar';
$string['badgestatus_1'] = 'Verfügbar';
$string['badgestatus_2'] = 'Nicht verfügbar (Kriterien gesperrt)';
$string['badgestatus_3'] = 'Verfügbar (Kriterien gesperrt)';
$string['badgestatus_4'] = 'Archiviert';
$string['badgestoearn'] = 'Anzahl der verfügbaren Badges: {$a}';
$string['badgesview'] = 'Kursbezogene Badges';
$string['badgetags'] = 'Tags für Badges';
$string['badgeurl'] = 'Link zum verliehenen Badge';
$string['balignment'] = 'Ausrichtungen ({$a})';
$string['bawards'] = 'Empfänger/innen ({$a})';
$string['bcriteria'] = 'Kriterien';
$string['bdetails'] = 'Einstellungen';
$string['bendorsement'] = 'Bestätigung';
$string['bmessage'] = 'Mitteilung';
$string['boverview'] = 'Überblick';
$string['brelated'] = 'Zugeordnete Badges ({$a})';
$string['bydate'] = 'abgeschlossen bis';
$string['claim'] = 'Leitsatz (Claim)';
$string['claimcomment'] = 'Kommentar zur Anerkennung';
$string['claimid'] = 'Leitsatz (URL)';
$string['clearsettings'] = 'Einstellungen löschen';
$string['completioninfo'] = 'Dieser Badge wurde verliehen für den Abschluss:';
$string['completionnotenabled'] = 'Der Kursabschluss ist für diesen Kurs nicht aktiviert. Deshalb kann der Kursabschluss nicht als Kriterium zur Verleihung eines Badge verwendet werden. Aktivieren Sie den Kursabschluss in den Kurseinstellungen.';
$string['configenablebadges'] = 'Wenn diese Option aktiviert ist, können Sie Badges erstellen und an Nutzer/innen der Website verleihen.';
$string['configuremessage'] = 'Mitteilung';
$string['connect'] = 'Verbinden';
$string['connected'] = 'Verbunden';
$string['connecting'] = 'Wird verbunden ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'Tragen Sie hier die E-Mail-Adresse des Verleihers des Badge ein.';
$string['copy'] = 'Kopieren';
$string['copyof'] = 'Kopie von {$a}';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Badges';
$string['coursebadgesdisabled'] = 'Kursbezogene Badges sind nicht aktiviert.';
$string['coursebadgetitle'] = 'Kurs-Badge: {$a}';
$string['coursecompletion'] = 'Teilnehmer/innen müssen diesen Kurs abschließen.';
$string['create'] = 'Neuer Badge';
$string['createbutton'] = 'Badge anlegen';
$string['creatorbody'] = '<p>{$a->user} hat alle Kriterien erfüllt und den Badge verliehen bekommen. Sie können den Badge auf der Seite {$a->link} ansehen. </p>';
$string['creatorsubject'] = '\'{$a}\' wurde ausgezeichnet!';
$string['criteria_0'] = 'Dieser Badge wird verliehen, wenn ...';
$string['criteria_1'] = 'Aktivitätsabschluss';
$string['criteria_1_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die bestimmte Aktivitäten im Kurs abgeschlossen haben.';
$string['criteria_2'] = 'Manuelle Verleihung über eine bestimmte Rolle';
$string['criteria_2_help'] = 'Dieses Kriterium erlaubt es, einen Badge manuell durch Personen zu verleihen, die eine bestimmte Rolle auf der Website oder in einem Kurs haben.';
$string['criteria_3'] = 'Soziale Beteiligung';
$string['criteria_3_help'] = 'Sozial';
$string['criteria_4'] = 'Kursabschluss';
$string['criteria_4_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die den Kurs abgeschlossen haben. Bei diesem Kriterium können Sie zusätzliche Parameter festlegen, z.B. eine zu erreichende Mindestbewertung oder ein Datum für den Kursabschlusses.';
$string['criteria_5'] = 'Mehrere Kurse abschließen';
$string['criteria_5_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die mehrere Kurse abgeschlossen haben. Für jeden dieser Kurse können Sie zusätzliche Parameter festlegen, z.B. eine zu erreichende Mindestbewertung oder ein Datum für den Kursabschlusses.';
$string['criteria_6'] = 'Vervollständigung des Nutzerprofils';
$string['criteria_6_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die bestimmte Profilfelder im ihrem Nutzerprofil vervollständigt haben. Das können standardmäßige oder nutzerdefinierte Profilfelder sein, die für Nutzer/innen zugänglich sind.';
$string['criteria_7'] = 'Verliehene Badges';
$string['criteria_7_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die bereits andere Badges erworben haben.';
$string['criteria_8'] = 'Mitgliedschaft in globaler Gruppe';
$string['criteria_8_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die Mitglied in bestimmten globalen Gruppen sind.';
$string['criteria_9'] = 'Kompetenzen';
$string['criteria_9_help'] = 'Dieses Kriterium erlaubt es, einen Badge an Nutzer/innen zu verleihen, die bestimmte Kompetenzen abgeschlossen haben.';
$string['criteria_descr'] = 'Nutzer/innen erhalten den Badge, wenn sie folgende Bedingung erfüllen:';
$string['criteria_descr_0'] = 'Abschluss von <strong>{$a}</strong> der folgenden Bedingungen.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> folgenden Aktivitäten sind abgeschlossen:';
$string['criteria_descr_2'] = 'Dieser Badge muss von Nutzer/innen mit <strong>{$a}</strong> Rollen verliehen werden:';
$string['criteria_descr_4'] = 'Teilnehmer/innen müssen den Kurs abschließen.';
$string['criteria_descr_5'] = '<strong>{$a}</strong> folgenden Kurse müssen abgeschlossen sein:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> folgenden Nutzerprofilfelder müssen vervollständigt sein:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> aus den folgenden Badges müssen erworben werden:';
$string['criteria_descr_8'] = 'Mitgliedschaft in <strong>{$a}</strong> von folgenden globalen Gruppen ist notwendig:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> der folgenden Kompetenzen müssen abgeschlossen werden:';
$string['criteria_descr_bydate'] = ' bis <em>{$a}</em>';
$string['criteria_descr_grade'] = 'mit minimaler Bewertung von <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Abschließen <strong>{$a}</strong>: ';
$string['criteria_descr_short1'] = 'Abschließen <strong>{$a}</strong>: ';
$string['criteria_descr_short2'] = 'Verliehen durch <strong>{$a}</strong>:';
$string['criteria_descr_short4'] = 'Kurs abschließen';
$string['criteria_descr_short5'] = 'Abschließen <strong>{$a}</strong>: ';
$string['criteria_descr_short6'] = 'Abschließen <strong>{$a}</strong>: ';
$string['criteria_descr_short7'] = 'Abschließen <strong>{$a}</strong>: ';
$string['criteria_descr_short8'] = 'Mitglied in globaler Gruppe <strong>{$a}</strong> von:';
$string['criteria_descr_short9'] = 'Abgeschlossene <strong>{$a}</strong> von:';
$string['criteria_descr_single_1'] = 'Die folgende Aktivität muss beendet werden:';
$string['criteria_descr_single_2'] = 'Dieser Badge muss von Nutzer/innen mit folgender Rolle verliehen werden:';
$string['criteria_descr_single_4'] = 'Teilnehmer/innen müssen den Kurs abschließen';
$string['criteria_descr_single_5'] = 'Der folgende Kurs muss abgeschlossen werden:';
$string['criteria_descr_single_6'] = 'Das folgende Nutzerprofilfeld muss vervollständigt sein:';
$string['criteria_descr_single_7'] = 'Der folgende Badge muss erworben werden:';
$string['criteria_descr_single_8'] = 'Mitgliedschaft in folgender globaler Gruppe ist notwendig:';
$string['criteria_descr_single_9'] = 'Die folgenden Kompetenzen wurden abgeschlossen:';
$string['criteria_descr_single_short1'] = 'Abschließen:';
$string['criteria_descr_single_short2'] = 'Verliehen durch:';
$string['criteria_descr_single_short4'] = 'Kurs abschließen';
$string['criteria_descr_single_short5'] = 'Abschließen:';
$string['criteria_descr_single_short6'] = 'Abschließen:';
$string['criteria_descr_single_short7'] = 'Abschließen:';
$string['criteria_descr_single_short8'] = 'Mitglied in:';
$string['criteria_descr_single_short9'] = 'Abgeschlossen:';
$string['criteriacreated'] = 'Kriterium für Badge angelegt';
$string['criteriadeleted'] = 'Kriterium für Badge gelöscht';
$string['criteriasummary'] = 'Zusammenfassung der Kriterien';
$string['criteriaupdated'] = 'Kriterium für Badge aktualisiert';
$string['criterror'] = 'Parameterprobleme';
$string['criterror_help'] = 'Die Übersicht zeigt alle Parameter, die ursprünglich mit diesem Badge verbunden waren, aber nicht mehr verfügbar sind. Diese Parameter sollten deaktiviert werden, damit Nutzer/innen diesen Badge in Zukunft überhaupt erlangen können.';
$string['currentimage'] = 'Aktuelles Bild';
$string['currentstatus'] = 'Aktueller Status';
$string['dateawarded'] = 'Verleihdatum';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Tag(e)';
$string['deactivate'] = 'Zugriff verhindern';
$string['deactivatesuccess'] = 'Der Zugriff auf den Badge wurde erfolgreich deaktiviert.';
$string['defaultissuercontact'] = 'E-Mail-Adresse des Badge-Verleihers';
$string['defaultissuercontact_desc'] = 'Tragen Sie hier eine E-Mail-Adresse ein, die mit dem Badge-Verleiher verknüpft ist. Für ein Open-Badge-Backpack 2.0 dient diese der Authentifizierung, wenn Badges in ein Backpack veröffentlicht werden.';
$string['defaultissuername'] = 'Name des Badge-Verleihers';
$string['defaultissuername_desc'] = 'Tragen Sie hier einen Namen ein, der Verleiher von Badges auf der Website verwendet wird (z.B. den Namen der verleihenden Institution).';
$string['defaultissuerpassword'] = 'Kennwort des Badge-Verleihers';
$string['defaultissuerpassword_help'] = 'Auf der Backpack-Website ist ein Konto mit der E-Mail-Adresse erforderlich, die in der Einstellung für die E-Mail-Adresse des Badge-Verleihers unter "Website-Administration / Badges / Badge-Einstellungen angegeben ist. Das Kennwort für das Konto sollte hier eingegeben werden.';
$string['delbadge'] = 'Möchten Sie wirklich den Badge \'{$a}\' und alle verliehenen Instanzen löschen?';
$string['delconfirm'] = 'Löschen und verliehene Badges entfernen';
$string['delcritconfirm'] = 'Möchten Sie dieses Kriterium wirklich löschen?';
$string['deletehelp'] = '<p>Vollständiges Löschen von Badges führt dazu, dass alle verliehenen Badges verschwinden und nicht mehr verfügbar sind. Löschen bedeutet, sie endgültig zu entfernen.</p><p>Hinweis: Wenn Nutzer/innen vor dem Löschen einen Badge exportiert haben, bleibt dieser erhalten. Der Link zur Prüfseite, wo der Badge herkommt, wird jedoch beim Löschen entfernt und kann nicht mehr genutzt werden.</p>';
$string['delexternalbackpack'] = 'Website-Backpack löschen';
$string['delexternalbackpackconfirm'] = 'Website-Backpack \'{$a}\' löschen?';
$string['delparamconfirm'] = 'Möchten Sie diesen Parameter wirklich löschen?';
$string['description'] = 'Beschreibung';
$string['disconnect'] = 'Verbindung aufheben';
$string['donotaward'] = 'Derzeit ist der Badge nicht verfügbar, d.h. er kann nicht an Nutzer/innen verliehen werden. Wenn Sie den Badge verleihen möchten, müssen Sie ihn aktivieren. Klicken Sie dazu auf die Taste \'\'Zugriff erlauben\'\'.';
$string['enablebadges'] = 'Badges aktivieren';
$string['endorsement'] = 'Bestätigung';
$string['error:backpackdatainvalid'] = 'Die vom Backpack gelieferten Daten sind ungültig!';
$string['error:backpackemailnotfound'] = 'Die E-Mail \'{$a}\' ist nicht mit einem Backpack verbunden. Sie müssen sich für dieses Konto ein <a href="https://backpack.openbadges.org">Backpack anlegen</a> oder sich mit einer anderen E-Mail-Adresse anmelden.';
$string['error:badgeawardnotfound'] = 'Dieser Badge kann nicht verifiziert werden. Möglicherweise wurde er zurückgezogen.';
$string['error:badgenotfound'] = 'Badge nicht gefunden';
$string['error:cannotact'] = 'Der Badge kann nicht aktiviert werden.';
$string['error:cannotawardbadge'] = 'Der Badge kann nicht an Nutzer/innen verliehen werden.';
$string['error:cannotdeletecriterion'] = 'Das Kriterium kann nicht gelöscht werden.';
$string['error:cannotrevokebadge'] = 'Das Badge kann von Nutzer/in nicht zurückgezogen werden.';
$string['error:clone'] = 'Der Badge kann nicht dupliziert werden.';
$string['error:connectionunknownreason'] = 'Die Verbindung ist fehlgeschlagen, aber es wurde kein Grund angegeben.';
$string['error:duplicatename'] = 'Ein Badge mit diesem Namen existiert bereits im System.';
$string['error:externalbadgedoesntexist'] = 'Badge nicht gefunden';
$string['error:guestuseraccess'] = 'Sie sind im Moment als Gast angemeldet. Um Badges zu sehen, müssen Sie sich mit Ihren Nutzerdaten anmelden.';
$string['error:invalidcriteriatype'] = 'Unzugültiger Kriteriumstyp';
$string['error:invalidexpiredate'] = 'Das Ablaufdatum muss in der Zukunft liegen.';
$string['error:invalidexpireperiod'] = 'Der Ablaufdauer kann nicht negativ oder gleich Null sein.';
$string['error:invalidparambadge'] = 'Der Badge existiert nicht.';
$string['error:invalidparamcohort'] = 'Die globale Gruppe existiert nicht.';
$string['error:noactivities'] = 'In diesem Kurs wurde für keine Aktivität ein Aktivitätsabschluss konfiguriert.';
$string['error:nobadges'] = 'Derzeit sind keine Badges aktiviert, die als Kriterien hinzugefügt werden können. Ein Website-Badge kann nur andere Website-Badges als Kriterien haben. Ein Kurs-Badge kann andere Kurs-Badges oder Wensite-Badges als Kriterien haben.';
$string['error:nocohorts'] = 'Keine globalen Gruppen';
$string['error:nocourses'] = 'Der Kursabschluss ist für keinen Kurs der Website aktiviert. Deshalb wird kein Kurs zur Auswahl angezeigt. Sie können den Kursabschluss in den Kurseinstellungen aktivieren.';
$string['error:nogroupslink'] = '<p>Nur öffentliche Collections werden angezeigt. <a href="{$a}" target="_blank" rel="nofollow">Gehen Sie zu Ihrem Backpack</a> und legen Sie mindestens eine öffentliche Collection an.</p>';
$string['error:nogroupssummary'] = '<p>Keine öffentlichen Badge Collections in Ihrem Backpack.</p>';
$string['error:nopermissiontoview'] = 'Sie haben kein Recht, Empfänger/innen mit dem Badge zu sehen.';
$string['error:nosuchbadge'] = 'Der Badge mit der ID {$a} existiert nicht.';
$string['error:nosuchcohort'] = 'Warnung: Diese globale Gruppe ist nicht länger verfügbar.';
$string['error:nosuchcourse'] = 'Warnung: Dieser Kurs existiert nicht mehr.';
$string['error:nosuchfield'] = 'Warnung: Dieses Nutzerprofilfeld existiert nicht mehr.';
$string['error:nosuchmod'] = 'Warnung: Diese Aktivität existiert nicht mehr.';
$string['error:nosuchrole'] = 'Warnung: Diese Rolle ist nicht mehr verfügbar.';
$string['error:nosuchuser'] = 'Die Person mit dieser E-Mail-Adresse hat kein Nutzerkonto beim aktuellen Backpack-Dienst.';
$string['error:notifycoursedate'] = 'Warnung: Badges, die mit dem Abschluss von Aktivitäten bzw. Kursen verbunden sind, können nicht verliehen werden, bevor der Kurs startet.';
$string['error:parameter'] = 'Warnung: Mindestens ein Parameter sollte gewählt werden, damit die Verleihung des Badge reibungslos funktioniert.';
$string['error:relatedbadgedoesntexist'] = 'Es gibt für diese ID kein öffentliches Badge';
$string['error:requesterror'] = 'Die Verbindung ist fehlgeschlagen (Fehlercode {$a}).';
$string['error:requesttimeout'] = 'Die Verbindung ist fehlgeschlagen (Timeout).';
$string['error:save'] = 'Der Badge kann nicht gespeichert werden.';
$string['error:userdeleted'] = '{$a->user} (Dieses Nutzerkonto wurde in {$a->site} gelöscht)';
$string['eventbadgearchived'] = 'Badge archiviert';
$string['eventbadgeawarded'] = 'Badge verliehen';
$string['eventbadgecreated'] = 'Badge angelegt';
$string['eventbadgecriteriacreated'] = 'Kriterien für Badge angelegt';
$string['eventbadgecriteriadeleted'] = 'Kriterien für Badge gelöscht';
$string['eventbadgecriteriaupdated'] = 'Kriterien für Badge aktualisiert';
$string['eventbadgedeleted'] = 'Badge gelöscht';
$string['eventbadgedisabled'] = 'Badge deaktiviert';
$string['eventbadgeduplicated'] = 'Badge dupliziert';
$string['eventbadgeenabled'] = 'Badge aktiviert';
$string['eventbadgelistingviewed'] = 'Liste der Badges angezeigt';
$string['eventbadgerevoked'] = 'Badge zurückgezogen';
$string['eventbadgeupdated'] = 'Badge aktualisiert';
$string['eventbadgeviewed'] = 'Badge angezeigt';
$string['evidence'] = 'Evidenz';
$string['existingrecipients'] = 'Vorhandene Empfänger/innen';
$string['existsinbackpack'] = 'Badge existiert bereits im Backpack';
$string['expired'] = 'Abgelaufen';
$string['expiredate'] = 'Diese  Badge verfällt am {$a}.';
$string['expireddate'] = 'Dieser Badge ist am {$a} verfallen.';
$string['expiredin'] = 'Abgelaufen {$a}';
$string['expireperiod'] = 'Dieser Badge verfällt {$a} Tag(e) nach der Verleihung.';
$string['expireperiodh'] = 'Dieser Badge verfällt {$a} Stunde(n) nach der Verleihung.';
$string['expireperiodm'] = 'Dieser Badge verfällt {$a} Minute(n) nach der Verleihung.';
$string['expireperiods'] = 'Dieser Badge verfällt {$a} Sekunde(n) nach der Verleihung.';
$string['expiresin'] = 'Läuft ab {$a}';
$string['expirydate'] = 'Ablaufdatum';
$string['expirydate_help'] = 'Optional können Badges zu einem bestimmten Termin verfallen oder nur eine vorgegebene Zeit nach der Verleihung gültig sein.';
$string['externalbackpack_required'] = 'Der Backpack-Provider kann nicht leer sein.';
$string['externalbadges'] = 'Meine Badges von anderen Websites';
$string['externalbadges_help'] = 'Dieser Bereich zeigt Badges aus Ihrem externen Backpack.';
$string['externalbadgesp'] = 'Badges von anderen Websites:';
$string['externalconnectto'] = 'Um Ihre externen Badges anzeigen zu können, müssen Sie eine <a href="{$a}">Verbindung zu einem Backpack</a> herstellen.';
$string['fixed'] = 'Fester Termin';
$string['hidden'] = 'Verborgen';
$string['hiddenbadge'] = 'Keine Informationen zum Badge verfügbar';
$string['hostedurl'] = 'Externe URL';
$string['hostedurldescription'] = 'Externe URL, über die das Badge bereitgestellt ist';
$string['imageauthoremail'] = 'E-Mail von Bildautor/in';
$string['imageauthoremail_help'] = 'Wenn angegeben, wird die E-Mail-Adresse der Person auf der Badge-Seite angezeigt, die das Bild erstellt hat.';
$string['imageauthorname'] = 'Name von Bildautor/in';
$string['imageauthorname_help'] = 'Wenn angegeben, wird der Name der Person auf der Badge-Seite angezeigt, die das Bild erstellt hat.';
$string['imageauthorurl'] = 'URL von Bildautor/in';
$string['imageauthorurl_help'] = 'Wenn angegeben, wird die URL zur Website der Person auf der Badge-Seite angezeigt, die das Bild erstellt hat. Die URL muss mit http:// oder https:// beginnen.';
$string['imagecaption'] = 'Bildtitel';
$string['imagecaption_help'] = 'Wenn ein Bildtitel angegeben ist, wird er auf Badge-Seite angezeigt.';
$string['includeauthdetails'] = 'Authentifikationsdetails für den Backpack einbeziehen';
$string['invalidurl'] = 'Ungültige URL';
$string['issuancedetails'] = 'Ablaufdatum';
$string['issuedbadge'] = 'Information zum verliehenen Badge';
$string['issuedby'] = 'Verliehen von {$a}';
$string['issuedon'] = 'Verliehen {$a}';
$string['issuerdetails'] = 'Verleiher/in';
$string['issueremail'] = 'E-Mail';
$string['issueremail_help'] = 'E-Mail-Kontakt der Organisation, die die Unterstützung liefert.';
$string['issuername'] = 'Verleiher/in';
$string['issuername_endorsement'] = 'Ausstellername';
$string['issuername_endorsement_help'] = 'Name des/der Bestätigenden';
$string['issuername_help'] = 'Tragen Sie hier den Namen des Verleihers oder der verleihenden Institution ein.';
$string['issuerurl'] = 'URL von Verleiher/in';
$string['issuerurl_help'] = 'Die Website der ausstellenden Organisation. Die URL muss mit http:// oder https:// beginnen.';
$string['language'] = 'Sprache';
$string['language_help'] = 'Sprache, die auf der Badge-Seite verwendet wird.';
$string['listbackpacks'] = 'Liste von Backpacks';
$string['localbadges'] = 'Meine Badges von der Website {$a}';
$string['localbadgesh'] = 'Meine Badges von dieser Website';
$string['localbadgesh_help'] = 'Diese Seite zeigt alle Badges, die Ihnen auf dieser Website für den Abschluss von Kursen, Aktivitäten oder anderer Kriterien verliehen wurden.

Sie können für Ihre Badges einstellen, welche in Ihrem Nutzerprofil angezeigt werden sollen und welche nicht.

Sie können alle oder einzelne Badges herunterladen und auf Ihrem Computer speichern. Heruntergeladene Badges können zu externen Backpack-Diensten hinzugefügt werden.';
$string['localbadgesp'] = 'Badges von {$a}:';
$string['localconnectto'] = 'Um die Badges außerhalb dieser Website zu teilen, müssen Sie eine <a href="{$a}">Verbindung zu einem Backpack</a> herstellen.';
$string['loginbackpacktitle'] = '<strong>Melden Sie sich für Ihr Backpack an</strong>';
$string['makeprivate'] = 'nicht anzeigen';
$string['makepublic'] = 'anzeigen';
$string['managebackpacks'] = 'Backpacks verwalten';
$string['managebadges'] = 'Badges verwalten';
$string['message'] = 'Mitteilung';
$string['messagebody'] = '<p>Sie haben den Badge "%badgename%" verliehen bekommen!</p>
<p>Weitere Informationen zu diesem Badge finden Sie unter %badgelink%.</p>
<p>Sie können den Badge über die Seite {$a} verwalten und herunterladen.</p>';
$string['messagesubject'] = 'Glückwunsch! Sie haben einen Badge erworben!';
$string['method'] = 'Dieses Kriterium ist erfüllt, wenn ...';
$string['mingrade'] = 'Mindestbewertung notwendig';
$string['month'] = 'Monat(e)';
$string['moredetails'] = 'Weitere Details';
$string['mybackpack'] = 'Einstellungen für mein Backpack';
$string['mybadges'] = 'Meine Badges';
$string['namewithlink'] = 'Name mit Link';
$string['never'] = 'Nie';
$string['newbackpack'] = 'Neuen Backpack hinzufügen';
$string['newbadge'] = 'Neuen Badge anlegen';
$string['newimage'] = 'Neues Bild';
$string['noalignment'] = 'Für diesen Badge sind keine externen Skills oder Kompetenzen angegeben.';
$string['noawards'] = 'Dieser Badge wurde bisher nicht verliehen.';
$string['nobackpack'] = 'Mit diesem Nutzerkonto ist kein Backpack-Dienst verbunden.<br/>';
$string['nobackpackbadgessummary'] = 'Es sind keine Badges in den von Ihnen ausgewählten Collections verfügbar.';
$string['nobackpackcollectionssummary'] = 'Keine Badge Collection ausgewählt';
$string['nobackpacks'] = 'Keine Backpacks verfügbar';
$string['nobadges'] = 'Derzeit sind keine Badges für Nutzer/innen verfügbar';
$string['nocompetencies'] = 'Keine Kompetenzen ausgewählt';
$string['nocriteria'] = 'Badge-Kriterien sind bisher nicht festgelegt.';
$string['noendorsement'] = 'Für das Badge wurde keine Bestätigung erteilt.,';
$string['noexpiry'] = 'Dieser Badge hat kein Ablaufdatum.';
$string['noparamstoadd'] = 'Es gibt keine weiteren Parameter, die zu diesem Badge-Kriterium hinzugefügt werden können.';
$string['norelated'] = 'Dieser Badge hat keine zugeordneten Badges.';
$string['notacceptedrole'] = 'Sie haben derzeit keine Rolle, die diesen Badge manuell verleihen darf.<br/>
Personen, die diesen Badge bisher erworben haben, können Sie auf der Seite {$a} sehen.';
$string['notconnected'] = 'Nicht verbunden';
$string['notealignment'] = 'Es können externe Fertigkeiten oder Standards festgelegt werden, für die der Badge gilt. Alle externen Fähigkeiten oder Standards werden auf der Badge-Seite angezeigt.';
$string['noteendorsement'] = 'Die Ausstellung über Dritte kann verwendet werden, um dem Badge einen Mehrwert zu verleihen. Ein Badge ist beispielsweise bedeutsamer, wenn er von einer Institution statt von einer Einzelperson ausgestellt wurde. Auch, wenn er von einer überregionalen oder nationalen Organisation stammt statt von einer lokalen Institution.';
$string['noterelated'] = 'Badges mit einer Verbindung können als verwandt gekennzeichnet sein. Beispielsweise können alle Badges mit gleichem Kriterium, die in verschiedenen Sprachen angezeigt werden, als verwandt gekennzeichnet werden. Alle verwandten Badges werden auf der Badge-Seite angezeigt.';
$string['nothingtoadd'] = 'Es sind keine Kriterien verfügbar.';
$string['notification'] = 'Ersteller/in benachrichtigen';
$string['notification_help'] = 'Diese Einstellung legt fest, wie Ersteller/innen benachrichtigt werden, wenn der Badge verliehen wird.

Folgende Optionen sind möglich:

* **Nie**: Keine Nachrichten.

* **Jederzeit**: Nachricht, sobald der Badge verliehen wird.

* **Täglich**: Nachricht einmal täglich.

* **Wöchentlich**: Nachricht einmal wöchentlich.

* **Monatlich**: Nachricht einmal monatlich.';
$string['notifydaily'] = 'Täglich';
$string['notifyevery'] = 'Jederzeit';
$string['notifymonthly'] = 'Monatlich';
$string['notifyweekly'] = 'Wöchentlich';
$string['numawards'] = 'Dieser Badge wurde an <a href="{$a->link}">{$a->count}</a> Person(en) verliehen.';
$string['numawardstat'] = 'Dieser Badge wurde an {$a} Person(en) verliehen.';
$string['oauth2issuer'] = 'OAuth 2-Services';
$string['openbadgesv1'] = 'Open-Badges 1.0';
$string['openbadgesv2'] = 'Open-Badges 2.0';
$string['openbadgesv2p1'] = 'Open-Badges 2.1';
$string['othernavigation'] = 'Andere Navigation ...';
$string['overallcrit'] = 'gewählten Kriterien sind erfüllt.';
$string['password_required'] = 'Das Kennwort darf nicht leer sein.';
$string['potentialrecipients'] = 'Mögliche Empfänger/innen';
$string['preferences'] = 'Badges konfigurieren';
$string['privacy:metadata:backpack'] = 'Datensatz von Nutzer-Backpacks (Badges)';
$string['privacy:metadata:backpack:backpackuid'] = 'Eindeutiger Identifier des Backpacks';
$string['privacy:metadata:backpack:email'] = 'E-Mail-Adresse, die mit dem Backpack verbunden ist';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID des Backpacks';
$string['privacy:metadata:backpack:userid'] = 'ID der Person, deren Backpack das ist';
$string['privacy:metadata:backpackoauth2'] = 'OAuth2-Info, wenn sich eine Person zu einem externen Backpack verbindet';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'Oauth 2-Service-ID';
$string['privacy:metadata:backpackoauth2:scope'] = 'Umfang der Backpack-Verbindung auflisten';
$string['privacy:metadata:backpackoauth2:token'] = 'Token der Backpack-Verbindung';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID der Person, die die Verbindung aufbaut';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID der Person, die die Verbindung ändert';
$string['privacy:metadata:badge'] = 'Badge Collection';
$string['privacy:metadata:badge:timecreated'] = 'Zeit, zu der der Badge erstellt wurde';
$string['privacy:metadata:badge:timemodified'] = 'Zeit, zu der der Badge zuletzt bearbeitet wurde';
$string['privacy:metadata:badge:usercreated'] = 'ID der Person, die den Badge erstellt hat';
$string['privacy:metadata:badge:usermodified'] = 'ID der Person, die den Badge bearbeitet hat';
$string['privacy:metadata:criteriamet'] = 'Liste von Kriterien, die erreicht wurden';
$string['privacy:metadata:criteriamet:datemet'] = 'Das Datum, an dem das Kriterium erfüllt wurde';
$string['privacy:metadata:criteriamet:userid'] = 'ID der Person, die die Kriterien erfüllt hat';
$string['privacy:metadata:external:backpacks'] = 'Geteilte Daten, wenn eine Person Ihre Badges an ein externes Backpack überträgt';
$string['privacy:metadata:external:backpacks:badge'] = 'Name des Badge';
$string['privacy:metadata:external:backpacks:description'] = 'Beschreibung des Badge';
$string['privacy:metadata:external:backpacks:image'] = 'Bild des Badge';
$string['privacy:metadata:external:backpacks:issuer'] = 'Information zum Verleiher';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle-URL, unter der verliehene Badge angezeigt werden kann';
$string['privacy:metadata:issued'] = 'Liste der ausgestellten Badges';
$string['privacy:metadata:issued:dateexpire'] = 'Zeit, zu der der Badge abläuft';
$string['privacy:metadata:issued:dateissued'] = 'Zeitpunkt der Verleihung';
$string['privacy:metadata:issued:userid'] = 'ID der Person, die den Badge erworben hat';
$string['privacy:metadata:manualaward'] = 'Liste manuell verliehener Badges';
$string['privacy:metadata:manualaward:datemet'] = 'Zeit, zu der der Badge verliehen wurde';
$string['privacy:metadata:manualaward:issuerid'] = 'ID der Person, die den Badge verleiht';
$string['privacy:metadata:manualaward:issuerrole'] = 'Rolle der Person, die den Badge verleiht';
$string['privacy:metadata:manualaward:recipientid'] = 'ID der Person, die den Badge manuell verliehen bekommen hat';
$string['recipient'] = 'Badge-Empfänger/in';
$string['recipientdetails'] = 'Empfängerdetails';
$string['recipientidentificationproblem'] = 'Empfänger/in für diesen Badge kann unter den vorhandenen Nutzer/innen nicht gefunden werden.';
$string['recipients'] = 'Empfänger/innen';
$string['recipientvalidationproblem'] = 'Nutzer/in kann nicht als Empfänger/in für dieses Badge verifiziert werden.';
$string['relatedbages'] = 'Zugeordnete Badges';
$string['relative'] = 'Relative Zeit';
$string['requiredbadge'] = 'Mindestens ein Badge muss zum Kriterium hinzugefügt werden.';
$string['requiredcohort'] = 'Mindestens eine globale Gruppe muss zum Kriterium hinzugefügt werden.';
$string['requiredcompetency'] = 'Mindestens eine Kompetenz muss zum Kompetenzkriterium hinzugefügt werden.';
$string['requiredcourse'] = 'Mindestens ein Kurs muss zum Kriterium hinzugefügt werden.';
$string['reviewbadge'] = 'Änderungen beim Zugriff zum Badge';
$string['reviewconfirm'] = '<p>Hiermit machen Sie Ihren Badge für Nutzer/innen sichtbar und erlauben ihnen den Erwerb.</p>

<p>Möglicherweise haben Nutzer/innen bereits früher die Kriterien für den Badge erfüllt. Ihnen wird der Badge nun umgehend zugewiesen.</p>

<p>Sobald der Badge einmal verliehen wurde, wird er <strong>gesperrt</strong>.</p>

<p>Möchten Sie für den Badge \'{$a}\' nun den Zugriff aktivieren?</p>';
$string['revoke'] = 'Badge zurückziehen';
$string['save'] = 'Speichern';
$string['searchname'] = 'Nach Name suchen';
$string['selectaward'] = 'Wählen Sie die Rolle, die diesen Badge verleihen darf:';
$string['selectgroup_end'] = 'Nur öffentliche Collections werden angezeigt. <a href="{$a}">Gehen Sie zu Ihrem Backpack</a> und legen Sie eine öffentliche Collection an.';
$string['selectgroup_start'] = 'Wählen Sie Collections aus Ihrem Backpack, um sie auf dieser Seite anzuzeigen:';
$string['selecting'] = 'Mit den gewählten Badges ...';
$string['setup'] = 'Verbindung konfigurieren';
$string['sitebackpackdeleted'] = 'Der Website-Backpack wurde gelöscht.';
$string['sitebackpacknotdeleted'] = 'Dieser Backpack konnte nicht gelöscht werden, da dies die Standardeinstellung der Website ist.';
$string['sitebackpackwarning'] = 'Die Verbindung zum Backpack konnte nicht hergestellt werden. <br> <br>Überprüfen Sie, ob die Administrationseinstellung "E-Mail-Adresse des Badge-Ausstellers" die gültige E-Mail-Adresse für ein Konto auf der Backpack-Website ist. <br> <br> Vergewissern Sie sich, dass das "Kennwort des Badge-Ausstellers" auf der Seite <a href="{$a-> url}"> Einstellungen für den Website-Backpack </a> das richtige Kennwort für das Konto auf der Backpack-Website ist. <br> <br> Antwort der Backpack-Website: "{$a->warning}"';
$string['sitebadges'] = 'Website-Badges';
$string['sitebadges_help'] = 'Website-Badges können nur für systemweite Leistungen verliehen werden, wie z.B. das Abschließen mehrerer Kurse oder die Vervollständigung des Nutzerprofils. Website-Badges können auch manuell von einer Person an eine andere verliehen werden.

Badges für kursbezogene Leistungen müssen für den jeweiligen Kurs angelegt werden. Sie finden die entsprechenden kursbezogenen Badges unter \'Kurs-Administration > Badges\'.';
$string['sitebadgetitle'] = 'Website-Badge: {$a}';
$string['status'] = 'Status';
$string['status_help'] = 'Der Status eines Badge legt fest, wie er verwendet werden kann:

* **Verfügbar**: Der Badge kann von Nutzer/innen erworben werden. Während ein Badge verfügbar ist, können keine Änderungen an den Kriterien vorgenommen werden.

* **Nicht verfügbar**: Der Badge kann nicht erworben und auch nicht manuell verliehen werden. Solange ein Badge nicht verliehen wurde, können seine Kriterien verändert werden.

Sobald ein Badge einmal verliehen wurde, wird er automatisch **gesperrt**. Gesperrte Badges können weiterhin erworben werden, die Kriterien sind aber nicht mehr änderbar. Falls Sie Details oder Kriterien eines gesperrten Badges bearbeiten möchten, können Sie den Badge duplizieren und dann alle Einstellungen vornehmen.

*Warum werden Badges gesperrt?*

Wir möchten sicherstellen, dass immer dieselbe Leistung erbracht werden muss, um den Badge zu erwerben. Derzeit ist es nicht möglich, einmal erworbene Badges zurückzuziehen. Wenn die Kriterien für Badges nachträglich geändert werden könnten, würden Nutzer/innen mit dem gleichen Badge möglicherweise ganz andere Anforderungen erfüllt haben.';
$string['statusmessage_0'] = 'Dieser Badge ist derzeit für Nutzer/innen nicht verfügbar. Klicken Sie auf \'\'Zugriff aktivieren\'\', damit der Badge von Nutzer/innen erworben werden kann.';
$string['statusmessage_1'] = 'Dieser Badge ist derzeit für Nutzer/innen verfügbar. Klicken Sie auf \'\'Zugriff verhindern\'\', wenn Sie Änderungen vornehmen möchten.';
$string['statusmessage_2'] = 'Dieser Badge ist derzeit für Nutzer/innen nicht verfügbar und seine Kriterien sind gesperrt. Klicken Sie auf \'\'Zugriff aktivieren\'\', damit er wieder von Nutzer/innen erworben werden kann.';
$string['statusmessage_3'] = 'Dieser Badge ist derzeit für Nutzer/innen verfügbar und seine Kriterien sind gesperrt.';
$string['statusmessage_4'] = 'Dieser Badge ist derzeit archiviert.';
$string['subject'] = 'Betreff';
$string['tagarea_badge'] = 'Badges';
$string['tags'] = 'Tags';
$string['targetcode'] = 'Code';
$string['targetcode_help'] = 'Eindeutige Text-ID, mit der auf die externe Fähigkeit oder den externen Standard in ihrem Framework verwiesen wird.';
$string['targetdescription'] = 'Beschreibung';
$string['targetdescription_help'] = 'Kurze Beschreibung der externen Fähigkeit oder des externen Standards.';
$string['targetframework'] = 'Framework';
$string['targetframework_help'] = 'Name Frameworks für den externen Fähigkeit oder den externen Standards.';
$string['targetname'] = 'Name';
$string['targetname_help'] = 'Die externe Fähigkeit oder der externe Standard., womit der Badge verbunden ist.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Ein Link zur Beschreibung, die die externe Fähigkeit oder den externen Standard darstellt. Die URL muss mit http:// oder https:// beginnen.';
$string['testbackpack'] = 'Backpack \'{$a}\' testen';
$string['testsettings'] = 'Testeinstellungen';
$string['type'] = 'Typ';
$string['userbadges'] = 'Badges von Nutzer/innen';
$string['variablesubstitution'] = 'Variablenersetzung in Mitteilungen';
$string['variablesubstitution_help'] = 'In der Mitteilung, die an Badge-Empfänger/innen versendet wird, stehen verschiedene Platzhalter im Text bzw. im Betreff. Diese Platzhalter werden automatisch durch geeignete Werte ersetzt, wenn die Mitteilung erzeugt und versendet wird. Das funktioniert jedoch nur, wenn die Syntax genau so wie nachfolgend beschrieben verwendet wird:

%badgename%
: An dieser Stelle wird der Name des Badge eingesetzt.

%username%
: An dieser Stelle wird der vollständige Name der Person eingesetzt, die den Badge erworben hat.

%badgelink%
: An dieser Stelle wird die öffentliche URL zu einer Seite eingesetzt, die Informationen zum Badge anzeigt.';
$string['verifyemail'] = 'E-Mail prüfen';
$string['version'] = 'Version';
$string['version_help'] = 'Das Versionsfeld kann verwendet werden, um die Badge-Entwicklung zu verfolgen. Wenn angegeben, wird die Version auf der Badge-Seite angezeigt.';
$string['viewbadge'] = 'Verliehenen Badge anzeigen';
$string['visible'] = 'Sichtbar';
$string['warnexpired'] = '(Dieser Badge ist abgelaufen!)';
$string['year'] = 'Jahr(e)';
