<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'ja', version '4.3'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'このステータスではメインのアンチウイルス設定の閾値に基づいて最近検出されたエラーかあるかどうかをチェックします。';
$string['check_antivirus_error'] = '過去 {$a->lookback} に {$a->errors} 件のエラーが検出されました。';
$string['check_antivirus_info'] = '現在、アンンチウイルススキャナは有効にされていません。';
$string['check_antivirus_logstore_not_supported'] = '選択されたログストアのタイプではアンチウイルススキャナの状態を確認できません。';
$string['check_antivirus_name'] = 'アンチウイルス';
$string['check_antivirus_ok'] = '{$a->scanners} アンチウイルススキャナは有効にされています。過去 {$a->lookback} に問題は検出されていません。';
$string['check_configrw_details'] = '<p>ウェブサーバからファイルが修正されないようインストール後に<code>config.php</code>のファイルパーミッションを変更することをお勧めします。この方法はサーバのセキュリティを著しく向上させるものではありませんが一般的なセキュリティ上の弱点を抑制したり制限することはできます。</p>';
$string['check_configrw_name'] = '書き込み可能なconfig.php';
$string['check_configrw_ok'] = 'PHPスクリプトはconfig.phpを修正することができません。';
$string['check_configrw_warning'] = 'PHPスクリプトはconfig.phpを修正することができます。';
$string['check_cookiesecure_details'] = '<p>https通信が有効にされた場合、セキュアクッキーの送信を有効にすることをお勧めします。また、httpからhttpsへのパーマネントリダイレクトを設定してください。理想的には同時にHSTSヘッダも送信してください。</p>';
$string['check_cookiesecure_error'] = 'セキュアクッキーを有効にしてください。';
$string['check_cookiesecure_http'] = 'あなたがセキュアクッキーを使用するにはhttpsを有効にする必要があります。';
$string['check_cookiesecure_name'] = 'セキュアクッキー';
$string['check_cookiesecure_ok'] = 'セキュアクッキーは有効にされています。';
$string['check_crawlers_details'] = '<p>Googleに公開する設定ではサーチエンジンがコースにゲストとしてログインできるようにします。ゲストログインが許可されていない場合、この設定の有効化は意味を持ちません。</p>';
$string['check_crawlers_error'] = 'サーチエンジンによるゲストアクセスは許可されていますが、ゲストアクセスは無効にされています。';
$string['check_crawlers_info'] = 'サーチエンジンはゲストとして入ることができます。';
$string['check_crawlers_name'] = 'Googleに公開する';
$string['check_crawlers_ok'] = 'サーチエンジンによるアクセスは有効にされていません。';
$string['check_defaultuserrole_details'] = '<p>すべてのログインユーザにはデフォルトユーザロールのケイパビリティが付与されます。このロールに危険なケイパビリティが許可されていないことを確認してください。デフォルトユーザロールでサポートされるレガシータイプは「認証済みユーザ」のみです。コース表示ケイパビリティは有効にすべきではありません。</p>
<p>自動データ削除リクエスト承認 (tool_dataprivacy | automaticdatadeletionapproval) オプションが有効されていることを確認してください。ユーザは大量データ削除の可能性のある削除を要求できます。</p>';
$string['check_defaultuserrole_error'] = 'デフォルトユーザロール「 {$a} 」は正しくない定義です!';
$string['check_defaultuserrole_name'] = 'すべてのユーザのデフォルトロール';
$string['check_defaultuserrole_notset'] = 'デフォルトロールが設定されていません。';
$string['check_defaultuserrole_ok'] = 'すべてのユーザのデフォルトロール定義はOKです。';
$string['check_dirindex_info'] = 'ディレクトリインデックスは有効にしないでください。';
$string['check_displayerrors_details'] = '<p>いくつかのエラーメッセージはあなたのサーバに関する機密情報を漏洩する可能性があるためPHP設定<code>display_errors</code>の有効化は実運用サイトではお勧めできません。</p>';
$string['check_displayerrors_error'] = 'PHPエラー表示設定が有効にされています。この設置を無効にすることをお勧めします。';
$string['check_displayerrors_name'] = 'PHPエラーを表示する';
$string['check_displayerrors_ok'] = 'PHPエラー表示は無効にされています。';
$string['check_dotfiles_info'] = '/.well-known/*を除くすべてのドットファイルは公開しないでください。';
$string['check_emailchangeconfirmation_details'] = '<p>ユーザがプロファイルでメールアドレスを変更する場合、メール確認ステップが推奨されています。無効にされている場合、スパム送信者がサーバをスパム送信に悪用する恐れがあります。</p>
<p>メールアドレスフィールドが認証プラグインからロックされている場合、この可能性をここで考える必要はありません。</p>';
$string['check_emailchangeconfirmation_error'] = 'ユーザはどのようなメールアドレスでも入力することができます。';
$string['check_emailchangeconfirmation_info'] = 'ユーザは許可されたドメインのみのメールアドレスを入力することができます。';
$string['check_emailchangeconfirmation_name'] = 'メール変更確認';
$string['check_emailchangeconfirmation_ok'] = 'ユーザプロファイル内のメールアドレス変更は確認されるべきです。';
$string['check_embed_details'] = '<p>無制限のオブジェクト埋め込みは非常に危険です - すべての登録ユーザは他のサーバに対してXSSアタックを開始することができます。この設定は実稼動サーバでは無効にしてください。</p>';
$string['check_embed_error'] = '無制限のオブジェクト埋め込みが許可されています - これは大部分のサーバで非常に危険な設定です。';
$string['check_embed_name'] = 'EMBEDおよびOBJECTを許可する';
$string['check_embed_ok'] = '無制限のオブジェクト埋め込みは許可されていません。';
$string['check_frontpagerole_details'] = '<p>すべての登録ユーザのサイトホーム活動にはデフォルトのサイトホームロールのケイパビリティが割り当てられます。このロールにリスクのあるケイパビリティが許可されているかどうか確認してください。</p>
<p>この目的のため、特別なロールを作成してレガシタイプのロールは使用しないことをお勧めします。</p>';
$string['check_frontpagerole_error'] = '正しくないサイトホームロール「 {$a} 」の割り当てが検出されました!';
$string['check_frontpagerole_name'] = 'サイトホームロール';
$string['check_frontpagerole_notset'] = 'サイトホームロールが設定されていません。';
$string['check_frontpagerole_ok'] = 'サイトホームロール定義はOKです。';
$string['check_guestrole_details'] = '<p>ゲストロールはゲストに使用され、ログインユーザおよび一時的なゲストコースアクセスには使用されません。このロールにリスクのあるケイパビリティが許可されているかどうか確認してください。</p>
<p>ゲストロールでサポートされているレガシタイプのロールは「ゲスト」のみです</p>';
$string['check_guestrole_error'] = 'ゲストロール「 {$a} 」の定義は正しくありません!';
$string['check_guestrole_name'] = 'ゲストロール';
$string['check_guestrole_notset'] = 'ゲストロールが設定されていません。';
$string['check_guestrole_ok'] = 'ゲストロール定義はOKです。';
$string['check_mediafilterswf_details'] = '<p>自動swf埋め込みは非常に危険です - すべての登録ユーザは他のサーバに対してXSSアタックを開始することができます。この設定は実稼動サーバでは無効にしてください。</p>';
$string['check_mediafilterswf_error'] = 'Flashメディアフィルタが許可されています - これは大部分のサーバで非常に危険な設定です。';
$string['check_mediafilterswf_name'] = '.swfメディアフィルタ有効化';
$string['check_mediafilterswf_ok'] = 'Flashメディアフィルタが有効にされていません。';
$string['check_nodemodules_details'] = '<p>ディレクトリ「 <code>{$a->path}</code> 」はNode.jsモジュールおよび一般的にNPMユーティリティによってインストールされる依存関係を含みます。これらのモジュールはgruntフレームワークを使用するようなローカルのMoodleの開発に必要です。これらのためにMoodleサイトを実運用する必要はありません。また、あなたのサイトをリモート攻撃にさらす潜在的に危険なコードを含むことができてしまいます。</p><p>サイトにパブリックURLからアクセスできる場合、ディレクトリを削除することを強くお勧めします。またはあなたのウェブサーバ設定で少なくともディレクトリへのウェブアクセスを禁止してください。</p>';
$string['check_nodemodules_info'] = 'node_modulesディレクトリはパブリックサイトに存在すべきではありません。';
$string['check_nodemodules_name'] = 'Node.jsモジュールディレクトリ';
$string['check_openprofiles_details'] = 'ユーザプロファイルを公開した場合、スパム送信者が不正利用することができます。「プロファイル閲覧時にユーザのログインを強制する」または「ユーザのログインを強制する」を有効にすることをお勧めします。';
$string['check_openprofiles_error'] = 'ログインなしで誰でもユーザプロファイルを閲覧できます。';
$string['check_openprofiles_name'] = 'ユーザプロファイルを公開する';
$string['check_openprofiles_ok'] = 'ユーザプロファイルを閲覧するにはログインが必要です。';
$string['check_passwordpolicy_details'] = '<p>パスワードの推測は不正アクセスを取得するための頻繁に使われる簡単な方法であるため、パスワードポリシーの設定をお勧めします。ユーザがパスワードを記憶できなかったり、忘れたり、書き留めたりすることがありますので必要条件を厳格にしすぎないでください。</p>';
$string['check_passwordpolicy_error'] = 'パスワードポリシーが設定されていません。';
$string['check_passwordpolicy_name'] = 'パスワードポリシー';
$string['check_passwordpolicy_ok'] = 'パスワードポリシーが有効にされています。';
$string['check_preventexecpath_details'] = '<p>管理画面による実行可能パス設定を許可することにより権限昇格の可能性が生じます。</p>これはconfig.phpで次のように強制されるべきです:</p><p><code>$CFG->preventexecpath = true;</code></p>';
$string['check_preventexecpath_name'] = '実行可能パス';
$string['check_preventexecpath_ok'] = '実行可能パスはconfig.phpのみで設定することができます。';
$string['check_preventexecpath_warning'] = '実行可能パスは管理画面で設定することができます。';
$string['check_publicpaths_403'] = '(戻り値403は理想的には404であるべきです)';
$string['check_publicpaths_generic'] = '{$a} ファイルは公開しないでください。';
$string['check_publicpaths_name'] = 'すべての公開およびプライベートパスをチェックする';
$string['check_publicpaths_ok'] = 'すべての内部パスは外部からアクセスできません。';
$string['check_publicpaths_warning'] = '内部パスの一部に外部からアクセスできます。';
$string['check_riskadmin_detailsok'] = '<p>次のシステム管理者一覧を確認してください:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>次のシステム管理者一覧を確認してください。:</p>{$a->admins}
<p>システムコンテクストのみへの管理者ロール割り当てをお勧めします。次のユーザはサポートされない管理者ロールが他のコンテクストで割り当てられています:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = '管理者';
$string['check_riskadmin_ok'] = '{$a} 名のサーバ管理者が登録されています。';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) ロール割り当てをレビューする</a>';
$string['check_riskadmin_warning'] = '{$a->admincount} 名のサーバ管理者および {$a->unsupcount} 名のサポートされない管理者ロールの割り当てが見つかりました。';
$string['check_riskbackup_details_overriddenroles'] = '<p>これらのアクティブなオーバーライドはバックアップ内にユーザデータを含むことができる能力をユーザに与えます。このパーミッションが本当に必要かどうか確認してください。</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>現在、以下のシステムロールはバックアップ内にユーザデータを含むことをユーザに許可しています。このパーミッションが本当に必要かどうか確認してください。</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>上記のロールまたはローカルオーバーライドのため以下のユーザアカウントは現在コースに登録しているユーザの個人情報を含むバックアップを作成できるパーミッションを持っています。これらのユーザが (a)信用されて (b)強度の高いパスワードで守られていることを確認してください:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'ユーザデータのバックアップを明確に許可しているロールはありません。しかし、「doanything」ケイパビリティを持った管理者はまだユーザデータをバックアップできることに留意してください。';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->contextname} 内の {$a->name}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'ユーザデータのバックアップ';
$string['check_riskbackup_ok'] = 'ユーザデータのバックアップを明確に許可しているロールはありません。';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->contextname} 内の {$a->fullname} ({$a->email})</a>';
$string['check_riskbackup_warning'] = 'ユーザデータをバックアップできる {$a->rolecount} 件のロール、{$a->overridecount} 件のオーバーライドおよび {$a->usercount} 名のユーザが見つかりました。';
$string['check_riskxss_details'] = '<p>RISK_XSSは信頼されるユーザのみ使用できるすべての危険なケイパビリティを意味します。</p>
<p>以下のユーザ一覧を閲覧した後、このサーバにおいてあなたがこれらのユーザを完全に信頼できることを確認してください:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS信頼ユーザ';
$string['check_riskxss_warning'] = 'RISK_XSS - {$a} 名の信頼できるユーザが見つかりました。';
$string['check_unsecuredataroot_details'] = '<p>datarootディレクトリはウェブからアクセスできないようにしてください。ウェブからアクセスできないディレクトリを使用する最良の方法はパブリックウェブディレクトリ外のディレクトリを使用することです。</p>
<p>あなたがディレクトリを移動した場合、それに応じて<code>config.php</code>の<code>$CFG->dataroot</code>設定を変更してください。</p>';
$string['check_unsecuredataroot_error'] = 'あなたのdatarootディレクトリ <code>{$a}</code> は正しくない場所に配置されてウェブで晒された状態です!';
$string['check_unsecuredataroot_name'] = '安全ではないdataroot';
$string['check_unsecuredataroot_ok'] = 'datarootディレクトリはウェブからアクセスできないようにしてください。';
$string['check_unsecuredataroot_warning'] = 'あなたのdatarootディレクトリ「 <code>{$a}</code> 」は正しくない場所に配置されウェブに晒された状態です。';
$string['check_vendordir_details'] = '<p>ディレクトリ「 <code>{$a->path}</code> 」は様々なサードパーティライブラリおよび一般的にPHPコンポーザによってインストールされる依存関係を含みます。PHPUnitフレームワークのインストールのようなローカルのMoodle開発に必要であると思われます。これらのためにMoodleサイトを実運用する必要はありません。また、あなたのサイトをリモート攻撃にさらす潜在的に危険なコードを含むことができてしまいます。</p><p>サイトにパブリックURLからアクセスできる場合、ディレクトリを削除することを強くお勧めします。またはあなたのウェブサーバ設定で少なくともディレクトリへのウェブアクセスを禁止してください。</p>';
$string['check_vendordir_info'] = 'vendorディレクトリはパブリックサイトに存在すべきではありません。';
$string['check_vendordir_name'] = 'ベンダディレクトリ';
$string['check_webcron_details'] = '<p>ウェブブラウザでcronを実行することにより匿名ユーザに機密情報を晒すことができてしまいます。そのため、コマンドラインによるcronを実行するか、リモートアクセスにcronにパスワードを設定することをお勧めします。</p>';
$string['check_webcron_name'] = 'ウェブcron';
$string['check_webcron_ok'] = '匿名ユーザはcronにアクセスできません。';
$string['check_webcron_warning'] = '匿名ユーザはcronにアクセスできます。';
$string['configuration'] = '設定';
$string['description'] = '説明';
$string['details'] = '詳細';
$string['eventreportviewed'] = '閲覧済みセキュリティチェックレポート';
$string['issue'] = '問題';
$string['pluginname'] = 'セキュリティチェック';
$string['privacy:metadata'] = 'セキュリティ概要プラグインはいかなる個人データも保存しません。';
$string['security:view'] = 'セキュリティレポートを表示する';
$string['timewarning'] = 'データ処理には長時間を要します。しばらくお待ちください ...';
