<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'pt_br', version '4.3'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuspagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página sobre nós. Este texto também será usado como texto de link para a página sobre nós se você configurar a \'Posição do link Sobre nós\' adequadamente.';
$string['activityiconcoloradministrationsetting'] = 'Cor do ícone de atividade para "Administração"';
$string['activityiconcoloradministrationsetting_desc'] = 'Cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorassessmentsetting'] = 'Cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorassessmentsetting_desc'] = 'A cor do ícone da atividade para "Avaliação"';
$string['activityiconcolorcollaborationsetting'] = 'Cor do ícone da atividade para "Colaboração"';
$string['activityiconcolorcollaborationsetting_desc'] = 'A cor do ícone da atividade para "Colaboração';
$string['activityiconcolorcommunicationsetting'] = 'Cor do ícone da atividade para "Comunicação"';
$string['activityiconcolorcommunicationsetting_desc'] = 'A cor do ícone da atividade para "Comunicação"';
$string['activityiconcolorcontentsetting'] = 'Cor do ícone da atividade para "Conteúdo"';
$string['activityiconcolorcontentsetting_desc'] = 'A cor do ícone de atividade para "Conteúdo"';
$string['activityiconcolorinterfacesetting'] = 'Cor do ícone de atividade para "Interface"';
$string['activityiconcolorinterfacesetting_desc'] = 'A cor do ícone de atividade para "Interface"';
$string['activityiconcolorsheading'] = 'Cores dos ícones de atividades';
$string['activitynavigationsetting_desc'] = 'Com esta configuração, os elementos para saltar para a atividade/recurso anterior e seguinte, bem como o menu suspenso para saltar para uma atividade/recurso distinto, são exibidos. Além disso, nos cursos que utilizam o modo \'uma seção por página\', também são exibidos elementos semelhantes para a seção anterior e seguinte. Elementos de UI como este já existiam no Boost no Moodle Core até o Moodle 3.11, mas foram removidos no 4.0. Com o Boost Union, você pode trazê-los de volta.';
$string['activitypurposecontent'] = 'Conteúdo';
$string['addpreferredlangsetting_desc'] = 'Com esta configuração, você pode adicionar uma configuração \'Definir idioma preferido\' ao menu de idiomas no menu do usuário. Compreensivelmente, esta configuração só será processada se a configuração <a href="{$a->url1}">Exibir menu de idioma</a> estiver ativada e se pelo menos <a href="{$a->url2} ">um segundo pacote de idioma é instalado</a> e <a href="{$a->url3}">oferecido para seleção</a>.';
$string['blockregionfooterwidth'] = 'Largura da região do bloco para a região \'Rodapé\'';
$string['blockregionfooterwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Rodapé\'. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionoutsidebottomwidth'] = 'Largura da região do bloco para a região \'Externa (inferior)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (inferior)\' que é mostrada abaixo do conteúdo principal. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionoutsideleftwidth'] = 'Largura da região do bloco para a região \'Externa (esquerda)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (esquerda)\' que é mostrada no lado esquerdo da área de conteúdo principal. Por padrão, Boost Union usa uma largura de 300px. Você pode inserir outros valores baseados em pixels, como 200px, mas também pode inserir um valor percentual, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsiderightwidth'] = 'Largura da região do bloco para a região \'Externa (direita)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (direita)\' que é mostrada no lado direito da área de conteúdo principal. Por padrão, Boost Union usa uma largura de 300px. Você pode inserir outros valores baseados em pixels, como 200px, mas também pode inserir um valor percentual, como 10%, ou um valor de largura da janela de visualização, como 10vw.';
$string['blockregionoutsidetopwidth'] = 'Largura da região do bloco para a região \'Externa (superior)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Com esta configuração, você pode definir a largura da região do bloco \'Externo (topo)\' que é mostrada no topo da página. Você pode escolher entre largura total, largura do conteúdo do curso e largura do herói.';
$string['blockregionsforlayout'] = 'Regiões de bloco adicionais para layout \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Com esta configuração, você pode ativar regiões de bloco adicionais para o layout \'{$a}\'.';
$string['blockregionsheading_desc'] = '<p>Boost Union fornece um grande número de regiões de bloco adicionais que podem ser usadas para adicionar e mostrar blocos em toda a página Moodle:</p> <ul><li>As <em>regiões de bloco externas</em> são colocado em todos os quatro lados da página Moodle. Eles podem ser usados para mostrar blocos que acompanham a página Moodle mostrada, mas não pertencem diretamente ao conteúdo principal.</li> <li>A <em>região do bloco de cabeçalho</em> é colocada entre a área externa (superior). e a área de conteúdo principal. Ele pode ser usado para mostrar um bloco como informação de cabeçalho do curso.</li> <li>As <em>regiões do bloco de conteúdo</em> são colocadas diretamente acima e abaixo do conteúdo principal na área de conteúdo principal. Eles podem ser usados para adicionar blocos ao fluxo de conteúdo do curso.</li> <li>As <em>regiões de blocos de rodapé</em> são colocadas na parte inferior da página, entre a área externa (inferior) e a nota de rodapé. Você tem três regiões de rodapé disponíveis para construir colunas, se necessário.</li> <li>A <em>região de bloco fora da tela</em> é de alguma forma especial, pois paira sobre toda a página do Moodle como uma gaveta. A gaveta é aberta pelo ícone de 9 pontos no lado direito da barra de navegação. Você tem três regiões fora da tela disponíveis para construir colunas, se necessário.</li></ul> <p>Observação:</p> <ul><li>Por padrão, todas as regiões de bloco adicionais estão desativadas. Ative as regiões de bloqueio específicas nos layouts de página específicos de acordo com suas necessidades. Tente ser o mais focado possível: muitas regiões de bloqueio podem sobrecarregar os usuários finais.</li> <li>Assim que uma região de bloqueio adicional for ativada, ela ficará visível para todos os usuários autenticados e poderá ser editada por professores e gerentes (dependendo de o fato de um determinado usuário ter permissão para editar a página específica do Moodle, é claro). Mas também existem recursos theme/boost_union:viewregion* e theme/boost_union:editregion* que permitem ajustar o uso de cada região de bloco de acordo com suas necessidades.</li> <li>O Exterior (esquerda), Exterior (direita), conteúdo (superior), conteúdo (inferior) e regiões de bloco de cabeçalho não estão disponíveis para todos os layouts de página.</li></ul>';
$string['breadcrumbsheading'] = 'Breadcrumbs';
$string['choosereadme'] = '<p>O tema Boost Union é um tema filho do Boost que tem como objetivo, por um lado, tornar o Boost simplesmente mais configurável e, por outro lado, fornecer recursos adicionais úteis para a operação diária do Moodle de administradores, professores e estudantes.</p><p>Boost Union é mantido por<br />Moodle an Hochschulen e.V.,</p><p>em cooperação com<br />lern.link GmbH </p><p>juntamente com<br />bdecent GmbH</p>';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Conteúdo';
$string['contactcontentsetting_desc'] = 'Nesta configuração, você pode adicionar conteúdo rich text que será mostrado em uma página de contato (que não é a mesma que a página integrada de \'Contato com o suporte do site\' do Moodle).';
$string['contactlinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de contato deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['contactpagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de contato. Este texto também será usado como texto de link para a página de contato se você configurar a \'Posição do link da página de contato\' adequadamente.';
$string['courseheaderimageenabled_desc'] = 'Quando ativado, a imagem do curso (que pode ser carregada nas configurações do curso) é exibida no cabeçalho do curso. As imagens dos cursos são mostradas ali, além da página \'Meus cursos\', onde são sempre mostradas.';
$string['emailbrandinginstructionli1'] = 'Vá para a <a href="{$a->url}" target="_blank">página de configurações de personalização de idioma</a> para abrir o pacote de idiomas <em>{$a->lang}</em> para edição.';
$string['emailbrandingtextdemobody'] = 'O corpo do e-mail começa aqui.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu. Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra. O corpo do e-mail termina aqui.';
$string['enablefooterbutton_desc'] = 'Com "rodapé" entende-se o círculo que contém o ponto de interrogação na parte inferior da página.<br />Ao clicar, o usuário é apresentado a uma sobreposição. Dependendo da configuração do site, o Moodle mostra vários links (como "Documentação para esta página" ou "Resumo de retenção de dados") nesta sobreposição.<br />Com esta configuração, você pode controlar se deseja mostrar ou suprimir o botão de rodapé na parte inferior da página.';
$string['faviconheading_desc'] = 'Observação: o Boost Union tem seu próprio upload de favicon e não usa o favicon da <a href="{$a}">configuração de favicon do núcleo do Moodle</a>.<br />O Boost Union especialmente permite que você substitua o upload favicon dentro de seus sabores.';
$string['flavoursdeleteconfirmation'] = 'Você realmente deseja excluir o sabor <em>{$a}</em>?';
$string['footersuppresschatsetting'] = 'Suprimir o link \'Bate-papo com participantes do curso\'';
$string['footersuppresschatsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link \'Bate-papo com participantes do curso\' no rodapé. Caso contrário, esse link apareceria nos cursos assim que uma sala de comunicação fosse adicionada às configurações do curso.';
$string['footersuppresscontactsetting'] = 'Suprimir o link \'Entre em contato com o suporte do site\'';
$string['footersuppresscontactsetting_desc'] = 'Com essa configuração, você pode suprimir totalmente o link ‘Entre em contato com o suporte do site’ no rodapé. Caso contrário, esse link apareceria se o <a href="{$a->url}">link de contato com o suporte do site</a> estivesse definido.';
$string['footersuppressfeedbacksetting'] = 'Suprimir o link \'Enviar comentários sobre este software\'';
$string['footersuppressfeedbacksetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link ‘Enviar feedback sobre este software’ no rodapé. Caso contrário, este link apareceria se a configuração <a href="{$a->url}">feedback sobre este software</a> estivesse ativada.';
$string['footersuppresshelpsetting'] = 'Suprimir link \'Documentação para esta página\'';
$string['footersuppresshelpsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link ‘Documentação para esta página’ no rodapé. Caso contrário, este link apareceria se uma <a href="{$a->url}">raiz do documento Moodle Docs</a> fosse definida.';
$string['footersuppresspoweredsetting'] = 'Suprimir link \'Powered by Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link \'Powered by Moodle\' no rodapé. Caso contrário, este link mostraria a informação de que este site está executando o Moodle e forneceria um link para o Moodle HQ.';
$string['footersuppressservicessetting'] = 'Suprimir link \'Serviços e suporte\'';
$string['footersuppressservicessetting_desc'] = 'Com esta configuração, você pode suprimir totalmente o link ‘Serviços e suporte’ no rodapé. Caso contrário, este link mostraria o <a href="{$a->url}">link de serviços e suporte</a> para os administradores.';
$string['footersuppressstandardfooter'] = 'Suprimir a saída do rodapé pelo plugin {$a}';
$string['footersuppressstandardfooter_desc'] = 'Com esta configuração, você pode suprimir totalmente a saída do rodapé pelo plugin \'{$a}\'. Plugins (mesmo que sejam fornecidos com o núcleo do Moodle, mas ainda sejam tecnicamente plugins) podem adicionar conteúdo adicional ao rodapé implementando uma função específica. Este plugin implementou esta função e pode adicionar conteúdo ao rodapé em determinadas circunstâncias.';
$string['footersuppressusertoursetting'] = 'Suprimir o link "Redefinir tour do usuário nesta página"';
$string['footersuppressusertoursetting_desc'] = 'Com essa configuração, você pode suprimir totalmente o link ‘Redefinir tour do usuário nesta página’ no rodapé. Caso contrário, este link forneceria a possibilidade de redefinir um tour do usuário em uma página específica.';
$string['footnotesetting_desc'] = 'Tudo o que você adicionar a esta área de texto será exibido no final de uma página, no rodapé (não no rodapé flutuante) em todas as páginas que utilizam os layouts "gavetas", "colunas2" ou "login". O conteúdo nesta área pode ser, por exemplo, os direitos de autor, os termos de utilização ou o nome da sua organização. <br/> Se quiser remover a nota de rodapé novamente, basta esvaziar a área de texto.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Problemas do GitHub</a>
theme_boost_union/githubissueslink';
$string['helplinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de ajuda deve ser adicionado automaticamente à página do Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['helppagetitlesetting_desc'] = 'Nesta configuração você pode definir o título da página de ajuda. Este texto também será usado como texto de link para a página de ajuda se você configurar a \'Posição do link da página de ajuda\' adequadamente.';
$string['hidenodesprimarynavigationsetting_desc'] = 'Com esta configuração, você pode ocultar um ou vários nós da navegação primária.<br /><br /> Observação: aqui, você pode simplesmente remover os nós de navegação. Mas se você quiser adicionar nós de navegação personalizados, considere usar a <a href="{$a->url}">funcionalidade do menu inteligente do Boost Union</a>.';
$string['imprintlinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de impressão deve ser adicionado automaticamente à página do Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['imprintpagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de impressão. Este texto também será usado como texto de link para a página de impressão se você configurar a \'Posição do link de impressão\' adequadamente.';
$string['infobannerbsclasssetting'] = 'Banner de informações {$a->no} Classe Bootstrap';
$string['infobannerbsclasssetting_desc'] = 'Com esta configuração, você pode selecionar o estilo Bootstrap com o qual o banner de informações {$a->no} deve ser exibido. Se você escolher a opção \'Sem cor do Bootstrap\', o banner de informações será exibido sem nenhuma cor específica do Bootstrap, o que lhe dá a liberdade de estilizar o banner por conta própria no editor de rich text.';
$string['infobannercontentsetting'] = 'Conteúdo do banner informativo {$a->no}';
$string['infobannercontentsetting_desc'] = 'Aqui você insere as informações que devem ser mostradas no banner de informações {$a->no}.';
$string['infobannerdismissconfirm'] = 'Você realmente deseja redefinir a visibilidade do banner informativo {$a->no} e quer mostrá-lo novamente para todos os usuários que o dispensaram?';
$string['infobannerdismissfail'] = 'A redefinição de visibilidade do banner de informações {$a->no} falhou para pelo menos um usuário';
$string['infobannerdismissiblesetting'] = 'Banner informativo {$a->no} dispensável';
$string['infobannerdismissiblesetting_desc'] = 'Com esta configuração, você pode tornar o banner informativo {$a->no} dispensável. Se o usuário clicar no botão x no banner de informações, o banner ficará permanentemente oculto para esse usuário. A visibilidade não é redefinida automaticamente, mesmo se você alterar o conteúdo do banner de informações. Se quiser redefinir a visibilidade do banner de informações, clique no botão \'Redefinir visibilidade\' abaixo.';
$string['infobannerdismissresetbutton'] = 'Redefinir a visibilidade do banner de informações {$a->no}';
$string['infobannerdismisssuccess'] = 'A visibilidade do banner informativo {$a->no} foi redefinida';
$string['infobannerenabledsetting'] = 'Ativar banner de informações {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Com esta configuração, você pode ativar o banner de informações {$a->no}.';
$string['infobannerendsetting'] = 'Banner de informações {$a->no} horário de término';
$string['infobannerendsetting_desc'] = 'Com esta configuração você pode definir até quando o banner informativo {$a->no} deve ser exibido. A hora configurada é interpretada como hora do servidor e não como hora do usuário.';
$string['infobannerheading'] = 'Banner de informações {$a->no}';
$string['infobannermodesetting'] = 'Modo de exibição do banner de informações {$a->no}';
$string['infobannermodesetting_desc'] = 'Com esta configuração você pode definir se o banner informativo {$a->no} deve ser um banner perpétuo (que é sempre mostrado) ou um banner com controle de tempo (que só é mostrado dentro do intervalo de tempo configurado)';
$string['infobannerordersetting'] = 'Banner de informações {$a->no} posição do pedido';
$string['infobannerordersetting_desc'] = 'Com esta configuração você define a posição de ordem do banner informativo {$a->no}. Por padrão, os banners de informações são ordenados de cima para baixo, como você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de pedido a dois ou mais banners informativos, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['infobannerpagessetting'] = 'Layouts de página para exibir o banner de informações {$a->no}';
$string['infobannerpagessetting_desc'] = 'Com esta configuração, você pode selecionar os layouts de página nos quais o banner informativo {$a->no} deve ser exibido.';
$string['infobannerstartsetting'] = 'Banner de informações {$a->no} horário de início';
$string['infobannerstartsetting_desc'] = 'Com esta configuração você pode definir a partir de quando o banner informativo {$a->no} deve ser exibido. A hora configurada é interpretada como hora do servidor e não como hora do usuário.';
$string['loginbackgroundimagetextsetting_desc'] = 'Com esta configuração opcional você pode adicionar texto, por exemplo. um aviso de direitos autorais para as imagens de fundo enviadas. Este texto aparecerá no topo do rodapé da página de login. No entanto, por motivos de espaço da tela, ele só é mostrado em telas maiores.<br/> Cada linha consiste no identificador do arquivo (o nome do arquivo), o texto que deve ser exibido e a cor do texto, separados por uma barra vertical . Cada declaração precisa ser escrita em uma nova linha. <br/> Por exemplo:<br/> background-image-1.jpg|Copyright: CC0|dark<br/> Como cor do texto, você pode usar os valores "dark" ou "light".<br /> Você pode declarar textos para uma quantidade arbitrária de imagens de fundo de login enviadas. Os textos serão adicionados apenas às imagens que correspondam ao nome do arquivo com o identificador declarado nesta configuração.';
$string['loginformheading'] = 'Formulário de login';
$string['loginformpositionsetting_left'] = 'Alinhado a Esquerda';
$string['loginidpshowintrosetting_desc'] = 'Com esta configuração, você controla se a introdução <em>\'{$a}\'</em> é mostrada acima dos botões de login do IDP ou não. Por padrão, a introdução é mostrada e os usuários serão rapidamente informados sobre o que são os botões IDP. Se você desabilitar esta configuração, a introdução do IDP ficará oculta. Isso permite que você forneça uma interface de login de usuário limpa se você usar apenas provedores de identidade externos como OAuth2 ou OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Observação: assim que você ocultar o formulário de login local, você corre o risco de os administradores não conseguirem mais fazer login com uma conta local se houver um problema com o provedor de identidade externo. Para permitir logins locais nesses casos, uma <a href="{$a->url}">página de login local de entrada lateral</a> é fornecida. Nesta página de login local de entrada lateral, todas as medidas de segurança de login do Moodle também se aplicam.';
$string['loginlocalloginlocalnotdisabled'] = 'O login local está habilitado no formulário de login padrão. Não há necessidade de fazer login nesta página de login local aqui. Por favor, use a <a href="{$a->url}">página de login padrão</a> para fazer login.';
$string['loginlocalshowintrosetting_desc'] = 'Com esta configuração, você controla se uma introdução <em>\'{$a}\'</em> é mostrada acima do formulário de login local ou não. Por padrão, a introdução não é mostrada. Mas se você habilitá-lo, esta introdução poderá ajudar os usuários a entender quais credenciais usar no formulário de login local, especialmente se você fornecer mais de um método de login ou se tiver alterado a ordem dos métodos de login.';
$string['logosheading_desc'] = 'Observação: Boost Union tem seu próprio upload de logotipo e não usa o logotipo da <a href="{$a}">configuração de logotipo do núcleo do Moodle</a>.<br />Boost Union especialmente permite que você carregue mais imagens formatos que o núcleo do Moodle permite e permite que você substitua os logotipos carregados em seus sabores.';
$string['maintenancelinkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página de informações de manutenção deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['maintenancepagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página de informações de manutenção. Este texto também será usado como texto de link para a página de informações de manutenção se você configurar a \'Posição do link da página de informações de manutenção\' adequadamente.';
$string['markbrokenlinkssetting_desc'] = 'Adiciona um ícone de "cadeia quebrada" na frente dos links quebrados (que levam a arquivos de rascunho carregados que não foram processados adequadamente) e marca o link na cor do bootstrap como "perigo". Em contraste com as configurações "Marcar links externos" e "Marcar links mailto", não há possibilidade de limitar o escopo desta configuração, pois marcar links quebrados é um indicador de que algo está quebrado e precisa ser corrigido manualmente.';
$string['markexternallinkssetting_desc'] = 'Adiciona um ícone de "link externo" após links externos (que levam o usuário a um alvo fora do Moodle).';
$string['markmailtolinkssetting_desc'] = 'Adiciona um ícone de "envelope" na frente dos links mailto.';
$string['mobilecss_overwrite'] = 'Assim que você adicionar qualquer código CSS a esta configuração e salvá-la, a <a href="{$a->url}">configuração principal do Moodle <em>mobilecssurl</em></a> será automaticamente substituída com uma URL do tema Boost Union. Atualmente esta configuração está definida como <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Assim que você adicionar qualquer código CSS a esta configuração e salvá-la, a <a href="{$a->url}">configuração principal do Moodle <em>mobilecssurl</em></a> será definida automaticamente para um URL do tema Boost Union.';
$string['modiconnamefail'] = 'Este arquivo foi carregado na pasta correta para a atividade <em>{$a}</em>, mas o nome do arquivo não é válido. Por favor, altere o nome do arquivo para <em>monologo.svg</em> / <em>monologo.png</em> (para ícones do Moodle 4) ou para <em>icon.svg</em> / <em>icon .png</em> (para ícones legados do Moodle 3).';
$string['offerspagetitlesetting_desc'] = 'Nesta configuração você pode definir o título da página de ofertas. Este texto também será usado como texto de link para a página de ofertas se você configurar a \'Posição do link de ofertas\' adequadamente.';
$string['outsideregionsplacement_desc'] = 'Com esta configuração, você pode controlar se, em telas maiores, as regiões de bloco \'Externo (esquerda)\' e \'Externo (direita)\' devem ser colocadas perto da área de conteúdo principal ou perto das bordas da janela.';
$string['outsideregionsplacementnearwindowedges'] = 'Exibir regiões \'Externa (esquerda)\' e \'Externa (direita)\' próximas às bordas da janela';
$string['outsideregionsplacementnextmaincontent'] = 'Exibir regiões \'Externa (esquerda)\' e \'Externa (direita)\' próximas à área de conteúdo principal';
$string['page1pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 1. Este texto também será usado como texto do link para a página genérica 1 se você configurar a \'Posição do link da página genérica 1\' adequadamente.';
$string['page2linkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página genérica 2 deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['page2pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 2. Este texto também será usado como texto do link para a página genérica 2 se você configurar a \'Posição do link da página genérica 2\' adequadamente.';
$string['page3linkpositionsetting_desc'] = 'Nesta configuração você pode configurar se um link para a página genérica 3 deve ser adicionado automaticamente à página Moodle. Se você não quiser mostrar um link automaticamente, você pode adicionar um link para {$a->url} de qualquer lugar do Moodle manualmente.';
$string['page3pagetitlesetting_desc'] = 'Nesta configuração, você pode definir o título da página genérica 3. Este texto também será usado como texto do link para a página genérica 3 se você configurar a \'Posição do link da página genérica 3\' adequadamente.';
$string['pluginname'] = 'Boost Union';
$string['privacy:metadata'] = 'O tema Boost Union não armazena nenhum dado pessoal sobre nenhum usuário.';
$string['resourcescachecontrolnote'] = 'Observe que os arquivos são enviados para o navegador com o cabeçalho \'Cache-Control\' definido, que informa ao navegador para armazenar o arquivo em cache. Se tiver certeza de que não alterará o arquivo em um futuro próximo, você poderá usar o URL persistente para vincular ao arquivo. No entanto, se você planeja modificar um arquivo, mas mantém o mesmo nome de vez em quando, você deve usar o URL revisado e vincular novamente o arquivo onde o usou sempre que atualizar o arquivo para evitar que os navegadores mostrem o cache versões desatualizadas do arquivo.';
$string['showhintcourseguestaccessgeneral'] = 'No momento, você está visualizando este curso como <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Para ter acesso total ao curso, você pode <a href="{$a->url}">inscrever-se neste curso</a>.';
$string['showhintcoursehiddengeneral'] = 'Este curso está atualmente <strong>oculto</strong>. Somente professores inscritos podem acessar este curso quando oculto.';
$string['showhintcoursehiddensettingslink'] = 'Você pode alterar a visibilidade nas <a href="{$a->url}">configurações do curso</a>.';
$string['showhintcourseselfenrolfrom'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita a partir de {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita de {$a->from} até {$a->until}.';
$string['showhintcourseselfenrolsince'] = 'A instância de inscrição <strong>{$a->name}</strong> permite atualmente a autoinscrição irrestrita.';
$string['showhintcourseselfenrolsinceuntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita até {$a->until}.';
$string['showhintcourseselfenrolunlimited'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita indefinidamente.';
$string['showhintcourseselfenroluntil'] = 'A instância de inscrição <strong>{$a->name}</strong> permite a autoinscrição irrestrita até {$a->until}.';
$string['shownavbarstarredcourses_config'] = 'Definir cursos marcados com estrela na página \'Meus cursos\'';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Por padrão, na <a href="{$a}">página de gerenciamento do curso</a>, o Moodle exige que você abra os detalhes do curso ou passe pelas configurações do curso antes de clicar em um elemento adicional da UI para visualizá-lo. o curso. Ao ativar esta configuração, você pode adicionar um ícone “Ver curso” diretamente à listagem de categorias na página de gerenciamento do curso.';
$string['slidebackgroundimagealtsetting'] = 'Slide {$a->no} atributo alternativo da imagem de fundo';
$string['slidebackgroundimagealtsetting_desc'] = 'Aqui você pode definir um atributo alt para a imagem do slide {$a->no}. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir um atributo alt. Observe que não fornecer um atributo alt reduz a acessibilidade.';
$string['slidebackgroundimagesetting'] = 'Imagem de fundo do slide {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Aqui você pode fazer upload de um arquivo de imagem que será mostrado como imagem de fundo atrás do conteúdo do slide {$a->no}. Certifique-se ou verifique se o conteúdo ainda pode ser lido na imagem de fundo. Tente também certificar-se de que a proporção das imagens de fundo de todos os slides seja igual (já que a proporção da imagem de fundo controla a altura do slide e você pode querer evitar oscilações quando os slides são alterados). Esta é uma configuração obrigatória, o slide não será mostrado se você não fizer upload de nenhuma imagem de fundo.';
$string['slidecaptionsetting'] = 'Legenda do slide {$a->no}';
$string['slidecaptionsetting_desc'] = 'Aqui você insere a legenda que deverá ser exibida no slide {$a->no}. A legenda é exibida na parte inferior central do slide. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir uma legenda.';
$string['slidecontentsetting'] = 'Slide {$a->no} conteúdo';
$string['slidecontentsetting_desc'] = 'Aqui você insere o conteúdo que deverá ser exibido no slide {$a->no}. O conteúdo é exibido na parte inferior central do slide. Se uma legenda for definida, o conteúdo será exibido abaixo da legenda. Observe que o editor de rich text produz texto alinhado à esquerda por padrão, mas você pode querer alterá-lo para texto centralizado para uma aparência mais agradável. Evite também adicionar muito conteúdo ao slide e teste-o em dispositivos pequenos, pois o conteúdo que ultrapassar o slide será simplesmente ocultado. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir nenhum conteúdo.';
$string['slidecontentstylesetting'] = 'Estilo de conteúdo do slide {$a->no}';
$string['slidecontentstylesetting_desc'] = 'Aqui você pode modificar o estilo do conteúdo do slide {$a->no}. Por padrão, o estilo do conteúdo é uma fonte de cor branca para imagens de fundo escuro. No entanto, para permitir um estilo fácil e consistente em todos os tipos de imagens de fundo, você pode substituir o estilo aqui. Observe que esta configuração anulará a cor da fonte que você definiu no editor de rich text acima em qualquer caso.';
$string['slideenabledsetting'] = 'Habilitar slide {$a->no}';
$string['slideenabledsetting_desc'] = 'Com esta configuração, você pode ativar o slide {$a->no}.';
$string['slideheading'] = 'Slide {$a->no}';
$string['slidelinksetting'] = 'Slide {$a->no} link URL';
$string['slidelinksetting_desc'] = 'Aqui, você pode definir uma URL (interna ou externa do Moodle) à qual o conteúdo do slide {$a->no} será vinculado. Esta é uma configuração opcional, o slide será mostrado mesmo se você não definir um URL de link.';
$string['slidelinksourcesetting'] = 'Fonte do link do slide {$a->no}';
$string['slidelinktargetsetting'] = 'Slide {$a->no} link alvo';
$string['slidelinktargetsetting_desc'] = 'Aqui, você pode definir o destino do link que será definido para o link do slide assim que você definir um URL de link no slide {$a->no}.';
$string['slidelinktitlesetting'] = 'Título do link do slide {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Aqui, você pode definir um título de link que será apresentado como dica de ferramenta assim que o usuário passar o mouse sobre o slide {$a->no}. Esta é uma configuração opcional, o slide será vinculado mesmo se você não definir um título para o link. Observe que não fornecer um título de link diminui a acessibilidade.';
$string['slideordersetting'] = 'Slide {$a->no} posição do pedido';
$string['slideordersetting_desc'] = 'Com esta configuração você define a posição da ordem do slide {$a->no}. Por padrão, os slides são ordenados conforme você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de ordem a dois ou mais slides, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['slideranimationsetting_desc'] = 'Com esta configuração, você controla a animação do controle deslizante. \'Slide\' aplica uma animação deslizante, \'Fade\' aplica uma animação esmaecida e \'None\' remove todas as animações.';
$string['slideranimationsetting_slide'] = 'Slide';
$string['sliderfrontpagepositionsetting_desc'] = 'O controle deslizante é mostrado apenas na página inicial do site. Com essa configuração, você controla se o controle deslizante é exibido antes do conteúdo inicial do site ou depois do conteúdo inicial do site. Se você quiser mostrar apenas o controle deslizante na página inicial do site e nada mais, todos os outros conteúdos da página inicial do site poderão ser removidos alterando as <a href="{$a->url}">configurações da página inicial do site</a>.';
$string['sliderindicatornavsetting'] = 'Ativar a navegação do indicador deslizante';
$string['sliderridesetting_desc'] = 'Com esta configuração, você controla o comportamento do ciclo do controle deslizante. \'No carregamento da página\' começa a percorrer os slides após o término do carregamento da página, \'Após a interação\' começará a circular depois que um usuário interagir com o controle deslizante. \'Nunca\' desativa totalmente o ciclo automático de slides, exigindo a entrada do usuário para percorrer os slides.';
$string['sliderwrapsetting'] = 'Percorrer continuamente os slides';
$string['smartmenusbycohort'] = 'By cohort';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'A lista de itens do menu de cursos dinâmicos conterá todos os cursos do usuário que correspondem ao status de conclusão selecionado. Por exemplo, se você selecionar \'Em andamento\' como status de conclusão, a lista de itens do menu de cursos dinâmicos conterá apenas os cursos nos quais o usuário atual está trabalhando.';
$string['smartmenusmenudescription_help'] = 'A descrição do cardápio. Isto será usado principalmente como documentação interna, mas você também pode exibi-lo no menu usando a opção ‘Mostrar descrição’.';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenupresentationheader'] = 'Apresentação do Menu';
$string['switchedroleto'] = 'Você está visualizando este curso atualmente com o papel: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Posição da imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Com esta configuração, você controla o posicionamento da imagem de fundo dentro do contêiner do bloco de anúncio {$a->no}. O primeiro valor é a posição horizontal, o segundo valor é a posição vertical.';
$string['tilebackgroundimagesetting'] = 'Imagem de fundo do bloco de anúncio {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Aqui, você pode fazer upload de um arquivo de imagem que será mostrado como imagem de fundo atrás do conteúdo do bloco de anúncio {$a->no}. Certifique-se ou verifique se o conteúdo ainda pode ser lido na imagem de fundo. Esta é uma configuração opcional, o bloco de anúncio funcionará mesmo se você não carregar nenhuma imagem de fundo.';
$string['tilecontentsetting'] = 'Bloco de anúncio {$a->no} conteúdo';
$string['tilecontentstylesetting_desc'] = 'Aqui você pode modificar o estilo do conteúdo do bloco de anúncio {$a->no}. Por padrão, o estilo do conteúdo é controlado pelo estilo definido no editor de rich text acima. No entanto, para permitir um estilo fácil e consistente, especialmente ao usar texto em imagens de fundo, você pode substituir o estilo aqui.';
$string['tileenabledsetting'] = 'Ativar bloco de anúncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Com esta configuração, você pode ativar o bloco de anúncio {$a->no}.';
$string['tilefrontpagepositionsetting_desc'] = 'Os blocos de anúncios são exibidos apenas na página inicial do site. Com essa configuração, você controla se os blocos de anúncios serão exibidos antes do conteúdo inicial do site ou depois do conteúdo inicial do site. Se você quiser mostrar apenas os blocos de anúncios na página inicial do site e nada mais, todos os outros conteúdos da página inicial do site poderão ser removidos alterando as <a href="{$a->url}">configurações da página inicial do site</a>.';
$string['tileheading'] = 'Bloco de anúncio {$a->no}
theme_boost_union/tileheading';
$string['tilelinksetting'] = 'URL do link do bloco de anúncio {$a->no}';
$string['tilelinksetting_desc'] = 'Aqui, você pode definir uma URL (interna ou externa do Moodle) que será oferecida como botão de link no final do bloco de anúncio {$a->no}. Esta é uma configuração opcional, o bloco de anúncio funcionará mesmo se você não definir nenhum URL de link.';
$string['tilelinktargetsetting'] = 'Bloco de anúncio {$a->no} link target';
$string['tilelinktargetsetting_desc'] = 'Aqui, você pode definir o destino do link definido para o botão do link assim que definir um URL de link no bloco de anúncio {$a->no}.';
$string['tilelinktitlesetting'] = 'Título do link do bloco de anúncio {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Aqui, você pode definir um título de link que será usado como rótulo do botão de link assim que você definir um URL de link no bloco de anúncio {$a->no}. Observe que se você definir um URL de link, mas não definir um título para o link, o botão do link será rotulado apenas como \'Link\'.';
$string['tileordersetting'] = 'Bloco de anúncio {$a->no} posição do pedido';
$string['tileordersetting_desc'] = 'Com esta configuração, você define a posição de ordem do bloco de anúncio {$a->no}. Por padrão, os blocos de anúncios são ordenados de cima para baixo e da esquerda para a direita, como você os vê nesta página de configurações aqui. No entanto, você pode decidir atribuir outra posição de pedido com esta configuração. Se você atribuir a mesma posição de pedido a dois ou mais blocos de anúncios, eles serão ordenados novamente de acordo com a ordem nesta página de configurações.';
$string['tiletitlesetting'] = 'Título do bloco de anúncio {$a->no}';
$string['tiletitlesetting_desc'] = 'Aqui, você insere o título que deve ser exibido no bloco de anúncio {$a->no}. Esta é uma configuração opcional, o bloco de anúncio será mostrado mesmo se você não definir um título.';
$string['upgradenotice_2022080922_copied'] = 'O <strong>{$a}</strong> existente nas configurações principais do Moodle foi copiado para a configuração Boost Union {$a} durante esta atualização. Verifique novamente o resultado.';
$string['upgradenotice_2022080922_notcopied'] = 'A configuração <strong>{$a}</strong> em Boost Union está vazia agora. Se você quiser usar um {$a} dentro do Boost Union a partir de agora, basta carregá-lo na configuração Boost Union {$a} mais tarde.';
