<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'pt_br', version '4.3'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Sobre mim';
$string['actingasrole'] = 'Você está atualmente acessando com outro papel';
$string['activatetemplateoverride'] = 'Ativar a substituição do template para \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'Quando marcado, o valor na configuração \'{$a->setting}\' será usado como template \'{$a->template}\' se tiver texto.';
$string['activebreadcrumb'] = 'Cor de fundo para o item ativo na navegação estrutural';
$string['activebreadcrumbdesc'] = 'Definir a cor de fundo para o item ativo e o restante da barra de navegação estrutural.';
$string['activitiesheading'] = 'Atividades';
$string['alertaccess'] = 'Visibilidade do alerta';
$string['alertaccessadmins'] = 'Visível para administradores';
$string['alertaccessdesc'] = 'Defina o tipo de restrição de acesso para a visibilidade da caixa de alerta. Nota: se estiver usando "Adicionar restrição de campo de perfil personalizado", será necessário adicionar valores para os campos de perfil abaixo.';
$string['alertaccessglobal'] = 'Visível para todos';
$string['alertaccessprofile'] = 'Adicionar restrição ao campo de perfil personalizado';
$string['alertaccessusers'] = 'Visível para usuários autenticados';
$string['alertannounce'] = 'Anúncio';
$string['alertannouncedesc'] = 'Exibir um anúncio no alerta.';
$string['alertbackgroundcolorinfo'] = 'Cor de fundo para Informação';
$string['alertbackgroundcolorinfodesc'] = 'Cor de fundo dos alertas do tipo Informação.';
$string['alertbackgroundcolorsuccess'] = 'Cor de fundo de Anúncio';
$string['alertbackgroundcolorsuccessdesc'] = 'Cor de fundo dos alertas do tipo Anúncio.';
$string['alertbackgroundcolorwarning'] = 'Cor de fundo de Aviso';
$string['alertbackgroundcolorwarningdesc'] = 'Cor de fundo dos alertas do tipo Aviso.';
$string['alertbordercolorinfo'] = 'Cor de borda de Informação';
$string['alertbordercolorinfodesc'] = 'Cor da borda dos alertas do tipo Informação.';
$string['alertbordercolorsuccess'] = 'Cor de borda de Anúncio';
$string['alertbordercolorsuccessdesc'] = 'Cor da borda dos alertas do tipo Anúncio.';
$string['alertbordercolorwarning'] = 'Cor da borda de Aviso';
$string['alertbordercolorwarningdesc'] = 'Cor da borda dos alertas do tipo Aviso.';
$string['alertcolorinfo'] = 'Cor de Informação';
$string['alertcolorinfodesc'] = 'Cor do ícone dos alertas do tipo Informação.';
$string['alertcolorsheading'] = 'Cores e ícone do alerta';
$string['alertcolorsuccess'] = 'Cor de Anúncio';
$string['alertcolorsuccessdesc'] = 'Cor do ícone dos alertas do tipo Anúncio.';
$string['alertcolorwarning'] = 'Cor de Aviso';
$string['alertcolorwarningdesc'] = 'Cor do ícone dos alertas do tipo Aviso.';
$string['alertcount'] = 'Contagem de alertas';
$string['alertcountdesc'] = 'O número de alertas a serem mostrados na área de edição abaixo';
$string['alertdesc'] = 'Digite e personalize um texto a ser exibido no topo do site como um alerta. É possível definir mais de um alerta para segmentar diferentes tipos de usuários.';
$string['alertdisabled'] = 'Desabilitado';
$string['alertdisabledesc'] = 'Desabilitar este alerta.';
$string['alerthiddencourse'] = 'Ocultar alertas no curso';
$string['alerthiddencoursedesc'] = 'Avisar os professores que os cursos estão ocultos.';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'clique aqui para atualizar as configurações';
$string['alerthiddencoursetext-start'] = 'Este curso está oculto e não pode ser acessado pelos estudantes,';
$string['alerticoninfo'] = 'Ícone de Informação';
$string['alerticoninfodesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Informação. Digite o nome do ícone sem o prefixo fa-.';
$string['alerticonsuccess'] = 'Ícone de Anúncio';
$string['alerticonsuccessdesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Anúncio. Digite o nome do ícone sem o prefixo fa-.';
$string['alerticonwarning'] = 'Ícone de Aviso';
$string['alerticonwarningdesc'] = 'Defina o <a href="http://fortawesome.github.io/Font-Awesome/icons/">Ícone do Font Awesome</a> que será utilizado nas caixas de alerta do tipo Aviso. Digite o nome do ícone sem o prefixo fa-.';
$string['alertinfo'] = 'Informação';
$string['alertinfodesc'] = 'Exibir informações no alerta.';
$string['alertkeyvalue'] = 'Chave de alerta';
$string['alertkeyvalue_details'] = 'A chave que identifica este alerta. Você só precisa alterar isso se quiser mostrar o mesmo alerta novamente, ou seja, o conteúdo não mudou ou já foi usado antes. Observação: As alterações de formatação não contam como uma mudança no conteúdo.';
$string['alertprofilefield'] = 'Campo de perfil personalizado nome=valor (opcional)';
$string['alertprofilefielddesc'] = 'Adicionar regra de acesso usado para campo de perfil personalizado, por exemplo: usertype=student';
$string['alertsettings'] = 'Alerta {$a}';
$string['alertsettingscourse'] = 'Configurações de Alertas do Curso';
$string['alertsettingsgeneral'] = 'Configurações Gerais de Alertas';
$string['alertsettingsheading'] = 'Alertas';
$string['alerttext'] = 'Texto de Alerta';
$string['alerttextdesc'] = 'Digite o texto para exibir na caixa de alerta';
$string['alerttype'] = 'Tipo de alerta';
$string['alerttypedesc'] = 'Selecione o tipo de alerta: informação (azul), aviso (amarelo) ou anúncio (verde).';
$string['alertwarning'] = 'Aviso';
$string['alertwarningdesc'] = 'Exibir um aviso no alerta.';
$string['analyticscount'] = 'Contagem do Analytics';
$string['analyticscountdesc'] = 'O número de campos de análise a serem mostrados na área de edição abaixo.';
$string['analyticsprofilefield'] = 'Nome do campo de perfil personalizado=valor (opcional)';
$string['analyticsprofilefielddesc'] = 'Adicionar regra de acesso usando campo de perfil personalizado, por exemplo: usertype=student';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsdesc'] = 'Você pode configurar vários códigos para o Google Analytics e atribuí-los aos campos do perfil do usuário. Ou você pode usar o Matomo, o analytics de código aberto.';
$string['analyticssettingsheading'] = 'Configurar o Google Analytics e / ou o Matomo';
$string['analyticstext'] = 'ID do Analytics';
$string['analyticstextdesc'] = 'Digite o ID do Google Analytics';
$string['anonymizega'] = 'Tornar anônimo o IP do usuário';
$string['anonymizegadesc'] = 'Tornar anônimo o envio de IP do usuário para o Google Analytics';
$string['backcolor'] = 'Cor do fundo';
$string['backcolordesc'] = 'Selecione a cor do fundo.';
$string['bcustyle'] = 'Estilo BCU';
$string['blockbackgroundcolor'] = 'Cor de fundo do bloco.';
$string['blockbackgroundcolordesc'] = 'Defina a cor de fundo para todos os blocos.';
$string['blockbordercolor'] = 'Cor da borda do bloco';
$string['blockbordercolordesc'] = 'Defina a cor da borda do bloco.';
$string['blockheaderbackgroundcolor'] = 'A cor de fundo do titulo do bloco';
$string['blockheaderbackgroundcolordesc'] = 'Defina a cor de fundo do cabeçalho de todos os blocos.';
$string['blockheaderborderbottom'] = 'Espessura da borda inferior do cabeçalho do bloco';
$string['blockheaderborderbottomdesc'] = 'Definir a espessura da borda inferior dos cabeçalhos de bloco';
$string['blockheaderborderleft'] = 'Espessura da borda esquerda do cabeçalho do bloco';
$string['blockheaderborderleftdesc'] = 'Definir a espessura da borda esquerda dos cabeçalhos de bloco';
$string['blockheaderborderright'] = 'Espessura da borda direita do cabeçalho do bloco';
$string['blockheaderborderrightdesc'] = 'Definir a espessura da borda direita dos cabeçalhos de bloco';
$string['blockheaderbordertop'] = 'Espessura da borda superior do cabeçalho do bloco';
$string['blockheaderbordertopdesc'] = 'Define a espessura da borda superior dos cabeçalhos de bloco';
$string['blockheaderbordertopstyle'] = 'Estilo da borda dos cabeçalhos de blocos';
$string['blockheaderbordertopstyledesc'] = 'Definir o estilo da borda dos cabeçalhos de bloco';
$string['blockheaderbottomradius'] = 'Raio inferior do cabeçalho do bloco';
$string['blockheaderbottomradiusdesc'] = 'Defina o raio do bloco de cabeçalho inferior para obter um efeito curvo/arredondado';
$string['blockheadercolor'] = 'Cor da fonte do cabeçalho do bloco';
$string['blockheadercolordesc'] = 'Defina a cor da fonte do cabeçalho do bloco.';
$string['blockheadertopradius'] = 'Raio superior do cabeçalho do bloco';
$string['blockheadertopradiusdesc'] = 'Definir o raio do bloco de cabeçalho superior para obter um efeito curvo/arredondado.';
$string['blockicons'] = 'Ícones de bloco';
$string['blockiconsdesc'] = 'Defina isto para mostrar ícones de bloco na área de cabeçalho do bloco.';
$string['blockiconsheadersize'] = 'Tamanho dos ícones dos cabeçalhos de blocos';
$string['blockiconsheadersizedesc'] = 'Definir o tamanho do ícone da fonte usada no cabeçalho dos blocos moodle. Selecione um valor na lista.';
$string['blocklayoutbuilder'] = 'Regiões de bloqueio da página inicial';
$string['blocklayoutbuilderdesc'] = 'Abaixo, você pode criar seu próprio layout para regiões de blocos na página inicial.<br/>Para adicionar conteúdo a essas regiões, você precisará <strong> ativar a edição na página inicial do Moodle</strong>.<br/>Em seguida você pode começar a arrastar/soltar blocos nas regiões que criar!';
$string['blocklayoutlayoutcheck'] = 'Verifique seu layout';
$string['blocklayoutlayoutcheckdesc'] = 'Use a ferramenta abaixo para verificar o número de blocos que você usou e ver uma representação de seu novo layout.';
$string['blocklayoutlayoutcount1'] = 'Você pode definir um máximo de';
$string['blocklayoutlayoutcount2'] = 'regiões de bloco. Você está usando atualmente:';
$string['blocklayoutlayoutrow'] = 'Linha da região de bloco';
$string['blocklayoutlayoutrowdesc'] = 'Adicionar / definir o layout para a linha de região de bloco na página principal.';
$string['blockmainborderbottom'] = 'Espessura da borda inferior do bloco principal';
$string['blockmainborderbottomdesc'] = 'Definir a espessura da borda inferior da área do bloco principal.';
$string['blockmainborderleft'] = 'Espessura da borda esquerda do bloco principal';
$string['blockmainborderleftdesc'] = 'Definir a espessura da borda esquerda da área do bloco principal.';
$string['blockmainborderright'] = 'Espessura da borda direita do bloco principal';
$string['blockmainborderrightdesc'] = 'Definir a espessura da borda direita da área do bloco principal';
$string['blockmainbordertop'] = 'Espessura da borda superior do bloco principal';
$string['blockmainbordertopdesc'] = 'Define a espessura da borda superior da área principal do bloco.';
$string['blockmainbordertopstyle'] = 'Estilo de borda principal do bloco';
$string['blockmainbordertopstyledesc'] = 'Define o estilo da borda da área de conteúdo do bloco.';
$string['blockmainbottomradius'] = 'Raio inferior do bloco principal';
$string['blockmainbottomradiusdesc'] = 'Define o raio inferior da área principal do bloco para obter um efeito curvo/arredondado.';
$string['blockmaintopradius'] = 'Raio superior do bloco principal';
$string['blockmaintopradiusdesc'] = 'Defina o raio superior da área principal do bloco para obter um efeito curvo/arredondado.';
$string['blockregionbackground'] = 'Cor de fundo da região do bloco';
$string['blockregionbackgrounddesc'] = 'Cor de fundo do componente que contém layouts de bloco personalizados na página principal';
$string['blockshowhide'] = 'Mostrar / ocultar o bloco';
$string['blockside'] = 'Localização dos Blocos';
$string['blocksidedesc'] = 'Controla se os blocos aparecem à esquerda ou à direita da página.';
$string['breadcrumb'] = 'Trilha de navegação';
$string['breadcrumbbackgroundcolor'] = 'Cor de fundo da trilha de navegação';
$string['breadcrumbbackgroundcolordesc'] = 'Definir a cor de fundo da trilha de navegação.';
$string['breadcrumbdisplay'] = 'Mostrar a trilha de navegação';
$string['breadcrumbdisplaydesc'] = 'Definir o que deve ser exibido na trilha de navegação de um curso.';
$string['breadcrumbhome'] = 'Início da trilha de navegação';
$string['breadcrumbhomedesc'] = 'Exibe o início da trilha de navegação como um ícone ou como um texto.';
$string['breadcrumbhomeicon'] = 'Ícone';
$string['breadcrumbhometext'] = 'Texto';
$string['breadcrumbseparator'] = 'Separador de trilha de navegação';
$string['breadcrumbseparatordesc'] = 'Defina os "<a href="{$a}" target="_blank">Ícones do Font Awesome</a>" a serem usados como separador de itens na trilha de navegação. Insira o nome do ícone sem o prefixo "fa-".';
$string['breadcrumbtextcolor'] = 'Cor do texto da trilha de navegação';
$string['breadcrumbtextcolordesc'] = 'Definir a cor do texto da trilha de navegação';
$string['breadcrumbtitle'] = 'Nome do curso na trilha de navegação';
$string['breadcrumbtitledesc'] = 'Definir o modo de exibição do nome do curso na trilha de navegação';
$string['bs4all'] = 'Extra Pequeno - Extra Grande';
$string['bs4extralarge'] = 'Somente Extra Grande';
$string['bs4large'] = 'Grande - Extra grande';
$string['bs4medium'] = 'Médio - Extra grande';
$string['bs4none'] = 'Nenhum';
$string['bs4small'] = 'Pequeno - Extra grande';
$string['buttoncolor'] = 'Cor do Botão';
$string['buttoncolorcancel'] = 'Cor do botão cancelar';
$string['buttoncolordesc'] = 'A cor dos principais botões usados em todo o site.';
$string['buttoncolordesccancel'] = 'Cor de fundo do botão cancelar.<br />Coloque \'transparent\' para deixá-lo transparente.';
$string['buttoncolordescscnd'] = 'A cor dos botões secundários utilizada em todo o site.';
$string['buttoncolorscnd'] = 'Cor do botão secundário';
$string['buttondesc'] = 'Altere a aparência dos botões usados neste tema.';
$string['buttondropshadow'] = 'Sombra na parte inferior do botão';
$string['buttondropshadowdesc'] = 'Mostre uma sombra (sombreamento) na parte inferior do botão.';
$string['buttonfocuscolor'] = 'Cor do foco do botão';
$string['buttonfocuscolordesc'] = 'A cor que o botão usa ao focar no botão.';
$string['buttonfocuscoloropacity'] = 'Opacidade da cor do foco do botão';
$string['buttonfocuscoloropacitydesc'] = 'A opacidade que o botão usa para a cor ao focar no botão.';
$string['buttonhovercolor'] = 'Cor do botão (quando receber foco)';
$string['buttonhovercolorcancel'] = 'Cor do botão cancelar (quando receber foco)';
$string['buttonhovercolordesc'] = 'A cor do botão quando você passar o mouse sobre ele.';
$string['buttonhovercolordesccancel'] = 'A cor do botão Cancelar quando você passar o mouse sobre ele. Digite transparente na caixa para transparência.';
$string['buttonhovercolordescscnd'] = 'a cor do botão secundário quando você passar o mouse sobre ele';
$string['buttonhovercolorscnd'] = 'Cor do botão secundário (quando receber foco)';
$string['buttonlogincolor'] = 'Cor do botão de login';
$string['buttonlogincolordesc'] = 'A cor do botão de Login.';
$string['buttonloginheight'] = 'Definir a altura para o botão de login';
$string['buttonloginheightdesc'] = 'Funciona somente se estiver usando um formulário de login no cabeçalho superior';
$string['buttonloginhovercolor'] = 'Cor do botão de login quando selecionado';
$string['buttonloginhovercolordesc'] = 'A cor do botão de login ao passar o mouse';
$string['buttonloginmargintop'] = 'Definir a margem superior para o botão de login';
$string['buttonloginmargintopdesc'] = 'Permite alterar o espaçamento/posicionamento do botão de login.';
$string['buttonloginpadding'] = 'Definir margem interna para o botão Entrar';
$string['buttonloginpaddingdesc'] = 'Número maior = botão maior.';
$string['buttonlogintextcolor'] = 'Cor do texto do botão de login';
$string['buttonlogintextcolordesc'] = 'A cor do texto usado no botão de login.';
$string['buttonradius'] = 'Definir o raio do botão';
$string['buttonradiusdesc'] = 'Raio maior = botões curvados, raio menor = botões quadrados.';
$string['buttonsettings'] = 'Botões';
$string['buttonsettingsheading'] = 'Personalizar os botões deste tema.';
$string['buttontextcolor'] = 'Cor de texto do botão';
$string['buttontextcolorcancel'] = 'Cor do texto do botão cancelar';
$string['buttontextcolordesc'] = 'A cor do texto usada nos botões';
$string['buttontextcolordesccancel'] = 'A cor do texto usado nos botões de cancelamento.';
$string['buttontextcolordescscnd'] = 'A cor do texto usada nos botões secundários.';
$string['buttontextcolorscnd'] = 'Cor do texto do botão secundário';
$string['cachedef_adaptablefontawesomeiconmapping'] = 'Cache dos ícones do Font Awesome';
$string['categoryhavecustomheader'] = 'Cabeçalho personalizado da categoria';
$string['categoryhavecustomheaderdesc'] = 'Selecione as categorias de nível superior que terão um cabeçalho personalizado. Para selecionar mais de uma ou desmarcar uma categoria, use a tecla \'Ctrl\'. Salve e atualize a página para atualizar Nota: As subcategorias das selecionadas herdarão os valores das configurações.';
$string['categoryheaderbgimage'] = 'Imagem de fundo da Categoria  \'{$a->name}\' com id \'{$a->id}\'';
$string['categoryheaderbgimagedesc'] = 'Definir uma imagem de fundo para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' no cabeçalho. O tamanho mínimo é 1600x180px (1900x 180px recomendado). A imagem cobrirá o cabeçalho completo.';
$string['categoryheaderbgimagedescchildren'] = 'Definir uma imagem de fundo para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' e seus filhos \'{$a->children}\' no cabeçalho. O tamanho mínimo é 1600x180px (1900x180px recomendado). A imagem cobrirá o cabeçalho completo.';
$string['categoryheadercustomcss'] = 'CSS personalizado da Categoria  \'{$a->name}\' com id \'{$a->id}\'';
$string['categoryheadercustomcssdesc'] = 'Definir o CSS personalizado para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\'. Isso irá gerar um CSS para o seletor de temas prefixado com \'.category - {$a->id}\'. Se o CSS não parecer que foi aplicado, verifique o arquivo de log do PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Definir CSS personalizado para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' e seus filhos \'{$a->children}\'. Isso irá gerar CSS para o seletor de temas prefixado com \'.category-{$a->id}\' e para todos os IDs filhos. Se o CSS parecer que não foi aplicado, verifique o arquivo de log do PHP.';
$string['categoryheadercustomtitle'] = 'Título personalizado da Categoria  \'{$a->name}\' com id \'{$a->id}\'';
$string['categoryheadercustomtitledesc'] = 'Definir o título personalizado para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' no cabeçalho. Se estiver em branco, será mostrado o que foi configurado pelas configurações \'sitetitle\' e \'sitetitletext\' em páginas que não são do curso ou nas páginas do curso quando \'enableheading\' estiver \'off\'. Quando preenchido em páginas vinculadas à categoria que não são do curso, isso substituirá o título do site. Quando preenchido nas páginas do curso, aparecerá acima do título, conforme estabelecido pela configuração \'enableheading\'. Porém, em celulares, qualquer \'title\' aparecerá apenas dependendo da configuração \'responsivecoursetitle\'.';
$string['categoryheadercustomtitledescchildren'] = 'Definir o nome personalizado para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' e seus filhos \'{$a->children}\' no cabeçalho. Se estiver em branco, será apresentado o que foi configurado pelas configurações \'sitetitle\' e \'sitetitletext\' em páginas que não são do curso ou nas páginas do curso quando \'enableheading\' estiver \'off\'. Quando preenchido em páginas vinculadas à categoria que não são do curso, isso substituirá o título do site. Quando preenchido nas páginas do curso, aparecerá acima do título, conforme estabelecido pela configuração \'enableheading\'. Porém, em celulares, qualquer \'título/nome\' aparecerá apenas dependendo da configuração \'responsivecoursetitle\'.';
$string['categoryheaderheader'] = 'Configurações para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Define as configurações para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Define as configurações para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' e suas subcategorias.';
$string['categoryheaderlogo'] = 'Logo da Categoria  \'{$a->name}\' com id \'{$a->id}\'';
$string['categoryheaderlogodesc'] = 'Define um logotipo para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' no cabeçalho. O tamanho recomendado é de 200px por 80px.';
$string['categoryheaderlogodescchildren'] = 'Define um logotipo para a categoria de nível superior \'{$a->name}\' com o ID \'{$a->id}\' e suas subcategorias \'{$a->children}\' no cabeçalho. O tamanho recomendado é de 200px por 80px.';
$string['categoryheaderssettings'] = 'Cabeçalhos da categoria';
$string['categoryheaderssettingsdesc'] = 'Defina as configurações para os cabeçalhos dentro de uma categoria.';
$string['categoryheaderssettingsheading'] = 'Altera o cabeçalho para uma ou mais categorias de nível superior e inferior.';
$string['cdefaulticon'] = 'Ícone padrão dos meus cursos';
$string['cdefaulticondesc'] = 'O ícone do Font Awesome sem o prefixo "fa-" a ser usado para cursos que ainda não têm um ícone. Se estiver vazio, será usado o padrão.';
$string['cfrozenicon'] = 'Ícone congelado dos meus cursos';
$string['cfrozenicondesc'] = 'O ícone do Font Awesome sem o prefixo "fa-" a ser usado para cursos congelados. Se estiver vazio, será usado o padrão.';
$string['chiddenicon'] = 'Ícone oculto dos meus cursos';
$string['chiddenicondesc'] = 'O ícone do Font Awesome sem o prefixo "fa-" a ser usado para cursos ocultos. Se estiver vazio, será usado o padrão.';
$string['choosereadme'] = '<div class="clearfix">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
<h3>Sobre</h3>
<p>Adaptable é um tema responsivo e altamente personalizável baseado no popular tema BCU. O Boost é o tema base, que por sua vez utiliza o framework Bootstrap.</p>
<p>O tema é licenciado sob a Licença Pública Geral GNU (GPL) versão 3. Você pode encontrar os detalhes completos "<a href="https://www.gnu.org/licenses/gpl-3.0.html" target="_blank">aqui</a>".</p>
<br>
<h3>Créditos</h3>
<p>Esta versão do tema foi desenvolvida por:<br>
G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).
</p>
<p>Este tema foi desenvolvido anteriormente por:<ul>
<li>Jeremy Hopkins (Universidade de Coventry).</li>
<li>Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>).</li>
<li>Manoj Solanki (Universidade de Coventry).</li>
</ul></p>
<h3>Outros créditos</h3>
<p>Colaboradores para a versão 2:<ul>
<li>G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).</li>
<li>Stuart Lamour.</li>
<li>Alistair Spark (University College London).</li>
</ul><p>entre muitos outros desenvolvedores, testadores, tradutores e voluntários (consulte o arquivo <a href="adaptable/Readme.md" target="_blank">Readme.md</a>).</p>
<br>
<h3>Relatando bugs</h3>
<p>Você pode relatar bugs e melhorias que deseja financiar em nosso "<a href="https://gitlab.com/jezhops/moodle-theme_adaptable/-/issues" target="_blank">repositório</a>".</p>
<br>
<h3>Suporte Técnico</h3>
<p>Você pode fazer suas perguntas no fórum do Moodle:</p>
<ul>
<li>Inglês: <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank">Fórum de temas</a>.</li>
</ul>
</div>';
$string['cneveraccessedicon'] = 'Ícone dos meus cursos nunca acessados';
$string['cneveraccessedicondesc'] = 'O ícone do Font Awesome sem o prefixo "fa-" a ser usado para cursos nos quais o usuário está inscrito, mas não acessou. Se estiver vazio, será usado o padrão.';
$string['collapsedtopicscoloursenabled'] = 'Configurações de cor de fundo e texto para alternar tópicos recolhidos';
$string['collapsedtopicscoloursenableddesc'] = 'Usar configurações de cor de fundo e texto para tópicos recolhidos em vez das configurações "sectionheadingcolor" e "coursesectionheaderbg" do Adaptable.';
$string['colordesc'] = 'Você pode selecionar as cores que gostaria de usar em todo o tema. Use Hex ou qualquer outra notação padrão. Como opção alternativa, você pode usar transparente e herdado como um valor';
$string['colorsettings'] = 'Cores';
$string['colorsettingsheading'] = 'Modificar as cores principais usadas em todo o tema.';
$string['configtabtitle'] = 'Configurações';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Curso';
$string['courseactivitynavigationenabled'] = 'Navegação de atividades';
$string['courseactivitynavigationenableddesc'] = 'Navegação de atividades ativada.';
$string['courseindexitemcolor'] = 'Cor do item';
$string['courseindexitemcolordesc'] = 'A cor do item no "Índice do Curso" em um curso.';
$string['courseindexitemhovercolor'] = 'Cor do item (quando receber foco)';
$string['courseindexitemhovercolordesc'] = 'A cor do item no "Índice do Curso" em um curso (quando receber foco).';
$string['courseindexpageitembgcolor'] = 'Cor de fundo do item da página';
$string['courseindexpageitembgcolordesc'] = 'A cor de fundo do item da página no "Índice do Curso" em um curso.';
$string['courseindexpageitemcolor'] = 'Cor do item da página';
$string['courseindexpageitemcolordesc'] = 'A cor do item da página no "Índice do Curso" em um curso.';
$string['courseindexsettings'] = 'Índice do curso';
$string['courseindexsettingsdesc'] = 'Personalizar o Índice do Curso.';
$string['courseindexsettingsheading'] = 'Configurações do índice do curso';
$string['coursepageactivitybottomblockregionheading'] = 'Região de bloco inferior personalizada da atividade do curso';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Uma região de bloco personalizada que aparece após o final das atividades.';
$string['coursepageblockactivitybottomenabled'] = 'Habilitar região de bloco inferior da atividade na página do curso';
$string['coursepageblockactivitybottomenableddesc'] = 'Habilitar esta região em todas as páginas do curso.';
$string['coursepageblocklayoutbuilder'] = 'Regiões de bloco da página do curso';
$string['coursepageblocklayoutbuilderdesc'] = 'Aqui você pode construir seu próprio layout para as regiões de bloco na página do curso. Para adicionar conteúdo a essas regiões, você precisará ativar a edição na página do curso do Moodle. Em seguida, você pode começar a arrastar/soltar blocos nas regiões que criar!';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Página do Curso - Linha Inferior de Área de Bloco';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Adicione / defina o layout para a linha da região de bloco na página do curso';
$string['coursepageblocklayoutlayouttoprow'] = 'Página do Curso - Linha Superior de Área de Bloco';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Adicionar / definir o layout para linha de área de bloco na página do Curso.';
$string['coursepageblockregionsettings'] = 'Página do Curso - Construtor de Região de Bloco';
$string['coursepageblocksenabled'] = 'Habilitar regiões personalizadas de bloco na página do curso';
$string['coursepageblocksenableddesc'] = 'Você pode habilitar / desabilitar regiões personalizadas de bloco (superior e inferior) na página do curso. Você pode então arrastar e soltar blocos nas regiões que você criou.';
$string['coursepageblocksliderenabled'] = 'Habilitar região de bloco para um slider personalizado na página do curso';
$string['coursepageblocksliderenableddesc'] = 'Habilitar esta região em todas as páginas do curso.';
$string['coursepageheaderhidesitetitle'] = 'Ocultar o título do site nas páginas dos cursos';
$string['coursepageheaderhidesitetitledesc'] = 'Ocultar o título do site, logomarca e barra de busca nas páginas dos cursos. Use em conjunto com a configuração de altura do cabeçalho para mostrar um cabeçalho menor nas páginas dos cursos.';
$string['coursepagenewssliderblockregionheading'] = 'Região de bloco personalizada para slider de notícias';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Uma região de bloco personalizada projetada para uso com o slider de notícias que faz parte do pacote Adaptable UI. Essa região aparece acima das atividades na página do Curso. Para adicionar um bloco slider de notícias, primeiro instale o <strong><a href="https://moodle.org/plugins/block_news_slider">Slider de notícias do Adaptable UI</a></strong> e configure-o para aparecer na região "Página do Curso - Região do slider" em todas as páginas do curso.';
$string['coursepagesidebarinfooterenabled'] = 'Mover a barra lateral para o rodapé na página Curso';
$string['coursepagesidebarinfooterenableddesc'] = 'Mover a barra lateral para o rodapé para ampliar o layout de página do curso.';
$string['coursepagesidebarinfooterenabledsection'] = 'Configurações comuns';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Configurações comuns para a maioria dos formatos de curso.';
$string['courses'] = 'Cursos';
$string['coursesearch'] = 'Buscar curso';
$string['coursesectionactivityassignbgcolor'] = 'Cor de fundo da atividade Tarefa';
$string['coursesectionactivityassignbgcolordesc'] = 'Define a cor de fundo da atividade da Tarefa. Digite <strong>transparente</strong> na caixa para transparência.';
$string['coursesectionactivityassignleftbordercolor'] = 'Atividade Tarefa - cor da borda esquerda';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Definir a cor da borda esquerda.';
$string['coursesectionactivitybordercolor'] = 'Seção do Curso - Cor da Borda Inferior da Atividade';
$string['coursesectionactivitybordercolordesc'] = 'Definir a cor da borda inferior da atividade da seção do curso.';
$string['coursesectionactivityborderstyle'] = 'Seção do Curso - Estilo da Borda Inferior da Atividade';
$string['coursesectionactivityborderstyledesc'] = 'Definir o estilo da borda inferior da atividade da seção do curso.';
$string['coursesectionactivityborderwidth'] = 'Seção do Curso - Largura da Borda Inferior da Atividade';
$string['coursesectionactivityborderwidthdesc'] = 'Definir a largura da borda que aparece na parte inferior de uma atividade da seção do curso.';
$string['coursesectionactivitycolors'] = 'Seção do Curso - Opções da Atividade';
$string['coursesectionactivityforumbgcolor'] = 'Cor de fundo da atividade fórum';
$string['coursesectionactivityforumbgcolordesc'] = 'Define a cor de fundo da atividade do fórum. Digite <strong>transparent</strong> na caixa para transparência.';
$string['coursesectionactivityforumleftbordercolor'] = 'Atividade Fórum - Cor exibida na borda esquerda da atividade';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Define a cor da borda esquerda';
$string['coursesectionactivityheadingcolour'] = 'Seção do Curso - Cor do Título da Atividade';
$string['coursesectionactivityheadingcolourdesc'] = 'A cor das atividades clicáveis exibidas na página principal do curso.';
$string['coursesectionactivityiconsize'] = 'Seção do Curso - Tamanho do Ícone da Atividade';
$string['coursesectionactivityiconsizedesc'] = 'Define o tamanho do ícone para atividades/recursos (por exemplo, um valor de 16px definirá o tamanho como 16px por 16px).';
$string['coursesectionactivityleftborderwidth'] = 'Seção do Curso - Largura da Borda Esquerda da Atividade';
$string['coursesectionactivityleftborderwidthdesc'] = 'Definir a largura da borda que aparece à esquerda de uma atividade na seção do curso.';
$string['coursesectionactivitymarginbottom'] = 'Espaçamento da margem inferior da atividade';
$string['coursesectionactivitymarginbottomdesc'] = 'Espaçamento da margem inferior entre as atividades.';
$string['coursesectionactivitymargintop'] = 'Espaçamento da margem superior da atividade';
$string['coursesectionactivitymargintopdesc'] = 'Espaçamento superior entre atividades.';
$string['coursesectionactivityquizbgcolor'] = 'Cor de fundo da atividade Questionário';
$string['coursesectionactivityquizbgcolordesc'] = 'Define a cor de fundo da atividade do questionário. Digite <strong>transparent</strong> na caixa para transparência.';
$string['coursesectionactivityquizleftbordercolor'] = 'Cor da exibição da borda esquerda da atividade Questionário';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Definir a cor da borda esquerda.';
$string['coursesectionbgcolor'] = 'Seção do curso - Fundo';
$string['coursesectionbgcolordesc'] = 'Definir a cor de fundo da seção do curso';
$string['coursesectionbordercolor'] = 'Seção do Curso - Cor da Borda';
$string['coursesectionbordercolordesc'] = 'Define a cor da borda das seções do curso.';
$string['coursesectionborderradius'] = 'Seção do Curso - Raio da Borda';
$string['coursesectionborderradiusdesc'] = 'Define o raio da borda das seções do curso (cantos arredondados).';
$string['coursesectionborderstyle'] = 'Seção do Curso - Estilo da Borda';
$string['coursesectionborderstyledesc'] = 'Define o estilo da borda das seções do curso.';
$string['coursesectionborderwidth'] = 'Seção do Curso - Largura da borda';
$string['coursesectionborderwidthdesc'] = 'Define a largura da borda das seções do curso.';
$string['coursesectionheaderbg'] = 'Seção do Curso - Fundo do Título';
$string['coursesectionheaderbgdesc'] = 'Define a cor de fundo dos cabeçalhos das seções do curso.';
$string['coursesectionheaderbordercolor'] = 'Seção do Curso - Estilo da Borda do Título';
$string['coursesectionheaderbordercolordesc'] = 'Define a cor da borda do cabeçalho da seção do curso (somente a borda inferior é usada, pois o contêiner externo também tem uma borda).';
$string['coursesectionheaderborderradiusbottom'] = 'Seção do Curso - Raio da Borda Inferior do Título';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Define o raio inferior das bordas do cabeçalho da seção do curso (cantos arredondados).';
$string['coursesectionheaderborderradiustop'] = 'Seção do Curso - Raio da Borda Superior do Título';
$string['coursesectionheaderborderradiustopdesc'] = 'Define o raio superior das bordas do cabeçalho da seção do curso (cantos arredondados).';
$string['coursesectionheaderborderstyle'] = 'Seção do Curso - Estilo da Borda do Título';
$string['coursesectionheaderborderstyledesc'] = 'Define o estilo da borda do cabeçalho da seção do curso (somente a borda inferior é usada, pois o contêiner externo também tem uma borda).';
$string['coursesectionheaderborderwidth'] = 'Seção do Curso - Largura da Borda do Título';
$string['coursesectionheaderborderwidthdesc'] = 'Definir a largura da borda do título da seção do curso (somente a borda inferior é usada porque a estrutura externa também possui borda)';
$string['coursesections'] = 'Seções do Curso';
$string['coursesettings'] = 'Cursos';
$string['coursesettingsdesc'] = 'Personalizar os cursos.';
$string['coursesettingsheading'] = 'Configurações do curso';
$string['coursetitlefullname'] = 'Nome completo do curso';
$string['coursetitlemaxwidth'] = 'Tamanho Máximo do Título do Curso';
$string['coursetitlemaxwidthdesc'] = 'Define o número máximo de caracteres da área do título do curso.';
$string['coursetitleshortname'] = 'Nome breve / Código do Curso';
$string['currentcolor'] = 'Seção Atual do Curso -  Cor de Destaque';
$string['currentcolordesc'] = 'Defina a cor de destaque para a seção atual do curso';
$string['customcoursesubtitle'] = 'Título do curso personalizado';
$string['customcoursesubtitledesc'] = 'Nome do campo personalizado do perfil de usuário para o título do curso.';
$string['customcoursetitle'] = 'Título do curso personalizado';
$string['customcoursetitledesc'] = 'Nome do campo personalizado do perfil de usuário para o título do curso.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Todas as regras CSS adicionadas nesta área de texto serão refletidas em todas as páginas, facilitando a personalização desse tema.';
$string['dangericoncolor'] = 'Cor do ícone de aviso';
$string['dangericoncolordesc'] = 'Definir a cor do ícone de aviso/perigo usado principalmente em campos obrigatórios.';
$string['dashblocklayoutbuilder'] = 'Painel - Regiões de blocos';
$string['dashblocklayoutbuilderdesc'] = 'Abaixo, você pode criar seu próprio layout para regiões de bloco na página Painel.
Para adicionar conteúdo nessas regiões, você precisará <strong>ativar a edição na página de painel do Moodle</strong>.
Então você pode começar a arrastar/soltar blocos nas regiões que criar!';
$string['dashblocklayoutlayoutrow'] = 'Linha de Região de Bloco do Painel';
$string['dashblocklayoutlayoutrowdesc'] = 'Adicionar / definir o layout da linha de região de bloco na página Painel.';
$string['dashblocksabovecontent'] = 'Mostrar acima do conteúdo principal';
$string['dashblocksbelowcontent'] = 'Mostrar abaixo do conteúdo principal';
$string['dashblocksenabled'] = 'Habilitar região de bloco personalizada na página Painel';
$string['dashblocksenableddesc'] = 'Você pode ativar / desativar regiões de bloco personalizadas na página Painel.
Em seguida, você pode arrastar e soltar blocos nas regiões que você criou';
$string['dashblocksposition'] = 'Personalizar a posição da região de bloco';
$string['dashblockspositiondesc'] = 'Quando regiões de bloco personalizadas estiverem habilitadas para a página do painel, escolha a posição.';
$string['dashboardblockregionsettings'] = 'Construtor de Região de Bloco do Painel';
$string['defaultzoom'] = 'Zoom Padrão';
$string['defaultzoomdesc'] = 'Tamanho padrão da tela quando o zoom estiver desabilitado ou o usuário não fez uma escolha. Escolha entre tela cheia e largura fixa.';
$string['disablecustommenu'] = 'Desativar Menus Personalizados';
$string['disablecustommenudesc'] = 'Desativar os menus personalizados do Moodle na barra de navegação (ainda será renderizada em outros temas que você possa ter instalado)';
$string['disabled'] = 'Desabilitado';
$string['disablemenuscoursepages'] = 'Desabilitar os menus nas páginas do curso';
$string['disablemenuscoursepagesdesc'] = 'Ativar esta opção limitará a exibição dos menus principais às páginas do site, à página inicial e ao painel, e não será exibida em nenhuma página de curso';
$string['discardbuttontext'] = 'Cancelar';
$string['displayeditingbuttontext'] = 'Texto do botão Ativar edição';
$string['displayeditingbuttontextdesc'] = 'Mostrar ou ocultar o texto no botão de ativar edição. Nota: Aplica-se apenas ao botão de ativar edição do curso.';
$string['displaygrades'] = 'Mostrar Notas';
$string['displaygradesdesc'] = 'Mostrar o item Notas no menu';
$string['displaylogin'] = 'Tela de Login';
$string['displayloginbox'] = 'Caixa de login';
$string['displayloginbutton'] = 'Botão';
$string['displaylogindesc'] = 'Selecione como exibir a caixa de login no cabeçalho.';
$string['displayloginno'] = 'Sem usuário';
$string['displayparticipants'] = 'Mostrar Participantes';
$string['displayparticipantsdesc'] = 'Mostrar o item Participantes no menu';
$string['dividingline'] = 'Linha divisória no cabeçalho';
$string['dividingline2'] = 'Linha divisória no rodapé';
$string['dividingline2desc'] = 'A cor da linha divisória no rodapé';
$string['dividinglinedesc'] = 'A cor da linha divisória no cabeçalho';
$string['editfont'] = 'Cor da fonte do botão Editar e Personalizar esta página';
$string['editfontdesc'] = 'Definir a cor da fonte do botão Editar e Personalizar esta página';
$string['edithorizontalpadding'] = 'Definir margem interna horizontal dos botões de edição';
$string['editoffbk'] = 'Fundo do botão Ativar edição e Personalizar esta página quando desativados';
$string['editoffbkdesc'] = 'Definir a cor de fundo do botão Ativar edição e Personalizar esta página quando estiverem desativados';
$string['editonbk'] = 'Fundo do botão Ativar edição e Personalizar esta página';
$string['editonbkdesc'] = 'Definir a cor de fundo do botão Ativar edição e Personalizar esta página';
$string['editsettingsbutton'] = 'Editar configurações e exibição do botão';
$string['editsettingsbuttondesc'] = 'Configure aqui o que deve aparecer na barra de navegação para editar as configurações. Observe que essas opções não se aplicam a páginas para as quais não há configurações relacionadas, como a página do painel.';
$string['editsettingsbuttonshowbutton'] = 'Mostrar apenas o botão de edição. Por exemplo. Botão "Ativar edição" na página do curso.';
$string['editsettingsbuttonshowcog'] = 'Mostrar apenas o ícone de configurações de edição (ícone de engrenagem / roda dentada).';
$string['editsettingsbuttonshowcogandbutton'] = 'Mostrar ícone de configurações de edição e engrenagem. Observe que isso ocupa mais espaço na navegação.';
$string['emoticonsize'] = 'Tamanho dos emoticons';
$string['emoticonsizedesc'] = 'Definir a altura e a largura dos emoticons do moodle.';
$string['enablealert'] = 'Habilitar Caixa de Alerta {$a}';
$string['enablealertdesc'] = 'Habilitar Caixa de Alerta {$a}';
$string['enablealerts'] = 'Habilitar / Desabilitar Alertas';
$string['enablealertsdesc'] = 'Habilitar / desabilitar alertas no seu site';
$string['enablealertstriptags'] = 'Retirar automaticamente as tags html dos alertas';
$string['enablealertstriptagsdesc'] = 'Habilitar limpará automaticamente as mensagens de alerta, Desabilitar permitirá que você use html/links nas mensagens, mas você precisará limpar manualmente na visualização html';
$string['enableanalytics'] = 'Habilitar o Google Analytics';
$string['enableanalyticsdesc'] = 'Habilitar as configurações do Google Analytics no seu site Moodle';
$string['enableavailablecourses'] = 'Mostrar "Cursos Disponíveis"';
$string['enableavailablecoursesdesc'] = 'Mostrar o texto "Cursos disponíveis" na página principal';
$string['enablebadges'] = 'Emblemas';
$string['enablebadgesdesc'] = 'Mostrar um link para os emblemas dos usuários';
$string['enableblog'] = 'Habilitar meus Blogs';
$string['enableblogdesc'] = 'Mostrar um link para a página de blogs dos usuários';
$string['enablecalendar'] = 'Calendário do Usuário';
$string['enablecalendardesc'] = 'Mostrar um link para o calendário dos usuários';
$string['enablecompetencieslink'] = 'Link de Competências';
$string['enablecompetencieslinkdesc'] = 'Mostar um link de competências no menu \'Este curso\'. Nota: a configuração \'Habilitar competências\' precisa estar habilitada.';
$string['enablecoursesectionsdesc'] = 'Mostrar um submenu no menu \'Este curso\' contendo links para mostrar cada seção.';
$string['enabledtabbedprofileeditprofilelink'] = 'Ativar link de edição do perfil';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Habilitar o link de edição no perfil com abas. Nota: Quando habilitado, será exibido apenas se o usuário tiver permissão para editar o perfil.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Habilitar link de preferências';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Habilitar link de preferências no perfil com abas';
$string['enableeditprofile'] = 'Editar Perfil';
$string['enableeditprofiledesc'] = 'Mostrar um link para editar o perfil dos usuários';
$string['enableeventsdesc'] = 'Mostrar um link para o calendário';
$string['enablefeed'] = 'Meu Feedback';
$string['enablefeeddesc'] = 'Exibir um link para os usuários da página "Meu feeedback"- Observação: isso requer instalação adicional: <a href="https://moodle.org/plugins/report_myfeedback" target="blank">Plugin My Feedback</a>';
$string['enablegrades'] = 'Notas';
$string['enablegradesdesc'] = 'Mostrar um link para as notas dos usuários';
$string['enableheading'] = 'Cabeçalho - Título do Curso';
$string['enableheadingdesc'] = 'Definir o modo de exibição do título do curso no cabeçalho quando o título padrão do site Moodle estiver habilitado.';
$string['enablehelp'] = 'Link de Ajuda \'{$a->number}\'';
$string['enablehelpdesc'] = 'Adicionar um link de ajuda \'{$a->number}\' na barra de navegação.';
$string['enablehomedesc'] = 'Mostrar um link para a página principal';
$string['enablehomeredirect'] = 'Habilitar Página Inicial redirect=0';
$string['enablehomeredirectdesc'] = '';
$string['enablemenus'] = 'Habilitar Menus';
$string['enablemenusdesc'] = 'É recomendável que você deixe isso desativado, se os menus não estão em uso, por razões de desempenho';
$string['enablemy'] = 'Painel';
$string['enablemydesc'] = 'Mostrar um link para o Painel';
$string['enablemysitesdesc'] = 'Mostrar um menu com os cursos dos usuários';
$string['enablemysitesrestriction'] = 'Restringir o menu de cursos do usuário para um campo personalizado do perfil';
$string['enablemysitesrestrictiondesc'] = 'Restringir o menu suspenso de cursos do usuário por um campo de perfil personalizado. Por exemplo. usertype=staff';
$string['enablenavbarwhenloggedout'] = 'Habilitar barra de navegação quando estiver desconectado';
$string['enablenavbarwhenloggedoutdesc'] = 'Mostra a barra de navegação mesmo quando desconectado. Limitado apenas ao menu Ajuda e Ferramentas.';
$string['enablenote'] = 'Minhas Notificações';
$string['enablenotedesc'] = 'Mostrar um link para a página de notificações do usuário';
$string['enableposts'] = 'Meus Posts';
$string['enablepostsdesc'] = 'Mostrar um link para a página Meus Posts';
$string['enablepref'] = 'Minhas Preferências';
$string['enableprefdesc'] = 'Mostrar um link para a página de preferências do usuário';
$string['enableprivatefiles'] = 'Arquivos Privados';
$string['enableprivatefilesdesc'] = 'Mostrar um link para os arquivos privados dos usuários';
$string['enableprofile'] = 'Perfil';
$string['enableprofiledesc'] = 'Mostrar um link para o perfil dos usuários';
$string['enablesavecanceloverlay'] = 'Habilitar Salvar mu / Cancelar sobreposição nas páginas de configurações';
$string['enableshowhideblocks'] = 'Habilitar Mostrar e Ocultar Blocos';
$string['enableshowhideblocksdesc'] = 'Permitir que os usuários mostrem/ocultem todos blocos.';
$string['enableshowhideblockstext'] = 'Mostrar texto para Mostrar Ocultar Blocos';
$string['enableshowhideblockstextdesc'] = 'Mostrar o texto ao lado do botão.';
$string['enabletabbedprofile'] = 'Habilitar perfil com abas';
$string['enabletabbedprofiledesc'] = 'Habilitar a funcionalidade do perfil com abas.';
$string['enablethiscoursedesc'] = 'Mostrar um menu suspenso com as atividades do curso atual.';
$string['enabletoolsmenus'] = 'Habilitar Menus de Ferramentas';
$string['enabletoolsmenusdesc'] = 'Se os menus não estão sendo utilizados, é recomendado que você deixe isso desativado por razões de desempenho.';
$string['enablezoom'] = 'Habilitar o Zoom';
$string['enablezoomdesc'] = 'Permitir aos usuários alternar entre tela cheia e largura fixa.';
$string['enablezoomshowtext'] = 'Mostrar texto para Habilitar Zoom';
$string['enablezoomshowtextdesc'] = 'Mostrar o texto ao lado do botão.';
$string['events'] = 'Eventos';
$string['expandable'] = 'Expansível';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Envie um favicon para ser usado no seu site';
$string['favoff'] = 'Versão Core FontAwesome 6 Free';
$string['fontblockheadercolor'] = 'Cor da Fonte do Cabeçalho dos Blocos';
$string['fontblockheadercolordesc'] = 'Defina a cor da fonte do cabeçalho dos blocos do moodle, use o código hexadecimal html. Observe que isso também afeta a cor do ícone.';
$string['fontblockheadersize'] = 'Tamanho da fonte do cabeçalho dos blocos';
$string['fontblockheadersizedesc'] = 'Define o tamanho da fonte usado no cabeçalho dos blocos do Moodle. Selecione um valor da lista.';
$string['fontblockheaderweight'] = 'Peso da fonte dos cabeçalhos dos blocos';
$string['fontblockheaderweightdesc'] = 'Define o peso da fonte usado no cabeçalho dos blocos do Moodle. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontcolor'] = 'Cor principal da fonte';
$string['fontcolordesc'] = 'Definir a cor da fonte no tema, use o código hexadecimal html.';
$string['fontdefault'] = 'Padrão';
$string['fontdesc'] = 'Você pode selecionar as fontes que deseja usar em todo o tema.';
$string['fontheadercolor'] = 'Cor da fonte do cabeçalho';
$string['fontheadercolordesc'] = 'Defina a cor da fonte do cabeçalho no tema, use o código hexadecimal html.';
$string['fontheadername'] = 'Fonte dos cabeçalhos';
$string['fontheadernamedesc'] = 'Selecione a fonte usada nos cabeçalhos de texto e blocos.';
$string['fontheaderweight'] = 'Peso da fonte dos cabeçalhos';
$string['fontheaderweightdesc'] = 'Peso da fonte dos cabeçalhos usados no site. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontname'] = 'Fonte principal';
$string['fontnamedesc'] = 'Selecione a fonte principal para o site.';
$string['fontsettings'] = 'Fontes';
$string['fontsettingsheading'] = 'Modificar as fontes usadas em todo o tema.';
$string['fontsize'] = 'Tamanho da fonte principal';
$string['fontsizedesc'] = 'Selecione o tamanho da fonte padrão (em porcentagem) usado em todo o site.';
$string['fontsubset'] = 'Subconjunto de fontes do Google';
$string['fontsubsetdesc'] = 'Selecione outro subconjunto de caracteres que não seja o latino para aplicar a todas as fontes. O subconjunto latino já está incluído por padrão.';
$string['fonttitlecolor'] = 'Cor da fonte do título do site/curso';
$string['fonttitlecolorcourse'] = 'Cor da fonte do título do curso';
$string['fonttitlecolorcoursedesc'] = 'Definir a cor da fonte do título do curso no tema, use o código hexadecimal html.';
$string['fonttitlecolordesc'] = 'Definir a cor da fonte do título do site e do título do curso no tema, use o código hexadecimal html.';
$string['fonttitlename'] = 'Fonte do título do Site / Curso';
$string['fonttitlenamedesc'] = 'Selecione a fonte usada nos títulos do site e dos cursos.';
$string['fonttitlesize'] = 'Título do Site / Curso - Tamanho da fonte';
$string['fonttitlesizedesc'] = 'Tamanho da fonte do título do site e dos cursos usados no site. Selecione um valor da lista.';
$string['fonttitleweight'] = 'Título do Site / Curso - Peso da fonte';
$string['fonttitleweightdesc'] = 'Define o peso da fonte usado no título do site e nos títulos dos cursos. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['fontweight'] = 'Peso da fonte principal';
$string['fontweightdesc'] = 'Peso da fonte usada no site. Selecione um valor de 100 a 900, dependendo da fonte selecionada.';
$string['footerbkcolor'] = 'Cor de fundo do rodapé';
$string['footerbkcolordesc'] = 'Definir a cor de fundo do rodapé.';
$string['footerblocksplacement'] = 'Rodapé - Local dos Blocos';
$string['footerblocksplacement1'] = 'Em todo o site';
$string['footerblocksplacement2'] = 'Apenas na Página Inicial';
$string['footerblocksplacement3'] = 'Nunca';
$string['footerblocksplacementdesc'] = 'Controlar onde os blocos superiores do rodapé são exibidos. Todo o site é o padrão.';
$string['footercontent'] = 'Rodapé - Conteúdo da Secão';
$string['footercontentdesc'] = 'Adicionar conteúdo para a seção de rodapé';
$string['footerdesc'] = 'Adicionar um título para a seção de rodapé.';
$string['footerheader'] = 'Rodapé - Título da Secão';
$string['footerlayoutrow'] = 'Construtor de Layout do Rodapé';
$string['footerlayoutrowdesc'] = 'Crie seu layout para as regiões de blocos de rodapé.';
$string['footerlinkcolor'] = 'Cor do link nos blocos do rodapé';
$string['footerlinkcolordesc'] = 'Definir a cor do link nos blocos do rodapé.';
$string['footersettings'] = 'Rodapé';
$string['footersettingsheading'] = 'Defina o conteúdo que deve aparecer no rodapé.';
$string['footertextcolor'] = 'Cor do texto do rodapé';
$string['footertextcolor2'] = 'Cor do texto do rodapé inferior';
$string['footertextcolor2desc'] = 'Cor do texto do rodapé inferior.';
$string['footertextcolordesc'] = 'A cor do texto no rodapé, use o código hexadecimal html.';
$string['footnote'] = 'Nota de rodapé';
$string['footnotedesc'] = 'Adicionar texto ao rodapé';
$string['forumbodybackgroundcolor'] = 'Fórum - Fundo do corpo da postagem';
$string['forumbodybackgroundcolordesc'] = 'Cor de fundo para uma postagem em fórum.';
$string['forumheaderbackgroundcolor'] = 'Fórum - Fundo do título da postagem';
$string['forumheaderbackgroundcolordesc'] = 'Cor de fundo para uma postagem em fórum.';
$string['frnt-footer'] = 'Blocos nesta área serão visíveis apenas para usuários administradores';
$string['frontpageblockregionsettings'] = 'Construtor de Região de Bloco';
$string['frontpageblocksenabled'] = 'Habilitar a região de bloco personalizada na página principal';
$string['frontpageblocksenableddesc'] = 'Você pode habilitar / desabilitar regiões de bloco personalizadas na página principal.
Em seguida, você pode arrastar e soltar blocos nas regiões que criou';
$string['frontpageblocksettings'] = 'Blocos de Marketing';
$string['frontpagecoursesettings'] = 'Lista de cursos da página inicial';
$string['frontpagedesc'] = 'Configurar a maneira como as caixas dos curso são renderizadas na página principal.';
$string['frontpagemarketenabled'] = 'Habilitar os Blocos de Marketing';
$string['frontpagemarketenableddesc'] = 'Definir os blocos de marketing na página principal.';
$string['frontpagemarketoption'] = 'Escolha o estilo para blocos de marketing';
$string['frontpagemarketoptiondesc'] = 'Você pode aplicar estilos diferentes aos blocos de marketing.
Nota: O estilo BCU foi projetado para funcionar com imagens na parte superior do bloco.';
$string['frontpagenumbertiles'] = 'Número de blocos de curso por linha';
$string['frontpagenumbertilesdesc'] = 'Número de azulejos do curso a serem exibidos por linha na lista de cursos da página inicial.';
$string['frontpagerenderer'] = 'Caixas de Curso na Página Principal';
$string['frontpagerendererdefaultimage'] = 'Imagem padrão de curso';
$string['frontpagerendererdefaultimagedesc'] = 'A imagem padrão a ser usada quando nenhuma imagem de curso for encontrada (aplica-se apenas a Azulejos com sobreposição).';
$string['frontpagerendererdesc'] = 'Controlar a maneira como as caixas dos cursos na página principal são renderizadas.';
$string['frontpagerendereroption1'] = 'Blocos';
$string['frontpagerendereroption2'] = 'Blocos com sobreposição';
$string['frontpagerendereroption3'] = 'Padrão do Moodle';
$string['frontpagerendereroption4'] = 'Blocos de Coventry';
$string['frontpagesettingsheading'] = 'Renderização da Página Principal';
$string['frontpageslidersettings'] = 'Slider da Página Principal';
$string['frontpagetiles1'] = '1 bloco';
$string['frontpagetiles2'] = '2 blocos';
$string['frontpagetiles3'] = '3 blocos';
$string['frontpagetiles4'] = '4 blocos';
$string['frontpagetiles6'] = '6 blocos';
$string['frontpageuserblocksenabled'] = 'Ativar região de bloco de poste lateral na página inicial para usuários';
$string['frontpageuserblocksenableddesc'] = 'Você pode ativar/desativar a região de bloco de poste lateral na página inicial para usuários. Observação: "Usuários" aqui significa usuários convidados e autenticados; os administradores sempre verão a região.';
$string['fullscreen'] = 'Tela cheia';
$string['fullscreenwidth'] = 'Largura da tela cheia.';
$string['fullscreenwidthdesc'] = 'Definir a largura máxima do tema quando estiver no modo de tela cheia / zoom.';
$string['future'] = 'Futuro';
$string['gdprbutton'] = 'Botão de Resumo de Retenção de Dados';
$string['gdprbuttondesc'] = 'Mostrar o botão de Resumo de Retenção de Dados no rodapé.';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Você pode configurar vários códigos para o Google Analytics e atribuí-los a campos de perfil de usuário.';
$string['googleanalyticssettingsheading'] = 'Configure o Google Analytics para o seu site';
$string['googlefonts'] = 'Fontes do Google';
$string['googlefontsdesc'] = 'Ativar <a href="{$a}" target="_blank">Google Fonts</a> para os nomes das fontes que você especificar, exceto "Padrão". Quando "desativado", você tem a oportunidade de servir as fontes através de CSS / modificação do tema ou já tê-las instaladas nos dispositivos dos usuários. Quando "ativado", selecione o subconjunto necessário (o latino está sempre incluído) e insira o peso da fonte correto, ou a fonte não será exibida. <b>NOTA: Adaptable é licenciado sob a GPLv3 e pode conter bugs, por favor, verifique por si mesmo se, quando desativado, as fontes do Google não estão sendo usadas!</b>';
$string['headerbgimage'] = 'Imagem de fundo';
$string['headerbgimagedesc'] = 'Defina uma imagem de fundo no cabeçalho. O tamanho mínimo é 1600x180px (recomendado 1900x180px). A imagem cobre o cabeçalho inteiro. Você pode adicionar uma cor em "Cor de fundo do cabeçalho superior" ou usar <i>transparente</i> para mostrar a imagem de fundo. Nesse caso, modifique a cor do texto para ser exibido corretamente sobre a imagem.';
$string['headerbkcolor'] = 'Cor de fundo do cabeçalho superior';
$string['headerbkcolor2'] = 'Cor de fundo do cabeçalho inferior';
$string['headerbkcolor2desc'] = 'Definir a cor de fundo do cabeçalho inferior. Observe que isso também define a cor de fundo para o estilo Cabeçalho 2.';
$string['headerbkcolordesc'] = 'Definir a cor de fundo do cabeçalho superior';
$string['headerdesc'] = 'Carregue seu favicon, logotipo, defina o formulário de login no cabeçalho, ajuste os títulos no cabeçalho.<br />
Você pode definir o tamanho da fonte e os estilos dos títulos na página de configurações <a href="./../admin/settings.php?section=theme_adaptable_font">Fontes</a>.';
$string['headernavbarhelpheading'] = 'Links de Ajuda e Opções';
$string['headernavbarhelpheadingdesc'] = 'Opções para links do menu de ajuda.';
$string['headernavbarmycoursesheading'] = 'Menu Meus Cursos';
$string['headernavbarmycoursesheadingdesc'] = 'Todas as opções para o menu "Meus cursos" ("Meus sites") que exibe a lista de cursos do usuário atual.';
$string['headernavbarthiscourseheading'] = 'Menu Este Curso';
$string['headernavbarthiscourseheadingdesc'] = 'Neste menu, o estudante pode acessar diretamente todas as atividades do curso, a lista de participantes e suas notas.';
$string['headersearchandsocial'] = 'Pesquisa de cabeçalho e social';
$string['headersearchandsocialdesc'] = 'Defina a posição da caixa de pesquisa e dos ícones sociais no cabeçalho para o estilo de cabeçalho um.<br />
Você pode definir os ícones sociais na página de configurações de <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Social do cabeçalho</a>.</strong>.';
$string['headersearchandsocialnone'] = 'Nenhum';
$string['headersearchandsocialsearchheader'] = 'Pesquisa no cabeçalho';
$string['headersearchandsocialsearchmobilenav'] = 'Pesquisa no cabeçalho e na barra de navegação para dispositivos móveis';
$string['headersearchandsocialsearchnavbar'] = 'Pesquisa na barra de navegação';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Pesquisa na barra de navegação, social no cabeçalho';
$string['headersearchandsocialsocialheader'] = 'Social no cabeçalho';
$string['headersettings'] = 'Cabeçalho';
$string['headersettingsheading'] = 'Personalize o cabeçalho deste tema.';
$string['headerstyle'] = 'Estilo do cabeçalho';
$string['headerstyle1'] = 'Cabeçalho 1 (cabeçalho original de 3 linhas)';
$string['headerstyle2'] = 'Cabeçalho 2 (cabeçalho de 2 linhas)';
$string['headerstyledesc'] = 'Escolha o estilo do cabeçalho. Cabeçalho um refere-se ao cabeçalho original de três linhas do Adaptable. Cabeçalho dois é um cabeçalho mínimo de duas linhas com uma caixa de pesquisa.';
$string['headerstyleheading'] = 'Configurações de Estilo do Cabeçalho';
$string['headerstyleheadingdesc'] = 'Adaptable suporta dois estilos de cabeçalho, o cabeçalho original de três linhas e um cabeçalho simplificado mais recente de duas linhas.
Saiba que se você alternar para o cabeçalho de duas linhas mais novo, <strong> NÃO </strong> será capaz de: <br />
<ol><li>Mostrar ícones sociais no cabeçalho</li><li>Mostrar o logotipo do site em dispositivos móveis </li> </ol>';
$string['headertextcolor'] = 'Cor do texto e link do cabeçalho';
$string['headertextcolor2'] = 'A cor do texto e do link dos blocos do cabeçalho inferior';
$string['headertextcolor2desc'] = 'Definir a cor do texto e do link dos blocos do cabeçalho inferior.';
$string['headertextcolordesc'] = 'Define a cor do texto e dos links do cabeçalho.';
$string['help'] = 'Ajuda';
$string['helplinkscount'] = 'Número de links de ajuda';
$string['helplinkscountdesc'] = 'Definir o número de links de ajuda que você deseja adicionar à barra de navegação principal.';
$string['helplinktitle'] = 'Título do Link de Ajuda \'{$a->number}\'';
$string['helplinktitledesc'] = 'O título para o link de ajuda \'{$a->number}\' na barra de navegação. Se vazio, o padrão é \'Ajuda {$a->number}\'.';
$string['helpprofilefield'] = 'Link de ajuda "{$a->number}" campo de perfil personalizado (opcional)';
$string['helpprofilefielddesc'] = 'Adicionar regra de acesso ao link de ajuda "{$a->number}" usando para campo de perfil personalizado, por exemplo: usertype=student.';
$string['helptarget'] = 'Ajuda alvo';
$string['helptargetdesc'] = 'Deseja que o link de ajuda seja aberto em uma nova janela?';
$string['helptitle'] = 'Ajuda {$a->number}';
$string['hiddencourses'] = 'Cursos Ocultos';
$string['hiddenfromview'] = 'Oculto na visuaização';
$string['hide'] = 'Ocultar';
$string['hidefootersocial'] = 'Mostrar ícones de rede social';
$string['hidefootersocialdesc'] = 'Mostre ícones de redes sociais no rodapé abaixo dos blocos.';
$string['hideinforum'] = 'Ocultar Ajuda e Ferramentas nos Fóruns';
$string['hideinforumdesc'] = 'Ao usar largura fixa e todas as opções de menu, a caixa de pesquisa do fórum se derrama para a linha abaixo. Ativar esta opção ocultará ferramentas e itens de menu de ajuda nos fóruns, permitindo que ela seja exibida corretamente.';
$string['home'] = 'Início';
$string['homebk'] = 'Imagem de fundo da página inicial';
$string['homebkdesc'] = 'Enviar uma imagem que será a imagem de fundo na página principal.';
$string['hvpcustomcss'] = 'CSS personalizado H5P';
$string['hvpcustomcssdesc'] = 'CSS personalizado para o módulo H5P.';
$string['infobox'] = 'Caixa de informações da página inicial';
$string['infobox2'] = 'Caixa de informações secundária da página inicial';
$string['infobox2desc'] = 'Caixa de informações secundária da página inicial. Consulte a seção "Leia-me" na guia de configurações "Informações" para obter informações adicionais.<br><strong>Nota: </strong><i>Este elemento é usado apenas para compatibilidade com a BCU e será removido em versões futuras.</i>';
$string['infoboxdesc'] = 'Bloco de informações da página inicial HTML. Consulte a seção "Leia-me" na guia de configurações "Informações" para obter informações adicionais.<br><strong>Nota: </strong><i>Este elemento é usado apenas para compatibilidade com a BCU e será removido em versões futuras.</i>';
$string['infoboxfullscreen'] = 'Caixa de informação em tela cheia';
$string['infoboxfullscreendesc'] = 'Ativar esta opção fará com que a caixa de informação fique em tela cheia.';
$string['infoiconcolor'] = 'Cor do ícone de ajuda';
$string['infoiconcolordesc'] = 'Defina a cor do ícone de informações/ajuda usado por dicas.';
$string['inprogress'] = 'Em andamento';
$string['introboxbackgroundcolor'] = 'Cor de fundo da caixa de introdução';
$string['introboxbackgroundcolordesc'] = 'Cor de fundo para a caixa de introdução (destaca a descrição da atividade) usada em fóruns e outras atividades';
$string['invalidcategorygeneratedscss'] = 'CSS gerado personalizado da categoria inválido: "{$a->scss}".';
$string['invalidcategoryscss'] = 'SCSS personalizado da categoria inválido para a categoria "{$a->topcatname}" com id "{$a->topcatid}": "{$a->scss}".';
$string['jssection'] = 'Seção de JavaScript';
$string['jssectiondesc'] = 'Adicionar código javascript para o site';
$string['jssectionrestricted'] = 'Seção - Javascript Condicional';
$string['jssectionrestricteddashboardonly'] = 'Incluir JavaScript apenas na página do painel';
$string['jssectionrestricteddashboardonlydesc'] = 'Mostrar o javascript apenas na página do painel. Caso contrário, isso será mostrado em todo o site.';
$string['jssectionrestricteddesc'] = 'Adicionar código javascript condicionalmente ao site com base em um campo de perfil personalizado. Este javascript aparecerá apenas se essa condição for atendida.';
$string['jssectionrestrictedprofilefield'] = 'Seção - Campo de perfil personalizado da seção Javascript';
$string['jssectionrestrictedprofilefielddesc'] = 'Mostrar o javascript acima SOMENTE quando o usuário corresponder ao valor do campo de perfil personalizado, por exemplo: faculty=fbl.';
$string['jumpto'] = 'Ir para...';
$string['landscape'] = 'Paisagem';
$string['layoutaddcontent'] = 'Satisfeito com o seu layout? Agora adicione conteúdo aos seus blocos:';
$string['layoutaddcontentdesc1'] = 'Você configurou';
$string['layoutaddcontentdesc2'] = 'blocos de marketing. Se você estiver satisfeito com este layout, adicione conteúdo aos blocos abaixo.<br> Se não estiver satisfeito, use o construtor de layout acima para fazer alterações.';
$string['layoutcheck'] = 'Verificar seu layout';
$string['layoutcheckdesc'] = 'Use a ferramenta abaixo para verificar o número de blocos que você usou e ver uma representação do seu novo layout.';
$string['layoutcount1'] = 'Você pode definir no máximo';
$string['layoutcount2'] = 'regiões de bloco. Atualmente, você está usando:';
$string['layoutdesc'] = 'Definir o layout padrão que os usuários visualizam.';
$string['layoutsettings'] = 'Layout';
$string['layoutsettingsheading'] = 'Controlar a aparência do layout do site';
$string['leftblocks'] = 'Lado esquerdo';
$string['linkcolor'] = 'Cor do Link';
$string['linkcolordesc'] = 'Definir a cor dos links no tema, use o código hexadecimal html.';
$string['linkhover'] = 'Cor do Link ao passar o mouse';
$string['linkhoverdesc'] = 'Definir a cor dos links (ao passar o mouse) no tema, use o código hexadecimal html.';
$string['linksmenu'] = 'Menu de Links';
$string['loadingcolor'] = 'Cor do Carregamento';
$string['loadingcolordesc'] = 'Cor da barra de carregamento no topo da página.';
$string['loginbgimage'] = 'Imagem de Fundo';
$string['loginbgimagedesc'] = 'Adicionar uma imagem de fundo para página em tela cheia.';
$string['loginbgopacity'] = 'Opacidade do fundo do cabeçalho da página de login, barra de navegação, caixa de login e rodapé quando houver uma imagem de fundo';
$string['loginbgopacitydesc'] = 'Opacidade para o cabeçalho, barra de navegação, caixa de logon e rodapé quando houver uma imagem de fundo na página de login.';
$string['loginbgstyle'] = 'Estilo do plano de fundo do Login';
$string['loginbgstyledesc'] = 'Selecionar o estilo para a imagem carregada.';
$string['logindesc'] = 'Personalizar a página de login adicionando uma imagem de fundo e textos acima e abaixo da caixa de login.';
$string['loginfooter'] = 'Rodapé da página de login';
$string['loginfooterdesc'] = 'Mostrar o rodapé da página de login.';
$string['loginheader'] = 'Cabeçalho da página de login';
$string['loginheaderdesc'] = 'Mostrar o cabeçalho da página de login.';
$string['loginplaceholder'] = 'Identificação do usuário';
$string['loginsettings'] = 'Página de Login';
$string['loginsettingsheading'] = 'Personalizar a página de login';
$string['logintextboxbottom'] = 'Caixa de texto inferior';
$string['logintextboxbottomdesc'] = 'Adicionar um texto personalizado abaixo da caixa de login.';
$string['logintextboxtop'] = 'Caixa de texto superior';
$string['logintextboxtopdesc'] = 'Adicionar um texto personalizado acima da caixa de login.';
$string['logintextbutton'] = 'Entrar';
$string['logintextbuttonwhenoidc'] = 'Login de Convidado/Manual';
$string['logintextmanualbutton'] = 'Login de conta de teste';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Faça o upload de um logotipo para uso em seu site. O tamanho recomendado é de 200 px por 80 px.';
$string['maincolor'] = 'Cor principal';
$string['maincolordesc'] = 'Cor principal para blocos e rodapé.';
$string['maincoursepage'] = 'Página Principal do Curso';
$string['market'] = 'Bloco de Marketing';
$string['marketblockbordercolor'] = 'Cor da linha de borda do bloco de marketing';
$string['marketblockbordercolordesc'] = 'Define a cor da linha da borda do bloco de marketing.';
$string['marketblocksbackgroundcolor'] = 'Cor de fundo da região de blocos de marketing';
$string['marketblocksbackgroundcolordesc'] = 'Definir a cor de fundo da região de blocos de marketing';
$string['marketdesc'] = 'Adicionar html ao bloco de marketing (consulte o arquivo <a href="./../theme/adaptable/README.txt" target="_blank">README</a> para obter informações e dicas adicionais).';
$string['marketingbuilderdesc'] = 'Use a ferramenta abaixo para configurar seus blocos de marketing. Uma vez definidas, as configurações do bloco aparecerão mais abaixo na página.';
$string['marketingbuilderheading'] = 'Construtor de Layout de Bloco de Marketing';
$string['marketingsettings'] = 'Blocos de Marketing';
$string['marketingsettingsheading'] = 'Personalizar os blocos de marketing que aparecem na página inicial.';
$string['marketingvisible'] = 'Mostrar os blocos de marketing quando';
$string['marketingvisibledesc'] = 'Mostrar os blocos de marketing quando "Desconectado", "Conectado" ou "Conectado ou Desconectado".';
$string['marketingvisibleloggedin'] = 'Conectado';
$string['marketingvisibleloggedinout'] = 'Conectado ou Desconectado';
$string['marketingvisibleloggedout'] = 'Desconectado';
$string['marketlayoutrow'] = 'Linha do Bloco de Marketing';
$string['marketlayoutrowdesc'] = 'Adicionar / definir o layout para a linha do bloco de marketing na página principal';
$string['menubkcolor'] = 'Cor de fundo do Menu Principal';
$string['menubkcolordesc'] = 'Definir a cor de fundo do Menu Principal';
$string['menubordercolor'] = 'Cor da borda inferior do Menu Principal';
$string['menubordercolordesc'] = 'Define a cor da borda inferior do Menu Principal';
$string['menufontcolor'] = 'Cor da fonte do Menu Principal';
$string['menufontcolordesc'] = 'Define uma cor de fonte do Menu Principal';
$string['menufontpadding'] = 'Preenchimento para itens de navegação';
$string['menufontpaddingdesc'] = 'Definir o preenchimento dos itens na barra de navegação principal.';
$string['menufontsize'] = 'Tamanho da fonte da barra de navegação';
$string['menufontsizedesc'] = 'Definir o tamanho da fonte usada na barra de navegação principal.';
$string['menuhovercolor'] = 'Cor do Menu Principal quando passar o mouse';
$string['menuhovercolordesc'] = 'Define a cor do Menu Principal quando passar o mouse';
$string['menuoverrideprofilefield'] = 'Nome do campo de perfil personalizado';
$string['menuoverrideprofilefielddefault'] = 'configuracoesmenuPrincipal';
$string['menuoverrideprofilefielddesc'] = 'Nome do campo de perfil personalizado "lista" usado para substituição pelo usuário.';
$string['menusdesc'] = '.';
$string['menusession'] = 'Armazenar detalhes de acesso na sessão';
$string['menusessiondesc'] = 'Por razões de desempenho, sugere-se que isso seja ativado. Você pode querer desativar durante os testes.';
$string['menusessionttl'] = 'Minutos para armazenar regras de acesso em sessão';
$string['menusessionttldesc'] = 'De quantos em quantos minutos as regras de acesso ao menu são atualizadas na sessão dos usuários.';
$string['menusettings'] = 'Menus do Cabeçalho';
$string['menusettingsheading'] = 'Personalizar os menus no cabeçalho acima do cabeçalho deste tema.';
$string['menusheading'] = 'Configurar a navegação para menus de link no cabeçalho superior';
$string['menusheadingvisibility'] = 'Configurações gerais para a visibilidade do Menu Superior';
$string['menusheadingvisibilitydesc'] = 'As configurações a seguir permitem controlar onde os menus são exibidos e, opcionalmente, permitir que os usuários personalizem suas configurações';
$string['menuslinkicon'] = 'Ícone do menu de links';
$string['menuslinkicondesc'] = 'Escolha um ícone do font awesome personalizado.';
$string['menuslinkright'] = 'Mostrar link de menus no canto superior direito';
$string['menuslinkrightdesc'] = 'Se marcado, mostrar o link para os menus no canto superior direito ao lado do menu de mensagens.';
$string['menustitledesc'] = 'Os menus Ferramentas (na barra de navegação) e Superior (cabeçalho superior) podem ser restritos com base nos campos de perfil personalizados (opcional). Para adicionar uma restrição, digite o nome do campo do perfil e o valor esperado. A estrutura de menus segue o formato padrão do Moodle:
<pre>
Comunidade Moodle|https://moodle.org
-Suporte gratuito do Moodle|https://moodle.org/support
-Desenvolvimento do Moodle|https://moodle.org/development
--Moodle Docs|http: //docs.moodle.org|Moodle Docs
--German Moodle Docs | http: //docs.moodle.org/de|Documentação em alemão|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Permitir substituição pelo usuário';
$string['menuuseroverridedesc'] = 'Essas configurações podem ser usadas para dar aos usuários controle sobre onde os menus aparecem por meio de um campo de perfil personalizado. Para usar essa opção, você precisará criar um campo de perfil personalizado no formato "lista" com valores na ordem correspondente:<br/><pre>1. Geral (o primeiro item na lista será para visibilidade geral do menu)
2. Apenas páginas iniciais (o segundo item na lista definirá a visibilidade apenas para páginas do site/iniciais)
3. Oculto (o terceiro valor na lista ocultará totalmente os menus)</pre>
Você NÃO deve usar a opção "Desativar Menus em Páginas de Curso" em conjunto com as configurações de campo de perfil. Em vez disso, defina o valor padrão para sua entrada "Apenas Páginas Iniciais" ao configurar a lista do campo de perfil.

Nota: Os usuários precisarão fazer logout do Moodle e fazer login novamente para que essa alteração tenha efeito. Você pode querer adicionar uma observação explicando isso no campo de perfil personalizado.';
$string['messagepopupbackground'] = 'Cor de fundo do pop-up de mensagens';
$string['messagepopupbackgrounddesc'] = 'Definir a cor de fundo do cabeçalho do pop-up de mensagens.';
$string['messagepopupcolor'] = 'Cor do texto do pop-up de mensagens';
$string['messagepopupcolordesc'] = 'Defina a cor do texto do cabeçalho do pop-up de mensagens.';
$string['messagingbackgroundcolor'] = 'Cor de fundo da janela principal de mensagens';
$string['messagingbackgroundcolordesc'] = 'Definir a cor de fundo da janela principal das mensagens.';
$string['mobilemenubkcolor'] = 'Cor de fundo do menu para dispositivos móveis';
$string['mobilemenubkcolordesc'] = 'Definir a cor de fundo do menu principal em dispositivos móveis (recolhido).';
$string['moodledocs'] = 'Link da Documentação do Moodle';
$string['moodledocsdesc'] = 'Mostrar o link da Documentação do Moodle no rodapé.';
$string['more'] = 'Mais';
$string['msgbadgecolor'] = 'Cor de fundo da mensagem do emblema';
$string['msgbadgecolordesc'] = 'Defina a cor de fundo do emblema/balão das mensagens no cabeçalho (exibe o número de mensagens não lidas)';
$string['myblogs'] = 'Meus Blogs';
$string['mycoursesmenulimit'] = 'Limite do menu dos meus cursos';
$string['mycoursesmenulimitdesc'] = 'Ajustar o número máximo de cursos que aparecem no menu suspenso Meus cursos. 0 mostrará todos os cursos.';
$string['mysites'] = 'Meus Cursos';
$string['mysitesdisabled'] = 'Desabilitar';
$string['mysitesexclude'] = 'Habilitar excluindo cursos ocultos';
$string['mysitesinclude'] = 'Habilitar incluindo cursos ocultos';
$string['mysitesmaxlength'] = 'Tamanho Máximo de Meus Cursos';
$string['mysitesmaxlengthdesc'] = 'Ajuste o tamanho máximo dos nomes dos cursos no menu Meus cursos para otimizar.';
$string['mysitesmenudisplay'] = 'Mostrar menu Meus Cursos';
$string['mysitesmenudisplaydesc'] = 'Escolha o texto a ser exibido para um item de menu e ao passar o mouse.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Mostrar título completo do curso e título completo ao passar o mouse.';
$string['mysitesmenudisplayfullnamenohover'] = 'Mostrar o nome completo do curso e nenhum texto ao passar o mouse.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Mostrar código curto e nome completo do curso ao passar o mouse.';
$string['mysitesmenudisplayshortcodenohover'] = 'Mostrar o nome breve do curso e nenhum texto ao passar o mouse.';
$string['mysitessortoverride'] = 'Habilitar a ordenação personalizada de Meus Cursos';
$string['mysitessortoverridedesc'] = 'Usar campos de perfil personalizados ou strings genéricas (ano etc) para agrupar cursos antigos no submenu.';
$string['mysitessortoverridefield'] = 'Meus Campos Personalizados ou Strings de Perfil de Cursos';
$string['mysitessortoverridefielddesc'] = 'Lista delimitada por vírgula de campos ou sequências de perfil a serem verificados nos códigos de acesso do curso';
$string['mysitessortoverridelast'] = 'Último acesso ou hora de início da matrícula se nunca acessado';
$string['mysitessortoverridemyoverview'] = 'Usar lista do meu resumo';
$string['mysitessortoverrideoff'] = 'Mostrar todos os cursos inscritos em uma simples lista horizontal';
$string['mysitessortoverrideprofilefields'] = 'Mostrar os cursos encontrados nos campos de perfil na primeira lista, os outros no submenu';
$string['mysitessortoverrideprofilefieldscohort'] = 'Exibir cursos encontrados em campos de perfil + coortes na primeira lista, outros no submenu';
$string['mysitessortoverridestrings'] = 'Exibir cursos matriculados contendo strings na primeira lista, outros no submenu';
$string['navbarcachetime'] = 'Tempo de cache da barra de navegação';
$string['navbarcachetimedesc'] = 'O número de minutos que a barra de navegação fica armazenada em cache.';
$string['navbardesc'] = 'Permite que você controle todos os elementos que aparecem na barra de navegação.';
$string['navbardisplayicons'] = 'Mostrar ícones';
$string['navbardisplayiconsdesc'] = 'Mostra os ícones ao lado dos títulos do menu principal';
$string['navbardisplaysubmenuarrow'] = 'Mostrar a seta do submenu';
$string['navbardisplaysubmenuarrowdesc'] = 'Exibir a seta do submenu (voltada para baixo) quando um cabeçalho de menu tiver opções de submenu.';
$string['navbardropdownborderradius'] = 'Arredondamento da borda do menu suspenso';
$string['navbardropdownborderradiusdesc'] = 'Controla o raio da borda dos menus suspensos (por exemplo, cantos arredondados).';
$string['navbardropdownhovercolor'] = 'Menu suspenso - Fundo ao passar o mouse';
$string['navbardropdownhovercolordesc'] = 'Cor de fundo do menu suspenso ao passar o mouse sobre os items.';
$string['navbardropdowntextcolor'] = 'Cor do texto do menu suspenso';
$string['navbardropdowntextcolordesc'] = 'Cor do texto do item do menu suspenso.';
$string['navbardropdowntexthovercolor'] = 'Cor do texto do menu suspenso ao passar o mouse';
$string['navbardropdowntexthovercolordesc'] = 'Menu suspenso - Cor do texto ao passar o mouse sobre os items.';
$string['navbardropdowntransitiontime'] = 'Tempo de transição da barra de navegação';
$string['navbardropdowntransitiontimedesc'] = 'Tempo de efeito de transição da barra de navegação em segundos. Fornece um efeito de animação de aparecimento gradual ao passar o mouse sobre um menu que possui submenus.';
$string['navbarlinksettingsdesc'] = 'Permitir controlar os links que aparecem na barra de navegação.';
$string['navbarlinksettingsheading'] = 'Personalize os links na barra de navegação';
$string['navbarlinkssettings'] = 'Links da Barra de Navegação';
$string['navbarsettings'] = 'Configurações da Barra de Navegação';
$string['navbarsettingsheading'] = 'Personalizar a barra de navegação';
$string['navbarstyles'] = 'Estilos da Barra de Navegação';
$string['navbarstylesdesc'] = 'Permite que você controle os estilos dos elementos que aparecem na barra de navegação.';
$string['navbarstylesheading'] = 'Personalizar os estilos na barra de navegação';
$string['newmenu'] = 'Menu Suspenso do Topo';
$string['newmenu1trigger'] = 'Palavra de gatilho do menu suspenso 1 do menu superior';
$string['newmenu1triggerdesc'] = 'Definir uma palavra de gatilho para o menu suspenso 1 do menu superior. Ícones Font Awesome podem ser usados';
$string['newmenu2trigger'] = 'Palavra de gatilho do menu suspenso 2 do menu superior';
$string['newmenu2triggerdesc'] = 'Definir uma palavra de gatilho para o menu suspenso 2 do menu superior. Ícones Font Awesome podem ser usados.';
$string['newmenudesc'] = 'Configurar os links a serem mostrados em um menu de cabeçalho superior.';
$string['newmenufield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['newmenufielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['newmenuheading'] = 'Menu Superior';
$string['newmenurequirelogin'] = 'Autenticação obrigatória';
$string['newmenurequirelogindesc'] = 'Se habilitado, este menu estará visível apenas para usuários autenticados';
$string['newmenutitle'] = 'Título do Menu Superior';
$string['newmenutitledefault'] = 'Menu';
$string['newmenutitledesc'] = 'O título da lista suspensa que aparecerá no cabeçalho do seu site.';
$string['newstickercount'] = 'Número de seções de notícias do ticker';
$string['newstickercountdesc'] = 'Definir várias seções de notícias do ticker com regras de acesso para segmentar diferentes públicos.';
$string['newstickersettings'] = 'Ticker de notícias';
$string['nextactivity'] = 'Próxima atividade';
$string['nextsection'] = 'Próxima seção';
$string['noenrolments'] = 'Nenhuma matrícula encontrada.';
$string['none'] = 'Nenhum';
$string['normal'] = 'Largura fixa';
$string['nostyle'] = 'Sem estilo';
$string['onetopicactivetabbackgroundcolor'] = 'Cor de fundo da aba ativa';
$string['onetopicactivetabbackgroundcolordesc'] = 'A cor de fundo da aba ativa em um curso "Um Tópico".';
$string['onetopicactivetabtextcolor'] = 'Cor do texto da aba ativa';
$string['onetopicactivetabtextcolordesc'] = 'A cor do texto da aba ativa em um curso "Um Tópico".';
$string['onetopicdesc'] = 'Personalizar a aparência do formato de curso "<a href="{$a}" target="_blank">Formato de Curso Um Tópico</a>" (se estiver em uso no seu site).';
$string['onetopicheading'] = 'Um Tópico';
$string['originaltemplatepreview'] = 'Visualização do arquivo de tema original/substituído';
$string['originaltemplatesource'] = 'Fonte do arquivo de tema original/substituído';
$string['overriddentemplate'] = 'Modelo substituído: {$a}';
$string['overriddentemplatedesc'] = 'Se definido, o texto aqui será usado como o modelo "{$a}". Para garantir que a visualização funcione, deve haver o exemplo padrão de contexto no formato JSON.';
$string['overriddentemplatenopreview'] = 'Sem visualização devido à falta de exemplo JSON';
$string['overriddentemplatepreview'] = 'Visualização de configuração substituída';
$string['overridetemplate'] = 'Modelo substituído: {$a}';
$string['pageheaderalternative'] = 'Alternativo';
$string['pageheaderheight'] = 'Altura do cabeçalho da página';
$string['pageheaderheightdesc'] = 'Define a altura da área principal do cabeçalho (contendo logotipo e títulos)';
$string['pageheaderlayout'] = 'Layout do cabeçalho um, cabeçalho da página';
$string['pageheaderlayoutdesc'] = 'O layout do cabeçalho da página para o estilo de Cabeçalho 1.';
$string['pageheaderlayouttwo'] = 'Cabeçalho 2, layout do cabeçalho da página';
$string['pageheaderlayouttwodesc'] = 'O layout do cabeçalho da página para o estilo de Cabeçalho 2.';
$string['pageheadernosearch'] = 'Sem pesquisa';
$string['pageheaderoriginal'] = 'Original';
$string['passwordplaceholder'] = 'Senha';
$string['past'] = 'Passado';
$string['pastcourses'] = 'Cursos antigos';
$string['people'] = 'Participantes';
$string['piwikenabled'] = 'Habilitado';
$string['piwikenableddesc'] = 'Habilitar o monitorament do Matomo para o Moodle.';
$string['piwikimagetrack'] = 'Rastreamento de imagem';
$string['piwikimagetrackdesc'] = 'Ativar rastreamento de imagem para o Moodle em navegadores com JavaScript desativado.';
$string['piwiksettings'] = 'Matomo (formalmente Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Gere URL limpo para monitoramento avançado.';
$string['piwiksettingsheading'] = 'Configurar Matomo';
$string['piwiksiteid'] = 'ID do Site';
$string['piwiksiteiddesc'] = 'Digite o ID do seu site.';
$string['piwiksiteurl'] = 'URL do Matomo';
$string['piwiksiteurldesc'] = 'Insira a URL da sua análise Matomo sem http(s) ou barra final.';
$string['piwiktrackadmin'] = 'Monitorar administradores';
$string['piwiktrackadmindesc'] = 'Habilitar o monitoramento de usuários administradores (não recomendado)';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Retrato';
$string['previousactivity'] = 'Atividade anterior';
$string['previoussection'] = 'Seção anterior';
$string['printbodyfontsize'] = 'Tamanho da fonte do corpo';
$string['printbodyfontsizedesc'] = 'Definir o tamanho da fonte do corpo';
$string['printlineheight'] = 'Altura da linha';
$string['printlineheightdesc'] = 'Defina a altura da linha.';
$string['printmargin'] = 'Margem';
$string['printmargindesc'] = 'Defina a margem.';
$string['printpageorientation'] = 'Orientação da página';
$string['printpageorientationdesc'] = 'Defina a orientação da página para "Retrato" ou "Paisagem".';
$string['printsettings'] = 'Imprimir';
$string['printsettingsdesc'] = 'Defina as configurações para impressão.';
$string['printsettingsheading'] = 'Configurações de impressão';
$string['privacy:closed'] = 'Fechado';
$string['privacy:fullin'] = 'Cheio';
$string['privacy:metadata:preference:collapseblock'] = 'O estado dos blocos em uma página.';
$string['privacy:metadata:preference:draweropenblock'] = 'O estado da gaveta de bloco.';
$string['privacy:metadata:preference:draweropenindex'] = 'O estado do índice do curso.';
$string['privacy:nofull'] = 'Não cheio';
$string['privacy:open'] = 'Aberto';
$string['privacy:request:preference:collapseblock'] = 'A preferência do usuário "{$a->name}" para o ID do bloco "{$a->blockid}" tem o valor de "{$a->value}", que representa "{$a->decoded}" para o bloco.';
$string['privacy:request:preference:draweropenblock'] = 'A preferência do usuário "{$a->name}" tem o valor de "{$a->value}", que representa "{$a->decoded}" para a bloco de gaveta.';
$string['privacy:request:preference:draweropenindex'] = 'A preferência do usuário "{$a->name}" tem o valor de "{$a->value}", que representa "{$a->decoded}" para o índice do curso.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'A preferência do usuário "{$a->name}" para o ID da alerta "{$a->alertid}" tem o valor de "{$a->value}" para a alerta fornecida, "indispensável" ou qualquer outra "chave de alerta" que represente que a alerta existia para o usuário.';
$string['privacy:request:preference:themeadaptablefull'] = 'A preferência do usuário "{$a->name}" tem o valor de "{$a->value}", que representa "{$a->decoded}" para o zoom.';
$string['privacy:request:preference:themeadaptablezoom'] = 'A preferência do usuário "{$a->name}" tem o valor de "{$a->value}", que representa "{$a->decoded}" para o estado do zoom.';
$string['properties'] = 'Importar / Exportar configurações';
$string['propertiesdesc'] = 'Nesta seção, você pode importar/exportar as configurações (propriedades) atuais do tema Adaptable no formato JSON. Você também pode visualizar todas as configurações atuais nesta instalação do Moodle.';
$string['propertiesexport'] = 'Exportar propriedades como uma string JSON';
$string['propertiesproperty'] = 'Propriedade';
$string['propertiesreturn'] = 'Voltar';
$string['propertiessub'] = 'Configurações atuais do tema';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Adicionado:';
$string['putpropertieschanged'] = 'Alterado:';
$string['putpropertiesdesc'] = 'Cole a sequência JSON e \'Salvar alterações\'. Atenção! Não valida valores de configuração e executa um \'Limpar todos os caches\'.';
$string['putpropertiesfrom'] = 'de';
$string['putpropertiesheading'] = 'Importar configurações do tema';
$string['putpropertiesignorecti'] = 'Ignorando todas as configurações de imagem do título do curso.';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Importar propriedades';
$string['putpropertiesreportfiles'] = 'Lembre-se de enviar os seguintes arquivos para suas configurações:';
$string['putpropertiessettingsreport'] = 'Relatório de configurações:';
$string['putpropertiesunchanged'] = 'Sem alteração:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nosso';
$string['putpropertyproperties'] = 'Propriedades';
$string['putpropertyreport'] = 'Relatório:';
$string['putpropertyversion'] = 'versão:';
$string['region-content'] = 'Conteúdo';
$string['region-course-bottom-a'] = 'Página do curso região inferior 5';
$string['region-course-bottom-b'] = 'Página do curso região inferior 6';
$string['region-course-bottom-c'] = 'Página do curso região inferior 7';
$string['region-course-bottom-d'] = 'Página do curso região inferior 8';
$string['region-course-section-a'] = 'Região inferior de término da atividade da página do curso';
$string['region-course-tab-one-a'] = 'Página do curso - região da aba 1';
$string['region-course-tab-two-a'] = 'Página do curso - região da aba 2';
$string['region-course-top-a'] = 'Página do curso região superior 1';
$string['region-course-top-b'] = 'Página do curso região superior 2';
$string['region-course-top-c'] = 'Página do curso região superior 3';
$string['region-course-top-d'] = 'Página do curso região superior 4';
$string['region-frnt-footer'] = 'Rodapé';
$string['region-frnt-market-a'] = 'Região 1 da página';
$string['region-frnt-market-b'] = 'Região 2 da página';
$string['region-frnt-market-c'] = 'Região 3 da página';
$string['region-frnt-market-d'] = 'Região 4 da página';
$string['region-frnt-market-e'] = 'Região 5 da página';
$string['region-frnt-market-f'] = 'Região 6 da página';
$string['region-frnt-market-g'] = 'Região 7 da página';
$string['region-frnt-market-h'] = 'Região 8 da página';
$string['region-frnt-market-i'] = 'Região 9 da página';
$string['region-frnt-market-j'] = 'Região 10 da página';
$string['region-frnt-market-k'] = 'Região 11 da página';
$string['region-frnt-market-l'] = 'Região 12 da página';
$string['region-frnt-market-m'] = 'Região 13 da página';
$string['region-frnt-market-n'] = 'Região 14 da página';
$string['region-frnt-market-o'] = 'Região 15 da página';
$string['region-frnt-market-p'] = 'Região 16 da página';
$string['region-frnt-market-q'] = 'Região 17 da página';
$string['region-frnt-market-r'] = 'Região 18 da página';
$string['region-frnt-market-s'] = 'Região 19 da página';
$string['region-frnt-market-t'] = 'Região 20 da página';
$string['region-my-tab-one-a'] = 'Painel - região da aba 1';
$string['region-my-tab-two-a'] = 'Painel - região da aba 2';
$string['region-news-slider-a'] = 'Página do Curso - região do slider';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['regionmaincolor'] = 'Cor da região principal';
$string['regionmaincolordesc'] = 'Defina a cor de fundo para a área de conteúdo principal.';
$string['rendereroverlaycolor'] = 'Cor de sobreposição';
$string['rendereroverlayfontcolor'] = 'Cor da fonte de sobreposição';
$string['responsivebreadcrumb'] = 'Trilha de Navegação';
$string['responsivebreadcrumbdesc'] = 'Em quais tamanhos de tela você gostaria que a Trilha de Navegação fosse exibida?';
$string['responsivecoursetitle'] = 'Título Curso / Site';
$string['responsivecoursetitledesc'] = 'Em quais tamanhos de tela você gostaria que os títulos do Site / Curso fossem exibidos?';
$string['responsiveheader'] = 'Cabeçalho principal';
$string['responsiveheaderdesc'] = 'Em quais tamanhos de telas de você gostaria que o cabeçalho principal fosse exibido? <br/>
     Essa configuração se aplica apenas se você estiver usando o cabeçalho padrão / original de 3 linhas.<br/>
     Remover o cabeçalho completamente também removerá os elementos contidos nele: <br/>
     <ul><li> Ícones sociais</li><li>Logo</li><li>Título do Site / Curso</li></ul>';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'Em quais tamanho de telas você gostaria que o logotipo fosse exibido?';
$string['responsivepagefooter'] = 'Rodapé';
$string['responsivepagefooterdesc'] = 'Em que tamanho de tela você gostaria que o rodapé fosse exibido?';
$string['responsivesectionnav'] = 'Navegação de Atividade / Seção';
$string['responsivesectionnavdesc'] = 'Mostrar / ocultar o <strong>texto</strong> da atividade / seção "anterior" e "próxima"  para navegação em telas pequenas.
         Por padrão, ocultamos esse texto em telas menores para que apenas os ícones dos links <anterior> <próxima> sejam exibidos e não o nome completo da seção / atividade.';
$string['responsivesettings'] = 'Layout Responsivo';
$string['responsivesettingsheading'] = 'Controlar como o site se comporta em diferentes tamanhos de tela';
$string['responsiveslider'] = 'Slider da Página Principal';
$string['responsivesliderdesc'] = 'Em quais tamanhos de tela você gostaria que o Slider da Página inicial fosse exibido?';
$string['responsivesocial'] = 'Ícone de Redes Sociais';
$string['responsivesocialdesc'] = 'Em quais tamanho de telas você gostaria que os ícones de redes sociais fossem exibido?';
$string['responsivesocialsize'] = 'Define o tamanho da fonte dos ícones de redes sociais nos dispositivos móveis';
$string['responsivesocialsizedesc'] = 'Para melhor visualização, o tamanho precisa ser 5px maior que o tamanho real desejado.';
$string['responsiveticker'] = 'Barra de notícias';
$string['responsivetickerdesc'] = 'Em que tamanho de tela você gostaria que o ticker de notícias fosse exibido?';
$string['rightblocks'] = 'Lado direito';
$string['savebuttontext'] = 'Salvar mudanças';
$string['searchboxpadding'] = 'Preenchimento da caixa de busca';
$string['searchboxpaddingdesc'] = 'Defina o preenchimento para a caixa de pesquisa quando estiver no cabeçalho (se estiver sendo usada em vez de ícones sociais) <br />Por exemplo, 5px 10px 5px 10px (topo, direita, inferior, esquerda).<br> Você pode definir ícones sociais na página de configurações de <a href="./../admin/settings.php?section=theme_adaptable_social">Social do Cabeçalho</a>.</strong>.';
$string['sectionheadingcolor'] = 'Cor do texto do título da seção';
$string['sectionheadingcolordesc'] = 'Defina a cor para o texto dos títulos das seções.';
$string['sections'] = 'Seções';
$string['selectionbackground'] = 'Cor de fundo do texto selecionado';
$string['selectionbackgrounddesc'] = 'Definir a cor de fundo do texto quando um texto for selecionado na tela.';
$string['selectiontext'] = 'Cor do texto selecionado';
$string['selectiontextdesc'] = 'Definir a cor do texto quando um texto for selecionado na tela.';
$string['settingsalertbox'] = 'Caixa de Alerta';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblockicons'] = 'Ícones';
$string['settingsblocksgeneral'] = 'Geral';
$string['settingsborders'] = 'Bordas';
$string['settingsbreadcrumbcolors'] = 'Cores da trilha de navegação';
$string['settingscolors'] = 'Cores';
$string['settingscourses'] = 'Cursos';
$string['settingsfonts'] = 'Fontes';
$string['settingsfootercolors'] = 'Cores do rodapé';
$string['settingsforumheading'] = 'Fórum';
$string['settingsheadercolors'] = 'Cores do Cabeçalho';
$string['settingsinfoboxcolors'] = 'Cores da Caixa de Informação';
$string['settingsinformation'] = 'Information';
$string['settingsmaincolors'] = 'Cores Principais';
$string['settingsmarketingcolors'] = 'Cores do Bloco de Marketing';
$string['settingsmessagescolors'] = 'Cores do Popup de Mensagens';
$string['settingsmobilecolors'] = 'Dispositivos Móveis - Cores';
$string['settingsnavbarcolors'] = 'Cores da barra de navegação (navbar)';
$string['settingsoverlaycolors'] = 'Cores de sobreposição de tiles';
$string['settingspagealertsettings'] = 'Alertas';
$string['settingspageblocksettings'] = 'Bloco';
$string['settingssecondinfoboxcolors'] = 'Segundas cores da caixa de informações';
$string['settingstopicsweeks'] = 'Tópicos / Semanas';
$string['show'] = 'Mostrar';
$string['showfooterblocks'] = 'Mostrar blocos do rodapé';
$string['showfooterblocksdesc'] = 'Mostrar / ocultar os quatro blocos configuráveis do rodapé.';
$string['shownavigationblockoncoursepage'] = 'Mostrar bloco de navegação na página do curso';
$string['shownavigationblockoncoursepagedesc'] = 'Defina isso para mostrar o bloco de navegação na página do curso.';
$string['showusername'] = 'Mostrar nome de usuário';
$string['showusernamedesc'] = 'Mostrar o nome de usuário no menu na navbar';
$string['side-post1'] = 'Barra lateral no rodapé';
$string['sidebaricon'] = 'Mostrar / ocultar a barra lateral';
$string['sitelinkslabel'] = 'Links do site';
$string['sitetitle'] = 'Mostrar o título do site';
$string['sitetitlecoursesdisabled'] = 'Desabilitado - mostra somente os títulos dos cursos nas páginas dos cursos';
$string['sitetitlecoursesenabled'] = 'Habilitado - mostra o título do site e os títulos dos cursos nas páginas dos cursos';
$string['sitetitlecustom'] = 'Usar o título do site personalizado (digite na caixa de texto abaixo)';
$string['sitetitledefault'] = 'Usar o título do site Moodle (nome do site)';
$string['sitetitledesc'] = 'Mostrar o título padrão do site Moodle de <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Configurações da Página Inicial</a> ou insira um título personalizado na caixa de texto abaixo.';
$string['sitetitleoff'] = 'Desabilitar o título do site';
$string['sitetitletext'] = 'Título do site';
$string['sitetitletextdesc'] = 'Título do site exibido no cabeçalho. Você pode usar qualquer tag HTML e aplicar estilos inline. Recomenda-se usar a tag HTML h1 em torno do título, em vez da tag p que é adicionada por padrão ao digitar algo neste campo.';
$string['slider2h3bgcolor'] = 'Cor de Fundo do H3 do Slider 2';
$string['slider2h3bgcolordesc'] = 'A cor de fundo que você quer para a tag H3 do Slider 2';
$string['slider2h3color'] = 'Cor do Texto do H3 do Slider 2';
$string['slider2h3colordesc'] = 'A cor do texto desejada para a tag H3 do Slider 2.';
$string['slider2h4bgcolor'] = 'Cor de Fundo do H4 do Slider 2';
$string['slider2h4bgcolordesc'] = 'Escolher a cor de fundo que você quer para a tag H4 do Slider 2';
$string['slider2h4color'] = 'Cor do Texto do H4 do Slider 2';
$string['slider2h4colordesc'] = 'A cor do texto desejada para a tag H4 do Slider 2.';
$string['slidercaption'] = 'Legenda do Slider';
$string['slidercaptiondesc'] = 'Adicionar um subtítulo para seu slide';
$string['slidercount'] = 'Contador do Slider';
$string['slidercountdesc'] = 'Selecione quantos slides você deseja adicionar <strong>e clique em SALVAR</strong> para carregar os campos de entrada de dados';
$string['sliderenabled'] = 'Habilitar Slider';
$string['sliderenableddesc'] = 'Habilitar um Slider na parte superior da sua página principal';
$string['sliderfullscreen'] = 'Slider em tela cheia';
$string['sliderfullscreendesc'] = 'Marque esta caixa para mostrar o slider em tela cheia (largura de 100%)';
$string['sliderh3color'] = 'Cor do H3 do Slider 1';
$string['sliderh3colordesc'] = 'Escolha a cor desejada para a tag H3 do Slider 1.';
$string['sliderh4color'] = 'Cor do H4 do Slider 1';
$string['sliderh4colordesc'] = 'A cor desejada para a tag H4 do Slider 1.';
$string['sliderimage'] = 'Foto/imagem do Slider';
$string['sliderimagedesc'] = 'Adicionar uma imagem ao seu slide. O tamanho recomendado é 1600px x 400px ou superior.';
$string['slidermarginbottom'] = 'Margem abaixo do slider';
$string['slidermarginbottomdesc'] = 'Definir o tamanho da margem abaixo do slider.';
$string['slidermargintop'] = 'Margem acima do slider';
$string['slidermargintopdesc'] = 'Definir o tamanho da margem acima do slider.';
$string['slideroption2'] = 'Escolher o Tipo de Slider';
$string['slideroption2a'] = 'Cor de fundo da seta da opção 2 do slider';
$string['slideroption2adesc'] = 'Define a cor de fundo da seta da opção 2 do slider';
$string['slideroption2color'] = 'Slider dois enviar bg';
$string['slideroption2colordesc'] = 'Defina uma cor de fundo para o texto de envio na opção de estilo de slider.';
$string['slideroption2desc'] = 'Escolha o Tipo de Slider <strong>e clique em SALVAR</strong> para ver as configurações de cores do slider escolhido';
$string['slideroption2submitcolor'] = 'Texto de envio do Slider 2';
$string['slideroption2submitcolordesc'] = 'Definir uma cor de fundo para o texto de envio na cor da opção 2 do estilo do controle deslizante';
$string['sliderstyle1'] = 'Slider estilo 1';
$string['sliderstyle2'] = 'Slider estilo 2';
$string['slidersubmitbgcolor'] = 'Slider 1 - Cor de fundo do envio';
$string['slidersubmitbgcolordesc'] = 'Escolha a cor de fundo do botão de envio do Slider 1';
$string['slidersubmitcolor'] = 'Slider 1 - Texto do Envio';
$string['slidersubmitcolordesc'] = 'Escolha a cor do texto do botão de envio do Slider 1';
$string['sliderurl'] = 'URL do link do slide';
$string['sliderurldesc'] = 'Adicione um URL como link para quando seu slide for clicado.';
$string['slidervisible'] = 'Mostrar o slider quando';
$string['slidervisibledesc'] = 'Mostrar o slider quando "Desconectado", "Conectado" ou "Conectado ou desconectado".';
$string['slidervisibleloggedin'] = 'Conectado';
$string['slidervisibleloggedinout'] = 'Conectado ou desconectado';
$string['slidervisibleloggedout'] = 'Desconectado';
$string['slideshowdesc'] = 'Carregar as imagens, adicione os links e a descrição do carrossel na primeira página.';
$string['slideshowsettings'] = 'Slideshow';
$string['slideshowsettingsheading'] = 'Personalize o carrossel na página inicial.';
$string['slight'] = 'Leve';
$string['socialheading'] = 'Configurações do Ícone Social';
$string['socialicondesc'] = 'Define o ícone Font Awesome, por exemplo: fa-facebook.';
$string['socialiconlist'] = 'Lista de Ícones Sociais';
$string['socialiconlistdesc'] = 'Insira uma lista delimitada para configurar os ícones / links sociais que você precisa, usando o formato: url|title|icon';
$string['socialpaddingside'] = 'Ajustar o preenchimento para o lado do ícone social';
$string['socialpaddingsidedesc'] = 'Isso será o espaço entre o ícone e outro elemento ou a lacuna entre dois ícones. Ou seja, o preenchimento no ícone será esse valor dividido por dois. O valor padrão segue as diretrizes de marca do Instagram.';
$string['socialpaddingtop'] = 'Ajustar o preenchimento acima dos ícones sociais (altera a posição vertical)';
$string['socialpaddingtopdesc'] = 'Será no mínimo 15 px (definido usando a margem) mais esse valor.';
$string['socialsearchicon'] = 'Pesquisar Moodle';
$string['socialsearchicondesc'] = 'Habilite para colocar um link de pesquisa ao lado de ícones sociais (como usando a caixa de pesquisa de todo o site de desabilitações sociais)';
$string['socialsettings'] = 'Cabeçalho Social';
$string['socialsize'] = 'Definir o tamanho da fonte dos ícones sociais';
$string['socialsizedesc'] = 'Para uma visualização melhor, o tamanho precisa ser 5px maior que o tamanho atual desejado.';
$string['socialtarget'] = 'Destino da abertura de links sociais';
$string['socialtargetdesc'] = 'Como você gostaria que os links sociais fossem abertos (mesma ou nova janela)';
$string['socialtitledesc'] = 'Você pode desativar a caixa de pesquisa em todo o site e ativar os ícones / links sociais em seu lugar.
Para configurar os ícones, insira uma lista limitada no campo "Social Icon List" abaixo.
Isso deve estar no formato:

url|título |ícone

Por exemplo:
<pre>
https://example.com/course/search.php|Pesquisa Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https: //instagram.com|Instagram|fa-instagram
https: //example.com|Meu site|fa-globe
</pre>
Para referência, você pode encontrar a lista completa de ícones em <a href="https://fortawesome.github.io/Font-Awesome/icons/">Ícones de Font Awesome</a>';
$string['solid'] = 'Sólido';
$string['standard'] = 'Padrão';
$string['standardscreenwidth'] = 'Largura padrão da tela.';
$string['standardscreenwidthdesc'] = 'Defina a largura da tela ao alternar para a visualização "padrão" (consulte também as configurações relacionadas de enablezoom e defaultzoom).';
$string['standardview'] = 'Visualização padrão';
$string['static'] = 'Estático';
$string['stickynavbar'] = 'Barra de navegação fixa no topo';
$string['stickynavbardesc'] = 'Fixar a barra de navegação no topo da tela ao rolar para baixo.';
$string['stylecover'] = 'Capa';
$string['stylestretch'] = 'Esticar';
$string['tabbedlayoutcoursepage'] = 'Página do curso - Layout com abas';
$string['tabbedlayoutcoursepagedesc'] = 'Use um layout de abas para a página do curso. Isso exibe todo o conteúdo em abas, com o conteúdo do curso em uma aba e permitindo que você personalize o conteúdo em outras abas. Use essa configuração para configurar a ordem das abas.';
$string['tabbedlayoutcoursepagelink'] = 'Link do curso no layout de abas da página do curso';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Tenha um link de aba de volta para a página do curso nas abas do curso.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Página do curso - Cor da aba selecionada';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Escolha a cor para a aba selecionada.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Página do curso - Cor da aba não selecionada';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Escolha a cor para qualquer outra aba.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Tempo de persistência da aba da página inicial do curso';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'A aba da página inicial do curso persiste na aba selecionada ao atualizar por um período de inatividade. Defina o período de inatividade aqui. Por exemplo, defina como 30 para que a primeira aba seja selecionada após 30 minutos de inatividade.';
$string['tabbedlayoutdashboard'] = 'Página do Painel - Layout com abas';
$string['tabbedlayoutdashboarddesc'] = 'Usar um layout com abas para a página Painel. Isso exibe todo o conteúdo em abas, com o conteúdo do curso em uma aba e permite adaptar o conteúdo em outras abas. Use esta configuração para configurar a ordem das abas.';
$string['tabbedlayoutdashboardtab1condition'] = 'Aba 1  - Restrição de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Adicionar uma regra de acesso usando o campo de perfil personalizado para exibir a Aba 1, por exemplo: showtab1 = true';
$string['tabbedlayoutdashboardtab2condition'] = 'Aba 2  - Restrição de campo de perfil personalizado (opcional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Adicionar uma regra de acesso usando o campo de perfil personalizado para exibir a Aba 2, por exemplo: showtab2 = true';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Painel - Cor da aba selecionada';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Escolha a cor para a aba selecionada.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Painel - Cor da aba não selecionada';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Escolha a cor para qualquer outra aba.';
$string['tabbedlayoutheading'] = 'Adaptable - Layout com Abas';
$string['tabbedlayouttablabelcourse'] = 'Conteúdo do Curso';
$string['tabbedlayouttablabelcourse1'] = 'Aba 1';
$string['tabbedlayouttablabelcourse2'] = 'Aba 2';
$string['tabbedlayouttablabeldashboard'] = 'Conteúdo do Painel';
$string['tabbedlayouttablabeldashboard1'] = 'Aba 1';
$string['tabbedlayouttablabeldashboard2'] = 'Aba 2';
$string['targetnewwindow'] = 'Nova janela';
$string['targetsamewindow'] = 'Mesma janela';
$string['templatesheading'] = 'Configurações de modelos';
$string['templatesheadingdesc'] = 'Substituir modelos.';
$string['templatessel'] = 'Modelos para substituir';
$string['templatesseldesc'] = 'Selecione os modelos a serem substituídos e cada um será mostrado em sua própria página. Se não for selecionado aqui, o modelo não será substituído, mesmo que esteja ativado. Para não selecionar nenhum, use a tecla "Ctrl".';
$string['templatessettings'] = 'Modelos';
$string['themechanges'] = 'Alterações';
$string['themereadme'] = 'Leia-me';
$string['themesupport'] = 'Suporte';
$string['thiscourse'] = 'Este curso';
$string['ticker'] = 'Avisos';
$string['tickerdefault'] = 'Não há notícias para exibir';
$string['tickerfullscreen'] = 'Largura da tela cheia';
$string['tickersettings'] = 'Rodapé de notícias';
$string['tickersettingsheading'] = 'Configurar rodapé de notícias';
$string['tickertext'] = 'Texto do rodapé de notícias';
$string['tickertextdesc'] = 'Adicione texto de notícias no formato de lista no rodapé. Consulte o leia-me para obter mais informações.';
$string['tickertextprofilefield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['tickertextprofilefielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['tickerwidth'] = 'Largura Fixa';
$string['tickerwidthdesc'] = 'Você pode usar essa configuração para fixar o rodapé de notícias com largura de 100%.';
$string['tilesbordercolor'] = 'Tiles - Cor da borda das caixas do curso';
$string['tilesbordercolordesc'] = 'Tiles - Definir a cor da borda das caixas do curso';
$string['tilescontactstitle'] = 'Mostrar o papel dos contatos do curso';
$string['tilescontactstitledesc'] = 'Mostrar / ocultar o papel de um contato do curso. Se não for exibida, uma imagem será exibida antes de cada contato';
$string['tilesshowallcontacts'] = 'Mostrar todos os contatos do curso';
$string['tilesshowallcontactsdesc'] = 'Mostrar todos os contatos do curso ou apenas um.';
$string['tilesshowcontacts'] = 'Mostrar contatos do curso';
$string['tilesshowcontactsdesc'] = 'Mostrar / ocultar contatos do curso.';
$string['togglenavigation'] = 'Alternar navegação';
$string['toolsmenu'] = 'Menu Suspenso de Ferramentas';
$string['toolsmenu2'] = '2º menu de Ferramentas';
$string['toolsmenu2desc'] = 'Você pode configurar os links para serem exibidos em um menu de ferramentas. Cada linha consiste em algum texto de menu, um URL de link (opcional), um título de dica (opcional) e um código de idioma ou lista de códigos separados por vírgula (opcional, para exibir a linha apenas para usuários do idioma especificado), separados por caracteres de pipe. Você pode definir uma estrutura usando hífens. Por exemplo:
<pre>
Comunidade Moodle|https: //moodle.org
-Suporte gratuito do Moodle|https: //moodle.org/support
-Desenvolvimento do Moodle|https: //moodle.org/development
--Moodle Docs|http: //docs.moodle.org|Moodle Docs
--German Moodle Docs|http: //docs.moodle.org/de| Documentação em alemão |de
Moodle.com|http: //moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Adicione os links aqui.';
$string['toolsmenufield'] = 'Campo de perfil personalizado Nome=Valor (opcional)';
$string['toolsmenufielddesc'] = 'Adicionar regra de acesso usando o campo de perfil personalizado, por exemplo: usertype=student';
$string['toolsmenuheading'] = 'Menu de Ferramentas';
$string['toolsmenuheadingdesc'] = 'Adicionar um menu suspenso à barra de navegação principal. Você pode configurar links para serem exibidos sob um menu de ferramentas (na barra de navegação principal). O formato é semelhante ao utilizado para menus personalizados do Moodle, mas permite adicionar ícones do Font Awesome aos itens do menu:<br/><pre>
&lt;span class=&quot;fa-solid fa-videoa&quot;&gt;&lt;/span&gt; Gravar Tela|https://mysite.localhost|Gravar Tela
&lt;span class=&quot;fa-regular fa-image&quot;&gt;&lt;/span&gt; ThinkStock|https://mysite.localhost|ThinkStock
&lt;span class=&quot;fa-regular fa-clock&quot;&gt;&lt;/span&gt; Relógio de Exame|https://mysite.localhost|Relógio de Exame
</pre><br />';
$string['toolsmenuheadingindex'] = 'Menu de Ferramentas {$a}';
$string['toolsmenulabel'] = 'Menu de ferramentas';
$string['toolsmenulabel2'] = 'Ferramentas dois';
$string['toolsmenuscount'] = 'Número de menus de ferramentas';
$string['toolsmenuscountdesc'] = 'Defina o número de menus de ferramentas que deseja adicionar à barra de navegação principal.';
$string['toolsmenutitle'] = 'Título do menu de ferramentas';
$string['toolsmenutitledefault'] = 'Ferramentas';
$string['toolsmenutitledesc'] = 'Adicione o título do menu que você gostaria de exibir na barra de navegação principal.';
$string['topicsweeks'] = 'Formato de curso Tópicos/Semanas';
$string['topicsweeksdesc'] = 'Definir os estilos para o formato de curso Tópicos/Semanas';
$string['topmenufontsize'] = 'Tamanho da fonte do menu superior';
$string['topmenufontsizedesc'] = 'Ajustar o tamanho da fonte dos menus superiores';
$string['topmenuscount'] = 'Número de menus superiores';
$string['topmenuscountdesc'] = 'Definir o número de menus superiores que você deseja adicionar ao cabeçalho do tema';
$string['turngradereditingoff'] = 'Desativar a edição do avaliador';
$string['turngradereditingon'] = 'Ativar a edição do avaliador';
$string['usermenu'] = 'Menu do usuário';
$string['usernameposition'] = 'Posição do nome do usuário';
$string['usernamepositiondesc'] = 'Definir a posição do nome de usuário, \'Esquerda\' ou \'Direita\'.';
$string['usernav'] = 'Cabeçalho do Usuário';
$string['usernavdesc'] = 'Permite controlar todos os elementos que aparecem na lista suspensa de navegação do usuário.';
$string['usernavheading'] = 'Personalizar o menu suspenso de navegação do usuário';
$string['usernodescription'] = 'Usuário ainda não atualizou sua descrição.';
$string['usernointerests'] = 'Usuário ainda não atualizou seus interesses.';
$string['usersettings'] = 'Perfil do usuário';
$string['usersettingsdesc'] = 'Definir as configurações para o perfil do usuário.';
$string['usersettingsheading'] = 'Controlar aparência do perfil do usuário';
$string['versionalpha'] = 'Versão alfa - quase certamente contém bugs. Esta é uma versão de desenvolvimento \'apenas\' para desenvolvedores! Nem pense em instalar em um servidor de produção!';
$string['versionbeta'] = 'Versão beta - Provavelmente contém bugs. Pronta para teste por administradores apenas em um servidor de teste.';
$string['versioninfo'] = 'Release {$a->release}, versão {$a->version} no Moodle {$a->moodle}';
$string['versionrc'] = 'Versão candidata a lançamento - pode conter bugs. Verifique completamente em um servidor de teste antes de pensar em um servidor de produção.';
$string['versionstable'] = 'Versão estável - Pode conter bugs, pois não há tempo suficiente no universo para encontrá-los todos. Verifique em um servidor de teste antes de instalar em seu servidor de produção, sério! Você não vai se arrepender e poderá personalizar até ficar feliz, depois use a funcionalidade \'Importar/exportar configurações\' para transferir os valores de configuração, barrar os arquivos.';
$string['wide'] = 'Tela cheia';
