<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'pt_br', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['activate'] = 'Habilitar acesso';
$string['activatesuccess'] = 'O acesso aos emblemas foi habilitado com sucesso.';
$string['addalignment'] = 'Adicionar habilidade ou padrão externo';
$string['addbadge'] = 'Adicionar um emblema';
$string['addbadge_help'] = 'Selecione todos os emblemas que devem ser adicionados a este requisito de emblema. Mantenha pressionada a tecla CTRL para selecionar vários itens.';
$string['addbadgecriteria'] = 'Adicionar critérios ao emblema';
$string['addcohort'] = 'Adicionar coorte';
$string['addcohort_help'] = 'Selecione todos os coortes que devem ser adicionados a este requisito de emblema. Mantenha pressionada a tecla CTRL para selecionar vários itens.';
$string['addcompetency'] = 'Adicionar competência';
$string['addcompetency_help'] = 'Selecione todos as competências que devem ser adicionadas a este requisito de emblema. Mantenha pressionada a tecla CTRL para selecionar vários itens.';
$string['addcourse'] = 'Adicionar cursos';
$string['addcourse_help'] = 'Selecione todos os cursos que podem ser adicionados a essa condição de emblema. Mantenha pressionada a tecla CTRL para selecionar vários cursos.';
$string['addcriteria'] = 'Adicionar critérios';
$string['addcriteriatext'] = 'Para começar a adicionar critérios, por favor, selecione uma das opções a partir do menu drop-down.';
$string['addedtobackpack'] = 'Emblema adicionado na mochila';
$string['addrelated'] = 'Adicionar emblema relacionado';
$string['addtobackpack'] = 'Adicionar à mochila';
$string['adminonly'] = 'Esta página é restrita a administradores do site.';
$string['after'] = 'após a data de emissão.';
$string['aggregationmethod'] = 'Método de agregação';
$string['alignment'] = 'Alinhamento';
$string['all'] = 'Todos';
$string['allmethod'] = 'Todas as condições selecionadas forem concluídas';
$string['allmethodactivity'] = 'Todas as atividades selecionadas forem concluídas';
$string['allmethodbadges'] = 'Todos os emblemas selecionados foram recebidos';
$string['allmethodcohort'] = 'Participação em todas os coortes selecionados';
$string['allmethodcompetencies'] = 'Todas as competências selecionadas foram concluídas';
$string['allmethodcourseset'] = 'Todos os cursos selecionados forem concluídos';
$string['allmethodmanual'] = 'Todos os papéis selecionados concedem o emblema';
$string['allmethodprofile'] = 'Todos os campos do perfil selecionados foram preenchidos';
$string['allowcoursebadges'] = 'Ativar emblemas do curso';
$string['allowcoursebadges_desc'] = 'Permite que emblemas sejam criados e concedidos no contexto do curso.';
$string['allowexternalbackpack'] = 'Conexão com mochilas externas';
$string['allowexternalbackpack_desc'] = 'Se habilitado, os usuários podem se conectar a uma mochila externa e compartilhar seus emblemas neste site. Os usuários também podem optar por exibir coleções de emblemas públicas de sua mochila externa na página de perfil deste site. É recomendável deixar essa opção desativada se o seu site não estiver acessível na Internet.';
$string['any'] = 'Qualquer';
$string['anymethod'] = 'Qualquer uma das condições for concluída';
$string['anymethodactivity'] = 'Qualquer uma das atividades selecionadas for concluída';
$string['anymethodbadges'] = 'Quaisquer dos emblemas selecionados foram recebidos';
$string['anymethodcohort'] = 'Participação em qualquer um dos coortes selecionados';
$string['anymethodcompetencies'] = 'Qualquer uma das competências selecionadas foi concluída';
$string['anymethodcourseset'] = 'Qualquer um dos cursos selecionados estar concluído';
$string['anymethodmanual'] = 'Qualquer um dos papeis selecionados concedem o emblema';
$string['anymethodprofile'] = 'Qualquer um dos campos do perfil estar preenchido';
$string['apiversion'] = 'Versão da API suportada';
$string['archivebadge'] = 'Gostaria de apagar o emblema \'{$a}\' mas manter os emblemas emitidos existentes?';
$string['archiveconfirm'] = 'Excluir e manter os emblemas emitidos existentes';
$string['archivehelp'] = '<p> Esta opção significa que o emblema será marcado como "aposentado" e não será mais exibido na lista de emblemas. Os usuários não serão mais capazes de ganhar este emblema, porém os usuários que já receberam este emblema ainda poderão exibí-lo na sua página de perfil e enviá-lo para mochilas externas.</p><p>Se você gostaria que seus usuários mantivessem o acesso aos emblemas ganhos, é importante que você selecione esta opção ao invés de excluir completamente os emblemas.</p>';
$string['attachment'] = 'Anexar emblema à mensagem';
$string['attachment_help'] = 'Se habilitado, um arquivo do emblema emitido será anexado ao e-mail do destinatário para download. (Para usar esta opção a configuração de permitir anexos deve estar habilitada em Administração do site / Servidor /E-mail / Configuração de saída de e-mail.)';
$string['award'] = 'Conceder emblema';
$string['awardedto'] = 'Concedido à {$a}';
$string['awardedtoyou'] = 'Emitido para mim';
$string['awardoncron'] = 'Acesso aos emblemas foi habilitado com sucesso. Muitos usuários podem receber instantaneamente este emblema. Para garantir uma boa performance no site, esta ação levará algum tempo para ser processada.';
$string['awards'] = 'Destinatários';
$string['backpackapiurl'] = 'URL da API da mochila';
$string['backpackavailability'] = 'Verificação de emblema externo';
$string['backpackavailability_help'] = 'Para os beneficiários do emblema serem capazes de provar que eles ganharam seus emblemas de você, um serviço de mochila externo deve ser capaz de acessar o seu site e verificar emblemas emitidos a partir dele. Seu site atualmente não parece ser acessível, o que significa que emblemas que você já emitiu ou vai emitir no futuro não poderão ser verificados.

**Por que estou vendo esta mensagem?**

Pode ser que seu firewall impede o acesso de usuários fora da rede, o site é protegido por senha, ou se você estiver executando o site em um computador que não está disponível na Internet (tais como uma máquina de desenvolvimento local).

**Isto é um problema?**

Você deve corrigir esse problema em qualquer local de produção onde você está planejando a emissão de emblemas, caso contrário, os destinatários não serão capazes de provar que eles ganharam seus emblemas de você. Se o seu site ainda não está em produção, você pode criar e fornecer emblemas de teste, desde que o site fique acessível antes de entrar em produção.

**E se eu não posso fazer todo o meu local de acesso público?**

A única URL necessárias para a verificação é [seu-site-url]/badges/assertion.php por isso, se você é capaz de modificar o seu firewall para permitir o acesso externo ao arquivo, verificação emblema continuará a funcionar.';
$string['backpackbadgessettings'] = 'Alterar configurações da mochila';
$string['backpackbadgessummary'] = 'Você tem {$a->totalbadges} emblemas(s) exibidos de {$a->totalcollections} coleções(s).';
$string['backpackcannotsendverification'] = 'Não foi possível enviar e-mail de verificação';
$string['backpackconnected'] = 'Mochila está conectada';
$string['backpackconnection'] = 'Conexão de mochila';
$string['backpackconnection_connected'] = 'Sua mochila';
$string['backpackconnection_help'] = 'Armazene e compartilhe seus emblemas deste site e exiba emblemas públicos de outros sites em seu perfil de usuário.';
$string['backpackconnectioncancelattempt'] = 'Conectar usando um endereço de e-mail diferente';
$string['backpackconnectionconnect'] = 'Conectar a mochila';
$string['backpackconnectionnottested'] = 'A conexão não pode ser testada para esta mochila porque somente as Mochilas Open Badges v.2.0 têm suporte.';
$string['backpackconnectionok'] = 'Conexão com a mochila estabelecida com sucesso.';
$string['backpackconnectionresendemail'] = 'Reenviar e-mail de verificação';
$string['backpackconnectionunexpectedmessage'] = 'A mochila retornou o erro: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Ocorreu um problema ao conectar a sua mochila. Seu provedor está enviando esta mensagem: \'{$a}\'.';
$string['backpackdetails'] = 'Configurações de mochila';
$string['backpackdisconnected'] = 'Mochila está desconectada';
$string['backpackemail'] = 'Endereço de e-mail';
$string['backpackemail_help'] = 'Endereço de e-mail associado à sua mochila. Enquanto você estiver conectado, quaisquer medalhas obtidas nesse site serão associadas ao seu ambiente de e-mail.';
$string['backpackemail_required'] = 'O endereço de e-mail não pode ficar em branco';
$string['backpackemailverificationpending'] = 'Verificação pendente';
$string['backpackemailverifyemailbody'] = 'Oi {$a->userfirstname},

Você está quase terminando de se conectar à sua mochila de emblemas em \'{$a->sitename}\'.

Para finalizar a conexão com sua mochila, verifique seu endereço de e-mail através do seguinte botão:

{$a->buttonlink}

Se o botão não funcionar, você pode copiar e colar o seguinte URL em seu navegador:
{$a->link}


Se você não tentou se conectar à sua mochila de emblemas, pode ignorar este email com segurança.

Para qualquer ajuda extra, entre em contato com o suporte do site,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Confirmação por e-mail da mochila de emblemas';
$string['backpackemailverifypending'] = 'Um email de verificação foi enviado para <strong>{$a}</strong>. Clique no link de verificação no email para ativar sua conexão com a mochila.';
$string['backpackemailverifysuccess'] = 'Agora você está conectado à sua mochila.';
$string['backpackemailverifytokenmismatch'] = 'O token no link que você clicou não corresponde ao token armazenado. Certifique-se de clicar no link do e-mail mais recente que você recebeu.';
$string['backpackexporterror'] = 'Não foi possível exportar o emblema para a mochila.';
$string['backpackexporterrorwithinfo'] = 'Não é possível exportar o emblema "{$a->badgename}" para a mochila. Erro: {$a->erro}';
$string['backpackimport'] = 'Configurações de importação de emblema';
$string['backpackimport_help'] = 'Depois que a conexão com a mochila é estabelecida com sucesso, os emblemas de sua mochila podem ser exibidos na sua página "Meus emblemas" e na sua página de perfil.

Nesta área, você pode selecionar coleções de emblemas de sua mochila que você gostaria de exibir em seu perfil.';
$string['backpackprovider'] = 'Fornecedor de mochila';
$string['backpacksettings'] = 'Configurações da mochila';
$string['backpackweburl'] = 'URL da mochila';
$string['badgedetails'] = 'Detalhes do emblema';
$string['badgeimage'] = 'Imagem';
$string['badgeimage_help'] = 'A imagem deve ter pelo menos 300 x 300 pixels de tamanho. Ela será exibida como 300 x 300 pixels na página do emblema e 100 x 100 pixels na página de perfil do usuário.';
$string['badgeissued'] = 'Emblema emitido';
$string['badgeprivacysetting'] = 'Configurações de privacidade de emblemas';
$string['badgeprivacysetting_help'] = 'Emblemas que você ganha podem ser exibidos na sua página de perfil. Esta configuração permite que você defina automaticamente a visibilidade dos emblemas obtidos recentemente.

Você ainda pode controlar as configurações de privacidade dos emblemas individualmente em sua página "Meus emblemas".';
$string['badgeprivacysetting_str'] = 'Mostrar automaticamente emblemas que eu obtive em minha página de perfil';
$string['badges'] = 'Emblemas';
$string['badgesalt'] = 'Salt do hash do endereço de e-mail do destinatário';
$string['badgesalt_desc'] = 'Usar um "hash" permite que os serviços de mochilas confirmem o ganhador do emblema sem ter que expor seu endereço de e-mail. Esta configuração deve usar apenas números e letras.

Nota: Para efeitos de verificação de destinatários, por favor, evite alterar essa configuração uma vez que você começar a emitir emblemas.';
$string['badgesdisabled'] = 'Emblemas não estão habilitados neste site.';
$string['badgesearned'] = 'Numero de emblemas obtidos: {$a}';
$string['badgesettings'] = 'Configurações de emblemas';
$string['badgestatus_0'] = 'Não disponível';
$string['badgestatus_1'] = 'Disponível';
$string['badgestatus_2'] = 'Não disponível (critérios bloqueados)';
$string['badgestatus_3'] = 'Disponível (critérios bloqueados)';
$string['badgestatus_4'] = 'Arquivada';
$string['badgestoearn'] = 'Número de emblemas disponíveis: {$a}';
$string['badgesview'] = 'Emblemas do curso';
$string['badgetags'] = 'Tags do emblema';
$string['badgeurl'] = 'Link do emblema emitido';
$string['balignment'] = 'Alinhamentos ({$a})';
$string['bawards'] = 'Destinatários ({$a})';
$string['bcriteria'] = 'Critérios';
$string['bdetails'] = 'Editar detalhes';
$string['bendorsement'] = 'Endosso';
$string['bmessage'] = 'Mensagem';
$string['boverview'] = 'Visão geral';
$string['brelated'] = 'Emblemas relacionados ({$a})';
$string['bydate'] = 'concluir até';
$string['claim'] = 'Crédito';
$string['claimcomment'] = 'Comentário de endosso';
$string['claimid'] = 'URL do crédito';
$string['clearsettings'] = 'Limpar configurações';
$string['completioninfo'] = 'Este emblema foi emitido por concluir: ';
$string['completionnotenabled'] = 'A conclusão de curso não está habilitada para esse curso e portanto não pode ser incluída no critério do emblema. Você pode habilitar a conclusão de curso nas configurações do curso.';
$string['configenablebadges'] = 'Se habilitada, esta funcionalidade permite a você criar emblemas e concedê-los aos usuários do site.';
$string['configuremessage'] = 'Mensagem do emblema';
$string['connect'] = 'Conectar';
$string['connected'] = 'Conectado';
$string['connecting'] = 'Conectando...';
$string['contact'] = 'Contato';
$string['contact_help'] = 'Um endereço de e-mail associado ao emissor do emblema.';
$string['copy'] = 'Copiar';
$string['copyof'] = 'Cópia de {$a}';
$string['course'] = 'Curso: {$a}';
$string['coursebadges'] = 'Emblemas';
$string['coursebadgesdisabled'] = 'Emblemas de curso não estão habilitados neste site.';
$string['coursebadgetitle'] = 'Emblema do curso {$a}';
$string['coursecompletion'] = 'Os usuários devem concluir este curso.';
$string['create'] = 'Novo emblema';
$string['createbutton'] = 'Criar emblema';
$string['creatorbody'] = '<p>{$a->user} concluiu todos os requisitos e foi premiado com o emblema. Ver emblema emitido em {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' foi concedido!';
$string['criteria_0'] = 'Este emblema é concedido quando...';
$string['criteria_1'] = 'Conclusão de atividade';
$string['criteria_1_help'] = 'Permite que um emblema seja concedido a usuários baseado na conclusão de um conjunto de atividades de um determinado curso.';
$string['criteria_2'] = 'Atribuição manual por papel';
$string['criteria_2_help'] = 'Permite que um emblema seja concedido manualmente por um usuários que tenha um papel particular em um curso ou no site.';
$string['criteria_3'] = 'Participação social';
$string['criteria_3_help'] = 'Social';
$string['criteria_4'] = 'Conclusão de curso';
$string['criteria_4_help'] = 'Permite que um emblema seja atribuído a um usuário que concluiu o curso. Este critério pode conter parâmetros adicionais como nota mínima e data de conclusão do curso.';
$string['criteria_5'] = 'Conclusão de um conjunto de cursos';
$string['criteria_5_help'] = 'Permite que um emblema seja concedido a um usuário que concluiu um conjunto de cursos. Cada curso pode conter parâmetros adicionais como nota mínima ou data de conclusão de curso.';
$string['criteria_6'] = 'Preenchimento de perfil';
$string['criteria_6_help'] = 'Permite que um emblema seja concedido a um usuário por preencher determinados campos do perfil. Você pode selecionar campos padrão e personalizados que estejam disponíveis aos usuários.';
$string['criteria_7'] = 'Emblemas emitidos';
$string['criteria_7_help'] = 'Permite que um emblema seja concedido aos usuários com base em outros emblemas que eles ganharam.';
$string['criteria_8'] = 'Membro de coorte';
$string['criteria_8_help'] = 'Permite que um emblema seja concedido aos usuários com base na associação de coorte.';
$string['criteria_9'] = 'Competências';
$string['criteria_9_help'] = 'Permite que um emblema seja concedido aos usuários com base nas competências que eles completaram.';
$string['criteria_descr'] = 'Os estudantes são premiados com este emblema quando concluem a seguinte condição:';
$string['criteria_descr_0'] = 'Concluir <strong>{$a}</strong> das condições listadas.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> das seguintes atividades estão concluídas:';
$string['criteria_descr_2'] = 'Este emblema deve ser concedido por usuários com <strong>{$a}</strong> dos seguintes papéis:';
$string['criteria_descr_4'] = 'Os usuários devem concluir o curso';
$string['criteria_descr_5'] = '<strong>{$a}</strong> dos seguintes cursos devem ser concluídos:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> dos seguintes campos de perfil de usuário devem ser preenchidos:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> dos seguintes emblemas devem ser conquistados:';
$string['criteria_descr_8'] = 'Participação em <strong>{$a}</strong> dos seguintes coortes é necessária:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> das seguintes competências prcisam estar concluídas:';
$string['criteria_descr_bydate'] = 'por <em>{$a}</em>';
$string['criteria_descr_grade'] = 'com nota mínima de <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Concluir <strong>{$a}</strong> de:&nbsp;';
$string['criteria_descr_short1'] = 'Concluir <strong>{$a}</strong> de:&nbsp;';
$string['criteria_descr_short2'] = 'Concedido por <strong>{$a}</strong> de:&nbsp;';
$string['criteria_descr_short4'] = 'Concluir o curso';
$string['criteria_descr_short5'] = 'Concluir <strong>{$a}</strong> de:&nbsp;';
$string['criteria_descr_short6'] = 'Concluir <strong>{$a}</strong> de:&nbsp;';
$string['criteria_descr_short7'] = 'Conclua <strong>{$a}</strong> de:';
$string['criteria_descr_short8'] = 'Participação no coorte em <strong>{$a}</strong> de:';
$string['criteria_descr_short9'] = 'Conclua <strong>{$a}</strong> de:';
$string['criteria_descr_single_1'] = 'A seguinte atividade deve ser concluída:';
$string['criteria_descr_single_2'] = 'Este emblema deve ser concedido por um usuário com o seguinte papel:';
$string['criteria_descr_single_4'] = 'Os usuários devem concluir o curso';
$string['criteria_descr_single_5'] = 'O seguinte curso deve ser concluído:';
$string['criteria_descr_single_6'] = 'O seguinte campo de perfil de usuário deve ser preenchido:';
$string['criteria_descr_single_7'] = 'O seguinte emblema deve ser ganho:';
$string['criteria_descr_single_8'] = 'É necessário ser membro do seguinte coorte:';
$string['criteria_descr_single_9'] = 'A seguinte competência precisa estar concluída:';
$string['criteria_descr_single_short1'] = 'Concluir:&nbsp;';
$string['criteria_descr_single_short2'] = 'Concedido por:&nbsp;';
$string['criteria_descr_single_short4'] = 'Concluir o curso';
$string['criteria_descr_single_short5'] = 'Concluir:&nbsp;';
$string['criteria_descr_single_short6'] = 'Concluir:&nbsp;';
$string['criteria_descr_single_short7'] = 'Completo:';
$string['criteria_descr_single_short8'] = 'Filiação em:';
$string['criteria_descr_single_short9'] = 'Conclua:';
$string['criteriacreated'] = 'Critério de emblema criado com sucesso';
$string['criteriadeleted'] = 'Critério de emblema excluído com sucesso';
$string['criteriasummary'] = 'Resumo dos critérios';
$string['criteriaupdated'] = 'Critério do emblema atualizado com sucesso';
$string['criterror'] = 'Problemas com parâmetros atuais';
$string['criterror_help'] = 'Esse conjunto de campos mostra todos os parâmetros que foram inicialmente adicionados como condições deste emblema e não estão mais disponíveis. É recomendado que você desmarque estes parâmetros para se certificar de que os usuários possam obter esse emblema no futuro.';
$string['currentimage'] = 'Imagem atual';
$string['currentstatus'] = 'Estado atual:&nbsp;';
$string['dateawarded'] = 'Data de emissão';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Dia(s)';
$string['deactivate'] = 'Desabilitar o acesso';
$string['deactivatesuccess'] = 'Acesso aos emblemas foi desabilitado com sucesso.';
$string['defaultissuercontact'] = 'Endereço de e-mail do emissor do emblema';
$string['defaultissuercontact_desc'] = 'Um endereço de e-mail associado ao emissor do emblema. Para uma mochila Open Badges v2.0, isso é usado para autenticação ao publicar emblemas em uma mochila.';
$string['defaultissuername'] = 'Nome do emissor do emblema';
$string['defaultissuername_desc'] = 'Nome do agente emissor ou autoridade.';
$string['defaultissuerpassword'] = 'Senha do emissor do emblema';
$string['defaultissuerpassword_help'] = 'É necessária uma conta no site da mochila com o endereço de e-mail, conforme especificado na configuração do endereço de e-mail do emissor do emblema em Administração do site / Emblemas / Configurações de emblemas. A senha da conta deve ser inserida aqui.';
$string['delbadge'] = 'Você gostaria de apagar o emblema \'{$a}\' e remover todos os emblemas que já foram emitidos?';
$string['delconfirm'] = 'Excluir e remover emblemas emitidos';
$string['delcritconfirm'] = 'Tem certeza de que deseja excluir este critério?';
$string['deletehelp'] = '<p>Excluir totalmente um emblema quer dizer que todas as inforações e registros de critérios serão permanentemente removidos. Usuários que obtiveram o emblema não poderão mais acessá-lo nem mostrá-lo na página de perfil.</p>
<p>Nota: Usuários que obtiveram o emblema e já o enviaram para uma mochila externa ainda terão este emblema em sua mochila externa. No entanto, não será possível acessar os critérios e páginas de evidência com links de volta para este site.</p>';
$string['delexternalbackpack'] = 'Excluir o site da Mochila';
$string['delexternalbackpackconfirm'] = 'Excluir site da mochila \'{$a}\'?';
$string['delparamconfirm'] = 'Tem certeza de que deseja excluir este parâmetro?';
$string['description'] = 'Descrição';
$string['disconnect'] = 'Desconectar';
$string['donotaward'] = 'No momento este emblema não está ativo, portanto não pode ser concedido aos usuários. Se você gostaria de conceder  este emblema, por favor, configure o status para ativo.';
$string['enablebadges'] = 'Habilitar emblemas';
$string['endorsement'] = 'Endosso';
$string['error:backpackdatainvalid'] = 'Os dados retornados pela mochila eram inválidos.';
$string['error:backpackemailnotfound'] = 'O e-mail "{$a}" não está associado com uma mochila. Você precisa <a href="http://backpack.openbadges.org">criar uma mochila</a> para essa conta ou entrar com outro endereço de e-mail.';
$string['error:badgeawardnotfound'] = 'Não é possível confirmar este emblema premiado. Este emblema pode ter sido revogado.';
$string['error:badgenotfound'] = 'Emblema não encontrado';
$string['error:cannotact'] = 'Não é possível ativar o emblema.';
$string['error:cannotawardbadge'] = 'Não pode conceder emblemas para um usuário.';
$string['error:cannotdeletecriterion'] = 'Este critério não pode ser excluído.';
$string['error:cannotrevokebadge'] = 'Não é possível revogar o emblema de um usuário.';
$string['error:clone'] = 'Não foi possível copiar o emblema.';
$string['error:connectionunknownreason'] = 'A conexão não foi bem sucedida, mas nenhuma razão foi dada.';
$string['error:duplicatename'] = 'Um emblema com esse nome já existe no sistema.';
$string['error:externalbadgedoesntexist'] = 'Emblema não encontrado';
$string['error:guestuseraccess'] = 'Você acessou como visitante. Para ver emblemas, você precisa fazer login com sua conta de usuário.';
$string['error:invalidcriteriatype'] = 'Tipo de critérios inválido.';
$string['error:invalidexpiredate'] = 'Data de validade deve estar no futuro.';
$string['error:invalidexpireperiod'] = 'Período de validade não pode ser negativo ou igual a 0.';
$string['error:invalidparambadge'] = 'Emblema não existe.';
$string['error:invalidparamcohort'] = 'Coorte não existe.';
$string['error:noactivities'] = 'Não há atividades com critérios de conclusão habilitadas neste curso.';
$string['error:nobadges'] = 'Não há nenhum emblema de curso ou site com acesso habilitado para ser adicionado como critério.
Atualmente não há emblemas com acesso habilitado para serem adicionados como critérios. Um emblema de site só pode ter como critério outros emblemas de site. Um emblema de curso pode ter como critério outros emblemas de curso ou emblemas de site.';
$string['error:nocohorts'] = 'Sem coortes';
$string['error:nocourses'] = 'A conclusão de curso não está habilitada para nenhum curso do site, então nenhum pode ser mostrado. A conclusão de curso pode ser habilitada nas configurações do curso.';
$string['error:nogroupslink'] = '<p>Somente coleções públicas são mostradas. <a href="{$a}" target="_blank" rel="nofollow">Visite sua mochila</a> para criar coleções publicas.</p>';
$string['error:nogroupssummary'] = '<p>Não há coleções públicas de emblemas disponíveis na sua mochila. </p>';
$string['error:nopermissiontoview'] = 'Você não tem permissões para ver os usuários que receberam emblemas';
$string['error:nosuchbadge'] = 'Emblema com id {$a} não existe.';
$string['error:nosuchcohort'] = 'Aviso: Este coorte não está mais disponível.';
$string['error:nosuchcourse'] = 'Aviso: Este curso não está mais disponível.';
$string['error:nosuchfield'] = 'Aviso: Este campo de perfil de usuário não está mais disponível.';
$string['error:nosuchmod'] = 'Aviso: Esta atividade não está mais disponível.';
$string['error:nosuchrole'] = 'Aviso: Este papel não está mais disponível.';
$string['error:nosuchuser'] = 'Usuário com este endereço de e-mail não tem uma conta com o provedor de mochilas atual.';
$string['error:notifycoursedate'] = 'Aviso: Emblemas associados com as conclusões de atividade e curso não serão emitidos até a data de início do curso.';
$string['error:parameter'] = 'Aviso: Pelo menos um parâmetro deve ser selecionado para assegurar a emissão apropriada do emblema.';
$string['error:relatedbadgedoesntexist'] = 'Não há emblema público com esse identificador';
$string['error:requesterror'] = 'O pedido de conexão falhou (código do erro {$a}).';
$string['error:requesttimeout'] = 'O pedido de conexão expirou antes que pudesse ser concluído.';
$string['error:save'] = 'Não é possível salvar o emblema.';
$string['error:userdeleted'] = '{$a->user} (Este usuário não existe mais em {$a->site})';
$string['eventbadgearchived'] = 'Emblema arquivado';
$string['eventbadgeawarded'] = 'Emblema emitido';
$string['eventbadgecreated'] = 'Emblema criado';
$string['eventbadgecriteriacreated'] = 'Critérios de emblema criados';
$string['eventbadgecriteriadeleted'] = 'Critérios de emblema excluídos';
$string['eventbadgecriteriaupdated'] = 'Critérios de emblema atualizados';
$string['eventbadgedeleted'] = 'Emblema excluído';
$string['eventbadgedisabled'] = 'Emblema desativado';
$string['eventbadgeduplicated'] = 'Emblema duplicado';
$string['eventbadgeenabled'] = 'Emblema ativado';
$string['eventbadgelistingviewed'] = 'Listagem de emblemas visualizada';
$string['eventbadgerevoked'] = 'Emblema revogado';
$string['eventbadgeupdated'] = 'Emblema atualizado';
$string['eventbadgeviewed'] = 'Emblema visualizado';
$string['evidence'] = 'Evidência';
$string['existingrecipients'] = 'Usuários que receberam emblemas';
$string['existsinbackpack'] = 'Emblema já existe na mochila';
$string['expired'] = 'Expirado';
$string['expiredate'] = 'Este emblema expira em {$a}.';
$string['expireddate'] = 'Este emblema expirou em {$a}.';
$string['expiredin'] = 'Expirado em {$a}';
$string['expireperiod'] = 'Este emblema expira {$a} dia(s) depois da emissão.';
$string['expireperiodh'] = 'Este emblema expira {$a} horas(s) depois da emissão.';
$string['expireperiodm'] = 'Este emblema expira {$a} minuto(s) depois da emissão.';
$string['expireperiods'] = 'Este emblema expira {$a} segundo(s) depois da emissão.';
$string['expiresin'] = 'Expira em {$a}';
$string['expirydate'] = 'Data de validade';
$string['expirydate_help'] = 'Opcionalmente, emblemas podem expirar em uma data específica ou a data pode ser calculada com base na data da emissão do emblema para o usuário.';
$string['externalbackpack_required'] = 'O provedor de mochila não pode ficar em branco';
$string['externalbadges'] = 'Meus emblemas de outros sites';
$string['externalbadges_help'] = 'Esta área exibe emblemas de mochilas externas.';
$string['externalbadgesp'] = 'Emblemas de outros sites:';
$string['externalconnectto'] = 'Para exibir emblemas externos que você precisa <a href="{$a}">conectar a uma mochila</a> .';
$string['fixed'] = 'Data fixa';
$string['hidden'] = 'Oculto';
$string['hiddenbadge'] = 'Infelizmente, o proprietário do emblema não disponibilizou esta informação.';
$string['hostedurl'] = 'URL externo';
$string['hostedurldescription'] = 'URL externo onde o emblema está hospedado';
$string['imageauthoremail'] = 'E-mail do autor da imagem';
$string['imageauthoremail_help'] = 'Se especificado, o endereço de e-mail do autor da imagem do emblema será exibido na página do emblema.';
$string['imageauthorname'] = 'Nome do autor da imagem';
$string['imageauthorname_help'] = 'Se especificado, o nome do autor da imagem do emblema será exibido na página do emblema.';
$string['imageauthorurl'] = 'URL do autor da imagem';
$string['imageauthorurl_help'] = 'Se especificado, um link para o site do autor da imagem do emblema é exibido na página do emblema. O URL deve ter um prefixo http: // ou https: //.';
$string['imagecaption'] = 'Legenda da imagem';
$string['imagecaption_help'] = 'Se especificado, uma legenda da imagem é exibida na página do emblema.';
$string['includeauthdetails'] = 'Inclui detalhes de autenticação com a mochila';
$string['invalidurl'] = 'URL inválida';
$string['issuancedetails'] = 'Expiração do emblema';
$string['issuedbadge'] = 'Informações do emblema emitido';
$string['issuedby'] = 'Emitido por {$a}';
$string['issuedon'] = '{$a} emitido';
$string['issuerdetails'] = 'Detalhes do emissor';
$string['issueremail'] = 'E-mail';
$string['issueremail_help'] = 'Um endereço de e-mail de contato da organização que está emitindo o endosso.';
$string['issuername'] = 'Nome do emissor';
$string['issuername_endorsement'] = 'Nome do endossante';
$string['issuername_endorsement_help'] = 'O nome do endossante.';
$string['issuername_help'] = 'Nome do agente ou da autoridade emissora.';
$string['issuerurl'] = 'URL do emissor';
$string['issuerurl_help'] = 'O site da organização emitindo o endosso. O URL deve ter um prefixo http: // ou https: //.';
$string['language'] = 'Idioma';
$string['language_help'] = 'O idioma usado na página do emblema.';
$string['listbackpacks'] = 'Lista de mochilas';
$string['localbadges'] = 'Meus emblemas do web site {$a}';
$string['localbadgesh'] = 'Meus emblemas deste web site';
$string['localbadgesh_help'] = 'Todos os emblemas ganhos neste web site por concluir cursos, atividades de cursos e outras condições.

Você pode gerenciar seus emblemas aqui tornando-os públicos ou particulares na sua página de perfil.

Você pode baixar todos os seus emblemas ou cada emblema separadamente e salvá-los em seu computador. Os emblemas baixados podem ser adicionados ao seu serviço de mochila externo.';
$string['localbadgesp'] = 'Emblemas de {$a}:';
$string['localconnectto'] = 'Para compartilhar estes emblemas fora deste site, você precisa <a href="{$a}">conectar a uma mochila</a> .';
$string['loginbackpacktitle'] = '<strong>Faça login na sua mochila</strong>';
$string['makeprivate'] = 'Tornar particular';
$string['makepublic'] = 'Tornar público';
$string['managebackpacks'] = 'Gerenciar mochilas';
$string['managebadges'] = 'Gerenciar emblemas';
$string['message'] = 'Corpo da mensagem';
$string['messagebody'] = '<p>Você foi premiado com o emblema "%badgename%"!</p>
<p>Mais informações sobre esse emblema podem ser encontradas na página de information em %badgelink%.</p>
<p>Você pode gerenciar e baixar o emblema da sua página {$a}.</p>';
$string['messagesubject'] = 'Parabéns! Você acabou de ganhar um emblema!';
$string['method'] = 'Este critério é concluído quando...';
$string['mingrade'] = 'Nota mínima exigida';
$string['month'] = 'Mês(es)';
$string['moredetails'] = 'Mais detalhes';
$string['mybackpack'] = 'Minhas configurações de mochila';
$string['mybadges'] = 'Meus emblemas';
$string['namewithlink'] = 'Nome com link';
$string['never'] = 'Nunca';
$string['newbackpack'] = 'Adicionar uma nova mochila';
$string['newbadge'] = 'Adicionar um novo emblema';
$string['newimage'] = 'Nova imagem';
$string['noalignment'] = 'Este emblema não possui habilidades ou padrões externos especificados.';
$string['noawards'] = 'Este emblema ainda não foi conquistado.';
$string['nobackpack'] = 'Não há serviço de mochila conectado a esta conta. <br/>';
$string['nobackpackbadgessummary'] = 'Não há emblemas nas coleções que você selecionou.';
$string['nobackpackcollectionssummary'] = 'Nenhuma coleção de emblemas foi selecionada.';
$string['nobackpacks'] = 'Não há mochilas disponíveis';
$string['nobadges'] = 'No momento, não há emblemas disponíveis.';
$string['nocompetencies'] = 'Nenhuma competência selecionada.';
$string['nocriteria'] = 'Os critérios para este emblema ainda não foram definidos.';
$string['noendorsement'] = 'Este emblema não possui um endosso.';
$string['noexpiry'] = 'Este emblema não possui uma data de expiração.';
$string['noparamstoadd'] = 'Não existem parâmetros adicionais disponíveis para adicionar a esta condição do emblema.';
$string['norelated'] = 'Este emblema não possui nenhum emblema relacionado.';
$string['notacceptedrole'] = 'Sua atribuição de papel atual não está entre os papéis que podem atribuir manualmente este emblema.<br/>
Se você gostaria de ver os usuários que já ganharam este emblema, você pode visitar a página {$a}.';
$string['notconnected'] = 'Não conectado';
$string['notealignment'] = 'Habilidades ou padrões externos, com os quais o emblema está associado, podem ser especificados. Quaisquer habilidades ou padrões externos são exibidos na página do emblema.';
$string['noteendorsement'] = 'Um endosso de um terceiro pode ser usado para agregar valor ao emblema. Por exemplo, um emblema emitido por um professor pode ser endossado pela escola, ou um emblema emitido por um órgão local de aprovação pode ser endossado pelo órgão nacional de concessão.';
$string['noterelated'] = 'Emblemas com uma conexão podem ser marcados como relacionados. Por exemplo, os emblemas com os mesmos critérios exibidos em diferentes idiomas podem ser marcados como relacionados. Quaisquer emblema relacionados são exibidos na página do emblema.';
$string['nothingtoadd'] = 'Não existem critérios disponíveis para adicionar.';
$string['notification'] = 'Notificar criador do emblema';
$string['notification_help'] = 'Esta configuração controla as notificações enviadas para um criador de emblema para que ele saiba que o emblema foi emitido.

As seguintes opções estão disponíveis:

* **NUNCA** – Não enviar notificações.

* **CADA VEZ** – Enviar uma notificação cada vez que este emblema é concedido.

* **DIÁRIO** – Enviar notificações uma vez por dia.

* **SEMANAL** – Enviar notificações uma vez por semana.

* **MENSAL** – Enviar notificações uma vez por mês.';
$string['notifydaily'] = 'Diariamente';
$string['notifyevery'] = 'Cada vez';
$string['notifymonthly'] = 'Mensal';
$string['notifyweekly'] = 'Semanal';
$string['numawards'] = 'Este emblema foi emitido para <a href="{$a->link}">{$a->count}</a> usuário(s).';
$string['numawardstat'] = 'Este emblema foi emitido {$a} usuário(s).';
$string['oauth2issuer'] = 'Serviços OAuth2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Outra navegação ...';
$string['overallcrit'] = 'critério(s) selecionado(s) for(em) concluído(s).';
$string['password_required'] = 'A senha não pode ficar em branco';
$string['potentialrecipients'] = 'Usuários aptos a receber o emblema';
$string['preferences'] = 'Preferências de emblema';
$string['privacy:metadata:backpack'] = 'Um registro de mochilas do usuário';
$string['privacy:metadata:backpack:backpackuid'] = 'O identificador exclusivo da mochila';
$string['privacy:metadata:backpack:email'] = 'O e-mail associado à mochila';
$string['privacy:metadata:backpack:externalbackpackid'] = 'O ID da mochila';
$string['privacy:metadata:backpack:userid'] = 'O ID do usuário da mochila';
$string['privacy:metadata:backpackoauth2'] = 'Informação do OAuth 2 quando o usuário conecta a uma mochila externa';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID do serviço OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Lista de escopo de conexão com a mochila';
$string['privacy:metadata:backpackoauth2:token'] = 'Token de conexão com a Mochila';
$string['privacy:metadata:backpackoauth2:userid'] = 'O ID do usuário conectado à mochila';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'O ID do usuário';
$string['privacy:metadata:badge'] = 'Uma coleção de emblemas';
$string['privacy:metadata:badge:timecreated'] = 'A hora em que o emblema foi criado';
$string['privacy:metadata:badge:timemodified'] = 'A hora em que o emblema foi modificado pela última vez';
$string['privacy:metadata:badge:usercreated'] = 'O ID do usuário que criou o emblema';
$string['privacy:metadata:badge:usermodified'] = 'O ID do usuário que modificou o emblema';
$string['privacy:metadata:criteriamet'] = 'Uma coleção de critérios que foram atendidos';
$string['privacy:metadata:criteriamet:datemet'] = 'A data em que os critérios foram atendidos';
$string['privacy:metadata:criteriamet:userid'] = 'O ID do usuário que atendeu aos critérios';
$string['privacy:metadata:external:backpacks'] = 'Informações compartilhadas quando os usuários enviam seus emblemas para uma mochila externa';
$string['privacy:metadata:external:backpacks:badge'] = 'O nome do emblema';
$string['privacy:metadata:external:backpacks:description'] = 'A descrição do emblema';
$string['privacy:metadata:external:backpacks:image'] = 'A imagem do emblema';
$string['privacy:metadata:external:backpacks:issuer'] = 'Algumas informações sobre o emissor';
$string['privacy:metadata:external:backpacks:url'] = 'O URL do Moodle onde as informações do emblema emitido podem ser vistas';
$string['privacy:metadata:issued'] = 'Um registro de emblemas concedidos';
$string['privacy:metadata:issued:dateexpire'] = 'A data em que o emblema expira';
$string['privacy:metadata:issued:dateissued'] = 'A data da concessão';
$string['privacy:metadata:issued:userid'] = 'O ID do usuário que recebeu um emblema';
$string['privacy:metadata:manualaward'] = 'Um registro de concessões manuais';
$string['privacy:metadata:manualaward:datemet'] = 'A data em que o usuário recebeu o emblema';
$string['privacy:metadata:manualaward:issuerid'] = 'O ID do usuário que concede o emblema';
$string['privacy:metadata:manualaward:issuerrole'] = 'O papel do usuário que concede o emblema';
$string['privacy:metadata:manualaward:recipientid'] = 'O ID do usuário que recebe manualmente um emblema';
$string['recipient'] = 'Destinatário do Emblema';
$string['recipientdetails'] = 'Detalhes do usuário a receber o emblema';
$string['recipientidentificationproblem'] = 'Não foi possível encontrar um que recebeu este emblema entre os usuários existentes.';
$string['recipients'] = 'Usuários que receberam o emblema';
$string['recipientvalidationproblem'] = 'Esse usuário não pode ser verificado como recebedor deste emblema.';
$string['relatedbages'] = 'Emblemas relacionados';
$string['relative'] = 'Data relativa';
$string['requiredbadge'] = 'Ao menos um emblema deve ser adicionado ao critério de emblemas.';
$string['requiredcohort'] = 'Pelo menos um coorte deve ser adicionado ao critério de coorte.';
$string['requiredcompetency'] = 'Pelo menos uma competência deve ser adicionada ao critério de competência.';
$string['requiredcourse'] = 'Pelo menos um curso deve ser adicionado ao critério conjunto de cursos.';
$string['reviewbadge'] = 'Alterações de acesso ao emblema';
$string['reviewconfirm'] = '<p>Isso tornará o emblema visível para os usuários e permitir-lhes começar a ganhá-lo. </p>

<p>É possível que alguns usuários já atendam aos critérios deste emblema e receberão este emblema imediatamente após ativá-lo. </p>

<p>Uma vez que um emblema foi emitido, ele será <strong>bloqueado</strong> - certas configurações, incluindo os critérios e as configurações de validade não poderão ser alterados. </p>

<p>Tem certeza que você deseja habilitar o acesso ao emblema \'{$a}\'?</p>';
$string['revoke'] = 'Revogar emblema';
$string['save'] = 'Salvar';
$string['searchname'] = 'Pesquisar por nome';
$string['selectaward'] = 'Por favor, selecione o papel que você gostaria de usar para conceder este emblema:&nbsp;';
$string['selectgroup_end'] = 'Somente coleções públicas são mostradas. <a href="{$a}">Visite sua mochila</a> para criar mais coleções públicas.';
$string['selectgroup_start'] = 'Selecione as coleções de sua mochila para mostrar neste site:';
$string['selecting'] = 'Com emblemas selecionados...';
$string['setup'] = 'Configurar a conexão';
$string['sitebackpackdeleted'] = 'O site de mochila foi excluído.';
$string['sitebackpacknotdeleted'] = 'Esta mochila não pode ser excluída porque é atualmente a padrão do site.';
$string['sitebackpackwarning'] = 'Não foi possível conectar a mochila. <br/><br/>Verifique se a configuração de administrador "Endereço de e-mail do emissor do emblema" é o e-mail válido para uma conta no site da mochila. <br/><br/>Verifique se "Senha do emissor do emblema" na <a href="{$a->url}">página de configurações da mochila do site</a>, é a senha correta para a conta no site da mochila. <br/><br/>A mochila retornou: "{$a->warning}"';
$string['sitebadges'] = 'Emblemas do site';
$string['sitebadges_help'] = 'Emblemas do site só podem ser concedidos aos usuários para atividades relacionadas ao site. Esses incluem a conclusão de um conjunto de cursos ou partes de perfis de usuário. Emblemas do site também podem ser emitidos manualmente de um usuário para outro.

Emblemas para atividades relacionadas com o curso deve ser criados no nível do curso. Emblemas do curso podem ser encontrados em Administração do curso > Emblemas.';
$string['sitebadgetitle'] = 'Emblema do site {$a}';
$string['status'] = 'Status do emblema';
$string['status_help'] = 'Status de um emblema determina seu comportamento no sistema:

* ** DISPONÍVEL** - Significa que este emblema pode ser conquistado pelos usuários. Enquanto um emblema estiver disponível para os usuários, os seus critérios não podem ser alterados.

* **NÃO DISPONÍVEL** - Significa que este emblema não está disponível para os usuários e não pode ser obtido ou emitido manualmente. Se tal emblema nunca foi emitido antes, os seus critérios podem ser alterados.

Uma vez que um emblema foi emitido pelo menos a um usuário, torna-se automaticamente **BLOQUEADO**. Emblemas bloqueados ainda podem ser obtidos pelos usuários, mas os seus critérios não podem mais serem alterados. Se você precisar modificar detalhes ou critérios de um emblema bloqueado, você pode duplicar este emblema e fazer todas as alterações necessárias.

*Por que bloqueamos os emblemas?*

Queremos ter certeza que todos os usuários concluam as mesmas condições para ganhar um emblema. Atualmente, não é possível revogar emblemas. Se permitirmos que as condições de emblemas sejam alteradas o tempo todo, nós provavelmente terminaríamos com usuários obtendo o mesmo emblema por concluir condições completamente diferentes.';
$string['statusmessage_0'] = 'Este emblema não está disponível para os usuários. Permita o acesso caso queira que os usuários ganhem este emblema.';
$string['statusmessage_1'] = 'Este emblema está disponível para os usuários. Desabilite o acesso para fazer quaisquer alterações.';
$string['statusmessage_2'] = 'Este emblema não está disponível para os usuários e seus critérios estão bloqueados. Permita o acesso caso queira que os usuários ganhem este emblema.';
$string['statusmessage_3'] = 'Este emblema está disponível para os usuários e seus critérios estão bloqueados.';
$string['statusmessage_4'] = 'Este emblema está arquivado.';
$string['subject'] = 'Assunto da mensagem';
$string['tagarea_badge'] = 'Emblemas';
$string['tags'] = 'Tags';
$string['targetcode'] = 'Código';
$string['targetcode_help'] = 'Uma "string" identificadora única para referenciar a habilidade ou padrão externo neste framework.';
$string['targetdescription'] = 'Descrição';
$string['targetdescription_help'] = 'Breve descrição da competência externa ou padrão.';
$string['targetframework'] = 'Framework';
$string['targetframework_help'] = 'O nome da competência externa ou estrutura padrão.';
$string['targetname'] = 'Nome';
$string['targetname_help'] = 'A competência, habilidade ou padrão com o qual o emblema está alinhado.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Um link para uma página descrevendo a competência, habilidade ou padrão. A URL deve ter um prefixo http:// ou https://.';
$string['testbackpack'] = 'Testar mochila \'{$a}\'';
$string['testsettings'] = 'Testar configurações';
$string['type'] = 'Tipo';
$string['userbadges'] = 'Emblemas de usuário';
$string['variablesubstitution'] = 'Substituição de variáveis nas mensagens.';
$string['variablesubstitution_help'] = 'Em uma mensagem de emblema, determinadas variáveis podem ser inserida no assunto e/ou no corpo de uma mensagem de modo que elas serão substituídass por valores reais quando a mensagem for enviada. As variáveis devem ser inseridas no texto da mesma forma que são mostradas a seguir. As seguintes variáveis podem ser usadas:

%badgename%
: Isso será substituído pelo nome completo do emblema.

%username%
: Isso será substituído pelo nome completo do destinatário.

%badgelink%
: Isto será substituído pela URL pública com informações sobre o emblema emitido.';
$string['verifyemail'] = 'Verifique o email';
$string['version'] = 'Versão';
$string['version_help'] = 'O campo da versão pode ser usado para acompanhar o desenvolvimento do emblema. Se especificada, a versão é exibida na página do emblema.';
$string['viewbadge'] = 'Ver emblema emitido';
$string['visible'] = 'Visível';
$string['warnexpired'] = '(Este emblema expirou!)';
$string['year'] = 'Ano(s)';
