<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'uk', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Дії';
$string['activate'] = 'Дозволити доступ';
$string['activatesuccess'] = 'Доступ до відзнак вже дозволено.';
$string['addalignment'] = 'Додайте зовнішні навички або стандарт';
$string['addbadge'] = 'Додайте відзнаку';
$string['addbadge_help'] = 'Виберіть усі відзнаки, які слід додати до вимоги цієї відзнаки. Утримуйте клавішу CTRL, щоб вибрати кілька елементів.';
$string['addbadgecriteria'] = 'Додати критерії відзнаки';
$string['addcohort'] = 'Додати когорту';
$string['addcohort_help'] = 'Виберіть усі когорти, які слід додати до вимоги цієї відзнаки. Утримуйте клавішу CTRL, щоб вибрати кілька елементів.';
$string['addcompetency'] = 'Додайте компетентності';
$string['addcompetency_help'] = 'Виберіть усі компетенції, які слід додати до вимоги цієї відзнаки. Утримуйте клавішу CTRL, щоб вибрати кілька елементів.';
$string['addcourse'] = 'Додати курси';
$string['addcourse_help'] = 'Виберіть всі курси, які потрібно додати до цієї відзнаки. Утримування кнопки CTRL дозволяє мультивибір.';
$string['addcriteria'] = 'Додати критерій';
$string['addcriteriatext'] = 'Для початку додавання критерія, будь ласка, виберіть одну опцію з випадаючого меню.';
$string['addedtobackpack'] = 'До торбинки додано відзнаку';
$string['addrelated'] = 'Додайте відповідну відзнаку';
$string['addtobackpack'] = 'Додати в торбину';
$string['adminonly'] = 'Ця сторінка тільки для адміністраторів сайту.';
$string['after'] = 'після моменту видання.';
$string['aggregationmethod'] = 'Метод агрегування';
$string['alignment'] = 'Вирівнювання';
$string['all'] = 'Все';
$string['allmethod'] = 'Всі вибрані умови';
$string['allmethodactivity'] = 'Всі вибрані діяльності завершені';
$string['allmethodbadges'] = 'Всі вибрані відзнаки були зароблені';
$string['allmethodcohort'] = 'Членство у всіх обраних когортах';
$string['allmethodcompetencies'] = 'Всі вибрані компетенції були завершені';
$string['allmethodcourseset'] = 'Всі вибрані курси завершені';
$string['allmethodmanual'] = 'Всі вибрані ролі присуджують відзнаку';
$string['allmethodprofile'] = 'Всі вибрані поля облікового запису заповнені';
$string['allowcoursebadges'] = 'Дозволити відзнаки курсу';
$string['allowcoursebadges_desc'] = 'Дозволяє створювати та присуджувати відзнаки в контексті курсу.';
$string['allowexternalbackpack'] = 'Зовнішнє підключення до торбин';
$string['allowexternalbackpack_desc'] = 'Якщо ввімкнено, користувачі можуть підключатися до зовнішнього рюкзака та ділитися своїми значками з цього сайту. Користувачі також можуть відображати будь-які загальнодоступні колекції значків зі свого зовнішнього рюкзака на сторінці профілю на цьому сайті. Рекомендується залишити цю опцію вимкненою, якщо ваш сайт недоступний з Інтернету.';
$string['any'] = 'Будь-який';
$string['anymethod'] = 'Будь-яка вибрана умова';
$string['anymethodactivity'] = 'Будь-яка з вибраних діяльностей завершена';
$string['anymethodbadges'] = 'Будь-яка із вибраних відзнак була зароблена';
$string['anymethodcohort'] = 'Членство в будь-якій із вибраних когорт';
$string['anymethodcompetencies'] = 'Будь-яка з обраних компетенцій була завершена';
$string['anymethodcourseset'] = 'Будь-які з вибраних курсів завершені';
$string['anymethodmanual'] = 'Будь-які з вибраних ролей присуджують відзнаки';
$string['anymethodprofile'] = 'Будь-які з вибраних полів облікового запису заповнені';
$string['apiversion'] = 'Версія API, що підтримується';
$string['archivebadge'] = 'Ви збираєтеся видалити відзнаку \'{$a}\', при цьому зберегти її попередні присудження?';
$string['archiveconfirm'] = 'Видалити але зберегти попередні присудження';
$string['archivehelp'] = '<p>Ця опція означає, що відзнака буде помічена як "застаріла" і більше не буде показуватися у списку відзнак. А користувачі більше не матимуть можливості її отримувати. Проте, у тих користувачів, яким раніше ця відзнака була присуджена, вона буде залишатися і вони зможуть демонструвати її на своїй персональній сторінці та пов’язувати зі своїми зовнішніми торбинками відзнак.</p>
<p>Якщо ви хочете, щоб всі попередні призначення відзнак залишалися у користувачів, важливо вибрати цю опцію замість повністю видалити відзнаку.</p>';
$string['attachment'] = 'Прикріпити відзнаку до повідомлення';
$string['attachment_help'] = 'Якщо ввімкнено, виданий значок буде долучено до електронної пошти одержувача для завантаження. (Щоб використовувати цю опцію, потрібно ввімкнути вкладення в налаштуваннях Адміністрування сайту / Сервер / Електронна пошта / Вихідна пошта.)';
$string['award'] = 'Присудити відзнаку';
$string['awardedto'] = 'Присуджено {$ a}';
$string['awardedtoyou'] = 'Видано мені';
$string['awardoncron'] = 'Доступ до відзнак було успішно включено. Занадто багато користувачів можуть миттєво заробиш цю відзнаку. Для забезпечення нормальної роботи сайту, ця дія займе деякий час для обробітку.';
$string['awards'] = 'Отримали';
$string['backpackapiurl'] = 'URL-адреса API торбинки';
$string['backpackavailability'] = 'Перевірка зовнішньої відзнаки';
$string['backpackavailability_help'] = 'Щоб одержувачі відзнак могли довести, що вони отримали їх від вас, зовнішній сервіс повинен мати доступ до вашого сайту та можливість перевірити з нього відзнаки. Ваш сайт в даний момент не є доступним, а значить видані вами відзнаки не можуть бути  перевіреними.

**Чому я бачу це повідомлення?**

Це може бути, якщо ваш брандмауер запобігає доступу користувачів з-за меж вашої мережі, ваш сайт захищено паролем або ви працюєте з сайтом на комп\'ютері, який не має доступу до інтернету (наприклад, локальна машина розробника).

**Чи є це проблемою?**

Ви, повинні вирішити цю проблему, якщо у вас повністю робочий сайт, де ви плануєте присуджувати відзнаки, інакше одержувачі не зможуть довести, що вони заробили свої відзнаки у вас. Якщо ваш сайт в розробці, ви можете створювати і присуджувати відзнаки не хвилюючись цим, поки не перейдете у виробничий режим.

**Що робити, якщо я не можу зробити мій сайт загальнодоступним?**

Для перевірки потрібен тільки доступ по [your-site-url]/badges/assertion.php, так що якщо ви в змозі внести зміни в брандмауер, щоб дозволити зовнішній доступ до цього файлу, перевірки відзнак все одно будуть працювати.';
$string['backpackbadgessettings'] = 'Змініть параметри торбинки';
$string['backpackbadgessummary'] = 'У вас є відзнака "{$a->totalbadges}" з колекцій (-ів) "{$a->totalcollections}".';
$string['backpackcannotsendverification'] = 'Не вдається надіслати електронний лист для підтвердження';
$string['backpackconnected'] = 'Торбинку підключено';
$string['backpackconnection'] = 'Підключіть до рюкзака';
$string['backpackconnection_connected'] = 'Ваш рюкзак';
$string['backpackconnection_help'] = 'Зберігайте та діліться своїми значками з цього сайту та відображайте загальнодоступні значки з інших веб-сайтів у своєму профілі користувача.';
$string['backpackconnectioncancelattempt'] = 'Підключіться за допомогою іншої адреси електронної пошти';
$string['backpackconnectionconnect'] = 'Підключіть до торбинки';
$string['backpackconnectionnottested'] = 'Для цієї торбинки неможливо перевірити з’єднання, оскільки його підтримують лише торбинки Open Badges v2.0.';
$string['backpackconnectionok'] = 'З\'єднання з торбинкою успішно встановлено';
$string['backpackconnectionresendemail'] = 'Відправити лист з підтвердженням';
$string['backpackconnectionunexpectedmessage'] = 'Торбинка повернула помилку: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Виникла проблема підключення до вашого рюкзака. Ваш постачальник рюкзака надсилає це повідомлення: "{$a}".';
$string['backpackdetails'] = 'Налаштування торбинки відзнак';
$string['backpackdisconnected'] = 'Торбинка відключена';
$string['backpackemail'] = 'Ел.пошта';
$string['backpackemail_help'] = 'Адреса електронної пошти, пов\'язаний з вашою торбинкою відзнак. Якщо з\'єднання з торбинкою встановлено, то ця адреса використовується замість вашої внутрішньої адреси електронної пошти, щоб передати відзнаку у вашу торбинку.';
$string['backpackemail_required'] = 'Адреса електронної пошти не може бути пустою';
$string['backpackemailverificationpending'] = 'Очікується перевірка';
$string['backpackemailverifyemailbody'] = 'Привіт, {$a->userfirstname},

Ви майже завершили підключення до свого рюкзака з значками на \'{$a->sitename}\'.

Щоб завершити підключення до вашого рюкзака, підтвердьте свою адресу електронної пошти за допомогою такої кнопки: {$a->buttonlink}

Якщо кнопка не працює, ви можете скопіювати та вставити наступну URL-адресу у свій браузер: {$a->link}

Якщо ви не намагалися підключитися до свого рюкзака з значками, можете сміливо ігнорувати цей електронний лист.

Щоб отримати додаткову допомогу, зверніться до служби підтримки свого сайту, {$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Підтвердження електронної пошти в торбинці з відзнаками';
$string['backpackemailverifypending'] = 'Ми надіслали електронний лист на <strong>{$a}</strong>. Натисніть на посилання підтвердження в електронному листі, щоб активувати з’єднання з рюкзаком.';
$string['backpackemailverifysuccess'] = 'Тепер ви підключені до свого рюкзака.';
$string['backpackemailverifytokenmismatch'] = 'Токен у посиланні, на яке ви натиснули, не відповідає збереженому маркеру. Переконайтеся, що ви натиснули посилання в останній отриманій електронній пошті.';
$string['backpackexporterror'] = 'Неможливо експортувати відзнаку до торбинки';
$string['backpackexporterrorwithinfo'] = 'Не вдається експортувати бейдж "{$a->badgename}" у рюкзак. Помилка: {$a->error}';
$string['backpackimport'] = 'Налаштування імпорту відзнак';
$string['backpackimport_help'] = 'Після успішного встановлення з’єднання з вашою торбинкою, відзнаки звідти можуть показуватися на сторінці "Мої відзнаки" та сторінці вашого профілю.

Тут ви можете вибрати колекції відзнак з вашої торбинки, які ви хочете показувати на своїй профільній сторінці.';
$string['backpackprovider'] = 'Постачальник торбинок';
$string['backpacksettings'] = 'Налаштування емітента нагород';
$string['backpackweburl'] = 'URL-адреса торбинки';
$string['badgedetails'] = 'Детальніше про відзнаку';
$string['badgeimage'] = 'Зображення';
$string['badgeimage_help'] = 'Розмір зображення має бути не менше 300 x 300 пікселів. Він буде відображатися у розмірі 300 x 300 пікселів на сторінці значка та 100 x 100 пікселів на сторінці профілю користувача.';
$string['badgeissued'] = 'Значок видано';
$string['badgeprivacysetting'] = 'Налаштування конфіденційності відзнаки';
$string['badgeprivacysetting_help'] = 'Отримані вами значки можуть відображатися на сторінці профілю вашого облікового запису. Цей параметр дозволяє автоматично налаштувати видимість щойно зароблених значків. Ви все ще можете керувати налаштуваннями конфіденційності окремих значків на сторінці значків.';
$string['badgeprivacysetting_str'] = 'Автоматично показувати відзнаки на моїй персональній сторінці';
$string['badges'] = 'Відзнаки';
$string['badgesalt'] = 'Сіль для хешування електронної адреси одержувача';
$string['badgesalt_desc'] = 'Використання хешування дозволяє сервісам торбинок підтверджувати отримані відзнаки без потреби перевірки адреси електронної пошти. Це опція повинна використовувати тільки числа та літери.

Примітка: з метою перевірки отримувача, будь ласка, не змінюйте цю опцію від часу початку присудження відзнак.';
$string['badgesdisabled'] = 'Відзнаки на цьому сайті не включено.';
$string['badgesearned'] = 'Кількість отриманих відзнак: {$a}';
$string['badgesettings'] = 'Налаштування відзнак';
$string['badgestatus_0'] = 'Недоступно';
$string['badgestatus_1'] = 'Доступно';
$string['badgestatus_2'] = 'Недоступно (критерії заблоковано)';
$string['badgestatus_3'] = 'Доступно (критерії заблоковано)';
$string['badgestatus_4'] = 'Архів';
$string['badgestoearn'] = 'Кількість доступних відзнак: {$a}';
$string['badgesview'] = 'Відзнаки курсу';
$string['badgetags'] = 'Теги значка';
$string['badgeurl'] = 'Видана посилання відзнаки';
$string['balignment'] = 'Відповідність ({$a})';
$string['bawards'] = 'Одержувачі ({$a})';
$string['bcriteria'] = 'Критерій';
$string['bdetails'] = 'Редагувати деталі';
$string['bendorsement'] = 'Підтвердження';
$string['bmessage'] = 'Повідомлення';
$string['boverview'] = 'Огляд';
$string['brelated'] = 'Пов’язані відзнаки ({$a})';
$string['bydate'] = 'завершити до';
$string['claim'] = 'Заявка';
$string['claimcomment'] = 'Коментар підтвердження';
$string['claimid'] = 'URL-адреса заявки';
$string['clearsettings'] = 'Очистити налаштування';
$string['completioninfo'] = 'Ця відзнака присуджена за завершення:';
$string['completionnotenabled'] = 'Функціонал завершення курсу не включено на цьому курсі, тому він не може бути включеним в критерії відзнаки. Завершення курсу може бути включене в параметрах курсу.';
$string['configenablebadges'] = 'Якщо ввімкнено, ця функція дозволяє створювати значки та нагороджувати їх користувачам сайту.';
$string['configuremessage'] = 'Повідомлення відзнаки';
$string['connect'] = 'З’єднання';
$string['connected'] = 'З’єднано';
$string['connecting'] = 'З’єднання...';
$string['contact'] = 'Контакт';
$string['contact_help'] = 'Ел.адреса пов’язана з видавцем відзнаки.';
$string['copyof'] = 'Копія {$a}';
$string['course'] = 'Курс: {$ a}';
$string['coursebadges'] = 'Відзнаки';
$string['coursebadgesdisabled'] = 'Відзнаки курсу не дозволені на цьому сайті.';
$string['coursebadgetitle'] = 'Відзнака курсу {$ a}';
$string['coursecompletion'] = 'Користувачі повинні завершити цей курс.';
$string['create'] = 'Нова відзнака';
$string['createbutton'] = 'Створити відзнаку';
$string['creatorbody'] = '<p>{$a->user} виконав(ла) всі вимоги та нагороджен(а)ий відзнакою. Переглянути видану відзнаку на {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' був(ла) нагороджен(а)ий!';
$string['criteria_0'] = 'Ця відзнака видається, коли ...';
$string['criteria_1'] = 'По завершенню виду діяльності';
$string['criteria_1_help'] = 'Дозволяє отримання відзнаки користувачами на основі завершення комплексу заходів (діяльностей) протягом курсу.';
$string['criteria_2'] = 'Присуджується роллю';
$string['criteria_2_help'] = 'Дозволяє отримання відзнаки користувачами за допомогою ручної відмітки користувачем з вказанною роллю.';
$string['criteria_3'] = 'Суспільна участь';
$string['criteria_3_help'] = 'Суспільне';
$string['criteria_4'] = 'По завершенню курсу';
$string['criteria_4_help'] = 'Дозволяє отримання відзнаки користувачами на основі завершення курсу. Цей критерій може мати додаткові параметри, такі як мінімальна кінцева оцінка та дата закінчення курсу.';
$string['criteria_5'] = 'Завершення набору курсів';
$string['criteria_5_help'] = 'Дозволяє отримання відзнаки користувачами на основі завершення набору курсів. Кожен курс може мати додаткові параметри, такі як мінімальна кінцева оцінка та дата закінчення курсу.';
$string['criteria_6'] = 'По заповненню профілю';
$string['criteria_6_help'] = 'Дозволяє отримання відзнаки користувачами на основі заповнення вказаних полів у своєму профілі. Ви можете вибрати з типових та додаткових полів профілю користувача.';
$string['criteria_7'] = 'Нагороджені відзнаками';
$string['criteria_7_help'] = 'Дозволяє вручати відзнаки користувачам на основі інших відзнак, які вони заробили.';
$string['criteria_8'] = 'Когортне членство';
$string['criteria_8_help'] = 'Дозволяє вручати відзнаку користувачам на основі членства в когорті.';
$string['criteria_9'] = 'Компетенції';
$string['criteria_9_help'] = 'Дозволяє вручати відзнаку користувачам на основі їх компетенції.';
$string['criteria_descr'] = 'Користувачі нагороджуються цією відзнакою, коли вони виконали такі вимоги:';
$string['criteria_descr_0'] = 'Виконайте <strong>{$a}</strong> із перелічених вимог.';
$string['criteria_descr_1'] = '<strong>{$a}</strong>  з перерахованих діяльностей виконано:';
$string['criteria_descr_2'] = 'Ця відзнака присуджується користувачам <strong>{$a}</strong> такими ролями:';
$string['criteria_descr_4'] = 'Користувачі повинні завершити цей курс';
$string['criteria_descr_5'] = '<strong>{$a}</strong> з перерахованих курсів повинні бути завершені:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> з перерахованих полів профілю користувача повинні бути заповнені:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> з таких відзнак потрібно заробити:';
$string['criteria_descr_8'] = 'Потрібне членство в <strong>{$a}</strong> таких когортах:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> з таких компетенцій має бути завершено:';
$string['criteria_descr_bydate'] = 'на <em>{$a}</em>';
$string['criteria_descr_grade'] = 'з мінімальною оцінкою - <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Завершено <strong>{$a}</strong> з:';
$string['criteria_descr_short1'] = 'Завершено <strong>{$a}</strong> з:';
$string['criteria_descr_short2'] = 'Присуджено <strong>{$a}</strong> з:';
$string['criteria_descr_short4'] = 'Закінчено курс';
$string['criteria_descr_short5'] = 'Завершено <strong>{$a}</strong> з:';
$string['criteria_descr_short6'] = 'Завершено <strong>{$a}</strong> з:';
$string['criteria_descr_short7'] = 'Повні <strong>{$a}</strong> із:';
$string['criteria_descr_short8'] = 'Когортне членство в <strong>{$a}</strong> з:';
$string['criteria_descr_short9'] = 'Повні <strong>{$a}</strong> із:';
$string['criteria_descr_single_1'] = 'Наступні діяльності повинні бути завершені:';
$string['criteria_descr_single_2'] = 'Ця відзнака присуджується користувачами з такими ролями:';
$string['criteria_descr_single_4'] = 'Користувачі повинні завершити курс';
$string['criteria_descr_single_5'] = 'Цей курс повинен бути завершеним:';
$string['criteria_descr_single_6'] = 'Ці поля профілю користувача повинні бути заповнені:';
$string['criteria_descr_single_7'] = 'Потрібно заробити таку відзнаку:';
$string['criteria_descr_single_8'] = 'Необхідно членство в такій когорті:';
$string['criteria_descr_single_9'] = 'Необхідно заповнити такі компетенції:';
$string['criteria_descr_single_short1'] = 'Завершено:';
$string['criteria_descr_single_short2'] = 'Присуджено:';
$string['criteria_descr_single_short4'] = 'Завершено курс';
$string['criteria_descr_single_short5'] = 'Завершено:';
$string['criteria_descr_single_short6'] = 'Завершено:';
$string['criteria_descr_single_short7'] = 'Завершено:';
$string['criteria_descr_single_short8'] = 'Членство в:';
$string['criteria_descr_single_short9'] = 'Завершено:';
$string['criteriacreated'] = 'Критерій відзнаки успішно створено';
$string['criteriadeleted'] = 'Критерій відзнаки успішно вилучено';
$string['criteriasummary'] = 'Перелік критеріїв';
$string['criteriaupdated'] = 'Критерій відзнаки успішно створено';
$string['criterror'] = 'Актуальні параметри отримання';
$string['criterror_help'] = 'Це поле показує всі параметри, які від початку були визначені як вимоги отримання цієї відзнаки але на даний момент є недоступними для виконання. Рекомендуємо вам перевірити всі ці параметри, щоб впевнитися, що користувачі в подальшому матимуть змогу отримати цю відзнаку.';
$string['currentimage'] = 'Поточне зображення';
$string['currentstatus'] = 'Поточний статус:';
$string['dateawarded'] = 'Дата отримання';
$string['dateearned'] = 'Дата:  {$a}';
$string['day'] = 'День(ів)';
$string['deactivate'] = 'Заборонити доступ';
$string['deactivatesuccess'] = 'Доступ до відзнак успішно відключено.';
$string['defaultissuercontact'] = 'Електронна адреса видавця відзнаки';
$string['defaultissuercontact_desc'] = 'Електронна адреса, пов’язана з емітентом відзнаки. Для торбинки Open Badges v2.0 він використовується для автентифікації під час публікації відзнак у торбинці.';
$string['defaultissuername'] = 'Ім’я видавця відзнаки';
$string['defaultissuername_desc'] = 'Назва агента присудження або уповноваженого.';
$string['defaultissuerpassword'] = 'Пароль видавця відзнаки';
$string['defaultissuerpassword_help'] = 'На сайті торбинки потрібен обліковий запис із адресою електронної пошти, зазначеною в налаштуваннях електронної адреси видавця відзнаки в розділі Адміністрування сайту / Відзнаки / Відзнаки. Тут потрібно ввести пароль облікового запису.';
$string['delbadge'] = 'Ви хочете видалити відзнаку \'{$a}\' та та всі її попередні присудження?';
$string['delconfirm'] = 'Вилучити разом з наявними виданими відзнаками';
$string['delcritconfirm'] = 'Ви впевнені, що хочете видалити цей критерій?';
$string['deletehelp'] = '<p>Повне видалення відзнаки означає, що буде видалено про неї вся інформація та її критерії. Користувачі, які раніше отримали цю відзнаку більше не будуть мати до неї доступу та не зможуть демонструвати її на своїй персональній сторінці.</p>
<p>Примітка: користувачі, які вже отримали цю відзнаку та розмістили її у своїй зовнішній торбинці відзнак, вже її там не втратять. Проте вони не зможуть отримати доступ до критеріїв та фактичних посилань на відзнаку на цьому сайті.</p>';
$string['delexternalbackpack'] = 'Видалити торбинку сайту';
$string['delexternalbackpackconfirm'] = 'Видалити торбинку сайту "{$a}"?';
$string['delparamconfirm'] = 'Ви впевнені, що бажаєте видалити цей параметр?';
$string['description'] = 'Опис';
$string['disconnect'] = 'Відключити';
$string['donotaward'] = 'Наразі, ця відзнака неактивна, тому не може присуджуватися користувачам. Якщо ви хочете комусь присудити цю відзнаку, спочатку зробіть її активною.';
$string['enablebadges'] = 'Включити відзнаки';
$string['endorsement'] = 'Підтвердження';
$string['error:backpackdatainvalid'] = 'Повернення даних з торбинки визнано недійсним.';
$string['error:backpackemailnotfound'] = 'Ел.пошта  \'{$a}\'  не пов’язана з торбинкою. Вам потрібно <a href="http://backpack.openbadges.org">створити торбинку</a> для цього облікового запису або зареєструватися з іншою адресою ел.пошти.';
$string['error:badgeawardnotfound'] = 'Неможливо підтвердити цю нагороджену відзнаку. Можливо, ця відзнака була анульована.';
$string['error:badgenotfound'] = 'Не знайдено відзнаку';
$string['error:cannotact'] = 'Не вдається активувати відзнаку.';
$string['error:cannotawardbadge'] = 'Не вдається призначити відзнаку користувачу.';
$string['error:cannotdeletecriterion'] = 'Цей критерій не можна видаляти.';
$string['error:cannotrevokebadge'] = 'Не вдається видалити відзнаку у користувача.';
$string['error:clone'] = 'Не вдається скопіювати відзнаку.';
$string['error:connectionunknownreason'] = 'З’єднання не вдалося, але причина цього не вказана.';
$string['error:duplicatename'] = 'Відзнака з такою назвою вже існує в системі.';
$string['error:externalbadgedoesntexist'] = 'Відзнаку не знайдено';
$string['error:guestuseraccess'] = 'Наразі ви використовуєте гостьовий доступ. Щоб побачити відзнаки, потрібно увійти до системи під своїм обліковим записом.';
$string['error:invalidcriteriatype'] = 'Хибний тип критерію.';
$string['error:invalidexpiredate'] = 'Дата закінчення терміну дії повинна бути у майбутньому.';
$string['error:invalidexpireperiod'] = 'Період терміну дії не може бути від’ємним або дорівнювати 0.';
$string['error:invalidparambadge'] = 'Відзнаки не існує.';
$string['error:invalidparamcohort'] = 'Когорта не існує.';
$string['error:noactivities'] = 'На цьому курсі немає видів діяльності, що мають дозволений критерій завершення.';
$string['error:nobadges'] = 'Наразі жодних відзнак із дозволеним доступом не можна додати як критерії. Відзнака сайту може містити лише інші відзнаки сайту як критерій. Відзнака курсу може мати за критерії інші відзнаки курсу або відзнаки сайту.';
$string['error:nocohorts'] = 'Без когорт';
$string['error:nocourses'] = 'Слідкування за завершенням курсу не включено для жодного курсу на цьому сайті, тому не може бути показаним. Включити цю функціональність можна в налаштуваннях курсу.';
$string['error:nogroupslink'] = '<p> Відображаються лише загальнодоступні колекції. <a href="{$a}" target="_blank" rel="nofollow"> Відвідайте свою торбинку </a>, щоб створити загальнодоступні колекції. </p>';
$string['error:nogroupssummary'] = '<p> У вашій торбинці немає загальнодоступних колекцій відзнак. </p>';
$string['error:nopermissiontoview'] = 'Ви не маєте права переглядати отримувачів відзнаки';
$string['error:nosuchbadge'] = 'Відзнаки з кодом {$a} не існує.';
$string['error:nosuchcohort'] = 'Попередження. Ця когорта більше недоступна.';
$string['error:nosuchcourse'] = 'Увага: цей курс більше недоступний.';
$string['error:nosuchfield'] = 'Увага: це поле користувача більше недоступне.';
$string['error:nosuchmod'] = 'Увага: ця діяльність більше недоступна.';
$string['error:nosuchrole'] = 'Увага: ця роль більше недоступна.';
$string['error:nosuchuser'] = 'Користувач з цією ел.адресою не має облікового запису у поточного постачальника торбинок відзнак.';
$string['error:notifycoursedate'] = 'Увага: Відзнаки пов’язані з завершенням курсу або діяльності не можуть призначатися до дати початку навчання на курсі.';
$string['error:parameter'] = 'Увага: Принаймні один параметр повинен бути обраний, щоб забезпечити правильність робочого процесу видачі відзнак.';
$string['error:relatedbadgedoesntexist'] = 'З цим ідентифікатором немає загальнодоступної відзнаки';
$string['error:requesterror'] = 'З’єднання зазнало невдачі (код помилки {$a}).';
$string['error:requesttimeout'] = 'Запит на з’єднання закінчився по тайм ауту.';
$string['error:save'] = 'Не вдається зберегти відзнаку.';
$string['error:userdeleted'] = '{$a->user} (Такого користувача більше не існує в  {$a->site})';
$string['eventbadgearchived'] = 'Архівовано відзнаку';
$string['eventbadgeawarded'] = 'Видано відзнаку';
$string['eventbadgecreated'] = 'Створено відзнаку';
$string['eventbadgecriteriacreated'] = 'Створені критерії відзнаки';
$string['eventbadgecriteriadeleted'] = 'Видалені критерії відзнаки';
$string['eventbadgecriteriaupdated'] = 'Оновлено критерії відзнаки';
$string['eventbadgedeleted'] = 'Відзнака видалена';
$string['eventbadgedisabled'] = 'Відзнака вимкнена';
$string['eventbadgeduplicated'] = 'Відзнака скопійована';
$string['eventbadgeenabled'] = 'Відзнака ввімкнена';
$string['eventbadgelistingviewed'] = 'Переглянуто список відзнак';
$string['eventbadgerevoked'] = 'Відзнака відмінена';
$string['eventbadgeupdated'] = 'Відзнака оновлена';
$string['eventbadgeviewed'] = 'Відзнака переглянута';
$string['evidence'] = 'Докази';
$string['existingrecipients'] = 'Існуючі одержувачі відзнаки';
$string['existsinbackpack'] = 'У торбинці вже є відзнака';
$string['expired'] = 'Закінчено';
$string['expiredate'] = 'Ця відзнака закінчується  {$a}.';
$string['expireddate'] = 'Ця відзнака закінчилася  {$a}.';
$string['expiredin'] = 'Термін дії закінчився {$ a}';
$string['expireperiod'] = 'Ця відзнака закінчується через {$a} день(ів) після присудження.';
$string['expireperiodh'] = 'Ця відзнака закінчується через {$a} год. після присудження.';
$string['expireperiodm'] = 'Ця відзнака закінчується через {$a} хв. після присудження.';
$string['expireperiods'] = 'Ця відзнака закінчується через {$a} сек. після присудження.';
$string['expiresin'] = 'Закінчується {$ a}';
$string['expirydate'] = 'Дата завершення';
$string['expirydate_help'] = 'Додатково, термін дії відзнаки може закінчуватися вказаною датою або датою вирахуваною відносно дати тримання цієї відзнаки користувачем.';
$string['externalbackpack_required'] = 'Постачальник рюкзака не може бути пустим';
$string['externalbadges'] = 'Мої відзнаки з інших сайтів';
$string['externalbadges_help'] = 'Тут показуються відзнаки з ваших зовнішніх торбинок.';
$string['externalbadgesp'] = 'Відзнаки з інших сайтів:';
$string['externalconnectto'] = 'Для показу зовнішніх відзнак вам необхідно <a href="{$a}">з’єднатися з торбинкою</a>.';
$string['fixed'] = 'Фіксована дата';
$string['hidden'] = 'Прихований';
$string['hiddenbadge'] = 'На жаль, власник відзнаки не зробив цю інформацію доступною.';
$string['hostedurl'] = 'Зовнішня URL-адреса';
$string['hostedurldescription'] = 'Зовнішня URL-адреса, на якій розміщено значок';
$string['imageauthoremail'] = 'Адреса ел. пошти автора зображення';
$string['imageauthoremail_help'] = 'Якщо вказано, електронна адреса автора зображення значка відображається на сторінці значка.';
$string['imageauthorname'] = 'Ім’я автора зображення';
$string['imageauthorname_help'] = 'Якщо вказано, ім’я автора зображення значка відображається на сторінці значка.';
$string['imageauthorurl'] = 'URL-адреса автора зображення';
$string['imageauthorurl_help'] = 'Якщо вказано, на сторінці значка відображається посилання на веб-сайт автора зображення значка. URL-адреса повинна мати префікс http:// або https://.';
$string['imagecaption'] = 'Зображення підпису';
$string['imagecaption_help'] = 'Якщо вказано, на сторінці значка відображається зображення підпису.';
$string['includeauthdetails'] = 'Додайте до торбинки деталі автентифікації';
$string['invalidurl'] = 'Недійсна URL-адреса';
$string['issuancedetails'] = 'Відзнака не актуальна';
$string['issuedbadge'] = 'Інформація присудження відзнаки';
$string['issuedby'] = 'Видано {$ a}';
$string['issuedon'] = 'Видано {$ a}';
$string['issuerdetails'] = 'Деталі присудження';
$string['issueremail'] = 'Електронна пошта';
$string['issueremail_help'] = 'Контактна адреса електронної пошти організації, яка видає підтвердження.';
$string['issuername'] = 'Ім’я видавця';
$string['issuername_endorsement'] = 'Назва підтвердження';
$string['issuername_endorsement_help'] = 'Ім’я підтверджуючого';
$string['issuername_help'] = 'Назва агента присудження або уповноваженого.';
$string['issuerurl'] = 'URL видавця';
$string['issuerurl_help'] = 'Веб-сайт організації, що видає підтвердження. URL-адреса має мати префікс http: // або https: //.';
$string['language'] = 'Мова';
$string['language_help'] = 'Мова, яка використовується на сторінці відзнаки.';
$string['listbackpacks'] = 'Список торбинок';
$string['localbadges'] = 'Мої відзнаки з  {$a}';
$string['localbadgesh'] = 'Мої відзнаки з цього сайту';
$string['localbadgesh_help'] = 'Всі відзнаки отримані на цьому сайті через завершення курсів, діяльностей та іншого.

Ви можете управляти своїми відзнаками роблячи їх загальнодоступними на сторінці свого профілю або приховуючи їх.

Ви можете завантажити всі ваші відзнаки або кожну окремо на свій комп’ютер. Збережені відзнаки можуть бути доданими до ваших зовнішніх торбинок відзнак.';
$string['localbadgesp'] = 'Відзнаки з  {$a}:';
$string['localconnectto'] = 'Щоб зробити ці відзнаки загальнодоступними поза цим сайтом, вам  потрібно <a href="{$a}">з’єднатися з торбинкою відзнак</a>.';
$string['loginbackpacktitle'] = '<strong>Увійдіть у свій рюкзак</strong>';
$string['makeprivate'] = 'Не показувати';
$string['makepublic'] = 'Показувати';
$string['managebackpacks'] = 'Керування торбинками';
$string['managebadges'] = 'Керування відзнаками';
$string['message'] = 'Текст повідомлення';
$string['messagebody'] = '<p>Ви нагороджені відзнакою "%badgename%"!</p> <p>Детальну інформацію про цю відзнаку можете знайти на %badgelink%.</p> <p>Ви маєте можливість переглянути та завантажити відзнаку зі сторінки {$a}.</p>';
$string['messagesubject'] = 'Вітаємо! Ви отримали відзнаку!';
$string['method'] = 'Цей критерій вважається виконаним, коли ...';
$string['mingrade'] = 'Мінімальна необхідна оцінка';
$string['month'] = 'Місяць(ів)';
$string['moredetails'] = 'Детальніше';
$string['mybackpack'] = 'Налаштування моєї торбинки';
$string['mybadges'] = 'Мої відзнаки';
$string['never'] = 'Ніколи';
$string['newbackpack'] = 'Додати торбинку';
$string['newbadge'] = 'Додати відзнаку';
$string['newimage'] = 'Нове зображення';
$string['noalignment'] = 'Ця відзнака не містить жодних зовнішніх навичок або стандартів.';
$string['noawards'] = 'Ця відзнака ще не присуджувалася.';
$string['nobackpack'] = 'Немає приєднаних сервісів торбинок для цього облікового запису.<br/>';
$string['nobackpackbadgessummary'] = 'У вибраних колекціях немає відзнак.';
$string['nobackpackcollectionssummary'] = 'Не вибрано жодної колекції відзнак.';
$string['nobackpacks'] = 'Торбинок немає';
$string['nobadges'] = 'Наразі немає доступних для користувачів значків.';
$string['nocompetencies'] = 'Компетенції не обрані.';
$string['nocriteria'] = 'Критерій для цієї відзнаки ще не встановлено.';
$string['noendorsement'] = 'Ця відзнака не має підтвердження.';
$string['noexpiry'] = 'Ця відзнака не має терміну.';
$string['noparamstoadd'] = 'Немає додаткових параметрів, щоб додати до вимог отримання відзнаки.';
$string['norelated'] = 'Ця відзнака не має пов’язаних відзнак.';
$string['notacceptedrole'] = 'Ваша поточна роль не належить до тих, які можуть присуджувати відзнаки. <br/>Якщо ви бажаєте переглянути список користувачів, які вже отримали цю відзнаки, завітайте на сторінку {$a}.';
$string['notconnected'] = 'Не з’єднано';
$string['notealignment'] = 'Можуть бути вказані зовнішні навички або стандарти, за якими відповідає відзнака. Будь-які зовнішні навички або стандарти відображаються на сторінці відзнаки.';
$string['noteendorsement'] = 'Візуалізація від третьої сторони може бути використана для додавання вартості відзнаки. Наприклад, нагрудна відзнака, видана вчителем, може бути схвалена школою, або відзнака, видана місцевим органом нагородження, може бути відзначена національним органом нагородження.';
$string['noterelated'] = 'Відзнаки з підключенням можуть бути позначені як пов\'язані. Наприклад, відзнаки з однаковими критеріями, які відображаються різними мовами, можуть бути позначені як пов’язані. Усі відповідні відзнаки відображаються на сторінці відзнак.';
$string['nothingtoadd'] = 'Немає доступних критеріїв для додавання.';
$string['notification'] = 'Повідомити творця відзнаки';
$string['notification_help'] = 'Це налаштування управляє повідомленнями, що відправляються творцям відзнаки, щоб сповістити їх, що відзнака була видана. Доступні такі опції:

* **НІКОЛИ** - не надсилати повідомлення.

* **ЩОРАЗУ** - надсилати повідомлення кожного разу, коли відзнака присуджується.

* **ЩОДЕННО** - надсилати повідомлення раз на день.

* **ЩОТИЖНЕВО** - надсилати повідомлення раз на тиждень.

* **ЩОМІСЯЧНО** - надсилати повідомлення раз на місяць.';
$string['notifydaily'] = 'Щоденно';
$string['notifyevery'] = 'Щоразу';
$string['notifymonthly'] = 'Щомісячно';
$string['notifyweekly'] = 'Щотижнево';
$string['numawards'] = 'Цю відзнаку отримали <a href="{$a->link}">{$a->count}</a> користувач(ів).';
$string['numawardstat'] = 'Цю відзнаку отримали {$a} користувач(ів).';
$string['oauth2issuer'] = 'Послуги OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Інша навігація...';
$string['overallcrit'] = 'з вибраних критеріїв виконано.';
$string['password_required'] = 'Пароль не може бути пустим';
$string['potentialrecipients'] = 'Потенційні отримувачі відзнаки';
$string['preferences'] = 'Налаштування відзнак';
$string['privacy:metadata:backpack'] = 'Запис торбинок користувача';
$string['privacy:metadata:backpack:backpackuid'] = 'Унікальний ідентифікатор торбинки';
$string['privacy:metadata:backpack:email'] = 'Електронна пошта, пов’язана з торбинкою';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Ідентифікатор торбинки';
$string['privacy:metadata:backpack:userid'] = 'Ідентифікатор користувача, чия це торбинка';
$string['privacy:metadata:backpackoauth2'] = 'Інформація OAuth 2, коли користувач підключається до зовнішньої торбинки';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'Ідентифікатор служби OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Список областей підключення торбинки';
$string['privacy:metadata:backpackoauth2:token'] = 'Токен з\'єднання торбинки';
$string['privacy:metadata:backpackoauth2:userid'] = 'Ідентифікатор користувача, який підключається до торбинки';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Ідентифікатор користувача, зміненого з\'єднання';
$string['privacy:metadata:badge'] = 'Колекція відзнак';
$string['privacy:metadata:badge:timecreated'] = 'Час створення відзнаки';
$string['privacy:metadata:badge:timemodified'] = 'Час останньої зміни відзнаки';
$string['privacy:metadata:badge:usercreated'] = 'Ідентифікатор користувача, який створив відзнаку';
$string['privacy:metadata:badge:usermodified'] = 'Ідентифікатор користувача, який змінив відзнаку';
$string['privacy:metadata:criteriamet'] = 'Сукупність критеріїв, які були виконані';
$string['privacy:metadata:criteriamet:datemet'] = 'Дата виконання критеріїв';
$string['privacy:metadata:criteriamet:userid'] = 'Ідентифікатор користувача, який відповідав критеріям';
$string['privacy:metadata:external:backpacks'] = 'Інформація, що надсилається, коли користувачі надсилають свої відзнаки у зовнішню торбинку';
$string['privacy:metadata:external:backpacks:badge'] = 'Назва відзнаки';
$string['privacy:metadata:external:backpacks:description'] = 'Опис відзнаки';
$string['privacy:metadata:external:backpacks:image'] = 'Зображення відзнаки';
$string['privacy:metadata:external:backpacks:issuer'] = 'Деякі відомості про емітента';
$string['privacy:metadata:external:backpacks:url'] = 'URL-адреса Moodle, де можна побачити інформацію про видану відзнаку';
$string['privacy:metadata:issued'] = 'Запис нагороджених відзнак';
$string['privacy:metadata:issued:dateexpire'] = 'Дата закінчення дії відзнаки';
$string['privacy:metadata:issued:dateissued'] = 'Дата вручення нагороди';
$string['privacy:metadata:issued:userid'] = 'Ідентифікатор користувача, якому вручено відзнаку';
$string['privacy:metadata:manualaward'] = 'Запис вручення нагород';
$string['privacy:metadata:manualaward:datemet'] = 'Дата, коли користувач отримав відзнаку';
$string['privacy:metadata:manualaward:issuerid'] = 'Ідентифікатор користувача, який нагороджує відзнакою';
$string['privacy:metadata:manualaward:issuerrole'] = 'Роль користувача, який нагороджує відзнакою';
$string['privacy:metadata:manualaward:recipientid'] = 'Ідентифікатор користувача, якому вручається відзнака';
$string['recipient'] = 'Значок видано';
$string['recipientdetails'] = 'Деталі отримувача';
$string['recipientidentificationproblem'] = 'Не вдається знайти отримувача цієї відзнаки серед існуючих користувачів.';
$string['recipients'] = 'Отримувачі відзнаки';
$string['recipientvalidationproblem'] = 'Цього користувача не можна підтвердити як одержувача цього значка.';
$string['relatedbages'] = 'Пов\'язані відзнаки';
$string['relative'] = 'Відносна дата';
$string['requiredbadge'] = 'Принаймні одну відзнаку потрібно додати до критерію відзнаки.';
$string['requiredcohort'] = 'Принаймні одну когорту слід додати до критерію когорти.';
$string['requiredcompetency'] = 'Принаймні одну компетентність слід додати до критерію компетентності.';
$string['requiredcourse'] = 'Принаймні один курс слід додати до критерію завершеного курсу.';
$string['reviewbadge'] = 'Переглянути критерії відзнаки';
$string['reviewconfirm'] = '<p>Це зробить вашу відзнаку доступною користувачам, і вони зможуть її отримувати.</p>

<p>Цілком можливо, що деякі користувачі вже відповідають критеріям цієї відзнаки, тож вини отримають її відразу після включення.</p>

<p>Як тільки буде видано першу відзнаку, вона буде <strong>заблокована</strong> від змін - деякі параметри, включаючи критерії присудження, більше не можна буде змінювати.</p>

<p>Ви впевнені, що готові включити доступ до відзнаки \'{$a}\'?</p>';
$string['revoke'] = 'Відмінити відзнаку';
$string['save'] = 'Зберегти';
$string['searchname'] = 'Шукати за назвою';
$string['selectaward'] = 'Будь ласка, вкажіть роль, якій ви доручите присудження цієї відзнаки:';
$string['selectgroup_end'] = 'Показано лише загальнодоступні колекції. <a href="{$a}">Відвідайте свій рюкзак</a>, щоб створити більше загальнодоступних колекцій.';
$string['selectgroup_start'] = 'Виберіть колекції з вашої торбинки для показу на цьому сайті:';
$string['selecting'] = 'З вибраними відзнаками...';
$string['setup'] = 'Налаштувати з’єднання';
$string['sitebackpackdeleted'] = 'Торбинку сайту видалено.';
$string['sitebackpacknotdeleted'] = 'Неможливо видалити цю торбинку, оскільки зараз вона є сайтом за замовчуванням.';
$string['sitebackpackwarning'] = 'Не вдалося підключитися до торбинки. <br/> <br/> Перевірте, чи налаштування адміністратора "Електронна адреса видавця відзнаки" є дійсною електронною адресою для облікового запису на веб-сайті торбинки. <br/> <br/> Перевірте, чи "пароль видавця відзнаки" на <a href="{$a->url} "> сторінці налаштувань торбинки сайту </a> є правильним паролем для облікового запису на веб-сайт для торбинок. <br/> <br/> Результат: "{$a->warning}"';
$string['sitebadges'] = 'Відзнаки сайту';
$string['sitebadges_help'] = 'Відзнаки сайту присуджуються користувачам тільки за діяльності рівня сайту. Це включає завершення курсів та заповнення полів профілю користувача. Відзнаки сайту можуть також присуджуватися користувачам іншими користувачами.

Відзнаки курсу повинні створюватися на рівні курсу. Відзнаки курсу можна знайти в <b>Керування курсом > Відзнаки</b>.';
$string['sitebadgetitle'] = 'відзнака сайту {$ a}';
$string['status'] = 'Статус відзнаки';
$string['status_help'] = 'Статус відзнаки визначає її поведінку в системі:

* **ДОСТУПНА** - означає, що ця відзнака може бути отримана користувачами. Поки відзнака доступна користувачам, її критерії не можна змінювати.

* **НЕ ДОСТУПНА** - означає, що ця відзнака не доступна користувачам і не може бути отримана або присуджена вручну. Якщо відзнака ще не присуджувалася, то її критерії можуть бути зміненими. Якщо відзнака присуджена хоча б одному користувачу, вона автоматично стає **БЛОКОВАНА**. Заблоковані відзнаки можуть присуджуватися користувачам, але їхні критерії вже не можуть змінюватися. Якщо вам потрібно змінити деталі або критерії заблокованої відзнаки, ви можете здублювати цю відзнаку та зробити відповідні зміни.

*Чому ми блокуємо відзнаки?*

Ми хочемо бути переконаними, що всі користувачі отримують однакові вимоги для відзнак. В даний час це неможливо без скасування відзнак. Якщо дозволити критеріям відзнак змінюватися у будь-який час, то врешті-решт ми отримаємо набір тих же самих відзнак, отриманих за різними вимогами.';
$string['statusmessage_0'] = 'Ця відзнака наразі недоступна користувачам. Включіть доступ, якщо ви хочете щоб отримували цю відзнаку.';
$string['statusmessage_1'] = 'Ця відзнака наразі доступна користувачам. Відключіть доступ, щоб робити будь-які зміни.';
$string['statusmessage_2'] = 'Ця відзнака наразі недоступна користувачам та її критерії заблоковані. Включіть доступ, якщо ви хочете щоб отримували цю відзнаку.';
$string['statusmessage_3'] = 'Ця відзнака наразі доступна користувачам та її критерії заблоковані.';
$string['statusmessage_4'] = 'Ця відзнака наразі архівована.';
$string['subject'] = 'Тема повідомлення';
$string['tagarea_badge'] = 'Значки';
$string['tags'] = 'Теги';
$string['targetcode'] = 'Код';
$string['targetcode_help'] = 'Унікальний ідентифікатор рядка для посилання на зовнішні навички або стандарт у його рамках.';
$string['targetdescription'] = 'Опис';
$string['targetdescription_help'] = 'Короткий опис зовнішньої майстерності або стандарту.';
$string['targetframework'] = 'Основа';
$string['targetframework_help'] = 'Назва зовнішнього вміння або стандартної основи.';
$string['targetname'] = 'Назва';
$string['targetname_help'] = 'Зовнішня майстерність або стандарт, з яким узгоджується відзнака';
$string['targeturl'] = 'URL-адреса';
$string['targeturl_help'] = 'Посилання на сторінку, що описує зовнішню майстерність або стандарт. URL -адреса має мати префікс http: // або https: //.';
$string['testbackpack'] = 'Тестова торбинка "{$a}"';
$string['testsettings'] = 'Налаштування тесту';
$string['type'] = 'Тип';
$string['userbadges'] = 'Бейджі користувачів';
$string['variablesubstitution'] = 'Змінні в повідомленнях.';
$string['variablesubstitution_help'] = 'В повідомленні про отримання відзнаки можуть бути задіяні певні змінні в темі або/та у власне повідомленні, які в процесі генерації листа будуть замінені реальними значеннями. Змінні повинні бути вставлені в текст точності так, як показано нижче. Можна використати такі змінні:

%badgename%
: Буде замінено повною назвою відзнаки.

%username%
: Буде замінено повним ім’ям отримувача відзнаки.

%badgelink%
: Буде замінено публічним URL з інформацією про отриману відзнаку.';
$string['verifyemail'] = 'Підтвердити електронну адресу';
$string['version'] = 'Версія';
$string['version_help'] = 'Поле версії може використовуватися для відстеження розвитку значка. Якщо вказано, версія відображається на сторінці значка.';
$string['viewbadge'] = 'Переглянути отриману відзнаку';
$string['visible'] = 'Показано';
$string['warnexpired'] = '(Ця відзнака не актуальна!)';
$string['year'] = 'Роки';
