<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'organizer', language 'cs', version '4.3'.
 *
 * @package     organizer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absolutedeadline'] = 'Ukončení registrace';
$string['actionlink_delete'] = 'odstranit';
$string['actionlink_edit'] = 'Upravit';
$string['actionlink_eval'] = 'Vyhodnotit';
$string['actionlink_print'] = 'vytisknout';
$string['actions'] = 'Akce';
$string['actions_help'] = 'Akce s vybraným termínem.';
$string['allowcreationofpasttimeslots'] = 'Vytváření termínů v minulosti';
$string['allowsubmissionsfromdate'] = 'Zahájení registrace';
$string['allowsubmissionstodate'] = 'Ukončení registrace';
$string['alwaysshowdescription'] = 'Vždy zobrazovat popis';
$string['appointment_reminder_student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} máte schůzku {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['appointment_reminder_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} máte skupinovou schůzku {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['appointment_reminder_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Připomenutí skupinové schůzky';
$string['appointment_reminder_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Připomenutí schůzky';
$string['appointment_reminder_teacher:digest:fullmessage'] = 'Dobrý den {$a->receivername}!

Zítra máte následující schůzky:

{$a->digest}

Systém zasílání zpráv Moodle';
$string['appointment_reminder_teacher:digest:subject'] = 'Přehled schůzek';
$string['appointment_reminder_teacher:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} máte schůzku se studenty dne {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['appointment_reminder_teacher:group:digest:fullmessage'] = 'Dobrý den {$a->receivername}!

Zítra máte následující schůzky:

{$a->digest}

Systém zasílání zpráv Moodle';
$string['appointment_reminder_teacher:group:digest:subject'] = 'Přehled schůzek';
$string['appointment_reminder_teacher:smallmessage'] = 'Máte schůzku se studenty dne {$a->date} v {$a->time} v místě {$a->location}.';
$string['appointment_reminder_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Připomenutí schůzky';
$string['appointmentcomments'] = 'Poznámky';
$string['appointmentdatetime'] = 'Datum a čas';
$string['assign_notify_student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, máte naplánovanou schůzku s {$a->slot_teacher} dne {$a->date} v {$a->time}. Termín byl vybrán uživatelem {$a->sendername}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Datum: {$a->date} v {$a->time}

S pozdravem,
{$a->sendername}

Tato zpráva byla zaslána automaticky systémem Moodle.';
$string['assign_notify_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, máte naplánovanou skupinovou schůzku s {$a->slot_teacher} dne {$a->date} v {$a->time}. Termín pro vaši skupinu {$a->groupname} byl vybrán uživatelem {$a->sendername}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Datum: {$a->date} v {$a->time}

S pozdravem,
{$a->sendername}

Tato zpráva byla zaslána automaticky systémem Moodle.';
$string['assign_notify_student:group:smallmessage'] = 'Termín schůzky s {$a->slot_teacher} dne {$a->date} v {$a->time} byl vybrán pro vaší skupinu {$a->groupname} uživatelem {$a->sendername}.';
$string['assign_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Termín schůzky vybraný učitelem';
$string['assign_notify_student:smallmessage'] = 'Termín schůzky s {$a->slot_teacher} dne {$a->date} v {$a->time} vám byl vybrán uživatelem {$a->sendername}.';
$string['assign_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Termín schůzky vybraný učitelem';
$string['assign_notify_teacher:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, máte naplánovanou schůzku s {$a->slot_teacher} dne {$a->date} v {$a->time}. Termín byl vybrán uživatelem {$a->sendername}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Datum: {$a->date} v {$a->time}

Tato zpráva byla zaslána automaticky systémem Moodle.';
$string['assign_notify_teacher:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, máte naplánovanou skupinovou schůzku s {$a->groupname} dne {$a->date} v {$a->time}. Termín byl vybrán uživatelem {$a->sendername}.

Skupina: {$a->groupname}
Umístění: {$a->slot_location}
Datum: {$a->date} v {$a->time}

Tato zpráva byla zaslána automaticky systémem Moodle.';
$string['assign_notify_teacher:group:smallmessage'] = 'Termín schůzky se skupinou {$a->groupname} dne {$a->date} v {$a->time} byl vybrán uživatelem {$a->sendername}.';
$string['assign_notify_teacher:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Termín schůzky vybrán';
$string['assign_notify_teacher:smallmessage'] = 'Termín schůzky s {$a->sendername} dne {$a->date} v {$a->time} byl vybrán uživatelem {$a->sendername}.';
$string['assign_notify_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Termín schůzky vybrán';
$string['assign_title'] = 'Přiřazení termínu schůzky';
$string['assignsuccess'] = 'Termín byl úspěšně přiřazen a účastníci byli upozorněni.';
$string['atlocation'] = 'v místě';
$string['attended'] = 'zúčastnil(a) se';
$string['availability'] = 'Dostupnost';
$string['availablefrom'] = 'Rezervace možné od';
$string['availableslotsfor'] = 'Volné termíny pro';
$string['btn_add'] = 'Přidání nových termínů';
$string['btn_assign'] = 'Přiřadit termín';
$string['btn_comment'] = 'Upravit poznámku';
$string['btn_delete'] = 'Odstranit vybrané termíny';
$string['btn_deletesingle'] = 'Odstranit vybraný termín';
$string['btn_edit'] = 'Upravit vybrané termíny';
$string['btn_editsingle'] = 'Upravit vybraný termín';
$string['btn_eval'] = 'Vyhodnotit vybrané termíny';
$string['btn_eval_short'] = 'Vyhodnotit';
$string['btn_evalsingle'] = 'Vyhodnotit vybraný termín';
$string['btn_print'] = 'Vytisknout vybrané termíny';
$string['btn_printsingle'] = 'Vytisknout vybraný termín';
$string['btn_reeval'] = 'Znovu vyhodnotit účast';
$string['btn_register'] = 'Registrovat se';
$string['btn_remind'] = 'Odeslat připomenutí';
$string['btn_reregister'] = 'Změna registrace';
$string['btn_save'] = 'Uložit poznámku';
$string['btn_sendall'] = 'Odeslat připomínku všem studentům bez naplánované schůzky';
$string['btn_start'] = 'Začít';
$string['btn_unregister'] = 'Zrušit registraci';
$string['configemailteachers'] = 'Odesílat učitelům e-mailová oznámení o změnách stavu registrace.';
$string['confighour'] = 'hodina';
$string['confighours'] = 'hodin';
$string['confirm_conflicts'] = 'Opravdu chcete ignorovat kolize a vytvořit tyto termíny?';
$string['confirm_delete'] = 'Odstranit';
$string['datapreviewtitle'] = 'Náhled výstupu';
$string['datetime_help'] = 'Datum a čas úseku.';
$string['day_0'] = 'Pondělí';
$string['day_1'] = 'Úterý';
$string['day_2'] = 'Středa';
$string['day_3'] = 'Čtvrtek';
$string['day_4'] = 'Pátek';
$string['day_5'] = 'Sobota';
$string['day_6'] = 'Neděle';
$string['defaultsingleslotprintfields'] = 'Výchozí zobrazení údajů z profilu uživatele';
$string['deleteheader'] = 'Odstranění následujících termínů:';
$string['details_help'] = 'Stav tohoto termínu.';
$string['downloadfile'] = 'Stáhnout soubor';
$string['duedate'] = 'Platný termín';
$string['duration'] = 'Doba trvání';
$string['edit_notify_student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byly změněny podrobnosti o události {$a->sendername} dne {$a->date} v {$a->time}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Maximální počet účastníků: {$a->slot_maxparticipants}
Poznámky:
{$a->slot_comments}

Systém zasílání zpráv Moodle';
$string['edit_notify_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byly změněny podrobnosti o skupinové události {$a->sendername} dne {$a->date} v {$a->time}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Maximální počet účastníků: {$a->slot_maxparticipants}
Poznámky:
{$a->slot_comments}

Systém zasílání zpráv Moodle';
$string['edit_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Podrobnosti schůzky byly změněny.';
$string['edit_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Podrobnosti schůzky byly změněny.';
$string['edit_notify_teacher:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byly upraveny podrobnosti termínu {$a->date} v {$a->time} uživatelem {$a->sendername}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Maximální počet účastníků: {$a->slot_maxparticipants}
Poznámky:
{$a->slot_comments}

Systém zasílání zpráv Moodle';
$string['edit_notify_teacher:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byly upraveny podrobnosti termínu {$a->date} v {$a->time} uživatelem {$a->sendername}.

Učitel: {$a->slot_teacher}
Umístění: {$a->slot_location}
Maximální počet účastníků: {$a->slot_maxparticipants}
Poznámky:
{$a->slot_comments}

Systém zasílání zpráv Moodle';
$string['edit_notify_teacher:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Podrobnosti schůzky byly změněny.';
$string['edit_notify_teacher:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Podrobnosti schůzky byly změněny.';
$string['edit_submit'] = 'Potvrdit změny';
$string['emailteachers'] = 'Odesílání e-mailových oznámení učitelům';
$string['err_availablefromearly'] = 'Toto datum nelze nastavit později než počáteční datum!';
$string['err_availablefromlate'] = 'Toto datum nelze nastavit později než koncové datum!';
$string['err_enddate'] = 'Koncové datum nelze nastavit před počátečním datem!';
$string['err_location'] = 'Je třeba zadat místo události!';
$string['err_startdate'] = 'Počáteční datum nelze nastavit před dnešním datem ({$a->now})!';
$string['eval_attended'] = 'Zúčastnil(a) se';
$string['eval_feedback'] = 'Zpětná vazba';
$string['eval_grade'] = 'Vyhodnotit';
$string['eval_header'] = 'Vybrané termíny';
$string['eval_no_participants'] = 'Na tento termín nejsou registrovaní žádní účastníci';
$string['eval_not_occured'] = 'Čas schůzky ještě nenastal.';
$string['eval_notify_newappointment:student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byla vyhodnocena účast vaší schůzky {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Učitel kurzu umožnil znovu se zaregistrovat na jiný dostupný termín v plánovači {$a->organizername}.

Systém zasílání zpráv Moodle';
$string['eval_notify_newappointment:student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byla vyhodnocena účast vaší skupinové schůzky {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Učitel kurzu umožnil znovu se zaregistrovat na jiný dostupný termín v plánovači {$a->coursefullname}.

Systém zasílání zpráv Moodle';
$string['eval_notify_newappointment:student:group:smallmessage'] = 'Byla vyhodnocena účast vaší skupinové schůzky dne {$a->date} v {$a->time} v místě {$a->location}.';
$string['eval_notify_newappointment:student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Vyhodnocení schůzky';
$string['eval_notify_newappointment:student:smallmessage'] = 'Byla vyhodnocena účast vaší schůzky dne {$a->date} v {$a->time} v místě {$a->location}.';
$string['eval_notify_newappointment:student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Vyhodnocení schůzky';
$string['eval_notify_student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byla vyhodnocena účast vaší schůzky {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['eval_notify_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} byla vyhodnocena účast vaší skupinové schůzky {$a->sendername} dne {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['eval_notify_student:group:smallmessage'] = 'Byla vyhodnocena účast vaší skupinové schůzky dne {$a->date} v {$a->time} v místě {$a->location}.';
$string['eval_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Vyhodnocení schůzky';
$string['eval_notify_student:smallmessage'] = 'Byla vyhodnocena účast vaší schůzky dne {$a->date} v {$a->time} v místě {$a->location}.';
$string['eval_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Vyhodnocení schůzky';
$string['evaluate'] = 'Vyhodnotit';
$string['eventappointmentevaluated'] = 'Schůzka byla vyhodnocena.';
$string['eventappwith:single'] = 'Schůzka';
$string['eventnoparticipants'] = 'Žádní účastníci';
$string['eventslotcreated'] = 'Nové termíny byly vytvořeny.';
$string['eventslotdeleted'] = 'Termín byl smazán.';
$string['eventslotupdated'] = 'Termín byl aktualizován.';
$string['eventslotviewed'] = 'Termín byl zobrazen.';
$string['eventtemplate'] = '{$a->courselink} / {$a->organizerlink}: {$a->appwith} {$a->with} {$a->participants}<br />Místo konání: {$a->lokace}<br />';
$string['eventtemplatewithoutlinks'] = '{$a->coursename} / {$a->organizátor}: {$a->appwith} {$a->with} {$a->participants}<br />Místo konání: {$a->lokace}<br />';
$string['exportsettings'] = 'Nastavení exportu';
$string['filtertable_help'] = 'Prohledat vypsané termíny podle zadaného řetězce.';
$string['font_large'] = 'velké';
$string['font_medium'] = 'střední';
$string['font_small'] = 'malé';
$string['format'] = 'Formát';
$string['gap'] = 'Časový odstup';
$string['group_registration_notify:student:queue:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} přidal(a) vaší skupinu {$a->groupname} do čekací listiny na termín {$a->date} v {$a->time} v místě {$a->lokaci}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:queue:group:smallmessage'] = '{$a->sendername} přidal(a) skupinu {$a->groupname} na čekací listinu termínu {$a->date} v {$a->time}.';
$string['group_registration_notify:student:queue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina zapsána na čekací listinu';
$string['group_registration_notify:student:register:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} zaregistroval(a) vaši skupinu {$a->groupname} na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:register:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} zaregistroval(a) vaši skupinu {$a->groupname} na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:register:group:smallmessage'] = '{$a->sendername} zaregistroval(a) vaši skupinu {$a->groupname} na termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:register:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina registrována';
$string['group_registration_notify:student:register:smallmessage'] = '{$a->sendername} zaregistroval(a) vaši skupinu {$a->groupname} na termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:register:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina registrována';
$string['group_registration_notify:student:reregister:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} znovu zaregistroval(a) vaši skupinu {$a->skupinový název} na termín {$a->date} od {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:reregister:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} znovu zaregistroval(a) vaši skupinu {$a->skupinový název} na termín {$a->date} od {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:reregister:group:smallmessage'] = '{$a->sendername} změnil(a) registraci vaší skupiny {$a->groupname} na nový termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:reregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Změna registrace skupiny';
$string['group_registration_notify:student:reregister:smallmessage'] = '{$a->sendername} změnil(a) registraci vaší skupiny {$a->groupname} na nový termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:reregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Změna registrace skupiny';
$string['group_registration_notify:student:unqueue:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->courseid} {$a->coursefullname}, {$a->sendername} odebral(a) vaši skupinu {$a->groupname} z čekací listiny na termín {$a->date} v {$a->time} v místě  {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:unqueue:group:smallmessage'] = '{$a->sendername} odebral(a) vaší skupinu {$a->groupname} z čekací listiny na termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:unqueue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina byla odebrána z čekací listiny.';
$string['group_registration_notify:student:unregister:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} odhlásil(a) vaši skupinu {$a->groupname} z termínu {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:unregister:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname}, {$a->sendername} odhlásil(a) vaši skupinu {$a->groupname} z termínu {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['group_registration_notify:student:unregister:group:smallmessage'] = '{$a->sendername} zrušil(a) registraci vaší skupiny {$a->groupname} na termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:unregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Zrušení skupinové schůzky';
$string['group_registration_notify:student:unregister:smallmessage'] = '{$a->sendername} zrušil(a) registraci vaší skupiny {$a->groupname} na termín {$a->date} v {$a->time}.';
$string['group_registration_notify:student:unregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Zrušení skupinové schůzky';
$string['group_slot_available'] = 'Termín je k dispozici';
$string['group_slot_full'] = 'Termín je obsazen';
$string['groupmodeexistingcoursegroups'] = 'Použít existující skupiny v kurzu';
$string['groupmodenogroups'] = 'Individuální schůzky';
$string['groupmodeslotgroups'] = 'Vytvoření skupiny na prázdný časový úsek';
$string['groupmodeslotgroupsappointment'] = 'Vytvoření skupiny podle rezervovaného času';
$string['groupwarning'] = 'Podívejte se na možnosti skupiny níže!';
$string['headerfooter'] = 'Tisknout záhlaví/zápatí';
$string['hidecalendar'] = 'Skrýt kalendář';
$string['img_title_due'] = 'Termín je vypsán';
$string['img_title_evaluated'] = 'Účast v termínu je vyhodnocena';
$string['img_title_no_participants'] = 'Tento termín neměl žádné účastníky';
$string['img_title_past_deadline'] = 'Vypršela lhůta pro registraci na tento termín.';
$string['img_title_pending'] = 'Tato schůzka čeká na vyhodnocení účasti';
$string['includetraineringroups'] = 'Zahrnout školitele do skupin';
$string['infobox_app_countdown'] = 'Čas zbývající do události: {$a->days} dnů, {$a->hours} hodin, {$a->minutes} minut, {$a->sekund} sekund';
$string['infobox_app_occured'] = 'Schůzka již proběhla.';
$string['infobox_deadline_countdown'] = 'Čas zbývající do uzavření registrace: {$a->days} dnů, {$a->hours} hodin, {$a->minutes} minut, {$a->sekund} sekund';
$string['infobox_deadline_passed'] = 'Lhůta pro registraci uplynula. Registrace již nelze měnit.';
$string['infobox_deadline_passed_slot'] = 'xxx termínů nelze vytvořit, protože uplynula lhůta pro registraci.';
$string['infobox_feedback_title'] = 'Zpětná vazba';
$string['infobox_mycomments_title'] = 'Moje poznámky';
$string['infobox_myslot_noslot'] = 'Aktuálně nejste registrován(a) na žádný termín.';
$string['infobox_myslot_title'] = 'Můj termín';
$string['infobox_organizer_expires'] = 'Platnost tohoto plánovače vyprší {$a->date} v {$a->time}.';
$string['infobox_showfreeslots'] = 'Volné termíny';
$string['infobox_showhiddenslots'] = 'Skryté termíny';
$string['infobox_showmyslotsonly'] = 'Moje termíny';
$string['infobox_showregistrationsonly'] = 'Rezervované termíny';
$string['infobox_showslots'] = 'Minulé termíny';
$string['infobox_slotoverview_title'] = 'Přehled termínů';
$string['isgrouporganizer'] = 'Skupinové schůzky';
$string['location'] = 'Místo konání';
$string['location_help'] = 'Místo, kde se schůzka odehrává.';
$string['locationlink'] = 'URL adresa místa konání';
$string['maillink'] = 'Plánovač schůzek je k dispozici <a href="{$a}">zde</a>.';
$string['maxparticipants'] = 'Max. účastníků';
$string['message_error_slot_full_group'] = 'Tento termín je již obsazen!';
$string['message_info_slots_added_pl'] = '{$a->count} nových termínů bylo přidáno.';
$string['message_warning_no_slots_added'] = 'Nebyly přidány žádné nové termíny!';
$string['message_warning_no_slots_selected'] = 'Nejprve musíte vybrat alespoň jeden termín!';
$string['message_warning_no_visible_slots_selected'] = 'Nejprve musíte vybrat alespoň jeden viditelný termín!';
$string['messages_all'] = 'Nové registrace, změny a storna';
$string['messages_none'] = 'Žádná oznámení o registracích';
$string['messages_re_unreg'] = 'Pouze změny a storna registrace';
$string['min'] = 'min';
$string['min_pl'] = 'minut';
$string['modformwarningplural'] = 'Tato pole nelze upravit, protože v tomto plánovači byly vytvořeny schůzky!';
$string['modformwarningsingular'] = 'Toto pole nelze upravit, protože v tomto plánovači byly vytvořeny schůzky!';
$string['modulename'] = 'Plánovač schůzek';
$string['modulename_help'] = 'Plánovač umožňuje učitelům domluvit si schůzky se studenty vypsáním  termínů, na které se studenti mohou zaregistrovat.';
$string['modulenameplural'] = 'Plánovače';
$string['multipleappointmentenddate'] = 'Koncové datum';
$string['multipleappointmentstartdate'] = 'Počáteční datum';
$string['mymoodle_organizer_expires'] = 'Platnost tohoto plánovače vyprší {$a->date} v {$a->time}';
$string['no_due_slots'] = 'Platnost všech termínů vytvořených v tomto plánovači vypršela.';
$string['no_slots'] = 'V tomto plánovači nejsou vypsány žádné termíny schůzek.';
$string['no_slots_defined'] = 'V současné době nejsou k dispozici žádné termíny schůzek.';
$string['no_slots_defined_teacher'] = 'Nyní nejsou k dispozici žádné termíny schůzek. Klikněte <a href="{$a->link}">zde</a> a vytvořte nějaké.';
$string['nocalendareventslotcreation'] = 'Nevytvářet události kalendáře pro neobsazené termíny';
$string['nofreeslots'] = 'Nejsou k dispozici žádné volné termíny.';
$string['noparticipants'] = 'Žádní účastníci';
$string['noslots'] = 'Nejsou termíny pro';
$string['notificationtime'] = 'Připomenutí události';
$string['novalidparticipants'] = 'Žádní platní účastníci';
$string['numentries'] = 'Položky zobrazené na stránce';
$string['organizer'] = 'Plánovač schůzek';
$string['organizer:addinstance'] = 'Přidat nový plánovač';
$string['organizer:addslots'] = 'Přidání nových termínů';
$string['organizer:comment'] = 'Přidat poznámky';
$string['organizer_remind_all_no_recepients'] = 'Aktuálně není komu poslat upozornění.';
$string['organizer_remind_all_recepients_pl'] = 'Celkem {$a->count} zpráv bude odesláno následujícím příjemcům:';
$string['organizer_remind_all_recepients_sg'] = 'Celkem {$a->count} zpráva bude odeslána následujícím příjemcům:';
$string['organizer_remind_all_title'] = 'Odeslat připomenutí';
$string['organizercommon'] = 'Nastavení plánovače';
$string['organizername'] = 'Název plánovače';
$string['orientationlandscape'] = 'na šířku';
$string['orientationportrait'] = 'na výšku';
$string['otherheader'] = 'Ostatní';
$string['pageorientation'] = 'Orientace stránky';
$string['participants'] = 'Účastníci';
$string['participants_help'] = 'Seznam účastníků, kteří si tento termín rezervovali.';
$string['pdfsettings'] = 'Nastavení PDF';
$string['places_taken_pl'] = '{$a->numtakenplaces}/{$a->totalplaces} míst rezervováno';
$string['places_taken_sg'] = '{$a->numtakenplaces}/{$a->totalplaces} míst rezervováno';
$string['pluginadministration'] = 'Správa plánovače';
$string['pluginname'] = 'Plánovač schůzek';
$string['print_return'] = 'Návrat do přehledu termínů';
$string['privacy:metadata:comments'] = 'Poznámky učitele pro tento slot.';
$string['queue'] = 'Seznam náhradníků';
$string['recipientname'] = '&lt;jméno příjemce&gt;';
$string['reg_status'] = 'Stav registrace';
$string['reg_status_not_registered'] = 'Neregistrován(a)';
$string['reg_status_organizer_expired'] = 'Plánovač již není aktuální';
$string['reg_status_registered'] = 'Registrován(a)';
$string['reg_status_slot_attended'] = 'Zúčastnil(a) se';
$string['reg_status_slot_available'] = 'Termín je k dispozici';
$string['reg_status_slot_full'] = 'Termín obsazen';
$string['reg_status_slot_not_attended'] = 'Nezúčastnil(a) se';
$string['reg_status_slot_past_deadline'] = 'Na tento termín již není možné se registrovat';
$string['reg_status_slot_pending'] = 'Schůzka čeká na vyhodnocení';
$string['register_notify_teacher:queue:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} se student(ka) {$a->sendername} zařadil(a) na čekací listinu na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:queue:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} zařadil(a) na čekací listinu skupinu {$a->groupname} na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:queue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina zapsána na čekací listinu';
$string['register_notify_teacher:queue:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Student zapsán na čekací listinu';
$string['register_notify_teacher:register:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} se student(ka) {$a->sendername} zaregistroval(a) na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:register:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} zaregistroval(a) skupinu {$a->groupname} na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:register:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina registrována';
$string['register_notify_teacher:register:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Student registrován';
$string['register_notify_teacher:reregister:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} se student(ka) {$a->sendername} znovu zaregistroval(a) na nový termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:reregister:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} znovu zaregistroval(a) skupinu {$a->groupname} na nový termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:reregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Změna registrace skupiny';
$string['register_notify_teacher:reregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Změna registrace studenta';
$string['register_notify_teacher:unqueue:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} se student(ka) {$a->sendername} smazal(a) z čekací listiny na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:unqueue:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} smazal(a) skupinu {$a->groupname} z čekací listiny na termín {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:unqueue:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Skupina byla odebrána z čekací listiny.';
$string['register_notify_teacher:unqueue:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Student byl odebrán z čekací listiny';
$string['register_notify_teacher:unregister:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} zrušila schůzku v termínu {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:unregister:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} student(ka) {$a->sendername} odhlásil(a) skupinu {$a->groupname} z termínu {$a->date} v {$a->time} v místě {$a->location}.

Systém zasílání zpráv Moodle';
$string['register_notify_teacher:unregister:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Zrušení skupinové schůzky';
$string['register_notify_teacher:unregister:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Zrušení termínu studentem';
$string['register_reminder_student:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} jste se stále nezaregistrovali na žádný termín schůzky nebo jste svůj zvolený termín zmeškali.

{$a->custommessage}

Systém zasílání zpráv Moodle';
$string['register_reminder_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

V rámci kurzu {$a->courseid} {$a->coursefullname} se vaše skupina {$a->groupname} stále nezaregistrovala na žádný termín schůzky nebo jste svůj zvolený termín zmeškali.

{$a->custommessage}

Systém zasílání zpráv Moodle';
$string['register_reminder_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Připomenutí registrace';
$string['register_reminder_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Připomenutí registrace';
$string['relative_deadline_before'] = 'před schůzkou';
$string['relative_deadline_now'] = 'Počínaje nyní';
$string['relativedeadline'] = 'Předběžná uzávěrka registrace';
$string['remindall_desc'] = 'Odeslat připomínku všem studentům bez naplánované schůzky';
$string['selectedslots'] = 'Vybrané termíny';
$string['singleslotcommands_help'] = 'Kliknutím na tlačítko akce můžete pracovat s konkrétním termínem.';
$string['singleslotprintfields'] = 'Zobrazení údajů z profilu uživatele';
$string['slot_anonymous'] = 'Účastníci termínu jsou anonymní';
$string['slot_slotvisible'] = 'Účastníky schůzky mohou vidět pouze registrovaní';
$string['slot_visible'] = 'Zobrazovat účastníky schůzky';
$string['slotdeleted_notify_student:fullmessage'] = 'Dobrý den {$a->receivername}!

Vaše schůzka v kurzu {$a->courseshortname} dne {$a->date} v {$a->time} v místě {$a->location} byla zrušena.
V plánovači {$a->organizátor název} nyní nemáte žádnou schůzku.
Chcete-li provést novou registraci na termín, pokračujte na: {$a->courselink}

Systém zasílání zpráv Moodle';
$string['slotdeleted_notify_student:group:fullmessage'] = 'Dobrý den {$a->receivername}!

Vaše skupinová schůzka v kurzu {$a->courseshortname} dne {$a->date} v {$a->time} v místě {$a->location} byla zrušena.
V plánovači {$a->organizátor název} nyní nemáte žádnou schůzku.
Chcete-li provést novou registraci na termín, pokračujte na: {$a->courselink}

Systém zasílání zpráv Moodle';
$string['slotdeleted_notify_student:group:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Schůzka byla zrušena';
$string['slotdeleted_notify_student:subject'] = '[{$a->courseid}{$a->courseshortname} / {$a->organizername}] - Schůzka byla zrušena';
$string['slotdetails'] = 'Podrobnosti o termínu';
$string['slotfrom'] = 'od';
$string['slotperiodendtime'] = 'Koncové datum';
$string['slotperiodheader'] = 'Generování časových úseků pro vybrané dny';
$string['slotperiodstarttime'] = 'Počáteční datum';
$string['slotto'] = 'do';
$string['status_help'] = 'Aktuální stav vypsaného termínu.';
$string['stroptimal'] = 'Optimální';
$string['studentcomment_title'] = 'Poznámky studenta';
$string['taballapp'] = 'Schůzky';
$string['tabstatus'] = 'Stav registrace';
$string['tabstud'] = 'Zobrazení studenta';
$string['teacher'] = 'Učitel';
$string['teacher_help'] = 'Seznam registrovaných učitelů.';
$string['teachercomment_title'] = 'Poznámky učitele';
$string['teachervisible'] = 'Zobrazit učitele účastníkům';
$string['textsize'] = 'Velikost písma';
$string['th_actions'] = 'Akce';
$string['th_appdetails'] = 'Podrobnosti';
$string['th_attended'] = 'Účast';
$string['th_comments'] = 'Poznámka účastníka';
$string['th_datetime'] = 'Datum a čas';
$string['th_datetimedeadline'] = 'Datum a čas';
$string['th_details'] = 'Stav';
$string['th_duration'] = 'Doba trvání';
$string['th_feedback'] = 'Zpětná vazba';
$string['th_grade'] = 'Vyhodnotit';
$string['th_location'] = 'Místo konání';
$string['th_participant'] = 'Účastník';
$string['th_participants'] = 'Účastníci';
$string['th_status'] = 'Stav';
$string['th_teacher'] = 'Učitel';
$string['th_teachercomments'] = 'Poznámky učitele';
$string['title_add'] = 'Přidání nových termínů';
$string['title_comment'] = 'Úprava vašich poznámek';
$string['title_delete'] = 'Smazat vybrané časové úseky';
$string['title_edit'] = 'Upravit vybrané časové úseky';
$string['title_eval'] = 'Vyhodnocení účasti vybraných časových úseků';
$string['title_print'] = 'Vytisknout termíny';
$string['totalday'] = 'xxx termínů pro yyy osob';
$string['totalday_groups'] = 'xxx termínů pro yyy skupin';
$string['totaltotal'] = 'Celkem: xxx termínů pro yyy osob';
$string['totaltotal_groups'] = 'Celkem: xxx termínů pro yyy skupin';
$string['trainerid'] = 'Učitel';
$string['unavailableslot'] = 'Tento termín je k dispozici od';
$string['visibility'] = 'Viditelnost členů - přednastavení';
$string['visibility_all'] = 'Viditelná identita';
$string['visibility_anonymous'] = 'Anonymní';
$string['visibility_slot'] = 'Viditelná identita v rámci termínu';
$string['visible'] = 'Zobrazit termín';
$string['warning_groupingid'] = 'Režim skupiny povolen. Je nutné vybrat platné seskupení.';
$string['warninggroupmode'] = 'Chcete-li vytvořit schůzku skupiny, musíte povolit režim skupiny a vybrat seskupení!';
$string['warningtext1'] = 'Vybrané termíny obsahují v tomto poli různé hodnoty!';
$string['warningtext2'] = 'Pozor! Obsah tohoto pole byl změněn!';
$string['weekdaylabel'] = 'Časový úsek pro den v týdnu';
