<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_reportbuilder', language 'lo', version '4.3'.
 *
 * @package     tool_reportbuilder
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesstab'] = 'ເຂົ້າເຖິງ';
$string['actions'] = 'ປະຕິບັດ';
$string['addacondition'] = 'ເພີ່ມເງື່ອນໄຂ...';
$string['addafilter'] = 'ເພີ່ມຕົວກອງ...';
$string['addaudience'] = 'ເພີ່ມຜູ້ຊົມ';
$string['addaudiences'] = 'ເພີ່ມຜູ້ຊົມໄປຫາລາຍງານນີ້';
$string['addcolumn'] = 'ເພີ່ມຖັນ';
$string['adddefault'] = 'ເພີ່ມການຕັ້ງຄ່າເລີ່ມຕົ້ນ';
$string['adddefault_help'] = 'ແຕ່ລະແຫຼ່ງລາຍງານຍັງກໍານົດຖັນ, ເງື່ອນໄຂ ແລະ ການກັ່ນຕອງເລີ່ມຕົ້ນ. ຖ້າທ່ານຕ້ອງການສ້າງບົດລາຍງານໂດຍໃຊ້ຄ່າເລີ່ມຕົ້ນເຫຼົ່ານີ້, ເລືອກຊ່ອງຂໍ້ມູນນີ້';
$string['addemails'] = 'ເພີ່ມອີເມລດ້ວຍຕົນເອງ';
$string['addfieldbyname'] = 'ເພີ່ມຊ່ອງຂໍ້ມູນ \'{$a}\' ໄປຫາລາຍງານ';
$string['addreport'] = 'ລາຍງານໃໝ່';
$string['addschedule'] = 'ຕາຕະລາງໃໝ່';
$string['addusers'] = 'ເພີ່ມຜູ້ໃຊ້ດ້ວຍຕົນເອງ';
$string['addusers_help'] = 'ຜູ້ໃຊ້ທັງໝົດທີ່ເພີ່ມດ້ວຍຕົນເອງຈະໄດ້ຮັບບົດລາຍງານນີ້ ເຖິງວ່າຈະມີຕໍາແໜ່ງ ຫຼື ພະແນກຂອງເຂົາເຈົ້າ';
$string['aggregation_avg'] = 'ສະເລ່ຍ';
$string['aggregation_count'] = 'ຈຳນວນ';
$string['aggregation_countdistinct'] = 'ຈຳນວນເອກະລັກ';
$string['aggregation_groupconcat'] = 'ເຄື່ອງໝາຍຈຸດແຍກມູນຄ່າ';
$string['aggregation_groupconcatdistinct'] = 'ເຄື່ອງໝາຍຈຸດແຍກຄ່າຕ່າງກັນ';
$string['aggregation_max'] = 'ສູງສຸດ';
$string['aggregation_min'] = 'ນ້ອຍສຸດ';
$string['aggregation_percent'] = 'ສ່ວນຮ້ອຍ';
$string['aggregation_sum'] = 'ລວມ';
$string['aggregation_unique'] = 'ມູນຄ່າເອກະລັກ';
$string['allusers'] = 'ຜູ້ໃຊ້ທັງໝົດ';
$string['allusersdesc'] = 'ເພີ່ມຜູ້ໃຊ້ທັງໝົດໄປຫາລາຍງານນີ້';
$string['and'] = 'ເພີ່ມ';
$string['asc'] = 'ຖັນ \'{$a}\' ມີທິດທາງການຈັດຮຽງຈາກໃຫຍ່ຫານ້ອຍ';
$string['audience'] = 'ຜູ້ຊົມ';
$string['audiencejobadd'] = 'ເພີ່ມວຽກ';
$string['audiencejobremove'] = 'ລຶບວຽກ';
$string['audiencejobs'] = 'ວຽກ';
$string['audiencejobs_help'] = 'ຜູ້ໃຊ້ສາມາດເບິ່ງບົດລາຍງານນີ້ ຖ້າພວກເຂົາຂຶ້ນກັບໜຶ່ງໃນວຽກທີ່ເລືອກຂ້າງລຸ່ມນີ້';
$string['audiencejobsempty'] = 'ບໍ່ມີວຽກໄດ້ເພີ່ມ';
$string['audiencemultiselectpostix'] = 'ບວກ {$a} ເພີ່ມ';
$string['audiencenotsaved'] = 'ຜູ້ຊົມບໍ່ໄດ້ບັນທຶກ';
$string['audiences'] = 'ຜູ້ຊົມ';
$string['authmethod'] = 'ວິທີການກວດສອບຄວາມຖືກຕ້ອງ';
$string['availableinalltenants'] = 'ມີໃຫ້ໃນຜູ້ເຊົ່າທັງໝົດ';
$string['availableinalltenants_help'] = 'ເມື່ອເປີດໃຊ້ງານ, ຜູ້ໃຊ້ (ທີ່ມີການອະນຸຍາດທີ່ເໝາະສົມ) ໃນຜູ້ເຊົ່າທັງໝົດຈະສາມາດເບິ່ງບົດລາຍງານນີ້. ແຫຼ່ງບົດລາຍງານສ່ວນໃຫຍ່ຈະຈໍາກັດຜູ້ໃຊ້ທີ່ສະແດງ ແລະ ຫນ່ວຍງານອື່ນໆ (ໂຄງການ, ການຢັ້ງຢືນ, ຫຼັກສູດ) ໂດຍອັດຕະໂນມັດກັບຜູ້ທີ່ສັງເກດເຫັນພາຍໃນຜູ້ເຊົ່າ.';
$string['basicinformation'] = 'ຂໍ້ມູນພື້ນຖານ';
$string['cachedef_userreports'] = 'ລາຍງານທີ່ກຳນົດເອງທີ່ຜູ້ໃຊ້ສາມາດເຂົ້າເຖິງ';
$string['canviewallreports'] = 'ສາມາດເບິ່ງລາຍງານທັງໝົດ';
$string['cardview'] = 'ມຸມມອງບັດ';
$string['cardview_help'] = 'ລາຍງານຈະສະຫຼັບໄປໃຊ້ມຸມມອງບັດໂດຍອັດຕະໂນມັດເມື່ອສະແດງຢູ່ໃນໜ້າຈໍຂະໜາດນ້ອຍ ຫຼື ໃນແຖບແຄບ';
$string['certificatesissues'] = 'ອອກໃບຢັ້ງຢືນ';
$string['certificatetemplates'] = 'ແມ່ແບບໃບຢັ້ງຢືນ';
$string['checkboxanyvalue'] = 'ມູນຄ່າໃດໜຶ່ງ';
$string['checkboxischecked'] = 'ແມ່ນ';
$string['checkboxisnotchecked'] = 'ບໍ່';
$string['choose'] = 'ເລືອກ...';
$string['conditionshelp'] = 'ເງື່ອນໄຂ';
$string['conditionshelp_help'] = 'ລາຍຊື່ເງື່ອນໄຂທີ່ກຳນົດໄວ້ລ່ວງໜ້າທີ່ນຳໃຊ້ສະເໝີເມື່ອເບິ່ງບົດລາຍງານນີ້.';
$string['conditionstab'] = 'ເງື່ອນໄຂ';
$string['confirm'] = 'ຢືນຢັນ';
$string['confirmdeletecondition'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບເງື່ອນໄຂ \'{$a}\'?';
$string['confirmdeleteschedule'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບກຳນົດເວລາ \'{$a}\' ແລະ ຂໍ້ມູນທີ່ກ່ຽວຂ້ອງທັງໝົດ? ຄຳສັ່ງນີ້ບໍ່ສາມາດຍົກເລີກໄດ້.';
$string['confirmresetallconditions'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຕ້ອງການຕັ້ງຄ່າຄືນທຸກເງື່ອນໄຂ?';
$string['confirmresetconditions'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຕ້ອງການຕັ້ງຄ່າຄືນເງື່ອນໄຂ \'{$a}\'?';
$string['confirmsendschedule'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຈັດຄິວ \'{$a}\' ເພື່ອສົ່ງ?';
$string['contentvisibility'] = 'ຈຳນວນຖັນທີ່ເບິ່ງເຫັນສະເໝີ';
$string['course_completion_days_course'] = 'ມື້ທີ່ເອົາລາຍວິຊາ';
$string['course_completion_days_enrolled'] = 'ມື້ລົງທະບຽນຮຽນ';
$string['course_completion_progress'] = 'ຄວາມຄືບໜ້າ';
$string['course_completion_progress_percent'] = 'ຄວາມຄືບໜ້າ (%)';
$string['course_completion_reaggregate'] = 'ເວລາລວມກັນແລ້ວ';
$string['course_completion_timecompleted'] = 'ເວລາສຳເລັດແລ້ວ';
$string['course_completion_timeenrolled'] = 'ເວລາລົງທະບຽນຮຽນ';
$string['course_completion_timestarted'] = 'ເວລາເລີ່ມແລ້ວ';
$string['course_enrolment_status'] = 'ສະຖານະການລົງທະບຽນຮຽນ';
$string['course_enrolment_timeended'] = 'ສິ້ນສຸດການລົງທະບຽນຮຽນແລ້ວ';
$string['course_enrolment_timestarted'] = 'ເລີ່ມການລົງທະບຽນຮຽນແລ້ວ';
$string['coursefullnamewithlink'] = 'ຊື່ເຕັມລາຍວິຊາພ້ອມດ້ວຍລິ້ງ';
$string['courseidnumberewithlink'] = 'ລະຫັດປະຈຳລາຍວິຊາພ້ອມດ້ວຍລິ້ງ';
$string['courseshortnamewithlink'] = 'ຊື່ຫຍໍ້ລາຍວິຊາພ້ອມດ້ວຍລິ້ງ';
$string['customessage'] = 'ຂໍ້ຄວາມທີ່ກຳນົດເອງ';
$string['customfieldcolumn'] = '{$a}';
$string['customizecondition'] = 'ແກ້ໄຂຊື່ເງື່ອນໄຂ';
$string['customizefilter'] = 'ແກ້ໄຂຊື່ຕົວກອງ';
$string['customizeheader'] = 'ແກ້ໄຂສ່ວນຫົວສຳລັບຖັນ \'{$a}\'';
$string['customreports'] = 'ລາຍງານແບບກຳນົດເອງ';
$string['customreportsdesc'] = 'ບົດລາຍງານທີ່ກໍານົດເອງ, ລວມທັງຂໍ້ມູນຜູ້ຊົມ ແລະ ຕາຕະລາງ';
$string['dateanyvalue'] = 'ມູນຄ່າໃດໜຶ່ງ';
$string['datecreated'] = 'ສ້າງແລ້ວ';
$string['datecurrent'] = 'ປະຈຸບັນ';
$string['dateinthefuture'] = 'ໃນອານາຄົດ';
$string['dateinthepast'] = 'ໃນອະດີດ';
$string['dateisempty'] = 'ຫວ່າງເປົ່າ';
$string['dateisnotempty'] = 'ແມ່ນບໍ່ຫວ່າງເປົ່າ';
$string['datelast'] = 'ຫຼ້າສຸດ ... ມື້';
$string['datenext'] = 'ຕໍ່ໄປ ... ມື້';
$string['dateprevious'] = 'ກ່ອນໜ້າ';
$string['daterange'] = 'ໄລຍະວັນທີ';
$string['daterangefrom'] = 'ຈາກ';
$string['daterangeto'] = 'ຫາ';
$string['datetostart'] = 'ວັນທີ';
$string['dateupcoming'] = 'ທີ່ຈະມາໄວໄວນີ້';
$string['debugsqlparams'] = 'ຕົວກຳນົດ';
$string['debugsqlquery'] = 'ການສອບຖາມໃນປະຈຸບັນ';
$string['deleteaudience'] = 'ລຶບຜູ້ຊົມ \'{$a}\'';
$string['deletecolumn'] = 'ລຶບຖັນ \'{$a}\'';
$string['deletecondition'] = 'ລຶບເງື່ອນໄຂ \'{$a}\'';
$string['deletefilter'] = 'ລຶບຕົວກອງ';
$string['deletereport'] = 'ລຶບລາຍງານ';
$string['deletereportmsg'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບລາຍງານ \'{$a}\' ແລະ ຂໍ້ມູນທີ່ກ່ຽວຂ້ອງທັງໝົດ? ຄຳສັ່ງນີ້ບໍ່ສາມາດຍົກເລີກໄດ້.';
$string['deletereportsuccess'] = 'ລາຍງານໄດ້ຖືກລຶບ';
$string['deleteschedule'] = 'ລຶບກຳນົດເວລາ';
$string['desc'] = 'ຖັນ \'{$a}\' ມີທິດທາງການຈັດຮຽງຈາກໃຫຍ່ຫານ້ອຍ';
$string['description'] = 'ລາຍລະອຽດ';
$string['description_help'] = 'ໃຫ້ລາຍລະອຽດກ່ຽວກັບຈຸດປະສົງຂອງບົດລາຍງານ.';
$string['duplicate'] = 'ຊ້ຳກັນ';
$string['duplicatereport'] = 'ລາຍງານຊ້ຳກັນ';
$string['editaudience'] = 'ແກ້ໄຂຜູ້ຊົມ';
$string['editmode'] = 'ສະຫຼັບເພື່ອແກ້ໄຂມຸມມອງ';
$string['editreport'] = 'ແກ້ໄຂເນື້ອຫາ';
$string['editreportdetails'] = 'ແກ້ໄຂລາຍລະອຽດ';
$string['editreportname'] = 'ແກ້ໄຂຊື່ລາຍງານ';
$string['editschedule'] = 'ແກ້ໄຂກຳນົດເວລາ';
$string['edittitle'] = 'ແກ້ໄຂລາຍງານ \'{$a}\'';
$string['enablesortingon'] = 'ເປີດໃຊ້ການຈັດຮຽງຢູ່ໃນຖັນ \'{$a}\'';
$string['enteremail'] = 'ກະລຸນາໃສ່ອີເມລທີ່ຖືກຕ້ອງແລ້ວກົດ \\u0027enter\\u0027';
$string['entitycertificate'] = 'ໃບຢັ້ງຢືນ';
$string['entitycertificateissue'] = 'ອອກໃບຢັ້ງຢືນ';
$string['entitycourse'] = 'ລາຍວິຊາ';
$string['entitycoursecompletion'] = 'ການສຳເລັດລາຍວິຊາ';
$string['entitycourseenrolment'] = 'ການລົງທະບຽນຮຽນລາຍວິຊາ';
$string['entitydatastorecoursecompletion'] = 'ສຳເລັດລາຍວິຊາການເກັບຮັກສາຂໍ້ມູນ';
$string['entityreportbuilder'] = 'ລາຍງານແບບກຳນົດເອງ';
$string['entityschedule'] = 'ກຳນົດເວລາ';
$string['entityuser'] = 'ຜູ້ໃຊ້';
$string['error:mustselectformat'] = 'ທີ່ຕ້ອງໄດ້ເລືອກຮູບແບບ.';
$string['error:mustselectsource'] = 'ທີ່ຕ້ອງໄດ້ເລືອກແຫຼ່ງລາຍງານ.';
$string['errormanageschedules'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ຈັດການຕາຕະລາງ';
$string['errormissingreportsource'] = 'ບໍ່ສາມາດຊອກຫາແຫຼ່ງລາຍງານທີ່ກຳນົດຄ່າໄດ້';
$string['errornorecipients'] = 'ທ່ານຕ້ອງເລືອກຜູ້ຮັບບາງຄົນສໍາລັບຕາຕະລາງນີ້';
$string['errorunavailablereportsource'] = 'ແຫຼ່ງລາຍງານທີ່ກຳນົດຄ່າບໍ່ສາມາດໃຊ້ໄດ້';
$string['eventreportcreated'] = 'ສ້າງລາຍງານແລ້ວ';
$string['eventreportdeleted'] = 'ລຶບລາຍງານແລ້ວ';
$string['eventreportschedulecreated'] = 'ສ້າງຕາຕະລາງລາຍງານແລ້ວ';
$string['eventreportscheduledeleted'] = 'ລຶບຕາຕະລາງລາຍງານແລ້ວ';
$string['eventreportscheduleupdated'] = 'ປັບປຸງຕາຕະລາງລາຍງານແລ້ວ';
$string['eventreportupdated'] = 'ປັບປຸງລາຍງານແລ້ວ';
$string['eventreportviewed'] = 'ເບິ່ງລາຍງານແລ້ວ';
$string['expandcardview'] = 'ຂະຫຍາຍມຸມມອງບັດ';
$string['expandconditions'] = 'ຂະຫຍາຍເງື່ອນໄຂ';
$string['expandfilters'] = 'ຂະຫຍາຍຕົວກັ່ນຕອງ';
$string['expandsorting'] = 'ຂະຫຍາຍການຈັດຮຽງ';
$string['exportselectall'] = 'ສົ່ງອອກລາຍງານແບບກຳນົດເອງທັງໝົດ';
$string['exportselectlimit'] = 'ສົ່ງອອກລາຍງານແບບກຳນົດເອງສະເພາະ';
$string['filternotvalid'] = 'ການກັ່ນຕອງຕ້ອງເປັນຊັ້ນຍ່ອຍຂອງ filter_base.';
$string['filtersbutton'] = 'ສະແດງ/ເຊື່ອງແຖບດ້ານຂ້າງຕົວກັ່ນຕອງ';
$string['filtershelp'] = 'ຕົວກັ່ນຕອງ';
$string['filtershelp_help'] = 'ລາຍຊື່ຕົວກອງທີ່ບໍ່ໄດ້ໃຊ້ອັດຕະໂນມັດແຕ່ມີໃຫ້ສຳລັບຜູ້ໃຊ້.';
$string['filterstab'] = 'ຕົວກອງ';
$string['format'] = 'ຮູບແບບ';
$string['fullnamewithlink'] = 'ຊື່ເຕັມພ້ອມດ້ວຍລິ້ງໂປຣໄຟລ໌';
$string['fullnamewithpicture'] = 'ຊື່ເຕັມພ້ອມດ້ວຍຮູບພາບ';
$string['fullnamewithpicturelink'] = 'ຊື່ເຕັມພ້ອມດ້ວຍຮູບພາບ ແລະ ລິ້ງ';
$string['hascurrentjobs'] = 'ມີວຽກໃນປະຈຸບັນ';
$string['hassystemrole'] = 'ແຕ່ງຕັ້ງໜ້າທີ່ລະບົບແລ້ວ';
$string['importaudiencelogerror'] = 'ບໍ່ສາມາດນຳເຂົ້າການບັນທຶກຜູ້ຊົມ';
$string['importaudiencelogsuccess'] = 'ນຳເຂົ້າບັນທຶກຜູ້ຊົມແລ້ວ';
$string['importexportreportdefinition'] = 'ຄວາມໝາຍລາຍງານ';
$string['importexportreportdefinition_help'] = 'ລວມທັງຖັນລາຍງານ, ເງື່ອນໄຂ ແລະ ຕົວກອງ';
$string['importlogerror'] = 'ບໍ່ສາມາດນຳເຂົ້າລາຍງານ \'{$a}\'';
$string['importlogerrorinvalidaudience'] = 'ຜູ້ຊົມຂາດຫາຍໄປ ຫຼື ບໍ່ຖືກຕ້ອງ';
$string['importlogerrorinvalidformat'] = 'ຮູບແບບກຳນົດເວລາຂາດຫາຍໄປ ຫຼື ບໍ່ຖືກຕ້ອງ';
$string['importlogerrorinvalidsource'] = 'ແຫຼ່ງລາຍງານຂາດຫາຍໄປ ຫຼື ບໍ່ຖືກຕ້ອງ';
$string['importlogerrorinvalidtype'] = 'ປະເພດລາຍງານບໍ່ຖືກຕ້ອງ';
$string['importlogerrorlegacyemails'] = 'ທີ່ຢູ່ອີເມລ໌ບໍ່ຖືກຮອງຮັບເປັນຜູ້ຮັບກຳນົດເວລາອີກຕໍ່ໄປ';
$string['importlogerrorlegacyemailsimport'] = 'ນຳເຂົ້າປາສະຈາກທີ່ຢູ່ອີເມລ';
$string['importlogerrorlegacyemailslog'] = 'ທີ່ຢູ່ອີເມລບໍ່ໄດ້ຖືກຮອງຮັບເປັນຜູ້ຮັບກຳນົດເວລາອີກຕໍ່ໄປ, ກະລຸນາເບິ່ງທີ່ <a href="{$a->docslink}">ບັນທຶກການຍົກລະດັບ</a>';
$string['importlogerrornorecipients'] = 'ຜູ້ຮັບກຳນົດເວລາຂາດຫາຍໄປ ຫຼື ບໍ່ຖືກຕ້ອງ';
$string['importlogsuccess'] = 'ສ້າງລາຍງານໃໝ່ \'<a href="{$a->url}">{$a->name}</a>\' ດ້ວຍຖັນ {$a->columncount}, {$a->conditioncount} ເງື່ອນໄຂ ແລະ { $a->filtercount} ຕົວກອງ';
$string['importschedulelogerror'] = 'ບໍ່ສາມາດນຳເຂົ້າກຳນົດເວລາ';
$string['importschedulelogsuccess'] = 'ນຳເຂົ້າບັນທຶກກຳນົດເວລາແລ້ວ';
$string['importselectall'] = 'ນຳເຂົ້າລາຍງານກຳນົດເອງທັງໝົດ';
$string['importselectlimit'] = 'ນຳເຂົ້າລາຍງານກຳນົດເອງສະເພາະ...';
$string['invalidcolumn'] = 'ຖັນບໍ່ຖືກຕ້ອງ';
$string['invalidcondition'] = 'ເງື່ອນໄຂບໍ່ຖືກຕ້ອງ';
$string['invalidemail'] = 'ທີ່ຢູ່ອີເມລ \'{$a}\' ນີ້ບໍ່ຖືກຕ້ອງ';
$string['invalidfilter'] = 'ຕົວກອງບໍ່ຖືກຕ້ອງ';
$string['ismemberofcohort'] = 'ສະມາຊິກຂອງກຸ່ມ';
$string['isnotempty'] = 'ບໍ່ຫວ່າງເປົ່າ';
$string['lastcourseaccess'] = 'ເຂົ້າເຖິງລາຍວິຊາຫຼ້າສຸດ';
$string['lastmodified'] = 'ການດັດແກ້ຫຼ້າສຸດ';
$string['lastsenton'] = 'ສົ່ງຫຼ້າສຸດໃນ';
$string['lessthanaday'] = 'ພາຍໃນໜຶ່ງວັນ';
$string['managereports'] = 'ຈັດການລາຍງານກຳນົດເອງ';
$string['manuallyaddedusers'] = 'ເພີ່ມຜູ້ໃຊ້ດ້ວຍຕົນເອງ';
$string['message'] = 'ຂໍ້ຄວາມ';
$string['modifiedby'] = 'ດັດແກ້ໂດຍ';
$string['movecolumn'] = 'ຍ້າຍຖັນ {$a}';
$string['movefilter'] = 'ຍ້າຍຕົວກອງ {$a}';
$string['movesorting'] = 'ຍ້າຍການຈັດລຽງລຳດັບຂອງຖັນ \'{$a}\'';
$string['never'] = 'ບໍ່ເຄີຍ';
$string['newaggregationfor'] = 'ການລວບລວມໃໝ່ສໍາລັບຖັນ \'{$a}\'';
$string['newschedule'] = 'ກຳນົດເວລາໃໝ່';
$string['newvaluefor'] = 'ມູນຄ່າໃໝ່ສຳລັບ \'{$a}\'';
$string['noaggregation'] = 'ບໍ່ມີການລວບລວມ';
$string['noaudiences'] = 'ບໍ່ມີຜູ້ຊົມ';
$string['noaudiencesalert'] = 'ການກໍານົດເວລາບົດລາຍງານນີ້ຈະເປັນໄປໄດ້ພຽງແຕ່ຖ້າມີໜຶ່ງ ຫຼື ຫຼາຍຜູ້ຊົມຖືກເພີ່ມໃສ່ມັນ. ກະລຸນາໄປທີ່ແຖບ "ຜູ້ຊົມ" ແລະ ສ້າງຜູ້ຊົມຢ່າງໜ້ອຍໜຶ່ງຄົນເພື່ອສືບຕໍ່.';
$string['noavailablecohorts'] = 'ບໍ່ມີກຸ່ມໃຫ້';
$string['nocolumnsselected'] = 'ເພີ່ມຖັນໄປຫາລາຍງານ';
$string['noconditions'] = 'ບໍ່ມີເງື່ອນໄຂຖືກເລືອກ';
$string['nofilters'] = 'ບໍ່ມີຕົວກັ່ນຕອງຖືກເລືອກ';
$string['nosortablecolumns'] = 'ຍັງບໍ່ທັນໄດ້ເພີ່ມຖັນທີ່ຈັດລຽງໄດ້.';
$string['numberanyvalue'] = 'ມູນຄ່າໃດໜຶ່ງ';
$string['numberbetween'] = 'ໃນໄລຍະລະຫວ່າງ';
$string['numberequalorgreaterthan'] = 'ໃຫຍ່ກວ່າ ຫຼື ເທົ່າກັບ';
$string['numberequalorlessthan'] = 'ໜ້ອຍກວ່າ ຫຼື ເທົ່າກັບ';
$string['numberequalto'] = 'ເທົ່າກັບ';
$string['numbergreaterthan'] = 'ໃຫຍ່ກວ່າ';
$string['numberisempty'] = 'ແມ່ນຫວ່າງເປົ່າ';
$string['numberisnotempty'] = 'ແມ່ນບໍ່ຫວ່າງເປົ່າ';
$string['numberlessthan'] = 'ນ້ອຍກວ່າ';
$string['or'] = 'ຫຼື';
$string['pluginname'] = 'ຕົວສ້າງລາຍງານ';
$string['preview'] = 'ເບິ່ງຕົວຢ່າງ';
$string['previewmode'] = 'ປ່ຽນໄປເປັນມຸມມອງເບິ່ງຕົວຢ່າງ';
$string['privacy:metadata:preference:filters_report'] = 'ເກັບຮັກສາຊັບສິນຕົວກັ່ນຕອງຜູ້ໃຊ້ສຳລັບລາຍງານ';
$string['privacy:metadata:reportbuilder'] = 'ຂໍ້ມູນກ່ຽວກັບລາຍງານທີ່ກຳນົດເອງ';
$string['privacy:metadata:reportbuilder:name'] = 'ຊື່ຂອງລາຍງານ';
$string['privacy:metadata:reportbuilder:source'] = 'ແຫຼ່ງຂໍ້ມູນສຳລັບລາຍງານ';
$string['privacy:metadata:reportbuilder:tenantid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ເຊົ່າລາຍງານທີ່ເປັນຂອງ';
$string['privacy:metadata:reportbuilder:timecreated'] = 'ເວລາທີ່ລາຍງານຖືກສ້າງ';
$string['privacy:metadata:reportbuilder:timemodified'] = 'ເວລາທີ່ລາຍງານຖືກດັດແປງຫຼ້າສຸດ';
$string['privacy:metadata:reportbuilder:usercreated'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ສ້າງລາຍງານ';
$string['privacy:metadata:reportbuilder:usermodified'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ດັດແກ້ລາຍງານ';
$string['privacy:metadata:reportbuilder_audience'] = 'ຂໍ້ມູນກ່ຽວກັບລາຍງານຜູ້ຊົມທີ່ກຳນົດເອງ';
$string['privacy:metadata:reportbuilder_audience:classname'] = 'ຫ້ອງຮຽນສຳລັບນຳໃຊ້ສຳລັບຜູ້ຊົມນີ້';
$string['privacy:metadata:reportbuilder_audience:configdata'] = 'ການກຳນົດຄ່າຜູ້ຊົມ';
$string['privacy:metadata:reportbuilder_audience:reportid'] = 'ລະຫັດປະຈຳຕົວລາຍງານຜູ້ຊົມທີ່ເປັນຂອງ';
$string['privacy:metadata:reportbuilder_audience:timecreated'] = 'ເວລາທີ່ຜູ້ຊົມຖືກສ້າງ';
$string['privacy:metadata:reportbuilder_audience:timemodified'] = 'ເວລາທີ່ຜູ້ຊົມຖືກດັດແປງ';
$string['privacy:metadata:reportbuilder_audience:usercreated'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ໄດ້ສ້າງຜູ້ຊົມ';
$string['privacy:metadata:reportbuilder_audience:usermodified'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ໄດ້ດັດແປງຜູ້ຊົມ';
$string['privacy:metadata:reportbuilder_schedule'] = 'ຂໍ້ມູນກ່ຽວກັບກຳນົດເວລາລາຍງານທີ່ກຳນົດເອງ';
$string['privacy:metadata:reportbuilder_schedule:format'] = 'ຮູບແບບຂອງຂໍ້ມູນລາຍງານທີ່ໄດ້ກຳນົດເວລາ';
$string['privacy:metadata:reportbuilder_schedule:lastsenton'] = 'ເວລາທີ່ກຳນົດເວລາໄດ້ຖືກສົ່ງຄັ້ງສຸດທ້າຍ';
$string['privacy:metadata:reportbuilder_schedule:message'] = 'ເນື້ອຫາຂອງຂໍ້ຄວາມທີ່ໄດ້ກຳນົດເວລາ';
$string['privacy:metadata:reportbuilder_schedule:name'] = 'ຊື່ຂອງຕາຕະລາງ';
$string['privacy:metadata:reportbuilder_schedule:recurrence'] = 'ກຳນົດເວລາເກີດຂື້ນຄືນໃໝ່ແນວໃດ';
$string['privacy:metadata:reportbuilder_schedule:reportid'] = 'ລະຫັດປະຈຳຕົວຂອງບົດລາຍງານທີ່ກໍານົດເວລາເປັນຂອງ';
$string['privacy:metadata:reportbuilder_schedule:scheduled'] = 'ເວລາທີ່ກຳນົດເວລາຮອດກຳນົດເພື່ອເລີ່ມຕົ້ນ';
$string['privacy:metadata:reportbuilder_schedule:subject'] = 'ຫົວຂໍ້ລວມຢູ່ໃນຂໍ້ຄວາມທີ່ກໍານົດ';
$string['privacy:metadata:reportbuilder_schedule:timecreated'] = 'ເວລາທີ່ກຳນົດເວລາຖືກສ້າງ';
$string['privacy:metadata:reportbuilder_schedule:timemodified'] = 'ເວລາທີ່ກຳນົດເວລາໄດ້ຖືກປັບປຸງຫຼ້າສຸດ';
$string['privacy:metadata:reportbuilder_schedule:usercreated'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ສ້າງກຳນົດເວລາ';
$string['privacy:metadata:reportbuilder_schedule:usermodified'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ຜູ້ທີ່ດັດແປງກຳນົດເວລາຫຼ້າສຸດ';
$string['privacywarning'] = 'ຄໍາເຕືອນ: ກ່ອນທີ່ຈະເພີ່ມອີເມລໃດໜຶ່ງ, ໃຫ້ແນ່ໃຈວ່າທ່ານມີພື້ນຖານທາງດ້ານກົດໝາຍທີ່ຈະເຮັດແນວນັ້ນ ແລະ ນີ້ແມ່ນປະຕິບັດຕາມກົດໝາຍວ່າດ້ວຍຄວາມເປັນສ່ວນຕົວທີ່ກ່ຽວຂ້ອງນໍາໃຊ້ກັບອົງການຈັດຕັ້ງຂອງທ່ານ.';
$string['profiledepartment'] = 'ໂປຣໄຟລ໌ພະແນກ';
$string['quarter'] = 'ໄຕມາດ';
$string['recipients'] = 'ຜູ້ຮັບ';
$string['recurrence'] = 'ການເກີດຂຶ້ນຊ້ຳ';
$string['recurrenceannualy'] = 'ປະຈຳປີ';
$string['recurrencedaily'] = 'ປະຈຳວັນ';
$string['recurrencedailyweekday'] = 'ປະຈຳວັນ-ມື້ອາທິດ';
$string['recurrencedonorepeat'] = 'ບໍ່ຊ້ຳກັນ';
$string['recurrencemonthly'] = 'ປະຈຳເດືອນ';
$string['recurrenceweekly'] = 'ປະຈຳອາທິດ';
$string['reg_wpreports'] = 'ຈຳນວນຂອງລາຍງານ ({$a}) ທີ່ກຳນົດເອງ';
$string['removechedulesuccess'] = 'ກຳນົດ';
$string['removeconditionsuccess'] = 'ເງື່ອນໄຂ \'{$a}\' ໄດ້ຖືກລຶບແລ້ວ.';
$string['report'] = 'ລາຍງານ';
$string['report_access_list'] = 'ລາຍງານລະບົບສໍາລັບລາຍຊື່ຜູ້ໃຊ້ທີ່ມີການເຂົ້າເຖິງບົດລາຍງານທີ່ກໍານົດ';
$string['reportbuilder:edit'] = 'ແກ້ໄຂການກຳນົດຄ່າບົດລາຍງານ';
$string['reportbuilder:read'] = 'ເບິ່ງລາຍງານ';
$string['reportcoursecompletion'] = 'ສຳເລັດລາຍວິຊາຈາກບ່ອນຈັດເກັບຂໍ້ມູນ';
$string['reportcourseenrolmentcompletion'] = 'ການລົງທະບຽນຮຽນລາຍວິຊາ ແລະ ການສຳເລັດ';
$string['reportcourseenrolments'] = 'ການລົງທະບຽນຮຽນລາຍວິຊາ';
$string['reportcourseparticipants'] = 'ຜູ້ເຂົ້າຮ່ວມລາຍວິຊາ';
$string['reportlimitreachedsite'] = 'ຮອດຈຳນວນລາຍງານກຳນົດເອງສູງສຸດສຳລັບເວັບໄຊທ໌ນີ້ແລ້ວ. ກະລຸນາລຶບບາງລາຍງານອອກ ຫຼືຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ';
$string['reportlimitreachedtenant'] = 'ທ່ານສາມາດສ້າງລາຍງານແບບກຳນົດເອງໄດ້ພຽງແຕ່ {$a} ຢູ່ໃນເວັບໄຊທ໌ນີ້. ກະລຸນາລຶບບາງລາຍງານອອກ ຫຼື ຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ';
$string['reportlimitreachedtitle'] = 'ຮອດຈຳກັດລາຍງານແລ້ວ';
$string['reportlists'] = 'ລາຍງານລະບົບສຳລັບບັນຊີລາຍຊື່ບົດລາຍງານ';
$string['reportliveeditingdisabled'] = 'ການເບິ່ງເຫັນຂໍ້ມູນລ່ວງໜ້າຖືກປິດໄວ້ໂດຍຜູ້ເບິ່ງແຍງເວັບໄຊທ໌<br />ຄລິກທີ່ປຸ່ມ "ເບິ່ງຕົວຢ່າງ" ເພື່ອເບິ່ງເນື້ອໃນລາຍງານ';
$string['reportname'] = 'ຊື່ລາຍງານ';
$string['reportname_help'] = 'ໃສ່ຊື່ສຳລັບລາຍງານ';
$string['reportschedules'] = 'ລາຍງານລະບົບສຳລັບລາຍຊື່ກຳນົດເວລາ';
$string['reportsource'] = 'ແຫຼ່ງບົດລາຍງານ';
$string['reportsource_help'] = 'ແຫຼ່ງບົດລາຍງານກໍານົດບ່ອນທີ່ຂໍ້ມູນສໍາລັບບົດລາຍງານຈະມາຈາກ';
$string['reportstab'] = 'ບົດລາຍງານ';
$string['reportuserslist'] = 'ລາຍຊື່ຜູ້ໃຊ້';
$string['resetall'] = 'ຕັ້ງຄ່າຄືນໃໝ່ທັງໝົດ';
$string['resetallconditions'] = 'ຕັ້ງຄ່າເງື່ອນໄຂທັງໝົດຄືນໃໝ່';
$string['resetcondition'] = 'ຕັ້ງຄ່າເງື່ອນໄຂຄືນໃໝ່';
$string['resetfield'] = 'ຕັ້ງຄ່າຊ່ອງຂໍ້ມູນ \'{$a}\'ຄືນໃໝ່';
$string['resettable'] = 'ຕັ້ງຄ່າຕາຕະລາງຄືນໃໝ່';
$string['rolemanager'] = 'ຜູ້ຈັດການຜຸ້ສ້າງລສຍງສຍ';
$string['rolemanagerdescription'] = 'ອະນຸຍາດໃຫ້ສ້າງ ແລະ ຈັດການລາຍງານແບບກຳນົດເອງພາຍໃນຜູ້ເຊົ່າປັດຈຸບັນ';
$string['saveandcontinue'] = 'ບັນທຶກ ແລະ ສືບຕໍ່';
$string['schedule'] = 'ກຳນົດເວລາ';
$string['scheduleaddedastask'] = 'ກຳນົດເວລາຈະຖືກສົ່ງໄປໃນທັນທີທີ່ເປັນໄປໄດ້';
$string['scheduled'] = 'ກຳນົດເວລາແລ້ວ';
$string['schedulename'] = 'ຊື່ກຳນົດເວລາ';
$string['schedulenotifyupgrade'] = 'ຍົກລະດັບຕາຕະລາງການລາຍງານ';
$string['schedulenotifyupgrademessage'] = 'ເປັນສ່ວນໜຶ່ງຂອງການຍົກລະດັບ Moodle Workplace ທີ່ຜ່ານມາຂອງທ່ານ, ກຳນົດເວລາການລາຍງານທີ່ກຳນົດເອງ \'{$a->schedulename}\' ທີ່ທ່ານສ້າງຂຶ້ນສຳລັບລາຍງານ \'<a href="{$a->reportlink}">{$a->reportname} </a>\' ໄດ້ຖືກດັດແປງແລ້ວ.
<br /> <br />
ເນື່ອງຈາກການພິຈາລະນາຄວາມປອດໄພ, Moodle Workplace ບໍ່ຮອງຮັບທີ່ຢູ່ອີເມລຂອງຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ລົງທະບຽນຖືກໃຊ້ເປັນຜູ້ຮັບຕາມກຳນົດເວລາອີກຕໍ່ໄປ. ສໍາລັບການອ້າງອິງ, ອີເມລທີ່ຖືກລົບອອກມີດັ່ງນີ້:
<br /> <br />
{$a->emails}
<br /> <br />
ສຳລັບລາຍລະອຽດເພີ່ມເຕີມ ກະລຸນາເບິ່ງທີ່ <a href="{$a->docslink}">ບັນທຶກການຍົກລະດັບຜູ້ຊົມ ແລະ ກຳນົດເວລາ</a>.';
$string['schedules'] = 'ກຳນົດເວລາ';
$string['selectacondition'] = 'ເລືອກເງື່ອນໄຂ';
$string['selectafilter'] = 'ເລືອກຕົວກັ່ນຕອງ';
$string['selectaggregation'] = 'ເລືອກການລວບລວມສຳລັບຖັນ \'{$a}\'';
$string['selectcohorts'] = 'ເລືອກກຸ່ມ';
$string['selectcourses'] = 'ເລືອກລາຍວິຊາ';
$string['selectsource'] = 'ເລືອກແຫຼ່ງລາຍງານ';
$string['send'] = 'ສົ່ງ';
$string['send_schedulestask'] = 'ກຳນົດເວລາສົ່ງ';
$string['settings'] = 'ຕັ້ງຄ່າ';
$string['shared'] = 'ແບ່ງປັນແລ້ວ';
$string['showfirstcolumntitle'] = 'ສະແດງຫົວຂໍ້ຖັນທຳອິດ';
$string['sidebarbutton'] = 'ສະແດງ/ເຊື່ອງແຖບດ້ານຂ້າງ';
$string['sortingshelp'] = 'ການຈັດລຽງ';
$string['sortingshelp_help'] = 'ການຈັດລຽງເລີ່ມຕົ້ນສຳລັບລາຍງານ';
$string['sortingtab'] = 'ການຈັດລຽງ';
$string['subject'] = 'ເລື່ອງ';
$string['tabletab'] = 'ຕາຕະລາງ';
$string['teststring2'] = 'ສະຕຣິງສອບເສັງ 2';
$string['timecreated'] = 'ສ້າງເວລາແລ້ວ';
$string['userconfirmed'] = 'ຢືນຢັນການລົງທະບຽນ';
$string['userpicture'] = 'ຮູບພາບຜູ້ໃຊ້';
$string['usersuspended'] = 'ໂຈະການລົງທະບຽນ';
$string['userviewreportas'] = 'ເບິ່ງຂໍ້ມູນລາຍງານເປັນ';
$string['userviewreportas_help'] = 'ຂໍ້ມູນລາຍງານຈະຖືກລວມເປັນຖ້າຖືກເບິ່ງໂດຍຜູ້ໃຊ້ທີ່ເລືອກ. ຖ້າປ່ອຍໃຫ້ຫວ່າງ, ຜູ້ໃຊ້ປະຈຸບັນຈະຖືກນຳໃຊ້ເປັນຄ່າເລີ່ມຕົ້ນ';
$string['userviewreportasnotice'] = 'ລາຍງານອາດຈະມີຂໍ້ມູນຈາກຜູ້ເຊົ່າທັງໝົດ';
$string['viewreports'] = 'ຜູ້ສ້າງລາຍງານ';
