<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_almondb', language 'it', version '4.3'.
 *
 * @package     theme_almondb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Impostazioni avanzate';
$string['almondbpage'] = 'Pagine informative';
$string['almondbpagecaption'] = 'Didascalia della pagina';
$string['almondbpagecaptiondesc'] = 'Aggiungi una didascalia per la tua pagina';
$string['almondbpagecaptionsimple'] = 'Didascalia della pagina';
$string['almondbpagecaptionsimpledesc'] = 'Aggiungi una didascalia per la tua pagina';
$string['almondbpagecount'] = 'Conteggio pagine';
$string['almondbpagecountdesc'] = 'Seleziona quante pagine desideri aggiungere <strong>poi clicca su SALVA</strong> per caricare i campi di input.';
$string['almondbpagecountsimple'] = 'Conteggio pagine';
$string['almondbpagecountsimpledesc'] = 'Seleziona quante pagine desideri aggiungere <strong>poi clicca su SALVA</strong> per caricare i campi di input.';
$string['almondbpagecss'] = 'CSS della pagina';
$string['almondbpagecssdesc'] = 'Aggiungi un CSS per la tua pagina';
$string['almondbpagecsslink'] = 'Collegamento CSS della pagina';
$string['almondbpagecsslinkdesc'] = 'Aggiungi un collegamento CSS per la tua pagina,
            Esempio: "https://www.esempio.com/abc.css"';
$string['almondbpagedesign'] = 'Design della pagina';
$string['almondbpagedesigndesc'] = 'Seleziona il design della pagina che desideri aggiungere. Puoi creare rapidamente le tue pagine utilizzando un design semplice.
                                In un design semplice, utilizza solo la parte dell\'immagine e del sottotitolo.';
$string['almondbpageenabled'] = 'Abilita pagina almondb';
$string['almondbpageenableddesc'] = 'Abilita una pagina almondb nella parte superiore della tua home page';
$string['almondbpageenabledsimple'] = 'Abilita pagina almondb';
$string['almondbpageenabledsimpledesc'] = 'Abilita una pagina almondb nella parte superiore della tua home page';
$string['almondbpageend'] = '--Fine--';
$string['almondbpageenddesc'] = '';
$string['almondbpagefooter'] = 'Piè di pagina della pagina';
$string['almondbpagefooterdesc'] = 'Aggiungi il piè di pagina alla pagina delle informazioni';
$string['almondbpagefootersimple'] = 'Piè di pagina della pagina';
$string['almondbpagefootersimpledesc'] = 'Aggiungi il piè di pagina alla pagina delle informazioni';
$string['almondbpageheader'] = 'Intestazione della pagina';
$string['almondbpageheaderdesc'] = 'Aggiungi l\'intestazione alla pagina delle informazioni';
$string['almondbpageheadersimple'] = 'Intestazione della pagina';
$string['almondbpageheadersimpledesc'] = 'Aggiungi l\'intestazione alla pagina delle informazioni';
$string['almondbpageheading'] = ': Impostazioni avanzate della pagina';
$string['almondbpageheadingdesc'] = 'Ciò crea fino a sei pagine informative per promuovere elementi importanti del tuo sito.';
$string['almondbpageheadingsimple'] = '! Impostazioni pagina semplice';
$string['almondbpageheadingsimpledesc'] = 'Ciò crea fino a sei pagine informative per promuovere elementi importanti del tuo sito.';
$string['almondbpageimage'] = 'Immagine della pagina';
$string['almondbpageimagedesc'] = 'Aggiungi un\'immagine per la tua pagina.';
$string['almondbpageimagesimple'] = 'Immagine della pagina';
$string['almondbpageimagesimpledesc'] = 'Aggiungi un\'immagine per la tua pagina.';
$string['almondbpageimglink'] = 'Collegamento cartella immagini della pagina';
$string['almondbpageimglinkdesc'] = 'Aggiungi un collegamento alla cartella immagini per la tua pagina, copia le immagini che utilizzi in HTML in questa cartella.
            Se compili il campo della cartella immagini, non fornire il percorso dell\'immagine in HTML,
            scrivilo solo come demo-1.png (o jpg).
            Esempio: http://www.esempio.com/img/ , (img src= demo-1.jpg)';
$string['almondbpageimgpositionsimple'] = 'Posizione dell\'immagine della pagina';
$string['almondbpageimgpositionsimpledesc'] = 'Dove verrà posizionata l\'immagine caricata sulla pagina.';
$string['almondbpagenavbar'] = 'Barra di navigazione della pagina';
$string['almondbpagenavbardesc'] = 'Aggiungi la barra di navigazione alla pagina delle informazioni';
$string['almondbpageno'] = '! Pagina-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Inserisci le impostazioni per la pagina {$a->almondbpage}. <b><i>LINK PAGINA: www.tuosito/locale/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagenosimple'] = '! Pagina-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Inserisci le impostazioni per la pagina {$a->almondbpage}. <b><i>LINK PAGINA: www.tuosito/locale/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagenotfound'] = 'Pagina non trovata, controlla l\'URL';
$string['almondbpagestart'] = 'Impostazioni pagina informazioni';
$string['almondbpagestartdesc'] = '';
$string['almondbpagetitle'] = 'Titolo della pagina';
$string['almondbpagetitledesc'] = 'Aggiungi il titolo della pagina.';
$string['almondbpagetitlesimple'] = 'Titolo della pagina';
$string['almondbpagetitlesimpledesc'] = 'Aggiungi il titolo della pagina.';
$string['backcolor'] = 'Colore di sfondo';
$string['backcolor_desc'] = 'Colore di sfondo';
$string['backgroundimage'] = 'Immagine di sfondo';
$string['backgroundimage_desc'] = 'L\'immagine da visualizzare come sfondo del sito. L\'immagine di sfondo caricata qui sovrascriverà l\'immagine di sfondo nei file di impostazioni predefinite del tema.';
$string['block01button'] = 'Pulsante blocco 1';
$string['block01buttondesc'] = 'Aggiungi un pulsante per il tuo blocco 1';
$string['block01buttonlink'] = 'URL blocco 1';
$string['block01buttonlinkdesc'] = 'Aggiungi un URL per il tuo blocco 1';
$string['block01caption'] = 'Didascalia blocco 1';
$string['block01captiondefault'] = '<h2 class="white">Temi Premium in Primo Piano</h2><br>
<p class="white">I temi sono costruiti senza disturbare la disposizione di Moodle, rendendo il tuo lavoro più semplice. Scopri alcune delle principali caratteristiche dei temi.</p>';
$string['block01captiondesc'] = 'Aggiungi una didascalia per il tuo blocco 1';
$string['block01color'] = 'Colore di sfondo blocco 1';
$string['block01colordesc'] = 'Aggiungi un colore di sfondo per il tuo blocco 1';
$string['block01enabled'] = 'Abilita blocco 1';
$string['block01enableddesc'] = 'Abilita o disabilita il blocco 1 nella tua home page';
$string['block01info'] = ': Blocco-1 RIEPILOGO TITOLO';
$string['block01infodesc'] = 'RIEPILOGO TITOLO - Inserisci le impostazioni per il blocco 1';
$string['block02button'] = 'Pulsante blocco {$a->block}';
$string['block02buttondesc'] = 'Aggiungi un pulsante per il tuo blocco';
$string['block02buttonlink'] = 'URL blocco {$a->block}';
$string['block02buttonlinkdesc'] = 'Aggiungi un URL per il tuo blocco';
$string['block02caption'] = 'Didascalia blocco {$a->block}';
$string['block02captiondefault'] = 'Goditi i nostri corsi online gratuiti,
ovunque tu sia e quando vuoi. Accedi ai contenuti del corso su mobile, tablet o desktop';
$string['block02captiondesc'] = 'Aggiungi una didascalia per il tuo blocco';
$string['block02count'] = 'Conteggio blocco 2';
$string['block02countdesc'] = 'Seleziona il numero di caselle e premi il pulsante Salva modifiche';
$string['block02enabled'] = 'Abilita blocco 2';
$string['block02enableddesc'] = 'Abilita o disabilita il blocco 2 nella tua home page';
$string['block02icon'] = 'Icona blocco {$a->block}';
$string['block02icondefault'] = '';
$string['block02icondefault1'] = 'core:i/report';
$string['block02icondefault2'] = 'core:i/settings';
$string['block02icondefault3'] = 'core:i/stats';
$string['block02icondefault4'] = 'core:i/notifications';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clicca per vedere le icone</a>';
$string['block02imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block02info'] = '! Blocco-2 ICON BOX';
$string['block02infodesc'] = 'ICON BOX - Inserisci le impostazioni per il blocco 2';
$string['block02title'] = 'Titolo blocco {$a->block}';
$string['block02titledefault'] = 'Top Investment Advisors';
$string['block02titledesc'] = 'Aggiungi un titolo per il tuo blocco';
$string['block03caption'] = 'Didascalia blocco 3 {$a->block}';
$string['block03captiondefault'] = 'Vestibulum non diam quis nisl dignissim posuere a vulputate urna nunc velit';
$string['block03captiondesc'] = 'Aggiungi una didascalia per il tuo blocco 3';
$string['block03design'] = 'Design blocco 3';
$string['block03designdesc'] = 'Seleziona il design del blocco 3 che desideri aggiungere';
$string['block03enabled'] = 'Abilita blocco 3';
$string['block03enableddesc'] = 'Abilita o disabilita il blocco 3 nella tua home page';
$string['block03header'] = 'Intestazione blocco 3';
$string['block03headerdefault'] = 'SIAMO THEMES ALMOND';
$string['block03headerdesc'] = 'Intestazione blocco 3';
$string['block03icon'] = 'Icona blocco 3 {$a->block}';
$string['block03icondefault'] = 'core:i/categoryevent';
$string['block03icondefault1'] = 'core:t/download';
$string['block03icondefault2'] = 'core:a/setting';
$string['block03icondefault3'] = 'core:docs';
$string['block03icondefault4'] = 'core:i/duration';
$string['block03icondefault5'] = 'core:i/checked';
$string['block03icondefault6'] = 'core:e/visual_aid';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clicca per vedere le icone</a>';
$string['block03info'] = '! Blocco-3 CARATTERISTICHE';
$string['block03infodesc'] = 'CARATTERISTICHE - Inserisci le impostazioni per il blocco 3';
$string['block03link'] = 'URL blocco 3 {$a->block}';
$string['block03linkdesc'] = 'Aggiungi un URL per il tuo blocco 3';
$string['block03title'] = 'Titolo blocco 3 {$a->block}';
$string['block03titledefault'] = 'Design responsivo';
$string['block03titledesc'] = 'Aggiungi un titolo per il tuo blocco 3';
$string['block04button'] = 'Testo pulsante blocco 4';
$string['block04buttondefault'] = 'Visualizza tutti i corsi';
$string['block04buttondesc'] = 'Testo pulsante blocco 4';
$string['block04buttonlink'] = 'Collegamento pulsante blocco 4';
$string['block04buttonlinkdefault'] = 'course/index.php';
$string['block04buttonlinkdesc'] = 'Collegamento pulsante blocco 4';
$string['block04caption'] = 'Didascalia blocco 4 {$a->block}';
$string['block04captiondesc'] = 'Aggiungi una didascalia per il tuo blocco 4';
$string['block04design'] = 'Design blocco 4';
$string['block04designdesc'] = 'Seleziona il design del blocco 4 che desideri aggiungere';
$string['block04enabled'] = 'Abilita blocco 4';
$string['block04enableddesc'] = 'Abilita o disabilita il blocco 4 nella tua home page';
$string['block04header'] = 'Intestazione blocco 4';
$string['block04headerdefault'] = 'ULTIMI PROGETTI';
$string['block04headerdesc'] = 'Intestazione blocco 4';
$string['block04imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block04info'] = '! Blocco-4 ULTIMI';
$string['block04infodesc'] = 'ULTIMI - Inserisci le impostazioni per il blocco 4';
$string['block04link'] = 'URL blocco 4 {$a->block}';
$string['block04linkdesc'] = 'Aggiungi un URL per il tuo blocco 4';
$string['block04title'] = 'Titolo blocco 4 {$a->block}';
$string['block04titledesc'] = 'Aggiungi un titolo per il tuo blocco 4';
$string['block05caption'] = 'Didascalia blocco 5 {$a->block}';
$string['block05captiondesc'] = 'Aggiungi una didascalia per il tuo blocco 5';
$string['block05design'] = 'Design blocco 5';
$string['block05designdesc'] = 'Seleziona il design del blocco 5 che desideri aggiungere';
$string['block05enabled'] = 'Abilita blocco 5';
$string['block05enableddesc'] = 'Abilita o disabilita il blocco 5 nella tua home page';
$string['block05header'] = 'Intestazione blocco 5';
$string['block05headerdefault'] = 'PERCHÉ SCEGLIERCI';
$string['block05headerdesc'] = 'Intestazione blocco 5';
$string['block05icon'] = 'Icona blocco 5 {$a->block}';
$string['block05icondefault'] = 'core:i/categoryevent';
$string['block05icondefault1'] = 'core:i/settings';
$string['block05icondefault2'] = 'core:i/hide';
$string['block05icondefault3'] = 'core:i/bullhorn';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Clicca per vedere le icone</a>';
$string['block05imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block05info'] = '! Blocco-5 PERCHÉ NOI';
$string['block05infodesc'] = 'PERCHÉ NOI - Inserisci le impostazioni per il blocco 5';
$string['block05link'] = 'URL blocco 5 {$a->block}';
$string['block05linkdesc'] = 'Aggiungi un URL per il tuo blocco 5';
$string['block05title'] = 'Titolo blocco 5 {$a->block}';
$string['block05titledesc'] = 'Aggiungi un titolo per il tuo blocco 5';
$string['block06button'] = 'URL blocco 6';
$string['block06buttondesc'] = 'Aggiungi un URL per il tuo blocco 6';
$string['block06buttonlink'] = 'URL blocco 6';
$string['block06buttonlinkdesc'] = 'Aggiungi un URL per il tuo blocco 6';
$string['block06caption'] = 'Didascalia blocco 6';
$string['block06captiondefault'] = 'Aggiungi una didascalia predefinita per il tuo blocco 6';
$string['block06captiondesc'] = 'Aggiungi una didascalia per il tuo blocco 6';
$string['block06color'] = 'Colore di sfondo blocco 6';
$string['block06colordesc'] = 'Aggiungi un colore di sfondo per il tuo blocco 6';
$string['block06design'] = 'Design blocco 6';
$string['block06designdesc'] = 'Seleziona il design del blocco 6 che desideri aggiungere';
$string['block06enabled'] = 'Abilita blocco 6';
$string['block06enableddesc'] = 'Abilita o disabilita il blocco 6 nella tua home page';
$string['block06header'] = 'Intestazione blocco 6';
$string['block06headerdefault'] = 'LAVORARE CON NOI';
$string['block06headerdesc'] = 'Intestazione blocco 6';
$string['block06imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block06info'] = '! Blocco-6 LAVORARE CON NOI';
$string['block06infodesc'] = 'LAVORARE CON NOI - Inserisci le impostazioni per il blocco 6';
$string['block07button'] = 'URL blocco 7';
$string['block07buttondesc'] = 'Aggiungi un URL per il tuo blocco 7';
$string['block07buttonlink'] = 'URL blocco 7';
$string['block07buttonlinkdesc'] = 'Aggiungi un URL per il tuo blocco 7';
$string['block07count'] = 'Conteggio blocco 7';
$string['block07countdefault'] = '8';
$string['block07countdesc'] = 'Numero di corsi da mostrare';
$string['block07design'] = 'Design blocco 7';
$string['block07designdesc'] = 'Seleziona il design del blocco 7 che desideri aggiungere';
$string['block07enabled'] = 'Abilita blocco 7';
$string['block07enableddesc'] = 'Abilita o disabilita il blocco 7 nella tua home page';
$string['block07enrol'] = 'Gratuito';
$string['block07header'] = 'Intestazione blocco 7';
$string['block07headerdefault'] = 'CORSI DISPONIBILI';
$string['block07headerdesc'] = 'Intestazione blocco 7';
$string['block07info'] = '! Blocco-7 CORSI DISPONIBILI';
$string['block07infodesc'] = 'CORSI DISPONIBILI - Inserisci le impostazioni per il blocco 7';
$string['block07priceshow'] = 'Mostra prezzo iscrizione al corso';
$string['block07priceshowdesc'] = 'Abilita/Disabilita il prezzo di iscrizione al corso';
$string['block07studentrole'] = 'Ruolo studente blocco 7';
$string['block07studentroledesc'] = 'Seleziona il ruolo dello studente';
$string['block07teacherenabled'] = 'Insegnante abilitato blocco 7';
$string['block07teacherenableddesc'] = 'Mostrare l\'insegnante?';
$string['block07teacherrole'] = 'Ruolo insegnante blocco 7';
$string['block07teacherroledesc'] = 'Seleziona il ruolo dell\'insegnante';
$string['block07title'] = 'Titolo blocco 7';
$string['block07titledefault'] = 'shortname';
$string['block07titledesc'] = 'Tipo di titolo del corso';
$string['block07tooltipcategory'] = 'Categoria';
$string['block07tooltipenrolled'] = 'Studenti iscritti';
$string['block07tooltiplastdate'] = 'Data ultima modifica';
$string['block08caption'] = 'Didascalia blocco 8';
$string['block08captiondefault'] = 'Continuiamo a servire con il nostro personale docente distinto. Incontra i nostri insegnanti.';
$string['block08captiondesc'] = 'Didascalia blocco 8';
$string['block08count'] = 'Conteggio blocco 8';
$string['block08countdefault'] = '8';
$string['block08countdesc'] = 'Numero di insegnanti da mostrare';
$string['block08description'] = 'Descrizione blocco 8';
$string['block08descriptiondesc'] = 'Mostra la descrizione utente sulla pagina';
$string['block08design'] = 'Design blocco 8';
$string['block08designdesc'] = 'Seleziona il design del blocco 8 che desideri aggiungere';
$string['block08enabled'] = 'Abilita blocco 8';
$string['block08enableddesc'] = 'Abilita o disabilita il blocco 8 nella tua home page';
$string['block08header'] = 'Intestazione blocco 8';
$string['block08headerdefault'] = 'INSEGNANTI';
$string['block08headerdesc'] = 'Intestazione blocco 8';
$string['block08info'] = '! Blocco-8 INSEGNANTE';
$string['block08infodesc'] = 'INSEGNANTI - Inserisci le impostazioni per il blocco 8';
$string['block08showrole'] = 'Mostra ruolo blocco 8';
$string['block08showroledesc'] = 'Ruolo utente da mostrare nel blocco 8';
$string['block08studentrole'] = 'Ruolo studente blocco 8';
$string['block08studentroledesc'] = 'Ruolo studente';
$string['block08tooltipcourse'] = 'Numero totale di corsi dell\'insegnante';
$string['block08tooltipstudents'] = 'Numero totale di studenti dell\'insegnante';
$string['block08total'] = 'Totale blocco 8';
$string['block08totaldesc'] = 'Mostra il numero totale di corsi e studenti';
$string['block09background'] = 'Sfondo blocco 9';
$string['block09backgrounddesc'] = 'Seleziona il colore o l\'immagine di sfondo del blocco 9';
$string['block09boxshadow'] = 'Ombra blocco 9';
$string['block09boxshadowdesc'] = 'Seleziona l\'ombra del blocco 9 abilitata';
$string['block09caption'] = 'Didascalia blocco 9';
$string['block09captiondefault'] = 'Elenco delle categorie registrate';
$string['block09captiondesc'] = 'Didascalia blocco 9';
$string['block09count'] = 'Conteggio blocco 9';
$string['block09countdefault'] = '8';
$string['block09countdesc'] = 'Numero di categorie da mostrare';
$string['block09ctgid'] = 'ID Categoria blocco 9';
$string['block09ctgiddesc'] = 'Seleziona l\'ID della categoria del blocco 9 (es. id = 1 o id = 2 o id = 3...), lascia vuoto per tutte le categorie.';
$string['block09design'] = 'Design blocco 9';
$string['block09designdesc'] = 'Seleziona il design del blocco 9 che desideri aggiungere';
$string['block09enabled'] = 'Abilita blocco 9';
$string['block09enableddesc'] = 'Abilita o disabilita il blocco 9 nella tua home page';
$string['block09header'] = 'Intestazione blocco 9';
$string['block09headerdefault'] = 'Categorie disponibili';
$string['block09headerdesc'] = 'Descrizione intestazione blocco 9';
$string['block09info'] = '! Blocco-9 CATEGORIE';
$string['block09infodesc'] = 'CATEGORIE - Inserisci le impostazioni per il blocco 9';
$string['block10caption'] = 'Didascalia blocco 10 {$a->block}';
$string['block10captiondesc'] = 'Aggiungi una didascalia per il tuo blocco';
$string['block10count'] = 'Conteggio blocco 10';
$string['block10countdesc'] = 'Seleziona il numero di riquadri e premi il pulsante Salva modifiche';
$string['block10design'] = 'Design blocco 10';
$string['block10designdesc'] = 'Seleziona il design del blocco 10 che desideri aggiungere';
$string['block10enabled'] = 'Abilita blocco 10';
$string['block10enableddesc'] = 'Abilita o disabilita il blocco 10 nella tua home page';
$string['block10header'] = 'Intestazione blocco 10';
$string['block10headerdefault'] = 'TESTIMONIANZE';
$string['block10headerdesc'] = 'Intestazione blocco 10';
$string['block10imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block10info'] = '! Blocco-10 TESTIMONIANZE';
$string['block10infodesc'] = 'TESTIMONIANZE - Inserisci le impostazioni per il blocco 10';
$string['block10job'] = 'Lavoro blocco 10 {$a->block}';
$string['block10jobdesc'] = 'Lavoro blocco 10';
$string['block10link'] = 'URL blocco 10 {$a->block}';
$string['block10linkdesc'] = 'Aggiungi un URL per il tuo blocco';
$string['block10name'] = 'Nome blocco 10 {$a->block}';
$string['block10namedesc'] = 'Nome blocco 10';
$string['block11caption'] = 'Didascalia blocco 11';
$string['block11captiondefault'] = 'Benvenuti ai post del blog di Almondb.';
$string['block11captiondesc'] = 'Didascalia blocco 11';
$string['block11count'] = 'Conteggio blocco 11';
$string['block11countdesc'] = 'Seleziona il numero di blog da visualizzare';
$string['block11design'] = 'Design blocco 11';
$string['block11designdesc'] = 'Seleziona il design del blocco 11 che desideri aggiungere';
$string['block11enabled'] = 'Abilita blocco 11';
$string['block11enableddesc'] = 'Abilita o disabilita il blocco 11 nella tua home page';
$string['block11header'] = 'Intestazione blocco 11';
$string['block11headerdefault'] = 'BLOG ALMOND';
$string['block11headerdesc'] = 'Intestazione blocco 11';
$string['block11info'] = '! Blocco-11 POST DEL BLOG';
$string['block11infodesc'] = 'POST DEL BLOG - Inserisci le impostazioni per il blocco 11';
$string['block12info'] = '! Blocco-12 Vuoto';
$string['block13info'] = '! Blocco-13 Vuoto';
$string['block14info'] = '! Blocco-14 Vuoto';
$string['block15info'] = '! Blocco-15 Vuoto';
$string['block16info'] = '! Blocco-16 Vuoto';
$string['block17info'] = '! Blocco-17 Vuoto';
$string['block18caption'] = 'Didascalia blocco 18';
$string['block18captiondesc'] = 'Didascalia blocco 18';
$string['block18css'] = 'CSS blocco 18';
$string['block18cssdesc'] = 'Aggiungi un CSS per il tuo blocco';
$string['block18csslink'] = 'Link CSS blocco 18';
$string['block18csslinkdesc'] = 'Aggiungi un link CSS per il tuo blocco';
$string['block18enabled'] = 'Abilita blocco 18';
$string['block18enableddesc'] = 'Abilita o disabilita il blocco 18 nella tua home page';
$string['block18info'] = '! Blocco-18 BLOCCO HTML';
$string['block18infodesc'] = 'BLOCCO HTML - Inserisci le impostazioni per il blocco 18';
$string['block18title'] = 'Titolo blocco 18';
$string['block18titledesc'] = 'Seleziona il design del blocco 18 che desideri aggiungere';
$string['block19caption'] = 'Didascalia blocco 19';
$string['block19captiondefault'] = 'È un fatto consolidato che un lettore sarà distratto dal
                                    contenuto leggibile di una pagina quando ne osserva il layout.';
$string['block19captiondesc'] = 'Didascalia blocco 19';
$string['block19design'] = 'Design blocco 19';
$string['block19designdesc'] = 'Seleziona il design del blocco 19 che desideri aggiungere';
$string['block19enabled'] = 'Abilita blocco 19';
$string['block19enableddesc'] = 'Abilita o disabilita il blocco 19 nella tua home page';
$string['block19header'] = 'Intestazione blocco 19';
$string['block19headerdefault'] = 'I NOSTRI PARTNER';
$string['block19headerdesc'] = 'Intestazione blocco 19';
$string['block19headerenabled'] = 'Intestazione abilita blocco 19';
$string['block19headerenableddesc'] = 'Intestazione abilita/disabilita blocco 19';
$string['block19imgdesc'] = 'Aggiungi un\'immagine per il tuo blocco';
$string['block19info'] = '! Blocco-19 BRAND';
$string['block19infodesc'] = 'BRAND - Inserisci le impostazioni per il blocco 19';
$string['block19link'] = 'URL immagine blocco 19 {$a->block}';
$string['block19linkdesc'] = 'Aggiungi un URL immagine per il tuo blocco 19';
$string['block20col1caption'] = 'Didascalia colonna 1 Blocco 20';
$string['block20col1captiondefault'] = 'È un fatto consolidato che un lettore sarà distratto dal
                                    contenuto leggibile di una pagina quando ne osserva il layout.';
$string['block20col1captiondesc'] = 'Didascalia colonna 1 Blocco 20';
$string['block20col1header'] = 'Intestazione colonna 1 Blocco 20';
$string['block20col1headerdesc'] = 'Intestazione colonna 1 Blocco 20';
$string['block20col2header'] = 'Intestazione colonna 2 Blocco 20';
$string['block20col2headerdesc'] = 'Inserisci l\'intestazione colonna 2 Blocco 20';
$string['block20col2link'] = 'Collegamento colonna 2 Blocco 20';
$string['block20col2linkdefault'] = 'Chi siamo|https://themesalmond.com
                                    La nostra storia|https://moodle.org/support
                                    Termini e condizioni|https://moodle.org/development
                                    Informativa sulla privacy|http://docs.moodle.org|Moodle Docs
                                    Mappa del sito|http://docs.moodle.org/en|Documentazione in inglese|en
                                    Moodle.com|http://moodle.com/';
$string['block20col2linkdesc'] = 'Area collegamento colonna 2 Blocco 20';
$string['block20col3header'] = 'Intestazione colonna 3 Blocco 20';
$string['block20col3headerdesc'] = 'Inserisci l\'intestazione colonna 3 Blocco 20';
$string['block20col3link'] = 'Collegamento colonna 3 Blocco 20';
$string['block20col3linkdefault'] = 'Chi siamo|https://themesalmond.com
                                    La nostra storia|https://moodle.org/support
                                    Termini e condizioni|https://moodle.org/development
                                    Informativa sulla privacy|http://docs.moodle.org|Moodle Docs
                                    Mappa del sito|http://docs.moodle.org/tr|Documentazione in turco|tr
                                    Moodle.com|http://moodle.com/';
$string['block20col3linkdesc'] = 'Area collegamento colonna 3 Blocco 20';
$string['block20col4caption'] = 'Didascalia colonna 4 Blocco 20';
$string['block20col4captiondefault'] = 'Indirizzo';
$string['block20col4captiondesc'] = 'Inserisci la didascalia colonna 4 Blocco 20';
$string['block20col4header'] = 'Intestazione colonna 4 Blocco 20';
$string['block20col4headerdesc'] = 'Inserisci l\'intestazione colonna 4 Blocco 20';
$string['block20copyright'] = 'Copyright Blocco 20';
$string['block20copyrightdefault'] = 'Copyright © 2022 Progettato da
    <a href="https://www.themealmond.com">themesalmond.com</a>.  Tutti i diritti riservati.';
$string['block20copyrightdesc'] = 'Copyright Blocco 20';
$string['block20enabled'] = 'Abilita blocco 20';
$string['block20enableddesc'] = 'Abilita o disabilita il blocco 20 nella tua home page';
$string['block20info'] = '! Blocco-20 PIE DI PAGINA';
$string['block20infodesc'] = 'PIE DI PAGINA - Inserisci le impostazioni per il blocco 20';
$string['block20logo'] = 'Seleziona il logo del Blocco 20';
$string['block20logodesc'] = 'Selezione logo Blocco 20';
$string['block20moodle'] = 'Abilita pulsante pagina iniziale';
$string['block20moodledesc'] = 'Abilita o disabilita la pagina iniziale originale di Moodle nel Blocco 20';
$string['block20social'] = 'Collegamenti social Blocco 20';
$string['block20socialdefault'] = '<ul>
<li><a href="#" target="_blank"><i class="fa fa-facebook-f"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-linkedin"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-instagram"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
</ul>';
$string['block20socialdesc'] = 'Collegamenti social Blocco 20';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Un bootswatch è un insieme di variabili Bootstrap e css per stilizzare Bootstrap';
$string['brandcolor'] = 'Colore del brand';
$string['brandcolor_desc'] = 'Il colore di sfondo.';
$string['button'] = 'Pulsante';
$string['buttonlink'] = 'https://themesalmond.com/';
$string['choosereadme'] = 'almondb è un tema moderno altamente personalizzabile.';
$string['configtitle'] = 'Almondb';
$string['coursesection'] = 'Sezioni del corso';
$string['coursesummary'] = 'Riepilogo del corso';
$string['currentinparentheses'] = '(corrente)';
$string['dashboardnavchoice'] = 'Navigazione della pagina del cruscotto';
$string['dashboardnavchoicedesc'] = 'Seleziona la navigazione della pagina del cruscotto da visualizzare';
$string['div'] = '</div>';
$string['divdiv'] = '</div></div></div>';
$string['footerbackgroundcolor'] = 'Colore di sfondo del piè di pagina';
$string['footerbackgroundcolordesc'] = 'Puoi cambiare il colore di sfondo del piè di pagina';
$string['footerselect'] = 'Piè di pagina della bacheca';
$string['footerselectdesc'] = 'Seleziona lo stile del piè di pagina della bacheca';
$string['frontpagealmondb'] = 'Pagina principale';
$string['frontpagechoice'] = 'Seleziona la pagina principale';
$string['frontpagechoicedesc'] = 'Seleziona la pagina principale da visualizzare';
$string['frontpagecolor'] = 'Seleziona colore predefinito della pagina principale';
$string['frontpagecolordesc'] = '<div class="row pb-3">
                                    <div class="col p-1 text-center" style="background-color:#4272d7;"> 1-#4272d7</div>
                                    <div class="col p-1 text-center" style="background-color:#f98012;"> 2-#f98012</div>
                                    <div class="col p-1 text-center" style="background-color:#fa4251;"> 3-#fa4251</div>
                                    <div class="col p-1 text-center" style="background-color:#c45e28;"> 4-#c45e28</div>
                                    <div class="col p-1 text-center" style="background-color:#63c76a;"> 5-#63c76a</div>
                                    <div class="col p-1 text-center" style="background-color:#024E64;"> 6-#024E64</div>
                                </div>';
$string['frontpagedesc'] = 'Seleziona la pagina principale da visualizzare';
$string['frontpageend'] = '--Fine--';
$string['frontpageenddesc'] = '';
$string['frontpageheading'] = '! Scelta pagina principale';
$string['frontpageheading1'] = '! SEZIONE della pagina principale';
$string['frontpageheadingdesc1'] = 'Selezione della sezione della pagina principale numero uno
<br><a href="./../theme/almondb/pix/almondb/slide_01.jpg" target="_blank">Clicca per vedere i blocchi</a>';
$string['frontpagenav'] = ': Scelta intestazione della pagina principale';
$string['frontpagenavchoice'] = 'Navigazione della pagina principale';
$string['frontpagenavchoicedesc'] = 'Seleziona la navigazione della pagina principale da visualizzare';
$string['frontpagenavdesc'] = 'Seleziona l\'intestazione della pagina principale da visualizzare';
$string['frontpagenavlightdark'] = 'Pagina principale chiara-scuro';
$string['frontpagenavlightdarkdesc'] = 'Se hai scelto un colore scuro sopra, seleziona "navbar-dark".';
$string['frontpagenavlink'] = 'Collegamenti della barra di navigazione della pagina principale';
$string['frontpagenavlinkdefault'] = 'Caratteristiche
-Intestazione
-Colori|/mod/page/view.php?id=113
-Blocchi|/mod/page/view.php?id=114
-Facile e veloce|/mod/page/view.php?id=115
-Usa ora|/mod/page/view.php?id=116
Pagine
-Chi siamo|/mod/page/view.php?id=1
-Blog|/blog/
Corsi
-Tutti i corsi|/course/
-Ricerca corsi|/course/search.php|_blank
Fluide
-Riquadro del titolo|#block01
-Riquadro dell\'icona|#block02
-Caratteristiche|#block03
-Ultimi|#block04
-PERCHÉ noi|#block05
-Lavorare con noi|#block06
-Corso|#block07
-Insegnante|#block08
-Categoria|#block09
-Testimonianze|#block10|_self
-Articoli del blog|#block11|_self
-HTML di blocco|#block18|_self
-Marchi|#block19
Piè di pagina|#block20
Insegnanti|#block08
Documentazione|https://themesalmond.com/documents/|_blank';
$string['frontpagenavlinkdesc'] = 'Inserisci i collegamenti della barra di navigazione della pagina principale';
$string['frontpagesection1_1'] = 'Sezione 1';
$string['frontpagesection1_10'] = 'Sezione 10';
$string['frontpagesection1_2'] = 'Sezione 2';
$string['frontpagesection1_3'] = 'Sezione 3';
$string['frontpagesection1_4'] = 'Sezione 4';
$string['frontpagesection1_5'] = 'Sezione 5';
$string['frontpagesection1_6'] = 'Sezione 6';
$string['frontpagesection1_7'] = 'Sezione 7';
$string['frontpagesection1_8'] = 'Sezione 8';
$string['frontpagesection1_9'] = 'Sezione 9';
$string['frontpagesectiondesc1_1'] = 'Sezione 1 della pagina principale';
$string['frontpagesectiondesc1_10'] = 'Sezione 10 della pagina principale';
$string['frontpagesectiondesc1_2'] = 'Sezione 2 della pagina principale';
$string['frontpagesectiondesc1_3'] = 'Sezione 3 della pagina principale';
$string['frontpagesectiondesc1_4'] = 'Sezione 4 della pagina principale';
$string['frontpagesectiondesc1_5'] = 'Sezione 5 della pagina principale';
$string['frontpagesectiondesc1_6'] = 'Sezione 6 della pagina principale';
$string['frontpagesectiondesc1_7'] = 'Sezione 7 della pagina principale';
$string['frontpagesectiondesc1_8'] = 'Sezione 8 della pagina principale';
$string['frontpagesectiondesc1_9'] = 'Sezione 9 della pagina principale';
$string['generalsettings'] = 'Impostazioni generali';
$string['header3phone'] = 'Numero di telefono';
$string['header3phonedesc'] = 'Numero di telefono di contatto da mostrare nella barra di navigazione.';
$string['headerlogo'] = 'Seleziona il logo della barra di navigazione';
$string['headerlogodesc'] = 'Seleziona il logo della navigazione della pagina principale da visualizzare';
$string['imgloginbackground'] = 'Immagine di sfondo della pagina di accesso';
$string['imgloginbackground_desc'] = 'Descrizione dell\'immagine di sfondo della pagina di accesso';
$string['loggedinnot'] = 'accedi.';
$string['loginbackgroundimage'] = 'Immagine di sfondo della pagina di accesso';
$string['loginbackgroundimage_desc'] = 'L\'immagine da visualizzare come sfondo per la pagina di accesso.';
$string['loginposition'] = 'Posizione del modulo di accesso';
$string['loginpositiondesc'] = 'Seleziona la posizione dello schermo del modulo di accesso';
$string['navbarcolor'] = 'Colore di sfondo della barra di navigazione';
$string['navbarcolor_desc'] = 'Colore di sfondo della barra di navigazione';
$string['navbarcontainer'] = 'Aggiungi container';
$string['navbarcontainerdesc'] = 'Puoi inserire la barra di navigazione all\'interno del container';
$string['nobootswatch'] = 'Nessuno';
$string['over'] = 'con';
$string['pluginname'] = 'Almondb';
$string['preset'] = 'Impostazioni predefinite del tema';
$string['preset_desc'] = 'Scegli un set di impostazioni predefinite per cambiare ampiamente l\'aspetto del tema.';
$string['presetfiles'] = 'File di impostazioni predefinite aggiuntivi del tema';
$string['presetfiles_desc'] = 'I file di impostazioni predefinite possono essere utilizzati per modificare drasticamente l\'aspetto del tema. Consulta <a href="https://docs.moodle.org/dev/almondb_Presets">almondb presets</a> per informazioni su come creare e condividere i tuoi file di impostazioni predefinite e consulta il <a href="https://archive.moodle.net/almondb">Repository delle impostazioni predefinite</a> per le impostazioni predefinite condivise da altri.';
$string['privacy:drawerblockclosed'] = 'La preferenza corrente per il cassetto dei blocchi è chiusa.';
$string['privacy:drawerblockopen'] = 'La preferenza corrente per il cassetto dei blocchi è aperta.';
$string['privacy:drawerindexclosed'] = 'La preferenza corrente per il cassetto dell\'indice è chiusa.';
$string['privacy:drawerindexopen'] = 'La preferenza corrente per il cassetto dell\'indice è aperta.';
$string['privacy:drawernavclosed'] = 'La preferenza corrente per il cassetto della navigazione è chiusa.';
$string['privacy:drawernavopen'] = 'La preferenza corrente per il cassetto della navigazione è aperta.';
$string['privacy:metadata'] = 'Il tema almondb non memorizza dati personali su alcun utente.';
$string['privacy:metadata:preference:draweropenblock'] = 'La preferenza dell\'utente per nascondere o mostrare il cassetto con i blocchi.';
$string['privacy:metadata:preference:draweropenindex'] = 'La preferenza dell\'utente per nascondere o mostrare il cassetto con l\'indice del corso.';
$string['privacy:metadata:preference:draweropennav'] = 'La preferenza dell\'utente per nascondere o mostrare la navigazione del cassetto.';
$string['rawscss'] = 'SCSS grezzo';
$string['rawscss_desc'] = 'Utilizza questo campo per fornire codice SCSS o CSS che verrà iniettato alla fine del foglio di stile.';
$string['rawscsspre'] = 'SCSS iniziale grezzo';
$string['rawscsspre_desc'] = 'In questo campo è possibile fornire codice SCSS di inizializzazione, che verrà iniettato prima di tutto il resto. Nella maggior parte dei casi, utilizzerai questa impostazione per definire variabili.';
$string['region-side-pre'] = 'Destra';
$string['sitecolor'] = 'Seleziona colore della pagina principale';
$string['sitecolor-1'] = '#4272d7';
$string['sitecolor-2'] = '#f98012';
$string['sitecolor-3'] = '#fa4251';
$string['sitecolor-4'] = '#c45e28';
$string['sitecolor-5'] = '#63c76a';
$string['sitecolor-6'] = '#024E64';
$string['sitecolor_desc'] = 'Puoi scegliere il colore che desideri tranne quello predefinito';
$string['slideno'] = '! Diapositiva-{$a->slide}';
$string['slidenodesc'] = 'Inserisci le impostazioni per la diapositiva {$a->slide}.';
$string['sliderbutton'] = 'Pulsante slider';
$string['sliderbuttondesc'] = 'Inserisci la destinazione del testo del pulsante dell\'immagine della diapositiva,
sia la chiave di lingua che il testo. Ad esempio: lang:display o Display';
$string['sliderbuttonurl'] = 'Collegamento pulsante diapositiva';
$string['sliderbuttonurldesc'] = 'Inserisci la destinazione del collegamento del pulsante dell\'immagine della diapositiva';
$string['slidercaption'] = 'Didascalia slider';
$string['slidercaptiondesc'] = 'Aggiungi una didascalia per la tua diapositiva';
$string['slidercount'] = 'Conteggio slider';
$string['slidercountdesc'] = 'Seleziona quante diapositive desideri aggiungere <strong>poi clicca su SALVA</strong> per caricare i campi di input.';
$string['sliderdesign'] = 'Design slider';
$string['sliderdesigndesc'] = 'Seleziona il design della diapositiva che desideri aggiungere';
$string['sliderenabled'] = 'Abilita slider';
$string['sliderenableddesc'] = 'Abilita uno slider nella parte superiore della tua pagina iniziale';
$string['sliderimage'] = 'Immagine slider';
$string['sliderimageblock02img'] = 'Immagine blocco {$a->block}';
$string['sliderimageblock04img'] = 'Immagine blocco {$a->block}';
$string['sliderimageblock05img'] = 'Immagine blocco';
$string['sliderimageblock06img'] = 'Immagine blocco';
$string['sliderimageblock10img'] = 'Immagine blocco 10 {$a->block}';
$string['sliderimageblock19img'] = 'Immagine blocco 19 {$a->block}';
$string['sliderimagedesc'] = 'Aggiungi un\'immagine per la tua diapositiva. La dimensione consigliata è di 1500px x 500px o superiore.';
$string['slideropacity'] = 'Opacità slider';
$string['slideropacitydesc'] = 'Opacità del colore della pagina principale verso lo slider';
$string['slidershowheight'] = 'Altezza presentazione';
$string['slidershowheight_desc'] = 'Regola l\'altezza della presentazione sulla pagina principale del sito.';
$string['slidertitle'] = 'Titolo diapositiva';
$string['slidertitledesc'] = 'Aggiungi il titolo della diapositiva.';
$string['slideshow'] = 'Slider';
$string['slideshowend'] = '--Fine--';
$string['slideshowenddesc'] = '';
$string['slideshowheading'] = ': Slider pagina iniziale';
$string['slideshowheadingdesc'] = 'Questo crea una presentazione di fino a sei diapositive per promuovere elementi importanti del tuo sito. La presentazione è reattiva, dove l\'altezza dell\'immagine è impostata in base alle dimensioni dello schermo. Se non viene selezionata alcuna immagine per una diapositiva, verranno utilizzate le immagini predefinite nella cartella pix.';
$string['slideshowstart'] = 'Impostazioni slider pagina iniziale';
$string['slideshowstartdesc'] = '';
$string['theme_almondb_frontpageblock'] = 'Blocco';
$string['theme_almondb_frontpageblockdesc'] = 'Impostazioni dei blocchi HTML della pagina principale';
$string['theme_almondb_frontpageblockend'] = '--Fine--';
$string['theme_almondb_frontpageblockenddesc'] = '';
$string['theme_almondb_frontpageblockheading'] = 'Blocchi della pagina principale';
$string['themesettings'] = 'Impostazioni del tema';
$string['totop'] = 'Torna su';
$string['unaddableblocks'] = 'Blocchi non necessari';
$string['unaddableblocks_desc'] = 'I blocchi specificati non sono necessari quando si utilizza questo tema e non verranno elencati nel menu "Aggiungi un blocco".';
$string['underline'] = '<div style="margin-bottom: 10px; border-bottom:3px solid blue;width:100%;"></div><br>';
