<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'it', version '4.3'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Si è verificato un errore durante il caricamento del blog.';
$string['addon.blog.showonlyyourentries'] = 'Visualizza solo i tuoi inserimenti';
$string['addon.calendar.calendarevent'] = 'Eventi del calendario';
$string['addon.calendar.calendarevents'] = 'Eventi del calendario';
$string['addon.calendar.calendarreminders'] = 'Promemoria del calendario';
$string['addon.calendar.currentmonth'] = 'Mese corrente';
$string['addon.calendar.defaultnotificationtime'] = 'Orario di notifica di default';
$string['addon.calendar.errorloadevent'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['addon.calendar.errorloadevents'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['addon.calendar.noevents'] = 'Non ci sono eventi';
$string['addon.calendar.reminders'] = 'Promemoria';
$string['addon.calendar.setnewreminder'] = 'Imposta un nuovo promemoria';
$string['addon.competency.errornocompetenciesfound'] = 'Non sono state trovate competenze';
$string['addon.competency.nocompetencies'] = 'Non sono presenti competenze';
$string['addon.coursecompletion.complete'] = 'Completato';
$string['addon.coursecompletion.couldnotloadreport'] = 'Non è stato possibile caricare il report di completamento del corso, per favore riprova più tardi.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configura dsipositivi';
$string['addon.messages.contactlistempty'] = 'L\'elenco dei contatti è vuoto';
$string['addon.messages.contactname'] = 'Nome del contatto';
$string['addon.messages.deletemessage'] = 'Elimina messaggio';
$string['addon.messages.deletemessageconfirmation'] = 'Sei sicuro di eliminare il messaggio? Verrà eliminato soltanto dalla tua conversazione, ma sarà ancora visibile dall\'utente che ha ricevuto o inviato il messaggio.';
$string['addon.messages.errordeletemessage'] = 'Si è verificato un errore durante l\'eliminazione del messaggio.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Si è verificato un errore durante la ricezione dei contatti dal server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Si è verificato un errore durante la ricezione delle discussioni dal server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['addon.messages.errorwhileretrievingusers'] = 'Si è verificato un errore durante il caricamento degli utenti dal server.';
$string['addon.messages.messagenotsent'] = 'Il messaggio non è stato inviato, per favore riprova più tardi.';
$string['addon.messages.newmessages'] = 'Nuovi messaggi';
$string['addon.messages.nousersfound'] = 'Non sono stati trovati utenti';
$string['addon.messages.showdeletemessages'] = 'Visualizza messaggi eliminati';
$string['addon.messages.type_blocked'] = 'Bloccato';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Risultati della ricerca';
$string['addon.messages.type_strangers'] = 'Altri';
$string['addon.messages.useentertosenddescdesktop'] = 'Se disabilitato, è possibile utilizzare Ctrl+Invio per inviare il messaggio.';
$string['addon.messages.useentertosenddescmac'] = 'Se disabilitato, è possibile utilizzare Cmd+Invio per inviare il messaggio.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Non è stato possibile aggiungere messaggi alla conversazione {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Non è stato possibile inviare messaggi all\'utente {{user}}. {{error}}';
$string['addon.mod_assign.cannotgradefromapp'] = 'Alcuni metodi di valutazione non sono ancora supportati dall\'app e non possono essere modificati.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Questo feedback non è supportato dalla app e può non contenere tutte le informazioni.';
$string['addon.mod_assign.gradenotsynced'] = 'Valutazione non sincronizzata';
$string['addon.mod_assign.notallparticipantsareshown'] = 'I partecipanti che non hanno consegnato non sono visualizzati.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Ci sono {{count}} bozze.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Ci sono {{count}} partecipanti.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Ci sono {{count}} consegne che richiedono la valutazione.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Ci sono {{count}} compiti consegnati.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Ci sono {{count}} team.';
$string['addon.mod_assign.submissionnotsupported'] = 'Questa consegna non è supportata dalla app e può non contenere tutte le informazioni.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'valutazione utente';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La valutazione dell\'utente è stata modificata sul sito.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'La consegna dell\'utente è stata modificata sul sito.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Si è verificato un errore durante il collegamento alla chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Si è verificato un errore durante la ricezione dei dati della chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Si è verificato un errore durante la ricezione degli utenti della chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Si è verificato un errore durante l\'invio del messaggio.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Per inviare messaggi devi essere online.';
$string['addon.mod_chat.nosessionsfound'] = 'Non è stata trovata nessuna sezione';
$string['addon.mod_chat.showincompletesessions'] = 'Visualizza sessioni non completate';
$string['addon.mod_choice.errorgetchoice'] = 'Si è verificato un errore durante la ricezione di dati della scelta.';
$string['addon.mod_choice.responsesresultgraphdescription'] = 'Il {{number}}% ha scelto l\'opzione {{text}}.';
$string['addon.mod_data.edittagsnotsupported'] = 'L\'app non supporta la modifica di tag';
$string['addon.mod_data.errorapproving'] = 'Si è verificato un errore durante l\'approvazione o disapprovazione del record.';
$string['addon.mod_data.errordeleting'] = 'Si è verificato un errore durante l\'eliminazione del record.';
$string['addon.mod_data.locationpermissiondenied'] = 'L\'accesso alla tua posizione è stato negato.';
$string['addon.mod_data.mylocation'] = 'La mia posizione';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Il feedback è stato salvato e sarà inviato più tardi.';
$string['addon.mod_folder.emptyfilelist'] = 'Non ci sono file da visualizzare.';
$string['addon.mod_forum.errorgetforum'] = 'Si è verificato un errore durante la ricezione dei dati del forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Si è verificato un errore durante la ricezione delle impostazioni gruppo.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Non è stato possibile creare la discussione in tutti i gruppi.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'In questo forum non sono presenti discussioni.';
$string['addon.mod_forum.group'] = 'Gruppo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussioni';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} interventi';
$string['addon.mod_forum.refreshposts'] = 'Aggiorna interventi';
$string['addon.mod_glossary.byauthor'] = 'Raggruppa per autore';
$string['addon.mod_glossary.bycategory'] = 'Raggruppa per categoria';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Aggiornati di recente';
$string['addon.mod_glossary.bysearch'] = 'Cerca';
$string['addon.mod_glossary.cannoteditentry'] = 'Non è possibile modificare la voce';
$string['addon.mod_glossary.entriestobesynced'] = 'Voci da sincronizzare';
$string['addon.mod_glossary.entrypendingapproval'] = 'Questa voce è in attesa di approvazione.';
$string['addon.mod_glossary.errorloadingentries'] = 'Si è verificato un errore durante il caricamento delle voci.';
$string['addon.mod_glossary.errorloadingentry'] = 'Si è verificato un errore durante il caricamento della voce.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Si è verificato un errore durante il caricamento del glossario.';
$string['addon.mod_glossary.noentriesfound'] = 'Non sono state trovate voci.';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Scarica file H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Si è verificato un errore durante lo scaricamento dei dati dell\'attività H5P';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Il pacchetto H5P non è stato scaricato. Per utilizzarlo è necessario scaricarlo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Il pacchetto H5P è stato modificato dopo l\'ultimo scaricamento. Per utilizzarlo è necessario scaricarlo nuovamente.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'E\' necessario essere online per visualizzare il pacchetto H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Visualizza tentativo {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Visualizza descrizione';
$string['addon.mod_lesson.finishretakeoffline'] = 'Il tentativo è stato completato offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'E\' stato sincronizzato un tentativo offline. Desideri rivederlo?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Il tentativo è stato completato sul sito.';
$string['addon.mod_lti.errorgetlti'] = 'Si è verificato un errore durante la ricezione dei dati del modulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'l\'URL di lancio non è valida.';
$string['addon.mod_lti.launchactivity'] = 'Lancia l\'attività';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Si è verificato un errore durante il caricamento della pagina.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Si è verificato un errore durante il salvataggio delle domande. Sei sicuro di abbandonare il quiz?';
$string['addon.mod_quiz.errordownloading'] = 'Si è verificato un errore durante lo scaricamento dei dati.';
$string['addon.mod_quiz.errorgetattempt'] = 'Si è verificato un errore durante la ricezione dei dati del tentativo.';
$string['addon.mod_quiz.errorgetquestions'] = 'Si è verificato un errore durante la ricezione delle domande.';
$string['addon.mod_quiz.errorgetquiz'] = 'Si è verificato un errore durante la ricezione dei dati del quiz.';
$string['addon.mod_quiz.errorparsequestions'] = 'Si è verificato un errore durante la lettura delle domande. Per favore svolgi il quiz usando un browser.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Questo quiz non può essere svolto nell\'app poiché contiene domande che non sono supportate nell\'app.';
$string['addon.mod_quiz.errorsaveattempt'] = 'Si è verificato un errore durante il salvataggio del tentativo.';
$string['addon.mod_quiz.finishnotsynced'] = 'Completato ma non sincronizzato.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Il quiz contiene domande non supportare dall\'app:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Si è verificato un errore durante il caricamento del contenuto.';
$string['addon.mod_resource.openthefile'] = 'Apri';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Non è stato possibile calcolare le valutazioni.';
$string['addon.mod_scorm.dataattemptshown'] = 'Questi dati appartengono al tentativo numero {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Si è verificato un errore durante la creazione di un tentativo offline. Per favore riprova.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Si è verificato un errore durante lo scaricamento dello SCORM "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Si è verificato un errore durante la ricezione dei dati SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Spiacente, l\'applicazione supporta solamente SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Lo scaricamento di pacchetti SCORM è disabilitato. Per favore contatta l\'amministratore del sito.';
$string['addon.mod_scorm.errornovalidsco'] = 'Questo SCORM non ha SCO visibili da caricare.';
$string['addon.mod_scorm.errorpackagefile'] = 'Spiacente, l\'applicazione supporta solamente pacchetti ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Si è verificato un errore durante la sincronizzazione. Per favore riprova.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Questo tentativo ha dati non sincronizzati.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Questo tentativo non può essere inviato perché hai superato il numero massimo di tentativi.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Questo SCORM non è stato scaricato, lo sarà non appena lo aprirai.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Questo SCORM è stato modificato dall\'ultimo scaricamento e sarà scaricato nuovamente non appena lo aprirai.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alcuni dati offline del tentativo {{number}} sono stati eliminati perché non è stato possibile inserirli in un nuovo tentativo.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Alcuni tentativi non sono stati sincronizzati sul sito poiché è presente un tentativo svolto online che non è stato terminato. Per sincronizzare, devi prima terminare il tentativo online.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Si è verificato un errore durante l\'invio del sondaggio. Per favore riprova.';
$string['addon.mod_survey.errorgetsurvey'] = 'Si è verificato un errore durante la ricezione di dati del sondaggio.';
$string['addon.mod_survey.results'] = 'Risultati';
$string['addon.mod_url.accessurl'] = 'Accedi all\'URL';
$string['addon.mod_url.pointingtourl'] = 'URL dove punta la risorsa.';
$string['addon.mod_wiki.errorloadingpage'] = 'Si è verificato un errore durante il caricamento della pagina.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Il wiki non ha contenuti.';
$string['addon.mod_wiki.gowikihome'] = 'Vai alla prima pagina del wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Il titolo non può essere vuoto';
$string['addon.mod_wiki.viewpage'] = 'Visualizza pagina';
$string['addon.mod_wiki.wikipage'] = 'Pagina wiki';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Devi inserire un titolo.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'La consegna è stata modificata sul sito.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'La valutazione è stata modificata sul sito.';
$string['addon.notes.warningnotenotsent'] = 'Non è stato possibile aggiungere note al corso {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Si è verificato un errore durante la ricezione delle notifiche.';
$string['addon.notifications.notifications'] = 'Notifiche';
$string['addon.notifications.playsound'] = 'Riproduci suono';
$string['addon.notifications.therearentnotificationsyet'] = 'Non ci sono notifiche.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Eliminare tutti i dati scaricati dal sito?';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Saranno eliminati tutti i dati scaricati da \'{{name}}\', compresi i corsi scaricati e le risorse che ti permettono di lavorare offline';
$string['appstoredescription'] = 'NOTA: l\'applicazione ufficiale Moodle Mobile funziona solamente con siti Moodle abilitati appositamente. In caso diproblemi di collegamento, contattare l\'amministratore del sito.

L\'app consente di:

- navigare nel contenuto del corso, anche oflfine
- ricevere notifiche istantanee di messaggi e di eventi
- trovare rapidamente e contattare altri partecipanti
- caricare dal dispositivo mobile immagini, audio, video e altri tipi di file
- visualizzare le valutazioni del corso
- molto altro ancora!

Per ulteriori informazioni: http://docs.moodle.org/en/Mobile_app

Saremo lieti di conoscere le tue impressioni sulle funzionalità disponibili e ricevere suggerimenti sulle funzionalità da implementare nella app.

L\'app ha bisogno delle seguenti autorizzazioni:
Registrare audio - Per registrare file audio da caricare su Moodle
Leggere è modificare il contenuto della memoria SD - Per scaricare i contenuti sulla memoria SD e visualizzarli offline
Accesso alla rete - Per collegarsi al sito Moodle, verificare lo stato del collegamento e impostare la modalità offline
Essere lanciata all\'avvio - Per ricevere le notifiche con l\'app in background
Evitare lo standby del telefono - Per ricever notifiche push in qualsiasi momento';
$string['core.browser'] = 'Browser';
$string['core.cannotconnect'] = 'Non è stato possibile effettuare il collegamento';
$string['core.cannotdownloadfiles'] = 'Lo scaricamento di file è disabilitato. Per favore contatta l\'amministratore del sito.';
$string['core.captureaudio'] = 'Registra audio';
$string['core.capturedimage'] = 'Foto scattata.';
$string['core.captureimage'] = 'Scatta foto';
$string['core.capturevideo'] = 'Registra video';
$string['core.clearsearch'] = 'Pulisci la ricerca';
$string['core.clicktoseefull'] = 'Click per visualizzare il contenuto completo.';
$string['core.comments.warningcommentsnotsent'] = 'Non è stato possibile sincronizzare i commenti. {{error}}';
$string['core.confirmcanceledit'] = 'Sei sicuro di abbandonare questa pagina? Tutte le modifiche saranno perdute.';
$string['core.confirmloss'] = 'Sei sicuro? Le modifiche andranno perdute.';
$string['core.confirmopeninbrowser'] = 'Desideri aprirlo nel browser?';
$string['core.contenteditingsynced'] = 'Il contenuto in fase di modifica è stato sincronizzato.';
$string['core.contentlinks.chooseaccount'] = 'Seleziona account';
$string['core.copiedtoclipboard'] = 'Testo copiato nella clipboard';
$string['core.copytoclipboard'] = 'Copia nella clipboard';
$string['core.course.activitynotyetviewableremoteaddon'] = 'La risorsa alla quale si sta accedendo non è supportata per l\'accesso mobile, accedi cliccando su Apri nel Browser.';
$string['core.course.allsections'] = 'Tutte le sezioni';
$string['core.course.confirmdownload'] = 'Stai per scaricare {{size}}.{{availableSpace}} Vuoi continuare?';
$string['core.course.confirmdownloadunknownsize'] = 'Non è stato possibile calcolare la dimensione del download.{{availableSpace}} Vuoi continuare?';
$string['core.course.confirmdownloadzerosize'] = 'Stai per iniziare il download. {{availableSpace}} Sei sicuro di voler continuare?';
$string['core.course.confirmlimiteddownload'] = 'Non sei collagato al Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Stai per scaricare <strong>almeno</strong> {{size}}.{{availableSpace}} Vuoi continuare?';
$string['core.course.couldnotloadsectioncontent'] = 'Non è stato possibile caricare il contenuto della sezione, per favore riprova più tardi.';
$string['core.course.couldnotloadsections'] = 'Non è stato possibile caricare le sezioni, per favore riprova più tardi.';
$string['core.course.errordownloadingcourse'] = 'Si è verificato un errore durante lo scaricamento del corso.';
$string['core.course.errordownloadingsection'] = 'Si è verificato un errore durante lo scaricamento della sezione.';
$string['core.course.errorgetmodule'] = 'Si è verificato un errore durante la ricezione dei dati dell\'attività.';
$string['core.course.nocontentavailable'] = 'Non sono presenti contenuti.';
$string['core.courses.confirmselfenrol'] = 'Desideri iscriverti al corso?';
$string['core.courses.downloadcourses'] = 'Scarica corsi';
$string['core.courses.enrolme'] = 'Iscrivimi';
$string['core.courses.errorloadcategories'] = 'Si è verificato un errore durante il caricamento delle categorie.';
$string['core.courses.errorloadcourses'] = 'Si è verificato un errore durante il caricamento dei corsi.';
$string['core.courses.errorsearching'] = 'Si è verificato un errore durante la ricerca.';
$string['core.courses.errorselfenrol'] = 'Si è verificato un errore mentre ti stavi iscrivendo.';
$string['core.courses.filtermycourses'] = 'Filtra i miei corsi';
$string['core.courses.notenrollable'] = 'Non puoi iscriverti al corso.';
$string['core.courses.password'] = 'Chiave di iscrizione';
$string['core.courses.searchcoursesadvice'] = 'Puoi utilizzare la ricerca corsi per accedere come ospite oppure iscriverti nei corsi che lo consentono.';
$string['core.courses.selfenrolment'] = 'Iscrizione spontanea';
$string['core.courses.totalcoursesearchresults'] = 'Totale corsi: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo attuale';
$string['core.deletedoffline'] = 'Eliminato offline';
$string['core.deleting'] = 'Eliminazione in corso';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.downloaded'] = 'Scaricato';
$string['core.downloading'] = 'Scaricamento in corso';
$string['core.errorchangecompletion'] = 'Si è verificato un errore durante la modifica dello stato di completamento. Per favore riprova.';
$string['core.errordeletefile'] = 'Si è verificato un errore durante l\'eliminazione del file. Per favore riprova.';
$string['core.errordownloading'] = 'Si è verificato un errore durante lo scaricamento del file.';
$string['core.errordownloadingsomefiles'] = 'Si è verificato un errore durante lo scaricamento dei file. E\' possibile che manchino alcuni file.';
$string['core.errorfileexistssamename'] = 'Un file con lo stesso nome è già presente.';
$string['core.errorinvalidresponse'] = 'E\' stata ricevuta una risposta non valida. Se l\'errore persiste, contatta l\'amministratore del sito.';
$string['core.errorloadingcontent'] = 'Si è verificato un errore durante il caricamento del contenuto.';
$string['core.erroropenfilenoapp'] = 'Si è verificato un errore durante l\'apertura del file: non sono disponibili app per aprire questo tipo di file.';
$string['core.erroropenfilenoextension'] = 'Si è verificato un errore durante l\'apertura del file: il file non ha un\'estensione.';
$string['core.erroropenpopup'] = 'L\'attività tenta di aprirsi in una finestra popup. Le popup non sono supportate nella app.';
$string['core.errorrenamefile'] = 'Si è verificato un errore durante la modifica del nome del file. Per favore riprova.';
$string['core.errorsync'] = 'Si è verificato un errore durante la sincronizzazione. Per favore riprova.';
$string['core.filenameexist'] = 'Un file con lo stesso non è già presente: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'Stai per caricare {{size}}. Sei sicuro di continuare?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Non è stato possibile calcolare la dimensione del caricamento. Vuoi continuare?';
$string['core.fileuploader.errorcapturingaudio'] = 'Si è verificato un errore durante la registrazione dell\'audio';
$string['core.fileuploader.errorcapturingimage'] = 'Si è verificato un errore durante l\'acquisizione dell\'immagine.';
$string['core.fileuploader.errorcapturingvideo'] = 'Si è verificato un errore durante l\'acquisizione del video';
$string['core.fileuploader.errorgettingimagealbum'] = 'Si è verificato un errore durante la ricezione dell\'immagine dall\'album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Devi essere online per caricare file.';
$string['core.fileuploader.errornoapp'] = 'Non hai un\'app per svolgere questa azione.';
$string['core.fileuploader.errorreadingfile'] = 'Si è verificato un errore durante la lettura del file.';
$string['core.fileuploader.errorwhileuploading'] = 'Si è verificato un errore durante il caricamento del file.';
$string['core.fileuploader.file'] = 'File';
$string['core.fileuploader.fileuploaded'] = 'File caricato correttamente';
$string['core.fileuploader.maxbytesfile'] = 'Il file {{$a.file}} è troppo grande. La dimensione massima consentita è {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Album fotografico';
$string['core.fileuploader.readingfile'] = 'Letture file in corso';
$string['core.fileuploader.readingfileperc'] = 'Lettura file: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Seleziona un file';
$string['core.fileuploader.uploadafile'] = 'Carica un file';
$string['core.fileuploader.uploading'] = 'Caricamento in corso';
$string['core.fileuploader.uploadingperc'] = 'Caricamento: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.play'] = 'Esegui H5P';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Immagine';
$string['core.imageviewer'] = 'Visualizzatore di immagini';
$string['core.lastsync'] = 'Ultima sincronizzazione';
$string['core.login.authenticating'] = 'Autenticazione in corso';
$string['core.login.confirmdeletesite'] = 'Sei sicuro di eliminare il sito {{sitename}}?';
$string['core.login.connect'] = 'Collegati!';
$string['core.login.connecttomoodle'] = 'Collegati a Moodle';
$string['core.login.credentialsdescription'] = 'Per favore inserisci username e password per l\'autenticazione';
$string['core.login.erroraccesscontrolalloworigin'] = 'La chiamata cross-origin che stai effettuando è stata rifiutata. Per ulteriori informazioni: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Si è verificato un errore durante l\'eliminazione di questo sito. Per favore riprova.';
$string['core.login.errorupdatesite'] = 'Si è verificato un errore durante l\'aggiornamento del token del sito.';
$string['core.login.findyoursite'] = 'Trova il tuo sito';
$string['core.login.invalidaccount'] = 'Verificare le proprie credenziali o chiedere all\'amministratore del sito di controllare la configurazione del sito.';
$string['core.login.invalidmoodleversion'] = 'La versione di Moodle non è valida. La versione minima richiesta è la {{$a}} o versioni successive.';
$string['core.login.invalidsite'] = 'L\'URL del sito non è valida';
$string['core.login.invalidtime'] = 'Orario non valido';
$string['core.login.invalidvaluemax'] = 'Il valore massimo è {{$a}}';
$string['core.login.invalidvaluemin'] = 'Il valore minimo è {{$a}}';
$string['core.login.loginbutton'] = 'Login';
$string['core.login.logininsiterequired'] = 'Devi autenticarti usando una finestra browser';
$string['core.login.mobileservicesnotenabled'] = 'I servizi mobile non sono abilitati nel sito. Per richiederne l\'abilitazione, contattare l\'amministrazione del sito.';
$string['core.login.notloggedin'] = 'Devi essere autenticato';
$string['core.login.onboardingcreatemanagecourses'] = 'Crea e gestisci i tuoi corsi';
$string['core.login.onboardingenrolmanagestudents'] = 'Crea e gestisci i tuoi studenti';
$string['core.login.onboardinggetstarted'] = 'Primi passi con Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ho già un sito Moodle';
$string['core.login.onboardingimalearner'] = 'Sono uno studente';
$string['core.login.onboardingimaneducator'] = 'Sono un formatore';
$string['core.login.onboardingineedasite'] = 'Mi serve un sito Moodle';
$string['core.login.onboardingwelcome'] = 'Benvenuto nell\'App Moodle!';
$string['core.login.or'] = 'Oppure';
$string['core.login.passwordrequired'] = 'Password necessaria';
$string['core.login.reconnect'] = 'Riconnetti';
$string['core.login.reconnectssodescription'] = 'Il token di autenticazione non è valido oppure è scaduto. Devi ricollegarti al sito autenticandoti tramite il browser.';
$string['core.login.selectsite'] = 'Seleziona il sito:';
$string['core.login.signupplugindisabled'] = '{{$a}} non è abilitato.';
$string['core.login.siteaddress'] = 'Indirizzo del sito';
$string['core.login.siteinmaintenance'] = 'Il sito è in modalità manutenzione';
$string['core.login.sitepolicynotagreederror'] = 'Politiche del sito non accettate.';
$string['core.login.siteurl'] = 'URL del sito';
$string['core.login.siteurlrequired'] = 'L\'URL del sito è obbligatoria. Esempio:<i>http://www.yourmoodlesite.abc or https://www.yourmoodlesite.efg</i>';
$string['core.login.usernamerequired'] = 'Username obbligatorio';
$string['core.login.webservicesnotenabled'] = 'Nel sito non sono stati abilitati i web service. Per favore contatta l\'amministratore del sito per verificare la configurazione.';
$string['core.login.yourenteredsite'] = 'Collegati al sito';
$string['core.lostconnection'] = 'Il token di autenticazione non è valido o è scaduto. Devi autenticarti nuovamente.';
$string['core.needhelp'] = 'Serve aiuto?';
$string['core.networkerrormsg'] = 'La rete non è abilitata o non funziona.';
$string['core.notapplicable'] = 'n/d';
$string['core.notsent'] = 'Non inviato';
$string['core.openfile'] = 'Apri file';
$string['core.openfullimage'] = 'Click per visualizare l\'immagine a dimensioni reali';
$string['core.openinbrowser'] = 'Apri nel browser';
$string['core.opensecurityquestion'] = 'Apri domanda di sicurezza';
$string['core.opensettings'] = 'Apri impostazioni';
$string['core.openwith'] = 'Apri con...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Riproduci';
$string['core.pulltorefresh'] = 'Trascina per aggiornare';
$string['core.qrscanner'] = 'Scanner QR';
$string['core.question.cannotdeterminestatus'] = 'Non è possibile determinare lo stato';
$string['core.question.questionmessage'] = 'Domanda {{$a}}: {{$b}}';
$string['core.requireduserdatamissing'] = 'Nel profilo di questo utente mancano alcuni dati. Per favore compila i dati mancanti e riprova.<br>{{$a}}';
$string['core.retry'] = 'Riprova';
$string['core.scanqr'] = 'Scansiona codice QR';
$string['core.searching'] = 'Ricerca in corso';
$string['core.settings.about'] = 'Informazioni';
$string['core.settings.appsettings'] = 'Impostazioni App';
$string['core.settings.appversion'] = 'Versione App';
$string['core.settings.cannotsyncwithoutwifi'] = 'Il dispositivo non è connesso al Wi-Fi. Collegarsi ad una rete Wi-Fi o disabilitare Risparmio dati nelle impostazione dell\'app.';
$string['core.settings.colorscheme'] = 'Schema colori';
$string['core.settings.colorscheme-dark'] = 'Scuro';
$string['core.settings.colorscheme-light'] = 'Chiaro';
$string['core.settings.colorscheme-system'] = 'Default di sistema';
$string['core.settings.connectwifitosync'] = 'Collegarsi ad un Wi-Fi o disabilitare Risparmio dati per sincronizzare i siti';
$string['core.settings.copyinfo'] = 'Copia informazioni sul dispositivo nella clipboard';
$string['core.settings.cordovadevicemodel'] = 'Modello del dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versione SO del dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Piattaforma del dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID del dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versione Cordova';
$string['core.settings.debugdisplaydescription'] = 'Se abilitato, saranno visualizzate più informazioni relative agli errori';
$string['core.settings.deviceinfo'] = 'Informazioni sul dispositivo';
$string['core.settings.deviceos'] = 'SO del dispositivo';
$string['core.settings.displayformat'] = 'Formato di visualizzazione';
$string['core.settings.enabledownloadsection'] = 'Abilita scaricamento sezioni';
$string['core.settings.enablefirebaseanalytics'] = 'Abilita analitica Firebase';
$string['core.settings.enablerichtexteditor'] = 'Abilita editor di testo';
$string['core.settings.enablerichtexteditordescription'] = 'Se abilitato, sarà possibile utilizzare un editor di testo per inserire contenuti';
$string['core.settings.enablesyncwifi'] = 'Sincronizza solo tramite Wi-Fi';
$string['core.settings.errorsyncsite'] = 'Si è verificato un errore durante la sincronizzazione dei dati dal sito. Per favore verifica la connessione internet e riprova.';
$string['core.settings.estimatedfreespace'] = 'Spazio libero stimato';
$string['core.settings.filesystemroot'] = 'Root del filesystem';
$string['core.settings.fontsize'] = 'Dimensione testo';
$string['core.settings.localnotifavailable'] = 'Notifiche locali disponibili';
$string['core.settings.locationhref'] = 'URL Webview';
$string['core.settings.navigatorlanguage'] = 'Navigator language';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Stato della connessione internet';
$string['core.settings.privacypolicy'] = 'Privacy policy';
$string['core.settings.reportinbackground'] = 'Invia errori automaticamente';
$string['core.settings.spaceusage'] = 'Spazio utilizzato';
$string['core.settings.syncdatasaver'] = 'Risparmio dati: sincronizza solo su Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronizzazione';
$string['core.settings.synchronizenow'] = 'Sincronizza adesso';
$string['core.settings.synchronizenowhelp'] = 'Tutte le modifiche effettuate offline, compresi messaggi e notifiche, saranno sincronizzate quando il dispositivo è connesso';
$string['core.settings.syncsettings'] = 'Impostazioni di sincronizzazione';
$string['core.settings.wificonnection'] = 'Connessione WiFi';
$string['core.sharedfiles.rename'] = 'Rinomna';
$string['core.sharedfiles.replace'] = 'Sostituisci';
$string['core.sharedfiles.sharedfiles'] = 'File condivisi';
$string['core.sizetb'] = 'TB';
$string['core.tablet'] = 'Tablet';
$string['core.tryagain'] = 'Riprova';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Nota';
$string['core.unexpectederror'] = 'Si è verificato un errore inatteso. Riprova chiudendo e riaprendo l\'applicazione.';
$string['core.unknown'] = 'Sconosciuto';
$string['core.unzipping'] = 'Decompressione in corso';
$string['core.user.contact'] = 'Contatto';
$string['core.user.detailsnotavailable'] = 'Non puoi visualizzare i dettagli di questo utente.';
$string['core.user.sendemail'] = 'Email';
$string['core.viewcode'] = 'Visualizza codice';
$string['core.vieweditor'] = 'Visualizza editor';
$string['core.viewembeddedcontent'] = 'Visualizza contenuto incorporato';
$string['core.wsfunctionnotavailable'] = 'La funzione webservice non è disponibile.';
$string['core.youreoffline'] = 'Sei offline';
$string['core.youreonline'] = 'Sei di nuovo online';
$string['freemium.notallowed'] = 'Non consentito';
$string['freemium.qrlogindisabled'] = 'L\'autenticazione con codice QR non è abilitata su questo sito: <br><br>{{url}}';
$string['pluginname'] = 'Stringhe di lingua Moodle Mobile';
