<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_messageinbound', language 'da', version '4.3'.
 *
 * @package     tool_messageinbound
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['classname'] = 'Klassenavn';
$string['component'] = 'Komponent';
$string['configmessageinboundhost'] = 'Adresse på den server Moodle skal tjekke mail på. Vil du bruge en speciel port, kan du skrive [server]:[port], for eksempel mail.eksempel.dk:993. Lader du feltet stå tomt, vil servertypens standardport blive brugt.';
$string['defaultexpiration'] = 'Standardadresses udløbsperiode';
$string['defaultexpiration_help'] = 'Når en e-mailadresse er oprettet, kan den indstilles til automatisk at udløbe efter en periode. Det anbefales at sætte en udløbstid.';
$string['description'] = 'Beskrivelse';
$string['domain'] = 'E-maildomæne';
$string['edit'] = 'Rediger';
$string['edithandler'] = 'Rediger indstillingerne for {$a}-håndteringen.';
$string['editinghandler'] = 'Redigering {$a}';
$string['enabled'] = 'Aktiveret';
$string['fixedenabled_help'] = 'Du kan ikke ændre håndteringsassistentens tilstand. Det kan være på grund af at den kræves af andre assistenter.';
$string['fixedvalidateaddress'] = 'Validder afsenderadresse';
$string['fixedvalidateaddress_help'] = 'Du kan ikke ændre adressevalideringen for denne håndteringsassistent. Det kan være fordi assistenten kræver en særlig indstilling.';
$string['handlerdisabled'] = 'Den e-mailassistent du prøvede at kontakte, er blevet deaktiveret. Kan ikke behandle beskeden nu.';
$string['incomingmailconfiguration'] = 'Konfiguration af indkommende mail';
$string['incomingmailserversettings'] = 'Indstillinger for indkommende mailserver';
$string['incomingmailserversettings_desc'] = 'Moodle kan forbinde til IMAP-servere. Du kan specificere indstillingerne til din IMAP-server her.';
$string['invalid_recipient_handler'] = 'Hvis en gyldig besked modtages på mail, men afsenderen ikke godkendes, gemmes mailen på mailserveren og brugeren kontaktes via mailadressen i brugerprofilen. Brugeren får dermed en chance for at bekræfte autenticiteten af den originale besked.

Denne assistent håndterer disse svar.

Det er ikke muligt at deaktivere verificering af afsender for denne håndteringsassistent, da brugeren kunne svare fra en forkert mailadresse hvis hendes mailklient ikke er konfigureret korrekt.';
$string['invalid_recipient_handler_name'] = 'Ugyldig afsenderassistent';
$string['invalidrecipientdescription'] = 'Beskeden "{$a->subject}" blev ikke godkendt da den blev sendt fra en anden mailadresse end den i din brugerprofil. For at beskeden kan godkendes, skal du besvare denne besked.';
$string['invalidrecipientdescriptionhtml'] = 'Beskeden "{$a->subject}" blev ikke godkendt da den blev sendt fra en anden mailadresse end den i din brugerprofil. For at beskeden kan godkendes, skal du besvare denne besked.';
$string['invalidrecipientfinal'] = 'Beskeden "{$a->subject}" blev ikke godkendt. Tjek at du sendte den fra samme mailadresse som den i din brugerprofil.';
$string['mailbox'] = 'Mailboksnavn';
$string['mailboxconfiguration'] = 'Mailbokskonfiguration';
$string['mailboxdescription'] = '[mailboks]+subadresse@[domain]';
$string['mailsettings'] = 'Mailindstillinger';
$string['message_handlers'] = 'Mailhåndtering';
$string['messageinbound'] = 'Indkommende mails';
$string['messageinboundenabled'] = 'Aktiver behandling af indkommende mails';
$string['messageinboundenabled_desc'] = 'Behandling af indkommende mails skal være aktiveret for at beskeder kan sendes med de rigtige informationer.';
$string['messageinboundgeneralconfiguration'] = 'Generel konfiguration';
$string['messageinboundgeneralconfiguration_desc'] = 'Med funktionen til håndtering af indkommende beskeder kan du modtage og behandle mails i Moodle. Det betyder at man via e-mail kan svare på forumindlæg eller tilføje filer til brugeres private filer.';
$string['messageinboundhost'] = 'Indkommende mailserver';
$string['messageinboundhostpass'] = 'Adgangskode';
$string['messageinboundhostpass_desc'] = 'Dette er adgangskoden til login til din mailadresse.';
$string['messageinboundhostssl'] = 'Brug SSL';
$string['messageinboundhostssl_desc'] = 'Nogle mailservere understøtter et ekstra sikkerhedslag ved at kryptere kommunikation mellem Moodle og din server. Vi anbefaler at bruge SSL-kryptering hvis din server understøtter det.';
$string['messageinboundhosttype'] = 'Servertype';
$string['messageinboundhostuser'] = 'Brugernavn';
$string['messageinboundhostuser_desc'] = 'Dette er brugernavnet til login til din mailadresse.';
$string['messageinboundmailboxconfiguration_desc'] = 'Når mails sendes ud bruges formatet adresse+data@eksempel.dk. For at generere pålidelige adresser i Moodle skal du specificere den adresse du almindeligvis bruger før @-tegnet og domænet efter @-tegnet separat. For eksempel vil mailboksens navn i eksemplet være "adresse" og mail-domænet "eksempel.dk". Du bør bruge en dedikeret mailkonto til dette formål.';
$string['messageprocessingerror'] = 'Du har for nylig sendt en mail med emnet "{$a->subject}", men desværre kunne den ikke blive behandlet.

Fejloplysningerne vises herunder

{$a->error}';
$string['messageprocessingerrorhtml'] = '<p>Du har for nylig sendt en mail med emnet "{$a->subject}", men desværre kunne den ikke blive behandlet.</p> <p>Fejlbeskeden vises herunder.</p> <p>{$a->error}</p>';
$string['messageprocessingfailed'] = 'Mailen "{$a->subject}" kunne ikke behandles. Fejlen er følgende: "{$a->message}".';
$string['messageprocessingfailedunknown'] = 'Mailen "{$a->subject}" kunne ikke behandles. Kontakt din administrator.';
$string['messageprocessingsuccess'] = '{$a->plain} Hvis ikke du vil modtage disse underretninger fremover, kan du redigere dine personlige indstillinger for beskeder ved at åbne {$a->messagepreferencesurl} i din browser.';
$string['messageprocessingsuccesshtml'] = '{$a->plain} Hvis ikke du vil modtage disse underretninger fremover, kan du <a href="{$a->messagepreferencesurl}">redigere dine personlige indstillinger for beskeder</a>.</p>';
$string['messageprovider:invalidrecipienthandler'] = 'Besked med bekræftelse af at en indkommende besked er fra dig';
$string['messageprovider:messageprocessingerror'] = 'Advarsel når en indkommende besked ikke kan ekspederes';
$string['messageprovider:messageprocessingsuccess'] = 'Bekræftelse på at en besked er ekspederet';
$string['name'] = 'Navn';
$string['noencryption'] = 'Off - Ingen kryptering';
$string['noexpiry'] = 'Ingen udløb';
$string['oldmessagenotfound'] = 'Du har forsøgt manuelt at godkende en meddelelse, men den blev ikke fundet. Det kan være fordi den allerede er behandlet, eller fordi den er udløbet.';
$string['oneday'] = 'En dag';
$string['onehour'] = 'En time';
$string['oneweek'] = 'En uge';
$string['oneyear'] = 'Et år';
$string['pluginname'] = 'Konfiguration af indkommende beskeder';
$string['replysubjectprefix'] = 'Re:';
$string['requirevalidation'] = 'Valider afsenderadresse';
$string['ssl'] = 'SSL (Auto-detekter SSL-version)';
$string['sslv2'] = 'SSLv2 (Gennemtving SSL Version 2)';
$string['sslv3'] = 'SSLv3 (Gennemtving SSL Version 3)';
$string['taskcleanup'] = 'Ryd ikke-verificerede indkomne mails';
$string['taskpickup'] = 'Opsamling af indkommende mail';
$string['tls'] = 'TLS (TLS; startet via forhandling på protokolniveau over ukrypteret kanal; ANBEFALET måde at starte sikker forbindelse på)';
$string['tlsv1'] = 'TLSv1 (direkte forbindelse til TLS-server version 1.x)';
$string['validateaddress'] = 'Valider afsenders mailadresse';
$string['validateaddress_help'] = 'Når en meddelelse er modtaget fra en bruger, vil Moodle forsøge at validere den ved at sammenligne mailadressen i brugerprofilen.

Hvis ikke afsenderen matcher, vil brugeren modtage en underretning om at bekræfte at hun faktisk har sendt e-mailen.

Er indstillingen deaktiveret, vil afsenderens mailadresse ikke blive tjekket.';
