<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'da', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har kommende BigBlueButton-sessioner';
$string['bbbduetimeoverstartingtime'] = 'Sluttidspunktet skal være senere end starttidspunktet';
$string['bbbdurationwarning'] = 'Sessionen må maksimalt vare %duration% minutter';
$string['bbbrecordwarning'] = 'Denne session bliver muligvis optaget';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Tilføj et nyt BigBlueButton-rum';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Opret forekomst til livesessioner';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Opret en forekomst med optagelser';
$string['bigbluebuttonbn:deleterecordings'] = 'Slet optagelser';
$string['bigbluebuttonbn:importrecordings'] = 'Importer optagelser';
$string['bigbluebuttonbn:join'] = 'Deltag i en BigBlueButton-session';
$string['bigbluebuttonbn:managerecordings'] = 'Administrer BigBlueButton-optagelser';
$string['bigbluebuttonbn:protectrecordings'] = 'Beskyt optagelser';
$string['bigbluebuttonbn:publishrecordings'] = 'Udgiv optagelser';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Stop beskyttelse af optagelser';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Stop udgivelse af optagelser';
$string['config_extended_capabilities'] = 'Udvidede beføjelser';
$string['config_extended_capabilities_description'] = 'Konfigurationsmuligheder for udvidede beføjelser hvis de er tilbudt af BigBlueButtonserveren';
$string['config_importrecordings'] = 'Importer optagelser';
$string['config_importrecordings_description'] = 'Disse indstillinger er funktionsspecifikke.';
$string['config_importrecordings_enabled'] = 'Import af optagelser er aktiveret';
$string['config_importrecordings_enabled_description'] = 'Når denne og optagelsesfunktionen er aktiveret, er det muligt at importere optagelser fra forskellige kurser til en aktivitet.';
$string['config_importrecordings_from_deleted_enabled'] = 'Import af optagelser fra slettede aktiviteter er aktiveret';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Når denne og funktionen Import af optagelser er aktiveret, er det muligt at importere optagelser fra aktiviteter, der ikke længere er på kurset.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_recordings'] = 'Vis optagelser';
$string['config_recordings_deleted_default'] = 'Medtag optagelser fra slettede aktiviteter er aktiveret som standard';
$string['config_recordings_deleted_default_description'] = 'Er det aktiveret, vil optegnelsen indeholde optagelser af aktiviteter, som siden er blevet slettet.';
$string['config_recordings_deleted_editable'] = 'Funktionen medtag optagelser fra slettede aktiviteter kan redigeres';
$string['config_recordings_deleted_editable_description'] = 'Inkluder optagelser fra slettede aktiviteter kan som standard redigeres, når forekomsten er tilføjet eller opdateret.';
$string['config_recordings_description'] = 'Disse indstillinger er funktionsspecifikke';
$string['config_recordings_general'] = 'Vis optagelsesindstillinger';
$string['config_recordings_general_description'] = 'Disse indstillinger bruges kun, når optagelser vises';
$string['config_server_url_description'] = 'Standardoplysningerne er til en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-tjeneste til Moodle (åbner i et nyt vindue)</a>, som leveres af Blindside Networks med følgende begrænsninger:
<ol>
<li>En session kan højst vare i 60 minutter</li>
<li>Det højeste antal samtidige brugere pr. session er 25</li>
<li>Optagelser udløber efter syv (7) dage og kan ikke downloades</li>
<li>De studerendes webkameraer er kun synlige for moderatoren.</li>
</ol>';
$string['config_waitformoderator'] = 'Vent på moderator';
$string['config_waitformoderator_cache_ttl'] = 'Vent på moderator-cache TTL (sekunder)';
$string['config_waitformoderator_default'] = 'Vent på moderator er som standard aktiveret';
$string['config_waitformoderator_default_description'] = 'Skal indstillingen "Vent på moderator" være aktiveret som standard, når der tilføjes et nyt BigBlueButton-rum?';
$string['config_waitformoderator_editable'] = 'Vent på moderator kan redigeres';
$string['config_waitformoderator_editable_description'] = 'Skal "Vent på moderator" kunne redigeres i BigBlueButton-indstillingerne?';
$string['config_waitformoderator_ping_interval'] = 'Vent på moderator-ping (sekunder)';
$string['config_waitformoderator_ping_interval_description'] = 'Hvor ofte skal serveren pinges for at kontrollere, om moderatoren er kommet ind i rummet?';
$string['config_welcome_default'] = 'Standard velkomstmeddelelse';
$string['config_welcome_default_description'] = 'Velkomstbeskeden vises, når deltagerne træder ind i rummet. Hvis feltet er tomt, vises en besked, der er indstillet på BigBlueButton-serveren.';
$string['config_welcome_editable'] = 'Standard velkomstmeddelelse kan redigeres af lærere';
$string['config_welcome_editable_description'] = 'Velkomstbeskeden kan redigeres, når forekomsten er tilføjet eller opdateret';
$string['end_session_confirm'] = 'Er du sikker på du vil slutte denne session';
$string['end_session_confirm_title'] = 'Vil du virkelig slutte sessionen?';
$string['ends_at'] = 'Slutter';
$string['event_activity_created'] = 'Aktivitet oprettet';
$string['event_activity_deleted'] = 'Aktivitet slettet';
$string['event_meeting_created'] = 'Møde oprettet';
$string['event_meeting_ended'] = 'Mødet blev lukket';
$string['event_meeting_joined'] = 'Deltaget i møde';
$string['event_meeting_left'] = 'Møde forladt';
$string['event_recording_deleted'] = 'Optagelse slettet';
$string['event_recording_imported'] = 'Optagelse importeret';
$string['event_recording_published'] = 'Optagelse udgivet';
$string['event_recording_unpublished'] = 'Udgivelse af optagelse stoppet';
$string['general_error_unable_connect'] = 'Det er ikke muligt at oprette forbindelse. Kontrollér BigBlueButton-serverens url OG kontrollér, om BigBlueButton-serveren kører.
Detaljer: {$a}';
$string['index_confirm_end'] = 'Vil du afslutte sessionen?';
$string['index_disabled'] = 'deaktiveret';
$string['index_enabled'] = 'aktiveret';
$string['index_ending'] = 'Afslutter sessionen ... vent lidt';
$string['index_error_forciblyended'] = 'Det er ikke muligt at deltage i sessionen da det er afsluttet manuelt.';
$string['index_error_unable_display'] = 'Det er ikke muligt at vise møder. Tjek BigBlueButton-serverens URL OG tjek om serveren kører.';
$string['index_heading'] = 'BigBlueButton-rum';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderatorer';
$string['index_heading_name'] = 'Rum';
$string['index_heading_recording'] = 'Optagelse';
$string['index_heading_users'] = 'Brugere';
$string['index_heading_viewer'] = 'Deltagere';
$string['mod_form_block_general'] = 'Generelle indstillinger';
$string['mod_form_block_participants'] = 'Rolle tildelt under livesessionen';
$string['mod_form_block_presentation'] = 'Præsentationsindhold';
$string['mod_form_block_record'] = 'Optagelsesindstillinger';
$string['mod_form_block_schedule'] = 'Tidsplan for sessionen';
$string['mod_form_field_closingtime'] = 'Lukket';
$string['mod_form_field_conference_name'] = 'Navn på sessionen';
$string['mod_form_field_duration'] = 'Varighed';
$string['mod_form_field_duration_help'] = 'Indstilling af mødets varighed vil angive en maksimal periode indenfor hvilken mødet holdes aktivt inden optagelsen slutter.';
$string['mod_form_field_intro'] = 'Beskrivelse';
$string['mod_form_field_intro_help'] = 'En kort beskrivelse af rummet';
$string['mod_form_field_name'] = 'Rummets navn';
$string['mod_form_field_openingtime'] = 'Åben';
$string['mod_form_field_participant_add'] = 'Tilføj deltager';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Deltager';
$string['mod_form_field_participant_list'] = 'Deltager';
$string['mod_form_field_participant_list_action_add'] = 'Tilføj';
$string['mod_form_field_participant_list_action_remove'] = 'Fjern';
$string['mod_form_field_participant_list_text_as'] = 'deltag i sessionen som';
$string['mod_form_field_participant_list_type_all'] = 'Alle tilmeldte brugere';
$string['mod_form_field_participant_list_type_owner'] = 'Ejer';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Bruger';
$string['mod_form_field_record'] = 'Sessionen optages måske';
$string['mod_form_field_room_name'] = 'Rummets navn';
$string['mod_form_field_userlimit'] = 'Brugergrænse';
$string['mod_form_field_userlimit_help'] = 'Maksimalt antal tilladte brugere i et møde. Hvis grænsen er sat til 0 vil antallet være ubegrænset.';
$string['mod_form_field_voicebridge_format_error'] = 'Formatfejl. Du bør angive et tal mellem 1 og 9999.';
$string['mod_form_field_wait'] = 'Vent på moderator';
$string['mod_form_field_wait_help'] = 'Skal deltagere vente på en moderator før de tilgå et rum?';
$string['mod_form_field_welcome'] = 'Velkomstbesked';
$string['mod_form_field_welcome_default'] = 'Velkommen til  %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Velkomstbeskeden vises, når deltagerne kommer ind i rummet. Hvis feltet er tomt, vises en standardmeddelelse, der er angivet i webstedets administration.';
$string['modulename_help'] = 'BigBlueButton er et open source webkonferencesystem designet til online læring, som understøtter deling i realtid af lyd, video, chat, dias, skærmdeling, whiteboard med flere brugere, grupperum, afstemninger og emojis.

Ved hjælp af BigBlueButton kan du oprette et rum til sessioner som f.eks. live online-undervisning, virtuelle kontortider eller gruppesamarbejde med fjernstuderende. Sessionen kan optages til senere afspilning.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['pluginname'] = 'BigBlueButton';
$string['started_at'] = 'Startet';
$string['starts_at'] = 'Starter';
$string['userlimitreached'] = 'Antallet af tilladte brugere i en session er nået.';
$string['view_conference_action_end'] = 'Afslut session';
$string['view_conference_action_join'] = 'Deltag i møde';
$string['view_error_bigbluebutton'] = 'BigBlueButton returnerede fejl. {$a}';
$string['view_error_create'] = 'BigBlueButtonserveren returnerede en fejlbesked. Mødet kunne ikke oprettes.';
$string['view_error_import_no_courses'] = 'Der er ikke valgt nogen kurser der skal gennemses for optagelser';
$string['view_error_import_no_recordings'] = 'Der er ingen optagelser på kurset som kan importeres';
$string['view_error_max_concurrent'] = 'Det tilladte antal samtidige sessioner er nået.';
$string['view_error_no_group'] = 'Der er ingen grupper. Du skal oprette nogle grupper, før du forsøger at deltage i sessionen.';
$string['view_error_no_group_student'] = 'Du er ikke blevet føjet til en gruppe. Kontakt din lærer.';
$string['view_error_no_group_teacher'] = 'Der er ingen grupper. Du er nødt til at oprette nogle grupper.';
$string['view_error_unable_join'] = 'Kan ikke komme ind i rummet. Kontroller BigBlueButton-serverens URL OG kontroller om BigBlueButton-serveren kører.';
$string['view_error_unable_join_student'] = 'Det er ikke muligt at forbinde til BigBlueButton-serveren.';
$string['view_error_unable_join_teacher'] = 'Det er ikke muligt at forbinde til BigBlueButton-serveren. Kontakt en administrator.';
$string['view_error_url_missing_parameters'] = 'Der mangler nogle parametre i denne URL';
$string['view_error_userlimit_reached'] = 'Grænsen for antal tilladte brugere i en session er nået.';
$string['view_groups_selection'] = 'Vælg hvilken gruppe du vil være med i og bekræft dit valg.';
$string['view_groups_selection_join'] = 'Deltag';
$string['view_groups_selection_warning'] = 'Der er et rum til hver gruppe, og du har adgang til flere af dem. Pas på at du får valgt det rigtige.';
$string['view_login_moderator'] = 'Logger ind som moderator ...';
$string['view_message_conference_has_ended'] = 'Sessionen er afsluttet.';
$string['view_message_conference_in_progress'] = 'Sessionen er i gang.';
$string['view_message_conference_not_started'] = 'Sessionen er ikke startet endnu.';
$string['view_message_conference_room_ready'] = 'Mødetrummet er klart og du kan deltage i sessionen nu.';
$string['view_message_conference_wait_for_moderator'] = 'Afventer at en moderator deltager i mødet.';
$string['view_message_finished'] = 'Aktiviteten er overstået.';
$string['view_message_has_joined'] = 'deltager';
$string['view_message_have_joined'] = 'deltager';
$string['view_message_hour'] = 'time';
$string['view_message_hours'] = 'timer';
$string['view_message_minute'] = 'minut';
$string['view_message_minutes'] = 'minutter';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderatorer';
$string['view_message_norecordings'] = 'Der er ingen optagelser.';
$string['view_message_notavailableyet'] = 'Sessionen er endnu ikke tilgængelig.';
$string['view_message_room_closed'] = 'Dette rum er lukket.';
$string['view_message_room_open'] = 'Rummet er åbent.';
$string['view_message_room_ready'] = 'Rummet er klar';
$string['view_message_session_has_user'] = 'Der er';
$string['view_message_session_has_users'] = 'Der er';
$string['view_message_session_no_users'] = 'Der er ingen deltagere i denne session';
$string['view_message_session_running_for'] = 'Denne session har været igang i';
$string['view_message_session_started_at'] = 'Sessionen startede kl.';
$string['view_message_tab_close'] = 'Denne fane/dette vindue skal lukkes manuelt';
$string['view_message_user'] = 'Bruger';
$string['view_message_users'] = 'Brugere';
$string['view_message_viewer'] = 'Betragter';
$string['view_message_viewers'] = 'Betragtere';
$string['view_noguests'] = 'BigBlueButton er ikke åben for gæster.';
$string['view_nojoin'] = 'Du har ikke en rolle der tillader dig at deltage i sessionen';
$string['view_recording'] = 'optagelse';
$string['view_recording_actionbar'] = 'Værktøjslinje';
$string['view_recording_activity'] = 'Aktivitet';
$string['view_recording_button_import'] = 'Links til import af optagelse';
$string['view_recording_button_return'] = 'Gå tilbage';
$string['view_recording_course'] = 'Kursus';
$string['view_recording_date'] = 'Dato';
$string['view_recording_description'] = 'Beskrivelse';
$string['view_recording_duration'] = 'Varighed';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_presentation'] = 'Præsentation';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Er du sikker på at du vil importere denne optagelse?';
$string['view_recording_length'] = 'Varighed';
$string['view_recording_link_warning'] = 'Dette er et link til en optagelse fra et andet kursus eller aktivitet.';
$string['view_recording_list_actionbar'] = 'Værktøjslinje';
$string['view_recording_list_actionbar_delete'] = 'Slet';
$string['view_recording_list_actionbar_hide'] = 'Skjul';
$string['view_recording_list_actionbar_publish'] = 'Publicér';
$string['view_recording_list_actionbar_show'] = 'Vis';
$string['view_recording_list_actionbar_unpublish'] = 'Stop udgivelse';
$string['view_recording_list_activity'] = 'Aktivitet';
$string['view_recording_list_course'] = 'Kursus';
$string['view_recording_list_date'] = 'Dato';
$string['view_recording_list_description'] = 'Beskrivelse';
$string['view_recording_list_duration'] = 'Varighed';
$string['view_recording_list_recording'] = 'Optagelse';
$string['view_recording_modal_title'] = 'Indstil værdier for optagelsen';
$string['view_recording_name'] = 'Navn';
$string['view_recording_recording'] = 'Optager';
$string['view_section_title_presentation'] = 'Præsentationsfil';
$string['view_section_title_recordings'] = 'Optagelser';
$string['view_warning_default_server'] = 'Dette websted bruger en <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">gratis BigBlueButton-service til Moodle (åbner i nyt vindue)</a> leveret af Blindside Networks med følgende begrænsninge:
<ol>
<li>Den maksimale længde for hver session er 60 minutter</li>
<li>Det maksimale antal samtidige brugere pr. session er 25</li>
<li>Optagelser udløber efter syv (7) dage og kan ikke downloades</li>
<li>De studerendes webkameraer er kun synlige for moderatoren.</li>
</ol>';
$string['waitformoderator'] = 'Venter på at en moderator deltager.';
