<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'et', version '4.3'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Kinnita';
$string['accept_grades'] = 'Kinnita tööriistast pärit hinded';
$string['accept_grades_admin'] = 'Kinnita tööriistast pärit hinded';
$string['accept_grades_admin_help'] = 'Saate määrata, kas tööriista pakkujal lubatakse selle tööriista eksemplaridega seotud hindeid lisada, värskendada, vaadata ja kustutada.

Mõni tööriistapakkuja võimaldab tööriistas tehtud toimingute eest saadud hinded mugavuse huvides otse Moodle’isse salvestada.';
$string['accept_grades_help'] = 'Saate määrata, kas tööriista pakkujal lubatakse selle konkreetse tööriistaeksemplaridega seotud hindeid lisada, värskendada, vaadata ja kustutada.

Mõni tööriistapakkuja võimaldab mugavuse huvides tööriistas tehtud toimingute eest saadud hinded otse Moodle’isse salvestada.

Pange tähele, et selle sätte saab tööriista konfiguratsioonis üle kirjutada.';
$string['accepted'] = 'Kinnitatud';
$string['action'] = 'Toiming';
$string['activate'] = 'Aktiveeri';
$string['activatetoadddescription'] = 'Enne kirjelduse lisamist peate selle tööriista aktiveerima.';
$string['active'] = 'Aktiivne';
$string['activity'] = 'Tegevus';
$string['add_ltiadv'] = 'Lisa LTI eelis';
$string['add_ltilegacy'] = 'Lisa pärand LTI';
$string['addnewapp'] = 'Luba välisrakendus';
$string['addserver'] = 'Lisa uus usaldusväärne server';
$string['addtype'] = 'Lisa eelkonfigureeritud tööriist';
$string['allow'] = 'Luba';
$string['allowsetting'] = 'Luba tööriistal talletada 8K sätteid Moodle’is';
$string['always'] = 'Alati';
$string['autoaddtype'] = 'Lisa tööriist';
$string['automatic'] = 'Automaatne, põhineb tööriista URL-il';
$string['baseurl'] = 'Alus-URL / tööriista registreerimisnimi';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuthi põhistring';
$string['basiclti_endpoint'] = 'LTI lõpp-punkt';
$string['basiclti_in_new_window'] = 'Teie tegevus avati uues aknas.';
$string['basiclti_in_new_window_open'] = 'Ava uues aknas';
$string['basiclti_parameters'] = 'LTI käivitusparameetrid';
$string['basicltiactivities'] = 'LTI tegevused';
$string['basicltifieldset'] = 'Kohandatud näidisväljakogum';
$string['basicltiintro'] = 'Tegevuse kirjeldus';
$string['basicltiname'] = 'Tegevuse nimi';
$string['basicltisettings'] = 'Learning Tool Interoperability (LTI) põhisätted';
$string['cachedef_keyset'] = 'Vahemällu salvestatakse tööriistade klahvistiku teave';
$string['cancel'] = 'Tühista';
$string['cancelled'] = 'Tühistatud';
$string['cannot_delete'] = 'Selle tööriista konfiguratsiooni ei saa kustutada.';
$string['cannot_edit'] = 'Selle tööriista konfiguratsiooni ei saa muuta.';
$string['capabilities'] = 'Tegevusload';
$string['capabilities_help'] = 'Valige tegevusload, mille soovite tööriista pakkuja jaoks lubada. Saate valida mitu funktsiooni.';
$string['capabilitiesrequired'] = 'Aktiveerumiseks vajab see tööriist juurdepääsu järgmistele andmetele:';
$string['cleanaccesstokens'] = 'Aegunud juurdepääsumärkide väline tööriist eemaldamine';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Jätkamiseks klõpsake</a>';
$string['clientidadmin'] = 'Kliendi ID';
$string['clientidadmin_help'] = 'Kliendi ID on unikaalne väärtus, mida kasutatakse tööriista tuvastamiseks. See luuakse automaatselt iga tööriista jaoks, mis kasutab LTI 1.3 juurutatud JWT turvaprofiili ja peaks olema osa tööriista pakkujale edastatud üksikasjadest, et nad saaksid ühenduse lõpuks konfigureerida.';
$string['comment'] = 'Kommentaar';
$string['configpassword'] = 'Välise tööriista vaikeparool';
$string['configpreferheight'] = 'Vaikimisi eelistatud kõrgus';
$string['configpreferwidget'] = 'Määra vidin vaikevidinaks';
$string['configpreferwidth'] = 'Vaikimisi eelistatud laius';
$string['configresourceurl'] = 'Vahendi vaike-URL';
$string['configtoolurl'] = 'Välise tööriista vaike-URL';
$string['configtypes'] = 'Luba LTI rakendused';
$string['configured'] = 'Konfigureeritud';
$string['confirmtoolactivation'] = 'Kas soovite selle tööriista kindlasti aktiveerida?';
$string['contentitem_deeplinking'] = 'Toetab sügavat linkimist (sisu-üksuse teade)';
$string['contentitem_deeplinking_help'] = 'Kui see ruut on märgitud, on välistööriista lisamisel saadaval valik „Vali sisu“.';
$string['contentitem_multiple_description'] = 'Sinu kursusele lisatakse järgmised üksused:';
$string['contentitem_multiple_graded'] = 'Hinnatud tegevus (Maksimumhinne: {$a})';
$string['course_tool_types'] = 'Kursuse tööriistad';
$string['courseactivitiesorresources'] = 'Kursuse Tegevused või Vahendid';
$string['courseid'] = 'Kursuse ID';
$string['courseinformation'] = 'Kursuseteave';
$string['courselink'] = 'Mine kursusele';
$string['coursemisconf'] = 'Kursus on valesti konfigureeritud';
$string['createdon'] = 'Loodud';
$string['curllibrarymissing'] = 'LTI kasutamiseks peab olema installitud PHP Curli teek.';
$string['custom'] = 'Kohandatud parameetrid';
$string['custom_config'] = 'Kasutatakse tööriista kohandatud konfiguratsiooni.';
$string['custom_help'] = 'Kohandatud parameetrid on tööriista pakkuja määratud sätted. Näiteks saab kohandatud parameetri abil kuvada konkreetse pakkujalt pärit vahendit. Iga parameeter peaks olema eraldi real kujul „nimi=väärtus“ (nt chapter=3“).

Seda välja pole vaja muuta, kui tööriista pakkuja selleks otsest juhist pole andnud.';
$string['custominstr'] = 'Kohandatud parameetrid';
$string['debuglaunch'] = 'Silumisrežiimi valik';
$string['debuglaunchoff'] = 'Tavakäivitus';
$string['debuglaunchon'] = 'Silumisrežiimis käivitus';
$string['default'] = 'Vaikimisi';
$string['default_launch_container'] = 'Vaikeümbris käivitamisel';
$string['default_launch_container_help'] = 'Käivitamisel kasutatav ümbris määrab selle, kuidas kuvatakse kursusel käivitatav tööriist. Mõni käivitamisel kasutatav ümbris võimaldab kasutada tööriista eraldiseisvana, teised ümbrised muudavad tööriista rohkem Moodle’i keskkonda integreerituks.

* **Vaikimisi** – käivitamisel kasutatakse tööriista konfiguratsioonis määratud ümbrist.
* **Samas aknas** – tööriist kuvatakse olemasolevas Moodle’i aknas samamoodi nagu enamik muud tüüpi tegevused.
* **Samas aknas ilma plokkideta** – tööriist kuvatakse olemasolevas Moodle’i aknas ja navigeerimisnupud kuvatakse lehe ülaservas.
* **Uues aknas** – tööriist avaneb uues aknas kogu saadaoleva ruumi ulatuses. Eri brauserites võib see avaneda uuel vahekaardil või hüpikaknas. Võimalik, et brauserites on uue akna avamine keelatud.';
$string['delegate'] = 'Delegeeri õpetajale';
$string['delegate_tool'] = 'Nagu on määratletud Sügava linkimise definitsioonis või Delegeeri õpetajale';
$string['delete'] = 'Kustuta';
$string['delete_confirmation'] = 'Kas soovite selle eelkonfigureeritud tööriista kindlasti kustutada?';
$string['deletetype'] = 'Kustuta eelkonfigureeritud tööriist';
$string['display_description'] = 'Kuva käivitamisel tegevuse kirjeldus';
$string['display_description_help'] = 'Kui see ruut on märgitud, kuvatakse tööriista pakkuja sisu kohal tegevuse kirjeldus (määratakse ülal).

Kirjeldus pole kohustuslik, aga seda võib kasutada näiteks tööriista kasutajatele täiendavate juhiste andmiseks.

Kirjeldust ei kuvata juhul, kui tööriist käivitatakse uues aknas.';
$string['display_name'] = 'Kuva käivitamisel tegevuse nimi';
$string['display_name_help'] = 'Kui see ruut on märgitud, kuvatakse tööriista pakkuja sisu kohal tegevuse nimi (määratakse ülal).

Võimalik, et ka tööriista pakkuja kuvab nime. Selle sätte abil saab vältida pealkirja dubleerimist.

Nime ei kuvata juhul, kui tööriist käivitatakse uues aknas.';
$string['domain_mismatch'] = 'Tööriista URL-i domeen ei ühti tööriista konfiguratsiooniga.';
$string['donot'] = 'Ära saada';
$string['donotaccept'] = 'Ei nõustu';
$string['donotallow'] = 'Ära luba';
$string['duplicateregurl'] = 'See registreerimise URL on juba kasutusel.';
$string['editdescription'] = 'Tööriistale kirjelduse lisamiseks klõpsake siin.';
$string['edittype'] = 'Muuda eelkonfigureeritud tööriista';
$string['embed'] = 'Manusta';
$string['embed_no_blocks'] = 'Manusta ilma plokkideta';
$string['enableemailnotification'] = 'Saada meiliteatisi';
$string['enableemailnotification_help'] = 'Kui see säte on lubatud, saavad õppijad meiliteatise, kui nende tööriistas esitatud tööle hinne pannakse.';
$string['enterkeyandsecret'] = 'Sisestage oma tarbijavõti ja ühissaladus.';
$string['enterkeyandsecret_help'] = 'Kui teile anti tarbijavõti ja/või ühissaladus, sisestage need siia.';
$string['errorbadurl'] = 'URL pole sobiv tööriista ega kasseti URL.';
$string['errorincorrectconsumerkey'] = 'Tarbijavõti on vale.';
$string['errorinvaliddata'] = 'Sobimatud andmed: {$a}';
$string['errorinvalidmediatype'] = 'Sobimatu meediumitüüp: {$a}';
$string['errorinvalidresponseformat'] = 'Sisuüksuse vastusevorming ei sobi.';
$string['errormisconfig'] = 'Tööriist on valesti konfigureeritud. Paluge oma Moodle’i administraatoril tööriista konfiguratsioon parandada.';
$string['errortooltypenotfound'] = 'LTI-tööriista tüüpi ei leitud.';
$string['existing_window'] = 'Olemasolev aken';
$string['extensions'] = 'LTI laiendusteenused';
$string['external_tool_type'] = 'Eelkonfigureeritud tööriist';
$string['external_tool_type_help'] = '* **Automaatne, põhineb tööriista URL-il** – sobivaim tööriistakonfiguratsioon valitakse automaatselt. Kui tööriista URL-i ei tunta ära, tuleb tööriista konfiguratsiooniüksikasjad sisestada käsitsi.
* **Kindel eelkonfigureeritud tööriist** – välistööriista pakkujaga suhtlemisel kasutatakse määratud tööriista konfiguratsiooni. Kui tööriista URL ei tundu kuuluvat tööriista pakkujale, kuvatakse hoiatus. Alati pole vaja tööriista URL-i sisestada.
* **Kohandatud konfiguratsioon** – võimalik, et tarbijavõti ja ühissaladus tuleb sisestada käsitsi. Tarbijavõtme ja ühissaladuse saab hankida tööriista pakkujalt. Kõigi tööriistade puhul pole tarbijavõtit ega ühissaladust vaja, sel juhul võib väljad jätta tühjaks.

### Eelkonfigureeritud tööriista muutmine

Eelkonfigureeritud tööriistade ripploendi järel on saadaval kolm ikooni.

* **Lisa** – kursusetasemetööriista konfiguratsiooni loomine. Tööriista konfiguratsiooni saavad kasutada kõik välistööriistaeksemplarid.
* **Muuda** – valige ripploendist kursusetasemetööriist ja seejärel klõpsake seda ikooni. Tööriista konfiguratsiooniüksikasju saab muuta.
* **Kustuta** – valitud kursusetasemetööriista eemaldamine.';
$string['external_tool_types'] = 'Eelkonfigureeritud tööriistad';
$string['failedtoconnect'] = 'Moodle ei saanud süsteemiga „{$a}“ ühendust luua.';
$string['failedtocreatetooltype'] = 'Uue tööriista loomine nurjus. Kontrollige URL-i ja proovige uuesti.';
$string['failedtodeletetoolproxy'] = 'Tööriista registreeringu kustutamine nurjus. Võimalik, et peate selle „Välistööriistade registreerimiste halduses“ käsitsi kustutama.';
$string['filter_basiclti_configlink'] = 'Eelistatud saitide ja nende paroolide konfigureerimine';
$string['filter_basiclti_password'] = 'Parool on kohustuslik.';
$string['filterconfig'] = 'LTI haldamine';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Kasuta valesti konfigureeritud eksemplari puhul olemasolevat konfiguratsiooni';
$string['fixnew'] = 'Uus konfiguratsioon';
$string['fixnewconf'] = 'Määratle valesti konfigureeritud eksemplari jaoks uus konfiguratsioon';
$string['fixold'] = 'Kasuta olemasolevat';
$string['force_ssl'] = 'Sunni SSL-i kasutama';
$string['force_ssl_help'] = 'Kui see säte on valitud, sunnitakse selle tööriista pakkujaga ühenduse loomiseks alati SSL-i kasutama.

Lisaks kasutatakse SSL-i kõikides tööriista pakkuja saadetavates teenusetaotlustes.

Kui soovite seda sätet kasutada, veenduge, et see Moodle’i sait ja tööriista pakkuja toetaks SSL-i.';
$string['forced_help'] = 'See säte on sunniviisiliselt jõustatud tööriista konfiguratsioonis kursuse või saidi tasemel. Te ei saa seda muuta selles liideses.';
$string['generaltool'] = 'Üldine tööriist';
$string['global_tool_types'] = 'Globaalsed eelkonfigureeritud tööriistad';
$string['grading'] = 'Hinnete marsruutimine';
$string['icon_url'] = 'Ikooni URL';
$string['icon_url_help'] = 'Ikooni URL võimaldab muuta ikooni, mis kuvatakse kursuse tegevuste loendis selle tegevuse juures. Vaikimisi määratud LTI ikooni asemel saate kasutada tegevust illustreerivat ikooni.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'Kognitiivne LTI';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb kognitiivsel sügavusel, mille õpilane on jõudnud LTI tegevuses.';
$string['indicator:cognitivedepthdef'] = 'Kognitiivne LTI';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on jõudnud selle analüüsi intervalli jooksul LTI tegevuste pakutava kognitiivse seotuse protsendini (tasemed = vaadet pole, vaade, esitamine, tagasiside kuvamine)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsilaane LTI';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel laiusel, mille õpilane LTI tegevuses saavutas.';
$string['indicator:socialbreadthdef'] = 'Sotsilaane LTI';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud LTI tegevuste pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osales üksi, osales koos teistega)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Algata sisselogimise URL';
$string['initiatelogin_help'] = 'Tööriista URL, kuhu tuleb saata sisselogimise algatamise taotlused. See URL on vajalik enne, kui sõnumi saab tööriista edukalt saata.';
$string['invalidid'] = 'LTI ID oli vale.';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Avaliku võtme tüüp';
$string['keytype_help'] = 'Tööriista valideerimiseks kasutatud autentimismeetod.';
$string['keytype_keyset'] = 'Klahvistiku URL';
$string['keytype_rsa'] = 'RSA võti';
$string['launch_in_moodle'] = 'Käivita tööriist Moodle’is';
$string['launch_in_popup'] = 'Käivita tööriist hüpikaknas';
$string['launch_url'] = 'Tööriista URL';
$string['launch_url_help'] = 'Tööriista URL tähistab välistööriista veebiaadressi ja võib sisaldada lisateavet (nt kuvatav vahend).
Kui te pole kindel, milline aadress tuleks määrata tööriista URL-iks, küsige lisateavet tööriista pakkujalt.

Kui teil on olemas kasseti URL; saate sisestada selle ja ülejäänud andmed sisestatakse vormi automaatselt.

Kui olete valinud eelkonfigureeritud tööriista, võib juhtuda, et te ei pea tööriista URL-i sisestama. See kehtib näiteks juhul, kui tööriista lingi kaudu käivitatakse ühendus tööriista pakkuja süsteemiga üldiselt, mitte konkreetse vahendiga.';
$string['launchinpopup'] = 'Käivitusümbris';
$string['launchinpopup_help'] = 'Käivitamisel kasutatav ümbris määrab selle, kuidas kuvatakse kursusel käivitatav tööriist. Mõni käivitamisel kasutatav ümbris võimaldab kasutada tööriista eraldiseisvana, teised ümbrised muudavad tööriista rohkem Moodle’i keskkonda integreerituks.

* **Vaikimisi** – käivitamisel kasutatakse tööriista konfiguratsioonis määratud ümbrist.
* **Samas aknas** – tööriist kuvatakse olemasolevas Moodle’i aknas samamoodi nagu enamik muud tüüpi tegevused.
* **Samas aknas ilma plokkideta** – tööriist kuvatakse olemasolevas Moodle’i aknas ja navigeerimisnupud kuvatakse lehe ülaservas.
* **Uues aknas** – tööriist avaneb uues aknas kogu saadaoleva ruumi ulatuses. Eri brauserites võib see avaneda uuel vahekaardil või hüpikaknas. Võimalik, et brauserites on uue akna avamine keelatud.';
$string['launchoptions'] = 'Käivitamissätted';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Tööriistade kursusespetsiifiliste konfiguratsioonide lisamine';
$string['lti:addinstance'] = 'Uute välise tööriista tegevuste lisamine';
$string['lti:addmanualinstance'] = 'Lisa käsitsi konfigureeritud tööriist';
$string['lti:addpreconfiguredinstance'] = 'Lisa eelseadistatud tööriist';
$string['lti:admin'] = 'Ole tööriista käivitamisel administraator';
$string['lti:grade'] = 'Välise tööriista tagastatud hinnete vaatamine';
$string['lti:manage'] = 'Tööriista käivitamine juhendaja režiimis';
$string['lti:requesttooladd'] = 'Nõua tööriista saidiülest konfiguratsiooni';
$string['lti:view'] = 'Välise tööriista tegevuste käivitamine';
$string['lti_administration'] = 'Muuda eelkonfigureeritud tööriista';
$string['lti_errormsg'] = 'Tööriist tagastas järgmise tõrketeate: „{$a}“';
$string['lti_launch_error'] = 'Välise tööriista käivitamisel ilmnes tõrge:';
$string['lti_launch_error_tool_request'] = '<p>
Konfigureerimise lõpuleviimiseks administraatorile päringu esitamiseks klõpsake <a href="{$a->admin_request_url}" target="_top">siin</a>.
</p>';
$string['lti_launch_error_unsigned_help'] = '<p>Võimalik, et selle tõrke põhjuseks on tööriista pakkujaga seotud tarbijavõtme ja ühissaladuse puudumine.</p>
<p>Kui teil on tarbijavõti ja ühissaladus, saate need sisestada välise tööriista muutmise käigus (veenduge, et täpsemad valikud oleks nähtaval).</p>
<p>Teine võimalus on <a href="{$a->course_tool_editor}">luua tööriista pakkuja jaoks kursusespetsiifiline konfiguratsioon</a>.</p>';
$string['lti_tool_request_added'] = 'Tööriista konfigureerimise taotlus on esitatud. Võimalik, et peate tööriista konfigureerimise lõpuleviimiseks pöörduma administraatori poole.';
$string['lti_tool_request_existing'] = 'Selle tööriista domeeniga seotud tööriista konfigureerimise taotlus on juba esitatud.';
$string['ltisettings'] = 'LTI sätted';
$string['ltiunknownserviceapicall'] = 'LTI tundmatu teenuse-API kutse';
$string['ltiversion'] = 'LTI versioon';
$string['ltiversion_help'] = 'LTI versioon, mida kasutatakse sõnumite ja teenusetaotluste allkirjastamiseks: LTI 1.0 / 1.1 ja LTI 2.0 kasutavad OAuth 1.0A turbeprofiili; LTI 1.3.0 kasutab JWT-sid.';
$string['main_admin'] = 'Üldspikker';
$string['main_admin_help'] = 'Välistööriistade abil saab Moodle’is mugavalt kasutada mujal majutatud õppematerjale. Välistööriist pääseb erilise käivitusprotokolli abil juurde tööriista käivitanud kasutaja üldistele andmetele.
 Need andmed on näiteks õppeasutuse nimi, kursuse ID, kasutaja ID ja muu teave (nt kasutaja nimi või meiliaadress).


Sellel lehel loetletud tööriistad on jagatud kolme kategooriasse.

* **Aktiivne** – administraator on nende tööriistapakkujate sätted kinnitanud ja konfigureerinud. Neid saab kasutada kõigil selle Moodle’i saidi kursustel.
 Sisestatud tarbijavõtme ja ühissaladuse põhjal luuakse selle Moodle’i saidi ja kaugtööriista vahel turvaliseks suhtluseks usaldusväärne ühenduskanal.

* **Ootel** – nende tööriistapakkujate sätted on paketina imporditud, aga administraator pole neid konfigureerinud.
Õpetajad saavad nende pakkujate tööriistu kasutada, kui neil on tarbijavõti ja ühissaladus või kui neid ei nõuta.
* **Tagasi lükatud** – need on tööriistapakkujad, kelle tööriistu administraator ei plaani kogu Moodle’i saidi jaoks saadavaks teha.
 Õpetajad saavad nende pakkujate tööriistu kasutada, kui neil on tarbijavõti ja ühissaladus või kui neid ei nõuta.';
$string['manage_external_tools'] = 'Tööriistade haldus';
$string['manage_tool_proxies'] = 'Väliste tööriistade registreerimiste haldus';
$string['manage_tools'] = 'Eelkonfigureeritud tööriistade haldus';
$string['manuallyaddtype'] = 'Teine võimalus on <a href="{$a}">konfigureerida tööriist käsitsi</a>.';
$string['miscellaneous'] = 'Varia';
$string['misconfiguredtools'] = 'Tuvastati valesti konfigureeritud tööriistaeksemplarid.';
$string['missingparameterserror'] = 'Leht on valesti konfigureeritud: „{$a}“.';
$string['module_class_type'] = 'Moodle’i mooduli tüüp';
$string['modulename'] = 'Väline tööriist';
$string['modulename_help'] = 'Välise tööriista tegevusmoodul võimaldab õppijatel kasutada muudel veebisaitidel olevaid õppematerjale ja tegevusi. Näiteks võib välise tööriista kaudu pääseda juurde väljaandja uut tüüpi tegevustele ja õppematerjalidele.

Välise tööriista tegevuse loomiseks peab tööriista pakkuja toetama LTI-d (Learning Tools Interoperability). Õpetaja saab luua uue välise tööriista tegevuse või kasutada saidi administraatori konfigureeritud tööriista.

Välise tööriista tegevused erinevad URL-i kaudu kasutatavatest vahenditest mitmes mõttes.

* Välised tööriistad on kontekstitundlikud, st need pääsevad juurde tööriista kasutaja andmetele (nt õppeasutus, kursus ja nimi).
* Välised tööriistad toetavad tegevuse eksemplariga seotud hinnete lugemist, värskendamist ja kustutamist.
* Välise tööriista konfigureerimisel luuakse teie saidi ja tööriista pakkuja vahel turvaliseks suhtluseks usaldusväärne ühenduskanal.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Välised tööriistad';
$string['modulenamepluralformatted'] = 'LTI eksemplarid';
$string['name'] = 'Nimi';
$string['never'] = 'Mitte kunagi';
$string['new_window'] = 'Uus aken';
$string['no_lti_configured'] = 'Ükski konfigureeritud tööriist pole aktiivne.';
$string['no_lti_pending'] = 'Ühtegi ootel välist tööriista pole.';
$string['no_lti_rejected'] = 'Ühtegi tagasi lükatud välist tööriista pole.';
$string['no_lti_tools'] = 'Välistööriistu pole konfigureeritud.';
$string['no_tp_accepted'] = 'Ühtegi välise tööriista registreerimist pole kinnitatud.';
$string['no_tp_cancelled'] = 'Ühtegi välise tööriista registreerimist pole tühistatud.';
$string['no_tp_configured'] = 'Ükski konfigureeritud väline tööriist pole registreerimata.';
$string['no_tp_pending'] = 'Ükski välise tööriista registreerimine pole ootel.';
$string['no_tp_rejected'] = 'Ühtegi välise tööriista registreerimist pole tagasi lükatud.';
$string['noattempts'] = 'Selles tööriistaeksemplaris pole tehtud ühtegi soorituskatset.';
$string['noltis'] = 'Ühtegi välise tööriista eksemplari pole.';
$string['noprofileservice'] = 'Profiiliteenust ei leitud.';
$string['noservers'] = 'Servereid ei leitud.';
$string['notypes'] = 'Moodle’is pole praegu seadistatud ühtegi LTI-tööriista. Nende lisamiseks klõpsake ülalpool olevat linki Installi.';
$string['noviewusers'] = 'Ühtegi selle tööriista kasutamise loaga kasutajat ei leitud.';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 nõuab, et kehtiv openssl.cnf oleks konfigureeritud ja sinu veebiserverile kättesaadav. Selle saidi openssl seadistamiseks ja lubamiseks pöördu saidi administraatori poole.';
$string['optionalsettings'] = 'Valikulised sätted';
$string['organization'] = 'Asutuse üksikasjad';
$string['organizationdescr'] = 'Asutuse kirjeldus';
$string['organizationid_default'] = 'Vaikimisi organisatsiooni ID';
$string['organizationid_default_help'] = 'Organisatsiooni ID jaoks kasutatav vaikeväärtus. Saidi ID tuvastab selle Moodle\'i installi.';
$string['organizationidguid'] = 'Organisatsiooni ID';
$string['organizationidguid_help'] = 'Selle Moodle\'i eksemplari kordumatu identifikaator edastati tööriistale platvormi eksemplari GUID-na.

Kui see väli jäetakse tühjaks, kasutatakse vaikeväärtust.';
$string['organizationurl'] = 'Asutuse URL';
$string['organizationurl_help'] = 'Selle Moodle’i saidi alus-URL

Kui see väli jääb tühjaks, kasutatakse saidi konfiguratsioonile vastavat vaikeväärtust.';
$string['pagesize'] = 'Lehel kuvatavate esitamiste arv';
$string['parameter'] = 'Tööriista parameetrid';
$string['parameter_help'] = 'Tööriista parameetrid on sätted, mille tööriista pakkuja peab edastama kinnitatud tööriista puhvris.';
$string['password'] = 'Ühissaladus';
$string['password_admin'] = 'Ühissaladus';
$string['password_admin_help'] = 'Ühissaladus on sisuliselt parool, mille abil saab autentida tööriista kasutaja. Tööriista pakkuja peaks selle edastama koos tarbijavõtmega.

Nende tööriistade puhul, mis ei nõua Moodle’iga turvalise ühenduse loomist ega ei paku lisateenuseid (nt hindearuanded), ei pruugi ühissaladust vaja olla.';
$string['password_help'] = 'Eelkonfigureeritud tööriistade puhul ei pea selles etapis ühissaladust sisestama, sest see sisestatakse konfigureerimise käigus.

Selle välja peaks täitma siis, kui soovite luua lingi konfigureerimata tööriistapakkuja jaoks. Kui tööriista pakkujat kasutatakse kursusel mitu korda, soovitame lisada kursuse tasemel tööriista konfiguratsiooni.

Ühissaladus on sisuliselt parool, mille abil saab autentida tööriista kasutaja. Tööriista pakkuja peaks selle edastama koos tarbijavõtmega.

Nende tööriistade puhul, mis ei nõua Moodle’iga turvalise ühenduse loomist ega ei paku lisateenuseid (nt hindearuanded), ei pruugi ühissaladust vaja olla.';
$string['pending'] = 'Ootel';
$string['pluginadministration'] = 'Välistööriista haldus';
$string['pluginname'] = 'Välistööriist';
$string['preferheight'] = 'Eelistatud kõrgus';
$string['preferwidget'] = 'Vidina eelistatud käivitusrežiim';
$string['preferwidth'] = 'Eelistatud laius';
$string['press_to_submit'] = 'Klõpsake selle tegevuse käivitamiseks';
$string['privacy'] = 'Privaatsus';
$string['privacy:metadata:coursefullname'] = 'Kursuse täisnimi, kust kasutaja LTI Tarbijale juurde pääseb';
$string['privacy:metadata:courseid'] = 'Kursuse ID, kust kasutaja LTI Tarbijale juurde pääseb';
$string['privacy:metadata:courseidnumber'] = 'Kursuse ID-number, kust kasutaja LTI-tarbijale juurde pääseb';
$string['privacy:metadata:courseshortname'] = 'Kursuse lühinimi, kust kasutaja LTI Tarbijale juurde pääseb';
$string['privacy:metadata:createdby'] = 'Kaardi loonud kasutaja';
$string['privacy:metadata:email'] = 'Kasutaja e-posti aadress, kes üritab LTI Tarbijale ligi pääseda';
$string['privacy:metadata:externalpurpose'] = 'LTI-Tarbija pakub kasutajainfot ja konteksti LTI-tööriista pakkujale.';
$string['privacy:metadata:firstname'] = 'LTI-tarbijat kasutava kasutaja eesnimi';
$string['privacy:metadata:fullname'] = 'LTI-tarbijat kasutava kasutaja täisnimi';
$string['privacy:metadata:lastname'] = 'LTI-tarbijat kasutava kasutaja perekonnanimi';
$string['privacy:metadata:lti_submission'] = 'LTI esitamine';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Ajatempel, mis näitab esitamise kuupäeva';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Ajatempel, mis näitab, millal esildist muudeti';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Kasutaja hinne protsentides';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Kasutaja originaalhinne';
$string['privacy:metadata:lti_submission:userid'] = 'LTI-tegevuse jaoks esitanud kasutaja ID';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI volitused';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI proksi nimi';
$string['privacy:metadata:lti_types'] = 'LTI tüübid';
$string['privacy:metadata:lti_types:name'] = 'LTI tüübi nimi';
$string['privacy:metadata:role'] = 'Kursusel olev roll kasutajal, kes üritab LTI tarbijale ligi saada';
$string['privacy:metadata:timecreated'] = 'Kaardi loomise aeg';
$string['privacy:metadata:timemodified'] = 'Kaardi muutmise aeg';
$string['privacy:metadata:userid'] = 'LTI tarbijale ligipääseva kasutaja ID';
$string['privacy:metadata:useridnumber'] = 'LTI tarbijale ligipääseva kasutaja ID number';
$string['privacy:metadata:username'] = 'LTI tarbijale ligipääseva kasutaja kasutajanimi';
$string['publickey'] = 'Avalik võti';
$string['publickey_help'] = 'Tööriista pakutav avalik võti (PEM-vormingus) sissetulevate sõnumite ja teenusetaotluste allkirjade kontrollimiseks.';
$string['publickeyset'] = 'Avalik võtmekomplekt';
$string['publickeyset_help'] = 'Avalik võtmekomplekt, kust see sait hangib tööriista avaliku võtme, et sissetulevate sõnumite ja teenusetaotluste allkirju saaks kontrollida.';
$string['quickgrade'] = 'Luba kiirhindamine';
$string['quickgrade_help'] = 'Kui see säte on lubatud, saab ühel lehel hinnata mitme tööriista ulatuses. Lisage hinded ja kommentaarid ning seejärel klõpsake kõigi sellel lehel tehtud muudatuste salvestamiseks nuppu „Salvesta kogu minu tagasiside“.';
$string['redirect'] = 'Teid suunatakse ümber mõne sekundi jooksul. Kui mitte, klõpsake nuppu.';
$string['redirectionuris'] = 'Ümbersuunamine  URL(id)';
$string['redirectionuris_help'] = 'URI-de loend (üks rea kohta), mida tööriist autoriseerimistaotluste esitamisel kasutab. Vähemalt üks peab olema registreeritud, enne kui sõnumi saab tööriista edukalt saata.';
$string['register'] = 'Registreeri';
$string['register_warning'] = 'Tundub, et registreerimislehe avamiseks kulub aega. Kui see ei avane, veenduge, et konfiguratsioonisätetes oleks sisestatud õige URL. Kui Moodle kasutab HTTPS-i, veenduge, et konfigureeritav tööriist toetaks HTTPS-i ja te kasutaksite URL-is HTTPS-i.';
$string['registertype'] = 'Konfigureeri uue välise tööriista registreerimine';
$string['registration_options'] = 'Registreerimissätted';
$string['registrationname'] = 'Tööriista pakkuja nimi';
$string['registrationname_help'] = 'Sisestage registreeritava tööriista pakkuja nimi.';
$string['registrationurl'] = 'Registreerimise URL';
$string['registrationurl_help'] = 'Registreerimise URL on koht tööriista pakkuja juures, kuhu saadetakse registreerimistaotlused.';
$string['reject'] = 'Lükka tagasi';
$string['rejected'] = 'Tagasi lükatud';
$string['resource'] = 'Vahend';
$string['resourcekey'] = 'Tarbijavõti';
$string['resourcekey_admin'] = 'Tarbijavõti';
$string['resourcekey_admin_help'] = 'Tarbijavõti on sisuliselt kasutajanimi, mille abil saab autentida tööriista kasutaja. Tööriista pakkuja jaoks toimib see kordumatu ID-na, mille põhjal tuvastatakse Moodle’i sait, kus kasutaja tööriista käivitab.

Tarbijavõtme peab edastama tööriista pakkuja. Tarbijavõtme hankimise viis on eri pakkujate puhul erinev. See võib toimuda automaatselt või tööriista pakkujale saadetava päringu põhjal.

Nende tööriistade puhul, mis ei nõua Moodle’iga turvalise ühenduse loomist ega ei paku lisateenuseid (nt hindearuanded), ei pruugi ressursi võtit vaja olla.';
$string['resourcekey_help'] = 'Eelkonfigureeritud tööriistade puhul ei pea selles etapis ressursi võtit sisestama, sest see sisestatakse konfigureerimise käigus.

Selle välja peaks täitma siis, kui soovite luua lingi konfigureerimata tööriistapakkuja jaoks. Kui tööriista pakkujat kasutatakse kursusel mitu korda, soovitame lisada kursuse tasemel tööriista konfiguratsiooni.

Tarbijavõti on sisuliselt kasutajanimi, mille abil saab autentida tööriista kasutaja. Tööriista pakkuja jaoks toimib see kordumatu ID-na, mille põhjal tuvastatakse Moodle’i sait, kus kasutaja tööriista käivitab.

Tarbijavõtme peab edastama tööriista pakkuja. Tarbijavõtme hankimise viis on eri pakkujate puhul erinev. See võib toimuda automaatselt või tööriista pakkujale saadetava päringu põhjal.

Nende tööriistade puhul, mis ei nõua Moodle’iga turvalise ühenduse loomist ega ei paku lisateenuseid (nt hindearuanded), ei pruugi ressursi võtit vaja olla.';
$string['resourceurl'] = 'Vahendi URL';
$string['return_to_course'] = 'Kursusekuvale naasmiseks klõpsake <a href="{$a->link}" target="_top">siin</a>.';
$string['saveallfeedback'] = 'Salvesta kogu minu tagasiside';
$string['search:activity'] = 'Välistööriist – tegevuse teave';
$string['secure_icon_url'] = 'Turvalise ühenduse ikooni URL';
$string['secure_icon_url_help'] = 'Sarnane ikooni URL-iga, aga see kuvatakse siis, kui kasutaja siseneb Moodle’iss turvaliselt SSL-i kaudu. Selle sätte peamine eesmärk on takistada brauseril kasutajat hoiatamast, kui leht avati SSL-i kaudu ja kuvada ebaturvaline pilt.';
$string['secure_launch_url'] = 'Turvaline tööriista URL';
$string['secure_launch_url_help'] = 'Sarnane tööriista URL-iga, aga seda kasutatakse kõrge turvalisuse tagamiseks. Moodle kasutab turvalist tööriista URL-i tavalise tööriista URL-i asemel, kui Moodle’i sait avatakse SSL-i kaudu või kui tööriista konfiguratsioonis on sisse lülitatud alati SSL-i kaudu käivitamine.

Samuti saate tööriista URL-iks määrata HTTPS-aadressi, mis sunnitakse käivituma SSL-i kaudu, nii et selle välja võib tühjaks jätta.';
$string['selectcontent'] = 'Sisu valimine';
$string['send'] = 'Saada';
$string['services'] = 'Teenused';
$string['services_help'] = 'Valige teenused, mille soovite tööriista pakkuja jaoks lubada. Saate valida mitu teenust.';
$string['setupoptions'] = 'Häälestusvalikud';
$string['share_email'] = 'Edasta tööriistale käivitaja meiliaadress';
$string['share_email_admin'] = 'Edasta tööriistale käivitaja meiliaadress';
$string['share_email_admin_help'] = 'Saate määrata, kas tööriista pakkujale edastatakse tööriista käivitaja meiliaadress.
Tööriista pakkuja saab meiliaadresside järgi eristada kasutajaliideses sama kasutajanimega õppijaid, samuti võib tööriist saata meilisõnumeid tööriistas tehtud toimingute põhjal.';
$string['share_email_help'] = 'Saate määrata, kas tööriista pakkujale edastatakse tööriista käivitaja meiliaadress.

Tööriista pakkuja saab meiliaadresside järgi sama kasutajanimega kasutajaid eristada, samuti võib tööriist saata meilisõnumeid tööriistas tehtud toimingute põhjal.

Pange tähele, et selle sätte saab tööriista konfiguratsioonis üle kirjutada.';
$string['share_name'] = 'Edasta tööriistale käivitaja nimi';
$string['share_name_admin'] = 'Edasta tööriistale käivitaja nimi';
$string['share_name_admin_help'] = 'Saate määrata, kas tööriista pakkujale edastatakse tööriista käivitaja täisnimi.
Tööriista pakkuja kasutab nimesid selleks, et kuvada tööriistas kasutaja jaoks tähenduslikku teavet.';
$string['share_name_help'] = 'Saate määrata, kas tööriista pakkujale edastatakse tööriista käivitaja täisnimi.

Tööriista pakkuja kasutab nimesid selleks, et kuvada tööriistas kasutaja jaoks tähenduslikku teavet.

Pange tähele, et selle sätte saab tööriista konfiguratsioonis üle kirjutada.';
$string['share_roster'] = 'Anna tööriistale juurdepääs kursuse nimekirjale';
$string['share_roster_admin'] = 'Tööriist pääseb juurde kursuse nimekirjale';
$string['share_roster_admin_help'] = 'Saate määrata, kas tööriist pääseb juurde nende kursuste kasutajaloenditele, mille kaudu see tööriist käivitatakse.';
$string['share_roster_help'] = 'Saate määrata, kas tööriist pääseb juurde selle kursuse kasutajaloendile.

Pange tähele, et selle sätte saab tööriista konfiguratsioonis üle kirjutada.';
$string['show_in_course_activity_chooser'] = 'Kuva tegevusevalijas ja kuva eelkonfigureeritud tööriistana';
$string['show_in_course_lti1'] = 'Tööriista konfiguratsiooni kasutus';
$string['show_in_course_lti1_help'] = 'See tööriist võidakse kuvada tegevusevalijas, et õpetaja saaks selle valida ja kursusele lisada. Teine võimalus on kuvada see välistööriista kursusele lisamisel eelkonfigureeritud tööriistade rippmenüüs. Lisavõimalus on lubada tööriista konfiguratsiooni kasutada ainult siis, kui kursusele välistööriista lisamisel sisestatakse tööriista täpne URL.';
$string['show_in_course_lti2'] = 'Tööriista konfiguratsiooni kasutus';
$string['show_in_course_lti2_help'] = 'See tööriist võidakse kuvada tegevusevalijas, et õpetaja saaks selle valida ja kursusele lisada, või välistööriista kursusele lisamisel eelkonfigureeritud tööriistade rippmenüüs.';
$string['show_in_course_no'] = 'Ära kuva, kasuta ainult siis, kui sisestatakse vastav tööriista URL';
$string['show_in_course_preconfigured'] = 'Kuva välistööriista lisamisel eelkonfigureeritud tööriistana';
$string['sitehost'] = 'Saidi hostinimi';
$string['siteid'] = 'Saidi ID';
$string['size'] = 'Mahuparameetrid';
$string['submission'] = 'Töö esitamine';
$string['submissions'] = 'Esitatud tööd';
$string['submissionsfor'] = 'Ülesandes {$a} esitatud tööd';
$string['subplugintype_ltiresource'] = 'LTI teenuseressurss';
$string['subplugintype_ltiresource_plural'] = 'LTI teenuseressursid';
$string['subplugintype_ltiservice'] = 'LTI teenus';
$string['subplugintype_ltiservice_plural'] = 'LTI teenused';
$string['subplugintype_ltisource'] = 'LTI allikas';
$string['subplugintype_ltisource_plural'] = 'LTI allikad';
$string['successfullycreatedtooltype'] = 'Uus tööriist on nüüd loodud.';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Tööriista konfiguratsioon on valitud sisust toodud.';
$string['toggle_debug_data'] = 'Kuva/peida silumisandmed';
$string['tool_config_not_found'] = 'Selle URL-iga seotud tööriista konfiguratsiooni ei leitud.';
$string['tool_settings'] = 'Tööriista sätted';
$string['tooldescription'] = 'Tööriista kirjeldus';
$string['tooldescription_help'] = 'Tööriista kirjeldus, mis kuvatakse õpetajatele tegevuste loendis.

Siin tuleks kirjeldada, milleks see tööriist on mõeldud ja mida see teeb, ning anda õpetajale kogu vajalik lisateave.';
$string['tooldetailsaccesstokenurl'] = 'Juurdepääsu märgi URL';
$string['tooldetailsauthrequesturl'] = 'Autentimistaotluse URL';
$string['tooldetailsclientid'] = 'Kliendi ID';
$string['tooldetailsdeploymentid'] = 'Juurutamise ID';
$string['tooldetailsmailtosubject'] = 'LTI tööriista seaded';
$string['tooldetailsmodalemail'] = 'Email';
$string['tooldetailsmodallink'] = 'Kuva seadistuse detailid';
$string['tooldetailsmodaltitle'] = 'Tööriista konfiguratsiooni detailid';
$string['tooldetailsplatformid'] = 'Platvormi ID';
$string['tooldetailspublickeyseturl'] = 'Avaliku võtmekomplekti URL';
$string['toolisbeingused'] = 'Seda tööriista kasutatakse {$a} korda';
$string['toolisnotbeingused'] = 'Seda tööriista pole veel kasutatud';
$string['toolproxy'] = 'Väliste tööriistade registreerimised';
$string['toolproxy_help'] = 'Välistööriistade registreerimised võimaldavad Moodle’i saidi administraatoritel konfigureerida välistööriistad tööriistapuhvri abil, mis on saadud LTI versiooni 2.0 toetavalt tööriista pakkujalt. Protsessi alustamiseks on vaja ainult tööriista pakkuja edastatud registreerimise URL-i. Tööriista pakkuja jaoks juurdepääsetavad tegevusload ja teenused valitakse uue registreerimise konfigureerimisel.

Sellel lehel loetletud tööriistaregistreeringud on jagatud nelja kategooriasse.

* **Konfigureeritud** – need tööriistaregistreeringud on seadistatud, kuid registreerimisprotsess pole veel alanud.
* **Ootel** – nende tööriistade registreerimisprotsess on alanud, kuid pole lõpule viidud. Selle tagasi kategooriasse „Konfigureeritud“ teisaldamiseks avage ja salvestage sätted.

* **Kinnitatud** – need tööriistaregistreeringud on kinnitatud; tööriista puhverserveris määratletud ressursid kuvatakse eelkonfigureeritud tööriistade lehel
esialgse olekuga „Ootel“.
* **Tagasi lükatud** – need tööriistaregistreeringud lükati registreerimisprotsessi ajal tagasi. Selle tagasi kategooriasse „Konfigureeritud“ teisaldamiseks ja registreerimise uuesti alustamiseks avage ja salvestage sätted.';
$string['toolproxyregistration'] = 'Välise tööriista registreerimine';
$string['toolregistration'] = 'Välise tööriista registreerimine';
$string['toolsetup'] = 'Välise tööriista konfiguratsioon';
$string['tooltypeadded'] = 'Eelkonfigureeritud tööriist lisati';
$string['tooltypedeleted'] = 'Eelkonfigureeritud tööriist kustutati';
$string['tooltypenotdeleted'] = 'Eelkonfigureeritud tööriista ei saanud kustutada';
$string['tooltypes'] = 'Tööriistad';
$string['tooltypeupdated'] = 'Eelkonfigureeritud tööriist värskendati';
$string['toolurl'] = 'Tööriista URL';
$string['toolurl_contentitemselectionrequest'] = 'Sisu valimise URL';
$string['toolurl_contentitemselectionrequest_help'] = 'Sisuvaliku URL-i kasutatakse sisuvaliku lehe käivitamiseks tööriistapakkujalt. Kui see on tühi, kasutatakse tööriista URL-i';
$string['toolurl_help'] = 'Tööriista URL-i kasutatakse tööriistade URL-ide ja konfiguratsioonide vastavusse viimiseks. URL-i ette http(s)-i lisamine pole kohustuslik.

Kui välistööriista eksemplaris pole tööriista URL-i määratud, kasutatakse sellena alus-URL-i.

Näiteks tööriista *tool.com* alus-URL vastab järgmistele:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Tööriista *www.tool.com/quizzes* alus-URL vastab järgmistele:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Tööriista *quiz.tool.com* alus-URL vastab järgmistele:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Kui ühele ja samale domeenile on mitu eri tööriistakonfiguratsiooni, kasutatakse kõige täpsemat vastet.

Samuti saate sisestada kasseti URL-i, kui teil on see olemas, ja tööriista üksikasjad sisestatakse automaatselt.';
$string['toolurlplaceholder'] = 'Tööriista URL...';
$string['typename'] = 'Tööriista nimi';
$string['typename_help'] = 'Tööriista nime põhjal tuvastatakse Moodle’is tööriista pakkuja. Sisestatud nimi kuvatakse õpetajatele, kui nad kursustel väliseid tööriistu lisavad.';
$string['types'] = 'Tüübid';
$string['unabletocreatetooltype'] = 'Tööriista ei saa luua';
$string['unabletofindtooltype'] = 'Ei leia tööriista üksusele {$a->id}';
$string['unknownstate'] = 'Tundmatu seisund';
$string['update'] = 'Värskendus';
$string['useraccountinformation'] = 'Kasutaja kontoteave';
$string['userpersonalinformation'] = 'Kasutaja isikuandmed';
$string['using_tool_cartridge'] = 'Tööriistakasseti kasutamine';
$string['using_tool_configuration'] = 'Aktiivse tööriista konfiguratsioon:';
$string['validurl'] = 'URL-i alguses peab olema „http(s)://“.';
$string['viewsubmissions'] = 'Esitatud tööde ja hinnete kuva';
