<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'et', version '4.3'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Juurdepääsukontroll';
$string['actionaftercorrectanswer'] = 'Toiming pärast õiget vastust';
$string['actionaftercorrectanswer_help'] = 'Pärast küsimusele õigesti vastamist on järgneva lehe jaoks 3 valikut:
* Tavaline – järgige tunni kava
* Kuva veel vaatamata leht – lehed on kuvatud juhujärjestuses, lehte korduvalt ei kuvata.
* Kuva veel vastamata leht – lehed on kuvatud juhujärjestuses koos lehtedega, mis sisaldavad uuesti kuvatud vastamata küsimusi';
$string['actions'] = 'Toimingud';
$string['activitylink'] = 'Link järgmisele toimingule';
$string['activitylink_help'] = 'Kui soovite, et tunni lõpus kuvataks link mõnele muule tegevusele, valige see tegevus rippmenüüst.';
$string['activitylinkname'] = 'Minge: {$a}';
$string['activityoverview'] = 'Mõne teie õppetüki tähtaeg on käes.';
$string['addabranchtable'] = 'Lisa sisuleht';
$string['addanendofbranch'] = 'Lisa haru lõpp';
$string['addanewpage'] = 'Lisa uus leht';
$string['addaquestionpage'] = 'Lisa küsimuste leht';
$string['addaquestionpagehere'] = 'Lisa küsimuste leht siia';
$string['addbranchtable'] = 'Lisa sisuleht';
$string['addcluster'] = 'Lisa küsimuste rühm';
$string['addedabranchtable'] = 'Sisuleht lisatud';
$string['addedanendofbranch'] = 'Haru lõpp on lisatud';
$string['addedaquestionpage'] = 'Küsimuste leht lisatud';
$string['addedcluster'] = 'Küsimuste rühm on lisatud';
$string['addedendofcluster'] = 'Küsimuste rühma lõpp on lisatud';
$string['addendofbranch'] = 'Lisa haru lõpp';
$string['addendofcluster'] = 'Lisa küsimuste rühma lõpp';
$string['addessay'] = 'Loo essee tüüpi küsimuse leht';
$string['addmatching'] = 'Loo vastavusse seadmise tüüpi küsimuse leht';
$string['addmultichoice'] = 'Loo valikvastustega küsimuse leht';
$string['addnewgroupoverride'] = 'Lisa rühma testisätete ülekirjutus';
$string['addnewuseroverride'] = 'Lisa kasutaja testisätete ülekirjutus';
$string['addnumerical'] = 'Loo arvuküsimuse leht';
$string['addpage'] = 'Lisa leht';
$string['addshortanswer'] = 'Loo lühivastusega küsimuse leht';
$string['addtruefalse'] = 'Loo tõene/väär-vastusega küsimuse leht';
$string['allotheranswers'] = 'Kõik teised vastused';
$string['allotheranswersjump'] = 'Kõikide teiste vastuse hüpped';
$string['allotheranswersscore'] = 'Kõikide teiste vastuste skoor';
$string['allowofflineattempts'] = 'Luba tunni soorituskatse mobiilirakenduse kaudu võrguühenduseta';
$string['allowofflineattempts_help'] = 'Kui see säte on lubatud, saab mobiilirakenduse kasutaja tunni alla laadida ja teha soorituskatse võrguühenduseta.
Alla laaditakse ka kõik võimalikud vastused ja õiged vastused.
Märkus. Kui tunnil on ajapiirang, ei saa võrguühenduseta soorituskatset teha.';
$string['anchortitle'] = 'Põhisisu algus';
$string['and'] = 'JA';
$string['answer'] = 'Vastus';
$string['answeredcorrectly'] = 'õigesti vastatud.';
$string['answersfornumerical'] = 'Numbriliste küsimuste vastused peaksid olema paarid miinimum- ja maksimumväärtustest.';
$string['arrangebuttonshorizontally'] = 'Kas soovite paigutada sisunupud horisontaalselt?';
$string['attempt'] = 'Soorituskatse: {$a}';
$string['attemptheader'] = 'Soorituskatse';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Soorituskatsed';
$string['attemptsdeleted'] = 'Kustutatud soorituskatsed';
$string['attemptsremaining'] = 'Jäänud on {$a} soorituskatset';
$string['available'] = 'Saadaval alates';
$string['averagescore'] = 'Keskmine punktisumma';
$string['averagetime'] = 'Keskmine aeg';
$string['branch'] = 'Sisu';
$string['branchtable'] = 'Sisu';
$string['cancel'] = 'Tühista';
$string['cannotfindanswer'] = 'Tõrge. Vastust ei leitud.';
$string['cannotfindattempt'] = 'Tõrge. Soorituskatset ei leitud.';
$string['cannotfindessay'] = 'Viga: esseed ei leitud';
$string['cannotfindfirstgrade'] = 'Tõrge. Hindeid ei leitud.';
$string['cannotfindfirstpage'] = 'Esimest lehte ei leitud.';
$string['cannotfindgrade'] = 'Tõrge. Hindeid ei leitud.';
$string['cannotfindnewestgrade'] = 'Tõrge. Uusimat hinnet ei leitud.';
$string['cannotfindnextpage'] = 'Tunni varundus: järgmist lehte ei leitud.';
$string['cannotfindpagerecord'] = 'Lisa haru lõppu: lehe kirjet ei leitud';
$string['cannotfindpages'] = 'Tunni lehti ei leitud';
$string['cannotfindpagetitle'] = 'Kustutamise kinnitamine: lehe pealkirja ei leitud';
$string['cannotfindpreattempt'] = 'Eelmise soorituskatse kirjet ei leitud.';
$string['cannotfindrecords'] = 'Tõrge. Tunni kirjeid ei leitud';
$string['cannotfindtimer'] = 'Tõrge. Üksuse lesson_timerkirjeid ei leitud';
$string['cannotfinduser'] = 'Tõrge. Kasutajaid ei leitud';
$string['canretake'] = '{$a} saab uuesti teha';
$string['casesensitive'] = 'Kasuta regulaaravaldisi';
$string['casesensitive_help'] = 'Märkige see ruut, et vastuste analüüsil kasutataks regulaaravaldisi.';
$string['checkbranchtable'] = 'Kontrolli sisulehte';
$string['checkedthisone'] = 'Kontrollis seda.';
$string['checknavigation'] = 'Kontrolli navigatsiooni';
$string['checkquestion'] = 'Kontrolli küsimust';
$string['classstats'] = 'Klassi statistika';
$string['clicktodownload'] = 'Faili allalaadimiseks klõpsake järgmist linki.';
$string['closebeforeopen'] = 'Õppetükki ei saanud värskendada. Teie määratud sulgemiskuupäev on avamiskuupäevast varasem.';
$string['cluster'] = 'Küsimuste rühm';
$string['clusterjump'] = 'Veel vaatamata küsimus rühmast';
$string['clustertitle'] = 'Küsimuste rühm';
$string['collapsed'] = 'Ahendatud';
$string['comments'] = 'Teie kommentaarid';
$string['completed'] = 'Lõpetatud';
$string['completederror'] = 'Lõpeta tund';
$string['completethefollowingconditions'] = 'Jätkamiseks peate täitma järgmised tunniga <b>{$a}</b> seotud tingimused.';
$string['completionendreached'] = 'Nõua lehe lõppu jõudmist';
$string['completionendreached_desc'] = 'Õppija peab selle tegevuse lõpule viimiseks jõudma õppetüki lehe lõppu.';
$string['completiontimespent'] = 'Õppija peab selles tegevuses veetma vähemalt';
$string['completiontimespentdesc'] = 'Õppija peab selles tegevuses veetma vähemalt {$a}';
$string['completiontimespentgroup'] = 'Nõua ajakulu';
$string['conditionsfordependency'] = 'Sõltuvuse tingimus(ed)';
$string['configintro'] = 'Siin määratud väärtused määratlevad vaikeväärtused, mida kasutatakse sätete vormis siis, kui luuakse uut tunnitegevust. Täpsemate sätetena määratletud sätted kuvatakse ainult siis, kui klõpsatakse linki „Kuva rohkem...“.';
$string['configmaxanswers'] = 'Maksimaalne vaikimisi lubatud vastustearv lehel';
$string['configmediaclose'] = 'Kuvab sulgemisnupu hüpikaknas, mis on genereeritud lingitud meediumifaili jaoks';
$string['configmediaheight'] = 'Määrab hüpikakna kõrguse lingitud meediumifailide jaoks';
$string['configmediawidth'] = 'Määrab hüpikakna laiuse lingitud meediumifailide jaoks';
$string['configpassword_desc'] = 'Saate määrata, kas tunnile juurdepääsuks on vaja parooli.';
$string['configslideshowbgcolor'] = 'Taustavärv slaidiesitluste jaoks, kui see on lubatud';
$string['configslideshowheight'] = 'Määrab slaidiseansi kõrguse, kui see säte on lubatud';
$string['configslideshowwidth'] = 'Määrab slaidiseansi laius, kui see säte on lubatud';
$string['configtimelimit_desc'] = 'Kui ajapiirang on määratud, siis kuvatakse tunni alguses hoiatus koos taimeriga. Kui taimer on nullis, siis ajapiirang puudub.';
$string['confirmdelete'] = 'Kustuta leht';
$string['confirmdeletionofthispage'] = 'Kinnita selle lehe kustutamine';
$string['congratulations'] = 'Tunni lõpp. Palju õnne!';
$string['continue'] = 'Jätka';
$string['continuetoanswer'] = 'Jätkake vastuste muutmist.';
$string['continuetonextpage'] = 'Minge järgmisele lehele.';
$string['correctanswerjump'] = 'Õige vastuse hüpe';
$string['correctanswerscore'] = 'Õige vastuse punkstisumma';
$string['correctresponse'] = 'Reageering õigele vastusele';
$string['createaquestionpage'] = 'Küsimuselehe loomine';
$string['credit'] = 'Lisapunktid';
$string['customscoring'] = 'Kohandatud punktisumma';
$string['customscoring_help'] = 'Kui see säte on sisse lülitatud, siis annab iga vastus arvulisi punkte (positiivne või negatiivne).';
$string['deadline'] = 'Tähtaeg';
$string['defaultessayresponse'] = 'Teie esseed hindab kursuse õpetaja.';
$string['deleteallattempts'] = 'Kustuta kõik soorituskatsed';
$string['deletedefaults'] = 'Kustutatud {$a} x õppetunni vaikeseade';
$string['deletedpage'] = 'Leht kustutatud';
$string['deletepagenamed'] = 'Kustuta leht: {$a}';
$string['deleting'] = 'Kustutamine';
$string['deletingpage'] = 'Kustutamine – leht {$a}';
$string['dependencyon'] = 'Sõltub';
$string['dependencyon_help'] = 'Selle sätte puhul sõltub tunnile juurdepääs mõnest muust sama kursuse tunnist. Kasutada võib kõikvõimalikke sätete „Kulunud aeg“, „Lõpetatud“ ja „Hinne parem kui“ kombinatsioone.';
$string['description'] = 'Kirjeldus';
$string['deselectallattempts'] = 'Tühista kõigi katsete valik';
$string['detailedstats'] = 'Üksikasjalik statistika';
$string['didnotanswerquestion'] = 'Ei vastanud selle küsimusele.';
$string['didnotreceivecredit'] = 'Ei saanud lisapunkte';
$string['disabled'] = 'Keelatud';
$string['displaydefaultfeedback'] = 'Kasuta vaiketagasisidet';
$string['displaydefaultfeedback_help'] = 'Kui see säte on lubatud, siis juhul kui teatud küsimuse vastust ei leita, kuvatakse vaikevastus „Õige vastus“ või „Vale vastus“.';
$string['displayinleftmenu'] = 'Kas soovite kuvada menüüs?';
$string['displayleftif'] = 'Menüü kuvamiseks vajalik miinimumhinne';
$string['displayleftif_help'] = 'See säte määrab, kas õppija peab saama teatud hinde, enne kui talle kuvatakse tunni menüü. See sunnib õppija kogu tunni läbi tegema esimesel katsel ning seejärel, pärast nõutud hinde saamist, saab ta kasutada menüüd ülevaatamiseks.';
$string['displayleftmenu'] = 'Kuva menüü';
$string['displayleftmenu_help'] = 'Kui see säte on lubatud, kuvatakse menüü, mis võimaldab kasutajatel lehtede loendis navigeerida.';
$string['displayofgrade'] = 'Hinde kuvamine (ainult õppijatele)';
$string['displayreview'] = 'Paku võimalust küsimusele uuesti vastata';
$string['displayreview_help'] = 'Kui see säte on lubatud, siis küsimusele valesti vastamise korral saab õppija uuesti proovida (ilma lisapunktideta) või tunniga jätkata.';
$string['displayscorewithessays'] = '<p>Automaaatselt hinnatavate küsimuste eest saite {$a->score} punkti {$a->tempmaxgrade} võimalikust.</p>
<p>Teie {$a->essayquestions} esseeküsimus(t) hinnatakse ja lisatakse lõpptulemusele hiljem.</p>
<p>Teie praegune hinne ilma esseeküsimus(t)eta on {$a->score} punkti {$a->grade} võimalikust.</p>';
$string['displayscorewithoutessays'] = 'Teie punktisumma on {$a->score} ({$a->grade}-st)';
$string['duplicatepagenamed'] = 'Dubleeri leht: {$a}';
$string['edit'] = 'Muuda';
$string['editbranchtable'] = 'Sisulehe muutmine';
$string['editcluster'] = 'Küsimuste rühma muutmine';
$string['editendofbranch'] = 'Haru lõpulehe muutmine';
$string['editendofcluster'] = 'Küsimuste rühma lõpulehe muutmine';
$string['editessay'] = 'Essee tüüpi küsimuse lehe muutmine';
$string['editingquestionpage'] = 'Küsimuse lehe {$a} muutmine';
$string['editlessonsettings'] = 'Muuda tunni seadistust';
$string['editmatching'] = 'Vastavusse viimise tüüpi küsimuse lehe muutmine';
$string['editmultichoice'] = 'Valikvastustega küsimuse lehe muutmine';
$string['editnumerical'] = 'Arvuküsimuse lehe muutmine';
$string['editoverride'] = 'Testisätete ülekirjutuse muutmine';
$string['editpage'] = 'Muuda selle lehe sisu';
$string['editpagecontent'] = 'Muuda selle lehe sisu';
$string['editquestion'] = 'Küsimuse lehe muutmine';
$string['editshortanswer'] = 'Lühivastusega küsimuse lehe muutmine';
$string['edittruefalse'] = 'Tõene/väär-vastusega küsimuse lehe muutmine';
$string['email'] = 'Meiliaadress';
$string['emailallgradedessays'] = 'Saada KÕIK hinnatud esseed e-postiga';
$string['emailgradedessays'] = 'Saada hinnatud esseed e-postiga';
$string['emailsuccess'] = 'Meilisõnumid on nüüd saadetud';
$string['emptypassword'] = 'Parooli väli ei tohi olla tühi';
$string['enabled'] = 'Lubatud';
$string['endofbranch'] = 'Haru lõpp';
$string['endofcluster'] = 'Küsimuste rühma lõpp';
$string['endofclustertitle'] = 'Küsimuste rühma lõpp';
$string['endoflesson'] = 'Tunni lõpp';
$string['enteredthis'] = 'sisenes siia.';
$string['enterpassword'] = 'Palun sisestage parool:';
$string['eolstudentoutoftime'] = 'Tähelepanu! Selle tunni aeg on lõppenud. Teie viimane vastus ei pruukinud arvesse minna, kui sisestasite selle pärast aja lõppemist.';
$string['eolstudentoutoftimenoanswers'] = 'Te ei vastanud ühelegi küsimusele. Saite selle tunni hindeks 0.';
$string['essay'] = 'Essee';
$string['essayemailmessage2'] = '<p>Esseeküsimus: {$a->question}</p><p>Teie vastus: <em>{$a->response}</em></p><p>Hindaja kommentaarid: <em>{$a->comment}</em></p><p>Saite selle essee eest {$a->earned} punkti {$a->outof} võimalikust.</p><p>Teie selle tunni {$a->lesson} hinne on muudetud hindeks {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p> Oled selle essee küsimuse eest saanud {$a->earned} {$a->outof}-st.</p><p>Sinu õppetunni {$a->lesson} hinne on muudetud {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Tunni küsimus on hinnatud';
$string['essaynotgradedyet'] = 'Esseed ei ole veel hinnatud.';
$string['essayresponses'] = 'Esseevormis vastused';
$string['essays'] = 'Esseed';
$string['essayscore'] = 'Essee punktisumma';
$string['eventcontentpageviewed'] = 'Sisulehte vaadati';
$string['eventessayassessed'] = 'Esseed vaadati';
$string['eventessayattemptviewed'] = 'Esseekatset vaadati';
$string['eventhighscoreadded'] = 'Rekordpunktisumma lisati';
$string['eventhighscoresviewed'] = 'Rekordpunktisummasid vaadati';
$string['eventlessonended'] = 'Õppetükk lõppes';
$string['eventlessonrestarted'] = 'Õppetükki alustati uuesti';
$string['eventlessonresumed'] = 'Õppetükki jätkati';
$string['eventlessonstarted'] = 'Õppetükki alustati';
$string['eventoverridecreated'] = 'Õppetüki sätete ülekirjutus loodi';
$string['eventoverridedeleted'] = 'Õppetüki sätete ülekirjutus on kustutatud';
$string['eventoverrideupdated'] = 'Õppetüki sätete ülekirjutus värskendati';
$string['eventpagecreated'] = 'Leht loodi';
$string['eventpagedeleted'] = 'Leht on kustutatud';
$string['eventpagemoved'] = 'Leht teisaldati';
$string['eventpageupdated'] = 'Leht on värskendatud';
$string['eventquestionanswered'] = 'Küsimusele vastati';
$string['eventquestionviewed'] = 'Küsimust vaadati';
$string['false'] = 'Väär';
$string['fileformat'] = 'Failivorming';
$string['finalwrong'] = 'Mitte päris.';
$string['finish'] = 'Lõpeta';
$string['firstanswershould'] = 'Esimene vastus peaks viima õige vastuse hüppes määratud lehele';
$string['firstwrong'] = 'Vastasite valesti. Kas sooviksite küsimusele uuesti vastata? (Kui nüüd vastate õigesti, ei mõjuta see siiski teie lõplikku punktisummat.)';
$string['flowcontrol'] = 'Liikumise kontroll';
$string['fractionsaddwrong'] = 'Teie valitud positiivsete hinnete summa ei anna kokku 100%<br />See annab kokku hoopis {$a}%<br />Kas soovite minna tagasi ja parandada seda küsimust?';
$string['fractionsnomax'] = 'Üks vastustest peaks olema 100%, nii et selle küsimuse eest<br />oleks võimalik saada täishinne.<br />Kas soovite minna tagasi ja parandada seda küsimust?';
$string['full'] = 'Laiendatud';
$string['general'] = 'Üldine';
$string['gotoendoflesson'] = 'Mine tunni lõppu';
$string['grade'] = 'Hinne';
$string['gradebetterthan'] = 'Hinne parem kui (%)';
$string['gradebetterthanerror'] = 'Teeni hinne, mis on parem kui {$a} protsenti';
$string['graded'] = 'Hinnatud';
$string['gradeessay'] = 'Hinda esseeküsimusi ({$a->notgradedcount} hindamata tööd ja {$a->notsentcount} saatmata tööd)';
$string['gradeis'] = 'Hinne on {$a}';
$string['gradeoptions'] = 'Hindamisvalikud';
$string['groupoverrides'] = 'Rühma testisätete ülekirjutused';
$string['groupoverridesdeleted'] = 'Rühma testisätete ülekirjutused on kustutatud.';
$string['groupsnone'] = 'Sellel kursusel pole rühmi.';
$string['handlingofretakes'] = 'Uuesti tegemiste käsitlemine';
$string['handlingofretakes_help'] = 'Kui uuesti tegemine on lubatud, siis selle sättega määratakse, kas tunni hinne on kõigi soorituskatsete maksimum või keskmine.';
$string['havenotgradedyet'] = 'Pole veel hinnatud';
$string['here'] = 'siia';
$string['highscore'] = 'Suurim punktisumma';
$string['hightime'] = 'Lühim aeg';
$string['importcount'] = '{$a} küsimuse importimine';
$string['importquestions'] = 'Impordi küsimused';
$string['importquestions_help'] = 'See funktsioon võimaldab mitmesugustes vormingutes küsimusi importida tekstifailina.';
$string['inactiveoverridehelp'] = '* Õppija pole seotud ühegi sellise rühma või rolliga, millel on õigus õppetükki vaadata või sooritada.';
$string['indicator:cognitivedepth'] = 'Kognitiivne tund';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb tunnetuslikul sügavusel, mille õpilane õppetunni tegevuses saavutas.';
$string['indicator:cognitivedepthdef'] = 'Kognitiivne tund';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on selle analüüsi intervalli jooksul saavutanud selle tunnitegevuste pakutava kognitiivse seotuse protsendi (tasemed = vaadet pole, vaade, esitamine, tagasiside vaatamine, tagasiside kommenteerimine, uuesti esitamine pärast tagasiside vaatamist)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsiaalne tund';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel laiusel, mille õpilane õppetunnitegevuse käigus saavutas.';
$string['indicator:socialbreadthdef'] = 'Sotsiaalne tund';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsi intervalli jooksul saavutanud selle õppetundide pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osales üksi, osales koos teistega)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Sisestatud leht';
$string['invalidfile'] = 'Sobimatu fail';
$string['invalidid'] = 'Kursuse mooduli või tunni ID-d ei edastatud';
$string['invalidlessonid'] = 'Tunni ID oli vale';
$string['invalidoverrideid'] = 'Testisätete ülekirjutuse sobimatu ID';
$string['invalidpageid'] = 'Lehe ID ei sobi';
$string['jump'] = 'Hüpe';
$string['jumps'] = 'Hüpped';
$string['jumps_help'] = 'Igal vastusel (küsimuse kohta) või kirjeldusel (sisu lehtede kohta) on vastav hüpe. Hüpe saab olla suhteline (näiteks see leht või järgmine leht) või absoluutne (vastava tunni mis tahes leht).';
$string['jumpsto'] = 'Hüpe asukohta <em>{$a}</em>';
$string['leftduringtimed'] = 'Lahkusite ajapiiranguga tunnist.<br />Tunni uuesti alustamiseks klõpsake nuppu Jätka.';
$string['leftduringtimednoretake'] = 'Lahkusite ajapiiranguga tunnist ja teil<br />pole lubatud tundi jätkata või uuesti alustada.';
$string['leftduringtimedsession'] = 'Lahkusite ajapiiranguga tunnist.';
$string['lesson:addinstance'] = 'Lisa uus tund';
$string['lesson:edit'] = 'Muuda tunni tegevust';
$string['lesson:grade'] = 'Õppetüki esseevormis vastuste hindamine';
$string['lesson:manage'] = 'Halda tunni tegevust';
$string['lesson:manageoverrides'] = 'Õppetüki sätete ülekirjutuste haldus';
$string['lesson:view'] = 'Kuva tunnitegevus';
$string['lesson:viewreports'] = 'Kuva õppetüki aruanded';
$string['lessonclosed'] = 'See tund suleti {$a}.';
$string['lessoncloses'] = 'Tund suletakse';
$string['lessoneventcloses'] = '{$a} sulgub';
$string['lessoneventopens'] = '{$a} avaneb';
$string['lessonformating'] = 'Tunni vormindamine';
$string['lessonmenu'] = 'Tunni menüü';
$string['lessonnotready'] = 'See tund pole veel valmis. Palun pöördu $a poole.';
$string['lessonnotready2'] = 'See tund pole veel võtmiseks valmis.';
$string['lessonopen'] = 'See tund avatakse {$a}';
$string['lessonopens'] = 'Tund avatakse';
$string['lessonpagelinkingbroken'] = 'Ei leia esimest lehte. Tunni lehe link võib olla katki. Pöörduge administraatori poole.';
$string['lessonstats'] = 'Tunni statistika';
$string['linkedmedia'] = 'Lingitud meediumifail';
$string['loginfail'] = 'Sisselogimine nurjus, proovige uuesti';
$string['lowscore'] = 'Väikseim punktisumma';
$string['lowtime'] = 'Pikim aeg';
$string['manualgrading'] = 'Hinda esseevastuseid';
$string['matchesanswer'] = 'Vastab vastusele';
$string['matching'] = 'Vastavusse seadmine';
$string['matchingpair'] = 'Vastavuses olev paar {$a}';
$string['maxgrade'] = 'Maksimumhinne';
$string['maxgrade_help'] = 'Selle sättega määratakse selle tunni maksimumhinne. Kui selle sätte väärtus on 0, siis tundi hinnetelehtedel ei kuvata.';
$string['maximumnumberofanswersbranches'] = 'Vastuste maksimaalne arv';
$string['maximumnumberofanswersbranches_help'] = 'See säte määratleb tunnis kasutatavate vastuste maksimaalse lubatud hulga. Kui kasutatakse ainult õige/vale-küsimusi, võib selleks olla määratud 2. Seda sätet saab suvalisel ajal muuta, kuna see mõjutab ainult seda, mida õpetaja näeb, mitte andmeid.';
$string['maximumnumberofattempts'] = 'Katsete maksimumarv';
$string['maximumnumberofattempts_help'] = 'See säte määrab igale küsimusele katsete maksimaalse lubatud arvu. Kui vastati mitu korda valesti ja kordade piirarv sai täis, siis kuvatakse tunni järgmine leht.';
$string['maximumnumberofattemptsreached'] = 'Katsete maksimaalne lubatud arv on täis. Siirdumine järgmisele lehele';
$string['mediaclose'] = 'Kuva sulgemisnupp';
$string['mediafile'] = 'Lingitud meediumifail';
$string['mediafile_help'] = 'Tunnis kasutamiseks saab üles laadida meediumifaili. Sel juhul kuvatakse igal tunni lehel plokis nimega „Lingitud meediumifail“ link „Vaatamiseks klõpsake siin“.';
$string['mediafilepopup'] = 'Vaatamiseks klõpsake siin';
$string['mediaheight'] = 'Hüpikakna kõrgus';
$string['mediawidth'] = 'Hüpikakna laius';
$string['messageprovider:graded_essay'] = 'Hinnatud essee teavitus';
$string['minimumnumberofquestions'] = 'Küsimuste miinimumarv';
$string['minimumnumberofquestions_help'] = 'See säte määratleb tegevuse hinde arvutamiseks kasutatavate vastuste minimaalse hulga.';
$string['missingname'] = 'Sisestage hüüdnimi';
$string['modattempts'] = 'Luba õppijal tagasi minna';
$string['modattempts_help'] = 'Kui see säte on lubatud, siis saavad õppijad tundi uuesti sirvida alates algusest.';
$string['modattemptsnoteacher'] = 'Tagasiminek on lubatud ainult õppijate jaoks';
$string['modulename'] = 'Tund';
$string['modulename_help'] = 'Õppetüki tegevuste moodul aitab õpetajal esitada sisu ja/või viia läbi tegevusi huvitavalt ja paindlikult. Õpetaja saab tunni koostada järjestikustest sisulehtedest või suunavatest tegevustest, mis pakuvad õppijale eri õppeviise ja võimalusi. Mõlemal juhul saavad õpetajad sisu haaravamaks ja arusaadavamaks muutmiseks kasutada eri tüüpi küsimusi, nagu näiteks valikvastustega küsimused, vastavusse viimise ülesanded ja lühivastustega küsimused. Sõltuvalt õppija vastusest ja õpetaja määratud sätetest saavad õppijad järgmisele lehele edasi minna, jäävad eelmisele lehele või nad suunatakse ümber täiesti teist teed pidi.

Õppetükki saab hinnata ja hinne salvestatakse hinnetelehele.

Õppetükke saab kasutada näiteks järgmiseks:

* uute teemade õppimiseks ilma otsese juhendamiseta;
* konkreetsete stsenaariumide või simulatsioonide/otsustamisharjutuste läbimängimiseks;
* eri võimalustega testide koostamiseks, kus küsimused sõltuvad algsetest vastustest.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Tunnid';
$string['move'] = 'Teisalda leht';
$string['movedpage'] = 'Leht liigutatud';
$string['movepagehere'] = 'Teisalda leht siia';
$string['movepagenamed'] = 'Teisalda leht: {$a}';
$string['moving'] = 'Lehe teisaldamine: {$a}';
$string['multianswer'] = 'Mitmikvastus';
$string['multianswer_help'] = 'Märkige vastav ruut, kui õigeid vastuseid on rohkem kui üks';
$string['multichoice'] = 'Valikvastused';
$string['multipleanswer'] = 'Mitmikvalik';
$string['nameapproved'] = 'Nimi heaks kiidetud';
$string['namereject'] = 'Kahjuks lükkas filter teie nime tagasi.<br />Proovige mõnda muud nime.';
$string['new'] = 'uus';
$string['nextpage'] = 'Järgmine leht';
$string['noanswer'] = 'Vähemalt ühele küsimusele pole vastust antud. Palun minge tagasi ja esitage vastus.';
$string['noattemptrecordsfound'] = 'Katsete kohta puuduvad andmed: hinnet ei antud';
$string['nobranchtablefound'] = 'Sisulehte ei leitud';
$string['noclose'] = 'Sulgemiskuupäeva pole';
$string['nocommentyet'] = 'Kommentaare veel pole.';
$string['nocoursemods'] = 'Tegevusi pole';
$string['nocredit'] = 'Lisapunkte veel pole';
$string['nodeadline'] = 'Tähtaega pole';
$string['noessayquestionsfound'] = 'Sellest tunnist essee tüüpi küsimusi ei leitud.';
$string['nohighscores'] = 'Edetabeleid pole';
$string['nolessonattempts'] = 'Selle tunni kohta pole veel ühtegi soorituskatset.';
$string['nolessonattemptsgroup'] = 'Rühma {$a} liikmed pole selles õppetükis ühtegi soorituskatset teinud.';
$string['none'] = 'Pole';
$string['nooneansweredcorrectly'] = 'Mitte keegi ei vastanud õigesti.';
$string['nooneansweredthisquestion'] = 'Mitte keegi vastanud sellele küsimusele.';
$string['noonecheckedthis'] = 'Mitte keegi pole seda kontrollinud.';
$string['nooneenteredthis'] = 'Mitte keegi ei sisenenud siia.';
$string['noonehasanswered'] = 'Mitte keegi pole veel esseevastust esitanud.';
$string['noonehasansweredgroup'] = 'Ükski rühma {$a} liige pole esseeküsimusele veel vastanud.';
$string['noopen'] = 'Avamiskuupäeva pole';
$string['nooverridedata'] = 'Peate üle kirjutama vähemalt ühe õppetükisätte.';
$string['noretake'] = 'Seda tundi ei saa uuesti teha.';
$string['normal'] = 'Tavaline – järgige tunni kava';
$string['notcompleted'] = 'Lõpetamata';
$string['notcompletedwithdate'] = 'Ei ole valmis ({$a})';
$string['notdefined'] = 'Määratlemata';
$string['notenoughsubquestions'] = 'Määratletud on liiga vähe alamküsimusi.';
$string['notenoughtimespent'] = 'Selle õppetüki läbimiseks kulus {$a->timespent}, mis on lühem kui nõutav aeg {$a->timerequired}. Võimalik, et peate uuesti proovima.';
$string['notgraded'] = 'Hindamata';
$string['notitle'] = 'Pealkirjata';
$string['notyetcompleted'] = 'Õppetükki on alustatud, aga see pole veel läbitud.';
$string['numberofcorrectanswers'] = 'Õigete vastuste arv: {$a}';
$string['numberofcorrectanswersheader'] = 'Õigete vastuste arv';
$string['numberofcorrectmatches'] = 'Õigete paaride arv: {$a}';
$string['numberofpagestoshow'] = 'Kuvatavate lehtede arv';
$string['numberofpagestoshow_help'] = 'Selle sättega määratakse tunnis kuvatavate lehtede arv. Seda saab rakendada üksnes selliste tundide korral, mis on juhujärjestuses (kui sätte „Tegevus pärast õiget vastust“ väärtuseks on „Kuva veel vaatamata leht“ või „Kuva veel vastamata leht“). Kui määratud on null, siis kuvatakse kõik lehed.';
$string['numberofpagesviewed'] = 'Vastatud küsimuste arv: {$a}';
$string['numberofpagesviewedheader'] = 'Vastatud küsimuste arv';
$string['numberofpagesviewednotice'] = 'Vastatud küsimuste arv: {$a->nquestions} (Peaksite vastama vähemalt {$a->minquestions} küsimusele.)';
$string['numerical'] = 'Arvuline';
$string['numericanswer'] = 'Numbriline vastus';
$string['numericanswer_help'] = 'Kooloniga saad määrata ühe numbri või arvude vahemiku. Näiteks 2: 5 tähendab, et iga vastus vahemikus 2 kuni 5, sealhulgas 2 ja 5, on õige.';
$string['offlinedatamessage'] = 'Olete tegelenud selle soorituskatsega mobiilseadmest. Sellesse õpikeskkonda salvestati andmeid viimati {$a} tagasi. Kontrollige, kas kogu teie töö on salvestatud.';
$string['ongoing'] = 'Kuva jooksev punktisumma';
$string['ongoing_help'] = 'Kui see säte on lubatud, siis saab igal lehel näha, kui palju punkte maksimumist on õppija praeguseks saanud.';
$string['ongoingcustom'] = 'Olete saanud {$a->score} punkti võimalikust {$a->currenthigh} punktist.';
$string['ongoingnormal'] = 'Olete vastanud õigesti {$a->correct} küsimusele (kokku {$a->viewed} küsimust).';
$string['onpostperpage'] = 'Ainult üks postitus hinde kohta';
$string['openafterclose'] = 'Oled määranud pärast sulgemiskuupäeva avatud kuupäeva';
$string['options'] = 'Valikud';
$string['or'] = 'VÕI';
$string['ordered'] = 'Järjestatud';
$string['other'] = 'Muu';
$string['outof'] = 'Koguarvust {$a}';
$string['override'] = 'Kirjuta üle';
$string['overridedeletegroupsure'] = 'Kas soovite kindlasti kustutada rühma {$a} testisätete ülekirjutuse?';
$string['overridedeleteusersure'] = 'Kas soovite kindlasti kustutada kasutaja {$a} testisätete ülekirjutuse?';
$string['overridegroup'] = 'Kirjuta selle rühma sätted üle';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Sätete ülekirjutused';
$string['overrideuser'] = 'Kirjuta selle kasutaja sätted üle';
$string['overrideusereventname'] = '{$a->lesson} - kirjuta üle';
$string['overview'] = 'Ülevaade';
$string['overview_help'] = 'Tund koosneb mitmest lehest ja valikuliselt ka sisulehtedest. Leht sisaldab mingit sisu ja lõpeb tavaliselt küsimusega. Iga vastusega määratud küsimus on hüpe. Hüpe saab olla suhteline (näiteks see leht või järgmine leht) või absoluutne (vastava tunni mis tahes leht). Sisuleht on leht, mis sisaldab linke tunni muudele lehtedele (nt sisukorralehele).';
$string['page'] = 'Leht: {$a}';
$string['page-mod-lesson-edit'] = 'Muuda tunni lehte';
$string['page-mod-lesson-view'] = 'Kuva tunni leht või selle eelvaade';
$string['page-mod-lesson-x'] = 'Mis tahes tunni leht';
$string['pageanswers'] = 'Lehel olevad vastused';
$string['pagecontents'] = 'Lehe sisu';
$string['pageresponses'] = 'Lehel antud vastused';
$string['pages'] = 'Lehti';
$string['pagetitle'] = 'Lehe pealkiri';
$string['password'] = 'Parool';
$string['passwordprotectedlesson'] = '{$a} on parooliga kaitstud tund.';
$string['pleasecheckoneanswer'] = 'Valige üks vastus';
$string['pleasecheckoneormoreanswers'] = 'Valige üks või rohkem vastust';
$string['pleaseenteryouranswerinthebox'] = 'Sisestage oma vastus sellele väljale';
$string['pleasematchtheabovepairs'] = 'Vastendage ülalolevad paarid';
$string['pluginadministration'] = 'Tunni haldus';
$string['pluginname'] = 'Tund';
$string['pointsearned'] = 'Teenitud punktid';
$string['postprocesserror'] = 'Järeltöötluse ajal ilmnes tõrge.';
$string['postsuccess'] = 'Postitatud.';
$string['practice'] = 'Harjutustund';
$string['practice_help'] = 'Harjutustundi hinnetelehel ei kuvata.';
$string['preprocesserror'] = 'Eeltöötluse ajal ilmnes tõrge.';
$string['prerequisiteisobsolete'] = 'Eeldustunni valik tuleb eemaldada. Kasutage selle asemel juurdepääsupiiranguid.';
$string['prerequisitelesson'] = 'Eeldustund';
$string['preview'] = 'Eelvaade';
$string['previewlesson'] = '{$a} – eelvaade';
$string['previewpagenamed'] = 'Lehe eelvaade: {$a}';
$string['previouspage'] = 'Eelmine leht';
$string['privacy:metadata:attempts'] = 'Leheküljekatsete register';
$string['privacy:metadata:attempts:answerid'] = 'Vastuse ID';
$string['privacy:metadata:attempts:correct'] = 'Kas katse oli õige';
$string['privacy:metadata:attempts:pageid'] = 'Lehe ID';
$string['privacy:metadata:attempts:retry'] = 'Katse number';
$string['privacy:metadata:attempts:timeseen'] = 'Katse tegemise aeg';
$string['privacy:metadata:attempts:useranswer'] = 'Detailid kasutaja vastuse kohta';
$string['privacy:metadata:attempts:userid'] = 'Kasutaja ID';
$string['privacy:metadata:branch'] = 'Ülevaade vaadatud lehtedest';
$string['privacy:metadata:branch:flag'] = 'Kas järgmine leht arvutati juhuslikult';
$string['privacy:metadata:branch:nextpageid'] = 'Järgmise lehe ID';
$string['privacy:metadata:branch:pageid'] = 'Lehe ID';
$string['privacy:metadata:branch:retry'] = 'Katse number';
$string['privacy:metadata:branch:timeseen'] = 'Lehe vaatamise aeg';
$string['privacy:metadata:branch:userid'] = 'Kasutaja ID';
$string['privacy:metadata:grades'] = 'Iga tunni hinnete arvestus';
$string['privacy:metadata:grades:completed'] = 'Hinde andmise kuupäev';
$string['privacy:metadata:grades:grade'] = 'Antud hinne';
$string['privacy:metadata:grades:userid'] = 'Kasutaja ID';
$string['privacy:metadata:overrides'] = 'Ülekirjutuste arvestus tunni kohta';
$string['privacy:metadata:overrides:available'] = 'Aeg, millal õppetundi võidakse proovida';
$string['privacy:metadata:overrides:deadline'] = 'Tunni läbimise tähtaeg.';
$string['privacy:metadata:overrides:maxattempts'] = 'Katste maksimumarv';
$string['privacy:metadata:overrides:password'] = 'Tunni ligipääsu salasõna';
$string['privacy:metadata:overrides:retake'] = 'Kas uued katsed on lubatud';
$string['privacy:metadata:overrides:review'] = 'Kas küsimuse uus proovimine on lubatud';
$string['privacy:metadata:overrides:timelimit'] = 'Ajalimiit tunni läbimiseks, sekundites.';
$string['privacy:metadata:overrides:userid'] = 'Kasutaja ID';
$string['privacy:metadata:timer'] = 'Tunni katse protokoll';
$string['privacy:metadata:timer:completed'] = 'Kas katse lõpetati';
$string['privacy:metadata:timer:lessontime'] = 'Viimane moment kui me salvestasime tegevuse';
$string['privacy:metadata:timer:starttime'] = 'Katse alustamise kuupäev';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Viimane hetk, kui me mobiilirakendusest tegevust salvestasime';
$string['privacy:metadata:timer:userid'] = 'kasutaja ID';
$string['privacy:metadata:userpref:lessonview'] = 'Eelistatud kuvarežiim õppetundide muutmisel';
$string['privacy:path:essayanswers'] = 'Essee vastused';
$string['privacy:path:essayresponses'] = 'Essee vastused';
$string['privacy:path:pages'] = 'Lehed';
$string['processerror'] = 'Töötluse ajal ilmnes tõrge.';
$string['progressbar'] = 'Edenemisriba';
$string['progressbar_help'] = 'Kui see säte on lubatud, siis kuvatakse tunni lehtede allservas hinnanguline lõpetatusprotsent.';
$string['progressbarteacherwarning'] = '$a ei näe prograssiriba';
$string['progressbarteacherwarning2'] = 'Edenemisriba ei kuvata, sest te saate seda tundi muuta';
$string['progresscompleted'] = 'Olete tunnist edukalt läbinud {$a}%';
$string['qtype'] = 'Lehe tüüp';
$string['question'] = 'Küsimus';
$string['questionoption'] = 'Küsimuse valik';
$string['questiontype'] = 'Küsimuse tüüp';
$string['randombranch'] = 'Juhuslik sisuleht';
$string['randompageinbranch'] = 'Juhuslik küsimus sisulehelt';
$string['rank'] = 'Võrdlus teistega';
$string['rawgrade'] = 'Töötlemata hinne';
$string['receivedcredit'] = 'Saadud lisapunktid';
$string['redisplaypage'] = 'Uuenda leht';
$string['removeallgroupoverrides'] = 'Kustuta kõik rühma testisätete ülekirjutused.';
$string['removealluseroverrides'] = 'Kustuta kõik kasutaja testisätete ülekirjutused.';
$string['report'] = 'Aruanne';
$string['reports'] = 'Aruanded';
$string['response'] = 'Reageering';
$string['retakesallowed'] = 'Uuesti võtmine lubatud';
$string['retakesallowed_help'] = 'Kui see säte on lubatud, siis on selle tunni puhul lubatud rohkem kui üks soorituskatse.';
$string['returnto'] = 'Tagasi {$a}';
$string['returntocourse'] = 'Tagasi kursusele';
$string['reverttodefaults'] = 'Ennista õppetüki vaikesätted';
$string['review'] = 'Läbivaatus';
$string['reviewlesson'] = 'Vaata tund läbi';
$string['reviewquestionback'] = 'Jah, ma sooviksin uuesti proovida';
$string['reviewquestioncontinue'] = 'Ei, soovin minna järgmise küsimuse juurde';
$string['sanitycheckfailed'] = 'Mõistlikkuse kontroll kukkus läbi: See katse on kustutatud.';
$string['save'] = 'Salvesta';
$string['savechanges'] = 'Salvesta muudatused';
$string['savechangesandeol'] = 'Saate kõik muudatused salvestada ja minna tunni lõppu.';
$string['saveoverrideandstay'] = 'Salvesta ja sisesta veel üks ülekirjutus';
$string['savepage'] = 'Salvesta leht';
$string['score'] = 'Punktisumma';
$string['score_help'] = 'Punktisummat kasutatakse ainult siis, kui kohandatud punktiarvestus on lubatud. Sel juhul saab igale vastusele määrata arvulise punktiväärtuse (positiivne või negatiivne).';
$string['scores'] = 'Punktisummad';
$string['search:activity'] = 'Tund – tegevuse teave';
$string['secondpluswrong'] = 'Mitte päris õige. Kas sooviksite uuesti proovida?';
$string['selectallattempts'] = 'Vali kõik katsed';
$string['selectaqtype'] = 'Valige küsimuse tüüp';
$string['sent'] = 'Saadetud';
$string['shortanswer'] = 'Lühivastus';
$string['showanunansweredpage'] = 'Kuva veel vastamata leht';
$string['showanunseenpage'] = 'Kuva veel vaatamata leht';
$string['singleanswer'] = 'Üksikvastus';
$string['skip'] = 'Jäta vahele';
$string['slideshow'] = 'Slaidiseanss';
$string['slideshow_help'] = 'Kui see säte on lubatud, siis kuvatakse tund slaidiseansina (kindla laiuse ja kõrgusega).';
$string['slideshowbgcolor'] = 'Slaidiseansi taustavärv';
$string['slideshowheight'] = 'Slaidiseansi kõrgus';
$string['slideshowwidth'] = 'Slaidiseansi laius';
$string['startlesson'] = 'Alusta tundi';
$string['studentattemptlesson'] = '{$a->firstname} {$a->lastname} – katse number {$a->attempt}';
$string['studentname'] = '{$a} nimi';
$string['studentoneminwarning'] = 'Hoiatus. Tunni lõpetamiseks on 1 minut või vähem aega.';
$string['studentoutoftimeforreview'] = 'Tähelepanu! Selle tunni ülevaatamiseks ette nähtud aeg on otsa saanud';
$string['studentresponse'] = 'Õppija {$a} reageering';
$string['submit'] = 'Esita';
$string['submitname'] = 'Esita nimi';
$string['teacherjumpwarning'] = 'Selles tunnis on kasutusel hüpe {$a->cluster} või {$a->unseen}. Selle asemel kasutatakse hüpet järgmisele lehele. Nende hüpete testimiseks logige sisse õppijana.';
$string['teacherongoingwarning'] = 'Jooksev punktisumma kuvatakse ainult õppijale. Jooksva punktisumma testimiseks logige sisse õppijana.';
$string['teachertimerwarning'] = 'Taimer töötab ainult õppijate jaoks. Taimeri katsetamiseks logige sisse õppijana.';
$string['thatsthecorrectanswer'] = 'Õige vastus';
$string['thatsthewronganswer'] = 'Vale vastus';
$string['thefollowingpagesjumptothispage'] = 'Järgmised lehed viivad siia';
$string['thispage'] = 'See leht';
$string['timeisup'] = 'Aeg on läbi.';
$string['timelimit'] = 'Ajapiirang';
$string['timelimit_help'] = 'Kui ajapiirang on määratud, kuvatakse tunni alguses hoiatus koos taimeriga. Pärast etteantud aja möödumist antud vastuseid ei hinnata.';
$string['timelimitwarning'] = 'Teil on {$a} selle õppetüki lõpetamiseks.';
$string['timeremaining'] = 'Aega on jäänud';
$string['timespenterror'] = 'Kulutage selles tunnis vähemalt {$a} minutit';
$string['timespentminutes'] = 'Kulunud aeg (minutites)';
$string['timetaken'] = 'Aega kulus';
$string['totalpagesviewedheader'] = 'Vaadatud lehtede arv';
$string['true'] = 'Tõene';
$string['truefalse'] = 'Tõene/väär';
$string['unabledtosavefile'] = 'Üleslaaditud faili ei saanud salvestada';
$string['unknownqtypesnotimported'] = 'Importimata jäi {$a} küsimust, mille küsimusetüüpi ei toetata';
$string['unseenpageinbranch'] = 'Veel vaatamata küsimus sisulehel';
$string['unsupportedqtype'] = 'Mittetoetatud küsimusetüüp ({$a})!';
$string['updatedpage'] = 'Leht värskendatud';
$string['updatefailed'] = 'Värskendamine ebaõnnestus';
$string['updatepagenamed'] = 'Värskenda lehte: {$a}';
$string['usemaximum'] = 'Kasuta maksimumi';
$string['usemean'] = 'Kasuta keskmist';
$string['usepassword'] = 'Parooliga kaitstud tund';
$string['usepassword_help'] = 'Kui see säte on lubatud, siis on tunnile juurdepääsuks vaja parooli.';
$string['useroverrides'] = 'Kasutaja testisätete ülekirjutused';
$string['useroverridesdeleted'] = 'Kasutaja testisätete ülekirjutused on kustutatud.';
$string['usersnone'] = 'Ükski õppija ei pääse sellele õppetükile juurde.';
$string['viewessayanswers'] = 'Kuva essee vastused';
$string['viewgrades'] = 'Vaata hindeid';
$string['viewreports'] = 'Kuva {$a->student} {$a->attempts} lõpetatud soorituskatset';
$string['viewreports2'] = 'Kuva {$a} lõpetatud katsed';
$string['warning'] = 'Hoiatus.';
$string['welldone'] = 'Tubli!';
$string['whatdofirst'] = 'Mida sooviksite esmalt teha?';
$string['withselectedattempts'] = 'Koos valitud katsetega...';
$string['wronganswerjump'] = 'Vale vastuse hüpe';
$string['wronganswerscore'] = 'Vale vastuse punktisumma';
$string['wrongresponse'] = 'Reageering valele vastusele';
$string['youhaveseen'] = 'Olete näinud juba rohkem kui ühte selle tunni lehte.<br />Kas soovite alustada viimasest nähtud lehest?';
$string['youranswer'] = 'Teie vastus';
$string['yourcurrentgradeis'] = 'Sinu praegune hinne on {$a}';
$string['yourcurrentgradeisoutof'] = 'Teie praegune tulemus on {$a->grade} (maksimum: {$a->total})';
$string['youshouldview'] = 'Peaksite vastama vähemalt: {$a}';
