<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'el', version '4.3'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Διαγραφή δραστηριότητας σε εξέλιξη...';
$string['agedigitalconsentmapinvalidage'] = 'Η «{$a}» δεν είναι έγκυρη τιμή για την ηλικία.';
$string['agedigitalconsentmapinvalidcomma'] = 'Το «{$a}» έχει περισσότερα ή λιγότερα από ένα διαχωριστικό κόμμα.';
$string['agedigitalconsentmapinvalidcountry'] = 'Η «{$a}» δεν είναι έγκυρη τιμή για την χώρα.';
$string['agedigitalconsentmapinvaliddefault'] = 'Η προεπιλεγμένη (*) τιμή λείπει.';
$string['agelocationverificationdisabled'] = 'Η επαλήθευση ηλικίας και τοποθεσίας έχει απενεργοποιηθεί';
$string['alreadyloggedin'] = 'Έχετε ήδη συνδεθεί ως {$a}. Πρέπει να αποσυνδεθείτε πρώτα, για να συνδεθείτε ως ένας διαφορετικός χρήστης.';
$string['authnotexisting'] = 'Το πρόσθετο εξουσιοδότησης δεν υπάρχει';
$string['backupcontainexternal'] = 'Αυτό το αντίγραφο ασφαλείας περιέχει εξωτερικούς Moodle Network Hosts που δεν είναι ρυθμισμένοι τοπικά';
$string['backuptablefail'] = 'Οι πίνακες αντιγράφων ασφαλείας ΔΕΝ έχουν στηθεί σωστά!';
$string['blockcannotconfig'] = 'Αυτό το μπλοκ δεν υποστηρίζει γενικές ρυθμίσεις';
$string['blockcannotinistantiate'] = 'Πρόβλημα κατά την υλοποίηση αντικειμένου μπλοκ';
$string['blockcannotread'] = 'Δεν ήταν δυνατή η ανάγνωση δεδομένων για το blockid= {$a}';
$string['blockdoesnotexist'] = 'Αυτό το μπλοκ δεν υπάρχει';
$string['blockdoesnotexistonpage'] = 'Αυτό το μπλοκ (αναγνωριστικό={$a->instanceid}) δεν υπάρχει σε αυτή τη σελίδα ({$a->url}).';
$string['blocknameconflict'] = 'Σύγκρουση ονοματοδοσίας: το μπλοκ {$a->name} έχει τον ίδιο τίτλο με ένα υπάρχον μπλοκ: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Η επανάκληση σχολίου απέρριψε αυτό το σχόλιο.';
$string['cannotaddcoursemodule'] = 'Δεν ήταν δυνατή η προσθήκη νέου αρθρώματος μαθήματος';
$string['cannotaddcoursemoduletosection'] = 'Δεν ήταν δυνατή η προσθήκη νέου αρθρώματος μαθήματος σε αυτή την ενότητα';
$string['cannotaddmodule'] = 'Δεν ήταν δυνατή η προσθήκη του αρθρώματος {$a} στη λίστα αρθρωμάτων!';
$string['cannotaddnewmodule'] = 'Δεν ήταν δυνατή η προσθήκη νέου αρθρώματος {$a}';
$string['cannotaddrss'] = 'Δεν έχετε δικαίωμα να προσθέσετε τροφοδοσίες RSS';
$string['cannotaddthisblocktype'] = 'Δεν μπορείτε να προσθέσετε ένα {$a} μπλοκ σε αυτήν τη σελίδα.';
$string['cannotassignrole'] = 'Αδυναμία ανάθεσης ρόλου στο μάθημα';
$string['cannotassignrolehere'] = 'Δεν επιτρέπεται να αναθέσετε το ρο αυτόν (id = {$a->roleid}) σε αυτό το πλαίσιο ({$a->context})';
$string['cannotassignselfasparent'] = 'Αδυναμία ανάθεσης ρόλου ως γονέα!';
$string['cannotcallscript'] = 'Δεν μπορείτε να καλέστε αυτό το script με αυτόν τον τρόπο';
$string['cannotcallusgetselecteduser'] = 'Δεν μπορείτε να καλέσετε το user_selector::get_selected_user εάν η επιλογή multiselect είναι επιλεγμένη.';
$string['cannotcreatebackupdir'] = 'Αποτυχία δημιουργίας φακέλου backupdata. Ο διαχειριστής του ιστοτόπου πρέπει να ρυθμίσει τα δικαιώματα αρχείων.';
$string['cannotcreatecategory'] = 'Η κατηγορία δεν εισήχθη';
$string['cannotcreatedboninstall'] = '<p>Αδυναμία δημιουργίας βάσης δεδομένων.</p><p>Η βάση δεδομένων που προσδιορίστηκε δεν υπάρχει και ο χρήστης που δόθηκε δεν έχει δικαίωμα να δημιουργήσει την βάση δεδομένων.</p><p>Ο διαχειριστής του ιστοτόπου πρέπει να επαληθεύσει τις ρυθμίσεις της βάσης δεδομένων.</p>';
$string['cannotcreategroup'] = 'Σφάλμα κατά τη δημιουργία νέας ομάδας';
$string['cannotcreatelangbase'] = 'Σφάλμα: Δεν ήταν δυνατή η δημιουργία φακέλου βασικής γλώσσας';
$string['cannotcreatelangdir'] = 'Δε δημιουργήθηκε φάκελος γλώσσας.';
$string['cannotcreateorfindstructs'] = 'Σφάλμα κατά την εύρεση ή δημιουργία δομών ενοτήτων για αυτό το μάθημα';
$string['cannotcreatepopupwin'] = 'Μη ορισμένο στοιχείο - αποτυχία δημιουργίας αναδυόμενου παραθύρου';
$string['cannotcreatesitedir'] = 'Αποτυχία δημιουργίας φακέλου ιστοτόπου. Ο διαχειριστής του ιστοτόπου πρέπει να ρυθμίσει τα δικαιώματα αρχείων.';
$string['cannotcreatetempdir'] = 'Αδυναμία δημιουργίας προσωρινού φακέλου';
$string['cannotcreateuploaddir'] = 'Αποτυχία δημιουργίας φακέλου ανεβασμένων. Ο διαχειριστής του ιστοτόπου πρέπει να ρυθμίσει τα δικαιώματα αρχείων.';
$string['cannotcustomisefiltersblockuser'] = 'Δεν μπορείτε να προσαρμόσετε τις ρυθμίσεις των φίλτρων σε περιβάλλοντα χρήστη ή μπλοκ.';
$string['cannotdeletebackupids'] = 'Αποτυχία διαγραφής id προηγούμενων αντιγράφων ασφαλείας';
$string['cannotdeletecategorycourse'] = 'Η διαγραφή του μαθήματος «{$a}» απέτυχε.';
$string['cannotdeletecategoryquestions'] = 'Δεν ήταν δυνατή η διαγραφή ερωτήσεων από την κατηγορία «{$a}»';
$string['cannotdeletecourse'] = 'Δεν έχετε τα δικαιώματα να σβήσετε αυτό το μάθημα';
$string['cannotdeletecustomfield'] = 'Σφάλμα κατά τη διαγραφή δεδομένων προσαρμοσμένων πεδίων';
$string['cannotdeletedir'] = 'Αδυναμία διαγραφής ({$a})';
$string['cannotdeletefile'] = 'Δεν είναι δυνατή η διαγραφή αυτού του αρχείου';
$string['cannotdeleterole'] = 'Δεν μπορεί να διαγραφεί επειδή {$a}';
$string['cannotdeleterolewithid'] = 'Δεν ήταν δυνατή η διαγραφή ρόλου με αναγνωριστικό {$a}';
$string['cannotdeletethisrole'] = 'Δεν μπορείτε να διαγράψετε αυτόν το ρόλο επειδή χρησιμοποιείται από το σύστημα ή επειδή είναι ο τελευταίος ρόλος με δυνατότητες διαχειριστή.';
$string['cannotdisableformat'] = 'Ο προεπιλεγμένος μορφότυπος δεν μπορεί να απενεργοποιηθεί.';
$string['cannotdownloadcomponents'] = 'Δεν μπορεί να γίνει λήψη των στοιχείων λογισμικού';
$string['cannotdownloadlanguageupdatelist'] = 'Αδυναμία λήψης λίστας ανανεωμένων γλωσσικών πακέτων από το download.moodle.org';
$string['cannotdownloadzipfile'] = 'Δεν μπορεί να γίνει λήψη του αρχείου ZIP.';
$string['cannoteditcomment'] = 'Αυτό το σχόλιο δεν είναι δικό σας για να το επεξεργαστείτε!';
$string['cannoteditcommentexpired'] = 'Δεν μπορείτε να το επεξεργαστείτε. Ο χρόνος έχει λήξει!';
$string['cannoteditpostorblog'] = 'Δεν μπορείτε να κάνετε ανάρτηση ή επεξεργασία σε ιστολόγια';
$string['cannoteditsiteform'] = 'Δεν μπορείτε να επεξεργαστείτε το μάθημα ιστοτόπου χρησιμοποιώντας αυτή τη φόρμα';
$string['cannotedituserpreferences'] = 'Δεν είναι δυνατή η επεξεργασία των προτιμήσεων αυτού του χρήστη';
$string['cannotedityourprofile'] = 'Λυπούμαστε, δεν μπορείτε να επεξεργαστείτε το προφίλ σας';
$string['cannotexecduringupgrade'] = 'Δεν μπορεί να εκτελεστεί κατά την αναβάθμιση';
$string['cannotfindcategory'] = 'Αδυναμία εύρεσης εγγραφής κατηγορίας από τη βάση δεδομένων με ID - {$a}';
$string['cannotfindcomponent'] = 'Δεν βρέθηκε το στοιχείο λογισμικού.';
$string['cannotfindcontext'] = 'Δεν ήταν δυνατή η εύρεση πλαισίου';
$string['cannotfindcourse'] = 'Αδυναμία εύρεσης μαθήματος';
$string['cannotfinddocs'] = 'Αδυναμία εύρεσης αρχείων docs της γλώσσας «{$a}»';
$string['cannotfindgradeitem'] = 'Αδυναμία εύρεσης grade_item';
$string['cannotfindgroup'] = 'Αδυναμία εύρεσης ομάδας';
$string['cannotfindhelp'] = 'Αδυναμία εύρεσης αρχείων βοήθειας για τη γλώσσα «{$a}»';
$string['cannotfindinfo'] = 'Αδυναμία εύρεσης πληροφοριών για: «{$a}»';
$string['cannotfindlang'] = 'Αδυναμία εύρεσης πακέτου γλώσσας «{$a}»!';
$string['cannotfindteacher'] = 'Αδυναμία εύρεσης διδάσκοντα';
$string['cannotfinduser'] = 'Αδυναμία εύρεσης χρήστη με όνομα «{$a}»';
$string['cannotgeoplugin'] = 'Δεν είναι δυνατή η σύνδεση με τον εξυπηρετητή geoPlugin στη διεύθυνση https://www.geoplugin.com. Παρακαλούμε, να ελέγξετε τις ρυθμίσεις διακομιστή μεσολάβησης ή να εγκαταστήσετε το αρχείο δεδομένων MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Δεν ήταν δυνατή η ανάκτηση μπλοκ από τη βάση δεδομένων';
$string['cannotgetcats'] = 'Αδυναμία ανάκτησης εγγραφής κατηγορίας';
$string['cannotgetdata'] = 'Αδυναμία λήψης δεδομένων';
$string['cannotgradeuser'] = 'Αδυναμία βαθμολογίας αυτού του χρήστη';
$string['cannothaveparentcate'] = 'Η κατηγορία μαθήματος δεν μπορεί να έχει γονέα!';
$string['cannotimport'] = 'Σφάλμα εισαγωγής';
$string['cannotimportformat'] = 'Λυπούμαστε, η εισαγωγή αυτού του μορφότυπου δεν έχει υλοποιηθεί ακόμη!';
$string['cannotimportgrade'] = 'Σφάλμα εισαγωγής βαθμών';
$string['cannotinsertgrade'] = 'Αδυναμία εισαγωγής στοιχείου βαθμού χωρίς το αναγνωριστικό (id) του μαθήματος!';
$string['cannotinsertrate'] = 'Δεν ήταν δυνατή η εισαγωγή μιας νέας ταξινόμησης ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Δεν ήταν δυνατή η εισαγωγή νέας εγγραφής με αναγνωριστικό {$a}';
$string['cannotmailconfirm'] = 'Σφάλμα κατά την αποστολή μηνύματος ηλε.ταχυδρομείου για επιβεβαίωση αλλαγής κωδικού πρόσβασης';
$string['cannotmanualctrack'] = 'Η δραστηριότητα δεν παρέχει χειροκίνητο εντοπισμό ολοκλήρωσης';
$string['cannotmapfield'] = 'Ανιχνεύτηκε σύγκρουση στην αντιστοίχιση - δύο πεδία αναφέρονται στο ίδιο στοιχείο βαθμού {$a}';
$string['cannotmarktopic'] = 'Δεν ήταν δυνατή η βαθμολόγηση αυτού του θέματος για αυτό το μάθημα';
$string['cannotmigratedatacomments'] = 'Δεν είναι δυνατή η μετεγκατάσταση (μεταφορά/μετατροπή)
 σχολίων αρθρώματος δεδομένων';
$string['cannotmodulename'] = 'Αδυναμία ανάκτησης ονόματος αρθρώματος στην κατασκευή της πλοήγησης';
$string['cannotmoduletype'] = 'Αδυναμία ανάκτησης τύπου αρθρώματος στην κατασκευή της πλοήγησης';
$string['cannotmovecategory'] = 'Δεν μπορεί να μεταφερθεί η κατηγορία';
$string['cannotmovecourses'] = 'Δεν μπορεί να μεταφερθεί μάθημα από την κατηγορία του σε άλλη.';
$string['cannotmoverolewithid'] = 'Αδυναμία μετακίνησης ρόλου με ID {$a}';
$string['cannotopencsv'] = 'Αδυναμία ανοίγματος αρχείου CSV';
$string['cannotopenfile'] = 'Αδυναμία ανοίγματος αρχείου ({$a})';
$string['cannotopenforwrit'] = 'Αδυναμία ανοίγματος για εγγραφή: {$a}';
$string['cannotopentemplate'] = 'Αδυναμία ανοίγματος αρχείου υποδείγματος ({$a})';
$string['cannotopenzip'] = 'Αδυναμία ανοίγματος αρχείου zip, πιθανώς λόγω σφάλματος επέκτασης zip σε λειτουργικό σύστημα 64-bit.';
$string['cannotoverridebaserole'] = 'Αδυναμία παράκαμψης δυνατοτήτων βασικού ρόλου';
$string['cannotoverriderolehere'] = 'Δεν επιτρέπεται να παρακάμψετε αυτόν το ρόλο (id = {$a->roleid}) σε αυτό το πλαίσιο ({$a->context})';
$string['cannotreadfile'] = 'Αδυναμία ανάγνωσης αρχείου ({$a})';
$string['cannotreadtmpfile'] = 'Σφάλμα ανάγνωσης προσωρινού αρχείου';
$string['cannotreaduploadfile'] = 'Δεν ήταν δυνατή η ανάγνωση του ανεβασμένου αρχείου';
$string['cannotremovefrommeta'] = 'Δεν ήταν δυνατή η αφαίρεση του επιλεγμένου μαθήματος από αυτό το μετα-μάθημα!';
$string['cannotreprocessgrades'] = 'Δεν ήταν δυνατή η επανεπεξεργασία βαθμών για αυτήν τη δραστηριότητα {$a}';
$string['cannotresetguestpwd'] = 'Δεν μπορείτε να επαναρχικοποιήσετε τον κωδικό πρόσβασης επισκέπτη';
$string['cannotresetmail'] = 'Σφάλμα επαναρχικοποίησης κωδικού πρόσβασης και αποστολής μηνύματος ηλε.ταχυδρομείου';
$string['cannotresetthisrole'] = 'Αδυναμία επαναρχικοποίησης αυτού του ρόλου';
$string['cannotrestore'] = 'Παρουσιάστηκε κάποιο σφάλμα και δεν ήταν δυνατή η ολοκλήρωση της επαναφοράς!';
$string['cannotrestoreadminorcreator'] = 'Πρέπει να είστε δημιουργός ή διαχειριστής ώστε να επαναφέρετε ένα αντίγραφο ασφαλείας μέσα σε ένα καινούριο μάθημα!';
$string['cannotrestoreadminoredit'] = 'Πρέπει να είστε διδάσκων-συντάκτης ή διαχειριστής ώστε να επαναφέρετε ένα αντίγραφο ασφαλείας μέσα σε ένα επιλεγμένο μάθημα!';
$string['cannotsaveagreement'] = 'Δεν ήταν δυνατή η αποθήκευση της συμφωνίας σας';
$string['cannotsaveblock'] = 'Σφάλμα αποθήκευσης ρυθμίσεων αρθρώματος';
$string['cannotsavecomment'] = 'Αδυναμία αποθήκευσης σχολίου';
$string['cannotsavedata'] = 'Αδυναμία αποθήκευσης δεδομένων';
$string['cannotsavefile'] = 'Αδυναμία αποθήκευσης αρχείου «{$a}»!';
$string['cannotsavemd5file'] = 'Αδυναμία αποθήκευσης αρχείου md5.';
$string['cannotsavezipfile'] = 'Αδυναμία αποθήκευσης συμπιεσμένου αρχείου';
$string['cannotservefile'] = 'Αδυναμία διάθεσης του αρχείου λόγω προβλήματος ρυθμίσεων εξυπηρετητή.';
$string['cannotsetparentforcatoritem'] = 'Αδυναμία ορισμού γονέα για την κατηγορία ή το μάθημα!';
$string['cannotsetpassword'] = 'Δεν ήταν δυνατός ο ορισμός κωδικού πρόσβασης χρήστη!';
$string['cannotsetprefgrade'] = 'Δεν ήταν δυνατός ο ορισμός της προτίμησης aggregationview (εμφάνιση συνάθροισης) σε {$a} για αυτή την κατηγορία βαθμών';
$string['cannotsettheme'] = 'Δεν ήταν δυνατός ο ορισμός του αισθητικού θέματος!';
$string['cannotsetupblock'] = 'Οι πίνακες μπλοκ ΔΕΝ έχουν οριστεί σωστά!';
$string['cannotsetupcapformod'] = 'Δεν ήταν δυνατός ο ορισμός των δυνατοτήτων για {$a}';
$string['cannotsetupcapforplugin'] = 'Δεν ήταν δυνατός ο ορισμός των δυνατοτήτων για {$a}';
$string['cannotshowhidecoursesincategory'] = 'Αδυναμία προβολής/απόκρυψης μαθημάτων στην κατηγορία {$a}.';
$string['cannotsignup'] = 'Δεν μπορείτε να δημιουργήσετε ένα νέο λογαριασμό, διότι έχετε ήδη συνδεθεί ως {$a}.';
$string['cannotswitcheditmodeon'] = 'Αδυναμία ενεργοποίησης της κατάστασης λειτουργίας επεξεργασίας';
$string['cannotunassigncap'] = 'Δεν ήταν δυνατή η αφαίρεση της απαρχαιωμένης δυνατότητας {$a->cap} από το ρόλο {$a->role}';
$string['cannotunassignrolefrom'] = 'Δεν ήταν δυνατή η αφαίρεση του ρόλου με αναγνωριστικό: {$a} από αυτόν τον χρήστη';
$string['cannotunzipfile'] = 'Αδυναμία αποσυμπίεσης αρχείου';
$string['cannotupdatemod'] = 'Δεν ήταν δυνατή η ενημέρωση του {$a}';
$string['cannotupdatepasswordonextauth'] = 'Αποτυχία ενημέρωσης κωδικού πρόσβασης στην εξωτερική αυθεντικοποίηση: {$a}. Δείτε τις καταγραφές του εξυπηρετητή για περισσότερες λεπτομέρειες.';
$string['cannotupdateprofile'] = 'Σφάλμα ενημέρωσης εγγραφής χρήστη';
$string['cannotupdaterecord'] = 'Δεν ήταν δυνατή η ενημέρωση του ID εγγραφής {$a}';
$string['cannotupdaterss'] = 'Αδυναμία ενημέρωσης τροφοδοσίας RSS';
$string['cannotupdatesubcourse'] = 'Δεν ήταν δυνατή η ενημέρωση του μαθήματος-παιδιού!';
$string['cannotupdateusermsgpref'] = 'Αδυναμία ενημέρωσης προτιμήσεων μηνυμάτων χρήστη';
$string['cannotupdateuseronexauth'] = 'Αποτυχία ενημέρωσης δεδομένων χρήστη στην εξωτερική αυθεντικοποίηση: {$a}. Δείτε τις καταγραφές του εξυπηρετητή για περισσότερες λεπτομέρειες.';
$string['cannotuploadfile'] = 'Σφάλμα επεξεργασίας αρχείου προς ανέβασμα';
$string['cannotuseadmin'] = 'Πρέπει να είστε διαχειριστής για να χρησιμοποιήσετε αυτή τη σελίδα';
$string['cannotuseadminadminorteacher'] = 'Πρέπει να είστε διδάσκων ή διαχειριστής για να χρησιμοποιήσετε αυτή τη σελίδα';
$string['cannotusepage'] = 'Μόνο διδάσκοντες και διαχειριστές μπορούν να χρησιμοποιήσουν αυτή τη σελίδα';
$string['cannotusepage2'] = 'Λυπούμαστε, δεν μπορείτε να χρησιμοποιήσετε αυτή τη σελίδα';
$string['cannotviewcategory'] = 'Δεν έχετε άδεια να δείτε αυτή τη λίστα με μαθήματα.';
$string['cannotviewprofile'] = 'Δεν μπορείτε να δείτε το προφίλ αυτού του χρήστη';
$string['cannotviewreport'] = 'Δεν μπορείτε να προβάλετε αυτήν την αναφορά';
$string['cannotwritefile'] = 'Αδυναμία εγγραφής στο αρχείο ({$a})';
$string['categoryerror'] = 'Σφάλμα κατηγορίας';
$string['categoryidnumbertaken'] = 'Αυτός ο αναγνωριστικός αριθμός χρησιμοποιείται ήδη για άλλη κατηγορία';
$string['categorynamerequired'] = 'Το όνομα κατηγορίας απαιτείται';
$string['categorytoolong'] = 'Πολύ μεγάλο όνομα κατηγορίας';
$string['commentmisconf'] = 'Το αναγνωριστικό του σχολίου είναι μη ορθά ρυθμισμένο';
$string['componentisuptodate'] = 'Το στοιχείο λογισμικού είναι ενημερωμένο.';
$string['confirmationnotenabled'] = 'Η επιβεβαίωση χρήστη δεν είναι ενεργοποιημένη σε αυτόν τον ιστότοπο';
$string['confirmsesskeybad'] = 'Συγνώμη, αλλά δεν ήταν δυνατή η επιβεβαίωση του κλειδιού της συνόδου σας για να την ολοκλήρωση αυτής της ενέργειας. Αυτό το χαρακτηριστικό ασφαλείας αποτρέπει την εκτέλεση σημαντικών λειτουργιών κατά λάθος ή επίτηδες στο όνομά σας. Παρακαλούμε επιβεβαιώστε ότι θέλετε να εκτελεστεί αυτή η λειτουργία.';
$string['contenttypenotfound'] = 'Ο τύπος τράπεζας περιεχομένου «{$a}» δεν υπάρχει ή δεν αναγνωρίζεται.';
$string['contentvisibilitynotfound'] = 'Η ορατότητα περιεχομένου με την τιμή «{$a}» δεν υπάρχει ή δεν αναγνωρίζεται.';
$string['couldnotassignrole'] = 'Ένα σοβαρό αλλά μη-ορισμένο σφάλμα συνέβη ενώ δοκιμάστηκε η απόδοση ρόλου σε σας.';
$string['couldnotupdatenoexistinguser'] = 'Αδυναμία ενημέρωσης του χρήστη - ο χρήστης δεν υπάρχει';
$string['couldnotverifyagedigitalconsent'] = 'Παρουσιάστηκε σφάλμα κατά την προσπάθεια επαλήθευσης της ηλικίας της ψηφιακής συγκατάθεσης. <br /> Επικοινωνήστε με τον διαχειριστή.';
$string['countriesphpempty'] = 'Σφάλμα: Το αρχείο countries.php στο πακέτο γλώσσας {$a} είναι κενό ή δεν υπάρχει.';
$string['coursedoesnotbelongtocategory'] = 'Το μάθημα δεν ανήκει σε αυτή την κατηγορία';
$string['courseformatnotfound'] = 'Ο μορφότυπος του μαθήματος «{$a}» δεν υπάρχει ή δεν αναγνωρίζεται.';
$string['coursegroupunknown'] = 'Το μάθημα που αντιστοιχεί στην ομάδα {$a} δεν έχει οριστεί';
$string['courseidnotfound'] = 'Το αναγνωριστικό του μαθήματος δεν υπάρχει.';
$string['courseidnumbertaken'] = 'Αυτός ο αναγνωριστικός αριθμός χρησιμοποιείται ήδη για άλλο μάθημα ({$a})';
$string['coursemisconf'] = 'Το μάθημα έχει μη έγκυρες ρυθμίσεις';
$string['courserequestdisabled'] = 'Λυπούμαστε αλλά οι αιτήσεις δημιουργίας μαθήματος έχουν απενεργοποιηθεί από το διαχειριστή';
$string['csvcolumnduplicates'] = 'Εντοπίστηκαν διπλότυπες στήλες';
$string['csvemptyfile'] = 'Το αρχείο CSV είναι κενό';
$string['csvfewcolumns'] = 'Δεν υπάρχουν αρκετές στήλες. Παρακαλούμε, επαληθεύσετε τη ρύθμιση του διαχωριστικού στηλών.';
$string['csvfileerror'] = 'Υπάρχει κάποιο πρόβλημα με τον μορφότυπο του αρχείου CSV. Παρακαλούμε, ελέγξτε αν ο αριθμός των επικεφαλίδων και των στηλών ταιριάζει και ότι το διαχωριστικό και η κωδικοποίηση αρχείων είναι σωστά. {$a}';
$string['csvinvalidcols'] = '<b>Μη έγκυρο αρχείο CSV:</b> Η πρώτη γραμμή πρέπει να περιέχει επικεφαλίδες με ονόματα πεδίων και το αρχείο πρέπει να είναι τύπου <br />«Expanded Fields/Comma Separated»<br />ή<br /> «Expanded Fields with CAVV Result Code/Comma Separated»';
$string['csvinvalidcolsnum'] = 'Λάθος αρχείο CSV - η κάθε γραμμή πρέπει να περιέχει 49 ή 70 πεδία';
$string['csvloaderror'] = 'Ένα σφάλμα συνέβη κατά τη φόρτωση του CSV αρχείου: {$a}';
$string['csvnodata'] = 'Μη έγκυρο αρχείο CSV - Το αρχείο CSV έχει κεφαλίδες, αλλά δεν περιέχει δεδομένα.';
$string['csvweirdcolumns'] = 'Μη έγκυρος μορφότυπος αρχείου CSV - ο αριθμός των στηλών δεν είναι σταθερός!';
$string['dbconnectionfailed'] = '<p>Σφάλμα: Η σύνδεση στη βάση απέτυχε</p>
<p>Είναι πιθανόν η βάση να είναι υπερφορτωμένη ή να μην τρέχει σωστά.</p>
<p>Ο διαχειριστής του ιστοτόπου θα πρέπει επίσης να ελέγξει ότι οι λεπτομέρειες της βάσης δεδομένων έχουν οριστεί σωστά στο config.php</p>{$a}';
$string['dbdriverproblem'] = '<p>Σφάλμα: Ο οδηγός της βάσης δεδομένων εμφάνισε πρόβλημα</p><p>Ο διαχειριστής του ιστοτόπου θα πρέπει να ελέγξει τις ρυθμίσεις του εξυπηρετητή</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Εντοπίστηκε σοβαρό πρόβλημα στη σύνοδο της βάσης δεδομένων. Παρακαλούμε ειδοποιήστε το διαχειριστή του συστήματος.';
$string['dbsessionhandlerproblem'] = 'Σφάλμα στην δημιουργία της συνόδου βάσης δεδομένων. Παρακαλούμε ειδοποιήστε το διαχειριστή του εξυπηρετητή.';
$string['dbsessionmysqlpacketsize'] = 'Εντοπίστηκε σοβαρό σφάλμα συνόδου. Παρακαλούμε ειδοποιήστε το διαχειριστή του ιστοτόπου. Το πρόβλημα πιθανότατα προκλήθηκε από χαμηλή τιμή της ρύθμισης max_allowed_packet στην MySQL.';
$string['dbupdatefailed'] = 'Αποτυχία ενημέρωσης βάσης δεδομένων';
$string['ddldependencyerror'] = 'Αδυναμία τροποποίησης {$a->targettype} «{$a->targetname}». Βρέθηκε εξάρτηση με {$a->offendingtype} «{$a->offendingname}»';
$string['ddlexecuteerror'] = 'Σφάλμα στην εκτέλεση DDL sql';
$string['ddlfieldalreadyexists'] = 'Το πεδίο «{$a}» υπάρχει ήδη';
$string['ddlfieldnotexist'] = 'Το πεδίο «{$a->fieldname}» δεν υπάρχει στον πίνακα «{$a->tablename}»';
$string['ddltablealreadyexists'] = 'Ο πίνακας «{$a}» υπάρχει ήδη';
$string['ddltablenotexist'] = 'Ο πίνακας «{$a}» δεν υπάρχει';
$string['ddlunknownerror'] = 'Άγνωστο σφάλμα βιβλιοθήκης DDL';
$string['ddlxmlfileerror'] = 'Εντοπίστηκαν σφάλματα XML αρχείου βάσης';
$string['ddsequenceerror'] = 'Εσφαλμένος ορισμός πίνακα «{$a}»: μπορεί να υπάρχει μόνο μία αυτόματη στήλη και πρέπει να οριστεί ως κλειδί.';
$string['destinationcmnotexit'] = 'Το άρθρωμα του μαθήματος-στόχου δεν υπάρχει';
$string['detectedbrokenplugin'] = 'Το πρόσθετο «{$a}» είναι ελαττωματικό ή απαρχαιωμένο. Λυπούμαστε αλλά δεν είναι δυνατή η συνέχιση.';
$string['dmlexceptiononinstall'] = '<p>Παρουσιάστηκε κάποιο σφάλμα βάσης δεδομένων [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Σφάλμα στη συντακτική ανάλυση του ερωτήματος SQL';
$string['dmlreadexception'] = 'Σφάλμα ανάγνωσης από τη βάση δεδομένων';
$string['dmltransactionexception'] = 'Σφάλμα συναλλαγής βάσης δεδομένων';
$string['dmlwriteexception'] = 'Σφάλμα εγγραφής στη βάση δεδομένων';
$string['downgradedcore'] = 'ΣΦΑΛΜΑ!!! Ο κώδικας που χρησιμοποιείτε είναι παλαιότερος από την έκδοση που δημιούργησε αυτές τις βάσεις δεδομένων!';
$string['downloadedfilecheckfailed'] = 'Αποτυχία ελέγχου αρχείου που έγινε λήψη';
$string['duplicatefieldname'] = 'Ανιχνεύθηκε δεύτερο πεδίο με ίδιο όνομα «{$a}»';
$string['duplicatenosupport'] = 'Η δραστηριότητα «{$a->modname}» δεν μπορεί να αντιγραφεί διότι το άρθρωμα «{$a->modtype}» δεν υποστηρίζει την δημιουργία και επαναφορά αντιγράφων ασφαλείας.';
$string['duplicateparaminsql'] = 'ΣΦΑΛΜΑ: διπλότυπη παράμετρος στο ερώτημα';
$string['duplicaterolename'] = 'Υπάρχει ήδη ένας ρόλος με αυτό το όνομα!';
$string['duplicateroleshortname'] = 'Υπάρχει ήδη ένας ρόλος με αυτό το σύντομο όνομα!';
$string['duplicateusername'] = 'Διπλότυπο όνομα χρήστη - αγνόηση εγγραφής';
$string['emailfail'] = 'Αποτυχία αποστολής μηνύματος ηλε.ταχυδρομείου';
$string['encryption_decryptfailed'] = 'Η αποκρυπτογράφηση απέτυχε';
$string['encryption_encryptfailed'] = 'Η κρυπτογράφηση απέτυχε';
$string['encryption_invalidkey'] = 'Μη έγκυρο κλειδί';
$string['encryption_keyalreadyexists'] = 'Το κλειδί υπάρχει ήδη';
$string['encryption_nokey'] = 'Το κλειδί δεν βρέθηκε';
$string['encryption_wrongmethod'] = 'Τα δεδομένα δεν ταιριάζουν με κάποια υποστηριζόμενη μέθοδο κρυπτογράφησης';
$string['enddatebeforestartdate'] = 'Η ημερομηνία λήξης του μαθήματος πρέπει να είναι μετά την ημερομηνία έναρξης.';
$string['error'] = 'Συνέβη κάποιο σφάλμα';
$string['error_question_answers_missing_in_db'] = 'Δεν βρέθηκε μια απάντηση που να ταιριάζει στην «{$a->answer}» στον πίνακα βάσης δεδομένων question_answers (απαντήσεις ερωτήσεων). Αυτό συνέβη κατά την επαναφορά της ερώτησης με αναγνωριστικό {$a->filequestionid} στο αρχείο αντιγράφου ασφαλείας, το οποίο έχει αντιστοιχηθεί στην υπάρχουσα ερώτηση με αναγνωριστικό {$a->dbquestionid} στη βάση δεδομένων.';
$string['errorcleaningdirectory'] = 'Σφάλμα στο καθαρισμό φακέλου «{$a}»';
$string['errorcopyingfiles'] = 'Σφάλμα στην αντιγραφή αρχείων';
$string['errorcreatingdirectory'] = 'Σφάλμα στη δημιουργία φακέλου «{$a}»';
$string['errorcreatingfile'] = 'Σφάλμα στη δημιουργία αρχείου «{$a}»';
$string['errorcreatingrole'] = 'Σφάλμα στη δημιουργία ρόλου';
$string['errorfetchingrssfeed'] = 'Σφάλμα κατά την κλήση/λήψη τροφοδοσίας RSS.';
$string['erroronline'] = 'Σφάλμα στη γραμμή «{$a}»';
$string['erroroutput'] = 'Εσφαλμένη έξοδος, οπότε απενεργοποιείται η αυτόματη ανακατεύθυνση.';
$string['errorparsingxml'] = 'Σφάλμα στη συντακτική ανάλυση της XML: {$a->errorstring} στη γραμμή {$a->errorline}, χαρακτήρας {$a->errorchar}';
$string['errorprocessingarchive'] = 'Σφάλμα κατά την επεξεργασία αρχείου αρχειοθήκης';
$string['errorreadingfile'] = 'Σφάλμα στην ανάγνωση του αρχείου «{$a}»';
$string['errorsavingrequest'] = 'Συνέβη κάποιο σφάλμα κατά την αποθήκευση του αιτήματός σας.';
$string['errorsettinguserpref'] = 'Σφάλμα κατά τον ορισμό της προτίμησης χρήστη';
$string['errorunzippingfiles'] = 'Σφάλμα στην αποσυμπίεση αρχείων';
$string['expiredkey'] = 'Ληγμένο κλειδί';
$string['externalauthpassworderror'] = 'Μη-κενός κωδικός πρόσβασης για την εξωτερική αυθεντικοποίηση';
$string['externalfilenolocation'] = 'Το εξωτερικό αρχείο δεν έχει διαδρομή τοποθεσίας';
$string['failtoloadblocks'] = 'Ένα ή περισσότερα μπλοκ είναι καταχωρημένα στη βάση αλλά κανένα δεν μπόρεσε να φορτωθεί!';
$string['fieldrequired'] = 'Το «{$a}» είναι απαιτούμενο πεδίο';
$string['fileexists'] = 'Το αρχείο υπάρχει';
$string['filemismatch'] = 'Αναντιστοιχία ονόματος αρχείου (μη-πυρήνα). Το αρχείο «{$a->current}» θα έπρεπε να είναι «{$a->file}»';
$string['filenotfound'] = 'Συγνώμη, δεν ήταν δυνατή η εύρεση του ζητούμενου αρχείου';
$string['filenotreadable'] = 'Το αρχείο δεν είναι αναγνώσιμο';
$string['filterdoesnothavelocalconfig'] = 'Το φίλτρο {$a} δεν επιτρέπει τοπικές ρυθμίσεις.';
$string['filternotactive'] = 'Το φίλτρο {$a} δεν είναι ενεργό αυτή τη στιγμή';
$string['filternotenabled'] = 'Το φίλτρο δεν είναι ενεργοποιημένο!';
$string['filternotinstalled'] = 'Το φίλτρο {$a} δεν είναι εγκατεστημένο αυτή τη στιγμή';
$string['forumblockingtoomanyposts'] = 'Έχετε υπερβεί το όριο αναρτήσεων που έχει οριστεί για αυτό το φόρουμ.';
$string['functionalityremoved'] = 'Γίνεται προσπάθεια για πρόσβαση σε λειτουργικότητα που έχει αφαιρεθεί.';
$string['generalexceptionmessage'] = 'Εξαίρεση - {$a}';
$string['gradecantregrade'] = 'Παρουσιάστηκε σφάλμα κατά τον υπολογισμό βαθμού: {$a}';
$string['gradepubdisable'] = 'Απενεργοποιήθηκε η ανάρτηση βαθμών';
$string['gradesneedregrading'] = 'Οι βαθμοί μαθημάτων πρέπει να επανυπολογιστούν';
$string['groupalready'] = 'Ο χρήστης ήδη ανήκει στην ομάδα {$a}';
$string['groupexistforcourse'] = 'Η ομάδα «{$a}» ήδη υπάρχει για αυτό το μάθημα';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Η ομάδα «{$a->name}» με έναν αναγνωριστικό αριθμό «{$a->idnumber}» υπάρχει ήδη για αυτό το μάθημα';
$string['grouphasidnumber'] = 'Η ομάδα «{$a}» έχει αναγνωριστικό αριθμό και μπορεί να έχει δημιουργηθεί αυτόματα από ένα εξωτερικό σύστημα. Δεν έχετε δικαίωμα να καταργήσετε αυτή την ομάδα.';
$string['groupinghasidnumber'] = 'Η ομαδοποίηση «{$a}» έχει αναγνωριστικό αριθμό και μπορεί να έχει δημιουργηθεί αυτόματα από ένα εξωτερικό σύστημα. Δεν έχετε δικαίωμα να καταργήσετε αυτή την ομαδοποίηση.';
$string['groupingnotaddederror'] = 'Η ομαδοποίηση «{$a}» δεν προστέθηκε';
$string['groupnotaddederror'] = 'Η ομάδα «{$a}» δεν προστέθηκε';
$string['groupnotaddedtogroupingerror'] = 'Η ομάδα «{$a->groupname}» δεν προστέθηκε στην ομαδοποίηση «{$a->groupingname}»';
$string['groupunknown'] = 'Η ομάδα {$a} δεν σχετίζεται με το συγκεκριμένο μάθημα';
$string['groupusernotmember'] = 'Ο χρήστης δεν είναι μέλος αυτής της ομάδας.';
$string['guestcantaccessprofiles'] = 'Οι επισκέπτες δεν έχουν πρόσβαση στα προφίλ χρηστών. Συνδεθείτε με έναν πλήρη λογαριασμό για να συνεχίσετε.';
$string['guestnocomment'] = 'Οι επισκέπτες δεν επιτρέπεται να αναρτούν σχόλια!';
$string['guestnoeditprofile'] = 'Ο επισκέπτης δεν μπορεί να τροποποιήσει το προφίλ του';
$string['guestnoeditprofileother'] = 'Το προφίλ του επισκέπτη δεν μπορεί να τροποποιηθεί';
$string['guestnorate'] = 'Οι επισκέπτες δεν επιτρέπεται να αξιολογούν καταχωρήσεις';
$string['guestsarenotallowed'] = 'Ο επισκέπτης δεν επιτρέπεται να εκτελέσει αυτή την ενέργεια';
$string['hackdetected'] = 'Ανιχνεύτηκε επίθεση!';
$string['hashpoolproblem'] = 'Λανθασμένο περιεχόμενο αρχείου δεξαμενής {$a}.';
$string['headersent'] = 'Οι κεφαλίδες έχουν ήδη αποσταλεί';
$string['idnumbertaken'] = 'Αυτός ο αναγνωριστικός αριθμός χρησιμοποιείται ήδη';
$string['idnumbertoolong'] = 'Ο αναγνωριστικός αριθμός έχει πολύ μεγάλο μήκος';
$string['importformatnotimplement'] = 'Λυπούμαστε, η εισαγωγή από αυτόν τον μορφότυπο δεν έχει υλοποιηθεί ακόμη!';
$string['incorrectext'] = 'Το αρχείο έχει λανθασμένη επέκταση';
$string['inplaceeditableerror'] = 'Σφάλμα κλήσης επεξεργαστή ενημέρωσης';
$string['installproblem'] = 'Συνήθως δεν είναι δυνατή η ανάκτηση από σφάλματα που προκλήθηκαν κατά την εγκατάσταση. Ίσως χρειαστεί να δημιουργήσετε μια νέα βάση δεδομένων ή να χρησιμοποιήσετε ένα διαφορετικό πρόθεμα βάσης δεδομένων, εάν θέλετε να δοκιμάσετε ξανά την εγκατάσταση.';
$string['internalauthpassworderror'] = 'Λείπει κωδικός πρόσβασης ή μη έγκυρη πολιτική κωδικού πρόσβασης για εσωτερική αυθεντικοποίηση';
$string['invalidaccess'] = 'Αυτή η σελίδα δεν προσπελάστηκε απευθείας';
$string['invalidaccessparameter'] = 'Μη έγκυρη παράμετρος πρόσβασης';
$string['invalidaction'] = 'Μη έγκυρη παράμετρος ενέργειας';
$string['invalidactivityid'] = 'Μη έγκυρο αναγνωριστικό δραστηριότητας';
$string['invalidadminsettingname'] = 'Μυ έγκυρη ρύθμιση διαχειριστή ({$a})';
$string['invalidargorconf'] = 'Δεν έχουν δοθεί έγκυρες παράμετροι ή έχουν γίνει λανθασμένες ρυθμίσεις στον εξυπηρετητή';
$string['invalidarguments'] = 'Δεν έχουν δοθεί έγκυρες παράμετροι';
$string['invalidblockinstance'] = 'Μη έγκυρο στιγμιότυπο μπλοκ για: {$a}';
$string['invalidbulkenrolop'] = 'Ζητήθηκε μη έγκυρη λειτουργία μαζικής εγγραφής.';
$string['invalidcategory'] = 'Λανθασμένη κατηγορία!';
$string['invalidcategoryid'] = 'Μη έγκυρο αναγνωριστικό κατηγορίας!';
$string['invalidcomment'] = 'Το σχόλιο είναι λανθασμένο';
$string['invalidcommentarea'] = 'Μη έγκυρη περιοχή σχολίων';
$string['invalidcommentid'] = 'Μη έγκυρο αναγνωριστικό σχολίου';
$string['invalidcommentitemid'] = 'Μη έγκυρο αναγνωριστικό στοιχείου σχολίου';
$string['invalidcommentparam'] = 'Μη έγκυρες παράμετροι σχολίων';
$string['invalidcomponent'] = 'Μη έγκυρο όνομα στοιχείο λογισμικού';
$string['invalidconfirmdata'] = 'Μη έγκυρα δεδομένα επιβεβαίωσης';
$string['invalidcontentid'] = 'Μη έγκυρο αναγνωριστικό περιεχομένου';
$string['invalidcontext'] = 'Μη έγκυρο πλαίσιο';
$string['invalidcountrycode'] = 'Μη έγκυρος κωδικός χώρας: {$a}';
$string['invalidcourse'] = 'Μη έγκυρο μάθημα';
$string['invalidcourseformat'] = 'Μη έγκυρος τύπος μαθήματος';
$string['invalidcourseid'] = 'Προσπαθείτε να χρησιμοποιήσετε ένα μη έγκυρο αναγνωριστικό μαθήματος';
$string['invalidcourselevel'] = 'Λανθασμένο επίπεδο πλαισίου';
$string['invalidcoursemodule'] = 'Μη έγκυρο ID αρθρώματος μαθήματος';
$string['invalidcoursenameshort'] = 'Μη έγκυρο σύντομο όνομα μαθήματος';
$string['invaliddata'] = 'Τα υποβληθέντα δεδομένα δεν είναι έγκυρα';
$string['invaliddatarootpermissions'] = 'Ανιχνεύθηκαν μη έγκυρα δικαιώματα κατά την προσπάθεια δημιουργίας ενός καταλόγου. Ενεργοποιήστε την αποσφαλμάτωση για περαιτέρω λεπτομέρειες.';
$string['invaliddevicetype'] = 'Μη έγκυρος τύπος συσκευής';
$string['invalidelementid'] = 'Μη έγκυρο αναγνωριστικό στοιχείου!';
$string['invalidentry'] = 'Αυτή δεν είναι μια έγκυρη εγγραφή!';
$string['invalidevent'] = 'Μη έγκυρο γεγονός';
$string['invalidfieldname'] = 'Το «{$a}» δεν είναι έγκυρο όνομα πεδίου';
$string['invalidfiletype'] = 'Το «{$a}» δεν είναι έγκυρος τύπος αρχείου';
$string['invalidformatpara'] = 'Λανθασμένος μορφότυπος για την παράμετρο που επιλέχθηκε';
$string['invalidformdata'] = 'Λανθασμένα δεδομένα φόρμας';
$string['invalidfunction'] = 'Λανθασμένη λειτουργία';
$string['invalidgradeitemid'] = 'Μη έγκυρο αναγνωριστικό στοιχείου βαθμού';
$string['invalidgroupid'] = 'Καθορίστηκε μη έγκυρο αναγνωριστικό ομάδας';
$string['invalidipformat'] = 'Λανθασμένος μορφότυπος διεύθυνσης IP';
$string['invaliditemid'] = 'Μη έγκυρο αναγνωριστικό στοιχείου';
$string['invalidkey'] = 'Λανθασμένο κλειδί';
$string['invalidlanguagecode'] = 'Μη έγκυρος κωδικός γλώσσας: {$a}';
$string['invalidlegacy'] = 'Λανθασμένος ορισμός παλαιότερης έκδοσης ρόλου για τον τύπο: {$a}';
$string['invalidmd5'] = 'Η μεταβλητή ελέγχου ήταν λανθασμένη - δοκιμάστε ξανά';
$string['invalidmode'] = 'Μη έγκυρη μορφή ({$a})';
$string['invalidmodule'] = 'Μη έγκυρο άρθρωμα';
$string['invalidmoduleid'] = 'Μη έγκυρο ID αρθρώματος: {$a}';
$string['invalidmodulename'] = 'Μη έγκυρο όνομα αρθρώματος: {$a}';
$string['invalidnum'] = 'Μη έγκυρη αριθμητική τιμή';
$string['invalidnumkey'] = 'Ο πίνακας $conditions (συνθήκες) δεν μπορεί να περιέχει αριθμητικά κλειδιά. Παρακαλούμε διορθώστε τον κώδικα!';
$string['invalidoutcome'] = 'Μη έγκυρο αναγνωριστικό μαθησιακού αποτελέσματος';
$string['invalidpagesize'] = 'Μη έγκυρο μέγεθος σελίδας';
$string['invalidpasswordpolicy'] = 'Μη έγκυρη πολιτική κωδικού πρόσβασης';
$string['invalidpaymentmethod'] = 'Μυ έγκυρη μορφή πληρωμής: {$a}';
$string['invalidpersistenterror'] = 'Σφάλμα: {$a}';
$string['invalidqueryparam'] = 'ΣΦΑΛΜΑ: Λανθασμένο πλήθος παραμέτρων ερωτήματος. Αναμενόταν {$a->expected}, ελήφθησαν {$a->actual}.';
$string['invalidratingarea'] = 'Μη έγκυρη περιοχή βαθμολόγησης';
$string['invalidrecord'] = 'Δεν είναι δυνατή η εύρεση εγγραφής δεδομένων στον πίνακα βάσης δεδομένων {$a}.';
$string['invalidrecordunknown'] = 'Δεν είναι δυνατή η εύρεση εγγραφής δεδομένων στην βάση δεδομένων.';
$string['invalidrequest'] = 'Μη έγκυρο αίτημα';
$string['invalidrole'] = 'Μη έγκυρος ρόλος';
$string['invalidroleid'] = 'Μη έγκυρο ID ρόλου';
$string['invalidscaleid'] = 'Μη έγκυρο αναγνωριστικό κλίμακας';
$string['invalidsection'] = 'Η έγγραφή του αρθρώματος μαθήματος περιέχει μη έγκυρη ενότητα';
$string['invalidsesskey'] = 'Ο διαθέσιμος χρόνος για την σύνοδό σας έχει πιθανότατα λήξει. Παρακαλούμε, συνδεθείτε ξανά.';
$string['invalidshortname'] = 'Μη έγκυρο σύντομο όνομα μαθήματος';
$string['invalidsourcefield'] = 'Το πεδίο προέλευσης του αρχείου προσχεδίου δεν είναι έγκυρο';
$string['invalidstatedetected'] = 'Κάτι έχει πάει στραβά: {$a}. Κανονικά αυτό δεν πρέπει ποτέ να συμβεί.';
$string['invalidurl'] = 'Μη έγκυρο URL';
$string['invaliduser'] = 'Μη έγκυρος χρήστης';
$string['invaliduserdata'] = 'Μη έγκυρα δεδομένα χρήστη: «{$a}»';
$string['invaliduserfield'] = 'Μη έγκυρο πεδίο χρήστη: «{$a}»';
$string['invaliduserid'] = 'Μη έγκυρο αναγνωριστικό χρήστη';
$string['invalidusername'] = 'Το όνομα χρήστη που δόθηκε περιέχει μη έγκυρους χαρακτήρες';
$string['invalidusernameblank'] = 'Το όνομα χρήστη δεν μπορεί να είναι κενό';
$string['invalidxmlfile'] = 'Το «{$a}» δεν είναι έγκυρο αρχείο XML';
$string['iplookupfailed'] = 'Αδυναμία εύρεσης πληροφοριών geo σχετικά με αυτή την IP διεύθυνση {$a}';
$string['iplookupprivate'] = 'Αδυναμία προβολής αναζήτησης ιδιωτικής διεύθυνσης IP';
$string['ipmismatch'] = 'Αναντιστοιχία διεύθυνσης IP πελάτη';
$string['listcantmovedown'] = 'Αποτυχία μεταφοράς στοιχείου προς τα κάτω, καθώς είναι το τελευταίο.';
$string['listcantmoveleft'] = 'Αποτυχία μεταφορές του στοιχείου στα αριστερά καθώς δεν έχει γονέα';
$string['listcantmoveright'] = 'Αποτυχία μεταφοράς του στοιχείου στα δεξιά καθώς δεν υπάρχει ομότιμος από το οποίο να μπορεί να δημιουργηθεί υποστοιχείο. Μετακινήστε το κάτω από άλλο ομότιμο κι έπειτα μπορείτε να το μετακινήσετε στα δεξιά.';
$string['listcantmoveup'] = 'Αποτυχία μεταφοράς του στοιχείου επάνω, καθώς είναι το πρώτο.';
$string['listnochildren'] = 'Δε βρέθηκε υποστοιχείο';
$string['listnoitem'] = 'Αδυναμία εύρεσης στοιχείου';
$string['listnopeers'] = 'Δε βρέθηκαν οι peers του στοιχείου';
$string['listupdatefail'] = 'Απέτυχε η λειτουργία της βάσης δεδομένων κατά την επεξεργασία της ιεραρχίας της λίστας';
$string['logfilenotavailable'] = 'Δεν υπάρχουν διαθέσιμες καταγραφές';
$string['loginasnoenrol'] = 'Δεν είναι εφικτή η εγγραφή ή η ακύρωση εγγραφής όταν είστε στο μάθημα σε σύνοδο «Σύνδεση ως»';
$string['loginasonecourse'] = 'Δεν μπορείτε να συνδεθείτε/εισέλθετε σε αυτό το μάθημα.<br /> Πρέπει να τερματίσετε τη σύνοδο «Σύνδεση ως» πριν να συνδεθείτε/εισέλθετε σε οποιοδήποτε άλλο μάθημα.';
$string['maxareabytes'] = 'Το αρχείο είναι μεγαλύτερο από τον χώρο που απομένει σε αυτήν την περιοχή.';
$string['maxbytesfile'] = 'Το αρχείο «{$a->file}» είναι πολύ μεγάλο. Το μέγιστο μέγεθος που μπορείτε να ανεβάσετε είναι «{$a->size}».';
$string['maxdraftitemids'] = 'Προσωρινός περιορισμός στο ανέβασμα/μεταφόρτωση αρχείων σας επειδή ανεβάσατε μεγάλο όγκο αρχείων. Παρακαλούμε, περιμένετε και δοκιμάστε ξανά.';
$string['messageundeliveredbynotificationsettings'] = 'Δεν ήταν δυνατή η αποστολή του μηνύματος, επειδή τα προσωπικά μηνύματα μεταξύ χρηστών (στις ρυθμίσεις ειδοποιήσεων) έχουν απενεργοποιηθεί από ένα διαχειριστή ιστοτόπου.';
$string['messagingdisable'] = 'Η ανταλλαγή μηνυμάτων είναι απενεργοποιημένη σε αυτόν τον ιστότοπο';
$string['mimetexisnotexist'] = 'Το σύστημά σας δεν έχει ρυθμιστεί ώστε να εκτελεί mimeTeX. Πρέπει να κατεβάσετε τον πηγαίο κώδικα C από το <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a>, να τον μεταγλωττίσετε και να τοποθετήσετε στον κατάλογο moodle/filter/tex/ το εκτελέσιμο αρχείο.';
$string['mimetexnotexecutable'] = 'Το παραμετροποιημένο mimetex δεν είναι εκτελέσιμο!';
$string['missing_moodle_backup_xml_file'] = 'Από το αντίγραφο ασφαλείας λείπει το αρχείο XML: {$a}';
$string['missingfield'] = 'Το πεδίο «{$a}» λείπει';
$string['missingkeyinsql'] = 'ΣΦΑΛΜΑ: λείπει η παράμετρος «{$a}» στο ερώτημά σας';
$string['missingparam'] = 'Η απαιτούμενη παράμετρος ({$a}) λείπει';
$string['missingparameter'] = 'Κάποια απαιτούμενη παράμετρος λείπει';
$string['missingrequiredfield'] = 'Κάποιο απαιτούμενο πεδίο λείπει';
$string['missinguseranditemid'] = 'Λείπει το userid και το itemid';
$string['missingvarname'] = 'Λείπει το απαιτούμενο όνομα μεταβλητής!';
$string['mixedtypesqlparam'] = 'ΣΦΑΛΜΑ: Μπερδεμένοι τύποι παραμέτρων του ερωτήματος sql!!';
$string['mnetdisable'] = 'Το MNet είναι απενεργοποιημένο';
$string['mnetlocal'] = 'Οι απομακρυσμένοι χρήστες MNet δεν μπορούν να συνδεθούν τοπικά';
$string['moduledisable'] = 'Αυτό το άρθρωμα ({$a}) έχει απενεργοποιηθεί για αυτό το συγκεκριμένο μάθημα';
$string['moduledoesnotexist'] = 'Το άρθρωμα αυτό δεν υπάρχει';
$string['moduleinstancedoesnotexist'] = 'Το στιγμιότυπο αυτού του αρθρώματος δεν υπάρχει';
$string['modulemissingcode'] = 'Λείπει απαιτούμενος κώδικας στο άρθρωμα {$a} για την εκτέλεση αυτής της λειτουργίας';
$string['movecatcontentstoroot'] = 'Δεν επιτρέπεται η μετακίνηση του περιεχομένου της κατηγορίας στη ρίζα. Πρέπει να μεταφέρετε τα περιεχόμενα σε μια υπάρχουσα κατηγορία!';
$string['movecatcontentstoselected'] = 'Κάποια από τα περιεχόμενα της κατηγορίας δεν μπορούν να μετακινηθούν στην επιλεγμένη κατηγορία.';
$string['movecategorynotpossible'] = 'Δεν μπορείτε να μετακινήσετε την κατηγορία «{$a}» στην επιλεγμένη κατηγορία.';
$string['movecategoryownparent'] = 'Δεν μπορείτε να κάνετε την κατηγορία «{$a}» γονέα του εαυτού της.';
$string['movecategoryparentconflict'] = 'Δεν μπορείτε να κάνετε την κατηγορία «{$a}» υποκατηγορία μιας από τις δικές της υποκατηγορίες.';
$string['mssqlrcsmodemissing'] = 'Η βάση δεδομένων δεν χρησιμοποιεί την αναμενόμενη λειτουργία READ_COMMITTED_SNAPSHOT η οποία μπορεί να οδηγήσει σε λανθασμένα αποτελέσματα, ειδικά σε σενάρια υψηλού ανταγωνισμού. Ενεργοποιήστε το για σωστή συμπεριφορά. Για περισσότερες πληροφορίες, ανατρέξτε στην τεκμηρίωση <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Εγκατάσταση του MSSQL για PHP</a>.';
$string['multiplerecordsfound'] = 'Βρέθηκαν πολλές εγγραφές ενώ αναμένεται μόνο μία.';
$string['multiplerestorenotallow'] = 'Δεν επιτρέπεται η εκτέλεση πολλαπλών λειτουργιών επαναφοράς!';
$string['mustbeloggedin'] = 'Πρέπει να συνδεθείτε για να το κάνετε αυτό';
$string['mustbeteacher'] = 'Πρέπει να είστε διδάσκων για να δείτε αυτή τη σελίδα';
$string['myisamproblem'] = 'Οι πίνακες βάσης δεδομένων χρησιμοποιούν τη μηχανή βάσης δεδομένων MyISAM. Συνιστάται η χρήση μηχανής συμβατής με το ACID με πλήρη υποστήριξη συναλλαγών ΒΔ, όπως η InnoDB.';
$string['needcopy'] = 'Πρέπει να αντιγράψετε κάτι πρώτα!';
$string['needcoursecategroyid'] = 'Είτε το αναγνωριστικό μαθήματος ή η κατηγορία πρέπει να έχει οριστεί';
$string['needphpext'] = 'Πρέπει να προσθέσετε υποστήριξη {$a} στην εγκατάσταση PHP σας';
$string['noadmins'] = 'Χωρίς διαχειριστές!';
$string['noblocks'] = 'Δε βρέθηκαν μπλοκ!';
$string['nocapabilitytousethisservice'] = 'Ο χρήστης δεν έχει την απαιτούμενη δυνατότητα για να χρησιμοποιήσει αυτήν την υπηρεσία';
$string['nocategorydelete'] = 'Η κατηγορία «{$a}» δεν μπορεί να διαγραφεί!';
$string['nocontext'] = 'Συγγνώμη, αλλά εκείνο το μάθημα δεν αποτελεί έγκυρο πλαίσιο';
$string['nodata'] = 'Δεν υπάρχουν δεδομένα';
$string['noexistingcategory'] = 'Δεν υπάρχει κατηγορία';
$string['nofile'] = 'Δεν έχει οριστεί αρχείο';
$string['nofiltersenabled'] = 'Δεν έχουν ενεργοποιηθεί καθόλου φίλτρα.';
$string['nofolder'] = 'Ο συγκεκριμένος κατάλογος δεν υπάρχει';
$string['noformdesc'] = 'Δε βρέθηκε προσδιορισμός φόρμας formslib για αυτή τη δραστηριότητα.';
$string['noguest'] = 'Δεν υπάρχουν επισκέπτες εδώ!';
$string['noinstances'] = 'Δεν υπάρχουν στιγμιότυπα του {$a} σε αυτό το μάθημα!';
$string['nologinas'] = 'Δεν μπορείτε να συνδεθείτε ως ο συγκεκριμένος χρήστης';
$string['nonmeaningfulcontent'] = 'Περιεχόμενο δίχως σημασία';
$string['noparticipants'] = 'Δε βρέθηκαν συμμετέχοντες για αυτό το μάθημα';
$string['noparticipatorycms'] = 'Συγγνώμη, αλλά δεν έχετε αρθρώματα συμμετοχικού μαθήματος για να αναφέρετε';
$string['nopermissions'] = 'Λυπούμαστε, αλλά αυτή τη στιγμή δεν έχετε τα δικαιώματα για να το κάνετε αυτό ({$a}).';
$string['nopermissiontoaccesspage'] = 'Δεν έχετε δικαίωμα πρόσβασης σε αυτήν τη σελίδα.';
$string['nopermissiontocomment'] = 'Δεν μπορείτε να προσθέσετε σχόλια';
$string['nopermissiontodelentry'] = 'Δεν μπορείτε να διαγράψετε αυτό το σχόλιο!';
$string['nopermissiontoeditcomment'] = 'Δεν μπορείτε να επεξεργαστείτε τις καταχωρήσεις άλλων!';
$string['nopermissiontohide'] = 'Δεν έχετε το δικαίωμα να κρύψετε το συγκεκριμένο στοιχείο!';
$string['nopermissiontoimportact'] = 'Δεν έχετε τα απαιτούμενα δικαιώματα για να εισαγάγετε δραστηριότητες σε αυτό το μάθημα';
$string['nopermissiontolock'] = 'Δεν έχετε το δικαίωμα να κλειδώσετε το συγκεκριμένο στοιχείο';
$string['nopermissiontomanagegroup'] = 'Δεν έχετε τα απαιτούμενα δικαιώματα για να διαχειριστείτε ομάδες';
$string['nopermissiontorate'] = 'Δεν επιτρέπεται η αξιολόγηση στοιχείων!';
$string['nopermissiontoshow'] = 'Δεν έχετε το δικαίωμα να το προβάλετε αυτό!';
$string['nopermissiontounlock'] = 'Δεν έχετε το δικαίωμα να ξεκλειδώσετε το συγκεκριμένο στοιχείο!';
$string['nopermissiontoupdatecalendar'] = 'Λυπούμαστε, αλλά δεν έχετε δικαίωμα να ενημερώσετε το γεγονός ημερολογίου.';
$string['nopermissiontoviewgrades'] = 'Αδυναμία προβολής βαθμών.';
$string['nopermissiontoviewletergrade'] = 'Λείπει το δικαίωμα επισκόπησης των βαθμών';
$string['nopermissiontoviewpage'] = 'Δεν επιτρέπετε να δείτε αυτή τη σελίδα';
$string['nosite'] = 'Δεν ήταν δυνατή η εύρεση μαθήματος αρχικού επιπέδου!';
$string['nositeid'] = 'Δεν υπάρχει ID ιστοτόπου';
$string['nostartdatenoenddate'] = 'Η ημερομηνία λήξης του μαθήματος μπορεί να οριστεί μόνο εάν έχει οριστεί ημερομηνία έναρξης.';
$string['nostatstodisplay'] = 'Λυπούμαστε, δεν υπάρχουν διαθέσιμα δεδομένα για προβολή';
$string['notallowedtoupdateprefremotely'] = 'Δεν έχετε το δικαίωμα να επεξεργαστείτε αυτή την προτίμηση χρήστη απομακρυσμένα';
$string['notavailable'] = 'Αυτό δεν είναι προσωρινά διαθέσιμο';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Δεν είστε μέλος αυτής της ομάδας μαθήματος';
$string['notownerofkey'] = 'Δεν είστε ο ιδιοκτήτης αυτού του κλειδιού';
$string['nousers'] = 'Δεν υπάρχει τέτοιος χρήστης!';
$string['oauth1accesstoken'] = 'Σφάλμα OAuth 1.0: Δεν λάβαμε το κουπόνι πρόσβασης.';
$string['oauth1requesttoken'] = 'Σφάλμα OAuth 1.0: Δεν λάβαμε το κουπόνι αίτησης - ο πάροχος υπηρεσιών ενδέχεται να είναι προσωρινά εκτός λειτουργίας.';
$string['oauth2refreshtokenerror'] = 'Δεν ήταν δυνατή η ανανέωση του κουπονιού OAuth 2. Κατάσταση HTTP για απομακρυσμένο τελικό σημείο: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Δεν ήταν δυνατή η ανανέωση του κουπονιού OAuth 2 για έναν ή περισσότερους εκδότες. Προβολή εξόδου εργασίας για λεπτομέρειες.';
$string['oauth2upgradetokenerror'] = 'Δεν ήταν δυνατή η αναβάθμιση του κουπονιού OAuth 2. Κατάσταση HTTP για απομακρυσμένο τελικό σημείο: {$a}';
$string['onlyadmins'] = 'Μόνον οι διαχειριστές μπορούν να το κάνουν αυτό.';
$string['onlyeditingteachers'] = 'Μόνον οι διδάσκοντες-συντάκτες μπορούν να το κάνουν αυτό.';
$string['onlyeditown'] = 'Μόνον τις δικές σας πληροφορίες μπορείτε να επεξεργαστείτε';
$string['orderidnotfound'] = 'Αδυναμία εύρεσης αναγνωριστικού σειράς {$a}';
$string['pagenotexist'] = '<p>Παρουσιάστηκε ασυνήθιστο σφάλμα· προσπάθεια προβολής μιας σελίδας που δεν υπάρχει:</p>{$a}';
$string['pagenotexisttitle'] = 'Σφάλμα 404: Αδυναμία εύρεσης αρχείου';
$string['pathdoesnotstartslash'] = 'Δεν δόθηκαν έγκυρες παράμετροι· το μονοπάτι πρέπει να αρχίζει με κάθετο!';
$string['pleasereport'] = 'Εάν έχετε χρόνο, παρακαλούμε ενημερώστε μας τι κάνατε όταν εμφανίστηκε το σφάλμα:';
$string['pluginrequirementsnotmet'] = 'Δεν εγκαταστάθηκε το πρόσθετο «{$a->pluginname}» ({$a->pluginversion}). Απαιτεί πιο νέα έκδοση του Moodle (αυτή τη στιγμή χρησιμοποιείτε {$a->currentmoodle}, χρειάζεστε {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Το πρόσθετο «{$a->pluginname}» {$a->pluginversion} δεν υποστηρίζει αυτήν την έκδοση του Moodle {$a->moodleversion}. Αναζητήστε πληροφορίες για το πρόσθετο για να βρείτε τις υποστηριζόμενες εκδόσεις.';
$string['prefixcannotbeempty'] = '<p>Σφάλμα: το πρόθεμα της βάσης δεν μπορεί να είναι κενή ({$a})</p>
<p>Ο διαχειριστής του ιστοτόπου θα πρέπει να διορθώσει αυτό το πρόβλημα.</p>';
$string['prefixtoolong'] = '<p>Σφάλμα: το πρόθεμα της βάσης είναι πολύ μεγάλη ({$a->dbfamily})</p>
<p>Ο διαχειριστής του ιστοτόπου θα πρέπει να διορθώσει αυτό το πρόβλημα. Το μέγιστο μήκος για το πρόθεμα των πινάκων στο {$a->dbfamily} είναι {$a->maxlength} χαρακτήρες.</p>';
$string['privatefilesupload'] = 'Το ανέβασμα απευθείας στην περιοχή ιδιωτικών αρχείων χρηστών δεν υποστηρίζεται πλέον. Ανεβάστε σε μια περιοχή προσχεδίων και στη συνέχεια, μετακινήστε τα αρχεία με core_user::add_user_private_files';
$string['processingstops'] = 'Η επεξεργασία σταματά εδώ. Τα εναπομείναντα αρχεία αγνοούνται.';
$string['protected_cc_not_supported'] = 'Δεν υποστηρίζονται προστατευμένα πακέτα μάθησης (Common Cartridge)';
$string['querystringcannotbeempty'] = 'Η συμβολοσειρά ερωτήματος δεν μπορεί να είναι κενή.';
$string['redirecterrordetected'] = 'Ανιχνεύτηκε μη υποστηριζόμενη ανακατεύθυνση. Τερματίστηκε η εκτέλεση δέσμης ενεργειών';
$string['refoundto'] = 'Μπορεί να σας επιστραφεί το ποσό {$a}';
$string['refoundtoorigi'] = 'Έγινε επιστροφή στο αρχικό ποσό: {$a}';
$string['registrationdisabled'] = 'Η καταχώρηση είναι απενεργοποιημένη σε αυτόν τον ιστότοπο';
$string['remotedownloaderror'] = '<p>Η λήψη του στοιχείου λογισμικού στον εξυπηρετητή σας απέτυχε. Παρακαλούμε επαληθεύστε τις ρυθμίσεις του διακομιστή μεσολάβησης· η επέκταση PHP cURL συνιστάται ιδιαίτερα.</p><br /><p>Πρέπει να κατεβάσετε το αρχείο <a href="{$a->url}">{$a->url}</a> χειροκίνητα, να το αντιγράψετε στο «{$a->dest}» στον εξυπηρετητή σας και να το αποσυμπιέσετε εκεί.</p>';
$string['remotedownloadnotallowed'] = 'Η λήψη στοιχείων λογισμικού στον εξυπηρετητή δεν επιτρέπεται (είναι απενεργοποιημένο το allow_url_fopen).<br /><br />Πρέπει να κατεβάσετε το αρχείο <a href="{$a->url}">{$a->url}</a> χειροκίνητα, αντιγράψτε το στο «{$a->dest}» στον εξυπηρετητή σας και αποσυμπιέστε το εκεί.';
$string['reportnotavailable'] = 'Αυτός ο τύπος αναφοράς είναι διαθέσιμος μόνο για το μάθημα ιστοτόπου';
$string['requirecorrectaccess'] = 'Μη έγκυρη διεύθυνση URL ή θύρα.';
$string['requireloginerror'] = 'Μάθημα ή δραστηριότητα μη προσβάσιμο/η.';
$string['restore_path_element_missingmethod'] = 'Η μέθοδος επαναφοράς {$a} λείπει. Πρέπει να οριστεί από έναν προγραμματιστή.';
$string['restore_path_element_noobject'] = 'Το αντικείμενο προς επαναφορά {$a} δεν είναι αντικείμενο.';
$string['restorechecksumfailed'] = 'Παρουσιάστηκε κάποιο πρόβλημα με τις πληροφορίες επαναφοράς που ήταν αποθηκευμένες στην σύνοδό σας. Ελέγξτε τα όρια μεγέθους της μνήμης PHP / πακέτων βάσης δεδομένων. Η επαναφορά σταμάτησε.';
$string['restrictedcontextexception'] = 'Λυπούμαστε, η εκτέλεση εξωτερικής διαδικασίας παραβιάζει περιορισμούς πλαισίου.';
$string['restricteduser'] = 'Συγγνώμη, αλλά ο τρέχων λογαριασμός σας «{$a}» δεν επιτρέπεται να το κάνει αυτό';
$string['reverseproxyabused'] = 'Έχει ενεργοποιηθεί ο Αντίστροφος διακομιστής μεσολάβησης (Reverse proxy). Ο εξυπηρετητής σας τώρα δεν είναι προσβάσιμος απευθείας. Λυπούμαστε για αυτό.<br />Παρακαλούμε επικοινωνήστε με το διαχειριστή του εξυπηρετητή σας.';
$string['rpcerror'] = 'Ωχ! Η επικοινωνία με το MNet απέτυχε! Ακολουθεί το μήνυμα σφάλματος για να το μεταβιβάσετε στον διαχειριστή σας: {$a}';
$string['scheduledbackupsdisabled'] = 'Η λήψη χρονοπρογραμματισμένων αντιγράφων ασφαλείας έχει απενεργοποιηθεί από το διαχειριστή του εξυπηρετητή';
$string['secretalreadyused'] = 'Ο σύνδεσμος αλλαγής κωδικού πρόσβασης έχει ήδη χρησιμοποιηθεί· ο κωδικός πρόσβασης δεν έχει αλλάξει';
$string['sectionnotexist'] = 'Αυτή η ενότητα δεν υπάρχει';
$string['sendmessage'] = 'Αποστολή μηνύματος';
$string['sendmessagesent'] = 'Ευχαριστούμε για την ανατροφοδότησή σας σχετικά με:<br>{$a}';
$string['serverconnection'] = 'Σφάλμα σύνδεσης με τον εξυπηρετητή';
$string['servicedonotexist'] = 'Η υπηρεσία δεν υπάρχει';
$string['sessioncookiesdisable'] = 'Λανθασμένη χρήση του require_key_login() - τα cookies συνόδου πρέπει να είναι απενεργοποιημένα!';
$string['sessiondiskfull'] = 'Η διαμέριση συνόδου (session partition) είναι πλήρης. Δεν είναι δυνατή η σύνδεση αυτή τη στιγμή. Παρακαλούμε ειδοποιήστε τον διαχειριστή του εξυπηρετητή';
$string['sessionerroruser'] = 'Ο διαθέσιμος χρόνος για την σύνοδό σας έχει πιθανότατα λήξει. Παρακαλούμε, συνδεθείτε ξανά.';
$string['sessionerroruser2'] = 'Ανιχνεύθηκε ένα σφάλμα στον εξυπηρετητή το οποίο επηρεάζει τη σύνοδο σύνδεσής σας. Παρακαλούμε, συνδεθείτε ξανά ή επανεκκινήστε τον περιηγητή σας.';
$string['sessionexpired'] = 'Η σύνοδος έληξε';
$string['sessionhandlerproblem'] = 'Λάθος ρυθμίσεων για το χειριστήριο της συνόδου';
$string['sessionipnomatch'] = 'Λυπούμαστε αλλά το IP σας φαίνεται να έχει αλλάξει από την πρώτη φορά που συνδεθήκατε. Αυτό το χαρακτηριστικό ασφαλείας εμποδίζει crackers από το να κλέψουν την ταυτότητά σας ενώ έχετε συνδεθεί σε αυτόν τον ιστότοπο. Οι κανονικοί χρήστες δε πρέπει να βλέπουν αυτό το μήνυμα - ζητήστε βοήθεια από το διαχειριστή του ιστοτόπου.';
$string['sessionipnomatch2'] = 'Λυπούμαστε αλλά το IP σας φαίνεται να έχει αλλάξει από την πρώτη φορά που συνδεθήκατε. Αυτό το χαρακτηριστικό ασφαλείας εμποδίζει crackers από το να κλέψουν την ταυτότητά σας ενώ έχετε συνδεθεί στον ιστότοπο. Μπορεί να δείτε αυτό το σφάλμα εάν χρησιμοποιείτε ασύρματο δίκτυο ή εάν μετακινείστε μεταξύ διαφορετικών δικτύων. Παρακαλούμε επικοινωνήστε με το διαχειριστή του ιστοτόπου σας για περισσότερη βοήθεια.<br /><br />Εάν επιθυμείτε να συνεχίσετε παρακαλούμε πιέστε το πλήκτρο F5 για να ανανεώσετε αυτή τη σελίδα.';
$string['sessionwaiterr'] = 'Εξαντλήθηκε ο χρόνος κατά την αναμονή για κλείδωμα συνόδου.<br />Περιμένετε να ολοκληρωθούν τα τρέχοντα αιτήματά σας και δοκιμάστε ξανά αργότερα.';
$string['shortnametaken'] = 'Το σύντομο όνομα χρησιμοποιείται ήδη από άλλο μάθημα ({$a})';
$string['sitepolicynotagreed'] = 'Δεν συμφωνήθηκε πολιτική ιστοτόπου: <a href="{$a}">Κάντε κλικ εδώ για να ανοίξετε την πολιτική ιστοτόπου.</a>';
$string['socksnotsupported'] = 'Ο SOCKS5 proxy δεν υποστηρίζεται στην PHP4';
$string['spellcheckernotconf'] = 'Ο spellchecker δεν έχει ρυθμιστεί';
$string['sslonlyaccess'] = 'Για λόγους ασφαλείας επιτρέπονται μόνο συνδέσεις https, λυπούμαστε.';
$string['statscatchupmode'] = 'Τα στατιστικά είναι σε φάση ενημέρωσης. Μέχρι τώρα έχει γίνει επεξεργασία {$a->daysdone} ημερών/-ας και εκκρεμούν/-εί {$a->dayspending}. Παρακαλούμε, ελέγξτε ξανά σύντομα!';
$string['statsdisable'] = 'Τα στατιστικά δεν είναι ενεργοποιημένα.';
$string['statsnodata'] = 'Δεν υπάρχουν διαθέσιμα δεδομένα για αυτόν το συνδυασμό μαθημάτων και χρονικών περιόδων';
$string['storedfilecannotcreatefile'] = 'Αδυναμία δημιουργίας αρχείου τοπικής δεξαμενής αρχείων. Παρακαλούμε, επαληθεύστε τα δικαιώματα στο dataroot και τον διαθέσιμο χώρο στο δίσκο.';
$string['storedfilecannotcreatefiledirs'] = 'Αδυναμία δημιουργίας φακέλου τοπικής δεξαμενής αρχείων. Παρακαλούμε επαληθεύστε τα δικαιώματα στο dataroot.';
$string['storedfilecannotread'] = 'Αδυναμία ανάγνωσης αρχείου, είτε το αρχείο δεν υπάρχει ή υπάρχουν προβλήματα δικαιωμάτων';
$string['storedfilecannotreadfile'] = 'Αδυναμία ανάγνωσης του αρχείου «{$a}». Είτε το αρχείο δεν υπάρχει είτε υπάρχει πρόβλημα δικαιωμάτων.';
$string['storedfilenotcreated'] = 'Αδυναμία δημιουργίας αρχείου «{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}»';
$string['storedfileproblem'] = 'Άγνωστη εξαίρεση σχετική με τοπικά αρχεία ({$a})';
$string['tagdisabled'] = 'Οι ετικέτες είναι απενεργοποιημένες!';
$string['tagnotfound'] = 'Αδυναμία εύρεσης της συγκεκριμένης ετικέτας στη βάση';
$string['targetdatabasenotempty'] = 'Η βάση-στόχος δεν είναι άδεια. Η μεταφορά εγκαταλείφθηκε για λόγους ασφαλείας.';
$string['textconditionsnotallowed'] = 'Οι συγκρίσεις συνθηκών στηλών κειμένου δεν επιτρέπονται. Παρακαλούμε, χρησιμοποιήστε τη συνάρτηση sql_compare_text() στο ερώτημά σας.';
$string['themenotinstall'] = 'Αυτό το αισθητικό θέμα δεν είναι εγκατεστημένο!';
$string['tokengenerationfailed'] = 'Δεν είναι δυνατή η δημιουργία νέου κουπονιού.';
$string['transactionvoid'] = 'Η συναλλαγή δεν μπορεί να ακυρωθεί επειδή έχει ακυρωθεί ήδη';
$string['unenrolerror'] = 'Προέκυψε σφάλμα κατά την ακύρωση εγγραφής του συγκεκριμένου ατόμου';
$string['unicodeupgradeerror'] = 'Λυπούμαστε, αλλά η βάση δεδομένων σας είναι ήδη σε Unicode κι αυτή η έκδοση του Moodle δεν μπορεί να κάνει τη μετεγκατάσταση (μεταφορά/μετατροπή) της βάσης σας σε Unicode. Παρακαλούμε πρώτα αναβαθμίστε σε Moodle 1.7.x κι μετά εκτελέστε τη μετεγκατάσταση σε Unicode από τη σελίδα του Διαχειριστή. Αφού έχει γίνει αυτό θα πρέπει να μπορείτε να κάνετε τη μετεγκατάσταση σε Moodle {$a}';
$string['unknowaction'] = 'Άγνωστη ενέργεια!';
$string['unknowcategory'] = 'Άγνωστη κατηγορία!';
$string['unknowcontext'] = 'Άγνωστο πλαίσιο ({$a}) στο get_child_contexts!';
$string['unknowformat'] = 'Άγνωστος μορφότυπος ({$a})';
$string['unknownbackupexporterror'] = 'Άγνωστο σφάλμα στην προετοιμασία πληροφοριών για εισαγωγή';
$string['unknownblockregion'] = 'Η περιοχή μπλοκ «{$a}» δεν αναγνωρίζεται σε αυτή τη σελίδα.';
$string['unknowncontext'] = 'Άγνωστο πλαίσιο.';
$string['unknowncourse'] = 'Άγνωστο μάθημα με όνομα «{$a}»';
$string['unknowncourseidnumber'] = 'Άγνωστο αναγνωριστικό μαθήματος «{$a}»';
$string['unknowncourserequest'] = 'Άγνωστη αίτηση δημιουργίας μαθήματος';
$string['unknowncoursesection'] = 'Άγνωστη ενότητα στο μάθημα «{$a}»';
$string['unknownevent'] = 'Άγνωστο γεγονός';
$string['unknownfiletype'] = 'Σφάλμα: άγνωστος τύπος φίλτρου';
$string['unknowngroup'] = 'Άγνωστη ομάδα «{$a}»';
$string['unknownhelp'] = 'Άγνωστο θέμα βοήθειας {$a}';
$string['unknownjsinrequirejs'] = 'Αδυναμία εύρεσης βιβλιοθήκης JavaScript: {$a}';
$string['unknownmodulename'] = 'Άγνωστο όνομα αρθρώματος για τη φόρμα';
$string['unknownrole'] = 'Άγνωστος ρόλος «{$a}»';
$string['unknownsortcolumn'] = 'Άγνωστη στήλη ταξινόμησης {$a}';
$string['unknownuseraction'] = 'Λυπούμαστε αλλά αυτή η ενέργεια χρήστη δεν είναι κατανοητή.';
$string['unknownuserselector'] = 'Άγνωστος επιλογέας χρήστη';
$string['unknoworder'] = 'Άγνωστη ταξινόμηση';
$string['unknowparamtype'] = 'Άγνωστος τύπος παραμέτρου: {$a}';
$string['unknowquestiontype'] = 'Μη υποστηριζόμενος τύπος ερώτησης {$a}';
$string['unknowuploadaction'] = 'Σφάλμα: Άγνωστη ενέργεια ανεβάσματος ({$a})';
$string['unspecifycourseid'] = 'Πρέπει να καθορίσετε αναγνωριστικό μαθήματος, σύντομο όνομα ή αναγνωριστικό αριθμό';
$string['unsupportedevent'] = 'Μη υποστηριζόμενος τύπος γεγονότος';
$string['unsupportedstate'] = 'Μη υποστηριζόμενη κατάσταση συμπλήρωσης';
$string['unsupportedwebserver'] = 'Λυπούμαστε αλλά το λογισμικό εξυπηρετητή δικτύου ({$a}) δεν υποστηρίζεται.';
$string['upgraderequires19'] = 'Σφάλμα: Εγκαταστάθηκε νέα έκδοση Moodle στον εξυπηρετητή σας. Δυστυχώς η αναβάθμιση από την προηγούμενη έκδοση δεν υποστηρίζεται.<br />Παρακαλούμε αναβαθμίστε πρώτα στην τελευταία κυκλοφορία/διανομή 1.9.x. Μπορείτε επίσης να επιστρέψετε στην προηγούμενη έκδοση με επανεγκατάσταση των αρχικών αρχείων.';
$string['upgraderunning'] = 'Ο ιστότοπος βρίσκεται υπό αναβάθμιση. Παρακαλούμε ξαναπροσπαθήστε αργότερα.';
$string['urlnotdefinerss'] = 'Δεν έχει οριστεί διεύθυνση URL για την τροφοδοσία RSS';
$string['useradmineditadmin'] = 'Μόνο διαχειριστές επιτρέπεται να τροποποιήσουν λογαριασμούς άλλων διαχειριστών';
$string['useradminodelete'] = 'Οι λογαριασμοί διαχειριστών δεν μπορούν να διαγραφούν.';
$string['userautherror'] = 'Άγνωστο πρόσθετο αυθεντικοποίησης';
$string['userauthunsupported'] = 'Το πρόσθετο αυθεντικοποίησης δεν υποστηρίζεται εδώ';
$string['useremailduplicate'] = 'Διπλότυπη διεύθυνση';
$string['usermustbemnet'] = 'Ο χρήστες στη λίστα ελέγχου πρόσβασης MNet πρέπει να είναι απομακρυσμένοι χρήστες MNet';
$string['usernamelowercase'] = 'Το όνομα χρήστη πρέπει να είναι με πεζά';
$string['usernotaddederror'] = 'Ο χρήστης δεν προστέθηκε - άγνωστο σφάλμα';
$string['usernotaddedregistered'] = 'Ο χρήστης δεν προστέθηκε - ήδη καταχωρημένος';
$string['usernotavailable'] = 'Οι λεπτομέρειες αυτού του χρήστη δεν είναι διαθέσιμες σε εσάς.';
$string['usernotdeletedadmin'] = 'Ο χρήστης δεν διαγράφηκε, καθώς οι λογαριασμοί διαχειριστών δεν μπορούν να διαγραφούν.';
$string['usernotdeleteddeleted'] = 'Ο χρήστης αυτός έχει ήδη διαγραφεί.';
$string['usernotdeletederror'] = 'Ο χρήστης δε διαγράφηκε - σφάλμα';
$string['usernotdeletedmissing'] = 'Ο χρήστης δε διαγράφηκε - δεν ήταν δυνατή η εύρεση του ονόματος χρήστη';
$string['usernotdeletedoff'] = 'Ο χρήστης δε διαγράφηκε - δεν επιτρέπεται η διαγραφή';
$string['usernotfullysetup'] = 'Ο χρήστης δεν ρυθμίστηκε πλήρως';
$string['usernotincourse'] = 'Ο χρήστης δεν υπάρχει σε αυτό το μάθημα!';
$string['usernotrenamedadmin'] = 'Αδυναμία μετονομασίας λογαριασμών διαχειριστών';
$string['usernotrenamedexists'] = 'Ο χρήστης δε μετονομάστηκε - το καινούργιο όνομα χρήστη χρησιμοποιείται ήδη.';
$string['usernotrenamedmissing'] = 'Ο χρήστης δε μετονομάστηκε - δεν ήταν δυνατή η εύρεση του παλιού ονόματος χρήστη.';
$string['usernotrenamedoff'] = 'Ο χρήστης δε μετονομάστηκε - η μετονομασία δεν επιτρέπεται';
$string['usernotupdatedadmin'] = 'Αδυναμία ενημέρωσης λογαριασμών διαχειριστών';
$string['usernotupdatederror'] = 'Ο χρήστης δεν ενημερώθηκε - σφάλμα';
$string['usernotupdatednotexists'] = 'Ο χρήστης δεν ενημερώθηκε - δεν υπάρχει';
$string['userquotalimit'] = 'Έχετε φτάσει το όριο ποσόστωσης αρχείων σας.';
$string['userselectortoomany'] = 'Ο user_selector έχει περισσότερους από έναν επιλεγμένους χρήστες, ακόμη κι αν το multiselect είναι ανενεργό.';
$string['verifyagedigitalconsentnotpossible'] = 'Λυπούμαστε! Η επαλήθευση ψηφιακής ηλικίας συγκατάθεσης δεν είναι δυνατή αυτή τη στιγμή.';
$string['wrongcall'] = 'Το σενάριο καλείται λανθασμένα';
$string['wrongcontextid'] = 'Το ID πλαισίου ήταν λανθασμένο (δεν είναι δυνατή η εύρεσή του)';
$string['wrongdestpath'] = 'Λανθασμένο μονοπάτι προορισμού.';
$string['wrongroleid'] = 'Λανθασμένο ID ρόλου!';
$string['wrongsourcebase'] = 'Λανθασμένη βάση πηγής URL.';
$string['wrongusernamepassword'] = 'Λάθος χρήστης / κωδικός πρόσβασης';
$string['wrongzipfilename'] = 'Λανθασμένο όνομα αρχείου ZIP.';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Δεν ήταν δυνατή η δημιουργία του μαθήματος - Δεν έχετε δικαίωμα';
$string['wwwrootmismatch'] = 'Ανιχνεύτηκε λανθασμένη πρόσβαση. Η πρόσβαση σε αυτόν τον εξυπηρετητή μπορεί να γίνει μόνον από τη διεύθυνση «{$a}»· λυπούμαστε.<br />Παρακαλούμε ενημερώστε τον διαχειριστή του εξυπηρετητή.';
$string['wwwrootslash'] = 'Ανιχνεύτηκε λανθασμένο $CFG->wwwroot στο config.php, πρέπει να περιέχει τελικά /.<br />Παρακαλούμε ενημερώστε το διαχειριστή του εξυπηρετητή.';
$string['xmldberror'] = 'Σφάλμα XMLDB!';
$string['youcannotdeletecategory'] = 'Δεν μπορείτε να διαγράψετε την κατηγορία «{$a}» επειδή δεν μπορείτε ούτε να διαγράψετε τα περιεχόμενα ούτε να τα μεταφέρετε αλλού.';
