<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'eu', version '4.3'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Sarbide-kontrola';
$string['actionaftercorrectanswer'] = 'Erantzun zuzenaren ondorengo ekintza';
$string['actionaftercorrectanswer_help'] = 'Galdera bati zuzen erantzun ondoren, 3 aukera daude hurrengo orrirako:

* Arrunta - Jarraitu ikasgararen ibilbideari
* Erakutsi ikusi gabeko orri bat - Ausaz erakutsiko dira orriak bi aldiz erakutsi gabe
* Erakutsi erantzun gabeko orri bat - Ausaz erakutsiko dira orriak, erantzun gabeko galderak dituzten orriak erreikatu gabe';
$string['actions'] = 'Ekintzak';
$string['activitylink'] = 'Esteka hurrengo jarduerara';
$string['activitylink_help'] = 'Ikasgaiaren amaieran ikastaroko beste jarduera baterako esteka eskaintzeko, aukeratu jarduera zabaltzen den menuan.';
$string['activitylinkname'] = 'Joan hona: {$a}';
$string['activityoverview'] = 'Egin gabeko ikasgaiak dituzu';
$string['addabranchtable'] = 'Gehitu eduki-orria';
$string['addanendofbranch'] = 'Gehitu adar-taularen amaiera';
$string['addanewpage'] = 'Gehitu orri berria';
$string['addaquestionpage'] = 'Gehitu galdera-orria';
$string['addaquestionpagehere'] = 'Gehitu galdera-orria hemen';
$string['addbranchtable'] = 'Gehitu eduki-orria';
$string['addcluster'] = 'Gehitu multzoa';
$string['addedabranchtable'] = 'Eduki-orria gehitu da';
$string['addedanendofbranch'] = 'Adar-taularen amaiera gehitu da';
$string['addedaquestionpage'] = 'Galdera-orria gehitu da';
$string['addedcluster'] = 'Multzoa gehitu da';
$string['addedendofcluster'] = 'Multzo-amaiera gehitu da';
$string['addendofbranch'] = 'Gehitu adar-taularen amaiera';
$string['addendofcluster'] = 'Gehitu multzo-amaiera';
$string['addessay'] = 'Sortu Entsegua-galdera orri bat';
$string['addmatching'] = 'Sortu Lotu galdera-orri bat';
$string['addmultichoice'] = 'Sortu Aukera-anizkoitzeko galdera-orri bat';
$string['addnewgroupoverride'] = 'Gehitu talde-salbuespena';
$string['addnewuseroverride'] = 'Gehitu erabiltzaile-salbuespena';
$string['addnumerical'] = 'Sortu Zenbakizko galdera-orri bat';
$string['addpage'] = 'Gehitu orria';
$string['addshortanswer'] = 'Sortu Erantzun laburreko galdera-orri bat';
$string['addtruefalse'] = 'Sortu Egia/gezurra galdera-orri bat';
$string['allotheranswers'] = 'Beste eztabaida guztiak';
$string['allotheranswersjump'] = 'Beste erantzun guztiek salto egiten dute';
$string['allotheranswersscore'] = 'Beste erantzun guztien lortzen dute';
$string['allowofflineattempts'] = 'Baimendu ikasgaia lineaz kanpo egiten saiatzea mobile aplikazioaren bitartez';
$string['allowofflineattempts_help'] = 'Gaituz gero, mobile aplikazioaren erabiltzaile batek ikasgaia jaitsi eta lineaz kanpo egiten saiatu daiteke. Galdera eta erantzun posible guztiak ere deskargatuko dira. Oharra: Ezin da ikasgaia lineaz kanpo egin denbora-muga bat badauka.';
$string['anchortitle'] = 'Eduki nagusiaren hasiera';
$string['and'] = 'ETA';
$string['answer'] = 'Erantzuna';
$string['answeredcorrectly'] = 'zuzen erantzunda.';
$string['answersfornumerical'] = 'Zenbakizko galderen erantzunek gehieneko eta gutxieneko balio-bikoteak izan behar dute';
$string['arrangebuttonshorizontally'] = 'Antolatu eduki-botoiak horizontalean?';
$string['attempt'] = 'Saiakera: {$a}';
$string['attemptheader'] = 'Saiakera';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '%{$a->grade} {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Saiakerak';
$string['attemptsdeleted'] = 'Ezabatutako saiakerak';
$string['attemptsremaining'] = '{$a} saiakera pendiente daukazu';
$string['available'] = 'Hasiera-data';
$string['averagescore'] = 'Batez besteko puntuazioa';
$string['averagetime'] = 'Batez besteko denbora';
$string['branch'] = 'Edukia';
$string['branchtable'] = 'Edukia';
$string['cachedef_overrides'] = 'Erabiltzaile eta talde-salbuespenen informazioa';
$string['cancel'] = 'Utzi';
$string['cannotfindanswer'] = 'Errorea: ezin da erantzuna aurkitu';
$string['cannotfindattempt'] = 'Errorea: ezin da saiakera aurkitu';
$string['cannotfindessay'] = 'Errorea: ezin da entsegua aurkitu';
$string['cannotfindfirstgrade'] = 'Errorea: ezin dira kalifikazioak aurkitu';
$string['cannotfindfirstpage'] = 'Ezin da lehenengo orria aurkitu';
$string['cannotfindgrade'] = 'Ezin da kalifikazioa aurkitu';
$string['cannotfindnewestgrade'] = 'Errorea: ezin da azken kalifikazioa aurkitu';
$string['cannotfindnextpage'] = 'Ikasgaiaren laguntza: ez da hurrengo orria aurkitu!';
$string['cannotfindpagerecord'] = 'Gehitu adarraren amaiera: ez da orriaren erregistroa aurkitu';
$string['cannotfindpages'] = 'Ezin dira Ikasgaiaren orriak aurkitu';
$string['cannotfindpagetitle'] = 'Baieztatu ezabaketa: ez da orriaren izenburua aurkitu';
$string['cannotfindpreattempt'] = 'Ez da aurreko saiakeraren erregistroa aurkitu!';
$string['cannotfindrecords'] = 'Errorea: ezin izan dira ikasgaiaren erregistroak aurkitu';
$string['cannotfindtimer'] = 'Errorea: ezin izan dira lesson_timer erregistroak aurkitu';
$string['cannotfinduser'] = 'Errorea: ezin dira erabiltzaileak aurkitu';
$string['canretake'] = '{$a} (e)k ikasgaia berriz har dezan baimendu';
$string['casesensitive'] = 'Erabil adierazpen erregularrak';
$string['casesensitive_help'] = 'Egin klik laukitxoan erantzunen analisian adierazpen erregularrak erabiltzeko.';
$string['checkbranchtable'] = 'Egiaztatu eduki-orria';
$string['checkedthisone'] = 'Hau egiaztatu da.';
$string['checknavigation'] = 'Egiaztatu nabigazioa';
$string['checkquestion'] = 'Egiaztatu galdera';
$string['classstats'] = 'Taldeko estatistikak';
$string['clicktodownload'] = 'Egin klik ondoko estekan fitxategia jaisteko.';
$string['closebeforeopen'] = 'Ezin da ikasgaia eguneratu. Ezarri duzun itxiera-data hasiera-data baino lehenagokoa da.';
$string['cluster'] = 'Multzoa';
$string['clusterjump'] = 'Multzo batean ikusi gabeko galdera';
$string['clustertitle'] = 'Multzoa';
$string['collapsed'] = 'Tolestua';
$string['comments'] = 'Zure iruzkinak';
$string['completed'] = 'Osatuta';
$string['completederror'] = 'Osatu ikasgaia';
$string['completethefollowingconditions'] = 'Jarraitzeko, baldintza hauek bete beharko dituzu <b>{$a}</b> ikasgaian.';
$string['completiondetail:reachend'] = 'Jardueraren amaierara arte igarotzea';
$string['completiondetail:timespent'] = 'Jardueran gutxienez {$a} ematea';
$string['completionendreached'] = 'Derrigorrezkoa da amaierara heltzea';
$string['completionendreached_desc'] = 'Ikasleak ikasgaiaren amaierara heldu behar du jarduera hau osatutzat emateko';
$string['completiontimespent'] = 'Ikasleak jarduera hau egin du gutxienez ondoko denbora-tartean';
$string['completiontimespentdesc'] = 'Erabiltzaileak gutxienez {$a} eman behar du jarduera egiten';
$string['completiontimespentgroup'] = 'Eman beharreko denbora';
$string['conditionsfordependency'] = 'Mendekotasun-baldintza(k)';
$string['configintro'] = 'Hemen zehaztutako balioak ikasgai jarduera berri bat sortzean balio lehenetsiak zehazteko erabiltzen dira. Ezarpen aurreratu gisa markatutakoak soilik \'Erakutsi gehiago...\' estekan klik egitean erakutsiko dira.';
$string['configmaxanswers'] = 'Lehenetsitako gehieneko erantzun-kopurua orriko';
$string['configmediaclose'] = 'Erakutsi itxiera-botoia estekatutako media-fitxategiarentzat zabaldutako popup leihoan.';
$string['configmediaheight'] = 'Estekatutako media-fitxategiaren popup leihoaren altuera zehazten du.';
$string['configmediawidth'] = 'Estekatutako media-fitxategiaren popup leihoaren zabalera zehazten du.';
$string['configpassword_desc'] = 'Ea pasahitza behar den ikasgaira sartzeko.';
$string['configslideshowbgcolor'] = 'Diapositiba-aurkezpenaren atzeko planoaren kolorea, gaituta egonez gero';
$string['configslideshowheight'] = 'Diapositiba-aurkezpenaren altuera zehazten du, gaituta egonez gero';
$string['configslideshowwidth'] = 'Diapositiba-aurkezpenaren zabalera zehazten du, gaituta egonez gero';
$string['configtimelimit_desc'] = 'Denbora-muga bat zehaztuz gero, ikasgaiaren hasieran ohar bat erakusten da eta atzera kontu bat erakusten da. Zero zehaztuz gero, ez dago denbora mugarik.';
$string['confirmdelete'] = 'Ezabatu orria';
$string['confirmdeletionofthispage'] = 'Ziurtatu orri hau ezabatu nahi duzula';
$string['congratulations'] = 'Zorionak! Ikasgaiaren amaierara iritsi zara';
$string['continue'] = 'Jarraitu';
$string['continuetoanswer'] = 'Jarraitu erantzunak aldatzeko.';
$string['continuetonextpage'] = 'Jarraitu hurrengo orrira.';
$string['correctanswerjump'] = 'Erantzun zuzenerako jauzia';
$string['correctanswerscore'] = 'Erantzun zuzenaren puntuazioa';
$string['correctresponse'] = 'Erantzun zuzena';
$string['createaquestionpage'] = 'Sortu galdera-orria';
$string['credit'] = 'Kreditua';
$string['customscoring'] = 'Puntuazio pertsonalizatua';
$string['customscoring_help'] = 'Gaituz gero, erantzun bakoitzari zenbakizko balioa (positiboa edo negatiboa) zehaztu beharko da.';
$string['deadline'] = 'Itxiera-data';
$string['defaultessayresponse'] = 'Zure entsegua irakasleak kalifikatuko du.';
$string['deleteallattempts'] = 'Ezabatu ikasgaiaren saiakera guztiak';
$string['deletedefaults'] = 'Lehenetsitako {$a} x ikasgai ezabatu da';
$string['deletedpage'] = 'Orria ezabatu da';
$string['deletepagenamed'] = 'Ezabatu orria: {$a}';
$string['deleting'] = 'Ezabatzen';
$string['deletingpage'] = 'Orria ezabatzen: {$a}';
$string['dependencyon'] = 'Honen menpekoa:';
$string['dependencyon_help'] = 'Ezarpen honek baimentzen du ikasgai honetarako sarbidea ikastaro bereko beste ikasgai batean lortutako emaitzaren araberakoa izatea. Erabilitako denbora, osatuta dagoen edo "kalifikazioa hau baino hobea" motako aldagaien edozein konbinaketa erabil daiteke.';
$string['description'] = 'Deskribapena';
$string['deselectallattempts'] = 'Desmarkatu saiakera guztiak';
$string['detailedstats'] = 'Estatistika zehatzak';
$string['didnotanswerquestion'] = 'Galdera honi ez diozu erantzunik eman.';
$string['didnotreceivecredit'] = 'Ez duzu krediturik jaso';
$string['disabled'] = 'Desgaituta';
$string['displaydefaultfeedback'] = 'Erabili lehenetsitako feedback-a';
$string['displaydefaultfeedback_help'] = 'Gaituz gero, galdera baten erantzuna aurkitzen ez bada "Hauxe da erantzun zuzena" edo "Hauxe da erantzun okerra" erantzun lehenetsia erakutsiko da.';
$string['displayinleftmenu'] = 'Menuan erakutsi?';
$string['displayleftif'] = 'Gutxieneko puntuazioa menua erakusteko';
$string['displayleftif_help'] = 'Ezarpen honek zehazten du ikasleak kalifikazio zehatz bat lortu behar duen ikasgaiaren menua ikusi ahal izateko. Honek ikaslea lehenengo saiakeran ikasgai osotik pasatzera behartzen du, eta ondoren, behar den kalifikazioa lortuz gero, berrikusketa egiteko menua ikusi ahal izango du.';
$string['displayleftmenu'] = 'Erakutsi menua';
$string['displayleftmenu_help'] = 'Gaituz gero, erabiltzaileari nabigatzeko aukera ematen dion orrien zerrenda erakusten duen menua erakusten da.';
$string['displaymode'] = 'Erakusteko modua';
$string['displayofgrade'] = 'Erakutsi kalifikazioa (ikasleentzat soilik)';
$string['displayreview'] = 'Eman aukera galderari berriz erantzuteko';
$string['displayreview_help'] = 'Gaituz gero, galdera bat modu okerrean erantzuten denean ikasleari puntuazioan eragin gabe berriz saiatzeko edo ikasgaiarekin jarraitzeko aukera ematen zaio. Ikasleak beste galdera batera mugitzeko klik egiten badu aukeratutako erantzuna (okerra) jarraituko da. Modu lehenetsian erantzun okerrek "orri honetara" salto egin eta 0 puntuazioa dute, eta beraz, ikasleen nahasmena ekiditeko, erantzun okerrak beste orri batera salto egiteko konfiguratzea gomendatzen da.';
$string['displayscorewithessays'] = '<p>Automatikoki kalifikatutako galderetan hau da zure puntuazioa: {$a->score}
posible zen gehieneko puntuazio honetatik: {$a->tempmaxgrade}.</p>
<p> {$a->essayquestions} entsegu motako galdera(k) beranduago kalifikatuko dira eta zure azken emaitzari erantsiko zaizkio aurrerago.</p>
<p>Oraingoz, eta entsegu-galdera(k) kontuan hartu gabe, zure emaitza {$a->score} (e)koa da {$a->grade} (e)tik</p>';
$string['displayscorewithoutessays'] = 'Zure puntuazioa hau da: {$a->score} (gehienekoa {$a->grade}(e)tik).';
$string['duplicatepagenamed'] = 'Bikoiztu orria: {$a}';
$string['edit'] = 'Editatu';
$string['editbranchtable'] = 'Eduki-orri bat editatzen';
$string['editcluster'] = 'Multzo bat editatzen';
$string['editendofbranch'] = 'Adar-taularen amaiera bat editatzen';
$string['editendofcluster'] = 'Multzo-amaiera bat editatzen';
$string['editessay'] = 'Entsegua-galdera orri bat editatzen';
$string['editinglesson'] = 'Ikasgaia editatzen';
$string['editingquestionpage'] = '{$a} galdera-orria editatzen';
$string['editlesson'] = 'Editatu ikasgaia';
$string['editlessonsettings'] = 'Editatu ikasgaiaren ezarpenak';
$string['editmatching'] = 'Lotu galdera-orri bat editatzen';
$string['editmultichoice'] = 'Aukera-anizkoitzeko galdera-orri bat editatzen';
$string['editnumerical'] = 'Zenbakizko galdera-orri bat editatzen';
$string['editoverride'] = 'Editatu salbuespena';
$string['editpage'] = 'Editatu orriaren edukiak';
$string['editpagecontent'] = 'Editatu orriaren edukiak';
$string['editquestion'] = 'Galderara-orria editatzen';
$string['editshortanswer'] = 'Erantzun laburreko galdera-orri bat editatzen';
$string['edittruefalse'] = 'Egia/gezurra galdera-orri bat editatzen';
$string['email'] = 'Posta elektronikoa';
$string['emailallgradedessays'] = 'Bidali kalifikatutako entseguen jakinarazpenak';
$string['emailgradedessays'] = 'Bidali kalifikatutako entseguen jakinarazpenak';
$string['emailsuccess'] = 'Jakinarazpenak ondo bidali dira';
$string['emptypassword'] = 'Pasahitza ezin da hutsik egon';
$string['enabled'] = 'Gaituta';
$string['endofbranch'] = 'Adarraren amaiera';
$string['endofcluster'] = 'Multzoaren amaiera';
$string['endofclustertitle'] = 'Multzoaren amaiera';
$string['endoflesson'] = 'Ikasgaiaren amaiera';
$string['enteredthis'] = 'hau sartuta.';
$string['enterpassword'] = 'Idatzi pasahitza, mesedez:';
$string['eolstudentoutoftime'] = 'Kontuz: Ikasgai hau egiteko finkatu zen denbora-epea gainditu duzu. Agian zure azken erantzuna ez da kontuan hartu epea amaitu ondoren eman baduzu.';
$string['eolstudentoutoftimenoanswers'] = 'Ez duzu erantzunik eman. Ikasgai honetan 0 puntu lortu duzu.';
$string['essay'] = 'Entsegua';
$string['essayemailmessage2'] = '<p>Entsegu-galderaren emaitza: {$a->question}</p><p>Zure erantzuna:<em>{$a->response}</em></p>
<p>{$a->teacher} iruzkinak:<em>{$a->comment}</em></p><p>Zuk {$a->outof}(e)tik {$a->earned} jaso duzu entsegu-galdera honetako.</p><p>Ikasgai honetan zure kalifikazioa aldatu egin da eta orain hau da: {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Entseguaren erantzun honengatik {$a->outof}(e)tik {$a->earned} lortu dituzu.</p><p>{$a->lesson} ikasgaiaren zure kalifikazioa %{$a->newgrade}(e)ra aldatu da.</p>';
$string['essayemailsubject'] = 'Ikasgai galderarako zure kalifikazioa eskuragarri dago';
$string['essaynotgradedyet'] = 'Saiakera hau ez da oraindik kalifikatu';
$string['essayresponses'] = 'Entseguaren erantzunak';
$string['essays'] = 'Entseguak';
$string['essayscore'] = 'Entseguaren puntuazioa';
$string['eventcontentpageviewed'] = 'Eduki-orria ikusi da';
$string['eventessayassessed'] = 'Entsegua ebaluatu da';
$string['eventessayattemptviewed'] = 'Entsegu-saiakera ikusi da';
$string['eventhighscoreadded'] = 'Ikasgaiaren gehieneko puntuazioa gehitu da';
$string['eventhighscoresviewed'] = 'Ikasgaiaren gehieneko puntuazioa ikusi da';
$string['eventlessonended'] = 'Ikasgaia amaitu da';
$string['eventlessonrestarted'] = 'Ikasi berriz hasi da';
$string['eventlessonresumed'] = 'Ikasgaiari berriz ekin zaio';
$string['eventlessonstarted'] = 'Ikasgaia hasi da';
$string['eventoverridecreated'] = 'Ikasgairako salbuespena sortu da';
$string['eventoverridedeleted'] = 'Ikasgairako salbuespena ezabatu da';
$string['eventoverrideupdated'] = 'Ikasgairako salbuespena eguneratu da';
$string['eventpagecreated'] = 'Orria sortu da';
$string['eventpagedeleted'] = 'Orria ezabatu da';
$string['eventpagemoved'] = 'Orria mugitu da';
$string['eventpageupdated'] = 'Orria eguneratu da';
$string['eventquestionanswered'] = 'Galdera erantzun da';
$string['eventquestionviewed'] = 'Galdera ikusi da';
$string['false'] = 'Gezurra';
$string['fileformat'] = 'Fitxategi-formatua';
$string['finalwrong'] = 'Ez da egokia.';
$string['finish'] = 'Amaitu';
$string['firstanswershould'] = 'Lehenengo erantzunak erantzun "Zuzena" orria jauzi egin behar luke';
$string['firstwrong'] = 'Zure erantzuna ez da zuzena izan. Berriz saiatu nahi al duzu? (Oraingoan ondo erantzunez gero ez da zure azken emaitzan zenbatuko).';
$string['flowcontrol'] = 'Ibilbidearen kontrola';
$string['fractionsaddwrong'] = 'Aukeratutako puntuazio positiboen batura ez da % 100<br />Batura %{$a} baino ez da.<br/> Nahi al duzu atzera jo eta galdera hau egokitu?';
$string['fractionsnomax'] = 'Erantzunetako batek %100 izan beharko luke, horrela<br/>erantzun honentzat gehieneko nota lortzea posible izan dadin.<br/>Atzera bueltatu nahi duzu arazoa konpontzeko?';
$string['full'] = 'Zabaldua';
$string['general'] = 'Orokorra';
$string['gotoendoflesson'] = 'Joan ikasgaiaren amaierara';
$string['grade'] = 'Kalifikazioa';
$string['gradebetterthan'] = 'Kalifikazioa (%) baino handiagoa';
$string['gradebetterthanerror'] = 'Ehuneko {$a} baino kalifikazio handiagoa lortu';
$string['graded'] = 'Kalifikatua';
$string['gradeessay'] = 'Kalifikatu entsegu galderak ({$a->notgradedcount} kalifikatu gabe eta {$a->notsentcount} bidali gabe)';
$string['gradeis'] = 'Kalifikazioa {$a} da';
$string['gradeoptions'] = 'Kalifikazio-aukerak';
$string['groupoverrides'] = 'Talde-salbuespenak';
$string['groupoverridesdeleted'] = 'Talde-salbuespenak ezabatu dira';
$string['groupsnone'] = 'Ez dago sarbidea duzun talderik.';
$string['handlingofretakes'] = 'Saiakera errepikatuen erabilera';
$string['handlingofretakes_help'] = 'Ikasgaia berriz egitea baimenduz gero, ezarpen honek zehazten du ikasgaiaren kalifikazioa saiakera guztien arteko media ala altuena izango den.';
$string['havenotgradedyet'] = 'Oraindik ez kalifikatua.';
$string['here'] = 'hemen';
$string['highscore'] = 'Puntuazio altua';
$string['hightime'] = 'Denbora altua';
$string['importcount'] = '{$a} galderak inportatzen';
$string['importquestions'] = 'Inportatu galderak';
$string['importquestions_help'] = 'Funtzio honek testu-fitxategietatik hainbat formatutako galderak inportatzeko aukera ematen du.';
$string['inactiveoverridehelp'] = '* Salbuespen hau ez-aktibo dago erabiltzailearen jarduerarako sarbidea murriztuta dagoelako. Honen arrazoia taldeko edo rol-esleipena izan daiteke, bestelako eskuragarritasun murrizketak edo jarduera ezkutuan egotea.';
$string['indicator:cognitivedepth'] = 'Gaitasun kognitiboa ikasgaietan';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak Ikasgaia motako jardueretan lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:cognitivedepthdef'] = 'Gaitasun kognitiboa ikasgaietan';
$string['indicator:cognitivedepthdef_help'] = 'Partaide honek Ikasgaia jarduerak eskaintzen duen gaitasun kognitiboaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Ikusi gabe, Ikusi da, Bidali da, Feedbacka ikusi da, Feedbackari iruzkina egin da, Feedback ikusi ondoren berriz bidali da)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Gaitasun soziala ikasgaietan';
$string['indicator:socialbreadth_help'] = 'Helburu hau ikasleak Ikasgaia motako jardueretan lortutako zabalera sozialean oinarrituta dago.';
$string['indicator:socialbreadthdef'] = 'Gaitasun soziala ikasgaietan';
$string['indicator:socialbreadthdef_help'] = 'Partaide honek Ikasgaia jarduerak eskaintzen duen gaitasun sozialaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Parte-hartzerik ez, bakarkako parte-hartzea, parte-hartzea besteekin)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Txertatutako orria';
$string['invalidfile'] = 'Fitxategi baliogabea';
$string['invalidid'] = 'Ez da modulu edo ikasgaiaren ID gainditu ikastaroan';
$string['invalidlessonid'] = 'Ikasgaiaren IDa ez da egokia';
$string['invalidoverrideid'] = 'Salbuespenaren ID baliogabea';
$string['invalidpageid'] = 'Orriaren ID baliogabea';
$string['jump'] = 'Jauzia';
$string['jumps'] = 'Jauziak';
$string['jumps_help'] = 'Erantzun (galderetarako) edo deskribapen (eduki-orrietarako) bakoitzak dagokion jauzia du. Jauzia erlatiboa izan daiteke, horri hau edo hurrengo orria, adibidez, edo erabatekoa, ikasgaiko orrietako bat zehaztuta.';
$string['jumpsto'] = '<em>{$a}</em>rako jauziak';
$string['leftduringtimed'] = 'Denbora-epe finkoko ikasgaia eten da.<br/>Berriz hasteko egin klik "Jarraitu" botoian, mesedez.';
$string['leftduringtimednoretake'] = 'Denbora-epe finkoko ikasgaia eten da eta<br/>ez dago berriz hasteko edo jarraitzeko baimenik.';
$string['leftduringtimedsession'] = 'Denbora neurtua zuen ikasgai batetik irten zara.';
$string['lesson:addinstance'] = 'Gehitu ikasgai berria';
$string['lesson:edit'] = 'Editatu ikasgaia';
$string['lesson:grade'] = 'Kalifikatu ikasgaiaren entsegu motako galderak';
$string['lesson:manage'] = 'Kudeatu ikasgaia';
$string['lesson:manageoverrides'] = 'Kudeatu ikasgai-salbuespenak';
$string['lesson:view'] = 'Ikusi ikasgaia';
$string['lesson:viewreports'] = 'Ikusi ikasgaiaren txostenak';
$string['lessonbeingpreviewed'] = 'Ikasgaia aurreikusia izaten ari da une honetan.';
$string['lessonclosed'] = 'Ikasgai hau {$a} egunean itxi zen.';
$string['lessoncloses'] = 'Ikasgaia ixten da';
$string['lessoneventcloses'] = '{$a}(r)en itxiera-data:';
$string['lessoneventopens'] = '{$a}(r)en hasiera-data';
$string['lessonformating'] = 'Ikasgaia formateatzen';
$string['lessonmenu'] = 'Ikasgaiaren menua';
$string['lessonnotready'] = 'Ikasgai hau ez dago praktikatzeko prest. Zure {$a} (r)ekin harremanetan jarri, mesedez.';
$string['lessonnotready2'] = 'Ikasgai hau ez dago prest.';
$string['lessonopen'] = 'Ikasgai hau {$a} egunean irekiko da.';
$string['lessonopens'] = 'Ikasgaia ireki da';
$string['lessonpagelinkingbroken'] = 'Ez da lehenengo orririk aurkitu. Seguru aski ikasgaiaren orriarekiko esteka hautsita dago. Administratzailearekin harremanetan jarri, mesedez.';
$string['lessonstats'] = 'Ikasgaiaren estatistikak';
$string['linkedmedia'] = 'Estekatutako media';
$string['loginfail'] = 'Sarrerak huts egin du. Saiatu berriro, mesedez...';
$string['lowscore'] = 'Puntuazio baxua';
$string['lowtime'] = 'Denbora baxua';
$string['manageoverrides'] = 'Kudeatu baliogabetzeak';
$string['manualgrading'] = 'Kalifikatu entseguak';
$string['matchesanswer'] = 'Erantzunarekin bat dator';
$string['matching'] = 'Lotu';
$string['matchingpair'] = 'Lotzeko {$a}. bikotea';
$string['maxgrade'] = 'Gehieneko kalifikazioa';
$string['maxgrade_help'] = 'Balio honek ikasgai batean lor daitekeen gehieneko kalifikazioa adierazten du. 0 ezarriz gero, ikasgaia ez da kalifikazio-orrietan agertuko.';
$string['maximumnumberofanswersbranches'] = 'Gehieneko erantzun-kopurua';
$string['maximumnumberofanswersbranches_help'] = 'Ezarpen honek ikasgaian erabili ahalko den gehieneko erantzun-kopurua zehazten du. Egia/gezurra galderak soilik erabiltzen badira, 2 ezar daiteke. Edonoiz alda daiteke ezarpen hau, soilik irakasleak ikusten duenari eragiten diolako eta ez datuei.';
$string['maximumnumberofattempts'] = 'Gehieneko saiakera-kopurua galderako';
$string['maximumnumberofattempts_help'] = 'Ezarpen honek zehazten du galdera bakoitzeko gehieneko saiakera-kopurua. Hainbat aldiz oker erantzunda gehieneko hori gainditzen denean, ikasgaiko hurrengo orria erakutsiko da.';
$string['maximumnumberofattemptsreached'] = 'Gehieneko saiakera-kopurura iritsi zara. Hurrengo orrira jauzi';
$string['mediaclose'] = 'Erakutsi ixteko botoia';
$string['mediafile'] = 'Estekatutako media';
$string['mediafile_help'] = 'Media-fitxategi bat igo daiteke ikasgaian erabiltzeko. \'Egin klik hemen ikusteko\' esteka erakutsiko da \'Estekatutako media\' izeneko blokean ikasgaiaren orri bakoitzean.';
$string['mediafilepopup'] = 'Egin klik hemen ikusteko';
$string['mediaheight'] = 'Popup leihoaren altuera';
$string['mediawidth'] = 'Popup leihoaren zabalera';
$string['messageprovider:graded_essay'] = 'Ikasgaiaren entsegua kalifikatu izanaren jakinarazpena';
$string['minimumnumberofquestions'] = 'Gutxieneko galdera-kopurua';
$string['minimumnumberofquestions_help'] = 'Ezarpen honek zehazten du jardueraren kalifikazioa kalkulatzeko erabiliko den gutxieneko galdera-kopurua.';
$string['missingname'] = 'Mesedez, idatzi goitizena';
$string['modattempts'] = 'Baimendu ikaslearen berrikuspena';
$string['modattempts_help'] = 'Gaituz gero, ikasleek ikasgaian zehar nagiba dezakete eta berriz hasierara itzuli.';
$string['modattemptsnoteacher'] = 'Ikaslearen berrikuspena soilik ikasleen eskura dago.';
$string['modulename'] = 'Ikasgaia';
$string['modulename_help'] = 'Ikasgaiak edukiak edota aktibitateak era malgu eta interesgarrian aurkezteko aukera ematen dio irakasleari. Irakasleak ikasgaia hezkuntza-eduki edo aktibitateen multzo lineal bat sortzeko erabil dezake, ikasleari hainbat aukera eta ibilbide eskainiz. Edonola ere, ikasleen parte-hartzea areagotzeko eta ulermena bermatzeko irakasleak galdera mota ezberdinak erabil ditzake, hala nola aukera anizkoitzekoak, lotzekoak edo erantzun motzekoak. Ikasle bakoitzaren erantzunaren arabera eta irakasleak ikasgaia garatu duen moduaren arabera ikaslea hurrengo orrira pasatuko da, aurreko orri batera itzuliko da edo ibilbide erabat ezberdin batera berbideratua izango da.

Ikasgai bat ebalua daiteke, eta kalifikazioa kalifikazio-liburuan gordetzen da.

Ikasgaiak ondokoetarako erabil daitezke

* Gai berri bateko ikasketa auto-gidatua egiteko
* Erabaki-hartze egoeren eta simulazio-ariketak egiteko
* Bereizitako birpasorako ariketak egiteko, birpasorako galdera-multzo ezberdinekin, aurreko galderei erantzundakoaren araberakoak.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Ikasgaiak';
$string['move'] = 'Mugitu orria';
$string['movedpage'] = 'Orria mugitu da';
$string['movepagehere'] = 'Mugitu orria hona';
$string['movepagenamed'] = 'Mugitu orria: {$a}';
$string['moving'] = 'Orria mugitzen: {$a}';
$string['multianswer'] = 'Erantzun anizkoitza';
$string['multianswer_help'] = 'Egin klik laukitxoan aukera bat baino gehiago zuzena bada.';
$string['multichoice'] = 'Aukera anizkoitza';
$string['multipleanswer'] = 'Erantzun anizkoitza';
$string['nameapproved'] = 'Izena onartu da';
$string['namereject'] = 'Sentitzen dugu. Iragazkiak ez du zure izena onartu.<br/>Beste izen batekin saiatu, mesedez.';
$string['new'] = 'berria';
$string['nextpage'] = 'Hurrengo orria';
$string['noanswer'] = 'Galdera batek edo gehiagok ez du erantzunik. Mesedez, joan atzera eta osatu.';
$string['noattemptrecordsfound'] = 'Ez da saiakeren erregistrorik aurkitu. Kalifikaziorik gabe';
$string['nobranchtablefound'] = 'Ez da eduki-orririk aurkitu';
$string['noclose'] = 'Ez dago itxiera-datarik';
$string['nocommentyet'] = 'Iruzkinik ez oraindik.';
$string['nocoursemods'] = 'Ez da jarduerarik aurkitu';
$string['nocredit'] = 'Ez duzu krediturik';
$string['nodeadline'] = 'Ez dago eperik';
$string['noessayquestionsfound'] = 'Ikasgai honetan ez da entsegu-galderarik aurkitu.';
$string['nohighscores'] = 'Ez dago gehinezko puntuaziorik';
$string['nolessonattempts'] = 'Ez da ikasgai hau praktikatzeko saiakerarik egin.';
$string['nolessonattemptsgroup'] = '{$a} taldeko partaideek ez dute saiakerarik egin ikasgai honetan.';
$string['none'] = 'Bat ere ez';
$string['nooneansweredcorrectly'] = 'Inork ez du ondo erantzun.';
$string['nooneansweredthisquestion'] = 'Inork ez du galdera hau erantzun.';
$string['noonecheckedthis'] = 'Inork ez du hau egiaztatu.';
$string['nooneenteredthis'] = 'Inork ez du hau sartu.';
$string['noonehasanswered'] = 'Inork ez dio entsegu-galderari oraingoz erantzun.';
$string['noonehasansweredgroup'] = 'Hemengo Inork ({$a}) ez dio entsegu-galderari oraingoz erantzun.';
$string['noopen'] = 'Ez dago hasiera-datarik';
$string['nooverridecreated'] = 'Ez da baliogabetzerik sortu.';
$string['nooverridedata'] = 'Gutxienez ikasgaiaren ezarpen baten salbuespena egin behar duzu.';
$string['noretake'] = 'Ezin duzu ikasgai hau berriz hasi.';
$string['normal'] = 'Normala - jarraitu ikasgaiaren ibilbidea';
$string['notcompleted'] = 'Ez osatua';
$string['notcompletedwithdate'] = '({$a}) ez osatua';
$string['notdefined'] = 'Definitu gabe';
$string['notenoughsubquestions'] = 'Azpigaldera nahikorik ez duzu definitu!<br />Atzera joan nahi duzu arazoa konpontzeko?';
$string['notenoughtimespent'] = 'Ikasgai hau osatzeko {$a->timespent} behar izan duzu, eta hori behar den denbora ({$a->timerequired}) baino gutxiago da. Agian ikasgaia berriz egiten saiatu beharko zara.';
$string['notgraded'] = 'Kalifikatu gabea';
$string['notitle'] = 'Izenbururik gabe';
$string['notyetcompleted'] = 'Ikasgaia hasita dago baina osatu gabe oraindik';
$string['numberofcorrectanswers'] = 'Erantzun zuzenen kopurua: {$a}';
$string['numberofcorrectanswersheader'] = 'Erantzun zuzenen kopurua';
$string['numberofcorrectmatches'] = 'Ondo osatutako bikote kopurua: {$a}';
$string['numberofpagestoshow'] = 'Erakutsi beharreko orriak';
$string['numberofpagestoshow_help'] = 'Ezarpen honek ikasgaian erakutsi beharreko orri-kopurua zehazten du. Ausazko ordenan erakusten diren orriak dituzten ikasgaietan soilik du eragina ("Erantzun zuzenaren ondorengo ekintza" aukeran "Erakutsi ikusi ez den orri bat" edo "Erakutsi erantzun ez den orri bat" zehaztuta). Zero ezarriz gero orri guztiak erakutsiko dira.';
$string['numberofpagesviewed'] = 'Erantzundako galdera-kopurua: {$a}';
$string['numberofpagesviewedheader'] = 'Erantzundako galdera-kopura';
$string['numberofpagesviewednotice'] = 'Erantzundako galdera-kopurua: {$a->nquestions}; (Gutxienez, {$a->minquestions} erantzun beharko zenituzke).';
$string['numerical'] = 'Zenbakizkoa';
$string['numericanswer'] = 'Erantzun numerikoa';
$string['numericanswer_help'] = 'Zenbaki bat edo zenbaki tarte bat zehaztu dezakezu bi puntu (:) erabilita. Esaterako 2:5 zehaztuta 2 eta 5 arteko erantzunak zuzentzat emango dira, biak barne.';
$string['offlinedatamessage'] = 'Saiakera honetan gailu mugikor batetik lan egin duzu. Datuak azkenengoz duela {$a} gorde ziren. Mesedez konprobatu ez duzula gorde gabeko aldaketarik.';
$string['ongoing'] = 'Erakutsi metatutako puntuazioa';
$string['ongoing_help'] = 'Gaituz gero, orri bakoitzak ikasleak lor daitezkeen puntu guztietatik zenbat lortu duen erakustiko du.';
$string['ongoingcustom'] = 'Ikasgai hau gehienez {$a->score} punturekin balioesten da. Zuk {$a->score} puntu lortu duzu gehieneko {$a->currenthigh} puntutatik.';
$string['ongoingnormal'] = 'Zuk {$a->viewed} galderatik {$a->correct} ondo erantzun duzu.';
$string['onpostperpage'] = 'Mezu bakarra kalifikazioko';
$string['openafterclose'] = 'Zehaztu duzun hasiera-data itxiera-data baino beranduagokoa da.';
$string['options'] = 'Aukerak';
$string['or'] = 'edo';
$string['ordered'] = 'Ordenatua';
$string['other'] = 'Bestelakoak';
$string['outof'] = '{$a} (e)tik kanpo';
$string['override'] = 'Salbuespena';
$string['overridedeletegroupsure'] = 'Ziur zaude {$a} talderako salbuespena ezabatu nahi duzula?';
$string['overridedeleteusersure'] = 'Ziur zaude {$a} erabiltzailearentzako salbuespena ezabatu nahi duzula?';
$string['overridegroup'] = 'Salbuetsitako taldea';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Salbuespenak';
$string['overrideuser'] = 'Salbuetsitako erabiltzailea';
$string['overrideusereventname'] = '{$a->lesson} - Salbuespena';
$string['overview'] = 'Laburpena';
$string['overview_help'] = 'Ikasgaia hainbat orriz eta aukeran eduki-orriz osatuta dago. Orri batek eduki bat du eta normaleak galdera batekin bukatzen da. Galderaren erantzun bakoitzarekin jauzi bat dago lotuta. Jauzia erlatiboa izan daiteke, orri hau edo hurrengo orria, adibidez; edo erabatekoa, ikasgaiko orrietako bat zehaztuta. Eduki-orria ikasgaiko beste orri batzuetarako estekak dituen orria da, adibidez Edukien taula bat.';
$string['page'] = 'Orria: {$a}';
$string['page-mod-lesson-edit'] = 'Editatu ikasgaiaren orria';
$string['page-mod-lesson-view'] = 'Ikusi edo aurreikusi ikasgaiaren orria';
$string['page-mod-lesson-x'] = 'Ikasgaiaren edozein orri';
$string['pageanswers'] = 'Orriaren erantzunak';
$string['pagecontents'] = 'Orriaren edukiak';
$string['pageresponses'] = 'Orriaren erantzunak';
$string['pages'] = 'Orriak';
$string['pagetitle'] = 'Orriaren izenburua';
$string['password'] = 'Pasahitza';
$string['passwordprotectedlesson'] = '{$a} pasahitzaz babestutako ikasgaia da.';
$string['pleasecheckoneanswer'] = 'Aukeratu erantzun bat';
$string['pleasecheckoneormoreanswers'] = 'Aukeratu erantzun bat edo gehiago';
$string['pleaseenteryouranswerinthebox'] = 'Idatzi zure erantzuna kutxan, mesedez';
$string['pleasematchtheabovepairs'] = 'Bikote hauen arteko harremana aurkitu, mesedez';
$string['pluginadministration'] = 'Ikasgaiaren kudeaketa';
$string['pluginname'] = 'Ikasgaia';
$string['pointsearned'] = 'Irabazitako puntuak';
$string['postprocesserror'] = 'Errorea gertatu da prozesamenduaren ostean!';
$string['postsuccess'] = 'Mezu arrakastatsua';
$string['practice'] = 'Praktikako ikasgaia';
$string['practice_help'] = 'Praktikako ikasgaiak ez dira kalifikazio-liburuan erakustiko.';
$string['preprocesserror'] = 'Errorea gertatu da prozesamenduaren aurretik!';
$string['prerequisiteisobsolete'] = 'Aurretik egin beharreko ikasgaiaren aukera ezabatua izango da. Mesedez horiek eskuragarritasun murrizketekin ordezkatu ezazu.';
$string['prerequisitelesson'] = 'Aurretik egin beharreko ikasgaia';
$string['preview'] = 'Aurreikusi';
$string['previewlesson'] = 'Aurreikusi {$a}';
$string['previewpagenamed'] = 'Aurreikusi orria: {$a}';
$string['previouspage'] = 'Aurreko orria';
$string['privacy:metadata:attempts'] = 'Orri-saiakeren erregistroa';
$string['privacy:metadata:attempts:answerid'] = 'Erantzunaren IDa';
$string['privacy:metadata:attempts:correct'] = 'Saiakerak erantzun zuzena izan duen edo ez';
$string['privacy:metadata:attempts:pageid'] = 'Orriaren IDa';
$string['privacy:metadata:attempts:retry'] = 'Saiakeraren zenbakia';
$string['privacy:metadata:attempts:timeseen'] = 'Saiakera egin zeneko unea';
$string['privacy:metadata:attempts:useranswer'] = 'Erabiltzailearen erantzunaren inguruko xehetasunak';
$string['privacy:metadata:attempts:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:branch'] = 'Ikusitako orrien erregistroa';
$string['privacy:metadata:branch:flag'] = 'Hurrengo orria ausaz kalkulatuko den edo ez';
$string['privacy:metadata:branch:nextpageid'] = 'Hurrengo orriaren IDa';
$string['privacy:metadata:branch:pageid'] = 'Orriaren IDa';
$string['privacy:metadata:branch:retry'] = 'Saiakeraren zenbakia';
$string['privacy:metadata:branch:timeseen'] = 'Orria ikusi zeneko unea';
$string['privacy:metadata:branch:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:grades'] = 'Ikasgai bakoitzeko kalifikazioen erregistroa';
$string['privacy:metadata:grades:completed'] = 'Kalifikazioa eman zeneko data';
$string['privacy:metadata:grades:grade'] = 'Emandako kalifikazioa';
$string['privacy:metadata:grades:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:overrides'] = 'Ikasgai bakoitzeko salbuespenen erregistroa';
$string['privacy:metadata:overrides:available'] = 'Ikasgaian saiakerak egiten hasi daitezkeen unea';
$string['privacy:metadata:overrides:deadline'] = 'Ikasgaia osatzeko itxiera-data.';
$string['privacy:metadata:overrides:maxattempts'] = 'Gehieneko saiakera kopurua';
$string['privacy:metadata:overrides:password'] = 'Ikasgaian sartzeko pasahitza';
$string['privacy:metadata:overrides:retake'] = 'Saiakerak errepikatu daitezkeen edo ez';
$string['privacy:metadata:overrides:review'] = 'Galdera bat erantzuten berriz saiatzea baimenduta dagoen edo ez';
$string['privacy:metadata:overrides:timelimit'] = 'Ikasgaia osatzeko denbora-muga (segundoetan).';
$string['privacy:metadata:overrides:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:timer'] = 'Ikasgai-saiakeraren erregistroa';
$string['privacy:metadata:timer:completed'] = 'Saiakera osatu den edo ez';
$string['privacy:metadata:timer:lessontime'] = 'Jarduera jaso zen azken unea';
$string['privacy:metadata:timer:starttime'] = 'Saiakera hasi zeneko unea';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Mobile aplikaziotik jarduera jaso zen azken unea';
$string['privacy:metadata:timer:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:userpref:lessonview'] = 'Hobetsitako ikasgaiak editatzeko erakusketa-modua';
$string['privacy:path:essayanswers'] = 'Entseguaren erantzunak';
$string['privacy:path:essayresponses'] = 'Entseguaren erantzunak';
$string['privacy:path:pages'] = 'Orriak';
$string['processerror'] = 'Errorea gertatu da prozesamenduan!';
$string['progressbar'] = 'Aurrerapen-barra';
$string['progressbar_help'] = 'Gaituz gero, ikasgaiaren orrien beheko aldean osatze-mailaren gutxi gorabeherako ehunekoaren barra bat erakutsiko da.';
$string['progressbarteacherwarning'] = '{$a}(e)k ez du aurrerapen-barra ikusten';
$string['progressbarteacherwarning2'] = 'Ikasgaia editatzeko baimena duzunez, zuk ez duzu aurrerapen-barra ikusiko';
$string['progresscompleted'] = 'Ikasgai honen % {$a} osatu duzu';
$string['qtype'] = 'Orri mota';
$string['question'] = 'Galdera';
$string['questionoption'] = 'Galdera';
$string['questiontype'] = 'Galdera mota';
$string['randombranch'] = 'Ausazko eduki-orria';
$string['randompageinbranch'] = 'Eduki-orri baten barruko ausazko galdera';
$string['rank'] = 'Bitartea';
$string['rawgrade'] = 'Puntuazio gordina';
$string['receivedcredit'] = 'Kreditu jasoa';
$string['redisplaypage'] = 'Orria berriz erakutsi';
$string['removeallgroupoverrides'] = 'Ezabatu talde-salbuespen guztiak';
$string['removealluseroverrides'] = 'Ezabatu erabiltzaile-salbuespen guztiak';
$string['report'] = 'Txostena';
$string['reports'] = 'Txostenak';
$string['response'] = 'Erantzuna';
$string['retakesallowed'] = 'Ikasgaia berriz hastea baimenduta';
$string['retakesallowed_help'] = 'Gaituz gero, ikasleek behin baino gehiagotan erantzun ahal diote ikasgaiari.';
$string['returnto'] = 'Itzuli hona: {$a}';
$string['returntocourse'] = 'Ikastarora itzuli';
$string['reverttodefaults'] = 'Itzuli ikasgaiaren balio lehenetsietara';
$string['review'] = 'Berrikuspena';
$string['reviewlesson'] = 'Berrikusi ikasgaia';
$string['reviewquestionback'] = 'Bai, berriz saiatu nahiko nuke';
$string['reviewquestioncontinue'] = 'Ez, hurrengora pasa nahi dut';
$string['sanitycheckfailed'] = '\'Sanity Check-ek\' huts egin du: Saiakera hau ezabatu da';
$string['save'] = 'Gorde';
$string['savechanges'] = 'Gorde aldaketak';
$string['savechangesandeol'] = 'Gorde aldaketa guztiak eta joan ikasgaiaren amaierara.';
$string['saveoverrideandstay'] = 'Gorde eta sartu beste salbuespen bat';
$string['savepage'] = 'Gorde orria';
$string['score'] = 'Puntuazioa';
$string['score_help'] = 'Ikasgaiaren ezarpenetan puntuazio pertsonalizatua gaituta badago, erantzun bakoitzari zenbakizko balioa (positiboa edo negatiboa) zehaztu beharko da.';
$string['scores'] = 'Puntuazioak';
$string['search:activity'] = 'Ikasgaia - jardueraren informazioa';
$string['secondpluswrong'] = 'Ez. Berriz saiatu nahi al duzu?';
$string['selectallattempts'] = 'Aukeratu saiakera guztiak';
$string['selectaqtype'] = 'Aukeratu galdera-mota';
$string['selectreport'] = 'Aukeratu txostena';
$string['sent'] = 'Bidali da';
$string['shortanswer'] = 'Erantzun laburra';
$string['showanunansweredpage'] = 'Erakutsi erantzun ez den orri bat';
$string['showanunseenpage'] = 'Erakutsi ikusi ez den orri bat';
$string['singleanswer'] = 'Erantzun bakar bat';
$string['skip'] = 'Utzi alde batera nabigazioa';
$string['slideshow'] = 'Diaporama';
$string['slideshow_help'] = 'Gaituz gero, ikasgaia diaporama gisa erakutsiko da, altuera eta zabalera finkoa duela.';
$string['slideshowbgcolor'] = 'Diaporamaren atzeko planoaren kolorea';
$string['slideshowheight'] = 'Diaporamaren altuera';
$string['slideshowwidth'] = 'Diaporamaren zabalera';
$string['startlesson'] = 'Hasi ikasgaia';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->firstname} (r)en {$a->attempt} saiakera';
$string['studentname'] = '{$a} Izena';
$string['studentoneminwarning'] = 'Kontuz: Ikasgaia amaitzeko minutu bat edo gutxiago geratzen zaizu.';
$string['studentoutoftimeforreview'] = 'Adi: Ikasgaia berrikusteko denbora agortu duzu';
$string['studentresponse'] = '{$a}(r)en erantzuna';
$string['submit'] = 'Bidali';
$string['submitname'] = 'Izena bidali';
$string['teacherjumpwarning'] = 'Ikasgai honetan {$a->cluster} edo {$a->unseen} jauzia erabiltzen ari da. Bere ordez, hurrengo orrirako jauzia erabiliko da. Ikasle gisa sartu zaitez jauzi horiek probatzeko.';
$string['teacherongoingwarning'] = 'Metatutako puntuazioa soilik ikasleari erakusten zaio. Ikasle gisa sartu zaitez metatutako puntuazioa probatzeko.';
$string['teachertimerwarning'] = 'Denbora-neurgailua soilik ikasleei erakusten zaie. Denbora-neurgailua probatzeko ikasle gisa sartu zaitez.';
$string['thatsthecorrectanswer'] = 'Hauxe da erantzun zuzena';
$string['thatsthewronganswer'] = 'Hauxe da erantzun okerra';
$string['thefollowingpagesjumptothispage'] = 'Orri hauek honetarako jauzia dute';
$string['thispage'] = 'Orri hau';
$string['timeisup'] = 'Denbora amaitu da';
$string['timelimit'] = 'Denbora-muga';
$string['timelimit_help'] = 'Gaituz gero, denbora-mugaren gaineko ohar bat erakusten da ikasgaiaren hasieran eta atzera kontu bat erakusten da. Denbora-muga amaitu ondoren emandako erantzunak ez dira kalifikatuko.';
$string['timelimitwarning'] = '{$a} duzu ikasgai amaitzeko';
$string['timeremaining'] = 'Geratzen den denbora';
$string['timespenterror'] = 'Eman gutxienez {$a} minutu Ikasgai honi';
$string['timespentminutes'] = 'Emandako denbora (minututan)';
$string['timetaken'] = 'Erabilitako denbora';
$string['totalpagesviewedheader'] = 'Ikusitako orri-kopurua';
$string['true'] = 'Egia';
$string['truefalse'] = 'Egia/gezurra';
$string['unabledtosavefile'] = 'Igotako fitxategia ezin izan da gorde';
$string['unknownqtypesnotimported'] = 'Onartzen ez diren galdera-motetako {$a} galdera ez dira inportatu';
$string['unseenpageinbranch'] = 'Eduki-orrian ikusi ez den galdera';
$string['unsupportedqtype'] = 'Onartzen ez den galdera mota ({$a})!';
$string['updatedpage'] = 'Orria eguneratu da';
$string['updatefailed'] = 'Eguneratzeak huts egin du';
$string['updatepagenamed'] = 'Eguneratu orria: {$a}';
$string['usemaximum'] = 'Erabili gehienekoa';
$string['usemean'] = 'Erabili batez bestekoa';
$string['usepassword'] = 'Pasahitzaz babestutako ikasgaia';
$string['usepassword_help'] = 'Gaituz gero, ikasgaia eskuratzeko pasahitza eskatuko da.';
$string['useroverrides'] = 'Erabiltzaile-salbuespenak';
$string['useroverridesdeleted'] = 'Erabiltzaile-salbuespenak ezabatu dira';
$string['usersnone'] = 'Ikasleek ez dute ikasgai honetarako sarbiderik';
$string['viewessayanswers'] = 'Ikusi saiakeraren erantzunak';
$string['viewgrades'] = 'Ikusi kalifikazioak';
$string['viewreports'] = 'Ikusi {$a->student}(e)k osatutako {$a->attempts} saiakera';
$string['viewreports2'] = 'Ikusi osatutako {$a} saiakera';
$string['warning'] = 'Kontuz';
$string['welldone'] = 'Ederki!';
$string['whatdofirst'] = 'Nondik hasi nahi duzu?';
$string['withselectedattempts'] = 'Saiakera aukeratuekin...';
$string['wronganswerjump'] = 'Erantzun okerrerako jauzia';
$string['wronganswerscore'] = 'Erantzun okerraren puntuazioa';
$string['wrongresponse'] = 'Erantzun okerra';
$string['youhaveseen'] = 'Ikasgai honetako orri bat edo gehiago ikusi duzu jadanik.<br />Ikusitako azken orritik hasi nahi al duzu?';
$string['youranswer'] = 'Zure erantzuna';
$string['yourcurrentgradeis'] = 'Oraingo zure kalifikazioa {$a} da';
$string['yourcurrentgradeisoutof'] = 'Zure oraingo kalifikazioa {$a->grade} da gehieneko {$a->total}(e)tik.';
$string['youshouldview'] = 'Gutxienez hau ikusi beharko zenuke: {$a}';
