<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'eu', version '4.3'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Zeregin-jarduerako eranskinak';
$string['activitydate:submissionsdue'] = 'Entregatze-data:';
$string['activitydate:submissionsopen'] = 'Hasiera-data:';
$string['activitydate:submissionsopened'] = 'Hasiera-data:';
$string['activityeditor'] = 'Jardueraren argibideak';
$string['activityeditor_help'] = 'Ikasleek zeregin honetan osatu nahiko zenituzketen ekintzak. Hau soilik ikasleek euren bidalketa editatu eta bidaltzen duten bidalketa-orrian erakusten da.';
$string['activityoverview'] = 'Zure arreta behar duten hainbat zeregin duzu';
$string['addattempt'] = 'Baimendu beste saiakera bat';
$string['addnewattempt'] = 'Gehitu saiakera berria';
$string['addnewattempt_help'] = 'Honek bidalketa huts bat sortuko du, horren gainean lan egin dezazun.';
$string['addnewattemptfromprevious'] = 'Gehitu aurreko bidalketan oinarritutako saiakera berria';
$string['addnewattemptfromprevious_help'] = 'Honek kopiatuko ditu aurreko bidalketaren edukiak bidalketa berri batera, horren gainean lan egin dezazun.';
$string['addnewgroupoverride'] = 'Gehitu talde batentzako salbuespena';
$string['addnewuseroverride'] = 'Gehitu erabiltzaile batentzako salbuespena';
$string['addsubmission'] = 'Gehitu bidalketa';
$string['addsubmission_help'] = 'Oraindik ez duzu bidalketarik egin.';
$string['allocatedmarker'] = 'Esleitutako kalifikatzailea';
$string['allocatedmarker_help'] = 'Bidalketa honi esleitutako kalifikatzailea.';
$string['allowsubmissions'] = 'Baimendu erabiltzaileari zereginean bidalketak egiten jarraitzea.';
$string['allowsubmissionsfromdate'] = 'Bidalketetarako hasiera-data';
$string['allowsubmissionsfromdate_help'] = 'Gaituz gero, ikasleek ezingo dute bidalketa egin data hau baino lehen. Desgaituz gero, ikasleek bidalketa egin ahal izango dute oraintxe bertan.';
$string['allowsubmissionsshort'] = 'Baimendu aldaketak bidalketan';
$string['alwaysshowdescription'] = 'Beti erakutsi deskribapena';
$string['alwaysshowdescription_help'] = 'Desgaituz gero, ikasleek goiko zereginaren deskripzioa soilik ikusiko dute "Baimendu bidalketak hemendik" aukeran markatutako egunetik aurrera.';
$string['applytoteam'] = 'Aplikatu kalifikazioak eta feedbackak talde osoari';
$string['assign:addinstance'] = 'Gehitu zeregin berria';
$string['assign:editothersubmission'] = 'Editatu beste ikasle baten bidalketa';
$string['assign:exportownsubmission'] = 'Esportatu norberaren bidalketa';
$string['assign:grade'] = 'Kalifikatu zeregina';
$string['assign:grantextension'] = 'Eman epearen luzapena';
$string['assign:manageallocations'] = 'Kudeatu bidalketei esleitutako kalifikatzaileak';
$string['assign:managegrades'] = 'Berrikusi eta argitaratu kalifikazioak';
$string['assign:manageoverrides'] = 'Kudeatu zeregin-salbuespenak';
$string['assign:receivegradernotifications'] = 'Jaso kalifikatzailearen bidalketen jakinarazpenak';
$string['assign:releasegrades'] = 'Argitaratu kalifikazioak';
$string['assign:revealidentities'] = 'Ezagutarazi ikasleen identitatea';
$string['assign:reviewgrades'] = 'Berrikusi kalifikazioak';
$string['assign:showhiddengrader'] = 'Ikusi ezkutuko kalifikatzailearen identitatea';
$string['assign:submit'] = 'Bidali zeregina';
$string['assign:view'] = 'Ikusi zeregina';
$string['assign:viewblinddetails'] = 'Ikusi ikasleen identitateak bidalketa anonimoak gaituta daudeunean';
$string['assign:viewgrades'] = 'Ikusi kalifikazioak';
$string['assign:viewownsubmissionsummary'] = 'Ikusi norbere bidalketaren laburpena';
$string['assignfeedback'] = 'Feedbackaren plugina';
$string['assignfeedbackpluginname'] = 'Feedbackaren plugina';
$string['assignmentisdue'] = 'Epea amaitu da';
$string['assignmentmail'] = '{$a->grader}(e)k feedbacka bidali du zure \'{$a->assignment}\' zereginaren bidalketarako.

Zure zereginaren bidalketaren eranskin gisa ikus dezakezu:

 {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader}(e)k feedbacka bidali du zure \'<i>{$a->assignment}</i>\' zereginaren bidalketarako.</p>
<p>Zure <a href="{$a->url}">zereginaren bidalketaren eranskin gisa ikus dezakezu</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader}(e)k feedbacka bidali du zure \'{$a->assignment}\' zereginaren bidalketarako. Zure zereginaren bidalketaren eranskin gisa ikus dezakezu.';
$string['assignmentname'] = 'Zereginaren izena';
$string['assignmentplugins'] = 'Zereginaren pluginak';
$string['assignmentsperpage'] = 'Zereginak orriko';
$string['assignsubmission'] = 'Bidalketaren plugina';
$string['assignsubmissionpluginname'] = 'Bidalketaren plugina';
$string['assigntimeleft'] = 'Geratzen den denbora';
$string['attemptheading'] = '{$a->attemptnumber} saiakera: {$a->submissionsummary}';
$string['attempthistory'] = 'Aurreko saiakerak';
$string['attemptnumber'] = 'Saiakera-kopurua';
$string['attemptreopenmethod'] = 'Saiakera gehigarriak';
$string['attemptreopenmethod_help'] = 'Ezarpen honek ikasle batek zereginean saiakera gehigarriak egin ditzakeen zehazten du. Saiakera bakoitzaren kalifikazioa eta feedbacka gordetzen dira, eta irakasleek zein ikasleak ikusi ditzakete. Hauek dira eskuragarri dauden aukerak:

* Inoiz ez - Bidalketa bakarra onartzen da.
* Eskuz - Irakasle batek ikaslearen saiakera gehigarriak baimendu ditzake.
* Automatikoki gainditu arte - Saiakera gehigarriak automatikoki baimenduko dira ikasleak kalifikazio liburuan zeregin hau gainditzeko zehaztutako kalifikazioa lortu arte.';
$string['attemptreopenmethod_manual'] = 'Eskuz';
$string['attemptreopenmethod_none'] = 'Inoiz ere ez';
$string['attemptreopenmethod_untilpass'] = 'Automatikoki gainditu arte';
$string['attemptsettings'] = 'Saiakeren ezarpenak';
$string['availability'] = 'Eskuragarritasuna';
$string['back'] = 'Atzera';
$string['backtoassignment'] = 'Itzuli zereginera';
$string['batchoperationconfirmaddattempt'] = 'Baimendu beste saiakera bat aukeratutako bidalketetan?';
$string['batchoperationconfirmdownloadselected'] = 'Jaitsi nahi dituzu aukeratutako bidalketak?';
$string['batchoperationconfirmgrantextension'] = 'Epea luzatu aukeratutako bidalketa guztietan?';
$string['batchoperationconfirmlock'] = 'Blokeatu aukeratutako bidalketa guztiak?';
$string['batchoperationconfirmremovesubmission'] = 'Ezabatu aukeratutako bidalketak?';
$string['batchoperationconfirmreverttodraft'] = 'Itzuli aukeratutako bidalketak zirriborro egoerara?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Aukeratutako bidalketa guztiei kalifikatzaile esleipena ezarri nahi diezu?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Aukeratutako bidalketa guztiei kalifikazio lan-fluxu egoera ezarri nahi diezu?';
$string['batchoperationconfirmunlock'] = 'Desblokeatu nahi dituzu aukeratutako bidalketa guztiak?';
$string['batchoperationlock'] = 'blokeatu bidalketak';
$string['batchoperationreverttodraft'] = 'itzuli bidalketak zirriborrora';
$string['batchoperationsdescription'] = 'Aukeratutakoekin...';
$string['batchoperationunlock'] = 'desblokeatu bidalketak';
$string['batchsetallocatedmarker'] = 'Esleitu kalifikatzailea aukeratutako {$a} erabiltzaileri.';
$string['batchsetmarkingworkflowstateforusers'] = 'Aukeratutako {$a} erabiltzaileri kalifikazio lan-fluxu egoera esleitu zaie.';
$string['beginassignment'] = 'Hasi zeregina';
$string['blindmarking'] = 'Bidalketa anonimoak';
$string['blindmarking_help'] = 'Bidalketa anonimoak kalifikatzaileei ikasleen identitatea ezkutatzen die. Bidalketa anonimoen ezarpenak blokeatuko dira zeregin horretan bidalketa edo kalifikazio bat egiterakoan.';
$string['blindmarkingenabledwarning'] = 'Bidalketa anonimoak gaituta daude jarduera honetan. Kalifikazio-ekintzen menutik ikasleen identitatea ezagutarazi arte kalifikazioak ez dira kalifikazio-liburura gehituko.';
$string['cachedef_overrides'] = 'Erabiltzaile eta talde-salbuespenen informazioa';
$string['calendardue'] = '{$a}(r)en entregatze-data';
$string['calendargradingdue'] = '{$a}(r)en kalifikazio-data';
$string['caneditsubmission'] = 'Zure bidalketa editatu eta epea amaitu ondoren bidali ahal duzu, baina berandu entregatu gisa markatua izango da.';
$string['changefilters'] = 'Aldatu iragazkiak';
$string['changeuser'] = 'Aldatu erabiltzail';
$string['choosegradingaction'] = 'Kalifikazio-ekintza';
$string['choosemarker'] = 'Aukeratu...';
$string['chooseoperation'] = 'Aukeratu eragiketa';
$string['clickexpandreviewpanel'] = 'Egin klik berrikusketa-panela zabaltzeko';
$string['collapsegradepanel'] = 'Tolestu kalifikazio-panela';
$string['collapsereviewpanel'] = 'Tolestu berrikusketa-panela';
$string['comment'] = 'Iruzkina';
$string['completiondetail:submit'] = 'Bidalketa bat egitea';
$string['completionsubmit'] = 'Bidalketa bat egitea';
$string['configshowrecentsubmissions'] = 'Duela gutxiko aktibitatearen txostenetan guztiek ikus ditzakete bidalketen jakinarazpenak';
$string['confirmbatchgradingoperation'] = 'Ziur zaude {$a->operation} nahi duzula {$a->count} ikaslerentzat?';
$string['confirmstart'] = '{$a} duzu zeregin hau osatzeko. Hasten zarenean, erlojuan atzera-kontaketa hasiko da eta ezin da pausatu.';
$string['confirmsubmission'] = 'Ziur zaude zure lana bidali nahi duzula kalifikatzeko? Ezin izango duzu aldaketarik egin.';
$string['confirmsubmissionheading'] = 'Baieztatu bidalketa';
$string['conversionexception'] = 'Zeregina ezin izan da bihurtu. Salbuespena hau izan da: {$a}.';
$string['couldnotconvertgrade'] = 'Ezin izan da bihurtu zereginaren kalifikazioa {$a} erabiltzailearentzat.';
$string['couldnotconvertsubmission'] = 'Ezin izan da bihurtu zereginaren bidalketa {$a} erabiltzailearentzat.';
$string['couldnotcreatecoursemodule'] = 'Ezin izan da ikastaroaren modulua sortu.';
$string['couldnotcreatenewassignmentinstance'] = 'Ezin izan da sortu zeregin berria.';
$string['couldnotfindassignmenttoupgrade'] = 'Ez da aurkitu zeregin zaharra eguneratzeko.';
$string['crontask'] = 'Zeregin-moduluaren atzeko planoko prozesatzea';
$string['currentassigngrade'] = 'Zereginaren kalifikazioa';
$string['currentattempt'] = 'Hau da {$a} saiakera.';
$string['currentattemptof'] = 'Hau {$a->attemptnumber}. saiakera da ( {$a->maxattempts} saiakera onartzen dira ).';
$string['currentgrade'] = 'Oraingo kalifikazioa kalifikazio-liburuan';
$string['cutoffdate'] = 'Itxiera-data';
$string['cutoffdate_help'] = 'Gaituz gero, zereginak ez du data hau baino beranduagoko bidalketarik onartuko, luzapenik ematen ez bada, behintzat. Kontuz! Desgaituta badago bidalketak amaiera-datarik gabe onartuko dira.';
$string['cutoffdatecolon'] = 'Itxiera-data: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Itxiera-data ezin da bidalketaren irekiera-data baino lehenagokoa izan.';
$string['cutoffdatevalidation'] = 'Itxiera-data ezin da entregatze-data baino lehenagokoa izan.';
$string['defaultlayout'] = 'Berrezarri lehenetsitako diseinua';
$string['defaultsettings'] = 'Lehenetsitako zereginaren ezarpenak';
$string['defaultsettings_help'] = 'Ezarpen hauek zeregin berri guztietarako balio lehenetsiak definitzen dituzte.';
$string['defaultteam'] = 'Talde lehenetsia';
$string['deleteallsubmissions'] = 'Ezabatu bidalketa guztiak';
$string['description'] = 'Deskribapena';
$string['disabled'] = 'Desgaituta';
$string['downloadall'] = 'Jaitsi bidalketa guztiak';
$string['downloadasfolders'] = 'Jaitsi bidalketak karpetetan';
$string['downloadasfolders_help'] = 'Zereginaren bidalketak karpetetan deskargatu daitezke. Bidalketa bakoitza karpeta ezberdin batean sartzen da, azpikarpeten egitura mantenduta, eta fitxategiaren izena aldatu gabe.';
$string['downloadselectedsubmissions'] = 'Jaitsi aukeratutako bidalketak';
$string['duedate'] = 'Entregatze-data';
$string['duedate_help'] = 'Hau zereginaren entregatze-epea da. Bidalketak onartuko dira data hau baino beranduago, baina bidalketa atzeratuen seinalea jarriko zaio. Ezarri zereginaren itxiera-data une horren ondorengo bidalketak saihesteko.';
$string['duedateaftersubmissionvalidation'] = 'Entregatze-data bidalketetarako hasiera-data baino beranduagokoa izan behar da.';
$string['duedatecolon'] = 'Entregatze-data: {$a}';
$string['duedatereached'] = 'Zeregin hau bidaltzeko epea amaitu da';
$string['duedatevalidation'] = 'Entregatze-data ezin da irekitze-data baino lehenagokoa izan.';
$string['duplicateoverride'] = 'Bikoiztu salbuespena';
$string['editaction'] = 'Ekintzak...';
$string['editattemptfeedback'] = 'Editatu {$a} saiakeraren kalifikazioa eta feedbacka.';
$string['editingpreviousfeedbackwarning'] = 'Saiakera zahar baten feedbacka editatzen ari zara. Saiakera hau {$a->totalattempts}(e)tik {$a->attemptnumber}.a da.';
$string['editingstatus'] = 'Editatze-egoera';
$string['editonline'] = 'Editatu on-line';
$string['editoverride'] = 'Editatu salbuespena';
$string['editsubmission'] = 'Editatu bidalketa';
$string['editsubmission_help'] = 'Oraindik zure bidalketan aldaketak egin ditzakezu.';
$string['editsubmissionother'] = 'Editatu {$a}(r)en bidalketa';
$string['enabled'] = 'Gaituta';
$string['enabletimelimit'] = 'Gaitu erlojupeko zereginak';
$string['enabletimelimit_help'] = 'Gaituz gero, zereginaren ezarpenen orrian denbora-muga bat zehaztu ahalko duzu.';
$string['errornosubmissions'] = 'Ez dago jaisteko bidalketarik';
$string['errorquickgradingvsadvancedgrading'] = 'Kalifikazioak ez dira gorde zeregin honek kalifikazio aurreratua erabiltzen duelako';
$string['errorrecordmodified'] = 'Kalifikazioak ez dira gorde norbaitek aldatu duelako erregistro bat edo gehiago zuk orria kargatu ondoren.';
$string['eventallsubmissionsdownloaded'] = 'Bidalketa guztiak jaisten ari dira.';
$string['eventassessablesubmitted'] = 'Bidalketa ondo bidali da.';
$string['eventbatchsetmarkerallocationviewed'] = 'Sortaren kalifikatzaile esleipena ikusi da';
$string['eventbatchsetworkflowstateviewed'] = 'Sortaren lan-jarioa ikusi da.';
$string['eventextensiongranted'] = 'Luzapen bat baimendu da.';
$string['eventfeedbackupdated'] = 'Feedbacka eguneratu da';
$string['eventfeedbackviewed'] = 'Feedbacka ikusi da';
$string['eventgradingformviewed'] = 'Kalifikazio-formularioa ikusi da';
$string['eventgradingtableviewed'] = 'Kalifikazio-taula ikusi da';
$string['eventidentitiesrevealed'] = 'Identitateak ezagutuarazi dira.';
$string['eventmarkerupdated'] = 'Esleitutako kalifikatzailea eguneratu da.';
$string['eventoverridecreated'] = 'Zereginerako salbuespena sortu da';
$string['eventoverridedeleted'] = 'Zereginerako salbuespena ezabatu da';
$string['eventoverrideupdated'] = 'Zereginerako salbuespena eguneratu da';
$string['eventremovesubmissionformviewed'] = 'Bidalketa ezabatzeko berrespena ikusi da.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Identitateak ezagutarazteko berrespen-orria ikusi da.';
$string['eventstatementaccepted'] = 'Erabiltzaileak bidalketa-adierazpena onartu du.';
$string['eventsubmissionconfirmationformviewed'] = 'Bidalketa berresteko formularioa ikusia.';
$string['eventsubmissioncreated'] = 'Bidalketa sortu da.';
$string['eventsubmissionduplicated'] = 'Erabiltzaileak euren bidalketa bikoiztu du.';
$string['eventsubmissionformviewed'] = 'Bidalketa-formularioa ikusi da.';
$string['eventsubmissiongraded'] = 'Bidalketa kalifikatu da.';
$string['eventsubmissionlocked'] = 'Bidalketa erabiltzaile batentzat blokeatu da.';
$string['eventsubmissionremoved'] = 'Bidalketa ezabatuta.';
$string['eventsubmissionstatusupdated'] = 'Bidalketaren egoera eguneratu da.';
$string['eventsubmissionstatusviewed'] = 'Bidalketaren egoera ikusia izan da.';
$string['eventsubmissionunlocked'] = 'Bidalketa erabiltzaile batentzat desblokeatu da.';
$string['eventsubmissionupdated'] = 'Bidalketa eguneratu da.';
$string['eventsubmissionviewed'] = 'Bidalketa ikusi da.';
$string['eventworkflowstateupdated'] = 'Lan-fluxu egoera eguneratu da.';
$string['expandreviewpanel'] = 'Zabaldu berrikusketa-panela';
$string['extensionduedate'] = 'Luzapenaren entregatze-data';
$string['extensionnotafterduedate'] = 'Luzapenaren datak entregatze-data baino beranduago izan behar du';
$string['extensionnotafterfromdate'] = 'Luzapenaren datak bidaltzeko hasiera-data baino beranduagokoa izan behar da';
$string['feedback'] = 'Feedbacka';
$string['feedbackavailableanonhtml'] = 'Feedback berri bat daukazu \'<i>{$a->assignment}</i>\' zereginaren zure bidalketan<br /><br />
Zereginaren <a href="{$a->url}"> zure bidalketarekin batera</a> ikusi dezakezu.';
$string['feedbackavailableanonsmall'] = 'Feedback berria {$a->assignment} zereginarentzat';
$string['feedbackavailableanontext'] = 'Feedback berri bat daukazu \'{$a->assignment}\' zereginaren zure bidalketan

Zereginaren zure bidalketarekin batera ikusi dezakezu:

 {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username}(e)k feedbacka bidali du zure zereginaren bidalketarako: \'<i>{$a->assignment}</i>\'<br /><br /> Feedback hau ikusi dezakezu <a href="{$a->url}">zeregineko bidalketaren eranskin gisa</a>.';
$string['feedbackavailablesmall'] = '{$a->username}(e)k feedbacka bidali du {$a->assignment} zereginerako';
$string['feedbackavailabletext'] = '{$a->username}(e)k feedbacka bidali du zure \'{$a->assignment}\' zereginaren bidalketarako.

Zure zereginaren bidalketaren eranskin gisa ikus dezakezu:

{$a->url}';
$string['feedbackplugin'] = 'Feedbackaren plugina';
$string['feedbackpluginforgradebook'] = 'Feedbackaren plugin honek iruzkinak bidaliko ditu kalifikazio-liburura';
$string['feedbackpluginforgradebook_help'] = 'Feedbackaren plugin bakar batek bidali ditzake feedbackak kalifikazio-liburura.';
$string['feedbackplugins'] = 'Feedbackaren pluginak';
$string['feedbacksettings'] = 'Feedbackaren ezarpenak';
$string['feedbacktypes'] = 'Feedback motak';
$string['filesubmissions'] = 'Fitxategi-bidalketak';
$string['filter'] = 'Iragazkia';
$string['filterdraft'] = 'Zirriborroa';
$string['filtergrantedextension'] = 'Baimendutako luzapena';
$string['filternone'] = 'Iragazkirik ez';
$string['filternotsubmitted'] = 'Bidali gabea';
$string['filterrequiregrading'] = 'Kalifikazioa behar du';
$string['filtersubmitted'] = 'Bidalita';
$string['fixrescalednullgrades'] = 'Zeregin honek erroreak dituzten kalifikazioak ditu. Zuk <a href="{$a->link}">kalifikazio hauek automatikoki konpondu</a> ditzakezu. Honek ikastaroaren guztirakoei eragin diezaieke.';
$string['fixrescalednullgradesconfirm'] = 'Ziur zaude erroreak dituzten kalifikazioak konpondu nahi dituzula? Eragindako kalifikazio guztiak ezabatu egingo dira. Honek ikastaroko guztirakoei eragin diezaieke.';
$string['fixrescalednullgradesdone'] = 'Kalifikazioak konpondu dira.';
$string['gradeabovemaximum'] = 'Kalifikazioak {$a} baino txikiagoa edo berdina izan behar du.';
$string['gradebelowzero'] = 'Kalifikazioak 0 edo handiagoa izan behar du.';
$string['gradebreakdown'] = 'Kalifikazioen analisia';
$string['gradecanbechanged'] = 'Kalifikazioa alda daiteke';
$string['gradechangessaveddetail'] = 'Kalifikazioan eta feedbackean egindako aldaketak gorde dira';
$string['graded'] = 'Kalifikatua';
$string['gradedby'] = 'Nork kalifikatua';
$string['gradedfollowupsubmit'] = 'Kalifikatuta - bidalketa berriagoa jaso da';
$string['gradedon'] = 'Noiz kalifikatua';
$string['gradeitem:submissions'] = 'Bidalketak';
$string['gradelocked'] = 'Kalifikazio hau blokeatu edo aldatu da kalifikazio-liburuan.';
$string['gradeoutof'] = 'Kalifikazioa (gehieneko {$a}(e)tik)';
$string['gradeoutofhelp'] = 'Kalifikazioa';
$string['gradeoutofhelp_help'] = 'Idatzi hemen ikasleak egindako bidalketaren kalifikazioa. Hamartarrak ere sar ditzakezu.';
$string['gradersubmissionupdatedhtml'] = '{$a->username}(e)k bidalketa eguneratu du <i>\'{$a->assignment}\' zereginean ({$a->timeupdated})</i><br/><br/>
Ikusgai dago <a href="{$a->url}">webgune honetan</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username}(e)k bidalketa eguneratu du {$a->assignment} zereginean.';
$string['gradersubmissionupdatedtext'] = '{$a->username}(e)k bidalketa eguneratu du z{$a->assignment} zereginean ({$a->timeupdated})

Hemen ikusgai:

{$a->url}';
$string['gradestudent'] = 'Kalifikatu ikaslea: (id={$a->id}, izen osoa={$a->fullname}).';
$string['gradeuser'] = '{$a} kalifikazioa';
$string['grading'] = 'Kalifikazioa';
$string['gradingchangessaved'] = 'Kalifikazioaren aldaketak gorde dira';
$string['gradingduedate'] = 'Gogorarazi data honetarako kalifikatzea:';
$string['gradingduedate_help'] = 'Bidalketen kalifikazioa eginda egoteko aurreikusitako data. Data hau aginte-paneleko irakasleen jakinarazpenak lehenesteko erabiltzen da.';
$string['gradingdueduedatevalidation'] = 'Kalifikatzea gogoratzeko jakinarazpen-data ezin da bidalketen entregatze-data baino lehenagokoa izan.';
$string['gradingduefromdatevalidation'] = 'Kalifikatzea gogoratzeko jakinarazpen-data ezin da bidalketen Hasiera-data baino lehenagokoa izan.';
$string['gradingmethodpreview'] = 'Kalifikazio-irizpidea';
$string['gradingoptions'] = 'Aukerak';
$string['gradingstatus'] = 'Kalifikazioaren egoera';
$string['gradingstudent'] = 'Ikaslea kalifikatzen';
$string['gradingsummary'] = 'Kalifikazioen laburpena';
$string['grantextension'] = 'Eman epearen luzapena';
$string['grantextensionforusers'] = 'Eman epearen luzapena {$a} ikasleei';
$string['groupoverrides'] = 'Talde-salbuespenak';
$string['groupoverridesdeleted'] = 'Talde-salbuespenak ezabatu dira';
$string['groupsnone'] = 'Ez dago sarbidea duzun talderik.';
$string['groupsubmissionsettings'] = 'Taldeko bidalketen ezarpenak';
$string['hiddenuser'] = 'Partaidea';
$string['hidegrader'] = 'Ezkutatu kalifikatzailearen identitatea ikasleei';
$string['hidegrader_help'] = 'Gaituz gero, zereginaren bidalketen kalifikazioak egiten dituzten erabiltzaileen identitateak ez dira erakusten, ikasleek euren lana nork kalifikatu duen jakin ez dezaten.

Kontuan izan ezarpen honek ez duela eraginik ebaluazio-orriko iruzkinen kutxan.';
$string['hideshow'] = 'Ezkutatu/Erakutsi';
$string['inactiveoverridehelp'] = '* Salbuespen hau ez-aktibo dago erabiltzailearen jarduerarako sarbidea murriztuta dagoelako. Honen arrazoia taldeko edo rol-esleipena izan daiteke, bestelako eskuragarritasun murrizketak edo jarduera ezkutuan egotea.';
$string['indicator:cognitivedepth'] = 'Gaitasun kognitiboa zereginetan';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak zeregina motako jardueretan lortutako sakonera kognitiboan oinarrituta dago.';
$string['indicator:cognitivedepthdef'] = 'Gaitasun kognitiboa zereginetan';
$string['indicator:cognitivedepthdef_help'] = 'Partaide honek Zeregina jarduerak eskaintzen duen gaitasun kognitiboaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Ikusi gabe, Ikusi da, Bidali da, Feedbacka ikusi da, Feedbackari iruzkina egin da, Feedback ikusi ondoren berriz bidali da)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Gaitasun soziala zereginetan';
$string['indicator:socialbreadth_help'] = 'Helburu hau ikasleak zeregina motako jardueretan lortutako zabalera sozialean oinarrituta dago.';
$string['indicator:socialbreadthdef'] = 'Gaitasun soziala zereginetan';
$string['indicator:socialbreadthdef_help'] = 'Partaide honek Zeregina jarduerak eskaintzen duen gaitasun sozialaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Parte-hartzerik ez, bakarkako parte-hartzea, parte-hartzea besteekin)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Argibideen fitxategiak';
$string['introattachments'] = 'Fitxategi gehigarriak';
$string['introattachments_help'] = 'Zereginean erabiltzeko fitxategi gehigarriak gehitu daitezke, esaterako erantzunen txantiloiak.';
$string['invalidfloatforgrade'] = 'Ezin izan da ulertu emandako kalifikazioa: {$a}';
$string['invalidgradeforscale'] = 'Kalifikazioak ez du balio oraingo eskalarako';
$string['invalidoverrideid'] = 'Salbuespenaren ID-a ez da zuzena';
$string['lastmodifiedgrade'] = 'Azken aldaketa (kalifikazioa)';
$string['lastmodifiedsubmission'] = 'Azken aldaketa (bidalketa)';
$string['latesubmissions'] = 'Epez kanpoko bidalketak';
$string['latesubmissionsaccepted'] = 'Noiz arte baimendua: {$a}';
$string['loading'] = 'Igotzen...';
$string['locksubmissionforstudent'] = 'Galarazi bidalketa berriak egitea ikasle honi: (id={$a->id}, izen osoa={$a->fullname}).';
$string['locksubmissions'] = 'Blokeatu bidalketak';
$string['manageassignfeedbackplugins'] = 'Kudeatu zereginaren feedback-pluginak';
$string['manageassignsubmissionplugins'] = 'Kudeatu zereginetarako bidalketa-plugina';
$string['marker'] = 'Kalifikatzailea';
$string['markerfilter'] = 'Kalifikatzaile iragazkia';
$string['markerfilternomarker'] = 'Kalifikatzailerik ez';
$string['markingallocation'] = 'Erabili kalifikatzaile esleipena';
$string['markingallocation_help'] = 'Kalifikazio lan-fluxuarekin batera gaituz gero, ikasle konkretuei kalifikatzaileak eslei dakizkieke.';
$string['markingworkflow'] = 'Erabili kalifikazio lan-fluxua';
$string['markingworkflow_help'] = 'Gaituz gero, kalifikazioak lan-fluxu egoera ezberdinetatik igaroko dira ikasleei erakutsi baino lehen. Honek kalifikazio erronda anitz egiteko eta kalifikazioak ikasle guztiei aldi berean argitaratzeko aukera ematen du.';
$string['markingworkflowstate'] = 'Kalifikazio lan-fluxuaren egoera';
$string['markingworkflowstate_help'] = 'Balizko lan-fluxu batek hurrengo egoerak izan ditzake (baimenen arabera):

* Kalifikatu gabe - kalifikatzailea oraindik ez da lanean hasi.
* Kalifikatzen - kalifikatzailea lanean hasi da baina oraindik ez du amaitu.
* Kalifikazioa osatua - kalifikatzaileak lana amaitu du baina oraindik ikuskatu/zuzentzera sartuko da.
* Berrikusten - irakaslea kalifikazioaren kalitatearen ikuskapena egiten ari da.
* Argitaratzeko prest - irakasleak kalifikazioari onespena eman dio baina ikasleari oraindik ez zaio kalifikazioa erakutsi.
* Argitaratuta - ikasleak kalifikazio eta feedbacka ikusi ditzake';
$string['markingworkflowstateinmarking'] = 'Kalifikatzen';
$string['markingworkflowstateinreview'] = 'Berrikusten';
$string['markingworkflowstatenotmarked'] = 'Kalifikatu gabe';
$string['markingworkflowstatereadyforrelease'] = 'Argitaratzeko prest';
$string['markingworkflowstatereadyforreview'] = 'Kalifikazioa osatua';
$string['markingworkflowstatereleased'] = 'Argitaratuta';
$string['maxattempts'] = 'Saiakera kopuru maximoa';
$string['maxattempts_help'] = 'Ikasle batek egin dezaken saiakera kopuru maximoa. Saiakera-kopuru honetara heldu ondoren, bidalketa ezingo zaio berriz ireki.';
$string['maxgrade'] = 'Gehieneko kalifikazioa';
$string['maxperpage'] = 'Gehieneko zereginak orriko';
$string['maxperpage_help'] = 'Kalifikatzaile batek kalifikazio orrian gehienez erakutsi ditzakeen zeregin kopurua. Ezarpen hau erabilgarria da partaide asko dituzten ikastaroetan kargatzeko denbora-muga ekiditeko.';
$string['messageprovider:assign_notification'] = 'Zereginaren jakinarazpenak';
$string['modulename'] = 'Zeregina';
$string['modulename_help'] = 'Zeregina jarduera moduluaren bidez irakasleak komunikatu ditzake atazak, jaso ditzake ikasleen lanak eta eman ditzake kalifikazioak eta feedbackak.

Ikasleek eduki digitalak bidal ditzakete (fitxategiak), testu-dokumentuak kalkulu orriak, irudiak, audio-klipak edo bideo-klipak. Halaber, ikasleek zeregina egiteko garaian, idatz dezakete testu bat zuzenean testu-editorean. Zereginaren beste erabilera posible bat da \'mundu errealeko\' ataza bat ikasleei gogoraraztea, adibidez, arte-lan bat edo eduki digitalik eskatzen ez duen edozein lan. Ikasleek lana bidal dezakete banaka edo talde baten izenean.

Irakasleek, zereginak orrazterakoan, feedbackak eta iruzkinak jar ditzakete, fitxategiak igo ditzakete, adibidez: ikasleen dokumentuetan egindako oharrak, dokumentu berriak iruzkinekin edo hitzezko feedbacka duten audioak. Zereginak kalifikatzeko erabil daitezke zenbakiak, eskalak edo errubrikak bezalako kalifikazio-metodo aurreratuak. Azken kalifikazioak kalifikazio-liburuan gordetzen dira.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Zereginak';
$string['moreusers'] = '{$a} gehiago...';
$string['multipleteams'] = 'Talde bateko baino gehiagoko partaidea';
$string['multipleteams_desc'] = 'Zereginak taldekako bidalketa behartzen du. Zu talde bat baino gehiagoko kidea zara. Bidalketak egin ahal izateko talde bakar bateko kidea izan behar duzu. Mesedez jarri harremanetan zure irakaslearekin zure talde-partaidetzak aldatu ditzan.';
$string['multipleteamsgrader'] = 'Talde anitzeko kidea, ezin du bidalketarik egin.';
$string['newsubmissions'] = 'Zereginak bidalita';
$string['nextuser'] = 'Hurrengo erabiltzailea';
$string['noattempt'] = 'Saiakerarik ez';
$string['noclose'] = 'Ez dago ixteko datarik';
$string['nofiles'] = 'Fitxategirik ez.';
$string['nofilters'] = 'Ez dago iragazkirk';
$string['nograde'] = 'Kalifikaziorik ez.';
$string['nogroupoverrides'] = 'Une honetan ez dago talde-salbuespenik.';
$string['nomoresubmissionsaccepted'] = 'Soilik epearen luzapena jaso duten kideei baimenduta.';
$string['none'] = 'Bat ere ez';
$string['noonlinesubmissions'] = 'Zeregin honek ez du ezer on-line aurkezteko eskatzen';
$string['noopen'] = 'Ez dago zabaltzeko datarik';
$string['nooverridedata'] = 'Gutxienez zereginaren ezarpen baten salbuespena egin behar duzu.';
$string['nosavebutnext'] = 'Hurrengoa';
$string['nosubmission'] = 'Ez dago bildalketarik zeregin honetan';
$string['nosubmissionyet'] = 'Oraindik ez da bidalketarik egin.';
$string['noteam'] = 'Ez zara inongo taldetako kide';
$string['noteam_desc'] = 'Zereginak taldekako bidalketa behartzen du. Zu ez zara inongo taldeko kidea, eta ondorioz ezin duzu bidalketarik egin. Mesedez jarri harremanetan zure irakaslearekin zure talde-partaidetzak aldatu ditzan.';
$string['noteamgrader'] = 'Talderik gabeko kidea, ezin du bidalketarik egin.';
$string['notgraded'] = 'Kalifikatu gabea';
$string['notgradedyet'] = 'Oraindik notarik jarri gabe';
$string['notifications'] = 'Jakinarazpenak';
$string['nouseroverrides'] = 'Une honetan ez dago erabiltzaile-salbuespenik.';
$string['nousers'] = 'Ez dago erabiltzailerik';
$string['nousersselected'] = 'Ez da erabiltzailerik aukeratu';
$string['numberofdraftsubmissions'] = 'Zirriborroak';
$string['numberofparticipants'] = 'Partaideak';
$string['numberofsubmissionsneedgrading'] = 'Kalifikatu beharrekoak';
$string['numberofsubmissionsneedgradinglabel'] = 'Kalifikatu beharrekoak: {$a}';
$string['numberofsubmittedassignments'] = 'Bidalita';
$string['numberofteams'] = 'Taldeak';
$string['offline'] = 'Ez du on-line bidalketarik eskatzen';
$string['open'] = 'Irekita';
$string['opensubmissionexists'] = 'Irekitako zeregin bidalketa bat existitzen da dagoeneko.';
$string['outlinegrade'] = 'Kalifikazioa: {$a}';
$string['outof'] = '{$a->current}.a {$a->total}(e)tik';
$string['overdue'] = 'Zeregina bidaltzeko epea amaitu da orain dela {$a}';
$string['override'] = 'Gehitu salbuespena';
$string['overridedeletegroupsure'] = 'Ziur zaude {$a} taldearen salbuespena ezabatu nahi duzula?';
$string['overridedeleteusersure'] = 'Ziur zaude {$a} erabiltzailearen salbuespena ezabatu nahi duzula?';
$string['overridegroup'] = 'Salbuetsitako taldea';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Salbuespenak';
$string['overrideuser'] = 'Salbuetsitako erabiltzailea';
$string['overrideusereventname'] = '{$a->assign} - Salbuespena';
$string['page-mod-assign-view'] = 'Zereginaren edozein orri';
$string['page-mod-assign-x'] = 'Zereginaren edozein orri';
$string['paramtimeremaining'] = '{$a} geratzen da';
$string['participant'] = 'Partaidea';
$string['pluginadministration'] = 'Zereginaren kudeaketa';
$string['pluginname'] = 'Zeregina';
$string['preventsubmissionnotingroup'] = 'Behartu taldeko kidea izatea bidalketa egiteko';
$string['preventsubmissionnotingroup_help'] = 'Gaituz gero, taldeetatik kanpo dauden erabiltzaileek ezin izango dute bidalketarik egin.';
$string['preventsubmissions'] = 'Galarazi erabiltzaileari zeregin honetan bidalketa berriak egitea.';
$string['preventsubmissionsshort'] = 'Galarazi bidalketan aldaketak egitea';
$string['previous'] = 'Aurrekoa';
$string['previoususer'] = 'Aurreko erabiltzailea';
$string['privacy:attemptpath'] = 'saiakera {$a}';
$string['privacy:blindmarkingidentifier'] = 'Bidalketa anonimorako erabilitako identifikatzailea';
$string['privacy:gradepath'] = 'kalifikazioa';
$string['privacy:metadata:assigndownloadasfolders'] = 'Erabiltzailearen lehenespena fitxategi anitzeko bidalketak karpetatan jaisteko.';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Zereginaretarako feedback-data';
$string['privacy:metadata:assignfilter'] = 'Iragazteko aukerak, hala nola, \'Bidalia\', \'Bidali gabea\', \'Kalifikatu beharrekoak\' eta \'Luzapen bermatua\'';
$string['privacy:metadata:assigngrades'] = 'Erabiltzailearen kalifikazioak gordetzen ditu.';
$string['privacy:metadata:assignmarkerfilter'] = 'Zereginaren laburpena iragazten du esleitutako kalifikatzailearen arabera.';
$string['privacy:metadata:assignmentid'] = 'Zereginaren IDa';
$string['privacy:metadata:assignmessageexplanation'] = 'Ikasleei mezuak mezularitza-sistemaren bidez bidaltzen zaizkie.';
$string['privacy:metadata:assignoverrides'] = 'Bidalketaren salbuespenen informazioa gordetzen du.';
$string['privacy:metadata:assignperpage'] = 'Erakutsiko den bildaketa-kopurua orriko.';
$string['privacy:metadata:assignquickgrading'] = 'Kalifikazio azkarra erakustearen inguruko lehenespena.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Erabiltzailearen bidalketez informazioa gordetzen du.';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Zereginaren bidalketa-data';
$string['privacy:metadata:assignuserflags'] = 'Erabitzailearen metadatuak gordetzen ditu, hala nola, luzapen-datak';
$string['privacy:metadata:assignusermapping'] = 'Bidalketa anonimoetarako loturak';
$string['privacy:metadata:assignworkflowfilter'] = 'Laneko fluxu mailen araberako iragazkia';
$string['privacy:metadata:grade'] = 'Zereginaren bidalketa honetarako zenbakizko kalifikazioa. Adibidez, scales/advancedgradingforms direlakoen arabera ezar daitezke, baina beti koma higikorreko zenbakitara berriro pasako da.';
$string['privacy:metadata:grader'] = 'Kalifikatzailearen erabiltzailearen IDa.';
$string['privacy:metadata:groupid'] = 'Erabiltzailea kidea den taldearen IDa.';
$string['privacy:metadata:latest'] = 'Azken saiakerari buruzko informazioei buruzko bilaketak dezente errazten ditu.';
$string['privacy:metadata:mailed'] = 'Erabiltzaile honi mezurik bidali al zaio?';
$string['privacy:metadata:timecreated'] = 'Sorrera-unea';
$string['privacy:metadata:timestarted'] = 'Denboraren hasiera';
$string['privacy:metadata:userid'] = 'Erabiltzailearen IDa';
$string['privacy:studentpath'] = 'Ikasleen bidalketak';
$string['privacy:submissionpath'] = 'Bidalketa';
$string['quickgrading'] = 'Kalifikazio azkarra';
$string['quickgrading_help'] = 'Kalifikazio azkarraren bidez, kalifikazioak (eta ikaste-emaitzak) jar  ditzakezu zuzenean bidalketa-taulan. Kalifikazio azkarra ez da bateragarria kalifikazio aurreratuarekin eta ez da kalifikatzaile bat baino gehiago dagoenean erabiltzea gomendatzen.';
$string['quickgradingchangessaved'] = 'Kalifikazio aldaketak gorde dira';
$string['quickgradingresult'] = 'Kalifikazio azkarra';
$string['recordid'] = 'Identifikatzailea';
$string['relativedatessubmissiontimeleft'] = 'Ikasleko kalkulatuta';
$string['removeallgroupoverrides'] = 'Ezabatu talde-salbuespen guztiak';
$string['removealluseroverrides'] = 'Ezabatu erabiltzaile-salbuespen guztiak';
$string['removesubmission'] = 'Ezabatu bidalketa';
$string['removesubmissionconfirm'] = 'Ziur zaude bidalketa ezabatu nahi dituzula?';
$string['removesubmissionconfirmforstudent'] = 'Ziur zaude {$a} ikaslearen bidalketa ezabatu nahi dituzula?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Ziur zaude {$a} zereginean egindako bidalketa ezabatu nahi duzula? Kontuan izan mesedez honek ez duela ikaslearen denbora-muga berrabiaraziko. Ikasleari denbora gehigarria eman ahal diozu denbora-mugaren erabiltzaile-salbuespena gehituta.';
$string['removesubmissionconfirmwithtimelimit'] = 'Ziur zaude zure bidalketa ezabatu nahi duzula? Kontuan izan mesedez honek ez duela zure denbora-muga berrabiaraziko.';
$string['removesubmissionforstudent'] = 'Ezabatu ikaslearen bidalketa:  (IDa={$a->id}, izen osoa={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Gainditu arte berrireki aukera ez da bateragarria bidalketa anonimekin, kalifikazioak ez direlako kalifikatzailera bidaltzen ikasleen identitateak ezagutarazi arte.';
$string['requireallteammemberssubmit'] = 'Behartu taldekide guztiak bidalketa egitera';
$string['requireallteammemberssubmit_help'] = 'Ezarpen hau Bidalketa ezarpenetako \'Behartu ikasleak bidali botoian klik egitera\' aukerarekin batera erabili behar da.

Gaituz gero, taldekide guztiek bidalketa-botoian klik egin behar dute taldearen bidalketa amaitutzat emateko. Desgaituz gero, edozein taldekidek bidalketa bidali ahalko du.';
$string['requiresubmissionstatement'] = 'Behartu ikasleak bidalketa-adierazpena onartzera';
$string['requiresubmissionstatement_help'] = 'Behartu ikasleak bidalketa-adierazpena onartzera zeregin honen bidalketa guztietan.';
$string['revealidentities'] = 'Ezagutarazi ikasleen identitatea';
$string['revealidentitiesconfirm'] = 'Ziur zaude ikasleen identitatea jakinarazi nahi duzula zeregin honetan? Eragiketa hau ezin da desegin. Behin ikasleen identitateak jakinarazi direla, kalifikazioak kalifikazio liburura bidaliko dira.';
$string['reverttodefaults'] = 'Itzuli zereginaren balio lehenetsietara';
$string['reverttodraft'] = 'Itzuli bidalketa zirriborro egoerara';
$string['reverttodraftforgroup'] = 'Itzuli {$a} taldearen bidalketa zirriborrora.';
$string['reverttodraftforstudent'] = 'Itzuli ikasle honen bidalketa zirriborro egoerara: (id={$a->id}, izen osoa={$a->fullname}).';
$string['reverttodraftshort'] = 'Itzuli bidalketa zirriborrora';
$string['reviewed'] = 'Berrikusia';
$string['save'] = 'Gorde';
$string['saveallquickgradingchanges'] = 'Gorde kalifikazio azkar guztietako aldaketak';
$string['saveandcontinue'] = 'Gorde eta jarraitu';
$string['savechanges'] = 'Gorde aldaketak';
$string['savegradingresult'] = 'Kalifikazioa';
$string['savenext'] = 'Gorde eta erakutsi hurrengoa';
$string['saveoverrideandstay'] = 'Gorde eta sartu beste salbuespen bat';
$string['savingchanges'] = 'Aldaketak gordetzen...';
$string['scale'] = 'Eskala';
$string['search:activity'] = 'Zeregina - jardueraren informazioa';
$string['selectedusers'] = 'Aukeratutako erabiltzaileak';
$string['selectlink'] = 'Aukeratu...';
$string['selectuser'] = 'Aukeratu {$a}';
$string['sendlatenotifications'] = 'Eman kalifikatzaileei epez kanpoko bidalketen berri';
$string['sendlatenotifications_help'] = 'Gaituz gero, kalifikatzaileek (normalean irakasleak) mezu bat jasotzen dute ikasleek bidalketa bat berandu egiten duten bakoitzean. Mezularitza-metodoak konfiguratuta daude horretarako.';
$string['sendnotifications'] = 'Jakinarazi kalifikatzaileei bidalketak daudenean';
$string['sendnotifications_help'] = 'Gaituz gero, kalifikatzaileek (normalean irakasleak) mezu bat jasotzen dute ikasleek bidalketa bat egiten duten bakoitzean, nahiz garaiz edo berandu bidali. Mezularitza-metodoak konfiguratuta daude horretarako.';
$string['sendstudentnotifications'] = 'Jakinarazi ikasleari';
$string['sendstudentnotifications_help'] = 'Markatu ezazu kutxa hau ikasleari eguneratutako kalifikazio edo feedbackaren berri emateko jakinarazpena bidaltzeko. Zeregin honetan kalifikazio lan-fluxua gaituta badago jakinarazpena ez da bidaliko kalifikazioa argitaratu arte.';
$string['sendstudentnotificationsdefault'] = '\'Jakinarazi ikasleari\' ezarpenaren balio lehenetsia';
$string['sendstudentnotificationsdefault_help'] = 'Ikasle bakoitza kalifikatzean, \'Jakinarazi ikasleari\' laukitxo markatuta egon behar da modu lehenetsian?';
$string['sendsubmissionreceipts'] = 'Bidali ikasleei bidalketa gorde izanaren agiria';
$string['sendsubmissionreceipts_help'] = 'Aukera honek bidalketa gorde izanaren agiriak gaitzen ditu ikasleentzat. Ikasleek jasoko dute jakinarazpen bat zeregin bat bidaltzen duten bakoitzean.';
$string['setmarkerallocationforlog'] = 'Ezarri kalifikatzaile esleipena: (id={$a->id}, izen osoa={$a->fullname}, kalifikatzailea={$a->marker}).';
$string['setmarkingallocation'] = 'Ezarri esleitutako kalifikatzailea';
$string['setmarkingworkflowstate'] = 'Ezarri kalifikazio lan-fluxuaren egoera';
$string['setmarkingworkflowstateforlog'] = 'Ezarri kalifikazio lan-fluxuaren egoera:  (id={$a->id}, izen osoa={$a->fullname}, egoera={$a->state}).';
$string['settings'] = 'Zereginaren ezarpenak';
$string['showrecentsubmissions'] = 'Erakutsi azken bidalketak';
$string['status'] = 'Egoera';
$string['studentnotificationworkflowstateerror'] = 'Kalifikazio lan-fluxuaren egoera \'Argitaratuta\' izan behar da ikasleei jakinarazteko.';
$string['submission'] = 'Bidalketa';
$string['submissionattachments'] = 'Erakutsi fitxategiak soilik bidalketa egin bitartean';
$string['submissionattachments_help'] = 'Markatu laukitxo hau fitxategiak soilik bidalketa-orrian erakutsiak izan daitezen.
Bestela, fitxategiak zereginaren eta bidalketaren orrian erakutsiko dira.';
$string['submissioncopiedhtml'] = '<p>\'<i>{$a->assignment}</i>\' zereginerako aurreko bidalketaren kopia bat egin duzu.</p>
<p>Zure <a href="{$a->url}">zeregin bidalketaren</a> egoera ikus dezakezu.</p>';
$string['submissioncopiedsmall'] = '{$a->assignment} zereginerako zure aurreko bidalketa kopiatu duzu';
$string['submissioncopiedtext'] = '\'{$a->assignment}\' zereginerako zure aurreko bidalketa kopiatu duzu

Zure zeregin bidalketaren egoera hemen ikus dezakezu:

   {$a->url}';
$string['submissiondrafts'] = 'Behartu ikasleak bidali botoian klik egitera';
$string['submissiondrafts_help'] = 'Gaituz gero, ikasleek bidali botoian klik egin beharko dute bidalketa amaitutzat emateko. Mekanismo honi esker, ikasleek sisteman zirriborro moduko bidalketa bat gorde dezakete. Aukera hau "Ez" egoeratik "Bai" egoerara aldatzen bada eta dagoeneko ikasleen bidalketak badaude, amaitutako bidalketatzat hartuko dira.';
$string['submissioneditable'] = 'Ikasleak bere bidalketa edita dezake';
$string['submissionempty'] = 'Ez da ezer bidali';
$string['submissionlog'] = 'Ikaslea: {$a->fullname}, Egoera: {$a->status}';
$string['submissionmodified'] = 'Bidalketen informazioa daukazu. Mesedez irten orritik eta saiatu berriro.';
$string['submissionmodifiedgroup'] = 'Beste norbaitek bidalketa eguneratu du. Mesedez irten orritik eta saiatu berriro.';
$string['submissionnotcopiedinvalidstatus'] = 'Bidalketa ez da kopiatu, berrireki ondoren editatu delako.';
$string['submissionnoteditable'] = 'Ikasleak ezin du editatu bidalketa hau';
$string['submissionnotopen'] = 'Zeregin hau ez dago bidalketak egiteko zabalik';
$string['submissionnotready'] = 'Zeregin hau ez dago bidaltzeko prest:';
$string['submissionplugins'] = 'Bidalketa-pluginak';
$string['submissionreceipthtml'] = '<p>\'<i>{$a->assignment}</i>\' zereginean bidalketa egin duzu.</p>
<p>Zure <a href="{$a->url}">zeregineko bidalketaren egoera</a> ikus dezakezu.</p>';
$string['submissionreceiptotherhtml'] = '\'<i>{$a->assignment}</i>\' zereginean egin duzun bidalketa ondo gorde da.<br /><br />
Zure <a href="{$a->url}">zeregineko bidalketaren egoera</a> ikus dezakezu.';
$string['submissionreceiptothersmall'] = '{$a->assignment} zereginean egin duzun bidalketa ondo gorde da.';
$string['submissionreceiptothertext'] = '\'{$a->assignment}\' zereginean egin duzun bidalketa ondo gorde da.

Zure zeregineko bidalketaren egoera hemen ikus dezakezu:

    {$a->url}';
$string['submissionreceipts'] = 'Bidali bidalketa gorde izanaren agiria';
$string['submissionreceiptsmall'] = 'Bidalketa egin duzu {$a->assignment} zereginean';
$string['submissionreceipttext'] = '\'{$a->assignment}\' zereginean egin duzun bidalketa ondo gorde da.

Zure zeregineko bidalketaren egoera hemen ikus dezakezu:

 {$a->url}';
$string['submissionsclosed'] = 'Bidalketa itxita';
$string['submissionsettings'] = 'Bidalketaren ezarpenak';
$string['submissionslocked'] = 'Zeregin honek ez du bidalketarik onartzen';
$string['submissionslockedshort'] = 'Ez dago baimenduta bidalketan aldaketak egitea';
$string['submissionstatement'] = 'Bidalketa-adierazpena';
$string['submissionstatement_help'] = 'Ikasle bakoitzak bere lanak bidali ahal izateko onartu behar duten adierazpena.';
$string['submissionstatementacceptedlog'] = '{$a} erabiltzaileak bidalketa-adierazpena onartu du';
$string['submissionstatementdefault'] = 'Bidalketa hau nik egindako lana da, eta besteen ekarpenak baditu, egilearen aitorpena egin dut lanean bertan.';
$string['submissionstatementrequired'] = 'Onespen hau onartu behar duzu bidalketa egin aurretik.';
$string['submissionstatementteamsubmission'] = 'Taldekako bidalketa-adierazpena';
$string['submissionstatementteamsubmission_help'] = 'Ikasle bakoitzak bere taldeko lana bidali ahal izateko onartu behar duen adierazpena.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Taldeko kide guztiek bidalketak egiten dituzteneko taldekako bidalketa-adierazpena';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Ikasle bakoitzak talde bateko kide gisa bere lana bidali ahal izateko onartu behar duen adierazpena.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Bidalketa hau nire lana da taldeko kide gisa, beste norbaiten lana erabili izana aitortzen dudan kasuetan izan ezik.';
$string['submissionstatementteamsubmissiondefault'] = 'Bidalketa hau nire taldearen lana da, beste norbaiten lana erabili izana aitortzen dugun kasuetan izan ezik.';
$string['submissionstatus'] = 'Bidalketaren egoera';
$string['submissionstatus_'] = 'Ez dago bidalketarik';
$string['submissionstatus_draft'] = 'Zirriborroa (bidali gabea)';
$string['submissionstatus_marked'] = 'Kalifikatua';
$string['submissionstatus_new'] = 'Bidalketarik ez';
$string['submissionstatus_reopened'] = 'Berrirekita';
$string['submissionstatus_submitted'] = 'Kalifikatzeko bidalia';
$string['submissionstatusheading'] = 'Bidalketen egoera';
$string['submissionsummary'] = '{$a->status}. Azken aldaketa {$a->timemodified}-n';
$string['submissionteam'] = 'Taldea';
$string['submissiontypes'] = 'Bidalketa motak';
$string['submitaction'] = 'Bidali';
$string['submitassignment'] = 'Bidali zeregina';
$string['submitassignment_help'] = 'Behin zeregina bidalita, ezin izango duzu aldaketarik egin.';
$string['submitforgrading'] = 'Bidali kalifikatzeko';
$string['submitted'] = 'Bidalita';
$string['submittedearly'] = 'Bidalketa epea amaitu baino {$a} lehenago bidali zen';
$string['submittedlate'] = 'Zeregina berandu bidali zen: {$a}';
$string['submittedlateshort'] = '{$a} beranduago';
$string['submittedovertime'] = 'Zeregina denbora agortu baino {$a} beranduago bidali zen.';
$string['submittedundertime'] = 'Zeregina denbora agortu baino {$a} lehenago bidali zen.';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Feedback plugina';
$string['subplugintype_assignfeedback_plural'] = 'Feedback pluginak';
$string['subplugintype_assignsubmission'] = 'Bidalketa-plugina';
$string['subplugintype_assignsubmission_plural'] = 'Bidalketa-pluginak';
$string['teamname'] = 'Taldea: {$a}';
$string['teamsubmission'] = 'Ikasleek taldeka bidaliko dute';
$string['teamsubmission_help'] = 'Gaituz gero, ikasleak lehenetsitako talde-multzoaren arabera edo talde-multzo jakin baten arabera banatuko dira. Taldeko bidalketa bat taldeko kide guztien artean partekatuko da eta taldekide guztiek ikusiko dute bidalketari beste taldekideek egindako aldaketak.';
$string['teamsubmissiongroupingid'] = 'Ikasle-taldeen talde-multzoa';
$string['teamsubmissiongroupingid_help'] = 'Zereginak talde-multzo hau erabiliko du ikasle-taldeak aurkitzeko. Zehazten ez bada, lehenetsitako talde multzoa erabiliko da.';
$string['textinstructions'] = 'Zereginerako argibideak';
$string['timelimit'] = 'Denbora-muga';
$string['timelimit_help'] = 'Gaituz gero, zereginaren orrian denbora-muga abiarazten da eta bidalketa egin bitartean atzera-kontaketa bat erakusten da.';
$string['timelimitnotenabled'] = 'Zereginerako denbora-muga ez dago gaituta.';
$string['timelimitpassed'] = 'Denbora-muga agortu egin da';
$string['timemodified'] = 'Azken aldaketa';
$string['timeremaining'] = 'Geratzen den denbora';
$string['timeremainingcolon'] = 'Geratzen den denbora: {$a}';
$string['togglezoom'] = 'Zoom gehiego/gutxiago eremuan';
$string['ungroupedusers'] = '\'Behartu taldeko kidea izatea bidalketa egiteko\' ezarpena gaituta dago eta erabiltzaile batzuk ez dira inongo taldeko kide edo talde bat baino gehiagoko kideak dira, eta beraz erabiltzaile horiek ezingo dute bidalketarik egin.';
$string['ungroupedusersoptional'] = '\'Ikasleek taldeka bidaliko dute\' ezarpena gaituta dago eta erabiltzaile batzuk ez dira ezein taldeko kide, edo talde anitzetako kideak dira. Kontuan izan ikasle hauek \'Talde lehenetsia\'-ren kide gisa egingo dituztela bidalketak.';
$string['unlimitedattempts'] = 'Mugarik gabea';
$string['unlimitedattemptsallowed'] = 'Mugarik gabeko saiakera-kopurua onartzen da.';
$string['unlimitedpages'] = 'Mugarik gabea';
$string['unlocksubmissionforstudent'] = 'Baimendu bidalketak ikasle honi: (id={$a->id}, izen osoa={$a->fullname}).';
$string['unlocksubmissions'] = 'Desblokeatu bidalketak';
$string['unsavedchanges'] = 'Gorde gabeko aldaketak';
$string['unsavedchangesquestion'] = 'Gorde gabeko aldaketak daude kalifikazio edota feedbackean. Aldaketak gorde eta jarraitu nahi duzu?';
$string['updategrade'] = 'Eguneratu kalifikazioa';
$string['updatetable'] = 'Gorde eta eguneratu taula';
$string['upgradenotimplemented'] = 'Ez da garatu ({$a->type} {$a->subtype}) pluginarentzako eguneraketa';
$string['userassignmentdefaults'] = 'Zereginetan lehenetsitakoak erabiltzaileentzat';
$string['userextensiondate'] = 'Epearen luzapena eman da {$a} arte';
$string['usergrade'] = 'Erabiltzailearen kalifikazioa';
$string['useridlistnotcached'] = 'Kalifikazioen aldaketak EZ dira gorde, ezin izan delako zehaztu zein bidalketarentzat ote ziren.';
$string['useroverrides'] = 'Erabiltzaile-salbuespenak';
$string['useroverridesdeleted'] = 'Erabiltzaile-salbuespenak ezabatu dira.';
$string['usersnone'] = 'Ez dago zereginera sarbidea duen ikaslerik.';
$string['usersubmissioncannotberemoved'] = '{$a}(r)en bidalketa ezin da ezabatu.';
$string['userswhoneedtosubmit'] = 'Bidalketa egin behar duten erabiltzaileak: {$a}';
$string['validmarkingworkflowstates'] = 'Kalifikazio lan-fluxu egoera zuzenak';
$string['viewadifferentattempt'] = 'Ikusi beste saiakera bat';
$string['viewbatchmarkingallocation'] = 'Ikusi kalifikatzaile esleipen sortaren orria.';
$string['viewbatchsetmarkingworkflowstate'] = 'Ikusi kalifikazio lan-fluxu egoera sortaren orria.';
$string['viewfeedback'] = 'Ikusi feedbacka';
$string['viewfeedbackforuser'] = 'Ikusi erabiltzaile honentzako feedbacka: {$a}';
$string['viewfull'] = 'Ikusi guztia';
$string['viewfullgradingpage'] = 'Ireki kalifikazio guztien orria feedbacka emateko';
$string['viewgradebook'] = 'Ikusi kalifikazio-liburua';
$string['viewgrading'] = 'Ikusi bidalketa guztiak';
$string['viewgradingformforstudent'] = 'Ikusi ikasle honen kalifikazio-orria: (id={$a->id}, izen osoa={$a->fullname}).';
$string['viewownsubmissionform'] = 'Ikusi norberaren zereginen bidalketa-orria.';
$string['viewownsubmissionstatus'] = 'Ikusi norberaren zereginen bidalketa-orria.';
$string['viewrevealidentitiesconfirm'] = 'Ikusi ikasleen identitatea ezagutarazteko berrespen-orria.';
$string['viewsubmission'] = 'Ikusi bidalketa';
$string['viewsubmissionforuser'] = 'Ikusi ikasle honen erabiltzailea: {$a}';
$string['viewsubmissiongradingtable'] = 'Ikusi bidalketen kalifikazio-orria.';
$string['viewsummary'] = 'Ikusi laburpena';
$string['workflowfilter'] = 'Lan-fluxu iragazkia';
$string['xofy'] = '{$a->y}(e)tik {$a->x}.a';
