<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'nl', version '4.3'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'A♭ majeur';
$string['abminor'] = 'A♭ mineur';
$string['alto'] = 'Alt';
$string['altoclef'] = 'C-Sleutel (hoog)';
$string['anmajor'] = 'A Majeur';
$string['anminor'] = 'A Mineur';
$string['answerlbl'] = 'Antwoord';
$string['asharpminor'] = 'A♯ Mineur';
$string['aug10'] = 'Overmatige decime';
$string['aug11'] = 'Overmatige undecime';
$string['aug12'] = 'Overmatige duodecime';
$string['aug13'] = 'Overmatige tredecime';
$string['aug2'] = 'Overmatige secunde';
$string['aug3'] = 'Overmatige terts';
$string['aug4'] = 'Overmatige kwart';
$string['aug5'] = 'Overmatige kwint';
$string['aug6'] = 'Overmatige sext';
$string['aug7'] = 'Overmatige septiem';
$string['aug8'] = 'Overmatig oktaaf';
$string['aug9'] = 'Overmatige none';
$string['augmented'] = 'Overmatig';
$string['bass'] = 'Bas';
$string['bassclef'] = 'F-sleutel';
$string['bbmajor'] = 'B♭ majeur';
$string['bbminor'] = 'B♭ mineur';
$string['bnmajor'] = 'B majeur';
$string['bnminor'] = 'B mineur';
$string['cbmajor'] = 'C♭ majeur';
$string['chordquality'] = 'Akkoordgeslacht';
$string['chordquality-random'] = 'Mogelijke akkoordgeslachten';
$string['chordquality_write_questionastext'] = 'Akkoordgeslacht antwoord opgave';
$string['chordquality_write_questionastext_help'] = '<p>Geef een door komma’s gescheiden lijst van noten, zonder spaties, met de volgende syntax:</p><p>[Hoofdletter naam] [Voorteken ("n" = herstellingsteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)]4, ... </p>
<p>Willekeurig voorbeeld: <b>antwoord=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Harmonische functie antwoord opgave';
$string['chordquality_write_questionasui_help'] = '<p>Geef noten in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een “normale” noot zonder voorteken, kies dan voor het herstellingsteken ♮. Wil je een noot verwijderen klik er dan opnieuw op.';
$string['chordroot'] = 'Akkoord grondtoon';
$string['clef'] = 'Sleutel';
$string['clef-random'] = 'Mogelijke sleutels';
$string['cnmajor'] = 'C majeur';
$string['cnminor'] = 'C mineur';
$string['considerregister'] = 'Voeg register toe';
$string['considerregister_help'] = 'Geeft aan of het register van de toon meegenomen moet worden in de vraag.';
$string['correctansweris'] = 'Het goede antwoord is:';
$string['correctansweris_morethanone'] = 'Een mogelijk goed antwoord is:';
$string['csharpmajor'] = 'C♯ majeur';
$string['csharpminor'] = 'C♯ mineur';
$string['dbmajor'] = 'D♭ majeur';
$string['dim10'] = 'Verminderde decime';
$string['dim11'] = 'Verminderde undecime';
$string['dim12'] = 'Verminderde duodecime';
$string['dim13'] = 'Verminderde tredecime';
$string['dim2'] = 'Verminderde secunde';
$string['dim3'] = 'Verminderde terts';
$string['dim4'] = 'Verminderde kwart';
$string['dim5'] = 'Verminderde kwint';
$string['dim6'] = 'Verminderde sext';
$string['dim7'] = 'Verminderde septiem';
$string['dim8'] = 'Verminderd oktaaf';
$string['dim9'] = 'Verminderde none';
$string['diminished'] = 'Verminderd';
$string['dirasc'] = 'Boven de gegeven noot';
$string['dirdesc'] = 'Onder de gegeven noot';
$string['direction'] = 'Richting';
$string['displaykeysignature'] = 'Laat de toonsoort zien';
$string['dnmajor'] = 'D majeur';
$string['dnminor'] = 'D mineur';
$string['dsharpminor'] = 'D♯ mineur';
$string['ebmajor'] = 'E♭ majeur';
$string['ebminor'] = 'E♭ mineur';
$string['emptykeysignature'] = 'Lege toonsoort';
$string['enmajor'] = 'E majeur';
$string['enminor'] = 'E mineur';
$string['fnmajor'] = 'F majeur';
$string['fnminor'] = 'F mineur';
$string['fsharpmajor'] = 'F♯ majeur';
$string['fsharpminor'] = 'F♯ mineur';
$string['gbmajor'] = 'G♭ majeur';
$string['givennoteelementgroup'] = 'Gegeven noot';
$string['gnmajor'] = 'G majeur';
$string['gnminor'] = 'G mineur';
$string['grandstaff'] = 'G- en F-sleutel; piano notenbalk';
$string['gsharpminor'] = 'G♯ mineur';
$string['harmonicfunction_write_questionastext'] = 'Harmonische functie antwoord opgave';
$string['harmonicfunction_write_questionastext_help'] = '<p>Geef een door komma’s gescheiden lijst van noten, zonder spaties, door gebruik te maken van de volgende syntax: </p><p>[Hoofdletter naam] [Voorteken ("n" = herstellingsteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)]4, ... </p>
<p>Willekeurig voorbeeld: <b>antwoord=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Harmonische functie antwoord opgave';
$string['harmonicfunction_write_questionasui_help'] = '<p>Geef noten in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een “normale” noot zonder voorteken, kies dan voor het herstellingsteken ♮. Wil je een noot verwijderen klik er dan opnieuw op.</p>';
$string['harmonicfunctiontype-random'] = 'Mogelijke harmonische functies';
$string['hfidentifyresponsetypes'] = 'Mogelijke harmonische functie als antwoord';
$string['hftype_aug6th'] = 'Overmatige sext';
$string['hftype_diatonictriad'] = 'Diatonische drieklank';
$string['hftype_dom7th'] = 'Dominant septiem';
$string['hftype_extendeddom'] = 'Dominant met toevoegingen boven het oktaaf (9,11 of 13)';
$string['hftype_leadingtone7thfullydim'] = 'Verminderd septiem';
$string['hftype_leadingtone7thhalfdim'] = 'Halfverminderd septiem';
$string['hftype_neapolitan'] = 'Napels sext';
$string['hftype_nondom7th'] = 'Niet dominant septiem';
$string['hftype_secdom7th'] = 'Dubbel dominant (septiem)';
$string['hftype_secdomtriad'] = 'Dubbel dominant (drieklank)';
$string['hftype_secltfullydim'] = '';
$string['includealterations'] = 'Voeg voortekens toe';
$string['includealterations_help'] = 'Geeft aan of voortekens meegenomen moeten worden als deel van de vraag.';
$string['includestaticnote'] = 'Voeg gegeven noot toe';
$string['interval_write_questionastext'] = 'Interval antwoord opgave';
$string['interval_write_questionastext_help'] = '<p>Geef de antwoord noot, zonder spaties, gebruik makend van de volgende syntax: [Hoofdletter naam] [Voortekens("n" = zonder voorteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)] [Register (een getal tussen 1 en 6, aangegeven in het SPN]</p><p>Voorbeelden:
</p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Interval antwoord opgave';
$string['interval_write_questionasui_help'] = '<p>Geef noten in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een “normale” noot zonder voorteken, kies dan voor het herstellingsteken ♮. Wil je een noot verwijderen klik er dan opnieuw op.</p>';
$string['javascriptrequired'] = 'Deze moet vervangen worden door een grafische user interface, zorg dat Javascript gebruikt mag worden in je browser.';
$string['keyboard_input_questionasui'] = 'Piano klikken antwoord opgave';
$string['keyboard_input_questionasui_help'] = '<p>Geef noten in door te klikken op de piano. Om een noot te verwijderen, klik je er nogmaals op.</p>';
$string['keymode'] = 'Toonsoort';
$string['keysignature_write_questionastext'] = 'Toonsoort antwoord opgave';
$string['keysignature_write_questionastext_help'] = '<p>Geef een door komma’s gescheiden lijst van voortekens (tussen 1 en 7), zonder spaties, door gebruik te maken van de volgende syntax:</p><p>[Hoofdletter naam] [Register(een getal tussen 2 en 5, aangegeven in het SPN] </p><p>Voorbeeld: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Toonsoort antwoord opgave';
$string['keysignature_write_questionasui_help'] = '<p>Geef voortekens in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een noot verwijderen klik er dan opnieuw op.</p>';
$string['lbl_harmonicfunction'] = 'Harmonische functie';
$string['maj10'] = 'Grote decime';
$string['maj13'] = 'Grote tredecime';
$string['maj2'] = 'Grote secunde';
$string['maj3'] = 'Grote terts';
$string['maj6'] = 'Grote sext';
$string['maj7'] = 'Grote septiem';
$string['maj9'] = 'Grote none';
$string['major'] = 'Majeur';
$string['min10'] = 'Kleine decime';
$string['min13'] = 'Kleine tredecime';
$string['min2'] = 'Kleine secunde';
$string['min3'] = 'Kleine terts';
$string['min6'] = 'Kleine sext';
$string['min7'] = 'Kleine septiem';
$string['min9'] = 'Kleine none';
$string['minor'] = 'Mineur';
$string['mode-random'] = 'Mogelijke modi';
$string['musicqtype'] = 'Muziek vraag type';
$string['musictheory_gradingstrategy'] = 'Beoordelings strategie';
$string['musictheory_gradingstrategy_help'] = '<p>De beoordelingsstrategie bepaalt hoe de vraag wordt beoordeeld.</p>
<p><b>Alles of niets</b>: Het ingevulde antwoord zal vergeleken worden met het juiste antwoord. Wanneer het ingevulde antwoord juist is, zal het maximale aantal punten toegekend worden. Wanneer het ingevulde antwoord fout is, zullen er 0 punten gegeven worden.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Beoordelingsstrategie';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>De beoordelingsstrategie bepaalt hoe de vraag wordt beoordeeld.</p>
<p><b>Alles of niets</b>: Het ingevulde antwoord zal vergeleken worden met het juiste antwoord. Wanneer het ingevulde antwoord juist is, zal het maximale aantal punten toegekend worden. Wanneer het ingevulde antwoord fout is, zullen er 0 punten gegeven worden.</p>
<p><b>Gedeeltelijke punten voor iedere correcte noot</b>:
Een beoordelingsstrategie dat het aantal punten gelijk verdeelt over het aantal noten die de gebruiker moet ingeven en punten toekent per goed ingegeven noot .</p>';
$string['musictheory_intervalelementgroup'] = 'Interval';
$string['musictheory_intervalelementgroup_help'] = 'Geeft het type interval weer.';
$string['musictheory_intervalelementgroup_random'] = 'Mogelijke intervallen';
$string['nosectonic'] = '[Geen tweede tonica]';
$string['note_write_questionastext'] = 'Noot antwoord opgave';
$string['note_write_questionastext_help'] = '<p>Geef de antwoord noot, zonder spaties, gebruik makend van de volgende syntax: [Hoofdletter naam] [Voortekens("n" = zonder voorteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)] [Register (een getal tussen 1 en 6, aangegeven in het SPN]</p><p>Voorbeelden:
</p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Noot antwoord opgave';
$string['note_write_questionasui_help'] = '<p>Geef noten in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een “normale” noot zonder voorteken, kies dan voor het herstellingsteken ♮. Wil je een noot verwijderen klik er dan opnieuw op.</p>';
$string['notea'] = 'A';
$string['noteb'] = 'B';
$string['notec'] = 'C';
$string['noted'] = 'D';
$string['notee'] = 'E';
$string['notef'] = 'F';
$string['noteg'] = 'G';
$string['notelbl'] = 'Noot';
$string['per11'] = 'Reine undecime';
$string['per12'] = 'Reine duodecime';
$string['per4'] = 'Reine kwart';
$string['per5'] = 'Reine kwint';
$string['per8'] = 'Rein oktaaf';
$string['perfect'] = 'Rein';
$string['pluginname'] = 'Muziektheorie';
$string['pluginname_help'] = 'Dit vraagtype maakt het mogelijk om verschillende type muziekvragen en oefeningen te ontwikkelen in een grafische gebruikersinterface.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = 'Voeg een muziektheorie vraag toe';
$string['pluginnameediting'] = 'Pas een muziektheorie vraag aan';
$string['pluginnamesummary'] = 'Maakt het mogelijk om verschillende type muziektheorieoefeningen te creëren.';
$string['possiblescalesinresponse'] = 'Mogelijke toonladders als antwoord';
$string['privacy:metadata'] = 'Muziek vraag type slaat geen persoonlijke data op.';
$string['qtype_chordquality-identify'] = 'Akkoord geslacht herkennen';
$string['qtype_chordquality-identify-random'] = 'Akkoord geslacht herkennen (willekeurig)';
$string['qtype_chordquality-write'] = 'Akkoord geslacht creëren';
$string['qtype_chordquality-write-random'] = 'Akkoord geslacht creëren (willekeurig)';
$string['qtype_harmonicfunction-identify'] = 'Harmonische functie herkennen';
$string['qtype_harmonicfunction-identify-random'] = 'Harmonische functie herkennen (willekeurig)';
$string['qtype_harmonicfunction-write'] = 'Harmonische functie creëren';
$string['qtype_harmonicfunction-write-random'] = 'Harmonische functie creëren (willekeurig)';
$string['qtype_interval-identify'] = 'Interval herkennen';
$string['qtype_interval-identify-random'] = 'Interval herkennen (willekeurig)';
$string['qtype_interval-write'] = 'Interval creëren';
$string['qtype_interval-write-random'] = 'Interval creëren (willekeurig)';
$string['qtype_keyboard-input'] = 'Piano invoer';
$string['qtype_keysignature-identify'] = 'Toonsoort herkennen';
$string['qtype_keysignature-identify-random'] = 'Toonsoort herkennen (willekeurig)';
$string['qtype_keysignature-write'] = 'Toonsoort creëren';
$string['qtype_keysignature-write-random'] = 'Toonsoort creëren (willekeurig)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Alles of niets';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Gedeeltelijke punten voor ieder goede noot';
$string['qtype_note-identify'] = 'Noot herkennen';
$string['qtype_note-identify-random'] = 'Noot herkennen (willekeurig)';
$string['qtype_note-write'] = 'Noot creëren';
$string['qtype_note-write-random'] = 'Noot creëren (willekeurig)';
$string['qtype_scale-identify'] = 'Toonladder herkennen';
$string['qtype_scale-identify-random'] = 'Toonladder herkennen (willekeurig)';
$string['qtype_scale-write'] = 'Toonladder creëren';
$string['qtype_scale-write-random'] = 'Toonladder creëren (willekeurig)';
$string['quality-random'] = 'Mogelijke geslachten';
$string['qualityaug'] = 'Overmatig';
$string['qualitydim'] = 'Verminderd';
$string['qualitymaj'] = 'Majeur';
$string['qualitymin'] = 'Mineur';
$string['qualityper'] = 'Rein';
$string['questionoptions'] = 'Vraagopties';
$string['questiontext'] = 'Vraagtekst';
$string['questiontext_chordquality_identify'] = 'Herken de grondtoon en het geslacht van het volgende akkoord';
$string['questiontext_chordquality_write'] = 'Geef het volgende akkoord';
$string['questiontext_harmonicfunction_identify'] = 'Herken de volgende harmonische functie';
$string['questiontext_harmonicfunction_write'] = 'Geef de volgende harmonische functie';
$string['questiontext_help'] = 'Dit veld is niet nodig. Als het leeg gelaten wordt, zal er automatisch een vraag tekst worden getoond die past bij het gegeven muziek vraagtype in de activiteiten. Als je tekst in dit veld invult, zal het de automatisch gegenereerde tekst overschrijven.';
$string['questiontext_interval_identify'] = 'Herken het volgende interval';
$string['questiontext_interval_write_above'] = 'Maak het volgende interval compleet door een noot <b>boven</b> de gegeven noot in te vullen';
$string['questiontext_interval_write_below'] = 'Maak het volgende interval compleet door een noot <b>onder</b> de gegeven noot in te vullen';
$string['questiontext_keyboard_input'] = 'Klik de volgende noot op de piano';
$string['questiontext_keysignature_identify_major'] = 'Bepaal de majeur toonsoort door middel van de volgende voortekens';
$string['questiontext_keysignature_identify_minor'] = 'Bepaal de mineur toonsoort door middel van de volgende voortekens';
$string['questiontext_keysignature_write'] = 'Geef de volgende toonsoort';
$string['questiontext_note_identify'] = 'Herken de volgende noot';
$string['questiontext_note_write'] = 'Geef de volgende noot';
$string['questiontext_scale_identify'] = 'Herken de volgende toonladder';
$string['questiontext_scale_write'] = 'Geef de volgende toonladder in stijgende richting';
$string['questiontext_scale_write_melodic'] = 'Geef de volgende toonladder in zowel stijgende als dalende richting';
$string['rootposition'] = '[grondtoon]';
$string['scale_write_questionastext'] = 'Toonladder opgave';
$string['scale_write_questionastext_help'] = '<p>Geef een door komma’s onderbroken lijst van noten, inclusief de tonica, zonder spaties, door gebruik te maken van de volgende zinsbouw:</p><p> [Hoofdletter naam][Voortekens("n" = zonder voorteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)] [Register (een cijfer tussen 2 en 6, gevolgd door SPN)], ... </p>
<p>Willekeurig voorbeeld: <b>Tonica = An4 antwoord=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Toonladder antwoord opgave';
$string['scale_write_questionasui_help'] = '<p>Geef noten in door te klikken op de notenbalk, na het selecteren van het juiste voorteken in de toolbar aan de rechterkant. Wil je een “normale” noot zonder voorteken, kies dan voor het herstellingsteken ♮. Wil je een noot verwijderen klik er dan opnieuw op.</p> <p>Pas op dat voortekens soms voor meer dan 1 noot gelden...</p>';
$string['scaletype'] = 'Toonladder';
$string['scaletype-random'] = 'Mogelijke toonladders';
$string['scaletype_harmonic'] = 'Harmonisch mineur';
$string['scaletype_major'] = 'Majeur';
$string['scaletype_melodic'] = 'Melodisch mineur';
$string['scaletype_natural'] = 'Oorspronkelijk mineur';
$string['selectakey'] = 'Selecteer een toonsoort';
$string['selectanoption'] = 'Selecteer';
$string['selectaquality'] = 'Selecteer een geslacht';
$string['selectasize'] = 'Selecteer een grootte';
$string['size-random'] = 'Mogelijke groottes';
$string['size10'] = 'decime';
$string['size11'] = 'undecime';
$string['size12'] = 'duodecime';
$string['size13'] = 'tredecime';
$string['size2'] = 'secunde';
$string['size3'] = 'terts';
$string['size4'] = 'kwart';
$string['size5'] = 'kwint';
$string['size6'] = 'sext';
$string['size7'] = 'septiem';
$string['size8'] = 'oktaaf';
$string['size9'] = 'none';
$string['tenor'] = 'Tenor';
$string['tenorclef'] = 'C-sleutel (laag)';
$string['tonic'] = 'Tonica';
$string['treble'] = 'Viool sleutel';
$string['trebleclef'] = 'G-sleutel';
$string['updatemusicqtype'] = 'Update opties';
$string['validation_harmonicfunctionnotsupported'] = 'Deze harmonische functie wordt niet ondersteund.';
$string['validation_harmonicfunctiontypenotselected'] = 'Het functie type voor deze harmonische functie moet worden geselecteerd.';
$string['validation_interval_novalidcombo'] = 'De geselecteerde mogelijke geslachten en groottes zorgen niet voor een ondersteund interval.';
$string['validation_intervaloutsidestaff'] = 'Het register van de gegeven noot geeft een interval dat niet past in de notenbalk bij de gegeven sleutel.';
$string['validation_invalidchordquality'] = 'Dit type akkoord kan niet gemaakt worden op de gegeven grondtoon.';
$string['validation_invalidinterval_above'] = 'Dit interval kan niet boven de gegeven noot genoteerd worden.';
$string['validation_invalidinterval_below'] = 'Dit interval kan niet onder de gegeven noot genoteerd worden.';
$string['validation_noteoutsidekeyboard'] = 'Deze noot is buiten het bereik van de piano.';
$string['validation_noteoutsidestaff'] = 'Het register van de gegeven noot  past niet in de notenbalk bij de gegeven sleutel.';
$string['validation_possiblescaletypenotselected'] = 'Het type toonladder moet nog geselecteerd worden.';
$string['validation_possiblescaletypesnotselected_random'] = 'De mogelijke toonladder types in het antwoord moeten alle mogelijke types in de vraag bevatten.';
$string['validation_qualitymismatch'] = 'Deze combinatie van interval grootte en geslacht worden niet ondersteund.';
$string['validation_samestaticandgivennote'] = 'De gegeven noot en het antwoord komen niet overeen met de toonsoort op de piano.';
$string['validation_scale_invalidtonic'] = 'Niet ondersteunde tonica voor deze toonladder.';
$string['validation_scaleoutsidestaff'] = 'Het register van de gegeven tonica zorgt voor een toonladder die niet past op de notenbalk bij de gegeven sleutel.';
$string['validationerror_chordquality_identify'] = 'Incompleet antwoord. De letter, het voortekens en het geslacht van het akkoord moeten worden geselecteerd.';
$string['validationerror_empty'] = 'Er is geen antwoord ingevuld.';
$string['validationerror_harmonicfunction_identify'] = 'Onvolledig antwoord. In alle rolmenus moet iets geselecteerd worden.';
$string['validationerror_incompletechordquality'] = 'Onvolledig antwoord. Aantal noten in dit akkoord.';
$string['validationerror_incompleteharmonicfunction'] = 'Onvolledig antwoord. Aantal noten in deze harmonische functie.';
$string['validationerror_interval_identify'] = 'Onvolledig antwoord. Zowel het geslacht als de grootte moet geselecteerd worden.';
$string['validationerror_invalidsyntax'] = 'Foute syntax in antwoord.';
$string['validationerror_note_identify'] = 'Onvolledig antwoord. De letter, het voorteken en het register moet geselecteerd worden.';
$string['validationerror_note_identify_ltr_acc'] = 'Onvolledig antwoord. Zowel de letter als het voorteken moet geselecteerd worden.';
$string['validationerror_note_identify_ltr_reg'] = 'Onvolledig antwoord. Zowel de letter als het register moet geselecteerd worden.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Er zijn twee noten ingevuld. Vul aub 1 noot in.';
$string['validationerror_scale_identify'] = 'Onvolledig antwoord. In alle dropdown menus moet iets geselecteerd worden.';
$string['validationerror_scale_incomplete'] = 'Onvolledig antwoord. Er worden totaal 8 noten gevraagd , inclusief de tonica.';
$string['validationerror_scale_incomplete_melodic'] = 'Onvolledig antwoord. Er worden totaal 15 noten gevraagd , inclusief de tonica.';
$string['validationerror_whitespace'] = 'Foute syntax in antwoord: verwijder alle spaties uit je antwoord.';
