<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'factor_totp', language 'nl', version '4.3'.
 *
 * @package     factor_totp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:revoke'] = 'Time-based one-time password (TOTP) authenticator intrekken';
$string['devicename'] = 'Apparaatlabel';
$string['devicename_help'] = 'Dit is het apparaat waarop een authenticator-app is geïnstalleerd. Je kunt meerdere apparaten instellen, zodat je met dit label kunt bijhouden welke apparaten worden gebruikt. Je moet elk apparaat instellen met een eigen unieke code, zodat deze afzonderlijk kunnen worden ingetrokken.';
$string['devicenameexample'] = 'bijvoorbeeld "Werk iPhone 11"';
$string['error:alreadyregistered'] = 'Dit time-based one-time password (TOTP)-geheim is al geregistreerd';
$string['error:codealreadyused'] = 'Deze code is al gebruikt voor authenticatie. Wacht tot er een nieuwe code is gegenereerd en probeer het opnieuw.';
$string['error:futurecode'] = 'Deze code is ongeldig. Controleer of de tijd op je authenticatieapparaat correct is en probeer het opnieuw.
     De huidige systeemtijd is {$a}.';
$string['error:oldcode'] = 'Deze code is te oud. Controleer of de tijd op je authenticatieapparaat correct is en probeer het opnieuw.
     De huidige systeemtijd is {$a}.';
$string['error:wrongverification'] = 'Onjuiste verificatiecode.';
$string['factorsetup'] = 'App instellingen';
$string['info'] = '<p>Gebruik gelijk welke TOTP-authenticator-app om een verificatiecode op je telefoon te krijgen, zelfs als deze offline is.</p>
bijv. <ul><li><a href="https://authy.com/download/">Twilio Authy</a></li>
<li><a href="https://www.microsoft.com/en-us/account/authenticator#getapp">Microsoft Authenticator</a></li>
<li>Google Authenticator voor <a href="https://itunes.apple.com/us/app/google-authenticator/id388497605?mt=8" target="_blank">iOS</a> of <a href ="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" target="_blank">Android</a></li></ul>
<p>Opmerking: zorg ervoor dat de tijd en datum van je apparaat zijn ingesteld op \'Auto\' of \'Netwerk voorzien\'.</p>';
$string['logindesc'] = 'Gebruik de authenticator-app op je mobiele apparaat om een code te genereren.';
$string['loginoption'] = 'Gebruik de Authenticator-applicatie';
$string['loginskip'] = 'Ik heb mijn apparaat niet';
$string['loginsubmit'] = 'Doorgaan';
$string['logintitle'] = 'Verifieer dat jij het bent via de mobiele app';
$string['pluginname'] = 'Authenticator-app';
$string['privacy:metadata'] = 'De TOTP-factorplug-in slaat geen persoonlijke gegevens op';
$string['settings:totplink'] = 'Link voor installatie van mobiele app tonen';
$string['settings:totplink_help'] = 'Indien ingeschakeld, ziet de gebruiker een derde installatieoptie met een directe otpauth://-link';
$string['settings:window'] = 'TOTP-verificatievenster';
$string['settings:window_help'] = 'Hoe lang elke code geldig is. JE kunt dit als tijdelijke oplossing op een hogere waarde instellen als de apparaatklokken van je gebruikers vaak enigszins afwijken.
     Naar beneden afgerond op de dichtstbijzijnde 30 seconden, wat de tijd is tussen nieuw gegenereerde codes.';
$string['setupfactor'] = 'TOTP-authenticator instellen';
$string['setupfactor:account'] = 'Account:';
$string['setupfactor:enter'] = 'Gegevens handmatig invoeren:';
$string['setupfactor:key'] = 'Geheime sleutel:';
$string['setupfactor:link'] = '<b> OF </b> mobiele app openen:';
$string['setupfactor:link_help'] = 'Als u een mobiel apparaat gebruikt en al een authenticator-app hebt geïnstalleerd, werkt deze link mogelijk. Houd er rekening mee dat het gebruik van TOTP op hetzelfde apparaat waarop u inlogt de voordelen van MFA kan verzwakken.';
$string['setupfactor:linklabel'] = 'Open de app die al op dit apparaat is geïnstalleerd';
$string['setupfactor:mode'] = 'Modus:';
$string['setupfactor:mode:timebased'] = 'Op tijd gebaseerd';
$string['setupfactor:scan'] = 'Scan QR-code:';
$string['setupfactor:scanfail'] = 'Kun je niet scannen?';
$string['setupfactor:scanwithapp'] = 'Scan de QR-code met de door jou gekozen authenticatietoepassing.';
$string['summarycondition'] = 'met behulp van een TOTP-app';
$string['systimeformat'] = '%l:%M:%S %P %Z';
$string['verificationcode'] = 'Voer je 6-cijferige verificatiecode in';
$string['verificationcode_help'] = 'Open je authenticator-app zoals Google Authenticator en zoek naar de 6-cijferige code die overeenkomt met deze site en gebruikersnaam';
