<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'ar', version '4.3'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'مجلد الإدارة المحدد غير صحيح';
$string['admindirname'] = 'مجلد الإدارة';
$string['admindirsetting'] = 'القليل جداً من مستضيفي الويب يستعمل /admin بمثابة رابط خاص
للوصول إلى لوحة التحكم أو ما شابه. لسوء الحظ هذا يتعارض مع
الموضع القياسي لصفحات إدارة مودل. يمكنك حل هذه المشكلة عبر
إعادة تسمية مجلد الإدارة admin في نسختك لهذا التنصيب، لتضع
هذا الاسم الجديد هنا. مثلاً: <br /> <br />
<b>moodleadmin</b><br /> <br />
هذا من شأنه إصلاح روابط الإدارة في مودل.';
$string['admindirsettinghead'] = 'إعداد دليل المشرف ...';
$string['admindirsettingsub'] = 'القليل جداً من مستضيفي الويب يستعمل /admin بمثابة رابط خاص
للوصول إلى دلوحة التحكم أو ما شابه. لسوء الحظ هذا يتعارض مع
الموضع القياسي لصفحات إدارة مودل. يمكنك حل هذه المشكلة عبر
إعادة تسمية مجلد الإدارة admin في نسختك لهذا التنصيب، لتضع
هذا الاسم الجديد هنا. مثلاً: <br /> <br />
<b>moodleadmin</b><br /> <br />
هذا من شأنه إصلاح روابط الإدارة في مودل.';
$string['availablelangs'] = 'حزم اللغات المتاحة';
$string['caution'] = 'تحذير';
$string['chooselanguage'] = 'إختر اللغة';
$string['chooselanguagehead'] = 'إختر اللغة';
$string['chooselanguagesub'] = 'يرجى تحديد لغة لاستعمالها عند التنصيب. هذه اللغة ستستعمل أيضاً بمثابة اللغة الافتراضية للموقع، لكن يمكنك تغييرها لاحقا.';
$string['cliadminemail'] = 'عنوان البريد الالكتروني للمشرف الجديد';
$string['cliadminpassword'] = 'كلمة المرور للمشرف الجديد';
$string['cliadminusername'] = 'اسم المستخدم لحساب المشرف';
$string['clialreadyconfigured'] = 'ملف التهيئة config.php موجود سلفاً. لطفاً، استعمل الرابط ذي المسار admin/cli/install_database.php لتنصيب مودل في هذا الموقع.';
$string['clialreadyinstalled'] = 'ملف التهيئة config.php موجود سلفاً. لطفاً، استعمل الرابط ذي المسار admin/cli/install_database.php لترقية مودل في هذا الموقع.';
$string['cliinstallfinished'] = 'تم التنصيب بنجاح.';
$string['cliinstallheader'] = 'برنامج تنصيب مودل {$a} عبر سطر الأوامر النصية';
$string['climustagreelicense'] = 'في النمط اللاتفاعلي، عليك الموافقة على الرخصة عبر استعمال الخيار --agree-license';
$string['cliskipdatabase'] = 'يجري تخطي تنصيب قاعدة البيانات.';
$string['clisupportemail'] = 'عنوان البريد الالكتروني للدعم';
$string['clitablesexist'] = 'جداول قاعدة البيانات موجودة سلفاً؛ التنصيب عبر واجهة سطر الأوامر لا يمكنه الاستمرار.';
$string['compatibilitysettings'] = 'يجري فحص إعدادات PHP ...';
$string['compatibilitysettingshead'] = 'يجري فحص إعدادات PHP ...';
$string['compatibilitysettingssub'] = 'لا بد لمخدمك من اجتياز كل هذه الاختبارات ليكون مودل قادراً على العمل بشكل صحيح';
$string['configfilenotwritten'] = 'النص البرمجي للتنصيب لم يتمكن تلقائياً من إنشاء الملف config.php الذي يتضمن خيارات التشغيل الخاصة بهذا التنصيب، ربما لأن مجلد مودل غير قابل للكتابة. يمكنك نسخ النص الآتي ولصقه يدوياً في ملف اسمه config.php ووضعه في المجلد الرئيسي لمودل.';
$string['configfilewritten'] = 'تم انشاء ملف config.php بنجاح';
$string['configurationcomplete'] = 'تمت عملية الإعداد';
$string['configurationcompletehead'] = 'تمت عملية الإعداد';
$string['configurationcompletesub'] = 'حاول مودل حفظ إعدادات التنصيب في ملف في المجلد الرئيسي لهذا التنصيب.';
$string['database'] = 'قاعدة البيانات';
$string['databasehead'] = 'إعدادات قاعدة البيانات';
$string['databasehost'] = 'مستضيف قاعدة البيانات';
$string['databasename'] = 'اسم قاعدة البيانات';
$string['databasepass'] = 'كلمة سر قاعدة البيانات';
$string['databaseport'] = 'منفذ قاعدة البيانات';
$string['databasesocket'] = 'مقبس يونكس';
$string['databasetypehead'] = 'إختر مشغل قاعدة البيانات';
$string['databasetypesub'] = 'يدعم مودل عدة أنواع من مخدمات قواعد البيانات. لطفاً، اتصل بالمشرف إن كنت لا تدري أيها تستعمل.';
$string['databaseuser'] = 'مستخدم قاعدة البيانات';
$string['dataroot'] = 'مجلد البيانات';
$string['datarooterror'] = 'تعذر العثور على \'مجلد البيانات\' الذي حددته أو تعذرإنشاؤه. إما أن تقوم بتصحيح المسار أو إنشائه يدوياً.';
$string['datarootpermission'] = 'صلاحيات مجلدات البيانات';
$string['datarootpublicerror'] = 'إن \'مجلد البيانات\' الذي حددته يمكن الوصول إليه مباشرة عبر الويب. عليك استعمال مجلد آخر.';
$string['dbconnectionerror'] = 'لم يتم التوصيل بقاعدة البيانات المحددة. تأكد من إعدادات قاعدة البيانات.';
$string['dbcreationerror'] = 'خطأ عند إنشاء قاعدة البيانات. تعذر إنشاء قاعدة البيانات بالاسم المحدد بالإعدادات المعطاة.';
$string['dbhost'] = 'المخدم المضيف';
$string['dbpass'] = 'كلمة المرور';
$string['dbport'] = 'المنفذ';
$string['dbprefix'] = 'بادئة الجداول';
$string['dbtype'] = 'نوع';
$string['directorysettings'] = '<p>لطفاً، قم بتأكيد مواضع هذا التنصيب من مودل.</p>

<p><b>عنوان الويب:</b>
حدد عنوان الويب الكامل حيث يمكن الوصول إلى مودل.
إن كان موقعك قابلاً للوصول إليه عبر روابط متعددة، عليك
اختيار أكثرها ملاءمة للاستعمال من قبل طلبتك.
لا تُضمِّن الرابط علامة الشطب النهائية.</p>

<p><b>مجلد مودل:</b>
حدد المسار الكامل للمجلد لهذا التنصيب
تأكد من صحة الحروف الكبيرة والصغيرة.</p>

<p><b>مجلد البيانات:</b>
أنت بحاجة إلى موضع يستطيع فيه مودل خزن الملفات المرفوعة إلى الموقع.
هذا المجلد ينبغي أن يكون قابلاً للقراءة والكتابة من قبل مستخدم مخدم الويب
(عادة هو \'nobody\' أو \'apache\' أو \'www-data\')، ولكن يجب أن لا يكون متاحاً للوصول إليه مباشرة عبر الويب.
سيحاول برنامج التنصيب إنشاءه إن لم يكن موجوداً.</p>';
$string['directorysettingshead'] = 'الرجاء تأكيد مكان تثبت مودل';
$string['directorysettingssub'] = '<b>عنوان الويب:</b>
حدد عنوان الويب الكامل حيث يمكن الوصول إلى مودل.
إن كان موقعك قابلاً للوصول إليه عبر روابط متعددة، عليك
اختيار أكثرها ملاءمة للاستعمال من قبل طلبتك.
لا تُضمِّن الرابط علامة الشطب النهائية.
<br />
<br />
<b>مجلد مودل:</b>
حدد المسار الكامل للمجلد لهذا التنصيب
تأكد من صحة الحروف الكبيرة والصغيرة.
<br />
<br />
<b>مجلد البيانات:</b>
أنت بحاجة إلى موضع يستطيع فيه مودل خزن الملفات المرفوعة إلى الموقع.
هذا المجلد ينبغي أن يكون قابلاً للقراءة والكتابة من قبل مستخدم مخدم الويب
(عادة هو \'nobody\' أو \'apache\' أو \'www-data\')، ولكن يجب أن لا يكون متاحاً للوصول إليه مباشرة عبر الويب.
سيحاول برنامج التنصيب إنشاءه إن لم يكن موجوداً.';
$string['dirroot'] = 'مجلد مودل';
$string['dirrooterror'] = 'إعدادّّّ"الدليل" غير صحيح. حاول إعادة الإعداد';
$string['download'] = 'تنزيل';
$string['downloadlanguagebutton'] = 'تنزيل حزمة لغة &quot;{$a}&quot;';
$string['downloadlanguagehead'] = 'تنزيل حزمة اللغة';
$string['downloadlanguagenotneeded'] = 'بإمكانك متابعة عملية التنصيب مستعملاً حزمة اللغة الافتراضية، "{$a}".';
$string['downloadlanguagesub'] = 'لديك الآن خيار تنزيل حزمة لغة أخرى ومتابعة عملية التنصيب بهذه اللغة.<br /><br />إن لم تكن قادراً على تنزيل حزمة اللغة، فعملية التنصيب ستستمر باللغة الإنجليزية. (بمجرد إكتمال التنصيب، ستتاح لك فرصة تنزيل حزم لغات أخرى وتنصيبها).';
$string['doyouagree'] = 'هل أنت موافق؟ (نعم/لا):';
$string['environmenthead'] = 'يتم فحص البيئة';
$string['environmentsub'] = 'نحن نتحقق فيما إذا كانت المكونات المختلفة في نظامك تلبي متطلبات النظام';
$string['environmentsub2'] = 'كل إصدار من مودل يتطلب وجود إصدار معين من PHP على الأقل مع عدد من امتداداته الإجبارية.
يجري فحص شامل لبيئة العمل قبل كل تنصيب وترقية. لطفاً، تواصل مع المشرف على المخدم إن لم تكن على دراية بكيفية تنصيب الإصدار الأحدث من PHP أو امتداداته.';
$string['errorsinenvironment'] = 'فشلت مهمة التحقق من بيئة التشغيل!';
$string['fail'] = 'فشل';
$string['fileuploads'] = 'رفع الملفات';
$string['fileuploadserror'] = 'هذا يجب أن يكون نشط';
$string['fileuploadshelp'] = '<p>رفع الملفات يبدو أنه معطل في مخدمك.</p>

<p>يمكن لمودل متابعة التنصيب مع ذلك، ولكن بدون تلك القدرة، لن تتمكن
من رفع ملفات المقررات الدراسية أو صور الملفات الشخصية للمستخدمين
وما سوى ذلك</p>

<p>لتمكين رفع الملفات، عليك (أو على المشرف على النظام) تحرير ملف
php.ini الرئيسي في مخدمك وتغيير قيمة أحد الإعدادات فيه وهو
   <b>file_uploads</b> إلى \'1\'.</p>';
$string['inputdatadirectory'] = 'مجلد البيانات';
$string['inputwebadress'] = 'عنوان الويب:';
$string['inputwebdirectory'] = 'مجلد مودل';
$string['installation'] = 'التنصيب';
$string['invaliddbprefix'] = 'بادئة غير صحيحة. يمكن أن تتضمن البادئة حروفاً لاتينية صغيرة وشُرَطاً تحتانية حصراً.';
$string['langdownloaderror'] = 'مع الأسف، اللغة "{$a}" تعذر تنزيلها. عملية التنصيب ستستمر باللغة الإنجليزية.';
$string['langdownloadok'] = 'تم تنصيب اللغة "{$a}" بنجاح. عملية التنصيب ستستمر بتلك اللغة.';
$string['memorylimit'] = 'حد الذاكرة';
$string['memorylimiterror'] = 'ذاكرة الـ PHP صغيرة جداً... من المحتل ستواجه بعض المشاكل لاحقاً';
$string['memorylimithelp'] = '<p>إن حد استعمال الذاكرة لـ PHP في مخدمك حالياً هو {$a}.</p>

<p>هذا قد يسبب لمودل مشاكل في الذاكرة لاحقاً، خصوصاً
إن كانت لديك الكثير من الوحدات مُمَكَّنة و/أو الكثير من المستخدمين.</p>

<p>نوصي بضبط ذاكرة PHP على حد أعلى إن أمكن، مثلاً 40M.
   هناك عدة طرق للقيام بذلك والتي بإمكانك تجربتها:</p>
<ol>
<li>إن كنت تستطيع القيام بذلك، أعد تجميع PHP مع المفتاح <i>--enable-memory-limit</i>.
    هذا سيسمح لمودل بضبط حد الذاكرة بنفسه.</li>
<li>إن كنت تستطيع الوصول إلى ملف php.ini، يمكنك تغيير الخاصية <b>memory_limit</b>
    هناك إلى شيء آخر مثل 40M. إن لم يكن بإمكانك الوصول إليه
فقد تستطيع مطالبة المشرف بالقيام بذلك من جانبه.</li>
<li>في بعض مخدمات PHP يمكنك إنشاء ملف .htaccess في مجلد مودل
وجعله محتوياً على السطر الآتي:
    <blockquote><div>php_value memory_limit 40M</div></blockquote>
    <p>مع ذلك، في بعض المخدمات، هذا من شأنه منع <b>كل</b> صفحات PHP من العمل
    (ستشاهد أخطاءً عند النظر إلى الصفحات) مما يحتم عليك إزالة ملف .htaccess.</p></li>
</ol>';
$string['mysqliextensionisnotpresentinphp'] = 'لم يتم تعريف PHP بشكل صحيح مع امتداد MySQLi للعمل معه على الاتصال مع MySQL. لطفاً، تحقق من ملف php.ini عندك أو أعد تجميع PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>إن قاعدة البيانات هي الموضع الذي تخزن فيه معظم إعدادات مودل وبياناته وينبغي تهيئتها هنا.</p>
<p>إن حقول: اسم قاعدة البيانات، اسم المستخدم، وكلمة المرور هي حقول إجبارية؛ بادئة الجداول هو حقل إختياري.</p>
<p>اسم قاعدة البيانات له أن يتضمن حروفاً وأرقاماً لاتينية، علامة الدولار ($)، والخطوط التحتانية (_).</p>
<p>إن كانت قاعدة البيانات غير موجودة حالياً، والمستخدم الذي حددته يمتلك الصلاحية، سيحاول مودل إنشاء قاعدة بيانات جديدة ذات صلاحيات وإعدادات صحيحة.</p>
<p>إن المشغل غير متوافق مع محرك MyISAM القديم.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>إن قاعدة البيانات هي الموضع الذي تخزن فيه معظم إعدادات مودل وبياناته وينبغي تهيئتها هنا.</p>
<p>إن حقول: اسم قاعدة البيانات، اسم المستخدم، وكلمة المرور هي حقول إجبارية؛ بادئة الجداول هو حقل إختياري.</p>
<p>اسم قاعدة البيانات له أن يتضمن حروفاً وأرقاماً لاتينية، علامة الدولار ($)، والشُّرَط التحتانية (_).</p>
<p>إن كانت قاعدة البيانات غير موجودة حالياً، والمستخدم الذي حددته يمتلك الصلاحية، سيحاول مودل إنشاء قاعدة بيانات جديدة ذات صلاحيات وإعدادات صحيحة.</p>
<p>هذا المشغل غير متوافق مع محرك MyISAM القديم.</p>';
$string['nativemysqli'] = 'MySQL المُحسَّن (native/mysqli)';
$string['nativemysqlihelp'] = '<p>إن قاعدة البيانات هي الموضع الذي تخزن فيه معظم إعدادات مودل وبياناته وينبغي تهيئتها هنا.</p>
<p>إن حقول: اسم قاعدة البيانات، اسم المستخدم، وكلمة المرور هي حقول إجبارية؛ بادئة الجداول هو حقل إختياري.</p>
<p>اسم قاعدة البيانات له أن يتضمن حروفاً وأرقاماً لاتينية، علامة الدولار ($)، والشُّرَط التحتانية (_).</p>
<p>إن كانت قاعدة البيانات غير موجودة حالياً، والمستخدم الذي حددته يمتلك الصلاحية، سيحاول مودل إنشاء قاعدة بيانات جديدة ذات صلاحيات وإعدادات صحيحة.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'الآن ينبغي عليك تهيئة قاعدة البيانات حيث يتم خزن معظم بيانات مودل.
قاعدة البيانات هذه ينبغي أن تكون قد تم إنشاؤها مسبقاً وبمعيتها اسم مستخدم وكلمة مرور للوصول إليها. بادئة الجداول إجبارية.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>إن قاعدة البيانات هي الموضع الذي تخزن فيه معظم إعدادات مودل وبياناته وينبغي تهيئتها هنا.</p>
<p>إن حقول: اسم قاعدة البيانات، اسم المستخدم، كلمة المرور وبادئة الجداول هي حقول إجبارية.</p>
<p>قاعدة البيانات ينبغي أن تكون موجودة سلفاً والمستخدم لديه صلاحية القراءة والكتابة فيها.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'الآن ينبغي عليك تهيئة قاعدة البيانات حيث يتم خزن معظم بيانات مودل.
قاعدة البيانات هذه ينبغي أن تكون قد تم إنشاؤها مسبقاً وبمعيتها اسم مستخدم وكلمة مرور للوصول إليها. بادئة الجداول إجبارية.';
$string['nativesqlsrvnodriver'] = 'مشغلات مايكروسوفت لمخدم SQL التي تعمل مع PHP غير منصبة أو غير مهيئة للعمل بشكل صحيح.';
$string['ociextensionisnotpresentinphp'] = 'لم يتم تعريف PHP بشكل صحيح مع امتداد OCI8 للعمل معه على الاتصال مع Oracle. لطفاً، تحقق من ملف php.ini عندك أو أعد تجميع PHP.';
$string['pass'] = 'اجتياز';
$string['paths'] = 'المسارات';
$string['pathserrcreatedataroot'] = 'مجلد البيانات ({$a->dataroot}) لا يمكن إنشاؤه من قبل برنامج التنصيب.';
$string['pathshead'] = 'تأكيد المسارات';
$string['pathsrodataroot'] = 'مجلد البيانات الرئيسي غير قابل للكتابة.';
$string['pathsroparentdataroot'] = 'المجلد ذي الرتبة الأعلى ({$a->parent}) غير قابل للكتابة. مجلد البيانات ({$a->dataroot}) لا يمكن إنشاؤه من قِبَل برنامج التنصيب.';
$string['pathssubadmindir'] = 'القليل جداً من مستضيفي الويب يستعمل /admin بمثابة رابط للوصول إلى لوحة التحكم أو ما سواها. لسوء الحظ هذا يتعارض مع الموضع القياسي لصفحات إدارة مودل. يمكنك حل هذه المشكلة عبر إعادة تسمية مجلد الإدارة admin في نسختك من هذا التنصيب، لتضع هذا الاسم الجديد هنا. مثلاً: <em>moodleadmin</em>. هذا من شأنه إصلاح روابط الإدارة في مودل.';
$string['pathssubdataroot'] = '<p>المجلد الذي يخزن فيه مودل كل المحتوى من الملفات التي يرفعها المستخدمون.</p>
<p>هذا المجلد ينبغي أن يكون قابلاً للقراءة والكتابة من قبل مستخدم مخدم الويب (عادة هو \'www-data\'، \'nobody\'، أو \'apache\').</p>
<p>ينبغي أن لا يكون متاحاً للوصول المباشر عبر الويب.</p>
<p>إن كان المجلد غير موجود حالياً، فعملية التنصيب ستحاول إنشاءه.</p>';
$string['pathssubdirroot'] = '<p>المسار الكامل للمجلد الذي يحتوي على ترميز نظام مودل.</p>';
$string['pathssubwwwroot'] = '<p>العنوان الكامل حيث سيتم الوصول به إلى مودل، بعبارة أخرى، العنوان الذي على المستخدمين إدخاله في شريط العناوين لمستعرض الإنترنت للوصول إلى مودل.</p>
<p>ليس من الممكن الوصول إلى مودل عبر عناوين متعددة. إن كان موقعك قابلاً للوصول عبر عناوين متعددة، فعليك اختيار أسهلها واستعمل إعادة توجيه دائمية من باقي العناوين إلى هذا العنوان.</p>
<p>إن كان موقعك قابلاً للوصول من شبكة الإنترنت ومن شبكتك الداخلية، الإنترانت، استعمل العنوان الخارجي على الإنترنت هنا.</p>
<p>إذا كان العنوان الحالي خاطئاً، لطفاً، غيِّر الرابط في شريط العناوين لمتصفحك ثم أعد عملية التنصيب.</p>';
$string['pathsunsecuredataroot'] = 'موضع مجلد البيانات الرئيسي غير مُؤَمن';
$string['pathswrongadmindir'] = 'مجلد المشرف غير موجود';
$string['pgsqlextensionisnotpresentinphp'] = 'لم يتم تعريف PHP بشكل صحيح مع امتداد PGSQL للعمل معه على الاتصال مع PostgreSQL. لطفاً، تحقق من ملف php.ini عندك أو أعد تجميع PHP.';
$string['phpextension'] = 'إمتداد PHP {$a}';
$string['phpversion'] = 'إصدار PHP';
$string['phpversionhelp'] = '<p>يتطلب مودل على الأقل وجود PHP بالإصدار 5.6.5 أو 7.1 (الإصدار 7.0.x فيه بعض القيود عند التشغيل).</p>
<p>انت تستعمل حالياً الإصدار {$a}.</p>
<p>يجب عليك ترقية PHP أو الانتقال إلى مستضيف آخر لديه إصدار أحدث من PHP.</p>';
$string['releasenoteslink'] = 'للحصول على معلومات بشأن هذا الإصدار من مودل، لطفاً، أنظر ملاحظات الإطلاق في {$a}';
$string['safemode'] = 'وضع الأمان';
$string['safemodeerror'] = 'من الممكن ان مودل يواجه مشاكل عندما يكون وضع الامان نشط';
$string['safemodehelp'] = '<p>قد يكون لمودل مشاكل متعددة مع نمط التشغيل الآمن، ليس أقلها أن لا يكون مسموحاً له بإنشاء ملفات جديدة.</p>

<p>نمط التشغيل الآمن عادة ما يتم تمكينه في بيئة عمل المضيفين المصابين
بالذعر، ولذلك قد يكون من الأنسب لك البحث عن مستضيف آخر لموقعك.</p>

<p>يمكنك متابعة التنصيب إن أحببت، ولكن توقع بعض المشاكل من الآن وصاعداً.</p>';
$string['sessionautostart'] = 'البدء التلقائي للجلسة';
$string['sessionautostarterror'] = 'يجب أن يكون هذا معطل';
$string['sessionautostarthelp'] = '<p> يتطلب مودل لدعم الجلسات وبدونها لا يستطع العمل.</p>
<p>.يمكن تمكين الجلسات من خلال ملف php.in ...ابحث عن session.auto_start  </p>';
$string['sqliteextensionisnotpresentinphp'] = 'لم يتم تعريف PHP بشكل صحيح مع امتداد SQLite. لطفاً، تحقق من ملف php.ini عندك أو أعد تجميع PHP.';
$string['upgradingqtypeplugin'] = 'تجري ترقية ملحق نوع سؤال';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'أنت تشاهد هذه الصفحة لأنك تمكنت بنجاح من تنصيب وإطلاق
حزمة <strong>{$a->packname} {$a->packversion}</strong> في حاسبتك. تهانينا!';
$string['welcomep30'] = 'الإطلاق العائد لـ <strong>{$a->installername}</strong> يتضمن
التطبيقات المعدة لإنشاء بيئة تسمح لـ <strong>مودل</strong> بالعمل، وهي:';
$string['welcomep40'] = 'الحزمة تتضمن أيضاً <strong>مودل {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'استعمال كل التطبيقات في هذه الحزمة محكوم برخصها. حزمة التنصيب <strong>{$a->installername}</strong> الكاملة هي <a href="https://www.opensource.org/docs/definition_plain.html">مفتوحة المصدر</a> وموزعة بموجب الرخصة <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'الصفحات الآتية ستقودك عبر خطوات سهلة التتبع لتنصيب
وتهيئة <strong>مودل</strong> في حاسبتك. يمكنك قبول
الإعدادات الافتراضية، أو إختيارياً، تغييرها بما يتناسب مع احتياجاتك الخاصة.';
$string['welcomep70'] = 'أنقر زر "التالي" أدناه لمتابعة عملية تنصيب
<strong>مودل</strong>.';
$string['wwwroot'] = 'عنوان الويب';
$string['wwwrooterror'] = 'يبدو أن \'عنوان الويب\' غير صحيح - هذا التنصيب من مودل لا يبدو أنه متواجد هناك. لقد تمت إعادة تعيين القيمة أدناه.';
