<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'cs', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Popisek asistenční technologie';
$string['acceptTerms'] = 'Přijímám <a href=":url" target="_blank">podmínky použití</a>';
$string['accountDetailsLinkText'] = 'zde';
$string['actions'] = 'Akce';
$string['add'] = 'Přidat';
$string['addedandupdatedpp'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addedandupdatedps'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizována stará {$a->%old}.';
$string['addedandupdatedsp'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addedandupdatedss'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizována stará {$a->%old}.';
$string['addednewlibraries'] = 'Přidány {$a->%new} nové knihovny H5P.';
$string['addednewlibrary'] = 'Přidána {$a->%new} nová knihovna H5P.';
$string['additionallicenseinfo'] = 'Další informace o licenci';
$string['address'] = 'Adresa';
$string['age'] = 'Typický věk';
$string['ageDescription'] = 'Cílová skupina tohoto obsahu. Možné vstupní formáty oddělené čárkami: "1,34-45,-50,59-".';
$string['altText'] = 'Alternativní text';
$string['atto_h5p'] = 'Tlačítko Vložit H5P';
$string['atto_h5p_description'] = 'Tlačítko Vložit H5P v editoru Atto umožňuje uživatelům vkládat obsah H5P buď zadáním adresy URL nebo vloženého kódu, nebo nahráním souboru H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Komentáře autora';
$string['authorcommentsdescription'] = 'Komentáře pro editora obsahu. (Tento text nebude zveřejněn jako součást informací o autorských právech.)';
$string['authorname'] = 'Jméno autora';
$string['authorrole'] = 'Role autora';
$string['back'] = 'Zpět';
$string['by'] = 'od';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Ne';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ano';
$string['cancelPublishConfirmationDialogDescription'] = 'Opravdu chcete zrušit proces sdílení?';
$string['cancelPublishConfirmationDialogTitle'] = 'Zrušit sdílení';
$string['cancellabel'] = 'Zrušit';
$string['ccattribution'] = 'Uveďte původ (CC BY)';
$string['ccattributionnc'] = 'Uveďte původ-Neužívejte komerčně (CC BY-NC)';
$string['ccattributionncnd'] = 'Uveďte původ-Neužívejte komerčně-Nezpracovávejte (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Uveďte původ-Neužívejte dílo komerčně-Zachovejte licenci (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Uveďte původ-Nezpracovávejte (CC BY-ND)';
$string['ccattributionsa'] = 'Uveďte původ-Zachovejte licenci (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changeHasBeenSubmitted'] = 'Byla odeslána změna pro';
$string['changedby'] = 'Změnil';
$string['changedescription'] = 'Popis změny';
$string['changelog'] = 'Protokol změn';
$string['changeplaceholder'] = 'Oříznutí fotografie, změněný text atd.';
$string['city'] = 'Město';
$string['close'] = 'Zavřeno';
$string['confirmdialogbody'] = 'Potvrďte, že chcete pokračovat. Tuto akci nelze vrátit zpět.';
$string['confirmdialogheader'] = 'Potvrdit akci';
$string['confirmlabel'] = 'Potvrdit';
$string['connectionLost'] = 'Připojení ztraceno. Výsledky budou uloženy a odeslány po obnovení spojení.';
$string['connectionReestablished'] = 'Připojení bylo obnoveno.';
$string['contactPerson'] = 'Kontaktní osoba';
$string['contactPersonDescription'] = 'V případě problémů s obsahem sdíleným vydavatelem se H5P obrátí na kontaktní osobu. Jméno kontaktní osoby ani jiné informace nebudou zveřejněny ani sdíleny s třetími stranami';
$string['contentAvailable'] = 'Váš obsah bude běžně dostupný v centru do jednoho pracovního dne.';
$string['contentCopied'] = 'Obsah je zkopírován do schránky';
$string['contentLicenseTitle'] = 'Informace o licenci obsahu';
$string['contentUpdateSoon'] = 'Váš obsah bude brzy aktualizován';
$string['contentchanged'] = 'Tento obsah se od posledního použití změnil.';
$string['contentinuse'] = 'Tento obsah může být používán na jiných místech.';
$string['contenttype'] = 'Typ obsahu';
$string['copyright'] = 'Práva na užívání';
$string['copyrightWarning'] = 'Materiál chráněný autorským právem nelze sdílet v H5P Content Hub. Pokud je obsah licencován s OER přátelskou licencí, jako je Creative Commons, vyberte prosím příslušnou licenci. Pokud ne, tento obsah nelze sdílet.';
$string['copyrightinfo'] = 'Informace o autorských právech';
$string['copyrightstring'] = 'Autorská práva';
$string['copyrighttitle'] = 'Zobrazit informace o autorských právech k tomuto obsahu.';
$string['couldNotParseJSONFromZip'] = 'Nelze analyzovat JSON z balíčku: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Nelze přečíst soubor z balíčku: {$a->%fileName}';
$string['country'] = 'Země';
$string['creativecommons'] = 'Creative Commons';
$string['currentStep'] = 'Krok :step z :total';
$string['date'] = 'Datum';
$string['deletelibraryconfirm'] = '<p> Opravdu chcete odstranit verzi <em> "{$a->version}" </em> z knihovny <em> "{$a->name}" </em>? Odstraní knihovnu a všechna její použití. </p> <p> Tuto operaci nelze vrátit zpět. </p>';
$string['deletelibraryversion'] = 'Odstranit verzi';
$string['deleting'] = 'Odstranění knihovny';
$string['description'] = 'Popis';
$string['disablefullscreen'] = 'Zakázat celou obrazovku';
$string['discipline:dropdownButton'] = 'Rozbalovací tlačítko';
$string['discipline:in'] = 'v';
$string['discipline:searchPlaceholder'] = 'Zadejte pro vyhledání oborů';
$string['disciplineDescription'] = 'Můžete si vybrat více oborů';
$string['disciplineLabel'] = 'Obory';
$string['disciplineLimitReachedMessage'] = 'Můžete vybrat až :numDisciplines oborů';
$string['disciplines'] = 'Disciplíny';
$string['download'] = 'Stáhnout';
$string['downloadtitle'] = 'Stáhnout tento obsah jako soubor H5P.';
$string['editInfoTitle'] = 'Upravit informace pro <strong>:nadpis</strong>';
$string['editcontent'] = 'Upravit obsah H5P';
$string['editingFailed'] = 'Úprava se nezdařila.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'Emailová adresa';
$string['emailAddressDescription'] = 'E-mailovou adresu použije H5P ke kontaktování vydavatele v případě jakýchkoli problémů s obsahem nebo v případě, že vydavatel potřebuje obnovit svůj účet. Nebude zveřejněn ani sdílen s žádnými třetími stranami';
$string['embed'] = 'Vložen';
$string['embedtitle'] = 'Zobrazit vložený kód tohoto obsahu.';
$string['error:emptycontentid'] = 'Zadaná adresa URL je nesprávná nebo tento soubor nemůžete upravit.';
$string['eventh5pdeleted'] = 'codstraněn';
$string['eventh5pviewed'] = 'Zobrazen obsah H5P';
$string['feature'] = 'Vlastnosti';
$string['fetchtypesfailure'] = 'O dostupných typech obsahu H5P nebylo možné získat žádné informace. Selhalo připojení úložiště H5P';
$string['fileExceedsMaxSize'] = 'Jeden ze souborů uvnitř balíčku přesahuje maximální povolenou velikost souboru. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Zobrazit filtr H5P';
$string['filter_displayh5p_description'] = 'Filtr zobrazení H5P převádí adresy URL na vložený obsah H5P.';
$string['fullscreen'] = 'Celá obrazovka';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'Vlastní CSS';
$string['h5pcustomcss_help'] = 'CSS, které se použije na obsah H5P.';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Soubor H5P nebyl nalezen';
$string['h5pinvalidurl'] = 'Neplatná adresa URL obsahu H5P.';
$string['h5plibraryhandler'] = 'H5P framework handler';
$string['h5plibraryhandler_help'] = 'H5P framework používaný k zobrazení obsahu H5P. Doporučuje se nejnovější verze.';
$string['h5pmanage'] = 'Spravovat typ obsahu H5P';
$string['h5poverview'] = 'Přehled H5P';
$string['h5ppackage'] = 'Typ obsahu H5P';
$string['h5ppackage_help'] = 'Typ obsahu H5P je soubor s příponou H5P nebo ZIP obsahující všechny knihovny potřebné k zobrazení obsahu.';
$string['h5pprivatefile'] = 'Tento obsah H5P nelze zobrazit, protože nemáte přístup k souboru .h5p';
$string['h5psettings'] = 'H5P nastavení';
$string['h5ptitle'] = 'Navštivte stránku h5p.org a podívejte se na další obsah.';
$string['height'] = 'výška';
$string['helpChoosingLicense'] = 'Pomozte mi vybrat licenci';
$string['hideadvanced'] = 'Skrýt pokročilé';
$string['icon'] = 'Ikona';
$string['iconDescription'] = '640 x 480 pixelů. Pokud není vybrán obsah, použije se ikona kategorie';
$string['installedcontentlibraries'] = 'Nainstalované knihovny H5P';
$string['installedcontenttypes'] = 'Nainstalované typy obsahu H5P';
$string['installedh5p'] = 'Nainstalovaný H5P';
$string['invalidAge'] = 'Neplatný vstupní formát pro Typický věk. Možné vstupní formáty oddělené čárkami: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Soubor H5P nebyl nalezen (neplatný kontext)';
$string['invalidfile'] = 'Soubor "{$a->%filename}" není povolen. Povoleny jsou pouze soubory s následujícími příponami: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Neplatný jazykový soubor {$a->%file v knihovně {$a->%library}';
$string['invalidlanguagefile2'] = 'Do knihovny {$a->%name} byl zahrnut neplatný jazykový soubor {$a->%languageFile}';
$string['invalidlibrarydata'] = 'Zadaná neplatná data pro {$a->%property} v {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Zadaná neplatná data pro {$a->%property} v {$a->%library}. Očekávané boolovská.';
$string['invalidlibraryname'] = 'Neplatný název knihovny:  {$a->%name}';
$string['invalidlibrarynamed'] = 'Knihovna H5P {$a->%library} použitá v obsahu není platná';
$string['invalidlibraryoption'] = 'Neplatná volba {$a->%option} v {$a->%library}';
$string['invalidlibraryproperty'] = 'Nelze přečíst vlastnost {$a->%property} v {$a->%library}';
$string['invalidmainjson'] = 'Chybí platný hlavní soubor h5p.json';
$string['invalidmultiselectoption'] = 'Neplatná vybraná možnost ve vícečetném výběru.';
$string['invalidpackage'] = 'Neplatný typ obsahu H5P';
$string['invalidselectoption'] = 'Neplatná vybraná možnost ve výběru.';
$string['invalidsemanticsjson'] = 'Do knihovny {$a->%name}} byl zahrnut neplatný soubor semantics.json.';
$string['invalidsemanticstype'] = 'Interní chyba H5P: neznámý typ obsahu "{$a->@type}" v sémantice. Odstraňování obsahu!';
$string['invalidstring'] = 'Zadaný řetězec není platný podle regexp v sémantice. (hodnota: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Nyní je odeslán do H5P Hub';
$string['keywordExists'] = 'Klíčové slovo již existuje!';
$string['keywords'] = 'Klíčová slova';
$string['keywordsDescription'] = 'Můžete přidat více klíčových slov oddělených čárkami. Stisknutím klávesy „Enter“ nebo „Přidat“ potvrďte klíčová slova';
$string['keywordsExits'] = 'Klíčová slova již existují!';
$string['keywordsPlaceholder'] = 'Přidat klíčová slova';
$string['language'] = 'Jazyk';
$string['level'] = 'Úroveň';
$string['librariesmanagerdescription'] = '<p> H5P umožňuje uživatelům vytvářet interaktivní obsah poskytováním řady typů obsahu. </p> <p> Chcete-li zajistit, aby se na vašem webu používaly pouze důvěryhodné typy obsahu H5P, musíte <i> buď</i></p><ul> <li> Nahrát typy obsahu H5P z h5p.org <i> nebo</i></li> <li> Povolit naplánovanou úlohu "Stáhnout dostupné typy obsahu H5P z h5p.org" </li> </ul><p> Upozorňujeme, že uživatelé budou moci používat pouze typy obsahu H5P, které jsou nainstalovány na vašem webu. </p>';
$string['librarydirectoryerror'] = 'Název adresáře knihovny se musí shodovat  machineName nebo machineName-majorVersion.minorVersion (from library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licence';
$string['licenseCC010'] = 'CC0 1.0  Univerzální (CC0 1.0) Potvrzení o statusu volného díla';
$string['licenseCC010U'] = 'CC0 1.0  Univerzální';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Mezinárodní';
$string['licenseDescription'] = 'Vybrat licenci pro svůj obsah';
$string['licenseDetails'] = 'Podrobnosti o licenci';
$string['licenseDialogDescription'] = 'Kliknutím na konkrétní licenci získáte informace o správném použití';
$string['licenseGPL'] = 'GPL - Obecná veřejná licence';
$string['licenseV1'] = 'Verze 1';
$string['licenseV2'] = 'Verze 2';
$string['licenseV3'] = 'Verze 3';
$string['licenseVersionDescription'] = 'Vybrat verzi licence';
$string['licensee'] = 'Držitel licence';
$string['licenseextras'] = 'Extra licence';
$string['licenseversion'] = 'Verze licence';
$string['lockh5pdeploy'] = 'K tomuto obsahu H5P nelze přistupovat, protože se zpracovává. Prosím zkuste to znovu později.';
$string['logoUploadText'] = 'Logo organizace nebo avatar';
$string['longDescription'] = 'Dlouhý popis';
$string['longDescriptionPlaceholder'] = 'Dlouhý popis vašeho obsahu';
$string['mainTitle'] = 'Sdílení <strong>:nadpis</strong>';
$string['mainlibrarydisabled'] = 'Tento soubor nelze zobrazit, protože jeho typ obsahu je deaktivován. Obraťte se na svého správce a požádejte o povolení typu obsahu.';
$string['maxLength'] = ':length je maximální počet znaků';
$string['missingcontentfolder'] = 'Chybí platná složka obsahu';
$string['missingcoreversion'] = 'Systém nemohl nainstalovat komponentu {$a->% component} z balíčku, protože vyžaduje novější verzi modulu H5P. Na tomto webu je aktuálně spuštěna verze {$a->%current}, zatímco požadovaná verze je {$a->%required} nebo vyšší. Upgradujte a zkuste to znovu.';
$string['missingdependency'] = 'Chybí závislost {$a->@dep} vyžadovaná z {$a->@lib}.';
$string['missinglibrary'] = 'Chybí požadovaná knihovna {$a->@library}';
$string['missinglibraryfile'] = 'V knihovně: "{$a->%name}" chybí soubor: "{$a->%file}"';
$string['missinglibraryjson'] = 'Nelze najít soubor library.json s platným formátem json pro knihovnu  {$a->%name}';
$string['missinglibraryproperty'] = 'Požadovaná vlastnost {$a->% property} chybí v {$a->% library}';
$string['missingmainlibrary'] = 'Chybí hlavní knihovna {$a->@library}';
$string['missingmbstring'] = 'Rozšíření mbstring PHP není načteno. Je nutné, aby H5P správně fungoval.';
$string['missinguploadpermissions'] = 'Knihovny mohou existovat v nahraném souboru, ale nemáte dovoleno nahrávat nové knihovny. Obraťte se na svého správce.';
$string['next'] = 'Další';
$string['nocopyright'] = 'Pro tento obsah nejsou k dispozici žádné informace o autorských právech.';
$string['noextension'] = 'Soubor, který jste nahráli, není platným balíčkem HTML5. (Nemá příponu souboru .h5p)';
$string['noh5plibhandlerdefined'] = 'Není nainstalován žádný obslužný program H5P framework, takže obsah H5P nelze zobrazit.';
$string['nojson'] = 'Hlavní soubor h5p.json není platný';
$string['nopermissiontodeploy'] = 'Tento soubor nelze zobrazit, protože byl nahrán uživatelem bez požadovaného oprávnění implementovat obsah H5P.';
$string['nopermissiontoedit'] = 'Nemáte oprávnění upravovat obsah H5P.';
$string['notrustablefile'] = 'Tento soubor nelze zobrazit, protože byl nahrán uživatelem bez oprávnění aktualizace typů obsahu H5P. Kontaktujte správce a požádejte o instalaci typu obsahu.';
$string['nounzip'] = 'Soubor, který jste nahráli, není platným balíčkem HTML5. (Nelze jej rozbalit.)';
$string['offlineDialogBody'] = 'Nepodařilo se nám odeslat informace o dokončení tohoto úkolu. Zkontrolujte připojení k internetu.';
$string['offlineDialogHeader'] = 'Vaše připojení k serveru bylo ztraceno';
$string['offlineDialogRetryButtonLabel'] = 'Zkuste to znovu';
$string['offlineDialogRetryMessage'] = 'Opakovat za :num....';
$string['offlineSuccessfulSubmit'] = 'Výsledky byly úspěšně odeslány.';
$string['optionalInfo'] = 'Nepovinné informace';
$string['originator'] = 'Původce';
$string['pd'] = 'Veřejná doména';
$string['pddl'] = 'Public Domain Dedication a licence';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefon';
$string['pleaseWait'] = 'Prosím, čekejte...';
$string['pluginname'] = 'Balíček H5P';
$string['privacy:metadata'] = 'Subsystém H5P neukládá žádná osobní data.';
$string['publisherDescription'] = 'Popis vydavatele';
$string['publisherDescriptionText'] = 'To se zobrazí v části „Informace o vydavateli“ u sdíleného obsahu';
$string['publisherFieldDescription'] = 'U sdíleného obsahu se zobrazí jako „Jméno vydavatele“.';
$string['publisherFieldTitle'] = 'Vydavatel';
$string['registerOnHub'] = 'Zaregistrovat na H5P Hub';
$string['registrationFailed'] = 'Vyskytla se chyba';
$string['registrationFailedDescription'] = 'V tuto chvíli jsme nebyli schopni vytvořit účet. Něco se pokazilo. Zkuste to později.';
$string['registrationTitle'] = 'Registrace H5P Hub';
$string['remove'] = 'Odebrat';
$string['removeChip'] = 'Odebrat :chip ze seznamu';
$string['removeImage'] = 'Odebrat obrázek';
$string['requiredInfo'] = 'Požadované informace';
$string['resizescript'] = 'Chcete-li dynamicky měnit velikost vloženého obsahu, zahrňte na svůj web tento skript:';
$string['resubmitScores'] = 'Pokus o odeslání uložených výsledků.';
$string['reuse'] = 'Opětovné použití';
$string['reuseContent'] = 'Opětovné použití obsahu';
$string['reuseDescription'] = 'Znovu použít tento obsah.';
$string['reviewAndSave'] = 'Zkontrolovat a uložit';
$string['reviewAndShare'] = 'Zkontrolovat a sdílet';
$string['reviewInfo'] = 'Informace o kontrole';
$string['reviewMessage'] = 'Před sdílením si prosím přečtěte níže uvedené informace';
$string['saveChanges'] = 'Uložit změny';
$string['screenshots'] = 'Snímky obrazovky';
$string['screenshotsDescription'] = 'Přidejte až pět snímků obrazovky svého obsahu';
$string['share'] = 'Sdílet';
$string['shareFailed'] = 'Sdílení se nezdařilo.';
$string['shareTryAgain'] = 'Něco se pokazilo, zkuste to prosím sdílet znovu.';
$string['shared'] = 'Sdíleno';
$string['sharingNote'] = 'Veškeré podrobnosti obsahu lze po sdílení upravit';
$string['shortDescription'] = 'Stručný popis';
$string['shortDescriptionPlaceholder'] = 'Krátký popis vašeho obsahu';
$string['showadvanced'] = 'Zobrazit pokročilé';
$string['showless'] = 'Zobrazit méně';
$string['showmore'] = 'Zobrazit více';
$string['size'] = 'Velikost';
$string['someKeywordsExits'] = 'Některá z těchto klíčových slov již existují';
$string['source'] = 'Zdroj';
$string['startingover'] = 'Začněte znovu.';
$string['status'] = 'Stav';
$string['subContentWarning'] = 'Dílčí obsah (obrázky, otázky atd.) bude sdílen pod licencí :licence, pokud není v nástroji pro tvorbu uvedeno jinak';
$string['sublevel'] = 'Nižší úroveň';
$string['submitted'] = 'Odesláno!';
$string['successfullyRegistred'] = 'Úspěšně jste zaregistrovali účet na H5P Hub';
$string['successfullyRegistredDescription'] = 'Údaje o vašem účtu lze změnit';
$string['successfullyUpdated'] = 'Nastavení vašeho účtu H5P Hub byla úspěšně změněna';
$string['task_h5p'] = 'Naplánovaná úloha H5P';
$string['task_h5p_description'] = 'Plánovaná úloha H5P stahuje dostupné typy obsahu H5P z webu h5p.org.';
$string['thumbnail'] = 'Náhled';
$string['title'] = 'Nadpis';
$string['undisclosed'] = 'Nezveřejněno';
$string['unpackedFilesExceedsMaxSize'] = 'Celková velikost rozbalených souborů přesahuje maximální povolenou velikost. ( ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Uložit nastavení účtu';
$string['updatedlibraries'] = 'Aktualizovány knihovny {$a->%old} H5P.';
$string['updatedlibrary'] = 'Aktualizována knihovna {$a->%old} H5P.';
$string['uploadlibraries'] = 'Nahrát typy obsahu H5P';
$string['uploadsuccess'] = 'Typy obsahu H5P byly úspěšně nahrány';
$string['width'] = 'šířka';
$string['wrongversion'] = 'Verze knihovny H5P {$a->%machineName}} použitá v tomto obsahu není platná. Obsah obsahuje {$a->%contentLibrary}, ale měl by to být {$a->%semanticsLibrary}.';
$string['year'] = 'Rok';
$string['years'] = 'Rok(y)';
$string['yearsfrom'] = 'Rok (od)';
$string['yearsto'] = 'Rok (do)';
$string['zip'] = 'Zip';
