<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'tr', version '4.3'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color_black'] = 'Siyah Tema {$a}';
$string['background_color_blue'] = 'Mavi Tema {$a}';
$string['background_color_green'] = 'Yeşil Tema {$a}';
$string['background_color_red'] = 'Kırmızı Tema {$a}';
$string['custommenuitems'] = 'Özel Üst Menü Öğeleri';
$string['custommenuitems_desc'] = 'Üst menülerin yanında özel bir menü oluşturabilirsiniz. Kök menü kenarla hizalanmalı ve alt menüler tire (-) ile öncelenmelidir. Tire sayısı öğe derinliğini belirler. Böylece, tek tireli öğeler bir önceki üst düzey öğenin alt menüsünde görünürken, iki tireli öğeler bir önceki alt menünün alt menüsünde görünür.
Her menü öğesinin içeriği, "<strong>etiket</strong> | <strong>url</strong> | <strong>açıklama</strong> | <strong>dil</strong>" olmak üzere en fazla üç öğeden oluşmalıdır ve her biri "|" karakteri ile ayrılmalıdır.
<ul>
<li><strong>etiket</strong>: Menü öğesinin içinde görüntülenecek metin budur. Her menü öğesi için bir etiket belirtmelisiniz.</li>
<li><strong>url</strong>: Kullanıcıyı tıkladığında yönlendirilecek URL\'dir. Bu isteğe bağlıdır; sağlanmazsa, öğe hiçbir yere bağlı olmaz.<br>
"target" gibi diğer özellikler URL\'nin sonuna eklenebilir.</li>
<li><strong>açıklama</strong>: URL sağlarsanız, URL ile oluşturulan bağlantı için bir açıklama da sağlayabilirsiniz. Bu isteğe bağlıdır ve tanımlanmazsa, etiket menü öğesi için açıklama olarak kullanılır.</li>
<li><strong>dil</strong>: Satırın dördüncü öğesi olarak bir dil kodu (veya virgülle ayrılmış bir dil kodu listesi) ekleyebilirsiniz. Satır, kullanıcı belirtilen dil(ler)i seçtiğinde yalnızca görüntülenir.</li>
</ul>
Aşağıda özel bir menü oluşturmanın bir örneği bulunmaktadır:
<blockquote><pre>
Kurslar
-Tüm kurslar | /kurs/
-Benim kurslarım
--Örnek Kurs
---Örnek Kurs 7 | /kurs/göster.php?id=7
---Örnek Kurs 9 | /kurs/göster.php?id=9
--Test Kursu
---Test Kursu 2 | /kurs/göster.php?id=2
---Test Kursu 5 | /kurs/göster.php?id=5
Google
-Herhangi bir dilde Google | https://google.com.tr/" target="_blank
-Meksika\'da Google | https://www.google.com.mx/" target="_blank|Google Etiketi|en
-Portekizce\'de Google | https://google.com.br/" target="_blank|Google Etiketi|pt,pt_br,pt_br_kids
Destek Sayfası | https://destek.com/" target="_blank
</pre></blockquote>
Birden fazla dil desteği ile Moodle için, <strong>etiket</strong> değeri <strong>"diladı,bileşenadı"</strong> biçiminde biçimlendirilmelidir.
<blockquote><pre>
profil,moodle | /kullanıcı/profil.php
mesajlar,mesaj | /mesaj/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/tr/Gelişmiş_tema_ayarları" target="_blank">Daha fazla menü bilgisi</a>';
$string['logo_write'] = 'Kaydırarak üst menü logosu';
$string['logo_write_desc'] = 'Lütfen logonuzu üst kısıma eklemek istiyorsanız yükleyin. Bu logo, kaydırma üstte kaldığında gösterilecek ve menü renkli bir arka plan üzerinde görüntülenecektir.';
$string['settings_theme_heading'] = 'Tema';
$string['settings_top_heading'] = 'Üst Menü';
