<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'tr', version '4.3'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acessar'] = 'Derslere Eriş';
$string['background_color'] = 'Arka Plan Rengi';
$string['background_color_black'] = 'Siyah Tema {$a}';
$string['background_color_blue'] = 'Mavi Tema {$a}';
$string['background_color_default'] = 'Varsayılan Tema {$a}';
$string['background_color_desc'] = 'Üst ve Altbilgi arka plan rengi!';
$string['background_color_green'] = 'Yeşil Tema {$a}';
$string['background_color_random'] = 'Rastgele Tema {$a}';
$string['background_color_red'] = 'Kırmızı Tema {$a}';
$string['choosereadme'] = 'Boost Magnific, Moodle\'e neşeli renkler getirmek için özenle hazırlanmış bir tema.';
$string['contact_address'] = 'Adres';
$string['contact_email'] = 'E-posta';
$string['contact_phone'] = 'Telefon Numarası';
$string['content_pagefonts'] = 'Google Ekstra Yazı Tipleri';
$string['content_pagefonts_desc'] = 'Ekstra yazı tipleri için Google\'dan @import bağlantısını buraya ekleyin.<br>Birden fazla içe aktarma yapabilirsiniz.<br><a href="https://fonts.google.com/selection/embed" target="google">Gömme kodu</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle varsayılanı';
$string['content_type_empty'] = '(İçerik Yok)';
$string['content_type_footer'] = 'Altbilgi İçeriği Türü';
$string['content_type_footer_desc'] = 'Altbilgide göstermek istediğiniz içeriğin türünü seçin.';
$string['content_type_home'] = 'Ana Sayfa İçeriği Türü';
$string['content_type_home_desc'] = 'Ana sayfada göstermek istediğiniz içeriğin türünü seçin.';
$string['content_type_html'] = 'Editör ile oluşturulacak sayfa';
$string['continuar'] = 'Çalışmaya Devam Et';
$string['countlesson'] = '{$a} ders';
$string['countlessons'] = '{$a} dersler';
$string['customcss'] = 'Özel CSS';
$string['customcss_desc'] = 'Bu metin alanına eklediğiniz herhangi bir CSS kuralı, bu temayı özelleştirmeyi kolaylaştırmak için tüm sayfalara yansıtılacaktır.';
$string['custommenuitems'] = 'Özel Üst Menü Öğeleri';
$string['custommenuitems_desc'] = 'Üst menülerin yanında özel bir menü oluşturabilirsiniz. Kök menü kenarla hizalanmalı ve alt menüler tire (-) ile öncelenmelidir. Tire sayısı öğe derinliğini belirler. Böylece, tek tireli öğeler bir önceki üst düzey öğenin alt menüsünde görünürken, iki tireli öğeler bir önceki alt menünün alt menüsünde görünür.
Her menü öğesinin içeriği, "<strong>etiket</strong> | <strong>url</strong> | <strong>açıklama</strong> | <strong>dil</strong>" olmak üzere en fazla üç öğeden oluşmalıdır ve her biri "|" karakteri ile ayrılmalıdır.
<ul>
<li><strong>etiket</strong>: Menü öğesinin içinde görüntülenecek metin budur. Her menü öğesi için bir etiket belirtmelisiniz.</li>
<li><strong>url</strong>: Kullanıcıyı tıkladığında yönlendirilecek URL\'dir. Bu isteğe bağlıdır; sağlanmazsa, öğe hiçbir yere bağlı olmaz.<br>
"target" gibi diğer özellikler URL\'nin sonuna eklenebilir.</li>
<li><strong>açıklama</strong>: URL sağlarsanız, URL ile oluşturulan bağlantı için bir açıklama da sağlayabilirsiniz. Bu isteğe bağlıdır ve tanımlanmazsa, etiket menü öğesi için açıklama olarak kullanılır.</li>
<li><strong>dil</strong>: Satırın dördüncü öğesi olarak bir dil kodu (veya virgülle ayrılmış bir dil kodu listesi) ekleyebilirsiniz. Satır, kullanıcı belirtilen dil(ler)i seçtiğinde yalnızca görüntülenir.</li>
</ul>
Aşağıda özel bir menü oluşturmanın bir örneği bulunmaktadır:
<blockquote><pre>
Kurslar
-Tüm kurslar | /kurs/
-Benim kurslarım
--Örnek Kurs
---Örnek Kurs 7 | /kurs/göster.php?id=7
---Örnek Kurs 9 | /kurs/göster.php?id=9
--Test Kursu
---Test Kursu 2 | /kurs/göster.php?id=2
---Test Kursu 5 | /kurs/göster.php?id=5
Google
-Herhangi bir dilde Google | https://google.com.tr/" target="_blank
-Meksika\'da Google | https://www.google.com.mx/" target="_blank|Google Etiketi|en
-Portekizce\'de Google | https://google.com.br/" target="_blank|Google Etiketi|pt,pt_br,pt_br_kids
Destek Sayfası | https://destek.com/" target="_blank
</pre></blockquote>
Birden fazla dil desteği ile Moodle için, <strong>etiket</strong> değeri <strong>"diladı,bileşenadı"</strong> biçiminde biçimlendirilmelidir.
<blockquote><pre>
profil,moodle | /kullanıcı/profil.php
mesajlar,mesaj | /mesaj/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/tr/Gelişmiş_tema_ayarları" target="_blank">Daha fazla menü bilgisi</a>';
$string['editor_link_footer'] = '{$a} dil için altbilgi bloğunu düzenleyin';
$string['editor_link_footer_all'] = 'Tüm diller için altbilgi bloğunu düzenleyin';
$string['editor_link_home'] = '{$a} dil için ana sayfayı düzenleyin';
$string['editor_link_home_all'] = 'Tüm diller için ana sayfayı düzenleyin';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon, tarayıcı sekmesinde sayfa başlığının yanında görüntülenir. Özel bir favicon sağlanmazsa Moodle faviconu görüntülenir.';
$string['fontfamily'] = 'Site Yazı Tipi';
$string['fontfamily_desc'] = 'Moodle\'ınızda kullanmak istediğiniz yazı tipini seçin';
$string['footer_contact_title'] = 'İletişim Blok Başlığı';
$string['footer_contact_title_default'] = 'Bize Ulaşın';
$string['footer_contact_title_desc'] = 'İletişim bilgilerinin altbilgide görüneceği bloğun başlığını girin.';
$string['footer_description'] = 'Açıklama';
$string['footer_description_desc'] = 'Moodle\'ınızı, ne yaptığınızı açıklayın ve bu bilgiler Moodle altbilgisinde logonun altında gösterilecektir.';
$string['footer_frontpage_blockcourses_instructor'] = 'Profesörün adını göster';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'İşaretlenirse, ders listesinde profesörlerin adlarını gösterir!';
$string['footer_frontpage_blockcourses_text'] = '"{$a}" bloğunu açıklayan kısa metin';
$string['footer_frontpage_blockcourses_text_desc'] = '"{$a}" hakkında konuşan bir metin ekleyin!';
$string['footer_links_title'] = 'Bağlantılar Blok Başlığı';
$string['footer_links_title_default'] = 'Önemli Bağlantılar';
$string['footer_show_copywriter'] = '❤️ ile yapıldı göster';
$string['footer_show_copywriter_desc'] = '❤️ ile yapıldıyı gizlemek istiyorsanız işareti kaldırın';
$string['footer_social_title'] = 'Sosyal Bağlantılar Blok Başlığı';
$string['footer_social_title_default'] = 'Bizi sosyal medyada takip edin';
$string['footer_social_title_desc'] = 'Sosyal ağlarınızdan gelen verilerle alt bilgiye görünecek bloğun başlığını girin.';
$string['footerblink'] = 'Alt Bilgi Blok Bağlantıları';
$string['footerblink_desc'] = 'Burada bir Alt Bilgi Blok Bağlantıları yapılandırabilirsiniz ki temalar tarafından gösterilsin.<br>Her satır, bazı menü metni veya dil anahtarı veya metin, bir bağlantı URL\'si (isteğe bağlı) ile dikey çubuklarla ayrılmıştır. Örneğin:<br><pre>Moodle Destek|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'İletişim bloğu';
$string['footerblock_copywriter'] = '❤️ ile yapıldı';
$string['footerblock_description'] = 'Açıklama bloğu';
$string['footerblock_links'] = 'Bağlantılar bloğu';
$string['footerblock_social'] = 'Sosyal blok';
$string['free_name'] = 'Ücretsiz';
$string['frontpage_about_description'] = 'Ne yaptığınızı açıklayın';
$string['frontpage_about_description_desc'] = 'Moodle\'ınızın amacını en fazla 5 satırda açıklayın';
$string['frontpage_about_enable'] = 'Hakkında bloğunu etkinleştir';
$string['frontpage_about_enable_desc'] = 'İşaretlenirse, Hakkında Bloğu, Banner\'ın altında görünecektir!';
$string['frontpage_about_info'] = 'Veri kutusu {$a}';
$string['frontpage_about_logo'] = 'Burada farklı bir logo gösterilecek';
$string['frontpage_about_logo_desc'] = 'Ayarlanırsa, burada Üst logo yerine bu logo kullanılacaktır.<br>
Boş, Üst Logo\'yu kullanır!';
$string['frontpage_about_number'] = 'Veri miktarı';
$string['frontpage_about_number_desc'] = 'Yukarıda bahsedilen bilgi miktarını girin';
$string['frontpage_about_text'] = 'Veri adı';
$string['frontpage_about_text_1_defalt'] = 'Kurslar';
$string['frontpage_about_text_2_defalt'] = 'Öğretmenler';
$string['frontpage_about_text_3_defalt'] = 'Öğrenciler';
$string['frontpage_about_text_4_defalt'] = 'Dersler';
$string['frontpage_about_text_desc'] = 'Ana sayfada gösterilecek verinin adını girin';
$string['frontpage_about_title'] = 'Hakkında bloğu başlığı';
$string['frontpage_about_title_default'] = 'Küresel Topluluğumuz';
$string['grapsjs-assetmanager-addbutton'] = 'Resim ekle';
$string['grapsjs-assetmanager-modaltitle'] = 'Resim seç';
$string['grapsjs-assetmanager-uploadtitle'] = 'Dosyaları buraya sürükleyin veya yüklemek için tıklayın';
$string['grapsjs-attachment'] = 'Ek';
$string['grapsjs-clear'] = 'Tuvali Temizle';
$string['grapsjs-confirm_clear'] = 'Tuvali temizlemek istediğinizden emin misiniz?';
$string['grapsjs-decoration'] = 'Süslemeler';
$string['grapsjs-devicemanager-device'] = 'Cihaz';
$string['grapsjs-devicemanager-devices-desktop'] = 'Masaüstü';
$string['grapsjs-devicemanager-devices-mobilelandscape'] = 'Mobil, Yatay mod';
$string['grapsjs-devicemanager-devices-mobileportrait'] = 'Mobil, Dikey mod';
$string['grapsjs-devicemanager-devices-tablet'] = 'Tablet';
$string['grapsjs-dimensions'] = 'Boyutlar';
$string['grapsjs-domcomponents-names-'] = 'Kutu';
$string['grapsjs-domcomponents-names-body'] = 'Gövde';
$string['grapsjs-domcomponents-names-cell'] = 'Tablo Hücresi';
$string['grapsjs-domcomponents-names-comment'] = 'Yorum';
$string['grapsjs-domcomponents-names-image'] = 'Resim';
$string['grapsjs-domcomponents-names-label'] = 'Etiket';
$string['grapsjs-domcomponents-names-link'] = 'Bağlantı';
$string['grapsjs-domcomponents-names-map'] = 'Harita';
$string['grapsjs-domcomponents-names-row'] = 'Tablo Satırı';
$string['grapsjs-domcomponents-names-section'] = 'Bölüm';
$string['grapsjs-domcomponents-names-table'] = 'Tablo';
$string['logo_write'] = 'Kaydırarak üst menü logosu';
$string['logo_write_desc'] = 'Lütfen logonuzu üst kısıma eklemek istiyorsanız yükleyin. Bu logo, kaydırma üstte kaldığında gösterilecek ve menü renkli bir arka plan üzerinde görüntülenecektir.';
$string['settings_theme_heading'] = 'Tema';
$string['settings_top_heading'] = 'Üst Menü';
