<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'tr', version '4.3'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'YAPILACAKLAR';
$string['activityisscheduledfordeletion'] = 'Etkinlik silme işlemi devam ediyor ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" yaş için geçerli bir değer değil.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}", birden fazla veya daha az virgül ayırıcısına sahip.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" ülke için geçerli bir değer değil.';
$string['agedigitalconsentmapinvaliddefault'] = 'Varsayılan (*) değer eksik.';
$string['agelocationverificationdisabled'] = 'Yaş ve konum doğrulaması devre dışı bırakıldı';
$string['alreadyloggedin'] = 'Zaten {$a} olarak oturum açmışsınız, farklı kullanıcı olarak giriş yapmak için önce oturumu kapatmanız gerekir.';
$string['authnotexisting'] = 'Yetkilendirme eklentisi yok';
$string['backupcontainexternal'] = 'Bu yedekleme dosyası yerel olarak yapılandırılmamış dış Moodle Ağ Ana Bilgisayarlarını içerir';
$string['backuptablefail'] = 'Yedekleme tablolarının kurulumu başarılamadı!';
$string['blockcannotconfig'] = 'Bu blokun genel yapılandırması yok';
$string['blockcannotinistantiate'] = 'Blok nesnesi başlatılırken sorun oluştu';
$string['blockcannotread'] = 'Blok kimliği={$a} verilerini okuyamadı';
$string['blockdoesnotexist'] = 'Bu blok yok';
$string['blockdoesnotexistonpage'] = 'Bu blok (id={$a->instanceid}) bu sayfada ({$a->url}) yok.';
$string['blocknameconflict'] = 'Adlandırma çelişkisi: {$a->name} bloğu varolan bir blokla aynı başlığa sahip:{$a->conflict}!';
$string['callbackrejectcomment'] = 'Eklenti bu yorumun eklenmesini reddediyor';
$string['cannotaddcoursemodule'] = 'Yeni bir kurs modülü eklenemiyor';
$string['cannotaddcoursemoduletosection'] = 'Yeni kurs modülü bu bölüme eklenemedi';
$string['cannotaddmodule'] = '{$a} modülü modül listesine eklenemedi!';
$string['cannotaddnewmodule'] = 'Yeni bir {$a} modülü eklenemedi';
$string['cannotaddrss'] = 'Rss beslemeleri ekleme izniniz yok';
$string['cannotaddthisblocktype'] = 'Bu sayfaya bir {$a} bloğu ekleyemezsiniz.';
$string['cannotassignrole'] = 'Kurstaki role atama yapılamadı';
$string['cannotassignrolehere'] = 'Bu rolü (id = {$a->roleid}) bu bağlamda ({$a->context})atamaya izniniz yok';
$string['cannotassignselfasparent'] = 'Kendini üst olarak atayamıyor!';
$string['cannotcallscript'] = 'Bu betiği bu şekilde çağıramazsınız';
$string['cannotcallusgetselecteduser'] = 'Çoklu seçme yapılırsa user_selector::get_selected_user çağrılamaz.';
$string['cannotcreatebackupdir'] = 'Yedekleme verileri dosyası oluşturulamadı. Site yöneticisi dosya izinlerini düzeltmeli';
$string['cannotcreatecategory'] = 'Kategori eklenemedi';
$string['cannotcreatedboninstall'] = '<p>Veritabanı oluşturulamıyor.</p>
<p>Belirtilen veritabanı yok ve verilen kullanıcının veritabanı oluşturmak için izni yok.</p>
<p>Site yöneticisi veritabanı yapılandırmasını doğrulamalı.</p>';
$string['cannotcreategroup'] = 'Grup oluşturulurken hata';
$string['cannotcreatelangbase'] = 'Hata: Ana dil klasörü oluşturulamadı';
$string['cannotcreatelangdir'] = 'Dil dizini oluşturulamıyor';
$string['cannotcreateorfindstructs'] = 'Bu kurs için bölüm yapılarını bulmada ya da oluşturmada hata';
$string['cannotcreatepopupwin'] = 'Tanımsız öğe';
$string['cannotcreatesitedir'] = 'Site klasörü oluşturulamadı. Site yöneticisiniz dosya izinlerini düzenlemesi gerekiyor.';
$string['cannotcreatetempdir'] = 'Geçici dizin oluşturulamıyor';
$string['cannotcreateuploaddir'] = 'Yükleme klasörü oluşturulamıyor. Site yöneticisinin dosya izinlerini düzeltmesi gerekiyor.';
$string['cannotcustomisefiltersblockuser'] = 'Filtre ayarlarını, kullanıcı veya blok bağlamında kişiselleştiremezsiniz.';
$string['cannotdeletebackupids'] = 'Geçmiş yedekleme kimlikleri silinemedi';
$string['cannotdeletecategorycourse'] = '\'{$a}\' kursu silinirken hata oluştu.';
$string['cannotdeletecategoryquestions'] = '\'{$a}\' kategorisinden sorular silinemedi';
$string['cannotdeletecourse'] = 'Bu kursu silme yetkiniz yok';
$string['cannotdeletecustomfield'] = 'Özel alan verilerini silmede hata';
$string['cannotdeletedir'] = 'Silinemedi ({$a})';
$string['cannotdeletefile'] = 'Bu dosya silinemiyor';
$string['cannotdeleterole'] = 'Silinemedi, çünkü: {$a}';
$string['cannotdeleterolewithid'] = '{$a} kimliğinin rolünü silemedi';
$string['cannotdeletethisrole'] = 'Sistem tarafından kullanıldığı ya da yönetici yeteneklerine sahip son rol olduğu için bu rolü silemezsiniz.';
$string['cannotdisableformat'] = 'Varsayılan biçimi devre dışı bırakamazsınız';
$string['cannotdownloadcomponents'] = 'Bileşenler indirilemedi';
$string['cannotdownloadlanguageupdatelist'] = 'download.moodle.org adresinden dil listesi güncellemeleri indirilemedi';
$string['cannotdownloadzipfile'] = 'ZIP dosyası indirilemedi';
$string['cannoteditcomment'] = 'Düzeltilecek bu yorum size ait değil!';
$string['cannoteditcommentexpired'] = 'Bunu düzeltemezsiniz. Zaman doldu!';
$string['cannoteditpostorblog'] = 'Blogları göndermeniz ya da düzenlemeniz mümkün değil';
$string['cannoteditsiteform'] = 'Bu formu kullanarak site dersini düzenleyemezsiniz';
$string['cannotedituserpreferences'] = 'Bu kullanıcının tercihleri düzenlenemiyor';
$string['cannotedityourprofile'] = 'Üzgünüz, kendi profilinizi düzenleyemezsiniz';
$string['cannotexecduringupgrade'] = 'Yükseltme sırasında çalıştırılamaz';
$string['cannotfindcategory'] = '{$a} kimliğiyle veritabanından kategori kaydını bulamıyor';
$string['cannotfindcomponent'] = 'Bileşen bulunamadı';
$string['cannotfindcontext'] = 'Bağlam bulunamadı';
$string['cannotfindcourse'] = 'Bu dosya bulunamıyor';
$string['cannotfinddocs'] = '"{$a}" dil dökümanı dosyalarını bulamıyor';
$string['cannotfindgradeitem'] = 'grade_item bulunamadı';
$string['cannotfindgroup'] = 'Grup bulunamadı';
$string['cannotfindhelp'] = '"{$a}" dil yardım belgeleri bulunamadı';
$string['cannotfindinfo'] = '"{$a}" ile ilgili bilgiyi bulamıyor';
$string['cannotfindlang'] = '"{$a}" dil paketi bulunamadı!';
$string['cannotfindteacher'] = 'Öğretmen bulunamadı';
$string['cannotfinduser'] = '"{$a}" adlı kullanıcıyı bulamıyor';
$string['cannotgeoplugin'] = 'https://www.geoplugin.com adresindeki geoPlugin sunucusuna bağlanılamıyor, lütfen proxy ayarlarını kontrol edin veya en iyisi MaxMind GeoLite City veri dosyasını yükleyin';
$string['cannotgetblock'] = 'Veritabanından bloklar alınamadı';
$string['cannotgetcats'] = 'Kategori kaydı alınamadı';
$string['cannotgetdata'] = 'Veri alınamadı';
$string['cannotgradeuser'] = 'Bu kullanıcıya not verilemez';
$string['cannothaveparentcate'] = 'Kurs kategorisinin bir üst kategorisi yok!';
$string['cannotimport'] = 'İça aktarma hatası';
$string['cannotimportformat'] = 'Üzgünüz, bu biçimi alma henüz uygulanmadı!';
$string['cannotimportgrade'] = 'Not içe aktarma hatası';
$string['cannotinsertgrade'] = 'Kurs kimliği olmadan not öğesi eklenemiyor!';
$string['cannotinsertrate'] = 'Yeni değerlendirme eklenemedi ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Yeni kayıt ID ({$a}) eklenemedi';
$string['cannotmailconfirm'] = 'Şifre değişim onay e-postası gönderilirken hata';
$string['cannotmanualctrack'] = 'Etkinlik el ile tamamlama izlemeyi sağlamaz';
$string['cannotmapfield'] = 'Eşleme çarpışması tespit edildi - iki alan aynı not öğesiyle {$a} eşleşiyor';
$string['cannotmarktopic'] = 'Bu kurs için bu başlık işaretlenemiyor';
$string['cannotmigratedatacomments'] = 'Veri eklentisi yorumları aktarılamıyor';
$string['cannotmodulename'] = 'Gezinmeyi oluşturmak için eklenti adı alınamıyor';
$string['cannotmoduletype'] = 'Gezinmeyi oluşturmak için eklenti tipi alınamıyor';
$string['cannotmovecategory'] = 'Kategori taşınamıyor';
$string['cannotmovecourses'] = 'Kursları, ait olduğu kategoriden başka bir kategoriye taşıyamazsınız.';
$string['cannotmoverolewithid'] = '{$a} kimliğiyle rol taşınamıyor';
$string['cannotopencsv'] = 'CSV dosyası açılamadı';
$string['cannotopenfile'] = 'Dosya ({$a}) açılamadı';
$string['cannotopenforwrit'] = 'Yazılmak için açılamadı: {$a}';
$string['cannotopentemplate'] = 'Şablon dosya açılamadı ({$a})';
$string['cannotopenzip'] = 'Muhtemelen 64-bit işletim sistemindeki bir zip uzantısı hatası nedeniyle zip dosyası açılamıyor.';
$string['cannotoverridebaserole'] = 'Temel rol yetenekleri geçersiz kılınamıyor';
$string['cannotoverriderolehere'] = 'Bu rolü (id = {$a->roleid}) bu bağlamda ({$a->context}) geçersiz kılma izniniz yok';
$string['cannotreadfile'] = 'Dosya okunamadı ({$a})';
$string['cannotreadtmpfile'] = 'Geçici dosyayı okurken hata';
$string['cannotreaduploadfile'] = 'Yüklenen dosya okunamadı';
$string['cannotremovefrommeta'] = 'Seçilen kurs bu meta kurstan kaldırılamadı!';
$string['cannotreprocessgrades'] = 'Bu etkinlik için notları yeniden işleme koyamadı {$a}';
$string['cannotresetguestpwd'] = 'Konuk şifresini ayarlayamazsınız';
$string['cannotresetmail'] = 'Şifreyi yenilerken ve size gönderirken hata oluştu';
$string['cannotresetthisrole'] = 'Bu rol yeniden ayarlanamıyor';
$string['cannotrestore'] = 'Bir hata oluştu ve geri yükleme tamamlanamadı';
$string['cannotrestoreadminorcreator'] = 'Yeni kursa geri yüklemek için oluşturucu ya da yönetici kullanıcı olmanız gerekir!';
$string['cannotrestoreadminoredit'] = 'Yeni kursa geri yüklemek için içerik oluşturucu veya yönetici rölünde bir kullanıcı olmanız gerekir!';
$string['cannotsaveagreement'] = 'Sözleşmeniz kaydedilemedi';
$string['cannotsaveblock'] = 'Blok yapılandırmasını kaydederken hata';
$string['cannotsavecomment'] = 'Yorumu kaydederken hata';
$string['cannotsavedata'] = 'Veri kaydedilemedi';
$string['cannotsavefile'] = '"{$a}" dosyası kaydedilemedi!';
$string['cannotsavemd5file'] = 'md5 dosyası kaydedilemedi';
$string['cannotsavezipfile'] = 'ZIP dosyası kaydedilemedi';
$string['cannotservefile'] = 'Sunucu yapılandırma sorunu nedeniyle dosya sunulamıyor.';
$string['cannotsetparentforcatoritem'] = 'Kategori veya kurs ögesi için ana kategori ayarlanımıyor!';
$string['cannotsetpassword'] = 'Kullanıcı şifresi ayarlanamadı!';
$string['cannotsetprefgrade'] = 'Bu sınıf kategorisi için {$a} için tercih toplama görüntüsü ayarlanamadı.';
$string['cannotsettheme'] = 'Tema ayarlanamadı!';
$string['cannotsetupblock'] = 'Blok tabloları doğru bir şekilde AYARLANAMADI!';
$string['cannotsetupcapformod'] = '{$a} için izinler ayarlanamadı';
$string['cannotsetupcapforplugin'] = '{$a} için izinler ayarlanamadı';
$string['cannotshowhidecoursesincategory'] = '{$a} kategorisindeki kurslar gösterilemiyor/gizlenemiyor.';
$string['cannotsignup'] = '{$a} olarak önceden oturum açtığınız için yeni bir hesap oluşturamazsınız.';
$string['cannotswitcheditmodeon'] = 'Düzenleme modu açılamadı';
$string['cannotunassigncap'] = 'Geçersiz kılınmış {$a->cap} yeteneğinin {$a->role} rolünden ataması kaldırılamadı';
$string['cannotunassignrolefrom'] = 'Bu kullanıcının {$a} rol kimliğinden ataması kaldırılamıyor';
$string['cannotunzipfile'] = 'Dosya arşivi açılamadı';
$string['cannotupdatemod'] = '{$a} güncellenemedi';
$string['cannotupdatepasswordonextauth'] = 'Dış auth: {$a} üzerinde parola güncellemesi başarılamadı. Daha fazla ayrıntı için sunucu girişlerine bakınız.';
$string['cannotupdateprofile'] = 'Kullanıcı kaydını güncellerken hata';
$string['cannotupdaterecord'] = '{$a} nolu kayıt güncellenemedi';
$string['cannotupdaterss'] = 'Haber içeriği güncellenemedi';
$string['cannotupdatesubcourse'] = 'Bir alt kurs güncellenemedi!';
$string['cannotupdateusermsgpref'] = 'Kullanıcı mesaj tercihleri güncellenemiyor';
$string['cannotupdateuseronexauth'] = 'Dış auth: {$a} üzerindeki kullanıcı verileri güncellenemedi. Daha fazla ayrıntı için sunucu günlüklerine bakınız.';
$string['cannotuploadfile'] = 'Yükleme dosyasını yürütmede hata';
$string['cannotuseadmin'] = 'Bu sayfayı kullanmak için yönetici kullanıcı olmanız gerekli';
$string['cannotuseadminadminorteacher'] = 'Bu sayfayı kullanmak için eğitmen ya da yönetici kullanıcı olmanız gerekir';
$string['cannotusepage'] = 'Yalnızca eğitmenler ve yöneticiler bu sayfayı kullanabilir';
$string['cannotusepage2'] = 'Özür dileriz, bu sayfayı kullanamazsınız';
$string['cannotviewcategory'] = 'Bu kurs listesini görüntüleme izniniz yok.';
$string['cannotviewprofile'] = 'Bu kullanıcının profilini görüntüleyemezsiniz.';
$string['cannotviewreport'] = 'Bu raporu görüntüleyemezsiniz';
$string['cannotwritefile'] = '({$a}) dosyasına yazılamıyor';
$string['categoryerror'] = 'Kategori hatası';
$string['categoryidnumbertaken'] = 'ID numarası başka bir kategoride kullanılmış';
$string['categorynamerequired'] = 'Kategori adı gerekli';
$string['categorytoolong'] = 'Kategori adı çok uzun';
$string['commentmisconf'] = 'Açıklama kimliği eksik yapılandırılmış';
$string['componentisuptodate'] = 'Bileşen güncel';
$string['confirmationnotenabled'] = 'Bu sitede kullanıcı onayı etkin değil';
$string['confirmsesskeybad'] = 'Üzgünüz, oturum anahtarınız bu eylemi gerçekleştirmek için onaylanamadı. Bu güvenlik özelliği, sizin adınıza yapılacak olan önemli işlevlerin yanlışlıkla ya da kasten kullanılmasını engellemek içindir. Lütfen bu işlevi gerçekten yapmak istediğinizden emin olun.';
$string['contenttypenotfound'] = '\'{$a}\' içerik bankası türü mevcut değil veya tanınmadı.';
$string['contentvisibilitynotfound'] = '\'{$a}\' değerine sahip içerik görünürlüğü mevcut değil veya tanınmadı.';
$string['couldnotassignrole'] = 'Size rol atanmaya çalışılırken ciddi ama belirlenemeyen bir hata oluştu';
$string['couldnotupdatenoexistinguser'] = 'Kullanıcı güncellenemiyor - kullanıcı mevcut değil';
$string['couldnotverifyagedigitalconsent'] = 'Dijital rıza yaşını doğrulamaya çalışırken bir hata oluştu.<br />Lütfen yöneticiyle iletişime geçin.';
$string['countriesphpempty'] = 'Hata: {$a} dil paketindeki countries.php dosyası boş veya eksik.';
$string['coursedoesnotbelongtocategory'] = 'Kurs, bu kategoriye ait değil';
$string['courseformatnotfound'] = '\'{$a}\' kurs biçimi yok veya tanınmıyor';
$string['coursegroupunknown'] = 'Grup {$a} ile ilgili kurs belirtilmemiş';
$string['courseidnotfound'] = 'Kurs kimliği mevcut değil';
$string['courseidnumbertaken'] = 'ID numarası başka bir kurs için kullanılıyor ({$a})';
$string['coursemisconf'] = 'Kurs yanlış yapılandırılmış';
$string['courserequestdisabled'] = 'Üzgünüz, kurs istekleri yönetici tarafından devre dışı bırakıldı.';
$string['csvcolumnduplicates'] = 'Yinelenen sütun tespit edildi';
$string['csvemptyfile'] = 'CSV dosyası boş';
$string['csvfewcolumns'] = 'Yeterli sütun yok, lütfen ayraç ayarını doğrulayın';
$string['csvfileerror'] = 'CSV dosyasının biçiminde bir sorun var. Lütfen başlık ve sütun sayısının eşleştiğini ve ayırıcı ile dosya kodlamasının doğru olduğunu kontrol edin. {$a}';
$string['csvinvalidcols'] = '<b>Geçersiz CSV dosyası:</b> İlk satır "Başlık Alanları"nı içermeli ve dosya türü <br />"Genişletilmiş Alanlar/Virgülle Ayrılmış"<br />ya da <br /> "CAVV Sonuç Kodu ile Genişletilmiş Alanlar/Virgülle Ayrılmış" olmalı';
$string['csvinvalidcolsnum'] = 'Geçersiz CSV dosyası - her satır 49 ya da 70 alan içermeli';
$string['csvloaderror'] = '{$a} CSV dosyasını yüklerken hata oluştu';
$string['csvnodata'] = 'Geçersiz CSV dosyası - CSV dosyasında başlıklar var ancak herhangi bir veri içermiyor.';
$string['csvweirdcolumns'] = 'Hatalı CSV dosyası biçimi - sütun sayısı sabit değil!';
$string['dbconnectionfailed'] = '<p>Hata: Veritabanı bağlantısı başarısız oldu</p>
<p>Veritabanı aşırı yüklü ya da düzgün çalışmıyor olabilir.</p>
<p>Site yöneticisi veritabanı bilgilerinin config.php dosyasında doğru belirtilip belirtilmediğini kontrol etmelidir.</p>{$a}';
$string['dbdriverproblem'] = '<p>Hata: veritabanı sürücü problemi tespit edildi</p>
<p>Site yöneticisi sunucu yapılandırmasını doğrulamalı</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Ciddi veritabanı oturum problemi tespit edildi.<br /><br />Lütfen sunucu yöneticisine haber verin.';
$string['dbsessionhandlerproblem'] = 'Veritabanı oturumu ayarlanamadı. Lütfen sunucu yöneticisine haber verin.';
$string['dbsessionmysqlpacketsize'] = 'Ciddi oturum problemi tespit edildi. Lütfen yöneticiye haber verin, bu problem büyük olasılıkla  max_allowed_packet MySQL ayarının küçük değerli olmasından kaynaklanıyor.';
$string['dbupdatefailed'] = 'Veritabanı güncelleme başarısız oldu';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" değiştirilemiyor.{$a->offendingtype} "{$a->offendingname}" ile bağımlılık bulundu';
$string['ddlexecuteerror'] = 'DDL sql yürütme hatası';
$string['ddlfieldalreadyexists'] = '{$a}" alanı zaten var';
$string['ddlfieldnotexist'] = '"{$a->fieldname} alanı "{$a->tablename}" tablosunda yer almıyor';
$string['ddltablealreadyexists'] = '{$a}" tablosu zaten var';
$string['ddltablenotexist'] = '"{$a}" tablosu yok';
$string['ddlunknownerror'] = 'Bilinmeyen DDL kütüphane hatası';
$string['ddlxmlfileerror'] = 'XML veritabanı dosya hataları bulundu';
$string['ddsequenceerror'] = 'Yanlış tablo "{$a}" tanımı; sadece bir otomatik sütun olabilir ve anahtar olarak tanımlanmalıdır.';
$string['destinationcmnotexit'] = 'Hedef kurs modülü yok';
$string['detectedbrokenplugin'] = '"{$a}" eklentisi hatalı veya eski, devam edilemiyor, üzgünüz.';
$string['dmlexceptiononinstall'] = '<p>Bir veritabanı hatası oluştu [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'SQL sorgusu ayrıştırılırken hata oluştu';
$string['dmlreadexception'] = 'Veritabanından okumada hata';
$string['dmltransactionexception'] = 'Veritabanı işlem hatası';
$string['dmlwriteexception'] = 'Veritabanına yazmada hata';
$string['dndmaxbytes'] = 'Dosya çok büyük.  İzin verilen maksimum boyut {$a->size}\'dir.';
$string['dndread'] = 'Dosya okunurken hata oluştu';
$string['dndunkownfile'] = 'Bu dosya türü desteklenmiyor';
$string['dndupload'] = 'Dosya yüklenirken bilinmeyen bir hata oluştu';
$string['downgradedcore'] = 'HATA!!! Kullandığınız kod, bu veritabanını oluşturan kodun sürümünden daha ESKİ!';
$string['downloadedfilecheckfailed'] = 'İndirilen dosya kontrolü hatası';
$string['duplicatefieldname'] = 'Yinelenen alan adı "{$a}" tespit edildi';
$string['duplicatenosupport'] = '\'{$a->modname}\' etkinliği çoğaltılamadı çünkü {$a->modtype} modülünün yedekleme ve geri yükleme desteği yok.';
$string['duplicateparaminsql'] = 'HATA: sorguda tekrarlanan parametre adı';
$string['duplicaterolename'] = 'Bu adlı başka bir rol zaten var!';
$string['duplicateroleshortname'] = 'Bu kısa adlı başka bir rol zaten var!';
$string['duplicateusername'] = 'Yinelenen kullanıcı adı - kayıt atlanıyor';
$string['editedpagenotfound'] = 'Sistem bulunduğunuz sayfayı belirleyemedi. Lütfen sayfayı yenileyin ve tekrar deneyin.';
$string['emailfail'] = 'E-posta gönderirken hata';
$string['encryption_decryptfailed'] = 'Çözümleme başarısız oldu';
$string['encryption_encryptfailed'] = 'Şifreleme başarısız oldu';
$string['encryption_invalidkey'] = 'Geçersiz anahtar';
$string['encryption_keyalreadyexists'] = 'Anahtar zaten var';
$string['encryption_nokey'] = 'Anahtar bulunamadı';
$string['encryption_wrongmethod'] = 'Veriler, desteklenen bir şifreleme yöntemiyle eşleşmiyor';
$string['enddatebeforestartdate'] = 'Kursun bitiş tarihi başlangıç tarihinden sonra olmalıdır.';
$string['error'] = 'Hata oluştu';
$string['error_question_answers_missing_in_db'] = 'Question_answers veritabanı tablosunda "{$a->answer}" ile eşleşen bir cevap bulunamadı. Bu, veritabanında {$a->dbquestionid} kimliğine sahip mevcut soruyla eşleşen {$a->filequestionid} kimliği olan sorunun yedek dosyasında geri yüklenmesi sırasında oluştu.';
$string['errorcleaningdirectory'] = '"{$a}" dizinini temizlerken hata oluştu';
$string['errorcopyingfiles'] = 'Dosyaları kopyalarken hata oluştu';
$string['errorcreatingdirectory'] = '"{$a}" dizinini oluştururken hata oluştu';
$string['errorcreatingfile'] = '"{$a}" dosyasını oluştururken hata oluştu';
$string['errorcreatingrole'] = 'Rolü oluştururken';
$string['errorfetchingrssfeed'] = 'RSS akışı alınırken hata';
$string['erroronline'] = '{$a}. satırda hata var';
$string['erroroutput'] = 'Hata çıktısı, bu nedenle otomatik yönlendirme devre dışı bırakılıyor.';
$string['errorparsingxml'] = 'Hata ayrıştırma XML: {$a->errorstring} satır {$a->errorline}, karakter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Arşiv dosyası işlenirken hata oluştu';
$string['errorreadingfile'] = '"{$a}" dosyasını okurken hata oluştu';
$string['errorsavingrequest'] = 'İsteğinizi kaydetmeye çalışırken hata oluştu.';
$string['errorsettinguserpref'] = 'Kullanıcı tercihini kaydederken hata';
$string['errorunzippingfiles'] = 'Zipli dosyaları açarken hata oluştu';
$string['expiredkey'] = 'Süresi dolmuş anahtar';
$string['externalauthpassworderror'] = 'Harici kimlik doğrulama için boş olmayan şifre';
$string['externalfilenolocation'] = 'Harici dosyanın konum yolu yok';
$string['failtoloadblocks'] = 'Bir ya da daha fazla blok veritabanına kayıtlı, ama hiçbiri yüklenemedi!';
$string['fieldrequired'] = '"{$a}" doldurulması gerekli bir alandır';
$string['fileexists'] = 'Dosya mevcut';
$string['filemismatch'] = 'Çekirdek olmayan dosya adı uyuşmazlığı. "{$a->current}" dosyası {$a->file} olmalıdır';
$string['filenotfound'] = 'Üzgünüz, aranan dosya bulunamadı';
$string['filenotreadable'] = 'Dosya okunabilir değil';
$string['filterdoesnothavelocalconfig'] = '{$a} filtresi yerel yapılandırmaya izin vermiyor.';
$string['filternotactive'] = '{$a} filtresi şu anda etkin değil';
$string['filternotenabled'] = 'Filtre etkinleştirilmedi!';
$string['filternotinstalled'] = '{$a} filtresi şu anda kurulu değil';
$string['forumblockingtoomanyposts'] = 'Bu forum için belirlenen ileti gönderme eşiğini aştınız';
$string['functionalityremoved'] = 'Kaldırılmış bir işleve erişmeye çalışıyorsunuz.';
$string['generalexceptionmessage'] = 'Hata - {$a}';
$string['gradecantregrade'] = 'Not hesaplanırken bir hata oluştu: {$a}';
$string['gradepubdisable'] = 'Not yayınlanması geçersiz kılındı';
$string['gradesneedregrading'] = 'Kurs notlarının yeniden hesaplanması gerekiyor';
$string['groupalready'] = 'Kullanıcı {$a} grubuna zaten kayıtlı';
$string['groupexistforcourse'] = '"{$a}" grubu bu kursta zaten var';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Bu kurs için "{$a->idnumber}" ID numaralı "{$a->name}" Grubu zaten var';
$string['grouphasidnumber'] = '"{$a}" grubu bir ID numarasına sahip ve ek bir sistem tarafından otomatik olarak oluşturulmuş olabilir. Bu grubu silmeye yetkiniz yok.';
$string['groupinghasidnumber'] = '"{$a}" gruplaması bir ID numarasına sahip ve ek bir sistem tarafından otomatik olarak oluşturulmuş olabilir. Bu grubu silmeye yetkiniz yok.';
$string['groupingnotaddederror'] = '"{$a}" gruplama eklenmedi';
$string['groupnotaddederror'] = '"{$a}" grubu eklenmedi';
$string['groupnotaddedtogroupingerror'] = '"{$a->groupname}" grubu "{$a->groupingname}" gruplamaya eklenemedi';
$string['groupunknown'] = '{$a} grubu belirtilen kursla ilişkili değil';
$string['groupusernotmember'] = 'Kullanıcı, bu grubun üyesi değil.';
$string['guestcantaccessprofiles'] = 'Misafirler kullanıcı profillerine erişemez. Devam etmek için tam kullanıcı hesabı ile giriş yapın.';
$string['guestnocomment'] = 'Konukların mesajları yorumlamasına izin verilmez!';
$string['guestnoeditprofile'] = 'Konuk kullanıcı kendi profilini düzenleyemez';
$string['guestnoeditprofileother'] = 'Konuk kullanıcının profili düzenlenemez';
$string['guestnorate'] = 'Misafirlerin kaytıları puanlamasına izin ver';
$string['guestsarenotallowed'] = 'Konuk kullanıcının bunu yapmaya izni yok';
$string['hackdetected'] = 'Hack saldırısı tespit edildi!';
$string['hashpoolproblem'] = 'Yanlış havuz dosyası içeriği {$a}.';
$string['headersent'] = 'Başlıklar zaten gönderilmiş';
$string['idnumbertaken'] = 'ID numarası zaten kullanımda';
$string['idnumbertoolong'] = 'ID numarası çok uzun';
$string['importformatnotimplement'] = 'Üzgünüz, bu formatın içe aktarılması henüz gerçekleştirilmedi!';
$string['incorrectext'] = 'Dosya uzantısı hatalı';
$string['inplaceeditableerror'] = 'Güncelleme işlemcisi çağırılırken hata oluştu';
$string['installproblem'] = 'yükleme sırasında gerçekleşen hataları kurtarmak çoğunlukla mümkün değildir. Yüklemeyi yeniden denemek isterseniz, yeni bir veritabanı oluşturmanız ya da yeni bir ön ek kullanmanız gerekebilir.';
$string['internalauthpassworderror'] = 'Dahili kimlik doğrulama için eksik şifre veya geçersiz şifre ilkesi';
$string['invalidaccess'] = 'Bu sayfaya doğru bir şekilde erişilmedi';
$string['invalidaccessparameter'] = 'Geçersiz erişim parametresi';
$string['invalidaction'] = 'Geçersiz eylem parametresi';
$string['invalidactivityid'] = 'Geçersiz etkinlik kimliği';
$string['invalidadminsettingname'] = 'Geçersiz yönetici ayarı ({$a})';
$string['invalidargorconf'] = 'Geçerli hiçbir argüman sağlanamadı ya da yanlış sunucu yapılandırması';
$string['invalidarguments'] = 'Hiç bağımsız değişken sağlanamadı';
$string['invalidblockinstance'] = '{$a} için geçersiz blok örneği';
$string['invalidbulkenrolop'] = 'Geçersiz toplu kayıt işlemi talep edildi.';
$string['invalidcategory'] = 'Geçersiz kategori!';
$string['invalidcategoryid'] = 'Geçersiz kategori kimliği!';
$string['invalidcomment'] = 'Yorum geçersiz';
$string['invalidcommentarea'] = 'Geçersiz yorum alanı';
$string['invalidcommentid'] = 'Geçersiz yorum kimliği';
$string['invalidcommentitemid'] = 'Geçersiz yorum ögesi kimliği';
$string['invalidcommentparam'] = 'Geçersiz yorum parametreleri';
$string['invalidcomponent'] = 'Geçersiz bileşen adı';
$string['invalidconfirmdata'] = 'Geçersiz onay verisi';
$string['invalidcontentid'] = 'Geçersiz içerik kimliği';
$string['invalidcontext'] = 'Geçersiz içerik';
$string['invalidcountrycode'] = 'Geçersiz ülke kodu: {$a}';
$string['invalidcourse'] = 'Geçersiz kurs';
$string['invalidcourseformat'] = 'Geçersiz kurs biçimi';
$string['invalidcourseid'] = 'Geçersiz bir kursun kimlik bilgisini kullanmaya çalışıyorsunuz';
$string['invalidcourselevel'] = 'Geçersiz bağlam seviyesi';
$string['invalidcoursemodule'] = 'Geçersiz kurs eklentisi ID';
$string['invalidcoursemoduleid'] = 'Geçersiz kurs modülü kimliği: {$a}';
$string['invalidcoursenameshort'] = 'Geçersiz kurs kısa adı';
$string['invaliddata'] = 'Gönderilen veri geçersiz';
$string['invaliddatarootpermissions'] = 'Klasör oluşturulurken hatalı izinler bulundu. Daha fazla ayrıntı için hata denetim modunu açın.';
$string['invaliddevicetype'] = 'Geçersiz aygıt türü';
$string['invalidelementid'] = 'Geçersiz öğe kimliği!';
$string['invalidentry'] = 'Bu geçerli bir girdi değil!';
$string['invalidevent'] = 'Geçersiz olay';
$string['invalidfieldname'] = '"{$a}" geçerli bir alan adı değil';
$string['invalidfiletype'] = '"{$a}" geçerli bir dosya tipi değil';
$string['invalidformatpara'] = 'Seçilen parametre için geçersiz biçim';
$string['invalidformdata'] = 'Yanlış form verileri';
$string['invalidfunction'] = 'Yanlış işlev';
$string['invalidgradeitemid'] = 'Yanlış not öğesi kimliği';
$string['invalidgroupid'] = 'Yanlış grup kimliği belirtildi';
$string['invalidipformat'] = 'Geçersiz IP adresi biçimi';
$string['invaliditemid'] = 'Yanlış öğe kimliği';
$string['invalidkey'] = 'Geçersiz anahtar';
$string['invalidlanguagecode'] = 'Geçersiz dil kodu: {$a}';
$string['invalidlegacy'] = '{$a} tipi için yanlış devralınan rol tanımı';
$string['invalidmd5'] = 'Kontrol değişkeni yanlış - yeniden deneyin';
$string['invalidmode'] = 'Geçersiz mod ({$a})';
$string['invalidmodule'] = 'Geçersiz modül';
$string['invalidmoduleid'] = 'Geçersiz modül kimliği: {$a}';
$string['invalidmodulename'] = 'Geçersiz modül adı: {$a}';
$string['invalidnum'] = 'Geçersiz sayısal değer';
$string['invalidnumkey'] = '$conditions dizisi sayısal anahtarlar içermeyebilir, lütfen kodu düzeltin!';
$string['invalidoutcome'] = 'Yanlış kazanım kimliği';
$string['invalidpagesize'] = 'Geçersiz sayfa boyutu';
$string['invalidpasswordpolicy'] = 'Geçersiz şifre ilkesi';
$string['invalidpaymentmethod'] = 'Geçersiz ödeme metodu: {$a}';
$string['invalidpersistenterror'] = 'Hata: {$a}';
$string['invalidqueryparam'] = 'HATA: Sorgu parametrelerinin sayısı yanlış. {$a->expected} beklenirken, {$a->actual} alındı.';
$string['invalidratingarea'] = 'Geçersiz değerlendirme alanı';
$string['invalidrecord'] = '{$a} veritabanı tablosunda veri kaydı bulunamıyor.';
$string['invalidrecordunknown'] = 'Veritabanında veri kaydı bulunamıyor.';
$string['invalidrequest'] = 'Geçersiz istek';
$string['invalidrole'] = 'Geçersiz rol';
$string['invalidroleid'] = 'Geçersiz rol kimliği';
$string['invalidscaleid'] = 'Geçersiz ölçek kimliği';
$string['invalidsection'] = 'Kurs modülü kaydı geçersiz bölüm içeriyor';
$string['invalidsesskey'] = 'Oturumunuzun süresi doldu. Lütfen tekrar giriş yapınız.';
$string['invalidshortname'] = 'Bu geçersiz kurs kısa adı';
$string['invalidsourcefield'] = 'Taslak dosyasının kaynak alanı geçersiz';
$string['invalidstatedetected'] = 'Bir şeyler doğru gitmiyor: {$a}. Bunun normalde hiç olmaması gerekirdi.';
$string['invalidurl'] = 'Geçersiz URL';
$string['invaliduser'] = 'Geçersiz kullanıcı';
$string['invaliduserdata'] = 'Geçersiz kullanıcı verileri: {$a}';
$string['invaliduserfield'] = 'Geçersiz kullanıcı alanı: {$a}';
$string['invaliduserid'] = 'Geçersiz kullanıcı kimliği';
$string['invalidusername'] = 'Verilen kullanıcı adı geçersiz karakterler içeriyor';
$string['invalidusernameblank'] = 'kullanıcı adı boş olamaz';
$string['invalidxmlfile'] = '"{$a}" geçerli bir XML dosyası değil';
$string['iplookupfailed'] = 'Bu IP adresi için yer bilgisi bulunamıyor: ???';
$string['iplookupprivate'] = 'Özel IP adresleri için arama bilgisi gösterilemez';
$string['ipmismatch'] = 'İstemci IP adresinin yanlış eşleşmesi';
$string['listcantmovedown'] = 'Benzerlerinin sonuncusu olduğu için öğe aşağı taşınamadı.';
$string['listcantmoveleft'] = 'Öge sola taşınamadı, bir üst ögesi yok';
$string['listcantmoveright'] = 'Öge sağa taşınamadı çünkü alt ögesi olabileceği öge yok. Başka bir ögenin altına taşıyın, sonra sağa taşıyabilirsiniz.';
$string['listcantmoveup'] = 'Benzerlerinin ilki olduğu için öğe yukarı taşınamadı.';
$string['listnochildren'] = 'Ögeye ait alt öge yok';
$string['listnoitem'] = 'Öge bulunamadı';
$string['listnopeers'] = 'Öğe eşleri bulunamadı';
$string['listupdatefail'] = 'Liste hiyerarşisi düzenlenirken veritabanı hatası oluştu';
$string['logfilenotavailable'] = 'Günlükler erişilebilir değil';
$string['loginasnoenrol'] = 'Bir derste "Farklı giriş" oturumundayken derse kayıt olamaz veya ders kaydını silemezsiniz.';
$string['loginasonecourse'] = 'Bu kursa giremezsiniz.<br />Başka bir kursa girmeden önce "Farklı giriş" oturumunu sonlandırmanız gerekir.';
$string['maxareabytes'] = 'Bu dosya bu alanda kalan boş yerden daha büyük';
$string['maxbytesfile'] = '{$a->file} dosyasının boyutu çok büyük. En fazla {$a->size} MB büyüklüğünde dosya yükleyebilirsiniz.';
$string['maxdraftitemids'] = 'Çok sayıda dosya yükledikten sonra dosya yüklemeleriniz geçici olarak sınırlandırılır. Lütfen bekleyin ve yeniden deneyin.';
$string['messageundeliveredbynotificationsettings'] = 'Kullanıcılar arasındaki kişisel iletiler (Bildirim ayarlarında) bir site yöneticisi tarafından devre dışı bırakıldığı için mesaj gönderilemedi.';
$string['messagingdisable'] = 'Bu sitede mesajlaşma geçersiz kılındı';
$string['mimetexisnotexist'] = 'Sisteminiz mimeTeX\'i çalıştıracak şekilde yapılandırılmadı. C kaynağını <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> adresinden temin etmeniz, derlemeniz ve çalıştırılabilir dosyayı moodle/filter/tex/ dizininize atın.';
$string['mimetexnotexecutable'] = 'ÖZel mimetex yürütülemiyor!';
$string['missing_moodle_backup_xml_file'] = 'Yedekleme XML dosyası eksik: {$a}';
$string['missingcategoryrole'] = 'Kullanıcıya rol atanamadı: kategori için eksik rol.';
$string['missingfield'] = '"{$a}" alanı eksik';
$string['missingkeyinsql'] = 'HATA: sorgulamada eksik "{$a}" parametresi';
$string['missingparam'] = 'Gerekli bir ({$a}) parametresi eksikti';
$string['missingparameter'] = 'Eksik parametre';
$string['missingrequiredfield'] = 'Gerekli alanlardan bazıları eksik';
$string['missinguseranditemid'] = 'Eksik kullanıcı ve öğe kimliği';
$string['missingvarname'] = 'Gerekli değişken adı eksik!';
$string['mixedtypesqlparam'] = 'HATA: Karışık tiplerde sql sorgulama parametreleri';
$string['mnetdisable'] = 'MNET devre dışı bırakıldı';
$string['mnetlocal'] = 'Uzak MNET kullanıcıları yerel oturum açamaz';
$string['moduledisable'] = 'Bu ({$a}) modülü bu kurs için geçersiz kılındı';
$string['moduledoesnotexist'] = 'Bu modül mevcut değil';
$string['moduleinstancedoesnotexist'] = 'Bu modülün örneği mevcut değil';
$string['modulemissingcode'] = 'Bu eylemi gerçekleştirecek gerekli kod {$a} modülü için eksik';
$string['moodlenet:invalidshareformat'] = 'Hatasız MoodleNet paylaşım biçimi';
$string['moodlenet:invalidsharestatus'] = 'Hatalı MoodleNet paylaşımı durumu';
$string['moodlenet:invalidsharetype'] = 'Geçersiz MoodleNet paylaşımı türü';
$string['moodlenet:usernotconfigured'] = 'MoodleNet\'te içerik paylaşma izniniz yok veya hesabınız yanlış yapılandırılmış.';
$string['movecatcontentstoroot'] = 'Kategori içeriğinin kök dizine taşınmasına izin verilmez. İçeriği mevcut kategoriye taşımanız gerekir!';
$string['movecatcontentstoselected'] = 'Bazı kategori içerikleri seçilen kategoriye taşınamaz.';
$string['movecategorynotpossible'] = '\'{$a}\' kategorisini seçili kategoriye taşıyamazsınız.';
$string['movecategoryownparent'] = '\'{$a}\' kategorisini, kendi kendisinin ana kategorisi yapamazsınız.';
$string['movecategoryparentconflict'] = '\'{$a}\' kategorisini kendi alt kategorilerinden birisinin alt kategorisi yapamazsınız.';
$string['mssqlrcsmodemissing'] = 'Veritabanı, özellikle yüksek eşzamanlılık senaryoları altında yanlış sonuçlara yol açabilecek beklenen READ_COMMITTED_SNAPSHOT modunu kullanmıyor. Lütfen doğru davranışı sağlayın. Daha fazla bilgi için,
<a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP"> PHP için MSSQL Yükleme </a> belgelerine bakın.';
$string['multiplerecordsfound'] = 'Sadece bir kayıt beklenmesine rağmen birden fazla kayıt bulundu.';
$string['multiplerestorenotallow'] = 'Çoklu geri yükleme yürütmesine izin verilmiyor!';
$string['mustbeloggedin'] = 'Bunu yapmak için oturum açmalısınız';
$string['mustbeteacher'] = 'Bu sayfaya bakabilmek için eğitimci olmalısınız';
$string['myisamproblem'] = 'Veritabanı tabloları MyISAM veritabanı motoru kullanıyor, InnoDB gibi tam işlem desteğine sahip ACID uyumlu motor kullanılması tavsiye edilir.';
$string['needcopy'] = 'İlk önce bir şeyi kopyalamanız gerekli!';
$string['needcoursecategroyid'] = 'Kur kimliği ya da kategori belirtilmeli';
$string['needphpext'] = 'PHP kurulumunuza {$a} desteği eklemelisiniz';
$string['noadmins'] = 'Hiç yönetici yok!';
$string['noblocks'] = 'Hiç blok bulunamadı!';
$string['nocapabilitytousethisservice'] = 'Kullanıcı bu hizmeti kullanabilmek için gerekli yeteneğe sahip değil';
$string['nocategorydelete'] = '\'{$a}\' kategorisi silinemez!';
$string['nocontext'] = 'Üzgünüz, bu kursun geçerli bir bağlamı yok';
$string['nodata'] = 'Veriler yok';
$string['noexistingcategory'] = 'Mevcut kategori yok';
$string['nofile'] = 'Dosya belirtilmemiş';
$string['nofiltersenabled'] = 'Filtreler etkinleştirilmemiş';
$string['nofolder'] = 'Gerekli dizin mevcut değil';
$string['noformdesc'] = 'Bu etkinlik için form açıklama dosyası bulunamadı.';
$string['noguest'] = 'Burada hiç konuk yok!';
$string['noinstances'] = '{$a} bu kursta kullanılmadı!';
$string['nologinas'] = 'Bu kullanıcı olarak oturum açma izniniz yok';
$string['nonmeaningfulcontent'] = 'Anlamsız içerik';
$string['noparticipants'] = 'Bu kursiçin hiç katılımcı bulunamadı';
$string['noparticipatorycms'] = 'Üzgünüz, ancak raporlayacağınız katılımcı kurs modüliniz yok';
$string['nopermissions'] = 'Üzgünüz, ancak şu anda bunu yapmak için izniniz yok ({$a}).';
$string['nopermissiontoaccesspage'] = 'Bu sayfaya erişim izniniz yok.';
$string['nopermissiontocomment'] = 'Yorum ekleyemezsiniz';
$string['nopermissiontodelentry'] = 'Bu yorumu silemezsiniz!';
$string['nopermissiontoeditcomment'] = 'Başka kişilerin yorumlarını düzenleyemezsiniz!';
$string['nopermissiontohide'] = 'Gizleme izni yok!';
$string['nopermissiontoimportact'] = 'Bu kursa etkinlikleri aktarmak için gerekli izinlere sahip değilsiniz';
$string['nopermissiontolock'] = 'Kilitlemek için izin yok!';
$string['nopermissiontomanagegroup'] = 'Grupları yönetmek için gerekli izinleriniz yok';
$string['nopermissiontorate'] = 'Öğelerin puanlanmasına izin verilmiyor!';
$string['nopermissiontoshow'] = 'Bunu görmeye izin yok!';
$string['nopermissiontounlock'] = 'Kilidi açmak için izin yok!';
$string['nopermissiontoupdatecalendar'] = 'Üzgünüz, ama şu anda takvim olayını güncellemek için izniniz yok';
$string['nopermissiontoviewcalendar'] = 'Maalesef takvim olayını görüntüleme izniniz yok.';
$string['nopermissiontoviewgrades'] = 'Notlar görüntülenemiyor.';
$string['nopermissiontoviewletergrade'] = 'Harf notlarını görüntüleme izni yok';
$string['nopermissiontoviewpage'] = 'Bu sayfaya bakma izniniz yok';
$string['nosite'] = 'Üst-düzey bir kurs bulunamıyor!';
$string['nositeid'] = 'Site kimliği yok';
$string['nostartdatenoenddate'] = 'Bir kurs bitiş tarihi ancak bir başlangıç tarihi de ayarlanmışsa ayarlanabilir.';
$string['nostatstodisplay'] = 'Üzgünüz, gösterilecek veri yok';
$string['notallowedtoupdateprefremotely'] = 'Bu kullanıcı tercihini uzaktan güncellemek için izniniz yok';
$string['notavailable'] = 'Şu anda erişilemez';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Bu kurs grubuna üye değilsiniz';
$string['notownerofkey'] = 'Bu anahtarın sahibi değilsiniz';
$string['nousers'] = 'Böyle bir kullanıcı yok!';
$string['oauth1accesstoken'] = 'OAuth 1.0 hatası: Erişim belirtecini alamadık.';
$string['oauth1requesttoken'] = 'OAuth 1.0 hatası: İstek belirtecini alamadık - hizmet sağlayıcı geçici olarak hizmet dışı olabilir.';
$string['oauth2refreshtokenerror'] = 'OAuth 2 belirteci yenilenemedi. Uzak uç nokta için HTTP durumu: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Bir veya daha fazla düzenleyici için OAuth 2 belirteci yenilenemedi. Ayrıntılar için görev çıktısını görüntüleyin.';
$string['oauth2upgradetokenerror'] = 'OAuth 2 belirteci yükseltilemedi. Uzak uç nokta için HTTP durumu: {$a}';
$string['onlyadmins'] = 'Bunu sadece yöneticiler yapabilir';
$string['onlyeditingteachers'] = 'Sadece öğretmenler bunu yapabilir';
$string['onlyeditown'] = 'Sadece kendi bilgilerinizi düzenleyebilirsiniz';
$string['opensslsealerror'] = 'OpenSSL verileri mühürleyemiyor';
$string['opensslsignerror'] = 'OpenSSL verileri imzalayamıyor';
$string['orderidnotfound'] = 'Sipariş kimliği {$a} bulunamadı';
$string['pagenotexist'] = '<p>Olmayan bir sayfayı görüntülemeye çalışırken olağandışı bir hata oluştu:</p>{$a}';
$string['pagenotexisttitle'] = '404 Hata: Dosya bulunamadı';
$string['passwordexceeded'] = 'Şifre {$a} karakterden fazla olamaz!';
$string['pathdoesnotstartslash'] = 'Geçerli argümanlar sağlanamadı, yol / (kesme) işareti ile başlamaz!';
$string['pleasereport'] = 'Zamanınız varsa, lütfen hata oluştuğunda ne yapmaya çalıştığınızı bilmemize izin verin:';
$string['pluginrequirementsnotmet'] = '"{$a->pluginname}" ({$a->pluginversion}) eklentisi kurulamadı. Bu eklenti daha yeni bir Moodle sürümü gerektirmektedir (şu anda kullandığınız: {$a->currentmoodle}, gereken: {$a->requiremoodle}).';
$string['pluginunsupported'] = '"{$a->pluginname}" {$a->pluginversion} eklentisi, Moodle {$a->moodleversion}\'ın bu sürümünü desteklemiyor. Desteklenen sürümleri bulmak için eklenti bilgilerine bakın.';
$string['prefixcannotbeempty'] = '<p>Hata: veritabanı tablo öneki boş olamaz ({$a})</p>
<p>Site yöneticisi bu sorunu gidermeli.</p>';
$string['prefixtoolong'] = '<p>Hata: veritabanı tablo öneki çok uzun ({$a->dbfamily})</p>
<p>Site yöneticisi bu sorunu gidermeli. {$a->dbfamily}\'de tablo öneklerinin maksimum uzunluğu {$a->maxlength} karakterdir.</p>';
$string['privatefilesupload'] = 'Doğrudan kullanıcıların özel dosyaları alanına yüklenmesi artık desteklenmiyor. Bir taslak alana yükleyin ve ardından dosyaları core_user :: add_user_private_files ile taşıyın';
$string['processingstops'] = 'İşlem burada sona erer. Kalan kayıtlar yoksayılır.';
$string['protected_cc_not_supported'] = 'Korumalı kartuşlar desteklenmiyor.';
$string['querystringcannotbeempty'] = 'Sorgu dizesi boş olamaz.';
$string['redirecterrordetected'] = 'Desteklenmeyen yönlendirme algılandı, komut dosyası yürütme sonlandırıldı';
$string['refoundto'] = 'Geri ödenebilir: {$a}';
$string['refoundtoorigi'] = 'Orijinal tutara {$a} geri ödeme yapıldı';
$string['registrationdisabled'] = 'Kayıt bu sitede devre dışı bırakıldı';
$string['remotedownloaderror'] = '<p>Bileşeni sunucunuza indirirken hata oluştu, lütfen proxy ayarlarını kontrol edin. PHP cURL eklentisi şiddetle tavsiye edilir.</p>
<p><a href="{$a->url}">{$a->url}</a> dosyasını kendiniz indirmeli ve indirdiğiniz dosyayı sunucunuzundaki "{$a->dest}" klasörüne kaydetmeli ve zip arşivini açmalısınız.
</p>';
$string['remotedownloadnotallowed'] = 'Sunucunuza bileşen indirmeye izin verilmiyor. (allow_url_fopen pasif).<br /><br />Arşivlenmiş dosyayı <a href="{$a->url}">{$a->url}</a> elle indirip buraya "{$a->dest}" açmalısınız.';
$string['reportnotavailable'] = 'Bu rapor tipi yalnızca site dersi için mevcut';
$string['requirecorrectaccess'] = 'Geçersiz url veya bağlantı noktası.';
$string['requireloginerror'] = 'Kurs veya etkinlik erişilemez.';
$string['restore_path_element_missingmethod'] = '{$a} geri yükleme yöntemi eksik. Geliştirici tarafından tanımlanmalı.';
$string['restore_path_element_noobject'] = 'Geri yükleme nesnesi {$a} bir nesne değil';
$string['restorechecksumfailed'] = 'Oturumunuzda kayıtlı bilgilerin geri yüklenmesinde bazı hatalar oluştu. Lütfen PHP belleği/Veri Tabanı Paketi Boyutu limitlerini kontrol ediniz. Geri yükleme durduruldu.';
$string['restrictedcontextexception'] = 'Üzgünüz, dış işlev yürütmesi, bağlam kısıtlamayı ihlal ediyor.';
$string['restricteduser'] = 'Üzgünüz, şu anki "{$a}" hesabınız bunu yapmak için sınırlandırılmıştır';
$string['reverseproxyabused'] = 'Sunucuya doğrudan erişilemeyecek şekilde ters proxy etkinleştirildi.<br />Lütfen sunucu yöneticisiyle iletişime geçin.';
$string['rpcerror'] = 'Pardon! MNET iletişiminiz başarısız oldu! Yöneticinize ileteceğiniz hata mesajı: ({$a})';
$string['scheduledbackupsdisabled'] = 'Otomatik yedeklemeler, sunucu yöneticisi tarafından kapatılmış.';
$string['secretalreadyused'] = 'Şifre değiştirme doğrulama bağlantısı önceden kullanılmış, şifre değiştirilmedi';
$string['sectionnotexist'] = 'Bu bölüm yok';
$string['sendmessage'] = 'Mesaj gönder';
$string['sendmessagesent'] = 'Geri bildiriminiz için teşekkürler:<br>{$a}';
$string['serverconnection'] = 'Sunucuya bağlanma hatası';
$string['servicedonotexist'] = 'Varolmayan servis';
$string['sessioncannotobtainlock'] = '<p>{$a->acquiretimeout} içinde {$a->id} oturum kimliği için kilit alınamadı.</p>

<p>Muhtemelen başka bir sayfa ({$a->whohaslock}) başka bir tarayıcı sekmesinde çalışıyor veya bir hata nedeniyle kilidi açmadı.</p>

<p>Oturum kilitleme zaman aşımına ({$a->lockexpire}) kadar bekleyebilir veya tarayıcı oturumunuzu yeniden başlatabilirsiniz. Bu hata devam ederse, lütfen sunucu yöneticisini bilgilendirin.</p>';
$string['sessioncookiesdisable'] = 'require_key_login() yanlış kullanımı - oturum çerezleri geçersiz kılınmalı!';
$string['sessiondiskfull'] = 'Oturum için ayrılmış alan dolu. Şimdilik giriş yapmanız imkansız. Lütfen sunucu yöneticisini bilgilendirin.';
$string['sessionerroruser'] = 'Oturumunuz zaman aşımına uğradı. Lütfen tekrar giriş yapınız.';
$string['sessionerroruser2'] = 'Giriş oturumunuzu etkileyen bir sunucu hatası algılandı. Lütfen yeniden giriş yapınız ya da tarayıcınızı yeniden başlatınız.';
$string['sessionexpired'] = 'Oturum süresi doldu';
$string['sessionhandlerproblem'] = 'Oturum işleyicisi yanlış yapılandırılmış';
$string['sessionipnomatch'] = 'Üzgünüz, IP numaranız ilk girdiğinizden farklıdır. Bu güvenlik özelliği, siteye giriş yaptığınızda crackerların kimlik bilgilerinizi çalmalarını engellemek içindir. Normal kullanıcıların bu mesajı görmemeleri gerekir - lütfen yardım için site yöneticisine başvurun.';
$string['sessionipnomatch2'] = '<p>Üzgünüm, ancak IP numaranız ilk giriş yaptığınız zamana göre değişmiş görünüyor. Bu güvenlik özelliği, bu sitede oturum açmışken bilgisayar korsanlarının kimliğinizi çalmasını önler. Kablosuz ağ kullanıyorsanız veya farklı ağlar arasında dolaşım yapıyorsanız bu hatayı görebilirsiniz. Daha fazla yardım için lütfen site yöneticisine danışın.</p>';
$string['sessionwaiterr'] = 'Oturum kilidi beklenirken zaman aşımına uğradı. <br />Mevcut isteklerinizin tamamlanmasını bekleyin ve daha sonra yeniden deneyin.';
$string['shortnametaken'] = 'Kısa ad başka bir kurs ({$a}) için kullanılıyor';
$string['sitepolicynotagreed'] = 'Site politikası kabul edilmedi: <a href="{$a}"> Site politikasını açmak için burayı tıklayın </a>.';
$string['socksnotsupported'] = 'SOCKS5 vekil sunucu, PHP4\'te desteklenmemektedir';
$string['spellcheckernotconf'] = 'Yazım denetimi yapılandırılmamış';
$string['sslonlyaccess'] = 'Üzgünüz, güvenlik sebeplerinden dolayı sadece güvenli (https) bağlantılara izin verilir.';
$string['statscatchupmode'] = 'İstatistikler şu anda işleme modunda. Şu ana kadar {$a->daysdone} gün işlendi ve {$a->dayspending} gün de beklemede. Daha sonra tekrar kontrol edin!';
$string['statsdisable'] = 'İstatistikler etkin değil.';
$string['statsnodata'] = 'Bu kurs ve zaman periyodu bileşimi için mevcut veri yok';
$string['storedfilecannotcreatefile'] = 'Yerel dosya havuzu dosyası oluşturulamıyor, dataroot izinlerini ve kullanılabilir disk alanını doğrulayın.';
$string['storedfilecannotcreatefiledirs'] = 'Yerel dosya havuzu dizinleri oluşturulamıyor, dataroot izinleri doğrulayın.';
$string['storedfilecannotread'] = 'Dosya okunamıyor, ya dosya yok ya da izin problemi var';
$string['storedfilecannotreadfile'] = '\'{$a}\' dosyası okunamıyor. Ya dosya yok ya da bir izin sorunu var.';
$string['storedfilenotcreated'] = '"{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}" dosyası oluşturulamıyor';
$string['storedfileproblem'] = 'Yerel dosyalarla ({$a}) ilgili bilinmeyen istisna';
$string['tagdisabled'] = 'Etiketler geçersiz kılındı!';
$string['tagnotfound'] = 'Belirtilen etiket veritabanında yok';
$string['targetdatabasenotempty'] = 'Hedef veritabanı boş değil. Güvenlik nedeniyle transfer durduruldu.';
$string['textconditionsnotallowed'] = 'Metin sütun koşulları karşılaştırılmasına izin verilmiyor. Sorgunuzda sql_compare_text () kullanın.';
$string['themenotinstall'] = 'Bu tema yüklenmemiş!';
$string['tokengenerationfailed'] = 'Yeni bir belirteç oluşturulamadı.';
$string['transactionvoid'] = 'İşlem daha önceden iptal edildiğinden tekrar iptal edilemez.';
$string['unenrolerror'] = 'Bu kişinin ders kaydı silinirken bir hata oluştu';
$string['unicodeupgradeerror'] = 'Üzgünüz, veritabanınız Unicode değil. Moodle\'ın bu sürümü veritabanınızı Unicode\'a çeviremedi. Lütfen öncelikle Moodle 1.7.x sürümüne geçin ve Yönetim sayfasından Unicode dönüştürmeyi gerçekleştirin. Bu işlem bittikten sonra, Moodle {$a} sürümüne geçebilirsiniz.';
$string['unknowaction'] = 'Bilinmeyen eylem!';
$string['unknowcategory'] = 'Kategori bilinmiyor!';
$string['unknowcontext'] = 'get_child_contexts() işlevinde bu bağlam ({$a}) bilinmiyor!';
$string['unknowformat'] = 'Biçim bilinmiyor ({$a})';
$string['unknownbackupexporterror'] = 'İçe aktarmiçin bilgi hazırlarken bilinmeyen hata';
$string['unknownblockregion'] = '\'{$a}\' blok bölgesi bu sayfada tanınmıyor.';
$string['unknowncategory'] = '"{$a}" kategori kimlik numarasına sahip bilinmeyen kategori';
$string['unknowncontext'] = 'Bu bilinmeyen bir biçim';
$string['unknowncourse'] = '"{$a}" adlı kurs bilinmiyor';
$string['unknowncourseidnumber'] = 'Bilinmeyen kurs ID "{$a}"';
$string['unknowncourserequest'] = 'Hatalı kurs isteği';
$string['unknowncoursesection'] = '"{$a}" kursu içinde bilinmeyen kurs bölümü';
$string['unknownevent'] = 'Bilinmeyen etkinlik';
$string['unknownfiletype'] = 'Bilinmeyen filtre tipinde hata';
$string['unknowngroup'] = 'Bilinmeyen grup "{$a}"';
$string['unknownhelp'] = 'Bilinmeyen yardım konusu {$a}';
$string['unknownjsinrequirejs'] = '{$a} JavaScript kütüphanesi bulunamıyor.';
$string['unknownmodulename'] = 'Form için bilinmeyen eklenti';
$string['unknownrole'] = 'Bilinmeyen rol "{$a}"';
$string['unknownsortcolumn'] = 'Bilinmeyen sıralama sütunu {$a}';
$string['unknownuseraction'] = 'Üzgünüz, bu kullanıcı eylemini anlamıyorum';
$string['unknownuserselector'] = 'Bilinmeyen kullanıcı seçicisi';
$string['unknoworder'] = 'Bilinmeyen sıralama';
$string['unknowparamtype'] = 'Bilinmeyen parametre tipi: {$a}';
$string['unknowquestiontype'] = 'Bilinmeyen soru tipi: {$a}';
$string['unknowuploadaction'] = 'Bilinmeyen yükleme eylemi ({$a})';
$string['unspecifycourseid'] = 'Kurs kimliği, kısa ad veya kimlik numarası belirtilmeli';
$string['unsupportedevent'] = 'Desteklenmeyen olay tipi';
$string['unsupportedstate'] = 'Desteklenmeyen tamamlama durumu';
$string['unsupportedwebserver'] = 'Üzgünüz, web sunucu yazılımı ({$a}) desteklenmiyor.';
$string['upgraderequires19'] = 'Hata: Sunucuya yeni Moodle sürümü kurulmuş ama önceki sürümden bu sürüme güncelleme desteklenmez.<br />Lütfen öncelikle en son 1.9.x sürümüne güncelleyin. 1.9.x sürümüne güncelleme yapmadan 2.0.x sürümüne güncelleme yapamazsınız.<br />Eski dosyaları tekrar yükleyerek önceki sürümüne de dönebilirsiniz.';
$string['upgraderunning'] = 'Site güncellemesi yapılıyor, lütfen daha sonra deneyin.';
$string['urlnotdefinerss'] = 'RSS besleme için URL tanımlanmamış';
$string['useradmineditadmin'] = 'Sadece yöneticilerin diğer yönetici hesaplarını değiştirmesine izin verilmiştir';
$string['useradminodelete'] = 'Yönetici hesapları silinemez';
$string['userautherror'] = 'Bilinmeyen yetkilentirme eklentisi';
$string['userauthunsupported'] = 'Yetkilendirme eklentisi burada desteklenmiyor';
$string['useremailduplicate'] = 'Tekrarlayan adres';
$string['userisfilteredout'] = 'Bu kullanıcı, filtreler ve tablo tercihleriyle eşleşmiyor!';
$string['usermustbemnet'] = 'MNET erişim kontrol listesindeki kullanıcılar uzak MNET kullanıcıları olmalı';
$string['usernamelowercase'] = 'Kullanıcı adı küçük harflerden oluşmalıdır';
$string['usernotaddederror'] = 'Kullanıcısı eklenemedi - hata';
$string['usernotaddedregistered'] = 'Kullanıcısı eklenemedi - zaten kayıtlı';
$string['usernotaddedusernameexists'] = 'Kullanıcı eklemenedi- bu kullanıcı adı farkli bir posta adresi ile mevcut durumdadır.';
$string['usernotavailable'] = 'Bu kullanıcının ayrıntıları sizin erişiminize kapalı';
$string['usernotdeletedadmin'] = 'Kullanıcı silinemedi - yönetici hesapları silinemez';
$string['usernotdeleteddeleted'] = 'Bu kullanıcı zaten silinmişti.';
$string['usernotdeletederror'] = 'Kullanıcı silinemedi - hata';
$string['usernotdeletedmissing'] = 'Kullanıcı silinemedi - kullanıcı adı bulunamadı';
$string['usernotdeletedoff'] = 'Kullanıcı silinemedi - silmeye izin verilmemiş';
$string['usernotfullysetup'] = 'Kullanıcı tam kurulum yapmadı';
$string['usernotincourse'] = 'Kullanıcı bu kursda kayıtlı değil!';
$string['usernotrenamedadmin'] = 'Yönetici hesaplarının adı değiştirilemez';
$string['usernotrenamedexists'] = 'Kullanıcı yeniden adlandırılamadı - yeni kullanıcı adı zaten kullanımda';
$string['usernotrenamedmissing'] = 'Kullanıcı yeniden adlandırılamadı - eski kullanıcı adı bulunamadı';
$string['usernotrenamedoff'] = 'Kullanıcı yeniden adlandırılamadı - yeniden adlandırmaya izin verilmemiş';
$string['usernotupdatedadmin'] = 'Yönetici hesabı güncellenemiyor';
$string['usernotupdatederror'] = 'Kullanıcı güncellenmedi - hata';
$string['usernotupdatednotexists'] = 'Kullanıcı güncellenemedi - yok';
$string['userquotalimit'] = 'Dosya kota sınırına ulaştınız.';
$string['userselectortoomany'] = 'user_selector birden fazla seçilen kullanıcı var, multiselect yanlış bile olsa.';
$string['verifyagedigitalconsentnotpossible'] = 'Üzgünüz, dijital yaş onayı doğrulaması şu anda mümkün değildir.';
$string['wrongcall'] = 'Bu betik hatalı bir şekilde çağrıldı';
$string['wrongcontextid'] = 'Bağlam kimliği hatalı (bu kimlik bulunamadı)';
$string['wrongdestpath'] = 'Yanlış hedef yolu';
$string['wrongroleid'] = 'Hatalı rol kimliği';
$string['wrongsourcebase'] = 'Yanlış kaynak URL tabanı';
$string['wrongusernamepassword'] = 'Hatalı kullanıcı/şifre';
$string['wrongzipfilename'] = 'Yanlış ZIP dosya adı';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Kurrs oluşturulamadı - İzin yok';
$string['wwwrootmismatch'] = 'Hatalı erişim algılandı. Üzgünüz, bu sunucuya sadece "{$a}" adresinden erişilebilir.<br />Lütfen sunucu yöneticisini bilgilendirin.';
$string['wwwrootslash'] = 'config.php dosyasında geçersiz $CFG->wwwroot algılandı. Bu ayar slash karakteri ile bitmemeli. <br />Lütfen sunucu yöneticisini uyarın.';
$string['xmldberror'] = 'XMLDB hatası!';
$string['youcannotdeletecategory'] = '\'{$a}\' kategorisini silemezsiniz. Ne içeriğini sildiniz ne de başka bir yere taşıdınız.';
