<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'lt', version '4.3'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Veiksmas';
$string['actionsmenu'] = 'Veiksmų meniu';
$string['add'] = 'Įtraukti įrašą';
$string['addcomment'] = 'Įtraukti komentarą';
$string['addedby'] = 'Pridėjo';
$string['addentries'] = 'Įtraukti įrašus';
$string['addtemplate'] = 'Įrašo įtraukimo šablonas';
$string['advancedsearch'] = 'Išplėstinė paieška';
$string['allowcomments'] = 'Leisti komentuoti įrašus';
$string['alttext'] = 'Alternatyvusis tekstas';
$string['approvalstatus'] = 'Patvirtinimo statusas';
$string['approve'] = 'Patvirtinti';
$string['approved'] = 'Patvirtinta';
$string['areacontent'] = 'Sritys';
$string['ascending'] = 'Didėjimo tvarka';
$string['asearchtemplate'] = 'Išplėstinės paieškos šablonas';
$string['atmaxentry'] = 'Įvedėte maksimalų leistiną įrašų skaičių!';
$string['authorfirstname'] = 'Vardas';
$string['authorlastname'] = 'Pavardė';
$string['autogenallforms'] = 'Generuoti visus numatytuosius šablonus';
$string['autolinkurl'] = 'Automatiškai susieti URL';
$string['availablefromdate'] = 'Galima nuo';
$string['availabletags'] = 'Galimos žymės';
$string['availabletags_help'] = 'Žymės - tai šablono žymės, kurios redaguojant arba peržiūrint įrašus bus pakeistos duomenimis arba kitais elementais, pvz., redagavimo piktograma.

Laukų formatas yra [[fieldname]]. Visos kitos žymos turi formatą ##sometag##.

Dabartiniame šablone galima naudoti tik tas žymes, kurios yra sąraše Galimos žymės.';
$string['availabletodate'] = 'Galima iki';
$string['availabletodatevalidation'] = 'Galima data negali būti ankstesnė nei galima nuo data.';
$string['blank'] = 'Tuščia';
$string['buttons'] = 'Veiksmai';
$string['bynameondate'] = '{$a->name} - {$a->date}';
$string['calendarend'] = '{$a} uždaroma';
$string['calendarstart'] = '{$a} atidaroma';
$string['cancel'] = 'Atšaukti';
$string['cannotaccesspresentsother'] = 'Jums neleidžiama prieiti prie kitų naudotojų išankstinių nustatymų rinkinių';
$string['cannotadd'] = 'Nepavyksta įtraukti įrašų!';
$string['cannotapplypreset'] = 'Klaida taikant išankstinių nustatymų rinkinį.';
$string['cannotdeletepreset'] = 'Klaida naikinant išankstinių nustatymų rinkinį';
$string['cannotoverwritepreset'] = 'Klaida perrašant išankstinių nustatymų rinkinį';
$string['cannotunziptopreset'] = 'Nepavyksta išskleisti išankstinių nustatymų rinkinio katalogą';
$string['checkbox'] = 'Žymės langeliai';
$string['chooseexportfields'] = 'Pasirinkite laukus, kuriuos norite eksportuoti';
$string['chooseexportformat'] = 'Pasirinkite formatą, į kurį norite eksportuoti';
$string['chooseorupload'] = 'Pasirinkite failą';
$string['choosepreset'] = 'Išankstinių nustatymų rinkinio failas';
$string['closebeforeopen'] = 'Nurodyta pabaigos data prieš pradžios datą.';
$string['columns'] = 'stulpeliai';
$string['comment'] = 'Komentaras';
$string['commentdeleted'] = 'Komentaras panaikintas';
$string['commentempty'] = 'Komentaras buvo tuščias';
$string['comments'] = 'Komentarai';
$string['commentsaved'] = 'Komentaras įrašytas';
$string['commentsn'] = 'Komentarų: {$a}';
$string['commentsoff'] = 'Komentavimo galimybė nėra įgalinta';
$string['completiondetail:entries'] = 'Sukurti įrašų: {$a}';
$string['completionentries'] = 'Būtini įrašai';
$string['completionentriescount'] = 'Pridėti įrašus';
$string['completionentriesdesc'] = 'Mažiausiai būtinų įrašų skaičius: {$a}';
$string['configenablerssfeeds'] = 'Šis perjungimas įjungs RSS informacijos santraukų galimybę visose duomenų bazėse. Bet dar turėsite rankiniu būdu įjungti informacijos santraukas kiekvienos duomenų bazės parametruose.';
$string['confirmdeletefield'] = 'Ruošiatės naikinti šį lauką. Ar tikrai norite tai padaryti?';
$string['confirmdeleterecord'] = 'Ar tikrai norite ištrinti šį įrašą?';
$string['confirmdeleterecords'] = 'Ar tikrai norite ištrinti šiuos įrašus?';
$string['createactivity'] = 'Sukurkite savo laukus duomenims rinkti arba naudokite iš anksto nustatytą rinkinį, į kurį jau įtraukti laukai.';
$string['createfields'] = 'Sukurkite laukus įvairių tipų duomenims rinkti.';
$string['createtemplates'] = 'Šablonai apibrėžia jūsų veiklos sąsają. Kai sukursite laukus, šablonai bus sukurti automatiškai. Arba galite naudoti išankstinių nustatymų rinkinį, kuriame yra laukai ir šablonai.';
$string['csstemplate'] = 'Tinkintas CSS';
$string['csvfailed'] = 'Nepavyksta nuskaityti neapdorotų duomenų iš CSV failo';
$string['csvfile'] = 'CSV arba ZIP, kuriame yra CSV failas';
$string['csvimport'] = 'CSV failo importavimas';
$string['csvimport_help'] = 'Įrašus galima importuoti naudojant paprastojo teksto failą, kurio pirmojoje eilutėje yra laukų pavadinimų sąrašas, tada – duomenys (vienas įrašas vienoje eilutėje).';
$string['csvwithselecteddelimiter'] = '<abbr title="Kableliais atskirtos reikšmės">CSV</abbr>';
$string['data:addinstance'] = 'Pridėti naują duomenų bazę';
$string['data:approve'] = 'Patvirtinti nepatvirtintus įrašus';
$string['data:comment'] = 'Rašyti komentarus';
$string['data:exportallentries'] = 'Eksportuoti visus duomenų bazės įrašus';
$string['data:exportentry'] = 'Eksportuoti duomenų bazės įrašą';
$string['data:exportownentry'] = 'Eksportuoti savo duomenų bazės įrašą';
$string['data:exportuserinfo'] = 'Eksportuoti naudotojo informaciją';
$string['data:managecomments'] = 'Tvarkyti komentarus';
$string['data:manageentries'] = 'Tvarkyti įrašus';
$string['data:managetemplates'] = 'Tvarkyti šablonus';
$string['data:manageuserpresets'] = 'Tvarkyti išankstinių nustatymų rinkinius';
$string['data:rate'] = 'Vertinti įrašus';
$string['data:readentry'] = 'Skaityti įrašus';
$string['data:view'] = 'Peržiūrėti duomenų bazės veiklą';
$string['data:viewallratings'] = 'Peržiūrėti visus neapdorotus asmenų parašytus pažymius';
$string['data:viewalluserpresets'] = 'Peržiūrėti visų naudotojų išankstinių nustatymų rinkinius';
$string['data:viewanyrating'] = 'Peržiūrėti bendrus kurio nors asmens gautus pažymius';
$string['data:viewentry'] = 'Peržiūrėti įrašus';
$string['data:viewrating'] = 'Peržiūrėti bendrus jūsų gautus pažymius';
$string['data:writeentry'] = 'Rašyti įrašus';
$string['date'] = 'Data';
$string['dateentered'] = 'Įvedimo data';
$string['datemodified'] = 'Paskutinį kartą redaguota:';
$string['defaultfielddelimiter'] = '(kablelis yra numatytasis simbolis)';
$string['defaultfieldenclosure'] = '(numatytasis yra joks)';
$string['defaultsortfield'] = 'Numatytasis rikiavimo laukas';
$string['delcheck'] = 'Masinis žymimųjų langelių naikinimas';
$string['delete'] = 'Naikinti';
$string['deleteallentries'] = 'Naikinti visus įrašus';
$string['deletecomment'] = 'Ar tikrai norite naikinti šį komentarą?';
$string['deleteconfirm'] = 'Ištrinti išankstinių nustatymų rinkinį {$a}?';
$string['deleted'] = 'panaikinta';
$string['deleteentry'] = 'Ištrinti įrašą';
$string['deletefield'] = 'Naikinti lauką';
$string['deletenotenrolled'] = 'Naikinti neįregistruotų naudotojų įrašus';
$string['deletewarning'] = 'Ištrynus išankstinių nustatymų rinkinį, jis panaikinamas iš visų kursų galimų išankstinių nustatymų rinkinių sąrašo.';
$string['descending'] = 'Mažėjimo tvarka';
$string['directorynotapreset'] = '{$a->directory} Ne išankstinių nustatymų rinkinys: trūkstami failai: {$a->missing_files}';
$string['disapprove'] = 'Atšaukti patvirtinimą';
$string['download'] = 'Atsisiųsti';
$string['edit'] = 'Redaguoti';
$string['editcomment'] = 'Redaguoti komentarą';
$string['editentry'] = 'Redaguoti įrašą';
$string['editfield'] = 'Redaguoti lauką';
$string['editordisable'] = 'Išjungti rengyklę';
$string['editorenable'] = 'Įjungti kodo rengyklę';
$string['editpreset'] = 'Redaguoti išankstinio nustatymo rinkinį';
$string['emptyadd'] = 'Laukas Įtraukti šabloną yra tuščias, generuojama numatytoji forma...';
$string['emptyaddform'] = 'Neužpildėte jokių laukų!';
$string['emptypresetname'] = 'Išankstinio nustatymų rinkinio pavadinimas arba failas negali būti tuščias';
$string['enabletemplateeditorcheck'] = 'Ar tikrai norite įgalinti rengyklę? Tai gali pakeisti turinio rezultatą, kai šablonas yra išsaugomas.';
$string['entries'] = 'Įrašai';
$string['entrieslefttoadd'] = 'Norėdami užbaigti šią veiklą, turite pridėti dar {$a->entriesleft} įrašą / įrašus.';
$string['entrieslefttoaddtoview'] = 'Turite įtraukti dar {$a->entrieslefttoview} įrašus (-ų), kad galėtumėte peržiūrėti kitų dalyvių įrašus.';
$string['entry'] = 'Įrašas';
$string['entrysaved'] = 'Jūsų įrašas įrašytas';
$string['errordatafilenotfound'] = 'Failo importuoti nepavyko. Priimtini failų tipai yra CSV arba ZIP, kuriame yra CSV failas tokiu formatu, koks naudojamas įrašams eksportuoti.';
$string['errormustbeteacher'] = 'Norėdami naudoti šį puslapį turite būti dėstytojas!';
$string['errormustsupplyvalue'] = 'Privalote pateikti reikšmę čia.';
$string['errorpresetexists'] = 'Išankstinių nustatymų rinkinys tokiu pavadinimu jau yra.';
$string['errorpresetexistsbutnotoverwrite'] = 'Išankstinių nustatymų rinkinys tokiu pavadinimu jau yra. Pasirinkite kitą pavadinimą.';
$string['errorpresetnotfound'] = 'Išankstinių nustatymų rinkinio pavadinimu {$a} nerasta.';
$string['eventfieldcreated'] = 'Laukas sukurtas';
$string['eventfielddeleted'] = 'Laukas ištrintas';
$string['eventfieldupdated'] = 'Laukas atnaujintas';
$string['eventrecordcreated'] = 'Įrašas sukurtas';
$string['eventrecorddeleted'] = 'Įrašas ištrintas';
$string['eventrecordupdated'] = 'Įrašas atnaujintas';
$string['eventtemplateupdated'] = 'Šablonas atnaujintas';
$string['eventtemplateviewed'] = 'Šablonai peržiūrėti';
$string['example'] = 'Duomenų bazės modulio pavyzdys';
$string['excel'] = '„Excel“';
$string['expired'] = 'Apgailestaujame, ši veikla uždaryta {$a} ir nebegalima';
$string['export'] = 'Eksportuoti';
$string['exportaszip'] = 'Eksportuoti kaip suglaudintą failą';
$string['exportaszip_help'] = 'Eksportavimo ZIP failo funkcija leidžia įrašyti šablonus ir laukus kaip išankstinių nustatymų rinkinį ZIP failo atsisiuntimui. Tada ZIP failą galima importuoti į kitus kursus.';
$string['exportedtozip'] = 'Eksportuota į laikinąjį suglaudintą failą...';
$string['exportentries'] = 'Eksportuoti įrašus';
$string['exportformat'] = 'Eksportavimo formatas';
$string['exportoptions'] = 'Eksportavimo nuostatos';
$string['exportownentries'] = 'Eksportuoti tik jūsų įrašus? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Eksportuoti išankstinių nustatymų rinkinį';
$string['failedpresetdelete'] = 'Bandant naikinti išankstinių nustatymų rinkinį įvyko klaida.';
$string['fieldadded'] = 'Laukas įtrauktas';
$string['fieldallowautolink'] = 'Leisti automatinį susiejimą';
$string['fielddeleted'] = 'Laukas panaikintas';
$string['fielddelimiter'] = 'Lauko atskyriklis';
$string['fielddescription'] = 'Lauko aprašas';
$string['fieldenclosure'] = 'Lauko apibraukimas';
$string['fieldheight'] = 'Aukštis';
$string['fieldheightlistview'] = 'Aukštis (pikseliais) sąrašo rodinyje';
$string['fieldheightsingleview'] = 'Aukštis (pikseliais) vieno elemento rodinyje';
$string['fieldids'] = 'Laukų ID';
$string['fieldmappings'] = 'Laukų susiejimai';
$string['fieldmappings_help'] = 'Šis meniu leidžia saugoti duomenis iš esamos duomenų bazės. Norėdami išsaugoti duomenis lauke, turite juos susieti su nauju lauku, kuriame bus rodomi duomenys. Bet kuris laukas taip pat gali būti paliktas tuščias, į jį nenukopijuojant jokios informacijos. Bet koks senas laukas, nesusietas su nauju, bus prarastas ir visi jo duomenys bus pašalinti.
Galite susieti tik to paties tipo laukus, todėl kiekviename iškrentančiame meniu bus skirtingi laukai. Be to, turite būti atsargūs ir nebandyti susieti vieno seno lauko su daugiau nei vienu nauju lauku.';
$string['fieldname'] = 'Lauko pavadinimas';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Šie jūsų failo laukai yra nežinomi šiai duomenų bazei: {$a}';
$string['fieldoptions'] = 'Pasirinkimai (po vieną eilutėje)';
$string['fields'] = 'Laukai';
$string['fieldshelp'] = 'Sukurkite laukus įvairių tipų duomenims rinkti. Laukai nurodo jūsų duomenų bazės įrašų struktūrą.';
$string['fieldsinformationtags'] = 'Lauko informacija';
$string['fieldsnavigation'] = 'Laukų tretinė navigacija';
$string['fieldtagdescription'] = '{$a} aprašymas';
$string['fieldtagid'] = '{$a} ID';
$string['fieldtagname'] = '{$a} pavadinimas';
$string['fieldupdated'] = 'Laukas atnaujintas';
$string['fieldwidth'] = 'Plotis';
$string['fieldwidthlistview'] = 'Plotis (pikseliais) sąrašo rodinyje';
$string['fieldwidthsingleview'] = 'Plotis (pikseliais) vieno elemento rodinyje';
$string['file'] = 'Failas';
$string['fileencoding'] = 'Kodavimas';
$string['filesnotgenerated'] = 'Sugeneruoti ne visi failai: {$a}';
$string['filtername'] = 'Duomenų bazės automatinis susiejimas';
$string['footer'] = 'Poraštė';
$string['forcelinkname'] = 'Priverstinis saito pavadinimas';
$string['foundnorecords'] = 'Įrašų nerasta. <a href="{$a->reseturl}">Išvalyti viską</a>';
$string['foundrecords'] = 'Rasta {$a->num} iš {$a->max} įrašų. <a href="{$a->reseturl}">Išvalyti viską</a>';
$string['fromfile'] = 'Importuoti iš suglaudinto failo';
$string['fromfile_help'] = 'Importavimo iš ZIP failo funkcija leidžia naršyti ir įkelti iš anksto nustatytą šablonų ir laukų rinkinio ZIP failą.';
$string['generateerror'] = 'Sugeneruoti ne visi failai!';
$string['header'] = 'Antraštė';
$string['headeraddtemplate'] = 'Apibrėžkite įrašų įtraukimo arba redagavimo sąsają.';
$string['headerasearchtemplate'] = 'Apibrėžkite išplėstinės paieškos sąsają.';
$string['headercsstemplate'] = 'Pridėti tinkintą CSS prie šablonų.';
$string['headerjstemplate'] = 'Pridėkite tinkintą Javascript „Sąrašas“,„Vienas“ arba „Pridėti įrašą“ šablonuose.';
$string['headerlisttemplate'] = 'Apibrėžkite sąrašo rodinio išvaizdą.';
$string['headerrsstemplate'] = 'Apibrėžkite įrašų išvaizdą RSS informacijos santraukose.';
$string['headersingletemplate'] = 'Apibrėžia vieno elemento rodinio išvaizdą';
$string['id'] = 'Įėjimo ID';
$string['importandapply'] = 'Importuoti išankstinių nustatymų rinkinį ir pritaikyti';
$string['importapreset'] = 'Importuoti išankstinių nustatymų rinkinį';
$string['importentries'] = 'Importuoti įrašus';
$string['importpreset'] = 'Importuoti išankstinių nustatymų rinkinį';
$string['importpreset_desc'] = 'Išankstinių nustatymų rinkinys bus pritaikytas šiai veiklai, sukuriant laukus ir šablonus.
Jis nebus rodomas išankstinių nustatymų sąraše.';
$string['importpresetmissingcapability'] = 'Neturite leidimo importuoti išankstinių nustatymų rinkinio.';
$string['importsuccess'] = 'Pritaikytas išankstinių nustatymų rinkinys.';
$string['includeapproval'] = 'Įtraukti patvirtinimo statusą';
$string['includefiles'] = 'Įtraukti failus į eksportą';
$string['includetags'] = 'Įtraukti žymes';
$string['includetime'] = 'Įtraukti pridėjimo/atnaujinimo laiką';
$string['includeuserdetails'] = 'Įtraukti naudotojo duomenis';
$string['indicator:cognitivedepth'] = 'Kognityvinė duomenų bazė';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekė duomenų bazės veikloje.';
$string['indicator:cognitivedepthdef'] = 'Kognityvinė duomenų bazė';
$string['indicator:cognitivedepthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį pažinimo įsitraukimo procentą, kurį siūlo duomenų bazės veikla (lygiai = nėra peržiūros, peržiūra, pateikimas)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialinė duomenų bazė';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu pločiu, kurį besimokantysis pasiekė Duomenų bazės veikloje.';
$string['indicator:socialbreadthdef'] = 'Socialinė duomenų bazė';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis pasiekė šį socialinio įsitraukimo procentą, kurį siūlo duomenų bazės veikla per šį analizės intervalą (lygiai = nedalyvauta, vienas dalyvis)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'daugiau nereikia įrašų šiai duomenų bazei peržiūrėti';
$string['intro'] = 'Aprašymas';
$string['invalidaccess'] = 'Į šį puslapį įeita netinkamai';
$string['invalidfieldid'] = 'Lauko ID klaidingas';
$string['invalidfieldname'] = 'Pasirinkite kitą šio lauko pavadinimą';
$string['invalidfieldtype'] = 'Lauko tipas klaidingas';
$string['invalidid'] = 'Klaidingas duomenų ID';
$string['invalidpreset'] = '{$a} nėra išankstinių nustatymų rinkinys.';
$string['invalidrecord'] = 'Klaidingas įrašas';
$string['invalidurl'] = 'Jūsų ką tik įvestas URL yra neleistinas';
$string['jstemplate'] = 'Tinkintas „Javascript“';
$string['latitude'] = 'Platuma';
$string['latlong'] = 'Koordinatės';
$string['latlongboth'] = 'Abu, platuma ir ilguma, yra privalomi.';
$string['latlongdownloadallhint'] = 'Atsisiųsti visų įrašų saitą kaip KML';
$string['latlongkmllabelling'] = 'Kaip žymėti elementus KML failuose („Google Earth“)';
$string['latlonglinkservicesdisplayed'] = 'Sukurti išorinį rodytinų tarnybų saitą';
$string['latlongotherfields'] = 'Kiti laukai';
$string['list'] = 'Peržiūrėti sąrašą';
$string['listtemplate'] = 'Sąrašo rodinio šablonas';
$string['listview'] = 'Sąrašo rodinys';
$string['longitude'] = 'Ilguma';
$string['manageapproved'] = 'Leisti patvirtintų įrašų redagavimą';
$string['manageapproved_help'] = 'Leisti besimokantiesiems redaguoti arba ištrinti savo įrašus, kai jie buvo patvirtinti. Redaguoti įrašai turės būti patvirtinti iš naujo.';
$string['managefields'] = 'Tvarkyti laukus';
$string['mapexistingfield'] = 'Susieti su {$a}';
$string['mapnewfield'] = 'Kurti naują lauką';
$string['mapping:applypresets'] = 'Taikyti išankstinių nustatymų rinkinį';
$string['mapping:dialogtitle:usepreset'] = 'Taikyti išankstinių nustatymų rinkinį {$a}?';
$string['mapping:fieldstocreate'] = 'Laukai, kuriuos reikia sukurti: {$a}';
$string['mapping:fieldstodelete'] = 'Esami laukai, kuriuos reikia ištrinti: {$a}';
$string['mapping:mapfields'] = 'Susieti laukus';
$string['mapping:warningmessagedelete'] = 'Jei laukai, kuriuos reikia naikinti, yra tokio paties tipo kaip nauji laukai išankstinių nustatymų rinkinyje, kurį taikote, galite juos susieti.';
$string['mapping:warningmessagedeleteandcreate'] = 'Jei norimi ištrinti laukai yra tokio paties tipo kaip ir sukurti laukai, galite juos susieti Laukų susiejime.';
$string['mappingwarning'] = 'Visi seni laukai, nesusieti su nauju lauku, bus prarasti, o visi lauke esantys duomenys bus pašalinti.';
$string['maxentries'] = 'Maksimalus įrašų skaičius';
$string['maxentries_help'] = 'Maksimalus šios veiklos įrašų, kuriuos besimokančiajam leidžiama pateikti, skaičius.';
$string['maxsize'] = 'Maksimalus dydis';
$string['menu'] = 'Meniu';
$string['menuchoose'] = 'Pasirinkite...';
$string['missingdata'] = 'Lauko klasei turi būti pateiktas duomenų ID arba objektas.';
$string['missingfield'] = 'Programuotojo klaida: apibrėždami lauko klasę turite nurodyti lauką ir (arba) duomenis.';
$string['missingfieldtype'] = 'Nerastas {$a->name} lauko tipas';
$string['missingfieldtypeimport'] = 'Šie laukai nebuvo importuoti, nes neįdiegti atitinkami jų tipai:';
$string['missingfieldtypes'] = 'Toliau nurodyti laukų atitinkami laukų tipai neįdiegti ir nebus įtraukti į „Pridėti įrašą“ formą. Turite patikrinti „Pridėti įrašą“ šabloną ir pašalinti visus laukų pavadinimus.';
$string['modulename'] = 'Duomenų bazė';
$string['modulename_help'] = 'Duomenų bazė dalyviams leidžia kurti, tvarkyti ir ieškoti įrašų rinkinyje.

Įrašų struktūra apibrėžiama naudojant įvairių tipų laukus, pavyzdžiui, trumpąjį tekstą, iškrentantį meniu, teksto sritį, URL, paveikslėlį arba failą.

Kaip dėstytojas galite komentuoti ir vertinti įrašus. Taip pat galite leisti besimokantiesiems vertinti ir komentuoti įrašus (tarpusavio vertinimas). Įvertinimus galima apibendrinti ir sudaryti galutinį įvertinimą, kuris įrašomas įvertinimų knygelėje.

Jei įjungtas duomenų bazės automatinio susiejimo filtras, bet kokie įrašai duomenų bazėje bus automatiškai susiejami ten, kur šie žodžiai ar frazės yra kurse.

Duomenų bazę galite naudoti norėdami:

* Sukurti bendrą nuorodų, knygų, knygų apžvalgų, žurnalų nuorodų ir kt. rinkinį.
* Rodyti besimokančiųjų sukurtas nuotraukas, plakatus, interneto svetaines ar eilėraščius, kad juos tarpusavyje galėtų komentuoti ir peržiūrėti.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Duomenų bazės';
$string['more'] = 'Daugiau';
$string['moreurl'] = 'Daugiau URL';
$string['movezipfailed'] = 'Negalima perkelti suglaudinto failo';
$string['multientry'] = 'Pasikartojantis  įrašas';
$string['multimenu'] = 'Meniu (su kelių variantų pasirinkimu)';
$string['multipletags'] = 'Rastos kelios žymės! Šablonas neįrašytas';
$string['newentry'] = 'Naujas įrašas';
$string['newfield'] = 'Sukurti lauką';
$string['newfield_help'] = 'Laukas leidžia įvesti duomenis. Kiekvienas duomenų bazės veiklos įrašas gali turėti kelis kelių tipų laukus, pvz., datos lauką, leidžiantį dalyviams išskleidžiamajame meniu pasirinkti dieną, mėnesį ir metus, paveikslėlio lauką, leidžiantį dalyviams įkelti vaizdo failą, arba žymimąjį laukelį, kuriame dalyviai gali pasirinkti vieną ar daugiau parinkčių.

Kiekvienas laukas turi turėti unikalų lauko pavadinimą. Lauko aprašymas yra neprivalomas.';
$string['noaccess'] = 'Negalite prieiti prie šio puslapio';
$string['nodefinedfields'] = 'Naujas išankstinių nustatymų rinkinys neturi apibrėžtų laukų!';
$string['nofieldcontent'] = 'Lauko turinys nerastas';
$string['nofieldindatabase'] = 'Nėra apibrėžtų šios duomenų bazės laukų.';
$string['nofields'] = 'Laukų dar nėra';
$string['nolisttemplate'] = 'Sąrašo rodinio šablonas dar neapibrėžtas';
$string['nomatch'] = 'Nerasta atitinkančių įrašų!';
$string['nomaximum'] = 'Nėra maksimumo';
$string['nopreviewavailable'] = 'Nėra galimo speržiūros {$a}';
$string['norecords'] = 'Dar nėra įrašų';
$string['nosingletemplate'] = 'Vieno elemento rodinio šablonas dar neapibrėžtas';
$string['notapproved'] = 'Laukiama patvirtinimo';
$string['notapprovederror'] = 'Įėjimas dar nepatvirtintas.';
$string['notemplates'] = 'Dar nėra šablonų';
$string['notinjectivemap'] = 'Neinjektyvus susiejimas';
$string['notopenyet'] = 'Apgailestaujame, ši veikla negalima iki {$a}';
$string['number'] = 'Skaičius';
$string['numberrssarticles'] = 'RSS straipsniai';
$string['numnotapproved'] = 'Laukiama';
$string['numrecords'] = '{$a} įrašai (-ų)';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Nurodyta pabaigos data ankstesnė nei pradžios data';
$string['optionaldescription'] = 'Trumpasis aprašas (pasirinktinis)';
$string['optionalfilename'] = 'Failo vardas (pasirinktinis)';
$string['other'] = 'Kita';
$string['otherfields'] = 'Visi kiti laukai';
$string['overrwritedesc'] = 'Pakeisti esamą išankstinių nustatymų rinkinį šiuo pavadinimu ir perrašyti jo turinį';
$string['overwrite'] = 'Keisti';
$string['overwritesettings'] = 'Keisti esamus nustatymus, pvz., komentarus, įvertinimus ir kt.';
$string['page-mod-data-x'] = 'Bet kuris duomenų bazės veiklos modulio puslapis';
$string['pagesize'] = 'Puslapyje rodomų įrašų skaičius';
$string['participants'] = 'Dalyviai';
$string['picture'] = 'Paveikslėlis';
$string['pleaseaddsome'] = 'Norėdami pradėti, sukurkite žemiau arba <a href="{$a}">pasirinkite iš anksto apibrėžtą rinkinį</a>.';
$string['pluginadministration'] = 'Duomenų bazės veiklos administravimas';
$string['pluginname'] = 'Duomenų bazė';
$string['portfolionotfile'] = 'Eksportuoti į portfelį, o ne į failą (tik CSV ir „leap2a“)';
$string['presetdeleted'] = 'Išankstinių nustatymų rinkinys pašalintas.';
$string['presetinfo'] = 'Įrašius kaip išankstinių nustatymų rinkinį, šis šablonas bus publikuotas. Kiti naudotojai galės naudoti jį savo duomenų bazėse.';
$string['presetnotselected'] = 'Nebuvo pasirinktas joks išankstinių nustatymų rinkinys.';
$string['presets'] = 'Išankstinių nustatymų rinkiniai';
$string['presetshelp'] = 'Pasirinkite išankstinių nustatymų rinkinį, kurį naudosite kaip pradinį tašką.';
$string['preview'] = 'Peržiūra {$a}';
$string['previewaction'] = 'Peržiūra';
$string['privacy:metadata:commentpurpose'] = 'Duomenų bazės įrašų komentarai';
$string['privacy:metadata:data_content'] = 'Lauko turinys';
$string['privacy:metadata:data_content:content'] = 'Turinys';
$string['privacy:metadata:data_content:content1'] = 'Papildomas turinys 1';
$string['privacy:metadata:data_content:content2'] = 'Papildomas turinys 2';
$string['privacy:metadata:data_content:content3'] = 'Papildomas turinys 3';
$string['privacy:metadata:data_content:content4'] = 'Papildomas turinys 4';
$string['privacy:metadata:data_content:fieldid'] = 'Lauko apibrėžimo ID';
$string['privacy:metadata:data_records'] = 'Įrašai duomenų bazės veikloje';
$string['privacy:metadata:data_records:approved'] = 'Patvirtinimo būsena';
$string['privacy:metadata:data_records:groupid'] = 'Grupė';
$string['privacy:metadata:data_records:timecreated'] = 'Laikas, kai įrašas sukurtas';
$string['privacy:metadata:data_records:timemodified'] = 'Laikas, kai įrašas paskutinį kartą keistas';
$string['privacy:metadata:data_records:userid'] = 'Naudotojas, kuris sukūrė įrašą';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Duomenų bazės veiklos modulio laukas';
$string['privacy:metadata:filepurpose'] = 'Failas, pridėtas prie duomenų bazės įrašo';
$string['privacy:metadata:ratingpurpose'] = 'Duomenų bazių įrašų reitingai';
$string['privacy:metadata:tagpurpose'] = 'Duomenų bazės įrašų žymės';
$string['radiobutton'] = 'Išrinkimo mygtukai';
$string['recordapproved'] = 'Įrašas patvirtintas';
$string['recorddeleted'] = 'Įrašas panaikintas';
$string['recorddisapproved'] = 'Įrašas nepatvirtintas';
$string['recordsnotsaved'] = 'Neįrašytas joks įrašas. Patikrinkite įkelto failo formatą.';
$string['recordssaved'] = 'įrašyti įrašai';
$string['removealldatatags'] = 'Pašalinti visas duomenų bazės žymes';
$string['requireapproval'] = 'Ar reikalauti patvirtinti?';
$string['requireapproval_help'] = 'Dėstytojas turi patvirtinti įrašus, kad jie būtų matomi visiems.';
$string['required'] = 'Privalomas';
$string['requiredentries'] = 'Būtini įrašai užbaigimui (seni)';
$string['requiredentries_help'] = 'Jei nustatyta, rodomas pranešimas, kiek įrašų reikia pateikti veiklos užbaigimui. Atkreipkite dėmesį, kad šis nustatymas nėra susietas su veiklos užbaigimu.

Jei reikia įrašų, reikalingų veiklos užbaigimui, turėtų būti nustatytas naujas veiklos užbaigimo parametras "Būtini įrašai". Norėdami visiškai pašalinti šį nustatymą, nenustatykite reikšmės ir tada išsaugokite pakeitimus.
Vietoje to, naudokite laukelį "Įrašai, būtini prieš peržiūrint".';
$string['requiredentriestoview'] = 'Įrašai, būtini prieš peržiūrint';
$string['requiredentriestoview_help'] = 'Įrašų skaičius, kurį besimokantysis turi pridėti, kad galėtų peržiūrėti kitų besimokančiųjų įrašus.

Tai nesuderinama su duomenų bazės automatinio susiejimo filtru.';
$string['requiredentrieswarning'] = 'Šis nustatymas buvo pakeistas Veiklos užbaigimo nustatymuose "Būtini Įrašai"';
$string['requiredfield'] = 'Privalomas laukas';
$string['resetalltemplates'] = 'Iš naujo nustatyti visus šablonus';
$string['resetalltemplatesconfirm'] = 'Ketinate pašalinti visus dabartinio išankstinių nustatymų rinkinio šablonus. Jei vėliau norėsite atkurti šablonus, skirtuke „Išankstinių nustatymų rinkiniai“ turite iš naujo pasirinkti rinkinį.';
$string['resetalltemplatesconfirmtitle'] = 'Iš naujo nustatyti visus šablonus?';
$string['resetsettings'] = 'Nustatyti filtrus iš naujo';
$string['resettemplate'] = 'Nustatyti dabartinį šabloną iš naujo';
$string['resettemplateconfirm'] = 'Tai visam laikui pašalins dabartinius išankstinius nustatymus {$a}.';
$string['resettemplateconfirmtitle'] = 'Iš naujo nustatyti šabloną?';
$string['resizingimages'] = 'Keičiamas vaizdo miniatiūrų dydis...';
$string['rows'] = 'eilutės';
$string['rssglobaldisabled'] = 'Išjungta. Žr. svetainės konfigūracijos kintamuosius.';
$string['rsstemplate'] = 'RSS šablonas';
$string['rsstitletemplate'] = 'RSS pavadinimo šablonas';
$string['rsstype'] = 'Šios veiklos RSS informacijos santrauka';
$string['save'] = 'Įrašyti';
$string['saveandadd'] = 'Įrašyti ir įtraukti kitą';
$string['saveandview'] = 'Įrašyti ir peržiūrėti';
$string['saveaspreset'] = 'Viešinti išankstinių nustatymų rinkinį šioje svetainėje';
$string['saveaspreset_help'] = 'Įrašymo kaip išankstinių nustatymų rinkinio funkcija publikuoja šablonus ir laukus kaip iš anksto nustatytą rinkinį, kurį gali naudoti kiti svetainės naudotojai. (Galite bet kada jį panaikinti iš išankstinių nustatymų rinkinių sąrašo.)';
$string['saveaspresetmissingcapability'] = 'Naudotojas neturi leidimo išsaugoti duomenų bazės kaip iš išankstinių nustatymų rinkinio.';
$string['savedataaspreset'] = 'Išsaugoti visus laukus ir šablonus ir paskelbti kaip išankstinių nustatymų rinkinį šioje svetainėje';
$string['savesettings'] = 'Įrašyti parametrus';
$string['savesuccess'] = 'Išankstinių nustatymų rinkinys išsaugotas. <a href="{$a->url}">Peržiūrėti išankstinių nustatymų rinkinį</a>';
$string['savetemplate'] = 'Įrašyti šabloną';
$string['search'] = 'Ieškoti';
$string['search:activity'] = 'Duomenų bazė - veiklos informacija';
$string['search:entry'] = 'Duomenų bazė - įrašai';
$string['searchresults'] = 'Įrašai, kuriuose yra „{$a}“';
$string['selectedrequired'] = 'Visi pasirinkti būtini';
$string['selectexportoptions'] = 'Pasirinkite eksporto parinktis';
$string['selectfields'] = 'Pasirinkite laukus';
$string['showall'] = 'Rodyti visus įrašus';
$string['showmore'] = 'Rodyti daugiau';
$string['single'] = 'Peržiūrėti vieną elementą';
$string['singletemplate'] = 'Vieno elemento rodinio šablonas';
$string['singleview'] = 'Įrašo rodinys';
$string['startbuilding'] = 'Pradėkite kurti veiklą';
$string['subplugintype_datafield'] = 'Duomenų bazės srities tipas';
$string['subplugintype_datafield_plural'] = 'Duomenų bazės sričių tipai';
$string['subplugintype_datapreset'] = 'Išankstinių nustatymų rinkinys';
$string['subplugintype_datapreset_plural'] = 'Išankstinių nustatymų rinkiniai';
$string['tagarea_data_records'] = 'Duomenų įrašai';
$string['tags'] = 'Žymės';
$string['tagsdeleted'] = 'Duomenų bazės žymės pašalintos';
$string['teachersandstudents'] = '{$a->teachers} ir {$a->students}';
$string['templatereset'] = 'Šablono nustatymas iš naujo';
$string['templateresetall'] = 'Visi šablonai nustatyti iš naujo';
$string['templates'] = 'Šablonai';
$string['templatesaved'] = 'Šablonas įrašytas';
$string['templatesnavigation'] = 'Šablonų tretinė navigacija';
$string['text'] = 'Tekstas';
$string['textarea'] = 'Teksto sritis';
$string['timeadded'] = 'Įtraukimo laikas';
$string['timemodified'] = 'Keitimo laikas';
$string['todatabase'] = 'šioje duomenų bazėje.';
$string['type'] = 'Lauko tipas';
$string['undefinedprocessactionmethod'] = 'Data_Preset neapibrėžtas joks veiksmų metodas veiksmui {$a} apdoroti.';
$string['unknown'] = 'Nežinomas laukas';
$string['unsupportedfields'] = 'Nepalaikomi laukai';
$string['unsupportedfieldslist'] = 'Negalima eksportuoti šių laukų:';
$string['updatefield'] = 'Naujinti esamą lauką';
$string['uploadfile'] = 'Įkelti failą';
$string['uploadrecords'] = 'Importuoti įrašus';
$string['uploadrecords_help'] = 'Importuokite įrašus, kuriuos eksportavote iš kitos duomenų bazės, naudodami CSV arba ZIP, kuriame yra CSV failas (jei failai įtraukti į eksportą).

Arba norėdami sukurti importui skirtą CSV failą, pridėkite vieną įrašą į duomenų bazę ir tada jį eksportuokite. Redaguokite CSV failą ir pridėkite daugiau įrašų.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'url';
$string['usedate'] = 'Įtraukti į paiešką.';
$string['usepredefinedset'] = 'Naudoti nustatytą rinkinį';
$string['usepreset'] = 'Naudoti šį išankstinių nustatymų rinkinį';
$string['usestandard'] = 'Naudoti išankstinių nustatymų rinkinį';
$string['usestandard_help'] = 'Norėdami naudoti galimą visoje svetainėje išankstinių nustatymų rinkinį, pasirinkite jį iš sąrašo. (Jei išankstinių nustatymų rinkinį į sąrašą įtraukėte naudodami įrašymo kaip išankstinių nustatymų rinkinio funkciją, turite galimybę jį panaikinti.)';
$string['viewfromdate'] = 'Tik skaityti nuo';
$string['viewnavigation'] = 'Tretinės navigacijos peržiūros režimas';
$string['viewtemplates'] = 'Žiūrėti šablonus';
$string['viewtodate'] = 'Tik skaityti iki';
$string['viewtodatevalidation'] = 'Tik skaityti iki data negali būti ankstenė nei tik skaityti nuo data.';
$string['wrongdataid'] = 'Pateiktas neteisingas duomenų ID';
