<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'it', version '4.3'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthefile'] = 'Sul file';
$string['action'] = 'Azione';
$string['actions'] = 'Azioni';
$string['active'] = 'Attivi';
$string['activeprograms'] = 'Programmi attivi';
$string['activeprogramslink'] = '<a href="{$a->href}">Programmi attivi: {$a->count}</a>';
$string['addcourses'] = 'Aggiungi corso';
$string['addcourseslist'] = 'Seleziona corso';
$string['addcourseslist_help'] = 'E\' possibile selezionare uno o più corsi.';
$string['addset'] = 'Aggiungi set';
$string['addsetorcourse'] = 'Aggiungi set o corso';
$string['afterallocationwindowstarts'] = 'Dopo l\'inizio della assegnazione';
$string['afterallocationwindowstartswithrelativedate'] = '{$a} dopo l\'inizio della assegnazione';
$string['afterduedate'] = 'Dopo la data limite';
$string['afterduedatewithrelativedate'] = '{$a} dopo la data limite';
$string['afterstartdate'] = 'Dopo la data di  inizio';
$string['afterstartdatewithrelativedate'] = '{$a} dopo la data di inzio';
$string['afteruserallocationdate'] = 'Dopo la data di assegnazione dell\'utente';
$string['afteruserallocationdatewithrelativedate'] = '{$a} dopo la data di assegnazione dell\'utente';
$string['allinanyorder'] = 'Tutti in qualsiasi ordine';
$string['allinorder'] = 'Tutti in ordine';
$string['allocatetoprogram'] = 'Assegna al programma';
$string['allocateusers'] = 'Assegna utenti';
$string['allocationdate'] = 'Data di assegnazione';
$string['allocationdateonorafter'] = 'Data di assegnazione il o dopo il';
$string['allocationenddate'] = 'Data di fine assegnazione';
$string['allocationenddate_help'] = 'La data di fine assegnazione degli utenti al programma';
$string['allocationfor'] = 'Assegnazioni di \'{$a}\'';
$string['allocationsource'] = 'Fonte dell\'assegnazione';
$string['allocationstartdate'] = 'Data di inizio dell\'assegnazione';
$string['allocationstartdate_help'] = 'Data di inizio assegnazione degli utenti al programma';
$string['allocationwindow'] = 'Finestra di assegnazione';
$string['allocationwindowendedon'] = 'La finestra di assegnazione del programma è finita il {$a}.';
$string['allocationwindowstartson'] = 'La finestra di assegnazione del programma comincia il {$a}.';
$string['allowdirectallocation'] = 'Consenti assegnazione diretta';
$string['allowdirectallocation_help'] = 'Consente l\'assegnazione diretta degli utenti al programma';
$string['archive'] = 'Archivia';
$string['archived'] = 'Archiviati';
$string['archivedconfirmation'] = 'Sei sicuro di archiviare il programma {$a}\'? Il programma archiviato non sarà più disponibile a manager e corsisti e comparirà solamente nei report storici.';
$string['archivedon'] = 'Archiviato il';
$string['archivedprograms'] = 'Programmi archiviati';
$string['assfirstchildof'] = 'Come figlio di "{$a}"';
$string['associatedcertification'] = 'Certificazione associata';
$string['associatedcertifications'] = 'Certificazioni associate';
$string['associatedcertificationswitheditlinks'] = 'Certificazioni associate con link di modifica';
$string['atleast'] = 'Almeno';
$string['autocreategroups'] = 'Aggiungi ai gruppi di corso';
$string['autocreategroups_help'] = 'E\' possibile inserire automaticamente nello stesso gruppo gli utenti iscritti al programma. In ciascun corso verranno creati automaticamente gruppi utilizzando lo sesso nome del programma, Nei corsi condivisi tra tenant, al nome del gruppo verrà aggiunto anche il nome del tenant.';
$string['autocreategroupsnone'] = 'No';
$string['autocreategroupsprogram'] = 'Crea gruppi per il programma';
$string['availability'] = 'Disponibilità';
$string['available'] = 'Disponibile';
$string['baseset'] = 'Set base';
$string['beforeenddate'] = 'Prima della data di fine';
$string['beforeenddatewithrelativedate'] = '{$a} prima della data di fine';
$string['calendar'] = 'Pianificazione';
$string['calendarduedate'] = 'Data limite del programma {$a}';
$string['calendarenddate'] = 'Data di fine del programma {$a}';
$string['certification'] = 'Certificazione';
$string['certificationduedate'] = 'Data limite della certificazione';
$string['certificationmsgactive'] = 'La certificazione <strong>"{$a->fullname}"</strong> deve essere completata entro il <strong>{$a->date}</strong>';
$string['certificationmsgcompleted'] = 'La certificazione <strong>"{$a->fullname}"</strong> è completata';
$string['certificationmsgcompletedexpired'] = 'La certificazione <strong>"{$a->fullname}"</strong> è completata. Scadrà il <strong>{$a->date}</strong>';
$string['certificationmsgduedatenotset'] = 'La certificazione <strong>"{$a->fullname}"</strong> non ha una data limite impostata';
$string['certificationmsgexpired'] = 'La certificazione <strong>"{$a->fullname}"</strong> è scaduta il <strong>{$a->date}</strong>';
$string['certificationmsgoverdue'] = 'La certificazione <strong>"{$a->fullname}"</strong> aveva come data limite il <strong>{$a->date}</strong>';
$string['certifications'] = 'Certificazioni';
$string['close'] = 'Chiudi';
$string['completeallinanyorder'] = 'Completare in qualsiasi ordine';
$string['completeallinorder'] = 'Completare in ordine';
$string['completeatleast'] = 'Completare almeno';
$string['completed'] = 'Completato';
$string['completedprogramslink'] = '<a href="{$a->href}">Programmi completati: {$a->count}</a>';
$string['completion'] = 'Completamento';
$string['completion_help'] = 'Tipi di completamento da applicare al set:

* <strong>Tutti in ordine:</strong> l\'utente deve completare i corsi nella sequenza impostata
* <strong>Tutti in qualsiasi ordine:</strong> l\'utente deve completare i corsi in qualsiasi ordine
* <strong>Almeno X:</strong> l\'utente deve completare almeno X corsi in qualsiasi ordine';
$string['completionatleast'] = 'Completare almeno';
$string['completioncriteria'] = 'Criteri di completamento';
$string['completioncriteriagroup'] = 'Completamento';
$string['completioncriteriagroup_help'] = 'Per favore selezionare un criterio di completamento per questo set';
$string['completiondate'] = 'Data di completamento';
$string['completiondateonorafter'] = 'Data di completamento il o dopo il';
$string['conditionprogramcompleted'] = 'Programma';
$string['conditionprogramcompletedalldescription'] = 'Utenti che hanno lo stato \'Completato\' in tutti i seguenti programmi:
\'{$a->programname}\'';
$string['conditionprogramcompletedalldescriptionwithdate'] = 'Utenti che hanno lo stato \'Completato\' in tutti i seguenti programmi:
\'{$a->programname}\'<br />
Data di completamento il o dopo il  \'{$a->conditiondate}\'';
$string['conditionprogramcompletedanydescription'] = 'Utenti che hanno lo stato \'Completato\' in almeno uno dei seguenti programmi:
\'{$a->programname}\'';
$string['conditionprogramcompletedanydescriptionwithdate'] = 'Utenti che hanno lo stato \'Completato\' in tutti almeno uno dei seguenti programmi:
\'{$a->programname}\'<br />
Data di completamento il o dopo il  \'{$a->conditiondate}\'';
$string['conditionprogramcompleteddescription'] = 'Utenti che hanno lo stato \'Completato\' nel programma \'{$a}\'';
$string['conditionprogramcompleteddescriptionwithdate'] = 'Utenti che hanno lo stato \'Completato\' nel programma \'\'{$a->programname}\'<br />
Data di completamento il o dopo il  \'{$a->conditiondate}\'';
$string['conditionprogramnotcompleted'] = 'Programma non completato';
$string['conditionprogramnotcompleteddescription'] = 'Utenti che non hanno lo stato \'Completato\' nel programma \'{$a}\'';
$string['conditionprogramoverdue'] = 'Programma In ritardo';
$string['conditionprogramoverduedescription'] = 'Utenti che hanno lo stato \'In ritardo\' nel programma \'{$a}\'';
$string['conditionprogramoverduedescriptionwithdate'] = 'Utenti che hanno lo stato \'In ritardo\' nel programma \'{$a->programname}\'<br />
Data limite il o dopo il \'{$a->conditiondate}\'';
$string['conditionprogramsuspended'] = 'Programma sospeso';
$string['conditionprogramsuspendeddescription'] = 'Utenti che hanno lo stato \'Sospeso\' nel programma \'{$a}\'';
$string['conditionprogramsuspendeddescriptionwithdate'] = 'Utenti che hanno lo stato \'Sospeso\' nel programma \'{$a->programname}\'<br />
Data di sospensione il o successiva al \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Utenti assegnati al programma';
$string['conditionuserallocateddescription'] = 'Utenti assegnati al programma \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Utenti assegnati al programma \'{$a->programname}\'<br />
Data di assegnazione il o dopo il';
$string['conditionusernotallocated'] = 'Utenti non assegnati al programma';
$string['conditionusernotallocateddescription'] = 'Utenti non assegnati al programma \'{$a}\'';
$string['confirmdeallocateusers'] = 'L\'azione rimuoverà tutte le assegnazioni e i relativi dati degli utenti selezionati. L\'azione non potrà essere annullata.';
$string['confirmdeallocateusersheader'] = 'Rimuovi assegnazioni degli utenti';
$string['confirmdeletecourse'] = 'Sei sicuro di rimuovere il corso \'{$a}\' dal programma';
$string['confirmdeleteprogram'] = 'Sei sicuro di eliminare il programma \'{$a}\' e i relativi dati relativi? L\'azione non potrà essere annullata.';
$string['confirmdeleteset'] = 'Sei sicuro di eliminare il set  \'{$a}\' e rimuovere i corsi che contiene?';
$string['confirmdeleteuserallocation'] = 'Sei sicuro di rimuovere l\'assegnazione dell\'utente \'{$a}\' e i relativi dati? L\'azione non potrà essere annullata.';
$string['confirmduplicate'] = 'Sarà fatta un copia che includerà il contenuto del programma e la pianificazione ma non includerà gli utenti. Il codice identificativo del programma sarà rimosso.';
$string['confirmrecalculateprogress'] = 'Normalmente se le impostazioni del programma vengono modificate dopo che alcuni studenti hanno già completato il programma, il loro programma rimane nello stato "Completato" anche se non soddisfano più i requisiti di completamento. Questa azione consente di reimpostare e ricalcolare il completamento del programma. Ciò non influirà sui corsi del programma o sulle certificazioni collegate.
<br />Questa azione non potrà essere annullata. Sei sicuro di continuare?';
$string['confirmresetprogress'] = 'Sei sicuro di resettare l\'avanzamento di \'{$a}\'? Questa azione:<br /><br />
<ul>
<li>ripristina il programma</li>
<li>ripristina tutti i corsi all\'interno di questo programma</li>
<li>rimuove tutti i dati di completamento</li>
</ul>
L\'azione richiederà alcuni minuti per essere completata e non potrà essere annullata.';
$string['confirmresetusersprogramusers'] = 'Per tutti gli utenti selezionati, questa azione:<br /><br />
<ul>
<li>ripristina il programma</li>
<li>ripristina tutti i corsi all\'interno di questo programma</li>
<li>rimuove tutti i dati di completamento</li>
</ul>
L\'azione richiederà alcuni minuti per essere completata e non potrà essere annullata.';
$string['containscourse'] = 'Contiene il corso';
$string['content'] = 'Contenuto';
$string['copy'] = 'Copia';
$string['course'] = 'Corso';
$string['coursealreadyinset'] = 'Il corso è già presente nel set';
$string['coursecompletiondisabled'] = 'Il corso non ha abilitato il tracciamento del completamento. Sarà visualizzato nella dashbord ome non completato e in conseguenza di ciò i corsisti non potranno completare il programma.';
$string['coursecriteriadisabled'] = 'In questo corso è abilitato il tracciamento del completamento ma non sono stati configurati criteri.';
$string['courseinformation'] = 'Informazioni sul corso';
$string['coursenotavailable'] = 'Corso non disponibile';
$string['coursesinset'] = 'Corsi nel set (separati da virgola)';
$string['coursesinsetlines'] = 'Corsi nel set (uno per linea)';
$string['coursesinsetlineslinks'] = 'Corsi nel set con collegamenti (uno per linea)';
$string['coursesinsetlinks'] = 'Corsi nel set con collegamenti (separati da virgola)';
$string['criteriaall'] = 'Tutti i programmi selezionati devono risultare completati';
$string['criteriaany'] = 'Almeno uno dei programmi selezionati deve risultare completato';
$string['criteriaany_help'] = 'Se un utente ha già completato un programma, il completamento del secondo programma non attiverà di nuovo l\'azioe';
$string['criteriaeach'] = 'Ogni volta ce un utente completa uno dei programmi selezionati';
$string['criteriaeach_help'] = 'Equivalente alla creazione di più regole, una per ciascuno dei programmi seleioanti';
$string['dateoverriden'] = 'Data sovrascritta';
$string['datetypeabsolute'] = 'Seleziona data';
$string['datetypenone'] = 'Non impostato';
$string['dayssinceallocation'] = 'Giorni dalla assegnazione';
$string['daystakingprogram'] = 'Giorni trascorsi nel programma';
$string['deallocateusers'] = 'Rimuovi assegnazione degli utenti';
$string['default'] = 'Default';
$string['deleteallocation'] = 'Elimina assegnazione';
$string['deleteuserallocation'] = 'Rimuovi assegnazione degli utenti';
$string['description'] = 'Descrizione';
$string['directallocationdisabled'] = 'L’assegnazione diretta degli utenti al programma è disabilitata';
$string['displaycompletedcourses'] = 'Corsi completati nel programma';
$string['displaycompletiondate'] = 'Data di completamento programma';
$string['displayprogramduedate'] = 'Data limite del programma';
$string['displayprogramid'] = 'ID interna del programma utiilzzati negli URL';
$string['displayprogramname'] = 'Nome del programma';
$string['dontchange'] = 'Non cambiare';
$string['duedate'] = 'Data limite';
$string['duedate_help'] = 'La data limite di svolgimento del programma';
$string['duedateonorafter'] = 'Data limite il o dopo il';
$string['duplicate'] = 'Duplica';
$string['dynamic'] = 'Dinamica';
$string['dynamicrules'] = 'Regole dinamiche';
$string['dynamicrulesplugincheck'] = 'La visualizzazione dell\'elenco delle regole dinamiche non è possibile senza il pluign tool_dynamicrule';
$string['dynamicrulewarningdeallocation'] = 'E\' possibile rimuovere le assegnazioni degli utenti solo se sono stati assegnati da un\'altra regola dinamica, le assegnazioni manuali rimarranno inalterate.';
$string['editallocation'] = 'Modifica assegnazione';
$string['editprogramname'] = 'Modifica nome del programma';
$string['editsetname'] = 'Modifica nome del set';
$string['editstatusanddates'] = 'Modifica stati e date';
$string['editstatusanddatesbulk'] = 'Modifica stati e date per più utenti';
$string['enddate'] = 'Data di fine';
$string['enddate_help'] = 'Data di fine del programma';
$string['enrol'] = 'Iscrivi';
$string['enrolled'] = 'Iscritto';
$string['entityprogram'] = 'Programma';
$string['entityprogramcompletion'] = 'Completamento utente';
$string['entityprogramcontent'] = 'Contenuto del programma';
$string['entityprogramitem'] = 'Elemento del programma';
$string['entityprogramusers'] = 'Assegnazione utente';
$string['errorallocationenddatenostartdate'] = 'La data di fine assegnazione non può essere una data relativa se non è impostata la data di inziio';
$string['errorallocationenddatepreviousstartdate'] = 'La data di fine assegnazione non può essere antecedente alla data di inizio';
$string['errorbasesetnotfound'] = 'Il set base non è stato trovato';
$string['errorcannotallocate'] = 'Non è possibile assegnare l\'utente al programma (l\'assegnazione esiste già oppure non è consentita)';
$string['errorcannotresetprogram'] = 'Non è possibile resettare il programma';
$string['errorcantallocateusers'] = 'Non è possibile assegnare utenti';
$string['errorcantcreateset'] = 'Non è possibile creare ilset';
$string['errorcantdeletenotarchivedprogram'] = 'Non è possibile eliminare un programma non archiviato';
$string['errorcantselfenrol'] = 'Non è possibile iscriversi spontaneamente';
$string['errorcertificationnotfound'] = 'La certificazione non è stata trovata';
$string['errorcouldnotallocate'] = 'Non è stato possibile assegnare l\'utente \'{$a->originaluserfullname}\' al programma \'{$a->program}\'';
$string['errorduedatepreviousstartdate'] = 'La data limite non può essere anteriore alla data di inizio';
$string['errorenddatepreviousduedate'] = 'La data di fine non può essere posteriore alla data limite';
$string['errorenddatepreviousstartdate'] = 'La data di fine non può essere antecedente alla data di inizio';
$string['errorhelperactionnotallowed'] = 'Azione helper non consentita';
$string['erroridnumberuniquetenant'] = 'Questo codice identificativo è già stato usato per un altro programma';
$string['errorinvaliddate'] = 'Data non valida';
$string['errorinvalidprogram'] = 'Programma non valido';
$string['errorinvalidprogramitemmove'] = 'Spostamento non valido di un elemento del programma';
$string['errorloadingprogram_mobile'] = 'Errore durante il caricamento del programma';
$string['errormissingenrolprogramplugin'] = 'Il plugin id iscrizione via programma è mancante';
$string['errornopermissionallocateusers'] = 'Non hai privilegi per assegnare utenti al programma';
$string['errornopermissionmanageprograms'] = 'Non hai privilegi per gestire i programmi';
$string['errornopermissionmanageusers'] = 'Non hai privilegi per gestire utenti';
$string['errornopermissionviewallocatedusers'] = 'Non hai privilegi per visualizzare gli utenti asseganti al programma';
$string['errornopermissionviewprograms'] = 'Non hai privilegi per visualizzare programmi';
$string['errornopermissionviewreports'] = 'Non hai privilegi per visualizzare report';
$string['errornostudentsrolefound'] = 'Non sono stati trovati ruoli studente';
$string['errornothingtoexportforprograms'] = 'Non c\'è nulla da esportare per i seguenti programmi condivisi: {$a}';
$string['errorprogramnotfound'] = 'Il programma non è stato trovato';
$string['errorreporttypedoesnotexist'] = 'Il tipo di report non esiste';
$string['errorsameidnumber'] = 'Un programma con lo stesso codice identificativo è già esistente';
$string['errorsomeprogramsdontexist'] = 'Alcuni programmi non esistono';
$string['errorusercantbeallocated'] = 'L\'utente non può essere asseganto';
$string['eventcourseadded'] = 'Aggiunta corso';
$string['eventcourseremoved'] = 'Rimozione corso';
$string['eventcourseupdated'] = 'Aggiornamento corso';
$string['eventprogramcompleted'] = 'Completamento programma';
$string['eventprogramcreated'] = 'Creazione programma';
$string['eventprogramdeleted'] = 'Eliminazione programma';
$string['eventprogramupdated'] = 'Aggiornamento programma';
$string['eventsetcompleted'] = 'Completamento set';
$string['eventsetcreated'] = 'Creazione set';
$string['eventsetdeleted'] = 'Eliminazione set';
$string['eventsetupdated'] = 'Aggiornamento set';
$string['eventuserallocated'] = 'Assegnazione utente';
$string['eventuserdeallocated'] = 'Rimozione assegnazione utente';
$string['eventuserupdated'] = 'Aggiornamento assegnazione utente';
$string['export_content'] = 'Impostazioni';
$string['export_content_help'] = 'Programmi, nomi, descrizioni, date, tag, ecc.';
$string['export_dynamic_rules'] = 'Regole dinamiche';
$string['export_dynamic_rules_help'] = 'Tutte le configurazioni di regole dinamiche per questi programmi.';
$string['export_user_allocations'] = 'Assegnazioni utenti al programma';
$string['export_user_allocations_help'] = 'Include le assegnazioni degli utenti al programma. Una copia degli utenti non sarà inclusa.';
$string['exportonlyallocationspostfix'] = '(solo assegnazioni degli utenti)';
$string['exportprogramsdescription'] = 'Programmi con i relativi corsi, assegnazioni degli utenti e regole dinamiche del componente';
$string['fullprogramreport'] = 'Report completo dei programmi';
$string['futureallocation'] = 'Assegnazioni future';
$string['gotoprogram'] = 'Vai al programma';
$string['hidden'] = 'Nascosto';
$string['hiddenfromlearners'] = 'Nascosto ai corsisiti';
$string['idnumber'] = 'Codice identificativo';
$string['import_content'] = 'Impostazioni';
$string['import_content_help'] = 'Programmi, nomi, descrizioni, date, tag, ecc.';
$string['import_dynamic_rules'] = 'Regole dinamiche';
$string['import_dynamic_rules_help'] = 'Tutte le configurazioni di regole dinamiche di questi programmi.';
$string['import_user_allocations'] = 'Assegnazioni utenti al programma';
$string['import_user_allocations_help'] = 'Include assegnazione utenti a questi programmi.';
$string['importcannotallocate'] = 'Non è possibile assegnare l\'utente \'{$a->originaluserfullname}\' al programma \'{$a->program}\', l\'assegnazione esiste già oppure non è consentita.';
$string['importlogfailed'] = 'Non è stato possibile importare il programma \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Un programma con il codice identificativo {$a->originalidnumber}\' è già esistente';
$string['importlogsuccess'] = 'Creato il programma <a href="{$a->url}">{$a->fullname}</a> contenente {$a->setscount} set e {$a->coursescount} corsi';
$string['importlogsuccessuserallocations'] = 'E\' stato assegnato l\'utente \'{$a->userfullname}\' al programma \'{$a->program}\'';
$string['include_shared_entities'] = 'Includi elementi condivisi';
$string['include_shared_entities_help'] = 'Abilitano l\'impostazione, il file esportato conterrà:

* tutti i programmi condivisi nel tenant corrente
* tutti i corsi dei programmi al di fuori della categoria di corsi del tenant';
$string['inprogress'] = 'In svolgimento';
$string['keepprogramdefaults'] = 'Mantieni i default del program';
$string['lessthanaday'] = 'Meno di un giorno';
$string['locked'] = 'Bloccato';
$string['lockedreasonparent'] = 'Non disponile a meno che: sia disponibile il set {$a}';
$string['lockedreasonpreviouscourse'] = 'Non disponile a meno che: sia stato completato il corso precedente {$a}';
$string['lockedreasonpreviousset'] = 'Non disponile a meno che: sia stato completato il set precedente {$a}';
$string['maincompletion'] = 'Completamento principale';
$string['managedusersoverdue'] = 'Alcuni membri del team hanno programmi in ritardo.';
$string['manual'] = 'Manuale';
$string['mappingerrorprogramnotfound'] = 'Il programma {$a} non è stato trovato';
$string['mappingnoticenoidnumber'] = 'Il programma è stato individuato tramite il nome poiché il codice identificativo non è stato impostato. Si raccomanda di assegnare i codici identificativi ai programmi.';
$string['messageprovider:programcompleted'] = 'Programma completato';
$string['messageprovider:programuserallocated'] = 'Utente assegnato al programma';
$string['messageprovider:programuserdeallocated'] = 'Utente rimosso dall\'assegnazione al programma';
$string['missingcompletion'] = 'Criterio di completamento mancante';
$string['missingcourse'] = 'Corso mancante';
$string['missingfullname'] = 'Nome del programma mancante';
$string['missingprogram'] = 'Programma mancante';
$string['missingsetname'] = 'Nome del set mancante';
$string['name'] = 'Nome';
$string['never'] = 'Mai';
$string['newnameforset'] = 'Nuovo nome di \'{$a}\'';
$string['newprogram'] = 'Nuovo programma';
$string['notarchived'] = 'Non archiviato';
$string['notavailable'] = 'Non disponibile';
$string['notcompleted'] = 'Non completato';
$string['notenrolledprograms_mobile'] = 'Non sei iscritto a nessun programma';
$string['notificationduedate'] = 'Il programma ha come data limite di svolgimento il {$a}<br /><br />';
$string['notificationprogramcompleted'] = 'Gentile {$a->userfullname},<br /><br />
complimenti per aver completato il programma \'{$a->programname}\'!<br /><br />
Se lo desideri, puoi rivedere il programma quando vuoi. Troverai il programma nella pagina \'I Miei corsi\'.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserallocated'] = 'Gentile {$a->userfullname},<br /><br />
Benvenuto nel programma \'{$a->programname}\', che potrai trovare nella pagina \'I Miei corsi\'.<br /><br />
{$a->duedatemsg}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserdeallocated'] = 'Gentile {$a->userfullname},<br /><br />
Il programma \'{$a->programname}\' è ora chiuso e non può più essere acceduto.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationsubjectprogramcompleted'] = 'Complimenti, - \'{$a}\' è completo!';
$string['notificationsubjectprogramuserallocated'] = 'Benvenuto in \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = '\'{$a}\' chiuso';
$string['notset'] = 'Non impostato';
$string['notsuspended'] = 'Non sospeso';
$string['notvisible'] = 'Non visibile';
$string['nousersselected'] = 'Devi selezionare almeno un utente';
$string['numbercoursesinprogramunique'] = 'Numero di corsi (unico)';
$string['numbercoursesinset'] = 'Numero di corsi nel set';
$string['numbercurrentallocatedusers'] = 'Numero di utenti assegnati';
$string['open'] = 'Aperto';
$string['outcomeallocation'] = 'Assegna utenti ai programmi';
$string['outcomeallocationdescdate'] = 'Assegna utenti al programma {$a->programname}<br />
{$a->startdatestr}<br />
Con gli utenti sospesi: {$a->suspendedusers}';
$string['outcomeallocationdesckeepdate'] = 'Rimuovi sospensione e mantieni le date esistenti di inizio e fine programma';
$string['outcomeallocationdesckeepstartdate'] = 'Mantieni la data di inizio di default del programma';
$string['outcomeallocationdescstartdate'] = 'Data di inizio del programma: {$a->startdate}\'';
$string['outcomeallocationdescsuspendchangedate'] = 'Rimuovi sospensione e cambia le date esistenti di inizio e fine programma';
$string['outcomeallocationdontmodify'] = 'Non modificare le assegnazioni';
$string['outcomeallocationsuspendedusers'] = 'Con gli utenti sospesi';
$string['outcomeallocationsuspendedusers_help'] = 'Azione da svolgere quando gli utenti sono già assegnati ma la loro assegnazione è sospesa o terminata.';
$string['outcomeallocationunsuspend'] = 'Rimuovi sospensione, mantieni le date esistenti di inizio e fine programma';
$string['outcomeallocationunsuspendchangedate'] = 'Rimuovi sospensione, modifica le date esistenti di inizio e fine programma';
$string['outcomedeallocate'] = 'Rimuovi assegnazione utenti dal programma';
$string['outcomedeallocatesuspend'] = 'Sospendi assegnazioni esistenti';
$string['outcomedeallocation'] = 'Rimuovi assegnazioni degli utenti ai programmi';
$string['outcomedeallocationdescription'] = 'Rimuovi assegnazioni degli utenti al programma \'{$a}\'';
$string['outcomedeallocationdescriptionsuspend'] = 'Sospensione dell’assegnazione degli utenti al programma \'{$a}\'';
$string['overdue'] = 'In ritardo';
$string['overdueprograms'] = 'Programmi in ritardo';
$string['overdueprogramslink'] = '<a href="{$a->href}">Programmi In ritardo: {$a->count}</a>';
$string['parentname'] = 'Nome del genitore';
$string['pending'] = 'In attesa';
$string['pendingreasonhiddencourse'] = 'Alcuni corsi obbligatori per sbloccare questo corso non sono disponibili. Per favore contattare l’amministratore del sito.';
$string['pendingreasonparent'] = 'Completamento automatico: quando il set {$a} sarà disponibile.';
$string['pendingreasonpreviouscourse'] = 'Completamento automatico: quando il corso precedente {$a} sarà stato completato.';
$string['pendingreasonpreviousset'] = 'Completamento automatico: quando il set precedente {$a} sarà stato completato.';
$string['pluginname'] = 'Programma';
$string['previewprogramname'] = 'Anteprima del nome del programma';
$string['privacy:metadata:core_tag'] = 'Tag aggiunti ai programmi';
$string['privacy:metadata:program_set_completion'] = 'Informazioni sul completamento di un set di un programma';
$string['privacy:metadata:program_set_completion:completeddate'] = 'Data in cui l\'utente ha completato il set';
$string['privacy:metadata:program_set_completion:setid'] = 'Set completato.';
$string['privacy:metadata:program_set_completion:userid'] = 'Utente che ha completato il set';
$string['privacy:metadata:program_users:duedate'] = 'Data limite del programma';
$string['program:allocateuser'] = 'Assegna utenti ai programmi';
$string['program:configurecustomfields'] = 'Configurazione campi personalizzati del programma';
$string['program:coursereset'] = 'Reset dei corsi dei programmi';
$string['program:edit'] = 'Modifica programmi';
$string['programdescription'] = 'Descrizione del programma';
$string['programdescription_help'] = 'La descrizione del programma sarà visualizzata nelle informazioni e nella pagina di copertina del programma';
$string['programduedate'] = 'Data limite del programma';
$string['programfullname'] = 'Nome del programma';
$string['programfullname_help'] = 'Il nome del programma sarà visualizzato nella pagina dell\'elenco dei corsi';
$string['programidnumber'] = 'Codice identificativo del programma';
$string['programidnumber_help'] = 'Il codice identificativo di un programma verrà utilizzato solamente per corrispondenza con dati di sistemi esterni e non sarà visualizzato all\'interno del  sito. E\' possibile utilizzare il codice identificativo ufficiale, in mancanza può essere lasciato vuoto.';
$string['programimage'] = 'Immagine del programma';
$string['programimage_help'] = 'L\'immagine del programma sarà visualizzata nella pagina dell\'elenco dei corsi';
$string['programinformation'] = 'Informazioni sul programma';
$string['programname'] = 'Nome del programma';
$string['programnamewitheditlink'] = 'Nome del programma con link di modifica';
$string['programnamewithimage'] = 'Nome del programma con immagine';
$string['programnamewithimageandeditlink'] = 'Nome del programma con immagine e link di modifica';
$string['programnamewithimageandviewlink'] = 'Nome del programma con immagine e link di visualizzazione';
$string['programnamewithviewlink'] = 'Nome del programma con link di visualizzazione';
$string['programparentsetname'] = 'Nome del set genitore';
$string['programprogress'] = 'Avanzamento programma';
$string['programprogressexport'] = 'Avanzamento del programma {$a}';
$string['programprogresswithreportlinks'] = 'Avanzamento programma con link ai report';
$string['programreset'] = 'Reset programma';
$string['programrules'] = 'Regole del programma';
$string['programs'] = 'Programmi';
$string['programscustomfield'] = 'Campi personalizzati dei progammi';
$string['programsetname'] = 'Nome del set';
$string['programsoverview_mobile'] = 'Panoramica programmi';
$string['programstatus'] = 'Stato del programma';
$string['programtags'] = 'Tag del programma';
$string['programtags_help'] = 'Tag del programma';
$string['programtenant'] = 'Tenant del programma';
$string['programuserallocations'] = 'Assegnazioni utenti al programma';
$string['programvisibility'] = 'Visibilità del programma';
$string['programvisibility_help'] = 'Imposta la visibilità del programma nell\'elenco dei corsi dell\'utente';
$string['progress'] = '{$a} completato';
$string['progressoverview'] = 'Panoramica avanzamento';
$string['progressoverviewfor'] = 'Panoramica avanzamento di {$a}';
$string['progresspercent'] = 'Avanzamento';
$string['progressreport'] = 'Report  dell\'avanzamento';
$string['recalculateprogramcompletion'] = 'Ricalcola completamento programmi';
$string['recalculateprogramcompletion_help'] = 'Il completamento del programma verrà ricalcolato per tutti gli utenti assegnati. Tenere presente che se un utente ha completato il programma e al programma sono stati aggiunti nuovi contenuti, l\'utente potrebbe dover completare nuovamente il programma. Questa azione può richiedere alcuni minuti per essere completata e non potrà essere annullata.';
$string['reg_wpprograms'] = 'Numero di programmi ({$a})';
$string['reportprogramsallocationcompletion'] = 'Assegnazioni utenti ai programmi e completamenti';
$string['reset'] = 'Reset';
$string['resetprogress'] = 'Resetta programma';
$string['resetusersprogram'] = 'Resetta programma degli utenti';
$string['restore'] = 'Ripristina';
$string['review'] = 'Rivedi';
$string['rolemanager'] = 'Manager di programma';
$string['rolemanagerdescription'] = 'Nel proprio tenant, può di creare e gestire programmi  e assegnarvi utenti';
$string['scheduleupdatesuccess'] = 'Pianificazione aggiornata correttamente';
$string['seecontent_mobile'] = 'Visualizza contenuto';
$string['selectactiveandarchivedprograms'] = 'Seleziona tutti i programmi attivi ed archiviati';
$string['selectallactiveprograms'] = 'Seleziona tutti i programmi attivi';
$string['selectallprogramsinthisfile'] = 'Seleziona tutti i report in questo file';
$string['selectatleastoneprogram'] = 'Seleziona almeno un programma';
$string['selectcourses'] = 'Seleziona corsi';
$string['selectmanually'] = 'Seleziona manualmente...';
$string['selectprogramcondition'] = 'Programma';
$string['selectprogramcondition_help'] = 'Selezionare un programma da associare a questa condizione';
$string['selectprogramoutcome'] = 'Programma';
$string['selectprogramoutcome_help'] = 'Selezionare un programma da associare a questa azione';
$string['selectprogramstoallocate'] = 'Programmi';
$string['selectprogramstoallocate_help'] = 'Seleziona i programmi dove sarà assegnato l\'utente';
$string['separatetenantsingroupswarning'] = 'Nei corsi condivisi tra tenant, gli utenti di ciascun tenant saranno aggiunti a gruppi separati.';
$string['set'] = 'Set';
$string['setname'] = 'Nome';
$string['setname_help'] = 'E\' necessario impostare un nome del set';
$string['setofcourses'] = 'Set di corsi';
$string['setsandcoursesnotfound_mobile'] = 'Non sono stati trovati set o corsi';
$string['startdate'] = 'Data di inizio';
$string['startdate_help'] = 'La data di inizio del programma';
$string['status'] = 'Stato';
$string['status_help'] = 'Lo stato sospeso nasconderà il programma alla vista degli utenti.';
$string['suspended'] = 'Sospeso';
$string['suspendeddateonorafter'] = 'Sospeso il o dopo il';
$string['tagarea_tool_program'] = 'Programmi';
$string['tags'] = 'Tag';
$string['timecreated'] = 'Creato il';
$string['timemodified'] = 'Ultima modifica il';
$string['timesuspended'] = 'Sospeso il';
$string['toomanyprogramstoshow'] = 'Ci sono troppi programmi da visualizzare';
$string['type'] = 'Tipo';
$string['userduedate'] = 'Data limite';
$string['userduedate_help'] = 'Selezionare la data limite di svolgimento per l\'utente.';
$string['userenddate'] = 'Data di fine';
$string['userenddate_help'] = 'Selezionare la data dopo la quale il programma non sarà più visibile agli utenti.';
$string['userlist'] = 'Seleziona utenti';
$string['userlist_help'] = 'Selezionare gli utenti da assegnare al programma';
$string['users'] = 'Utenti';
$string['usersallocatedsuccess'] = '{$a} assegnazioni utente create correttamente';
$string['usersallocationnotavailable'] = 'L\'assegnazione degli utenti non è disponibile';
$string['usersdeallocatedsuccess'] = '{$a} utenti rimossi correttamente dall\'assegnazione';
$string['userseditedsuccess'] = '{$a} utenti modificati correttamente';
$string['usersrecalculationcompletion'] = 'Il completamento del programma è stato ricalcolato per {$a} utenti';
$string['usersresetprogramsuccess'] = 'Il programma è stato resettato per i seguenti utenti: {$a}';
$string['usersskipped'] = '{$a} utenti saltati poiché questa opzione non è disponibile per loro';
$string['userstartdate'] = 'Data di inizio';
$string['userstartdate_help'] = 'Selezionare la data nella quale l\'utente dovrà iniziare il programma. Tale data avrà valenza solo per questo utente.';
$string['visible'] = 'Visibile';
$string['warningcourseinvisible'] = 'Attenzione: il corso non è visibile agli studenti';
