<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'it', version '4.3'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Azione';
$string['actionsmenu'] = 'Menu azioni';
$string['add'] = 'Inserisci';
$string['addcomment'] = 'Aggiungi un commento';
$string['addedby'] = 'Aggiunto da';
$string['addentries'] = 'Aggiungi record';
$string['addtemplate'] = 'Modello Aggiunta/Modifica record';
$string['advancedsearch'] = 'Ricerca avanzata';
$string['allowcomments'] = 'Commenti alle voci';
$string['alttext'] = 'Testo alternativo';
$string['approvalstatus'] = 'Stato approvazione';
$string['approve'] = 'Approva';
$string['approved'] = 'Approvato';
$string['areacontent'] = 'Campi';
$string['ascending'] = 'Crescente';
$string['asearchtemplate'] = 'Modello Ricerca avanzata';
$string['atmaxentry'] = 'È stato inserito il massimo numero di record consentito!';
$string['authorfirstname'] = 'Nome';
$string['authorlastname'] = 'Cognome';
$string['autogenallforms'] = 'Genera modelli di default';
$string['autolinkurl'] = 'Collega automaticamente la URL';
$string['availablefromdate'] = 'Disponibile dal';
$string['availabletags'] = 'Tag disponibili';
$string['availabletags_help'] = 'I Tag sono segna posto da utilizzare nei Modelli di visualizzazione: all\'atto della visualizzazione o dell\'inserimento di un record, i Tag saranno sostituiti dal contenuto del campo o da un pulsante di comando.

I campi hanno il formato [[fieldname]], tutti gli atri tag hanno il formato ##sometag##.

È possibile usare solo i tag presenti nell\'elenco "Tag disponibili".';
$string['availabletodate'] = 'Fino al';
$string['availabletodatevalidation'] = 'La data di disponibilità \'Fino al\' non può essere antecedente dalla dati di disponibilità \'Dal\'.';
$string['blank'] = 'Vuoto';
$string['buttons'] = 'Azioni';
$string['bynameondate'] = 'di {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} chiude';
$string['calendarstart'] = '{$a} apre';
$string['cancel'] = 'Annulla';
$string['cannotaccesspresentsother'] = 'Non sei autorizzato ad accedere ali preset di altri utenti';
$string['cannotadd'] = 'Impossibile aggiungere record!';
$string['cannotapplypreset'] = 'Si è verificato un errore durante l’applicazione del preset.';
$string['cannotdeletepreset'] = 'Si è verificato u errore durante l\'eliminazione di un preset.';
$string['cannotoverwritepreset'] = 'Si è verificato un errore durante la sovrascrittura dei preset';
$string['cannotunziptopreset'] = 'Non è stato possibile decomprimere nella cartella dei preset';
$string['checkbox'] = 'Caselle di spunta';
$string['chooseexportfields'] = 'Seleziona i campi da esportare:';
$string['chooseexportformat'] = 'Seleziona il formato di esportazione:';
$string['chooseorupload'] = 'Scegli un file';
$string['choosepreset'] = 'File del preset';
$string['closebeforeopen'] = 'La data di aperture è antecedente alla data di chiusura';
$string['columns'] = 'colonne';
$string['comment'] = 'Commento';
$string['commentdeleted'] = 'Il commento è stato eliminato';
$string['commentempty'] = 'Il commento era vuoto';
$string['comments'] = 'Commenti ai record';
$string['commentsaved'] = 'Il commento è stato salvato';
$string['commentsn'] = '{$a} commento(i)';
$string['commentsoff'] = 'I commenti non sono abilitati';
$string['completiondetail:entries'] = 'Inserire record: {$a}';
$string['completionentries'] = 'Record  richiesti';
$string['completionentriescount'] = 'Aggiungi record';
$string['completionentriesdesc'] = 'Numero minimo di record da inserire: {$a}';
$string['configenablerssfeeds'] = 'Questa impostazione consente di generare feed RSS dalle attività Database. Per generare il feed RSS, sarà poi necessario abilitare manualmente l\'impostazione in ciascuna attività Database.';
$string['confirmdeletefield'] = 'Stai per eliminare questo campo. Sei sicuro?';
$string['confirmdeleterecord'] = 'Stai per eliminare questo record. Ne sei certo?';
$string['confirmdeleterecords'] = 'Sei certo di eliminare questi record ?';
$string['createactivity'] = 'È possibile creare campi per raccogliere dati oppure utilizzare un preset con campi già pronti.';
$string['createfields'] = 'È possibile creare campi per raccogliere dati di vario tipo.';
$string['createtemplates'] = 'È possibile creare campi per generare un modello oppure importare un preset contenente campi e modelli già pronti.';
$string['csstemplate'] = 'CSS personalizzato';
$string['csvfailed'] = 'Non è possibile leggere i dati grezzi dal file CSV';
$string['csvfile'] = 'File CSV o File ZIP contenente un CSV';
$string['csvimport'] = 'Importa un file CSV';
$string['csvimport_help'] = 'I record possono essere importati tramite un file di testo che abbia il nome del campo come intestazione di colonna ed un record per riga.';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Aggiungere attività database';
$string['data:approve'] = 'Approvare i record in attesa o disapprovare record già approvati';
$string['data:comment'] = 'Scrivere i commenti';
$string['data:exportallentries'] = 'Esportare tutti i record del database';
$string['data:exportentry'] = 'Esportare un record del database';
$string['data:exportownentry'] = 'Esportare propri record del database';
$string['data:exportuserinfo'] = 'Esportare dettagli utente';
$string['data:managecomments'] = 'Gestire commenti';
$string['data:manageentries'] = 'Gestire i record inseriti';
$string['data:managetemplates'] = 'Gestire i Modelli';
$string['data:manageuserpresets'] = 'Gestire preset';
$string['data:rate'] = 'Valutare i record inseriti';
$string['data:readentry'] = 'Accedere ai record inseriti';
$string['data:view'] = 'Visualizzare attività database';
$string['data:viewallratings'] = 'Visualizzare i voti grezzi dati da ciascuno';
$string['data:viewalluserpresets'] = 'Visualizzare preset di altri utenti';
$string['data:viewanyrating'] = 'Visualizzare totale delle valutazioni di chiunque';
$string['data:viewentry'] = 'Visualizzare i record inseriti';
$string['data:viewrating'] = 'Visualizzare totale delle proprie valutazioni';
$string['data:writeentry'] = 'Inserire un record';
$string['date'] = 'Data';
$string['dateentered'] = 'Data di inserimento';
$string['datemodified'] = 'Ultima modifica:';
$string['defaultfielddelimiter'] = '(di default la virgola)';
$string['defaultfieldenclosure'] = '(di default nessun carattere)';
$string['defaultsortfield'] = 'Campo di default per l\'ordinamento';
$string['delcheck'] = 'Casella di spunta per l\'eliminazione di massa';
$string['delete'] = 'Elimina';
$string['deleteallentries'] = 'Elimina tutti i record';
$string['deletecomment'] = 'Sei certo di voler eliminare questo commento?';
$string['deleteconfirm'] = 'Eliminare il preset {$a}?';
$string['deleted'] = 'è stato eliminato';
$string['deleteentry'] = 'Elimina record';
$string['deletefield'] = 'Elimina campo';
$string['deletenotenrolled'] = 'Elimina i record degli utenti non iscritti';
$string['deletewarning'] = 'Stai per eliminare questo preset. Sei sicuro?';
$string['descending'] = 'Decrescente';
$string['directorynotapreset'] = '{$a->directory} Non è un preset: file mancanti: {$a->missing_files}';
$string['disapprove'] = 'Disapprova';
$string['download'] = 'Scarica';
$string['edit'] = 'Modifica';
$string['editcomment'] = 'Modifica commento';
$string['editentry'] = 'Modifica record';
$string['editfield'] = 'Modifica campo';
$string['editordisable'] = 'Disabilita editor';
$string['editorenable'] = 'Abilita editor di codice';
$string['editpreset'] = 'Modifica preset';
$string['emptyadd'] = 'Il Modello di visualizzazione "Inserisci" non è stato impostato. Ne sto generando uno di default...';
$string['emptyaddform'] = 'Non hai riempito nessun campo!';
$string['emptypresetname'] = 'Il nome del preset o del file non possono essere vuoti.';
$string['enabletemplateeditorcheck'] = 'Sei sicuro di abilitare l\'editor? Al salvataggio del modello il contenuto potrà essere alterato.';
$string['entries'] = 'Record';
$string['entrieslefttoadd'] = 'Per per completare l’attività è necessario è necessario inserire altri {$a->entriesleft} record.';
$string['entrieslefttoaddtoview'] = 'Devi aggiungere {$a->entrieslefttoview} altri record prima di poter vedere i record degli altri partecipanti.';
$string['entry'] = 'Record';
$string['entrysaved'] = 'Il record è stato salvato';
$string['errordatafilenotfound'] = 'Non è stato possibile importare il file. I file consentiti sono file CSV o File ZIP contenente un CSV, formattati come nelle esportazioni.';
$string['errormustbeteacher'] = 'Devi avere il ruolo di docente per utilizzare questa pagina!';
$string['errormustsupplyvalue'] = 'Devi inserire un valore.';
$string['errorpresetexists'] = 'Esiste già un preset con questo nome.';
$string['errorpresetexistsbutnotoverwrite'] = 'Esiste già un preset con questo nome. Utilizzare un nome diverso.';
$string['errorpresetnotfound'] = 'Il preset di nome {$a} non è stato trovato.';
$string['eventfieldcreated'] = 'Creazione campo';
$string['eventfielddeleted'] = 'Eliminazione campo';
$string['eventfieldupdated'] = 'Aggiornamento campo';
$string['eventrecordcreated'] = 'Creazione record';
$string['eventrecorddeleted'] = 'Eliminazione record';
$string['eventrecordupdated'] = 'Aggiornamento record';
$string['eventtemplateupdated'] = 'Aggiornamento modello';
$string['eventtemplateviewed'] = 'Visualizzazione modello';
$string['example'] = 'Esempio di modulo Database';
$string['excel'] = 'Excel';
$string['expired'] = 'Spiacente, l\'attività non è più disponibile poiché è stata chiusa il {$a} ';
$string['export'] = 'Esporta';
$string['exportaszip'] = 'Esporta come .zip';
$string['exportaszip_help'] = 'L\'esportazione come .zip consente di scaricare i preset. I preset possono essere caricati ed utilizzate in altri corsi.';
$string['exportedtozip'] = 'Preimpostazione esportata su un file .zip temporaneo';
$string['exportentries'] = 'Esporta contenuti';
$string['exportformat'] = 'Formato di esportazione';
$string['exportoptions'] = 'Opzioni di esportazione';
$string['exportownentries'] = 'Esportare solo i tuoi record? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Esporta preset';
$string['failedpresetdelete'] = 'Si è verificato un errore durante l\'eliminazione di un preset.';
$string['fieldadded'] = 'Il campo è stato aggiunto.';
$string['fieldallowautolink'] = 'Consenti il collegamento automatico del campo';
$string['fielddeleted'] = 'Campo eliminato';
$string['fielddelimiter'] = 'Separatore di campo';
$string['fielddescription'] = 'Descrizione';
$string['fieldenclosure'] = 'Delimitatore di campo';
$string['fieldheight'] = 'Altezza';
$string['fieldheightlistview'] = 'Altezza (in pixel) nella visualizzazione Elenco';
$string['fieldheightsingleview'] = 'Altezza (in pixel) nella visualizzazione Dettagli.';
$string['fieldids'] = 'Id del campo';
$string['fieldmappings'] = 'Mappatura dei campi';
$string['fieldmappings_help'] = 'Questo menu consente di mantenere i dati del database mappandoli nei campi del preset scelto. Per mantenere i dati contenuti in un campo, è necessario mapparlo in un campo del peset. I campi del preset possono anche essere lasciati vuoti. I campi non mappati in un nuovo campo non saranno conservati ed i dati saranno perduti.
È possibile mappare campi tra loro solo se appartengono allo stesso tipo, pertanto ogni menu a discesa potrà visualizzare campi con nomi diversi. Si deve anche evitare di mappare un campo su più di un campo del preset.';
$string['fieldname'] = 'Nome del campo';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'I seguenti campi presenti nel tuo file non sono noti in questo database: {$a}';
$string['fieldoptions'] = 'Opzioni (scrivete una sola opzione per ciascuna riga)';
$string['fields'] = 'Campi';
$string['fieldshelp'] = 'È possibile creare campi per raccogliere diversi tipi di dati o personalizzare i campi creati tramite un preset.';
$string['fieldsinformationtags'] = 'Informazioni del campo';
$string['fieldsnavigation'] = 'Navigazione terziaria dei campi';
$string['fieldtagdescription'] = 'Descrizione {$a}';
$string['fieldtagid'] = 'ID {$a}';
$string['fieldtagname'] = 'Nome {$a}';
$string['fieldupdated'] = 'Il campo è stato aggiornato';
$string['fieldwidth'] = 'Larghezza';
$string['fieldwidthlistview'] = 'Larghezza nella visualizzazione Elenco.';
$string['fieldwidthsingleview'] = 'Larghezza nella visualizzazione Dettagli.';
$string['file'] = 'File';
$string['fileencoding'] = 'Codifica';
$string['filesnotgenerated'] = 'Non tutti i file sono stati generati: {$a}';
$string['filtername'] = 'Auto collegamento al Database';
$string['footer'] = 'Piè di pagina';
$string['forcelinkname'] = 'Nome forzato del link';
$string['foundnorecords'] = 'Non è stato trovato nessun record. <a href="{$a->reseturl}">Reset filtri</a>';
$string['foundrecords'] = 'Record trovati: {$a->num}/{$a->max}. <a href="{$a->reseturl}">Reset filtri</a>';
$string['fromfile'] = 'Importa da file .zip';
$string['fromfile_help'] = 'È possibile caricare un file in formato .zip contenente un preset del Database.';
$string['generateerror'] = 'Non tutti i file sono stati generati!';
$string['header'] = 'Intestazione';
$string['headeraddtemplate'] = 'Impostazione dell\'interfaccia di inserimento o modifica dei record.';
$string['headerasearchtemplate'] = 'Impostazione dell\'interfaccia della Ricerca avanzata.';
$string['headercsstemplate'] = 'Foglio di stile CSS da associare ai Modelli di visualizzazione.';
$string['headerjstemplate'] = 'Codice Javascript da usare nei Modelli di visualizzazione.';
$string['headerlisttemplate'] = 'Impostazione dell\'interfaccia per la visualizzazione Elenco.';
$string['headerrsstemplate'] = 'Impostazione della visualizzazione dei record nel feed RSS.';
$string['headersingletemplate'] = 'Impostazione dell\'interfaccia per la visualizzazione Dettagli.';
$string['id'] = 'ID record';
$string['importandapply'] = 'Importa un preset ed applicalo';
$string['importapreset'] = 'Importa un preset';
$string['importentries'] = 'Importa contenuti';
$string['importpreset'] = 'Importa preset';
$string['importpreset_desc'] = 'Il preset sarà applicato all\'attività e creerà campi e modelli. Il preset non apparirà nell\'elenco dei preset.';
$string['importpresetmissingcapability'] = 'Non sei autorizzato ad importare preset.';
$string['importsuccess'] = 'Il preset è stato applicato.';
$string['includeapproval'] = 'Includi stato di approvazione';
$string['includefiles'] = 'Includi file nell\'esportazione';
$string['includetags'] = 'Includi tag';
$string['includetime'] = 'Includi data di inserimento/modifica';
$string['includeuserdetails'] = 'Includi dettagli utente';
$string['indicator:cognitivedepth'] = 'Database cognitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività Database.';
$string['indicator:cognitivedepthdef'] = 'Database cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento cognitivo offerto dalle attività Database (Livelli: Nessuna visualizzazione, Visualizzazione, Invio)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Database sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività Database.';
$string['indicator:socialbreadthdef'] = 'Database sociale';
$string['indicator:socialbreadthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento sociale offerto dall\'attività Database (Livelli: Nessuna partecipazione, Partecipazione da solo)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'è necessario inserire un maggior numero di record prima di poter visualizzare questo Database';
$string['intro'] = 'Descrizione';
$string['invalidaccess'] = 'Questa pagina non è stata acceduta correttamente';
$string['invalidfieldid'] = 'L\'ID di campo non è valido';
$string['invalidfieldname'] = 'Si prega di scegliere un nome diverso per questo campo';
$string['invalidfieldtype'] = 'Tipo campo non valido';
$string['invalidid'] = 'ID non valido';
$string['invalidpreset'] = '{$a} non è un preset';
$string['invalidrecord'] = 'Record non valido';
$string['invalidurl'] = 'L\'URL inserito non è valido';
$string['jstemplate'] = 'JavaScript personalizzato';
$string['latitude'] = 'Latitudine';
$string['latlong'] = 'Coordinate geografiche';
$string['latlongboth'] = 'Devi compilare sia la latitudine sia la longitudine.';
$string['latlongdownloadallhint'] = 'Link per scaricare tutti i record in formato KML';
$string['latlongkmllabelling'] = 'Il modo con cui desideri etichettare gli elementi nei file in formato KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Servizio Link-Out da visualizzare';
$string['latlongotherfields'] = 'Altri campi';
$string['list'] = 'Elenco';
$string['listtemplate'] = 'Modello Elenco';
$string['listview'] = 'Vista elenco';
$string['longitude'] = 'Longitudine';
$string['manageapproved'] = 'Consenti modifica di record approvati';
$string['manageapproved_help'] = 'Dopo l\'approvazione, gli studenti potranno modificare o eliminare i record. I record modificati dovranno essere approvati nuovamente.';
$string['managefields'] = 'Gestione campi';
$string['mapexistingfield'] = 'Mappa in {$a}';
$string['mapnewfield'] = 'Crea un campo';
$string['mapping:applypresets'] = 'Applica preset';
$string['mapping:dialogtitle:usepreset'] = 'Applicare il preset {$a}?';
$string['mapping:fieldstocreate'] = 'Campi da creare: {$a}';
$string['mapping:fieldstodelete'] = 'Campi esistenti da eliminare: {$a}';
$string['mapping:mapfields'] = 'Mappatura campi';
$string['mapping:warningmessagedelete'] = 'Se i campi da eliminare sono dello stesso tipo dei nuovi campi del preset, sarà possibile mapparli tramite la Mappatura campi.';
$string['mapping:warningmessagedeleteandcreate'] = 'Se i campi da eliminare sono dello stesso tipo dei campi da creare, sarà possibile mapparli tramite la Mappatura campi.';
$string['mappingwarning'] = 'I campi che non saranno mappati in un nuovo campo saranno omessi ed i rispettivi dati saranno perduti.';
$string['maxentries'] = 'Numero massimo di record inseribili';
$string['maxentries_help'] = 'Il numero massimo di record inseribili nel Database da parte di un singolo utente.';
$string['maxsize'] = 'Dimensione massima';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Scegli...';
$string['missingdata'] = 'La id dei dati o l\'oggetto devono essere forniti alla classe dei campi.';
$string['missingfield'] = 'Errore di programamzione: è necessario specificare il campo e/o i dati quando si definisce un classe di campi.';
$string['missingfieldtype'] = 'Il tipo di campo di {$a->name} non è stato trovato';
$string['missingfieldtypeimport'] = 'I seguenti campi non sono stati importati poiché non sono stati installati i corrispondenti tipi di campo.';
$string['missingfieldtypes'] = 'I seguenti campi sono di un tipo che non corrisponde ai tipi di campi installati, pertanto non saranno inclusi nella scheda di inserimento record.
Si raccomanda di aggiornare di conseguenza il modello di Inserimento record.';
$string['modulename'] = 'Database';
$string['modulename_help'] = 'Il modulo attività Database consente ai partecipanti di creare, gestire e ricercare insiemi di record.

Il formato e la struttura dei record è impostato liberamente dal docente e può includere caselle di spunta, pulsanti radio, menu a discesa, immagini, file, URL, numeri, testi, eccetera.

Un docente può commentare e valutare i record inseriti. È anche possibile permettere agli studenti di valutare (valutazione tra pari). Le valutazioni possono essere aggregate in una valutazione finale che sarà memorizzata nel registro delle valutazioni.

Nel caso in cui il filtro \'Collegamento automatico ai campi del database\' sia attivo, verrà creato un link tutte le volte che il contenuto di un campo comparirà nei testi del corso.

È possibile usare l\'attività Database per:

* creare una collezione collaborativa di link web, libri, recensioni, articoli, eccetera
* visualizzare lavori degli studenti (fotografie, poster, siti web, eccetera) per la valutazione tra pari';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Database';
$string['more'] = 'Dettagli';
$string['moreurl'] = 'Altri URL';
$string['movezipfailed'] = 'Impossibile spostare il .zip';
$string['multientry'] = 'Elemento ripetuto';
$string['multimenu'] = 'Menu (Selezione multipla)';
$string['multipletags'] = 'Sono state trovati Tag duplicati. Il Modello di visualizzazione non è stato salvato';
$string['newentry'] = 'Nuovo record';
$string['newfield'] = 'Aggiungi un campo';
$string['newfield_help'] = 'Un campo consente l\'inserimento di dati. Un record può essere composto da più campi di diversi tipi come ad esempio una data, un\'immagine, caselle di spunta, eccetera.

Ciascun campo deve avere un nome univoco. La descrizione del campo è facoltativa.';
$string['noaccess'] = 'Non sei autorizzato ad accedere a questa pagina';
$string['nodefinedfields'] = 'Il nuovo preset non contiene definizioni di campi.';
$string['nofieldcontent'] = 'Il contenuto del campo non è stato trovato';
$string['nofieldindatabase'] = 'Il Database non ha campi.';
$string['nofields'] = 'Non è stato creato nessun campo';
$string['nolisttemplate'] = 'Il Modello di visualizzazione Elenco non è stata ancora impostato';
$string['nomatch'] = 'Non è stato trovato nessun record che corrisponda!';
$string['nomaximum'] = 'Senza limite massimo';
$string['nopreviewavailable'] = 'Nessuna anteprima disponibile per {$a}';
$string['norecords'] = 'Nessun record presente';
$string['nosingletemplate'] = 'Il modello di visualizzazione Singola non è stato ancora impostato';
$string['notapproved'] = 'In attesa di approvazione';
$string['notapprovederror'] = 'Il record non è stato ancora approvato.';
$string['notemplates'] = 'Non ci sono ancora modelli';
$string['notinjectivemap'] = 'Non è una mappa \'injective\'';
$string['notopenyet'] = 'Spiacente, questa attività non sarà disponibile prima del {$a}';
$string['number'] = 'Numero';
$string['numberrssarticles'] = 'Numero di record da visualizzare nel feed RSS';
$string['numnotapproved'] = 'In attesa di approvazione';
$string['numrecords'] = '{$a} record';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'La data di chiusura è successiva alla data di apertura';
$string['optionaldescription'] = 'Descrizione abbreviata (opzionale)';
$string['optionalfilename'] = 'Nome del file (opzionale)';
$string['other'] = 'Altro';
$string['otherfields'] = 'Tutti gli altri campi';
$string['overrwritedesc'] = 'Sostituisci il preset con questo nome sovrascrivendo il contenuto';
$string['overwrite'] = 'Sovrascrivi';
$string['overwritesettings'] = 'Sovrascrivi le impostazioni attuali (commenti, valutazioni, ecc.)';
$string['page-mod-data-x'] = 'Qualsiasi pagina con modulo database';
$string['pagesize'] = 'Record per pagina';
$string['participants'] = 'Sono autorizzati ad inserire record';
$string['picture'] = 'Immagine';
$string['pleaseaddsome'] = 'Puoi aggiungere campi al Database tramite il menu sottostante. Se preferisci, puoi usare degli <a href="{$a}">insiemi di campi preimpostati</a>.';
$string['pluginadministration'] = 'Gestione Attività Database';
$string['pluginname'] = 'Database';
$string['portfolionotfile'] = 'Esporta in un portfolio invece che in un file (solo csv e leap2a)';
$string['presetdeleted'] = 'Preset eliminato.';
$string['presetinfo'] = 'Salvando il preset si pubblicherà anche questo Modello di visualizzazione. Qualsiasi utente potrà utilizzarlo per il proprio Database.';
$string['presetnotselected'] = 'Non sono stati selezionate preset.';
$string['presets'] = 'Preset';
$string['presetshelp'] = 'Selezionare un preset da utilizzare come punto di inzio.';
$string['preview'] = 'Anteprima di {$a}';
$string['previewaction'] = 'Anteprima';
$string['privacy:metadata:commentpurpose'] = 'Commenti ai record del database';
$string['privacy:metadata:data_content'] = 'Contenuto di un campo';
$string['privacy:metadata:data_content:content'] = 'Contenuto';
$string['privacy:metadata:data_content:content1'] = 'Contenuto aggiuntivo 1';
$string['privacy:metadata:data_content:content2'] = 'Contenuto aggiuntivo 2';
$string['privacy:metadata:data_content:content3'] = 'Contenuto aggiuntivo 3';
$string['privacy:metadata:data_content:content4'] = 'Contenuto aggiuntivo 4';
$string['privacy:metadata:data_content:fieldid'] = 'ID della definizione del campo.';
$string['privacy:metadata:data_records'] = 'Record dell\'attività del database';
$string['privacy:metadata:data_records:approved'] = 'Stato dell\'approvazione';
$string['privacy:metadata:data_records:groupid'] = 'Gruppo';
$string['privacy:metadata:data_records:timecreated'] = 'Orario di creazione del record';
$string['privacy:metadata:data_records:timemodified'] = 'Orario di modifica più recente del record';
$string['privacy:metadata:data_records:userid'] = 'Orario di creazione del record';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Campi del modulo attività del database.';
$string['privacy:metadata:filepurpose'] = 'File allegato al record del database';
$string['privacy:metadata:ratingpurpose'] = 'Valutazioni del record del database';
$string['privacy:metadata:tagpurpose'] = 'Tag del record del database';
$string['radiobutton'] = 'Pulsante radio';
$string['recordapproved'] = 'Record approvati';
$string['recorddeleted'] = 'Il record è stato eliminato';
$string['recorddisapproved'] = 'Record disapprovato';
$string['recordsnotsaved'] = 'Nessun record è stato salvato. Prima di provare nuovamente, per favore controlla il formato del file usato per il caricamento.';
$string['recordssaved'] = 'record salvati';
$string['removealldatatags'] = 'Rimuovi tutti i tag del database';
$string['requireapproval'] = 'Approvazione dei record inseriti';
$string['requireapproval_help'] = 'I record inseriti devono essere approvati affinché siano visualizzabili dagli altri utenti.';
$string['required'] = 'Obbligatorio';
$string['requiredentries'] = 'Numero minimo di record da inserire (obsoleto)';
$string['requiredentries_help'] = 'Il numero minimo di record che un utente deve obbligatoriamente inserire nel Database per ritenere conclusa l\'attività. Da notare che questa impostazione non è correlata al completamento dell’attività.

Per impostare il numero minimo di record da inserire per completare l\'attività, deve essere utilizzata l\'impostazione \'Record richiesti\'. Per rimuovere del tutto questa impostazione, impostare a zero e salvare.

Si raccomanda di utilizzare l\'impostazione \'Record richiesti\' disponibile nelle impostazioni di completamento attività.';
$string['requiredentriestoview'] = 'Numero minimo di record da inserire per visualizzare';
$string['requiredentriestoview_help'] = 'Il numero minimo di record che l\'utente deve inserire obbligatoriamente prima di poter visualizzare i record di altri utenti.

L\'impostazione non è compatibile con il filtro Collegamento automatico al database.';
$string['requiredentrieswarning'] = 'L\'impostazione è stata sostituita dal criterio di completamento attività "Record  richiesti"';
$string['requiredfield'] = 'Campo obbligatorio';
$string['resetalltemplates'] = 'Resetta tutti i modelli';
$string['resetalltemplatesconfirm'] = 'Si sta per rimuovere tutti i modelli del preset corrente. Qualora in seguito si desideri ripristinare i modelli, sarà necessario selezionar di nuovo il preset nella scheda \'Preset\'.';
$string['resetalltemplatesconfirmtitle'] = 'Resettare tutti i modelli?';
$string['resetsettings'] = 'Reimposta filtri';
$string['resettemplate'] = 'Reimposta il modello corrente';
$string['resettemplateconfirm'] = 'Sarà rimosso definitivamente {$a} dai tuoi preset.';
$string['resettemplateconfirmtitle'] = 'Reimpostare il modello?';
$string['resizingimages'] = 'Ridimensionamento anteprima immagini in corso...';
$string['rows'] = 'righe';
$string['rssglobaldisabled'] = 'Disabilitato. Controlla configurazione delle variabili del sito.';
$string['rsstemplate'] = 'Modello RSS feed';
$string['rsstitletemplate'] = 'Titolo del feed RSS';
$string['rsstype'] = 'RSS di questa attività';
$string['save'] = 'Salva';
$string['saveandadd'] = 'Salva ed inserisci un altro record';
$string['saveandview'] = 'Salva e visualizza il record';
$string['saveaspreset'] = 'Pubblica preset sul sito';
$string['saveaspreset_help'] = 'Consente il salvataggio della struttura di questo database come preset rendendolo disponibile agli utenti del sito, comparendo nell\'elenco dei preset. È possibile eliminare in qualsiasi momento il preset salvato.';
$string['saveaspresetmissingcapability'] = 'L\'utente non è autorizzato a salvare il database come preset';
$string['savedataaspreset'] = 'Salva tutti i campi e modelli e pubblica come preset';
$string['savesettings'] = 'Esegui';
$string['savesuccess'] = 'Preset salvato. <a href="{$a->url}">Anteprima preset</a>';
$string['savetemplate'] = 'Salva il modello';
$string['search'] = 'Cerca';
$string['search:activity'] = 'Database - Informazioni sull\'attività';
$string['search:entry'] = 'Database - record';
$string['searchresults'] = 'Record contenenti "{$a}"';
$string['selectedrequired'] = 'Necessari tutti i selezionati';
$string['selectexportoptions'] = 'Seleziona opzioni di esportazione';
$string['selectfields'] = 'Seleziona campi';
$string['showall'] = 'Visualizza tutti i record';
$string['showmore'] = 'Visualizza altro';
$string['single'] = 'Dettagli';
$string['singletemplate'] = 'Modello visualizzazione Singola';
$string['singleview'] = 'Visualizzazione Singola';
$string['startbuilding'] = 'Inizia a costruire l\'attività';
$string['subplugintype_datafield'] = 'Tipo di campo database';
$string['subplugintype_datafield_plural'] = 'Tipi di campi database';
$string['subplugintype_datapreset'] = 'Preset';
$string['subplugintype_datapreset_plural'] = 'Preset';
$string['tagarea_data_records'] = 'Record';
$string['tags'] = 'Tag';
$string['tagsdeleted'] = 'I tag database sono stati eliminati';
$string['teachersandstudents'] = '{$a->teachers} e {$a->students}';
$string['templatereset'] = 'Reimposta modello';
$string['templateresetall'] = 'Reset di tutti i modelli';
$string['templates'] = 'Modelli';
$string['templatesaved'] = 'Il modello di visualizzazione è stato salvato';
$string['templatesnavigation'] = 'Navigazione terziaria dei modelli';
$string['text'] = 'Testo';
$string['textarea'] = 'Area di testo';
$string['timeadded'] = 'Data/ora inserimento';
$string['timemodified'] = 'Data/ora modifica';
$string['todatabase'] = 'in questo Database';
$string['type'] = 'Tipo di campo';
$string['undefinedprocessactionmethod'] = 'In Data_Preset non vi sono metodi definiti per gestire l\'azione "{$a}".';
$string['unknown'] = 'Campo sconosciuto';
$string['unsupportedfields'] = 'Campi non supportati';
$string['unsupportedfieldslist'] = 'I seguenti campi non possono essere esportati:';
$string['updatefield'] = 'Aggiorna un campo già esistente';
$string['uploadfile'] = 'Carica file';
$string['uploadrecords'] = 'Importa record';
$string['uploadrecords_help'] = 'Consente di Importare le voci esportate da un altro database, tramite CSV o ZIP contenente un file CSV (se i file sono inclusi nell\'esportazione).

In alternativa, per creare un file CSV da importare, aggiungere una voce al database e quindi esportarla. Modificare il file CSV e aggiungere più voci.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Includi nella ricerca.';
$string['usepredefinedset'] = 'Utilizza set predifinto';
$string['usepreset'] = 'Utilizza questo preset';
$string['usestandard'] = 'Utilizza un preset';
$string['usestandard_help'] = 'Consente la scelta di un Modello di visualizzazione preimpostato tra quelli disponibili nel sito. (Se è stato già salvato un Modello di visualizzazione, è possibile anche eliminarlo.)';
$string['viewfromdate'] = 'Solo lettura dal';
$string['viewnavigation'] = 'Navigazione terziaria modalità visualizzazione';
$string['viewtemplates'] = 'Visualizza modelli';
$string['viewtodate'] = 'Fino al';
$string['viewtodatevalidation'] = 'La data di solo lettura \'Fino al\' non può essere antecedente alla data \'Dal\'';
$string['wrongdataid'] = 'È stato fornito un ID errato';
