<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'uk', version '4.3'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Додати плитки';
$string['admintools'] = 'Інструменти адміністратора';
$string['all'] = 'Все';
$string['allcomplete'] = 'Все виконано';
$string['allcoursescomplypalette'] = 'Всі курси вже мають дозволені кольори плитки. Нічого скидати. Переконайтеся, що ви зберегли всі зміни до дозволених кольорів, перш ніж натиснути кнопку Скинути.';
$string['allowphototiles'] = 'Дозволити фотоплитки';
$string['allowphototiles_desc'] = 'Якщо вибрано, викладачі зможуть завантажувати фотографію для використання в якості зображення тла. Вони, як і раніше, зможуть використовувати стандартні значки плитки в одному курсі. (Якщо не вибрано, дозволено лише значки плитки, а інші налаштування фотоплитки будуть проігноровані.)';
$string['allowsubtilesview'] = 'Дозволити вигляд плиток в плитках';
$string['allowsubtilesview_desc'] = 'Дозволить використання налаштувань курсу, які у плитці показуватимуть діяльності (крім написів) як плитки, а не стандартним переліком';
$string['alternativelink'] = 'альтернативне посилання';
$string['asfraction'] = 'Показати як фракцію';
$string['aspectratiotootallorwide'] = 'Завантажене зображення збережено, але перевірте, як це може бути <strong>{$a->tallorwide}</strong>. Якщо це виглядає не правильно, обріжте його на стандартні розміри та завантажте знову. Напр. Ширина 200 x 300 висота підійде.';
$string['aspercentagedial'] = 'Показати як % в колі';
$string['assumedatastoreconsent'] = 'Отримати згоду на локальне сховище браузера';
$string['assumedatastoreconsent_desc'] = 'Якщо буде позначено цей пункт, користувач <b> не </b> матиме діалогового вікно із запитом про згоду зберігати дані в локальному сховищі вебоглядача';
$string['basecolour'] = 'Колір плиток';
$string['basecolour_help'] = 'Колір, встановлений тут, буде застосований до всіх плиток у курсі';
$string['brandcolour'] = 'Колір бренду';
$string['changedcolour'] = 'Колір плитки скинуто до типового в курсі {$a}';
$string['clickiffailstoload'] = 'Натисніть, якщо не вдається завантажити сторінку';
$string['close'] = 'Закрити';
$string['collapse'] = 'Згорнути розділ';
$string['collapsesections'] = 'Згорнути всі розділи';
$string['colourblue'] = 'Блакитний';
$string['colourdarkgreen'] = 'Темний зелений';
$string['colourgreen'] = 'Зелений';
$string['colourlightblue'] = 'Світлий блакитний';
$string['colourname_descr'] = 'Показувати назву кольору (наприклад, "Синій"), який буде використовуватися у спадному меню під час вибору кольору для курсу';
$string['colournamegeneral'] = 'Показувати назву кольору вище';
$string['colourpurple'] = 'Фіолетовий';
$string['colourred'] = 'Червоний';
$string['colours'] = 'Кольори';
$string['complete'] = 'виконано';
$string['complete-n-auto'] = 'Елемент не виконано. Його буде позначено як виконано, якщо ви відповідаєте критеріям виконання. Ви не можете змінити це вручну.';
$string['complete-y-auto'] = 'Елемент виконано. Його було позначено як виконаний, оскільки ви виконали всі критерії виконання. Ви не можете змінити це вручну.';
$string['completion_help'] = 'Галочка праворуч від активності може бути використана для вказівки, коли діяльність завершена (пусте коло буде показано, якщо ні). <br><br> Залежно від налаштування, галочка може з\'явитися автоматично, коли ви завершили роботу відповідно до умов, встановлених викладачем. <br><br> В інших випадках ви можете натиснути порожнє коло, коли ви думаєте, що ви завершили діяльність, і в ньому проставиться зелена галочка. (Повторне натискання видаляє галочку, якщо ви передумали.)';
$string['completionswitchhelp'] = '<p>Ви вибрали показ відстеження завершення на кожній плитці. Тому ми встановили "Відстеження виконання> Увімкнути" на цій сторінці до "Так". </p> <p> Окрім того, вам слід увімкнути відстеження виконання для <b> кожного елемента </b>, який ви відстежуєте. Наприклад, для PDF натисніть кнопку "Редагувати параметри", перегляньте розділ "Виконання діяльностей" та виберіть потрібні налаштування.</p> <p>Ви також можете зробити це в <b> гуртом </b>, як описано в розділі <a href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">докладне пояснення відстеження виконання на moodle.org</a></p>';
$string['completionwarning'] = 'Ви маєте включеним відстеження виконання на рівні курсу, але на рівні окремої діяльності жодне з елементів не має ввімкнено відстеження, тому відстежити нема чого.';
$string['completionwarning_changeinbulk'] = 'Змінити групу';
$string['completionwarning_help'] = 'Необхідно відстежувати окремі елементи, відредагувавши їх (під Виконання діяльностей > відстеження виконання), або зробити це гуртом в Керування курсом > Відстеження виконання > Включити стеження за виконанням';
$string['contact'] = 'Налагодити зв\'язок';
$string['contactdeveloper'] = 'Зверніться до розробника';
$string['contents'] = 'Вміст';
$string['courseshowtileprogress'] = 'Прогрес на кожній плитці';
$string['courseshowtileprogress_error'] = 'Ви маєте встановленим "Відстеження виконання > Включити стеження за виконанням" в "Ні" (див. далі на цій сторінці), що конфліктує з цим налаштуванням. Якщо ви бажаєте показувати прогрес на плитках, встановіть "Відстеження виконання > Включити стеження за виконанням" в "Так". В іншому випадку, установіть це налаштування на "Ні".';
$string['courseshowtileprogress_help'] = '<p>Якщо вибрано цей параметр, прогрес користувача з діяльністю буде показуватися в кожній плитці як <em> фракція </em> (наприклад, "Прогрес 2/10" означає, що 2 з 10 діяльностей завершено), або як <em> відсоток </em> у колі.</p><p>Це може бути використано лише, якщо "Відстеження виконання > Включити стеження за виконанням" включено в "Так".</p><p>Якщо в певній плитці немає діяльностей для відстеження, індикатор не показуватиметься для цієї плитці.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['courseusebarforheadings'] = 'Підкреслюйте заголовки кольоровою вкладкою';
$string['courseusebarforheadings_help'] = 'Показує кольорової вкладки ліворуч від заголовка в курсі, коли в текстовому редакторі вибирається стиль заголовка';
$string['courseusesubtiles'] = 'Використовувати плитки для діяльностей';
$string['courseusesubtiles_help'] = 'У кожній плитці показує кожну дію як плитку, а не як список дій вниз сторінки. Це не стосується написів, які не показуватимуться як плитки, тому їх можна використовувати як заголовки між плитками.';
$string['currentsection'] = 'Цей заголовок';
$string['customcss'] = 'Спеціальний CSS';
$string['customcssdesc'] = 'Спеціальний CSS для застосування до розділу змісту курсу під час використання формату курсу. Це не буде перевірятися, тому будьте уважні, щоб ввести валідний код. Наприклад: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Робота з даними';
$string['datapreferror'] = 'Функція налаштування даних доступна, якщо у вашому браузері є JavaScript. В іншому випадку зберігання даних не можна увімкнути.';
$string['dataprefquestion'] = '<p>Щоб зробити цей сайт простішим у використанні, ми зберігатимемо у вашому браузері функціональну інформацію, наприклад, вміст останньої відкритої плитки. Це залишається на вашому комп\'ютері протягом короткого часу, якщо ви знову відвідаєте цю сторінку. Ми не використовуємо це для відстеження. Чи ви погоджуєтеся на це?</p><p>Ми запам\'ятаємо ваш вибір, доки ви не очистите історію вебперегляду. Вибір варіанту "Ні" може призвести до уповільнення завантаження сторінки.</p>';
$string['defaultthiscourse'] = 'Типове для цього курсу';
$string['defaulttilecolour'] = 'Типовий колір плитки';
$string['defaulttileicon'] = 'Значок плитки';
$string['defaulttileicon_help'] = 'Вибраний тут значок з\'явиться в <em> усіх </em> плитках цього курсу. Індивідуальні плитки можуть мати інші значки, якщо використовувати окремі налаштування на рівні кожної плитки.';
$string['deleteimage'] = 'Видалити картинку';
$string['deletesection'] = 'Видалити плитку';
$string['developedby'] = '"Плитки" створено {$a}';
$string['developer'] = 'Розробник';
$string['disabledbyadmin'] = 'Вимкнуто адміністратором сайту';
$string['displayfilterbar'] = 'Фільтр панелі';
$string['displayfilterbar_error'] = 'Якщо ви не встановили результатів для цього курсу, ви можете показувати лише панель фільтрів на основі номерів плиток, а не на основі результатів. Спочатку створіть деякі результати, а потім поверніться сюди. Див.';
$string['displayfilterbar_help'] = '<p>Якщо буде позначено цей пункт, він автоматично показуватиме масив кнопок перед екраном плитки, які користувачі можуть натискати, щоб фільтрувати плитки до певних діапазонів</p><p>При виборі "на основі номерів плиток" буде показано ряд кнопок, наприклад, кнопка для плиток 1-4, кнопка для плиток 5-8 і т.д.</p><p>Коли вибрано "виходячи з результатів курсу", на результат курсу буде одна кнопка. Кожна плитка може бути призначена для даного результату (і, отже, до даної кнопки) на сторінці налаштувань цієї плитки.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Документ Word';
$string['displaytitle_mod_html'] = 'Вебсторінка';
$string['displaytitle_mod_jpeg'] = 'Картинка';
$string['displaytitle_mod_mp3'] = 'Аудіо';
$string['displaytitle_mod_mp4'] = 'Відео';
$string['displaytitle_mod_ppt'] = 'Презентація Powerpoint';
$string['displaytitle_mod_txt'] = 'Текст';
$string['displaytitle_mod_xls'] = 'Електронна таблиця';
$string['displaytitle_mod_zip'] = 'Zip-архів';
$string['documentation'] = 'Документація';
$string['documentationurl'] = 'URL Документації';
$string['documentationurl_descr'] = 'URL, за яким можна знайти документацію про "Плитки"';
$string['download'] = 'Завантажити';
$string['editsectionname'] = 'Редагувати Заголовок плитки';
$string['embeddedurlerror'] = 'Якщо зовнішній веб-сайт відмовляється підключитися до цього вікна, скористайтеся цим:';
$string['entersection'] = 'Увійти до секції';
$string['existingimage'] = 'Існуюче зображення для цієї плитки';
$string['expand'] = 'Розгорнути';
$string['expandall'] = 'Розгорнути все';
$string['expandsections'] = 'Розкрити всі діяльності (всі секції)';
$string['fileaddedtobottom'] = 'Файл додано до нижньої частини секції';
$string['filenoshowtext'] = 'Якщо файл не показується тут, скористайтеся кнопками праворуч для завантаження або перегляду в новому вікні';
$string['filterboth'] = 'Показувати кнопки на основі номерів плиток і результатів курсу';
$string['filternumbers'] = 'Показувати кнопки на основі номерів плиток';
$string['filteroutcomes'] = 'Показувати кнопки на основі результатів курсу';
$string['filteroutcomesrestore'] = 'Оригінальний курс використовував результати у панелі фільтрів, які ще не підтримуються під час процесу відновлення. Отже, налаштування смуги фільтра було змінено під час відновлення курсу. Якщо ви хочете використовувати результати для фільтрації плиток у відновленому курсі, будь ласка, встановіть результати знову. Початковий курс не змінився.';
$string['fittilestowidth'] = 'Встановіть плитки на ширину екрана';
$string['fittilestowidth_desc'] = 'Якщо позначити цей пункт, коли користувач звертається до курсу на немобільному пристрої, плитки затримуватимуть завантаження на пів секунди, а розрахунок буде зроблено як найкраще. Напр. уникайте однієї плитки в рядку, центральні плитки на екрані. Це відбудеться лише в перший раз, коли вони ввійдуть у курс у певному сеансі, а потім запам\'ятаються для сеансу або поки користувач не налаштує розмір екрану.';
$string['folderdisplayerror'] = 'Теки, призначені для показу вбудованого вмісту, не сумісні з форматом плиток. Ця <a href="{$a}"> Тека</a> була змінена, щоб показуватися на окремій сторінці';
$string['followthemecolour'] = 'Примусово дотримуватися кольору теми';
$string['followthemecolour_desc'] = 'Якщо встановлено так, викладачі не матимуть права вибирати цей модуль, і всі кольори плитки нижче будуть ігноруватися. Замість цього буде зроблена спроба отримати основний колір бренду теми і використовувати його замість цього';
$string['guidance'] = 'Керівництво';
$string['height'] = 'висота';
$string['hidden'] = 'Приховано';
$string['hide'] = 'Приховати';
$string['hidefromothers'] = 'Приховати плитку';
$string['home'] = 'Головна курсу';
$string['icontitle-address-book-o'] = 'Адресна книга';
$string['icontitle-assessment_graded'] = 'Оцінка А+';
$string['icontitle-assessment_timer'] = 'Час оцінювання';
$string['icontitle-asterisk'] = 'Зірочка';
$string['icontitle-award-solid'] = 'Нагорода';
$string['icontitle-balance-scale'] = 'Терези';
$string['icontitle-bar-chart'] = 'Гістограма';
$string['icontitle-bell-o'] = 'Дзвіночок';
$string['icontitle-binoculars'] = 'Бінокль';
$string['icontitle-bitcoin'] = 'Біткоін';
$string['icontitle-book'] = 'Книга';
$string['icontitle-bookmark-o'] = 'Закладка';
$string['icontitle-briefcase'] = 'Портфель';
$string['icontitle-building'] = 'Будівля';
$string['icontitle-bullhorn'] = 'Мегафон';
$string['icontitle-bullseye'] = 'Мішень';
$string['icontitle-calculator'] = 'Калькулятор';
$string['icontitle-calendar'] = 'Календар';
$string['icontitle-calendar-check-o'] = 'Календар з відміткою';
$string['icontitle-check'] = 'Перевірка';
$string['icontitle-child'] = 'Дитина';
$string['icontitle-clock-o'] = 'Годинник';
$string['icontitle-clone'] = 'Дублікат';
$string['icontitle-cloud-download'] = 'Хмара (завантаження)';
$string['icontitle-cloud-upload'] = 'Хмара (відвантаження)';
$string['icontitle-comment-o'] = 'Коментар';
$string['icontitle-comments-o'] = 'Коментарі';
$string['icontitle-compass'] = 'Компас';
$string['icontitle-diamond'] = 'Діамант';
$string['icontitle-dollar'] = 'Доляр';
$string['icontitle-euro'] = 'Евро';
$string['icontitle-exclamation-triangle'] = 'Оклик у трикутнику';
$string['icontitle-feed'] = 'Потік';
$string['icontitle-file-text-o'] = 'Текстовий файл';
$string['icontitle-film'] = 'Фільм';
$string['icontitle-flag-checkered'] = 'Прапорець (фініш)';
$string['icontitle-flag-o'] = 'Прапорець';
$string['icontitle-flash'] = 'Блискавка';
$string['icontitle-flask'] = 'Колба';
$string['icontitle-flipchart'] = 'Фліп-чарт';
$string['icontitle-frown-o'] = 'Похмурий';
$string['icontitle-gavel'] = 'Молоток';
$string['icontitle-gbp'] = 'Британський фунт';
$string['icontitle-globe'] = 'Глобус';
$string['icontitle-handshake-o'] = 'Рукостискання';
$string['icontitle-headphones'] = 'Навушники';
$string['icontitle-heartbeat'] = 'Серцебиття';
$string['icontitle-history'] = 'Годинник історії';
$string['icontitle-home'] = 'Домівка';
$string['icontitle-id-card-o'] = 'Айдікартка';
$string['icontitle-info'] = 'Інформація';
$string['icontitle-jigsaw'] = 'Головоломка';
$string['icontitle-key'] = 'Ключ';
$string['icontitle-laptop'] = 'Ноутбук';
$string['icontitle-life-buoy'] = 'Рятувальний круг';
$string['icontitle-lightbulb-o'] = 'Лямпочка';
$string['icontitle-line-chart'] = 'Лінійна гістограма';
$string['icontitle-list'] = 'Маркований список';
$string['icontitle-list-ol'] = 'Нумерований список';
$string['icontitle-location-arrow'] = 'Локаційна стрілка';
$string['icontitle-map-marker'] = 'Маркер мапи';
$string['icontitle-map-o'] = 'Мапа';
$string['icontitle-map-signs'] = 'Вказівники';
$string['icontitle-microphone'] = 'Мікрофон';
$string['icontitle-mobile-phone'] = 'Мобільник';
$string['icontitle-mortar-board'] = 'Академічна шапка';
$string['icontitle-music'] = 'Музика';
$string['icontitle-newspaper-o'] = 'Газета';
$string['icontitle-number_1'] = 'Номер 1';
$string['icontitle-number_10'] = 'Номер 10';
$string['icontitle-number_2'] = 'Номер 2';
$string['icontitle-number_3'] = 'Номер 3';
$string['icontitle-number_4'] = 'Номер 4';
$string['icontitle-number_5'] = 'Номер 5';
$string['icontitle-number_6'] = 'Номер 6';
$string['icontitle-number_7'] = 'Номер 7';
$string['icontitle-number_8'] = 'Номер 8';
$string['icontitle-number_9'] = 'Номер 9';
$string['icontitle-pencil-square-o'] = 'Олівець в квадраті';
$string['icontitle-person'] = 'Людина';
$string['icontitle-pie-chart'] = 'Кругова діаграма';
$string['icontitle-podcast'] = 'Подкаст';
$string['icontitle-puzzle-piece'] = 'Пазлик';
$string['icontitle-question-circle'] = 'Знак питання в колі';
$string['icontitle-random'] = 'Випадково';
$string['icontitle-refresh'] = 'Повторити';
$string['icontitle-road'] = 'Дорога';
$string['icontitle-search'] = 'Лупа';
$string['icontitle-sliders'] = 'Повзунки';
$string['icontitle-smile-o'] = 'Посмішка';
$string['icontitle-star'] = 'Зірка (затінено)';
$string['icontitle-star-half-o'] = 'Зірка (напівзатінена)';
$string['icontitle-star-o'] = 'Зірочка (без тіні)';
$string['icontitle-survey'] = 'Опитування';
$string['icontitle-tags'] = 'Мітки';
$string['icontitle-tasks'] = 'Задачі';
$string['icontitle-television'] = 'Телебачення';
$string['icontitle-thinking-person'] = 'Людина з лампочкою';
$string['icontitle-thumbs-o-down'] = 'Палець вниз';
$string['icontitle-thumbs-o-up'] = 'Палець вгору';
$string['icontitle-trophy'] = 'Трофей';
$string['icontitle-umbrella'] = 'Парасолька';
$string['icontitle-university'] = 'Університет';
$string['icontitle-user-o'] = 'Людина (без тіні)';
$string['icontitle-users'] = 'Люди';
$string['icontitle-volume-up'] = 'Промовець';
$string['icontitle-wrench'] = 'Гайковий ключ';
$string['imagecannotbeused'] = 'Зображення не можна використовувати';
$string['imagedeletedfrom'] = 'Зображення видалено з "{$a}"';
$string['imagesavedfor'] = 'Зображення збережено до плитки {$a}';
$string['imagesize'] = 'Розмір зображення';
$string['items'] = 'елементів';
$string['jsactivate'] = 'Увімкнено анімовану навігацію';
$string['jsdeactivate'] = 'Вимкнено анімовану навігацію';
$string['jsdeactivated'] = 'Ви вимкнули анімаційну навігацію у своєму обліковому записі';
$string['jsnavsettings'] = 'Налаштування навігації Javascript';
$string['jsreactivated'] = 'У вашому обліковому записі активована анімаційна навігація. Це може бути швидше. Для цього потрібно увімкнути JavaScript.';
$string['links'] = 'Посилання';
$string['loading'] = 'Завантаження';
$string['modalmodules'] = 'Модальні модулі';
$string['modalmodules_desc'] = 'Запускає ці модулі курсу в модальному вікні';
$string['modalresources'] = 'Модальні ресурси';
$string['modalresources_desc'] = 'Запускає ці ресурси в модальному вікні';
$string['modalwindows'] = 'Модальні вікна';
$string['newsectionname'] = 'Нова назва для теми {$a}';
$string['nexttopic'] = 'Наступна тема';
$string['noconnectionerror'] = 'Не вдається завантажити вміст. Перевірте підключення до Інтернету';
$string['nojswarning'] = 'Ваш браузер не підтримує JavaScript або його вимкнено. Розширений інтерфейс доступний, якщо ввімкнути Javascript';
$string['none'] = 'Відсутнє';
$string['notcomplete'] = 'Не завершено';
$string['notrecommended'] = 'Не рекомендовано';
$string['novaliddefaultcolour'] = 'Немає коректного кольору для кольору плитки нижче';
$string['ok'] = 'Гаразд';
$string['other'] = 'Інше';
$string['outcomes'] = 'результатів';
$string['outcomesunavailable'] = 'Результати недоступні';
$string['overall'] = 'Загалом';
$string['overallprogress'] = 'Завершення діяльності - загальний прогрес';
$string['overallprogressshort'] = 'Загальний прогрес';
$string['photoguidance_desc'] = '<p> Завантажте фотографію у  <strong> альбомному </strong> форматі. Ширина повинна бути приблизно в 1,35 рази більше висоти. Напр. Ширина 270 x 200 висота підійде добре. Вам не потрібно бути точним. </p> <p> Фотографії в портретному форматі не збігаються з формою плитки. Великі зображення або файли будуть зменшені та стиснені, якщо необхідно, після завантаження. </p>';
$string['photolibrary'] = 'Фото бібліотека';
$string['photolibrary_desc'] = 'Це фотографії, які ви нещодавно завантажили або використали. Щоб використати їх як тло для цієї плитки, натисніть її. Щоб завантажити нову, скористайтеся вкладкою завантаження вище.';
$string['phototilesaltstyle'] = 'Фотоплитки альтернативний стиль';
$string['phototilesaltstyle_desc'] = 'Якщо не вибрано (типово), то фотоплитки показують назву у верхній частині плитки. Альтернативний стиль показує назву внизу';
$string['phototilesettings'] = 'Фотоплитки';
$string['phototiletitletransarency'] = 'Прозорість назви фотоплитки';
$string['phototiletitletransarency_desc'] = 'Накладення назви на фотографічну плитку може мати злегка прозоре тло (типово 30%) або суцільний колір (0%)';
$string['phototitletitlelineheight'] = 'Висота заголовка';
$string['phototitletitlepadding'] = 'Вертикальний відступ у заголовку';
$string['picknewicon'] = 'Виберіть новий значок';
$string['picknewiconphoto'] = 'Виберіть новий значок або картинку тла';
$string['pluginname'] = 'Формат плитками';
$string['previoustopic'] = 'Попередня тема';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Користувач вимкнув анімаційну навігацію JavaScript.';
$string['privacypolicy'] = 'Політика конфіденційності';
$string['progress'] = 'Прогрес';
$string['reactivate'] = 'реактивувати';
$string['register'] = 'Реєстрація';
$string['registeragreeprivacy'] = 'Я погоджуюся з розробниками модуля {$a->privacypolicylink}';
$string['registerclicktocomplete'] = 'Натисніть Гаразд, щоб завершити процес';
$string['registeredthanks'] = 'Ваш модуль зареєстровано. Дякую.';
$string['registeremailno'] = 'Ні, Я не бажаю отримувати електронні листи';
$string['registeremailyes'] = 'Так, я готовий отримувати сповіщення про оновлення та іншу інформацію про модуль Tiles';
$string['registerintro1'] = 'Ми хотіли б залишатися на зв\'язку! При реєстрації';
$string['registerintro2'] = 'Ви підтримуєте подальший розвиток цього модуля';
$string['registerintro3'] = 'Ви можете швидко дізнатися про важливі оновлення та плани на майбутнє';
$string['registerintro4'] = 'ми можемо дізнатися більше про те, що ви хотіли б отримати в цьому модулі.';
$string['registerintro5'] = 'Ваші дані будуть зберігатися приватними розробниками, як зазначено в політиці конфіденційності, наведеній нижче. Спасибі вам за вашу підтримку!';
$string['registermissingemail'] = 'Заповніть адресу електронної пошти (для наведених нижче листів вибрано "Так")';
$string['registerpickemailpref'] = 'Виберіть налаштування електронної пошти';
$string['registerpolicyagreedlinktext'] = 'Політика конфіденційності та Угода про обробку даних';
$string['registrationdeferred'] = 'Дякую. Ми намагаємося зареєструвати ваш модуль (це ще не завершено).';
$string['reopenlastsection'] = 'Повторно відкрити останні відвідувані плитки';
$string['reopenlastsection_desc'] = 'Якщо це позначено, то після відвідування користувачем курсу, останній розділ, який він відкривав, буде знову відкритий після повернення в курс';
$string['resetallcoursecolours'] = 'Скинути всі кольори курсу';
$string['resetcolours'] = 'Скинути кольори';
$string['resetcolours_desc'] = 'Натисніть цю кнопку, щоб скинути колір плитки для всіх курсів, які не мають одного з кольорів нижче. Курси будуть змінені до типового кольору плитки нижче. Ви можете використовувати це після того, як ви змінили колірну палітру нижче, але переконайтеся, що ви <strong> зберегли будь-які зміни </strong> до кольорів нижче, перш ніж натиснути цю кнопку. Будьте обережні, оскільки це може змінити колір багатьох курсів!';
$string['revealcontents'] = 'Розкрите вміст плитки';
$string['section0name'] = 'Загальне';
$string['sectionerrorstring'] = 'Можливо, термін дії вашого сеансу закінчився. Спробуйте оновити цю сторінку.';
$string['sectionerrortitle'] = 'Помилка завантаження вмісту';
$string['sectionname'] = 'Плитка';
$string['sectionnumber'] = 'Номер Секції / плитки';
$string['selected'] = 'Вибрано';
$string['setavailabletilecolours'] = 'Дозволені кольори плитки (на всьому сайті)';
$string['settings'] = 'Параметри формату плитки';
$string['show'] = 'Показати';
$string['showalltiles'] = 'Показати всі плитки';
$string['showfromothers'] = 'Показати плитку';
$string['showseczerocoursewide'] = 'Показати нульовий розділ над всіма секціями';
$string['showseczerocoursewide_desc'] = 'Якщо буде позначено цей пункт, нульовий розділ (сама верхня частина) показуватиметься на головній сторінці курсу та на початку <b> кожної сторінки розділу курсу </b> (тобто у верхній частині вмісту кожного фрагмента). Якщо не позначено (рекомендовано), воно буде показано лише на головній сторінці курсу';
$string['showseparatewin'] = 'Показати файл у окремому вікні';
$string['sitename'] = 'Назва сайту';
$string['snapwarning'] = 'Можливо, можна редагувати свій курс у форматі Tiles, використовуючи іншу тему, а потім знову перейти до теми прив\'язки після завершення редагування.';
$string['subtileszeczerotoggled'] = 'Верхній розділ перемикається між форматом списку та плиток';
$string['sureresetcolours'] = 'Ви впевнені, що бажаєте скинути типові кольори плитки курсу? Це зачепить {$a} курс(ів)';
$string['tilecolourgeneral'] = 'Колірна палітра - додатковий колір';
$string['tilecolourgeneral_descr'] = 'Необов\'язковий колір, який буде запропоновано користувачам у вигляді кольору плитки у спадному меню в розділі Керування курсом> Редагувати параметри - залиште порожнім, щоб вимкнути цей колір';
$string['tilecolourschanged'] = 'Кольори плиток скинуто. Всі плитки тепер мають кольори, що відповідають кольорам нижче.';
$string['tileicon'] = 'Значок, який показуватиметься лише на цій плитці';
$string['tileicon_help'] = 'Елемент, вибраний тут, буде замінено, тільки для цієї плитки, який би значок плитки не був встановлений на рівні курсу.';
$string['tileicons'] = 'Значки плитки';
$string['tileoutcome'] = 'Підсумок для цієї плитки';
$string['tileoutcome_help'] = 'Якщо ви вибрали підсумок для цієї плитки, ви зможете під час налаштувань курсу показати набір кнопок <em> фільтра </em>, по одному для кожного підсумку, який при натисканні фільтруватиме показані плитки, відповідно до тих результатів, які вони мають показати';
$string['tilesformatregistration'] = 'Реєстрація формату плитки';
$string['togglecompletion'] = 'Натисніть, щоб змінити статус завершення';
$string['tootall'] = 'занадто висока для плитки';
$string['toowide'] = 'занадто широка для плитки';
$string['transparenttitleadjustments'] = 'Прозорі коригування заголовків';
$string['transparenttitleadjustments_desc'] = 'На фотоплитках з прозорим тлом заголовків, залежно від теми, ви можете налаштувати їх, щоб переконатися, що прозорі лінії назви не перекриваються, коли вони обертаються. Зауважте, що вони також дещо відрізняються в різних браузерах. Запропоновані значення для Chrome: на основі тем Boost і Clean: 30,5 і 4 | Adaptable: 32 і 4 | Moove: 32 і 2 | Remui: 32 і 2.5';
$string['uploadnewphoto'] = 'Завантажити нову фотографію';
$string['uploadnewphoto_help'] = 'Завантажте зображення, яке буде використовуватися на цій плитці';
$string['usejavascriptnav'] = 'Скористайтеся навігацією JavaScript з головної сторінки Плиток';
$string['usejavascriptnav_desc'] = 'Якщо позначити цей пункт, то коли користувач натискає плитку на сторінці загального огляду та має javascript, для переходу до вмісту плитки буде використано JS. Вміст плитки буде зберігатися локально в браузері відповідно до інших налаштувань, що подано нижче. Якщо не позначено, JS не буде використано, а замість нього буде використано застарілу навігацію. Інші налаштування JS нижче ігноруватимуться.';
$string['usejseditingexpandcollapse'] = 'Режим редагування - використовуйте JavaScript для розгортання / згортання плиток';
$string['usejseditingexpandcollapse_desc'] = 'Якщо вибрано цей параметр, у режимі редагування викладач може розгорнути та згорнути редагування плиток за допомогою анімованих переходів. Вміст плитки буде завантажено на розширення, без перезавантаження сторінок.';
$string['usejsnavforsinglesection'] = 'Використовуйте навігацію JS для сторінки з однією секцією';
$string['usejsnavforsinglesection_desc'] = 'Якщо позначити цей пункт, будь-який виклик для сторінки з однією секцією (& section = xx) буде оброблено за допомогою javascript, запустивши головну сторінку курсу, анімовану для відкриття в потрібному розділі через JS, замість того, щоб викликати сторінку старого стилю PHP';
$string['usesubtilesseczero'] = 'Використати плитки у верхній секції';
$string['usesubtilesseczero_help'] = 'Якщо вибрано, плитки будуть використовуватися у верхній частині, а також всередині всіх плиток. Проте плитки займають багато місця нагорі курсу. Можливо, краще залишити цей пункт не вибраним, щоб будь-які елементи у верхньому розділі показувалися в стандартному форматі списку.';
$string['width'] = 'ширина';
